/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.zve;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.mapper.SexEnumMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldBean;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldCreator;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldHelper;
import com.varial.personnel.domain.zve.ZveReasonAccount;
import com.varial.personnel.domain.zve.abpfl.ZveAbPfl;
import com.varial.personnel.domain.zve.account.ZveAccount;
import com.varial.personnel.domain.zve.anpfl.ZveAnPfl;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.basictypes.VDate;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;

public class ZveAnnouncementReportDataSource {
    private final Iterator<ZveReasonAccount> mReasonIterator;
    private Iterator<ZveAccount> mAccountIterator;
    private ZveReasonAccount mReasonAccount;
    private ZveAccount mAccount;
    private final AddressFieldCreator mAddressFieldCreator = AddressFieldHelper.getInstance().createAddressFieldCreator();
    private final ProgressBarUpdater mProgressBar;

    public ZveAnnouncementReportDataSource(List<ZveReasonAccount> accounts, ProgressBarUpdater progressBar) {
        this.mReasonIterator = accounts.iterator();
        this.mProgressBar = progressBar;
        this.initNextReasonAccount();
    }

    public boolean next() throws JRException {
        boolean hasNext = this.mAccountIterator.hasNext();
        try {
            if (hasNext) {
                this.mAccount = this.mAccountIterator.next();
            } else if (this.mReasonIterator.hasNext()) {
                this.initNextReasonAccount();
                this.mAccount = this.mAccountIterator.next();
                hasNext = true;
                this.mProgressBar.update();
            }
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        if (!hasNext) {
            this.mReasonAccount = null;
            this.mAccount = null;
        }
        return hasNext;
    }

    private void initNextReasonAccount() {
        this.mReasonAccount = this.mReasonIterator.next();
        this.mAccountIterator = this.mReasonAccount.getAccounts().iterator();
    }

    public Date getDatum() {
        return VDate.getCurrentLocalizedDateAndTime();
    }

    private Master getMaster() throws BusinessDomainException {
        return this.mAccount.getEmployee().getMaster(VDate.getDateMax(), VDate.getDateMax());
    }

    public String getGeschlecht() throws BusinessDomainException {
        return SexEnumMapper.toLongStringMorW((SexEnum)this.getMaster().getSex());
    }

    public PostalAddress getZvkAdresse() {
        return this.mAccount.getRecipient().getActiveRecipientTP().getAddress();
    }

    public String getZvkName() {
        return this.mAccount.getRecipient().getActiveRecipientTP().getLongDescription();
    }

    private CompanySettings getCompSettings() throws BusinessDomainException {
        return this.mAccount.getEmployee().getPCompany().getCompanySettings(VDate.getDateMax(), this.getValidDate());
    }

    private Foundations getFoundations() throws BusinessDomainException {
        if (this.getCompSettings().getPrintPlant()) {
            return this.mAccount.getEmployee().getAppurtenantPlant(VDate.getDateMax(), this.getValidDate()).getPlantFoundations(VDate.getDateMax(), this.getValidDate()).getFoundations();
        }
        return this.mAccount.getEmployee().getPCompany().getCompanyFoundations(VDate.getDateMax(), this.getValidDate()).getFoundations();
    }

    public PostalAddress getAgAdresse() throws BusinessDomainException {
        PlantPlace pp;
        if (this.getCompSettings().getPrintPlant() && (pp = this.mAccount.getEmployee().getEmployment(VDate.getDateMax(), this.getValidDate()).getPlantPlace()) != null) {
            return pp.getCurrentPlantPlaceTP().getAddress();
        }
        return new PostalAddress(this.getFoundations().getPostalAddress());
    }

    public String getAgName() throws BusinessDomainException {
        return this.getFoundations().getLongDescription();
    }

    public ZveAccount getZveAccount() {
        return this.mAccount;
    }

    public ZveAnPfl getZveAnpfl() {
        return this.mAccount.getZveAnPfl();
    }

    public ZveAbPfl getZveAbpfl() {
        return this.mAccount.getZveAbPfl();
    }

    public Object getZveAbschnitt() {
        return this.mAccount.getZveAbschnitt();
    }

    public Object getZveName() {
        return this.mAccount.getZveName();
    }

    public Object getZveAdresse() {
        return this.mAccount.getZveAdresse();
    }

    private Date getValidDate() {
        return VDate.isDateMax((Date)this.mAccount.getValidUntil()) ? this.mAccount.getValidFrom() : this.mAccount.getValidUntil();
    }

    public String getKontonummer() {
        return this.mAccount.getMessage().getKtoNrOrMitgliedsNr();
    }

    public String getVersicherungsNr() {
        return this.mAccount.getMessage().getVersicherungsNr();
    }

    public Date getGeburtsdatum() throws BusinessDomainException {
        Date dateOfBirth = this.mAccount.getMessage().getGeburtsDatum();
        if (dateOfBirth == null) {
            Master master = this.mAccount.getEmployee().getMaster(VDate.getDateMax(), VDate.getDateMax());
            dateOfBirth = master.getDateOfBirth();
        }
        return dateOfBirth;
    }

    public String getGeburtsname() throws BusinessDomainException {
        return this.mAccount.getEmployee().getInsurance(VDate.getDateMax(), VDate.getDateMax()).getNameAtBirth();
    }

    public List<AddressFieldBean> getAddressFieldBeans() {
        return Arrays.asList(this.mAddressFieldCreator.createAddressFieldBean(this.mAccount.getEmployee(), AddressFieldCreator.DocumentType.ZveAnnouncement));
    }

    public String getArchiString() {
        ArchivingMetadata am = new ArchivingMetadata();
        am.setEmployee(this.mReasonAccount.getEmployee(), VDate.getDateMax(), this.getValidDate());
        am.setValidFrom(this.mReasonAccount.getValidFrom());
        Date validUntil = this.mReasonAccount.getValidUntil();
        am.setValidUntil(VDate.isDateMax((Date)validUntil) ? null : validUntil);
        am.setUserID(SessionContext.getInstance().getSession().getUserCode());
        am.setReportName("Meldebescheinigung zur Zusatzversorgung");
        am.setAlwaysPrintValidUntil(true);
        return am.getArchiString();
    }
}

