/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxcertificate.lstbaccountsprint;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.lstb.LStB;
import com.varial.personnel.domain.lstb.TypeOfInstructionEnum;
import com.varial.personnel.domain.lstb.lstbaccount.LStBAccount;
import com.varial.personnel.domain.lstb.lstbwert.LStBWert;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldBean;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldCreator;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldHelper;
import com.varial.personnel.domain.reports.wagetaxcertificate.LStBHelper;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateSubReport;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateSubReportData;
import com.varial.personnel.domain.reports.wagetaxcertificate.from2016.WageTaxCertificatePrintBean;
import com.varial.personnel.domain.reports.wagetaxcertificate.lstbaccountsprint.LStBAccountComparator;
import com.varial.personnel.domain.reports.wagetaxcertificate.lstbaccountsprint.LStBProgressbar;
import com.varial.personnel.domain.reports.wagetaxcertificate.lstbaccountsprint.Step;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class LStBPrintDataSource
implements JRDataSource {
    private static final String NONBREAKING_SPACES = StringUtil.repeat((char)'\u00a0', (int)7);
    private final Iterator<LStBAccount> lStBAccountIterator;
    private final int lStBAccountCount;
    private WageTaxCertificatePrintBean currentBean;
    private final int year;
    private final LStBProgressbar progressBar;
    private final AddressFieldCreator mAddressFieldCreator;
    private final Date mActualDate;

    public LStBPrintDataSource(List<LStBAccount> lStBAccounts, LStBProgressbar progressBar) throws BusinessDomainException {
        this.progressBar = progressBar;
        progressBar.nextStep((Enum)Step.SelectLStBAccounts);
        Date validUntil = lStBAccounts.get(0).getValidUntil();
        this.year = DateHelper.getYear((Date)validUntil) + 1900;
        progressBar.nextStep((Enum)Step.SortLStBAccounts);
        Collections.sort(lStBAccounts, new LStBAccountComparator());
        this.lStBAccountIterator = lStBAccounts.iterator();
        this.lStBAccountCount = lStBAccounts.size();
        this.mActualDate = DateHelper.max((Date)new Date(), (Date)validUntil);
        this.mAddressFieldCreator = AddressFieldHelper.getInstance().createAddressFieldCreator(this.mActualDate);
    }

    public boolean next() throws JRException {
        if (this.lStBAccountIterator.hasNext()) {
            LStBAccount lStBAccount = this.lStBAccountIterator.next();
            this.currentBean = this.createBean(lStBAccount);
            this.progressBar.nextProcessed();
            return true;
        }
        return false;
    }

    private WageTaxCertificatePrintBean createBean(LStBAccount lStBAccount) {
        LStB lStB = lStBAccount.getLStB();
        WageTaxCertificatePrintBean bean = new WageTaxCertificatePrintBean();
        bean.Field_WageTaxCertificateSubReport = this.createWageTaxCertificateSubReport(lStB);
        AddressFieldBean addressFieldBean = this.mAddressFieldCreator.createAddressFieldBean(lStBAccount.getEmployee(), AddressFieldCreator.DocumentType.WageTaxCertificate);
        bean.addressFieldBeans = Arrays.asList(addressFieldBean);
        bean.Field_EmployeeETIN = lStBAccount.getETIN();
        bean.Field_EmployeeIdentNr = lStBAccount.getIdNr();
        bean.pcompanykey = lStBAccount.getPCompany().getPCompanyKey();
        bean.plantkey = "";
        bean.datum = DateMapper.toDDMMYYYYPointSeparationString((Date)lStBAccount.getCreatedOnDate());
        bean.pers_nr = lStB.getPersNr();
        bean.geb_dat = StringMapper.isNullString((String)lStB.getPersMelderechtlichesGeburtsdatum()) ? DateMapper.toDDMMYYYYPointSeparationString((Date)lStB.getPersGeburtsdatum()) : lStB.getPersMelderechtlichesGeburtsdatum();
        bean.dienst_dat_von = DateMapper.toDDMMPointSeparationString((Date)lStBAccount.getValidFrom()) + ".";
        bean.dienst_dat_bis = DateMapper.toDDMMPointSeparationString((Date)lStBAccount.getValidUntil()) + ".";
        bean.u_anz = lStB.getAnzahlU();
        bean.z_2B = lStB.getGrossbuchstaben();
        bean.z_3 = lStB.getBruttoArbLohn();
        bean.z_4 = lStB.getLSteuer();
        bean.z_5 = lStB.getSoli();
        bean.z_6 = lStB.getArbnKiSteuer();
        bean.z_7 = lStB.getEhegKiSteuer();
        bean.z_8 = lStB.getVBez1();
        bean.z_9 = lStB.getErmStVbezMKalenderjahr1();
        bean.z_10 = lStB.getErmStBetrMKalJahr();
        bean.z_11 = lStB.getLSteuerMKalJahr();
        bean.z_12 = lStB.getSoliMKalJahr();
        bean.z_13 = lStB.getKiSteuerArbnMKalJahr();
        bean.z_14 = lStB.getKiSteuerEhegMKalJahr();
        bean.z_15 = lStB.getKurzArbGeld();
        bean.z_15a = lStB.getKurzArbGeldAnteilig();
        bean.z_16A = lStB.getStFreiArbLohnDBA();
        bean.z_16B = lStB.getStFreiArbLohnATE();
        bean.z_17 = lStB.getStFreiArbgLeistg();
        bean.z_18 = lStB.getPauschArbgLeistg();
        bean.z_19 = lStB.getStPflichtArbLohnMKalJahr();
        bean.z_20 = lStB.getStFreiVerpfleg();
        bean.z_21 = lStB.getStFreiDopHaushalt();
        bean.z_22a = lStB.getArbgAnteilRenVers();
        bean.z_22b = lStB.getArbgAnteilBerufsVers();
        bean.z_23a = lStB.getArbnAnteilRenVers();
        bean.z_23b = lStB.getArbnAnteilBerufsVers();
        bean.z_24a = lStB.getStFreiGeKrankVers();
        bean.z_24b = lStB.getStFreiPrKrankVers();
        bean.z_24c = lStB.getStFreiGePflegeVers();
        bean.z_25 = lStB.getArbnAnteilKrankVers();
        bean.z_26 = lStB.getArbnAnteilPflegVers();
        bean.z_27 = lStB.getArbnAnteilArblVers();
        bean.z_28 = lStB.getBeitrPrKrankVers();
        bean.z_29 = lStB.getVBezBMGFreibetrag1();
        bean.z_30 = lStB.getErmStVbezMKalenderjahrJahr1() + NONBREAKING_SPACES;
        bean.z_31 = (String)(lStB.getVBezBeginn1().isEmpty() && lStB.getVBezEnde1().isEmpty() ? "" : lStB.getVBezBeginn1() + " - " + lStB.getVBezEnde1()) + NONBREAKING_SPACES;
        bean.z_32 = lStB.getVBezEinmVersbezug1();
        bean.z_33 = lStB.getAusgezKinderGeld();
        bean.z_34 = lStB.getFreibetragDBATuerkei();
        this.createZusatzbetraege(bean, lStB);
        bean.ag_bez = lStB.getArbgName();
        bean.ag_str_nr = lStB.getArbgAdrStr();
        bean.ag_plz = lStB.getArbgAdrPLZ() + lStB.getArbgAdrAuslandPLZ();
        bean.ag_ort = lStB.getArbgAdrOrt();
        bean.Field_EmployerTaxNumber = lStBAccount.getTaxNumber();
        bean.Field_EmployerStateTag = lStB.getArbgAdrAuslandLaenderkennzeichen().isEmpty() ? "D" : lStB.getArbgAdrAuslandLaenderkennzeichen();
        bean.finanzamt_bez = lStB.getArbgFAName();
        bean.finanzamt_nr = lStB.getArbgFANr();
        bean.Field_Year = lStB.getDauerJahr();
        bean.archi_string = this.getArchiString(lStBAccount);
        bean.transferticket = lStBAccount.getTransferticket();
        bean.stornoKorrektur = LStBPrintDataSource.toString(lStBAccount.getTypeOfInstruction());
        return bean;
    }

    private static String toString(TypeOfInstructionEnum typeOfInstruction) {
        switch (typeOfInstruction.value()) {
            case 2: {
                return "Korrektur";
            }
            case 3: {
                return "Storno";
            }
        }
        return "";
    }

    protected String getArchiString(LStBAccount lStBAccount) {
        ArchivingMetadata am = new ArchivingMetadata();
        am.setCompanyKey(lStBAccount.getPCompany().getPCompanyKey());
        am.setValidFrom(lStBAccount.getValidFrom());
        am.setValidUntil(lStBAccount.getValidUntil());
        am.setName(lStBAccount.getSurname() + ", " + lStBAccount.getFirstname());
        am.setPersonnelNumber(lStBAccount.getEmployee().getPersonnelnumber());
        am.setTaxNumber(lStBAccount.getTaxNumber());
        am.setReportName("Lohnsteuerbescheinigung");
        am.setUserID(SessionContext.getInstance().getSession().getUserCode());
        return am.getArchiString();
    }

    private void createZusatzbetraege(WageTaxCertificatePrintBean bean, LStB lStB) {
        bean.zusatz_text = new ArrayList();
        bean.zusatz_betrag = new ArrayList();
        this.addZusatzzeile(bean, "Kammerbeitrag Bremen", lStB.getKammerbeitragHB());
        this.addZusatzzeile(bean, "Kammerbeitrag Saarland", lStB.getKammerbeitragSL());
        this.addZusatzzeile(bean, "Stpfl. AG-Anteil zur Zusatzversorgung", lStB.getArbgAnteilZusatzVers());
        this.addZusatzzeile(bean, "Stpfl. AN-Anteil zur Zusatzversorgung", lStB.getArbnAnteilZusatzVers());
        this.addZusatzzeile(bean, "steuerfreie Fahrtkosten bei Ausw\u00e4rtst\u00e4tigkeit", lStB.getStFreiFahrtkAusw());
        for (LStBWert lStBWert : lStB.getLStBWerte()) {
            this.addZusatzzeile(bean, lStBWert.getWertName(), lStBWert.getWert());
        }
        while (bean.zusatz_text.size() < 9) {
            bean.zusatz_text.add("");
            bean.zusatz_betrag.add("");
        }
    }

    private void addZusatzzeile(WageTaxCertificatePrintBean bean, String text, BigDecimal betrag) {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)betrag)) {
            bean.zusatz_text.add(text);
            bean.zusatz_betrag.add(LStBHelper.toCurrencyFormatCentEuroSeparated((BigDecimal)betrag));
        }
    }

    private List<WageTaxCertificateSubReportData> createWageTaxCertificateSubReport(LStB lStB) {
        WageTaxCertificateSubReport subReport = new WageTaxCertificateSubReport();
        subReport.add(lStB);
        return subReport.getSubReportList();
    }

    public int getCount() {
        return this.lStBAccountCount;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object value = this.currentBean.getField(jrField.getName());
        if (value instanceof BigDecimal) {
            value = LStBHelper.toCurrencyFormatCentEuroSeparated((BigDecimal)((BigDecimal)value));
        }
        return value;
    }

    public Map<String, Object> getParameters() throws BusinessDomainException {
        return LStBHelper.createParameters((int)this.year, (boolean)false, (boolean)false, (Date)this.mActualDate);
    }

    public int getYear() {
        return this.year;
    }
}

