/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxcertificate;

import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.lstb.LStB;
import com.varial.personnel.domain.lstb.lstbmonat.LStBMonat;
import com.varial.personnel.domain.reports.wagetaxcertificate.LStBHelper;
import com.varial.personnel.domain.reports.wagetaxcertificate.LStBMonate;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateInsuranceSubBean;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateSubReportData;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WageTaxCertificateSubReport {
    protected final List<WageTaxCertificateSubReportData> mSubReportList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mWageTaxClassList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mChildAllowanceList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mFreeAllowanceyYearList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mAddAmountYearList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mChurchTaxEmployeeList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mPhiPniList = new ArrayList<WageTaxCertificateSubReportData>();
    private final List<WageTaxCertificateSubReportData> mBasicPhiPniList = new ArrayList<WageTaxCertificateSubReportData>();

    public void add(List<TaxContainer> taxContainers, List<WageTaxCertificateInsuranceSubBean> insuranceSubBeans, Date employeeBeginDate, Date employeeEndDate, Date validDate, boolean vorjahr, Date listFirstDate, LStBMonate lStBMonate) {
        Date currentMonth = employeeBeginDate;
        int anzahlEintraege = 0;
        while (DateHelper.beforeOrEqual((Date)currentMonth, (Date)employeeEndDate)) {
            WageTaxCertificateInsuranceSubBean insuranceSubBean;
            Date validFrom = DateHelper.getFirstDayOfMonth((Date)currentMonth);
            Date validUntil = DateHelper.getLastDayOfMonth((Date)currentMonth);
            TaxContainer taxContainer = this.getTaxContainer(taxContainers, validFrom = DateHelper.max((Date)validFrom, (Date)employeeBeginDate), validUntil = DateHelper.min((Date)validUntil, (Date)employeeEndDate));
            if (taxContainer != null) {
                this.addToWageTaxClassList(taxContainer, validFrom, validUntil);
                this.addToChildAllowanceList(taxContainer, validFrom, validUntil);
                this.addToFreeAllowanceyYearList(taxContainer, validFrom, validUntil);
                this.addToAddAmountYearList(taxContainer, validFrom, validUntil);
                this.addToChurchTaxEmployeeList(taxContainer, validFrom, validUntil);
            }
            if ((insuranceSubBean = this.getWageTaxCertificateInsuranceSubBean(insuranceSubBeans, validFrom, validUntil)) != null) {
                this.addToPhiPniList(insuranceSubBean, validFrom, validUntil);
                this.addToBasicPhiPniList(insuranceSubBean, validFrom, validUntil);
            }
            if (anzahlEintraege != this.getListeintraege()) {
                lStBMonate.add(taxContainer, insuranceSubBean, currentMonth);
            }
            anzahlEintraege = this.getListeintraege();
            currentMonth = DateHelper.addMonths((Date)currentMonth, (int)1);
        }
        this.mSubReportList.addAll(this.mWageTaxClassList);
        this.mSubReportList.addAll(this.mChildAllowanceList);
        this.mSubReportList.addAll(this.mFreeAllowanceyYearList);
        this.mSubReportList.addAll(this.mAddAmountYearList);
        this.mSubReportList.addAll(this.mChurchTaxEmployeeList);
        this.mSubReportList.addAll(this.mPhiPniList);
        this.mSubReportList.addAll(this.mBasicPhiPniList);
    }

    private TaxContainer getTaxContainer(List<TaxContainer> taxContainers, Date validFrom, Date validUntil) {
        for (TaxContainer taxContainer : taxContainers) {
            if (!DateHelper.beforeOrEqual((Date)validFrom, (Date)taxContainer.validuntil) || !DateHelper.afterOrEqual((Date)validUntil, (Date)taxContainer.validfrom)) continue;
            return taxContainer;
        }
        return null;
    }

    private WageTaxCertificateInsuranceSubBean getWageTaxCertificateInsuranceSubBean(List<WageTaxCertificateInsuranceSubBean> insuranceSubBeans, Date validFrom, Date validUntil) {
        for (WageTaxCertificateInsuranceSubBean insuranceSubBean : insuranceSubBeans) {
            if (!DateHelper.beforeOrEqual((Date)validFrom, (Date)insuranceSubBean.getValidUntil()) || !DateHelper.afterOrEqual((Date)validUntil, (Date)insuranceSubBean.getValidFrom())) continue;
            return insuranceSubBean;
        }
        return null;
    }

    private int getListeintraege() {
        return this.mWageTaxClassList.size() + this.mChildAllowanceList.size() + this.mSubReportList.size() + this.mAddAmountYearList.size() + this.mChurchTaxEmployeeList.size() + this.mPhiPniList.size() + this.mBasicPhiPniList.size();
    }

    public void add(LStB lStB) {
        for (LStBMonat lStBMonat : lStB.getLStBMonate()) {
            this.addToWageTaxClassList(lStBMonat);
            this.addToChildAllowanceList(lStBMonat);
            this.addToFreeAllowanceyYearList(lStBMonat);
            this.addToAddAmountYearList(lStBMonat);
            this.addToChurchTaxEmployeeList(lStBMonat);
            this.addToPhiPniList(lStBMonat);
            this.addToBasicPhiPniList(lStBMonat);
        }
        this.mSubReportList.addAll(this.mWageTaxClassList);
        this.mSubReportList.addAll(this.mChildAllowanceList);
        this.mSubReportList.addAll(this.mFreeAllowanceyYearList);
        this.mSubReportList.addAll(this.mAddAmountYearList);
        this.mSubReportList.addAll(this.mChurchTaxEmployeeList);
        this.mSubReportList.addAll(this.mPhiPniList);
        this.mSubReportList.addAll(this.mBasicPhiPniList);
    }

    public void add(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        this.addToWageTaxClassListFromCarriedForward(eECarriedForwardOfEntry);
        this.addToChildAllowanceListFromCarriedForward(eECarriedForwardOfEntry);
        this.addToFreeAllowanceyYearListFromCarriedForward(eECarriedForwardOfEntry);
        this.addToAddAmountYearListFromCarriedForward(eECarriedForwardOfEntry);
        this.addToChurchTaxEmployeeListFromCarriedForward(eECarriedForwardOfEntry);
    }

    private static void add(List<WageTaxCertificateSubReportData> list, String f_title, String f_value, Object value, Date validFromDate, Date validUntilDate) {
        if (!list.isEmpty()) {
            WageTaxCertificateSubReportData WTCSubReportLast = list.get(list.size() - 1);
            if (!StringMapper.equal((String)WTCSubReportLast.getF_value(), (String)f_value)) {
                list.add(new WageTaxCertificateSubReportData("", f_value, value, validFromDate, validUntilDate));
            } else {
                WTCSubReportLast.setF_validUntil(DateMapper.toDDMMPointEndPointSeparationString((Date)validUntilDate));
                WTCSubReportLast.setValidUntil(validUntilDate);
            }
        } else {
            list.add(new WageTaxCertificateSubReportData(f_title, f_value, value, validFromDate, validUntilDate));
        }
    }

    private static void add(List<WageTaxCertificateSubReportData> list, String f_title, String f_value, Object value, EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        WageTaxCertificateSubReport.add(list, f_title, f_value, value, eECarriedForwardOfEntry.getEmploymentFrom(), eECarriedForwardOfEntry.getEmploymentUntil());
    }

    private void addToWageTaxClassList(LStBMonat lStBMonat) {
        String taxbracket = WageTaxCertificateSubReport.getTaxBracket(lStBMonat.getSteuerklasse(), lStBMonat.getFaktor());
        WageTaxCertificateSubReport.add(this.mWageTaxClassList, "Steuerklasse / Faktor:", taxbracket, taxbracket, lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToWageTaxClassList(TaxContainer taxContainer, Date validFrom, Date validUntil) {
        String taxbracket = WageTaxCertificateSubReport.getTaxBracket(taxContainer.taxbracket, taxContainer.percentagesplit);
        WageTaxCertificateSubReport.add(this.mWageTaxClassList, "Steuerklasse / Faktor:", taxbracket, taxbracket, validFrom, validUntil);
    }

    private void addToWageTaxClassListFromCarriedForward(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        String taxbracket = WageTaxCertificateSubReport.getTaxBracket(eECarriedForwardOfEntry.getTaxBracket(), eECarriedForwardOfEntry.getPercentageSplit());
        WageTaxCertificateSubReport.add(this.mWageTaxClassList, "Steuerklasse / Faktor:", taxbracket, taxbracket, eECarriedForwardOfEntry);
    }

    private static String getTaxBracket(int taxBracket, BigDecimal percentageSplit) {
        Object result = Integer.toString(taxBracket);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)percentageSplit)) {
            result = (String)result + " / " + percentageSplit.toString().replace('.', ',');
        }
        return result;
    }

    private void addToChildAllowanceList(LStBMonat lStBMonat) {
        BigDecimal value = LStBHelper.toScale((int)1, (BigDecimal)lStBMonat.getKinder());
        String childrelief = StringMapper.replaceAllSubString((String)BigDecimalMapper.toString((BigDecimal)value), (String)".", (String)",");
        WageTaxCertificateSubReport.add(this.mChildAllowanceList, "Zahl der Kinderfreibetr\u00e4ge:", childrelief, value, lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToChildAllowanceList(TaxContainer taxContainer, Date validFrom, Date validUntil) {
        BigDecimal value = LStBHelper.toScale((int)1, (BigDecimal)taxContainer.childrelief);
        String childrelief = StringMapper.replaceAllSubString((String)BigDecimalMapper.toString((BigDecimal)value), (String)".", (String)",");
        WageTaxCertificateSubReport.add(this.mChildAllowanceList, "Zahl der Kinderfreibetr\u00e4ge:", childrelief, value, validFrom, validUntil);
    }

    private void addToChildAllowanceListFromCarriedForward(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        BigDecimal value = LStBHelper.toScale((int)1, (BigDecimal)eECarriedForwardOfEntry.getChildRelief());
        String childrelief = StringMapper.replaceAllSubString((String)BigDecimalMapper.toString((BigDecimal)value), (String)".", (String)",");
        WageTaxCertificateSubReport.add(this.mChildAllowanceList, "Zahl der Kinderfreibetr\u00e4ge:", childrelief, value, eECarriedForwardOfEntry);
    }

    private void addToFreeAllowanceyYearList(LStBMonat lStBMonat) {
        WageTaxCertificateSubReport.add(this.mFreeAllowanceyYearList, "Steuerfreier Jahresbetrag:", LStBHelper.toCurrencyFormat((BigDecimal)lStBMonat.getSteuerfreibetragJahr()), lStBMonat.getSteuerfreibetragJahr(), lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToFreeAllowanceyYearList(TaxContainer taxContainer, Date validFrom, Date validUntil) {
        WageTaxCertificateSubReport.add(this.mFreeAllowanceyYearList, "Steuerfreier Jahresbetrag:", LStBHelper.toCurrencyFormat((BigDecimal)taxContainer.freeallowanceyy), taxContainer.freeallowanceyy, validFrom, validUntil);
    }

    private void addToFreeAllowanceyYearListFromCarriedForward(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        WageTaxCertificateSubReport.add(this.mFreeAllowanceyYearList, "Steuerfreier Jahresbetrag:", LStBHelper.toCurrencyFormat((BigDecimal)eECarriedForwardOfEntry.getFreeAllowanceYY()), eECarriedForwardOfEntry.getFreeAllowanceYY(), eECarriedForwardOfEntry);
    }

    private void addToAddAmountYearList(LStBMonat lStBMonat) {
        WageTaxCertificateSubReport.add(this.mAddAmountYearList, "Hinzurechnungsbetrag (Jahresbetrag):", LStBHelper.toCurrencyFormat((BigDecimal)lStBMonat.getHinzurechnungsbetragJahr()), lStBMonat.getHinzurechnungsbetragJahr(), lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToAddAmountYearList(TaxContainer taxContainer, Date validFrom, Date validUntil) {
        WageTaxCertificateSubReport.add(this.mAddAmountYearList, "Hinzurechnungsbetrag (Jahresbetrag):", LStBHelper.toCurrencyFormat((BigDecimal)taxContainer.addamountyy), taxContainer.addamountyy, validFrom, validUntil);
    }

    private void addToAddAmountYearListFromCarriedForward(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        WageTaxCertificateSubReport.add(this.mAddAmountYearList, "Hinzurechnungsbetrag (Jahresbetrag):", LStBHelper.toCurrencyFormat((BigDecimal)eECarriedForwardOfEntry.getAddAmountYY()), eECarriedForwardOfEntry.getAddAmountYY(), eECarriedForwardOfEntry);
    }

    private void addToChurchTaxEmployeeList(LStBMonat lStBMonat) {
        String value = WageTaxCertificateSubReport.getChurchTaxForPrint(lStBMonat.getKiStAbzugKonfession()) + " / " + WageTaxCertificateSubReport.getChurchTaxForPrint(lStBMonat.getKiStAbzugEhegatteKonfession());
        WageTaxCertificateSubReport.add(this.mChurchTaxEmployeeList, "Kirchensteuermerkmale:", value, value, lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToPhiPniList(LStBMonat lStBMonat) {
        WageTaxCertificateSubReport.add(this.mPhiPniList, "Beitr\u00e4ge zur PKV/PPV:", LStBHelper.toCurrencyFormat((BigDecimal)lStBMonat.getBeitragpkvppv()), LStBHelper.toCurrencyFormat((BigDecimal)lStBMonat.getBeitragpkvppv()), lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToBasicPhiPniList(LStBMonat lStBMonat) {
        WageTaxCertificateSubReport.add(this.mBasicPhiPniList, "Beitr\u00e4ge zur Basis-PKV/-PPV:", LStBHelper.toCurrencyFormat((BigDecimal)lStBMonat.getBeitragbasispkvppv()), LStBHelper.toCurrencyFormat((BigDecimal)lStBMonat.getBeitragbasispkvppv()), lStBMonat.getElstamGueltigAb(), null);
    }

    private void addToChurchTaxEmployeeList(TaxContainer taxContainer, Date validFrom, Date validUntil) {
        String value = WageTaxCertificateSubReport.getChurchTaxForPrint(taxContainer.churchtaxee) + " / " + WageTaxCertificateSubReport.getChurchTaxForPrint(taxContainer.churchtaxspouse);
        WageTaxCertificateSubReport.add(this.mChurchTaxEmployeeList, "Kirchensteuermerkmale:", value, value, validFrom, validUntil);
    }

    private void addToPhiPniList(WageTaxCertificateInsuranceSubBean insuranceSubBean, Date validFrom, Date validUntil) {
        BigDecimal value = insuranceSubBean.getBeitragPKV().add(insuranceSubBean.getBeitragPPV());
        WageTaxCertificateSubReport.add(this.mPhiPniList, "Beitr\u00e4ge zur PKV/PPV:", LStBHelper.toCurrencyFormat((BigDecimal)value), value, validFrom, validUntil);
    }

    private void addToBasicPhiPniList(WageTaxCertificateInsuranceSubBean insuranceSubBean, Date validFrom, Date validUntil) {
        BigDecimal value = insuranceSubBean.getBeitragBasisPKV().add(insuranceSubBean.getBeitragBasisPPV());
        WageTaxCertificateSubReport.add(this.mBasicPhiPniList, "Beitr\u00e4ge zur Basis-PKV/-PPV:", LStBHelper.toCurrencyFormat((BigDecimal)value), value, validFrom, validUntil);
    }

    private void addToChurchTaxEmployeeListFromCarriedForward(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        String value = WageTaxCertificateSubReport.getChurchTaxForPrint(eECarriedForwardOfEntry.getTypeOfChurchTaxEmployee().value()) + " / " + WageTaxCertificateSubReport.getChurchTaxForPrint(eECarriedForwardOfEntry.getTypeOfChurchTaxSpouse().value());
        WageTaxCertificateSubReport.add(this.mChurchTaxEmployeeList, "Kirchensteuermerkmale:", value, value, eECarriedForwardOfEntry);
    }

    private static String getChurchTaxForPrint(int churchtax) {
        return churchtax != 0 ? ChurchTaxEnumMapper.valueToString((int)churchtax) : "--";
    }

    private static String getChurchTaxForPrint(String churchtax) {
        return churchtax.isEmpty() ? "--" : churchtax;
    }

    public List<WageTaxCertificateSubReportData> getSubReportList() {
        return this.mSubReportList;
    }
}

