/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxcertificate;

import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.lstb.lstbmonat.LStBMonat;
import com.varial.personnel.domain.reports.wagetaxcertificate.LStBHelper;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateContainerQueries;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateInsuranceSubBean;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LStBMonate {
    protected static final BigDecimal ZERO2 = BigDecimal.valueOf(0L, 2);
    private final List<LStBMonat> lStBMonate = new ArrayList<LStBMonat>();

    public List<LStBMonat> getLStBMonate() {
        return this.lStBMonate;
    }

    public void add(EECarriedForwardOfEntry eeCarriedForwardOfEntry, Date effectiveDate) {
        TaxContainer taxContainer = WageTaxCertificateContainerQueries.queryTaxContainerForCF((String)eeCarriedForwardOfEntry.getEmployee().getObjectid(), (Date)effectiveDate, (Date)eeCarriedForwardOfEntry.getEmploymentUntil());
        LStBMonat lStBMonat = new LStBMonat();
        lStBMonat.setElstamGueltigAb(eeCarriedForwardOfEntry.getEmploymentFrom());
        lStBMonat.setSteuerklasse(this.firstNonZero(eeCarriedForwardOfEntry.getTaxBracket(), taxContainer.taxbracket));
        lStBMonat.setFaktor(LStBHelper.toScale((int)3, (BigDecimal)taxContainer.percentagesplit));
        lStBMonat.setKinder(LStBHelper.toScale((int)1, (BigDecimal)eeCarriedForwardOfEntry.getChildRelief()));
        lStBMonat.setKiStAbzugKonfession(this.firstNonZero(eeCarriedForwardOfEntry.getTypeOfChurchTaxEmployee().value(), taxContainer.churchtaxee));
        lStBMonat.setKiStAbzugEhegatteKonfession(this.firstNonZero(eeCarriedForwardOfEntry.getTypeOfChurchTaxSpouse().value(), taxContainer.churchtaxspouse));
        lStBMonat.setSteuerfreibetragJahr(LStBHelper.toScale2((BigDecimal)this.firstNonZero(eeCarriedForwardOfEntry.getFreeAllowanceYY(), taxContainer.freeallowanceyy)));
        lStBMonat.setSteuerfreibetragMonat(ZERO2);
        lStBMonat.setSteuerfreibetragWoche(ZERO2);
        lStBMonat.setSteuerfreibetragTag(ZERO2);
        lStBMonat.setHinzurechnungsbetragJahr(LStBHelper.toScale2((BigDecimal)this.firstNonZero(eeCarriedForwardOfEntry.getAddAmountYY(), taxContainer.addamountyy)));
        lStBMonat.setHinzurechnungsbetragMonat(ZERO2);
        lStBMonat.setHinzurechnungsbetragWoche(ZERO2);
        lStBMonat.setHinzurechnungsbetragTag(ZERO2);
        lStBMonat.setBeitragpkvppv(ZERO2);
        lStBMonat.setBeitragbasispkvppv(ZERO2);
        this.add(lStBMonat);
    }

    public void add(TaxContainer taxContainer, WageTaxCertificateInsuranceSubBean insuranceSubBean, Date listFirstDate) {
        LStBMonat lStBMonat = new LStBMonat();
        lStBMonat.setElstamGueltigAb(DateHelper.max((Date)taxContainer.validfrom, (Date)listFirstDate));
        lStBMonat.setSteuerklasse(taxContainer.taxbracket);
        lStBMonat.setFaktor(LStBHelper.toScale((int)3, (BigDecimal)taxContainer.percentagesplit));
        lStBMonat.setKinder(LStBHelper.toScale((int)1, (BigDecimal)taxContainer.childrelief));
        lStBMonat.setKiStAbzugKonfession(taxContainer.churchtaxee);
        lStBMonat.setKiStAbzugEhegatteKonfession(taxContainer.churchtaxspouse);
        lStBMonat.setSteuerfreibetragJahr(LStBHelper.toScale2((BigDecimal)taxContainer.freeallowanceyy));
        lStBMonat.setSteuerfreibetragMonat(LStBHelper.toScale2((BigDecimal)taxContainer.freeallowancemm));
        lStBMonat.setSteuerfreibetragWoche(LStBHelper.toScale2((BigDecimal)taxContainer.freeallowanceweekl));
        lStBMonat.setSteuerfreibetragTag(LStBHelper.toScale2((BigDecimal)taxContainer.freeallowancedaily));
        lStBMonat.setHinzurechnungsbetragJahr(LStBHelper.toScale2((BigDecimal)taxContainer.addamountyy));
        lStBMonat.setHinzurechnungsbetragMonat(LStBHelper.toScale2((BigDecimal)taxContainer.addamountmm));
        lStBMonat.setHinzurechnungsbetragWoche(LStBHelper.toScale2((BigDecimal)taxContainer.addamountweekly));
        lStBMonat.setHinzurechnungsbetragTag(LStBHelper.toScale2((BigDecimal)taxContainer.addamountdaily));
        if (insuranceSubBean != null) {
            lStBMonat.setBeitragpkvppv(LStBHelper.toScale2((BigDecimal)insuranceSubBean.getBeitragPKV().add(insuranceSubBean.getBeitragPPV())));
            lStBMonat.setBeitragbasispkvppv(LStBHelper.toScale2((BigDecimal)insuranceSubBean.getBeitragBasisPKV().add(insuranceSubBean.getBeitragBasisPPV())));
        } else {
            lStBMonat.setBeitragpkvppv(ZERO2);
            lStBMonat.setBeitragbasispkvppv(ZERO2);
        }
        this.add(lStBMonat);
    }

    private void add(LStBMonat lStBMonat) {
        lStBMonat.makeReadOnly();
        if (this.lStBMonate.isEmpty()) {
            this.lStBMonate.add(lStBMonat);
            lStBMonat.setLfdNr(this.lStBMonate.size());
        } else {
            LStBMonat last = this.lStBMonate.get(this.lStBMonate.size() - 1);
            if (this.lStBMonate.size() < 12 && !lStBMonat.areValuesEqual(last) && DateHelper.before((Date)last.getElstamGueltigAb(), (Date)lStBMonat.getElstamGueltigAb())) {
                this.lStBMonate.add(lStBMonat);
                lStBMonat.setLfdNr(this.lStBMonate.size());
            } else {
                lStBMonat.remove();
            }
        }
    }

    private int firstNonZero(int a, int b) {
        return a == 0 ? b : a;
    }

    private BigDecimal firstNonZero(BigDecimal a, BigDecimal b) {
        return BigDecimalMapper.isZeroOrNull((BigDecimal)a) ? b : a;
    }
}

