/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wageaccount;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.designation.Designation;
import com.varial.personnel.domain.designationtype.designation.DesignationTP;
import com.varial.personnel.domain.designationtype.designation.TypeOfDesignationEnum;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.UVRiskPeriod;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdbuv.DEUVDbuv;
import com.varial.personnel.domain.deuv.deuvdsfz.DEUVDsfz;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsme;
import com.varial.personnel.domain.deuv.mapper.ReasonOfDeliveryStringMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTP;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTPPersistencyManager;
import com.varial.personnel.domain.employee.mapper.SexEnumMapper;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.employee.tax.mapper.IncomeTaxReturnYYEnumMapper;
import com.varial.personnel.domain.employee.tax.mapper.TaxacationEnumMapper;
import com.varial.personnel.domain.global.community.CommunityPersistencyManager;
import com.varial.personnel.domain.global.community.CommunityTP;
import com.varial.personnel.domain.global.federalstate.FederalStatePersistencyManager;
import com.varial.personnel.domain.global.federalstate.FederalStateTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.occupation.Occupation;
import com.varial.personnel.domain.global.occupation.OccupationTP;
import com.varial.personnel.domain.global.occupationgroup.OccupationGroup;
import com.varial.personnel.domain.global.occupationgroup.OccupationGroupTP;
import com.varial.personnel.domain.global.occupationlong.OccupationLong;
import com.varial.personnel.domain.global.occupationlong.OccupationLongTP;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.state.StatePersistencyManager;
import com.varial.personnel.domain.global.state.StateTP;
import com.varial.personnel.domain.global.taxoffice.TaxOfficePersistencyManager;
import com.varial.personnel.domain.global.taxoffice.TaxOfficeTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.plant.IPlantPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOffice;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.EmployerBean;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.wageaccount.WageAccountAbsenttimeBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountAgePartTimeBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountCFPartClassRiskBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountCFofEntryBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountCFofSystemCOMBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountCFofSystemSIBBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountCFofSystemSIBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountDBUVRiskPeriodsBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountDEUEVBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountEntryBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountNewCalculationBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountPersonnelNumberBean;
import com.varial.personnel.domain.reports.wageaccount.WageAccountValueTypeBean;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.domain.typeofvalue.basictypes.CompressionOnAccountOfMovementEnum;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimePersistencyManager;
import com.varial.personnel.framework.DateComparator;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.personnel.persistency.absenttime.absenttimeall.AbsenttimeallContainer;
import com.varial.personnel.persistency.absenttime.absenttimeall.IAbsenttimeallDao;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.designationtype.entryrsnall.EntryrsnallContainer;
import com.varial.personnel.persistency.designationtype.entryrsnall.IEntryrsnallDao;
import com.varial.personnel.persistency.designationtype.withdrawalrsnall.IWithdrawalrsnallDao;
import com.varial.personnel.persistency.designationtype.withdrawalrsnall.WithdrawalrsnallContainer;
import com.varial.personnel.persistency.employee.cfofentryall.CfofentryallContainer;
import com.varial.personnel.persistency.employee.cfofentryall.ICfofentryallDao;
import com.varial.personnel.persistency.employee.cfofsystemcomall.CfofsystemcomallContainer;
import com.varial.personnel.persistency.employee.cfofsystemcomall.ICfofsystemcomallDao;
import com.varial.personnel.persistency.employee.cfofsystemsiall.CfofsystemsiallContainer;
import com.varial.personnel.persistency.employee.cfofsystemsiall.ICfofsystemsiallDao;
import com.varial.personnel.persistency.employee.cfofsystemsib.CfofsystemsibContainer;
import com.varial.personnel.persistency.employee.cfofsystemsib.ICfofsystemsibDao;
import com.varial.personnel.persistency.employee.cfpartclassrisk.CfpartclassriskContainer;
import com.varial.personnel.persistency.employee.cfpartclassrisk.ICfpartclassriskDao;
import com.varial.personnel.persistency.employee.eeabsenttimeall.EeabsenttimeallContainer;
import com.varial.personnel.persistency.employee.eeabsenttimeall.IEeabsenttimeallDao;
import com.varial.personnel.persistency.employee.eeworkall.EeworkallContainer;
import com.varial.personnel.persistency.employee.eeworkall.IEeworkallDao;
import com.varial.personnel.persistency.employee.employment.EmploymentContainer;
import com.varial.personnel.persistency.employee.employment.IEmploymentDao;
import com.varial.personnel.persistency.employee.insurance.IInsuranceDao;
import com.varial.personnel.persistency.employee.insurance.InsuranceContainer;
import com.varial.personnel.persistency.employee.masterall.IMasterallDao;
import com.varial.personnel.persistency.employee.masterall.MasterallContainer;
import com.varial.personnel.persistency.employee.tax.ITaxDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.global.accidentinsall.AccidentinsallContainer;
import com.varial.personnel.persistency.global.accidentinsall.IAccidentinsallDao;
import com.varial.personnel.persistency.global.parttimemodelall.IParttimemodelallDao;
import com.varial.personnel.persistency.global.parttimemodelall.ParttimemodelallContainer;
import com.varial.personnel.persistency.typeofValue.valuetypesall.IValuetypesallDao;
import com.varial.personnel.persistency.typeofValue.valuetypesall.ValuetypesallContainer;
import com.varial.personnel.persistency.workingTime.workingtimeall.IWorkingtimeallDao;
import com.varial.personnel.persistency.workingTime.workingtimeall.WorkingtimeallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.PutDataException;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang3.StringUtils;

public class WageAccountReportDataSource
implements JRDataSource {
    private static IAbsenttimeallDao daoAbsenttimeall = (IAbsenttimeallDao)UtilitiesManager.getBean((String)"absenttimeallDao", IAbsenttimeallDao.class);
    private static ICalculationbasicDao daoCalculationbasic = (ICalculationbasicDao)UtilitiesManager.getBean((String)"calculationbasicDao", ICalculationbasicDao.class);
    private static IEntryrsnallDao daoEntryrsnall = (IEntryrsnallDao)UtilitiesManager.getBean((String)"entryrsnallDao", IEntryrsnallDao.class);
    private static IWithdrawalrsnallDao daoWithdrawalrsnall = (IWithdrawalrsnallDao)UtilitiesManager.getBean((String)"withdrawalrsnallDao", IWithdrawalrsnallDao.class);
    private static ICfofentryallDao daoCfofentryall = (ICfofentryallDao)UtilitiesManager.getBean((String)"cfofentryallDao", ICfofentryallDao.class);
    private static ICfofsystemcomallDao daoCfofsystemcomall = (ICfofsystemcomallDao)UtilitiesManager.getBean((String)"cfofsystemcomallDao", ICfofsystemcomallDao.class);
    private static ICfofsystemsiallDao daoCfofsystemsiall = (ICfofsystemsiallDao)UtilitiesManager.getBean((String)"cfofsystemsiallDao", ICfofsystemsiallDao.class);
    private static ICfpartclassriskDao daoCfpartclassrisk = (ICfpartclassriskDao)UtilitiesManager.getBean((String)"cfpartclassriskDao", ICfpartclassriskDao.class);
    private static IAccidentinsallDao daoAccidentinsall = (IAccidentinsallDao)UtilitiesManager.getBean((String)"accidentinsallDao", IAccidentinsallDao.class);
    private static ICfofsystemsibDao daoCfofsystemsib = (ICfofsystemsibDao)UtilitiesManager.getBean((String)"cfofsystemsibDao", ICfofsystemsibDao.class);
    private static IEeabsenttimeallDao daoEeabsenttimeall = (IEeabsenttimeallDao)UtilitiesManager.getBean((String)"eeabsenttimeallDao", IEeabsenttimeallDao.class);
    private static IEeworkallDao daoEeworkall = (IEeworkallDao)UtilitiesManager.getBean((String)"eeworkallDao", IEeworkallDao.class);
    private static IEmploymentDao daoEmployment = (IEmploymentDao)UtilitiesManager.getBean((String)"employmentDao", IEmploymentDao.class);
    private static IInsuranceDao daoInsurance = (IInsuranceDao)UtilitiesManager.getBean((String)"insuranceDao", IInsuranceDao.class);
    private static IParttimemodelallDao daoParttimemodelall = (IParttimemodelallDao)UtilitiesManager.getBean((String)"parttimemodelallDao", IParttimemodelallDao.class);
    private static IMasterallDao daoMasterall = (IMasterallDao)UtilitiesManager.getBean((String)"masterallDao", IMasterallDao.class);
    private static ITaxDao daoTax = (ITaxDao)UtilitiesManager.getBean((String)"taxDao", ITaxDao.class);
    private static IValuepositionDao daoValueposition = (IValuepositionDao)UtilitiesManager.getBean((String)"valuepositionDao", IValuepositionDao.class);
    private static IValuetypesallDao daoValuetypesall = (IValuetypesallDao)UtilitiesManager.getBean((String)"valuetypesallDao", IValuetypesallDao.class);
    private static IWorkingtimeallDao daoWorkingtimeall = (IWorkingtimeallDao)UtilitiesManager.getBean((String)"workingtimeallDao", IWorkingtimeallDao.class);
    private static IPlantPersistencyManager plantPersistencyManager = (IPlantPersistencyManager)UtilitiesManager.getBean((String)"plantPersistencyManager", IPlantPersistencyManager.class);
    private static Date MAX_DATE = VDate.getDateMax();
    private final Map<String, CostCenter> mCostCenterMap = new HashMap<String, CostCenter>();
    private final Map<Key, DesignationTP> mEmployeeCircleHashMap = new HashMap<Key, DesignationTP>();
    private final Map<Key, OccupationGroupTP> mOccGroupHashMap = new HashMap<Key, OccupationGroupTP>();
    private final Map<Key, OccupationTP> mOccupationHashMap = new HashMap<Key, OccupationTP>();
    private final Map<Key, OccupationLongTP> mOccupationLongHashMap = new HashMap<Key, OccupationLongTP>();
    private final Map<String, Map<Date, CalculationbasicContainer>> mCalculationbasicHashMap = new HashMap<String, Map<Date, CalculationbasicContainer>>();
    private Map<Date, CalculationbasicContainer> mCBHashMap = new HashMap<Date, CalculationbasicContainer>();
    private final Map<String, DesignationTP> mValueTypeGroupTPMap = new HashMap<String, DesignationTP>();
    private Iterator<String[]> mVPIterator;
    private Iterator<Date> mCBIterator;
    private List<Date> mCBList;
    private List<String[]> mDataList;
    private List<String[]> mDataListOld;
    private List<String[]> mDataListNew;
    private final List<String> mErrorList = new ArrayList<String>();
    private final List<String> mResultList = new ArrayList<String>();
    private final String[] mResult;
    private MasterallContainer mMasterallContainer;
    private String FIELD_AG_NAME;
    private String FIELD_BETRIEBSSTAETTE;
    private String FIELD_PERSONAL_NR;
    private String FIELD_AN_NAME;
    private String FIELD_AN_VORNAME;
    private String FIELD_GEBURTSDATUM;
    private String FIELD_VERSICH_NR;
    private String FIELD_AN_TITEL;
    private String FIELD_AN_STRASSE;
    private String FIELD_AN_ORT;
    private String FIELD_AN_ANREDE;
    private String FIELD_AN_WOHNHAFT;
    private String FIELD_MITARBEITERKREIS;
    private String FIELD_NAMENSZUSATZ;
    private String FIELD_VORSATZWORT;
    private String FIELD_GEBURTSORT;
    private String FIELD_FAMILIENSTAND;
    private String FIELD_AN_HAUSNUMMER;
    private String FIELD_GEBURTSNAME;
    private String FIELD_LAENDERKENNZEICHEN;
    private String FIELD_AN_PLZ;
    private String FIELD_GEBURTS_VORSATZWORT;
    private String FIELD_GEBURTS_NAMENSZUSATZ;
    private String FIELD_GESCHLECHT;
    private String FIELD_SV_AUSWEIS;
    private String FIELD_TEXT_TS_1;
    private String FIELD_TEXT_TS_2;
    private String FIELD_TEXT_TS_3;
    private String FIELD_TEXT_TS_4;
    private String FIELD_TEXT_TS_5;
    private String FIELD_WERT_TS_1;
    private String FIELD_WERT_TS_2;
    private String FIELD_WERT_TS_3;
    private String FIELD_WERT_TS_4;
    private String FIELD_WERT_TS_5;
    private String FIELD_STAATSANGEHOERIGKEIT;
    private String FIELD_BESCHAEFTIGUNGSORT;
    private String FIELD_BUNDESLAND;
    private String FIELD_EU_VERSICH_NR;
    private String FIELD_EU_GEBURTSLAND;
    private String FIELD_FINANZAMTS_NR;
    private String FIELD_FINANZAMTS_BEZ;
    private String FIELD_AGS;
    private String FIELD_GEMEINDE;
    private String FIELD_DBA_FINANZAMTS_NR;
    private String FIELD_DBA_FINANZAMTS_BEZ;
    private String FIELD_DBA_DATUM_DER_BESCHEINIGUNG;
    private String FIELD_DBA_GILT_VOM;
    private String FIELD_DBA_GILT_BIS;
    private String FIELD_JAHR;
    private final String FIELD_BENUTZERNAME;
    private final String FIELD_AKTUELLESDATUM;
    private String FIELD_JOURNALISIERT_BIS;
    private String FIELD_ETIN;
    private String FIELD_STEUERID;
    private Collection<WageAccountPersonnelNumberBean> FIELD_PERSONNELNUMBERDATAS;
    private Collection<WageAccountNewCalculationBean> FIELD_NEWCALCULATIONDATAS;
    private Collection<WageAccountCFofEntryBean> FIELD_CFOFENTRYDATAS;
    private Collection<WageAccountCFofSystemSIBean> FIELD_CFOFSYSTEMSIDATAS;
    private Collection<WageAccountCFofSystemSIBBean> FIELD_CFOFSYSTEMSIBDATAS;
    private Collection<WageAccountCFofSystemCOMBean> FIELD_CFOFSYSTEMCOMDATAS;
    private Collection<WageAccountEntryBean> FIELD_ENTRYDATAS;
    private Collection<WageAccountAbsenttimeBean> FIELD_ABSENTTIMEDATAS;
    private Collection<WageAccountDEUEVBean> FIELD_DEUEVDATAS;
    private Collection<WageAccountAgePartTimeBean> FIELD_AGEPARTTIMEDATAS;
    private String FIELD_DETAIL1;
    private String FIELD_DETAIL2;
    private String FIELD_DETAIL3;
    private String FIELD_DETAIL4;
    private String FIELD_DETAIL5;
    private String FIELD_DETAIL6;
    private String FIELD_DETAIL7;
    private String FIELD_DETAIL8;
    private String FIELD_DETAIL9;
    private String FIELD_DETAIL10;
    private String FIELD_DETAIL11;
    private String FIELD_DETAIL12;
    private String FIELD_DETAIL13;
    private String FIELD_DETAIL0;
    private Boolean FIELD_BEZ_BOLD;
    private Boolean FIELD_BEZ_NORMAL;
    private Boolean FIELD_BALKEN = Boolean.TRUE;
    private Boolean FIELD_DBA = Boolean.FALSE;
    private String FIELD_SICHT;
    private final String FIELD_VERSION;
    private String FIELD_WAID;
    private String FIELD_ZUSATZ1;
    private String FIELD_ZUSATZ2;
    private String FIELD_ALTE_PERSONALNUMMER;
    private String FIELD_ALTE_PERSONALNUMMER_BIS;
    private String FIELD_BETRIEBSNR_KRK;
    private String FIELD_NAME_KRK;
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private final Date mForYearFrom;
    private final Date mCalculationStart;
    private Date mBeginOfEmployment;
    private Date mEndOfEmployment;
    private Date mJournalizeduntil;
    private final Language mLanguage;
    private final String mOidPCompany;
    private String[] mOidValueTypes;
    private boolean next = true;
    private boolean begin = true;
    private boolean mReturnCalculation = false;
    private final boolean mWithTransactionValues;
    private final boolean mWithReturnCalculation;
    private final boolean mInternalUse;
    private boolean mHasDatas = true;
    private boolean mBL_Bremen_Saarland = false;
    private boolean mVersorgungsbezug = false;
    private boolean mPrivatFreiwilligKVPV = false;
    private boolean mKVDR = false;
    private boolean mVersorgung = false;
    private boolean mGleitzone = false;
    private EmployerBean mEmployerBean;
    private int mPersonnelNumber;
    private int mRCNumber = 0;
    private int i = 1;
    private int nextOid = 0;
    private final boolean mUsePaidPublicHoliday = false;
    private final ProgressBarUpdater mProgressBar;

    public WageAccountReportDataSource(ReportFileStructCallback callback, ISpecialAccessPersistencyContext specialAccessPersistencyContext, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, boolean withTransactionValues, boolean withReturnCalculation, boolean internalUse, Date forEffectiveDate, Date forValidDate, List<String> errorList) throws BusinessDomainException {
        String[] messages;
        this.mProgressBar = new ProgressBarUpdater(callback, 1, 2, "Initialisierung");
        try {
            this.mProgressBar.show();
        }
        catch (PutDataException e) {
            e.printStackTrace();
        }
        EmployeeForReportGenerator generator = new EmployeeForReportGenerator(specialAccessPersistencyContext, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, DateHelper.getFirstDayOfMonth((Date)forValidDate), DateHelper.getLastDayOfMonth((Date)forValidDate), errorList);
        EmployeeForReport[] efrs = generator.getEmployeesForReport();
        if (!errorList.isEmpty()) {
            messages = errorList.toArray(new String[errorList.size()]);
            BusinessDomainException de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport((String[])messages);
            errorList.clear();
            callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
        }
        this.mForEffectiveDate = forEffectiveDate == null ? efrs[0].getEmploymentEffectiveUntil() : DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = forValidDate == null ? efrs[0].getEmploymentValidUntil() : DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mForYearFrom = DateHelper.getFirstDayOfYear((Date)this.mForValidDate);
        this.mOidPCompany = efrs[0].getOidPCompany();
        this.mLanguage = PCompanyPersistencyManager.getPCompany((String)this.mOidPCompany).getCompany().getDefaultLanguage();
        this.mCalculationStart = PCompanyPersistencyManager.getPCompany((String)this.mOidPCompany).getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate).getCalculationStart();
        this.mWithReturnCalculation = withReturnCalculation;
        this.mWithTransactionValues = withTransactionValues;
        this.mInternalUse = internalUse;
        for (String string : efrs) {
            if (DateHelper.before((Date)string.getJournalizeduntil(), (Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate)) && !this.mInternalUse) {
                this.mErrorList.add(string.getPersonnelNumberForPrint() + " " + string.getSurname() + ", " + string.getFirstname());
                continue;
            }
            if (string.getDateOfWithDrawal() != null && !DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate), (Date)string.getDateOfWithDrawal()) && !this.hatDifferenzNachAustritt(this.mForValidDate, string.getOidEmployee())) continue;
            this.mResultList.add(string.getOidEmployee());
        }
        this.mResult = new String[this.mResultList.size()];
        this.mResultList.toArray(this.mResult);
        if (!this.mErrorList.isEmpty()) {
            messages = this.mErrorList.toArray(new String[this.mErrorList.size()]);
            BusinessDomainException de = ReportExceptionMapper.makeThisEmployeesAreJournalizedBeforeThisYear((String[])messages);
            callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
        }
        if (this.mResult.length == 0) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        this.FIELD_AKTUELLESDATUM = DateMapper.toString((ILanguage)this.mLanguage, (Date)new Date());
        this.FIELD_BENUTZERNAME = SessionContext.getInstance().getSession().getUserCode();
        this.FIELD_VERSION = Version.getVersion();
        this.FIELD_JAHR = "Jahreslohnkonto " + DateMapper.toString((ILanguage)this.mLanguage, (Date)this.mForValidDate).substring(6, 10);
        if (this.mInternalUse) {
            this.FIELD_JAHR = this.FIELD_JAHR + " interner Gebrauch";
        }
        this.getValueTypeAll();
        this.getCalculationbasics();
        try {
            this.mProgressBar.nextStep("Erzeuge Datei");
            this.mProgressBar.setTotal(this.mResult.length);
        }
        catch (PutDataException e) {
            e.printStackTrace();
        }
    }

    public boolean next() throws JRException {
        try {
            if (!this.begin && !this.mVPIterator.hasNext()) {
                this.begin = true;
                this.i = 0;
            }
            this.FIELD_BALKEN = this.FIELD_BALKEN == false;
            if (this.begin || this.i == 0) {
                if (this.begin) {
                    this.next = this.getMasterDatasAll();
                    try {
                        this.mProgressBar.update();
                    }
                    catch (PutDataException e) {
                        e.printStackTrace();
                    }
                }
                this.i = 1;
                this.begin = false;
            }
            if (!this.begin && this.i >= 1 && this.mVPIterator.hasNext()) {
                boolean storno;
                String[] daten = this.mVPIterator.next();
                if (daten[0].equals("Sicht") && !this.mReturnCalculation) {
                    this.FIELD_SICHT = daten[1];
                }
                boolean valueType = (storno = "Storno".equals(daten[1])) && Character.isDigit(daten[15].charAt(daten[15].length() - 1));
                this.FIELD_DETAIL0 = daten[0];
                this.FIELD_DETAIL1 = daten[1];
                this.FIELD_DETAIL2 = !WageAccountReportDataSource.isNullorSpace(daten[2]) && storno && valueType ? "-" + daten[2] : daten[2];
                this.FIELD_DETAIL3 = !WageAccountReportDataSource.isNullorSpace(daten[3]) && storno && valueType ? "-" + daten[3] : daten[3];
                this.FIELD_DETAIL4 = !WageAccountReportDataSource.isNullorSpace(daten[4]) && storno && valueType ? "-" + daten[4] : daten[4];
                this.FIELD_DETAIL5 = !WageAccountReportDataSource.isNullorSpace(daten[5]) && storno && valueType ? "-" + daten[5] : daten[5];
                this.FIELD_DETAIL6 = !WageAccountReportDataSource.isNullorSpace(daten[6]) && storno && valueType ? "-" + daten[6] : daten[6];
                this.FIELD_DETAIL7 = !WageAccountReportDataSource.isNullorSpace(daten[7]) && storno && valueType ? "-" + daten[7] : daten[7];
                this.FIELD_DETAIL8 = !WageAccountReportDataSource.isNullorSpace(daten[8]) && storno && valueType ? "-" + daten[8] : daten[8];
                this.FIELD_DETAIL9 = !WageAccountReportDataSource.isNullorSpace(daten[9]) && storno && valueType ? "-" + daten[9] : daten[9];
                this.FIELD_DETAIL10 = !WageAccountReportDataSource.isNullorSpace(daten[10]) && storno && valueType ? "-" + daten[10] : daten[10];
                this.FIELD_DETAIL11 = !WageAccountReportDataSource.isNullorSpace(daten[11]) && storno && valueType ? "-" + daten[11] : daten[11];
                this.FIELD_DETAIL12 = !WageAccountReportDataSource.isNullorSpace(daten[12]) && storno && valueType ? "-" + daten[12] : daten[12];
                this.FIELD_DETAIL13 = !WageAccountReportDataSource.isNullorSpace(daten[13]) && storno && valueType ? "-" + daten[13] : daten[13];
                this.FIELD_BEZ_BOLD = daten[14].equals("bold");
                this.FIELD_BEZ_NORMAL = this.FIELD_BEZ_BOLD == false;
            }
            ++this.i;
            if (this.i == 50) {
                this.i = 0;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        return this.next;
    }

    private Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "ag_name": {
                return this.FIELD_AG_NAME;
            }
            case "betriebsstaette": {
                return this.FIELD_BETRIEBSSTAETTE;
            }
            case "personal_nr": {
                return this.FIELD_PERSONAL_NR;
            }
            case "an_name": {
                return this.FIELD_AN_NAME;
            }
            case "an_vorname": {
                return this.FIELD_AN_VORNAME;
            }
            case "geburtsdatum": {
                return this.FIELD_GEBURTSDATUM;
            }
            case "tarifbezug": {
                return "";
            }
            case "at_zulage": {
                return "";
            }
            case "sonst_zulage": {
                return "";
            }
            case "vereinb_entgelt": {
                return "";
            }
            case "grundlohnsatz": {
                return "";
            }
            case "an_titel": {
                return this.FIELD_AN_TITEL;
            }
            case "an_strasse": {
                return this.FIELD_AN_STRASSE;
            }
            case "an_ort": {
                return this.FIELD_AN_ORT;
            }
            case "an_anrede": {
                return this.FIELD_AN_ANREDE;
            }
            case "an_wohnhaft": {
                return this.FIELD_AN_WOHNHAFT;
            }
            case "bez_bold": {
                return this.FIELD_BEZ_BOLD;
            }
            case "bez_normal": {
                return this.FIELD_BEZ_NORMAL;
            }
            case "mitarbeiterkreis": {
                return this.FIELD_MITARBEITERKREIS;
            }
            case "namenszusatz": {
                return this.FIELD_NAMENSZUSATZ;
            }
            case "vorsatzwort": {
                return this.FIELD_VORSATZWORT;
            }
            case "geburtsort": {
                return this.FIELD_GEBURTSORT;
            }
            case "familienstand": {
                return this.FIELD_FAMILIENSTAND;
            }
            case "an_hausnummer": {
                return this.FIELD_AN_HAUSNUMMER;
            }
            case "geburtsname": {
                return this.FIELD_GEBURTSNAME;
            }
            case "laenderkennzeichen": {
                return this.FIELD_LAENDERKENNZEICHEN;
            }
            case "an_plz": {
                return this.FIELD_AN_PLZ;
            }
            case "geburts_vorsatzwort": {
                return this.FIELD_GEBURTS_VORSATZWORT;
            }
            case "geburts_namenszusatz": {
                return this.FIELD_GEBURTS_NAMENSZUSATZ;
            }
            case "geschlecht": {
                return this.FIELD_GESCHLECHT;
            }
            case "sv_ausweis": {
                return this.FIELD_SV_AUSWEIS;
            }
            case "wert_ts_1": {
                return this.FIELD_WERT_TS_1;
            }
            case "wert_ts_2": {
                return this.FIELD_WERT_TS_2;
            }
            case "wert_ts_3": {
                return this.FIELD_WERT_TS_3;
            }
            case "wert_ts_4": {
                return this.FIELD_WERT_TS_4;
            }
            case "wert_ts_5": {
                return this.FIELD_WERT_TS_5;
            }
            case "text_ts_1": {
                return this.FIELD_TEXT_TS_1;
            }
            case "text_ts_2": {
                return this.FIELD_TEXT_TS_2;
            }
            case "text_ts_3": {
                return this.FIELD_TEXT_TS_3;
            }
            case "text_ts_4": {
                return this.FIELD_TEXT_TS_4;
            }
            case "text_ts_5": {
                return this.FIELD_TEXT_TS_5;
            }
            case "staatsangehoerigkeit": {
                return this.FIELD_STAATSANGEHOERIGKEIT;
            }
            case "beschaeftigungsort": {
                return this.FIELD_BESCHAEFTIGUNGSORT;
            }
            case "bundesland": {
                return this.FIELD_BUNDESLAND;
            }
            case "eu_versich_nr": {
                return this.FIELD_EU_VERSICH_NR;
            }
            case "eu_geburtsland": {
                return this.FIELD_EU_GEBURTSLAND;
            }
            case "finanzamts_nr": {
                return this.FIELD_FINANZAMTS_NR;
            }
            case "finanzamts_bez": {
                return this.FIELD_FINANZAMTS_BEZ;
            }
            case "ags": {
                return this.FIELD_AGS;
            }
            case "gemeinde": {
                return this.FIELD_GEMEINDE;
            }
            case "dba": {
                return this.FIELD_DBA;
            }
            case "dba_finanzamts_nr": {
                return this.FIELD_DBA_FINANZAMTS_NR;
            }
            case "dba_finanzamts_bez": {
                return this.FIELD_DBA_FINANZAMTS_BEZ;
            }
            case "dba_datum_der_bescheinigung": {
                return this.FIELD_DBA_DATUM_DER_BESCHEINIGUNG;
            }
            case "dba_gilt_vom": {
                return this.FIELD_DBA_GILT_VOM;
            }
            case "dba_gilt_bis": {
                return this.FIELD_DBA_GILT_BIS;
            }
            case "detail1": {
                return this.FIELD_DETAIL1;
            }
            case "detail2": {
                return this.FIELD_DETAIL2;
            }
            case "detail3": {
                return this.FIELD_DETAIL3;
            }
            case "detail4": {
                return this.FIELD_DETAIL4;
            }
            case "detail5": {
                return this.FIELD_DETAIL5;
            }
            case "detail6": {
                return this.FIELD_DETAIL6;
            }
            case "detail7": {
                return this.FIELD_DETAIL7;
            }
            case "detail8": {
                return this.FIELD_DETAIL8;
            }
            case "detail9": {
                return this.FIELD_DETAIL9;
            }
            case "detail10": {
                return this.FIELD_DETAIL10;
            }
            case "detail11": {
                return this.FIELD_DETAIL11;
            }
            case "detail12": {
                return this.FIELD_DETAIL12;
            }
            case "detail13": {
                return this.FIELD_DETAIL13;
            }
            case "detail0": {
                return this.FIELD_DETAIL0;
            }
            case "sicht": {
                return this.FIELD_SICHT;
            }
            case "jahr": {
                return this.FIELD_JAHR;
            }
            case "benutzername": {
                return this.FIELD_BENUTZERNAME;
            }
            case "aktuellesdatum": {
                return this.FIELD_AKTUELLESDATUM;
            }
            case "personnelnumbersdatas": {
                return this.FIELD_PERSONNELNUMBERDATAS;
            }
            case "newcalculationdatas": {
                return this.FIELD_NEWCALCULATIONDATAS;
            }
            case "cfofentrydatas": {
                return this.FIELD_CFOFENTRYDATAS;
            }
            case "cfofsystemsidatas": {
                return this.FIELD_CFOFSYSTEMSIDATAS;
            }
            case "cfofsystemsibdatas": {
                return this.FIELD_CFOFSYSTEMSIBDATAS;
            }
            case "cfofsystemcomdatas": {
                return this.FIELD_CFOFSYSTEMCOMDATAS;
            }
            case "entrydatas": {
                return this.FIELD_ENTRYDATAS;
            }
            case "absenttimedatas": {
                return this.FIELD_ABSENTTIMEDATAS;
            }
            case "deuevdatas": {
                return this.FIELD_DEUEVDATAS;
            }
            case "ageparttimedatas": {
                return this.FIELD_AGEPARTTIMEDATAS;
            }
            case "journalisiert_bis": {
                return this.FIELD_JOURNALISIERT_BIS;
            }
            case "versich_nr": {
                return this.FIELD_VERSICH_NR;
            }
            case "version": {
                return this.FIELD_VERSION;
            }
            case "etin": {
                return this.FIELD_ETIN;
            }
            case "steuerid": {
                return this.FIELD_STEUERID;
            }
            case "waid": {
                return this.FIELD_WAID;
            }
            case "balken": {
                return this.FIELD_BALKEN;
            }
            case "zusatz1": {
                return this.FIELD_ZUSATZ1;
            }
            case "zusatz2": {
                return this.FIELD_ZUSATZ2;
            }
            case "alte_personalnummer": {
                return this.FIELD_ALTE_PERSONALNUMMER;
            }
            case "alte_personalnummer_bis": {
                return this.FIELD_ALTE_PERSONALNUMMER_BIS;
            }
            case "betriebsnr_krk": {
                return this.FIELD_BETRIEBSNR_KRK;
            }
            case "name_krk": {
                return this.FIELD_NAME_KRK;
            }
        }
        return null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.mMasterallContainer != null && this.mHasDatas) {
            String fieldName = field.getName();
            value = this.getFieldValue(fieldName);
            if (fieldName.equals("archi_string")) {
                ArchivingMetadata am = new ArchivingMetadata();
                am.setReportName(WageAccountReportDataSource.getReportName());
                am.setUserID(SessionContext.getInstance().getSession().getUserCode());
                am.setCompanyKey(this.getPCompanyKey());
                am.setValidFrom(DateHelper.getFirstDayOfYear((Date)this.mForValidDate));
                am.setValidUntil(this.getArchivingUntil());
                am.setPersonnelNumber(this.FIELD_PERSONAL_NR);
                am.setName(this.FIELD_AN_NAME + ", " + this.FIELD_AN_VORNAME);
                am.setReportName("Jahreslohnkonto");
                return am.getArchiString();
            }
            if (value instanceof String) {
                value = StringUtil.toJasperString((String)((String)value));
            }
        }
        return value;
    }

    private Date getArchivingUntil() {
        return this.mInternalUse || DateHelper.beforeOrEqual((Date)DateHelper.getLastDayOfYear((Date)this.mForValidDate), (Date)this.mJournalizeduntil) ? DateHelper.getLastDayOfYear((Date)this.mForValidDate) : this.mJournalizeduntil;
    }

    private String getPCompanyKey() {
        return this.getPCompany().getPCompanyKey();
    }

    private static String getReportName() {
        return "Jahreslohnkonto";
    }

    private boolean getMasterDatas() throws BusinessDomainException {
        boolean next = false;
        this.FIELD_ZUSATZ1 = "";
        this.FIELD_ZUSATZ2 = "";
        this.mPrivatFreiwilligKVPV = false;
        this.mBL_Bremen_Saarland = false;
        this.mVersorgungsbezug = false;
        this.mKVDR = false;
        this.mVersorgung = false;
        if (this.mResult != null && this.nextOid < this.mResult.length) {
            String currentOidEmployee = this.mResult[this.nextOid];
            if (this.mReturnCalculation) {
                if (this.mCBIterator != null && this.mCBIterator.hasNext()) {
                    String key2;
                    ++this.mRCNumber;
                    this.mDataList = new ArrayList<String[]>();
                    this.FIELD_WAID = Integer.toString(this.mPersonnelNumber * 1000 + this.mRCNumber);
                    CalculationbasicContainer cbContainer = this.mCBHashMap.get(this.mCBIterator.next());
                    Date validFrom = DateHelper.getFirstDayOfMonth((Date)cbContainer.validfrom);
                    Date validUntil = DateHelper.getLastDayOfMonth((Date)DateHelper.yesterday((Date)cbContainer.effectivefrom));
                    Date effectiveFrom = DateHelper.getFirstDayOfMonth((Date)cbContainer.effectivefrom);
                    this.FIELD_ZUSATZ1 = "Neuberechnung in " + DateMapper.toString((ILanguage)this.mLanguage, (Date)effectiveFrom);
                    this.FIELD_ZUSATZ2 = "f\u00fcr " + DateMapper.toString((ILanguage)this.mLanguage, (Date)validFrom) + " - " + DateMapper.toString((ILanguage)this.mLanguage, (Date)validUntil);
                    this.FIELD_SICHT = DateMapper.toString((ILanguage)this.mLanguage, (Date)effectiveFrom);
                    if (!this.mInternalUse) {
                        validUntil = DateHelper.min((Date)validUntil, (Date)this.mJournalizeduntil);
                    }
                    validFrom = DateHelper.max((Date)validFrom, (Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate));
                    this.mDataListNew = DateHelper.before((Date)(validUntil = DateHelper.min((Date)validUntil, (Date)DateHelper.getLastDayOfYear((Date)this.mForValidDate))), (Date)validFrom) ? new ArrayList<String[]>() : this.createList(effectiveFrom, validFrom, validUntil, currentOidEmployee);
                    this.mDataListOld = DateHelper.before((Date)validUntil, (Date)validFrom) ? new ArrayList<String[]>() : this.createList(DateHelper.yesterday((Date)effectiveFrom), validFrom, validUntil, currentOidEmployee);
                    HashMap<String, String[][]> cbHashMap = new HashMap<String, String[][]>();
                    for (String[] tempNewArray : this.mDataListNew) {
                        key2 = tempNewArray[15];
                        String[] emptyArray = WageAccountReportDataSource.createRow(key2, "");
                        cbHashMap.put(key2, new String[][]{tempNewArray, emptyArray});
                    }
                    for (String[] tempOldArray : this.mDataListOld) {
                        key2 = tempOldArray[15];
                        String[][] tempAllArray = (String[][])cbHashMap.get(key2);
                        if (tempAllArray == null) {
                            String[] emptyArray = WageAccountReportDataSource.createRow(key2, "");
                            cbHashMap.put(key2, new String[][]{emptyArray, tempOldArray});
                            continue;
                        }
                        tempAllArray[1] = tempOldArray;
                    }
                    this.getData(effectiveFrom, validFrom, validUntil, currentOidEmployee);
                    ArrayList dataList = new ArrayList(cbHashMap.keySet());
                    Collections.sort(dataList);
                    for (String key2 : dataList) {
                        boolean use = false;
                        String[][] tempAllArray = (String[][])cbHashMap.get(key2);
                        String[] tempNewArray = tempAllArray[0];
                        String[] tempOldArray = tempAllArray[1];
                        for (int i = 0; i < 15; ++i) {
                            if (StringMapper.compareTo((String)tempNewArray[i], (String)tempOldArray[i]) == 0) continue;
                            use = true;
                            break;
                        }
                        if (use && StringMapper.isNullString((String)tempOldArray[0])) {
                            tempOldArray[0] = tempNewArray[0];
                        }
                        if ("09999B".equals(tempOldArray[15]) || "19999B".equals(tempOldArray[15]) || "29999B".equals(tempOldArray[15]) || "69999B".equals(tempOldArray[15]) || "19999A".equals(tempOldArray[15]) || "69999A".equals(tempOldArray[15])) {
                            this.mDataList.add(tempOldArray);
                            continue;
                        }
                        if (!use) continue;
                        if ("882110".equals(tempNewArray[15])) {
                            tempNewArray[1] = "";
                            String[] emptyArray = WageAccountReportDataSource.createRow(key2, "");
                            this.mDataList.add(emptyArray);
                            this.mDataList.add(tempNewArray);
                            continue;
                        }
                        tempNewArray[0] = "";
                        tempNewArray[1] = "Neu";
                        tempOldArray[1] = "Storno";
                        this.mDataList.add(tempOldArray);
                        this.mDataList.add(tempNewArray);
                    }
                    if (this.mDataList.size() < 11) {
                        this.mDataList = new ArrayList<String[]>();
                    }
                    this.getData(effectiveFrom, validFrom, validUntil, currentOidEmployee);
                    this.mVPIterator = this.mDataList.iterator();
                    if (!this.mCBIterator.hasNext()) {
                        this.mReturnCalculation = false;
                        ++this.nextOid;
                        next = true;
                    } else {
                        next = true;
                    }
                } else {
                    this.mReturnCalculation = false;
                    ++this.nextOid;
                    next = true;
                }
            } else {
                this.mCBList = null;
                this.mCBIterator = null;
                this.mReturnCalculation = false;
                this.mCBHashMap = null;
                this.mRCNumber = 0;
                Date validFrom = DateHelper.getFirstDayOfYear((Date)this.mForValidDate);
                Date validUntil = DateHelper.getLastDayOfYear((Date)this.mForValidDate);
                Date effectiveFrom = DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate);
                Date effectiveUntil = DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate);
                validFrom = DateHelper.max((Date)validFrom, (Date)this.mCalculationStart);
                this.getData(effectiveUntil, validFrom, validUntil, currentOidEmployee);
                if (!this.mInternalUse) {
                    validUntil = DateHelper.min((Date)validUntil, (Date)this.mJournalizeduntil);
                }
                validFrom = DateHelper.max((Date)validFrom, (Date)this.mBeginOfEmployment);
                if (DateHelper.after((Date)this.mEndOfEmployment, (Date)DateHelper.getFirstDayOfYear((Date)validUntil))) {
                    validUntil = DateHelper.min((Date)validUntil, (Date)this.mEndOfEmployment);
                }
                this.mDataList = DateHelper.before((Date)validUntil, (Date)validFrom) ? new ArrayList<String[]>() : this.createList(effectiveFrom, validFrom, validUntil, currentOidEmployee);
                this.mVPIterator = this.mDataList.iterator();
                this.FIELD_WAID = Integer.toString(this.mPersonnelNumber * 1000 + this.mRCNumber);
                if (this.mWithReturnCalculation) {
                    this.mCBHashMap = this.mCalculationbasicHashMap.get(currentOidEmployee);
                }
                if (this.mCBHashMap != null) {
                    this.mCBList = new ArrayList<Date>(this.mCBHashMap.keySet());
                    Collections.sort(this.mCBList, new DateComparator());
                    this.mCBIterator = this.mCBList.iterator();
                    this.mReturnCalculation = true;
                } else {
                    ++this.nextOid;
                }
            }
            this.mHasDatas = this.mVPIterator.hasNext();
            next = true;
        } else {
            next = false;
        }
        return next;
    }

    private boolean getMasterDatasAll() throws BusinessDomainException {
        boolean next = this.getMasterDatas();
        while (next && !this.mHasDatas) {
            next = this.getMasterDatas();
        }
        return next;
    }

    /*
     * WARNING - void declaration
     */
    private void getData(Date effectiveDate, Date validFromDate, Date validUntilDate, String currentOidEmployee) throws BusinessDomainException {
        TaxContainer taxContainer;
        InsuranceContainer insuranceContainer;
        Date validUntilForDeuv = validUntilDate;
        HashMap<Date, Date[]> returnCalculationHashMap = new HashMap<Date, Date[]>();
        ArrayList<WageAccountPersonnelNumberBean> personnelnumberDatas = new ArrayList<WageAccountPersonnelNumberBean>();
        ArrayList<WageAccountNewCalculationBean> newCalculationDatas = new ArrayList<WageAccountNewCalculationBean>();
        ArrayList<WageAccountCFofEntryBean> cFofEntryDatas = new ArrayList<WageAccountCFofEntryBean>();
        ArrayList<WageAccountCFofSystemSIBean> cFofSystemSIDatas = new ArrayList<WageAccountCFofSystemSIBean>();
        ArrayList<WageAccountCFofSystemSIBBean> cFofSystemSIBDatas = new ArrayList<WageAccountCFofSystemSIBBean>();
        ArrayList<WageAccountCFofSystemCOMBean> cFofSystemCOMDatas = new ArrayList<WageAccountCFofSystemCOMBean>();
        ArrayList<WageAccountEntryBean> entryDatas = new ArrayList<WageAccountEntryBean>();
        ArrayList<WageAccountAbsenttimeBean> absenttimeDatas = new ArrayList<WageAccountAbsenttimeBean>();
        ArrayList<WageAccountAgePartTimeBean> agePartTimeDatas = new ArrayList<WageAccountAgePartTimeBean>();
        EmploymentContainer employmentContainer = WageAccountReportDataSource.getEmployment(effectiveDate, validUntilDate, currentOidEmployee);
        this.mEmployerBean = (EmployerBean)UtilitiesManager.getBean((String)"employerBean", EmployerBean.class);
        this.mEmployerBean.setOidPCompany(this.mOidPCompany);
        this.mEmployerBean.setEffectiveDate(effectiveDate);
        this.mEmployerBean.setValidDate(validUntilDate);
        this.mEmployerBean.setOidEmployee(currentOidEmployee);
        this.mEmployerBean.setOidPlant(employmentContainer != null ? employmentContainer.oidplant : "");
        this.mEmployerBean.createEmployerBean();
        if (employmentContainer != null) {
            if (PDateHelper.between((Date)employmentContainer.dateofwithdrawal, (Date)validFromDate, (Date)validUntilDate)) {
                validUntilForDeuv = MAX_DATE;
            }
            if (!StringMapper.isNullString((String)employmentContainer.oidplant)) {
                this.FIELD_BETRIEBSSTAETTE = this.mEmployerBean.getPlantCode() + " " + this.mEmployerBean.getPlantShortDescription();
                this.FIELD_BESCHAEFTIGUNGSORT = this.mEmployerBean.getPlantCity();
            } else {
                this.FIELD_BETRIEBSSTAETTE = "";
                this.FIELD_BESCHAEFTIGUNGSORT = "";
            }
            if (!StringMapper.isNullString((String)employmentContainer.oidemployeecircle)) {
                DesignationTP employeeCircle = this.getEmployeeCircle(employmentContainer.oidemployeecircle, effectiveDate, validUntilDate);
                this.FIELD_MITARBEITERKREIS = employeeCircle.getDesignation().getDesignation() + " " + employeeCircle.getShortDescription();
            } else {
                this.FIELD_MITARBEITERKREIS = "";
            }
            this.mBeginOfEmployment = WageAccountReportDataSource.getDateOfEntry(effectiveDate, validUntilDate, currentOidEmployee);
            this.mEndOfEmployment = employmentContainer.dateofwithdrawal == null ? validUntilDate : employmentContainer.dateofwithdrawal;
            Date date = validFromDate = DateHelper.between((Date)this.mBeginOfEmployment, (Date)validFromDate, (Date)validUntilDate) ? this.mBeginOfEmployment : validFromDate;
            if (DateHelper.after((Date)this.mEndOfEmployment, (Date)DateHelper.getFirstDayOfYear((Date)validUntilDate))) {
                validUntilDate = DateHelper.min((Date)validUntilDate, (Date)this.mEndOfEmployment);
            }
            this.FIELD_BUNDESLAND = DateHelper.afterOrEqual((Date)validUntilDate, (Date)new VDate(2026, 0, 1).getDate()) ? (!StringMapper.isNullString((String)employmentContainer.oidplant) ? this.mEmployerBean.getPlantFederalstateLongdescription() : this.mEmployerBean.getCompanyFederalstateLongdescription()) : (!StringMapper.isNullString((String)employmentContainer.oidplant) ? this.mEmployerBean.getPlantFederalstateLongdescription() + " / " + this.mEmployerBean.getPlantLawareaLong() : this.mEmployerBean.getCompanyFederalstateLongdescription() + " / " + this.mEmployerBean.getCompanyLawareaLong());
        }
        this.mMasterallContainer = WageAccountReportDataSource.getMasterall(effectiveDate, validUntilDate, currentOidEmployee);
        if (this.mMasterallContainer != null) {
            this.mJournalizeduntil = this.mMasterallContainer.journalizeduntil;
            this.FIELD_JOURNALISIERT_BIS = DateMapper.toString((ILanguage)this.mLanguage, (Date)this.mJournalizeduntil);
            if (this.mInternalUse) {
                this.mJournalizeduntil = DateHelper.getLastDayOfYear((Date)validUntilDate);
            }
            if (DateHelper.beforeOrEqual((Date)this.mBeginOfEmployment, (Date)this.mJournalizeduntil)) {
                validUntilDate = DateHelper.before((Date)DateHelper.getFirstDayOfYear((Date)validUntilDate), (Date)this.mJournalizeduntil) ? DateHelper.min((Date)validUntilDate, (Date)this.mJournalizeduntil) : DateHelper.getFirstDayOfYear((Date)validUntilDate);
            }
            if (!StringMapper.isNullString((String)this.mMasterallContainer.oidpcompany)) {
                this.FIELD_AG_NAME = this.mEmployerBean.getCompanyCode() + " / " + this.mEmployerBean.getCompanyShortDescription();
                if (StringMapper.isNullString((String)this.FIELD_BESCHAEFTIGUNGSORT)) {
                    this.FIELD_BESCHAEFTIGUNGSORT = this.mEmployerBean.getCompanyCity();
                }
            } else {
                this.FIELD_AG_NAME = "";
            }
            this.FIELD_PERSONAL_NR = Integer.toString(this.mMasterallContainer.personnelnumber);
            this.mPersonnelNumber = this.mMasterallContainer.personnelnumber;
            this.FIELD_GEBURTSDATUM = DateMapper.toString((ILanguage)this.mLanguage, (Date)this.mMasterallContainer.dateofbirth);
            this.FIELD_AN_NAME = this.mMasterallContainer.surname;
            this.FIELD_AN_VORNAME = this.mMasterallContainer.firstname;
            this.FIELD_AN_TITEL = this.mMasterallContainer.title;
            this.FIELD_AN_STRASSE = this.mMasterallContainer.street;
            if (this.FIELD_BUNDESLAND == null) {
                this.FIELD_BUNDESLAND = this.mEmployerBean.getCompanyFederalstateLongdescription();
                this.FIELD_BUNDESLAND = this.FIELD_BUNDESLAND + " / " + this.mEmployerBean.getCompanyLawareaLong();
            }
            this.FIELD_AN_ORT = this.mMasterallContainer.domicile;
            this.FIELD_AN_ANREDE = this.mMasterallContainer.formofaddress;
            this.FIELD_ETIN = this.mMasterallContainer.etinnumber;
            this.FIELD_NAMENSZUSATZ = this.mMasterallContainer.nameprefix;
            this.FIELD_VORSATZWORT = this.mMasterallContainer.nameaffix;
            this.FIELD_FAMILIENSTAND = this.mMasterallContainer.civilstatus == 0 ? "ledig" : "verheiratet";
            this.FIELD_AN_HAUSNUMMER = this.mMasterallContainer.streetnumber;
            this.FIELD_AN_PLZ = this.mMasterallContainer.postalcode;
            this.FIELD_AN_WOHNHAFT = this.mMasterallContainer.addressaddendum;
            this.FIELD_LAENDERKENNZEICHEN = StringMapper.isNullString((String)this.mMasterallContainer.oidstate) ? "" : WageAccountReportDataSource.getStateTP(this.mMasterallContainer.oidstate, effectiveDate, validUntilDate).getStateTag();
            this.FIELD_GESCHLECHT = SexEnumMapper.toLongString((SexEnum)SexEnumMapper.toSexEnum((int)this.mMasterallContainer.sex));
        }
        if ((insuranceContainer = WageAccountReportDataSource.getInsurance(effectiveDate, validUntilDate, currentOidEmployee)) != null) {
            StateTP stateTP;
            this.FIELD_VERSICH_NR = insuranceContainer.insuranceno;
            this.FIELD_GEBURTS_VORSATZWORT = insuranceContainer.nameaffixatbirth;
            this.FIELD_GEBURTS_NAMENSZUSATZ = insuranceContainer.nameprefixatbirth;
            this.FIELD_GEBURTSNAME = insuranceContainer.nameatbirth;
            this.FIELD_GEBURTSORT = insuranceContainer.placeofbirth;
            this.FIELD_EU_VERSICH_NR = insuranceContainer.euinsuranceno;
            this.FIELD_EU_GEBURTSLAND = "";
            this.FIELD_STAATSANGEHOERIGKEIT = "";
            if (!StringMapper.isNullString((String)insuranceContainer.oidhealthfund)) {
                HealthFundTP healthFundTP = HealthFundPersistencyManager.getHealthFund((String)insuranceContainer.oidhealthfund).getHealthFundTP(effectiveDate, validUntilDate);
                this.FIELD_BETRIEBSNR_KRK = healthFundTP.getStandardCompanyNumber();
                this.FIELD_NAME_KRK = healthFundTP.getShortDescription();
            } else {
                this.FIELD_BETRIEBSNR_KRK = "";
                this.FIELD_NAME_KRK = "";
            }
            if (!StringMapper.isNullString((String)insuranceContainer.oideustateofbirth)) {
                stateTP = WageAccountReportDataSource.getStateTP(insuranceContainer.oideustateofbirth, effectiveDate, validUntilDate);
                this.FIELD_EU_GEBURTSLAND = stateTP.getState().getState() + " " + stateTP.getLongDescription();
            }
            if (!StringMapper.isNullString((String)insuranceContainer.oidnationality)) {
                stateTP = WageAccountReportDataSource.getStateTP(insuranceContainer.oidnationality, effectiveDate, validUntilDate);
                this.FIELD_STAATSANGEHOERIGKEIT = stateTP.getState().getState() + " " + stateTP.getNationality();
            }
            this.FIELD_SV_AUSWEIS = insuranceContainer.siidcard ? "Ja / " + DateMapper.toString((ILanguage)this.mLanguage, (Date)insuranceContainer.registrsiidcard) : "Nein";
            if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2011, 11, 1).getDate())) {
                if (!StringMapper.isNullString((String)insuranceContainer.oidoccupationgroup)) {
                    OccupationGroupTP occupationGroupTP = this.getOccupationGroupTP(insuranceContainer.oidoccupationgroup, effectiveDate, validUntilDate);
                    this.FIELD_TEXT_TS_1 = "Berufsgruppe";
                    this.FIELD_WERT_TS_1 = occupationGroupTP.getOccupationGroup().getAKey();
                    this.FIELD_WERT_TS_1 = this.mMasterallContainer.sex == 1 ? this.FIELD_WERT_TS_1 + " " + occupationGroupTP.getMaleLongDescription() : this.FIELD_WERT_TS_1 + " " + occupationGroupTP.getFemaleLongDescription();
                }
                if (!StringMapper.isNullString((String)insuranceContainer.oidoccupation)) {
                    OccupationTP occupationTP = this.getOccupationTP(insuranceContainer.oidoccupation, effectiveDate, validUntilDate);
                    this.FIELD_TEXT_TS_2 = "T\u00e4tigkeit";
                    this.FIELD_WERT_TS_2 = occupationTP.getOccupation().getAKey();
                    this.FIELD_WERT_TS_2 = this.mMasterallContainer.sex == 1 ? this.FIELD_WERT_TS_2 + " " + occupationTP.getMaleLongDescription() : this.FIELD_WERT_TS_2 + " " + occupationTP.getFemaleLongDescription();
                }
                this.FIELD_TEXT_TS_3 = "Stellung im Beruf";
                this.FIELD_WERT_TS_3 = Integer.toString(insuranceContainer.positionofjob);
                switch (insuranceContainer.positionofjob) {
                    case 0: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Auszubildender";
                        break;
                    }
                    case 1: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Arbeiter";
                        break;
                    }
                    case 2: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Facharbeiter";
                        break;
                    }
                    case 3: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Meister";
                        break;
                    }
                    case 4: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Angestellter";
                        break;
                    }
                    case 5: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Jugendhilfe";
                        break;
                    }
                    case 6: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Rehabilitation";
                        break;
                    }
                    case 7: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Heimarbeiter";
                        break;
                    }
                    case 8: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " unter 18 Wochenstunden";
                        break;
                    }
                    case 9: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Teilzeit \u00fcber 18 WoStd";
                    }
                }
                this.FIELD_TEXT_TS_4 = "Ausbildung";
                this.FIELD_WERT_TS_4 = Integer.toString(insuranceContainer.education);
                switch (insuranceContainer.education) {
                    case 1: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " ohne Berufsausbildung";
                        break;
                    }
                    case 2: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " mit Berufsausbildung";
                        break;
                    }
                    case 3: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " Abitur ohne Berufsausb.";
                        break;
                    }
                    case 4: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " Abitur mit Berufsausb.";
                        break;
                    }
                    case 5: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " Fachhochschule";
                        break;
                    }
                    case 6: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " Hochschule / Uni.";
                        break;
                    }
                    case 7: {
                        this.FIELD_WERT_TS_4 = this.FIELD_WERT_TS_4 + " Ausbildung unbekannt";
                    }
                }
                this.FIELD_TEXT_TS_5 = "";
                this.FIELD_WERT_TS_5 = "";
            } else {
                if (!StringMapper.isNullString((String)insuranceContainer.oidoccupationlong)) {
                    OccupationLongTP occupationLongTP = this.getOccupationLongTP(insuranceContainer.oidoccupationlong, effectiveDate, validUntilDate);
                    this.FIELD_TEXT_TS_1 = "ausge\u00fcbte T\u00e4tigkeit";
                    this.FIELD_WERT_TS_1 = occupationLongTP.getOccupationLong().getOccupationKey();
                    this.FIELD_WERT_TS_1 = this.FIELD_WERT_TS_1 + " " + occupationLongTP.getLongDescription();
                }
                this.FIELD_TEXT_TS_2 = "Schulabschluss";
                this.FIELD_WERT_TS_2 = Integer.toString(insuranceContainer.schoolleaving);
                switch (insuranceContainer.schoolleaving) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.FIELD_WERT_TS_2 = this.FIELD_WERT_TS_2 + " ohne Schulabschluss";
                        break;
                    }
                    case 2: {
                        this.FIELD_WERT_TS_2 = this.FIELD_WERT_TS_2 + " Haupt-/Volksschulabschluss";
                        break;
                    }
                    case 3: {
                        this.FIELD_WERT_TS_2 = this.FIELD_WERT_TS_2 + " Mittlere Reife oder gleichwertiger Abschluss";
                        break;
                    }
                    case 4: {
                        this.FIELD_WERT_TS_2 = this.FIELD_WERT_TS_2 + " Abitur/Fachabitur";
                        break;
                    }
                    case 9: {
                        this.FIELD_WERT_TS_2 = this.FIELD_WERT_TS_2 + " Abschluss unbekannt";
                    }
                }
                this.FIELD_TEXT_TS_3 = "Ausbildungsabschluss";
                this.FIELD_WERT_TS_3 = Integer.toString(insuranceContainer.profeducation);
                switch (insuranceContainer.profeducation) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Ohne beruflichen Ausbildungsabschluss";
                        break;
                    }
                    case 2: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Abschluss einer anerkannten Berufsausbildung";
                        break;
                    }
                    case 3: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Meister/Techniker oder gleichwertiger Fachschulabschluss";
                        break;
                    }
                    case 4: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Bachelor";
                        break;
                    }
                    case 5: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Diplom/Magister/Master/Staatsexamen";
                        break;
                    }
                    case 6: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Promotion";
                        break;
                    }
                    case 9: {
                        this.FIELD_WERT_TS_3 = this.FIELD_WERT_TS_3 + " Abschluss unbekannt";
                    }
                }
                this.FIELD_TEXT_TS_4 = "Arbeitnehmer\u00fcberlassung";
                this.FIELD_WERT_TS_4 = insuranceContainer.manpowerprovision == 2 ? "2 Ja" : "1 Nein";
                this.FIELD_TEXT_TS_5 = "Vertragsform";
                this.FIELD_WERT_TS_5 = Integer.toString(insuranceContainer.typeofcontract);
                switch (insuranceContainer.typeofcontract) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.FIELD_WERT_TS_5 = this.FIELD_WERT_TS_5 + " Vollzeit - unbefristet";
                        break;
                    }
                    case 2: {
                        this.FIELD_WERT_TS_5 = this.FIELD_WERT_TS_5 + " Teilzeit - unbefristet";
                        break;
                    }
                    case 3: {
                        this.FIELD_WERT_TS_5 = this.FIELD_WERT_TS_5 + " Vollzeit - befristet";
                        break;
                    }
                    case 4: {
                        this.FIELD_WERT_TS_5 = this.FIELD_WERT_TS_5 + " Teilzeit - befristet";
                    }
                }
            }
        }
        if ((taxContainer = WageAccountReportDataSource.getTax(effectiveDate, validUntilDate, currentOidEmployee)) != null) {
            TaxOfficeTP taxOfficeTP;
            if (!StringMapper.isNullString((String)taxContainer.oidtaxoffice)) {
                taxOfficeTP = WageAccountReportDataSource.getTaxOfficeTP(taxContainer.oidtaxoffice, effectiveDate, validUntilDate);
                this.FIELD_FINANZAMTS_NR = taxOfficeTP.getTaxOffice().getTaxOffice();
                this.FIELD_FINANZAMTS_BEZ = taxOfficeTP.getLongDescription();
            } else {
                this.FIELD_FINANZAMTS_NR = "";
                this.FIELD_FINANZAMTS_BEZ = "";
            }
            if (!StringMapper.isNullString((String)taxContainer.oidfederalstate)) {
                FederalStateTP federalStateTP = WageAccountReportDataSource.getFederalStateTP(taxContainer.oidfederalstate, effectiveDate, validUntilDate);
                this.FIELD_BUNDESLAND = federalStateTP.getLongDescription() + " / " + federalStateTP.getLawArea();
            }
            if (!StringMapper.isNullString((String)taxContainer.oidcommunity)) {
                CommunityTP communityTP = WageAccountReportDataSource.getCommunityTP(taxContainer.oidcommunity, effectiveDate, validUntilDate);
                this.FIELD_AGS = communityTP.getCommunity().getGeneralCommunityKey();
                this.FIELD_GEMEINDE = communityTP.getLongDescription();
            } else {
                this.FIELD_AGS = "";
                this.FIELD_GEMEINDE = "";
            }
            if (!StringMapper.isNullString((String)taxContainer.oidtaxofdbawouttax)) {
                taxOfficeTP = WageAccountReportDataSource.getTaxOfficeTP(taxContainer.oidtaxofdbawouttax, effectiveDate, validUntilDate);
                this.FIELD_DBA_FINANZAMTS_NR = taxOfficeTP.getTaxOffice().getTaxOffice();
                this.FIELD_DBA_FINANZAMTS_BEZ = taxOfficeTP.getLongDescription();
                this.FIELD_DBA = Boolean.TRUE;
            } else {
                this.FIELD_DBA_FINANZAMTS_NR = "";
                this.FIELD_DBA_FINANZAMTS_BEZ = "";
                this.FIELD_DBA = Boolean.FALSE;
            }
            this.FIELD_DBA_DATUM_DER_BESCHEINIGUNG = DateMapper.toString((ILanguage)this.mLanguage, (Date)taxContainer.datectfcdbawouttax);
            this.FIELD_DBA_GILT_VOM = DateMapper.toString((ILanguage)this.mLanguage, (Date)taxContainer.fromdbawouttax);
            this.FIELD_DBA_GILT_BIS = DateMapper.toString((ILanguage)this.mLanguage, (Date)taxContainer.untildbawouttax);
            this.FIELD_STEUERID = taxContainer.tin;
        }
        String jahr = DateMapper.toString((ILanguage)this.mLanguage, (Date)effectiveDate);
        String monat = jahr.substring(3, 5);
        int mon = Integer.parseInt(monat);
        switch (mon) {
            case 1: {
                monat = "Januar";
                break;
            }
            case 2: {
                monat = "Februar";
                break;
            }
            case 3: {
                monat = "M\u00e4rz";
                break;
            }
            case 4: {
                monat = "April";
                break;
            }
            case 5: {
                monat = "Mai";
                break;
            }
            case 6: {
                monat = "Juni";
                break;
            }
            case 7: {
                monat = "Juli";
                break;
            }
            case 8: {
                monat = "August";
                break;
            }
            case 9: {
                monat = "September";
                break;
            }
            case 10: {
                monat = "Oktober";
                break;
            }
            case 11: {
                monat = "November";
                break;
            }
            case 12: {
                monat = "Dezember";
            }
        }
        Employee[] employees = WageAccountReportDataSource.getIEmployeePM().getEmployee(currentOidEmployee).getAllPredecessorAndSuccessor();
        if (employees.length > 1) {
            void var25_28;
            Employee[] employeeArray = employees;
            int n = employeeArray.length;
            boolean bl = false;
            while (var25_28 < n) {
                Employee employee = employeeArray[var25_28];
                personnelnumberDatas.add(new WageAccountPersonnelNumberBean(employee.getPersonnelnumber(), employee.getMinimumDateOfEntry(), employee.getLastDateOfWithdrawal()));
                ++var25_28;
            }
        }
        if (!this.mReturnCalculation) {
            List<Object> eeCFofEntryList = new ArrayList();
            eeCFofEntryList = this.getCFofEntrys(currentOidEmployee);
            for (CfofentryallContainer cfofentryallContainer : eeCFofEntryList) {
                String string4 = cfofentryallContainer.additionalboolean1 ? "S" : "";
                string4 = cfofentryallContainer.additionalboolean1 ? " B" : string4;
                string4 = cfofentryallContainer.additionalboolean1 ? " V" : string4;
                string4 = cfofentryallContainer.additionalboolean1 ? " F" : string4;
                cFofEntryDatas.add(new WageAccountCFofEntryBean(Integer.toString(cfofentryallContainer.yearofcertificate), DateMapper.toString((ILanguage)this.mLanguage, (Date)cfofentryallContainer.employmentfrom), DateMapper.toString((ILanguage)this.mLanguage, (Date)cfofentryallContainer.employmentuntil), Integer.toString(cfofentryallContainer.additionalint), cfofentryallContainer.additionalamount17 != null ? WageAccountReportDataSource.toPrintFormat(cfofentryallContainer.additionalamount17, 1) : "0,0", ChurchTaxEnumMapper.valueToString((int)cfofentryallContainer.typeofchurchtaxee), ChurchTaxEnumMapper.valueToString((int)cfofentryallContainer.typeofchurchtaysp), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount18), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount19), cfofentryallContainer.exclusionaitreturn ? "Ja" : "Nein", WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.grosspay), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.incometax), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.solidaritycharge), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.churchtaxee), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.churchtaxspouse), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.taxprivilegedpen1y), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.taxprivilegedpendy), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.reducedtaxedpaydy), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.incometaxdy), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.solidaritychargedy), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.churchtaxeedy), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.churchtaxspousedy), Integer.toString(cfofentryallContainer.additionalint1), string4, WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount1), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount2), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount3), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount4), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount5), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount6), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount7), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount8), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount9), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount10), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount24), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount25), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount11), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount12), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount14), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount15), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount16), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount23), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount20), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount21), WageAccountReportDataSource.toCurrencyFormat(cfofentryallContainer.additionalamount22)));
            }
            List<CfofsystemcomallContainer> eeCFofSystemComList = this.getCFofSystemComs(currentOidEmployee);
            for (CfofsystemcomallContainer cfofsystemcomallContainer : eeCFofSystemComList) {
                HealthFundTP healthFundTP = !StringMapper.isNullString((String)cfofsystemcomallContainer.oidhealthfund) ? WageAccountReportDataSource.getHealthFundTP(cfofsystemcomallContainer.oidhealthfund, effectiveDate, validUntilDate) : null;
                cFofSystemCOMDatas.add(new WageAccountCFofSystemCOMBean(Integer.toString(cfofsystemcomallContainer.foryear), Integer.toString(cfofsystemcomallContainer.persongroup), cfofsystemcomallContainer.occupation, healthFundTP != null ? healthFundTP.getShortDescription() : "", "", Integer.toString(cfofsystemcomallContainer.duesgrouphi) + " " + Integer.toString(cfofsystemcomallContainer.duesgrouppi) + " " + Integer.toString(cfofsystemcomallContainer.duesgroupui) + " " + Integer.toString(cfofsystemcomallContainer.duesgroupni), Integer.toString(cfofsystemcomallContainer.numberofhiday), Integer.toString(cfofsystemcomallContainer.numberofpiday), Integer.toString(cfofsystemcomallContainer.numberofuiday), Integer.toString(cfofsystemcomallContainer.numberofniday), "W".equals(cfofsystemcomallContainer.lawarea) ? "West" : "Ost", WageAccountReportDataSource.toCurrencyFormat(cfofsystemcomallContainer.hipayment), WageAccountReportDataSource.toCurrencyFormat(cfofsystemcomallContainer.pipayment), WageAccountReportDataSource.toCurrencyFormat(cfofsystemcomallContainer.uipayment), WageAccountReportDataSource.toCurrencyFormat(cfofsystemcomallContainer.nipayment)));
            }
            List<CfofsystemsiallContainer> list = this.getCFofSystemSis(currentOidEmployee);
            for (CfofsystemsiallContainer cfofsystemsiallContainer : list) {
                HealthFundTP healthFundTP = !StringMapper.isNullString((String)cfofsystemsiallContainer.oidhealthfund) ? WageAccountReportDataSource.getHealthFundTP(cfofsystemsiallContainer.oidhealthfund, effectiveDate, validUntilDate) : null;
                cFofSystemSIDatas.add(new WageAccountCFofSystemSIBean(DateMapper.toString((ILanguage)this.mLanguage, (Date)cfofsystemsiallContainer.validfrom), DateMapper.toString((ILanguage)this.mLanguage, (Date)cfofsystemsiallContainer.validuntil), Integer.toString(cfofsystemsiallContainer.persongroup), cfofsystemsiallContainer.occupation, healthFundTP != null ? healthFundTP.getShortDescription() : "", Integer.toString(cfofsystemsiallContainer.duesgrouphi) + " " + Integer.toString(cfofsystemsiallContainer.duesgrouppi) + " " + Integer.toString(cfofsystemsiallContainer.duesgroupui) + " " + Integer.toString(cfofsystemsiallContainer.duesgroupni), Integer.toString(cfofsystemsiallContainer.numberofhiday), Integer.toString(cfofsystemsiallContainer.numberofpiday), Integer.toString(cfofsystemsiallContainer.numberofuiday), Integer.toString(cfofsystemsiallContainer.numberofniday), "W".equals(cfofsystemsiallContainer.lawarea) ? "West" : "Ost", WageAccountReportDataSource.toCurrencyFormat(cfofsystemsiallContainer.hipayment), WageAccountReportDataSource.toCurrencyFormat(cfofsystemsiallContainer.pipayment), WageAccountReportDataSource.toCurrencyFormat(cfofsystemsiallContainer.uipayment), WageAccountReportDataSource.toCurrencyFormat(cfofsystemsiallContainer.nipayment), this.getCFPartClassRisks(cfofsystemsiallContainer.getObjectid())));
            }
            ArrayList arrayList = new ArrayList();
            List<CfofsystemsibContainer> list2 = this.getCFofSystemSibs(currentOidEmployee);
            for (CfofsystemsibContainer cfofsystemsibContainer : list2) {
                AbsenttimeallContainer absenttimeContainer = WageAccountReportDataSource.getAbsenttime(cfofsystemsibContainer.validuntil, cfofsystemsibContainer.validuntil, cfofsystemsibContainer.oidabsenttime);
                cFofSystemSIBDatas.add(new WageAccountCFofSystemSIBBean(DateMapper.toString((ILanguage)this.mLanguage, (Date)cfofsystemsibContainer.validfrom), DateMapper.toString((ILanguage)this.mLanguage, (Date)cfofsystemsibContainer.validuntil), absenttimeContainer.absenttimekey + " / " + absenttimeContainer.deuvabsenttimekey, absenttimeContainer.shortdescription));
            }
            HashMap<Date, String[]> hashMap = new HashMap<Date, String[]>();
            List<EmploymentContainer> list3 = WageAccountReportDataSource.getEntries(effectiveDate, validFromDate, DateHelper.getLastDayOfMonth((Date)validUntilDate), currentOidEmployee);
            if (!list3.isEmpty()) {
                for (EmploymentContainer employmentContainer2 : list3) {
                    String dateofentry = DateMapper.toString((ILanguage)this.mLanguage, (Date)employmentContainer2.dateofentry);
                    String dateofentrysi = DateMapper.toString((ILanguage)this.mLanguage, (Date)employmentContainer2.dateofentrysi);
                    String entryreason = StringMapper.isNullString((String)employmentContainer2.oidentryreason) ? "" : WageAccountReportDataSource.getEntryReason((Date)employmentContainer2.validuntil, (Date)employmentContainer2.validuntil, (String)employmentContainer2.oidentryreason).shortdescription;
                    String dateofwithdrawal = DateMapper.toString((ILanguage)this.mLanguage, (Date)employmentContainer2.dateofwithdrawal);
                    String dateofwithdrawalsi = DateMapper.toString((ILanguage)this.mLanguage, (Date)employmentContainer2.dateofwithdrawalsi);
                    String withdrawalrsn = StringMapper.isNullString((String)employmentContainer2.oidwithdrawalrsn) ? "" : WageAccountReportDataSource.getWithdrawalReason((Date)employmentContainer2.effectiveuntil, (Date)employmentContainer2.validuntil, (String)employmentContainer2.oidwithdrawalrsn).shortdescription;
                    String[] tempArray = (String[])hashMap.get(employmentContainer2.dateofentry);
                    if (tempArray == null) {
                        tempArray = new String[]{dateofentry, dateofentrysi, entryreason, dateofwithdrawal, dateofwithdrawalsi, withdrawalrsn};
                        hashMap.put(employmentContainer2.dateofentry, tempArray);
                        continue;
                    }
                    if (tempArray[0].compareTo(DateMapper.toString((ILanguage)this.mLanguage, (Date)employmentContainer2.dateofentry)) != 0) {
                        tempArray = new String[]{dateofentry, dateofentrysi, entryreason, dateofwithdrawal, dateofwithdrawalsi, withdrawalrsn};
                        hashMap.put(employmentContainer2.dateofentry, tempArray);
                        continue;
                    }
                    if (StringMapper.isNullString((String)tempArray[1])) {
                        tempArray[1] = dateofentrysi;
                    } else if (!StringMapper.isNullString((String)dateofentrysi) && tempArray[1].compareTo(dateofentrysi) != 0) {
                        tempArray[1] = dateofentrysi;
                    }
                    if (StringMapper.isNullString((String)tempArray[2])) {
                        tempArray[2] = entryreason;
                    } else if (!StringMapper.isNullString((String)entryreason) && tempArray[2].compareTo(entryreason) != 0) {
                        tempArray[2] = entryreason;
                    }
                    if (StringMapper.isNullString((String)tempArray[3])) {
                        tempArray[3] = dateofwithdrawal;
                    } else if (!StringMapper.isNullString((String)dateofwithdrawal) && tempArray[3].compareTo(dateofwithdrawal) != 0) {
                        tempArray[3] = dateofwithdrawal;
                    }
                    if (StringMapper.isNullString((String)tempArray[4])) {
                        tempArray[4] = dateofwithdrawalsi;
                    } else if (!StringMapper.isNullString((String)dateofwithdrawalsi) && tempArray[4].compareTo(dateofwithdrawalsi) != 0) {
                        tempArray[4] = dateofwithdrawalsi;
                    }
                    if (StringMapper.isNullString((String)tempArray[5])) {
                        tempArray[5] = withdrawalrsn;
                        continue;
                    }
                    if (StringMapper.isNullString((String)withdrawalrsn) || tempArray[5].compareTo(withdrawalrsn) == 0) continue;
                    tempArray[5] = withdrawalrsn;
                }
                ArrayList dateList = new ArrayList(hashMap.keySet());
                for (Object date : dateList) {
                    String[] tempArray = (String[])hashMap.get(date);
                    entryDatas.add(new WageAccountEntryBean(tempArray[0], tempArray[1], tempArray[2], tempArray[3], tempArray[4], tempArray[5]));
                }
                List<EeabsenttimeallContainer> list4 = WageAccountReportDataSource.getEEAbsenttimes(effectiveDate, validFromDate, DateHelper.getLastDayOfMonth((Date)validUntilDate), currentOidEmployee);
                for (EeabsenttimeallContainer absenttimeContainer : list4) {
                    AbsenttimeallContainer absenttimeallContainer = WageAccountReportDataSource.getAbsenttime(absenttimeContainer.validuntil, absenttimeContainer.validuntil, absenttimeContainer.oidabsenttime);
                    String validfrom = DateMapper.toString((ILanguage)this.mLanguage, (Date)absenttimeContainer.validfrom);
                    String validuntil = DateMapper.toString((ILanguage)this.mLanguage, (Date)absenttimeContainer.validuntil);
                    String absenttimekey = absenttimeContainer.absenttimekey + " / " + absenttimeContainer.deuvabsenttimekey;
                    String shortdescription = absenttimeallContainer.shortdescription;
                    String deleted = absenttimeContainer.deleted ? "J" : "N";
                    String vergleichsnetto = WageAccountReportDataSource.toCurrencyFormat(absenttimeContainer.comparisonnet);
                    String krankengeld = WageAccountReportDataSource.toCurrencyFormat(absenttimeContainer.sickpay);
                    absenttimeDatas.add(new WageAccountAbsenttimeBean(validfrom, validuntil, absenttimekey, shortdescription, deleted, vergleichsnetto, krankengeld));
                }
            }
            List<InsuranceContainer> agePartTimeList = WageAccountReportDataSource.getAgePartTimes(effectiveDate, validFromDate, DateHelper.getLastDayOfMonth((Date)validUntilDate), currentOidEmployee);
            for (InsuranceContainer agePartTimeContainer : agePartTimeList) {
                void var30_70;
                String vertragsart;
                String modellbezeichnung;
                String begrenzung;
                String mindestnettoentgelt;
                String rv_aufstockung;
                String atz_modell;
                if (!StringMapper.isNullString((String)agePartTimeContainer.oidparttimemodel)) {
                    ParttimemodelallContainer agePartTimeModelContainer = WageAccountReportDataSource.getAgePartTimeModel(effectiveDate, validFromDate, DateHelper.getLastDayOfMonth((Date)validUntilDate), agePartTimeContainer.oidparttimemodel);
                    atz_modell = agePartTimeModelContainer.parttimemodelkey;
                    String string = WageAccountReportDataSource.toPrintFormat(agePartTimeModelContainer.minimumincrease);
                    rv_aufstockung = WageAccountReportDataSource.toPrintFormat(agePartTimeModelContainer.increasepi);
                    mindestnettoentgelt = WageAccountReportDataSource.toPrintFormat(agePartTimeModelContainer.minimumnetwage);
                    begrenzung = agePartTimeModelContainer.limitationofdues ? "Ja" : "Nein";
                    modellbezeichnung = agePartTimeModelContainer.longdescription;
                    vertragsart = agePartTimeModelContainer.typeofcontract == 0 ? "Neuvertrag" : "Altvertrag";
                } else {
                    atz_modell = agePartTimeContainer.typeofageparttime == 0 ? "Teilzeit" : "Blockzeit";
                    String string = WageAccountReportDataSource.toPrintFormat(agePartTimeContainer.percincreasedues);
                    rv_aufstockung = WageAccountReportDataSource.toPrintFormat(agePartTimeContainer.percpiincrease);
                    mindestnettoentgelt = WageAccountReportDataSource.toPrintFormat(agePartTimeContainer.percminnetincome);
                    begrenzung = "";
                    modellbezeichnung = "";
                    vertragsart = "";
                }
                agePartTimeDatas.add(new WageAccountAgePartTimeBean(DateMapper.toString((ILanguage)this.mLanguage, (Date)agePartTimeContainer.beginageparttime), DateMapper.toString((ILanguage)this.mLanguage, (Date)agePartTimeContainer.endageparttime), (String)(agePartTimeContainer.persnoofreplacer == 0 ? "" : Integer.toString(agePartTimeContainer.persnoofreplacer) + " ") + agePartTimeContainer.nameofreplacer, agePartTimeContainer.compkeyofreplacer, (String)var30_70, mindestnettoentgelt, rv_aufstockung, atz_modell, DateMapper.toString((ILanguage)this.mLanguage, (Date)agePartTimeContainer.beginworkexemption), begrenzung, modellbezeichnung, agePartTimeContainer.useparttimeage ? "Ja" : "Nein", vertragsart));
            }
        }
        if (!this.mReturnCalculation) {
            List<ValuepositionContainer> rrVPList = WageAccountReportDataSource.getRRValuePositions(validUntilDate, currentOidEmployee);
            for (ValuepositionContainer valuepositionContainer : rrVPList) {
                Date[] dateArray = (Date[])returnCalculationHashMap.get(valuepositionContainer.effectivefrom);
                if (dateArray == null) {
                    Date[] dateArray2 = new Date[]{valuepositionContainer.effectivefrom, valuepositionContainer.validfrom};
                    returnCalculationHashMap.put(valuepositionContainer.effectivefrom, dateArray2);
                    continue;
                }
                dateArray[1] = DateHelper.min((Date)dateArray[1], (Date)valuepositionContainer.validfrom);
                returnCalculationHashMap.put(valuepositionContainer.effectivefrom, dateArray);
            }
            if (!returnCalculationHashMap.isEmpty()) {
                ArrayList tempList = new ArrayList(returnCalculationHashMap.keySet());
                Collections.sort(tempList, new DateComparator());
                for (Date date : tempList) {
                    Date[] dateArray = (Date[])returnCalculationHashMap.get(date);
                    newCalculationDatas.add(new WageAccountNewCalculationBean(DateMapper.toString((ILanguage)this.mLanguage, (Date)effectiveDate), DateMapper.toString((ILanguage)this.mLanguage, (Date)DateHelper.getLastDayOfMonth((Date)dateArray[0])), DateMapper.toString((ILanguage)this.mLanguage, (Date)dateArray[1]), DateMapper.toString((ILanguage)this.mLanguage, (Date)DateHelper.yesterday((Date)dateArray[0]))));
                }
            }
        }
        this.FIELD_PERSONNELNUMBERDATAS = personnelnumberDatas;
        this.FIELD_NEWCALCULATIONDATAS = newCalculationDatas;
        this.FIELD_CFOFENTRYDATAS = cFofEntryDatas;
        this.FIELD_CFOFSYSTEMSIDATAS = cFofSystemSIDatas;
        this.FIELD_CFOFSYSTEMSIBDATAS = cFofSystemSIBDatas;
        this.FIELD_CFOFSYSTEMCOMDATAS = cFofSystemCOMDatas;
        this.FIELD_ENTRYDATAS = entryDatas;
        this.FIELD_ABSENTTIMEDATAS = absenttimeDatas;
        this.FIELD_DEUEVDATAS = this.getDeuevData(effectiveDate, validFromDate, currentOidEmployee, validUntilForDeuv);
        this.FIELD_AGEPARTTIMEDATAS = agePartTimeDatas;
    }

    private Collection<WageAccountDEUEVBean> getDeuevData(Date effectiveDate, Date validFromDate, String currentOidEmployee, Date validUntilForDeuv) {
        ArrayList<WageAccountDEUEVBean> deuevDatas = new ArrayList<WageAccountDEUEVBean>();
        List<DEUVAccount> deuvAccountList = this.getDeuvAccounts(effectiveDate, validFromDate, DateHelper.getLastDayOfMonth((Date)validUntilForDeuv), currentOidEmployee);
        Date lastOfYear = DateHelper.getLastDayOfYear((Date)validFromDate);
        for (DEUVAccount deuvAccount : deuvAccountList) {
            DEUVDsfz deuvDsfz;
            if (DateHelper.after((Date)deuvAccount.getValidFrom(), (Date)lastOfYear) && deuvAccount.getReasonOfDelivery() != 54) break;
            DEUVDbuv deuvDbuv = deuvAccount.getDEUVDbuv();
            ArrayList<WageAccountDBUVRiskPeriodsBean> wageAccountDBUVRiskPeriodsList = new ArrayList<WageAccountDBUVRiskPeriodsBean>();
            if (deuvDbuv != null) {
                UVRiskPeriod[] uVRiskPeriods;
                for (UVRiskPeriod lUVRiskPeriod : uVRiskPeriods = deuvDbuv.getUVRiskPeriods()) {
                    wageAccountDBUVRiskPeriodsList.add(new WageAccountDBUVRiskPeriodsBean(lUVRiskPeriod.getBbnrUV(), StringMapper.isNullString((String)lUVRiskPeriod.getMitgliedsNr()) ? lUVRiskPeriod.getUnrs() : lUVRiskPeriod.getMitgliedsNr(), lUVRiskPeriod.getBbnrGTS(), lUVRiskPeriod.getGtStelle(), WageAccountReportDataSource.toPrintFormat(lUVRiskPeriod.getUvEntgelt(), 0), lUVRiskPeriod.getArbStd() == null ? WageAccountReportDataSource.toPrintFormat(BigDecimal.ZERO) : WageAccountReportDataSource.toPrintFormat(lUVRiskPeriod.getArbStd(), 0), lUVRiskPeriod.getUVGrund(), lUVRiskPeriod.getPaymentDescription()));
                }
            }
            DEUVDsme deuvDsme = deuvAccount.getDEUVDsme();
            DEUVDbme deuvDbme = null;
            String rechtskreis = "";
            String mehrfachbesch = "";
            String bbnrVerursacher = "";
            String bbnrEmpfaenger = "";
            Date validFrom = deuvAccount.getValidFrom();
            if (deuvDsme != null) {
                deuvDbme = deuvDsme.getDEUVDbme();
                if (deuvDbme != null) {
                    switch (deuvDbme.getRechtskreis()) {
                        case "W": {
                            rechtskreis = "West";
                            break;
                        }
                        case "O": {
                            rechtskreis = "Ost";
                        }
                    }
                    if (deuvAccount.getReasonOfDelivery() == 92) {
                        validFrom = DateHelper.getFirstDayOfYear((Date)validFrom);
                    }
                    if (!StringMapper.isNullString((String)deuvDbme.getMehrfachbesch())) {
                        mehrfachbesch = deuvDbme.getMehrfachbesch().equals("N") ? "Nein" : "Ja";
                    }
                }
                bbnrVerursacher = deuvDsme.getBbnrVerursacher();
                bbnrEmpfaenger = deuvDsme.getBbnrEmpfaenger();
            }
            if ((deuvDsfz = deuvAccount.getDeuvDsfz()) != null) {
                bbnrVerursacher = deuvDsfz.getBbnrvu();
                bbnrEmpfaenger = deuvDsfz.getEpnr();
            }
            String reasonOfDelivery = Integer.toString(deuvAccount.getReasonOfDelivery());
            deuevDatas.add(new WageAccountDEUEVBean(DateMapper.toString((ILanguage)this.mLanguage, (Date)validFrom) + (String)(VDate.isDateMax((Date)deuvAccount.getValidUntil()) ? "" : " - " + DateMapper.toString((ILanguage)this.mLanguage, (Date)deuvAccount.getValidUntil())), reasonOfDelivery + " " + ReasonOfDeliveryStringMapper.getReasonOfDeliverString((String)reasonOfDelivery), deuvAccount.getDuesgroups(), Integer.toString(deuvAccount.getPersongroup()), mehrfachbesch, deuvDbme != null ? WageAccountReportDataSource.toAmountString(deuvDbme.getEntgelt()) : "", deuvDbme != null ? WageAccountReportDataSource.toAmountString(deuvDbme.getEntgeltRb()) : "", deuvDsme != null ? deuvDsme.getStaat() : "", deuvDbme != null ? deuvDbme.getTaetigkeitssl() : "", deuvDsme != null ? deuvDsme.getBbnrKrankenkasse() : "", bbnrVerursacher, rechtskreis, deuvAccount.getCreatedOn(), bbnrEmpfaenger, deuvAccount.getCanceled(), deuvDbme != null ? deuvDbme.getGleitzone() : "", wageAccountDBUVRiskPeriodsList));
        }
        return deuevDatas;
    }

    private PCompany getPCompany() {
        return WageAccountReportDataSource.getPCompany(this.mMasterallContainer.oidpcompany);
    }

    public Map<String, Object> getParameters() {
        return new JasperParameterHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private List<String[]> createList(Date effectiveDate, Date beginValidDate, Date endValidDate, String oidEmployee) throws BusinessDomainException {
        void var80_107;
        ValuepositionContainer sumValuePositionContainer;
        ValuepositionContainer tempValuePositionContainer;
        String valueTypeKey;
        String[] vpArray;
        int endYearIndex;
        Employee employee = WageAccountReportDataSource.getIEmployeePM().getEmployee(oidEmployee);
        ArrayList<String[]> vpAllList = new ArrayList<String[]>();
        HashMap<Object, String[]> vpHashMap = new HashMap<Object, String[]>();
        ArrayList<Object> tempList = new ArrayList();
        String[] ueberschriftBruttowerte = WageAccountReportDataSource.createRow("09999B", "Bruttowerte", true);
        String[] tag_der_lohnzahlung = WageAccountReportDataSource.createRow("09999C", "Tag der Lohnzahlung");
        String[] lohnzahlungszeitraum = WageAccountReportDataSource.createRow("09999D", "Lohnzahlungszeitraum");
        String[] bundesland = WageAccountReportDataSource.createRow("09999E", "Bundesland");
        String[] kostenstelle = WageAccountReportDataSource.createRow("09999F", "Kostenstelle");
        String[] woechentliche_arbeitszeit = WageAccountReportDataSource.createRow("09999G", "w\u00f6chentliche Arbeitszeit");
        String[] arbeitstage = WageAccountReportDataSource.createRow("09999H", "Arbeitstage");
        String[] leerST = WageAccountReportDataSource.createRow("19999A", "");
        String[] ueberschriftSteuerwerte = WageAccountReportDataSource.createRow("19999B", "Steuerwerte", true);
        String[] steuerklasse = WageAccountReportDataSource.createRow("19999C", "Steuerklasse/Faktor");
        String[] zkf = WageAccountReportDataSource.createRow("19999D", "ZKF");
        String[] frei_hinzu_betrag_jahr = WageAccountReportDataSource.createRow("19999E", "Frei-/ Hinzu-betrag Jahr");
        String[] frei_hinzu_betrag_monat = WageAccountReportDataSource.createRow("19999F", "Frei-/ Hinzu-betrag Monat");
        String[] steuerpflicht = WageAccountReportDataSource.createRow("19999G", "Steuerpflicht");
        String[] lohnsteuerjahresausgleich = WageAccountReportDataSource.createRow("19999H", "Lohnsteuerjahresausgleich");
        String[] kirchensteuer = WageAccountReportDataSource.createRow("19999I", "Kirchensteuer AN/Ehegatte");
        String[] kammerbeitrag = WageAccountReportDataSource.createRow("19999J", "Kammerbeitrag");
        String[] monatsverdienst = WageAccountReportDataSource.createRow("19999K", "Monatsverdienst SBZ");
        String[] versorgungsbezug = WageAccountReportDataSource.createRow("19999L", "Versorgungsbezug");
        String[] versorgungsbeginn = WageAccountReportDataSource.createRow("19999M", "Versorgungsbeginn");
        String[] vbz_sonderz = WageAccountReportDataSource.createRow("19999N", "VBZ-Sonderzahlung(en)");
        String[] leerSV = WageAccountReportDataSource.createRow("29999A", "");
        String[] ueberschriftSozialversicherungswerte = WageAccountReportDataSource.createRow("29999B", "Sozialversicherungswerte", true);
        String[] pgs_staat = WageAccountReportDataSource.createRow("29999C", "PGS/Staat");
        String[] taetigkeitsschluessel = WageAccountReportDataSource.createRow("29999D", "T\u00e4tigkeitsschl\u00fcssel");
        String[] rentenart = WageAccountReportDataSource.createRow("29999F", "Rentenart / Status");
        String[] betriebsnummer = WageAccountReportDataSource.createRow("29999G", "Betriebsnummer");
        String[] bes_sv_merkmal = WageAccountReportDataSource.createRow("29999H", "besonderes SV-Merkmal");
        String[] bgs = WageAccountReportDataSource.createRow("29999I", "Beitragsgruppenschl\u00fcssel");
        String[] krankenkasse = WageAccountReportDataSource.createRow("29999J", "Krankenkasse");
        String[] rechtskreis_rv_av = WageAccountReportDataSource.createRow("29999K", "Rechtskreis RV/AV");
        String[] umlagepflicht = WageAccountReportDataSource.createRow("29999L", "Umlagepflicht");
        String[] umlagekasse = WageAccountReportDataSource.createRow("29999M", "Umlagekasse");
        String[] verzicht_rv_reduzierung = WageAccountReportDataSource.createRow("29999N", "Verzicht RV-Freiheit /-Reduzierung");
        String[] befrei_av_aga = WageAccountReportDataSource.createRow("29999O", "Befreiung AG-Anteil zur AV");
        String[] elterneigenschaft_abschlag = WageAccountReportDataSource.createRow("29999P", "Elterneig. PV / Anz. PV-Kinder");
        String[] mehrfachbeschaeftigung = WageAccountReportDataSource.createRow("29999Q", "Mehrfachbesch\u00e4ftigung");
        String[] rvRehab = WageAccountReportDataSource.createRow("29999R", "RV-Rehabilitationstr\u00e4ger");
        String[] bgs_anderer_ag = WageAccountReportDataSource.createRow("29999S", "BGS anderer AG");
        String[] priv_kv_basisab = WageAccountReportDataSource.createRow("29999T", "PKV-/PPV-Basisabsicherung");
        String[] priv_kv_zuschuss = WageAccountReportDataSource.createRow("29999U", "Private KV/AG-Zuschuss PKV");
        String[] priv_pv_zuschuss = WageAccountReportDataSource.createRow("29999V", "Private PV/AG-Zuschuss PPV");
        String[] freiw_kv = WageAccountReportDataSource.createRow("29999W", "Freiwillige KV");
        String[] ag_zuschuss_fkv = WageAccountReportDataSource.createRow("29999X", "AG-Zuschuss FKV");
        String[] freiw_pv = WageAccountReportDataSource.createRow("29999Y", "Freiwillige PV");
        String[] ag_zuschuss_fpv = WageAccountReportDataSource.createRow("29999Z", "AG-Zuschuss FPV");
        String[] beitragsher_bei_kug = WageAccountReportDataSource.createRow("29999ZA", "Beitragsherabsetzung bei KUG");
        String[] kvdr_krankenkasse = WageAccountReportDataSource.createRow("29999ZB", "KVdR- Krankenkasse");
        String[] beitragsober_vb = WageAccountReportDataSource.createRow("29999ZC", "Beitragsobergrenze VB-Max");
        String[] gesetz_rente = WageAccountReportDataSource.createRow("29999ZD", "Gesetzliche Rente");
        String[] berechnung_kv_pv = WageAccountReportDataSource.createRow("29999ZE", "Berechnung KV/PV");
        String[] betriebsrente = WageAccountReportDataSource.createRow("29999ZF", "Betriebsrente");
        String[] kennzeichen_mehrfachbezug = WageAccountReportDataSource.createRow("29999ZG", "Kennzeichen Mehrfachbezug");
        String[] kennzeichen_freibetrag = WageAccountReportDataSource.createRow("29999ZH", "Kennzeichen Freibetrag");
        String[] hoehe_freibetrag = WageAccountReportDataSource.createRow("29999ZI", "H\u00f6he Freibetrag");
        String[] elterneigenschaft_pv = WageAccountReportDataSource.createRow("29999ZJ", "Elterneigenschaft PV (KVdR)");
        String[] versorgungseinrichtung = WageAccountReportDataSource.createRow("29999ZK", "Versorgungseinrichtung");
        String[] bv_mitgleids_nr = WageAccountReportDataSource.createRow("29999ZL", "BV-Mitglieds-Nr.");
        String[] ag_zusch_versorg = WageAccountReportDataSource.createRow("29999ZM", "AG-Zusch. Versorg.");
        String[] gesamtbetrag = WageAccountReportDataSource.createRow("29999ZN", "Gesamtbetr. Versorg.");
        String[] beitragsabfuehrung = WageAccountReportDataSource.createRow("29999ZO", "Beitragsabf\u00fchrung");
        String[] regelmaessigesJAEGleitzone = WageAccountReportDataSource.createRow("29999ZP", "regelm\u00e4\u00dfiges JAE Gleitzone");
        String[] leerNetto = WageAccountReportDataSource.createRow("69999A", "", true);
        String[] ueberschriftNettowerte = WageAccountReportDataSource.createRow("69999B", "Nettowerte", true);
        Date tempEndMonthDate = endValidDate;
        Date tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        vpAllList.clear();
        List<ValuepositionContainer> vpList = this.getValuePositions(effectiveDate, beginValidDate, endValidDate, oidEmployee);
        if (!this.mReturnCalculation) {
            this.FIELD_SICHT = DateMapper.toString((ILanguage)this.mLanguage, (Date)effectiveDate);
        }
        this.FIELD_ALTE_PERSONALNUMMER = WageAccountReportDataSource.getEmployment((Date)this.mForEffectiveDate, (Date)DateHelper.tomorrow((Date)endValidDate), (String)oidEmployee).personnelnumberold;
        this.FIELD_ALTE_PERSONALNUMMER_BIS = "";
        if (!StringMapper.isNullString((String)this.FIELD_ALTE_PERSONALNUMMER)) {
            if (!StringMapper.equal((String)this.FIELD_PERSONAL_NR, (String)this.FIELD_ALTE_PERSONALNUMMER)) {
                Date validuntil = WageAccountReportDataSource.getOldPersonnelNumberUntil(this.mForEffectiveDate, DateHelper.tomorrow((Date)endValidDate), oidEmployee, this.FIELD_ALTE_PERSONALNUMMER);
                if (DateHelper.beforeOrEqual((Date)validuntil, (Date)endValidDate)) {
                    this.FIELD_ALTE_PERSONALNUMMER_BIS = DateMapper.toString((ILanguage)this.mLanguage, (Date)validuntil);
                } else {
                    this.FIELD_ALTE_PERSONALNUMMER = "";
                }
            } else {
                this.FIELD_ALTE_PERSONALNUMMER = "";
            }
        }
        int beginYearIndex = new VDate(beginValidDate).getMonth() + 2;
        for (int i = endYearIndex = new VDate(endValidDate).getMonth() + 2; i >= beginYearIndex; --i) {
            void var83_150;
            WorkingTime workingTime;
            MasterallContainer masterallContainer;
            EmploymentContainer employmentContainer;
            TaxContainer tempTaxContainer = WageAccountReportDataSource.getTax(effectiveDate, tempEndMonthDate, oidEmployee);
            if (tempTaxContainer != null) {
                switch (tempTaxContainer.taxbracket) {
                    case 0: {
                        steuerklasse[i] = "keine";
                        break;
                    }
                    case 1: {
                        steuerklasse[i] = "I";
                        break;
                    }
                    case 2: {
                        steuerklasse[i] = "II";
                        break;
                    }
                    case 3: {
                        steuerklasse[i] = "III";
                        break;
                    }
                    case 4: {
                        steuerklasse[i] = "IV";
                        break;
                    }
                    case 5: {
                        steuerklasse[i] = "V";
                        break;
                    }
                    case 6: {
                        steuerklasse[i] = "VI";
                        break;
                    }
                    default: {
                        steuerklasse[i] = "keine";
                    }
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempTaxContainer.percentagesplit)) {
                    steuerklasse[i] = steuerklasse[i] + " / " + WageAccountReportDataSource.toPrintFormat(tempTaxContainer.percentagesplit);
                }
                zkf[i] = WageAccountReportDataSource.toPrintFormat(tempTaxContainer.childrelief);
                if (!StringMapper.isNullString((String)tempTaxContainer.oidfederalstate)) {
                    FederalStateTP federalStateTP = WageAccountReportDataSource.getFederalStateTP(tempTaxContainer.oidfederalstate, effectiveDate, endValidDate);
                    bundesland[i] = federalStateTP.getShortDescSocialInsuranceLaw();
                    String string = rechtskreis_rv_av[i] = federalStateTP.getLawArea().equals("W") ? "West" : "Ost";
                    if (federalStateTP.getFederalState().getFederalState() == 4 || federalStateTP.getFederalState().getFederalState() == 10) {
                        this.mBL_Bremen_Saarland = true;
                    }
                }
                frei_hinzu_betrag_monat[i] = WageAccountReportDataSource.toCurrencyFormat(tempTaxContainer.freeallowancemm.subtract(tempTaxContainer.addamountmm));
                frei_hinzu_betrag_jahr[i] = WageAccountReportDataSource.toCurrencyFormat(tempTaxContainer.freeallowanceyy.subtract(tempTaxContainer.addamountyy));
                lohnsteuerjahresausgleich[i] = IncomeTaxReturnYYEnumMapper.valueToString((int)tempTaxContainer.incometaxreturnyy);
                steuerpflicht[i] = TaxacationEnumMapper.valueToString((int)tempTaxContainer.taxacation);
                kirchensteuer[i] = ChurchTaxEnumMapper.valueToString((int)tempTaxContainer.churchtaxee) + " / " + ChurchTaxEnumMapper.valueToString((int)tempTaxContainer.churchtaxspouse);
                kammerbeitrag[i] = tempTaxContainer.associationee ? "Ja" : "Nein";
                monatsverdienst[i] = WageAccountReportDataSource.toPrintFormat(tempTaxContainer.monthlyearnings);
                if (tempTaxContainer.pensionfreedues) {
                    this.mVersorgungsbezug = true;
                }
                versorgungsbezug[i] = WageAccountReportDataSource.toPrintFormat(tempTaxContainer.pension);
                versorgungsbeginn[i] = DateMapper.toString((ILanguage)this.mLanguage, (Date)tempTaxContainer.startdateofpension);
                vbz_sonderz[i] = WageAccountReportDataSource.toPrintFormat(tempTaxContainer.bonusofpension);
            }
            if ((employmentContainer = WageAccountReportDataSource.getEmployment(effectiveDate, tempEndMonthDate, oidEmployee)) != null) {
                if (StringMapper.isNullString((String)bundesland[i]) && !StringMapper.isNullString((String)employmentContainer.oidplant)) {
                    bundesland[i] = this.mEmployerBean.getPlantFederalstateShortDescSocialInsuranceLaw();
                    rechtskreis_rv_av[i] = this.mEmployerBean.getPlantLawareaLong();
                    if (this.mEmployerBean.getPlantFederalstateKey() == 4 || this.mEmployerBean.getPlantFederalstateKey() == 10) {
                        this.mBL_Bremen_Saarland = true;
                    }
                }
                String string = kostenstelle[i] = StringMapper.isNullString((String)employmentContainer.oidcostcenter) ? "" : this.getCostCenter(employmentContainer.oidcostcenter).getCostCenterTP(tempEndMonthDate, tempEndMonthDate).getLongDescription();
            }
            if ((masterallContainer = WageAccountReportDataSource.getMasterall(effectiveDate, tempEndMonthDate, oidEmployee)) != null) {
                tag_der_lohnzahlung[i] = DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate);
                lohnzahlungszeitraum[i] = DateMapper.toString((ILanguage)this.mLanguage, (Date)tempBeginMonthDate).substring(0, 3) + "-" + DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate);
                if (StringMapper.isNullString((String)bundesland[i]) && !StringMapper.isNullString((String)masterallContainer.oidpcompany)) {
                    bundesland[i] = this.mEmployerBean.getCompanyFederalstateShortDescSocialInsuranceLaw();
                    rechtskreis_rv_av[i] = this.mEmployerBean.getCompanyLawareaLong();
                    if (this.mEmployerBean.getCompanyFederalstateKey() == 4 || this.mEmployerBean.getCompanyFederalstateKey() == 10) {
                        this.mBL_Bremen_Saarland = true;
                    }
                }
            }
            EeworkallContainer eeworkallContainer = WageAccountReportDataSource.getEEWorkAll(effectiveDate, tempEndMonthDate, oidEmployee);
            BigDecimal bigDecimal = BigDecimal.ZERO;
            BigDecimal wochenarbeitszeit = BigDecimal.ZERO;
            if (eeworkallContainer != null) {
                WorkingtimeallContainer workingtimeContainer = WageAccountReportDataSource.getWorkingTime(effectiveDate, tempEndMonthDate, eeworkallContainer.oidworkingtime);
                if (workingtimeContainer != null && workingtimeContainer.oidworkingtime != null) {
                    wochenarbeitszeit = workingtimeContainer.weeklyworkingtime;
                    arbeitstage[i] = WageAccountReportDataSource.toPrintFormat(WorkingTimePersistencyManager.getWorkingTime((String)workingtimeContainer.oidworkingtime).getMonthlyConcreteTargetDays(Integer.parseInt(DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate).substring(3, 5)), Integer.parseInt(DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate).substring(6, 10)), employee, effectiveDate, tempEndMonthDate, false), 2);
                }
                if (eeworkallContainer.parttimework && !BigDecimalMapper.isZeroOrNull((BigDecimal)eeworkallContainer.percparttimework)) {
                    BigDecimal bigDecimal2 = eeworkallContainer.percparttimework.setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(100L));
                }
            }
            if (StringMapper.isNullString((String)arbeitstage[i]) && employmentContainer != null && !StringMapper.isNullString((String)employmentContainer.oidplant) && (workingTime = WageAccountReportDataSource.getPlantFoundations(employmentContainer.oidplant, effectiveDate, tempEndMonthDate).getFoundations().getWorkingTime()) != null) {
                arbeitstage[i] = WageAccountReportDataSource.toPrintFormat(workingTime.getMonthlyConcreteTargetDays(Integer.parseInt(DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate).substring(3, 5)), Integer.parseInt(DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate).substring(6, 10)), employee, effectiveDate, tempEndMonthDate, false), 2);
                wochenarbeitszeit = workingTime.getWorkingTimeTP(effectiveDate, tempEndMonthDate).getWeeklyWorkingTime();
            }
            if (StringMapper.isNullString((String)arbeitstage[i]) && masterallContainer != null && (workingTime = WageAccountReportDataSource.getPCompany(masterallContainer.oidpcompany).getCompanyFoundations(effectiveDate, tempEndMonthDate).getFoundations().getWorkingTime()) != null) {
                arbeitstage[i] = WageAccountReportDataSource.toPrintFormat(workingTime.getMonthlyConcreteTargetDays(Integer.parseInt(DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate).substring(3, 5)), Integer.parseInt(DateMapper.toString((ILanguage)this.mLanguage, (Date)tempEndMonthDate).substring(6, 10)), employee, effectiveDate, tempEndMonthDate, false), 2);
                wochenarbeitszeit = workingTime.getWorkingTimeTP(effectiveDate, tempEndMonthDate).getWeeklyWorkingTime();
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wochenarbeitszeit) && !BigDecimalMapper.isZeroOrNull((BigDecimal)var83_150)) {
                wochenarbeitszeit = wochenarbeitszeit.multiply((BigDecimal)var83_150).setScale(2, RoundingMode.HALF_UP);
            }
            woechentliche_arbeitszeit[i] = WageAccountReportDataSource.toPrintFormat(wochenarbeitszeit, 2);
            InsuranceContainer tempInsuranceContainer = WageAccountReportDataSource.getInsurance(effectiveDate, tempEndMonthDate, oidEmployee);
            if (tempInsuranceContainer != null) {
                void var86_175;
                pgs_staat[i] = Integer.toString(tempInsuranceContainer.persongroup);
                if (!StringMapper.isNullString((String)tempInsuranceContainer.oidnationality)) {
                    pgs_staat[i] = pgs_staat[i] + " / " + WageAccountReportDataSource.getStateTP(tempInsuranceContainer.oidnationality, effectiveDate, endValidDate).getState().getState();
                }
                if (DateHelper.before((Date)tempEndMonthDate, (Date)new VDate(2011, 11, 1).getDate())) {
                    taetigkeitsschluessel[i] = StringMapper.isNullString((String)tempInsuranceContainer.oidoccupationgroup) ? "" : this.getOccupationTP(tempInsuranceContainer.oidoccupation, effectiveDate, endValidDate).getOccupation().getAKey();
                    taetigkeitsschluessel[i] = taetigkeitsschluessel[i] + " " + Integer.toString(tempInsuranceContainer.positionofjob) + Integer.toString(tempInsuranceContainer.education);
                } else {
                    taetigkeitsschluessel[i] = StringMapper.isNullString((String)tempInsuranceContainer.oidoccupationlong) ? "" : this.getOccupationLongTP(tempInsuranceContainer.oidoccupationlong, effectiveDate, endValidDate).getOccupationLong().getOccupationKey();
                    taetigkeitsschluessel[i] = taetigkeitsschluessel[i] + " " + Integer.toString(tempInsuranceContainer.schoolleaving) + Integer.toString(tempInsuranceContainer.profeducation) + Integer.toString(tempInsuranceContainer.manpowerprovision) + Integer.toString(tempInsuranceContainer.typeofcontract);
                }
                rentenart[i] = Integer.toString(tempInsuranceContainer.typeofpension) + " / " + WageAccountReportDataSource.getIInsurancePM().getInsurance(tempInsuranceContainer.getObjectid()).getStatusCodeDEUV();
                betriebsnummer[i] = WageAccountReportDataSource.getEmployerNumber(effectiveDate, tempEndMonthDate, oidEmployee);
                switch (tempInsuranceContainer.specialcategory) {
                    case 0: {
                        bes_sv_merkmal[i] = "kein";
                        break;
                    }
                    case 1: {
                        bes_sv_merkmal[i] = "Geringverdiener";
                        break;
                    }
                    case 2: {
                        bes_sv_merkmal[i] = DateHelper.afterOrEqual((Date)tempEndMonthDate, (Date)new VDate(2019, 6, 1).getDate()) ? "\u00dcbergangsb." : "Gleitzone";
                        this.mGleitzone = true;
                        break;
                    }
                    case 3: {
                        bes_sv_merkmal[i] = DateHelper.afterOrEqual((Date)tempEndMonthDate, (Date)new VDate(2019, 6, 1).getDate()) ? "\u00dcbergangsb./AV" : "Gleitzone/AV";
                        this.mGleitzone = true;
                        break;
                    }
                    case 4: {
                        bes_sv_merkmal[i] = "freiw.soz.Jahr";
                        break;
                    }
                    case 5: {
                        bes_sv_merkmal[i] = "freiw.\u00f6ko.Jahr";
                    }
                }
                bgs[i] = Integer.toString(tempInsuranceContainer.duesgrouphi) + " " + Integer.toString(tempInsuranceContainer.duesgrouppi) + " " + Integer.toString(tempInsuranceContainer.duesgroupui) + " " + Integer.toString(tempInsuranceContainer.duesgroupni);
                if (tempInsuranceContainer.duesgrouphi == 0 || tempInsuranceContainer.duesgrouphi == 9) {
                    this.mPrivatFreiwilligKVPV = true;
                }
                if (!StringMapper.isNullString((String)tempInsuranceContainer.oidhealthfund)) {
                    krankenkasse[i] = WageAccountReportDataSource.getHealthFundTP(tempInsuranceContainer.oidhealthfund, effectiveDate, endValidDate).getShortDescription();
                }
                switch (tempInsuranceContainer.assessmentduty) {
                    case 0: {
                        umlagepflicht[i] = "keine";
                        break;
                    }
                    case 1: {
                        umlagepflicht[i] = "U1";
                        break;
                    }
                    case 2: {
                        umlagepflicht[i] = "U1 und U2";
                        break;
                    }
                    case 3: {
                        umlagepflicht[i] = "U2";
                    }
                }
                if (!StringMapper.isNullString((String)tempInsuranceContainer.oidhfassessment)) {
                    umlagekasse[i] = WageAccountReportDataSource.getHealthFundTP(tempInsuranceContainer.oidhfassessment, effectiveDate, endValidDate).getShortDescription();
                }
                verzicht_rv_reduzierung[i] = tempInsuranceContainer.noexemptionpf ? "Ja / " + DateMapper.toString((ILanguage)this.mLanguage, (Date)tempInsuranceContainer.datenoexemptionpf) : "Nein";
                befrei_av_aga[i] = tempInsuranceContainer.freeingoferduesui ? "J" : "N";
                elterneigenschaft_pv[i] = tempInsuranceContainer.nichildofeduckvdr ? "Ja" : "Nein";
                BigDecimal bigDecimal3 = BigDecimal.ZERO;
                if (DateHelper.afterOrEqual((Date)tempEndMonthDate, (Date)new VDate(2023, 6, 1).getDate())) {
                    BigDecimal bigDecimal4 = employee.getEffectiveNumberOfChildrenForNI(effectiveDate, tempEndMonthDate, true, false);
                }
                elterneigenschaft_abschlag[i] = tempInsuranceContainer.nichildeducation ? "Ja / " + (BigDecimal)var86_175 : "Nein / " + (BigDecimal)var86_175;
                rvRehab[i] = tempInsuranceContainer.pirehabresponsible ? "Ja" : "Nein";
                switch (tempInsuranceContainer.multiplyemployment) {
                    case 0: {
                        mehrfachbeschaeftigung[i] = "keine";
                        break;
                    }
                    case 1: {
                        mehrfachbeschaeftigung[i] = "unbek.2.Entgelt";
                        break;
                    }
                    case 2: {
                        mehrfachbeschaeftigung[i] = "Beitragsteilung";
                        break;
                    }
                    case 3: {
                        mehrfachbeschaeftigung[i] = "Beitragst./RK";
                    }
                }
                bgs_anderer_ag[i] = tempInsuranceContainer.groupkeyofother;
                if (DateHelper.afterOrEqual((Date)tempEndMonthDate, (Date)new VDate(2026, 0, 1).getDate())) {
                    InsuranceHIPIYearTP insuranceHIPIYearTP = WageAccountReportDataSource.getInsuranceHIPIYearTP(effectiveDate, tempEndMonthDate, oidEmployee);
                    if (insuranceHIPIYearTP != null) {
                        BigDecimal baseRatephipni = insuranceHIPIYearTP.getBaseRatePHI().add(insuranceHIPIYearTP.getBaseRatePNI());
                        priv_kv_basisab[i] = WageAccountReportDataSource.toCurrencyFormat(baseRatephipni);
                    } else {
                        priv_kv_basisab[i] = BigDecimalMapper.isZeroOrNull((BigDecimal)tempInsuranceContainer.baseratephi) ? WageAccountReportDataSource.toCurrencyFormat(BigDecimal.ZERO) : WageAccountReportDataSource.toCurrencyFormat(tempInsuranceContainer.baseratephi);
                    }
                } else {
                    priv_kv_basisab[i] = BigDecimalMapper.isZeroOrNull((BigDecimal)tempInsuranceContainer.baseratephi) ? WageAccountReportDataSource.toCurrencyFormat(BigDecimal.ZERO) : WageAccountReportDataSource.toCurrencyFormat(tempInsuranceContainer.baseratephi);
                }
                priv_kv_zuschuss[i] = (tempInsuranceContainer.privatehi ? "J" : "N") + " / " + WageAccountReportDataSource.toERAllowancePXIString(tempInsuranceContainer.erallowancephi);
                priv_pv_zuschuss[i] = (tempInsuranceContainer.privateni ? "J" : "N") + " / " + WageAccountReportDataSource.toERAllowancePXIString(tempInsuranceContainer.erallowancepni);
                switch (tempInsuranceContainer.contscalevhi) {
                    case 0: {
                        freiw_kv[i] = "keiner";
                        break;
                    }
                    case 1: {
                        freiw_kv[i] = "allgemein";
                        break;
                    }
                    case 2: {
                        freiw_kv[i] = "erh\u00f6ht";
                        break;
                    }
                    case 3: {
                        freiw_kv[i] = "erm\u00e4\u00dfigt";
                        break;
                    }
                    case 9: {
                        freiw_kv[i] = "individuell";
                    }
                }
                switch (tempInsuranceContainer.erallowancevhi) {
                    case 1: {
                        ag_zuschuss_fkv[i] = "halber";
                        break;
                    }
                    case 11: {
                        ag_zuschuss_fkv[i] = "BBG allgemein";
                        break;
                    }
                    case 12: {
                        ag_zuschuss_fkv[i] = "BBG erh\u00f6ht";
                        break;
                    }
                    case 13: {
                        ag_zuschuss_fkv[i] = "BBG erm\u00e4\u00dfigt";
                        break;
                    }
                    case 21: {
                        ag_zuschuss_fkv[i] = "tats. allgemein";
                        break;
                    }
                    case 22: {
                        ag_zuschuss_fkv[i] = "tats. erh\u00f6ht";
                        break;
                    }
                    case 23: {
                        ag_zuschuss_fkv[i] = "tats. erm\u00e4\u00dfigt";
                        break;
                    }
                    case 99: {
                        ag_zuschuss_fkv[i] = "keiner";
                    }
                }
                switch (tempInsuranceContainer.contscalevni) {
                    case 0: {
                        freiw_pv[i] = "keiner";
                        break;
                    }
                    case 1: {
                        freiw_pv[i] = "allgemein";
                        break;
                    }
                    case 2: {
                        freiw_pv[i] = "erh\u00f6ht";
                        break;
                    }
                    case 3: {
                        freiw_pv[i] = "erm\u00e4\u00dfigt";
                        break;
                    }
                    case 9: {
                        freiw_pv[i] = "individuell";
                    }
                }
                switch (tempInsuranceContainer.erallowancevni) {
                    case 1: {
                        ag_zuschuss_fpv[i] = "halber";
                        break;
                    }
                    case 2: {
                        ag_zuschuss_fpv[i] = "Bemessungsgr.";
                        break;
                    }
                    case 3: {
                        ag_zuschuss_fpv[i] = "tats\u00e4chlich";
                        break;
                    }
                    case 9: {
                        ag_zuschuss_fpv[i] = "keiner";
                    }
                }
                String string = beitragsher_bei_kug[i] = tempInsuranceContainer.decreaseofdues ? "Ja" : "Nein";
                if (!StringMapper.isNullString((String)tempInsuranceContainer.oidhealthfundkvdr)) {
                    kvdr_krankenkasse[i] = WageAccountReportDataSource.getHealthFundTP(tempInsuranceContainer.oidhealthfundkvdr, effectiveDate, endValidDate).getShortDescription();
                    if (tempInsuranceContainer.duesgrouphi == 0 && tempInsuranceContainer.duesgroupni == 0 && tempInsuranceContainer.duesgrouppi == 0 && tempInsuranceContainer.duesgroupui == 0) {
                        this.mKVDR = true;
                    }
                }
                beitragsober_vb[i] = WageAccountReportDataSource.toPrintFormat(tempInsuranceContainer.limitofdues);
                gesetz_rente[i] = WageAccountReportDataSource.toPrintFormat(tempInsuranceContainer.legalpension);
                berechnung_kv_pv[i] = Integer.toString(tempInsuranceContainer.choiseofdueshi) + " / " + Integer.toString(tempInsuranceContainer.choiseofduesni);
                betriebsrente[i] = !tempInsuranceContainer.isnopenspar229 ? "Ja" : "Nein";
                kennzeichen_mehrfachbezug[i] = WageAccountReportDataSource.toMultipleIncomeString(tempInsuranceContainer.multipleincome);
                kennzeichen_freibetrag[i] = WageAccountReportDataSource.toDemandOfFreeAmountString(tempInsuranceContainer.demandoffreeamount);
                hoehe_freibetrag[i] = WageAccountReportDataSource.toPrintFormat(tempInsuranceContainer.freeamount);
                if (!StringMapper.isNullString((String)tempInsuranceContainer.oidrecipient)) {
                    versorgungseinrichtung[i] = Recipient.getRecipient((String)tempInsuranceContainer.oidrecipient).getRecipientKey();
                    this.mVersorgung = tempInsuranceContainer.duesgrouppi == 0;
                } else {
                    versorgungseinrichtung[i] = "";
                }
                bv_mitgleids_nr[i] = tempInsuranceContainer.ppmembershipnumber;
                switch (tempInsuranceContainer.modeofcalculation) {
                    case 0: {
                        ag_zusch_versorg[i] = "tats\u00e4ch. Entgelt";
                        break;
                    }
                    case 1: {
                        ag_zusch_versorg[i] = "halber Beitrag";
                    }
                }
                gesamtbetrag[i] = tempInsuranceContainer.totaldues != null ? WageAccountReportDataSource.toCurrencyFormat(tempInsuranceContainer.totaldues) : "0,00";
                switch (tempInsuranceContainer.remittance) {
                    case 0: {
                        beitragsabfuehrung[i] = "Mitarbeiter";
                        break;
                    }
                    case 1: {
                        beitragsabfuehrung[i] = "Versorgungseinrich.";
                    }
                }
                regelmaessigesJAEGleitzone[i] = !BigDecimalMapper.isZeroOrNull((BigDecimal)tempInsuranceContainer.annualearningsglz) ? WageAccountReportDataSource.toCurrencyFormat(tempInsuranceContainer.annualearningsglz) : "0,00";
            }
            tempEndMonthDate = DateHelper.yesterday((Date)tempBeginMonthDate);
            tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        }
        if (this.mWithTransactionValues) {
            void var82_133;
            String[] ueberschriftBewegungswerte = WageAccountReportDataSource.createRow("0", "Bewegungswerte", true);
            vpAllList.add(ueberschriftBewegungswerte);
            tempEndMonthDate = endValidDate;
            tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
            vpHashMap = new HashMap();
            HashMap<String, ValuepositionContainer> sumHashMap = new HashMap<String, ValuepositionContainer>();
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            HashMap<String, ValuepositionContainer> hashMap2 = new HashMap<String, ValuepositionContainer>();
            int n = endYearIndex;
            while (var82_133 >= beginYearIndex) {
                Object valueTypeKey32;
                ValuepositionContainer sumValuePositionContainer2;
                HashMap<String, ValuepositionContainer> hashMap3 = new HashMap<String, ValuepositionContainer>();
                HashMap<String, ValuepositionContainer> valueTypeGroupToMonthMap = new HashMap<String, ValuepositionContainer>();
                for (ValuepositionContainer valuepositionContainer : vpList) {
                    boolean verdichtungAufWertartengruppe;
                    WageAccountValueTypeBean wageAccountValueTypeBean3;
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)tempBeginMonthDate) || valuepositionContainer.valuetypenumber >= 100000 || valuepositionContainer.valuetypenumber < 1 || !(wageAccountValueTypeBean3 = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype)).getMonthlyPayrollResult()) continue;
                    boolean bl = verdichtungAufWertartengruppe = wageAccountValueTypeBean3.getCompressionOnAccountOfMovement() == CompressionOnAccountOfMovementEnum.COAOME_Verdichtung_auf_Wertartengruppe;
                    if (verdichtungAufWertartengruppe) {
                        DesignationTP valueTypeGroupTP = this.getValueTypeGroupTP(wageAccountValueTypeBean3);
                        String valueTypeGroupKey = valueTypeGroupTP.getDesignation().getDesignation();
                        ValuepositionContainer tempValuePositionContainer3 = (ValuepositionContainer)valueTypeGroupToMonthMap.get(valueTypeGroupKey);
                        if (tempValuePositionContainer3 == null) {
                            valueTypeGroupToMonthMap.put(valueTypeGroupKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                        } else {
                            tempValuePositionContainer3.results = tempValuePositionContainer3.results.add(valuepositionContainer.results);
                        }
                        if (!wageAccountValueTypeBean3.getYearlyTotalPayrollResult()) continue;
                        ValuepositionContainer sumValuePositionContainer5 = (ValuepositionContainer)hashMap2.get(valueTypeGroupKey);
                        if (sumValuePositionContainer5 == null) {
                            hashMap2.put(valueTypeGroupKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                            continue;
                        }
                        sumValuePositionContainer5.results = sumValuePositionContainer5.results.add(valuepositionContainer.results);
                        continue;
                    }
                    String valueTypeKey2 = Integer.toString(valuepositionContainer.valuetypenumber);
                    ValuepositionContainer tempValuePositionContainer4 = (ValuepositionContainer)hashMap3.get(valueTypeKey2);
                    if (tempValuePositionContainer4 == null) {
                        hashMap3.put(valueTypeKey2, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                    } else {
                        tempValuePositionContainer4.results = tempValuePositionContainer4.results.add(valuepositionContainer.results);
                    }
                    if (!wageAccountValueTypeBean3.getYearlyTotalPayrollResult()) continue;
                    sumValuePositionContainer2 = (ValuepositionContainer)sumHashMap.get(valueTypeKey2);
                    if (sumValuePositionContainer2 == null) {
                        sumHashMap.put(valueTypeKey2, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                        continue;
                    }
                    sumValuePositionContainer2.results = sumValuePositionContainer2.results.add(valuepositionContainer.results);
                }
                ArrayList valueTypeKeys = new ArrayList(hashMap3.keySet());
                for (Object valueTypeKey32 : valueTypeKeys) {
                    ValuepositionContainer tempValuePositionContainer5 = (ValuepositionContainer)hashMap3.get(valueTypeKey32);
                    WageAccountValueTypeBean wageAccountValueTypeBean4 = WageAccountReportDataSource.getWageAccountValueTypeBean(tempValuePositionContainer5.oidvaluetype);
                    String[] vpArray4 = (String[])vpHashMap.get(valueTypeKey32);
                    if (vpArray4 == null) {
                        vpArray4 = WageAccountReportDataSource.createRow((String)valueTypeKey32, WageAccountReportDataSource.removeLeadingAsterisk(wageAccountValueTypeBean4.getShortDescription()));
                        vpHashMap.put(valueTypeKey32, vpArray4);
                    }
                    vpArray4[var82_133] = WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer5.results, "0,00");
                    ValuepositionContainer sumValuePositionContainer4 = (ValuepositionContainer)sumHashMap.get(valueTypeKey32);
                    if (sumValuePositionContainer4 == null) continue;
                    vpArray4[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer4.results, "");
                }
                ArrayList arrayList = new ArrayList(valueTypeGroupToMonthMap.keySet());
                valueTypeKey32 = arrayList.iterator();
                while (valueTypeKey32.hasNext()) {
                    String valueTypeGroupKey = (String)valueTypeKey32.next();
                    ValuepositionContainer tempValuePositionContainer6 = (ValuepositionContainer)valueTypeGroupToMonthMap.get(valueTypeGroupKey);
                    String[] vpArray2 = (String[])hashMap.get(valueTypeGroupKey);
                    if (vpArray2 == null) {
                        WageAccountValueTypeBean wageAccountValueTypeBean5 = WageAccountReportDataSource.getWageAccountValueTypeBean(tempValuePositionContainer6.oidvaluetype);
                        vpArray2 = WageAccountReportDataSource.createRow("!" + valueTypeGroupKey + "0", this.getValueTypeGroupTP(wageAccountValueTypeBean5).getShortDescription());
                        hashMap.put(valueTypeGroupKey, vpArray2);
                    }
                    vpArray2[var82_133] = WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer6.results, "0,00");
                    sumValuePositionContainer2 = (ValuepositionContainer)hashMap2.get(valueTypeGroupKey);
                    if (sumValuePositionContainer2 == null) continue;
                    vpArray2[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "");
                }
                tempEndMonthDate = DateHelper.yesterday((Date)tempBeginMonthDate);
                tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
                --var82_133;
            }
            ArrayList arrayList = new ArrayList(hashMap.keySet());
            Collections.sort(arrayList);
            for (Object valueTypeGroupKey : arrayList) {
                String[] vpArray3 = (String[])hashMap.get(valueTypeGroupKey);
                vpAllList.add(vpArray3);
            }
            ArrayList arrayList2 = new ArrayList(vpHashMap.keySet());
            Collections.sort(arrayList2);
            for (String valueTypeKey4 : arrayList2) {
                String[] stringArray = (String[])vpHashMap.get(valueTypeKey4);
                vpAllList.add(stringArray);
            }
            vpAllList.add(leerST);
        }
        vpAllList.add(ueberschriftBruttowerte);
        vpAllList.add(tag_der_lohnzahlung);
        vpAllList.add(lohnzahlungszeitraum);
        vpAllList.add(bundesland);
        vpAllList.add(kostenstelle);
        vpAllList.add(woechentliche_arbeitszeit);
        vpAllList.add(arbeitstage);
        tempEndMonthDate = endValidDate;
        tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        HashMap<String, ValuepositionContainer> sumHashMap = new HashMap<String, ValuepositionContainer>();
        vpHashMap = new HashMap();
        for (int i = endYearIndex; i >= beginYearIndex; --i) {
            HashMap<String, ValuepositionContainer> hashMap = new HashMap<String, ValuepositionContainer>();
            for (ValuepositionContainer valuepositionContainer : vpList) {
                if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)tempBeginMonthDate) || valuepositionContainer.valuetypenumber >= 200000 || valuepositionContainer.valuetypenumber < 100000) continue;
                String string = Integer.toString(valuepositionContainer.valuetypenumber);
                ValuepositionContainer tempValuePositionContainer7 = (ValuepositionContainer)hashMap.get(string);
                ValuepositionContainer sumValuePositionContainer3 = (ValuepositionContainer)sumHashMap.get(string);
                if (tempValuePositionContainer7 == null) {
                    hashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                } else {
                    tempValuePositionContainer7.results = tempValuePositionContainer7.results.add(valuepositionContainer.results);
                    tempValuePositionContainer7.factor1 = tempValuePositionContainer7.factor1.max(valuepositionContainer.factor1);
                    hashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(tempValuePositionContainer7));
                }
                if (sumValuePositionContainer3 == null) {
                    valuepositionContainer.category = i;
                    sumHashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                    continue;
                }
                sumValuePositionContainer3.results = sumValuePositionContainer3.results.add(valuepositionContainer.results);
                if (sumValuePositionContainer3.category != i) {
                    sumValuePositionContainer3.factor1 = sumValuePositionContainer3.factor1.add(valuepositionContainer.factor1);
                    sumValuePositionContainer3.category = i;
                }
                sumHashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(sumValuePositionContainer3));
            }
            tempList = new ArrayList(hashMap.keySet());
            for (String string : tempList) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)hashMap.get(string);
                ValuepositionContainer sumValuePositionContainer2 = (ValuepositionContainer)sumHashMap.get(string);
                vpArray = (String[])vpHashMap.get(Integer.toString(valuepositionContainer.valuetypenumber));
                WageAccountValueTypeBean wageAccountValueTypeBean = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype);
                if (vpArray == null) {
                    vpArray = WageAccountReportDataSource.createRow(wageAccountValueTypeBean);
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                        if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                            vpArray[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer2.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer2.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "0,00");
                        }
                    }
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1, "0,00");
                        vpArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer2.factor1, "0,00");
                    }
                    if (!wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                        vpArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "0,00");
                    }
                    vpHashMap.put(Integer.toString(valuepositionContainer.valuetypenumber), vpArray);
                    continue;
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                    vpArray[i] = !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer2.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer2.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "0,00");
                    }
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                    vpArray[i] = WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1, "0,00");
                    vpArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer2.factor1, "0,00");
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() || !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) continue;
                vpArray[i] = WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                vpArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer2.results, "0,00");
            }
            tempEndMonthDate = DateHelper.yesterday((Date)tempBeginMonthDate);
            tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        }
        tempList = new ArrayList(vpHashMap.keySet());
        Collections.sort(tempList);
        for (String string : tempList) {
            String[] stringArray = (String[])vpHashMap.get(string);
            vpAllList.add(stringArray);
        }
        vpAllList.add(leerST);
        vpAllList.add(ueberschriftSteuerwerte);
        vpAllList.add(steuerklasse);
        vpAllList.add(zkf);
        vpAllList.add(frei_hinzu_betrag_jahr);
        vpAllList.add(frei_hinzu_betrag_monat);
        vpAllList.add(steuerpflicht);
        vpAllList.add(lohnsteuerjahresausgleich);
        vpAllList.add(kirchensteuer);
        if (this.mBL_Bremen_Saarland) {
            vpAllList.add(kammerbeitrag);
        }
        vpAllList.add(monatsverdienst);
        if (this.mVersorgungsbezug) {
            vpAllList.add(versorgungsbezug);
            vpAllList.add(versorgungsbeginn);
            vpAllList.add(vbz_sonderz);
        }
        tempEndMonthDate = endValidDate;
        tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        vpHashMap = new HashMap();
        for (int i = endYearIndex; i >= beginYearIndex; --i) {
            HashMap<String, ValuepositionContainer> hashMap = new HashMap<String, ValuepositionContainer>();
            for (ValuepositionContainer valuepositionContainer : vpList) {
                WageAccountValueTypeBean wageAccountValueTypeBean = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype);
                if (!wageAccountValueTypeBean.getMonthlyPayrollResult() || !DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)tempBeginMonthDate) || valuepositionContainer.valuetypenumber >= 300000 || valuepositionContainer.valuetypenumber < 200000) continue;
                valueTypeKey = Integer.toString(valuepositionContainer.valuetypenumber);
                tempValuePositionContainer = (ValuepositionContainer)hashMap.get(valueTypeKey);
                ValuepositionContainer valuepositionContainer2 = (ValuepositionContainer)sumHashMap.get(valueTypeKey);
                if (tempValuePositionContainer == null) {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)valuepositionContainer.results) && !BigDecimalMapper.isZeroOrNull((BigDecimal)valuepositionContainer.percentage)) {
                        tempValuePositionContainer = WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer);
                        tempValuePositionContainer.results = tempValuePositionContainer.percentage;
                        hashMap.put(valueTypeKey, tempValuePositionContainer);
                    } else {
                        hashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                    }
                } else if (BigDecimalMapper.isZeroOrNull((BigDecimal)valuepositionContainer.results) && !BigDecimalMapper.isZeroOrNull((BigDecimal)valuepositionContainer.percentage)) {
                    tempValuePositionContainer.results = tempValuePositionContainer.results.add(valuepositionContainer.percentage);
                    tempValuePositionContainer.factor1 = tempValuePositionContainer.factor1.max(valuepositionContainer.factor1);
                    hashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(tempValuePositionContainer));
                } else {
                    tempValuePositionContainer.results = tempValuePositionContainer.results.add(valuepositionContainer.results);
                    tempValuePositionContainer.factor1 = tempValuePositionContainer.factor1.max(valuepositionContainer.factor1);
                    hashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(tempValuePositionContainer));
                }
                if (valuepositionContainer2 == null) {
                    valuepositionContainer.category = i;
                    sumHashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                    continue;
                }
                valuepositionContainer2.results = valuepositionContainer2.results.add(valuepositionContainer.results);
                if (valuepositionContainer2.category != i) {
                    valuepositionContainer2.factor1 = valuepositionContainer2.factor1.add(valuepositionContainer.factor1);
                    valuepositionContainer2.category = i;
                }
                sumHashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer2));
            }
            tempList = new ArrayList(hashMap.keySet());
            for (String string : tempList) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)hashMap.get(string);
                sumValuePositionContainer = (ValuepositionContainer)sumHashMap.get(string);
                vpArray = (String[])vpHashMap.get(Integer.toString(valuepositionContainer.valuetypenumber));
                WageAccountValueTypeBean wageAccountValueTypeBean = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype);
                if (vpArray == null) {
                    vpArray = WageAccountReportDataSource.createRow(wageAccountValueTypeBean);
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                        if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                            vpArray[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
                        }
                    }
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1, "0,00");
                        vpArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1, "0,00");
                    }
                    if (!wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                        vpArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
                    }
                    vpHashMap.put(Integer.toString(valuepositionContainer.valuetypenumber), vpArray);
                    continue;
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                    vpArray[i] = !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
                    }
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                    vpArray[i] = WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1, "0,00");
                    vpArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1, "0,00");
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() || !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) continue;
                vpArray[i] = WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results, "0,00");
                vpArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
            }
            tempEndMonthDate = DateHelper.yesterday((Date)tempBeginMonthDate);
            tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        }
        tempList = new ArrayList(vpHashMap.keySet());
        Collections.sort(tempList);
        for (String string : tempList) {
            String[] stringArray = (String[])vpHashMap.get(string);
            vpAllList.add(stringArray);
        }
        vpAllList.add(leerSV);
        vpAllList.add(ueberschriftSozialversicherungswerte);
        vpAllList.add(pgs_staat);
        vpAllList.add(taetigkeitsschluessel);
        vpAllList.add(rentenart);
        vpAllList.add(betriebsnummer);
        vpAllList.add(bes_sv_merkmal);
        vpAllList.add(bgs);
        vpAllList.add(krankenkasse);
        vpAllList.add(rechtskreis_rv_av);
        vpAllList.add(umlagepflicht);
        vpAllList.add(umlagekasse);
        vpAllList.add(verzicht_rv_reduzierung);
        vpAllList.add(befrei_av_aga);
        vpAllList.add(elterneigenschaft_abschlag);
        vpAllList.add(mehrfachbeschaeftigung);
        vpAllList.add(rvRehab);
        vpAllList.add(bgs_anderer_ag);
        if (this.mPrivatFreiwilligKVPV && !this.mKVDR) {
            vpAllList.add(priv_kv_basisab);
            vpAllList.add(priv_kv_zuschuss);
            vpAllList.add(priv_pv_zuschuss);
            vpAllList.add(freiw_kv);
            vpAllList.add(ag_zuschuss_fkv);
            vpAllList.add(freiw_pv);
            vpAllList.add(ag_zuschuss_fpv);
            vpAllList.add(beitragsher_bei_kug);
        }
        if (this.mKVDR) {
            vpAllList.add(kvdr_krankenkasse);
            vpAllList.add(beitragsober_vb);
            vpAllList.add(gesetz_rente);
            vpAllList.add(berechnung_kv_pv);
            vpAllList.add(betriebsrente);
            vpAllList.add(kennzeichen_mehrfachbezug);
            vpAllList.add(kennzeichen_freibetrag);
            vpAllList.add(hoehe_freibetrag);
        }
        vpAllList.add(elterneigenschaft_pv);
        if (this.mGleitzone) {
            vpAllList.add(regelmaessigesJAEGleitzone);
        }
        if (this.mVersorgung) {
            vpAllList.add(versorgungseinrichtung);
            vpAllList.add(bv_mitgleids_nr);
            vpAllList.add(ag_zusch_versorg);
            vpAllList.add(gesamtbetrag);
            vpAllList.add(beitragsabfuehrung);
        }
        tempEndMonthDate = endValidDate;
        tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        vpHashMap = new HashMap();
        for (int i = endYearIndex; i >= beginYearIndex; --i) {
            HashMap<String, ValuepositionContainer> hashMap = new HashMap<String, ValuepositionContainer>();
            for (ValuepositionContainer valuepositionContainer : vpList) {
                WageAccountValueTypeBean wageAccountValueTypeBean = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype);
                if (!wageAccountValueTypeBean.getMonthlyPayrollResult() || !DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)tempBeginMonthDate) || valuepositionContainer.valuetypenumber >= 700000 || valuepositionContainer.valuetypenumber < 300000) continue;
                valueTypeKey = Integer.toString(valuepositionContainer.valuetypenumber);
                tempValuePositionContainer = (ValuepositionContainer)hashMap.get(valueTypeKey);
                ValuepositionContainer valuepositionContainer3 = (ValuepositionContainer)sumHashMap.get(valueTypeKey);
                if (tempValuePositionContainer == null) {
                    hashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                } else {
                    tempValuePositionContainer.results = tempValuePositionContainer.results.add(valuepositionContainer.results);
                    tempValuePositionContainer.factor1 = tempValuePositionContainer.factor1.max(valuepositionContainer.factor1);
                    hashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(tempValuePositionContainer));
                }
                if (valuepositionContainer3 == null) {
                    valuepositionContainer.category = i;
                    sumHashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                    continue;
                }
                valuepositionContainer3.results = valuepositionContainer3.results.add(valuepositionContainer.results);
                if (valuepositionContainer3.category != i) {
                    valuepositionContainer3.factor1 = valuepositionContainer3.factor1.add(valuepositionContainer.factor1);
                    valuepositionContainer3.category = i;
                }
                sumHashMap.put(valueTypeKey, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer3));
            }
            tempList = new ArrayList(hashMap.keySet());
            for (String string : tempList) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)hashMap.get(string);
                sumValuePositionContainer = (ValuepositionContainer)sumHashMap.get(string);
                vpArray = (String[])vpHashMap.get(Integer.toString(valuepositionContainer.valuetypenumber));
                WageAccountValueTypeBean wageAccountValueTypeBean = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype);
                BigDecimal bigDecimal = valuepositionContainer.percentage = valuepositionContainer.percentage == null ? BigDecimal.ZERO.setScale(4) : valuepositionContainer.percentage;
                if (vpArray == null) {
                    vpArray = WageAccountReportDataSource.createRow(wageAccountValueTypeBean);
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.results) ? (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) || !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? "0,00/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toPrintFormat(valuepositionContainer.percentage)) : "0,00") : (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) || !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results) + "/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results) + "/" + WageAccountReportDataSource.toPrintFormat(valuepositionContainer.percentage)) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results));
                        if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                            vpArray[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
                        }
                    }
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1, "0,00");
                        vpArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1, "0,00");
                    }
                    if (!wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[i] = BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.results) ? "0,00" : (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.percentage) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results) + "/" + WageAccountReportDataSource.toPrintFormat(valuepositionContainer.percentage) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results));
                        vpArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
                    }
                    vpHashMap.put(Integer.toString(valuepositionContainer.valuetypenumber), vpArray);
                    continue;
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                    vpArray[i] = BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.results) ? (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) || !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? "0,00/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toPrintFormat(valuepositionContainer.percentage)) : "0,00") : (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) || !BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results) + "/" + WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results) + "/" + WageAccountReportDataSource.toPrintFormat(valuepositionContainer.percentage)) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results));
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        vpArray[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
                    }
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                    vpArray[i] = WageAccountReportDataSource.toFactor1Format(valuepositionContainer.factor1, "0,00");
                    vpArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer.factor1, "0,00");
                }
                if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() || !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) continue;
                vpArray[i] = BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.results) ? "0,00" : (!BigDecimalMapper.isZero((BigDecimal)valuepositionContainer.percentage) ? WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results) + "/" + WageAccountReportDataSource.toPrintFormat(valuepositionContainer.percentage) : WageAccountReportDataSource.toCurrencyFormat(valuepositionContainer.results));
                vpArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer.results, "0,00");
            }
            tempEndMonthDate = DateHelper.yesterday((Date)tempBeginMonthDate);
            tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        }
        tempList = new ArrayList(vpHashMap.keySet());
        Collections.sort(tempList);
        for (String string : tempList) {
            String[] stringArray = (String[])vpHashMap.get(string);
            vpAllList.add(stringArray);
        }
        vpAllList.add(leerNetto);
        vpAllList.add(ueberschriftNettowerte);
        List<Integer> pfaendungsnettoWertarten = Arrays.asList(795110, 795115, 795120, 795130, 795140);
        tempEndMonthDate = DateHelper.getLastDayOfYear((Date)endValidDate);
        tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
        vpHashMap = new HashMap();
        int n = 13;
        while (var80_107 >= 2) {
            HashMap<String, ValuepositionContainer> hashMap = new HashMap<String, ValuepositionContainer>();
            for (ValuepositionContainer valuepositionContainer : vpList) {
                WageAccountValueTypeBean wageAccountValueTypeBean6;
                int valueTypeNumber = valuepositionContainer.valuetypenumber;
                if ((var80_107 < beginYearIndex || var80_107 > endYearIndex || !DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)tempBeginMonthDate) || valueTypeNumber >= 890000 || valueTypeNumber < 700000) && (!DateHelper.beforeOrEqual((Date)valuepositionContainer.effectivefrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.effectiveuntil, (Date)tempBeginMonthDate) || !DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)tempEndMonthDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)tempBeginMonthDate) || valueTypeNumber != 890000 && valueTypeNumber != 890100) || !(wageAccountValueTypeBean6 = WageAccountReportDataSource.getWageAccountValueTypeBean(valuepositionContainer.oidvaluetype)).getMonthlyPayrollResult()) continue;
                String string = Integer.toString(valueTypeNumber);
                ValuepositionContainer tempValuePositionContainer8 = (ValuepositionContainer)hashMap.get(string);
                ValuepositionContainer sumValuePositionContainer6 = (ValuepositionContainer)sumHashMap.get(string);
                boolean summeMussErzeugtWerden = true;
                if (tempValuePositionContainer8 == null) {
                    hashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                } else if (pfaendungsnettoWertarten.contains(valueTypeNumber)) {
                    summeMussErzeugtWerden = false;
                } else {
                    tempValuePositionContainer8.results = tempValuePositionContainer8.results.add(valuepositionContainer.results);
                    tempValuePositionContainer8.factor1 = tempValuePositionContainer8.factor1.max(valuepositionContainer.factor1);
                    hashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(tempValuePositionContainer8));
                }
                if (!summeMussErzeugtWerden) continue;
                if (sumValuePositionContainer6 == null) {
                    valuepositionContainer.category = var80_107;
                    sumHashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(valuepositionContainer));
                    continue;
                }
                sumValuePositionContainer6.results = sumValuePositionContainer6.results.add(valuepositionContainer.results);
                if (sumValuePositionContainer6.category != var80_107) {
                    sumValuePositionContainer6.factor1 = sumValuePositionContainer6.factor1.add(valuepositionContainer.factor1);
                    sumValuePositionContainer6.category = var80_107;
                }
                sumHashMap.put(string, WageAccountReportDataSource.cloneValuepositionContainer(sumValuePositionContainer6));
            }
            tempList = new ArrayList(hashMap.keySet());
            for (String string : tempList) {
                void var86_197;
                ValuepositionContainer tempValuePositionContainer9 = (ValuepositionContainer)hashMap.get(string);
                ValuepositionContainer sumValuePositionContainer3 = (ValuepositionContainer)sumHashMap.get(string);
                String[] stringArray = (String[])vpHashMap.get(Integer.toString(tempValuePositionContainer9.valuetypenumber));
                WageAccountValueTypeBean wageAccountValueTypeBean = WageAccountReportDataSource.getWageAccountValueTypeBean(tempValuePositionContainer9.oidvaluetype);
                BigDecimal bigDecimal = tempValuePositionContainer9.percentage = tempValuePositionContainer9.percentage == null ? BigDecimal.ZERO.setScale(4) : tempValuePositionContainer9.percentage;
                if (stringArray == null) {
                    String[] stringArray2 = WageAccountReportDataSource.createRow(wageAccountValueTypeBean);
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        stringArray2[var80_107] = BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.results) ? (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) || !BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) ? "0,00/" + WageAccountReportDataSource.toFactor1Format(tempValuePositionContainer9.factor1) : WageAccountReportDataSource.toPrintFormat(tempValuePositionContainer9.percentage)) : "0,00") : (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) || !BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) ? WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results) + "/" + WageAccountReportDataSource.toFactor1Format(tempValuePositionContainer9.factor1) : WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results) + "/" + WageAccountReportDataSource.toPrintFormat(tempValuePositionContainer9.percentage)) : WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results));
                        if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                            stringArray2[1] = !BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer3.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer3.results, "0,00") + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer3.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer3.results, "0,00");
                        }
                    }
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        stringArray2[var80_107] = WageAccountReportDataSource.toFactor1Format(tempValuePositionContainer9.factor1, "0,00");
                        stringArray2[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer3.factor1, "0,00");
                    }
                    if (!wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        stringArray2[var80_107] = BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.results) ? "0,00" : (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.percentage) ? WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results) + "/" + WageAccountReportDataSource.toPrintFormat(tempValuePositionContainer9.percentage) : WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results));
                        stringArray2[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer3.results, "0,00");
                    }
                    vpHashMap.put(Integer.toString(tempValuePositionContainer9.valuetypenumber), stringArray2);
                } else {
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult() || !wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        stringArray[var80_107] = BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.results) ? (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) || !BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) ? "0,00/" + WageAccountReportDataSource.toFactor1Format(tempValuePositionContainer9.factor1) : WageAccountReportDataSource.toPrintFormat(tempValuePositionContainer9.percentage)) : "0,00") : (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) || !BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.percentage) ? (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.factor1) ? WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results) + "/" + WageAccountReportDataSource.toFactor1Format(tempValuePositionContainer9.factor1) : WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results) + "/" + WageAccountReportDataSource.toPrintFormat(tempValuePositionContainer9.percentage)) : WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results));
                        if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                            stringArray[1] = BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer3.results) ? (!BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer3.factor1) ? "0,00/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer3.factor1) : "0,00") : (!BigDecimalMapper.isZero((BigDecimal)sumValuePositionContainer3.factor1) ? WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer3.results) + "/" + WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer3.factor1) : WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer3.results));
                        }
                    }
                    if (wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && !wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        stringArray[var80_107] = WageAccountReportDataSource.toFactor1Format(tempValuePositionContainer9.factor1, "0,00");
                        stringArray[1] = WageAccountReportDataSource.toFactor1Format(sumValuePositionContainer3.factor1, "0,00");
                    }
                    if (!wageAccountValueTypeBean.getYearlyTotalPayrollFactor1() && wageAccountValueTypeBean.getYearlyTotalPayrollResult()) {
                        stringArray[var80_107] = BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.results) ? "0,00" : (!BigDecimalMapper.isZero((BigDecimal)tempValuePositionContainer9.percentage) ? WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results) + "/" + WageAccountReportDataSource.toPrintFormat(tempValuePositionContainer9.percentage) : WageAccountReportDataSource.toCurrencyFormat(tempValuePositionContainer9.results));
                        stringArray[1] = WageAccountReportDataSource.toCurrencyFormat(sumValuePositionContainer3.results, "0,00");
                    }
                }
                if (!"890100".equals(var86_197[15]) && !"880000".equals(var86_197[15])) continue;
                var86_197[1] = "";
            }
            tempEndMonthDate = DateHelper.yesterday((Date)tempBeginMonthDate);
            tempBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)tempEndMonthDate);
            --var80_107;
        }
        tempList = new ArrayList(vpHashMap.keySet());
        Collections.sort(tempList);
        for (String string : tempList) {
            String[] stringArray = (String[])vpHashMap.get(string);
            vpAllList.add(stringArray);
        }
        return vpAllList;
    }

    private static String toERAllowancePXIString(int erAllowancePXI) {
        switch (erAllowancePXI) {
            case 1: {
                return "tats\u00e4chliches Entgelt";
            }
            case 2: {
                return "Bemessungsgrenze";
            }
            case 9: {
                return "kein Beitrag";
            }
        }
        return "";
    }

    private static String toMultipleIncomeString(int multipleIncome) {
        switch (multipleIncome) {
            case 1: {
                return "Nein";
            }
            case 2: {
                return "Ja";
            }
            case 3: {
                return "Ja (Geringbez.)";
            }
        }
        return "";
    }

    private static String toDemandOfFreeAmountString(int demandOfFreeAmount) {
        switch (demandOfFreeAmount) {
            case 1: {
                return "Nein";
            }
            case 2: {
                return "Ja";
            }
            case 3: {
                return "Anteilig";
            }
        }
        return "";
    }

    private static String[] createRow(WageAccountValueTypeBean wageAccountValueTypeBean) {
        return WageAccountReportDataSource.createRow(wageAccountValueTypeBean.getValueTypeKey(), WageAccountReportDataSource.removeLeadingAsterisk(wageAccountValueTypeBean.getShortDescription()));
    }

    private static String[] createRow(String key, String text) {
        return WageAccountReportDataSource.createRow(key, text, false);
    }

    private static String[] createRow(String key, String text, boolean bold) {
        String[] row = new String[16];
        row[0] = text;
        row[14] = bold ? "bold" : "normal";
        row[15] = key;
        return row;
    }

    private DesignationTP getValueTypeGroupTP(WageAccountValueTypeBean wageAccountValueTypeBean) {
        Designation designation = wageAccountValueTypeBean.getValueTypeGroup();
        if (designation == null) {
            throw new IllegalArgumentException("Anwenderwertart " + wageAccountValueTypeBean.getValueTypeKey() + " hat keine Wertartgruppe, soll aber auf Wertartgruppe verdichtet werden.");
        }
        String oidValueTypeGroup = designation.getObjectid();
        DesignationTP valueTypeGroupTP = this.mValueTypeGroupTPMap.get(oidValueTypeGroup);
        if (valueTypeGroupTP == null) {
            Designation valueTypeGroup = Designation.getDesignation((String)oidValueTypeGroup, (TypeOfDesignationEnum)TypeOfDesignationEnum.TODE_VALUETYPEGROUP);
            valueTypeGroupTP = valueTypeGroup.getActiveDesignationTP();
            this.mValueTypeGroupTPMap.put(oidValueTypeGroup, valueTypeGroupTP);
        }
        return valueTypeGroupTP;
    }

    private static String removeLeadingAsterisk(String string) {
        return string.substring(0, 1).equals("*") ? string.substring(1).trim() : string;
    }

    private static String toCurrencyFormat(BigDecimal bigDecimal, String zeroValue) {
        return BigDecimalMapper.isZero((BigDecimal)bigDecimal) ? zeroValue : WageAccountReportDataSource.toCurrencyFormat(bigDecimal);
    }

    private static String toCurrencyFormat(BigDecimal bigDecimal) {
        String str = BigDecimalMapper.toString((BigDecimal)bigDecimal);
        Object temp = str;
        int length = ((String)temp).length();
        if (length > 0) {
            String temp2;
            String temp1;
            if (((String)temp).substring(0, 1).equals("-")) {
                --length;
            }
            if (length < 7) {
                temp = ((String)temp).replace('.', ',');
            }
            if (length >= 7 && length < 10) {
                temp = ((String)temp).replace('.', ',');
                temp1 = ((String)temp).substring(0, ((String)temp).length() - 6);
                temp2 = ((String)temp).substring(((String)temp).length() - 6, ((String)temp).length());
                temp = temp1 + "." + temp2;
            }
            if (length >= 10) {
                temp = ((String)temp).replace('.', ',');
                temp1 = ((String)temp).substring(0, ((String)temp).length() - 9);
                temp2 = ((String)temp).substring(((String)temp).length() - 9, ((String)temp).length() - 6);
                String temp3 = ((String)temp).substring(((String)temp).length() - 6, ((String)temp).length());
                temp = temp1 + "." + temp2 + "." + temp3;
            }
        }
        return temp;
    }

    private static String toFactor1Format(BigDecimal factor1, String zeroValue) {
        return BigDecimalMapper.isZero((BigDecimal)factor1) ? zeroValue : WageAccountReportDataSource.toFactor1Format(factor1);
    }

    private static String toFactor1Format(BigDecimal factor1) {
        return WageAccountReportDataSource.toPrintFormat(factor1).substring(0, BigDecimalMapper.toString((BigDecimal)factor1).length() - 2);
    }

    private static String toPrintFormat(BigDecimal bigDecimal) {
        return BigDecimalMapper.toString((BigDecimal)bigDecimal).replace('.', ',');
    }

    private static String toPrintFormat(BigDecimal bigDecimal, int scale) {
        return WageAccountReportDataSource.toPrintFormat(bigDecimal.setScale(scale, RoundingMode.HALF_UP));
    }

    private static HealthFundTP getHealthFundTP(String healthFundOid, Date effectiveDate, Date validDate) throws BusinessDomainException {
        HealthFund eeHealthFund = HealthFundPersistencyManager.getHealthFund((String)healthFundOid);
        return eeHealthFund.getHealthFundTP(effectiveDate, validDate);
    }

    private CostCenter getCostCenter(String costCenterOid) {
        CostCenter costCenter = this.mCostCenterMap.get(costCenterOid);
        if (costCenter == null) {
            costCenter = CostCenter.getCostCenter((String)costCenterOid);
            this.mCostCenterMap.put(costCenterOid, costCenter);
        }
        return costCenter;
    }

    private DesignationTP getEmployeeCircle(String oidEmployeeCircle, Date effectiveDate, Date validDate) throws BusinessDomainException {
        Key employeeCircleKey = new Key(oidEmployeeCircle, effectiveDate, validDate);
        DesignationTP designationTP = this.mEmployeeCircleHashMap.get(employeeCircleKey);
        if (designationTP == null) {
            designationTP = Designation.getDesignation((String)oidEmployeeCircle, (TypeOfDesignationEnum)TypeOfDesignationEnum.TODE_EMPLOYEECIRCLE).getDesignationTP(effectiveDate, validDate);
            this.mEmployeeCircleHashMap.put(employeeCircleKey, designationTP);
        }
        return designationTP;
    }

    private static PCompany getPCompany(String pCompanyOid) {
        PCompany eePCompany = PCompanyPersistencyManager.getPCompany((String)pCompanyOid);
        return eePCompany;
    }

    private static PlantFoundations getPlantFoundations(String plantOid, Date effectiveDate, Date validDate) throws BusinessDomainException {
        Plant plant = WageAccountReportDataSource.getPlant(plantOid);
        PlantFoundations eePlantFoundations = plant.getPlantFoundations(effectiveDate, validDate);
        return eePlantFoundations;
    }

    private static Plant getPlant(String plantOid) {
        Plant eePlant = plantPersistencyManager.getPlant(plantOid);
        return eePlant;
    }

    private static StateTP getStateTP(String oidNationality, Date effectiveDate, Date validDate) throws BusinessDomainException {
        StateTP stateTP = StatePersistencyManager.getState((String)oidNationality).getStateTP(effectiveDate, validDate);
        return stateTP;
    }

    private static TaxOfficeTP getTaxOfficeTP(String oidTaxOffice, Date effectiveDate, Date validDate) throws BusinessDomainException {
        TaxOfficeTP taxOfficeTP = TaxOfficePersistencyManager.getTaxOffice((String)oidTaxOffice).getTaxOfficeTP(effectiveDate, validDate);
        return taxOfficeTP;
    }

    private static CommunityTP getCommunityTP(String oidCommunity, Date effectiveDate, Date validDate) throws BusinessDomainException {
        CommunityTP communityTP = CommunityPersistencyManager.getCommunity((String)oidCommunity).getCommunityTP(effectiveDate, validDate);
        return communityTP;
    }

    private static FederalStateTP getFederalStateTP(String oidFederalState, Date effectiveDate, Date validDate) throws BusinessDomainException {
        FederalStateTP federalStateTP = FederalStatePersistencyManager.getFederalState((String)oidFederalState).getFederalStateTP(effectiveDate, validDate);
        return federalStateTP;
    }

    private OccupationGroupTP getOccupationGroupTP(String oidOccupationGroup, Date effectiveDate, Date validDate) throws BusinessDomainException {
        Key occupationGroupTPKey = new Key(oidOccupationGroup, effectiveDate, validDate);
        OccupationGroupTP occupationGroupTP = this.mOccGroupHashMap.get(occupationGroupTPKey);
        if (occupationGroupTP == null) {
            occupationGroupTP = OccupationGroup.getOccupationGroup((String)oidOccupationGroup).getOccupationGroupTP(effectiveDate, validDate);
            this.mOccGroupHashMap.put(occupationGroupTPKey, occupationGroupTP);
        }
        return occupationGroupTP;
    }

    private OccupationTP getOccupationTP(String oidOccupation, Date effectiveDate, Date validDate) throws BusinessDomainException {
        Key occupationTPKey = new Key(oidOccupation, effectiveDate, validDate);
        OccupationTP occupationTP = this.mOccupationHashMap.get(occupationTPKey);
        if (occupationTP == null) {
            occupationTP = Occupation.getOccupation((String)oidOccupation).getOccupationTP(effectiveDate, validDate);
            this.mOccupationHashMap.put(occupationTPKey, occupationTP);
        }
        return occupationTP;
    }

    private OccupationLongTP getOccupationLongTP(String oidOccupationLong, Date effectiveDate, Date validDate) throws BusinessDomainException {
        Key occupationLongTPKey = new Key(oidOccupationLong, effectiveDate, validDate);
        OccupationLongTP occupationLongTP = this.mOccupationLongHashMap.get(occupationLongTPKey);
        if (occupationLongTP == null) {
            occupationLongTP = OccupationLong.getOccupationLong((String)oidOccupationLong).getOccupationLongTP(effectiveDate, validDate);
            this.mOccupationLongHashMap.put(occupationLongTPKey, occupationLongTP);
        }
        return occupationLongTP;
    }

    private static MasterallContainer getMasterall(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            PersistencyDataSet masterDatas = daoMasterall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            return (MasterallContainer)masterDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static InsuranceContainer getInsurance(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            PersistencyDataSet insuranceDatas = daoInsurance.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            return (InsuranceContainer)insuranceDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static InsuranceHIPIYearTP getInsuranceHIPIYearTP(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            InsuranceHIPIYearTP insuranceHIPIYearTP = null;
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)});
            InsuranceHIPIYearTP[] insuranceHIPIYearTPs = InsuranceHIPIYearTPPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true);
            if (insuranceHIPIYearTPs != null && insuranceHIPIYearTPs.length > 0) {
                insuranceHIPIYearTP = insuranceHIPIYearTPs[0];
            }
            return insuranceHIPIYearTP;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static String getEmployerNumber(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            CompanyEmploymentOffice CompanyEmploymentOffice2;
            Plant plant;
            Employment employment = WageAccountReportDataSource.getIEmployeePM().getEmployee(oidEmployee).getEmployment(effectiveDate, validDate);
            String result = "";
            PlantPlace plantPlace = employment.getPlantPlace();
            if (plantPlace != null) {
                result = plantPlace.getStandardCompanyNumber();
            }
            if (result.equals("") && (plant = employment.getPlant()) != null) {
                PlantEmploymentOffice plantEmploymentOffice = null;
                try {
                    plantEmploymentOffice = plant.getPlantEmploymentOffice(effectiveDate, validDate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (plantEmploymentOffice != null) {
                    result = plantEmploymentOffice.getGeneralEmploymentOffice().getEmployerNumber();
                }
            }
            if (result.equals("") && (CompanyEmploymentOffice2 = WageAccountReportDataSource.getIEmployeePM().getEmployee(oidEmployee).getPCompany().getCompanyEmploymentOffice(effectiveDate, validDate)) != null) {
                result = CompanyEmploymentOffice2.getGeneralEmploymentOffice().getEmployerNumber();
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static TaxContainer getTax(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            PersistencyDataSet taxDatas = daoTax.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            return (TaxContainer)taxDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static EmploymentContainer getEmployment(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            PersistencyDataSet employmentDatas = daoEmployment.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            return (EmploymentContainer)employmentDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static Date getDateOfEntry(Date effectiveDate, Date validDate, String oidEmployee) {
        Date dateOfEntry = null;
        try {
            Date firstDayOfYear = DateHelper.getFirstDayOfYear((Date)validDate);
            Date lastDayOfYear = DateHelper.getLastDayOfYear((Date)validDate);
            PersistencyDataSet employmentDatas = daoEmployment.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)lastDayOfYear)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)firstDayOfYear)), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (employmentDatas.hasNext()) {
                EmploymentContainer employmentContainer = (EmploymentContainer)employmentDatas.getNext();
                if (employmentContainer.dateofentry == null) continue;
                if (employmentContainer.dateofwithdrawal == null) {
                    employmentContainer.dateofwithdrawal = lastDayOfYear;
                }
                if (!DateHelper.between((Date)employmentContainer.dateofentry, (Date)firstDayOfYear, (Date)lastDayOfYear) && !DateHelper.between((Date)employmentContainer.dateofwithdrawal, (Date)firstDayOfYear, (Date)lastDayOfYear) || dateOfEntry != null && !DateHelper.before((Date)employmentContainer.dateofentry, (Date)dateOfEntry)) continue;
                dateOfEntry = employmentContainer.dateofentry;
            }
            if (dateOfEntry == null) {
                dateOfEntry = firstDayOfYear;
            }
            return dateOfEntry;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static Date getOldPersonnelNumberUntil(Date effectiveDate, Date validDate, String oidEmployee, String oldPersonnelNumber) {
        Date validUntil = null;
        try {
            PersistencyDataSet employmentDatas = daoEmployment.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"personnelnumberold", (String)oldPersonnelNumber)}));
            while (employmentDatas.hasNext()) {
                EmploymentContainer employmentContainer = (EmploymentContainer)employmentDatas.getNext();
                validUntil = DateHelper.yesterday((Date)employmentContainer.validfrom);
            }
            return validUntil;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<ValuepositionContainer> getValuePositions(Date effectiveDate, Date beginValidDate, Date endValidDate, String currentOidEmployee) {
        ArrayList<ValuepositionContainer> vpList = new ArrayList<ValuepositionContainer>();
        try {
            List arrayList = ReportHelper.createArrayListByMaxNumbers((String[])this.mOidValueTypes, (int)500);
            for (String[] selecteds : arrayList) {
                PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"valuetypenumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidvaluetype", (String[])selecteds), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endValidDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)beginValidDate)), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
                while (valuePositionDatas.hasNext()) {
                    ValuepositionContainer container = (ValuepositionContainer)valuePositionDatas.getNext();
                    if (container.valuetypenumber >= 890000) continue;
                    vpList.add(container);
                }
            }
            vpList.addAll(WageAccountReportDataSource.getNetPays(beginValidDate, endValidDate, currentOidEmployee));
            return vpList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static List<ValuepositionContainer> getNetPays(Date beginYearDate, Date endYearDate, String currentOidEmployee) {
        ArrayList<ValuepositionContainer> vpList = new ArrayList<ValuepositionContainer>();
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)endYearDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)beginYearDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)endYearDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)beginYearDate))), Restrictions.in((String)"valuetypenumber", (String[])new String[]{"890000", "890100"}), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
            while (valuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuePositionDatas.getNext();
                vpList.add(container);
            }
            return vpList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static List<EmploymentContainer> getEntries(Date effectiveDate, Date beginYearDate, Date endYearDate, String currentOidEmployee) {
        ArrayList<EmploymentContainer> entryList = new ArrayList<EmploymentContainer>();
        try {
            PersistencyDataSet emloymentDatas = daoEmployment.getDataSet(new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endYearDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
            while (emloymentDatas.hasNext()) {
                EmploymentContainer container = (EmploymentContainer)emloymentDatas.getNext();
                entryList.add(container);
            }
            return entryList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static List<InsuranceContainer> getAgePartTimes(Date effectiveDate, Date beginYearDate, Date endYearDate, String currentOidEmployee) {
        ArrayList<InsuranceContainer> agePartTimeList = new ArrayList<InsuranceContainer>();
        try {
            PersistencyDataSet agePartTimeDatas = daoInsurance.getDataSet(new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endYearDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.le((String)"beginageparttime", (String)DateMapper.toString((Date)endYearDate)), Restrictions.ge((String)"endageparttime", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
            while (agePartTimeDatas.hasNext()) {
                InsuranceContainer container = (InsuranceContainer)agePartTimeDatas.getNext();
                agePartTimeList.add(container);
            }
            return agePartTimeList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static ParttimemodelallContainer getAgePartTimeModel(Date effectiveDate, Date beginYearDate, Date endYearDate, String oidAgePartTimeModel) {
        try {
            PersistencyDataSet agePartTimeModelDatas = daoParttimemodelall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endYearDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.eq((String)"oidparttimemodel", (String)oidAgePartTimeModel)}));
            if (agePartTimeModelDatas.hasNext()) {
                return (ParttimemodelallContainer)agePartTimeModelDatas.getNext();
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<DEUVAccount> getDeuvAccounts(Date effectiveDate, Date beginYearDate, Date endYearDate, String currentOidEmployee) {
        DEUVAccount[] deuvAccounts = DEUVAccountPersistencyManager.query((Order[])new Order[]{Order.asc((String)"validfrom"), Order.asc((String)"reasonofdelivery")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endYearDate)), Restrictions.eq((String)"transmitted", (String)BooleanMapper.toString((boolean)true)), Restrictions.eq((String)"manually", (String)BooleanMapper.toString((boolean)false)), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
        return Arrays.asList(deuvAccounts);
    }

    private static List<EeabsenttimeallContainer> getEEAbsenttimes(Date effectiveDate, Date beginYearDate, Date endYearDate, String currentOidEmployee) {
        ArrayList<EeabsenttimeallContainer> senttimeList = new ArrayList<EeabsenttimeallContainer>();
        try {
            PersistencyDataSet senttimeDatas = daoEeabsenttimeall.getDataSet(new Order[]{Order.asc((String)"validfrom")}, Restrictions.or((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endYearDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}), (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)endYearDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)beginYearDate)), Restrictions.eq((String)"deleted", (String)"T"), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)})));
            while (senttimeDatas.hasNext()) {
                EeabsenttimeallContainer container = (EeabsenttimeallContainer)senttimeDatas.getNext();
                senttimeList.add(container);
            }
            return senttimeList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<CfofentryallContainer> getCFofEntrys(String currentOidEmployee) {
        ArrayList<CfofentryallContainer> entryList = new ArrayList<CfofentryallContainer>();
        try {
            PersistencyDataSet eeCFofEntryDatas = daoCfofentryall.getDataSet(new Order[]{Order.asc((String)"employmentfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"employmentfrom", (String)DateMapper.toString((Date)this.mForValidDate)), Restrictions.ge((String)"employmentuntil", (String)DateMapper.toString((Date)this.mForYearFrom))}));
            while (eeCFofEntryDatas.hasNext()) {
                CfofentryallContainer eeCFofEntryContainer = (CfofentryallContainer)eeCFofEntryDatas.getNext();
                entryList.add(eeCFofEntryContainer);
            }
            return entryList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<CfofsystemcomallContainer> getCFofSystemComs(String currentOidEmployee) {
        ArrayList<CfofsystemcomallContainer> systemList = new ArrayList<CfofsystemcomallContainer>();
        try {
            PersistencyDataSet eeSystemComAllDatas = daoCfofsystemcomall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mForValidDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mForYearFrom))}));
            while (eeSystemComAllDatas.hasNext()) {
                CfofsystemcomallContainer eeSystemComAllContainer = (CfofsystemcomallContainer)eeSystemComAllDatas.getNext();
                systemList.add(eeSystemComAllContainer);
            }
            return systemList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<CfofsystemsiallContainer> getCFofSystemSis(String currentOidEmployee) {
        ArrayList<CfofsystemsiallContainer> systemList = new ArrayList<CfofsystemsiallContainer>();
        try {
            PersistencyDataSet eeSystemSiAllDatas = daoCfofsystemsiall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mForValidDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mForYearFrom))}));
            while (eeSystemSiAllDatas.hasNext()) {
                CfofsystemsiallContainer eeSystemSiAllContainer = (CfofsystemsiallContainer)eeSystemSiAllDatas.getNext();
                systemList.add(eeSystemSiAllContainer);
            }
            return systemList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<WageAccountCFPartClassRiskBean> getCFPartClassRisks(String oidCfOfSystemSi) {
        ArrayList<WageAccountCFPartClassRiskBean> systemList = new ArrayList<WageAccountCFPartClassRiskBean>();
        try {
            PersistencyDataSet cfpartclassriskDatas = daoCfpartclassrisk.getDataSet(null, Restrictions.eq((String)"oidcfofsystemsi", (String)oidCfOfSystemSi));
            while (cfpartclassriskDatas.hasNext()) {
                AccidentinsallContainer accidentinsallContainer;
                CfpartclassriskContainer cfpartclassriskContainer = (CfpartclassriskContainer)cfpartclassriskDatas.getNext();
                String accidentInsurance = !StringMapper.isNullString((String)cfpartclassriskContainer.oidaccidentins) ? ((accidentinsallContainer = WageAccountReportDataSource.getAccidentInsuranceContainer(cfpartclassriskContainer.oidaccidentins, this.mForEffectiveDate, this.mForValidDate)) != null ? accidentinsallContainer.longdescription : "") : "";
                String classOfRisk = cfpartclassriskContainer.classofrisk;
                String serialNumber = cfpartclassriskContainer.serialnumberalpha;
                String aiPayment = cfpartclassriskContainer.aipayment != null ? WageAccountReportDataSource.toCurrencyFormat(cfpartclassriskContainer.aipayment) : WageAccountReportDataSource.toPrintFormat(BigDecimal.ZERO, 2);
                systemList.add(new WageAccountCFPartClassRiskBean(accidentInsurance, classOfRisk + " | " + serialNumber, aiPayment));
            }
            return systemList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static AccidentinsallContainer getAccidentInsuranceContainer(String oidAccidentins, Date effectiveDate, Date validDate) {
        try {
            PersistencyDataSet accidentinsallDatas = daoAccidentinsall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"objectidroot", (String)oidAccidentins), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate)))}));
            AccidentinsallContainer accidentinsallContainer = null;
            if (accidentinsallDatas.hasNext()) {
                accidentinsallContainer = (AccidentinsallContainer)accidentinsallDatas.getNext();
            }
            return accidentinsallContainer;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<CfofsystemsibContainer> getCFofSystemSibs(String currentOidEmployee) {
        ArrayList<CfofsystemsibContainer> systemList = new ArrayList<CfofsystemsibContainer>();
        try {
            PersistencyDataSet eeSystemSibDatas = daoCfofsystemsib.getDataSet(new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mForValidDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mForYearFrom))}));
            while (eeSystemSibDatas.hasNext()) {
                CfofsystemsibContainer eeSystemSibContainer = (CfofsystemsibContainer)eeSystemSibDatas.getNext();
                systemList.add(eeSystemSibContainer);
            }
            return systemList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getCalculationbasics() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate))), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mForValidDate))), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate)))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mResult);
            for (Criterion each : inRestrictions) {
                PersistencyDataSet CalculationbasicDatas = daoCalculationbasic.getDataSet(null, Restrictions.and((Criterion)each, (Criterion)filter));
                while (CalculationbasicDatas.hasNext()) {
                    CalculationbasicContainer container = (CalculationbasicContainer)CalculationbasicDatas.getNext();
                    if (!DateHelper.before((Date)container.validfrom, (Date)container.effectivefrom)) continue;
                    Map<Date, CalculationbasicContainer> cbHashMap = this.mCalculationbasicHashMap.get(container.oidemployee);
                    if (cbHashMap == null) {
                        cbHashMap = new HashMap<Date, CalculationbasicContainer>();
                        cbHashMap.put(container.effectivefrom, container);
                        this.mCalculationbasicHashMap.put(container.oidemployee, cbHashMap);
                        continue;
                    }
                    CalculationbasicContainer tempContainer = cbHashMap.get(container.effectivefrom);
                    if (tempContainer != null && !DateHelper.before((Date)container.validfrom, (Date)tempContainer.validfrom)) continue;
                    cbHashMap.put(container.effectivefrom, container);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static List<ValuepositionContainer> getRRValuePositions(Date validDate, String currentOidEmployee) {
        ArrayList<ValuepositionContainer> vpList = new ArrayList<ValuepositionContainer>();
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)validDate))), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)validDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validDate)), Restrictions.eq((String)"valuetypenumber", (String)"882110"), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
            while (valuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuePositionDatas.getNext();
                vpList.add(container);
            }
            return vpList;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private boolean hatDifferenzNachAustritt(Date validDate, String currentOidEmployee) {
        String[] vtArray = new String[]{"99998", "882110"};
        boolean differenzNachAustritt = false;
        if (this.mInternalUse) {
            validDate = DateHelper.getLastDayOfYear((Date)validDate);
        }
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mForEffectiveDate))), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"validUntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)validDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.in((String)"valuetypenumber", (String[])vtArray), Restrictions.eq((String)"oidemployee", (String)currentOidEmployee)}));
            while (valuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuePositionDatas.getNext();
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)container.results)) continue;
                differenzNachAustritt = true;
            }
            return differenzNachAustritt;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static EeworkallContainer getEEWorkAll(Date effectiveDate, Date validDate, String oidEmployee) {
        try {
            PersistencyDataSet eeworkallDatas = daoEeworkall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            return (EeworkallContainer)eeworkallDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static WorkingtimeallContainer getWorkingTime(Date effectiveDate, Date validDate, String oidWorkingTime) {
        try {
            PersistencyDataSet workingtimeallDatas = daoWorkingtimeall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidworkingtime", (String)oidWorkingTime)}));
            return (WorkingtimeallContainer)workingtimeallDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static AbsenttimeallContainer getAbsenttime(Date effectiveDate, Date validDate, String oidAbsenttime) {
        try {
            PersistencyDataSet absenttimeallDatas = daoAbsenttimeall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidabsenttime", (String)oidAbsenttime)}));
            return (AbsenttimeallContainer)absenttimeallDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static EntryrsnallContainer getEntryReason(Date effectiveDate, Date validDate, String oidEntryReason) {
        try {
            PersistencyDataSet entryReasonDatas = daoEntryrsnall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidentryreason", (String)oidEntryReason)}));
            return (EntryrsnallContainer)entryReasonDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static WithdrawalrsnallContainer getWithdrawalReason(Date effectiveDate, Date validDate, String oidWithdrawalReason) {
        try {
            PersistencyDataSet withdrawalReasonDatas = daoWithdrawalrsnall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidwithdrawalrsn", (String)oidWithdrawalReason)}));
            return (WithdrawalrsnallContainer)withdrawalReasonDatas.getNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getValueTypeAll() {
        HashMap<String, String> vthashmap = new HashMap<String, String>();
        try {
            PersistencyDataSet valuetypesallDatas = daoValuetypesall.getDataSet(null, (Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate))), Restrictions.eq((String)"mmpayrollresult", (String)"T")}), Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate))), Restrictions.le((String)"valuetypenumber", (String)"99999"), Restrictions.eq((String)"mmpayrollfactor2", (String)"T")})}));
            while (valuetypesallDatas.hasNext()) {
                String tempOid;
                ValuetypesallContainer container = (ValuetypesallContainer)valuetypesallDatas.getNext();
                if (container.valuetypenumber >= 890000 || !StringMapper.isNullString((String)(tempOid = (String)vthashmap.get(container.oidvaluetype)))) continue;
                vthashmap.put(container.oidvaluetype, "");
            }
            this.mOidValueTypes = new String[vthashmap.keySet().size()];
            this.mOidValueTypes = vthashmap.keySet().toArray(this.mOidValueTypes);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static boolean isNullorSpace(String str) {
        return StringMapper.isNullString((String)str);
    }

    private static String toAmountString(BigDecimal amount) {
        return amount == null ? "" : StringUtils.leftPad((String)amount.setScale(0).toString(), (int)6, (char)'0');
    }

    private static ValuepositionContainer cloneValuepositionContainer(ValuepositionContainer vpContainer) {
        ValuepositionContainer tempVPContainer = new ValuepositionContainer();
        tempVPContainer.setLastUserid(vpContainer.getLastUserid());
        tempVPContainer.oidemployee = vpContainer.oidemployee;
        tempVPContainer.oidvaluetype = vpContainer.oidvaluetype;
        tempVPContainer.effectivefrom = vpContainer.effectivefrom;
        tempVPContainer.effectiveuntil = vpContainer.effectiveuntil;
        tempVPContainer.validfrom = vpContainer.validfrom;
        tempVPContainer.validuntil = vpContainer.validuntil;
        tempVPContainer.oidparent = vpContainer.oidparent;
        tempVPContainer.oidgenesisparent = vpContainer.oidgenesisparent;
        tempVPContainer.factor1 = vpContainer.factor1;
        tempVPContainer.factor2 = vpContainer.factor2;
        tempVPContainer.results = vpContainer.results;
        tempVPContainer.percentage = vpContainer.percentage;
        tempVPContainer.performfactor = vpContainer.performfactor;
        tempVPContainer.oidcostcenter = vpContainer.oidcostcenter;
        tempVPContainer.oidcostunit = vpContainer.oidcostunit;
        tempVPContainer.valuetypenumber = vpContainer.valuetypenumber;
        tempVPContainer.rankingnumber = vpContainer.rankingnumber;
        tempVPContainer.category = vpContainer.category;
        tempVPContainer.setObjectTS(vpContainer.getObjectTS());
        tempVPContainer.setObjectid(vpContainer.getObjectid());
        tempVPContainer.setVersion(vpContainer.getVersion());
        return tempVPContainer;
    }

    private static WageAccountValueTypeBean getWageAccountValueTypeBean(String oidValueType) throws BusinessDomainException {
        ValueTypeTP vttp = ValueType.getValueType((String)oidValueType).getValueTypeTP(MAX_DATE, MAX_DATE);
        WageAccountValueTypeBean bean = new WageAccountValueTypeBean(vttp);
        return bean;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private static IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }

    private class Key {
        private final String objectId;
        private final Date effectiveDate;
        private final Date validDate;

        public Key(String objectId, Date effectiveDate, Date validDate) {
            this.objectId = objectId;
            this.effectiveDate = effectiveDate;
            this.validDate = validDate;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key other = (Key)object;
                return StringMapper.equal((String)this.objectId, (String)other.objectId) && DateHelper.equal((Date)this.effectiveDate, (Date)other.effectiveDate) && DateHelper.equal((Date)this.validDate, (Date)other.validDate);
            }
            return false;
        }

        public int hashCode() {
            return this.effectiveDate.hashCode() + 31 * this.validDate.hashCode() + 961 * this.objectId.hashCode();
        }
    }
}

