/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.statementofearnings;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.personnel.domain.designationtype.personincharge.PersonInChargeTP;
import com.varial.personnel.domain.designationtype.wagefactor.WageFactorTP;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.attachment.EEAttachment;
import com.varial.personnel.domain.employee.credit.BalanceMonth;
import com.varial.personnel.domain.employee.credit.CreditInfo;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.dataera.EEDataERA;
import com.varial.personnel.domain.employee.dataera.EEDataERAHelper;
import com.varial.personnel.domain.employee.employment.partcostcenter.PartCostCenter;
import com.varial.personnel.domain.employee.employment.partcostunit.PartCostUnit;
import com.varial.personnel.domain.employee.relative.DegreeRelationShipEnum;
import com.varial.personnel.domain.employee.relative.EERelative;
import com.varial.personnel.domain.employee.relative.EERelativeDateOfBirthComparator;
import com.varial.personnel.domain.employee.relative.EERelativeTP;
import com.varial.personnel.domain.employee.relative.FlagCalculationEnum;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.employee.tax.mapper.TaxacationEnumMapper;
import com.varial.personnel.domain.employee.valueposition.Originator;
import com.varial.personnel.domain.employee.valueposition.OriginatorFactory;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.global.creditmodel.CreditModel;
import com.varial.personnel.domain.global.creditmodel.CreditModelTP;
import com.varial.personnel.domain.global.creditmodel.TypeOfCreditEnum;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.payscale.payscalegroup.PayScaleGroup;
import com.varial.personnel.domain.payscale.payscalegroup.PayScaleGroupTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.pcompany.settings.CorrectionEnum;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.employeepayment.AttachmentBean;
import com.varial.personnel.domain.reports.employeepayment.PayDeductionBean;
import com.varial.personnel.domain.reports.employeepayment.PensionSchemeBean;
import com.varial.personnel.domain.reports.employeepayment.PensionSchemeReasonForTransfer;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldBean;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldCreator;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsCache;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsHolidayMapper;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsNoticesOfSalary;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsQueries;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsReport;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsReportHelper;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsValuePositionDataSource;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsAbsenttimeBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsChildAllowanceBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsCostCenterSplitBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsCostUnitSplitBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsCreditInfoBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsERABean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsHolidayBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsInfoBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsLoanBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsPayDeductionBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsResultBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsScalePaymentBean;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsWageFactorBean;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypePersistencyManager;
import com.varial.personnel.domain.typeofvalue.basictypes.BlankLineEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ClassificationEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.CompressionEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.FontEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.NoPrintByZeroEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.PrintEnum;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.domain.typeofvalue.foundation.general.FoundationGeneral;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimePersistencyManager;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.framework.basictypes.FormOfAddressEnum;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.personnel.persistency.absenttime.absenttimeall.AbsenttimeallContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.designationtype.costcenterall.CostcenterallContainer;
import com.varial.personnel.persistency.designationtype.costunitall.CostunitallContainer;
import com.varial.personnel.persistency.designationtype.employeecirclall.EmployeecirclallContainer;
import com.varial.personnel.persistency.designationtype.employeegroupall.EmployeegroupallContainer;
import com.varial.personnel.persistency.designationtype.orgunitall.OrgunitallContainer;
import com.varial.personnel.persistency.employee.attachmentall.AttachmentallContainer;
import com.varial.personnel.persistency.employee.eeabsenttimeall.EeabsenttimeallContainer;
import com.varial.personnel.persistency.employee.eebankdetailsall.EebankdetailsallContainer;
import com.varial.personnel.persistency.employee.eepensschemeall.EepensschemeallContainer;
import com.varial.personnel.persistency.employee.eewagefactorall.EewagefactorallContainer;
import com.varial.personnel.persistency.employee.eeworkall.EeworkallContainer;
import com.varial.personnel.persistency.employee.employment.EmploymentContainer;
import com.varial.personnel.persistency.employee.insurance.InsuranceContainer;
import com.varial.personnel.persistency.employee.loanall.LoanallContainer;
import com.varial.personnel.persistency.employee.masterall.MasterallContainer;
import com.varial.personnel.persistency.employee.paydeductionall.IPaydeductionallDao;
import com.varial.personnel.persistency.employee.paydeductionall.PaydeductionallContainer;
import com.varial.personnel.persistency.employee.scalepaymentall.ScalepaymentallContainer;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.global.banktp.BanktpContainer;
import com.varial.personnel.persistency.global.fstateregcaall.FstateregcaallContainer;
import com.varial.personnel.persistency.global.recipientall.RecipientallContainer;
import com.varial.personnel.persistency.typeofValue.valuetypesall.ValuetypesallContainer;
import com.varial.personnel.persistency.workingTime.workingtimeall.WorkingtimeallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import com.varial.shared.Version;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang3.StringUtils;

public class StatementOfEarningsReportDataSource
implements JRDataSource {
    private static final ICalculationbasicDao daoCalculationbasic = (ICalculationbasicDao)StatementOfEarningsReportDataSource.getDao("calculationbasicDao");
    private static final IPaydeductionallDao daoPaydeductionall = (IPaydeductionallDao)StatementOfEarningsReportDataSource.getDao("paydeductionallDao");
    private static final IValuepositionDao daoValueposition = (IValuepositionDao)StatementOfEarningsReportDataSource.getDao("valuepositionDao");
    protected static final BigDecimal ZERO_CURRENCY = BigDecimal.valueOf(0L, 2);
    protected static final BigDecimal ZERO_PERCENTAGE = BigDecimal.valueOf(0L, 3);
    protected String FIELD_SOEID;
    protected String FIELD_MONAT;
    private String ARCHIV_FIRMENSCHLUESSEL;
    String FIELD_RUECKFRAGEN_AN;
    private String FIELD_DYNAMICFIELD1;
    private String FIELD_DYNAMICFIELD2;
    private String FIELD_DYNAMICFIELD3;
    private String FIELD_DYNAMICFIELD4;
    private String FIELD_DYNAMICLABEL1;
    private String FIELD_DYNAMICLABEL2;
    private String FIELD_DYNAMICLABEL3;
    private String FIELD_DYNAMICLABEL4;
    protected String FIELD_PERSONAL_NR;
    private String FIELD_EINTRITTSDATUM;
    private String FIELD_AUSTRITTSDATUM;
    private String FIELD_GEBURTSDATUM;
    private String FIELD_SV_GUELTIG_AB;
    private String FIELD_STEUERKLASSE;
    private String FIELD_STEUERFAKTOR;
    private String FIELD_STEUER_ID;
    private String FIELD_RELI_AN;
    private String FIELD_RELI_EG;
    private String FIELD_BEITR_GP_KV;
    private String FIELD_BEITR_GP_RV;
    private String FIELD_BEITR_GP_AV;
    private String FIELD_BEITR_GP_PV;
    private String FIELD_BEZ_BEITR_GP_KV;
    private String FIELD_BEZ_BEITR_GP_RV;
    private String FIELD_BEZ_BEITR_GP_AV;
    private String FIELD_BEZ_BEITR_GP_PV;
    protected String FIELD_KRANKENKASSE;
    private String FIELD_VERSICH_NR;
    private String FIELD_ARBEITSTAGE;
    private String FIELD_DATE;
    protected String FIELD_KONTOINHABER;
    protected String FIELD_AN_BANK;
    private String FIELD_VERSORGUNGSFREIBETRAG;
    private String FIELD_STEUERERMITTLUNG;
    private String FIELD_PERSONENGRUPPE;
    private String FIELD_GLEITZONE;
    private String FIELD_MEHRFACHBESCHAEFTIGUNG;
    private String FIELD_KIRCHENSTEUERSATZ;
    protected String FIELD_BERECHNUNGSZEITRAUM;
    private String FIELD_BEZ_PERSONENGRUPPE;
    protected String FIELD_ZAHLART;
    private String FIELD_VERSION;
    protected String FIELD_SOETYPE;
    private String FIELD_ETIN;
    protected String FIELD_ELTERNEIGENSCHAFT;
    private String FIELD_JAHR;
    private BigDecimal FIELD_FREI_HIN_BETRAG_MON;
    private BigDecimal FIELD_FREI_HIN_BETRAG_JAHR;
    private String FIELD_BEZ_FREI_HIN_BETRAG_MON;
    private String FIELD_BEZ_FREI_HIN_BETRAG_JAHR;
    protected BigDecimal FIELD_UEBERWEISUNGSBETRAG;
    private BigDecimal FIELD_WOCHENARBEITSZEIT;
    private BigDecimal FIELD_WOCHENARBEITSTAGE;
    private AddressFieldCreator mAddressFieldCreator;
    private List<AddressFieldBean> FIELD_ADDRESSFIELDDATAS;
    private Collection<StatementOfEarningsInfoBean> FIELD_INFODATAS;
    private Collection<StatementOfEarningsHolidayBean> FIELD_HOLIDAYDATAS;
    private Collection<StatementOfEarningsPayDeductionBean> FIELD_PAYDEDUCTIONDATAS;
    private Collection<StatementOfEarningsAbsenttimeBean> FIELD_ABSENTTIMEDATAS;
    private Collection<StatementOfEarningsLoanBean> FIELD_LOANDATAS;
    private Collection<StatementOfEarningsERABean> FIELD_ERADATAS;
    private Collection<StatementOfEarningsWageFactorBean> FIELD_WAGEFACTORDATAS;
    private Collection<StatementOfEarningsScalePaymentBean> FIELD_SCALEPAYMENTDATAS;
    private Collection<StatementOfEarningsPayDeductionBean> FIELD_ATTACHMENTDATAS;
    private Collection<StatementOfEarningsChildAllowanceBean> FIELD_CHILDALLOWANCEDATAS;
    private Collection<StatementOfEarningsCreditInfoBean> FIELD_CREDITINFODATAS;
    private Collection<StatementOfEarningsCostCenterSplitBean> FIELD_COSTCENTERSPLITDATAS;
    private Collection<StatementOfEarningsCostUnitSplitBean> FIELD_COSTUNITSPLITDATAS;
    private StatementOfEarningsValuePositionDataSource FIELD_ValuePostionDataSource;
    protected Boolean FIELD_SOETYPEBOOL;
    protected StatementOfEarningsCache mCache;
    protected StatementOfEarningsQueries mQueries;
    private StatementOfEarningsNoticesOfSalary mNoticesOfSalary;
    protected Iterator<StatementOfEarningsResultBean> mVPIterator;
    protected Iterator<Date[]> mRCIterator;
    protected Iterator<EmployeeBean> mEmployeeIterator;
    protected String[] mOidEmployees;
    protected Date mForEffectiveDate;
    protected Date mForValidDate;
    protected Date mBeginYearDate;
    protected Date mEndYearDate;
    protected Date mBeginMonthDate;
    protected Date mEndMonthDate;
    protected Date mBeginOfEmployment;
    protected Date mEndOfEmployment;
    protected Date mReturnCalculationDate;
    protected Date mJournalizedUntil;
    private CompanySettings mCompanySettings;
    protected BigDecimal mNetPay = BigDecimal.ZERO;
    protected boolean mReturnCalculation = false;
    protected boolean mChangeDescription;
    protected boolean mCorrectionRetiredEE;
    private boolean mReturnCalculationAll;
    private boolean mIsSuperiorForConsolidation;
    private boolean mPrintWithoutNetpay;
    private boolean mOnlyNetpayChangedPrint;
    protected CorrectionEnum mCorrectionsoe;
    protected int mPersonnelNumber;
    protected int mTempPersonnelNumber;
    protected int mRCNumber = 0;
    protected int nextOid = 0;
    protected String mZahlart;
    protected String mCurrentOidEmployee;
    protected Employee mCurrentEmployee;
    private String mOidPCompanyForSettings;
    private String mOidPCompanyForFoundations;
    protected String mEmployeeName;
    private StatementOfEarningsReport.FunctionEnum mFunktion;
    protected ProgressBarUpdater mProgressBar;
    private boolean mHasData = false;
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private final StatementOfEarningsReportHelper mStatementOfEarningsReportHelper = (StatementOfEarningsReportHelper)UtilitiesManager.getBean((String)"statementOfEarningsReportHelper", StatementOfEarningsReportHelper.class);
    private PensionSchemeReasonForTransfer mPensionSchemeReasonForTransfer;
    protected String mReportVersion;
    private final Map<String, ClassificationBean> mClassificationBeanMap = new HashMap<String, ClassificationBean>();

    private static <T> T getDao(String daoName) {
        return (T)UtilitiesManager.getApplicationContext().getBean(daoName);
    }

    public void execute(AllCallback callback, EmployeeForReport[] efrs, String oidPCompanyForSettings, String oidPCompanyForFoundations, boolean isSuperiorForConsolidation, boolean correctionRetiredEE, String info, Date forEffectiveDate, Date forValidDate, List<String> errorList, boolean returnCalculationAll, boolean printWithoutNetpay, boolean onlyNetpayChangedPrint, ProgressBarUpdater progressBar, StatementOfEarningsReport.FunctionEnum funktion, String reportVersion) throws BusinessDomainException, PutDataException {
        this.mCorrectionRetiredEE = correctionRetiredEE;
        this.mReturnCalculationAll = returnCalculationAll;
        this.mPrintWithoutNetpay = printWithoutNetpay;
        this.mOnlyNetpayChangedPrint = onlyNetpayChangedPrint;
        this.mReportVersion = reportVersion;
        this.mFunktion = funktion;
        if (!errorList.isEmpty()) {
            callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(errorList)));
            errorList.clear();
        }
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mCache = new StatementOfEarningsCache(this.mForEffectiveDate, this.mForValidDate);
        this.mQueries = new StatementOfEarningsQueries(this.mForEffectiveDate, this.mForValidDate);
        this.mEndMonthDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        if (!DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate), (Date)this.mEndMonthDate)) {
            this.mPrintWithoutNetpay = true;
        }
        this.mOidPCompanyForSettings = oidPCompanyForSettings;
        this.mOidPCompanyForFoundations = oidPCompanyForFoundations;
        this.mIsSuperiorForConsolidation = isSuperiorForConsolidation;
        this.mAddressFieldCreator = AddressFieldHelper.getInstance().createAddressFieldCreator(this.mOidPCompanyForSettings, this.mOidPCompanyForFoundations);
        this.mNoticesOfSalary = new StatementOfEarningsNoticesOfSalary(this.mForEffectiveDate, this.mForValidDate, info);
        ArrayList<String> oidEmployees = new ArrayList<String>();
        this.mCache.initCalculationbasicsValidFrom();
        for (EmployeeForReport efr : efrs) {
            String oidEmployee = efr.getOidEmployee();
            if (this.mOnlyNetpayChangedPrint && !this.checkChangeInNetPay(oidEmployee) || efr.getDateOfWithDrawal() != null && !DateHelper.afterOrEqual((Date)efr.getDateOfWithDrawal(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)) && this.mCache.getCalculationBasicValidFrom(oidEmployee) == null) continue;
            oidEmployees.add(oidEmployee);
            this.mCache.putEmployeeForReport(oidEmployee, efr);
        }
        Date date = new Date();
        this.FIELD_DATE = StatementOfEarningsReportDataSource.toString(date) + " " + VDate.formatCurrentDateAndTime((Date)date).substring(11, 16);
        this.mProgressBar = progressBar;
        if (funktion == StatementOfEarningsReport.FunctionEnum.PRINT) {
            this.mProgressBar.setTotal(oidEmployees.size());
        }
        this.mOidEmployees = oidEmployees.toArray(new String[oidEmployees.size()]);
        if (oidEmployees.isEmpty()) {
            if (funktion == StatementOfEarningsReport.FunctionEnum.PRINT) {
                throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
            }
            return;
        }
        this.FIELD_VERSION = Version.getVersion();
        this.mCache.initValueTypeGroupDescriptions();
        this.mCache.initValueTypes();
        this.mCache.initEEBankDetails(this.mOidEmployees);
        this.mCache.initVTCoefficients();
        this.mCompanySettings = this.mCache.getPCompany(this.mOidPCompanyForSettings).getCompanySettings(this.mForEffectiveDate, this.mForValidDate);
        this.mCorrectionsoe = this.mCompanySettings.getCorrectionStatementOfEarnings();
        if (this.mCompanySettings.getDeductionsIncludingTransfersOnSoE() || this.mCompanySettings.getGarnishmentsOnSoE()) {
            this.mCache.initCompanyAccounts(this.mOidPCompanyForSettings);
            this.mCache.initRecipients();
            this.mCache.initBankTPs();
            this.mPensionSchemeReasonForTransfer = new PensionSchemeReasonForTransfer(this.mForValidDate, this.mCache.getRecipientMap(), EmployeeForReportGenerator.getPCompanies((PCompany)PCompanyPersistencyManager.getPCompany((String)this.mOidPCompanyForFoundations)));
        }
        if (this.mCorrectionRetiredEE) {
            List<EmployeeBean> employeeBeans = this.getEmployeeBeans(this.mOidEmployees);
            Collections.sort(employeeBeans, new EmployeeBeanSortComparator());
            this.mEmployeeIterator = employeeBeans.iterator();
            this.mRCNumber = 0;
        }
    }

    private boolean checkChangeInNetPay(String oidEmployee) {
        Date aktualMonth = this.mForValidDate;
        Date prevMonth = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
        BigDecimal sum890000 = BigDecimal.ZERO;
        BigDecimal sum890100 = BigDecimal.ZERO;
        String[] valueTypeNumbers = new String[]{Integer.toString(890000), Integer.toString(890100)};
        try {
            ValuepositionContainer vpContainer;
            PersistencyDataSet valuePositionDatasAkt = daoValueposition.getDataSet(new Order[]{Order.asc((String)"valuetypenumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)aktualMonth))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)aktualMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)aktualMonth))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)aktualMonth))), Restrictions.in((String)"valuetypenumber", (String[])valueTypeNumbers)}));
            PersistencyDataSet valuePositionDatasPrev = daoValueposition.getDataSet(new Order[]{Order.asc((String)"valuetypenumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)prevMonth))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)prevMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)prevMonth))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)prevMonth))), Restrictions.in((String)"valuetypenumber", (String[])valueTypeNumbers)}));
            if (valuePositionDatasAkt.hasNext() && (vpContainer = (ValuepositionContainer)valuePositionDatasAkt.getNext()) != null) {
                if (vpContainer.valuetypenumber == 890000) {
                    sum890000 = vpContainer.results;
                }
                if (vpContainer.valuetypenumber == 890100) {
                    sum890100 = vpContainer.results;
                }
            }
            if (valuePositionDatasPrev.hasNext() && (vpContainer = (ValuepositionContainer)valuePositionDatasPrev.getNext()) != null) {
                if (vpContainer.valuetypenumber == 890000) {
                    sum890000 = sum890000.subtract(vpContainer.results);
                }
                if (vpContainer.valuetypenumber == 890100) {
                    sum890100 = sum890100.subtract(vpContainer.results);
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return sum890000.compareTo(BigDecimal.ZERO) != 0 || sum890100.compareTo(BigDecimal.ZERO) != 0;
    }

    protected boolean getMasterDatas() throws BusinessDomainException, PutDataException {
        boolean isPersonnelNumberChange;
        boolean next = false;
        this.mClassificationBeanMap.clear();
        if (!this.mCorrectionRetiredEE) {
            boolean bl = this.mReturnCalculation = this.mRCIterator != null && this.mRCIterator.hasNext();
            if (this.mReturnCalculation) {
                ++this.mRCNumber;
                this.FIELD_SOEID = this.getCurrrentPCompanyKey() + Integer.toString(this.mPersonnelNumber * 1000 + this.mRCNumber);
                this.FIELD_SOETYPE = "Korrekturverdienstnachweis\naus " + StatementOfEarningsReportDataSource.toMonthYYYY(this.mForEffectiveDate);
                this.FIELD_SOETYPEBOOL = Boolean.FALSE;
                Date[] rcDatas = this.mRCIterator.next();
                Date rcValidFrom = rcDatas[0];
                Date rcValidUntil = rcDatas[1];
                this.FIELD_MONAT = StatementOfEarningsReportDataSource.toMonthYYYY(rcValidFrom);
                this.FIELD_BERECHNUNGSZEITRAUM = StatementOfEarningsReportDataSource.toString(rcValidFrom) + " - " + StatementOfEarningsReportDataSource.toString(rcValidUntil);
                this.getDatas(rcValidFrom, rcValidUntil);
                this.FIELD_ZAHLART = "";
                this.FIELD_KONTOINHABER = "";
                this.FIELD_AN_BANK = "";
                this.mVPIterator = this.createRCVPList(rcValidFrom, rcValidUntil);
                next = true;
            } else {
                do {
                    boolean bl2 = next = this.nextOid < this.mOidEmployees.length;
                    if (!next) continue;
                    this.setCurrentOidEmployee(this.mOidEmployees[this.nextOid]);
                    this.mRCNumber = 0;
                    this.getDatas(DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), DateHelper.getLastDayOfMonth((Date)this.mForValidDate));
                    List<StatementOfEarningsResultBean> rbList = this.createVPList();
                    this.mVPIterator = rbList.size() >= 1 && (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetPay) || this.mPrintWithoutNetpay || this.mReturnCalculationAll) ? rbList.iterator() : null;
                    this.FIELD_SOEID = this.getCurrrentPCompanyKey() + Integer.toString(this.mPersonnelNumber * 1000 + this.mRCNumber);
                    this.FIELD_SOETYPEBOOL = PDateHelper.getDiffInMonths((Date)this.mForValidDate, (Date)this.mJournalizedUntil) <= 1;
                    this.FIELD_SOETYPE = this.FIELD_SOETYPEBOOL != false ? "Verdienstnachweis" : "Verdienstvorschau";
                    Date beginMonthDate = DateHelper.between((Date)this.mBeginOfEmployment, (Date)this.mBeginMonthDate, (Date)this.mEndMonthDate) ? this.mBeginOfEmployment : this.mBeginMonthDate;
                    this.FIELD_MONAT = StatementOfEarningsReportDataSource.toMonthYYYY(this.mBeginMonthDate);
                    this.FIELD_BERECHNUNGSZEITRAUM = StatementOfEarningsReportDataSource.toString(beginMonthDate) + " - " + StatementOfEarningsReportDataSource.toString(this.mEndMonthDate);
                    if (PDateHelper.getDiffInMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate), (Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate)) != 0) {
                        this.FIELD_ZAHLART = "";
                        this.FIELD_KONTOINHABER = "";
                        this.FIELD_AN_BANK = "";
                    } else {
                        this.FIELD_ZAHLART = this.mZahlart;
                    }
                    ++this.nextOid;
                } while (this.mVPIterator == null && next);
            }
        } else {
            do {
                if (!(next = this.mEmployeeIterator.hasNext())) continue;
                EmployeeBean employeebean = this.mEmployeeIterator.next();
                this.setCurrentOidEmployee(employeebean.getOidEmployee());
                ++this.mRCNumber;
                this.FIELD_SOEID = this.getCurrrentPCompanyKey() + Integer.toString(this.mPersonnelNumber * 1000 + this.mRCNumber);
                this.FIELD_SOETYPE = "Korrekturverdienstnachweis\naus " + StatementOfEarningsReportDataSource.toMonthYYYY(this.mForEffectiveDate);
                this.FIELD_SOETYPEBOOL = Boolean.FALSE;
                this.getDatas(DateHelper.getFirstDayOfMonth((Date)employeebean.getValidDate()), DateHelper.getLastDayOfMonth((Date)employeebean.getValidDate()));
                List<StatementOfEarningsResultBean> rbList = this.createVPList();
                this.mVPIterator = rbList.size() > 1 && (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNetPay) || this.mPrintWithoutNetpay || this.mReturnCalculationAll) ? rbList.iterator() : null;
                this.FIELD_MONAT = StatementOfEarningsReportDataSource.toMonthYYYY(this.mBeginMonthDate);
                this.FIELD_BERECHNUNGSZEITRAUM = StatementOfEarningsReportDataSource.toString(this.mBeginMonthDate) + " - " + StatementOfEarningsReportDataSource.toString(this.mEndMonthDate);
                this.FIELD_ZAHLART = "";
                this.FIELD_KONTOINHABER = "";
                this.FIELD_AN_BANK = "";
                ++this.nextOid;
            } while (this.mVPIterator == null && next);
        }
        boolean bl = isPersonnelNumberChange = this.mPersonnelNumber != this.mTempPersonnelNumber;
        if (isPersonnelNumberChange) {
            if (this.mFunktion == StatementOfEarningsReport.FunctionEnum.PRINT) {
                this.mProgressBar.update(this.FIELD_PERSONAL_NR + " / " + this.mEmployeeName);
            }
            this.mTempPersonnelNumber = this.mPersonnelNumber;
        }
        if (next) {
            this.FIELD_ADDRESSFIELDDATAS.get(0).setIsPersonnalNumberChange(Boolean.valueOf(isPersonnelNumberChange));
        }
        return next;
    }

    protected void setCurrentOidEmployee(String oidEmployee) {
        this.mCurrentOidEmployee = oidEmployee;
        this.mCurrentEmployee = StatementOfEarningsReportDataSource.getIEmployeePM().getEmployee(this.mCurrentOidEmployee);
    }

    private String getCurrrentPCompanyKey() {
        return this.mCache.getPCompany(this.mCurrentEmployee.getPCompany().getObjectid()).getPCompanyKey();
    }

    protected void getDatas(Date validFrom, Date validUntil) throws BusinessDomainException {
        TaxContainer taxContainer;
        InsuranceContainer insuranceContainer;
        Employee employee = this.mCurrentEmployee;
        this.FIELD_RUECKFRAGEN_AN = "";
        this.FIELD_DYNAMICFIELD1 = "";
        this.FIELD_DYNAMICFIELD2 = "";
        this.FIELD_DYNAMICFIELD3 = "";
        this.FIELD_DYNAMICFIELD4 = "";
        this.FIELD_DYNAMICLABEL1 = "";
        this.FIELD_DYNAMICLABEL2 = "";
        this.FIELD_DYNAMICLABEL3 = "";
        this.FIELD_DYNAMICLABEL4 = "";
        this.FIELD_EINTRITTSDATUM = "";
        this.FIELD_AUSTRITTSDATUM = "";
        this.FIELD_GEBURTSDATUM = "";
        this.FIELD_SV_GUELTIG_AB = "";
        this.FIELD_STEUERKLASSE = "";
        this.FIELD_STEUERFAKTOR = "";
        this.FIELD_STEUER_ID = "";
        this.FIELD_RELI_AN = "";
        this.FIELD_RELI_EG = "";
        this.FIELD_FREI_HIN_BETRAG_MON = null;
        this.FIELD_FREI_HIN_BETRAG_JAHR = null;
        this.FIELD_BEZ_FREI_HIN_BETRAG_MON = "";
        this.FIELD_BEZ_FREI_HIN_BETRAG_JAHR = "";
        this.FIELD_BEITR_GP_KV = "";
        this.FIELD_BEITR_GP_RV = "";
        this.FIELD_BEITR_GP_AV = "";
        this.FIELD_BEITR_GP_PV = "";
        this.FIELD_BEZ_BEITR_GP_KV = "";
        this.FIELD_BEZ_BEITR_GP_RV = "";
        this.FIELD_BEZ_BEITR_GP_AV = "";
        this.FIELD_BEZ_BEITR_GP_PV = "";
        this.FIELD_KRANKENKASSE = "";
        this.FIELD_VERSICH_NR = "";
        this.FIELD_ARBEITSTAGE = "";
        this.FIELD_UEBERWEISUNGSBETRAG = null;
        this.FIELD_KONTOINHABER = "";
        this.FIELD_AN_BANK = "";
        this.FIELD_VERSORGUNGSFREIBETRAG = "";
        this.FIELD_STEUERERMITTLUNG = "";
        this.FIELD_PERSONENGRUPPE = "";
        this.FIELD_GLEITZONE = "";
        this.FIELD_MEHRFACHBESCHAEFTIGUNG = "";
        this.FIELD_WOCHENARBEITSZEIT = null;
        this.FIELD_WOCHENARBEITSTAGE = null;
        this.FIELD_KIRCHENSTEUERSATZ = "";
        this.FIELD_BEZ_PERSONENGRUPPE = "";
        this.FIELD_ZAHLART = "";
        EmploymentContainer employmentContainer = this.mQueries.queryEmploymentContainer(this.mCurrentOidEmployee, validFrom, validUntil);
        MasterallContainer masterallContainer = this.mQueries.queryMasterAllContainer(this.mCurrentOidEmployee, validFrom, validUntil);
        this.ARCHIV_FIRMENSCHLUESSEL = employee.getPCompany().getPCompanyKey();
        this.FIELD_ADDRESSFIELDDATAS = Arrays.asList(this.mAddressFieldCreator.createAddressFieldBean(employee, validUntil, AddressFieldCreator.DocumentType.StatementOfEarnings));
        if (masterallContainer != null) {
            this.mPersonnelNumber = masterallContainer.personnelnumber;
            this.FIELD_PERSONAL_NR = Integer.toString(this.mPersonnelNumber);
            this.FIELD_GEBURTSDATUM = StatementOfEarningsReportDataSource.toString(masterallContainer.dateofbirth);
            this.mJournalizedUntil = masterallContainer.journalizeduntil;
            this.mEmployeeName = masterallContainer.surname + ", " + masterallContainer.firstname;
            if (DateHelper.before((Date)DateHelper.parse((String)"2005-01-01"), (Date)this.mForEffectiveDate) && DateHelper.before((Date)DateHelper.parse((String)"2005-01-01"), (Date)validFrom)) {
                this.FIELD_ETIN = masterallContainer.etinnumber;
            }
        }
        if ((insuranceContainer = this.mQueries.queryInsuranceContainer(this.mCurrentOidEmployee, validFrom, validUntil)) != null) {
            this.FIELD_BEITR_GP_KV = Integer.toString(insuranceContainer.duesgrouphi);
            this.FIELD_BEITR_GP_RV = Integer.toString(insuranceContainer.duesgrouppi);
            this.FIELD_BEITR_GP_AV = Integer.toString(insuranceContainer.duesgroupui);
            this.FIELD_BEITR_GP_PV = Integer.toString(insuranceContainer.duesgroupni);
            this.FIELD_VERSICH_NR = insuranceContainer.insuranceno;
            BigDecimal anzahlKinder = BigDecimal.ZERO;
            if (DateHelper.afterOrEqual((Date)validUntil, (Date)new VDate(2023, 6, 1).getDate())) {
                anzahlKinder = employee.getEffectiveNumberOfChildrenForNI(this.mForEffectiveDate, validUntil, true, false);
            }
            if (insuranceContainer.persongroup >= 900 && !StringMapper.isNullString((String)insuranceContainer.oidhealthfundkvdr)) {
                this.FIELD_ELTERNEIGENSCHAFT = insuranceContainer.nichildofeduckvdr ? "ja / " + anzahlKinder.toString() : "nein / " + anzahlKinder.toString();
                this.FIELD_KRANKENKASSE = !StringMapper.isNullString((String)insuranceContainer.oidhealthfundkvdr) ? StatementOfEarningsReportDataSource.toStringMaxLength(this.mCache.getHealthFundTP(insuranceContainer.oidhealthfundkvdr, validFrom).getShortDescription(), 27) : "";
            } else {
                this.FIELD_ELTERNEIGENSCHAFT = insuranceContainer.nichildeducation ? "ja / " + anzahlKinder.toString() : "nein / " + anzahlKinder.toString();
                this.FIELD_KRANKENKASSE = !StringMapper.isNullString((String)insuranceContainer.oidhealthfund) ? StatementOfEarningsReportDataSource.toStringMaxLength(this.mCache.getHealthFundTP(insuranceContainer.oidhealthfund, validFrom).getShortDescription(), 27) : "";
            }
            this.FIELD_PERSONENGRUPPE = Integer.toString(insuranceContainer.persongroup);
            this.FIELD_GLEITZONE = insuranceContainer.specialcategory == 2 ? "ja" : "nein";
            this.FIELD_MEHRFACHBESCHAEFTIGUNG = insuranceContainer.multiplyemployment > 1 ? "ja" : "nein";
            this.FIELD_BEZ_BEITR_GP_KV = StatementOfEarningsReportDataSource.toStringDuesGroupHi(insuranceContainer.duesgrouphi);
            this.FIELD_BEZ_BEITR_GP_RV = StatementOfEarningsReportDataSource.toStringDuesGroupPi(insuranceContainer.duesgrouppi);
            this.FIELD_BEZ_BEITR_GP_AV = StatementOfEarningsReportDataSource.toStringDuesGroupUiNi(insuranceContainer.duesgroupui);
            this.FIELD_BEZ_BEITR_GP_PV = StatementOfEarningsReportDataSource.toStringDuesGroupUiNi(insuranceContainer.duesgroupni);
            this.FIELD_BEZ_PERSONENGRUPPE = StatementOfEarningsReportDataSource.toStringPersonGroup(insuranceContainer.persongroup);
        }
        if ((taxContainer = this.mQueries.queryTaxContainer(this.mCurrentOidEmployee, validFrom, validUntil)) != null) {
            this.FIELD_STEUERKLASSE = StatementOfEarningsReportDataSource.toStringTaxBracket(taxContainer.taxbracket) + " / " + StatementOfEarningsReportDataSource.toString(taxContainer.childrelief);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)taxContainer.percentagesplit)) {
                this.FIELD_STEUERFAKTOR = StatementOfEarningsReportDataSource.toString(taxContainer.percentagesplit);
            }
            this.FIELD_VERSORGUNGSFREIBETRAG = taxContainer.pensionfreedues ? "ja" : "nein";
            this.FIELD_STEUERERMITTLUNG = TaxacationEnumMapper.valueToString((int)taxContainer.taxacation);
            this.FIELD_STEUER_ID = taxContainer.tin;
            this.FIELD_RELI_AN = ChurchTaxEnumMapper.valueToString((int)taxContainer.churchtaxee);
            this.FIELD_RELI_EG = ChurchTaxEnumMapper.valueToString((int)taxContainer.churchtaxspouse);
            this.FIELD_FREI_HIN_BETRAG_MON = taxContainer.freeallowancemm.subtract(taxContainer.addamountmm);
            this.FIELD_FREI_HIN_BETRAG_JAHR = taxContainer.freeallowanceyy.subtract(taxContainer.addamountyy);
            if (this.FIELD_FREI_HIN_BETRAG_MON.signum() >= 0) {
                this.FIELD_BEZ_FREI_HIN_BETRAG_MON = "Freibetrag Monat";
            } else {
                this.FIELD_BEZ_FREI_HIN_BETRAG_MON = "Hinzu-betrag Monat";
                this.FIELD_FREI_HIN_BETRAG_MON = this.FIELD_FREI_HIN_BETRAG_MON.negate();
            }
            if (this.FIELD_FREI_HIN_BETRAG_JAHR.signum() >= 0) {
                this.FIELD_BEZ_FREI_HIN_BETRAG_JAHR = "Freibetrag Jahr";
            } else {
                this.FIELD_BEZ_FREI_HIN_BETRAG_JAHR = "Hinzu-betrag Jahr";
                this.FIELD_FREI_HIN_BETRAG_JAHR = this.FIELD_FREI_HIN_BETRAG_JAHR.negate();
            }
            if (!StringMapper.isNullString((String)taxContainer.oidfederalstate)) {
                FstateregcaallContainer federalStateContainer = this.mQueries.queryFederalStateAllContainer(taxContainer.oidfederalstate, validFrom, validUntil);
                this.FIELD_KIRCHENSTEUERSATZ = federalStateContainer.shortdesctaxlaw + " / " + StatementOfEarningsReportDataSource.toPercent(federalStateContainer.churchtax);
            }
        }
        Date calculationStart = this.mReportHelper.getCalculationStartDate(this.mCache.getPCompany(this.mCurrentEmployee.getPCompany().getObjectid()).getCompanyFoundations(this.mForEffectiveDate, validFrom));
        this.mBeginYearDate = DateHelper.max((Date)DateHelper.getFirstDayOfYear((Date)validFrom), (Date)calculationStart);
        this.mEndYearDate = DateHelper.getLastDayOfMonth((Date)validFrom);
        this.mBeginMonthDate = DateHelper.getFirstDayOfMonth((Date)validFrom);
        this.mEndMonthDate = DateHelper.getLastDayOfMonth((Date)validFrom);
        if (employmentContainer != null) {
            String oidFS;
            FstateregcaallContainer federalStateContainer;
            FederalState fs;
            String oidFS2;
            FstateregcaallContainer federalStateContainer2;
            FederalState fs2;
            String oidPlant;
            PersonInChargeTP personInChargeTP;
            EmployeegroupallContainer egContainer;
            Object dynamicFieldValue;
            int dynamicFieldIndex = 1;
            if (this.mCompanySettings.getPrintEmployeeCircle()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidemployeecircle)) {
                    EmployeecirclallContainer ecContainer = this.mQueries.queryEmployeeCircleAllContainer(employmentContainer.oidemployeecircle, validFrom, validUntil);
                    dynamicFieldValue = StatementOfEarningsReportDataSource.firstNonNullString(ecContainer.shortdescription, ecContainer.longdescription);
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Mitarbeiterkreis:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintEmployeeGroup()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidemployeegroup)) {
                    egContainer = this.mQueries.queryEmployeeGroupAllContainer(employmentContainer.oidemployeegroup, validFrom, validUntil);
                    dynamicFieldValue = StatementOfEarningsReportDataSource.firstNonNullString(egContainer.shortdescription, egContainer.longdescription);
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Mitarbeitergruppe:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintEmploymentGroup()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidemploymentgroup)) {
                    egContainer = this.mQueries.queryEmploymentGroupAllContainer(employmentContainer.oidemploymentgroup, validFrom, validUntil);
                    dynamicFieldValue = StatementOfEarningsReportDataSource.firstNonNullString(egContainer.shortdescription, egContainer.longdescription);
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Mitarbeiterfunktion:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintCostCenter()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidcostcenter)) {
                    CostcenterallContainer ccContainer = this.mQueries.queryCostCenterAllContainer(employmentContainer.oidcostcenter, validFrom, validUntil);
                    dynamicFieldValue = ccContainer.costcenterkey + " " + StatementOfEarningsReportDataSource.firstNonNullString(ccContainer.shortdescription, ccContainer.longdescription);
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Kostenstelle:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintCostUnit()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidcostunit)) {
                    CostunitallContainer cuContainer = this.mQueries.queryCostUnitAllContainer(employmentContainer.oidcostunit, validFrom, validUntil);
                    dynamicFieldValue = cuContainer.costunitkey + " " + StatementOfEarningsReportDataSource.firstNonNullString(cuContainer.shortdescription, cuContainer.longdescription);
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Kostentr\u00e4ger:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintDepartment()) {
                dynamicFieldValue = StringMapper.isNullString((String)employmentContainer.oiddepartment) ? "" : this.mCache.getDepartmentTP(employmentContainer.oiddepartment, validFrom).getShortDescription();
                this.setDynamicFieldValue((String)dynamicFieldValue, "Abteilung:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintOrgUnit()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidorgunit)) {
                    OrgunitallContainer ouContainer = this.mQueries.queryOrgunitAllContainer(employmentContainer.oidorgunit, validFrom, validUntil);
                    dynamicFieldValue = StatementOfEarningsReportDataSource.firstNonNullString(ouContainer.shortdescription, ouContainer.longdescription);
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Org.Einheit:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintPersonInCharge1()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidpersonincharge1)) {
                    personInChargeTP = this.mCache.getPersonInChargeTP(employmentContainer.oidpersonincharge1, validUntil);
                    dynamicFieldValue = StatementOfEarningsReportDataSource.firstNonNullString(personInChargeTP.getShortDescription(), personInChargeTP.getLongDescription());
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Sachbearbeiter:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.mCompanySettings.getPrintPersonInCharge2()) {
                dynamicFieldValue = "";
                if (!StringMapper.isNullString((String)employmentContainer.oidpersonincharge2)) {
                    personInChargeTP = this.mCache.getPersonInChargeTP(employmentContainer.oidpersonincharge2, validUntil);
                    dynamicFieldValue = StatementOfEarningsReportDataSource.firstNonNullString(personInChargeTP.getShortDescription(), personInChargeTP.getLongDescription());
                }
                this.setDynamicFieldValue((String)dynamicFieldValue, "Sachbearbeiter:", dynamicFieldIndex);
                ++dynamicFieldIndex;
            }
            if (this.FIELD_KIRCHENSTEUERSATZ == "" && !StringMapper.isNullString((String)(oidPlant = employmentContainer.oidplant)) && (fs2 = this.mCache.getPlantFoundations(oidPlant, validFrom).getFoundations().getFederalState()) != null && this.mQueries.queryPlantTaxOfficeExists(oidPlant, validFrom, validUntil) && (federalStateContainer2 = this.mQueries.queryFederalStateAllContainer(oidFS2 = fs2.getObjectid(), validFrom, validUntil)) != null) {
                this.FIELD_KIRCHENSTEUERSATZ = federalStateContainer2.shortdesctaxlaw + " / " + StatementOfEarningsReportDataSource.toPercent(federalStateContainer2.churchtax);
            }
            if (this.FIELD_KIRCHENSTEUERSATZ == "" && !StringMapper.isNullString((String)masterallContainer.oidpcompany) && (fs = this.mCache.getPCompany(masterallContainer.oidpcompany).getCompanyFoundations(this.mForEffectiveDate, validFrom).getFoundations().getFederalState()) != null && (federalStateContainer = this.mQueries.queryFederalStateAllContainer(oidFS = fs.getObjectid(), validFrom, validUntil)) != null) {
                this.FIELD_KIRCHENSTEUERSATZ = federalStateContainer.shortdesctaxlaw + " / " + StatementOfEarningsReportDataSource.toPercent(federalStateContainer.churchtax);
            }
            this.FIELD_RUECKFRAGEN_AN = this.getRueckfragenAn(employmentContainer, validFrom);
            this.FIELD_EINTRITTSDATUM = StatementOfEarningsReportDataSource.toString(employmentContainer.dateofentry);
            this.FIELD_AUSTRITTSDATUM = StatementOfEarningsReportDataSource.toString(employmentContainer.dateofwithdrawal);
            this.FIELD_SV_GUELTIG_AB = employmentContainer.allowableentrydate != null ? StatementOfEarningsReportDataSource.toString(employmentContainer.allowableentrydate) : StatementOfEarningsReportDataSource.toString(employmentContainer.dateofentrysi);
            this.mBeginOfEmployment = employmentContainer.dateofentry;
            Date date = this.mEndOfEmployment = employmentContainer.dateofwithdrawal == null ? this.mEndYearDate : employmentContainer.dateofwithdrawal;
            if (DateHelper.compare((Date)this.mEndOfEmployment, (Date)this.mBeginMonthDate) >= 0) {
                this.mEndYearDate = DateHelper.min((Date)this.mEndYearDate, (Date)this.mEndOfEmployment);
                this.mEndMonthDate = DateHelper.min((Date)this.mEndMonthDate, (Date)this.mEndOfEmployment);
            }
            EeworkallContainer eEworkAllContainer = this.mQueries.queryEEWorkAllContainer(this.mCurrentOidEmployee, validFrom, validUntil);
            boolean printOnSoe = true;
            BigDecimal percparttimework = BigDecimal.ZERO;
            if (eEworkAllContainer != null && (printOnSoe = eEworkAllContainer.printonsoe)) {
                WorkingTime workingTime;
                WorkingtimeallContainer workingtimeallContainer;
                if (!StringMapper.isNullString((String)eEworkAllContainer.oidworkingtime)) {
                    workingtimeallContainer = this.mQueries.queryWorkingTimeAllContainer(eEworkAllContainer.oidworkingtime, validFrom, validUntil);
                    if (workingtimeallContainer != null) {
                        workingTime = WorkingTimePersistencyManager.getWorkingTime((String)eEworkAllContainer.oidworkingtime);
                        this.fillFieldsArbeit(workingTime, validUntil, workingtimeallContainer);
                    }
                } else if (!StringMapper.isNullString((String)eEworkAllContainer.oiddiffworkingtime) && (workingtimeallContainer = this.mQueries.queryWorkingTimeAllContainer(eEworkAllContainer.oiddiffworkingtime, validFrom, validUntil)) != null) {
                    workingTime = WorkingTimePersistencyManager.getWorkingTime((String)eEworkAllContainer.oiddiffworkingtime);
                    this.fillFieldsArbeit(workingTime, validUntil, workingtimeallContainer);
                }
                if (eEworkAllContainer.parttimework && !BigDecimalMapper.isZeroOrNull((BigDecimal)eEworkAllContainer.percparttimework)) {
                    percparttimework = eEworkAllContainer.percparttimework.setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(100L));
                }
            }
            if (printOnSoe) {
                WorkingTime workingTime;
                if (this.FIELD_ARBEITSTAGE == "" && !StringMapper.isNullString((String)employmentContainer.oidplant) && (workingTime = this.mCache.getPlantFoundations(employmentContainer.oidplant, validUntil).getFoundations().getWorkingTime()) != null) {
                    this.fillFieldsArbeit(workingTime, validUntil, null);
                }
                if (this.FIELD_ARBEITSTAGE == "" && masterallContainer != null && (workingTime = this.mCache.getPCompany(masterallContainer.oidpcompany).getCompanyFoundations(this.mForEffectiveDate, validUntil).getFoundations().getWorkingTime()) != null) {
                    this.fillFieldsArbeit(workingTime, validUntil, null);
                }
                if (this.FIELD_WOCHENARBEITSZEIT != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)percparttimework)) {
                    this.FIELD_WOCHENARBEITSZEIT = this.FIELD_WOCHENARBEITSZEIT.multiply(percparttimework).setScale(2, RoundingMode.HALF_UP);
                }
            }
        }
        this.FIELD_INFODATAS = null;
        this.FIELD_PAYDEDUCTIONDATAS = null;
        this.FIELD_ABSENTTIMEDATAS = null;
        this.FIELD_LOANDATAS = null;
        this.FIELD_HOLIDAYDATAS = null;
        this.FIELD_ERADATAS = null;
        this.FIELD_WAGEFACTORDATAS = null;
        this.FIELD_SCALEPAYMENTDATAS = null;
        this.FIELD_CREDITINFODATAS = null;
        this.FIELD_COSTCENTERSPLITDATAS = null;
        this.FIELD_COSTUNITSPLITDATAS = null;
        this.FIELD_ATTACHMENTDATAS = null;
        this.FIELD_CHILDALLOWANCEDATAS = null;
        if (this.mCompanySettings.getBreakPeriodsOnSoE()) {
            ArrayList<StatementOfEarningsAbsenttimeBean> absenttimeDatas = new ArrayList<StatementOfEarningsAbsenttimeBean>();
            List<EeabsenttimeallContainer> absenttimeList = this.getEEAbsenttimeallContainerList(this.mCurrentOidEmployee, validFrom);
            for (EeabsenttimeallContainer absenttimeContainer : absenttimeList) {
                AbsenttimeallContainer absenttimeallContainer = this.mQueries.queryAbsenttimeAllContainer(absenttimeContainer.oidabsenttime, absenttimeContainer.validuntil, absenttimeContainer.validuntil);
                if (!absenttimeContainer.printonsoe) continue;
                absenttimeDatas.add(new StatementOfEarningsAbsenttimeBean(StatementOfEarningsReportDataSource.toString(absenttimeContainer.validfrom), VDate.isDateMax((Date)absenttimeContainer.validuntil) ? "offen" : StatementOfEarningsReportDataSource.toString(absenttimeContainer.validuntil), (String)(StringMapper.isNullString((String)absenttimeContainer.deuvabsenttimekey) ? absenttimeContainer.absenttimekey : absenttimeContainer.absenttimekey + " / " + absenttimeContainer.deuvabsenttimekey), absenttimeallContainer.shortdescription));
            }
            this.FIELD_ABSENTTIMEDATAS = absenttimeDatas;
        }
        if (!this.mReturnCalculation) {
            EebankdetailsallContainer eebankdetailsallContainer;
            EEDataERAHelper.ERAValueForDisplay eraValueForDisplay;
            this.mZahlart = "Keine Zahlungsart hinterlegt";
            this.FIELD_KONTOINHABER = "";
            this.FIELD_AN_BANK = "";
            this.FIELD_INFODATAS = this.mNoticesOfSalary.createNotices(employmentContainer, this.mCurrentEmployee.getPCompany().getObjectid());
            this.FIELD_LOANDATAS = null;
            ArrayList<StatementOfEarningsLoanBean> loanDatas = new ArrayList<StatementOfEarningsLoanBean>();
            if (this.mCompanySettings.getLoansOnSoE()) {
                List loanList = this.mQueries.queryLoanallContainers(this.mCurrentOidEmployee);
                for (LoanallContainer loanallContainer : loanList) {
                    ValuepositionContainer vtTotalContainer = this.mQueries.queryValuePositionContainer(this.mCurrentOidEmployee, loanallContainer.getObjectid(), loanallContainer.oidvaluetype);
                    if (vtTotalContainer == null) continue;
                    BigDecimal[] resultset = this.queryLoanRateValuePositionResults(this.mCurrentOidEmployee, vtTotalContainer.getObjectid());
                    loanDatas.add(new StatementOfEarningsLoanBean(loanallContainer.oidloan, this.mCache.getValueTypeFoundationsByOid(loanallContainer.oidvaluetype).getGeneral().getLongDescription(), StatementOfEarningsReportDataSource.toString(loanallContainer.startrepayment), StatementOfEarningsReportDataSource.toCurrencyFormat(BigDecimalMapper.isZeroOrNull((BigDecimal)loanallContainer.interestrate) ? ZERO_CURRENCY : loanallContainer.interestrate), StatementOfEarningsReportDataSource.toCurrencyFormat(BigDecimalMapper.isZeroOrNull((BigDecimal)loanallContainer.totalamount) ? ZERO_CURRENCY : loanallContainer.totalamount), StatementOfEarningsReportDataSource.toCurrencyFormat(BigDecimalMapper.isZeroOrNull((BigDecimal)resultset[0]) ? ZERO_CURRENCY : resultset[0]), StatementOfEarningsReportDataSource.toCurrencyFormat(BigDecimalMapper.isZeroOrNull((BigDecimal)resultset[2]) ? ZERO_CURRENCY : resultset[2]), StatementOfEarningsReportDataSource.toCurrencyFormat(BigDecimalMapper.isZeroOrNull((BigDecimal)resultset[1]) ? ZERO_CURRENCY : resultset[1])));
                }
                this.FIELD_LOANDATAS = loanDatas;
            }
            if (this.mCompanySettings.getDeductionsIncludingTransfersOnSoE()) {
                ArrayList<StatementOfEarningsPayDeductionBean> payDeductionBeans = new ArrayList<StatementOfEarningsPayDeductionBean>();
                this.addPayDeductions(payDeductionBeans, this.mCurrentOidEmployee);
                this.addPayDeductionsPensionScheme(payDeductionBeans, this.mCurrentOidEmployee);
                this.FIELD_PAYDEDUCTIONDATAS = payDeductionBeans;
                this.FIELD_ATTACHMENTDATAS = this.getAttachmentBeans(this.mCurrentOidEmployee);
            }
            if (this.mCompanySettings.getRelativeOfEarnings()) {
                this.FIELD_CHILDALLOWANCEDATAS = this.getChildAllowanceBeans(employee);
            }
            if (this.mCompanySettings.getLeaveAccountsOnSoE()) {
                StatementOfEarningsHolidayMapper mapper = new StatementOfEarningsHolidayMapper(this.mCurrentOidEmployee, this.mForEffectiveDate, validFrom);
                this.FIELD_HOLIDAYDATAS = mapper.getHolidayBeans();
            }
            if (this.mCompanySettings.getStatisticsAndRunningTotalOnSoE()) {
                StatementOfEarningsCreditInfoBean infoBean;
                BalanceMonth[] balanceMonths;
                ValueType vt;
                String valuetypeKey;
                HashMap<CallSite, StatementOfEarningsCreditInfoBean> infoBeanHashMap = new HashMap<CallSite, StatementOfEarningsCreditInfoBean>();
                Date newEffectiveDate = this.mForEffectiveDate;
                PartCostCenter[] newValidDate = DateHelper.getLastDayOfMonth((Date)validFrom);
                Date oldEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
                PartCostUnit[] oldValidDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)validFrom));
                ArrayList<StatementOfEarningsCreditInfoBean> creditInfoDatas = new ArrayList<StatementOfEarningsCreditInfoBean>();
                EEDataCreditTP[] newDataCredits = employee.getEEDataCredits(newEffectiveDate, (Date)newValidDate);
                for (EEDataCreditTP cdTP : newDataCredits) {
                    CreditModel creditModel = cdTP.getEEDataCredit().getCreditModel();
                    if (creditModel == null) continue;
                    CreditModelTP creditModelTP = creditModel.getCreditModelTP(newEffectiveDate, (Date)newValidDate);
                    valuetypeKey = Integer.toString(StatementOfEarningsReportDataSource.toValueTypeNumber(creditModel.getTypeOfCredit()));
                    vt = ValueTypePersistencyManager.getValueTypeByKey((String)valuetypeKey);
                    if (vt == null) continue;
                    CreditInfo creditInfoNew = new CreditInfo(employee, vt, newEffectiveDate, (Date)newValidDate);
                    for (BalanceMonth balanceMonth : balanceMonths = creditInfoNew.getBalanceMonths()) {
                        if (!DateHelper.between((Date)balanceMonth.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)newValidDate), (Date)newValidDate)) continue;
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getOldAmount()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getNewAmount())) {
                            infoBean = new StatementOfEarningsCreditInfoBean(StatementOfEarningsReportDataSource.toString(balanceMonth.getValidFrom()), creditModel.getCreditModelKey() + " / " + creditModelTP.getShortDescription(), balanceMonth.getOldAmount(), balanceMonth.getEntryAmount(), balanceMonth.getWithdrawalAmount(), BigDecimal.ZERO, balanceMonth.getNewAmount(), true);
                            infoBeanHashMap.put((CallSite)((Object)(creditInfoNew.getValueTypeNumber() + "true")), infoBean);
                        }
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getOldHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getNewHours())) continue;
                        infoBean = new StatementOfEarningsCreditInfoBean(StatementOfEarningsReportDataSource.toString(balanceMonth.getValidFrom()), creditModel.getCreditModelKey() + " / " + creditModelTP.getShortDescription(), balanceMonth.getOldHours(), balanceMonth.getEntryHours(), balanceMonth.getWithdrawalHours(), BigDecimal.ZERO, balanceMonth.getNewHours(), false);
                        infoBeanHashMap.put((CallSite)((Object)(creditInfoNew.getValueTypeNumber() + "false")), infoBean);
                    }
                }
                EEDataCreditTP[] oldDataCredits = employee.getEEDataCredits(oldEffectiveDate, (Date)oldValidDate);
                for (EEDataCreditTP cdTP : oldDataCredits) {
                    CreditModel creditModel = cdTP.getEEDataCredit().getCreditModel();
                    if (creditModel == null || (vt = ValueTypePersistencyManager.getValueTypeByKey((String)(valuetypeKey = Integer.toString(StatementOfEarningsReportDataSource.toValueTypeNumber(creditModel.getTypeOfCredit()))))) == null) continue;
                    CreditInfo creditInfoOld = new CreditInfo(employee, vt, oldEffectiveDate, (Date)oldValidDate);
                    for (BalanceMonth balanceMonth : balanceMonths = creditInfoOld.getBalanceMonths()) {
                        if (!DateHelper.between((Date)balanceMonth.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)oldValidDate), (Date)oldValidDate)) continue;
                        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getOldAmount()) && BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getNewAmount()) || (infoBean = (StatementOfEarningsCreditInfoBean)infoBeanHashMap.get(creditInfoOld.getValueTypeNumber() + "true")) == null)) {
                            infoBean.setAlterSaldoBD(balanceMonth.getNewAmount());
                        }
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getOldHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)balanceMonth.getNewHours()) || (infoBean = (StatementOfEarningsCreditInfoBean)infoBeanHashMap.get(creditInfoOld.getValueTypeNumber() + "false")) == null) continue;
                        infoBean.setAlterSaldoBD(balanceMonth.getNewHours());
                    }
                }
                for (StatementOfEarningsCreditInfoBean infoBean2 : infoBeanHashMap.values()) {
                    infoBean2.setRueckrechnungBD(infoBean2.getNeuerSaldoBD().subtract(infoBean2.getAbgangBD()).subtract(infoBean2.getZugangBD()).subtract(infoBean2.getAlterSaldoBD()));
                    creditInfoDatas.add(infoBean2);
                }
                this.FIELD_CREDITINFODATAS = creditInfoDatas;
            }
            if (this.mCompanySettings.getAuxiliaryCostUnitsOnSoE() && employmentContainer != null) {
                PartCostUnit[] partCostUnits;
                PartCostCenter[] partCostCenters;
                ArrayList<StatementOfEarningsCostCenterSplitBean> costCenterSplitDatas = new ArrayList<StatementOfEarningsCostCenterSplitBean>();
                for (PartCostCenter pcc : partCostCenters = employee.getEmployment(this.mForEffectiveDate, this.mForValidDate).getPartCostCenters()) {
                    String costCenterKey = pcc.getCostCenter().getCostCenter();
                    String costCenterDescription = pcc.getCostCenter().getCostCenterTP(this.mForEffectiveDate, this.mForValidDate).getShortDescription();
                    costCenterSplitDatas.add(new StatementOfEarningsCostCenterSplitBean(costCenterKey + " " + costCenterDescription, StatementOfEarningsReportDataSource.toString(pcc.getPercentage(), 3)));
                }
                this.FIELD_COSTCENTERSPLITDATAS = costCenterSplitDatas;
                ArrayList<StatementOfEarningsCostUnitSplitBean> costUnitSplitDatas = new ArrayList<StatementOfEarningsCostUnitSplitBean>();
                for (PartCostUnit pcu : partCostUnits = employee.getEmployment(this.mForEffectiveDate, this.mForValidDate).getPartCostUnits()) {
                    String costUnitKey = pcu.getCostUnit().getCostUnit();
                    String costUnitDescription = pcu.getCostUnit().getCostUnitTP(this.mForEffectiveDate, this.mForValidDate).getShortDescription();
                    costUnitSplitDatas.add(new StatementOfEarningsCostUnitSplitBean(costUnitKey + " " + costUnitDescription, StatementOfEarningsReportDataSource.toString(pcu.getPercentage(), 3)));
                }
                this.FIELD_COSTUNITSPLITDATAS = costUnitSplitDatas;
            }
            ArrayList<StatementOfEarningsERABean> eraDatas = new ArrayList<StatementOfEarningsERABean>();
            EEDataERA eeDataERA = (EEDataERA)employee.getDataERAHistory().getItemOrNull(this.mForEffectiveDate, DateHelper.getLastDayOfMonth((Date)validFrom));
            EEDataERAHelper.ERAValueForDisplay eRAValueForDisplay = eraValueForDisplay = eeDataERA == null ? null : EEDataERAHelper.getERAValueForDisplay((Employee)employee, (Date)this.mForEffectiveDate, (Date)DateHelper.getLastDayOfMonth((Date)validFrom), (EEDataERA)eeDataERA);
            if (eraValueForDisplay != null) {
                StatementOfEarningsERABean eraBean = new StatementOfEarningsERABean(eraValueForDisplay.methodOfPaymentAsString, eraValueForDisplay.descriptionOfPayScaleLevel, eraValueForDisplay.descriptionOfPayScaleGroup, (String)(eraValueForDisplay.durationInMonth < 0 ? Integer.toString(eraValueForDisplay.durationInMonth) + " Mon." : ""), StatementOfEarningsReportDataSource.toString(eraValueForDisplay.validFromPayScaleGroup), StatementOfEarningsReportDataSource.toCurrencyFormat(eraValueForDisplay.amountBeforConversion.setScale(2, RoundingMode.HALF_UP)), StatementOfEarningsReportDataSource.toString(eraValueForDisplay.correctionFactor, 3), StatementOfEarningsReportDataSource.toString(eraValueForDisplay.IRWAZ) + " Std.", StatementOfEarningsReportDataSource.toString(eraValueForDisplay.RTWAZ) + " Std.", StatementOfEarningsReportDataSource.toString(eraValueForDisplay.percOfPerformanceERA) + " %");
                eraDatas.add(eraBean);
            }
            this.FIELD_ERADATAS = eraDatas;
            if (this.mCompanySettings.getPayScaleStatementsAndWagesFactorOnSoE()) {
                ArrayList<StatementOfEarningsWageFactorBean> wageFactorDatas = new ArrayList<StatementOfEarningsWageFactorBean>();
                List eeWageFactorList = this.mQueries.queryEEWageFactorAllContainers(this.mCurrentOidEmployee);
                for (EewagefactorallContainer eeWagefactorallContainer : eeWageFactorList) {
                    WageFactorTP wageFactorTP = this.mCache.getWageFactorTP(eeWagefactorallContainer.oidwagefactor);
                    if (!wageFactorTP.getPrintOnStatementOfEarnings()) continue;
                    int scale = wageFactorTP.getNumberDecimalPlaces();
                    wageFactorDatas.add(new StatementOfEarningsWageFactorBean(eeWagefactorallContainer.wagefactorkey, wageFactorTP.getLongDescription(), StatementOfEarningsReportDataSource.toCurrencyFormat(eeWagefactorallContainer.dues.setScale(scale, RoundingMode.HALF_UP)), StatementOfEarningsReportDataSource.toString(eeWagefactorallContainer.validfrom)));
                }
                this.FIELD_WAGEFACTORDATAS = wageFactorDatas;
                ArrayList<StatementOfEarningsScalePaymentBean> scalePaymentDatas = new ArrayList<StatementOfEarningsScalePaymentBean>();
                List scalePaymentList = this.mQueries.queryScalePaymentAllContainers(this.mCurrentOidEmployee);
                for (ScalepaymentallContainer scalepaymentallContainer : scalePaymentList) {
                    PayScaleGroupTP payScaleGroupTP = PayScaleGroup.getPayScaleGroup((String)scalepaymentallContainer.oidpayscalegroup).getPayScaleGroupTP(this.mForEffectiveDate, this.mForValidDate);
                    BigDecimal wert = payScaleGroupTP.getPayScaleLevel(scalepaymentallContainer.payscalelevel).getPayScaleValue();
                    Date gueltigAb = payScaleGroupTP.getValidFrom();
                    scalePaymentDatas.add(new StatementOfEarningsScalePaymentBean(this.mCache.getPayScale(scalepaymentallContainer.oidpayscale).getPayScaleKey(), this.mCache.getPayScaleGroup(scalepaymentallContainer.oidpayscalegroup).getPayScaleGroupKey(), Integer.toString(scalepaymentallContainer.payscalelevel), this.mCache.getPayScaleGroupLevelDescription(scalepaymentallContainer.oidpayscalegroup, scalepaymentallContainer.payscalelevel), StatementOfEarningsReportDataSource.toCurrencyFormat(wert.setScale(2)), StatementOfEarningsReportDataSource.toString(scalepaymentallContainer.validfrom), StatementOfEarningsReportDataSource.toString(gueltigAb), StatementOfEarningsReportDataSource.toString(scalepaymentallContainer.nextupgrading)));
                }
                this.FIELD_SCALEPAYMENTDATAS = scalePaymentDatas;
            }
            if ((eebankdetailsallContainer = this.mCache.getEEBankDetailsAllContainer(this.mCurrentOidEmployee)) != null) {
                switch (eebankdetailsallContainer.modeofpayment) {
                    case 0: {
                        this.mZahlart = "\u00dcberweisungsbetrag";
                        String string = this.FIELD_KONTOINHABER = StringMapper.isNullString((String)eebankdetailsallContainer.ownerofaccount) ? eebankdetailsallContainer.surname + ", " + eebankdetailsallContainer.firstname : eebankdetailsallContainer.ownerofaccount;
                        if (eebankdetailsallContainer.oidbank == null) break;
                        this.FIELD_AN_BANK = "BIC: " + this.mCache.getBankFoundations(eebankdetailsallContainer.oidbank).getBicCode() + "      IBAN: " + ReportHelper.toIbanFormat((String)eebankdetailsallContainer.iban);
                        break;
                    }
                    case 1: {
                        this.mZahlart = "Scheckbetrag";
                        break;
                    }
                    case 2: {
                        this.mZahlart = "Barzahlungsbetrag";
                    }
                }
            }
        }
    }

    protected List<EeabsenttimeallContainer> getEEAbsenttimeallContainerList(String oidEmployee, Date forValidDate) {
        return this.mQueries.queryEEAbsenttimeAllContainers(oidEmployee, forValidDate);
    }

    private static String firstNonNullString(String ... strings) {
        for (String s : strings) {
            if (StringMapper.isNullString((String)s)) continue;
            return s;
        }
        return "";
    }

    private static int toValueTypeNumber(TypeOfCreditEnum typeOfCredit) {
        switch (typeOfCredit.value()) {
            case 0: {
                return 801000;
            }
            case 1: {
                return 802000;
            }
            case 2: {
                return 803000;
            }
            case 3: {
                return 804000;
            }
            case 4: {
                return 805000;
            }
            case 5: {
                return 806000;
            }
            case 6: {
                return 807000;
            }
        }
        throw new IllegalArgumentException(typeOfCredit.toString());
    }

    private static String toStringTaxBracket(int taxbracket) {
        switch (taxbracket) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
        }
        return "keine";
    }

    private static String toStringDuesGroupHi(int duesgrouphi) {
        switch (duesgrouphi) {
            case 0: {
                return "kein Pflichtbeitrag";
            }
            case 1: {
                return "allgemeiner Beitrag";
            }
            case 2: {
                return "erh\u00f6hter Beitrag";
            }
            case 3: {
                return "erm\u00e4\u00dfigter Beitrag";
            }
            case 4: {
                return "LKK-versichert";
            }
            case 5: {
                return "(AG) Beitrag zur LKK ";
            }
            case 6: {
                return "Pauschalbeitrag GfB (AG)";
            }
            case 9: {
                return "Firmenzahler freiw. KV";
            }
        }
        return "keine Angaben";
    }

    private static String toStringDuesGroupPi(int duesgrouppi) {
        switch (duesgrouppi) {
            case 0: {
                return "kein Pflichtbeitrag";
            }
            case 1: {
                return "voller Beitrag";
            }
            case 2: {
                return "voller Beitrag zur AnV";
            }
            case 3: {
                return "halber Beitrag";
            }
            case 4: {
                return "halber Beitrag zur AnV";
            }
            case 5: {
                return "Pauschalbeitrag GfB";
            }
            case 6: {
                return "Pauschalbeitrag zur AnV GfB";
            }
        }
        return "keine Angaben";
    }

    private static String toStringDuesGroupUiNi(int duesgroup) {
        switch (duesgroup) {
            case 0: {
                return "kein Pflichtbeitrag";
            }
            case 1: {
                return "voller Beitrag";
            }
            case 2: {
                return "halber Beitrag";
            }
        }
        return "keine Angaben";
    }

    private static String toStringPersonGroup(int persongroup) {
        switch (persongroup) {
            case 101: {
                return "ohne besondere Merkmale";
            }
            case 102: {
                return "Auszubildende";
            }
            case 103: {
                return "Altersteilzeit";
            }
            case 104: {
                return "Hausgewerbetreibende";
            }
            case 105: {
                return "Praktikanten";
            }
            case 106: {
                return "Werksstudenten";
            }
            case 107: {
                return "Behinderte Menschen";
            }
            case 108: {
                return "Vorruhestandsgeld";
            }
            case 109: {
                return "Geringf\u00fcgig Besch\u00e4ftigte";
            }
            case 110: {
                return "Kurzfristig Besch\u00e4ftigte";
            }
            case 111: {
                return "Jugendhilfe";
            }
            case 112: {
                return "Familienangeh\u00f6rige Landwirtschaft";
            }
            case 113: {
                return "Nebenerwerbslandwirte";
            }
            case 114: {
                return "Nebenerwerbslandwirte - saisonal besch\u00e4ftigt";
            }
            case 116: {
                return "Ausgleichsgeldempf\u00e4nger nach dem FELEG";
            }
            case 118: {
                return "Unst\u00e4ndig Besch\u00e4ftigte";
            }
            case 119: {
                return "vers.-fr. Altersvollrentner u. Versorgungsbezieher wg. Alters";
            }
            case 120: {
                return "vers.-pfl. Altersvollrentner";
            }
            case 121: {
                return "Auszubildene, deren AE Geringverdienergrenze nicht \u00fcbersteigt";
            }
            case 122: {
                return "Auszubildene in einer au\u00dferbetr. Einrichtung";
            }
            case 123: {
                return "Personen, die ein freiwilliges soziales beziehungsweise \u00f6kologisches Jahr oder einen Bundesfreiwilligendienst leisten";
            }
            case 124: {
                return "Heimarbeiter o. Anspruch auf EFZ im Krankheitsfall";
            }
            case 127: {
                return "Behinderte Menschen mit Besch\u00e4ftigung im Intregationsamt";
            }
            case 190: {
                return "Besch\u00e4ftigte, die ausschlie\u00dflich in der gesetzl. UV versichert sind";
            }
            case 981: {
                return "Krankenversicherung der Rentner";
            }
            case 982: {
                return "vers.-fr. Praktikanten";
            }
            case 983: {
                return "vers.-fr. Gesch\u00e4ftsf\u00fchrer";
            }
            case 984: {
                return "vers.-fr. AG-Vorstandsmitglieder";
            }
            case 999: {
                return "Angabe nicht m\u00f6glich";
            }
        }
        return "keine Angaben";
    }

    private void fillFieldsArbeit(WorkingTime workingTime, Date validUntil, WorkingtimeallContainer workingtimeallContainer) throws BusinessDomainException {
        BigDecimal monthlyConcreteTargetDays = workingTime.getMonthlyConcreteTargetDays(StatementOfEarningsReportDataSource.toMonthInt(validUntil), StatementOfEarningsReportDataSource.toYearInt(validUntil), this.mCurrentEmployee, this.mForEffectiveDate, validUntil, false);
        this.FIELD_ARBEITSTAGE = StatementOfEarningsReportDataSource.toString(monthlyConcreteTargetDays, 2);
        if (workingtimeallContainer != null) {
            this.FIELD_WOCHENARBEITSZEIT = workingtimeallContainer.weeklyworkingtime;
            this.FIELD_WOCHENARBEITSTAGE = workingtimeallContainer.workingdaysperweek;
        } else {
            WorkingTimeTP workingTimeTP = workingTime.getWorkingTimeTP(this.mForEffectiveDate, validUntil);
            this.FIELD_WOCHENARBEITSZEIT = workingTimeTP.getWeeklyWorkingTime();
            this.FIELD_WOCHENARBEITSTAGE = workingTimeTP.getWorkingDaysPerWeek();
        }
    }

    private String getRueckfragenAn(EmploymentContainer employmentContainer, Date validFrom) throws BusinessDomainException {
        Object result = "";
        if (!StringMapper.isNullString((String)employmentContainer.oidpersonincharge1) && this.mCompanySettings.getPrintPersonInCharge1()) {
            result = "Bei R\u00fcckfragen wenden Sie sich bitte an " + this.mStatementOfEarningsReportHelper.toString(this.mCache.getPersonInChargeTP(employmentContainer.oidpersonincharge1, validFrom));
        }
        if (!StringMapper.isNullString((String)employmentContainer.oidpersonincharge2) && this.mCompanySettings.getPrintPersonInCharge2()) {
            result = StringMapper.isNullString((String)result) ? "Bei R\u00fcckfragen wenden Sie sich bitte an " : (String)result + " oder ";
            result = (String)result + this.mStatementOfEarningsReportHelper.toString(this.mCache.getPersonInChargeTP(employmentContainer.oidpersonincharge2, validFrom));
        }
        return result;
    }

    public static String toString(FormOfAddressEnum formOfAddress) {
        switch (formOfAddress.value()) {
            case 1: {
                return "Frau";
            }
            case 2: {
                return "Herrn";
            }
        }
        return "";
    }

    private void setDynamicFieldValue(String fieldValue, String labelValue, int fieldIndex) {
        switch (fieldIndex) {
            case 1: {
                this.FIELD_DYNAMICFIELD1 = fieldValue;
                this.FIELD_DYNAMICLABEL1 = labelValue;
                break;
            }
            case 2: {
                this.FIELD_DYNAMICFIELD2 = fieldValue;
                this.FIELD_DYNAMICLABEL2 = labelValue;
                break;
            }
            case 3: {
                this.FIELD_DYNAMICFIELD3 = fieldValue;
                this.FIELD_DYNAMICLABEL3 = labelValue;
                break;
            }
            case 4: {
                this.FIELD_DYNAMICFIELD4 = fieldValue;
                this.FIELD_DYNAMICLABEL4 = labelValue;
            }
        }
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put("LogoOfCompany", ReportHelper.getLogoOfCompany((String)this.mOidPCompanyForFoundations, (Date)this.mForEffectiveDate, (Date)this.mForValidDate));
        return parameters;
    }

    protected Map<String, ValuepositionContainer> createSumValuePositionMap(String oidEmployee) {
        HashMap<String, ValuepositionContainer> sumValuePositionHashMap = new HashMap<String, ValuepositionContainer>();
        Date beginDate = this.mBeginYearDate;
        Date endDate = DateHelper.getLastDayOfMonth((Date)beginDate);
        while (DateHelper.beforeOrEqual((Date)beginDate, (Date)this.mEndYearDate)) {
            this.addSumValuePositions(sumValuePositionHashMap, oidEmployee, beginDate, endDate);
            beginDate = DateHelper.tomorrow((Date)endDate);
            endDate = DateHelper.getLastDayOfMonth((Date)beginDate);
        }
        return sumValuePositionHashMap;
    }

    protected StatementOfEarningsResultBean createStatementOfEarningsResultBean(ValuepositionContainer vpContainer, boolean isSumVpContainer) throws BusinessDomainException {
        return new StatementOfEarningsResultBean(vpContainer, isSumVpContainer);
    }

    protected List<StatementOfEarningsResultBean> createVPList() throws BusinessDomainException {
        Date returnCalculationDate;
        StatementOfEarningsResultBean tempResultBean = new StatementOfEarningsResultBean();
        ArrayList<StatementOfEarningsResultBean> rrMonthSumList = new ArrayList<StatementOfEarningsResultBean>();
        ArrayList<Date[]> rcList = new ArrayList<Date[]>();
        ArrayList<StatementOfEarningsResultBean> rbList = new ArrayList<StatementOfEarningsResultBean>();
        this.mReturnCalculationDate = VDate.getDateMax();
        Map<String, ValuepositionContainer> sumValuePositionHashMap = this.createSumValuePositionMap(this.mCurrentOidEmployee);
        List<StatementOfEarningsResultBean> valuePositionList = this.queryStatementOfEarningsResultBeans(this.mCurrentOidEmployee, this.mBeginMonthDate, this.mEndMonthDate);
        List<StatementOfEarningsResultBean> resultBeanList = this.createResultBeanList(valuePositionList);
        Collections.sort(resultBeanList, new ResultBeanSortComparator());
        boolean firstVPContainer = true;
        for (StatementOfEarningsResultBean resultBean : resultBeanList) {
            if (resultBean.getValueTypeNumber() == 220800) {
                this.mChangeDescription = true;
            }
            if ((resultBean.getValueTypeNumber() == 890000 || resultBean.getValueTypeNumber() == 890100) && PDateHelper.getDiffInMonths((Date)this.mForEffectiveDate, (Date)this.mForValidDate) == 0) {
                if (resultBean.getValueTypeNumber() == 890000) {
                    this.mNetPay = resultBean.getResult();
                } else {
                    this.mNetPay = resultBean.getResult().negate();
                    this.mZahlart = "\u00dcberzahlungsbetrag";
                }
            } else {
                this.FIELD_ZAHLART = "";
            }
            if (resultBean.getValueTypeNumber() == 882000 && BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getResult()) || (resultBean.getValueTypeNumber() == 890000 || resultBean.getValueTypeNumber() == 890100) && PDateHelper.getDiffInMonths((Date)this.mForEffectiveDate, (Date)this.mForValidDate) != 0) continue;
            if (resultBean.getValueTypeNumber() != 882110) {
                ValuepositionContainer tempSumContainer;
                if (firstVPContainer) {
                    tempResultBean.setValueTypeNumber(0);
                }
                if (!resultBean.getCompressionKey().equals(tempResultBean.getCompressionKey())) {
                    if (firstVPContainer) {
                        firstVPContainer = false;
                        tempResultBean = resultBean;
                    } else {
                        tempSumContainer = sumValuePositionHashMap.get(tempResultBean.getSumCompressionKey());
                        if (tempSumContainer != null) {
                            tempResultBean.setSumResult(tempSumContainer.results);
                            tempResultBean.setSumFactor1(tempSumContainer.factor1);
                        }
                        rbList.add(tempResultBean);
                        tempResultBean = resultBean;
                    }
                } else if (resultBean.getValueTypeNumber() >= 100000) {
                    if (resultBean.getPrintOnSoEResult() != PrintEnum.PE_kein_Andruck || resultBean.getPrintOnSoEFactor1() != PrintEnum.PE_kein_Andruck || resultBean.getPrintOnSoEFactor2() != PrintEnum.PE_kein_Andruck) {
                        if (resultBean.getPrintOnSoEResult() != PrintEnum.PE_kein_Andruck) {
                            tempResultBean.setResult(tempResultBean.getResult().add(resultBean.getResult()));
                            tempResultBean.setOidCostCenter("");
                        }
                    } else {
                        tempResultBean.setOidCostCenter("");
                        tempSumContainer = sumValuePositionHashMap.get(tempResultBean.getSumCompressionKey());
                        if (tempSumContainer != null) {
                            tempResultBean.setSumResult(tempSumContainer.results);
                            tempResultBean.setSumFactor1(tempSumContainer.factor1);
                        }
                        rbList.add(tempResultBean);
                        tempResultBean = resultBean;
                    }
                } else if (resultBean.getCompressionOnSoe() != CompressionEnum.COME_keine_Verdichtung) {
                    tempResultBean.setResult(tempResultBean.getResult().add(resultBean.getResult()));
                    tempResultBean.setFactor1(tempResultBean.getFactor1().add(resultBean.getFactor1()));
                    if (!tempResultBean.getOidCostCenter().equals(resultBean.getOidCostCenter())) {
                        tempResultBean.setOidCostCenter("");
                    }
                    if (!tempResultBean.getFactor2().equals(resultBean.getFactor2())) {
                        tempResultBean.setFactor2(ZERO_CURRENCY);
                    }
                    if (!tempResultBean.getPercentage().equals(resultBean.getPercentage())) {
                        tempResultBean.setPercentage(ZERO_PERCENTAGE);
                    }
                    if (!tempResultBean.getPerformfactor().equals(resultBean.getPerformfactor())) {
                        tempResultBean.setPerformfactor(ZERO_PERCENTAGE);
                    }
                    String classificationString = resultBean.getBruttoEinordnung() + resultBean.getSteuerEinordnung() + resultBean.getSvEinordnung();
                    String tempClassificationString = tempResultBean.getBruttoEinordnung() + tempResultBean.getSteuerEinordnung() + tempResultBean.getSvEinordnung();
                    if (!tempClassificationString.equals(classificationString)) {
                        tempResultBean.setBruttoEinordnung("");
                        tempResultBean.setSteuerEinordnung("");
                        tempResultBean.setSvEinordnung("");
                    }
                    if (resultBean.getCompressionOnSoe() == CompressionEnum.COME_Verdichtung_auf_Wertartengruppe) {
                        String oidValueTypeGroup = resultBean.getOidValueTypeGroup();
                        tempResultBean.setShortDescription(this.mCache.getValueTypeGroupShortDescription(oidValueTypeGroup));
                        tempResultBean.setDescription(this.mCache.getValueTypeGroupLongDescription(oidValueTypeGroup));
                        tempResultBean.setBlankLineOnSoe(resultBean.getBlankLineOnSoe());
                        tempResultBean.setFontOnSoe(resultBean.getFontOnSoe());
                        tempResultBean.setPositionOnSoE(resultBean.getPositionOnSoE() < tempResultBean.getPositionOnSoE() ? resultBean.getPositionOnSoE() : tempResultBean.getPositionOnSoE());
                        if (resultBean.getPrintOnSoEFactor1() != PrintEnum.PE_kein_Andruck) {
                            tempResultBean.setPrintOnSoEFactor1(resultBean.getPrintOnSoEFactor1().value() < tempResultBean.getPrintOnSoEFactor1().value() ? resultBean.getPrintOnSoEFactor1() : tempResultBean.getPrintOnSoEFactor1());
                        }
                        if (resultBean.getPrintOnSoEFactor2() != PrintEnum.PE_kein_Andruck) {
                            tempResultBean.setPrintOnSoEFactor2(resultBean.getPrintOnSoEFactor2().value() < tempResultBean.getPrintOnSoEFactor2().value() ? resultBean.getPrintOnSoEFactor2() : tempResultBean.getPrintOnSoEFactor2());
                        }
                        if (resultBean.getPrintOnSoEResult() != PrintEnum.PE_kein_Andruck) {
                            tempResultBean.setPrintOnSoEResult(resultBean.getPrintOnSoEResult().value() < tempResultBean.getPrintOnSoEResult().value() ? resultBean.getPrintOnSoEResult() : tempResultBean.getPrintOnSoEResult());
                        }
                    }
                } else {
                    tempSumContainer = sumValuePositionHashMap.get(tempResultBean.getSumCompressionKey());
                    if (tempSumContainer != null) {
                        tempResultBean.setSumResult(tempSumContainer.results);
                        tempResultBean.setSumFactor1(tempSumContainer.factor1);
                    }
                    rbList.add(tempResultBean);
                    tempResultBean = resultBean;
                }
                if (resultBean.getValueTypeNumber() != 882000) continue;
                StatementOfEarningsResultBean tempBean = new StatementOfEarningsResultBean(resultBean);
                tempBean.setFactor1(ZERO_CURRENCY);
                tempBean.setFactor2(ZERO_CURRENCY);
                tempBean.setResult(ZERO_CURRENCY);
                tempBean.setPercentage(ZERO_PERCENTAGE);
                tempBean.setValueTypeNumber(-1);
                rbList.add(tempBean);
                continue;
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getResult()) || PDateHelper.getDiffInMonths((Date)resultBean.getEffectiveFrom(), (Date)this.mBeginMonthDate) != 0) continue;
            rrMonthSumList.add(resultBean);
            this.mReturnCalculationDate = DateHelper.min((Date)this.mReturnCalculationDate, (Date)resultBean.getValidFrom());
            if (this.mCorrectionsoe != CorrectionEnum.CE_KORREKTUR_VERDIENSTNACHWEISE && this.mCorrectionsoe != CorrectionEnum.CE_KORREKTUR_VERDIENSTNACHWEISE_EINZEILIG) continue;
            rcList.add(new Date[]{resultBean.getValidFrom(), resultBean.getValidUntil()});
        }
        if (this.mReturnCalculationAll && (returnCalculationDate = this.mCache.getCalculationBasicValidFrom(this.mCurrentOidEmployee)) != null) {
            if (DateHelper.before((Date)returnCalculationDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))) {
                this.mReturnCalculationDate = returnCalculationDate;
                rcList.clear();
            }
            while (DateHelper.before((Date)returnCalculationDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))) {
                Date[] rcDatas = new Date[]{DateHelper.getFirstDayOfMonth((Date)returnCalculationDate), DateHelper.getLastDayOfMonth((Date)returnCalculationDate)};
                rcList.add(rcDatas);
                returnCalculationDate = DateHelper.tomorrow((Date)rcDatas[1]);
            }
        }
        if (!firstVPContainer) {
            ValuepositionContainer tempSumContainer = sumValuePositionHashMap.get(tempResultBean.getSumCompressionKey());
            if (tempSumContainer != null) {
                tempResultBean.setSumResult(tempSumContainer.results);
                tempResultBean.setSumFactor1(tempSumContainer.factor1);
            }
            rbList.add(tempResultBean);
            this.addAnnualValueEveryMonthSumBeans(rbList, sumValuePositionHashMap);
            if (this.mCorrectionsoe == CorrectionEnum.CE_KORREKTUR_DIFFERENZEN) {
                rbList.addAll(rrMonthSumList);
            }
            Collections.sort(rcList, new RCDateComparator());
            this.mRCIterator = rcList.iterator();
        }
        this.verarbeitungKeinAndruck(rbList);
        return this.factoryResultBeanList(rbList);
    }

    protected void verarbeitungKeinAndruck(List<StatementOfEarningsResultBean> rbList) {
        for (StatementOfEarningsResultBean resultBean : new ArrayList<StatementOfEarningsResultBean>(rbList)) {
            if (resultBean.getValueTypeNumber() >= 880000 || !this.keinAndruck(resultBean)) continue;
            rbList.remove(resultBean);
        }
    }

    private boolean keinAndruck(int noprintbyzero, BigDecimal result, BigDecimal factor1, BigDecimal factor2) {
        switch (noprintbyzero) {
            case 1: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)factor1);
            }
            case 2: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)factor2);
            }
            case 3: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)result);
            }
            case 4: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)factor1) || BigDecimalMapper.isZeroOrNull((BigDecimal)factor2);
            }
            case 5: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)factor1) || BigDecimalMapper.isZeroOrNull((BigDecimal)result);
            }
            case 6: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)factor2) || BigDecimalMapper.isZeroOrNull((BigDecimal)result);
            }
            case 7: {
                return BigDecimalMapper.isZeroOrNull((BigDecimal)factor1) || BigDecimalMapper.isZeroOrNull((BigDecimal)factor2) || BigDecimalMapper.isZeroOrNull((BigDecimal)result);
            }
        }
        return false;
    }

    private boolean keinAndruck(ValuepositionContainer valueposition) {
        ValuetypesallContainer valuetype = this.mCache.getValueTypeAllContainer(valueposition.oidvaluetype);
        return this.keinAndruck(valuetype.noprintbyzero, valueposition.results, valueposition.factor1, valueposition.factor2);
    }

    private boolean keinAndruck(StatementOfEarningsResultBean bean) {
        return this.keinAndruck(bean.getNoPrintByZero().value(), bean.getResult(), bean.getFactor1(), bean.getFactor2());
    }

    protected void addAnnualValueEveryMonthSumBeans(List<StatementOfEarningsResultBean> rbList, Map<String, ValuepositionContainer> sumValuePositionHashMap) throws BusinessDomainException {
        HashSet<String> rbListSumCompressionKeys = new HashSet<String>();
        for (StatementOfEarningsResultBean resultBean : rbList) {
            rbListSumCompressionKeys.add(resultBean.getSumCompressionKey());
        }
        ArrayList<StatementOfEarningsResultBean> soeBeanList = new ArrayList<StatementOfEarningsResultBean>();
        Collection annualValueEveryMonthSumCompressionKeys = this.mCache.getAnnualValueEveryMonthSumCompressionKeys();
        for (Map.Entry<String, ValuepositionContainer> entry : sumValuePositionHashMap.entrySet()) {
            String sumCompressionKey = entry.getKey();
            if (!annualValueEveryMonthSumCompressionKeys.contains(sumCompressionKey) || rbListSumCompressionKeys.contains(sumCompressionKey)) continue;
            ValuepositionContainer vpContainer = entry.getValue();
            StatementOfEarningsResultBean soeBean = this.createStatementOfEarningsResultBean(vpContainer, true);
            soeBean.setInfoText(this.getInfoText(vpContainer));
            soeBean.setCompressionKey(this.generateCompressionKey(vpContainer));
            soeBean.setSumCompressionKey(this.generateSumCompressionKey(vpContainer));
            soeBeanList.add(soeBean);
        }
        List<StatementOfEarningsResultBean> annualValueBeans = this.createResultBeanList(soeBeanList);
        if (!annualValueBeans.isEmpty()) {
            rbList.addAll(annualValueBeans);
            Collections.sort(rbList, new ResultBeanSortComparator());
        }
    }

    protected Iterator<StatementOfEarningsResultBean> createRCVPList(Date rcValidFrom, Date rcValidUntil) throws BusinessDomainException {
        RRValuesMap rrValuesMap = new RRValuesMap();
        this.FIELD_INFODATAS = null;
        this.FIELD_PAYDEDUCTIONDATAS = null;
        PersistencyDataSet rrNewDatas = this.getRueckrechnungsDatenNeu(this.mCurrentOidEmployee, rcValidFrom, rcValidUntil);
        PersistencyDataSet rrOldDatas = this.getRueckrechnungsDatenAlt(this.mCurrentOidEmployee, rcValidFrom, rcValidUntil);
        while (rrNewDatas.hasNext()) {
            ValuepositionContainer rrNewContainer = (ValuepositionContainer)rrNewDatas.getNext();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)rrNewContainer.additionalamount2)) continue;
            this.createClassificationFieldLists(rrNewContainer);
            rrValuesMap.addRRNew(rrNewContainer);
        }
        while (rrOldDatas.hasNext()) {
            ValuepositionContainer tempRROldListContainer = (ValuepositionContainer)rrOldDatas.getNext();
            if (!this.processValueType(tempRROldListContainer)) continue;
            this.createClassificationFieldLists(tempRROldListContainer);
            rrValuesMap.addRROld(tempRROldListContainer);
        }
        List<StatementOfEarningsResultBean> vpList = this.createStornoNeu(rrValuesMap);
        return this.factoryResultBeanList(this.createResultBeanList(vpList)).iterator();
    }

    private boolean processValueType(ValuepositionContainer vpContainer) {
        switch (vpContainer.valuetypenumber) {
            case 795062: 
            case 795063: 
            case 795064: 
            case 795065: 
            case 795072: 
            case 795074: 
            case 795082: 
            case 795084: 
            case 795092: 
            case 795094: 
            case 795552: 
            case 795554: 
            case 861112: 
            case 861114: 
            case 862112: 
            case 862114: 
            case 863112: 
            case 863114: 
            case 863122: 
            case 863124: 
            case 863132: 
            case 863134: 
            case 863142: 
            case 863144: 
            case 863152: 
            case 863154: 
            case 863162: 
            case 863164: {
                return false;
            }
        }
        return true;
    }

    private String getInfoText(ValuepositionContainer vpContainer) {
        return !this.hasCompression(vpContainer) && vpContainer.genesisparenttype == 4 ? this.mQueries.queryVarPaymentAddInformation(vpContainer.oidgenesisparent) : "";
    }

    private boolean hasCompression(ValuepositionContainer vpContainer) {
        if (vpContainer.valuetypenumber >= 100000) {
            return true;
        }
        ValuetypesallContainer vtContainer = this.mCache.getValueTypeAllContainer(vpContainer.oidvaluetype);
        return vtContainer != null && vtContainer.compressiononsoe != 0;
    }

    private List<StatementOfEarningsResultBean> createStornoNeu(RRValuesMap rrValuesMap) throws BusinessDomainException {
        boolean einzeilig = this.mCorrectionsoe == CorrectionEnum.CE_KORREKTUR_VERDIENSTNACHWEISE_EINZEILIG;
        ArrayList keys = new ArrayList(rrValuesMap.keySet());
        ArrayList<StatementOfEarningsResultBean> resultBeans = new ArrayList<StatementOfEarningsResultBean>();
        Collections.sort(keys);
        for (String key : keys) {
            List rrValuesList = (List)rrValuesMap.get(key);
            for (RRValues rrValues : rrValuesList) {
                boolean rrOldMissing;
                boolean rrNewMissing;
                boolean bl = rrNewMissing = rrValues.rrNew == null;
                if (rrNewMissing) {
                    rrValues.rrNew = this.cloneWithZeroValues(rrValues.rrOld);
                }
                boolean bl2 = rrOldMissing = rrValues.rrOld == null;
                if (rrOldMissing) {
                    rrValues.rrOld = this.cloneWithZeroValues(rrValues.rrNew);
                }
                if (rrValues.rrOld.results == null) continue;
                if (rrValues.rrNew.valuetypenumber != 882110) {
                    StatementOfEarningsResultBean resultBean;
                    if (this.keinAndruck(rrValues.rrOld) && this.keinAndruck(rrValues.rrNew) && rrValues.rrOld.valuetypenumber < 880000 && rrValues.rrNew.valuetypenumber < 880000) continue;
                    if (this.isEqual(rrValues.rrOld, rrValues.rrNew)) {
                        resultBean = this.createStatementOfEarningsResultBean(rrValues.rrOld, false);
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getResult()) && BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getFactor1()) && BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getFactor2())) continue;
                        resultBean.setInfoText(rrValues.infoText);
                        resultBeans.add(resultBean);
                        continue;
                    }
                    if (einzeilig) {
                        rrValues.rrNew.buffer4 = rrValues.rrOld.factor1.negate();
                        rrValues.rrNew.buffer5 = rrValues.rrOld.results.negate();
                        if (rrNewMissing) {
                            rrValues.rrNew.factor2 = rrValues.rrOld.factor2;
                        } else if (!rrOldMissing && BigDecimalMapper.compareTo((BigDecimal)rrValues.rrNew.factor2, (BigDecimal)rrValues.rrOld.factor2) != 0) {
                            rrValues.rrNew.factor2 = BigDecimal.ZERO;
                        }
                        rrValues.rrNew.parenttype = 998;
                        resultBean = this.createStatementOfEarningsResultBean(rrValues.rrNew, false);
                        resultBean.setInfoText(rrValues.infoText);
                        resultBeans.add(resultBean);
                        continue;
                    }
                    if (!rrOldMissing) {
                        rrValues.rrOld.results = rrValues.rrOld.results.negate();
                        rrValues.rrOld.parenttype = 999;
                        StatementOfEarningsResultBean soeBeanOld = this.createStatementOfEarningsResultBean(rrValues.rrOld, false);
                        soeBeanOld.setInfoText(rrValues.infoText);
                        resultBeans.add(soeBeanOld);
                    }
                    if (rrNewMissing) continue;
                    rrValues.rrNew.parenttype = 1000;
                    StatementOfEarningsResultBean soeBeanNew = this.createStatementOfEarningsResultBean(rrValues.rrNew, false);
                    if (!rrOldMissing && StringMapper.isNullString((String)rrValues.infoText)) {
                        soeBeanNew.setPrintDescription(false);
                    }
                    soeBeanNew.setInfoText(rrValues.infoText);
                    resultBeans.add(soeBeanNew);
                    continue;
                }
                rrValues.rrNew.factor2 = ZERO_CURRENCY;
                rrValues.rrNew.factor1 = ZERO_CURRENCY;
                resultBeans.add(this.createStatementOfEarningsResultBean(rrValues.rrNew, false));
            }
        }
        return resultBeans;
    }

    protected List<StatementOfEarningsResultBean> createResultBeanList(List<StatementOfEarningsResultBean> resultBeans) throws BusinessDomainException {
        ArrayList<StatementOfEarningsResultBean> resultBeanList = new ArrayList<StatementOfEarningsResultBean>();
        for (StatementOfEarningsResultBean resultBean : resultBeans) {
            ValuetypesallContainer vtContainer = this.mCache.getValueTypeAllContainer(resultBean.getOidValueType());
            if (vtContainer == null || (vtContainer.printonsoefactor1 == 0 || BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getFactor1()) && !this.mReturnCalculation) && (vtContainer.printonsoefactor2 == 0 || BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getFactor2()) && !this.mReturnCalculation) && (vtContainer.printonsoeresult == 0 || BigDecimalMapper.isZeroOrNull((BigDecimal)resultBean.getResult()) && !this.mReturnCalculation) && vtContainer.valuetypenumber != 882000 && (vtContainer.valuetypenumber != 890000 || !this.mPrintWithoutNetpay && !this.mReturnCalculationAll) && !vtContainer.additionalboolean) continue;
            switch (vtContainer.typeofvaluetype) {
                case 0: {
                    resultBean.setRechenzeichen("i");
                    break;
                }
                case 1: {
                    resultBean.setRechenzeichen("+");
                    break;
                }
                case 2: {
                    resultBean.setRechenzeichen("-");
                }
            }
            resultBean.setNoPrintByZero(NoPrintByZeroEnum.from_int((int)vtContainer.noprintbyzero));
            resultBean.setPrintOnSoEFactor1(PrintEnum.from_int((int)vtContainer.printonsoefactor1));
            resultBean.setPrintOnSoEFactor2(PrintEnum.from_int((int)vtContainer.printonsoefactor2));
            resultBean.setPrintOnSoEResult(PrintEnum.from_int((int)vtContainer.printonsoeresult));
            resultBean.setPositionOnSoE(vtContainer.positiononsoe * 100 + 1);
            resultBean.setFontOnSoe(FontEnum.from_int((int)vtContainer.fontonsoe));
            resultBean.setBlankLineOnSoe(BlankLineEnum.from_int((int)vtContainer.blanklineonsoe));
            resultBean.setCompressionOnSoe(CompressionEnum.from_int((int)vtContainer.compressiononsoe));
            resultBean.setOidValueTypeGroup(vtContainer.oidvaluetypegroup);
            if (StringMapper.isNullString((String)resultBean.getOidValueTypeGroup()) || resultBean.getCompressionOnSoe() != CompressionEnum.COME_Verdichtung_auf_Wertartengruppe) {
                FoundationGeneral foundationGeneral = this.mCache.getValueTypeFoundationsByOid(resultBean.getOidValueType()).getGeneral();
                resultBean.setShortDescription(foundationGeneral.getShortDescription());
                resultBean.setDescription(foundationGeneral.getDescription());
            } else {
                String oidValueTypeGroup = resultBean.getOidValueTypeGroup();
                resultBean.setShortDescription(this.mCache.getValueTypeGroupShortDescription(oidValueTypeGroup));
                resultBean.setDescription(this.mCache.getValueTypeGroupLongDescription(oidValueTypeGroup));
            }
            if (resultBean.getValueTypeNumber() < 100000) {
                this.initClassificationFields(resultBean);
            }
            resultBeanList.add(resultBean);
        }
        return resultBeanList;
    }

    protected List<StatementOfEarningsResultBean> factoryResultBeanList(List<StatementOfEarningsResultBean> resultBeanList) {
        String oidValueType = "";
        int positionOnSoE = 0;
        ArrayList<StatementOfEarningsResultBean> resultBeans = new ArrayList<StatementOfEarningsResultBean>();
        boolean leerzeileNachher = false;
        Collections.sort(resultBeanList, new ResultBeanPositionComparator());
        for (StatementOfEarningsResultBean resultBean : resultBeanList) {
            boolean equals;
            boolean bl = equals = StringMapper.compareTo((String)oidValueType, (String)resultBean.getOidValueType()) == 0;
            if (equals) {
                resultBean.setPositionOnSoE(resultBean.getPositionOnSoE() + 10);
            }
            if (!equals && leerzeileNachher) {
                resultBeans.add(this.createEmptyStatementOfEarningsResultBean(positionOnSoE + 10));
            }
            if (!(equals || resultBean.getBlankLineOnSoe() != BlankLineEnum.BLE_Leerzeile_vorher && resultBean.getBlankLineOnSoe() != BlankLineEnum.BLE_Leerzeile_vorher_und_nachher)) {
                resultBeans.add(this.createEmptyStatementOfEarningsResultBean(resultBean.getPositionOnSoE() - 10));
            }
            resultBeans.add(resultBean);
            String infoText = resultBean.getInfoText();
            if (!StringMapper.isNullString((String)infoText)) {
                StatementOfEarningsResultBean infoResultBean = this.createEmptyStatementOfEarningsResultBean(resultBean.getPositionOnSoE() + 1);
                infoResultBean.setOidValueType(resultBean.getOidValueType());
                infoResultBean.setValueTypeNumber(resultBean.getValueTypeNumber());
                infoResultBean.setShortDescription(infoText);
                infoResultBean.setDescription("");
                infoResultBean.setFontOnSoe(resultBean.getFontOnSoe());
                infoResultBean.setBlankLineOnSoe(resultBean.getBlankLineOnSoe());
                infoResultBean.setIsInfo(true);
                infoResultBean.setRechenzeichen("");
                resultBeans.add(infoResultBean);
            }
            leerzeileNachher = resultBean.getBlankLineOnSoe() == BlankLineEnum.BLE_Leerzeile_nachher || resultBean.getBlankLineOnSoe() == BlankLineEnum.BLE_Leerzeile_vorher_und_nachher;
            oidValueType = resultBean.getOidValueType();
            positionOnSoE = resultBean.getPositionOnSoE();
        }
        return resultBeans;
    }

    private StatementOfEarningsResultBean createEmptyStatementOfEarningsResultBean(int positionOnSoE) {
        StatementOfEarningsResultBean bean = new StatementOfEarningsResultBean();
        bean.setPositionOnSoE(positionOnSoE);
        bean.setEffectiveFrom(DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
        bean.setEffectiveUntil(DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate));
        bean.setValidFrom(DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
        bean.setValidUntil(DateHelper.getLastDayOfMonth((Date)this.mForValidDate));
        return bean;
    }

    public boolean next() throws JRException {
        if (this.mOidEmployees.length == 0) {
            return false;
        }
        try {
            this.mChangeDescription = false;
            this.mNetPay = ZERO_CURRENCY;
            boolean next = this.getMasterDatas();
            BigDecimal bigDecimal = this.FIELD_UEBERWEISUNGSBETRAG = !this.mReturnCalculation && PDateHelper.getDiffInMonths((Date)this.mForEffectiveDate, (Date)this.mForValidDate) == 0 ? this.mNetPay : null;
            if (next) {
                this.FIELD_ValuePostionDataSource = new StatementOfEarningsValuePositionDataSource(this, this.mVPIterator);
                if (this.mVPIterator != null && this.mVPIterator.hasNext()) {
                    this.mHasData = true;
                }
            }
            return next;
        }
        catch (BusinessDomainException | PutDataException e) {
            throw new JRException(e);
        }
    }

    private Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "monat": {
                return this.FIELD_MONAT;
            }
            case "dynamicField1": {
                return this.FIELD_DYNAMICFIELD1;
            }
            case "dynamicField2": {
                return this.FIELD_DYNAMICFIELD2;
            }
            case "dynamicField3": {
                return this.FIELD_DYNAMICFIELD3;
            }
            case "dynamicField4": {
                return this.FIELD_DYNAMICFIELD4;
            }
            case "dynamicLabel1": {
                return this.FIELD_DYNAMICLABEL1;
            }
            case "dynamicLabel2": {
                return this.FIELD_DYNAMICLABEL2;
            }
            case "dynamicLabel3": {
                return this.FIELD_DYNAMICLABEL3;
            }
            case "dynamicLabel4": {
                return this.FIELD_DYNAMICLABEL4;
            }
            case "personal_nr": {
                return this.mIsSuperiorForConsolidation ? this.getCurrrentPCompanyKey() + " / " + this.FIELD_PERSONAL_NR : this.FIELD_PERSONAL_NR;
            }
            case "eintrittsdatum": {
                return this.FIELD_EINTRITTSDATUM;
            }
            case "austrittsdatum": {
                return this.FIELD_AUSTRITTSDATUM;
            }
            case "geburtsdatum": {
                return this.FIELD_GEBURTSDATUM;
            }
            case "sv_gueltig_ab": {
                return this.FIELD_SV_GUELTIG_AB;
            }
            case "steuerklasse": {
                return this.FIELD_STEUERKLASSE;
            }
            case "steuerfaktor": {
                return this.FIELD_STEUERFAKTOR;
            }
            case "steuer_id": {
                return this.FIELD_STEUER_ID;
            }
            case "reli_an": {
                return this.FIELD_RELI_AN;
            }
            case "reli_eg": {
                return this.FIELD_RELI_EG;
            }
            case "frei_hin_betrag_mon": {
                return this.FIELD_FREI_HIN_BETRAG_MON;
            }
            case "frei_hin_betrag_jahr": {
                return this.FIELD_FREI_HIN_BETRAG_JAHR;
            }
            case "bez_frei_hin_betrag_mon": {
                return this.FIELD_BEZ_FREI_HIN_BETRAG_MON;
            }
            case "bez_frei_hin_betrag_jahr": {
                return this.FIELD_BEZ_FREI_HIN_BETRAG_JAHR;
            }
            case "beitr_gp_kv": {
                return this.FIELD_BEITR_GP_KV;
            }
            case "beitr_gp_rv": {
                return this.FIELD_BEITR_GP_RV;
            }
            case "beitr_gp_av": {
                return this.FIELD_BEITR_GP_AV;
            }
            case "beitr_gp_pv": {
                return this.FIELD_BEITR_GP_PV;
            }
            case "bez_beitr_gp_kv": {
                return this.FIELD_BEZ_BEITR_GP_KV;
            }
            case "bez_beitr_gp_rv": {
                return this.FIELD_BEZ_BEITR_GP_RV;
            }
            case "bez_beitr_gp_av": {
                return this.FIELD_BEZ_BEITR_GP_AV;
            }
            case "bez_beitr_gp_pv": {
                return this.FIELD_BEZ_BEITR_GP_PV;
            }
            case "krankenkasse": {
                return this.FIELD_KRANKENKASSE;
            }
            case "versich_nr": {
                return this.FIELD_VERSICH_NR;
            }
            case "arbeitstage": {
                return this.FIELD_ARBEITSTAGE;
            }
            case "ueberweisungsbetrag": {
                return this.FIELD_UEBERWEISUNGSBETRAG;
            }
            case "kontoinhaber": {
                return this.FIELD_KONTOINHABER;
            }
            case "an_bank": {
                return this.FIELD_AN_BANK;
            }
            case "versorgungsfreibetrag": {
                return this.FIELD_VERSORGUNGSFREIBETRAG;
            }
            case "steuerermittlung": {
                return this.FIELD_STEUERERMITTLUNG;
            }
            case "personengruppe": {
                return this.FIELD_PERSONENGRUPPE;
            }
            case "gleitzone": {
                return this.FIELD_GLEITZONE;
            }
            case "mehrfachbeschaeftigung": {
                return this.FIELD_MEHRFACHBESCHAEFTIGUNG;
            }
            case "wochenarbeitszeit": {
                return this.FIELD_WOCHENARBEITSZEIT;
            }
            case "wochenarbeitstage": {
                return this.FIELD_WOCHENARBEITSTAGE;
            }
            case "kirchensteuersatz": {
                return this.FIELD_KIRCHENSTEUERSATZ;
            }
            case "berechnungszeitraum": {
                return this.FIELD_BERECHNUNGSZEITRAUM;
            }
            case "bez_personengruppe": {
                return this.FIELD_BEZ_PERSONENGRUPPE;
            }
            case "zahlart": {
                return this.FIELD_ZAHLART;
            }
            case "version": {
                return this.FIELD_VERSION;
            }
            case "soeid": {
                return this.FIELD_SOEID;
            }
            case "soetype": {
                return this.FIELD_SOETYPE;
            }
            case "soetypebool": {
                return this.FIELD_SOETYPEBOOL;
            }
            case "date": {
                return this.FIELD_DATE;
            }
            case "etin": {
                return this.FIELD_ETIN;
            }
            case "elterneigenschaft": {
                return this.FIELD_ELTERNEIGENSCHAFT;
            }
            case "jahr": {
                return this.FIELD_JAHR;
            }
            case "addressfielddatas": {
                return this.FIELD_ADDRESSFIELDDATAS;
            }
            case "infodatas": {
                return this.FIELD_INFODATAS;
            }
            case "holidaydatas": {
                return this.FIELD_HOLIDAYDATAS;
            }
            case "paydeductiondatas": {
                return this.FIELD_PAYDEDUCTIONDATAS;
            }
            case "absenttimedatas": {
                return this.FIELD_ABSENTTIMEDATAS;
            }
            case "attachmentdatas": {
                return this.FIELD_ATTACHMENTDATAS;
            }
            case "childallowancedatas": {
                return this.FIELD_CHILDALLOWANCEDATAS;
            }
            case "creditinfodatas": {
                return this.FIELD_CREDITINFODATAS;
            }
            case "costcentersplitdatas": {
                return this.FIELD_COSTCENTERSPLITDATAS;
            }
            case "costunitsplitdatas": {
                return this.FIELD_COSTUNITSPLITDATAS;
            }
            case "loandatas": {
                return this.FIELD_LOANDATAS;
            }
            case "eradatas": {
                return this.FIELD_ERADATAS;
            }
            case "wagefactordatas": {
                return this.FIELD_WAGEFACTORDATAS;
            }
            case "scalepaymentdatas": {
                return this.FIELD_SCALEPAYMENTDATAS;
            }
            case "valuePositionDataSource": {
                return this.FIELD_ValuePostionDataSource;
            }
        }
        return null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        Object value = this.getFieldValue(fieldName);
        if (value instanceof BigDecimal) {
            value = StatementOfEarningsReportDataSource.toCurrencyFormat(value);
        }
        if (value instanceof String) {
            value = StringUtil.toJasperString((String)((String)value));
        }
        if (fieldName.equals("archi_string")) {
            ArchivingMetadata am = new ArchivingMetadata();
            am.setReportName(StatementOfEarningsReportDataSource.getReportName());
            am.setUserID(SessionContext.getInstance().getSession().getUserCode());
            am.setCompanyKey(this.ARCHIV_FIRMENSCHLUESSEL);
            am.setPersonnelNumber(this.FIELD_PERSONAL_NR);
            am.setName(this.mEmployeeName);
            am.setValidFrom(this.mBeginMonthDate);
            am.setValidUntil(this.mEndMonthDate);
            return am.getArchiString();
        }
        return value;
    }

    private static String getReportName() {
        return "Verdienstnachweis";
    }

    private void addPayDeductions(Collection<StatementOfEarningsPayDeductionBean> payDeductionBeans, String oidEmployee) {
        String mmjjjj = StatementOfEarningsReportDataSource.toMMdotYYYY(this.mForValidDate);
        Map<String, PayDeductionBean> payDeductionHashMap = this.createPayDeductionMap(oidEmployee);
        this.addPayDeductionsVP(oidEmployee, payDeductionHashMap);
        for (String oidPayDeductionRoot : payDeductionHashMap.keySet()) {
            int modeofpayment;
            PaydeductionallContainer payDeductionContainer;
            BigDecimal amount;
            PayDeductionBean payDeductionBean = payDeductionHashMap.get(oidPayDeductionRoot);
            if (payDeductionBean == null || BigDecimalMapper.isZeroOrNull((BigDecimal)(amount = payDeductionBean.getBetrag())) || (payDeductionContainer = this.mQueries.queryPayDeductionAllContainer(payDeductionBean.getOidRoot())) == null) continue;
            String biccode = "";
            String iban = "";
            String empfaenger = "";
            Object verwendungszweck = "";
            if (!StringMapper.isNullString((String)payDeductionContainer.oidrecipient)) {
                RecipientallContainer recipientContainer = this.mCache.getRecipientallContainer(payDeductionContainer.oidrecipient);
                BanktpContainer bankTPcontainer = this.mCache.getBankTPContainer(recipientContainer.oidbank);
                if (bankTPcontainer != null) {
                    biccode = bankTPcontainer.biccode;
                }
                iban = recipientContainer.iban;
                empfaenger = recipientContainer.longdescription;
                modeofpayment = recipientContainer.modeofpayment;
                verwendungszweck = !StringMapper.isNullString((String)payDeductionContainer.reasonfortransfer) ? payDeductionContainer.reasonfortransfer + " " + mmjjjj : recipientContainer.reasonfortransfer + " " + mmjjjj;
            } else {
                BanktpContainer bankTPcontainer = this.mCache.getBankTPContainer(payDeductionContainer.oidbank);
                if (bankTPcontainer != null) {
                    biccode = bankTPcontainer.biccode;
                }
                iban = payDeductionContainer.iban;
                empfaenger = payDeductionContainer.recipient;
                modeofpayment = payDeductionContainer.modeofpayment;
                verwendungszweck = payDeductionContainer.reasonfortransfer + " " + mmjjjj;
            }
            String zahlungsart = StatementOfEarningsReportDataSource.getZahlungsart(modeofpayment);
            String betrag = StatementOfEarningsReportDataSource.toCurrencyFormat(amount);
            StatementOfEarningsPayDeductionBean sOEPayDeductionBean = new StatementOfEarningsPayDeductionBean(empfaenger, (String)verwendungszweck, biccode, iban, betrag, zahlungsart);
            payDeductionBeans.add(sOEPayDeductionBean);
        }
    }

    private static String getZahlungsart(int modeofpayment) {
        switch (modeofpayment) {
            case 0: {
                return "\u00dcberweisung";
            }
            case 1: {
                return "Scheck";
            }
            case 2: {
                return "Bar";
            }
            case 3: {
                return "Einzug";
            }
        }
        return "";
    }

    private Collection<StatementOfEarningsPayDeductionBean> getAttachmentBeans(String oidEmployee) {
        ArrayList<StatementOfEarningsPayDeductionBean> attachments = new ArrayList<StatementOfEarningsPayDeductionBean>();
        String mmjjjj = StatementOfEarningsReportDataSource.toMMdotYYYY(this.mForValidDate);
        List<AttachmentBean> attachmentList = this.queryAttachmentBeans(oidEmployee);
        for (AttachmentBean attachmentBean : attachmentList) {
            String verwendungszweck;
            int modeofpayment;
            String empfaenger;
            String iban;
            BigDecimal amount;
            AttachmentallContainer attachmentContainer = this.mQueries.queryAttachmentAllContainer(attachmentBean.getOidRoot());
            if (attachmentContainer == null || BigDecimalMapper.isZeroOrNull((BigDecimal)(amount = attachmentBean.getBetrag()))) continue;
            String biccode = "";
            if (!StringMapper.isNullString((String)attachmentContainer.oidrecipient)) {
                RecipientallContainer recipientContainer = this.mCache.getRecipientallContainer(attachmentContainer.oidrecipient);
                BanktpContainer bankTPcontainer = this.mCache.getBankTPContainer(recipientContainer.oidbank);
                if (bankTPcontainer != null) {
                    biccode = bankTPcontainer.biccode;
                }
                iban = recipientContainer.iban;
                empfaenger = recipientContainer.longdescription;
                modeofpayment = recipientContainer.modeofpayment;
                verwendungszweck = StringMapper.isNullString((String)attachmentContainer.reasonfortransfer) ? recipientContainer.reasonfortransfer + " " + mmjjjj : attachmentContainer.reasonfortransfer + " " + mmjjjj;
            } else {
                BanktpContainer bankTPcontainer = this.mCache.getBankTPContainer(attachmentContainer.oidbank);
                if (bankTPcontainer != null) {
                    biccode = bankTPcontainer.biccode;
                }
                iban = attachmentContainer.iban;
                empfaenger = attachmentContainer.recipient;
                modeofpayment = attachmentContainer.modeofpayment;
                verwendungszweck = attachmentContainer.reasonfortransfer + " " + mmjjjj;
            }
            String zahlungsart = StatementOfEarningsReportDataSource.getZahlungsart(modeofpayment);
            String betrag = StatementOfEarningsReportDataSource.toCurrencyFormat(amount);
            StatementOfEarningsPayDeductionBean sOEattachmentBean = new StatementOfEarningsPayDeductionBean(empfaenger, verwendungszweck, biccode, iban, betrag, zahlungsart);
            attachments.add(sOEattachmentBean);
        }
        return attachments;
    }

    private Collection<StatementOfEarningsChildAllowanceBean> getChildAllowanceBeans(Employee employee) throws BusinessDomainException {
        ArrayList<StatementOfEarningsChildAllowanceBean> childAllowanceBeans = new ArrayList<StatementOfEarningsChildAllowanceBean>();
        EERelative[] eeRelatives = employee.getEERelatives();
        ArrayList<EERelativeTP> eeRelativeTPs = new ArrayList<EERelativeTP>();
        for (EERelative eeRelative : eeRelatives) {
            EERelativeTP eeRelativeTP = (EERelativeTP)eeRelative.getHistory().getItemOrNull(this.mForEffectiveDate, this.mForValidDate);
            if (eeRelativeTP == null || eeRelativeTP.getDegreeRelationShip() != DegreeRelationShipEnum.DRSE_KIND) continue;
            eeRelativeTPs.add(eeRelativeTP);
        }
        eeRelativeTPs.sort((Comparator<EERelativeTP>)new EERelativeDateOfBirthComparator());
        Map<String, StatementOfEarningsChildAllowanceBean> childAllowanceHashMap = this.queryChildallowanceBeans(employee.getObjectid());
        for (EERelativeTP eeRelativeTP : eeRelativeTPs) {
            String oidEERelative = eeRelativeTP.getEERelative().getObjectid();
            String nameKind = eeRelativeTP.getSurName() + ", " + eeRelativeTP.getFirstName();
            String geburtsdatum = StatementOfEarningsReportDataSource.toString(eeRelativeTP.getDateOfBirth());
            String zahlungbis = StatementOfEarningsReportDataSource.toString(eeRelativeTP.getCAPaymentUntil());
            String berechnungsart = StatementOfEarningsReportDataSource.toString(eeRelativeTP.getCAFlagCalculation());
            StatementOfEarningsChildAllowanceBean childAllowanceBean = childAllowanceHashMap.get(oidEERelative);
            if (childAllowanceBean == null) {
                childAllowanceBean = new StatementOfEarningsChildAllowanceBean(oidEERelative, null);
            }
            childAllowanceBean.setNameKind(nameKind);
            childAllowanceBean.setGeburtsdatum(geburtsdatum);
            childAllowanceBean.setBerechnungsart(berechnungsart);
            childAllowanceBean.setZahlungbis(zahlungbis);
            childAllowanceBeans.add(childAllowanceBean);
        }
        return childAllowanceBeans;
    }

    private static String toString(FlagCalculationEnum flagCalculation) {
        switch (flagCalculation.value()) {
            case 2: {
                return "Z\u00e4hlkind";
            }
            case 1: {
                return "volles Kindergeld";
            }
            case 5: {
                return "keine Berechnung";
            }
        }
        return "";
    }

    private boolean isEqual(ValuepositionContainer vpc1, ValuepositionContainer vpc2) {
        return this.isEqual(vpc1.results, vpc2.results) && this.isEqual(vpc1.factor1, vpc2.factor1) && this.isEqual(vpc1.factor2, vpc2.factor2) && this.isEqual(vpc1.percentage, vpc2.percentage) && this.isEqual(vpc1.performfactor, vpc2.performfactor);
    }

    private boolean isEqual(BigDecimal value1, BigDecimal value2) {
        return BigDecimalMapper.compareTo((BigDecimal)value1, (BigDecimal)value2) == 0;
    }

    protected static String toCurrencyFormat(Object obj) {
        String temp2;
        String temp1;
        int tempLength = 0;
        Object temp = BigDecimalMapper.toString((BigDecimal)((BigDecimal)obj));
        for (int i = 0; i < ((String)temp).length(); ++i) {
            if (!StringMapper.equal((String)((String)temp).substring(i, i + 1), (String)".")) continue;
            tempLength = i;
        }
        int length = tempLength;
        if (((String)temp).substring(0, 1).equals("-")) {
            --length;
        }
        if (length < 4) {
            temp = ((String)temp).replace('.', ',');
        }
        if (length >= 4 && length < 7) {
            temp = ((String)temp).replace('.', ',');
            temp1 = ((String)temp).substring(0, tempLength - 3);
            temp2 = ((String)temp).substring(tempLength - 3, ((String)temp).length());
            temp = temp1 + "." + temp2;
        }
        if (length >= 7) {
            temp = ((String)temp).replace('.', ',');
            temp1 = ((String)temp).substring(0, tempLength - 6);
            temp2 = ((String)temp).substring(tempLength - 6, tempLength - 3);
            String temp3 = ((String)temp).substring(tempLength - 3, ((String)temp).length());
            temp = temp1 + "." + temp2 + "." + temp3;
        }
        return temp;
    }

    private void initClassificationFields(StatementOfEarningsResultBean resultBean) throws BusinessDomainException {
        String bruttoEinordnung = "";
        String steuerEinordnung = "";
        String svEinordnung = "";
        ClassificationBean classificationBean = this.mClassificationBeanMap.get(resultBean.getOidValueposition());
        if (classificationBean != null) {
            ConsequenceOfValueType[] covtArray;
            bruttoEinordnung = classificationBean.getBrutto();
            steuerEinordnung = classificationBean.getSteuer();
            svEinordnung = classificationBean.getSV();
            for (ConsequenceOfValueType lElement : covtArray = ValueType.getValueType((String)resultBean.getOidValueType()).getValueTypeTP(resultBean.getEffectiveUntil(), resultBean.getValidUntil()).getConsequenceForOrientation()) {
                if (lElement.getForClassification() != ClassificationEnum.CE_Pauschalsteuer) continue;
                steuerEinordnung = "P";
                bruttoEinordnung = "P";
            }
        }
        resultBean.setBruttoEinordnung(bruttoEinordnung);
        resultBean.setSvEinordnung(svEinordnung);
        resultBean.setSteuerEinordnung(steuerEinordnung);
    }

    private void createClassificationFieldLists(ValuepositionContainer vpContainer) throws BusinessDomainException {
        if (vpContainer.valuetypenumber == 100200 || vpContainer.valuetypenumber == 110510 || vpContainer.valuetypenumber == 110610 || vpContainer.valuetypenumber == 110620 || vpContainer.valuetypenumber == 129510 || vpContainer.valuetypenumber == 129511 || vpContainer.valuetypenumber == 130510 || vpContainer.valuetypenumber == 130520 || vpContainer.valuetypenumber == 130610 || vpContainer.valuetypenumber == 102505 || vpContainer.valuetypenumber == 102520 || vpContainer.valuetypenumber == 102500 || vpContainer.valuetypenumber == 102550 || vpContainer.valuetypenumber == 102540 || vpContainer.valuetypenumber == 736300 || vpContainer.valuetypenumber == 736800) {
            ClassificationBean classificationBean = this.mClassificationBeanMap.get(vpContainer.oidgenesisparent);
            if (classificationBean == null) {
                classificationBean = new ClassificationBean();
                this.mClassificationBeanMap.put(vpContainer.oidgenesisparent, classificationBean);
            }
            switch (vpContainer.valuetypenumber) {
                case 100200: {
                    classificationBean.setBrutto("G");
                    break;
                }
                case 110510: {
                    if (classificationBean.getSteuer().equals("V")) break;
                    classificationBean.setSteuer("L");
                    break;
                }
                case 110610: {
                    classificationBean.setSteuer("S");
                    break;
                }
                case 110620: {
                    classificationBean.setSteuer("E");
                    break;
                }
                case 102500: 
                case 102505: 
                case 102520: {
                    classificationBean.setSteuer("V");
                    break;
                }
                case 736300: 
                case 736800: {
                    classificationBean.setSteuer("P");
                    break;
                }
                case 102550: {
                    classificationBean.setSteuer("A");
                    break;
                }
                case 102540: {
                    classificationBean.setSteuer("E");
                    break;
                }
                case 129510: 
                case 129511: 
                case 130510: 
                case 130520: {
                    classificationBean.setSV("L");
                    break;
                }
                case 130610: {
                    classificationBean.setSV("E");
                }
            }
        }
    }

    protected List<StatementOfEarningsResultBean> queryStatementOfEarningsResultBeans(String oidEmployee, Date validFrom, Date validUntil) throws BusinessDomainException {
        ArrayList<StatementOfEarningsResultBean> soeBeanList = new ArrayList<StatementOfEarningsResultBean>();
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"valuetypenumber")}, Restrictions.or((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom))}), (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.lt((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(882110))})));
            while (valuePositionDatas.hasNext()) {
                ValuepositionContainer vpContainer = (ValuepositionContainer)valuePositionDatas.getNext();
                this.createClassificationFieldLists(vpContainer);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vpContainer.additionalamount2)) continue;
                StatementOfEarningsResultBean soeBean = this.createStatementOfEarningsResultBean(vpContainer, false);
                soeBean.setInfoText(this.getInfoText(vpContainer));
                soeBean.setCompressionKey(this.generateCompressionKey(vpContainer));
                soeBean.setSumCompressionKey(this.generateSumCompressionKey(vpContainer));
                soeBeanList.add(soeBean);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return soeBeanList;
    }

    private boolean checkReturnCalculation(String oidEmployee, Date validFrom) {
        boolean check = false;
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validFrom))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validFrom))), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(882110))}));
            if (valuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuePositionDatas.getNext();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)container.results)) {
                    check = true;
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return check;
    }

    private void addSumValuePositions(Map<String, ValuepositionContainer> sumValuePositionHashMap, String oidEmployee, Date firstDayOfMonth, Date lastDayOfMonth) {
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, Restrictions.or((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)lastDayOfMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)firstDayOfMonth)), Restrictions.in((String)"oidvaluetype", (Collection)this.mCache.getOidValueTypes())}), (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)lastDayOfMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)firstDayOfMonth)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)lastDayOfMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)firstDayOfMonth)), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(890000))})));
            while (valuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuePositionDatas.getNext();
                if (container == null || !BigDecimalMapper.isZeroOrNull((BigDecimal)container.additionalamount2)) continue;
                String sumCompressionKey = this.generateSumCompressionKey(container);
                ValuepositionContainer tempContainer = sumValuePositionHashMap.get(sumCompressionKey);
                if (tempContainer == null) {
                    sumValuePositionHashMap.put(sumCompressionKey, container);
                    continue;
                }
                tempContainer.results = tempContainer.results.add(container.results);
                tempContainer.factor1 = tempContainer.factor1.add(container.factor1);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private PersistencyDataSet getRueckrechnungsDatenAlt(String oidEmployee, Date rcValidFrom, Date rcValidUntil) {
        PersistencyDataSet rrValuePositionDatas;
        try {
            rrValuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"valuetypenumber"), Order.asc((String)"validuntil"), Order.asc((String)"factor2")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)rcValidUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)rcValidFrom)), this.getRueckrechnungsValueTypeNumberAltCriterion()}));
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return rrValuePositionDatas;
    }

    protected Criterion getRueckrechnungsValueTypeNumberAltCriterion() {
        return Restrictions.lt((String)"valuetypenumber", (String)Integer.toString(880000));
    }

    private PersistencyDataSet getRueckrechnungsDatenNeu(String oidEmployee, Date rcValidFrom, Date rcValidUntil) {
        PersistencyDataSet rrValuePositionDatas;
        try {
            rrValuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"valuetypenumber"), Order.asc((String)"validuntil"), Order.asc((String)"factor2")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)rcValidUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)rcValidFrom)), this.getRueckrechnungsValueTypeNumberNeuCriterion()}));
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return rrValuePositionDatas;
    }

    private Criterion getRueckrechnungsValueTypeNumberNeuCriterion() {
        return Restrictions.or((Criterion)Restrictions.lt((String)"valuetypenumber", (String)Integer.toString(880000)), (Criterion)Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(882110)));
    }

    private BigDecimal[] queryLoanRateValuePositionResults(String oidEmployee, String oidRootValueType) {
        BigDecimal[] results = new BigDecimal[3];
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"oidgenesisparent", (String)oidRootValueType), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)))}));
            while (valuePositionDatas.hasNext()) {
                ValuepositionContainer valuePositionContainer = (ValuepositionContainer)valuePositionDatas.getNext();
                if (valuePositionContainer == null) continue;
                if (valuePositionContainer.valuetypenumber == 886210) {
                    results[0] = valuePositionContainer.results;
                    continue;
                }
                if (valuePositionContainer.valuetypenumber == 886160) {
                    results[1] = valuePositionContainer.results;
                    continue;
                }
                if (valuePositionContainer.valuetypenumber != 886260) continue;
                results[2] = valuePositionContainer.results;
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return results;
    }

    private void addPayDeductionsPensionScheme(Collection<StatementOfEarningsPayDeductionBean> payDeductionBeans, String oidEmployee) {
        Map<String, PensionSchemeBean> pensionSchemeHashMap = this.createPensionSchemeMap(oidEmployee);
        ArrayList<String> pensionSchemeList = new ArrayList<String>(pensionSchemeHashMap.keySet());
        for (String oidPensionSchemeRoot : pensionSchemeList) {
            int modeofpayment;
            String empfaenger;
            String iban;
            Date rcDate;
            PensionSchemeBean pensionSchemeBean = pensionSchemeHashMap.get(oidPensionSchemeRoot);
            if (pensionSchemeBean == null) continue;
            BigDecimal amount = pensionSchemeBean.getBetrag();
            EepensschemeallContainer pensionSchemeContainer = this.mQueries.queryEEPensionSchemeAllContainer(pensionSchemeBean.getOidRoot());
            if (pensionSchemeContainer == null) continue;
            if (pensionSchemeContainer.revaluation && (rcDate = this.mCache.getCalculationBasicValidFrom(oidEmployee)) != null) {
                amount = amount.add(this.queryReturnCalculationPensionScheme(pensionSchemeContainer.objectidroot, rcDate));
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)amount)) continue;
            String verwendungszweck = this.mPensionSchemeReasonForTransfer.getReasonForTransfer(pensionSchemeContainer);
            String biccode = "";
            if (!StringMapper.isNullString((String)pensionSchemeContainer.oidrecipient)) {
                RecipientallContainer recipientContainer = this.mCache.getRecipientallContainer(pensionSchemeContainer.oidrecipient);
                BanktpContainer bankTPcontainer = this.mCache.getBankTPContainer(recipientContainer.oidbank);
                iban = recipientContainer.iban;
                empfaenger = recipientContainer.longdescription;
                modeofpayment = recipientContainer.modeofpayment;
                if (bankTPcontainer != null) {
                    biccode = bankTPcontainer.biccode;
                }
            } else {
                modeofpayment = pensionSchemeContainer.modeofpayment;
                BanktpContainer bankTPcontainer = this.mCache.getBankTPContainer(pensionSchemeContainer.oidbank);
                iban = pensionSchemeContainer.iban;
                empfaenger = pensionSchemeContainer.nameofrecipient;
                if (bankTPcontainer != null) {
                    biccode = bankTPcontainer.biccode;
                }
            }
            String zahlungsart = StatementOfEarningsReportDataSource.getZahlungsart(modeofpayment);
            String betrag = StatementOfEarningsReportDataSource.toCurrencyFormat(amount);
            StatementOfEarningsPayDeductionBean payDeductionBean = new StatementOfEarningsPayDeductionBean(empfaenger, verwendungszweck, biccode, iban, betrag, zahlungsart);
            payDeductionBeans.add(payDeductionBean);
        }
    }

    private BigDecimal queryPaymentSumResult(String oidEmployee, ValuePosition valuePosition, Date effectiveDate, Date validDate) {
        PersistentObject ausloeser = valuePosition.getGenesisOfParentObjects();
        String[] valueTypeNumbers = new String[]{"861110", "861114", "862110", "862114"};
        if (ausloeser instanceof EEAttachment) {
            valueTypeNumbers = new String[]{"795060", "795064", "795070", "795074", "795080", "795084", "795090", "795094", "795061", "795065", "795550", "795551", "795554", "795260", "795270", "795280", "795290", "795265"};
        }
        BigDecimal result = ZERO_CURRENCY;
        try {
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.in((String)"valuetypenumber", (String[])valueTypeNumbers)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                if (valuepositionContainer == null || !StringMapper.equal((String)valuepositionContainer.oidgenesisparent, (String)valuePosition.getObjectid())) continue;
                result = result.add(valuepositionContainer.results);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private BigDecimal queryReturnCalculationPensionScheme(String oidPensionSchemeRoot, Date returnCalculationDate) {
        BigDecimal result = ZERO_CURRENCY;
        Date tempRCDate = returnCalculationDate;
        Date newEffective = this.mForEffectiveDate;
        Date oldEffective = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
        while (DateHelper.before((Date)tempRCDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))) {
            EepensschemeallContainer pensionSchemeNewContainer;
            EepensschemeallContainer pensionSchemeOldContainer = this.mQueries.queryEEPensionSchemeAllContainer(oidPensionSchemeRoot, oldEffective, tempRCDate);
            if (pensionSchemeOldContainer != null) {
                result = result.subtract(this.queryPensionSchemeRCVP(pensionSchemeOldContainer.oidemployee, oldEffective, tempRCDate, oidPensionSchemeRoot));
            }
            if ((pensionSchemeNewContainer = this.mQueries.queryEEPensionSchemeAllContainer(oidPensionSchemeRoot, newEffective, tempRCDate)) != null) {
                result = result.add(this.queryPensionSchemeRCVP(pensionSchemeNewContainer.oidemployee, newEffective, tempRCDate, oidPensionSchemeRoot));
            }
            tempRCDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)tempRCDate));
        }
        return result;
    }

    private Map<String, PensionSchemeBean> createPensionSchemeMap(String oidEmployee) {
        HashMap<String, PensionSchemeBean> pensionSchemeHashMap = new HashMap<String, PensionSchemeBean>();
        try {
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"genesisparenttype", (String)"11"), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                String oidRoot = !StringMapper.isNullString((String)valuepositionContainer.oidrootgenesis) ? valuepositionContainer.oidrootgenesis : this.mQueries.queryEEPensionSchemeOidRoot(valuepositionContainer.oidgenesisparent);
                PensionSchemeBean pensionSchemeBean = (PensionSchemeBean)pensionSchemeHashMap.get(oidRoot);
                if (pensionSchemeBean == null) {
                    pensionSchemeBean = new PensionSchemeBean(oidRoot, valuepositionContainer.results);
                    pensionSchemeHashMap.put(oidRoot, pensionSchemeBean);
                    continue;
                }
                pensionSchemeBean.addBetrag(valuepositionContainer.results);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return pensionSchemeHashMap;
    }

    private BigDecimal queryPensionSchemeRCVP(String oidEmployee, Date effectiveDate, Date validDate, String oidRoot) {
        BigDecimal result = ZERO_CURRENCY;
        try {
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"genesisparenttype", (String)"11"), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                String tempOidRoot;
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                if (valuepositionContainer.valuetypenumber == 99999 || !StringMapper.equal((String)oidRoot, (String)(tempOidRoot = !StringMapper.isNullString((String)valuepositionContainer.oidrootgenesis) ? valuepositionContainer.oidrootgenesis : this.mQueries.queryEEPensionSchemeOidRoot(valuepositionContainer.oidgenesisparent)))) continue;
                result = result.add(valuepositionContainer.results);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private void addPayDeductionsVP(String oidEmployee, Map<String, PayDeductionBean> payDeductionHashMap) {
        try {
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"genesisparenttype", (String)"9"), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                String oidPayDeduction = this.mQueries.queryPayDeductionOidRoot(valuepositionContainer.oidgenesisparent);
                PayDeductionBean payDecuctionBean = payDeductionHashMap.get(oidPayDeduction);
                BigDecimal result = this.queryPaymentSumResult(oidEmployee, ValuePosition.getValuePosition((String)valuepositionContainer.getObjectid()), this.mForEffectiveDate, this.mForValidDate);
                if (payDecuctionBean == null) {
                    payDecuctionBean = new PayDeductionBean(oidPayDeduction, result, 1);
                    payDeductionHashMap.put(oidPayDeduction, payDecuctionBean);
                    continue;
                }
                if (payDecuctionBean.getModeType() == 2) continue;
                payDecuctionBean.addBetrag(result);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private BigDecimal queryValuePositionVari(String oidEmployee, String oidValueType, boolean revalution) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            Date tempRRDate;
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"oidvaluetype", (String)oidValueType), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuepositionDatas.getNext();
                if (container == null) continue;
                result = result.add(container.results);
            }
            if (revalution && (tempRRDate = this.mCache.getCalculationBasicValidFrom(oidEmployee)) != null) {
                while (DateHelper.before((Date)tempRRDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))) {
                    result = result.add(this.queryReturnCalculationDatasNew(oidEmployee, oidValueType, tempRRDate));
                    result = result.subtract(this.queryReturnCalculationDatasOld(oidEmployee, oidValueType, tempRRDate));
                    tempRRDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)tempRRDate));
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private BigDecimal queryReturnCalculationDatasOld(String oidEmployee, String oidValueType, Date returnCalculationDate) {
        BigDecimal result = BigDecimal.ZERO;
        Date effectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
        try {
            PersistencyDataSet rrValuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)returnCalculationDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)returnCalculationDate)), Restrictions.eq((String)"oidvaluetype", (String)oidValueType)}));
            while (rrValuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)rrValuePositionDatas.getNext();
                if (container == null || !BigDecimalMapper.isZeroOrNull((BigDecimal)container.additionalamount2)) continue;
                result = result.add(container.results);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private BigDecimal queryReturnCalculationDatasNew(String oidEmployee, String oidValueType, Date returnCalculationDate) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            PersistencyDataSet rrValuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)returnCalculationDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)returnCalculationDate)), Restrictions.eq((String)"oidvaluetype", (String)oidValueType)}));
            while (rrValuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)rrValuePositionDatas.getNext();
                if (container == null || !BigDecimalMapper.isZeroOrNull((BigDecimal)container.additionalamount2)) continue;
                result = result.add(container.results);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private Map<String, PayDeductionBean> createPayDeductionMap(String oidEmployee) {
        HashMap<String, PayDeductionBean> payDeductionHashMap = new HashMap<String, PayDeductionBean>();
        try {
            PersistencyDataSet paydeductionallDatas = daoPaydeductionall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"modetype", (String)"2"), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (paydeductionallDatas.hasNext()) {
                PaydeductionallContainer paydeductionallContainer = (PaydeductionallContainer)paydeductionallDatas.getNext();
                PayDeductionBean payDecuctionBean = (PayDeductionBean)payDeductionHashMap.get(paydeductionallContainer.objectidroot);
                BigDecimal betrag = this.queryValuePositionVari(paydeductionallContainer.oidemployee, paydeductionallContainer.oidvaluetype, paydeductionallContainer.revalution);
                if (payDecuctionBean == null) {
                    payDecuctionBean = new PayDeductionBean(paydeductionallContainer.objectidroot, betrag, 2);
                    payDeductionHashMap.put(paydeductionallContainer.objectidroot, payDecuctionBean);
                    continue;
                }
                payDecuctionBean.addBetrag(betrag);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return payDeductionHashMap;
    }

    private List<AttachmentBean> queryAttachmentBeans(String oidEmployee) {
        ArrayList<AttachmentBean> attachmentList;
        HashMap<String, AttachmentBean> vpHashMap = new HashMap<String, AttachmentBean>();
        try {
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"genesisparenttype", (String)"13"), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                String oidRoot = valuepositionContainer.oidgenesisparent;
                AttachmentBean attachmentBean = (AttachmentBean)vpHashMap.get(oidRoot);
                BigDecimal result = this.queryPaymentSumResult(oidEmployee, ValuePosition.getValuePosition((String)valuepositionContainer.getObjectid()), this.mForEffectiveDate, this.mForValidDate);
                if (attachmentBean == null) {
                    attachmentBean = new AttachmentBean(oidRoot, result);
                    vpHashMap.put(oidRoot, attachmentBean);
                    continue;
                }
                attachmentBean.addBetrag(result);
            }
            attachmentList = new ArrayList<AttachmentBean>(vpHashMap.values());
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return attachmentList;
    }

    private Map<String, StatementOfEarningsChildAllowanceBean> queryChildallowanceBeans(String oidEmployee) {
        HashMap<String, StatementOfEarningsChildAllowanceBean> vpHashMap = new HashMap<String, StatementOfEarningsChildAllowanceBean>();
        try {
            PersistencyDataSet valuepositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(760510)), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                String oidGenesisParentVP = valuepositionContainer.oidgenesisparent;
                BigDecimal result = valuepositionContainer.results;
                if (!StringMapper.isNullString((String)oidGenesisParentVP)) {
                    String oidEERelative = null;
                    ValuePosition rootVP = ValuePosition.getValuePosition((String)oidGenesisParentVP);
                    PersistentObject rootObject = rootVP.getRootGenesisOfParentObjects();
                    if (rootObject != null) {
                        if (!(rootObject instanceof EERelative)) continue;
                        EERelative eeRelative = (EERelative)rootObject;
                        oidEERelative = eeRelative.getObjectid();
                    } else {
                        PersistentObject genesisOfParentObject = rootVP.getGenesisOfParentObjects();
                        if (genesisOfParentObject != null) {
                            if (!(genesisOfParentObject instanceof EERelativeTP)) continue;
                            EERelativeTP eeRelativeTP = (EERelativeTP)genesisOfParentObject;
                            EERelative eeRelative = eeRelativeTP.getEERelative();
                            if (eeRelative != null) {
                                oidEERelative = eeRelative.getObjectid();
                            }
                        }
                    }
                    if (StringMapper.isNullString(oidEERelative)) continue;
                    StatementOfEarningsChildAllowanceBean childAllowanceBean = (StatementOfEarningsChildAllowanceBean)vpHashMap.get(oidEERelative);
                    if (childAllowanceBean == null) {
                        childAllowanceBean = new StatementOfEarningsChildAllowanceBean(oidEERelative, result);
                        vpHashMap.put(oidEERelative, childAllowanceBean);
                        continue;
                    }
                    childAllowanceBean.addBetrag(result);
                    continue;
                }
                StatementOfEarningsChildAllowanceBean childAllowanceBean = new StatementOfEarningsChildAllowanceBean("", result);
                vpHashMap.put("", childAllowanceBean);
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return vpHashMap;
    }

    private List<EmployeeBean> getEmployeeBeans(String[] oidEmployees) {
        ArrayList<EmployeeBean> employeeBeans = new ArrayList<EmployeeBean>();
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.lt((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate)))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet calculationbasicDatas = daoCalculationbasic.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.conjunction((Criterion[])new Criterion[]{inRestriction, filter})}));
                while (calculationbasicDatas.hasNext()) {
                    CalculationbasicContainer container = (CalculationbasicContainer)calculationbasicDatas.getNext();
                    if (!this.checkReturnCalculation(container.oidemployee, container.validfrom)) continue;
                    employeeBeans.add(new EmployeeBean(container.oidemployee, container.validfrom));
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return employeeBeans;
    }

    private ValuepositionContainer cloneWithZeroValues(ValuepositionContainer vpContainer) {
        ValuepositionContainer tempVPContainer = new ValuepositionContainer();
        tempVPContainer.oidemployee = vpContainer.oidemployee;
        tempVPContainer.oidvaluetype = vpContainer.oidvaluetype;
        tempVPContainer.effectivefrom = vpContainer.effectivefrom;
        tempVPContainer.effectiveuntil = vpContainer.effectiveuntil;
        tempVPContainer.validfrom = vpContainer.validfrom;
        tempVPContainer.validuntil = vpContainer.validuntil;
        tempVPContainer.oidparent = vpContainer.oidparent;
        tempVPContainer.oidgenesisparent = vpContainer.oidgenesisparent;
        tempVPContainer.parenttype = vpContainer.parenttype;
        tempVPContainer.genesisparenttype = vpContainer.genesisparenttype;
        tempVPContainer.factor1 = ZERO_CURRENCY;
        tempVPContainer.factor2 = ZERO_CURRENCY;
        tempVPContainer.results = ZERO_CURRENCY;
        tempVPContainer.percentage = ZERO_PERCENTAGE;
        tempVPContainer.performfactor = ZERO_PERCENTAGE;
        tempVPContainer.oidcostcenter = vpContainer.oidcostcenter;
        tempVPContainer.oidcostunit = vpContainer.oidcostunit;
        tempVPContainer.valuetypenumber = vpContainer.valuetypenumber;
        tempVPContainer.rankingnumber = vpContainer.rankingnumber;
        tempVPContainer.category = vpContainer.category;
        tempVPContainer.setObjectTS(vpContainer.getObjectTS());
        tempVPContainer.setObjectid(vpContainer.getObjectid());
        tempVPContainer.setLastUserid(vpContainer.getLastUserid());
        tempVPContainer.setVersion(vpContainer.getVersion());
        return tempVPContainer;
    }

    private static String toString(String s) {
        return StringMapper.isNullString((String)s) ? "" : s;
    }

    static String toStringMaxLength(String s, int maxLength) {
        return StringMapper.isNullString((String)s) ? "" : (s.length() <= maxLength ? s : s.substring(0, maxLength));
    }

    static String toString(BigDecimal bigDecimal) {
        return bigDecimal.toString().replace('.', ',');
    }

    static String toString(BigDecimal bigDecimal, int scale) {
        return StatementOfEarningsReportDataSource.toString(bigDecimal.setScale(scale, RoundingMode.HALF_UP));
    }

    private static String toPercent(BigDecimal bigDecimal) {
        return StatementOfEarningsReportDataSource.toString(bigDecimal) + "%";
    }

    static String toPercent(BigDecimal bigDecimal, int scale) {
        return StatementOfEarningsReportDataSource.toPercent(bigDecimal.setScale(scale, RoundingMode.HALF_UP));
    }

    private static String toString(Date date) {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)date);
    }

    protected static String toYYYY(Date date) {
        return DateMapper.toYYYYString((Date)date);
    }

    private static String toMM(Date date) {
        return StatementOfEarningsReportDataSource.toString(date).substring(3, 5);
    }

    static String toMMdotYYYY(Date date) {
        return StatementOfEarningsReportDataSource.toString(date).substring(3, 10);
    }

    private static int toYearInt(Date date) {
        return Integer.parseInt(StatementOfEarningsReportDataSource.toYYYY(date));
    }

    private static int toMonthInt(Date date) {
        return Integer.parseInt(StatementOfEarningsReportDataSource.toMM(date));
    }

    protected static String toMonthYYYY(Date date) {
        return ReportHelper.getMonthDescription((int)(StatementOfEarningsReportDataSource.toMonthInt(date) - 1)) + " " + StatementOfEarningsReportDataSource.toYYYY(date);
    }

    private String generateCompressionKey(ValuepositionContainer vpContainer) {
        String compressionKey;
        block9: {
            String valueTypeKey;
            block10: {
                block8: {
                    valueTypeKey = String.format("%06d", vpContainer.valuetypenumber);
                    if (vpContainer.valuetypenumber < 100000) break block8;
                    compressionKey = valueTypeKey + ";5";
                    break block9;
                }
                ValuetypesallContainer vtContainer = this.mCache.getValueTypeAllContainer(vpContainer.oidvaluetype);
                if (vtContainer == null || vtContainer.compressiononsoe == 0) break block10;
                switch (vtContainer.compressiononsoe) {
                    case 1: {
                        compressionKey = valueTypeKey + ";1;" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.factor2) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.percentage) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.performfactor) + ";" + StatementOfEarningsReportDataSource.toString(vpContainer.oidcostcenter);
                        break block9;
                    }
                    case 2: {
                        compressionKey = valueTypeKey + ";2;" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.factor2) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.performfactor);
                        break block9;
                    }
                    case 3: {
                        compressionKey = valueTypeKey + ";3;" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.factor2) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.percentage);
                        break block9;
                    }
                    case 4: {
                        compressionKey = valueTypeKey + ";4;" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.factor2);
                        break block9;
                    }
                    case 5: {
                        compressionKey = valueTypeKey + ";5";
                        break block9;
                    }
                    case 6: {
                        compressionKey = "A;" + vtContainer.oidvaluetypegroup;
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException("Die Wertart " + vtContainer.valuetypenumber + " hat die ung\u00fcltige Verdichtung " + vtContainer.compressiononsoe);
                    }
                }
            }
            compressionKey = valueTypeKey + ";0;" + this.getInfoText(vpContainer) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.factor2) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.factor1) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.percentage) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.performfactor) + ";" + StatementOfEarningsReportDataSource.toCompressionKeyPart(vpContainer.results) + ";" + StatementOfEarningsReportDataSource.toString(vpContainer.oidcostcenter);
        }
        return compressionKey;
    }

    private String generateSumCompressionKey(ValuepositionContainer vpContainer) {
        ValuetypesallContainer valuetypesallContainer = this.mCache.getValueTypeAllContainer(vpContainer.oidvaluetype);
        if (valuetypesallContainer == null) {
            String valueTypeKey = String.format("%06d", vpContainer.valuetypenumber);
            return valueTypeKey + ";5";
        }
        return StatementOfEarningsReportDataSource.generateSumCompressionKey(valuetypesallContainer);
    }

    static String generateSumCompressionKey(ValuetypesallContainer valuetypesallContainer) {
        if (valuetypesallContainer.compressiononsoe == 6) {
            return "A;" + valuetypesallContainer.oidvaluetypegroup;
        }
        String valueTypeKey = String.format("%06d", valuetypesallContainer.valuetypenumber);
        return valueTypeKey + ";5";
    }

    private static String toCompressionKeyPart(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "";
        }
        Object result = bigDecimal.toString();
        int index = ((String)result).indexOf(46);
        if (index < 0) {
            index = ((String)result).length();
        }
        result = StringUtils.repeat((String)" ", (int)Math.max(0, 8 - index)) + (String)result;
        return result;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private static String getParentName(String containerOidParent, int containerParentType) {
        if (containerParentType == 998 || containerParentType == 999 || containerParentType == 1000) {
            return String.valueOf(containerParentType);
        }
        if (!StringMapper.isNullString((String)containerOidParent)) {
            Originator originator = ((OriginatorFactory)UtilitiesManager.getBean((String)"originatorFactory", OriginatorFactory.class)).valueOf(containerParentType);
            return originator != null ? originator.getClassName() : "";
        }
        return "";
    }

    public boolean hasData() {
        return this.mHasData;
    }

    private class ClassificationBean {
        private String brutto = "";
        private String steuer = "";
        private String sv = "";

        public void setBrutto(String brutto) {
            this.brutto = brutto;
        }

        public void setSteuer(String steuer) {
            this.steuer = steuer;
        }

        public void setSV(String sv) {
            this.sv = sv;
        }

        public String getBrutto() {
            return this.brutto;
        }

        public String getSteuer() {
            return this.steuer;
        }

        public String getSV() {
            return this.sv;
        }
    }

    private class EmployeeBeanSortComparator
    implements Comparator<EmployeeBean> {
        private EmployeeBeanSortComparator() {
        }

        @Override
        public int compare(EmployeeBean eb1, EmployeeBean eb2) {
            EmployeeForReport efr1 = StatementOfEarningsReportDataSource.this.mCache.getEmployeeForReport(eb1.getOidEmployee());
            EmployeeForReport efr2 = StatementOfEarningsReportDataSource.this.mCache.getEmployeeForReport(eb2.getOidEmployee());
            String month1 = StatementOfEarningsReportDataSource.toMM(eb1.getValidDate());
            String year1 = StatementOfEarningsReportDataSource.toYYYY(eb1.getValidDate());
            String month2 = StatementOfEarningsReportDataSource.toMM(eb2.getValidDate());
            String year2 = StatementOfEarningsReportDataSource.toYYYY(eb2.getValidDate());
            int comp = StringMapper.compareTo((String)(efr1.getPersonnelNumber() + year1 + month1), (String)(efr2.getPersonnelNumber() + year2 + month2));
            return comp;
        }
    }

    public class RCDateComparator
    implements Comparator<Date[]> {
        @Override
        public int compare(Date[] date1, Date[] date2) {
            return DateHelper.compareDate((Date)date1[0], (Date)date2[0]);
        }
    }

    private class ResultBeanPositionComparator
    implements Comparator<StatementOfEarningsResultBean> {
        private ResultBeanPositionComparator() {
        }

        @Override
        public int compare(StatementOfEarningsResultBean soerb1, StatementOfEarningsResultBean soerb2) {
            int comp = Integer.compare(soerb1.getPositionOnSoE(), soerb2.getPositionOnSoE());
            if (comp != 0) {
                return comp;
            }
            comp = StringMapper.compareTo((String)soerb1.getCompressionKey(), (String)soerb2.getCompressionKey());
            return comp;
        }
    }

    public class ResultBeanSortComparator
    implements Comparator<StatementOfEarningsResultBean> {
        @Override
        public int compare(StatementOfEarningsResultBean soerb1, StatementOfEarningsResultBean soerb2) {
            int comp = StringMapper.compareTo((String)soerb1.getCompressionKey(), (String)soerb2.getCompressionKey());
            return comp;
        }
    }

    public class EmployeeBean {
        private final String oidEmployee;
        private final Date validDate;

        public EmployeeBean(String oidEmployee, Date validDate) {
            this.oidEmployee = oidEmployee;
            this.validDate = validDate;
        }

        public String getOidEmployee() {
            return this.oidEmployee;
        }

        public Date getValidDate() {
            return this.validDate;
        }
    }

    private class RRValuesMap
    extends HashMap<String, List<RRValues>> {
        private RRValuesMap() {
        }

        public void addRRNew(ValuepositionContainer valuePosition) {
            RRValues rrValues = this.getOrCreate(valuePosition, false);
            if (rrValues != null) {
                if (rrValues.rrNew == null) {
                    rrValues.rrNew = valuePosition;
                } else {
                    this.add(rrValues.rrNew, valuePosition);
                }
            }
        }

        public void addRROld(ValuepositionContainer valuePosition) {
            RRValues rrValues = this.getOrCreate(valuePosition, true);
            if (rrValues != null) {
                if (rrValues.rrOld == null) {
                    rrValues.rrOld = valuePosition;
                } else {
                    this.add(rrValues.rrOld, valuePosition);
                }
            }
        }

        private RRValues getOrCreate(ValuepositionContainer valuePosition, boolean old) {
            RRValues rrValues2;
            ArrayList<RRValues> rrValuesList;
            ValuetypesallContainer valueTypesAllContainer = StatementOfEarningsReportDataSource.this.mCache.getValueTypeAllContainer(valuePosition.oidvaluetype);
            if (valueTypesAllContainer == null || valueTypesAllContainer.printonsoeresult == 0 && valueTypesAllContainer.printonsoefactor1 == 0 && valueTypesAllContainer.printonsoefactor2 == 0) {
                return null;
            }
            Object compressionKey = StatementOfEarningsReportDataSource.this.generateCompressionKey(valuePosition);
            if (valuePosition.valuetypenumber < 100000) {
                compressionKey = (String)compressionKey + ";" + StatementOfEarningsReportDataSource.getParentName(valuePosition.oidgenesisparent, valuePosition.genesisparenttype);
            }
            if ((rrValuesList = (ArrayList<RRValues>)this.get(compressionKey)) == null) {
                rrValuesList = new ArrayList<RRValues>();
                this.put(compressionKey, rrValuesList);
            }
            if (StatementOfEarningsReportDataSource.this.hasCompression(valuePosition) && !rrValuesList.isEmpty()) {
                return (RRValues)rrValuesList.get(0);
            }
            for (RRValues rrValues2 : rrValuesList) {
                if (!(old ? rrValues2.rrOld == null : rrValues2.rrNew == null)) continue;
                return rrValues2;
            }
            String infoText = StatementOfEarningsReportDataSource.this.getInfoText(valuePosition);
            rrValues2 = new RRValues(infoText);
            rrValuesList.add(rrValues2);
            return rrValues2;
        }

        private void add(ValuepositionContainer sum, ValuepositionContainer summand) {
            sum.results = sum.results.add(summand.results);
            if (sum.valuetypenumber < 100000) {
                sum.factor1 = sum.factor1.add(summand.factor1);
            } else if (BigDecimalMapper.compareTo((BigDecimal)summand.factor1, (BigDecimal)sum.factor1) > 0) {
                sum.factor1 = summand.factor1;
            }
            if (BigDecimalMapper.compareTo((BigDecimal)summand.factor2, (BigDecimal)sum.factor2) != 0) {
                sum.factor2 = BigDecimal.ZERO;
            }
            if (BigDecimalMapper.compareTo((BigDecimal)summand.percentage, (BigDecimal)sum.percentage) != 0) {
                sum.percentage = BigDecimal.ZERO;
                sum.performfactor = BigDecimal.ZERO;
            }
            if (BigDecimalMapper.compareTo((BigDecimal)summand.performfactor, (BigDecimal)sum.performfactor) != 0) {
                sum.performfactor = BigDecimal.ZERO;
            }
        }
    }

    private class RRValues {
        private final String infoText;
        private ValuepositionContainer rrNew;
        private ValuepositionContainer rrOld;

        private RRValues(String infoText) {
            this.infoText = infoText;
        }
    }
}

