/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.statementofcontribution;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.paymentofcontributions.TypeOfListEnum;
import com.varial.personnel.domain.employee.paymentofcontributions.TypeOfPaymentEnum;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedues.InsuranceDues;
import com.varial.personnel.domain.employee.paymentofcontributions.mapper.TypeOfListEnumMapper;
import com.varial.personnel.domain.employee.paymentofcontributions.mapper.TypeOfPaymentEnumMapper;
import com.varial.personnel.domain.employee.paymentofcontributions.mapper.TypeOfStatusEnumMapper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.statementofcontribution.EmployeeForSOCBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionGlobalSocialInsuranceBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionReportDataSource;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionSummBDBean;
import com.varial.personnel.domain.reports.statementofcontribution.StatementOfContributionTypeBDBean;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.StatementOfContributionGlobalSocialInsuranceKVDRBean;
import com.varial.personnel.domain.typeofvalue.basictypes.ClassificationEnum;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.framework.DateComparator;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.assignments.comphealthfunall.ComphealthfunallContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.employee.masterall.MasterallContainer;
import com.varial.personnel.persistency.global.healthfundtp.assessment.AssessmentContainer;
import com.varial.personnel.persistency.global.healthfundtp.assessment.IAssessmentDao;
import com.varial.personnel.persistency.global.socialinsurance.SocialinsuranceContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SOCDataSourceHelper {
    private static IAssessmentDao daoAssessment = (IAssessmentDao)UtilitiesManager.getApplicationContext().getBean("assessmentDao");

    private SOCDataSourceHelper() {
    }

    public static Object[] getRetroactiveCorrectionDates(String currentOidEmployee, int arraySize, Date mForEffectiveDate, Date employeeStartDate, Date mForValidDate, Map<String, List<CalculationbasicContainer>> calculationBasicMap, Map<String, List<MasterallContainer>> mMasterAllMap) {
        List<CalculationbasicContainer> calculationBasicContainerLi;
        Object[] rueckrechnungsWerte = new Object[arraySize];
        LinkedList<Date> validFromDateList = new LinkedList<Date>();
        Date minValidFrom = null;
        Date journalizedUntil = null;
        MasterallContainer masterallContainer2 = null;
        List<MasterallContainer> listeMaster = mMasterAllMap.get(currentOidEmployee);
        if (listeMaster != null) {
            for (MasterallContainer masterallContainer2 : listeMaster) {
                if (!DateHelper.beforeOrEqual((Date)masterallContainer2.validfrom, (Date)employeeStartDate) || !DateHelper.afterOrEqual((Date)masterallContainer2.validuntil, (Date)employeeStartDate)) continue;
                journalizedUntil = masterallContainer2.journalizeduntil;
                if (PDateHelper.getDiffInMonths((Date)mForValidDate, (Date)journalizedUntil) <= 1) break;
                journalizedUntil = null;
                break;
            }
        }
        if (journalizedUntil != null && (calculationBasicContainerLi = calculationBasicMap.get(currentOidEmployee)) != null) {
            for (CalculationbasicContainer calculationbasicContainer : calculationBasicContainerLi) {
                if (!DateHelper.before((Date)calculationbasicContainer.validfrom, (Date)mForEffectiveDate)) continue;
                validFromDateList.add(calculationbasicContainer.validfrom);
            }
            Date[] datesValidFrom = new Date[validFromDateList.size()];
            datesValidFrom = validFromDateList.toArray(datesValidFrom);
            Arrays.sort(datesValidFrom, new DateComparator());
            minValidFrom = datesValidFrom[0];
        }
        if (journalizedUntil != null && minValidFrom != null) {
            rueckrechnungsWerte[0] = minValidFrom;
            rueckrechnungsWerte[1] = journalizedUntil;
        }
        return rueckrechnungsWerte;
    }

    public static String getActualOidHealthfund(StatementOfContributionReportDataSource sOCRDS, String oidHF) throws BusinessDomainException {
        HealthFund currentHealthFund = sOCRDS.mReportValues.getHealthFund(oidHF);
        if (currentHealthFund != null) {
            currentHealthFund = HealthFund.getHealthFundConsiderFusionsAtGivenTime((HealthFund)currentHealthFund, (Date)sOCRDS.mForValidDate);
        }
        return currentHealthFund.getObjectid();
    }

    public static String getHealthFundStandardCompanyNumber(StatementOfContributionReportDataSource sOCRDS, String oidHealthfund) throws BusinessDomainException {
        return sOCRDS.mReportValues.getHealthFundTP(oidHealthfund, sOCRDS.mForEffectiveDate, sOCRDS.mForValidDate).getStandardCompanyNumber();
    }

    public static String getHealthFundDescription(StatementOfContributionReportDataSource sOCRDS, String oidHealthfund) throws BusinessDomainException {
        return sOCRDS.mReportValues.getHealthFundTP(oidHealthfund, sOCRDS.mForEffectiveDate, sOCRDS.mForValidDate).getShortDescription();
    }

    public static List<StatementOfContributionGlobalSocialInsuranceKVDRBean> getGlobalSocialInsuranceKVDRCollection(Date forEffectiveDate, Date firstDayOfYear, Date lastDayOfYear) {
        LinkedList<StatementOfContributionGlobalSocialInsuranceKVDRBean> globalSocialInsuranceKVDRCollection = new LinkedList<StatementOfContributionGlobalSocialInsuranceKVDRBean>();
        List globalSocialInsuranceLi = new LinkedList();
        BigDecimal kv_ana_beitragszuschalg = BigDecimal.valueOf(0L, 2);
        BigDecimal pv_percentage = BigDecimal.valueOf(0L, 2);
        BigDecimal pv_ana_beitragszuschlag = BigDecimal.valueOf(0L, 2);
        globalSocialInsuranceLi = ReportEmployeesHandlingHelper.getGlobalSocialInsuranceLi((Date)forEffectiveDate, (Date)firstDayOfYear, (Date)lastDayOfYear);
        for (SocialinsuranceContainer socialinsuranceContainer : globalSocialInsuranceLi) {
            String date_valid_from = DateMapper.toDDMMYYYYPointSeparationString((Date)socialinsuranceContainer.validfrom);
            kv_ana_beitragszuschalg = socialinsuranceContainer.eesurchargehi;
            pv_percentage = socialinsuranceContainer.totalduepcni;
            pv_ana_beitragszuschlag = socialinsuranceContainer.eesurchargeni;
            globalSocialInsuranceKVDRCollection.add(new StatementOfContributionGlobalSocialInsuranceKVDRBean(date_valid_from, ReportHelper.toCurrencyFormatIfNullString((Object)kv_ana_beitragszuschalg), ReportHelper.toCurrencyFormatIfNullString((Object)pv_percentage) + "/ " + ReportHelper.toCurrencyFormatIfNullString((Object)pv_ana_beitragszuschlag)));
        }
        return globalSocialInsuranceKVDRCollection;
    }

    public static List<StatementOfContributionGlobalSocialInsuranceBean> buildSocialInsuranceBeitragsabrechnungCollection(String rechtsKreis, Date forEffectiveDate, Date firstDayOfYear, Date lastDayOfYear) {
        List globalSocialInsuranceLi = new LinkedList();
        LinkedList<StatementOfContributionGlobalSocialInsuranceBean> reportGlobalSocialInsuranceLi = new LinkedList<StatementOfContributionGlobalSocialInsuranceBean>();
        globalSocialInsuranceLi = ReportEmployeesHandlingHelper.getGlobalSocialInsuranceLi((Date)forEffectiveDate, (Date)firstDayOfYear, (Date)lastDayOfYear);
        for (SocialinsuranceContainer sCont : globalSocialInsuranceLi) {
            if (sCont == null) continue;
            BigDecimal FIELD_5000_percentage = StringMapper.equal((String)rechtsKreis, (String)"West") ? sCont.duepcphiallowance.multiply(new BigDecimal("0.5")).setScale(2, RoundingMode.HALF_UP) : sCont.duepcphiallowance.multiply(new BigDecimal("0.5")).setScale(2, RoundingMode.HALF_UP);
            BigDecimal FIELD_0500_0600_percentage = sCont.duepcpiforlie;
            BigDecimal FIELD_6000_percentage = sCont.duepchiforlie;
            BigDecimal FIELD_rv_full_percentage = sCont.totalduepcpi;
            BigDecimal FIELD_rv_reduced_percentage = sCont.totalduepcpi.subtract(sCont.duepcpiforlie);
            BigDecimal FIELD_av_percentage = sCont.totalduepcui;
            BigDecimal FIELD_pv_percentage = sCont.totalduepcni;
            BigDecimal FIELD_pv_ana_beitragszuschlag = sCont.eesurchargeni;
            BigDecimal FIELD_kv_ana_beitragszuschlag = DateHelper.afterOrEqual((Date)lastDayOfYear, (Date)new VDate(2015, 0, 1).getDate()) ? sCont.additionaldueshi : sCont.eesurchargehi;
            BigDecimal FIELD_insg_percentage = BigDecimal.ZERO.setScale(2);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sCont.percinsolvencyass)) {
                FIELD_insg_percentage = sCont.percinsolvencyass.setScale(2, RoundingMode.HALF_UP);
            }
            reportGlobalSocialInsuranceLi.add(new StatementOfContributionGlobalSocialInsuranceBean(DateMapper.toDDMMYYYYPointSeparationString((Date)sCont.validfrom), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_5000_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_0500_0600_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_6000_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_rv_full_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_rv_reduced_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_av_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_pv_percentage), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_pv_ana_beitragszuschlag), ReportHelper.toCurrencyFormatIfNullString((Object)FIELD_kv_ana_beitragszuschlag), ReportHelper.toCurrencyFormat((Object)FIELD_insg_percentage), sCont.validfrom, FIELD_5000_percentage, FIELD_0500_0600_percentage, FIELD_6000_percentage, FIELD_rv_full_percentage, FIELD_rv_reduced_percentage, FIELD_av_percentage, FIELD_pv_percentage, FIELD_pv_ana_beitragszuschlag, FIELD_kv_ana_beitragszuschlag, FIELD_insg_percentage));
        }
        return reportGlobalSocialInsuranceLi;
    }

    public static ComphealthfunallContainer getComphealthfundContainer(List<ComphealthfunallContainer> listeCompHealthFundAll, String currentOidPlant, String currentOidHealthfund, Date employeeStartDate) {
        ComphealthfunallContainer comphealthfunallContainer2 = null;
        if (listeCompHealthFundAll != null) {
            for (ComphealthfunallContainer comphealthfunallContainer2 : listeCompHealthFundAll) {
                if (!StringMapper.isNullString((String)currentOidPlant) ? StringMapper.equal((String)comphealthfunallContainer2.oidplant, (String)currentOidPlant) && StringMapper.equal((String)comphealthfunallContainer2.oidhealthfundroot, (String)currentOidHealthfund) && DateHelper.beforeOrEqual((Date)comphealthfunallContainer2.validfrom, (Date)employeeStartDate) && DateHelper.afterOrEqual((Date)comphealthfunallContainer2.validuntil, (Date)employeeStartDate) : StringMapper.isNullString((String)comphealthfunallContainer2.oidplant) && StringMapper.equal((String)comphealthfunallContainer2.oidhealthfundroot, (String)currentOidHealthfund) && DateHelper.beforeOrEqual((Date)comphealthfunallContainer2.validfrom, (Date)employeeStartDate) && DateHelper.afterOrEqual((Date)comphealthfunallContainer2.validuntil, (Date)employeeStartDate)) {
                    return comphealthfunallContainer2;
                }
                comphealthfunallContainer2 = null;
            }
        }
        return comphealthfunallContainer2;
    }

    public static ComphealthfunallContainer getComphealthfundContainer(Map<String, List<ComphealthfunallContainer>> mCompHealthFundAllHashMap, String currentOidPCompany, String currentOidPlant, String currentOidHealthfund, Date employeeStartDate) {
        ComphealthfunallContainer comphealthfunallContainer2 = null;
        List<ComphealthfunallContainer> listeCompHealthFundAll = mCompHealthFundAllHashMap.get(currentOidPCompany);
        if (listeCompHealthFundAll != null) {
            for (ComphealthfunallContainer comphealthfunallContainer2 : listeCompHealthFundAll) {
                if (!StringMapper.isNullString((String)currentOidPlant) ? StringMapper.equal((String)comphealthfunallContainer2.oidplant, (String)currentOidPlant) && StringMapper.equal((String)comphealthfunallContainer2.oidhealthfundroot, (String)currentOidHealthfund) && DateHelper.beforeOrEqual((Date)comphealthfunallContainer2.validfrom, (Date)employeeStartDate) && DateHelper.afterOrEqual((Date)comphealthfunallContainer2.validuntil, (Date)employeeStartDate) : StringMapper.equal((String)comphealthfunallContainer2.oidpcompany, (String)currentOidPCompany) && StringMapper.isNullString((String)comphealthfunallContainer2.oidplant) && StringMapper.equal((String)comphealthfunallContainer2.oidhealthfundroot, (String)currentOidHealthfund) && DateHelper.beforeOrEqual((Date)comphealthfunallContainer2.validfrom, (Date)employeeStartDate) && DateHelper.afterOrEqual((Date)comphealthfunallContainer2.validuntil, (Date)employeeStartDate)) {
                    return comphealthfunallContainer2;
                }
                comphealthfunallContainer2 = null;
            }
        }
        return comphealthfunallContainer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<AssessmentContainer>> getHashMapAssessment() {
        PersistencyDataSet assessmentDataSet = null;
        try {
            assessmentDataSet = daoAssessment.getDataSet(new Order[]{Order.asc((String)"oidhealthfundtp"), Order.asc((String)"assessmentkey")}, null);
            AssessmentContainer assessmentContainer = new AssessmentContainer();
            HashMap<String, List<AssessmentContainer>> assessmentMap = null;
            if (assessmentDataSet != null) {
                assessmentMap = new HashMap<String, List<AssessmentContainer>>();
                while (assessmentDataSet.hasNext()) {
                    assessmentContainer = (AssessmentContainer)assessmentDataSet.getNext();
                    LinkedList<AssessmentContainer> liste = (LinkedList<AssessmentContainer>)assessmentMap.get(assessmentContainer.oidhealthfundtp);
                    if (liste == null) {
                        liste = new LinkedList<AssessmentContainer>();
                        assessmentMap.put(assessmentContainer.oidhealthfundtp, liste);
                    }
                    liste.add(assessmentContainer);
                }
            }
            HashMap<String, List<AssessmentContainer>> hashMap = assessmentMap;
            return hashMap;
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
        }
        finally {
            if (assessmentDataSet != null) {
                assessmentDataSet.dispose();
            }
        }
        return null;
    }

    private static StatementOfContributionSummBDBean getStatementOfContributionSummBDBean(InsuranceDues insuranceDues) {
        BigDecimal summe_kv_1000_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_2000_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_3000_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_6000_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0100_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0200_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0300_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0400_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0500_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0600_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_av_0010_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_av_0020_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_av_0050_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_pv_0001_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u1_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u2_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_frw_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_pv_frw_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_st_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_1000_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_2000_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_3000_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_6000_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0100_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0200_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0300_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0400_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0500_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_rv_0600_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_av_0010_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_av_0020_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_av_0050_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_pv_0001_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u1_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u2_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u1_erstattung = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u2_erstattung = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_u1_u2_erstattung = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_frw_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_pv_frw_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_st_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_1000_SAG_Beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_3000_SAG_Beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_frw_SAG_Beitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_frw_zusatzbeitrag = BigDecimal.valueOf(0L, 2);
        BigDecimal summe_kv_zusatzbeitrag = BigDecimal.valueOf(0L, 2);
        if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_VORTRAG_BEITRAGSDIFFERENZ) {
            summe_kv_1000_beitrag = summe_kv_1000_beitrag.add(insuranceDues.getEeHi1000()).add(insuranceDues.getErHi1000()).add(insuranceDues.getErHi5000());
            if (BigDecimalMapper.isZero((BigDecimal)summe_kv_1000_entgelt)) {
                summe_kv_1000_entgelt = summe_kv_1000_entgelt.add(insuranceDues.getHiPayment());
            }
            summe_kv_2000_beitrag = summe_kv_2000_beitrag.add(insuranceDues.getEeHi2000()).add(insuranceDues.getErHi2000());
            summe_kv_3000_beitrag = summe_kv_3000_beitrag.add(insuranceDues.getEeHi3000()).add(insuranceDues.getErHi3000());
            summe_kv_6000_beitrag = summe_kv_6000_beitrag.add(insuranceDues.getErHi6000());
            summe_rv_0100_beitrag = summe_rv_0100_beitrag.add(insuranceDues.getEePi0100()).add(insuranceDues.getErPi0100());
            summe_rv_0100_beitrag = summe_rv_0100_beitrag.add(insuranceDues.getPiDifference());
            if (BigDecimalMapper.isZero((BigDecimal)summe_rv_0100_entgelt)) {
                summe_rv_0100_entgelt = summe_rv_0100_entgelt.add(insuranceDues.getPiPayment());
            }
            summe_rv_0300_beitrag = summe_rv_0300_beitrag.add(insuranceDues.getErPi0300());
            summe_rv_0500_beitrag = summe_rv_0500_beitrag.add(insuranceDues.getErPi0500());
            summe_av_0010_beitrag = summe_av_0010_beitrag.add(insuranceDues.getEeUi0010()).add(insuranceDues.getErUi0010());
            if (BigDecimalMapper.isZero((BigDecimal)summe_av_0010_entgelt)) {
                summe_av_0010_entgelt = summe_av_0010_entgelt.add(insuranceDues.getUiPayment());
            }
            summe_av_0020_beitrag = summe_av_0020_beitrag.add(insuranceDues.getEeUi0020()).add(insuranceDues.getErUi0020());
            summe_av_0050_beitrag = summe_av_0050_beitrag.add(insuranceDues.getInsolvencyAssessmentDues());
            summe_pv_0001_beitrag = summe_pv_0001_beitrag.add(insuranceDues.getEeNi0001()).add(insuranceDues.getEeNi0002()).add(insuranceDues.getErNi0001()).add(insuranceDues.getErNi0002());
            if (BigDecimalMapper.isZero((BigDecimal)summe_pv_0001_entgelt)) {
                summe_pv_0001_entgelt = summe_pv_0001_entgelt.add(insuranceDues.getNiPayment());
            }
        }
        if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_INSG_UMLAGEPFLICHT) {
            summe_av_0050_beitrag = summe_av_0050_beitrag.add(insuranceDues.getInsolvencyAssessmentDues());
            summe_av_0050_entgelt = summe_av_0050_entgelt.add(insuranceDues.getInsolvencyAssessmentPayment());
        }
        switch (insuranceDues.getDuesGroupHI()) {
            case 1: {
                summe_kv_1000_entgelt = summe_kv_1000_entgelt.add(insuranceDues.getHiPayment());
                summe_kv_1000_beitrag = summe_kv_1000_beitrag.add(insuranceDues.getEeHi1000()).add(insuranceDues.getErHi1000());
                break;
            }
            case 2: {
                summe_kv_2000_entgelt = summe_kv_2000_entgelt.add(insuranceDues.getHiPayment());
                summe_kv_2000_beitrag = summe_kv_2000_beitrag.add(insuranceDues.getEeHi2000()).add(insuranceDues.getErHi2000());
                break;
            }
            case 3: {
                summe_kv_3000_entgelt = summe_kv_3000_entgelt.add(insuranceDues.getHiPayment());
                summe_kv_3000_beitrag = summe_kv_3000_beitrag.add(insuranceDues.getEeHi3000()).add(insuranceDues.getErHi3000());
                break;
            }
            case 5: {
                if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_PFLICHTVERSICHERT) {
                    switch (insuranceDues.getTypeOfPaymentEnum().value()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            summe_kv_1000_entgelt = summe_kv_1000_entgelt.add(insuranceDues.getHiPayment());
                            summe_kv_1000_beitrag = summe_kv_1000_beitrag.add(insuranceDues.getErHi5000());
                        }
                    }
                }
                if (insuranceDues.getTypeOfListEnum() != TypeOfListEnum.TOLE_KURZARBEITERGELD) break;
                summe_kv_1000_entgelt = summe_kv_1000_entgelt.add(insuranceDues.getHiPayment());
                summe_kv_1000_beitrag = summe_kv_1000_beitrag.add(insuranceDues.getErHi5000());
                break;
            }
            case 6: {
                if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_MINIJOBS_GFB || insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_PFLICHTVERSICHERT) {
                    if (insuranceDues.getTypeOfPaymentEnum() != TypeOfPaymentEnum.TOPE_LAUFEND && insuranceDues.getTypeOfPaymentEnum() != TypeOfPaymentEnum.TOPE_LAUFEND_SECHSTEL) break;
                    summe_kv_6000_entgelt = summe_kv_6000_entgelt.add(insuranceDues.getHiPayment());
                    summe_kv_6000_beitrag = summe_kv_6000_beitrag.add(insuranceDues.getErHi6000());
                    break;
                }
                if (insuranceDues.getTypeOfListEnum() != TypeOfListEnum.TOLE_FIKTIVESENTGELT_100AG) break;
                summe_kv_6000_entgelt = summe_kv_6000_entgelt.add(insuranceDues.getHiPayment());
                summe_kv_6000_beitrag = summe_kv_6000_beitrag.add(insuranceDues.getErHi6000());
            }
        }
        switch (insuranceDues.getDuesGroupPI()) {
            case 1: {
                if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_MINIJOBS_GFB) {
                    if (!(insuranceDues.getTypeOfPaymentEnum() != TypeOfPaymentEnum.TOPE_LAUFEND && insuranceDues.getTypeOfPaymentEnum() != TypeOfPaymentEnum.TOPE_LAUFEND_SECHSTEL || BigDecimalMapper.isZeroOrNull((BigDecimal)(summe_rv_0500_beitrag = summe_rv_0500_beitrag.add(insuranceDues.getErPi0500()))))) {
                        summe_rv_0500_entgelt = summe_rv_0500_entgelt.add(insuranceDues.getPayment());
                    }
                    summe_rv_0100_entgelt = summe_rv_0100_entgelt.add(insuranceDues.getPiPayment());
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)(summe_rv_0100_beitrag = summe_rv_0100_beitrag.add(insuranceDues.getEePi0100()).add(insuranceDues.getErPi0100()))) || !BigDecimalMapper.isZeroOrNull((BigDecimal)summe_rv_0100_entgelt)) break;
                    summe_rv_0100_entgelt = summe_rv_0100_entgelt.add(insuranceDues.getPayment());
                    break;
                }
                summe_rv_0100_entgelt = summe_rv_0100_entgelt.add(insuranceDues.getPiPayment().add(insuranceDues.getPiDifference()));
                summe_rv_0100_beitrag = summe_rv_0100_beitrag.add(insuranceDues.getEePi0100()).add(insuranceDues.getErPi0100());
                break;
            }
            case 2: {
                if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_MINIJOBS_GFB) {
                    if (!(insuranceDues.getTypeOfPaymentEnum() != TypeOfPaymentEnum.TOPE_LAUFEND && insuranceDues.getTypeOfPaymentEnum() != TypeOfPaymentEnum.TOPE_LAUFEND_SECHSTEL || BigDecimalMapper.isZeroOrNull((BigDecimal)(summe_rv_0600_beitrag = summe_rv_0600_beitrag.add(insuranceDues.getErPi0600()))))) {
                        summe_rv_0600_entgelt = summe_rv_0600_entgelt.add(insuranceDues.getPayment());
                    }
                    summe_rv_0200_entgelt = summe_rv_0200_entgelt.add(insuranceDues.getPiPayment());
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)(summe_rv_0200_beitrag = summe_rv_0200_beitrag.add(insuranceDues.getEePi0200()).add(insuranceDues.getErPi0200()))) || !BigDecimalMapper.isZeroOrNull((BigDecimal)summe_rv_0200_entgelt)) break;
                    summe_rv_0200_entgelt = summe_rv_0200_entgelt.add(insuranceDues.getPayment());
                    break;
                }
                summe_rv_0200_entgelt = summe_rv_0200_entgelt.add(insuranceDues.getPiPayment());
                summe_rv_0200_beitrag = summe_rv_0200_beitrag.add(insuranceDues.getEePi0200()).add(insuranceDues.getErPi0200());
                break;
            }
            case 3: {
                summe_rv_0300_entgelt = summe_rv_0300_entgelt.add(insuranceDues.getPiPayment());
                summe_rv_0300_beitrag = summe_rv_0300_beitrag.add(insuranceDues.getErPi0300());
                break;
            }
            case 4: {
                summe_rv_0400_entgelt = summe_rv_0400_entgelt.add(insuranceDues.getPiPayment());
                summe_rv_0400_beitrag = summe_rv_0400_beitrag.add(insuranceDues.getErPi0400());
                break;
            }
            case 5: {
                summe_rv_0500_beitrag = summe_rv_0500_beitrag.add(insuranceDues.getErPi0500());
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)summe_rv_0500_beitrag)) break;
                summe_rv_0500_entgelt = summe_rv_0500_entgelt.add(insuranceDues.getPayment());
                break;
            }
            case 6: {
                summe_rv_0600_beitrag = summe_rv_0600_beitrag.add(insuranceDues.getErPi0600());
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)summe_rv_0600_beitrag)) break;
                summe_rv_0600_entgelt = summe_rv_0600_entgelt.add(insuranceDues.getPayment());
            }
        }
        switch (insuranceDues.getDuesGroupUI()) {
            case 1: {
                summe_av_0010_entgelt = summe_av_0010_entgelt.add(insuranceDues.getUiPayment());
                summe_av_0010_beitrag = summe_av_0010_beitrag.add(insuranceDues.getEeUi0010()).add(insuranceDues.getErUi0010());
                break;
            }
            case 2: {
                summe_av_0020_entgelt = summe_av_0020_entgelt.add(insuranceDues.getUiPayment());
                summe_av_0020_beitrag = summe_av_0020_beitrag.add(insuranceDues.getEeUi0020()).add(insuranceDues.getErUi0020());
            }
        }
        switch (insuranceDues.getDuesGroupNI()) {
            case 1: {
                if (insuranceDues.getDuesGroupHI() != 9) {
                    summe_pv_0001_entgelt = summe_pv_0001_entgelt.add(insuranceDues.getNiPayment());
                    summe_pv_0001_beitrag = summe_pv_0001_beitrag.add(insuranceDues.getEeNi0001()).add(insuranceDues.getEeNi0002()).add(insuranceDues.getErNi0001()).add(insuranceDues.getErNi0002());
                    break;
                }
            }
            case 2: {
                if (DateHelper.before((Date)insuranceDues.getDateOfList(), (Date)new VDate(2014, 3, 1).getDate())) {
                    if (insuranceDues.getTypeOfListEnum() != TypeOfListEnum.TOLE_PFLICHTVERSICHERT) break;
                    switch (insuranceDues.getTypeOfPaymentEnum().value()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            summe_pv_0001_entgelt = summe_pv_0001_entgelt.add(insuranceDues.getNiPayment());
                            summe_pv_0001_beitrag = summe_pv_0001_beitrag.add(insuranceDues.getEeNi0001()).add(insuranceDues.getEeNi0002()).add(insuranceDues.getErNi0001()).add(insuranceDues.getErNi0002());
                        }
                    }
                    break;
                }
                if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_FIKTIVESENTGELT_100AG) {
                    summe_pv_0001_entgelt = summe_pv_0001_entgelt.add(insuranceDues.getNiPayment());
                    summe_pv_0001_beitrag = summe_pv_0001_beitrag.add(insuranceDues.getEeNi0001()).add(insuranceDues.getEeNi0002()).add(insuranceDues.getErNi0001()).add(insuranceDues.getErNi0002());
                    break;
                }
                switch (insuranceDues.getTypeOfPaymentEnum().value()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        summe_pv_0001_entgelt = summe_pv_0001_entgelt.add(insuranceDues.getNiPayment());
                        summe_pv_0001_beitrag = summe_pv_0001_beitrag.add(insuranceDues.getEeNi0001()).add(insuranceDues.getEeNi0002()).add(insuranceDues.getErNi0001()).add(insuranceDues.getErNi0002());
                    }
                }
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)insuranceDues.getU1())) {
            summe_u1_entgelt = summe_u1_entgelt.add(insuranceDues.getAssessmentPayment());
            summe_u1_beitrag = summe_u1_beitrag.add(insuranceDues.getU1());
        }
        if (!BigDecimalMapper.isZero((BigDecimal)insuranceDues.getU2()) || insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_UMLAGEPFLICHT && StringMapper.equal((String)insuranceDues.getHfStdCompanyNo(), (String)"98000006")) {
            summe_u2_entgelt = summe_u2_entgelt.add(insuranceDues.getAssessmentPayment());
            summe_u2_beitrag = summe_u2_beitrag.add(insuranceDues.getU2());
        }
        if (!BigDecimalMapper.isZero((BigDecimal)insuranceDues.getVhi())) {
            summe_kv_frw_entgelt = summe_kv_frw_entgelt.add(insuranceDues.getHiPayment());
            summe_kv_frw_beitrag = summe_kv_frw_beitrag.add(insuranceDues.getVhi());
        }
        if (!BigDecimalMapper.isZero((BigDecimal)insuranceDues.getVni())) {
            summe_pv_frw_entgelt = summe_pv_frw_entgelt.add(insuranceDues.getNiPayment());
            summe_pv_frw_beitrag = summe_pv_frw_beitrag.add(insuranceDues.getVni());
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(summe_st_beitrag = insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_PFLICHTVERSICHERT && insuranceDues.getTypeOfPaymentEnum() == TypeOfPaymentEnum.TOPE_LAUFEND ? BigDecimal.valueOf(0L, 2) : summe_st_beitrag.add(insuranceDues.getEeLumpSumIncomeTax()).add(insuranceDues.getErLumpSumIncomeTax())))) {
            if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_VORTRAG_BEITRAGSDIFFERENZ) {
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)insuranceDues.getHiPayment())) {
                    summe_st_entgelt = summe_st_entgelt.add(insuranceDues.getHiPayment());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)insuranceDues.getPiPayment())) {
                    summe_st_entgelt = summe_st_entgelt.add(insuranceDues.getPiPayment());
                }
            } else {
                summe_st_entgelt = summe_st_entgelt.add(insuranceDues.getPayment());
            }
        }
        if (!StringMapper.isNullString((String)insuranceDues.getAdditionalString())) {
            summe_u1_erstattung = summe_u1_erstattung.add(BigDecimal.valueOf(Integer.parseInt(insuranceDues.getAdditionalString()), 2));
        }
        summe_u2_erstattung = summe_u2_erstattung.add(insuranceDues.getAdditionalDecimal());
        summe_u1_u2_erstattung = summe_u1_u2_erstattung.add(summe_u1_erstattung).add(summe_u2_erstattung);
        summe_kv_frw_zusatzbeitrag = summe_kv_frw_zusatzbeitrag.add(insuranceDues.getAddititionalDuesVHI());
        summe_kv_zusatzbeitrag = summe_kv_zusatzbeitrag.add(insuranceDues.getAddititionalDuesHI()).add(insuranceDues.getAdditionalDuesHIER());
        summe_beitrag = summe_beitrag.add(summe_kv_1000_beitrag).add(summe_kv_2000_beitrag).add(summe_kv_3000_beitrag).add(summe_kv_6000_beitrag).add(summe_rv_0100_beitrag).add(summe_rv_0200_beitrag).add(summe_rv_0300_beitrag).add(summe_rv_0400_beitrag).add(summe_rv_0500_beitrag).add(summe_rv_0600_beitrag).add(summe_av_0010_beitrag).add(summe_av_0020_beitrag).add(summe_av_0050_beitrag).add(summe_pv_0001_beitrag).add(summe_u1_beitrag).add(summe_u2_beitrag).add(summe_kv_frw_beitrag).add(summe_pv_frw_beitrag).add(summe_st_beitrag).subtract(summe_u1_erstattung).subtract(summe_u2_erstattung).add(summe_kv_frw_zusatzbeitrag).add(summe_kv_zusatzbeitrag);
        StatementOfContributionSummBDBean sOCSummBDBean = new StatementOfContributionSummBDBean(summe_kv_1000_entgelt, summe_kv_2000_entgelt, summe_kv_3000_entgelt, summe_kv_6000_entgelt, summe_rv_0100_entgelt, summe_rv_0200_entgelt, summe_rv_0300_entgelt, summe_rv_0400_entgelt, summe_rv_0500_entgelt, summe_rv_0600_entgelt, summe_av_0010_entgelt, summe_av_0020_entgelt, summe_av_0050_entgelt, summe_pv_0001_entgelt, summe_u1_entgelt, summe_u2_entgelt, summe_kv_frw_entgelt, summe_pv_frw_entgelt, summe_st_entgelt, summe_entgelt, summe_kv_1000_beitrag, summe_kv_2000_beitrag, summe_kv_3000_beitrag, summe_kv_6000_beitrag, summe_rv_0100_beitrag, summe_rv_0200_beitrag, summe_rv_0300_beitrag, summe_rv_0400_beitrag, summe_rv_0500_beitrag, summe_rv_0600_beitrag, summe_av_0010_beitrag, summe_av_0020_beitrag, summe_av_0050_beitrag, summe_pv_0001_beitrag, summe_u1_beitrag, summe_u2_beitrag, summe_kv_frw_beitrag, summe_pv_frw_beitrag, summe_st_beitrag, summe_u1_erstattung, summe_u2_erstattung, summe_beitrag, summe_kv_1000_SAG_Beitrag, summe_kv_3000_SAG_Beitrag, summe_kv_frw_SAG_Beitrag, "", summe_kv_zusatzbeitrag, summe_kv_frw_zusatzbeitrag);
        return sOCSummBDBean;
    }

    public static StatementOfContributionTypeBDBean getSOCTypeBDBeanFromInsuranceDues(InsuranceDues insuranceDues) {
        String monat_bezeichnung = ReportHelper.getMonthDescription((int)new VDate(insuranceDues.getDateOfList()).getMonth());
        String jahr = Integer.toString(new VDate(insuranceDues.getDateOfList()).getYear());
        BigDecimal sfn_zuschlag = BigDecimal.valueOf(0L, 2);
        BigDecimal eE_St = insuranceDues.getEeLumpSumIncomeTax();
        if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_PFLICHTVERSICHERT && insuranceDues.getTypeOfPaymentEnum() == TypeOfPaymentEnum.TOPE_LAUFEND) {
            sfn_zuschlag = sfn_zuschlag.add(insuranceDues.getEeLumpSumIncomeTax());
            eE_St = BigDecimal.valueOf(0L, 2);
        }
        if (insuranceDues.getTypeOfListEnum() == TypeOfListEnum.TOLE_KURZARBEITERGELD && !BigDecimalMapper.isZeroOrNull((BigDecimal)insuranceDues.getKUGPayment())) {
            sfn_zuschlag = sfn_zuschlag.add(insuranceDues.getKUGPayment().setScale(2));
        }
        Object monat_jahr = "";
        monat_jahr = DateHelper.before((Date)insuranceDues.getDateOfList(), (Date)insuranceDues.getEffectiveFrom()) ? ReportHelper.getMonthDescriptionShort((int)new VDate(insuranceDues.getDateOfList()).getMonth()) + " / " + Integer.toString(new VDate(insuranceDues.getDateOfList()).getYear()) : ReportHelper.getMonthDescriptionShort((int)new VDate(insuranceDues.getEffectiveFrom()).getMonth()) + " / " + Integer.toString(new VDate(insuranceDues.getEffectiveFrom()).getYear());
        String monat_jahr_abrechnung = ReportHelper.getMonthDescription((int)new VDate(insuranceDues.getValidFrom()).getMonth()) + " / " + Integer.toString(new VDate(insuranceDues.getValidFrom()).getYear());
        StatementOfContributionTypeBDBean typeBDBean = new StatementOfContributionTypeBDBean(monat_jahr_abrechnung, (String)monat_jahr, insuranceDues.getDateOfList(), TypeOfListEnumMapper.toEnumDescription((int)insuranceDues.getTypeOfListEnum().value()), monat_bezeichnung + " / " + jahr, Integer.toString(insuranceDues.getPersonnelnumber()), insuranceDues.getFirstname(), insuranceDues.getSurname(), Integer.toString(insuranceDues.getDuesGroupHI()), Integer.toString(insuranceDues.getDuesGroupPI()), Integer.toString(insuranceDues.getDuesGroupUI()), Integer.toString(insuranceDues.getDuesGroupNI()), Integer.toString(insuranceDues.getNumberOfHIDay()), Integer.toString(insuranceDues.getNumberOfPIDay()), Integer.toString(insuranceDues.getNumberOfUIDay()), Integer.toString(insuranceDues.getNumberOfNIDay()), insuranceDues.getNiChildEducation() ? "E" : "", Integer.toString(insuranceDues.getPersonGroup()), insuranceDues.getPayment(), sfn_zuschlag, TypeOfPaymentEnumMapper.toEnumDescription((int)insuranceDues.getTypeOfPaymentEnum().value()), insuranceDues.getInsuranceNo(), insuranceDues.getAssessmentPayment(), insuranceDues.getHiPayment(), insuranceDues.getUiPayment(), insuranceDues.getPiPayment(), insuranceDues.getNiPayment(), insuranceDues.getEeHi1000(), insuranceDues.getEeHi2000(), insuranceDues.getEeHi3000(), insuranceDues.getEePi0100(), insuranceDues.getEePi0200(), insuranceDues.getEeUi0010(), insuranceDues.getEeUi0020(), insuranceDues.getEeNi0001(), insuranceDues.getEeNi0002(), eE_St, insuranceDues.getErHi1000(), insuranceDues.getErHi2000(), insuranceDues.getErHi3000(), insuranceDues.getErPi0100(), insuranceDues.getErPi0200(), insuranceDues.getErUi0010(), insuranceDues.getErUi0020(), insuranceDues.getErNi0001(), insuranceDues.getErNi0002(), insuranceDues.getErLumpSumIncomeTax(), insuranceDues.getErHi5000(), insuranceDues.getErHi6000(), insuranceDues.getErPi0300(), insuranceDues.getErPi0400(), insuranceDues.getErPi0500(), insuranceDues.getErPi0600(), insuranceDues.getU1(), insuranceDues.getU2(), insuranceDues.getVhi(), insuranceDues.getVni(), insuranceDues.getPiDifference(), insuranceDues.getInsolvencyAssessmentDues(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, insuranceDues.getAddititionalDuesHI(), insuranceDues.getAdditionalDuesHIER(), insuranceDues.getAddititionalDuesVHI());
        typeBDBean.setTypeOfStatusEnum(TypeOfStatusEnumMapper.toTypeOfStatusEnum((int)insuranceDues.getAdditionalInteger()));
        typeBDBean.setStatus(TypeOfStatusEnumMapper.toEnumDescription((int)insuranceDues.getAdditionalInteger()));
        if (insuranceDues.getTypeOfListEnum().value() == 11 && !BigDecimalMapper.isZeroOrNull((BigDecimal)insuranceDues.getKUGPayment())) {
            typeBDBean.setKug("KUG");
        }
        StatementOfContributionSummBDBean summBean = SOCDataSourceHelper.getStatementOfContributionSummBDBean(insuranceDues);
        typeBDBean.setStatementOfContributionSummBDBean(summBean);
        return typeBDBean;
    }

    private static void setSOCTBDBeanHeaderSettings(StatementOfContributionTypeBDBean sOCTBDBeanOreginal, StatementOfContributionTypeBDBean sOCTBDBeanCopy, Date dateForSort) {
        sOCTBDBeanCopy.setTypeOfListEnum(sOCTBDBeanOreginal.getTypeOfListEnum());
        sOCTBDBeanCopy.setTypeOfPaymentEnum(sOCTBDBeanOreginal.getTypeOfPaymentEnum());
        sOCTBDBeanCopy.setTypeOfStatusEnum(sOCTBDBeanOreginal.getTypeOfStatusEnum());
        sOCTBDBeanCopy.setSortDate(new VDate(2006, 0, 1).getDate());
        sOCTBDBeanCopy.setSortDateBSBI(dateForSort);
        sOCTBDBeanCopy.setTypeOfBeitragEnum(sOCTBDBeanOreginal.getTypeOfBeitragEnum());
        sOCTBDBeanCopy.setBeitragsSollIstDescription(sOCTBDBeanOreginal.getBeitragsSollIstDescription());
        sOCTBDBeanCopy.setPersonnelNumberInt(sOCTBDBeanOreginal.getPersonnelNumberInt());
        sOCTBDBeanCopy.setArbeitgeber_bezeichnung(sOCTBDBeanOreginal.getArbeitgeber_bezeichnung());
        sOCTBDBeanCopy.setArbeitgeber_code(sOCTBDBeanOreginal.getArbeitgeber_code());
        sOCTBDBeanCopy.setArbeitgeber_plz_ort(sOCTBDBeanOreginal.getArbeitgeber_plz_ort());
        sOCTBDBeanCopy.setArbeitgeber_land(sOCTBDBeanOreginal.getArbeitgeber_land());
        sOCTBDBeanCopy.setArbeitgeber_str_nr(sOCTBDBeanOreginal.getArbeitgeber_str_nr());
        sOCTBDBeanCopy.setKk_bezeichnung(sOCTBDBeanOreginal.getKk_bezeichnung());
        sOCTBDBeanCopy.setRechtskreis(sOCTBDBeanOreginal.getRechtskreis());
        sOCTBDBeanCopy.setRefereToHealthFundDescription(sOCTBDBeanOreginal.getRefereToHealthFundDescription());
        sOCTBDBeanCopy.setRefereToOidHealthFund(sOCTBDBeanOreginal.getRefereToOidHealthFund());
        sOCTBDBeanCopy.setReferForSortHealthFundDescritionStdCompanyNr(sOCTBDBeanOreginal.getReferForSortHealthFundDescritionStdCompanyNr());
        sOCTBDBeanCopy.setReferToHealthFundStdCompanyNr(sOCTBDBeanOreginal.getReferToHealthFundStdCompanyNr());
        sOCTBDBeanCopy.setReferToOidArbeitgeber(sOCTBDBeanOreginal.getReferToOidArbeitgeber());
        sOCTBDBeanCopy.setReferToArbeitgeberDescription(sOCTBDBeanOreginal.getReferToArbeitgeberDescription());
        sOCTBDBeanCopy.setReferToOidCompHealthFund(sOCTBDBeanOreginal.getReferToOidCompHealthFund());
        sOCTBDBeanCopy.setReferToPLant(sOCTBDBeanOreginal.getReferToPLant());
        sOCTBDBeanCopy.setSvHealthFundToPlant(sOCTBDBeanOreginal.getSvHealthFundToPlant());
        sOCTBDBeanCopy.setAssessmentHealthFundToPlan(sOCTBDBeanOreginal.getAssessmentHealthFundToPlan());
        sOCTBDBeanCopy.setPersonnelNumber(sOCTBDBeanOreginal.getPersonnelNumber());
        sOCTBDBeanCopy.setSurname(sOCTBDBeanOreginal.getSurname());
        sOCTBDBeanCopy.setFirstName(sOCTBDBeanOreginal.getFirstName());
        sOCTBDBeanCopy.setOidEmployee(sOCTBDBeanOreginal.getOidEmployee());
        sOCTBDBeanCopy.setOidPCompany(sOCTBDBeanOreginal.getOidPCompany());
        sOCTBDBeanCopy.setOidPlant(sOCTBDBeanOreginal.getOidPlant());
        sOCTBDBeanCopy.setPlantDescription(sOCTBDBeanOreginal.getPlantDescription());
        sOCTBDBeanCopy.setEffectiveDate(dateForSort);
        sOCTBDBeanCopy.setValidFromDate(DateHelper.getFirstDayOfMonth((Date)dateForSort));
        sOCTBDBeanCopy.setValidUntilDate(DateHelper.getLastDayOfMonth((Date)dateForSort));
        sOCTBDBeanCopy.setPlantLawArea(sOCTBDBeanOreginal.getPlantLawArea());
        sOCTBDBeanCopy.setNurUmlage(sOCTBDBeanOreginal.getNurUmlage());
        sOCTBDBeanCopy.setSVAccountnumber(sOCTBDBeanOreginal.getSVAccountnumber());
        sOCTBDBeanCopy.setAssessmentAccountnumber(sOCTBDBeanOreginal.getAssessmentAccountnumber());
    }

    private static List<StatementOfContributionTypeBDBean> makeTypeBDBeansSechstel(StatementOfContributionTypeBDBean typeBDBean, Date reportValidDate) {
        StatementOfContributionSummBDBean sOCSummBDBeanSechstel;
        StatementOfContributionTypeBDBean beanCopy;
        LinkedList<StatementOfContributionTypeBDBean> sechstelTypeBDBeansLi = new LinkedList<StatementOfContributionTypeBDBean>();
        BigDecimal arbeitsentgelt = typeBDBean.getArbeitsentgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal umlageentgelt = typeBDBean.getUmlageentgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal kv_entgelt = typeBDBean.getKv_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal av_entgelt = typeBDBean.getAv_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal rv_entgelt = typeBDBean.getRv_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal pv_entgelt = typeBDBean.getPv_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_1000 = typeBDBean.getAna_1000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_2000 = typeBDBean.getAna_2000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_3000 = typeBDBean.getAna_3000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_0100 = typeBDBean.getAna_0100().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_0200 = typeBDBean.getAna_0200().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_0010 = typeBDBean.getAna_0010().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_0020 = typeBDBean.getAna_0020().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_0001 = typeBDBean.getAna_0001().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_0002 = typeBDBean.getAna_0002().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal ana_st = typeBDBean.getAna_st().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_1000 = typeBDBean.getAga_1000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_2000 = typeBDBean.getAga_2000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_3000 = typeBDBean.getAga_3000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0100 = typeBDBean.getAga_0100().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0200 = typeBDBean.getAga_0200().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0010 = typeBDBean.getAga_0010().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0020 = typeBDBean.getAga_0020().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0050 = typeBDBean.getAga_0050().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0001 = typeBDBean.getAga_0001().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0002 = typeBDBean.getAga_0002().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_st = typeBDBean.getAga_st().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_5000 = typeBDBean.getAga_5000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_6000 = typeBDBean.getAga_6000().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0300 = typeBDBean.getAga_0300().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0400 = typeBDBean.getAga_0400().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0500 = typeBDBean.getAga_0500().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_0600 = typeBDBean.getAga_0600().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_u1 = typeBDBean.getAga_u1().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_u2 = typeBDBean.getAga_u2().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_freiwillig_kv = typeBDBean.getAga_freiwillig_kv().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal aga_freiwillig_pv = typeBDBean.getAga_freiwillig_pv().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal rv_unterschied = typeBDBean.getRv_unterschied().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal kv_ana_zusatzbeitrag = typeBDBean.getKv_ana_zusatzbeitrag().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal kv_aga_zusatzbeitrag = typeBDBean.getKv_aga_zusatzbeitrag().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal kv_fw_zusatzbeitrag = typeBDBean.getKv_fw_zusatzbeitrag().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        StatementOfContributionSummBDBean summBeanOreginal = typeBDBean.getStatementOfContributionSummBDBean();
        BigDecimal summe_kv_1000_entgelt = summBeanOreginal.getF_summe_kv_1000_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_kv_2000_entgelt = summBeanOreginal.getF_summe_kv_2000_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_kv_3000_entgelt = summBeanOreginal.getF_summe_kv_3000_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_kv_6000_entgelt = summBeanOreginal.getF_summe_kv_6000_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_rv_0100_entgelt = summBeanOreginal.getF_summe_rv_0100_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_rv_0200_entgelt = summBeanOreginal.getF_summe_rv_0200_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_rv_0300_entgelt = summBeanOreginal.getF_summe_rv_0300_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_rv_0400_entgelt = summBeanOreginal.getF_summe_rv_0400_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_rv_0500_entgelt = summBeanOreginal.getF_summe_rv_0500_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_rv_0600_entgelt = summBeanOreginal.getF_summe_rv_0600_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_av_0010_entgelt = summBeanOreginal.getF_summe_av_0010_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_av_0020_entgelt = summBeanOreginal.getF_summe_av_0020_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_av_0050_entgelt = summBeanOreginal.getF_summe_av_0050_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_pv_0001_entgelt = summBeanOreginal.getF_summe_pv_0001_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_u1_entgelt = summBeanOreginal.getF_summe_u1_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_u2_entgelt = summBeanOreginal.getF_summe_u2_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_kv_frw_entgelt = summBeanOreginal.getF_summe_kv_frw_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_pv_frw_entgelt = summBeanOreginal.getF_summe_pv_frw_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_st_entgelt = summBeanOreginal.getF_summe_st_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_entgelt = summBeanOreginal.getF_summe_entgelt().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_u1_erstattung = summBeanOreginal.getF_summe_u1_erstattung().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_u2_erstattung = summBeanOreginal.getF_summe_u2_erstattung().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_kv_zusatzbeitrag = summBeanOreginal.getF_summe_kv_zusatzbeitrag().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        BigDecimal summe_kv_fw_zusatzbeitrag = summBeanOreginal.getF_summe_kv_fw_zusatzbeitrag().divide(new BigDecimal(6), 2, RoundingMode.HALF_UP);
        int i = 0;
        Date dateForSort = VDate.getDateMax();
        String arbeitsentgelt_typ = "";
        TypeOfPaymentEnum typeOfPaymentEnum = TypeOfPaymentEnum.TOPE_KEINE;
        switch (TypeOfPaymentEnumMapper.toInt((TypeOfPaymentEnum)typeBDBean.getTypeOfPaymentEnum())) {
            case 0: {
                typeOfPaymentEnum = TypeOfPaymentEnum.TOPE_KEINE_SECHSTEL;
                arbeitsentgelt_typ = TypeOfPaymentEnumMapper.toEnumDescription((int)5);
                break;
            }
            case 1: {
                typeOfPaymentEnum = TypeOfPaymentEnum.TOPE_LAUFEND_SECHSTEL;
                arbeitsentgelt_typ = TypeOfPaymentEnumMapper.toEnumDescription((int)6);
                break;
            }
            case 2: {
                typeOfPaymentEnum = TypeOfPaymentEnum.TOPE_EGA_SECHSTEL;
                arbeitsentgelt_typ = TypeOfPaymentEnumMapper.toEnumDescription((int)7);
                break;
            }
            case 3: {
                typeOfPaymentEnum = TypeOfPaymentEnum.TOPE_MK_FJ_SECHSTEL;
                arbeitsentgelt_typ = TypeOfPaymentEnumMapper.toEnumDescription((int)8);
                break;
            }
            case 4: {
                typeOfPaymentEnum = TypeOfPaymentEnum.TOPE_MW_SW_SECHSTEL;
                arbeitsentgelt_typ = TypeOfPaymentEnumMapper.toEnumDescription((int)9);
            }
        }
        Date vorMonatValidDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)reportValidDate));
        Date vorMonatFirstValidDtae = DateHelper.getFirstDayOfMonth((Date)vorMonatValidDate);
        Date vorMonatLastValidDtae = DateHelper.getLastDayOfMonth((Date)vorMonatValidDate);
        BigDecimal summe_beitrag_1_5 = BigDecimal.valueOf(0L, 2);
        summe_beitrag_1_5 = summe_beitrag_1_5.add(ana_1000).add(aga_1000).add(ana_2000).add(aga_2000).add(ana_3000).add(aga_3000).add(aga_6000).add(ana_0100).add(aga_0100).add(ana_0200).add(aga_0200).add(aga_0300).add(aga_0400).add(aga_0500).add(aga_0600).add(ana_0010).add(aga_0010).add(ana_0020).add(aga_0050).add(aga_0020).add(ana_0001).add(aga_0001).add(aga_u1).add(aga_u2).add(aga_freiwillig_kv).add(aga_freiwillig_pv).add(ana_st).add(aga_st);
        while (sechstelTypeBDBeansLi.size() != 5) {
            dateForSort = new VDate(2006, i, 1).getDate();
            beanCopy = new StatementOfContributionTypeBDBean(typeBDBean.getMonat_jahr_abrechnung(), typeBDBean.getMonat_jahr(), typeBDBean.getMonth(), typeBDBean.getListen_typ(), typeBDBean.getMonat_bezeichnung(), typeBDBean.getPers_nr(), typeBDBean.getVorname(), typeBDBean.getFamilienname(), typeBDBean.getBgs_kv(), typeBDBean.getBgs_rv(), typeBDBean.getBgs_av(), typeBDBean.getBgs_pv(), typeBDBean.getBgs_kv_tage(), typeBDBean.getBgs_rv_tage(), typeBDBean.getBgs_av_tage(), typeBDBean.getBgs_pv_tage(), typeBDBean.getParent(), typeBDBean.getPgs(), arbeitsentgelt, BigDecimal.valueOf(0L, 2), arbeitsentgelt_typ, typeBDBean.getVersicherungsnummer(), umlageentgelt, kv_entgelt, av_entgelt, rv_entgelt, pv_entgelt, ana_1000, ana_2000, ana_3000, ana_0100, ana_0200, ana_0010, ana_0020, ana_0001, ana_0002, ana_st, aga_1000, aga_2000, aga_3000, aga_0100, aga_0200, aga_0010, aga_0020, aga_0001, aga_0002, aga_st, aga_5000, aga_6000, aga_0300, aga_0400, aga_0500, aga_0600, aga_u1, aga_u2, aga_freiwillig_kv, aga_freiwillig_pv, rv_unterschied, aga_0050, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, kv_ana_zusatzbeitrag, kv_aga_zusatzbeitrag, kv_fw_zusatzbeitrag);
            typeBDBean.setTypeOfPaymentEnum(typeOfPaymentEnum);
            SOCDataSourceHelper.setSOCTBDBeanHeaderSettings(typeBDBean, beanCopy, dateForSort);
            if (DateHelper.between((Date)dateForSort, (Date)vorMonatFirstValidDtae, (Date)vorMonatLastValidDtae)) {
                sOCSummBDBeanSechstel = new StatementOfContributionSummBDBean(summe_kv_1000_entgelt, summe_kv_2000_entgelt, summe_kv_3000_entgelt, summe_kv_6000_entgelt, summe_rv_0100_entgelt, summe_rv_0200_entgelt, summe_rv_0300_entgelt, summe_rv_0400_entgelt, summe_rv_0500_entgelt, summe_rv_0600_entgelt, summe_av_0010_entgelt, summe_av_0020_entgelt, summe_av_0050_entgelt, summe_pv_0001_entgelt, summe_u1_entgelt, summe_u2_entgelt, summe_kv_frw_entgelt, summe_pv_frw_entgelt, summe_st_entgelt, summe_entgelt, ana_1000.add(aga_1000), ana_2000.add(aga_2000), ana_3000.add(aga_3000), aga_6000, ana_0100.add(aga_0100), ana_0200.add(aga_0200), aga_0300, aga_0400, aga_0500, aga_0600, ana_0010.add(aga_0010), ana_0020.add(aga_0020), aga_0050, ana_0001.add(aga_0001), aga_u1, aga_u2, aga_freiwillig_kv, aga_freiwillig_pv, ana_st.add(aga_st), summe_u1_erstattung, summe_u2_erstattung, summe_beitrag_1_5, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", summe_kv_zusatzbeitrag, summe_kv_fw_zusatzbeitrag);
                beanCopy.setStatementOfContributionSummBDBean(sOCSummBDBeanSechstel);
            } else {
                beanCopy.setStatementOfContributionSummBDBean(null);
            }
            sechstelTypeBDBeansLi.add(beanCopy);
            ++i;
        }
        dateForSort = new VDate(2006, i, 1).getDate();
        if (sechstelTypeBDBeansLi.size() == 5) {
            beanCopy = new StatementOfContributionTypeBDBean(typeBDBean.getMonat_jahr_abrechnung(), typeBDBean.getMonat_jahr(), typeBDBean.getMonth(), typeBDBean.getListen_typ(), typeBDBean.getMonat_bezeichnung(), typeBDBean.getPers_nr(), typeBDBean.getVorname(), typeBDBean.getFamilienname(), typeBDBean.getBgs_kv(), typeBDBean.getBgs_rv(), typeBDBean.getBgs_av(), typeBDBean.getBgs_pv(), typeBDBean.getBgs_kv_tage(), typeBDBean.getBgs_rv_tage(), typeBDBean.getBgs_av_tage(), typeBDBean.getBgs_pv_tage(), typeBDBean.getParent(), typeBDBean.getPgs(), typeBDBean.getArbeitsentgelt().subtract(arbeitsentgelt.multiply(new BigDecimal(5))), BigDecimal.valueOf(0L, 2), typeBDBean.getArbeitsentgelt_typ(), typeBDBean.getVersicherungsnummer(), typeBDBean.getUmlageentgelt().subtract(umlageentgelt), typeBDBean.getKv_entgelt().subtract(kv_entgelt.multiply(new BigDecimal(5))), typeBDBean.getAv_entgelt().subtract(av_entgelt.multiply(new BigDecimal(5))), typeBDBean.getRv_entgelt().subtract(rv_entgelt.multiply(new BigDecimal(5))), typeBDBean.getPv_entgelt().subtract(pv_entgelt.multiply(new BigDecimal(5))), typeBDBean.getAna_1000().subtract(ana_1000.multiply(new BigDecimal(5))), typeBDBean.getAna_2000().subtract(ana_2000.multiply(new BigDecimal(5))), typeBDBean.getAna_3000().subtract(ana_3000.multiply(new BigDecimal(5))), typeBDBean.getAna_0100().subtract(ana_0100.multiply(new BigDecimal(5))), typeBDBean.getAna_0200().subtract(ana_0200.multiply(new BigDecimal(5))), typeBDBean.getAna_0010().subtract(ana_0010.multiply(new BigDecimal(5))), typeBDBean.getAna_0020().subtract(ana_0020.multiply(new BigDecimal(5))), typeBDBean.getAna_0001().subtract(ana_0001.multiply(new BigDecimal(5))), typeBDBean.getAna_0002().subtract(ana_0002.multiply(new BigDecimal(5))), typeBDBean.getAna_st().subtract(ana_st.multiply(new BigDecimal(5))), typeBDBean.getAga_1000().subtract(aga_1000.multiply(new BigDecimal(5))), typeBDBean.getAga_2000().subtract(aga_2000.multiply(new BigDecimal(5))), typeBDBean.getAga_3000().subtract(aga_3000.multiply(new BigDecimal(5))), typeBDBean.getAga_0100().subtract(aga_0100.multiply(new BigDecimal(5))), typeBDBean.getAga_0200().subtract(aga_0200.multiply(new BigDecimal(5))), typeBDBean.getAga_0010().subtract(aga_0010.multiply(new BigDecimal(5))), typeBDBean.getAga_0020().subtract(aga_0020.multiply(new BigDecimal(5))), typeBDBean.getAga_0001().subtract(aga_0001.multiply(new BigDecimal(5))), typeBDBean.getAga_0002().subtract(aga_0002.multiply(new BigDecimal(5))), typeBDBean.getAga_st().subtract(aga_st.multiply(new BigDecimal(5))), typeBDBean.getAga_5000().subtract(aga_5000.multiply(new BigDecimal(5))), typeBDBean.getAga_6000().subtract(aga_6000.multiply(new BigDecimal(5))), typeBDBean.getAga_0300().subtract(aga_0300.multiply(new BigDecimal(5))), typeBDBean.getAga_0400().subtract(aga_0400.multiply(new BigDecimal(5))), typeBDBean.getAga_0500().subtract(aga_0500.multiply(new BigDecimal(5))), typeBDBean.getAga_0600().subtract(aga_0600.multiply(new BigDecimal(5))), typeBDBean.getAga_u1().subtract(aga_u1.multiply(new BigDecimal(5))), typeBDBean.getAga_u2().subtract(aga_u2.multiply(new BigDecimal(5))), typeBDBean.getAga_freiwillig_kv().subtract(aga_freiwillig_kv.multiply(new BigDecimal(5))), typeBDBean.getAga_freiwillig_pv().subtract(aga_freiwillig_pv.multiply(new BigDecimal(5))), typeBDBean.getRv_unterschied().subtract(rv_unterschied.multiply(new BigDecimal(5))), typeBDBean.getAga_0050().subtract(aga_0050.multiply(new BigDecimal(5))), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, typeBDBean.getKv_ana_zusatzbeitrag(), typeBDBean.getKv_aga_zusatzbeitrag(), typeBDBean.getKv_fw_zusatzbeitrag());
            SOCDataSourceHelper.setSOCTBDBeanHeaderSettings(typeBDBean, beanCopy, dateForSort);
            if (DateHelper.between((Date)dateForSort, (Date)vorMonatFirstValidDtae, (Date)vorMonatLastValidDtae)) {
                sOCSummBDBeanSechstel = new StatementOfContributionSummBDBean(summBeanOreginal.getF_summe_kv_1000_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_kv_2000_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_kv_3000_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_kv_6000_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_rv_0100_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_rv_0200_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_rv_0300_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_rv_0400_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_rv_0500_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_rv_0600_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_av_0010_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_av_0020_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_av_0050_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_pv_0001_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_u1_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_u2_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_kv_frw_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_pv_frw_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_st_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_entgelt().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), beanCopy.getAna_1000().add(beanCopy.getAga_1000()), beanCopy.getAna_2000().add(beanCopy.getAga_2000()), beanCopy.getAna_3000().add(beanCopy.getAga_3000()), beanCopy.getAga_6000(), beanCopy.getAna_0100().add(beanCopy.getAga_0100()), beanCopy.getAna_0200().add(beanCopy.getAga_0200()), beanCopy.getAga_0300(), beanCopy.getAga_0400(), beanCopy.getAga_0500(), beanCopy.getAga_0600(), beanCopy.getAna_0010().add(beanCopy.getAga_0010()), beanCopy.getAna_0020().add(beanCopy.getAga_0020()), beanCopy.getAga_0020(), beanCopy.getAna_0001().add(beanCopy.getAga_0001()), beanCopy.getAga_u1(), beanCopy.getAga_u2(), beanCopy.getAga_freiwillig_kv(), beanCopy.getAga_freiwillig_pv(), beanCopy.getAna_st().add(beanCopy.getAga_st()), summBeanOreginal.getF_summe_u1_erstattung().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_u2_erstattung().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_beitrag().subtract(summe_beitrag_1_5.multiply(new BigDecimal(5))), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", summBeanOreginal.getF_summe_kv_zusatzbeitrag().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)), summBeanOreginal.getF_summe_kv_fw_zusatzbeitrag().divide(new BigDecimal(2), 2, RoundingMode.HALF_UP).divide(new BigDecimal(6), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(2)));
                beanCopy.setStatementOfContributionSummBDBean(sOCSummBDBeanSechstel);
            } else {
                beanCopy.setStatementOfContributionSummBDBean(null);
            }
            sechstelTypeBDBeansLi.add(beanCopy);
        }
        return sechstelTypeBDBeansLi;
    }

    public static List<StatementOfContributionTypeBDBean> makeTypeBDBeansSechstel(List<StatementOfContributionTypeBDBean> reportTypeBDBeansLi, Date reportValidDate) {
        Iterator<StatementOfContributionTypeBDBean> reportTypeBDBeansIt = reportTypeBDBeansLi.iterator();
        LinkedList<StatementOfContributionTypeBDBean> typeBDBeanSechstelLi = new LinkedList<StatementOfContributionTypeBDBean>();
        while (reportTypeBDBeansIt.hasNext()) {
            StatementOfContributionTypeBDBean typeBDBean = reportTypeBDBeansIt.next();
            List<StatementOfContributionTypeBDBean> typeBDBeansSechstelFromOneReportTypeBDBeanLi = SOCDataSourceHelper.makeTypeBDBeansSechstel(typeBDBean, reportValidDate);
            typeBDBeanSechstelLi.addAll(typeBDBeansSechstelFromOneReportTypeBDBeanLi);
        }
        return typeBDBeanSechstelLi;
    }

    public static boolean areBSBIDVMValuesNegativeEquals(StatementOfContributionTypeBDBean stornoBDBean, StatementOfContributionTypeBDBean neuBDBean) {
        String stornovalueString = "";
        if (!StringMapper.isNullString((String)stornoBDBean.getBgs_kv_tage()) && !StringMapper.equal((String)(stornovalueString = stornoBDBean.getBgs_kv_tage().charAt(0) == '-' ? stornoBDBean.getBgs_kv_tage().substring(1, stornoBDBean.getBgs_kv_tage().length()) : stornoBDBean.getBgs_kv_tage()), (String)neuBDBean.getBgs_kv_tage())) {
            return false;
        }
        if (!StringMapper.isNullString((String)stornoBDBean.getBgs_rv_tage()) && !StringMapper.equal((String)(stornovalueString = stornoBDBean.getBgs_rv_tage().charAt(0) == '-' ? stornoBDBean.getBgs_rv_tage().substring(1, stornoBDBean.getBgs_rv_tage().length()) : stornoBDBean.getBgs_rv_tage()), (String)neuBDBean.getBgs_rv_tage())) {
            return false;
        }
        if (!StringMapper.isNullString((String)stornoBDBean.getBgs_av_tage()) && !StringMapper.equal((String)(stornovalueString = stornoBDBean.getBgs_av_tage().charAt(0) == '-' ? stornoBDBean.getBgs_av_tage().substring(1, stornoBDBean.getBgs_av_tage().length()) : stornoBDBean.getBgs_av_tage()), (String)neuBDBean.getBgs_av_tage())) {
            return false;
        }
        if (!StringMapper.isNullString((String)stornoBDBean.getBgs_pv_tage()) && !StringMapper.equal((String)(stornovalueString = stornoBDBean.getBgs_pv_tage().charAt(0) == '-' ? stornoBDBean.getBgs_pv_tage().substring(1, stornoBDBean.getBgs_pv_tage().length()) : stornoBDBean.getBgs_pv_tage()), (String)neuBDBean.getBgs_pv_tage())) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getArbeitsentgelt().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getArbeitsentgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getSfnZuschlaege().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getSfnZuschlaege()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getUmlageentgelt().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getUmlageentgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getKv_entgelt().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getKv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAv_entgelt().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getRv_entgelt().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getRv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getPv_entgelt().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getPv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_1000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_1000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_2000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_2000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_3000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_3000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_0100().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_0100()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_0200().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_0200()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_0010().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_0010()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_0020().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_0020()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0050().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0050()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_0001().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_0001()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_0002().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_0002()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAna_st().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAna_st()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_1000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_1000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_2000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_2000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_3000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_3000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0100().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0100()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0200().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0200()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0010().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0010()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0020().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0020()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0001().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0001()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0002().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0002()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_st().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_st()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_5000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_5000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_6000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_6000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0300().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0300()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0400().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0400()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0500().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0500()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_0600().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_0600()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_u1().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_u1()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_u2().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_u2()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_freiwillig_kv().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_freiwillig_kv()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getAga_freiwillig_pv().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getAga_freiwillig_pv()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getRv_unterschied().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getRv_unterschied()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getSag_1000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getSag_1000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getSag_3000().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getSag_3000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getKv_ana_zusatzbeitrag().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getKv_ana_zusatzbeitrag()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getKv_aga_zusatzbeitrag().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getKv_aga_zusatzbeitrag()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getKv_fw_zusatzbeitrag().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getKv_fw_zusatzbeitrag()) != 0) {
            return false;
        }
        return BigDecimalMapper.compareTo((BigDecimal)stornoBDBean.getSag_freiwillig_kv().multiply(BigDecimal.valueOf(-1L)), (BigDecimal)neuBDBean.getSag_freiwillig_kv()) == 0;
    }

    public static boolean areBSBIDVMValuesEquals(StatementOfContributionTypeBDBean bsBDBean, StatementOfContributionTypeBDBean biBDBean) {
        if (!(StringMapper.equal((String)bsBDBean.getBgs_kv(), (String)biBDBean.getBgs_kv()) && StringMapper.equal((String)bsBDBean.getBgs_rv(), (String)biBDBean.getBgs_rv()) && StringMapper.equal((String)bsBDBean.getBgs_rv(), (String)biBDBean.getBgs_rv()) && StringMapper.equal((String)bsBDBean.getBgs_rv(), (String)biBDBean.getBgs_rv()))) {
            return false;
        }
        if (!((StringMapper.isNullString((String)bsBDBean.getBgs_kv_tage()) || StringMapper.equal((String)bsBDBean.getBgs_kv_tage(), (String)"0")) && (StringMapper.isNullString((String)biBDBean.getBgs_kv_tage()) || StringMapper.equal((String)biBDBean.getBgs_kv_tage(), (String)"0")) || StringMapper.equal((String)bsBDBean.getBgs_kv_tage(), (String)biBDBean.getBgs_kv_tage()))) {
            return false;
        }
        if (!((StringMapper.isNullString((String)bsBDBean.getBgs_rv_tage()) || StringMapper.equal((String)bsBDBean.getBgs_rv_tage(), (String)"0")) && (StringMapper.isNullString((String)biBDBean.getBgs_rv_tage()) || StringMapper.equal((String)biBDBean.getBgs_rv_tage(), (String)"0")) || StringMapper.equal((String)bsBDBean.getBgs_rv_tage(), (String)biBDBean.getBgs_rv_tage()))) {
            return false;
        }
        if (!((StringMapper.isNullString((String)bsBDBean.getBgs_av_tage()) || StringMapper.equal((String)bsBDBean.getBgs_av_tage(), (String)"0")) && (StringMapper.isNullString((String)biBDBean.getBgs_av_tage()) || StringMapper.equal((String)biBDBean.getBgs_av_tage(), (String)"0")) || StringMapper.equal((String)bsBDBean.getBgs_av_tage(), (String)biBDBean.getBgs_av_tage()))) {
            return false;
        }
        if (!((StringMapper.isNullString((String)bsBDBean.getBgs_pv_tage()) || StringMapper.equal((String)bsBDBean.getBgs_pv_tage(), (String)"0")) && (StringMapper.isNullString((String)biBDBean.getBgs_pv_tage()) || StringMapper.equal((String)biBDBean.getBgs_pv_tage(), (String)"0")) || StringMapper.equal((String)bsBDBean.getBgs_pv_tage(), (String)biBDBean.getBgs_pv_tage()))) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getArbeitsentgelt(), (BigDecimal)biBDBean.getArbeitsentgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getUmlageentgelt(), (BigDecimal)biBDBean.getUmlageentgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getKv_entgelt(), (BigDecimal)biBDBean.getKv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAv_entgelt(), (BigDecimal)biBDBean.getAv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getRv_entgelt(), (BigDecimal)biBDBean.getRv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getPv_entgelt(), (BigDecimal)biBDBean.getPv_entgelt()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_1000(), (BigDecimal)biBDBean.getAna_1000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_2000(), (BigDecimal)biBDBean.getAna_2000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_3000(), (BigDecimal)biBDBean.getAna_3000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_0100(), (BigDecimal)biBDBean.getAna_0100()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_0200(), (BigDecimal)biBDBean.getAna_0200()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_0010(), (BigDecimal)biBDBean.getAna_0010()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_0020(), (BigDecimal)biBDBean.getAna_0020()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_0001(), (BigDecimal)biBDBean.getAna_0001()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_0002(), (BigDecimal)biBDBean.getAna_0002()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAna_st(), (BigDecimal)biBDBean.getAna_st()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_1000(), (BigDecimal)biBDBean.getAga_1000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_2000(), (BigDecimal)biBDBean.getAga_2000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_3000(), (BigDecimal)biBDBean.getAga_3000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0100(), (BigDecimal)biBDBean.getAga_0100()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0200(), (BigDecimal)biBDBean.getAga_0200()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0010(), (BigDecimal)biBDBean.getAga_0010()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0020(), (BigDecimal)biBDBean.getAga_0020()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0050(), (BigDecimal)biBDBean.getAga_0050()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0001(), (BigDecimal)biBDBean.getAga_0001()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0002(), (BigDecimal)biBDBean.getAga_0002()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_st(), (BigDecimal)biBDBean.getAga_st()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_5000(), (BigDecimal)biBDBean.getAga_5000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_6000(), (BigDecimal)biBDBean.getAga_6000()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0300(), (BigDecimal)biBDBean.getAga_0300()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0400(), (BigDecimal)biBDBean.getAga_0400()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0500(), (BigDecimal)biBDBean.getAga_0500()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_0600(), (BigDecimal)biBDBean.getAga_0600()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_u1(), (BigDecimal)biBDBean.getAga_u1()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_u2(), (BigDecimal)biBDBean.getAga_u2()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_freiwillig_kv(), (BigDecimal)biBDBean.getAga_freiwillig_kv()) != 0) {
            return false;
        }
        if (BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getAga_freiwillig_pv(), (BigDecimal)biBDBean.getAga_freiwillig_pv()) != 0) {
            return false;
        }
        return BigDecimalMapper.compareTo((BigDecimal)bsBDBean.getRv_unterschied(), (BigDecimal)biBDBean.getRv_unterschied()) == 0;
    }

    public static Conjunction getForActualMonthFilterStructs(Date monatValidDate) {
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)monatValidDate))), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)monatValidDate)))});
    }

    public static Conjunction getEmployeeFilterStructs(Conjunction andConditions, String oidEmployee, String oidPCompany) {
        andConditions.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        andConditions.add(Restrictions.eq((String)"oidpcompany", (String)oidPCompany));
        return andConditions;
    }

    public static Criterion getPCompanyFilterStructs(Criterion filterStructs, String[] oidPCompanies) {
        return Restrictions.and((Criterion)filterStructs, (Criterion)Restrictions.in((String)"oidpcompany", (String[])oidPCompanies));
    }

    public static Criterion getPCompanyFilterStructs(Criterion filterStructs, String oidPCompany) {
        return Restrictions.and((Criterion)filterStructs, (Criterion)Restrictions.eq((String)"oidpcompany", (String)oidPCompany));
    }

    public static void setEmployeeForSOCBeanHealthFundSettings(StatementOfContributionReportDataSource sOCRDS, EmployeeForSOCBean employeeForSOCBean, Date forEffectiveDate, Date forValidDate, HealthFund hf) throws BusinessDomainException {
        String hFShortDescription = sOCRDS.getHFShortDescription(hf.getObjectid(), forEffectiveDate, forValidDate);
        String hFKey = hf.getDomainKey();
        String standardCompanyNumber = sOCRDS.getStandardCompanyNumber(hf.getObjectid(), forEffectiveDate, forValidDate);
        employeeForSOCBean.setHealthFundDesciption(hFShortDescription);
        employeeForSOCBean.setHealthFundStandardCompanyNumber(standardCompanyNumber);
        employeeForSOCBean.setForSortSVHealthFundDescriptionStdCompanyNr(hFKey + standardCompanyNumber);
        employeeForSOCBean.setInsuranceOidhealthfund(hf.getObjectid());
    }

    public static BigDecimal getLfdBeitragspflichtigesEntgelt(String oidEmployee, Date effectiveDate, Date validDate) throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition vp : vpArray = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.in((String)"valuetypenumber", (String[])new String[]{Integer.toString(130510)}), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate)))}))) {
            PersistentObject genesisObject = vp.getGenesisOfParentObjects();
            if (!(genesisObject instanceof ValuePosition)) continue;
            ValuePosition genesisVP = (ValuePosition)genesisObject;
            boolean isBeitragspflichtigLfd = SOCDataSourceHelper.isGenesisBeitragspflichtig(genesisVP, effectiveDate, validDate);
            if (isBeitragspflichtigLfd) {
                result = result.add(vp.getPersistentBuffer3());
                continue;
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue;
            result = result.add(vp.getResult());
        }
        return result;
    }

    public static BigDecimal getKuerzungEntgeltAnSVTagen(String oidEmployee, BigDecimal svEntgelt, Date effectiveDate, Date validDate) throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        ValuePosition[] vpArray = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.in((String)"valuetypenumber", (String[])new String[]{Integer.toString(130590)}), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate)))}));
        if (vpArray.length > 0) {
            for (ValuePosition vp : vpArray) {
                svTage = svTage.add(vp.getFactor1());
            }
        } else {
            svTage = BigDecimal.valueOf(30L);
        }
        return svEntgelt.multiply(svTage).divide(BigDecimal.valueOf(30L), 2, RoundingMode.HALF_UP);
    }

    private static boolean isGenesisBeitragspflichtig(ValuePosition genesisVp, Date effectiveDate, Date validDate) throws BusinessDomainException {
        ConsequenceOfValueType[] covtArray;
        boolean isBeitragspflichtigLfd = false;
        for (ConsequenceOfValueType lElement : covtArray = genesisVp.getValueType().getValueTypeTP(effectiveDate, validDate).getConsequenceForOrientation()) {
            if (lElement.getForClassification() != ClassificationEnum.CE_SV_Beitragspflicht) continue;
            switch (lElement.getConsequenceOfValueType().getValueTypeKey()) {
                case 129510: 
                case 129511: 
                case 130510: {
                    isBeitragspflichtigLfd = true;
                }
            }
        }
        return isBeitragspflichtigLfd;
    }
}

