/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.masterdataimport.socialinsurance;

import com.infor.igf.core.scheduler.ExecutionGroup;
import com.infor.igf.core.scheduler.PreferredScheduler;
import com.infor.igf.core.scheduler.SchedulerService;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.PermanentCalculationJob;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.masterdata.Stammdatendatei;
import com.varial.personnel.domain.global.masterdata.xmlimport.XmlImport;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.global.socialinsurance.global.SocialInsuranceGlobal;
import com.varial.personnel.domain.global.socialinsurance.lawarea.SocialInsuranceLawArea;
import com.varial.personnel.domain.global.socialinsurance.lkk.SocialInsuranceLkk;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.domain.reports.masterdataimport.socialinsurance.SocialInsuranceXmlImportV1;
import com.varial.personnel.domain.reports.masterdataimport.socialinsurance.SocialInsuranceXmlImportV3;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SocialInsuranceXmlImport
extends XmlImport {
    private final AuthorizationToken mToken;
    private final Progressbar<?> mProgressBar;
    static BigDecimal TWELVE = BigDecimal.valueOf(12L);
    static BigDecimal ZERO_TWO = new BigDecimal("0.2");
    static BigDecimal ZERO_EIGHT = new BigDecimal("0.8");
    static BigDecimal ZERO_ZEROFIVE = new BigDecimal("0.05");
    private Date calculationDate = null;

    public SocialInsuranceXmlImport(AuthorizationToken token, Progressbar<?> progressBar, Stammdatendatei stammdatendatei) {
        super(stammdatendatei);
        this.mToken = token;
        this.mProgressBar = progressBar;
    }

    Progressbar<?> getProgressBar() {
        return this.mProgressBar;
    }

    public Date getCalculationDate() {
        return this.calculationDate;
    }

    public void setCalculationDate(Date calculationDate) {
        this.calculationDate = calculationDate;
    }

    public void importXml() throws BusinessDomainException {
        if (this.mStammdatendatei.isV1()) {
            new SocialInsuranceXmlImportV1(this, this.mStammdatendatei.getV1()).importXml();
        } else if (this.mStammdatendatei.isV3()) {
            new SocialInsuranceXmlImportV3(this, this.mStammdatendatei.getV3()).importXml();
        } else {
            throw new RuntimeException("Nur V1 und V3 implementiert");
        }
    }

    void updateCalculationDate(Date gueltigAbDate) {
        this.calculationDate = PDateHelper.minIgnoringNulls((Date[])new Date[]{this.calculationDate, gueltigAbDate});
    }

    public void createCalculations(Progressbar<?> progressBar, Date startDate) throws BusinessDomainException {
        if (this.calculationDate != null) {
            PersistencySession context = SessionContext.getInstance().getPersistencySession();
            Employee[] employees = IEmployeePersistencyManager.getInstance().getAllEE();
            progressBar.setTotal(employees.length);
            PersonnelBasic personnelBasic = PersonnelBasic.getPersonnelBasic();
            Date schedulerTime = personnelBasic.getSchedulerTimeOfGlobalData();
            LocalDateTime executionTime = schedulerTime == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(schedulerTime.getTime()), ZoneId.systemDefault());
            for (Employee employee : employees) {
                if (!employee.isLastDateOfWithdrawalAfter(startDate)) continue;
                Date effectiveFrom = DateHelper.tomorrow((Date)employee.getJournalizedUntil());
                Date validFrom = this.calculationDate;
                Date[] dates = employee.checkAndCorrectStartOfCalculation(effectiveFrom, validFrom);
                String correctEffectiveFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(dates[0].getTime()), ZoneId.systemDefault()).toString();
                String correctValidFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(dates[1].getTime()), ZoneId.systemDefault()).toString();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("oidEmployee", employee.getObjectid());
                parameters.put("effectiveFrom", correctEffectiveFrom);
                parameters.put("validFrom", correctValidFrom);
                parameters.put("classOfBasic", ((Object)((Object)this)).getClass().getName());
                parameters.put("suppliedDomainKey", employee.getDomainKey());
                SchedulerService schedulerService = (SchedulerService)UtilitiesManager.getBean((String)"schedulerService", SchedulerService.class);
                if (executionTime == null) {
                    schedulerService.addJob(PreferredScheduler.CALCULATION, ExecutionGroup.CALCULATION, this.mToken.getUserId(), employee.getSchedulerDescription().toString(), PermanentCalculationJob.class, parameters);
                } else {
                    schedulerService.addJob(PreferredScheduler.CALCULATION, ExecutionGroup.CALCULATION, executionTime, this.mToken.getUserId(), employee.getSchedulerDescription().toString(), PermanentCalculationJob.class, parameters);
                }
                context.flush();
                progressBar.nextProcessed();
            }
        }
    }

    static LocalDate getMin(Set<LocalDate> localDates) {
        LocalDate result = null;
        for (LocalDate localDate : localDates) {
            if (result != null && !localDate.isBefore(result)) continue;
            result = localDate;
        }
        return result;
    }

    static boolean isEqual(SocialInsuranceTP siTP1, SocialInsuranceTP siTP2) {
        return SocialInsuranceXmlImport.isEqual(siTP1.getGlobal(), siTP2.getGlobal()) && SocialInsuranceXmlImport.isEqual(siTP1.getLawAreaWest(), siTP2.getLawAreaWest()) && SocialInsuranceXmlImport.isEqual(siTP1.getLawAreaEast(), siTP2.getLawAreaEast()) && SocialInsuranceXmlImport.isEqual(siTP1.getLkk(), siTP2.getLkk());
    }

    private static boolean isEqual(SocialInsuranceGlobal siGlobal1, SocialInsuranceGlobal siGlobal2) {
        return SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAverageGeneralContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEaverageGeneralContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERaverageGeneralContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAverageReducedContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEaverageReducedContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERaverageReducedContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForNursingInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForMinersPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForMinersPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForMinersPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEblanketContributionRateForHIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERblanketContributionRateForHIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEblanketContributionRateForPIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERblanketContributionRateForPIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getInsignificantMaximumLimitForLowIncomeEarnersAmount) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getMinimumCalculationBasisForLowIncomeEarnersAmount) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getFactorForFormula) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getLowWageFrom) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getLowWageUntil) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargeNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargeNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargeNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargeHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargeHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargeHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargeUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargeUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargeUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargePI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargePI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargePI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getPercentInsolvencyAssessment) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDues) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getDebtLimit) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesKVDR) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesHIEE) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesHIER) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getFactorForFormulaTransition) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getNursingInsuranceReduction) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEratePensionInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getLumpsumMinijob);
    }

    private static boolean isEqual(SocialInsuranceLawArea siLawArea1, SocialInsuranceLawArea siLawArea2) {
        return SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getBasicAmountForHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getBasicAmountForHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getBasicAmountForPensionersAndUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMaximumAssessableEarningsForHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMaximumAssessableEarningsForMinersPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMinimumCalculationBasisForContributionOfHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMinimumCalculationBasisForContributionOfPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getCalculationBasisForContributionOfHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getCalculationBasisForContributionOfUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getGeneralMarginalValueOfLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getAnnualEarningsLimitHI);
    }

    private static boolean isEqual(SocialInsuranceLkk siLkk1, SocialInsuranceLkk siLkk2) {
        return SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesHIGeneral) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesHIReduced) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesNIChildless) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesNIChildEducation) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesNITwoChild) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesNIThreeChild) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesNIFourChild) && SocialInsuranceXmlImport.isEqual(siLkk1, siLkk2, SocialInsuranceLkk::getLkkDuesNIFiveChild);
    }

    private static <T> boolean isEqual(T t1, T t2, GetBigDecimalFunction<T> f) {
        return SocialInsuranceXmlImport.isEqual(f.getBigDecimal(t1), f.getBigDecimal(t2));
    }

    private static boolean isEqual(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        return PBigDecimalMapper.isEqual((BigDecimal)bigDecimal1, (BigDecimal)bigDecimal2);
    }

    static SocialInsuranceTP createCopy(SocialInsuranceTP socialInsuranceTP) {
        SocialInsuranceTP copy = (SocialInsuranceTP)socialInsuranceTP.createNew();
        copy.setEffectiveFrom(socialInsuranceTP.getEffectiveFrom());
        copy.setEffectiveUntil(socialInsuranceTP.getEffectiveUntil());
        copy.setValidFrom(socialInsuranceTP.getValidFrom());
        copy.setValidUntil(socialInsuranceTP.getValidUntil());
        copy.setGlobal(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getGlobal()));
        copy.setLawAreaWest(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getLawAreaWest()));
        copy.setLawAreaEast(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getLawAreaEast()));
        copy.setLkk(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getLkk()));
        copy.makeReadOnly();
        return copy;
    }

    private static SocialInsuranceLkk createCopy(SocialInsuranceLkk siLkk) {
        SocialInsuranceLkk copy = new SocialInsuranceLkk(siLkk.getLkkDuesHIGeneral(), siLkk.getLkkDuesHIReduced(), siLkk.getLkkDuesNIChildless(), siLkk.getLkkDuesNIChildEducation(), siLkk.getLkkDuesNITwoChild(), siLkk.getLkkDuesNIThreeChild(), siLkk.getLkkDuesNIFourChild(), siLkk.getLkkDuesNIFiveChild());
        return copy;
    }

    private static SocialInsuranceLawArea createCopy(SocialInsuranceLawArea siLawArea) {
        SocialInsuranceLawArea copy = new SocialInsuranceLawArea(siLawArea.getBasicAmountForHealthAndNursingInsurance(), siLawArea.getBasicAmountForPensionersAndUnemploymentInsurance(), siLawArea.getMaximumAssessableEarningsForHealthAndNursingInsurance(), siLawArea.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance(), siLawArea.getMaximumAssessableEarningsForMinersPensionersInsurance(), siLawArea.getMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(), siLawArea.getMinimumCalculationBasisForContributionOfPensionersInsurance(), siLawArea.getCalculationBasisForContributionOfHealthAndNursingInsurance(), siLawArea.getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(), siLawArea.getCalculationBasisForContributionOfUnemploymentInsurance(), siLawArea.getGeneralMarginalValueOfLowIncomeEarners(), siLawArea.getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(), siLawArea.getAnnualEarningsLimitHI());
        return copy;
    }

    private static SocialInsuranceGlobal createCopy(SocialInsuranceGlobal siGlobal) {
        SocialInsuranceGlobal copy = new SocialInsuranceGlobal(siGlobal.getAverageGeneralContributionRateForAllowanceInPHI(), siGlobal.getEEaverageGeneralContributionRateForAllowanceInPHI(), siGlobal.getERaverageGeneralContributionRateForAllowanceInPHI(), siGlobal.getAverageReducedContributionRateForAllowanceInPHI(), siGlobal.getEEaverageReducedContributionRateForAllowanceInPHI(), siGlobal.getERaverageReducedContributionRateForAllowanceInPHI(), siGlobal.getTotalContributionRateForPensionersInsurance(), siGlobal.getEEtotalContributionRateForPI(), siGlobal.getERtotalContributionRateForPI(), siGlobal.getTotalContributionRateForUnemploymentInsurance(), siGlobal.getEEtotalContributionRateForUI(), siGlobal.getERtotalContributionRateForUI(), siGlobal.getTotalContributionRateForNursingInsurance(), siGlobal.getEEtotalContributionRateForNI(), siGlobal.getERtotalContributionRateForNI(), siGlobal.getTotalContributionRateForMinersPensionersInsurance(), siGlobal.getEEtotalContributionRateForMinersPI(), siGlobal.getERtotalContributionRateForMinersPI(), siGlobal.getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners(), siGlobal.getEEblanketContributionRateForHIConcerningLowIncomeEarners(), siGlobal.getERblanketContributionRateForHIConcerningLowIncomeEarners(), siGlobal.getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners(), siGlobal.getEEblanketContributionRateForPIConcerningLowIncomeEarners(), siGlobal.getERblanketContributionRateForPIConcerningLowIncomeEarners(), siGlobal.getInsignificantMaximumLimitForLowIncomeEarnersAmount(), siGlobal.getMinimumCalculationBasisForLowIncomeEarnersAmount(), siGlobal.getFactorForFormula(), siGlobal.getLowWageFrom(), siGlobal.getLowWageUntil(), siGlobal.getSurchargeNI(), siGlobal.getEESurchargeNI(), siGlobal.getERSurchargeNI(), siGlobal.getSurchargeHI(), siGlobal.getEESurchargeHI(), siGlobal.getERSurchargeHI(), siGlobal.getSurchargeUI(), siGlobal.getEESurchargeUI(), siGlobal.getERSurchargeUI(), siGlobal.getSurchargePI(), siGlobal.getEESurchargePI(), siGlobal.getERSurchargePI(), siGlobal.getPercentInsolvencyAssessment(), siGlobal.getAdditionalDues(), siGlobal.getDebtLimit(), siGlobal.getAdditionalDuesHI(), siGlobal.getAdditionalDuesKVDR(), siGlobal.getAdditionalDuesHIEE(), siGlobal.getAdditionalDuesHIER(), siGlobal.getFactorForFormulaTransition(), siGlobal.getNursingInsuranceReduction(), siGlobal.getEEratePensionInsurance(), siGlobal.getLumpsumMinijob());
        return copy;
    }

    static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s);
    }

    static SocialInsuranceTP createSocialInsuranceTP(Date minValidFrom) {
        SocialInsuranceTP socialInsuranceTP = new SocialInsuranceTP();
        socialInsuranceTP.setValidFrom(minValidFrom);
        return socialInsuranceTP;
    }

    static List<SocialInsuranceTP> getHistoryFrom(SocialInsurance socialInsurance, Date validDate) {
        ArrayList<SocialInsuranceTP> result = new ArrayList<SocialInsuranceTP>();
        for (SocialInsuranceTP socialInsuranceTP : socialInsurance.getHistory().getAll()) {
            if (!DateHelper.beforeOrEqual((Date)validDate, (Date)socialInsuranceTP.getValidUntil())) continue;
            result.add(socialInsuranceTP);
        }
        result.sort((siTP1, siTP2) -> DateHelper.compare((Date)siTP1.getValidFrom(), (Date)siTP2.getValidFrom()));
        return result;
    }

    static void calculateFields(SocialInsuranceLawArea siWest, SocialInsuranceLawArea siEast) {
        siWest.setMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
        siEast.setMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
        siWest.setMinimumCalculationBasisForContributionOfPensionersInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_EIGHT));
        siEast.setMinimumCalculationBasisForContributionOfPensionersInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_EIGHT));
        siWest.setCalculationBasisForContributionOfHealthAndNursingInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
        siEast.setCalculationBasisForContributionOfHealthAndNursingInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
        siWest.setCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
        siEast.setCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
        siWest.setCalculationBasisForContributionOfUnemploymentInsurance(siWest.getBasicAmountForHealthAndNursingInsurance());
        siEast.setCalculationBasisForContributionOfUnemploymentInsurance(siEast.getBasicAmountForHealthAndNursingInsurance());
        siWest.setMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_ZEROFIVE));
        siEast.setMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_ZEROFIVE));
    }

    @FunctionalInterface
    private static interface GetBigDecimalFunction<T> {
        public BigDecimal getBigDecimal(T var1);
    }
}

