/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.library.addressfield;

import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.costunit.CostUnit;
import com.varial.personnel.domain.designationtype.designation.Designation;
import com.varial.personnel.domain.designationtype.personincharge.PersonInCharge;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.state.StateTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldBean;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.isoft.domain.reports.library.addressfield.AddressFieldCreatorIndividual;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddressFieldCreator {
    private final Date mEffectiveDate = VDate.getDateMax();
    private final Date mMasterValidDate;
    private final Date mEmploymentValidDate = DateHelper.today();
    private final Date mValidDate = DateHelper.today();
    private String mOidPCompanyForSettings;
    private String mOidPCompanyForFoundations;
    private final Map<String, CostCenter> mCostCenterMap = new HashMap<String, CostCenter>();
    private final Map<String, CostUnit> mCostUnitMap = new HashMap<String, CostUnit>();
    private final Map<String, PersonInCharge> mPersonInChargeMap = new HashMap<String, PersonInCharge>();
    private final Map<String, Designation> mDesignationMap = new HashMap<String, Designation>();

    protected AddressFieldCreator(Date masterValidDate) {
        this.mMasterValidDate = masterValidDate;
    }

    protected AddressFieldCreator() {
        this(DateHelper.today());
    }

    protected AddressFieldCreator(String oidPCompanyForSettings, String oidPCompanyForFoundations) {
        this();
        this.mOidPCompanyForSettings = oidPCompanyForSettings;
        this.mOidPCompanyForFoundations = oidPCompanyForFoundations;
    }

    public AddressFieldBean createAddressFieldBean(Employee employee, DocumentType documentType) {
        return this.createAddressFieldBean(employee, this.mEmploymentValidDate, documentType);
    }

    public AddressFieldBean createAddressFieldBean(Employee employee, Date dateZusatzzeile, DocumentType documentType) {
        AddressFieldBean addressFieldBean = new AddressFieldBean();
        addressFieldBean = new AddressFieldBean();
        this.fillAbsender(addressFieldBean, employee);
        this.fillZusatz(addressFieldBean, employee, dateZusatzzeile);
        boolean hatEmpfaenger = AddressFieldCreatorIndividual.createEmpfaengerIndividual(addressFieldBean, employee, documentType);
        if (!hatEmpfaenger) {
            this.fillEmpfaenger(addressFieldBean, employee);
        }
        return addressFieldBean;
    }

    protected void fillAbsender(AddressFieldBean addressFieldBean, Employee employee) {
        addressFieldBean.addAbsenderZeile(new String[]{""});
        CompanySettings companySettings = this.getCompanySettings(employee);
        Employment employment = this.getEmployment(employee);
        Plant plant = employment.getPlant();
        if (companySettings != null && companySettings.getPrintPlant() && plant != null) {
            PlantPlace plantPlace = employment.getPlantPlace();
            if (plantPlace != null) {
                PlantPlaceTP plantPlaceTP = (PlantPlaceTP)this.getItem(plantPlace.getHistory());
                if (plantPlaceTP != null && (plantPlaceTP.getClosingDate() == null || DateHelper.before((Date)this.mValidDate, (Date)plantPlaceTP.getClosingDate()))) {
                    this.addAbsenderZeilen(addressFieldBean, plantPlaceTP, plant);
                } else {
                    this.addAbsenderZeilen(addressFieldBean, plant);
                }
            } else {
                this.addAbsenderZeilen(addressFieldBean, plant);
            }
        } else {
            this.addAbsenderZeilen(addressFieldBean, this.getPCompanyForFoundations(employee));
        }
    }

    protected void fillZusatz(AddressFieldBean addressFieldBean, Employee employee, Date dateZusatzzeile) {
        StringBuilder result = new StringBuilder();
        CompanySettings companySettings = this.getCompanySettings(employee);
        if (companySettings != null) {
            ArrayList<CallSite> anschriftenZusaetze = new ArrayList<CallSite>();
            if (companySettings.getPersonnelnumberOnSoE()) {
                String personnelNumber = (String)(this.getPCompanyForSettings(employee).getIsSuperiorForConsolidation() ? employee.getPCompany().getPCompanyKey() + "/" : "") + employee.getPersonnelnumber();
                anschriftenZusaetze.add((CallSite)((Object)("PNR " + personnelNumber)));
            }
            Employment employment = this.getEmployment(employee, dateZusatzzeile);
            if (companySettings.getEECircleOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("MAK " + this.getKey(employment.getEmployeeCircle()))));
            }
            if (companySettings.getEEGroupOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("MAG " + this.getKey(employment.getEmployeeGroup()))));
            }
            if (companySettings.getEmployeeFunctionOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("MAF " + this.getKey(employment.getEmployeeFunction()))));
            }
            if (companySettings.getCostCenterOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("KST " + this.getKey(employment.getCostCenter()))));
            }
            if (companySettings.getCostUnitOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("KTR " + this.getKey(employment.getCostUnit()))));
            }
            if (companySettings.getOrgUnitOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("ORG " + this.getKey(employment.getOrgUnit()))));
            }
            if (companySettings.getDepartmentOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("ABT " + this.getKey(employment.getDepartment()))));
            }
            if (companySettings.getFirstPersonInChargeOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("SB1 " + this.getKey(employment.getPersonInCharge1()))));
            }
            if (companySettings.getSecondPersonInChargeOnSoE()) {
                anschriftenZusaetze.add((CallSite)((Object)("SB2 " + this.getKey(employment.getPersonInCharge2()))));
            }
            for (int i = 0; i < Math.min(anschriftenZusaetze.size(), 3); ++i) {
                if (i != 0) {
                    result.append(" / ");
                }
                result.append((String)anschriftenZusaetze.get(i));
            }
        }
        addressFieldBean.setZusatz(result.toString());
    }

    protected void fillEmpfaenger(AddressFieldBean addressFieldBean, Employee employee) {
        Master master = this.getMaster(employee);
        addressFieldBean.addEmpfaengerZeile(new String[]{master.getFormOfAddress(), master.getNameAffix()});
        String title = master.getTitle();
        String name = ReportHelper.concatWithSpace((String[])new String[]{master.getFirstname(), master.getNamePrefix(), master.getSurname()});
        if (title == null || title.length() < 11) {
            addressFieldBean.addEmpfaengerZeile(new String[]{title, name});
        } else {
            addressFieldBean.addEmpfaengerZeile(new String[]{title});
            addressFieldBean.addEmpfaengerZeile(new String[]{name});
        }
        this.fillEmpfaengeradresse(addressFieldBean, master);
    }

    protected void fillEmpfaengeradresse(AddressFieldBean addressFieldBean, Master master) {
        StateTP stateTP;
        if (!StringMapper.isNullString((String)master.getAddressAddendum())) {
            addressFieldBean.addEmpfaengerZeile(new String[]{master.getAddressAddendum()});
        }
        addressFieldBean.addEmpfaengerZeile(new String[]{master.getStreet(), master.getStreetNumber()});
        String domicile = StringMapper.isNullString((String)master.getDomicile()) ? "" : master.getDomicile();
        String land = "";
        if (master.getState() != null && (stateTP = (StateTP)this.getItem(master.getState().getHistory())) != null && !StringMapper.equal((String)stateTP.getStateTag(), (String)"D")) {
            land = stateTP.getLongDescription();
        }
        if (land.equals("")) {
            addressFieldBean.addEmpfaengerZeile(new String[]{master.getPostalCode(), domicile});
        } else {
            addressFieldBean.addEmpfaengerZeile(new String[]{master.getPostalCode(), domicile.toUpperCase()});
            addressFieldBean.addEmpfaengerZeile(new String[]{land.toUpperCase()});
        }
    }

    private void addAbsenderZeilen(AddressFieldBean addressFieldBean, PCompany pCompany) {
        this.addAbsenderZeilen(addressFieldBean, pCompany.getPCompanyKey(), this.getFoundations(pCompany));
    }

    private void addAbsenderZeilen(AddressFieldBean addressFieldBean, Plant plant) {
        this.addAbsenderZeilen(addressFieldBean, plant.getPlantKey(), this.getFoundations(plant));
    }

    private void addAbsenderZeilen(AddressFieldBean addressFieldBean, PlantPlaceTP plantPlaceTP, Plant plant) {
        Foundations foundations = this.getFoundations(plant);
        addressFieldBean.addAbsenderZeile(new String[]{plant.getPlantKey() + " / " + (foundations == null ? "" : foundations.getShortDescription())});
        PostalAddress postalAddress = plantPlaceTP.getAddress();
        if (postalAddress != null) {
            addressFieldBean.addAbsenderZeile(new String[]{postalAddress.getStreet() + ", " + postalAddress.getPostalCode() + " " + postalAddress.getCity()});
        }
    }

    private void addAbsenderZeilen(AddressFieldBean addressFieldBean, String key, Foundations foundations) {
        if (foundations == null) {
            addressFieldBean.addAbsenderZeile(new String[]{key});
        } else {
            addressFieldBean.addAbsenderZeile(new String[]{key + " / " + foundations.getShortDescription()});
            this.addAbsenderZeile(addressFieldBean, foundations);
        }
    }

    protected void addAbsenderZeile(AddressFieldBean addressFieldBean, Foundations foundations) {
        if (foundations == null) {
            return;
        }
        CompanyPlantPostalAddress postalAddress = foundations.getPostalAddress();
        if (postalAddress != null) {
            addressFieldBean.addAbsenderZeile(new String[]{postalAddress.getStreet() + ", " + postalAddress.getPostalCode() + " " + postalAddress.getCity()});
        }
    }

    private String getKey(CostCenter costCenter) {
        return AddressFieldCreator.getKey(costCenter, this.mCostCenterMap, CostCenter::getCostCenter);
    }

    private String getKey(CostUnit costUnit) {
        return AddressFieldCreator.getKey(costUnit, this.mCostUnitMap, CostUnit::getCostUnit);
    }

    private String getKey(PersonInCharge personInCharge) {
        return AddressFieldCreator.getKey(personInCharge, this.mPersonInChargeMap, PersonInCharge::getPersonInCharge);
    }

    private String getKey(Designation designation) {
        return AddressFieldCreator.getKey(designation, this.mDesignationMap, Designation::getDesignation);
    }

    private static <T extends PersistentObject> String getKey(T persistentObject, Map<String, T> map, GetKeyFunction<T> getKeyFunction) {
        if (persistentObject == null) {
            return "";
        }
        PersistentObject objectInMap = (PersistentObject)map.putIfAbsent(persistentObject.getObjectid(), persistentObject);
        return getKeyFunction.getKey((PersistentObject)(objectInMap != null ? objectInMap : persistentObject));
    }

    private <T extends PersonnelTimedPersistenceObject> T getItem(PersonnelHistory<T> history, Date validDate) {
        List items;
        PersonnelTimedPersistenceObject item = history.getItemOrNull(this.mEffectiveDate, validDate);
        if (item == null && !(items = history.getItems(this.mEffectiveDate)).isEmpty()) {
            item = (PersonnelTimedPersistenceObject)items.get(0);
        }
        return (T)item;
    }

    protected <T extends PersonnelTimedPersistenceObject> T getItem(PersonnelHistory<T> history) {
        return this.getItem(history, this.mValidDate);
    }

    protected Employment getEmployment(Employee employee, Date date) {
        return this.getItem(employee.getEmploymentHistory(), date);
    }

    protected Employment getEmployment(Employee employee) {
        return this.getEmployment(employee, this.mEmploymentValidDate);
    }

    public Master getMaster(Employee employee) {
        return this.getItem(employee.getMasterHistory(), this.mMasterValidDate);
    }

    private static PCompany getPCompany(String oidPCompany, Employee employee) {
        return StringMapper.isNullString((String)oidPCompany) ? employee.getPCompany() : PCompanyPersistencyManager.getPCompany((String)oidPCompany);
    }

    private PCompany getPCompanyForSettings(Employee employee) {
        return AddressFieldCreator.getPCompany(this.mOidPCompanyForSettings, employee);
    }

    protected PCompany getPCompanyForFoundations(Employee employee) {
        return AddressFieldCreator.getPCompany(this.mOidPCompanyForFoundations, employee);
    }

    private CompanySettings getCompanySettings(Employee employee) {
        return (CompanySettings)((Object)this.getItem(this.getPCompanyForSettings(employee).getCompanySettingsHistory()));
    }

    protected Foundations getFoundations(PCompany pCompany) {
        CompanyFoundations companyFoundations = (CompanyFoundations)this.getItem(pCompany.getCompanyFoundationsHistory());
        return companyFoundations == null ? null : companyFoundations.getFoundations();
    }

    private Foundations getFoundations(Plant plant) {
        PlantFoundations plantFoundations = (PlantFoundations)this.getItem(plant.getPlantFoundationsHistory());
        return plantFoundations == null ? null : plantFoundations.getFoundations();
    }

    public static enum DocumentType {
        StatementOfEarnings,
        DeuvAnnouncementToSi,
        WageTaxCertificate,
        ZveAnnouncement;

    }

    @FunctionalInterface
    private static interface GetKeyFunction<T extends PersistentObject> {
        public String getKey(T var1);
    }
}

