/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.deuvannouncementtosiprotocol;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.RecipientAddress;
import com.varial.personnel.domain.deuv.deuvaccount.RecipientAddressFactory;
import com.varial.personnel.domain.deuv.deuvdbeu.DEUVDbeu;
import com.varial.personnel.domain.deuv.deuvdbgb.DEUVDbgb;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdsfz.DEUVDsfz;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsme;
import com.varial.personnel.domain.deuv.mapper.ReasonOfDeliveryStringMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.mapper.DuesGroupStringMapper;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.mapper.SexEnumMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.persongroup.PersonGroup;
import com.varial.personnel.domain.global.persongroup.PersonGroupPersistencyManager;
import com.varial.personnel.domain.global.state.State;
import com.varial.personnel.domain.global.state.StateTP;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.deuvannouncementtosiprotocol.DeuvAnnouncementToSiReportSortGenerator;
import com.varial.personnel.domain.reports.deuvannouncementtosiprotocol.DeuvAnnouncementToSiSort;
import com.varial.personnel.domain.reports.deuvannouncementtosiprotocol.DeuvEUCitizenBean;
import com.varial.personnel.domain.reports.deuvannouncementtosiprotocol.DeuvNoInsuranceNumberBean;
import com.varial.personnel.domain.reports.library.ReportsSortComparator;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldBean;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldCreator;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsReport;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.PutDataException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class DeuvAnnouncementToSiReportDataSource
implements JRDataSource {
    private final NumberFormat amountFormat = this.config(NumberFormat.getCurrencyInstance(Locale.GERMANY), 6, 0);
    private static final String J = "J";
    private String mVersicherungsNr = "";
    private String mPersonalNr = "";
    private String mMidijobKennzeichen = "";
    private String mMidijobKennzErlaeuterung = "";
    private String mMidijobEntgelt = "";
    private String mEntgeltRentenberechnung = "";
    private String mBeschaeftigungVon = "";
    private String mBeschaeftigungBis = "";
    private String mBetriebsNrAG = "";
    private String mPersonengruppe = "";
    private String mMehrfachbeschaeftigung = "";
    private String mOst = "";
    private String mWest = "";
    private String mBeitragsgruppeKV = "";
    private String mBeitragsgruppeRV = "";
    private String mBeitragsgruppeALV = "";
    private String mBeitragsgruppePV = "";
    private String mAngabeTaetigkeit = "";
    private String mSchluesselStaatsangehoerigkeit = "";
    private String mEntgelt = "";
    private String mStatuskennzeichen = "";
    private String mStatuskennzeichenErlaeuterung = "";
    private String mPGSText = "";
    private String mStaatsangehoeriguText = "";
    private String mTaetigkeituText = "";
    private String mKvBGuText = "";
    private String mRvBGuText = "";
    private String mAvBGuText = "";
    private String mPvBGuText = "";
    private String mBetriebsNrKrk = "";
    private String mDatum = "";
    private String mNameAG = "";
    private String mStrasseAG = "";
    private String mPlzAG = "";
    private String mOrtAG = "";
    private String mAbgabeGrundText = "";
    private String mGeburtsdatum = "";
    private String mStornierungText = "";
    private DeuvNoInsuranceNumberBean mNoInsuranceNumberBean;
    private DeuvEUCitizenBean mEUCitizenBean;
    DEUVDsme mDSME = null;
    DEUVDsfz mDsfz = null;
    DEUVDbme mDBME = null;
    DEUVDbgb mDBGB = null;
    DEUVDbeu mDBEU = null;
    private Iterator<DEUVAccount> mDEUVAccountsIt;
    private DEUVAccount mDEUVAccount;
    private final boolean mReRunProtocol;
    private final StatementOfEarningsReport.FunctionEnum mFunction;
    private final RecipientAddressFactory mRecipientAddressFactory;
    private final AddressFieldCreator mAddressFieldCreator;
    private Map<String, PersonGroup> mPersongroups;
    private final ProgressBarUpdater mProgressBar;

    private NumberFormat config(NumberFormat result, int digits, int scale) {
        result.setMinimumFractionDigits(scale);
        result.setMaximumFractionDigits(scale);
        result.setMinimumIntegerDigits(digits);
        result.setMaximumIntegerDigits(digits);
        return result;
    }

    protected DeuvAnnouncementToSiReportDataSource(ISpecialAccessPersistencyContext specialAccessPersistencyContext, List<DEUVAccount> deuvAccountsLi, ReportSortStruct[] sorts, boolean reRunProtocol, ProgressBarUpdater progressBar, StatementOfEarningsReport.FunctionEnum function) throws BusinessDomainException, PutDataException {
        this.mFunction = function;
        this.mProgressBar = progressBar;
        this.mRecipientAddressFactory = new RecipientAddressFactory();
        this.mAddressFieldCreator = AddressFieldHelper.getInstance().createAddressFieldCreator();
        this.mReRunProtocol = reRunProtocol;
        this.mDatum = DateMapper.toDDMMYYYYPointSeparationString((Date)new Date());
        if (deuvAccountsLi == null || deuvAccountsLi.isEmpty()) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        if (sorts != null && sorts.length > 0) {
            DeuvAnnouncementToSiReportSortGenerator dEUVAnnouncementToSiReportSortGenerator = new DeuvAnnouncementToSiReportSortGenerator();
            List dEUVAnnouncementToSiSortLi = dEUVAnnouncementToSiReportSortGenerator.getReportSort(deuvAccountsLi.iterator());
            Collections.sort(dEUVAnnouncementToSiSortLi, new ReportsSortComparator(sorts));
            if (dEUVAnnouncementToSiSortLi == null || dEUVAnnouncementToSiSortLi.isEmpty()) {
                throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
            }
            Iterator dEUVAnnouncementToSiSortIt = dEUVAnnouncementToSiSortLi.iterator();
            ArrayList<DEUVAccount> deuvAccountsLocalLi = new ArrayList<DEUVAccount>();
            while (dEUVAnnouncementToSiSortIt.hasNext()) {
                DeuvAnnouncementToSiSort dEUVAnnouncementToSiSort = (DeuvAnnouncementToSiSort)dEUVAnnouncementToSiSortIt.next();
                deuvAccountsLocalLi.add(dEUVAnnouncementToSiSort.getDEUVAccount());
            }
            this.mDEUVAccountsIt = deuvAccountsLocalLi.iterator();
        } else {
            this.mDEUVAccountsIt = deuvAccountsLi.iterator();
        }
    }

    public boolean next() throws JRException {
        this.resetReportComponents();
        try {
            while (this.mDEUVAccountsIt.hasNext()) {
                this.mDEUVAccount = this.mDEUVAccountsIt.next();
                this.mProgressBar.update();
                if (this.mDEUVAccount == null) continue;
                this.setDEUVAccountValuesForReport();
                if (!this.mReRunProtocol || this.mFunction == StatementOfEarningsReport.FunctionEnum.SELFSERVICE) {
                    if (this.mFunction == StatementOfEarningsReport.FunctionEnum.SELFSERVICE) {
                        this.mDEUVAccount.setSelfservice(true);
                    }
                    if (!this.mReRunProtocol) {
                        this.mDEUVAccount.setEeCertificate(true);
                    }
                    this.mDEUVAccount.makeSaveable();
                }
                return true;
            }
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        this.mDEUVAccount = null;
        return false;
    }

    private void resetReportComponents() {
        this.mDSME = null;
        this.mDBME = null;
        this.mDBGB = null;
        this.mDBEU = null;
        this.mNoInsuranceNumberBean = null;
        this.mEUCitizenBean = null;
        this.mStornierungText = "";
        this.mVersicherungsNr = "";
        this.mPersonalNr = "";
        this.mMidijobEntgelt = "";
        this.mMidijobKennzeichen = "";
        this.mMidijobKennzErlaeuterung = "";
        this.mEntgeltRentenberechnung = null;
        this.mBeschaeftigungVon = "";
        this.mBeschaeftigungBis = "";
        this.mBetriebsNrAG = "";
        this.mPersonengruppe = "";
        this.mMehrfachbeschaeftigung = "";
        this.mOst = "";
        this.mWest = "";
        this.mBeitragsgruppeKV = "";
        this.mBeitragsgruppeRV = "";
        this.mBeitragsgruppeALV = "";
        this.mBeitragsgruppePV = "";
        this.mAngabeTaetigkeit = "";
        this.mSchluesselStaatsangehoerigkeit = "";
        this.mEntgelt = "";
        this.mStatuskennzeichen = "";
        this.mStatuskennzeichenErlaeuterung = "";
        this.mPGSText = "";
        this.mStaatsangehoeriguText = "";
        this.mTaetigkeituText = "";
        this.mKvBGuText = "";
        this.mRvBGuText = "";
        this.mAvBGuText = "";
        this.mPvBGuText = "";
        this.mBetriebsNrKrk = "";
        this.mNameAG = "";
        this.mStrasseAG = "";
        this.mPlzAG = "";
        this.mOrtAG = "";
        this.mAbgabeGrundText = "";
        this.mGeburtsdatum = "";
    }

    private void setDEUVAccountValuesForReport() throws BusinessDomainException {
        this.mDSME = this.mDEUVAccount.getDEUVDsme();
        this.mDsfz = this.mDEUVAccount.getDeuvDsfz();
        if (this.mDSME != null) {
            this.mDBME = this.mDSME.getDEUVDbme();
            if (J.equals(this.mDSME.getMmGeburtsangaben())) {
                this.mDBGB = this.mDSME.getDEUVDbgb();
                if (J.equals(this.mDSME.getMmEuDaten())) {
                    this.mDBEU = this.mDSME.getDEUVDbeu();
                    if (this.mDBEU != null) {
                        this.mEUCitizenBean = this.getEUCitizenBean();
                    }
                }
            }
            this.setReportValuesDsme();
        }
        if (this.mDsfz != null) {
            this.setReportValuesDsfz();
        }
        if (this.mDBGB != null) {
            this.mNoInsuranceNumberBean = this.getNoInsuranceNumberBean();
        }
    }

    private void setReportValuesDsme() throws BusinessDomainException {
        this.setAbgabeGrundText(this.mDSME.getAbgabegrund());
        this.mVersicherungsNr = this.mDSME.getVersicherungsnr();
        this.mBetriebsNrKrk = this.mDSME.getBbnrKrankenkasse();
        this.mBetriebsNrAG = this.mDSME.getBbnrVerursacher();
        if (this.mDSME.getPersonengruppe() > 0) {
            this.mPersonengruppe = Integer.toString(this.mDSME.getPersonengruppe());
            this.mPGSText = this.getPersonGroupString(this.mPersonengruppe);
        }
        this.mSchluesselStaatsangehoerigkeit = this.mDSME.getStaat();
        this.mStaatsangehoeriguText = this.mDSME.getStaat();
        if (this.mStaatsangehoeriguText != null && this.mStaatsangehoeriguText.length() == 3) {
            this.mStaatsangehoeriguText = this.getNationality(this.mStaatsangehoeriguText, this.mDEUVAccount.getEffectiveFrom(), this.getValidDate());
        }
        this.mStatuskennzeichen = this.mDSME.getStatuskennzeichen();
        this.mStatuskennzeichenErlaeuterung = this.getStatuskennzeichenString(this.mStatuskennzeichen);
        if (this.mDBME != null) {
            if (J.equals(this.mDBME.getStornokennzeichen())) {
                this.mStornierungText = "  Stornierung einer bereits abgegebenen Meldung.  Es wurde gemeldet:";
            }
            this.mBeschaeftigungVon = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mDBME.getBeginn());
            this.mBeschaeftigungBis = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mDBME.getEnde());
            this.mMehrfachbeschaeftigung = this.mDBME.getMehrfachbesch();
            this.mMidijobKennzeichen = this.mDBME.getGleitzone();
            this.mMidijobEntgelt = this.mDEUVAccount.isAfterStartMidijob() ? "Kennzeichen \u00dcbergangsbereich" : "Kennzeichen Gleitzone";
            this.mMidijobKennzErlaeuterung = this.getMidijobIndicatorDesc(this.mMidijobKennzeichen);
            if (this.mDBME.getRechtskreis() != null) {
                this.mOst = StringMapper.equal((String)this.mDBME.getRechtskreis(), (String)"O") ? "X" : "";
                String string = this.mWest = StringMapper.equal((String)this.mDBME.getRechtskreis(), (String)"W") ? "X" : "";
            }
            if (this.mDBME.getBeitragsgruppe() != null && this.mDBME.getBeitragsgruppe().length() == 4) {
                this.mBeitragsgruppeKV = this.mDBME.getBeitragsgruppe().substring(0, 1);
                this.mBeitragsgruppeRV = this.mDBME.getBeitragsgruppe().substring(1, 2);
                this.mBeitragsgruppeALV = this.mDBME.getBeitragsgruppe().substring(2, 3);
                this.mBeitragsgruppePV = this.mDBME.getBeitragsgruppe().substring(3, 4);
                this.mKvBGuText = this.mBeitragsgruppeKV + "    " + DuesGroupStringMapper.getDuesGroupHIText((int)Integer.parseInt(this.mBeitragsgruppeKV));
                this.mRvBGuText = this.mBeitragsgruppeRV + "    " + DuesGroupStringMapper.getDuesGroupPIText((int)Integer.parseInt(this.mBeitragsgruppeRV));
                this.mAvBGuText = this.mBeitragsgruppeALV + "    " + DuesGroupStringMapper.getDuesGroupUIText((int)Integer.parseInt(this.mBeitragsgruppeALV));
                this.mPvBGuText = this.mBeitragsgruppePV + "    " + DuesGroupStringMapper.getDuesGroupNIText((int)Integer.parseInt(this.mBeitragsgruppePV));
            }
            this.mAngabeTaetigkeit = this.mDBME.getTaetigkeitssl();
            if (this.mAngabeTaetigkeit != null) {
                if (this.mAngabeTaetigkeit.length() == 9) {
                    this.mTaetigkeituText = this.mAngabeTaetigkeit.substring(0, 5) + " " + this.mAngabeTaetigkeit.substring(5);
                } else if (this.mAngabeTaetigkeit.length() == 5) {
                    this.mTaetigkeituText = this.mAngabeTaetigkeit.substring(0, 3) + " " + this.mAngabeTaetigkeit.substring(3);
                }
            }
            if (this.mDBME.getEntgelt() != null) {
                this.mEntgelt = this.amountFormat.format(this.mDBME.getEntgelt());
            }
            if (this.mDBME.getEntgeltRb() != null) {
                this.mEntgeltRentenberechnung = this.amountFormat.format(this.mDBME.getEntgeltRb());
            }
        }
        this.setReportValues();
    }

    private void setReportValuesDsfz() throws BusinessDomainException {
        this.mDBGB = this.mDsfz.getDeuvDbgb();
        this.setAbgabeGrundText(String.valueOf(this.mDsfz.getGd()));
        this.mVersicherungsNr = this.mDsfz.getVsnr();
        this.mBetriebsNrKrk = this.mDsfz.getEpnr();
        this.mBetriebsNrAG = this.mDsfz.getBbnrvu();
        if (J.equals(this.mDsfz.getKennzst())) {
            this.mStornierungText = "  Stornierung einer bereits abgegebenen Meldung.  Es wurde gemeldet:";
        }
        this.mBeschaeftigungVon = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mDsfz.getBe());
        this.mBeschaeftigungBis = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mDsfz.getEe());
        this.setReportValues();
    }

    private void setReportValues() throws BusinessDomainException {
        Master master = this.getEmployee().getMaster(VDate.getDateMax(), VDate.getDateMax());
        this.mGeburtsdatum = DateMapper.toDDMMYYYYPointSeparationString((Date)master.getDateOfBirth());
        this.mPersonalNr = this.getEmployee().getIDString();
        CompanySettings companySettings = this.getEmployee().getPCompany().getCompanySettings(VDate.getDateMax(), this.getValidDate());
        if (companySettings.getUsePlants() && companySettings.getPrintPlant()) {
            Plant plant = this.getEmployee().getAppurtenantPlant(VDate.getDateMax(), this.getValidDate());
            if (plant == null) {
                throw EmployeeExceptionMapper.makeAssignmentMissingDomainException("Pers.-Nr. " + this.getEmployee().getPersonnelnumber() + ", " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.getValidDate()) + ": Zuordnung einer Betriebsst\u00e4tte");
            }
            Foundations plantfoundations = plant.getPlantFoundations(VDate.getDateMax(), this.getValidDate()).getFoundations();
            PlantPlace pp = this.getEmployee().getEmployment(VDate.getDateMax(), this.getValidDate()).getPlantPlace();
            if (pp != null) {
                PostalAddress postAdr = pp.getCurrentPlantPlaceTP().getAddress();
                if (postAdr != null) {
                    this.mStrasseAG = postAdr.getStreet();
                    this.mPlzAG = postAdr.getPostalCode();
                    this.mOrtAG = postAdr.getCity();
                }
            } else {
                CompanyPlantPostalAddress adress = plantfoundations.getPostalAddress();
                this.mStrasseAG = adress.getStreet();
                this.mPlzAG = adress.getPostalCode();
                this.mOrtAG = adress.getCity();
            }
            this.mNameAG = plantfoundations.getLongDescription();
        } else {
            Foundations companyFoundations = this.getEmployee().getPCompany().getCompanyFoundations(VDate.getDateMax(), this.getValidDate()).getFoundations();
            this.mNameAG = companyFoundations.getLongDescription();
            CompanyPlantPostalAddress adress = companyFoundations.getPostalAddress();
            this.mStrasseAG = adress.getStreet();
            this.mPlzAG = adress.getPostalCode();
            this.mOrtAG = adress.getCity();
        }
    }

    private String getNationality(String stateKey, Date effectiveDate, Date validDtate) throws BusinessDomainException {
        State state;
        if (StringMapper.equal((String)stateKey, (String)"000")) {
            return "deutsch";
        }
        String nationality = "";
        Insurance insurance = (Insurance)this.getEmployee().getInsuranceHistory().getItemOrNull(effectiveDate, validDtate);
        if (insurance != null && stateKey.equals((state = insurance.getNationality()).getState())) {
            StateTP stateTP = state.getStateTP(effectiveDate, validDtate);
            nationality = stateTP.getNationality();
        }
        return nationality;
    }

    private String getStateOfBirthDesc(String stateKey, Date effectiveDate, Date validDtate) throws BusinessDomainException {
        State state;
        String stateDesc = "";
        if (StringMapper.isNullString((String)stateKey)) {
            return stateDesc;
        }
        Insurance insurance = (Insurance)this.getEmployee().getInsuranceHistory().getItemOrNull(effectiveDate, validDtate);
        if (insurance != null && (state = insurance.getEuStateOfBirth()) != null && stateKey.equals(state.getState())) {
            StateTP stateTP = state.getStateTP(effectiveDate, validDtate);
            stateDesc = stateTP.getLongDescription();
        }
        return stateDesc;
    }

    private DeuvEUCitizenBean getEUCitizenBean() throws BusinessDomainException {
        return new DeuvEUCitizenBean(this.mDBEU.getGebLand(), this.getStateOfBirthDesc(this.mDBEU.getGebLand(), this.mDEUVAccount.getEffectiveFrom(), this.getValidDate()), this.mDBEU.getEuVersicherungsNr());
    }

    private DeuvNoInsuranceNumberBean getNoInsuranceNumberBean() throws BusinessDomainException {
        return new DeuvNoInsuranceNumberBean(this.mDBGB.getGebname(), this.mDBGB.getGebort(), DateMapper.toDDMMYYYYPointSeparationString((Date)this.mDBGB.getGebdatum()), this.mDBGB.getGeschlecht(), SexEnumMapper.toLongString((SexEnum)SexEnumMapper.toSexEnum((String)this.mDBGB.getGeschlecht())), this.mDBGB.getGebland(), this.getStateOfBirthDesc(this.mDBGB.getGebland(), this.mDEUVAccount.getEffectiveFrom(), this.getValidDate()));
    }

    private String getPersonGroupString(String pgs) throws BusinessDomainException {
        if (this.mPersongroups == null) {
            this.mPersongroups = new HashMap<String, PersonGroup>();
            for (PersonGroup each : PersonGroupPersistencyManager.query(null, null)) {
                this.mPersongroups.put(String.valueOf(each.getPersonGroupKey()), each);
            }
        }
        if (this.mPersongroups.containsKey(pgs)) {
            return this.mPersongroups.get(pgs).getPersonGroupTP(VDate.getDateMax(), VDate.getDateMax()).getShortDescription();
        }
        return "";
    }

    private void setAbgabeGrundText(String abgabeGrund) {
        this.mAbgabeGrundText = "Abgabegrund " + abgabeGrund + "    " + ReasonOfDeliveryStringMapper.getReasonOfDeliverString((String)abgabeGrund);
    }

    private String getMidijobIndicatorDesc(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        if (this.mDEUVAccount.isAfterStartMidijob()) {
            switch (value) {
                case "0": {
                    return "kein Arbeitsentgelt innerhalb der Grenzen des \u00a7 20 Abs.2 SGB IV";
                }
                case "1": {
                    return "Arbeitsentgelt durchgehend innerhalb der Grenzen des \u00a7 20 Abs.2 SGB IV";
                }
                case "2": {
                    return "Arbeitsentgelt sowohl innerhalb als auch au\u00dferhalb innerhalb der Grenzen des \u00a7 20 Abs.2 SGB IV";
                }
            }
            return "";
        }
        switch (value) {
            case "0": {
                return "kein Arbeitsentgelt innerhalb der Gleitzone";
            }
            case "1": {
                return "Arbeitsentgelt durchgehend innerhalb der Gleitzone";
            }
            case "2": {
                return "Arbeitsentgelt sowohl innerhalb als auch au\u00dferhalb der Gleitzone";
            }
        }
        return "";
    }

    private String getStatuskennzeichenString(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        switch (value) {
            case "1": {
                return "Ehegatte/Lebenspartner/Verwandter oder Verschw\u00e4gerter des Arbeitgebers";
            }
            case "2": {
                return "gesch\u00e4ftsf\u00fchrender Gesellschafter einer GmbH";
            }
        }
        return "";
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        if (fieldName.equals("addressFieldBeans")) {
            return this.createAddressFieldBeans();
        }
        if (fieldName.equals("StrasseAG")) {
            return this.mStrasseAG;
        }
        if (fieldName.equals("PlzAG")) {
            return this.mPlzAG;
        }
        if (fieldName.equals("OrtAG")) {
            return this.mOrtAG;
        }
        if (fieldName.equals("VersicherungsNr")) {
            return this.mVersicherungsNr;
        }
        if (fieldName.equals("PersonalNr")) {
            return this.mPersonalNr;
        }
        if (fieldName.equals("Geburtsdatum")) {
            return this.mGeburtsdatum;
        }
        if (fieldName.equals("MidijobEntgelt")) {
            return this.mMidijobEntgelt;
        }
        if (fieldName.equals("MidijobKennzeichen")) {
            return this.mMidijobKennzeichen;
        }
        if (fieldName.equals("MidijobKennzeichenErlaeuterung")) {
            return this.mMidijobKennzErlaeuterung;
        }
        if (fieldName.equals("EntgeltRentenberechnung")) {
            return this.mEntgeltRentenberechnung;
        }
        if (fieldName.equals("BeschaeftigungVon")) {
            return this.mBeschaeftigungVon;
        }
        if (fieldName.equals("BeschaeftigungBis")) {
            return this.mBeschaeftigungBis;
        }
        if (fieldName.equals("BetriebsNrAG")) {
            return this.mBetriebsNrAG;
        }
        if (fieldName.equals("Personengruppe")) {
            return this.mPersonengruppe;
        }
        if (fieldName.equals("Mehrfachbeschaeftigung")) {
            return this.mMehrfachbeschaeftigung;
        }
        if (fieldName.equals("Ost")) {
            return this.mOst;
        }
        if (fieldName.equals("West")) {
            return this.mWest;
        }
        if (fieldName.equals("BeitragsgruppeKV")) {
            return this.mBeitragsgruppeKV;
        }
        if (fieldName.equals("BeitragsgruppeRV")) {
            return this.mBeitragsgruppeRV;
        }
        if (fieldName.equals("BeitragsgruppeALV")) {
            return this.mBeitragsgruppeALV;
        }
        if (fieldName.equals("BeitragsgruppePV")) {
            return this.mBeitragsgruppePV;
        }
        if (fieldName.equals("AngabeTaetigkeit")) {
            return this.mAngabeTaetigkeit;
        }
        if (fieldName.equals("SchluesselStaatsangehoerigkeit")) {
            return this.mSchluesselStaatsangehoerigkeit;
        }
        if (fieldName.equals("Entgelt")) {
            return this.mEntgelt;
        }
        if (fieldName.equals("Statuskennzeichen")) {
            return this.mStatuskennzeichen;
        }
        if (fieldName.equals("StatuskennzeichenErlaeuterung")) {
            return this.mStatuskennzeichenErlaeuterung;
        }
        if (fieldName.equals("PGSText")) {
            return this.mPGSText;
        }
        if (fieldName.equals("StaatsangehoeriguText")) {
            return this.mStaatsangehoeriguText;
        }
        if (fieldName.equals("TaetigkeituText")) {
            return this.mTaetigkeituText;
        }
        if (fieldName.equals("KvBGuText")) {
            return this.mKvBGuText;
        }
        if (fieldName.equals("RvBGuText")) {
            return this.mRvBGuText;
        }
        if (fieldName.equals("AvBGuText")) {
            return this.mAvBGuText;
        }
        if (fieldName.equals("PvBGuText")) {
            return this.mPvBGuText;
        }
        if (fieldName.equals("KrkName")) {
            return this.getKrkName();
        }
        if (fieldName.equals("KrkStrasse")) {
            return this.getKrkStrasse();
        }
        if (fieldName.equals("KrkPlz")) {
            return this.getKrkPlz();
        }
        if (fieldName.equals("KrkOrt")) {
            return this.getKrkOrt();
        }
        if (fieldName.equals("BetriebsNrKrk")) {
            return this.mBetriebsNrKrk;
        }
        if (fieldName.equals("Datum")) {
            return this.mDatum;
        }
        if (fieldName.equals("NameAG")) {
            return this.mNameAG;
        }
        if (fieldName.equals("AbgabeGrundText")) {
            return this.mAbgabeGrundText;
        }
        if (fieldName.equals("StornierungText")) {
            return this.mStornierungText;
        }
        if (fieldName.equals("NoInsuranceNumberBean")) {
            return this.mNoInsuranceNumberBean;
        }
        if (fieldName.equals("EUCitizenBean")) {
            return this.mEUCitizenBean;
        }
        if (fieldName.equals("archi_string")) {
            return this.getArchiString();
        }
        if (fieldName.equals("memberNumberPP")) {
            return this.mDSME == null ? "" : this.mDSME.getAzKrankenkasse();
        }
        if (fieldName.equals("captionMemberNumberPP")) {
            return this.isPensionPayingRecipient() ? "Mitglieds-Nr. BV" : "";
        }
        if (fieldName.equals("captionHealthfundOrRecipient")) {
            return "Name und Anschrift der " + (this.isPensionPayingRecipient() ? "Berufsst. Versorgungseinrichtung" : "Einzugsstelle (Gesch\u00e4ftsstelle)");
        }
        if (fieldName.equals("captionHealthfundOrRecipientNumber")) {
            return "Betriebs-Nr. der Einzugsstelle:";
        }
        return null;
    }

    private List<AddressFieldBean> createAddressFieldBeans() {
        return Arrays.asList(this.mAddressFieldCreator.createAddressFieldBean(this.getEmployee(), AddressFieldCreator.DocumentType.DeuvAnnouncementToSi));
    }

    private String getKrkName() {
        return this.getRecipientAddress().getName();
    }

    private String getKrkStrasse() {
        return this.getRecipientAddress().getStreet();
    }

    private String getKrkPlz() {
        return this.getRecipientAddress().getPostalCode();
    }

    private String getKrkOrt() {
        return this.getRecipientAddress().getCity();
    }

    private RecipientAddress getRecipientAddress() {
        return this.mRecipientAddressFactory.getRecipientAddress(this.mDEUVAccount);
    }

    private Date getValidDate() {
        return this.mDEUVAccount.getValidDate();
    }

    private Employee getEmployee() {
        return this.mDEUVAccount.getEmployee();
    }

    private boolean isPensionPayingRecipient() {
        return this.mDEUVAccount.isRecipientDasBv();
    }

    private String getArchiString() {
        ArchivingMetadata am = new ArchivingMetadata();
        am.setEmployee(this.getEmployee(), VDate.getDateMax(), this.getValidDate());
        am.setValidFrom(this.mBeschaeftigungVon);
        am.setValidUntil(this.mBeschaeftigungBis);
        am.setHealthFundNo(this.mBetriebsNrKrk);
        am.setStdCompanyNr(this.mBetriebsNrAG);
        am.setUserID(SessionContext.getInstance().getSession().getUserCode());
        am.setReportName("Meldebescheinigung zur Sozialversicherung");
        am.setAlwaysPrintValidUntil(true);
        return am.getArchiString();
    }
}

