/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pueg.advice;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTime;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.ChoiseOfDuesNIEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pueg.PuegComponents;
import com.varial.personnel.domain.pueg.puegaccount.IPuegAccountPersistencyManager;
import com.varial.personnel.domain.pueg.puegaccount.PuegAccount;
import com.varial.personnel.domain.pueg.puegaccount.PuegAccountComparator;
import com.varial.personnel.domain.pueg.puegaccount.PuegAdviceStateEnum;
import com.varial.personnel.domain.pueg.puegaccount.PuegReasonOfDeliveryEnum;
import com.varial.personnel.domain.pueg.pueganfrage.PuegAnfrage;
import com.varial.personnel.domain.pueg.puegkuendigung.PuegKuendigung;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.domain.reports.zahls.ZahlsProtocolReport;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class PuegAdvice {
    public static final Date DATE_START_PUEG = DateMapper.toDate((String)"2025-07-01");
    public static final Date DATE_MAX_HISTORIC = DateMapper.toDate((String)"2023-07-01");
    private static final String KUNDENNUMMER = "0321404469";
    public static final String noCancelationPhrase = "R\u00fcckstellung: ";
    private final PCompany mPCompany;
    private boolean mAffectedBySpecialAccess;
    private final Date mCreatedOnDate;
    private final DEUVSenderTP mDEUVSenderTP;
    private Insurance mInsurance = null;
    private Master mMaster = null;
    private Employment mEmployment = null;
    private Tax mTax = null;
    protected final Date maxDate = VDate.getDateMax();
    private final List<PuegAccount> mCreated;
    private final List<PuegAccount> mCreatedError;
    private List<PuegAccount> mNewAccounts;
    private PuegAccount[] mAnmeldungen;
    private PuegAccount[] mAbmeldungen;
    private PuegAccount[] mHistAnfragen;
    private PuegAccount[] mAnmeldungenAbgelehnt;
    private boolean mKuendigungCreated;
    private boolean mAnmeldungCreated;
    private Date mMaxReviewDate;
    private Date mStartDate;
    private Date mEndDate;
    private Date mDevDateOfBirth;
    private String mDevDateOfBirthAbw;
    private String mDevTin;
    private String mDevKundennummer;
    private String mDevZuordnungsmerkmal;
    private String mDevOrdnungsbegriff;
    private Date mFrom;
    private Date mUntil;
    private boolean mHistorical;
    private PuegAccount mLastDummy = null;

    public PuegAdvice(PCompany pCompany) throws BusinessDomainException {
        this.mPCompany = pCompany;
        this.mCreatedOnDate = VDate.getCurrentLocalizedDateAndTime();
        this.mDEUVSenderTP = DeuvHelper.getDeuvSender((PCompany)pCompany).getDEUVSenderTP(VDate.getDateMax(), this.mCreatedOnDate);
        this.mCreated = new ArrayList<PuegAccount>();
        this.mCreatedError = new ArrayList<PuegAccount>();
        this.mMaxReviewDate = DATE_START_PUEG;
    }

    public static final String formatTimestampForQuery(Date d) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(d);
    }

    public void checkAttributes(PuegAccount account) throws BusinessDomainException {
        if (StringMapper.isNullString((String)account.getIdnr())) {
            account.addError("Die Angabe einer Steuer-ID ist erforderlich!");
        }
        if (account.getGeburtsdatum() == null && StringMapper.isNullString((String)account.getGeburtsdatumabw())) {
            account.addError("Die Angabe des Geburtsdatums bzw. des melder. Geb.Dat. ist erforderlich!");
        }
    }

    public void create(Employee emp) throws BusinessDomainException {
        Date mDate4YearsBefore;
        Date maxRR = emp.getMinDateOfRetroactiveCalculation();
        if (DateHelper.before((Date)this.mMaxReviewDate, (Date)maxRR)) {
            this.mMaxReviewDate = maxRR;
        }
        if (DateHelper.before((Date)this.mMaxReviewDate, (Date)(mDate4YearsBefore = DateHelper.addMonths((Date)this.mCreatedOnDate, (int)-48)))) {
            this.mMaxReviewDate = mDate4YearsBefore;
        }
        this.mTax = this.getTax(VDate.getDateMax(), VDate.getDateMax(), emp);
        this.mMaster = this.getMaster(VDate.getDateMax(), VDate.getDateMax(), emp);
        this.mNewAccounts = new ArrayList<PuegAccount>();
        if (this.mHistorical) {
            for (Date date : this.getDates(emp, this.mFrom, this.mUntil)) {
                this.mInsurance = this.getInsurance(VDate.getDateMax(), date, emp);
                this.mEmployment = this.getEmployment(VDate.getDateMax(), date, emp);
                this.mStartDate = date;
                if (DateHelper.after((Date)this.mEmployment.getDateOfEntry(), (Date)this.mStartDate)) {
                    this.mStartDate = this.mEmployment.getDateOfEntry();
                }
                this.mInsurance = this.getInsuranceOrNull(emp.getJournalizedUntil(), date, emp);
                this.mEmployment = this.getEmploymentOrNull(emp.getJournalizedUntil(), date, emp);
                if (this.mInsurance == null || this.mEmployment == null) continue;
                Date date2 = this.mEndDate = this.mEmployment.getDateOfWithDrawal() != null ? DateHelper.tomorrow((Date)this.mEmployment.getDateOfWithDrawal()) : null;
                if (this.mEndDate == null) {
                    this.mEndDate = this.mUntil;
                }
                if (!this.isRegisterable(emp, true)) continue;
                this.mNewAccounts.clear();
                PuegAccount newAccount = this.createHistorienanfrage(emp, this.mStartDate, this.mEndDate);
                if (!this.checkPuegHistoryForManHistAnfragen(this.mStartDate, this.mEndDate)) {
                    newAccount.addError("Es existiert bereits eine Anfrage f\u00fcr den Zeitraum.");
                }
                this.mNewAccounts.add(newAccount);
                break;
            }
        } else {
            String[] states = new String[]{"" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.AUFGEBAUT), "" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.UEBERMITTELT), "" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.VERARBEITET)};
            this.initialAnmeldungen(emp, states);
            this.initialAbmeldungen(emp, states);
            this.initialHistAnfragen(emp, states);
            String[] statesAbgelehnt = new String[]{"" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.ABGELEHNT)};
            this.initialAnmeldungenAbgelehnt(emp, statesAbgelehnt);
            this.mKuendigungCreated = false;
            this.mAnmeldungCreated = false;
            for (Date date : this.getDates(emp, this.mMaxReviewDate, this.mCreatedOnDate)) {
                PuegAccount abm;
                this.mInsurance = this.getInsurance(VDate.getDateMax(), date, emp);
                this.mEmployment = this.getEmployment(VDate.getDateMax(), date, emp);
                this.mStartDate = date;
                if (DateHelper.after((Date)this.mEmployment.getDateOfEntry(), (Date)this.mStartDate)) {
                    this.mStartDate = this.mEmployment.getDateOfEntry();
                }
                Date date3 = this.mEndDate = this.mEmployment.getDateOfWithDrawal() != null ? DateHelper.tomorrow((Date)this.mEmployment.getDateOfWithDrawal()) : null;
                if (this.mEndDate == null || this.isNotPvObligatory(date) && DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)this.mEndDate)) {
                    this.mEndDate = this.mInsurance.getValidFrom();
                }
                if (!this.mAnmeldungCreated && this.isRegisterable(emp, false)) {
                    this.mNewAccounts.add(this.createAnmeldung(emp, this.mStartDate));
                    this.mAnmeldungCreated = true;
                    if (this.mLastDummy != null && emp.equals((Object)this.mLastDummy.getEmployee())) {
                        this.mNewAccounts.remove(this.mLastDummy);
                        this.mLastDummy = null;
                    }
                }
                this.mInsurance = this.getInsuranceOrNull(emp.getJournalizedUntil(), date, emp);
                this.mEmployment = this.getEmploymentOrNull(emp.getJournalizedUntil(), date, emp);
                if (this.mInsurance == null || this.mEmployment == null) continue;
                Date date4 = this.mEndDate = this.mEmployment.getDateOfWithDrawal() != null ? DateHelper.tomorrow((Date)this.mEmployment.getDateOfWithDrawal()) : null;
                if (this.mEndDate == null || this.isNotPvObligatory(date) && DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)this.mEndDate)) {
                    this.mEndDate = this.mInsurance.getValidFrom();
                }
                if (!this.mKuendigungCreated && this.isCancellable(emp)) {
                    this.mNewAccounts.add(this.createKuendigung(emp, this.mEndDate));
                    this.mKuendigungCreated = true;
                }
                if (this.mAnmeldungCreated && this.mKuendigungCreated) {
                    for (PuegAccount each : this.mNewAccounts) {
                        if (!PuegReasonOfDeliveryEnum.KUENDIGUNG.equals((Object)each.getReasonOfDelivery())) continue;
                        each.addError("R\u00fcckstellung: Es wurde ebenfalls eine Anmeldung aufgebaut. Diese muss zun\u00e4chst \u00fcbermittelt werden.");
                    }
                }
                if (this.mAnmeldungCreated || !this.mKuendigungCreated || !this.hasMessage(PuegReasonOfDeliveryEnum.ANFRAGE, (abm = this.mNewAccounts.get(0)).getCreatedOn())) continue;
                abm.addError("R\u00fcckstellung: Es wurde bereits eine Anmeldung f\u00fcr diesen Tag \u00fcbermittelt. Der Aufbau und die \u00dcbermittlung sind erst am Folgetag m\u00f6glich.");
            }
        }
        for (PuegAccount each : this.mNewAccounts) {
            this.checkAttributes(each);
            if (!each.hasErrors()) {
                each.makeSaveable();
                each.setAdviceState(PuegAdviceStateEnum.BEREIT);
                this.mCreated.add(each);
                continue;
            }
            if (!each.getErrorMessage().contains(noCancelationPhrase)) {
                each.makeReadOnly();
            } else {
                each.setAdviceState(PuegAdviceStateEnum.AUFGEBAUT);
            }
            this.mCreatedError.add(each);
        }
    }

    private boolean hasMessage(PuegReasonOfDeliveryEnum type, Date createdOn) {
        switch (type.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                for (PuegAccount each : this.mAnmeldungen) {
                    if (!DateHelper.equal((Date)each.getCreatedOn(), (Date)createdOn)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (PuegAccount each : this.mAbmeldungen) {
                    if (!DateHelper.equal((Date)each.getCreatedOn(), (Date)createdOn)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void initialAnmeldungen(Employee emp, String[] states) {
        this.mAnmeldungen = PuegAccount.getPuegAccounts((String)"", (String)emp.getObjectid(), (Date)DATE_START_PUEG, (int)PuegReasonOfDeliveryEnum.toInt((PuegReasonOfDeliveryEnum)PuegReasonOfDeliveryEnum.ANFRAGE), (boolean)true, (String[])states);
    }

    private void initialAbmeldungen(Employee emp, String[] states) {
        this.mAbmeldungen = PuegAccount.getPuegAccounts((String)"", (String)emp.getObjectid(), (Date)DATE_START_PUEG, (int)PuegReasonOfDeliveryEnum.toInt((PuegReasonOfDeliveryEnum)PuegReasonOfDeliveryEnum.KUENDIGUNG), (boolean)false, (String[])states);
    }

    private void initialHistAnfragen(Employee emp, String[] states) {
        this.mHistAnfragen = PuegAccount.getPuegAccounts((String)"", (String)emp.getObjectid(), (Date)DATE_START_PUEG, (int)PuegReasonOfDeliveryEnum.toInt((PuegReasonOfDeliveryEnum)PuegReasonOfDeliveryEnum.ANFRAGE), (boolean)false, (String[])states);
    }

    private void initialAnmeldungenAbgelehnt(Employee emp, String[] states) {
        this.mAnmeldungenAbgelehnt = PuegAccount.getPuegAccounts((String)"", (String)emp.getObjectid(), (Date)DATE_START_PUEG, (int)PuegReasonOfDeliveryEnum.toInt((PuegReasonOfDeliveryEnum)PuegReasonOfDeliveryEnum.ANFRAGE), (boolean)true, (String[])states);
    }

    public boolean hasInitializedAccounts() {
        PuegAccount[] accounts = PuegAccount.getPuegAccounts((String)this.mPCompany.getObjectid(), null, (Date)DATE_START_PUEG, (int)PuegReasonOfDeliveryEnum.toInt((PuegReasonOfDeliveryEnum)PuegReasonOfDeliveryEnum.ALLE), (boolean)false, null);
        return accounts != null && accounts.length > 0;
    }

    private List<Date> getDates(Employee emp, Date from, Date until) throws BusinessDomainException {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (Employment each : emp.getEmploymentHistory().getPeriods(this.mCreatedOnDate, from, until)) {
            if (each == null || each.getValidFrom() == null || dates.contains(each.getValidFrom())) continue;
            dates.add(each.getValidFrom());
        }
        for (Employment each : emp.getInsuranceHistory().getPeriods(this.mCreatedOnDate, from, until)) {
            if (each == null || each.getValidFrom() == null || dates.contains(each.getValidFrom())) continue;
            dates.add(each.getValidFrom());
        }
        return dates;
    }

    private boolean isRegisterable(Employee emp, boolean forHistoricSetup) throws BusinessDomainException {
        if (!forHistoricSetup) {
            this.isOrderCriterionForRegistration();
            if (DateHelper.after((Date)this.mEmployment.getDateOfEntry(), (Date)this.mMaxReviewDate) && DateHelper.after((Date)this.mEmployment.getDateOfEntry(), (Date)this.mCreatedOnDate)) {
                return false;
            }
        } else {
            this.mNewAccounts.clear();
        }
        if (this.mEmployment.getDateOfWithDrawal() != null && (DateHelper.before((Date)this.mEmployment.getDateOfWithDrawal(), (Date)this.mMaxReviewDate) || !DateHelper.between((Date)this.mCreatedOnDate, (Date)this.mEmployment.getDateOfEntry(), (Date)this.mEmployment.getDateOfWithDrawal()))) {
            return false;
        }
        if (DateHelper.after((Date)this.mStartDate, (Date)this.mCreatedOnDate)) {
            this.createDummyForError(emp, this.mStartDate, "Die erneute Anmeldung nach K\u00fcndigung, z.B. wegen Wechselfall Ordnungskriterium, ist erst am Folgetag m\u00f6glich.");
            return false;
        }
        if (this.isNotPvObligatory(this.mStartDate)) {
            this.createDummyForError(emp, this.mStartDate, "F\u00fcr diesen Mitarbeiter besteht keine PV-Pflicht.");
            return false;
        }
        if (this.checkAbsentTime(emp, this.mStartDate, VDate.getDateMax())) {
            this.createDummyForError(emp, this.mStartDate, "Keine Anfrage aufgrund einer Fehlzeit 2.9.");
            return false;
        }
        if (this.mEmployment.getDateOfWithDrawal() != null && DateHelper.afterOrEqual((Date)this.mEmployment.getDateOfWithDrawal(), (Date)this.mEmployment.getDateOfEntry()) && DateHelper.after((Date)this.mStartDate, (Date)this.mEmployment.getDateOfWithDrawal())) {
            return false;
        }
        return forHistoricSetup || this.checkPuegHistoryForAnmeldung(this.mStartDate);
    }

    private void createDummyForError(Employee emp, Date date, String text) throws BusinessDomainException {
        if (this.mLastDummy == null || !emp.equals((Object)this.mLastDummy.getEmployee()) || !this.mLastDummy.getErrorMessage().contains(text)) {
            PuegAccount dummy = this.createAnmeldung(emp, date);
            dummy.addError(text);
            dummy.makeReadOnly();
            this.mNewAccounts.add(dummy);
            this.mLastDummy = dummy;
        }
    }

    private boolean isCancellable(Employee emp) throws BusinessDomainException {
        if ((this.mEmployment.getDateOfWithDrawal() != null && (DateHelper.afterOrEqual((Date)this.mEmployment.getDateOfWithDrawal(), (Date)this.mMaxReviewDate) || this.isRegistratedAndRetroWithDrawal()) && DateHelper.beforeOrEqual((Date)this.mEmployment.getDateOfWithDrawal(), (Date)this.mCreatedOnDate) && !DateHelper.after((Date)this.mEmployment.getDateOfWithDrawal(), (Date)this.mEmployment.getValidUntil()) || this.isNotPvObligatory(this.mEndDate) || this.isOrderCriterion() || this.checkAbsentTime(emp, this.mEndDate, VDate.getDateMax())) && this.checkPuegHistoryForKuendigung(this.mEndDate)) {
            PuegAccount lastAnmeldung = this.getLastAnmeldungOrNull();
            if (lastAnmeldung != null) {
                this.mDevTin = lastAnmeldung.getPuegAnfrage().getIdnr();
                this.mDevDateOfBirth = lastAnmeldung.getPuegAnfrage().getGeburtsdatum();
                this.mDevDateOfBirthAbw = lastAnmeldung.getPuegAnfrage().getGeburtsdatumabw();
                this.mDevKundennummer = lastAnmeldung.getPuegAnfrage().getKundennummer();
                this.mDevZuordnungsmerkmal = lastAnmeldung.getPuegAnfrage().getZuordnungsmerkmal();
                this.mDevOrdnungsbegriff = lastAnmeldung.getPuegAnfrage().getOrdnungsbegriff();
            }
            return true;
        }
        return false;
    }

    private boolean isRegistratedAndRetroWithDrawal() {
        PuegAccount lastAnmeldung = this.getLastAnmeldungOrNull();
        if (lastAnmeldung == null) {
            return false;
        }
        if (DateHelper.beforeOrEqual((Date)lastAnmeldung.getPuegAnfrage().getAbdatum(), (Date)this.mMaxReviewDate)) {
            this.mEndDate = DateHelper.add((Date)lastAnmeldung.getPuegAnfrage().getAbdatum(), (int)1);
            return true;
        }
        return false;
    }

    private PuegAccount getLastAnmeldungOrNull() {
        PuegAccount lastAnmeldung = null;
        if (this.mAnmeldungCreated) {
            lastAnmeldung = this.mNewAccounts.get(0);
        } else {
            if (this.mAnmeldungen == null || this.mAnmeldungen.length < 1) {
                return null;
            }
            lastAnmeldung = this.mAnmeldungen[this.mAnmeldungen.length - 1];
        }
        return lastAnmeldung;
    }

    private boolean isNotPvObligatory(Date date) {
        if (DateHelper.before((Date)date, (Date)DATE_START_PUEG)) {
            return false;
        }
        if (this.isKvdr(date)) {
            return ChoiseOfDuesNIEnum.CODNIE_KEIN_BEITRAG.equals(this.mInsurance.getChoiseOfDuesNI());
        }
        return this.mInsurance.getDuesGroupNI() == 0;
    }

    private boolean isOrderCriterion() throws BusinessDomainException {
        PuegAccount lastAnmeldung = this.getLastAnmeldungOrNull();
        if (this.checkOrderCriterion(lastAnmeldung) && this.checkResonse()) {
            this.mEndDate = this.mCreatedOnDate;
            return true;
        }
        return false;
    }

    private boolean isOrderCriterionForRegistration() throws BusinessDomainException {
        if (this.mAbmeldungen == null || this.mAbmeldungen.length < 1) {
            return false;
        }
        PuegAccount lastAbmeldung = this.mAbmeldungen[this.mAbmeldungen.length - 1];
        if (this.checkOrderCriterionForRegistration(lastAbmeldung) && this.checkResonse()) {
            this.mStartDate = DateHelper.add((Date)lastAbmeldung.getValidDate(), (int)1);
            return true;
        }
        return false;
    }

    private boolean checkResonse() {
        return true;
    }

    private boolean checkOrderCriterion(PuegAccount lastAnmeldung) throws BusinessDomainException {
        if (lastAnmeldung == null) {
            return false;
        }
        Employee emp = lastAnmeldung.getEmployee();
        String dateMaster = this.getBirthDateFromMaster();
        String dateAnmeldung = this.getBirthDateFromLastAnmeldung(lastAnmeldung);
        return !this.mTax.getTin().equals(lastAnmeldung.getPuegAnfrage().getIdnr()) || !StringMapper.equal((String)dateMaster, (String)dateAnmeldung) || !StringMapper.equal((String)KUNDENNUMMER, (String)lastAnmeldung.getPuegAnfrage().getKundennummer()) || !this.isSameZuordnungsmerkmal(this.getZuordnungsmerkmal(emp, this.mEndDate), lastAnmeldung.getPuegAnfrage().getZuordnungsmerkmal()) || !StringMapper.equal((String)emp.getIDString(), (String)lastAnmeldung.getPuegAnfrage().getOrdnungsbegriff());
    }

    private boolean checkOrderCriterionForRegistration(PuegAccount lastAbmeldung) throws BusinessDomainException {
        Employee emp = lastAbmeldung.getEmployee();
        String dateMaster = this.getBirthDateFromMaster();
        String dateKuendigung = this.getBirthDateFromLastKuendigung(lastAbmeldung);
        return !this.mTax.getTin().equals(lastAbmeldung.getPuegKuendigung().getIdnr()) || !StringMapper.equal((String)dateMaster, (String)dateKuendigung) || !StringMapper.equal((String)KUNDENNUMMER, (String)lastAbmeldung.getPuegKuendigung().getKundennummer()) || !this.isSameZuordnungsmerkmal(this.getZuordnungsmerkmal(emp, this.mEndDate), lastAbmeldung.getPuegKuendigung().getZuordnungsmerkmal()) || !StringMapper.equal((String)emp.getIDString(), (String)lastAbmeldung.getPuegKuendigung().getOrdnungsbegriff());
    }

    private String getBirthDateFromMaster() {
        String dateMaster = null;
        dateMaster = !StringMapper.isNullString((String)this.mMaster.getDateOfBirthELSTAM()) ? ReportDataTransfer.makeToNeededNumberLength((String)PuegComponents.formatDateString((String)this.mMaster.getDateOfBirthELSTAM()), (int)8) : ReportDataTransfer.makeToNeededNumberLength((String)DateMapper.toYYYYMMDDString((Date)this.mMaster.getDateOfBirth()), (int)8);
        return dateMaster;
    }

    private String getBirthDateFromLastAnmeldung(PuegAccount lastAnmeldung) {
        String dateAnmeldung = null;
        dateAnmeldung = !StringMapper.isNullString((String)lastAnmeldung.getPuegAnfrage().getGeburtsdatumabw()) ? ReportDataTransfer.makeToNeededNumberLength((String)PuegComponents.formatDateString((String)lastAnmeldung.getPuegAnfrage().getGeburtsdatumabw()), (int)8) : ReportDataTransfer.makeToNeededNumberLength((String)DateMapper.toYYYYMMDDString((Date)lastAnmeldung.getPuegAnfrage().getGeburtsdatum()), (int)8);
        return dateAnmeldung;
    }

    private String getBirthDateFromLastKuendigung(PuegAccount lastKuendigung) {
        String dateKuendigung = null;
        dateKuendigung = !StringMapper.isNullString((String)lastKuendigung.getPuegKuendigung().getGeburtsdatumabw()) ? ReportDataTransfer.makeToNeededNumberLength((String)PuegComponents.formatDateString((String)lastKuendigung.getPuegKuendigung().getGeburtsdatumabw()), (int)8) : ReportDataTransfer.makeToNeededNumberLength((String)DateMapper.toYYYYMMDDString((Date)lastKuendigung.getPuegKuendigung().getGeburtsdatum()), (int)8);
        return dateKuendigung;
    }

    private boolean isSameZuordnungsmerkmal(String currentZuordnungsmerkmal, String oldZuordnungsmerkmal) throws BusinessDomainException {
        String currentPart1 = currentZuordnungsmerkmal.substring(0, 8);
        String currentPart3 = currentZuordnungsmerkmal.substring(18, 26);
        String oldPart1 = oldZuordnungsmerkmal.substring(0, 8);
        String oldPart3 = oldZuordnungsmerkmal.substring(18, 26);
        return StringMapper.equal((String)currentPart1, (String)oldPart1) && StringMapper.equal((String)currentPart3, (String)oldPart3);
    }

    private boolean checkAbsentTime(Employee emp, Date from, Date until) {
        for (EEAbsentTime at : emp.getEEAbsentTimes()) {
            if (at.getIsDeleted() || !this.isRelevantAt(at)) continue;
            for (EEAbsentTimeTP tp : at.getEEAbsentTimeHistory(VDate.getDateMax())) {
                if (!PDateHelper.isIntersection((Date)from, (Date)until, (Date)tp.getValidFrom(), (Date)tp.getValidUntil()) || !DateHelper.beforeOrEqual((Date)tp.getValidFrom(), (Date)this.mCreatedOnDate)) continue;
                this.mStartDate = DateHelper.tomorrow((Date)tp.getValidUntil());
                if (!DateHelper.afterOrEqual((Date)tp.getValidUntil(), (Date)this.mCreatedOnDate)) continue;
                this.mEndDate = tp.getValidFrom();
                return true;
            }
        }
        return false;
    }

    private boolean isRelevantAt(EEAbsentTime at) {
        AbsentTime absentTime = at.getAbsentTime();
        String deuvCode = absentTime.getDEUVAbsentTimeKey();
        return !StringMapper.isNullString((String)deuvCode) && deuvCode.equals("2.9");
    }

    private boolean isKvdr(Date date) {
        Date begin = this.mInsurance.getBeginKVDR();
        if (begin == null) {
            return false;
        }
        Date end = this.mInsurance.getEndKVDR();
        if (end == null) {
            return DateHelper.afterOrEqual((Date)date, (Date)DateHelper.getFirstDayOfMonth((Date)begin));
        }
        return DateHelper.between((Date)date, (Date)DateHelper.getFirstDayOfMonth((Date)begin), (Date)DateHelper.getLastDayOfMonth((Date)end));
    }

    private boolean checkPuegHistoryForAnmeldung(Date date) {
        if (this.mAnmeldungenAbgelehnt != null && this.mAnmeldungenAbgelehnt.length > 0) {
            for (PuegAccount each : this.mAnmeldungenAbgelehnt) {
                if (StringMapper.isNullString((String)each.getErrorMessage()) || !each.getErrorMessage().contains("PUEG-3007-F") || !each.getPuegAnfrage().getIdnr().equals(this.mTax.getTin())) continue;
                return false;
            }
        }
        if (this.mAnmeldungen != null && this.mAnmeldungen.length > 0) {
            int anmeldungeBefore = 0;
            int abmeldungeBefore = 0;
            for (PuegAccount each : this.mAnmeldungen) {
                if (date.equals(each.getValidDate())) {
                    return false;
                }
                if (DateHelper.after((Date)date, (Date)each.getValidDate())) {
                    ++anmeldungeBefore;
                }
                if (each.getPuegAnfrage() == null || each.getPuegAnfrage().getPuegAntwortenKuendigung() == null || each.getPuegAnfrage().getPuegAntwortenKuendigung().length <= 0) continue;
                ++abmeldungeBefore;
            }
            for (PuegAccount each : this.mAbmeldungen) {
                if (!DateHelper.after((Date)date, (Date)each.getValidDate())) continue;
                ++abmeldungeBefore;
            }
            if (anmeldungeBefore != abmeldungeBefore) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPuegHistoryForKuendigung(Date date) {
        if (!(this.mAnmeldungCreated || this.mAnmeldungen != null && this.mAnmeldungen.length >= 1)) {
            return false;
        }
        int anmeldungeBefore = 0;
        int abmeldungeBefore = 0;
        for (PuegAccount each : this.mAnmeldungen) {
            if (DateHelper.after((Date)date, (Date)each.getValidDate())) {
                ++anmeldungeBefore;
            }
            if (each.getPuegAnfrage() == null || each.getPuegAnfrage().getPuegAntwortenKuendigung() == null || each.getPuegAnfrage().getPuegAntwortenKuendigung().length <= 0) continue;
            ++abmeldungeBefore;
        }
        if (this.mAnmeldungCreated) {
            ++anmeldungeBefore;
        }
        for (PuegAccount each : this.mAbmeldungen) {
            if (DateHelper.equal((Date)date, (Date)each.getValidDate())) {
                return false;
            }
            if (!DateHelper.after((Date)date, (Date)each.getValidDate())) continue;
            ++abmeldungeBefore;
        }
        return anmeldungeBefore != abmeldungeBefore;
    }

    private boolean checkPuegHistoryForHistAnfragen(Date date) {
        if (this.mHistAnfragen != null && this.mHistAnfragen.length > 0) {
            for (PuegAccount each : this.mHistAnfragen) {
                if (!date.equals(each.getValidDate())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkPuegHistoryForManHistAnfragen(Date from, Date until) {
        if (this.mAnmeldungen != null && this.mAnmeldungen.length > 0) {
            for (PuegAccount each : this.mAnmeldungen) {
                if (!DateHelper.between((Date)each.getValidDate(), (Date)from, (Date)until)) continue;
                return false;
            }
        }
        return true;
    }

    private PuegAccount createAccount(Employee emp, PuegReasonOfDeliveryEnum reason, Date ab, boolean abo) throws BusinessDomainException {
        PuegAccount account = new PuegAccount(emp);
        account.setAdviceState(PuegAdviceStateEnum.AUFGEBAUT);
        account.setReasonOfDelivery(reason);
        account.setCreatedOn(this.mCreatedOnDate);
        account.setDEUVSender(this.mDEUVSenderTP.getDEUVSender());
        account.setDEUVRecipient(this.getDEUVRecipient());
        account.setErrorMessage("");
        account.setValidDate(ab);
        account.setAbo(abo);
        return account;
    }

    private PuegAnfrage createAnfrage(Employee employee, PuegAccount account, Date ab, boolean abo) throws BusinessDomainException {
        PuegAnfrage anfrage = account.createAnfrage();
        UUID uuid = UUID.randomUUID();
        anfrage.setMessageid(uuid.toString());
        anfrage.setDatumanfrage(DeuvBasics.getCurrentDeuvDateString());
        anfrage.setKundennummer(KUNDENNUMMER);
        anfrage.setZuordnungsmerkmal(this.getZuordnungsmerkmal(employee, ab));
        anfrage.setOrdnungsbegriff(employee.getIDString());
        anfrage.setIdnr(this.mTax.getTin());
        anfrage.setGeburtsdatum(this.mMaster.getDateOfBirth());
        anfrage.setGeburtsdatumabw(this.mMaster.getDateOfBirthELSTAM());
        anfrage.setAbdatum(ab);
        anfrage.setAbo(abo);
        anfrage.setBisdatum(null);
        return anfrage;
    }

    private Date convertToDateOrNull(String dateOfBirthELSTAM) {
        Date date;
        String string = dateOfBirthELSTAM;
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy", Locale.UK);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = format.parse(string);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    private PuegAccount createAnmeldung(Employee employee, Date ab) throws BusinessDomainException {
        PuegAccount account = this.createAccount(employee, PuegReasonOfDeliveryEnum.ANFRAGE, ab, true);
        this.createAnfrage(employee, account, ab, true);
        return account;
    }

    private PuegAccount createHistorienanfrage(Employee employee, Date ab, Date bis) throws BusinessDomainException {
        PuegAccount account = this.createAccount(employee, PuegReasonOfDeliveryEnum.ANFRAGE, ab, false);
        PuegAnfrage anfrage = this.createAnfrage(employee, account, ab, false);
        anfrage.setBisdatum(bis);
        return account;
    }

    private PuegAccount createKuendigung(Employee employee, Date ab) throws BusinessDomainException {
        PuegAccount account = this.createAccount(employee, PuegReasonOfDeliveryEnum.KUENDIGUNG, ab, false);
        PuegKuendigung kuendigung = account.createKuendigung();
        UUID uuid = UUID.randomUUID();
        kuendigung.setMessageid(uuid.toString());
        kuendigung.setDatumanfrage(DeuvBasics.getCurrentDeuvDateString());
        if (!StringMapper.isNullString((String)this.mDevKundennummer)) {
            kuendigung.setKundennummer(this.mDevKundennummer);
        } else {
            kuendigung.setKundennummer(KUNDENNUMMER);
        }
        if (!StringMapper.isNullString((String)this.mDevZuordnungsmerkmal)) {
            kuendigung.setZuordnungsmerkmal(this.mDevZuordnungsmerkmal);
        } else {
            kuendigung.setZuordnungsmerkmal(this.getZuordnungsmerkmal(employee, ab));
        }
        if (!StringMapper.isNullString((String)this.mDevOrdnungsbegriff)) {
            kuendigung.setOrdnungsbegriff(this.mDevOrdnungsbegriff);
        } else {
            kuendigung.setOrdnungsbegriff(employee.getIDString());
        }
        if (!StringMapper.isNullString((String)this.mDevTin)) {
            kuendigung.setIdnr(this.mDevTin);
        } else {
            kuendigung.setIdnr(this.mTax.getTin());
        }
        if (this.mDevDateOfBirth != null) {
            kuendigung.setGeburtsdatum(this.mDevDateOfBirth);
        } else {
            kuendigung.setGeburtsdatum(this.mMaster.getDateOfBirth());
        }
        if (!StringMapper.isNullString((String)this.mDevDateOfBirthAbw)) {
            kuendigung.setGeburtsdatumabw(this.mDevDateOfBirthAbw);
        } else {
            kuendigung.setGeburtsdatumabw(this.mMaster.getDateOfBirthELSTAM());
        }
        return account;
    }

    public List<PuegAccount> getUntransmitteds(PuegReasonOfDeliveryEnum reason, String[] states, boolean withoutErrors) throws BusinessDomainException {
        List empFilterList;
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.in((String)"advicestate", (String[])states));
        if (!PuegReasonOfDeliveryEnum.ALLE.equals((Object)reason)) {
            filter.add(Restrictions.eq((String)"reasonofdelivery", (String)("" + PuegReasonOfDeliveryEnum.toInt((PuegReasonOfDeliveryEnum)reason))));
        }
        if ((empFilterList = PuegAccount.getEmployeeFilter((String)this.mPCompany.getObjectid(), null, null)) == null) {
            return new ArrayList<PuegAccount>();
        }
        ArrayList<PuegAccount> untransmitteds = new ArrayList<PuegAccount>();
        for (Criterion empFilter : empFilterList) {
            PuegAccount[] rows = PuegAdvice.getIPuegAccountPM().query(null, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            untransmitteds.addAll(Arrays.asList(rows));
        }
        ArrayList<PuegAccount> untransmittedsList = new ArrayList<PuegAccount>();
        for (PuegAccount account : untransmitteds) {
            if (withoutErrors && account.hasErrors()) continue;
            untransmittedsList.add(account);
        }
        Collections.sort(untransmittedsList, this.getPuegAccountComparator());
        return untransmittedsList;
    }

    private String getZuordnungsmerkmal(Employee employee, Date date) throws BusinessDomainException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mDEUVSenderTP.getStdCompanyNumber());
        sb.append("-");
        if (this.isKvdr(date)) {
            sb.append(ZahlsProtocolReport.getZahlsNumber((Employee)employee, (Date)VDate.getDateMax(), (Date)this.mCreatedOnDate));
        } else {
            sb.append(DEUVAdvice.getMainEmployerNumber((Employee)employee, (Date)VDate.getDateMax(), (Date)this.mCreatedOnDate));
        }
        sb.append("-");
        if (this.isKvdr(date)) {
            sb.append(ZahlsProtocolReport.getZahlsNumber((Employee)employee, (Date)VDate.getDateMax(), (Date)this.mCreatedOnDate));
        } else {
            sb.append(DEUVAdvice.getMainEmployerNumber((Employee)employee, (Date)VDate.getDateMax(), (Date)this.mCreatedOnDate));
        }
        return sb.toString();
    }

    private static IPuegAccountPersistencyManager getIPuegAccountPM() {
        return (IPuegAccountPersistencyManager)UtilitiesManager.getBean((String)"puegAccountPersistencyManager", IPuegAccountPersistencyManager.class);
    }

    public void setAffectedBySpecialAccess(boolean affectedBySpecialAccess) {
        this.mAffectedBySpecialAccess = affectedBySpecialAccess;
    }

    public Date getCreatedOnDate() {
        return this.mCreatedOnDate;
    }

    public Date getCreatedOnDateTruncated() {
        return DateHelper.correctDate((Date)this.mCreatedOnDate);
    }

    public String getPCompanyName(Date validTimePoint) throws BusinessDomainException {
        return this.getFoundations(validTimePoint).getShortDescription();
    }

    private Foundations getFoundations(Date validTimePoint) throws BusinessDomainException {
        return this.mPCompany.getCompanyFoundations(VDate.getDateMax(), validTimePoint).getFoundations();
    }

    public String getCompanyDescription(Date validTimePoint) throws BusinessDomainException {
        return this.getFoundations(validTimePoint).getShortDescription();
    }

    public boolean isAffectedBySpecialAccess() {
        return this.mAffectedBySpecialAccess;
    }

    private DEUVRecipient getDEUVRecipient() throws BusinessDomainException {
        return DeuvRecipientMap.getRecipientByTypeOfHealthFund((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG, (DEUVSender)this.mDEUVSenderTP.getDEUVSender());
    }

    public Insurance getInsurance(Date effectiveTimePoint, Date validTimePoint, Employee employee) throws BusinessDomainException {
        return employee.getInsurance(effectiveTimePoint, validTimePoint);
    }

    public Insurance getInsuranceOrNull(Date effectiveTimePoint, Date validTimePoint, Employee employee) throws BusinessDomainException {
        return (Insurance)employee.getInsuranceHistory().getItemOrNull(effectiveTimePoint, validTimePoint);
    }

    public Master getMaster(Date effectiveTimePoint, Date validTimePoint, Employee employee) throws BusinessDomainException {
        return employee.getMaster(effectiveTimePoint, validTimePoint);
    }

    public Tax getTax(Date effectiveTimePoint, Date validTimePoint, Employee employee) throws BusinessDomainException {
        return employee.getTax(effectiveTimePoint, validTimePoint);
    }

    public Employment getEmployment(Date effectiveTimePoint, Date validTimePoint, Employee employee) throws BusinessDomainException {
        return employee.getEmployment(effectiveTimePoint, validTimePoint);
    }

    public Employment getEmploymentOrNull(Date effectiveTimePoint, Date validTimePoint, Employee employee) throws BusinessDomainException {
        return (Employment)employee.getEmploymentHistory().getItemOrNull(effectiveTimePoint, validTimePoint);
    }

    public static final String formatPuegTimestamp(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(date);
    }

    public List<PuegAccount> getCreated() {
        return this.mCreated;
    }

    public List<PuegAccount> getCreatedError() {
        return this.mCreatedError;
    }

    public void setAsHistoricalSetup(Date from, Date until) {
        this.mHistorical = true;
        this.mFrom = from;
        this.mUntil = until;
    }

    public Comparator<PuegAccount> getPuegAccountComparator() {
        return new PuegAccountComparator();
    }
}

