/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.plant.settings;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.companyplant.AssessmentDutyEnum;
import com.varial.personnel.domain.companyplant.PensionschemeSettingsEnum;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.companyplant.mapper.PensionschemeSettingsEnumMapper;
import com.varial.personnel.domain.companyplant.mapper.ZvkSettingsEnumMapper;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModel;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModelPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.plant.IPlantPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.foundations.PPlantFoundationsFilterStruct;
import com.varial.personnel.domain.plant.foundations.mapper.PlantFoundationsFilterStructMapper;
import com.varial.personnel.domain.plant.settings.PlantSettings;
import com.varial.personnel.domain.plant.settings.PlantSettingsComparator;
import com.varial.personnel.domain.plant.settings.ctconsolidation.CTConsolidation;
import com.varial.personnel.domain.plant.settings.ctconsolidation.CTConsolidationPersistencyManager;
import com.varial.personnel.persistency.plant.plantsettings.IPlantsettingsDao;
import com.varial.personnel.persistency.plant.plantsettings.PlantsettingsContainer;
import com.varial.personnel.persistency.plant.plantsettingsall.IPlantsettingsallDao;
import com.varial.personnel.persistency.plant.plantsettingsall.PlantsettingsallContainer;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGenerator;
import java.util.Arrays;
import java.util.Date;

public class PlantSettingsPersistencyManager {
    private static IPlantsettingsallDao daoall = (IPlantsettingsallDao)UtilitiesManager.getApplicationContext().getBean("plantsettingsallDao");
    private static IPlantsettingsDao dao = (IPlantsettingsDao)UtilitiesManager.getApplicationContext().getBean("plantsettingsDao");
    private static IPlantPersistencyManager pm = (IPlantPersistencyManager)UtilitiesManager.getBean((String)"plantPersistencyManager", IPlantPersistencyManager.class);

    public static boolean existsPlantSettings(Criterion filters) {
        try {
            boolean existsPlantSettings = false;
            long count = dao.getRowCount(filters);
            if (count > 0L) {
                existsPlantSettings = true;
            }
            return existsPlantSettings;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static PlantSettings[] getPlantSettingsHistory(Plant pl) {
        return PlantSettingsPersistencyManager.query(null, Restrictions.eq((String)"oidplant", (String)pl.getObjectid()), pl);
    }

    public static PlantSettings[] query(Order[] sortierung, Criterion filters, Plant pl) {
        try {
            PlantsettingsContainer[] containers = dao.getRows(sortierung, filters);
            int count = containers.length;
            PlantSettings[] result = new PlantSettings[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new PlantSettings(pl, true);
                PlantSettingsPersistencyManager.fillPlantSettings(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static PlantSettings[] queryAll(Order[] sortierung, Criterion filters) {
        try {
            PlantsettingsallContainer[] containers = daoall.getRows(sortierung, filters);
            int count = containers.length;
            PlantSettings[] result = new PlantSettings[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new PlantSettings(pm.getPlant(containers[i].oidplant), true);
                PlantSettingsPersistencyManager.fillPlantSettings(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void load(PlantSettings ps) {
        PlantsettingsContainer container = null;
        try {
            container = dao.getRowByObjectID(ps.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)ps.getObjectid());
        }
        PlantSettingsPersistencyManager.fillPlantSettings(ps, container);
    }

    public static void save(PlantSettings ps) {
        PlantsettingsContainer container = dao.getInitializedInstance();
        PlantSettingsPersistencyManager.fillContainer(container, ps);
        try {
            container = ps.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        ps.setLastuser(container.getLastUserid());
        ps.setObjectid(container.getObjectid());
        ps.setTimestamp(container.getObjectTS());
        ps.setVersion(container.getVersion());
    }

    public static void delete(PlantSettings ps) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), ps.getObjectid(), ps.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static Date getStartOfHistory(String oidPlant) {
        try {
            SelectGenerator selector = new SelectGenerator("plantsettings_t", new String[]{"min(validfrom)"}, null, Restrictions.eq((String)"oidplant", (String)oidPlant), null, false, Date.class, new String[]{""});
            Date result = null;
            Date[] d = (Date[])selector.select();
            if (d[0] != null) {
                result = d[0];
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static void fillPlantSettings(PlantSettings ps, PlantsettingsContainer container) {
        ps.setLastuser(container.getLastUserid());
        ps.setObjectid(container.getObjectid());
        ps.setTimestamp(container.getObjectTS());
        ps.setVersion(container.getVersion());
        if (ps.getPlant() == null) {
            ps.setPlant(pm.getPlant(container.oidplant));
        }
        HealthFund healthFund = null;
        if (container.oidhfforassessment != null && container.oidhfforassessment != "") {
            healthFund = HealthFundPersistencyManager.getHealthFund((String)container.oidhfforassessment);
        }
        AgePartTimeModel agePartTimeModel = null;
        if (!StringMapper.isNullString((String)container.oidparttimemodel)) {
            agePartTimeModel = AgePartTimeModelPersistencyManager.getAgePartTimeModel((String)container.oidparttimemodel);
        }
        boolean erPaysNISurcharge = false;
        if (container.additionalint == 1) {
            erPaysNISurcharge = true;
        }
        Settings settings = new Settings(container.assessable, healthFund, container.annincometaxreturn, container.lawarea, container.dutyofsiidcard, agePartTimeModel, PensionschemeSettingsEnumMapper.toPensionschemeSettingsEnum((int)container.pensschemesetting), container.insolvencyass, container.minlaborutilrate, container.maxlaborutilrate, erPaysNISurcharge, ZvkSettingsEnumMapper.toZvkSettingsEnum((int)container.additionalenum), AssessmentDutyEnum.toAssessmentDutyEnum((int)container.assessmentduty));
        CTConsolidation[] cons = CTConsolidationPersistencyManager.getCTConsolidations((PlantSettings)ps);
        ps.setData(container.effectivefrom, container.effectiveuntil, container.validfrom, container.validuntil, settings, cons);
    }

    private static void fillPlantSettings(PlantSettings ps, PlantsettingsallContainer container) {
        ps.setLastuser(container.getLastUserid());
        ps.setObjectid(container.getObjectid());
        ps.setTimestamp(container.getObjectTS());
        ps.setVersion(container.getVersion());
        if (ps.getPlant() == null) {
            ps.setPlant(pm.getPlant(container.oidplant));
        }
        HealthFund healthFund = null;
        if (container.oidhfforassessment != null && container.oidhfforassessment != "") {
            healthFund = HealthFundPersistencyManager.getHealthFund((String)container.oidhfforassessment);
        }
        AgePartTimeModel agePartTimeModel = null;
        if (!StringMapper.isNullString((String)container.oidparttimemodel)) {
            agePartTimeModel = AgePartTimeModelPersistencyManager.getAgePartTimeModel((String)container.oidparttimemodel);
        }
        boolean erPaysNISurcharge = false;
        if (container.additionalint == 1) {
            erPaysNISurcharge = true;
        }
        Settings settings = new Settings(container.assessable, healthFund, container.annincometaxreturn, container.lawarea, container.dutyofsiidcard, agePartTimeModel, PensionschemeSettingsEnumMapper.toPensionschemeSettingsEnum((int)container.pensschemesetting), container.insolvencyass, container.minlaborutilrate, container.maxlaborutilrate, erPaysNISurcharge, ZvkSettingsEnumMapper.toZvkSettingsEnum((int)container.additionalenum), AssessmentDutyEnum.toAssessmentDutyEnum((int)container.assessmentduty));
        CTConsolidation[] cons = CTConsolidationPersistencyManager.getCTConsolidations((PlantSettings)ps);
        ps.setData(container.effectivefrom, container.effectiveuntil, container.validfrom, container.validuntil, settings, cons);
    }

    private static void fillContainer(PlantsettingsContainer container, PlantSettings ps) {
        container.setObjectid(ps.getObjectid());
        container.setObjectTS(ps.getTimestamp());
        container.setLastUserid(ps.getLastuser());
        container.setVersion(ps.getVersion());
        container.oidplant = ps.getPlant().getObjectid();
        container.effectivefrom = ps.getEffectiveFrom();
        container.effectiveuntil = ps.getEffectiveUntil();
        container.validfrom = ps.getValidFrom();
        container.validuntil = ps.getValidUntil();
        container.oidhfforassessment = ps.getSettings().getRateAssessmentAccomplishingHealthFund() == null ? "" : ps.getSettings().getRateAssessmentAccomplishingHealthFund().getObjectid();
        container.lawarea = ps.getSettings().getLawArea();
        container.dutyofsiidcard = ps.getSettings().getPromptDEUVAccount();
        container.annincometaxreturn = ps.getSettings().getAnnualIncomeTaxReturn();
        container.oidparttimemodel = ps.getSettings().getAgePartTimeModel() == null ? "" : ps.getSettings().getAgePartTimeModel().getObjectid();
        container.pensschemesetting = PensionschemeSettingsEnumMapper.toInt((PensionschemeSettingsEnum)ps.getSettings().getPensionshemeSettingsEnum());
        container.additionalint = ps.getSettings().getERPaysNISurcharge() ? 1 : 0;
        container.inclusionbavinatz = false;
        container.minlaborutilrate = ps.getSettings().getMinLaborUtilizationRate();
        container.maxlaborutilrate = ps.getSettings().getMaxlLaborUtilizationRate();
        container.insolvencyass = ps.getSettings().getInsolvencyAssessable();
        container.additionalenum = ZvkSettingsEnumMapper.toInt((ZvkSettingsEnum)ps.getSettings().getZvkSettings());
        container.assessmentduty = AssessmentDutyEnum.toInt((AssessmentDutyEnum)ps.getSettings().getAssessmentDuty());
        if (ps.getSettings().getAssessmentDuty() == AssessmentDutyEnum.KEINE || ps.getSettings().getAssessmentDuty() == AssessmentDutyEnum.U2) {
            container.assessable = false;
        }
        if (ps.getSettings().getAssessmentDuty() == AssessmentDutyEnum.U1_UND_U2) {
            container.assessable = true;
        }
        container.additionalboolean = false;
        container.additionaldate = null;
        container.additionalamount = null;
        container.additionalstring = "";
        container.additionaloid = "";
    }

    public static PlantSettings[] getActivePlantSettings(PPlantFoundationsFilterStruct[] filters, Order[] sortierung) {
        PlantSettings[] cs = PlantSettingsPersistencyManager.queryAll(sortierung, PlantFoundationsFilterStructMapper.toFilter((PPlantFoundationsFilterStruct[])filters));
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(cs, new PlantSettingsComparator());
        }
        return cs;
    }
}

