/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.plant.settings;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.ModeOfProcedureEnum;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.companyplant.mapper.CompanyPlantExceptionMapper;
import com.varial.personnel.domain.companyplant.mapper.ModeOfProcedureEnumMapper;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.employment.IEmploymentPersistencyManager;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.personnel.domain.global.lumpsumitax.LumpSumIncomeTax;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.mapper.PCompanyExceptionMapper;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.IPlantReferenced;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.mapper.PlantExceptionMapper;
import com.varial.personnel.domain.plant.settings.PlantSettingsPersistencyManager;
import com.varial.personnel.domain.plant.settings.ctconsolidation.CTConsolidation;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.math.BigDecimal;
import java.util.Date;

public class PlantSettings
extends PersonnelTimedPersistenceObject
implements IPlantReferenced {
    private static final int PRIORITY = 2;
    private Plant mPlant;
    private Settings mSettings;
    private CTConsolidation[] mConsolidations;
    private CTConsolidation[] mNewConsolidations;
    PlantSettings mOld = null;

    public PlantSettings(Plant plant) {
        super(2);
        this.mPlant = plant;
    }

    private PlantSettings(String objectID) {
        super(2, objectID);
    }

    public PlantSettings(String objectID, int version) {
        super(2, objectID, version);
    }

    protected PlantSettings(Plant plant, boolean readOnly) {
        super(2, readOnly);
        this.mPlant = plant;
    }

    public static PlantSettings getPlantSettings(String objectID) {
        return new PlantSettings(objectID);
    }

    protected void load() {
        PlantSettingsPersistencyManager.load(this);
    }

    protected void saveImpl() {
        PlantSettingsPersistencyManager.save(this);
    }

    protected void deleteImpl() {
        PlantSettingsPersistencyManager.delete(this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.mPlant.getDomainKey() + " / " + DateMapper.toString((Date)this.mEffectiveFrom) + " / " + DateMapper.toString((Date)this.mValidFrom);
    }

    public void setData(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, Settings settings, CTConsolidation[] cTConsolidation) {
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mSettings = settings;
        this.mConsolidations = cTConsolidation;
    }

    public void checkAttributes() throws BusinessDomainException {
        this.checkDates();
        Settings settings = null;
        if (this.mOld != null) {
            settings = this.mOld.getSettings();
        }
        this.getSettings().checkAttributes(this.getValidFrom(), settings);
        this.checkCTConsolidations();
        this.checkChangeOfAnnualIncomeTaxReturn();
        this.checkInsolvencyAssessable();
        this.getSettings().checkChangeOfAssessmentDuty(false, this.getPlant().getObjectid(), this.getValidFrom(), settings);
    }

    private void checkInsolvencyAssessable() throws BusinessDomainException {
        CompanyFoundations companyFoundations;
        if (this.getSettings().getInsolvencyAssessable() && ((companyFoundations = (CompanyFoundations)this.getPlant().getHeadCompany().getCompanyFoundationsHistory().getItemOrNull(VDate.getDateMax(), this.getValidFrom())).getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || companyFoundations.getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN) && DateHelper.beforeOrEqual((Date)this.getValidFrom(), (Date)companyFoundations.getFoundations().getInsolventlyUntil()) && DateHelper.afterOrEqual((Date)this.getValidUntil(), (Date)companyFoundations.getFoundations().getInsolventlyFrom())) {
            throw PCompanyExceptionMapper.makeInsolvencyAssessableFalseDomainException();
        }
    }

    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        Date minValidFrom = this.getPlant().getStartOfHistory();
        if (DateHelper.before((Date)this.getValidFrom(), (Date)minValidFrom)) {
            throw PlantExceptionMapper.makeStartHistoryBeforePlantFoundationValidFromDomainException((String)"PlantSettings.checkDates");
        }
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        this.setEffectiveFrom(pb.getSystemStart());
    }

    public void checkSettings(boolean assessableDeleted) throws BusinessDomainException {
        if (this.getSettings() != null) {
            if (this.getSettings().getAssessable()) {
                if (this.getSettings().getRateAssessmentAccomplishingHealthFund() == null) {
                    if (this.getPlant() != null && this.getPlant().getHeadCompany() != null) {
                        CompanySettings companySettings;
                        block15: {
                            companySettings = null;
                            try {
                                companySettings = this.getPlant().getHeadCompany().getCompanySettings(this.getEffectiveFrom(), this.getValidFrom());
                            }
                            catch (BusinessDomainException e) {
                                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block15;
                                throw e;
                            }
                        }
                        if (companySettings != null && companySettings.getSettings() != null) {
                            if (!companySettings.getSettings().getAssessable()) {
                                this.getSettings().checkAttributes(this.getValidFrom(), this.mOld.getSettings());
                            }
                        } else {
                            this.getSettings().checkAttributes(this.getValidFrom(), this.mOld.getSettings());
                        }
                    } else {
                        this.getSettings().checkAttributes(this.getValidFrom(), this.mOld.getSettings());
                    }
                }
            } else if (assessableDeleted) {
                this.checkAssessableDeletable();
                this.getSettings().checkAttributes(this.getValidFrom(), this.mOld.getSettings());
            } else {
                this.getSettings().checkAttributes(this.getValidFrom(), this.mOld.getSettings());
            }
        } else if (assessableDeleted) {
            this.checkAssessableDeletable();
        }
    }

    public void checkAssessableDeletable() throws BusinessDomainException {
        boolean notDeletable = true;
        CompanySettings companySettings = null;
        if (this.getPlant() != null) {
            if (this.getPlant().getHeadCompany() != null) {
                block6: {
                    try {
                        companySettings = this.getPlant().getHeadCompany().getCompanySettings(this.getEffectiveFrom(), this.getValidFrom());
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block6;
                        throw e;
                    }
                }
                notDeletable = companySettings != null ? (companySettings.getSettings() != null ? (companySettings.getSettings().getAssessable() ? false : this.getIEmployeePM().assessableEE(null, this)) : this.getIEmployeePM().assessableEE(null, this)) : this.getIEmployeePM().assessableEE(null, this);
            } else {
                notDeletable = this.getIEmployeePM().assessableEE(null, this);
            }
        }
        if (notDeletable) {
            throw PlantExceptionMapper.makeAssessableNotDeletableDomainException();
        }
    }

    public PersonnelTimedPersistenceObject createNew() {
        CTConsolidation[] ctcArray;
        PlantSettings result = new PlantSettings(this.mPlant);
        result.mEffectiveFrom = this.getEffectiveFrom();
        result.mEffectiveUntil = this.getEffectiveUntil();
        result.mValidFrom = this.getValidFrom();
        result.mValidUntil = this.getValidUntil();
        result.mSettings = this.getSettings();
        if (this.mNewConsolidations != null) {
            ctcArray = new CTConsolidation[this.mNewConsolidations.length];
            for (int i = 0; i < this.mNewConsolidations.length; ++i) {
                ctcArray[i] = this.mNewConsolidations[i].createNew(result);
            }
        } else {
            ctcArray = new CTConsolidation[this.getCtConsolidations().length];
            for (int i = 0; i < this.getCtConsolidations().length; ++i) {
                ctcArray[i] = this.getCtConsolidations()[i].createNew(result);
            }
        }
        result.mConsolidations = ctcArray;
        return result;
    }

    public Plant getPlant() {
        this.requireLoaded();
        return this.mPlant;
    }

    public void setPlant(Plant plant) {
        this.mPlant = plant;
    }

    public CTConsolidation[] getCtConsolidations() {
        this.requireLoaded();
        return this.mConsolidations;
    }

    public void setCtConsolidations(CTConsolidation[] ctc) {
        this.mNewConsolidations = ctc;
    }

    public Settings getSettings() {
        this.requireLoaded();
        return this.mSettings;
    }

    public void setSettings(Settings settings) {
        this.protocol("CompanySettings.Settings.Assessable", this.mSettings == null ? null : BooleanMapper.toString((boolean)this.mSettings.getAssessable()), settings == null ? null : BooleanMapper.toString((boolean)settings.getAssessable()));
        this.protocol("CompanySettings.Settings.RateAssessmentAccomplishingHealthFund", (IPersistentObject)(this.mSettings == null ? null : (this.mSettings.getRateAssessmentAccomplishingHealthFund() == null ? null : this.mSettings.getRateAssessmentAccomplishingHealthFund())), (IPersistentObject)(settings == null ? null : (settings.getRateAssessmentAccomplishingHealthFund() == null ? null : settings.getRateAssessmentAccomplishingHealthFund())));
        this.protocol("CompanySettings.Settings.AnnualIncomeTaxReturn", this.mSettings == null ? null : BooleanMapper.toString((boolean)this.mSettings.getAnnualIncomeTaxReturn()), settings == null ? null : BooleanMapper.toString((boolean)settings.getAnnualIncomeTaxReturn()));
        this.protocol("CompanySettings.Settings.LawArea", this.mSettings == null ? null : this.mSettings.getLawArea(), settings == null ? null : settings.getLawArea());
        this.protocol("CompanySettings.Settings.DutyOfEntrainmentSocialInsuranceIDCard", this.mSettings == null ? null : BooleanMapper.toString((boolean)this.mSettings.getPromptDEUVAccount()), settings == null ? null : BooleanMapper.toString((boolean)settings.getPromptDEUVAccount()));
        this.mSettings = settings;
    }

    public final void makeSaveable() {
        super.makeSaveable();
        if (this.mConsolidations != null) {
            for (int i = 0; i < this.mConsolidations.length; ++i) {
                this.mConsolidations[i].makeSaveable();
            }
        }
    }

    public final void makeReadOnly() {
        int i;
        super.makeReadOnly();
        for (i = 0; i < this.mConsolidations.length; ++i) {
            this.mConsolidations[i].makeReadOnly();
        }
        if (this.mNewConsolidations != null) {
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].makeReadOnly();
            }
        }
    }

    public void registerForLastExecute() {
        int i;
        super.registerForLastExecute();
        if (this.mConsolidations != null) {
            for (i = 0; i < this.mConsolidations.length; ++i) {
                this.mConsolidations[i].registerForLastExecute();
            }
        }
        if (this.mNewConsolidations != null) {
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].registerForLastExecute();
            }
        }
    }

    public void firstExecuteImpl() throws BusinessDomainException {
        if (this.mNewConsolidations != null) {
            int i;
            if (this.getCtConsolidations() != null) {
                for (i = 0; i < this.getCtConsolidations().length; ++i) {
                    this.mConsolidations[i].makeSaveable();
                    this.mConsolidations[i].unregisterLastExecute();
                    this.mConsolidations[i].destroy();
                }
            }
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].makeSaveable();
                this.mNewConsolidations[i].registerForLastExecute();
            }
        }
    }

    public void compareToOld(PlantSettings old) {
        if (old == null) {
            return;
        }
        this.mOld = old;
        if (old.getSettings().getAssessable() != this.mSettings.getAssessable()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.getSettings().getRateAssessmentAccomplishingHealthFund(), (IPersistentObject)this.mSettings.getRateAssessmentAccomplishingHealthFund())) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getAnnualIncomeTaxReturn() != this.mSettings.getAnnualIncomeTaxReturn()) {
            this.setValuateNeeded(true);
            return;
        }
        if (StringMapper.compareTo((String)old.getSettings().getLawArea(), (String)this.mSettings.getLawArea()) != 0) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getCtConsolidations().length != this.mNewConsolidations.length) {
            this.setValuateNeeded(true);
            return;
        }
        for (int i = 0; i < old.getCtConsolidations().length; ++i) {
            if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.getCtConsolidations()[i].getLumpSumIncomeTax(), (IPersistentObject)this.mNewConsolidations[i].getLumpSumIncomeTax())) {
                this.setValuateNeeded(true);
                return;
            }
            if (StringMapper.compareTo((String)ModeOfProcedureEnumMapper.toString((ModeOfProcedureEnum)old.getCtConsolidations()[i].getModeOfProcedureEnum()), (String)ModeOfProcedureEnumMapper.toString((ModeOfProcedureEnum)this.mNewConsolidations[i].getModeOfProcedureEnum())) == 0) continue;
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getPensionshemeSettingsEnum().value() != this.mSettings.getPensionshemeSettingsEnum().value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getInsolvencyAssessable() != this.mSettings.getInsolvencyAssessable()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getSettings().getMinLaborUtilizationRate(), (BigDecimal)this.mSettings.getMinLaborUtilizationRate())) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getSettings().getMaxlLaborUtilizationRate(), (BigDecimal)this.mSettings.getMaxlLaborUtilizationRate())) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getZvkSettings().value() != this.mSettings.getZvkSettings().value()) {
            this.setValuateNeeded(true);
            return;
        }
    }

    public String getRootDomainKey() {
        return this.getPlant().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Betriebsst\u00e4tte - Einstellungen";
    }

    public void checkCTConsolidations() {
        block13: {
            int i;
            boolean find;
            LumpSumIncomeTax tax;
            block12: {
                int i2;
                int i3;
                if (this.mNewConsolidations.length == 0) {
                    return;
                }
                tax = null;
                try {
                    tax = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen);
                }
                catch (Exception e) {
                    return;
                }
                find = false;
                if (!DateHelper.before((Date)this.getValidFrom(), (Date)new VDate(2007, 0, 1).getDate())) break block12;
                for (i3 = 0; i3 < this.mNewConsolidations.length; ++i3) {
                    if (this.mNewConsolidations[i3].getLumpSumIncomeTax().getTypeOfConsolidation() != ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                    find = true;
                }
                if (!find) break block13;
                for (i3 = 0; i3 < this.mNewConsolidations.length; ++i3) {
                    this.mNewConsolidations[i3].makeReadOnly();
                }
                CTConsolidation[] consolidations = new CTConsolidation[this.mNewConsolidations.length - 1];
                int j = 0;
                for (i2 = 0; i2 < this.mNewConsolidations.length; ++i2) {
                    if (this.mNewConsolidations[i2].getLumpSumIncomeTax().getTypeOfConsolidation() == ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                    consolidations[j] = this.mNewConsolidations[i2];
                    ++j;
                }
                this.mNewConsolidations = consolidations;
                for (i2 = 0; i2 < this.mNewConsolidations.length; ++i2) {
                    this.mNewConsolidations[i2].registerForLastExecute();
                }
                break block13;
            }
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                if (this.mNewConsolidations[i].getLumpSumIncomeTax().getTypeOfConsolidation() != ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                find = true;
            }
            if (!find) {
                int i4;
                for (i = 0; i < this.mNewConsolidations.length; ++i) {
                    this.mNewConsolidations[i].makeReadOnly();
                }
                CTConsolidation[] consolidations = new CTConsolidation[this.mNewConsolidations.length + 1];
                for (i4 = 0; i4 < this.mNewConsolidations.length; ++i4) {
                    if (this.mNewConsolidations[i4].getLumpSumIncomeTax().getTypeOfConsolidation() == ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                    consolidations[i4] = this.mNewConsolidations[i4];
                }
                consolidations[this.mNewConsolidations.length] = new CTConsolidation(this);
                consolidations[this.mNewConsolidations.length].setLumpSumIncomeTax(tax);
                consolidations[this.mNewConsolidations.length].setModeOfProcedureEnum(ModeOfProcedureEnum.MOPE_Nachweisverfahren);
                this.mNewConsolidations = consolidations;
                for (i4 = 0; i4 < this.mNewConsolidations.length; ++i4) {
                    this.mNewConsolidations[i4].registerForLastExecute();
                }
            }
        }
    }

    public void checkChangeOfAnnualIncomeTaxReturn() throws BusinessDomainException {
        if (this.mOld == null) {
            return;
        }
        Date minJournalizedUntil = this.getEmploymentPM().getMaxJournalizedUntil(this.mPlant);
        if (minJournalizedUntil == null) {
            return;
        }
        int monthOfJournalizedUntil = new VDate(minJournalizedUntil).getMonth();
        int yearOfJournalizedUntil = new VDate(minJournalizedUntil).getYear();
        int yearOfValidFrom = new VDate(this.mValidFrom).getYear();
        if (this.mOld.getSettings().getAnnualIncomeTaxReturn() != this.getSettings().getAnnualIncomeTaxReturn()) {
            if (monthOfJournalizedUntil == 0 && yearOfValidFrom < yearOfJournalizedUntil - 1) {
                throw CompanyPlantExceptionMapper.makeChangeOfAnnualIncomeTaxReturnNotAllowedDomainException();
            }
            if (monthOfJournalizedUntil > 0 && yearOfValidFrom < yearOfJournalizedUntil) {
                throw CompanyPlantExceptionMapper.makeChangeOfAnnualIncomeTaxReturnNotAllowedDomainException();
            }
        }
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private IEmploymentPersistencyManager getEmploymentPM() {
        return (IEmploymentPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("employmentPersistencyManager", IEmploymentPersistencyManager.class);
    }
}

