/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pcompany.settings;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.framework.domain.correspondencetext.CorrespondenceText;
import com.varial.framework.domain.correspondencetext.CorrespondenceTextPersistencyManager;
import com.varial.personnel.domain.companyplant.AssessmentDutyEnum;
import com.varial.personnel.domain.companyplant.PensionschemeSettingsEnum;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.companyplant.mapper.PensionschemeSettingsEnumMapper;
import com.varial.personnel.domain.companyplant.mapper.ZvkSettingsEnumMapper;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModel;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModelPersistencyManager;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CauseOfJournalizingEnum;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.pcompany.settings.CorrectionEnum;
import com.varial.personnel.domain.pcompany.settings.ctconsolidation.CTConsolidation;
import com.varial.personnel.domain.pcompany.settings.ctconsolidation.CTConsolidationPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.mapper.CauseOfJournalizingEnumMapper;
import com.varial.personnel.domain.pcompany.settings.mapper.CorrectionEnumMapper;
import com.varial.personnel.persistency.company.companysettings.CompanysettingsContainer;
import com.varial.personnel.persistency.company.companysettings.ICompanysettingsDao;
import com.varial.personnel.persistency.company.compsettingsall.CompsettingsallContainer;
import com.varial.personnel.persistency.company.compsettingsall.ICompsettingsallDao;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGenerator;
import java.util.Date;

public class CompanySettingsPersistencyManager {
    private static ICompsettingsallDao daoall = (ICompsettingsallDao)UtilitiesManager.getApplicationContext().getBean("compsettingsallDao");
    private static ICompanysettingsDao dao = (ICompanysettingsDao)UtilitiesManager.getApplicationContext().getBean("companysettingsDao");

    public static CompanySettings[] getCompanySettingsHistory(PCompany pc) {
        return CompanySettingsPersistencyManager.query(null, Restrictions.eq((String)"oidpcompany", (String)pc.getObjectid()), pc);
    }

    public static CompanySettings[] query(Order[] sortierung, Criterion filters, PCompany pc) {
        try {
            CompanysettingsContainer[] containers = dao.getRows(sortierung, filters);
            int count = containers.length;
            CompanySettings[] result = new CompanySettings[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new CompanySettings(pc, true);
                CompanySettingsPersistencyManager.fillCompanySettings(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static CompanySettings[] query(Order[] sortierung, Criterion filters) {
        try {
            CompanysettingsContainer[] containers = dao.getRows(sortierung, filters);
            int count = containers.length;
            CompanySettings[] result = new CompanySettings[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new CompanySettings(PCompanyPersistencyManager.getPCompany((String)containers[i].oidpcompany), true);
                CompanySettingsPersistencyManager.fillCompanySettings(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static CompanySettings[] queryAll(Order[] sortierung, Criterion filters) {
        try {
            CompsettingsallContainer[] containers = daoall.getRows(sortierung, filters);
            int count = containers.length;
            CompanySettings[] result = new CompanySettings[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new CompanySettings(PCompanyPersistencyManager.getPCompany((String)containers[i].oidpcompany), true);
                CompanySettingsPersistencyManager.fillCompanySettings(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void load(CompanySettings cs) {
        CompanysettingsContainer container = null;
        try {
            container = dao.getRowByObjectID(cs.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)cs.getObjectid());
        }
        CompanySettingsPersistencyManager.fillCompanySettings(cs, container);
    }

    public static void save(CompanySettings cs) {
        CompanysettingsContainer container = dao.getInitializedInstance();
        CompanySettingsPersistencyManager.fillContainer(container, cs);
        try {
            container = cs.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        cs.setLastuser(container.getLastUserid());
        cs.setObjectid(container.getObjectid());
        cs.setTimestamp(container.getObjectTS());
        cs.setVersion(container.getVersion());
    }

    public static void delete(CompanySettings cs) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), cs.getObjectid(), cs.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static Date getStartOfHistory(String oidPCompany) {
        try {
            SelectGenerator selector = new SelectGenerator("companysettings_t", new String[]{"min(validfrom)"}, null, Restrictions.eq((String)"oidpcompany", (String)oidPCompany), null, false, Date.class, new String[]{""});
            Date result = null;
            Date[] d = (Date[])selector.select();
            if (d[0] != null) {
                result = d[0];
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static void fillCompanySettings(CompanySettings cs, CompanysettingsContainer container) {
        cs.setLastuser(container.getLastUserid());
        cs.setObjectid(container.getObjectid());
        cs.setTimestamp(container.getObjectTS());
        cs.setVersion(container.getVersion());
        if (cs.getPCompany() == null) {
            cs.setPCompany(PCompanyPersistencyManager.getPCompany((String)container.oidpcompany));
        }
        DEUVSender sender = null;
        if (!StringMapper.isNullString((String)container.oiddeuvsender)) {
            sender = DEUVSender.getDEUVSender((String)container.oiddeuvsender);
        }
        HealthFund healthFund = null;
        if (container.oidhfforassessment != null && !StringMapper.isNullString((String)container.oidhfforassessment)) {
            healthFund = HealthFundPersistencyManager.getHealthFund((String)container.oidhfforassessment);
        }
        AgePartTimeModel agePartTimeModel = null;
        if (!StringMapper.isNullString((String)container.oidparttimemodel)) {
            agePartTimeModel = AgePartTimeModelPersistencyManager.getAgePartTimeModel((String)container.oidparttimemodel);
        }
        CorrespondenceText textregistry = null;
        if (!StringMapper.isNullString((String)container.oidtextregistry)) {
            textregistry = CorrespondenceTextPersistencyManager.getCorrespondenceText((String)container.oidtextregistry);
        }
        CorrespondenceText textresetpwd = null;
        if (!StringMapper.isNullString((String)container.oidtextresetpwd)) {
            textresetpwd = CorrespondenceTextPersistencyManager.getCorrespondenceText((String)container.oidtextresetpwd);
        }
        CorrespondenceText textreminder = null;
        if (!StringMapper.isNullString((String)container.oidtextreminder)) {
            textreminder = CorrespondenceTextPersistencyManager.getCorrespondenceText((String)container.oidtextreminder);
        }
        Settings settings = new Settings(container.assessable, healthFund, container.annincometaxreturn, container.lawarea, container.dutyofsiidcard, agePartTimeModel, PensionschemeSettingsEnumMapper.toPensionschemeSettingsEnum((int)container.pensschemesetting), container.insolvencyass, container.minlaborutilrate, container.maxlaborutilrate, container.erpaysnisurcharge, ZvkSettingsEnumMapper.toZvkSettingsEnum((int)container.typeofzvksettings), AssessmentDutyEnum.toAssessmentDutyEnum((int)container.assessmentduty));
        CTConsolidation[] ctc = null;
        ctc = CTConsolidationPersistencyManager.getCTConsolidations((CompanySettings)cs);
        cs.setData(container.effectivefrom, container.effectiveuntil, container.validfrom, container.validuntil, settings, container.useemployeecircle, container.useemployeegroup, container.useemploymentgroup, container.uselocation, container.usecostcenter, container.usecostunit, container.usedepartment, container.useoffice, container.useorgunit, container.usepersonincharge1, container.usepersonincharge2, container.usepersonincharge3, sender, container.useplants, container.firstddcalculation, CauseOfJournalizingEnumMapper.toCauseOfJournalizingEnum((int)container.causejournalizing), CorrectionEnumMapper.toCorrectionEnum((int)container.correctionsoe), container.eecircleonsoe, container.eegrouponsoe, container.eetgrouponsoe, container.departmentonsoe, container.officeonsoe, container.organizatunitonsoe, container.locationonsoe, container.costcenteronsoe, container.costunitonsoe, container.persincharge1onsoe, container.persincharge2onsoe, container.persincharge3onsoe, container.recalculationcccu, container.demarcation, container.shiftscheduleonsoe, container.payscaleonsoe, container.leaveaccountsonsoe, container.breakperiodsonsoe, container.runningtotalonsoe, container.deductionsonsoe, container.garnishmentsonsoe, container.loansonsoe, container.auxiliarycuonsoe, container.childrenonsoe, ctc, container.persnumberonsoe, container.dueswithprevmonth, container.inclusionbavinatz, container.socpercompany, container.printplant, container.printemployeecircl, container.printemployeegroup, container.printemploymentgro, container.printcostcenter, container.printcostunit, container.printdepartment, container.printorgunit, container.printpersonic1, container.printpersonic2, container.servicemaster, container.serviceeeralitive, container.servicedisability, container.serviceeework, container.servicetaxandinsur, container.serviceholiday, container.serviceabsenttime, container.servicecertificate, container.relativeofearnings, container.salaryatjournalize, container.emailaddresssender, container.expiryinminutes, textregistry, textresetpwd, textreminder, container.usemfa);
    }

    private static void fillCompanySettings(CompanySettings cs, CompsettingsallContainer container) {
        cs.setLastuser(container.getLastUserid());
        cs.setObjectid(container.getObjectid());
        cs.setTimestamp(container.getObjectTS());
        cs.setVersion(container.getVersion());
        if (cs.getPCompany() == null) {
            cs.setPCompany(PCompanyPersistencyManager.getPCompany((String)container.oidpcompany));
        }
        DEUVSender sender = null;
        if (!StringMapper.isNullString((String)container.oiddeuvsender)) {
            sender = DEUVSender.getDEUVSender((String)container.oiddeuvsender);
        }
        HealthFund healthFund = null;
        if (container.oidhfforassessment != null && !StringMapper.isNullString((String)container.oidhfforassessment)) {
            healthFund = HealthFundPersistencyManager.getHealthFund((String)container.oidhfforassessment);
        }
        AgePartTimeModel agePartTimeModel = null;
        if (!StringMapper.isNullString((String)container.oidparttimemodel)) {
            agePartTimeModel = AgePartTimeModelPersistencyManager.getAgePartTimeModel((String)container.oidparttimemodel);
        }
        CorrespondenceText textregistry = null;
        if (!StringMapper.isNullString((String)container.oidtextregistry)) {
            textregistry = CorrespondenceTextPersistencyManager.getCorrespondenceText((String)container.oidtextregistry);
        }
        CorrespondenceText textresetpwd = null;
        if (!StringMapper.isNullString((String)container.oidtextresetpwd)) {
            textresetpwd = CorrespondenceTextPersistencyManager.getCorrespondenceText((String)container.oidtextresetpwd);
        }
        CorrespondenceText textreminder = null;
        if (!StringMapper.isNullString((String)container.oidtextreminder)) {
            textreminder = CorrespondenceTextPersistencyManager.getCorrespondenceText((String)container.oidtextreminder);
        }
        Settings settings = new Settings(container.assessable, healthFund, container.annincometaxreturn, container.lawarea, container.dutyofsiidcard, agePartTimeModel, PensionschemeSettingsEnumMapper.toPensionschemeSettingsEnum((int)container.pensschemesetting), container.insolvencyass, container.minlaborutilrate, container.maxlaborutilrate, container.erpaysnisurcharge, ZvkSettingsEnumMapper.toZvkSettingsEnum((int)container.typeofzvksettings), AssessmentDutyEnum.toAssessmentDutyEnum((int)container.assessmentduty));
        CTConsolidation[] ctc = null;
        ctc = CTConsolidationPersistencyManager.getCTConsolidations((CompanySettings)cs);
        cs.setData(container.effectivefrom, container.effectiveuntil, container.validfrom, container.validuntil, settings, container.useemployeecircle, container.useemployeegroup, container.useemploymentgroup, container.uselocation, container.usecostcenter, container.usecostunit, container.usedepartment, container.useoffice, container.useorgunit, container.usepersonincharge1, container.usepersonincharge2, container.usepersonincharge3, sender, container.useplants, container.firstddcalculation, CauseOfJournalizingEnumMapper.toCauseOfJournalizingEnum((int)container.causejournalizing), CorrectionEnumMapper.toCorrectionEnum((int)container.correctionsoe), container.eecircleonsoe, container.eegrouponsoe, container.eetgrouponsoe, container.departmentonsoe, container.officeonsoe, container.organizatunitonsoe, container.locationonsoe, container.costcenteronsoe, container.costunitonsoe, container.persincharge1onsoe, container.persincharge2onsoe, container.persincharge3onsoe, container.recalculationcccu, container.demarcation, container.shiftscheduleonsoe, container.payscaleonsoe, container.leaveaccountsonsoe, container.breakperiodsonsoe, container.runningtotalonsoe, container.deductionsonsoe, container.garnishmentsonsoe, container.loansonsoe, container.auxiliarycuonsoe, container.childrenonsoe, ctc, container.persnumberonsoe, container.dueswithprevmonth, container.inclusionbavinatz, container.socpercompany, container.printplant, container.printemployeecircl, container.printemployeegroup, container.printemploymentgro, container.printcostcenter, container.printcostunit, container.printdepartment, container.printorgunit, container.printpersonic1, container.printpersonic2, container.servicemaster, container.serviceeeralitive, container.servicedisability, container.serviceeework, container.servicetaxandinsur, container.serviceholiday, container.serviceabsenttime, container.servicecertificate, container.relativeofearnings, container.salaryatjournalize, container.emailaddresssender, container.expiryinminutes, textregistry, textresetpwd, textreminder, container.usemfa);
    }

    private static void fillContainer(CompanysettingsContainer container, CompanySettings cs) {
        container.setObjectid(cs.getObjectid());
        container.setObjectTS(cs.getTimestamp());
        container.setLastUserid(cs.getLastuser());
        container.setVersion(cs.getVersion());
        container.oidpcompany = cs.getPCompany().getObjectid();
        container.effectivefrom = cs.getEffectiveFrom();
        container.effectiveuntil = cs.getEffectiveUntil();
        container.validfrom = cs.getValidFrom();
        container.validuntil = cs.getValidUntil();
        container.oidhfforassessment = cs.getSettings().getRateAssessmentAccomplishingHealthFund() == null ? "" : cs.getSettings().getRateAssessmentAccomplishingHealthFund().getObjectid();
        container.lawarea = cs.getSettings().getLawArea();
        container.dutyofsiidcard = cs.getSettings().getPromptDEUVAccount();
        container.annincometaxreturn = cs.getSettings().getAnnualIncomeTaxReturn();
        container.useemployeecircle = cs.getUseEmployeeCircle();
        container.uselocation = cs.getUseLocation();
        container.usecostcenter = cs.getUseCostCenter();
        container.usecostunit = cs.getUseCostUnit();
        container.usedepartment = cs.getUseDepartment();
        container.useoffice = cs.getUseOffice();
        container.useorgunit = cs.getUseOrgUnit();
        container.usepersonincharge1 = cs.getUsePersonInCharge1();
        container.usepersonincharge2 = cs.getUsePersonInCharge2();
        container.usepersonincharge3 = cs.getUsePersonInCharge3();
        container.useorgunit = cs.getUseOrgUnit();
        container.oiddeuvsender = cs.getDEUVSender() == null ? "" : cs.getDEUVSender().getObjectid();
        container.useplants = cs.getUsePlants();
        container.firstddcalculation = cs.getVeryFirstDayOfCalculation();
        container.causejournalizing = CauseOfJournalizingEnumMapper.toInt((CauseOfJournalizingEnum)cs.getCauseOfJournalizing());
        container.correctionsoe = CorrectionEnumMapper.toInt((CorrectionEnum)cs.getCorrectionStatementOfEarnings());
        container.eecircleonsoe = cs.getEECircleOnSoE();
        container.departmentonsoe = cs.getDepartmentOnSoE();
        container.officeonsoe = cs.getOfficeOnSoE();
        container.organizatunitonsoe = cs.getOrgUnitOnSoE();
        container.locationonsoe = cs.getLocationOnSoE();
        container.costcenteronsoe = cs.getCostCenterOnSoE();
        container.costunitonsoe = cs.getCostUnitOnSoE();
        container.persincharge1onsoe = cs.getFirstPersonInChargeOnSoE();
        container.persincharge2onsoe = cs.getSecondPersonInChargeOnSoE();
        container.persincharge3onsoe = cs.getThirdPersonInChargeOnSoE();
        container.recalculationcccu = cs.getRecalculationCostCenterCostUnit();
        container.demarcation = cs.getDemarcation();
        container.shiftscheduleonsoe = cs.getShiftScheduleOnSoE();
        container.payscaleonsoe = cs.getPayScaleStatementsAndWagesFactorOnSoE();
        container.leaveaccountsonsoe = cs.getLeaveAccountsOnSoE();
        container.breakperiodsonsoe = cs.getBreakPeriodsOnSoE();
        container.runningtotalonsoe = cs.getStatisticsAndRunningTotalOnSoE();
        container.deductionsonsoe = cs.getDeductionsIncludingTransfersOnSoE();
        container.garnishmentsonsoe = cs.getGarnishmentsOnSoE();
        container.loansonsoe = cs.getLoansOnSoE();
        container.auxiliarycuonsoe = cs.getAuxiliaryCostUnitsOnSoE();
        container.childrenonsoe = cs.getChildrenParticularsOnSoE();
        container.oidparttimemodel = cs.getSettings().getAgePartTimeModel() == null ? "" : cs.getSettings().getAgePartTimeModel().getObjectid();
        container.persnumberonsoe = cs.getPersonnelnumberOnSoE();
        container.useemployeegroup = cs.getUseEmployeeGroup();
        container.useemploymentgroup = cs.getUseEmployeeFunction();
        container.eegrouponsoe = cs.getEEGroupOnSoE();
        container.eetgrouponsoe = cs.getEmployeeFunctionOnSoE();
        container.dueswithprevmonth = cs.getPaymentOfContributionWithpreviousMonth();
        container.pensschemesetting = PensionschemeSettingsEnumMapper.toInt((PensionschemeSettingsEnum)cs.getSettings().getPensionshemeSettingsEnum());
        container.inclusionbavinatz = cs.getStipulationToEvaluatePensionshemeInAgePartTime();
        container.minlaborutilrate = cs.getSettings().getMinLaborUtilizationRate();
        container.maxlaborutilrate = cs.getSettings().getMaxlLaborUtilizationRate();
        container.insolvencyass = cs.getSettings().getInsolvencyAssessable();
        container.socpercompany = cs.getStatementOfContributionProCompany();
        container.printplant = cs.getPrintPlant();
        container.printemployeecircl = cs.getPrintEmployeeCircle();
        container.printemployeegroup = cs.getPrintEmployeeGroup();
        container.printemploymentgro = cs.getPrintEmploymentGroup();
        container.printcostcenter = cs.getPrintCostCenter();
        container.printcostunit = cs.getPrintCostUnit();
        container.printdepartment = cs.getPrintDepartment();
        container.printorgunit = cs.getPrintOrgUnit();
        container.printpersonic1 = cs.getPrintPersonInCharge1();
        container.printpersonic2 = cs.getPrintPersonInCharge2();
        container.servicemaster = cs.getServiceMaster();
        container.serviceeeralitive = cs.getServiceEERelative();
        container.servicedisability = cs.getServiceEEDisability();
        container.serviceeework = cs.getServiceEEWork();
        container.servicetaxandinsur = cs.getServiceTaxAndInsurance();
        container.serviceholiday = cs.getServiceEEHolidayYear();
        container.serviceabsenttime = cs.getServiceEEAbsentTime();
        container.servicecertificate = cs.getServiceCertificate();
        container.relativeofearnings = cs.getRelativeOfEarnings();
        container.erpaysnisurcharge = cs.getSettings().getERPaysNISurcharge();
        container.salaryatjournalize = cs.getDevelopOfSalaryHistoryAtJournalize();
        container.typeofzvksettings = ZvkSettingsEnumMapper.toInt((ZvkSettingsEnum)cs.getSettings().getZvkSettings());
        container.emailaddresssender = cs.getEmailaddressOfServiceSender();
        container.expiryinminutes = cs.getExpiryInMinutes();
        container.oidtextregistry = cs.getTextForServiceRegistry() == null ? "" : cs.getTextForServiceRegistry().getObjectid();
        container.oidtextresetpwd = cs.getTextForServicePwdReset() == null ? "" : cs.getTextForServicePwdReset().getObjectid();
        container.oidtextreminder = cs.getTextForServiceReminder() == null ? "" : cs.getTextForServiceReminder().getObjectid();
        container.usemfa = cs.getUseMfaForService();
        container.assessmentduty = AssessmentDutyEnum.toInt((AssessmentDutyEnum)cs.getSettings().getAssessmentDuty());
        if (cs.getSettings().getAssessmentDuty() == AssessmentDutyEnum.KEINE || cs.getSettings().getAssessmentDuty() == AssessmentDutyEnum.U2) {
            container.assessable = false;
        }
        if (cs.getSettings().getAssessmentDuty() == AssessmentDutyEnum.U1_UND_U2) {
            container.assessable = true;
        }
        container.economicsector = 0;
        container.additionaldate = null;
        container.additionalamount = null;
        container.additionalstring = "";
        container.additionaloid = "";
        container.additionalboolean = false;
        container.additionalint = 0;
        container.additionalenum = 0;
    }
}

