/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pcompany.settings;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.correspondencetext.CorrespondenceText;
import com.varial.personnel.domain.companyplant.ModeOfProcedureEnum;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.companyplant.mapper.CompanyPlantExceptionMapper;
import com.varial.personnel.domain.companyplant.mapper.ModeOfProcedureEnumMapper;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.personnel.domain.global.lumpsumitax.LumpSumIncomeTax;
import com.varial.personnel.domain.pcompany.IPCompanyReferenced;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.mapper.PCompanyExceptionMapper;
import com.varial.personnel.domain.pcompany.settings.CauseOfJournalizingEnum;
import com.varial.personnel.domain.pcompany.settings.CompanySettingsPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CorrectionEnum;
import com.varial.personnel.domain.pcompany.settings.ctconsolidation.CTConsolidation;
import com.varial.personnel.domain.pcompany.settings.mapper.CauseOfJournalizingEnumMapper;
import com.varial.personnel.domain.pcompany.settings.mapper.CorrectionEnumMapper;
import com.varial.personnel.domain.plant.settings.PlantSettings;
import com.varial.personnel.domain.plant.settings.PlantSettingsPersistencyManager;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.checkup.EMailAddress;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.personnel.isoft.LicenseCodesPayroll;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanySettings
extends PersonnelTimedPersistenceObject
implements IPCompanyReferenced {
    private static Logger LOGGER = LoggerFactory.getLogger((String)CompanySettings.class.getName());
    private static final int PRIORITY = 2;
    private PCompany mPCompany;
    private Settings mSettings;
    private boolean mUseEmployeeCircle;
    private boolean mUseLocation;
    private boolean mUseCostCenter;
    private boolean mUseCostUnit;
    private boolean mUseDepartment;
    private boolean mUseOffice;
    private boolean mUseOrgUnit;
    private boolean mUsePersonInCharge1;
    private boolean mUsePersonInCharge2;
    private boolean mUsePersonInCharge3;
    private DEUVSender mDEUVSender;
    private boolean mUsePlants;
    private int mVeryFirstDayOfCalculation;
    private CauseOfJournalizingEnum mCauseOfJournalizing;
    private CorrectionEnum mCorrectionStatementOfEarnings;
    private boolean mEECircleOnSoE;
    private boolean mDepartmentOnSoE;
    private boolean mOfficeOnSoE;
    private boolean mOrgUnitOnSoE;
    private boolean mLocationOnSoE;
    private boolean mCostCenterOnSoE;
    private boolean mCostUnitOnSoE;
    private boolean mFirstPersonInChargeOnSoE;
    private boolean mSecondPersonInChargeOnSoE;
    private boolean mThirdPersonInChargeOnSoE;
    private boolean mRecalculationCostCenterCostUnit;
    private boolean mDemarcation;
    private boolean mShiftScheduleOnSoE;
    private boolean mPayScaleStatementsAndWagesFactorOnSoE;
    private boolean mLeaveAccountsOnSoE;
    private boolean mBreakPeriodsOnSoE;
    private boolean mStatisticsAndRunningTotalOnSoE;
    private boolean mDeductionsIncludingTransfersOnSoE;
    private boolean mGarnishmentsOnSoE;
    private boolean mLoansOnSoE;
    private boolean mAuxiliaryCostUnitsOnSoE;
    private boolean mChildrenParticularsOnSoE;
    private CTConsolidation[] mConsolidations;
    private CTConsolidation[] mNewConsolidations;
    private boolean mPersonnelnumberOnSoE;
    private boolean mUseEmployeeGroup;
    private boolean mUseEmployeeFunction;
    private boolean mEEGroupOnSoE;
    private boolean mEmployeeFunctionOnSoE;
    private boolean mPaymentOfContributionWithpreviousMonth;
    private boolean mStipulationToEvaluatePensionshemeInAgePartTime;
    private boolean mStatementOfContributionProCompany;
    private boolean mPrintPlant;
    private boolean mPrintEmployeeCircle;
    private boolean mPrintEmployeeGroup;
    private boolean mPrintEmploymentGroup;
    private boolean mPrintCostCenter;
    private boolean mPrintCostUnit;
    private boolean mPrintDepartment;
    private boolean mPrintOrgUnit;
    private boolean mPrintPersonInCharge1;
    private boolean mPrintPersonInCharge2;
    private boolean mServiceMaster;
    private boolean mServiceEERelative;
    private boolean mServiceEEDisability;
    private boolean mServiceEEWork;
    private boolean mServiceTaxAndInsurance;
    private boolean mServiceEEHolidayYear;
    private boolean mServiceEEAbsentTime;
    private boolean mServiceCertificate;
    private boolean mRelativeOfEarnings;
    private boolean mDevelopOfSalaryHistoryAtJournalize;
    private String mEmailaddressOfServiceSender;
    private int mExpiryInMinutes;
    private CorrespondenceText mTextForServiceRegistry;
    private CorrespondenceText mTextForServicePwdReset;
    private CorrespondenceText mTextForServiceReminder;
    private boolean mUseMfaForService;
    CompanySettings mOld = null;

    public CompanySettings(PCompany pCompany) {
        super(2);
        this.mPCompany = pCompany;
    }

    private CompanySettings(String objectID) {
        super(2, objectID);
    }

    public CompanySettings(String objectID, int version) {
        super(2, objectID, version);
    }

    protected CompanySettings(boolean readOnly) {
        super(2, readOnly);
    }

    protected CompanySettings(PCompany pCompany, boolean readOnly) {
        super(2, readOnly);
        this.mPCompany = pCompany;
    }

    public static CompanySettings getCompanySettings(String objectID) {
        return new CompanySettings(objectID);
    }

    protected void load() {
        CompanySettingsPersistencyManager.load(this);
    }

    protected void saveImpl() {
        CompanySettingsPersistencyManager.save(this);
    }

    protected void deleteImpl() {
        CompanySettingsPersistencyManager.delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.mPCompany.getDomainKey() + " / " + DateMapper.toString((Date)this.mEffectiveFrom) + " / " + DateMapper.toString((Date)this.mValidFrom);
    }

    public void setData(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, Settings settings, boolean useEmployeeCircle, boolean useEmployeeGroup, boolean useEmployeeFunction, boolean useLocation, boolean useCostCenter, boolean useCostUnit, boolean useDepartment, boolean useOffice, boolean useOrgUnit, boolean usePersonInCharge1, boolean usePersonInCharge2, boolean usePersonInCharge3, DEUVSender deuvSender, boolean usePlants, int veryFirstDayOfCalculation, CauseOfJournalizingEnum causeOfJournalizing, CorrectionEnum correctionStatementOfEarnings, boolean eECircleOnSoE, boolean eEGroupOnSoE, boolean employeeFunctionOnSoE, boolean departmentOnSoE, boolean officeOnSoE, boolean orgUnitOnSoE, boolean locationOnSoE, boolean costCenterOnSoE, boolean costUnitOnSoE, boolean firstPersonInChargeOnSoE, boolean secondPersonInChargeOnSoE, boolean thirdPersonInChargeOnSoE, boolean recalculationCostCenterCostUnit, boolean demarcation, boolean shiftScheduleOnSoE, boolean payScaleStatementsAndWagesFactorOnSoE, boolean leaveAccountsOnSoE, boolean breakPeriodsOnSoE, boolean statisticsAndRunningTotalOnSoE, boolean deductionsIncludingTransfersOnSoE, boolean garnishmentsOnSoE, boolean loansOnSoE, boolean auxiliaryCostUnitsOnSoE, boolean childrenParticularsOnSoE, CTConsolidation[] ctConsolidations, boolean personnelnumberOnSoE, boolean paymentOfContributionWithpreviousMonth, boolean stipulationToEvaluatePensionshemeInAgePartTime, boolean statementOfContributionProCompany, boolean printPlant, boolean printEmployeeCircle, boolean printEmployeeGroup, boolean printEmploymentGroup, boolean printCostCenter, boolean printCostUnit, boolean printDepartment, boolean printOrgUnit, boolean printPersonInCharge1, boolean printPersonInCharge2, boolean serviceMaster, boolean serviceEERelative, boolean serviceEEDisability, boolean serviceEEWork, boolean serviceTaxAndInsurance, boolean serviceEEHolidayYear, boolean serviceEEAbsentTime, boolean serviceCertificate, boolean relativeOfEarnings, boolean developOfSalaryHistoryAtJournalize, String emailaddressOfServiceSender, int expiryInMinutes, CorrespondenceText textForServiceRegistry, CorrespondenceText textForServicePwdReset, CorrespondenceText textForServiceReminder, boolean useMfaForService) {
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mSettings = settings;
        this.mUseEmployeeCircle = useEmployeeCircle;
        this.mUseEmployeeGroup = useEmployeeGroup;
        this.mUseEmployeeFunction = useEmployeeFunction;
        this.mUseLocation = useLocation;
        this.mUseCostCenter = useCostCenter;
        this.mUseCostUnit = useCostUnit;
        this.mUseDepartment = useDepartment;
        this.mUseOffice = useOffice;
        this.mUseOrgUnit = useOrgUnit;
        this.mUsePersonInCharge1 = usePersonInCharge1;
        this.mUsePersonInCharge2 = usePersonInCharge2;
        this.mUsePersonInCharge3 = usePersonInCharge3;
        this.mDEUVSender = deuvSender;
        this.mUsePlants = usePlants;
        this.mVeryFirstDayOfCalculation = veryFirstDayOfCalculation;
        this.mCauseOfJournalizing = causeOfJournalizing;
        this.mCorrectionStatementOfEarnings = correctionStatementOfEarnings;
        this.mEECircleOnSoE = eECircleOnSoE;
        this.mEEGroupOnSoE = eEGroupOnSoE;
        this.mEmployeeFunctionOnSoE = employeeFunctionOnSoE;
        this.mDepartmentOnSoE = departmentOnSoE;
        this.mOfficeOnSoE = officeOnSoE;
        this.mOrgUnitOnSoE = orgUnitOnSoE;
        this.mLocationOnSoE = locationOnSoE;
        this.mCostCenterOnSoE = costCenterOnSoE;
        this.mCostUnitOnSoE = costUnitOnSoE;
        this.mFirstPersonInChargeOnSoE = firstPersonInChargeOnSoE;
        this.mSecondPersonInChargeOnSoE = secondPersonInChargeOnSoE;
        this.mThirdPersonInChargeOnSoE = thirdPersonInChargeOnSoE;
        this.mRecalculationCostCenterCostUnit = recalculationCostCenterCostUnit;
        this.mDemarcation = demarcation;
        this.mShiftScheduleOnSoE = shiftScheduleOnSoE;
        this.mPayScaleStatementsAndWagesFactorOnSoE = payScaleStatementsAndWagesFactorOnSoE;
        this.mLeaveAccountsOnSoE = leaveAccountsOnSoE;
        this.mBreakPeriodsOnSoE = breakPeriodsOnSoE;
        this.mStatisticsAndRunningTotalOnSoE = statisticsAndRunningTotalOnSoE;
        this.mDeductionsIncludingTransfersOnSoE = deductionsIncludingTransfersOnSoE;
        this.mGarnishmentsOnSoE = garnishmentsOnSoE;
        this.mLoansOnSoE = loansOnSoE;
        this.mAuxiliaryCostUnitsOnSoE = auxiliaryCostUnitsOnSoE;
        this.mChildrenParticularsOnSoE = childrenParticularsOnSoE;
        this.mConsolidations = ctConsolidations;
        this.mPersonnelnumberOnSoE = personnelnumberOnSoE;
        this.mPaymentOfContributionWithpreviousMonth = paymentOfContributionWithpreviousMonth;
        this.mStipulationToEvaluatePensionshemeInAgePartTime = stipulationToEvaluatePensionshemeInAgePartTime;
        this.mStatementOfContributionProCompany = statementOfContributionProCompany;
        this.mPrintPlant = printPlant;
        this.mPrintEmployeeCircle = printEmployeeCircle;
        this.mPrintEmployeeGroup = printEmployeeGroup;
        this.mPrintEmploymentGroup = printEmploymentGroup;
        this.mPrintCostCenter = printCostCenter;
        this.mPrintCostUnit = printCostUnit;
        this.mPrintDepartment = printDepartment;
        this.mPrintOrgUnit = printOrgUnit;
        this.mPrintPersonInCharge1 = printPersonInCharge1;
        this.mPrintPersonInCharge2 = printPersonInCharge2;
        this.mServiceMaster = serviceMaster;
        this.mServiceEERelative = serviceEERelative;
        this.mServiceEEDisability = serviceEEDisability;
        this.mServiceEEWork = serviceEEWork;
        this.mServiceTaxAndInsurance = serviceTaxAndInsurance;
        this.mServiceEEHolidayYear = serviceEEHolidayYear;
        this.mServiceEEAbsentTime = serviceEEAbsentTime;
        this.mServiceCertificate = serviceCertificate;
        this.mRelativeOfEarnings = relativeOfEarnings;
        this.mDevelopOfSalaryHistoryAtJournalize = developOfSalaryHistoryAtJournalize;
        this.mEmailaddressOfServiceSender = emailaddressOfServiceSender;
        this.mExpiryInMinutes = expiryInMinutes;
        this.mTextForServiceRegistry = textForServiceRegistry;
        this.mTextForServicePwdReset = textForServicePwdReset;
        this.mTextForServiceReminder = textForServiceReminder;
        this.mUseMfaForService = useMfaForService;
    }

    public void checkAttributes() throws BusinessDomainException {
        this.checkDates();
        this.requireLoaded();
        Settings settings = null;
        if (this.mOld != null) {
            settings = this.mOld.getSettings();
        }
        this.getSettings().checkAttributes(this.getValidFrom(), settings);
        this.checkEECircleOnSoE();
        this.checkEEGroupOnSoE();
        this.checkEmployeeFunctionOnSoE();
        this.checkCostCenterOnSoE();
        this.checkCostUnitOnSoE();
        this.checkOrgUnitOnSoE();
        this.checkDepartmentOnSoE();
        this.checkLocationOnSoE();
        this.checkFirstPersonInChargeOnSoE();
        this.checkSecondPersonInChargeOnSoE();
        this.checkCTConsolidations();
        this.checkChangeOfAnnualIncomeTaxReturn();
        this.checkPrintsOnSoE();
        this.checkSelfserviceData();
        this.checkInsolvencyAssessable();
        this.getSettings().checkChangeOfAssessmentDuty(true, this.getPCompany().getObjectid(), this.getValidFrom(), settings);
    }

    private void checkInsolvencyAssessable() throws BusinessDomainException {
        CompanyFoundations companyFoundations;
        if (this.getSettings().getInsolvencyAssessable() && ((companyFoundations = (CompanyFoundations)this.getPCompany().getCompanyFoundationsHistory().getItemOrNull(VDate.getDateMax(), this.getValidFrom())).getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || companyFoundations.getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN) && DateHelper.beforeOrEqual((Date)this.getValidFrom(), (Date)companyFoundations.getFoundations().getInsolventlyUntil()) && DateHelper.afterOrEqual((Date)this.getValidUntil(), (Date)companyFoundations.getFoundations().getInsolventlyFrom())) {
            throw PCompanyExceptionMapper.makeInsolvencyAssessableFalseDomainException();
        }
    }

    private void checkSelfserviceData() throws BusinessDomainException {
        if (LicenseCodesPayroll.SELFSERVICE.isLicensed()) {
            if (!(this.mServiceMaster || this.mServiceEERelative || this.mServiceEEDisability || this.mServiceEEWork || this.mServiceTaxAndInsurance || this.mServiceEEHolidayYear || this.mServiceEEAbsentTime || this.mServiceCertificate)) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Auswahl eines Bereiches f\u00fcr den Selfservice");
            }
            if (StringMapper.isNullString((String)this.mEmailaddressOfServiceSender)) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"E-Mail-Adresses des Selfservice-Absenders der E-Mails zur Registrierung und dem Passwort");
            }
        }
        new EMailAddress(this.mEmailaddressOfServiceSender).check();
    }

    private void checkPrintsOnSoE() throws BusinessDomainException {
        if (this.mPrintPlant && !this.mUsePlants) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Betriebsst\u00e4tte");
        }
        if (this.mPrintEmployeeCircle && !this.mUseEmployeeCircle) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Mitarbeiterkreis");
        }
        if (this.mPrintEmployeeGroup && !this.mUseEmployeeGroup) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Mitarbeitergruppe");
        }
        if (this.mPrintEmploymentGroup && !this.mUseEmployeeFunction) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Mitarbeiterfunktion");
        }
        if (this.mPrintCostCenter && !this.mUseCostCenter) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Kostenstelle");
        }
        if (this.mPrintCostUnit && !this.mUseCostUnit) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Kostentr\u00e4ger");
        }
        if (this.mPrintCostUnit && !this.mUseCostUnit) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Kostentr\u00e4ger");
        }
        if (this.mPrintDepartment && !this.mUseDepartment) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Abteilung");
        }
        if (this.mPrintOrgUnit && !this.mUseOrgUnit) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Organisationseinheit");
        }
        if (this.mPrintPersonInCharge1 && !this.mUsePersonInCharge1) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Bearbeiter 1");
        }
        if (this.mPrintPersonInCharge2 && !this.mUsePersonInCharge2) {
            throw PCompanyExceptionMapper.makePrintOnSOENotAllowedDomainException((String)"Bearbeiter 2");
        }
    }

    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        this.setEffectiveFrom(pb.getSystemStart());
        Date minValidFrom = this.getPCompany().getStartOfHistory();
        if (DateHelper.before((Date)this.getValidFrom(), (Date)minValidFrom)) {
            throw PCompanyExceptionMapper.makeStartHistoryBeforePCompanyFoundationValidFromDomainException((String)"CompanySettings.checkDates()");
        }
    }

    public void checkAssessableDeletable() throws BusinessDomainException {
        boolean notDeletable = true;
        if (this.getUsePlants()) {
            PlantSettings[] plantSettings;
            notDeletable = PlantSettingsPersistencyManager.existsPlantSettings((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidheadcompany", (String)this.getPCompany().getObjectid()), Restrictions.eq((String)"assessable", (String)"T"), Restrictions.isNull((String)"oidhfforassessment"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.getEffectiveFrom())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.getEffectiveFrom())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.getValidFrom()))}));
            LOGGER.debug("notDeletable wegen Mitarbeiter{}", (Object)notDeletable);
            if (!notDeletable && (plantSettings = PlantSettingsPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidheadcompany", (String)this.getPCompany().getObjectid()), Restrictions.eq((String)"assessable", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.getEffectiveFrom())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.getEffectiveFrom())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.getValidFrom()))}))).length > 0) {
                notDeletable = this.getIEmployeePM().assessableEEfromNotAssessablePlants(this, plantSettings);
            }
        } else {
            notDeletable = this.getIEmployeePM().assessableEE(this, null);
            LOGGER.debug("notDeletable wegen Mitarbeiter2{}", (Object)notDeletable);
        }
        if (notDeletable) {
            throw PCompanyExceptionMapper.makeAssessableNotDeletableDomainException();
        }
    }

    public void checkEECircleOnSoE() throws BusinessDomainException {
        if (this.getEECircleOnSoE() && !this.getUseEmployeeCircle()) {
            throw PCompanyExceptionMapper.makeEECircleOnSoEfalseDomainException();
        }
    }

    public void checkEEGroupOnSoE() throws BusinessDomainException {
        if (this.getEEGroupOnSoE() && !this.getUseEmployeeGroup()) {
            throw PCompanyExceptionMapper.makeEEGroupOnSoEfalseDomainException();
        }
    }

    public void checkEmployeeFunctionOnSoE() throws BusinessDomainException {
        if (this.getEmployeeFunctionOnSoE() && !this.getUseEmployeeFunction()) {
            throw PCompanyExceptionMapper.makeEmploymentGroupOnSoEfalseDomainException();
        }
    }

    public void checkDepartmentOnSoE() throws BusinessDomainException {
        if (this.getDepartmentOnSoE() && !this.getUseDepartment()) {
            throw PCompanyExceptionMapper.makeDepartmentOnSoEfalseDomainException();
        }
    }

    public void checkOfficeOnSoE() throws BusinessDomainException {
        if (this.getOfficeOnSoE() && !this.getUseOffice()) {
            throw PCompanyExceptionMapper.makeOfficeOnSoEfalseDomainException();
        }
    }

    public void checkOrgUnitOnSoE() throws BusinessDomainException {
        if (this.getOrgUnitOnSoE() && !this.getUseOrgUnit()) {
            throw PCompanyExceptionMapper.makeOrgUnitOnSoEfalseDomainException();
        }
    }

    public void checkLocationOnSoE() throws BusinessDomainException {
        if (this.getLocationOnSoE() && !this.getUseLocation()) {
            throw PCompanyExceptionMapper.makeLocationOnSoEfalseDomainException();
        }
    }

    public void checkCostCenterOnSoE() throws BusinessDomainException {
        if (this.getCostCenterOnSoE() && !this.getUseCostCenter()) {
            throw PCompanyExceptionMapper.makeCostCenterOnSoEfalseDomainException();
        }
    }

    public void checkCostUnitOnSoE() throws BusinessDomainException {
        if (this.getCostUnitOnSoE() && !this.getUseCostUnit()) {
            throw PCompanyExceptionMapper.makeCostUnitOnSoEfalseDomainException();
        }
    }

    public void checkFirstPersonInChargeOnSoE() throws BusinessDomainException {
        if (this.getFirstPersonInChargeOnSoE() && !this.getUsePersonInCharge1()) {
            throw PCompanyExceptionMapper.makeFirstPersonInChargeOnSoEfalseDomainException();
        }
    }

    public void checkSecondPersonInChargeOnSoE() throws BusinessDomainException {
        if (this.getSecondPersonInChargeOnSoE() && !this.getUsePersonInCharge2()) {
            throw PCompanyExceptionMapper.makeSecondPersonInChargeOnSoEfalseDomainException();
        }
    }

    public void checkThirdPersonInChargeOnSoE() throws BusinessDomainException {
        if (this.getThirdPersonInChargeOnSoE() && !this.getUsePersonInCharge3()) {
            throw PCompanyExceptionMapper.makeThirdPersonInChargeOnSoEfalseDomainException();
        }
    }

    public PersonnelTimedPersistenceObject createNew() {
        CTConsolidation[] ctcArray;
        CompanySettings result = new CompanySettings(this.mPCompany);
        result.mEffectiveFrom = this.getEffectiveFrom();
        result.mEffectiveUntil = this.getEffectiveUntil();
        result.mValidFrom = this.getValidFrom();
        result.mValidUntil = this.getValidUntil();
        result.mSettings = this.getSettings();
        result.mUseEmployeeCircle = this.getUseEmployeeCircle();
        result.mUseEmployeeGroup = this.getUseEmployeeGroup();
        result.mUseEmployeeFunction = this.getUseEmployeeFunction();
        result.mUseLocation = this.getUseLocation();
        result.mUseCostCenter = this.getUseCostCenter();
        result.mUseCostUnit = this.getUseCostUnit();
        result.mUseDepartment = this.getUseDepartment();
        result.mUseOffice = this.getUseOffice();
        result.mUseOrgUnit = this.getUseOrgUnit();
        result.mUsePersonInCharge1 = this.getUsePersonInCharge1();
        result.mUsePersonInCharge2 = this.getUsePersonInCharge2();
        result.mUsePersonInCharge3 = this.getUsePersonInCharge3();
        result.mDEUVSender = this.getDEUVSender();
        result.mUsePlants = this.getUsePlants();
        result.mVeryFirstDayOfCalculation = this.getVeryFirstDayOfCalculation();
        result.mCauseOfJournalizing = this.getCauseOfJournalizing();
        result.mCorrectionStatementOfEarnings = this.getCorrectionStatementOfEarnings();
        result.mEECircleOnSoE = this.getEECircleOnSoE();
        result.mEEGroupOnSoE = this.getEEGroupOnSoE();
        result.mEmployeeFunctionOnSoE = this.getEmployeeFunctionOnSoE();
        result.mDepartmentOnSoE = this.getDepartmentOnSoE();
        result.mOfficeOnSoE = this.getOfficeOnSoE();
        result.mOrgUnitOnSoE = this.getOrgUnitOnSoE();
        result.mLocationOnSoE = this.getLocationOnSoE();
        result.mCostCenterOnSoE = this.getCostCenterOnSoE();
        result.mCostUnitOnSoE = this.getCostUnitOnSoE();
        result.mFirstPersonInChargeOnSoE = this.getFirstPersonInChargeOnSoE();
        result.mSecondPersonInChargeOnSoE = this.getSecondPersonInChargeOnSoE();
        result.mThirdPersonInChargeOnSoE = this.getThirdPersonInChargeOnSoE();
        result.mRecalculationCostCenterCostUnit = this.getRecalculationCostCenterCostUnit();
        result.mDemarcation = this.getDemarcation();
        result.mShiftScheduleOnSoE = this.getShiftScheduleOnSoE();
        result.mPayScaleStatementsAndWagesFactorOnSoE = this.getPayScaleStatementsAndWagesFactorOnSoE();
        result.mLeaveAccountsOnSoE = this.getLeaveAccountsOnSoE();
        result.mBreakPeriodsOnSoE = this.getBreakPeriodsOnSoE();
        result.mStatisticsAndRunningTotalOnSoE = this.getStatisticsAndRunningTotalOnSoE();
        result.mDeductionsIncludingTransfersOnSoE = this.getDeductionsIncludingTransfersOnSoE();
        result.mGarnishmentsOnSoE = this.getGarnishmentsOnSoE();
        result.mLoansOnSoE = this.getLoansOnSoE();
        result.mAuxiliaryCostUnitsOnSoE = this.getAuxiliaryCostUnitsOnSoE();
        result.mChildrenParticularsOnSoE = this.getChildrenParticularsOnSoE();
        if (this.mNewConsolidations != null) {
            ctcArray = new CTConsolidation[this.mNewConsolidations.length];
            for (int i = 0; i < this.mNewConsolidations.length; ++i) {
                ctcArray[i] = this.mNewConsolidations[i].createNew(result);
            }
        } else {
            ctcArray = new CTConsolidation[this.getCtConsolidations().length];
            for (int i = 0; i < this.getCtConsolidations().length; ++i) {
                ctcArray[i] = this.getCtConsolidations()[i].createNew(result);
            }
        }
        result.mConsolidations = ctcArray;
        result.mPersonnelnumberOnSoE = this.getPersonnelnumberOnSoE();
        result.mPaymentOfContributionWithpreviousMonth = this.getPaymentOfContributionWithpreviousMonth();
        result.mStipulationToEvaluatePensionshemeInAgePartTime = this.getStipulationToEvaluatePensionshemeInAgePartTime();
        result.mStatementOfContributionProCompany = this.getStatementOfContributionProCompany();
        result.mPrintPlant = this.getPrintPlant();
        result.mPrintEmployeeCircle = this.getPrintEmployeeCircle();
        result.mPrintEmployeeGroup = this.getPrintEmployeeGroup();
        result.mPrintEmploymentGroup = this.getPrintEmploymentGroup();
        result.mPrintCostCenter = this.getPrintCostCenter();
        result.mPrintCostUnit = this.getPrintCostUnit();
        result.mPrintDepartment = this.getPrintDepartment();
        result.mPrintOrgUnit = this.getPrintOrgUnit();
        result.mPrintPersonInCharge1 = this.getPrintPersonInCharge1();
        result.mPrintPersonInCharge2 = this.getPrintPersonInCharge2();
        result.mServiceMaster = this.getServiceMaster();
        result.mServiceEERelative = this.getServiceEERelative();
        result.mServiceEEDisability = this.getServiceEEDisability();
        result.mServiceEEWork = this.getServiceEEWork();
        result.mServiceTaxAndInsurance = this.getServiceTaxAndInsurance();
        result.mServiceEEHolidayYear = this.getServiceEEHolidayYear();
        result.mServiceEEAbsentTime = this.getServiceEEAbsentTime();
        result.mServiceCertificate = this.getServiceCertificate();
        result.mRelativeOfEarnings = this.getRelativeOfEarnings();
        result.mDevelopOfSalaryHistoryAtJournalize = this.getDevelopOfSalaryHistoryAtJournalize();
        result.mEmailaddressOfServiceSender = this.getEmailaddressOfServiceSender();
        result.mExpiryInMinutes = this.getExpiryInMinutes();
        result.mTextForServiceRegistry = this.getTextForServiceRegistry();
        result.mTextForServicePwdReset = this.getTextForServicePwdReset();
        result.mTextForServiceReminder = this.getTextForServiceReminder();
        result.mUseMfaForService = this.getUseMfaForService();
        return result;
    }

    public PCompany getPCompany() {
        this.requireLoaded();
        return this.mPCompany;
    }

    public void setPCompany(PCompany pcompany) {
        this.mPCompany = pcompany;
    }

    public Settings getSettings() {
        this.requireLoaded();
        return this.mSettings;
    }

    public void setSettings(Settings settings) {
        this.protocol("CompanySettings.Settings.Assessable", this.mSettings == null ? null : BooleanMapper.toString((boolean)this.mSettings.getAssessable()), settings == null ? null : BooleanMapper.toString((boolean)settings.getAssessable()));
        this.protocol("CompanySettings.Settings.RateAssessmentAccomplishingHealthFund", (IPersistentObject)(this.mSettings == null ? null : (this.mSettings.getRateAssessmentAccomplishingHealthFund() == null ? null : this.mSettings.getRateAssessmentAccomplishingHealthFund())), (IPersistentObject)(settings == null ? null : (settings.getRateAssessmentAccomplishingHealthFund() == null ? null : settings.getRateAssessmentAccomplishingHealthFund())));
        this.protocol("CompanySettings.Settings.AnnualIncomeTaxReturn", this.mSettings == null ? null : BooleanMapper.toString((boolean)this.mSettings.getAnnualIncomeTaxReturn()), settings == null ? null : BooleanMapper.toString((boolean)settings.getAnnualIncomeTaxReturn()));
        this.protocol("CompanySettings.Settings.LawArea", this.mSettings == null ? null : this.mSettings.getLawArea(), settings == null ? null : settings.getLawArea());
        this.protocol("CompanySettings.Settings.DutyOfEntrainmentSocialInsuranceIDCard", this.mSettings == null ? null : BooleanMapper.toString((boolean)this.mSettings.getPromptDEUVAccount()), settings == null ? null : BooleanMapper.toString((boolean)settings.getPromptDEUVAccount()));
        this.mSettings = settings;
    }

    public boolean getUseEmployeeCircle() {
        this.requireLoaded();
        return this.mUseEmployeeCircle;
    }

    public void setUseEmployeeCircle(boolean useEmployeeCircle) {
        this.protocol("CompanySettings.UseEmployeeCircle", BooleanMapper.toString((boolean)this.mUseEmployeeCircle), BooleanMapper.toString((boolean)useEmployeeCircle));
        this.mUseEmployeeCircle = useEmployeeCircle;
    }

    public boolean getUseEmployeeGroup() {
        this.requireLoaded();
        return this.mUseEmployeeGroup;
    }

    public void setUseEmployeeGroup(boolean useEmployeeGroup) {
        this.protocol("CompanySettings.UseHalfLeaveDay", BooleanMapper.toString((boolean)this.mUseEmployeeGroup), BooleanMapper.toString((boolean)useEmployeeGroup));
        this.mUseEmployeeGroup = useEmployeeGroup;
    }

    public boolean getUseEmployeeFunction() {
        this.requireLoaded();
        return this.mUseEmployeeFunction;
    }

    public void setUseEmployeeFunction(boolean useEmployeeFunction) {
        this.protocol("CompanySettings.UseEmploymentGroup", BooleanMapper.toString((boolean)this.mUseEmployeeFunction), BooleanMapper.toString((boolean)useEmployeeFunction));
        this.mUseEmployeeFunction = useEmployeeFunction;
    }

    public boolean getUseLocation() {
        this.requireLoaded();
        return this.mUseLocation;
    }

    public void setUseLocation(boolean useLocation) {
        this.protocol("CompanySettings.UseLocation", BooleanMapper.toString((boolean)this.mUseLocation), BooleanMapper.toString((boolean)useLocation));
        this.mUseLocation = useLocation;
    }

    public boolean getUseCostCenter() {
        this.requireLoaded();
        return this.mUseCostCenter;
    }

    public void setUseCostCenter(boolean useCostCenter) {
        this.protocol("CompanySettings.UseCostCenter", BooleanMapper.toString((boolean)this.mUseCostCenter), BooleanMapper.toString((boolean)useCostCenter));
        this.mUseCostCenter = useCostCenter;
    }

    public boolean getUseCostUnit() {
        this.requireLoaded();
        return this.mUseCostUnit;
    }

    public void setUseCostUnit(boolean useCostUnit) {
        this.protocol("CompanySettings.UseCostUnit", BooleanMapper.toString((boolean)this.mUseCostUnit), BooleanMapper.toString((boolean)useCostUnit));
        this.mUseCostUnit = useCostUnit;
    }

    public boolean getUseDepartment() {
        this.requireLoaded();
        return this.mUseDepartment;
    }

    public void setUseDepartment(boolean useDepartment) {
        this.protocol("CompanySettings.UseDepartment", BooleanMapper.toString((boolean)this.mUseDepartment), BooleanMapper.toString((boolean)useDepartment));
        this.mUseDepartment = useDepartment;
    }

    public boolean getUseOffice() {
        this.requireLoaded();
        return this.mUseOffice;
    }

    public void setUseOffice(boolean useOffice) {
        this.protocol("CompanySettings.UseOffice", BooleanMapper.toString((boolean)this.mUseOffice), BooleanMapper.toString((boolean)useOffice));
        this.mUseOffice = useOffice;
    }

    public boolean getUseOrgUnit() {
        this.requireLoaded();
        return this.mUseOrgUnit;
    }

    public void setUseOrgUnit(boolean useOrgUnit) {
        this.protocol("CompanySettings.UseOrgUnit", BooleanMapper.toString((boolean)this.mUseOrgUnit), BooleanMapper.toString((boolean)useOrgUnit));
        this.mUseOrgUnit = useOrgUnit;
    }

    public boolean getUsePersonInCharge1() {
        this.requireLoaded();
        return this.mUsePersonInCharge1;
    }

    public void setUsePersonInCharge1(boolean usePersonInCharge1) {
        this.protocol("CompanySettings.UsePersonInCharge1", BooleanMapper.toString((boolean)this.mUsePersonInCharge1), BooleanMapper.toString((boolean)usePersonInCharge1));
        this.mUsePersonInCharge1 = usePersonInCharge1;
    }

    public boolean getUsePersonInCharge2() {
        this.requireLoaded();
        return this.mUsePersonInCharge2;
    }

    public void setUsePersonInCharge2(boolean usePersonInCharge2) {
        this.protocol("CompanySettings.UsePersonInCharge2", BooleanMapper.toString((boolean)this.mUsePersonInCharge2), BooleanMapper.toString((boolean)usePersonInCharge2));
        this.mUsePersonInCharge2 = usePersonInCharge2;
    }

    public boolean getUsePersonInCharge3() {
        this.requireLoaded();
        return this.mUsePersonInCharge3;
    }

    public void setUsePersonInCharge3(boolean usePersonInCharge3) {
        this.protocol("CompanySettings.UsePersonInCharge3", BooleanMapper.toString((boolean)this.mUsePersonInCharge3), BooleanMapper.toString((boolean)usePersonInCharge3));
        this.mUsePersonInCharge3 = usePersonInCharge3;
    }

    public DEUVSender getDEUVSender() {
        this.requireLoaded();
        return this.mDEUVSender;
    }

    public void setDEUVSender(DEUVSender deuvSender) {
        this.mDEUVSender = deuvSender;
    }

    public boolean getUsePlants() {
        this.requireLoaded();
        return this.mUsePlants;
    }

    public void setUsePlants(boolean usePlants) {
        this.protocol("CompanySettings.UsePlants", BooleanMapper.toString((boolean)this.mUsePlants), BooleanMapper.toString((boolean)usePlants));
        this.mUsePlants = usePlants;
    }

    public int getVeryFirstDayOfCalculation() {
        this.requireLoaded();
        return this.mVeryFirstDayOfCalculation;
    }

    public void setVeryFirstDayOfCalculation(int veryFirstDayOfCalculation) {
        this.protocol("CompanySettings.VeryFirstDayOfCalculation", Integer.toString(this.mVeryFirstDayOfCalculation), Integer.toString(veryFirstDayOfCalculation));
        this.mVeryFirstDayOfCalculation = veryFirstDayOfCalculation;
    }

    public CauseOfJournalizingEnum getCauseOfJournalizing() {
        this.requireLoaded();
        return this.mCauseOfJournalizing;
    }

    public void setCauseOfJournalizing(CauseOfJournalizingEnum causeOfJournalizing) {
        if (causeOfJournalizing == null) {
            throw ExceptionMapper.makeApplicationException((String)"CauseOfJournalizingEnum darf nicht NULL sein!");
        }
        this.protocol("CompanySettings.CauseOfJournalizingEnum", CauseOfJournalizingEnumMapper.toString((CauseOfJournalizingEnum)this.mCauseOfJournalizing), CauseOfJournalizingEnumMapper.toString((CauseOfJournalizingEnum)causeOfJournalizing));
        this.mCauseOfJournalizing = causeOfJournalizing;
    }

    public CorrectionEnum getCorrectionStatementOfEarnings() {
        this.requireLoaded();
        return this.mCorrectionStatementOfEarnings;
    }

    public void setCorrectionStatementOfEarnings(CorrectionEnum correctionStatementOfEarnings) {
        if (correctionStatementOfEarnings == null) {
            throw ExceptionMapper.makeApplicationException((String)"CorrectionStatementOfEarningsEnum darf nicht NULL sein!");
        }
        this.protocol("CompanySettings.CorrectionStatementOfEarningsEnum", CorrectionEnumMapper.toString((CorrectionEnum)this.mCorrectionStatementOfEarnings), CorrectionEnumMapper.toString((CorrectionEnum)correctionStatementOfEarnings));
        this.mCorrectionStatementOfEarnings = correctionStatementOfEarnings;
    }

    public boolean getEECircleOnSoE() {
        this.requireLoaded();
        return this.mEECircleOnSoE;
    }

    public void setEECircleOnSoE(boolean eECircleOnSoE) {
        this.protocol("CompanySettings.EECircleOnSoE", BooleanMapper.toString((boolean)this.mEECircleOnSoE), BooleanMapper.toString((boolean)eECircleOnSoE));
        this.mEECircleOnSoE = eECircleOnSoE;
    }

    public boolean getEEGroupOnSoE() {
        this.requireLoaded();
        return this.mEEGroupOnSoE;
    }

    public void setEEGroupOnSoE(boolean eEGroupOnSoE) {
        this.protocol("CompanySettings.EEGroupOnSoE", BooleanMapper.toString((boolean)this.mEEGroupOnSoE), BooleanMapper.toString((boolean)eEGroupOnSoE));
        this.mEEGroupOnSoE = eEGroupOnSoE;
    }

    public boolean getEmployeeFunctionOnSoE() {
        this.requireLoaded();
        return this.mEmployeeFunctionOnSoE;
    }

    public void setEmployeeFunctionOnSoE(boolean employeeFunctionOnSoE) {
        this.protocol("CompanySettings.EmploymentGroupOnSoE", BooleanMapper.toString((boolean)this.mEmployeeFunctionOnSoE), BooleanMapper.toString((boolean)employeeFunctionOnSoE));
        this.mEmployeeFunctionOnSoE = employeeFunctionOnSoE;
    }

    public boolean getDepartmentOnSoE() {
        this.requireLoaded();
        return this.mDepartmentOnSoE;
    }

    public void setDepartmentOnSoE(boolean departmentOnSoE) {
        this.protocol("CompanySettings.DepartmentOnSoE", BooleanMapper.toString((boolean)this.mDepartmentOnSoE), BooleanMapper.toString((boolean)departmentOnSoE));
        this.mDepartmentOnSoE = departmentOnSoE;
    }

    public boolean getOfficeOnSoE() {
        this.requireLoaded();
        return this.mOfficeOnSoE;
    }

    public void setOfficeOnSoE(boolean officeOnSoE) {
        this.protocol("CompanySettings.OfficeOnSoE", BooleanMapper.toString((boolean)this.mOfficeOnSoE), BooleanMapper.toString((boolean)officeOnSoE));
        this.mOfficeOnSoE = officeOnSoE;
    }

    public boolean getOrgUnitOnSoE() {
        this.requireLoaded();
        return this.mOrgUnitOnSoE;
    }

    public void setOrgUnitOnSoE(boolean orgUnitOnSoE) {
        this.protocol("CompanySettings.OrgUnitOnSoE", BooleanMapper.toString((boolean)this.mOrgUnitOnSoE), BooleanMapper.toString((boolean)orgUnitOnSoE));
        this.mOrgUnitOnSoE = orgUnitOnSoE;
    }

    public boolean getLocationOnSoE() {
        this.requireLoaded();
        return this.mLocationOnSoE;
    }

    public void setLocationOnSoE(boolean locationOnSoE) {
        this.protocol("CompanySettings.LocationOnSoE", BooleanMapper.toString((boolean)this.mLocationOnSoE), BooleanMapper.toString((boolean)locationOnSoE));
        this.mLocationOnSoE = locationOnSoE;
    }

    public boolean getCostCenterOnSoE() {
        this.requireLoaded();
        return this.mCostCenterOnSoE;
    }

    public void setCostCenterOnSoE(boolean costCenterOnSoE) {
        this.protocol("CompanySettings.CostCenterOnSoE", BooleanMapper.toString((boolean)this.mCostCenterOnSoE), BooleanMapper.toString((boolean)costCenterOnSoE));
        this.mCostCenterOnSoE = costCenterOnSoE;
    }

    public boolean getCostUnitOnSoE() {
        this.requireLoaded();
        return this.mCostUnitOnSoE;
    }

    public void setCostUnitOnSoE(boolean costUnitOnSoE) {
        this.protocol("CompanySettings.CostUnitOnSoE", BooleanMapper.toString((boolean)this.mCostUnitOnSoE), BooleanMapper.toString((boolean)costUnitOnSoE));
        this.mCostUnitOnSoE = costUnitOnSoE;
    }

    public boolean getFirstPersonInChargeOnSoE() {
        this.requireLoaded();
        return this.mFirstPersonInChargeOnSoE;
    }

    public void setFirstPersonInChargeOnSoE(boolean firstPersonInChargeOnSoE) {
        this.protocol("CompanySettings.FirstPersonInChargeOnSoE", BooleanMapper.toString((boolean)this.mFirstPersonInChargeOnSoE), BooleanMapper.toString((boolean)firstPersonInChargeOnSoE));
        this.mFirstPersonInChargeOnSoE = firstPersonInChargeOnSoE;
    }

    public boolean getSecondPersonInChargeOnSoE() {
        this.requireLoaded();
        return this.mSecondPersonInChargeOnSoE;
    }

    public void setSecondPersonInChargeOnSoE(boolean secondPersonInChargeOnSoE) {
        this.protocol("CompanySettings.SecondPersonInChargeOnSoE", BooleanMapper.toString((boolean)this.mSecondPersonInChargeOnSoE), BooleanMapper.toString((boolean)secondPersonInChargeOnSoE));
        this.mSecondPersonInChargeOnSoE = secondPersonInChargeOnSoE;
    }

    public boolean getThirdPersonInChargeOnSoE() {
        this.requireLoaded();
        return this.mThirdPersonInChargeOnSoE;
    }

    public void setThirdPersonInChargeOnSoE(boolean thirdPersonInChargeOnSoE) {
        this.protocol("CompanySettings.ThirdPersonInChargeOnSoE", BooleanMapper.toString((boolean)this.mThirdPersonInChargeOnSoE), BooleanMapper.toString((boolean)thirdPersonInChargeOnSoE));
        this.mThirdPersonInChargeOnSoE = thirdPersonInChargeOnSoE;
    }

    public boolean getRecalculationCostCenterCostUnit() {
        this.requireLoaded();
        return this.mRecalculationCostCenterCostUnit;
    }

    public void setRecalculationCostCenterCostUnit(boolean recalculationCostCenterCostUnit) {
        this.protocol("CompanySettings.RecalculationCostCenterCostUnit", BooleanMapper.toString((boolean)this.mRecalculationCostCenterCostUnit), BooleanMapper.toString((boolean)recalculationCostCenterCostUnit));
        this.mRecalculationCostCenterCostUnit = recalculationCostCenterCostUnit;
    }

    public boolean getDemarcation() {
        this.requireLoaded();
        return this.mDemarcation;
    }

    public void setDemarcation(boolean demarcation) {
        this.protocol("CompanySettings.Demarcation", BooleanMapper.toString((boolean)this.mDemarcation), BooleanMapper.toString((boolean)demarcation));
        this.mDemarcation = demarcation;
    }

    public boolean getShiftScheduleOnSoE() {
        this.requireLoaded();
        return this.mShiftScheduleOnSoE;
    }

    public void setShiftScheduleOnSoE(boolean shiftScheduleOnSoE) {
        this.protocol("CompanySettings.ShiftScheduleOnSoE", BooleanMapper.toString((boolean)this.mShiftScheduleOnSoE), BooleanMapper.toString((boolean)shiftScheduleOnSoE));
        this.mShiftScheduleOnSoE = shiftScheduleOnSoE;
    }

    public boolean getPayScaleStatementsAndWagesFactorOnSoE() {
        this.requireLoaded();
        return this.mPayScaleStatementsAndWagesFactorOnSoE;
    }

    public void setPayScaleStatementsAndWagesFactorOnSoE(boolean payScaleStatementsAndWagesFactorOnSoE) {
        this.protocol("CompanySettings.PayScaleStatementsAndWagesFactorOnSoE", BooleanMapper.toString((boolean)this.mPayScaleStatementsAndWagesFactorOnSoE), BooleanMapper.toString((boolean)payScaleStatementsAndWagesFactorOnSoE));
        this.mPayScaleStatementsAndWagesFactorOnSoE = payScaleStatementsAndWagesFactorOnSoE;
    }

    public boolean getLeaveAccountsOnSoE() {
        this.requireLoaded();
        return this.mLeaveAccountsOnSoE;
    }

    public void setLeaveAccountsOnSoE(boolean leaveAccountsOnSoE) {
        this.protocol("CompanySettings.LeaveAccountsOnSoE", BooleanMapper.toString((boolean)this.mLeaveAccountsOnSoE), BooleanMapper.toString((boolean)leaveAccountsOnSoE));
        this.mLeaveAccountsOnSoE = leaveAccountsOnSoE;
    }

    public boolean getBreakPeriodsOnSoE() {
        this.requireLoaded();
        return this.mBreakPeriodsOnSoE;
    }

    public void setBreakPeriodsOnSoE(boolean breakPeriodsOnSoE) {
        this.protocol("CompanySettings.BreakPeriodsOnSoE", BooleanMapper.toString((boolean)this.mBreakPeriodsOnSoE), BooleanMapper.toString((boolean)breakPeriodsOnSoE));
        this.mBreakPeriodsOnSoE = breakPeriodsOnSoE;
    }

    public boolean getStatisticsAndRunningTotalOnSoE() {
        this.requireLoaded();
        return this.mStatisticsAndRunningTotalOnSoE;
    }

    public void setStatisticsAndRunningTotalOnSoE(boolean statisticsAndRunningTotalOnSoE) {
        this.protocol("CompanySettings.StatisticsAndRunningTotalOnSoE", BooleanMapper.toString((boolean)this.mStatisticsAndRunningTotalOnSoE), BooleanMapper.toString((boolean)statisticsAndRunningTotalOnSoE));
        this.mStatisticsAndRunningTotalOnSoE = statisticsAndRunningTotalOnSoE;
    }

    public boolean getDeductionsIncludingTransfersOnSoE() {
        this.requireLoaded();
        return this.mDeductionsIncludingTransfersOnSoE;
    }

    public void setDeductionsIncludingTransfersOnSoE(boolean deductionsIncludingTransfersOnSoE) {
        this.protocol("CompanySettings.DeductionsIncludingTransfersOnSoE", BooleanMapper.toString((boolean)this.mDeductionsIncludingTransfersOnSoE), BooleanMapper.toString((boolean)deductionsIncludingTransfersOnSoE));
        this.mDeductionsIncludingTransfersOnSoE = deductionsIncludingTransfersOnSoE;
    }

    public boolean getGarnishmentsOnSoE() {
        this.requireLoaded();
        return this.mGarnishmentsOnSoE;
    }

    public void setGarnishmentsOnSoE(boolean garnishmentsOnSoE) {
        this.protocol("CompanySettings.GarnishmentsOnSoE", BooleanMapper.toString((boolean)this.mGarnishmentsOnSoE), BooleanMapper.toString((boolean)garnishmentsOnSoE));
        this.mGarnishmentsOnSoE = garnishmentsOnSoE;
    }

    public boolean getLoansOnSoE() {
        this.requireLoaded();
        return this.mLoansOnSoE;
    }

    public void setLoansOnSoE(boolean loansOnSoE) {
        this.protocol("CompanySettings.LoansOnSoE", BooleanMapper.toString((boolean)this.mLoansOnSoE), BooleanMapper.toString((boolean)loansOnSoE));
        this.mLoansOnSoE = loansOnSoE;
    }

    public boolean getAuxiliaryCostUnitsOnSoE() {
        this.requireLoaded();
        return this.mAuxiliaryCostUnitsOnSoE;
    }

    public void setAuxiliaryCostUnitsOnSoE(boolean auxiliaryCostUnitsOnSoE) {
        this.protocol("CompanySettings.AuxiliaryCostUnitsOnSoE", BooleanMapper.toString((boolean)this.mAuxiliaryCostUnitsOnSoE), BooleanMapper.toString((boolean)auxiliaryCostUnitsOnSoE));
        this.mAuxiliaryCostUnitsOnSoE = auxiliaryCostUnitsOnSoE;
    }

    public boolean getChildrenParticularsOnSoE() {
        this.requireLoaded();
        return this.mChildrenParticularsOnSoE;
    }

    public void setChildrenParticularsOnSoE(boolean childrenParticularsOnSoE) {
        this.protocol("CompanySettings.ChildrenParticularsOnSoE", BooleanMapper.toString((boolean)this.mChildrenParticularsOnSoE), BooleanMapper.toString((boolean)childrenParticularsOnSoE));
        this.mChildrenParticularsOnSoE = childrenParticularsOnSoE;
    }

    public CTConsolidation[] getCtConsolidations() {
        this.requireLoaded();
        return this.mConsolidations;
    }

    public void setCtConsolidations(CTConsolidation[] ctc) {
        this.mNewConsolidations = ctc;
    }

    public boolean getPersonnelnumberOnSoE() {
        this.requireLoaded();
        return this.mPersonnelnumberOnSoE;
    }

    public void setPersonnelnumberOnSoE(boolean personnelnumberOnSoE) {
        this.protocol("CompanySettings.PersonnelnumberOnSoE", BooleanMapper.toString((boolean)this.mPersonnelnumberOnSoE), BooleanMapper.toString((boolean)personnelnumberOnSoE));
        this.mPersonnelnumberOnSoE = personnelnumberOnSoE;
    }

    public boolean getPaymentOfContributionWithpreviousMonth() {
        this.requireLoaded();
        return this.mPaymentOfContributionWithpreviousMonth;
    }

    public void setPaymentOfContributionWithpreviousMonth(boolean paymentOfContributionWithpreviousMonth) {
        this.protocol("CompanySettings.PaymentOfContributionWithpreviousMonth", BooleanMapper.toString((boolean)this.mPaymentOfContributionWithpreviousMonth), BooleanMapper.toString((boolean)paymentOfContributionWithpreviousMonth));
        this.mPaymentOfContributionWithpreviousMonth = paymentOfContributionWithpreviousMonth;
    }

    public boolean getStipulationToEvaluatePensionshemeInAgePartTime() {
        this.requireLoaded();
        return this.mStipulationToEvaluatePensionshemeInAgePartTime;
    }

    public void setStipulationToEvaluatePensionshemeInAgePartTime(boolean stipulationToEvaluatePensionshemeInAgePartTime) {
        this.mStipulationToEvaluatePensionshemeInAgePartTime = stipulationToEvaluatePensionshemeInAgePartTime;
    }

    public final void makeSaveable() {
        int i;
        super.makeSaveable();
        if (this.mConsolidations != null) {
            for (i = 0; i < this.mConsolidations.length; ++i) {
                this.mConsolidations[i].makeSaveable();
            }
        }
        if (this.mNewConsolidations != null) {
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].makeSaveable();
            }
        }
    }

    public final void makeReadOnly() {
        int i;
        super.makeReadOnly();
        if (this.mConsolidations != null) {
            for (i = 0; i < this.mConsolidations.length; ++i) {
                this.mConsolidations[i].makeReadOnly();
            }
        }
        if (this.mNewConsolidations != null) {
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].makeReadOnly();
            }
        }
    }

    public void registerForLastExecute() {
        int i;
        super.registerForLastExecute();
        if (this.mConsolidations != null) {
            for (i = 0; i < this.mConsolidations.length; ++i) {
                this.mConsolidations[i].registerForLastExecute();
            }
        }
        if (this.mNewConsolidations != null) {
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].registerForLastExecute();
            }
        }
    }

    public void firstExecuteImpl() throws BusinessDomainException {
        if (this.mNewConsolidations != null) {
            int i;
            if (this.getCtConsolidations() != null) {
                for (i = 0; i < this.getCtConsolidations().length; ++i) {
                    this.mConsolidations[i].makeSaveable();
                    this.mConsolidations[i].unregisterLastExecute();
                    this.mConsolidations[i].destroy();
                }
            }
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                this.mNewConsolidations[i].makeSaveable();
                this.mNewConsolidations[i].registerForLastExecute();
            }
        }
    }

    public void compareToOld(CompanySettings old) {
        if (old == null) {
            return;
        }
        this.mOld = old;
        if (old.getSettings().getAssessable() != this.mSettings.getAssessable()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.getSettings().getRateAssessmentAccomplishingHealthFund(), (IPersistentObject)this.mSettings.getRateAssessmentAccomplishingHealthFund())) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getAnnualIncomeTaxReturn() != this.mSettings.getAnnualIncomeTaxReturn()) {
            this.setValuateNeeded(true);
            return;
        }
        if (StringMapper.compareTo((String)old.getSettings().getLawArea(), (String)this.mSettings.getLawArea()) != 0) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getRecalculationCostCenterCostUnit() != this.mRecalculationCostCenterCostUnit) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getDemarcation() != this.mDemarcation) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getCtConsolidations().length != this.mNewConsolidations.length) {
            this.setValuateNeeded(true);
            return;
        }
        for (int i = 0; i < old.getCtConsolidations().length; ++i) {
            if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.getCtConsolidations()[i].getLumpSumIncomeTax(), (IPersistentObject)this.mNewConsolidations[i].getLumpSumIncomeTax())) {
                this.setValuateNeeded(true);
                return;
            }
            if (StringMapper.compareTo((String)ModeOfProcedureEnumMapper.toString((ModeOfProcedureEnum)old.getCtConsolidations()[i].getModeOfProcedureEnum()), (String)ModeOfProcedureEnumMapper.toString((ModeOfProcedureEnum)this.mNewConsolidations[i].getModeOfProcedureEnum())) == 0) continue;
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getPensionshemeSettingsEnum().value() != this.mSettings.getPensionshemeSettingsEnum().value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getStipulationToEvaluatePensionshemeInAgePartTime() != this.mStipulationToEvaluatePensionshemeInAgePartTime) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getInsolvencyAssessable() != this.mSettings.getInsolvencyAssessable()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getSettings().getMinLaborUtilizationRate(), (BigDecimal)this.mSettings.getMinLaborUtilizationRate())) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getSettings().getMaxlLaborUtilizationRate(), (BigDecimal)this.mSettings.getMaxlLaborUtilizationRate())) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSettings().getZvkSettings().value() != this.mSettings.getZvkSettings().value()) {
            this.setValuateNeeded(true);
            return;
        }
    }

    public String getRootDomainKey() {
        return this.getPCompany().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Firma - Einstellungen";
    }

    public void checkCTConsolidations() {
        block13: {
            int i;
            boolean find;
            LumpSumIncomeTax tax;
            block12: {
                int i2;
                int i3;
                if (this.mNewConsolidations.length == 0) {
                    return;
                }
                tax = null;
                try {
                    tax = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen);
                }
                catch (Exception e) {
                    return;
                }
                find = false;
                if (!DateHelper.before((Date)this.getValidFrom(), (Date)new VDate(2007, 0, 1).getDate())) break block12;
                for (i3 = 0; i3 < this.mNewConsolidations.length; ++i3) {
                    if (this.mNewConsolidations[i3].getLumpSumIncomeTax().getTypeOfConsolidation() != ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                    find = true;
                }
                if (!find) break block13;
                for (i3 = 0; i3 < this.mNewConsolidations.length; ++i3) {
                    this.mNewConsolidations[i3].makeReadOnly();
                }
                CTConsolidation[] consolidations = new CTConsolidation[this.mNewConsolidations.length - 1];
                int j = 0;
                for (i2 = 0; i2 < this.mNewConsolidations.length; ++i2) {
                    if (this.mNewConsolidations[i2].getLumpSumIncomeTax().getTypeOfConsolidation() == ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                    consolidations[j] = this.mNewConsolidations[i2];
                    ++j;
                }
                this.mNewConsolidations = consolidations;
                for (i2 = 0; i2 < this.mNewConsolidations.length; ++i2) {
                    this.mNewConsolidations[i2].registerForLastExecute();
                }
                break block13;
            }
            for (i = 0; i < this.mNewConsolidations.length; ++i) {
                if (this.mNewConsolidations[i].getLumpSumIncomeTax().getTypeOfConsolidation() != ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                find = true;
            }
            if (!find) {
                int i4;
                for (i = 0; i < this.mNewConsolidations.length; ++i) {
                    this.mNewConsolidations[i].makeReadOnly();
                }
                CTConsolidation[] consolidations = new CTConsolidation[this.mNewConsolidations.length + 1];
                for (i4 = 0; i4 < this.mNewConsolidations.length; ++i4) {
                    if (this.mNewConsolidations[i4].getLumpSumIncomeTax().getTypeOfConsolidation() == ConsolidationIntoALumpSumEnum.CIALSE_Sachzuwendungen) continue;
                    consolidations[i4] = this.mNewConsolidations[i4];
                }
                consolidations[this.mNewConsolidations.length] = new CTConsolidation(this);
                consolidations[this.mNewConsolidations.length].setLumpSumIncomeTax(tax);
                consolidations[this.mNewConsolidations.length].setModeOfProcedureEnum(ModeOfProcedureEnum.MOPE_Nachweisverfahren);
                this.mNewConsolidations = consolidations;
                for (i4 = 0; i4 < this.mNewConsolidations.length; ++i4) {
                    this.mNewConsolidations[i4].registerForLastExecute();
                }
            }
        }
    }

    public void checkChangeOfAnnualIncomeTaxReturn() throws BusinessDomainException {
        if (this.mOld == null) {
            return;
        }
        Date minJournalizedUntil = this.getIEmployeePM().getMaxJournalizedUntil(this.mPCompany);
        if (minJournalizedUntil == null) {
            return;
        }
        int monthOfJournalizedUntil = new VDate(minJournalizedUntil).getMonth();
        int yearOfJournalizedUntil = new VDate(minJournalizedUntil).getYear();
        int yearOfValidFrom = new VDate(this.mValidFrom).getYear();
        if (this.mOld.getSettings().getAnnualIncomeTaxReturn() != this.getSettings().getAnnualIncomeTaxReturn()) {
            if (monthOfJournalizedUntil == 0 && yearOfValidFrom < yearOfJournalizedUntil - 1) {
                throw CompanyPlantExceptionMapper.makeChangeOfAnnualIncomeTaxReturnNotAllowedDomainException();
            }
            if (monthOfJournalizedUntil > 0 && yearOfValidFrom < yearOfJournalizedUntil) {
                throw CompanyPlantExceptionMapper.makeChangeOfAnnualIncomeTaxReturnNotAllowedDomainException();
            }
        }
    }

    public boolean getStatementOfContributionProCompany() {
        this.requireLoaded();
        return this.mStatementOfContributionProCompany;
    }

    public void setStatementOfContributionProCompany(boolean statementOfContributionProCompany) {
        this.mStatementOfContributionProCompany = statementOfContributionProCompany;
    }

    public boolean getPrintPlant() {
        this.requireLoaded();
        return this.mPrintPlant;
    }

    public void setPrintPlant(boolean printPlant) {
        this.mPrintPlant = printPlant;
    }

    public boolean getPrintEmployeeCircle() {
        this.requireLoaded();
        return this.mPrintEmployeeCircle;
    }

    public void setPrintEmployeeCircle(boolean printEmployeeCircle) {
        this.mPrintEmployeeCircle = printEmployeeCircle;
    }

    public boolean getPrintEmployeeGroup() {
        this.requireLoaded();
        return this.mPrintEmployeeGroup;
    }

    public void setPrintEmployeeGroup(boolean printEmployeeGroup) {
        this.mPrintEmployeeGroup = printEmployeeGroup;
    }

    public boolean getPrintEmploymentGroup() {
        this.requireLoaded();
        return this.mPrintEmploymentGroup;
    }

    public void setPrintEmploymentGroup(boolean printEmploymentGroup) {
        this.mPrintEmploymentGroup = printEmploymentGroup;
    }

    public boolean getPrintCostCenter() {
        this.requireLoaded();
        return this.mPrintCostCenter;
    }

    public void setPrintCostCenter(boolean printCostCenter) {
        this.mPrintCostCenter = printCostCenter;
    }

    public boolean getPrintCostUnit() {
        this.requireLoaded();
        return this.mPrintCostUnit;
    }

    public void setPrintCostUnit(boolean printCostUnit) {
        this.mPrintCostUnit = printCostUnit;
    }

    public boolean getPrintDepartment() {
        this.requireLoaded();
        return this.mPrintDepartment;
    }

    public void setPrintDepartment(boolean printDepartment) {
        this.mPrintDepartment = printDepartment;
    }

    public boolean getPrintOrgUnit() {
        this.requireLoaded();
        return this.mPrintOrgUnit;
    }

    public void setPrintOrgUnit(boolean printOrgUnit) {
        this.mPrintOrgUnit = printOrgUnit;
    }

    public boolean getPrintPersonInCharge1() {
        this.requireLoaded();
        return this.mPrintPersonInCharge1;
    }

    public void setPrintPersonInCharge1(boolean printPersonInCharge1) {
        this.mPrintPersonInCharge1 = printPersonInCharge1;
    }

    public boolean getPrintPersonInCharge2() {
        this.requireLoaded();
        return this.mPrintPersonInCharge2;
    }

    public void setPrintPersonInCharge2(boolean printPersonInCharge2) {
        this.mPrintPersonInCharge2 = printPersonInCharge2;
    }

    public boolean getServiceMaster() {
        this.requireLoaded();
        return this.mServiceMaster;
    }

    public void setServiceMaster(boolean serviceMaster) {
        this.mServiceMaster = serviceMaster;
    }

    public boolean getServiceEERelative() {
        this.requireLoaded();
        return this.mServiceEERelative;
    }

    public void setServiceEERelative(boolean serviceEERelative) {
        this.mServiceEERelative = serviceEERelative;
    }

    public boolean getServiceEEDisability() {
        this.requireLoaded();
        return this.mServiceEEDisability;
    }

    public void setServiceEEDisability(boolean serviceEEDisability) {
        this.mServiceEEDisability = serviceEEDisability;
    }

    public boolean getServiceEEWork() {
        this.requireLoaded();
        return this.mServiceEEWork;
    }

    public void setServiceEEWork(boolean serviceEEWork) {
        this.mServiceEEWork = serviceEEWork;
    }

    public boolean getServiceTaxAndInsurance() {
        this.requireLoaded();
        return this.mServiceTaxAndInsurance;
    }

    public void setServiceTaxAndInsurance(boolean serviceTaxAndInsurance) {
        this.mServiceTaxAndInsurance = serviceTaxAndInsurance;
    }

    public boolean getServiceEEHolidayYear() {
        this.requireLoaded();
        return this.mServiceEEHolidayYear;
    }

    public void setServiceEEHolidayYear(boolean serviceEEHolidayYear) {
        this.mServiceEEHolidayYear = serviceEEHolidayYear;
    }

    public boolean getServiceEEAbsentTime() {
        this.requireLoaded();
        return this.mServiceEEAbsentTime;
    }

    public void setServiceEEAbsentTime(boolean serviceEEAbsentTime) {
        this.mServiceEEAbsentTime = serviceEEAbsentTime;
    }

    public boolean getServiceCertificate() {
        this.requireLoaded();
        return this.mServiceCertificate;
    }

    public void setServiceCertificate(boolean serviceCertificate) {
        this.mServiceCertificate = serviceCertificate;
    }

    public boolean getRelativeOfEarnings() {
        this.requireLoaded();
        return this.mRelativeOfEarnings;
    }

    public void setRelativeOfEarnings(boolean relativeOfEarnings) {
        this.mRelativeOfEarnings = relativeOfEarnings;
    }

    public boolean getDevelopOfSalaryHistoryAtJournalize() {
        this.requireLoaded();
        return this.mDevelopOfSalaryHistoryAtJournalize;
    }

    public void setDevelopOfSalaryHistoryAtJournalize(boolean developOfSalaryHistoryAtJournalize) {
        this.mDevelopOfSalaryHistoryAtJournalize = developOfSalaryHistoryAtJournalize;
    }

    public String getEmailaddressOfServiceSender() {
        this.requireLoaded();
        return this.mEmailaddressOfServiceSender;
    }

    public void setEmailaddressOfServiceSender(String emailaddressOfServiceSender) {
        this.mEmailaddressOfServiceSender = emailaddressOfServiceSender;
    }

    public int getExpiryInMinutes() {
        this.requireLoaded();
        return this.mExpiryInMinutes;
    }

    public void setExpiryInMinutes(int expiryInMinutes) {
        this.mExpiryInMinutes = expiryInMinutes;
    }

    public CorrespondenceText getTextForServiceRegistry() {
        this.requireLoaded();
        return this.mTextForServiceRegistry;
    }

    public void setTextForServiceRegistry(CorrespondenceText textForServiceRegistry) {
        this.mTextForServiceRegistry = textForServiceRegistry;
    }

    public CorrespondenceText getTextForServicePwdReset() {
        this.requireLoaded();
        return this.mTextForServicePwdReset;
    }

    public void setTextForServicePwdReset(CorrespondenceText textForServicePwdReset) {
        this.mTextForServicePwdReset = textForServicePwdReset;
    }

    public CorrespondenceText getTextForServiceReminder() {
        this.requireLoaded();
        return this.mTextForServiceReminder;
    }

    public void setTextForServiceReminder(CorrespondenceText textForServiceReminder) {
        this.mTextForServiceReminder = textForServiceReminder;
    }

    public boolean getUseMfaForService() {
        this.requireLoaded();
        return this.mUseMfaForService;
    }

    public void setUseMfaForService(boolean useMfaForService) {
        this.mUseMfaForService = useMfaForService;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

