/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.lstb.lstbmonat;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.lstb.LStB;
import com.varial.personnel.domain.lstb.lstbmonat.ILStBMonatPersistencyManager;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.util.Date;

public class LStBMonat
extends PersistentObject {
    private static final int PRIORITY = 10;
    private final ILStBMonatPersistencyManager pm = (ILStBMonatPersistencyManager)UtilitiesManager.getBean((String)"lStBMonatPersistencyManager", ILStBMonatPersistencyManager.class);
    private LStB mLStB;
    private int mLfdNr;
    private Date mElstamGueltigAb;
    private int mSteuerklasse;
    private BigDecimal mFaktor;
    private BigDecimal mKinder;
    private String mKiStAbzugKonfession;
    private ChurchTaxEnum mKiStAbzugChurchTax;
    private String mKiStAbzugEhegatteKonfession;
    private ChurchTaxEnum mKiStAbzugEhegatteChurchTax;
    private BigDecimal mSteuerfreibetragJahr;
    private BigDecimal mSteuerfreibetragMonat;
    private BigDecimal mSteuerfreibetragWoche;
    private BigDecimal mSteuerfreibetragTag;
    private BigDecimal mHinzurechnungsbetragJahr;
    private BigDecimal mHinzurechnungsbetragMonat;
    private BigDecimal mHinzurechnungsbetragWoche;
    private BigDecimal mHinzurechnungsbetragTag;
    private BigDecimal mBeitragpkvppv;
    private BigDecimal mBeitragbasispkvppv;

    public LStBMonat() {
        super(10);
    }

    public static LStBMonat getLStBMonat(String objectID) {
        return new LStBMonat(objectID);
    }

    private LStBMonat(String objectID) {
        super(10, objectID);
    }

    public LStBMonat(String objectId, int version) {
        super(10, objectId, version);
    }

    protected LStBMonat(boolean readOnly) {
        super(10, readOnly);
    }

    public LStBMonat(LStB lStB) {
        this();
        this.mLStB = lStB;
    }

    protected void saveImpl() {
        this.pm.save(this);
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public LStB getLStB() {
        this.requireLoaded();
        return this.mLStB;
    }

    public void setLStB(LStB lStB) {
        this.mLStB = lStB;
    }

    public int getLfdNr() {
        this.requireLoaded();
        return this.mLfdNr;
    }

    public void setLfdNr(int lfdNr) {
        this.mLfdNr = lfdNr;
    }

    public Date getElstamGueltigAb() {
        this.requireLoaded();
        return this.mElstamGueltigAb;
    }

    public void setElstamGueltigAb(Date elstamGueltigAb) {
        this.mElstamGueltigAb = elstamGueltigAb;
    }

    public int getSteuerklasse() {
        this.requireLoaded();
        return this.mSteuerklasse;
    }

    public void setSteuerklasse(int steuerklasse) {
        this.mSteuerklasse = steuerklasse;
    }

    public BigDecimal getFaktor() {
        this.requireLoaded();
        return this.mFaktor;
    }

    public void setFaktor(BigDecimal faktor) {
        this.mFaktor = faktor;
    }

    public BigDecimal getKinder() {
        this.requireLoaded();
        return this.mKinder;
    }

    public void setKinder(BigDecimal kinder) {
        this.mKinder = kinder;
    }

    public String getKiStAbzugKonfession() {
        this.requireLoaded();
        return this.mKiStAbzugKonfession;
    }

    public ChurchTaxEnum getKiStAbzugChurchTax() {
        return this.mKiStAbzugChurchTax;
    }

    public void setKiStAbzugKonfession(int churchTax) {
        this.setKiStAbzugKonfession(ChurchTaxEnumMapper.toChurchTaxEnum((int)churchTax));
    }

    public void setKiStAbzugKonfession(ChurchTaxEnum churchTax) {
        this.mKiStAbzugChurchTax = churchTax;
        this.setKiStAbzugKonfession(ChurchTaxEnumMapper.toPerfidiaString((ChurchTaxEnum)this.mKiStAbzugChurchTax));
    }

    public void setKiStAbzugKonfession(String kiStAbzugKonfession) {
        this.mKiStAbzugKonfession = kiStAbzugKonfession;
    }

    public String getKiStAbzugEhegatteKonfession() {
        this.requireLoaded();
        return this.mKiStAbzugEhegatteKonfession;
    }

    public ChurchTaxEnum getKiStAbzugEhegatteChurchTax() {
        return this.mKiStAbzugEhegatteChurchTax;
    }

    public void setKiStAbzugEhegatteKonfession(int churchTax) {
        this.setKiStAbzugEhegatteKonfession(ChurchTaxEnumMapper.toChurchTaxEnum((int)churchTax));
    }

    public void setKiStAbzugEhegatteKonfession(ChurchTaxEnum churchTax) {
        this.mKiStAbzugEhegatteChurchTax = churchTax;
        this.setKiStAbzugEhegatteKonfession(ChurchTaxEnumMapper.toPerfidiaString((ChurchTaxEnum)this.mKiStAbzugEhegatteChurchTax));
    }

    public void setKiStAbzugEhegatteKonfession(String kiStAbzugEhegatteKonfession) {
        this.mKiStAbzugEhegatteKonfession = kiStAbzugEhegatteKonfession;
    }

    public BigDecimal getSteuerfreibetragJahr() {
        this.requireLoaded();
        return this.mSteuerfreibetragJahr;
    }

    public void setSteuerfreibetragJahr(BigDecimal steuerfreibetragJahr) {
        this.mSteuerfreibetragJahr = steuerfreibetragJahr;
    }

    public BigDecimal getSteuerfreibetragMonat() {
        this.requireLoaded();
        return this.mSteuerfreibetragMonat;
    }

    public void setSteuerfreibetragMonat(BigDecimal steuerfreibetragMonat) {
        this.mSteuerfreibetragMonat = steuerfreibetragMonat;
    }

    public BigDecimal getSteuerfreibetragWoche() {
        this.requireLoaded();
        return this.mSteuerfreibetragWoche;
    }

    public void setSteuerfreibetragWoche(BigDecimal steuerfreibetragWoche) {
        this.mSteuerfreibetragWoche = steuerfreibetragWoche;
    }

    public BigDecimal getSteuerfreibetragTag() {
        this.requireLoaded();
        return this.mSteuerfreibetragTag;
    }

    public void setSteuerfreibetragTag(BigDecimal steuerfreibetragTag) {
        this.mSteuerfreibetragTag = steuerfreibetragTag;
    }

    public BigDecimal getHinzurechnungsbetragJahr() {
        this.requireLoaded();
        return this.mHinzurechnungsbetragJahr;
    }

    public void setHinzurechnungsbetragJahr(BigDecimal hinzurechnungsbetragJahr) {
        this.mHinzurechnungsbetragJahr = hinzurechnungsbetragJahr;
    }

    public BigDecimal getHinzurechnungsbetragMonat() {
        this.requireLoaded();
        return this.mHinzurechnungsbetragMonat;
    }

    public void setHinzurechnungsbetragMonat(BigDecimal hinzurechnungsbetragMonat) {
        this.mHinzurechnungsbetragMonat = hinzurechnungsbetragMonat;
    }

    public BigDecimal getHinzurechnungsbetragWoche() {
        this.requireLoaded();
        return this.mHinzurechnungsbetragWoche;
    }

    public void setHinzurechnungsbetragWoche(BigDecimal hinzurechnungsbetragWoche) {
        this.mHinzurechnungsbetragWoche = hinzurechnungsbetragWoche;
    }

    public BigDecimal getHinzurechnungsbetragTag() {
        this.requireLoaded();
        return this.mHinzurechnungsbetragTag;
    }

    public void setHinzurechnungsbetragTag(BigDecimal hinzurechnungsbetragTag) {
        this.mHinzurechnungsbetragTag = hinzurechnungsbetragTag;
    }

    public BigDecimal getBeitragpkvppv() {
        this.requireLoaded();
        return this.mBeitragpkvppv;
    }

    public void setBeitragpkvppv(BigDecimal beitragpkvppv) {
        this.mBeitragpkvppv = beitragpkvppv;
    }

    public BigDecimal getBeitragbasispkvppv() {
        this.requireLoaded();
        return this.mBeitragbasispkvppv;
    }

    public void setBeitragbasispkvppv(BigDecimal beitragbasispkvppv) {
        this.mBeitragbasispkvppv = beitragbasispkvppv;
    }

    public LStBMonat createNew(LStB lStB) {
        this.requireLoaded();
        LStBMonat bo = new LStBMonat(lStB);
        bo.mLfdNr = this.mLfdNr;
        bo.mElstamGueltigAb = this.mElstamGueltigAb;
        bo.mSteuerklasse = this.mSteuerklasse;
        bo.mFaktor = this.mFaktor;
        bo.mKinder = this.mKinder;
        bo.mKiStAbzugKonfession = this.mKiStAbzugKonfession;
        bo.mKiStAbzugEhegatteKonfession = this.mKiStAbzugEhegatteKonfession;
        bo.mSteuerfreibetragJahr = this.mSteuerfreibetragJahr;
        bo.mSteuerfreibetragMonat = this.mSteuerfreibetragMonat;
        bo.mSteuerfreibetragWoche = this.mSteuerfreibetragWoche;
        bo.mSteuerfreibetragTag = this.mSteuerfreibetragTag;
        bo.mHinzurechnungsbetragJahr = this.mHinzurechnungsbetragJahr;
        bo.mHinzurechnungsbetragMonat = this.mHinzurechnungsbetragMonat;
        bo.mHinzurechnungsbetragWoche = this.mHinzurechnungsbetragWoche;
        bo.mHinzurechnungsbetragTag = this.mHinzurechnungsbetragTag;
        bo.mBeitragpkvppv = this.mBeitragpkvppv;
        bo.mBeitragbasispkvppv = this.mBeitragbasispkvppv;
        return bo;
    }

    public boolean areEqual(LStBMonat other) {
        return this.areValuesEqual(other) && LStBMonat.areEqual(this.mLfdNr, other.mLfdNr) && LStBMonat.areEqual(this.mElstamGueltigAb, other.mElstamGueltigAb);
    }

    public boolean areValuesEqual(LStBMonat other) {
        this.requireLoaded();
        other.requireLoaded();
        return LStBMonat.areEqual(this.mSteuerklasse, other.mSteuerklasse) && LStBMonat.areEqual(this.mFaktor, other.mFaktor) && LStBMonat.areEqual(this.mKinder, other.mKinder) && LStBMonat.areEqual(this.mKiStAbzugKonfession, other.mKiStAbzugKonfession) && LStBMonat.areEqual(this.mKiStAbzugEhegatteKonfession, other.mKiStAbzugEhegatteKonfession) && LStBMonat.areEqual(this.mSteuerfreibetragJahr, other.mSteuerfreibetragJahr) && LStBMonat.areEqual(this.mSteuerfreibetragMonat, other.mSteuerfreibetragMonat) && LStBMonat.areEqual(this.mSteuerfreibetragWoche, other.mSteuerfreibetragWoche) && LStBMonat.areEqual(this.mSteuerfreibetragTag, other.mSteuerfreibetragTag) && LStBMonat.areEqual(this.mHinzurechnungsbetragJahr, other.mHinzurechnungsbetragJahr) && LStBMonat.areEqual(this.mHinzurechnungsbetragMonat, other.mHinzurechnungsbetragMonat) && LStBMonat.areEqual(this.mHinzurechnungsbetragWoche, other.mHinzurechnungsbetragWoche) && LStBMonat.areEqual(this.mHinzurechnungsbetragTag, other.mHinzurechnungsbetragTag) && LStBMonat.areEqual(this.mBeitragpkvppv, other.mBeitragpkvppv != null ? other.mBeitragpkvppv : BigDecimal.ZERO.setScale(2)) && LStBMonat.areEqual(this.mBeitragbasispkvppv, other.mBeitragbasispkvppv != null ? other.mBeitragbasispkvppv : BigDecimal.ZERO.setScale(2));
    }

    private static boolean areEqual(String s1, String s2) {
        return StringMapper.equal((String)s1, (String)s2);
    }

    private static boolean areEqual(int i1, int i2) {
        return i1 == i2;
    }

    private static boolean areEqual(Date date1, Date date2) {
        return DateHelper.equal((Date)date1, (Date)date2);
    }

    private static boolean areEqual(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        return BigDecimalMapper.compareTo((BigDecimal)bigDecimal1, (BigDecimal)bigDecimal2) == 0;
    }

    public String toString() {
        return "LStBMonat [mLfdNr=" + this.mLfdNr + "]";
    }
}

