/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.insurance.mapper.MultiplyEmploymentEnumMapper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.library.ValueTypeLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;

public class SteuerungMarbPauschalFormula {
    private static final int _ZVK_BRUTTO = 100901;
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final ValuePositionLibrary wplib;
    private final GlobalLibrary gllib;
    private final ValueTypeLibrary walib;
    private boolean istSteuerpflichtig = false;
    private boolean istKammerBeitragspflichtig = false;
    private boolean istSVpflichtig = false;
    private boolean istUmlagepflichtig = false;
    private boolean istZVKpflichtig = false;
    private BigDecimal bruttolohn = BigDecimal.ZERO;
    private BigDecimal beitragsfreiLautWertartenbeschreibung = BigDecimal.ZERO;
    private BigDecimal steuerpflichtig = BigDecimal.ZERO;
    private BigDecimal sVpflichtig = BigDecimal.ZERO;
    private BigDecimal steuerfreiLautWertartenBeschreibung = BigDecimal.ZERO;
    private ValuePosition[] vpArray;
    private boolean istPauschalSteuerpflichtig;
    private BigDecimal puschalSteuerpflichtig;
    private boolean mMFBChecked = false;

    public SteuerungMarbPauschalFormula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib, ValueTypeLibrary waLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
        this.walib = waLib;
    }

    public void steuerung() throws BusinessDomainException {
        BigInteger tempBigI;
        BigDecimal tempBigD;
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) && (tempBigD = new BigDecimal(tempBigI = this.wplib.result().movePointRight(2).toBigInteger()).movePointLeft(2)).compareTo(this.wplib.result()) != 0) {
            this.gllib.erzeugeWiedervorlageBruchteileVonCent(this.wplib.genesisParent().getValueType().getValueTypeKey());
        }
        this.bruttolohn = this.wplib.result();
        this.callib.result(this.bruttolohn);
        block11: for (ValuePosition vPos : this.vpArray = this.wplib.genesisUndFolgen()) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100901: 
                case 100902: 
                case 100903: 
                case 100904: 
                case 100908: {
                    this.istZVKpflichtig = true;
                    continue block11;
                }
                case 101510: 
                case 101550: 
                case 101560: 
                case 101570: 
                case 101580: 
                case 101590: 
                case 101600: 
                case 101610: 
                case 101750: 
                case 101760: 
                case 101770: {
                    this.puschalSteuerpflichtig = vPos.getResult();
                    this.istPauschalSteuerpflichtig = true;
                    continue block11;
                }
                case 110510: 
                case 110610: 
                case 110620: {
                    this.steuerpflichtig = vPos.getResult();
                    this.istSteuerpflichtig = true;
                    continue block11;
                }
                case 115200: {
                    this.istKammerBeitragspflichtig = true;
                    continue block11;
                }
                case 130510: 
                case 130520: 
                case 130610: {
                    this.istSVpflichtig = true;
                    continue block11;
                }
                case 135200: 
                case 135300: {
                    this.istUmlagepflichtig = true;
                    continue block11;
                }
            }
        }
        if (this.istSteuerpflichtig) {
            this.bewerteSteuerFreiheitLautWertartenbeschreibung();
        }
        if (this.istSVpflichtig) {
            this.bewerteSVFreiheitLautWertartenbeschreibung();
        }
        if (this.istPauschalSteuerpflichtig) {
            this.bewertePauschalSteuerpflicht();
        }
        if (this.istSteuerpflichtig) {
            this.bewerteSteuerpflicht();
        }
        if (this.eelib.isBeitragsfrei()) {
            if (this.istSVpflichtig && BigDecimalMapper.isZeroOrNull((BigDecimal)this.sVpflichtig)) {
                this.sVpflichtig = this.bruttolohn;
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.sVpflichtig)) {
                this.wplib.addNeueWertPosition(128600, this.sVpflichtig);
            }
            this.wplib.loescheWertPosition(new int[]{130510, 130610});
        } else if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
            this.checkSAG();
        }
        if (this.gllib.lohnsteuerJahresausgleichFirma() && this.eelib.isMarbLStJA()) {
            switch (new VDate(this.wplib.gueltigAb()).getMonth()) {
                case 11: {
                    this.wplib.addNeueWertPosition(110700, this.steuerpflichtig);
                    break;
                }
                default: {
                    new CalculationBasic(this.eelib.marb(), this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)DateHelper.getLastDayOfYear((Date)this.wplib.gueltigAb())), this.getClass().getName());
                }
            }
        }
    }

    private void checkSAG() throws BusinessDomainException {
        if (!this.callib.isSagChecked()) {
            this.callib.setSagChecked(true);
            if (this.callib.dbgzVorhanden()) {
                this.checkMehrfachbeschaeftigung();
                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                    this.checkGesEntgeltLfd2013(this.callib.dbgzGAEG());
                    this.checkGesEntgeltEGA(this.callib.dbgzEGAEG());
                } else {
                    this.checkGesEntgeltLfd(this.callib.dbgzGAEG());
                    this.checkGesEntgeltEGA(this.callib.dbgzEGAEG());
                }
            }
        }
    }

    private void checkMehrfachbeschaeftigung() throws BusinessDomainException {
        if (!this.mMFBChecked) {
            this.mMFBChecked = true;
            switch (this.eelib.marbMehrfachBeschaeftigung().value()) {
                case 0: 
                case 1: {
                    throw EvaluationExceptionMapper.makeSAG_MehrfachbeschaeftigungDomainException((Date)this.callib.berchnungGueltigAb(), (String)MultiplyEmploymentEnumMapper.toString((MultiplyEmploymentEnum)this.eelib.marbMehrfachBeschaeftigung()));
                }
            }
        }
    }

    private void checkGesEntgeltLfd2013(BigDecimal dbgzGAEG) throws BusinessDomainException {
        if (this.callib.dbgzVorhanden()) {
            int svTage = this.wplib.svTageLfd().intValue();
            if (svTage != this.callib.dbgzSVTG()) {
                ValuePosition[] vPArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130560, 129200}));
                BigDecimal lfdEntg = BigDecimal.ZERO;
                BigDecimal andererAg = BigDecimal.ZERO;
                block4: for (ValuePosition vPos : vPArray) {
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 130510: {
                            lfdEntg = lfdEntg.add(vPos.getResult());
                            continue block4;
                        }
                        case 129200: 
                        case 130560: {
                            andererAg = andererAg.add(vPos.getResult());
                        }
                    }
                }
                if (svTage > 0) {
                    lfdEntg = lfdEntg.multiply(BigDecimal.valueOf(this.callib.dbgzSVTG())).divide(BigDecimal.valueOf(svTage), 2, RoundingMode.UP);
                }
                if (dbgzGAEG.compareTo(lfdEntg.add(andererAg)) != 0) {
                    this.wplib.addNeueWertPosition(129205, dbgzGAEG.subtract(lfdEntg.add(andererAg)));
                }
            } else {
                this.checkGesEntgeltLfd(dbgzGAEG);
            }
        } else {
            this.checkGesEntgeltLfd(dbgzGAEG);
        }
    }

    private void checkGesEntgeltLfd(BigDecimal gesamtesEntgeltLfd) throws BusinessDomainException {
        ValuePosition[] vPArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130560, 129200}));
        BigDecimal lfdEntg = BigDecimal.ZERO;
        for (ValuePosition vPos : vPArray) {
            lfdEntg = lfdEntg.add(vPos.getResult());
        }
        if (gesamtesEntgeltLfd.compareTo(lfdEntg) != 0) {
            this.wplib.addNeueWertPosition(129205, gesamtesEntgeltLfd.subtract(lfdEntg));
        }
    }

    private void checkGesEntgeltEGA(BigDecimal gesamtesEntgeltEGA) throws BusinessDomainException {
        ValuePosition[] vPArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130610, 129210}));
        BigDecimal lEGA = BigDecimal.ZERO;
        for (ValuePosition vPos : vPArray) {
            lEGA = lEGA.add(vPos.getResult());
        }
        if (gesamtesEntgeltEGA.compareTo(lEGA) != 0) {
            this.wplib.addNeueWertPosition(129215, gesamtesEntgeltEGA.subtract(lEGA));
        }
    }

    private void bewertePauschalSteuerpflicht() throws BusinessDomainException {
        switch (this.eelib.taxacation()) {
            case 9: 
            case 11: {
                this.wplib.loescheWertPosition(new int[]{101510, 101550, 101560, 101570, 101580, 101590, 101600, 101610, 101750, 101760, 101770});
                this.wplib.addNeueWertPosition(110510, this.puschalSteuerpflichtig);
                break;
            }
        }
    }

    private void bewerteSteuerpflicht() throws BusinessDomainException {
        switch (this.eelib.taxacation()) {
            case 3: {
                if (this.eelib.ueberwaelzungLstAN() && !this.wplib.aus37b()) {
                    this.wplib.addNeueWertPosition(101650, this.steuerpflichtig);
                    this.wplib.addNeueWertPosition(729800, this.steuerpflichtig);
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                } else {
                    this.wplib.addNeueWertPosition(101650, this.steuerpflichtig);
                    this.wplib.addNeueWertPosition(729300, this.steuerpflichtig);
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                }
                if (this.eelib.ueberwaelzungSolZAN()) {
                    this.wplib.addNeueWertPosition(729840, this.steuerpflichtig);
                } else {
                    this.wplib.addNeueWertPosition(729340, this.steuerpflichtig);
                }
                if (this.eelib.ueberwaelzungKiStAN()) {
                    if (this.gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Kurzfristig_Beschaeftigte)) {
                        if (this.eelib.marbKiStAbz() == 0) break;
                        this.wplib.addNeueWertPosition(729890, this.steuerpflichtig);
                        break;
                    }
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(729880, this.steuerpflichtig);
                        break;
                    }
                    if (this.eelib.marbKiStAbz() == 0) break;
                    this.wplib.addNeueWertPosition(729880, this.steuerpflichtig);
                    break;
                }
                if (this.gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Kurzfristig_Beschaeftigte)) {
                    if (this.eelib.marbKiStAbz() == 0) break;
                    this.wplib.addNeueWertPosition(729390, this.steuerpflichtig);
                    break;
                }
                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                    this.wplib.addNeueWertPosition(729380, this.steuerpflichtig);
                    break;
                }
                if (this.eelib.marbKiStAbz() == 0) break;
                this.wplib.addNeueWertPosition(729380, this.steuerpflichtig);
                break;
            }
            case 5: {
                if (DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2003, 3, 1).getDate())) {
                        if (this.eelib.ueberwaelzungLstAN()) {
                            this.wplib.addNeueWertPosition(101680, this.steuerpflichtig);
                            this.wplib.addNeueWertPosition(736800, this.steuerpflichtig);
                            this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                            break;
                        }
                        this.wplib.addNeueWertPosition(101680, this.steuerpflichtig);
                        this.wplib.addNeueWertPosition(736300, this.steuerpflichtig);
                        this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                        break;
                    }
                    new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), new VDate(2003, 3, 1).getDate(), this.getClass().getName());
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                    break;
                }
                if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                    break;
                }
                this.wplib.loescheWertPosition(new int[]{110510, 110610});
                break;
            }
            case 4: {
                if (this.eelib.ueberwaelzungLstAN()) {
                    this.wplib.addNeueWertPosition(101660, this.steuerpflichtig);
                    this.wplib.addNeueWertPosition(732800, this.steuerpflichtig);
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                } else {
                    this.wplib.addNeueWertPosition(101660, this.steuerpflichtig);
                    this.wplib.addNeueWertPosition(732300, this.steuerpflichtig);
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                }
                if (this.eelib.ueberwaelzungSolZAN()) {
                    this.wplib.addNeueWertPosition(732840, this.steuerpflichtig);
                } else {
                    this.wplib.addNeueWertPosition(732340, this.steuerpflichtig);
                }
                if (this.eelib.ueberwaelzungKiStAN()) {
                    if (this.gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Geringfuegig_Beschaeftigte)) {
                        if (this.eelib.marbKiStAbz() == 0) break;
                        this.wplib.addNeueWertPosition(732890, this.steuerpflichtig);
                        break;
                    }
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(732880, this.steuerpflichtig);
                        break;
                    }
                    if (this.eelib.marbKiStAbz() == 0) break;
                    this.wplib.addNeueWertPosition(732880, this.steuerpflichtig);
                    break;
                }
                if (this.gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Geringfuegig_Beschaeftigte)) {
                    if (this.eelib.marbKiStAbz() == 0) break;
                    this.wplib.addNeueWertPosition(732390, this.steuerpflichtig);
                    break;
                }
                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                    this.wplib.addNeueWertPosition(732380, this.steuerpflichtig);
                    break;
                }
                if (this.eelib.marbKiStAbz() == 0) break;
                this.wplib.addNeueWertPosition(732380, this.steuerpflichtig);
                break;
            }
            case 6: {
                if (this.eelib.ueberwaelzungLstAN()) {
                    if (DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(101660, this.steuerpflichtig);
                        this.wplib.addNeueWertPosition(735800, this.steuerpflichtig);
                    } else {
                        this.wplib.addNeueWertPosition(101670, this.steuerpflichtig);
                        this.wplib.addNeueWertPosition(735800, this.steuerpflichtig);
                    }
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                } else {
                    if (DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(101660, this.steuerpflichtig);
                        this.wplib.addNeueWertPosition(735300, this.steuerpflichtig);
                    } else {
                        this.wplib.addNeueWertPosition(101670, this.steuerpflichtig);
                        this.wplib.addNeueWertPosition(735300, this.steuerpflichtig);
                    }
                    this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                }
                if (this.eelib.ueberwaelzungSolZAN()) {
                    this.wplib.addNeueWertPosition(735840, this.steuerpflichtig);
                } else {
                    this.wplib.addNeueWertPosition(735340, this.steuerpflichtig);
                }
                if (this.eelib.ueberwaelzungKiStAN()) {
                    if (this.gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Aushilfskraefte_Land_und_Forstwirtschaft)) {
                        if (this.eelib.marbKiStAbz() == 0) break;
                        this.wplib.addNeueWertPosition(735890, this.steuerpflichtig);
                        break;
                    }
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(735880, this.steuerpflichtig);
                        break;
                    }
                    if (this.eelib.marbKiStAbz() == 0) break;
                    this.wplib.addNeueWertPosition(735880, this.steuerpflichtig);
                    break;
                }
                if (this.gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Aushilfskraefte_Land_und_Forstwirtschaft)) {
                    if (this.eelib.marbKiStAbz() == 0) break;
                    this.wplib.addNeueWertPosition(735390, this.steuerpflichtig);
                    break;
                }
                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                    this.wplib.addNeueWertPosition(735380, this.steuerpflichtig);
                    break;
                }
                if (this.eelib.marbKiStAbz() == 0) break;
                this.wplib.addNeueWertPosition(735380, this.steuerpflichtig);
                break;
            }
            case 1: 
            case 13: {
                if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2021, 0, 1).getDate())) {
                    if (this.eelib.taxacation() == 13) {
                        this.wplib.addNeueWertPosition(103520, this.wplib.result());
                    } else if (this.eelib.isDBA(this.wplib.gueltigAb())) {
                        this.wplib.addNeueWertPosition(103510, this.wplib.result());
                    }
                }
                this.wplib.addNeueWertPosition(104600, this.wplib.result());
                this.wplib.loescheWertPosition(new int[]{110510, 110610, 110620});
                break;
            }
            case 11: {
                this.callib.anzurechnendeSteuer(this.eelib.anzurechnendeSteuer());
                break;
            }
        }
    }

    private void bewerteSVFreiheitLautWertartenbeschreibung() throws BusinessDomainException {
        this.beitragsfreiLautWertartenbeschreibung = BigDecimal.ZERO;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.svfreiNachWABetrag())) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.svfreiNachWaPRozentsatz())) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.basiswertProzentsatzBeitragsfreiheit())) {
                    this.beitragsfreiLautWertartenbeschreibung = this.bruttolohn.multiply(this.walib.svfreiNachWaPRozentsatz()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    this.sVpflichtig = this.bruttolohn.subtract(this.beitragsfreiLautWertartenbeschreibung);
                } else {
                    this.beitragsfreiLautWertartenbeschreibung = this.bruttolohn.multiply(this.walib.svfreiNachWaPRozentsatz()).divide(this.walib.basiswertProzentsatzBeitragsfreiheit(), 2, RoundingMode.HALF_UP);
                    this.sVpflichtig = this.bruttolohn.subtract(this.beitragsfreiLautWertartenbeschreibung);
                }
            }
        } else if (BigDecimalMapper.compareTo((BigDecimal)this.walib.svfreiNachWABetrag(), (BigDecimal)this.bruttolohn) > 0) {
            this.beitragsfreiLautWertartenbeschreibung = this.bruttolohn;
            this.sVpflichtig = this.bruttolohn.subtract(this.beitragsfreiLautWertartenbeschreibung);
        } else {
            this.beitragsfreiLautWertartenbeschreibung = this.walib.svfreiNachWABetrag();
            this.sVpflichtig = this.bruttolohn.subtract(this.beitragsfreiLautWertartenbeschreibung);
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.beitragsfreiLautWertartenbeschreibung)) {
            this.wplib.addNeueWertPosition(128200, BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.svfreiNachWaPRozentsatz()) ? BigDecimal.ZERO : this.walib.svfreiNachWaPRozentsatz(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.beitragsfreiLautWertartenbeschreibung, false);
            this.modifiziereSVpflWertpositionen();
            if (this.istUmlagepflichtig) {
                this.modifiziereUmlagepflWertpositionen();
            }
            if (this.istZVKpflichtig) {
                this.modifiziereZVKpflWertpositionen();
            }
        }
    }

    private void bewerteSteuerFreiheitLautWertartenbeschreibung() throws BusinessDomainException {
        this.steuerfreiLautWertartenBeschreibung = BigDecimal.ZERO;
        this.steuerpflichtig = this.bruttolohn;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.steuerfreiNachWABetrag())) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.steuerfreiNachWAProzentsatz())) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.basiswertProzentsatzSteuerfreiheit())) {
                    this.steuerfreiLautWertartenBeschreibung = this.bruttolohn.multiply(this.walib.steuerfreiNachWAProzentsatz()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    this.steuerpflichtig = this.bruttolohn.subtract(this.steuerfreiLautWertartenBeschreibung);
                } else {
                    this.steuerfreiLautWertartenBeschreibung = this.bruttolohn.multiply(this.walib.steuerfreiNachWAProzentsatz()).divide(this.walib.basiswertProzentsatzSteuerfreiheit(), 2, RoundingMode.HALF_UP);
                    this.steuerpflichtig = this.bruttolohn.subtract(this.steuerfreiLautWertartenBeschreibung);
                }
            }
        } else if (BigDecimalMapper.compareTo((BigDecimal)this.walib.steuerfreiNachWABetrag(), (BigDecimal)this.bruttolohn) > 0) {
            this.steuerfreiLautWertartenBeschreibung = this.bruttolohn;
            this.steuerpflichtig = this.bruttolohn.subtract(this.steuerfreiLautWertartenBeschreibung);
        } else {
            this.steuerfreiLautWertartenBeschreibung = this.walib.steuerfreiNachWABetrag();
            this.steuerpflichtig = this.bruttolohn.subtract(this.steuerfreiLautWertartenBeschreibung);
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.steuerfreiLautWertartenBeschreibung)) {
            this.wplib.addNeueWertPosition(104200, BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.steuerfreiNachWAProzentsatz()) ? BigDecimal.ZERO : this.walib.steuerfreiNachWAProzentsatz(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.steuerfreiLautWertartenBeschreibung, false);
            this.modifiziereStpflWertpositionen();
            this.modifiziereLStBescheinigung();
            if (this.istKammerBeitragspflichtig) {
                this.modifiziereKammerbeitragspflWertpositionen();
            }
        }
    }

    private void modifiziereKammerbeitragspflWertpositionen() {
        block3: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 115200: {
                    vPos.setResult(this.steuerpflichtig);
                    continue block3;
                }
            }
        }
    }

    private void modifiziereLStBescheinigung() {
        block3: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 102500: 
                case 102505: 
                case 102510: 
                case 102520: 
                case 102530: 
                case 102540: 
                case 102550: {
                    vPos.setResult(this.steuerpflichtig);
                    continue block3;
                }
            }
        }
    }

    private void modifiziereStpflWertpositionen() {
        block3: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 110510: 
                case 110610: 
                case 110620: {
                    vPos.setResult(this.steuerpflichtig);
                    continue block3;
                }
            }
        }
    }

    private void modifiziereZVKpflWertpositionen() {
        block3: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100901: {
                    vPos.setResult(this.sVpflichtig);
                    continue block3;
                }
            }
        }
    }

    private void modifiziereUmlagepflWertpositionen() {
        block3: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 135200: 
                case 135300: {
                    vPos.setResult(this.sVpflichtig);
                    continue block3;
                }
            }
        }
    }

    private void modifiziereSVpflWertpositionen() {
        block3: for (ValuePosition vPos : this.vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 130510: 
                case 130520: 
                case 130610: {
                    vPos.setResult(this.sVpflichtig);
                    continue block3;
                }
            }
        }
    }
}

