/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CertificateCalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

public class PVBeitragsermittlungPrivatFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal FUENFZIG = BigDecimal.valueOf(50L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static final BigDecimal DREIHUNDERTSECHZIG = BigDecimal.valueOf(360L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal mBeitragspflichtig = BigDecimal.ZERO;
    private BigDecimal mPVTageAufgelaufen = BigDecimal.ZERO;
    private BigDecimal mMitarbeiterGesamtbeitrag = BigDecimal.ZERO;
    private BigDecimal mAGZuschussAufgelaufen = BigDecimal.ZERO;
    private boolean mMfB = false;
    private BigDecimal mPVTage = BigDecimal.ZERO;
    private BigDecimal mPvBBG = BigDecimal.ZERO;
    private BigDecimal mAGAnteilPv = BigDecimal.ZERO;
    private BigDecimal mANAnteilPv = BigDecimal.ZERO;

    public PVBeitragsermittlungPrivatFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.gllib = globalLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void pvBeitragsermittlung() throws BusinessDomainException {
        String BGSAndererAG = Integer.toString(this.eelib.marbBgrKvAndererAG()) + Integer.toString(this.eelib.marbBgrRvAndererAG()) + Integer.toString(this.eelib.marbBgrAvAndererAG()) + Integer.toString(this.eelib.marbBgrPvAndererAG());
        this.mMfB = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrKvAndererAG() != 6 && !StringMapper.equal((String)BGSAndererAG, (String)"0500");
        this.mPVTage = this.wplib.svTage();
        if (this.callib.dbbgVorhanden() && BigDecimal.valueOf(this.callib.dbbgSVTG()).compareTo(this.mPVTage) > 0) {
            this.mPVTage = BigDecimal.valueOf(this.callib.dbbgSVTG());
        }
        this.mPvBBG = this.mPVTage.compareTo(DREISSIG) != 0 ? this.gllib.svBbgKvPv().multiply(this.mPVTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.gllib.svBbgKvPv();
        if (this.gllib.bundeslandSchluesselBeschaeftigungsort() != 15) {
            this.mAGAnteilPv = this.gllib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
            this.mANAnteilPv = this.gllib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
        } else {
            this.mAGAnteilPv = this.gllib.bulaPvAga();
            this.mANAnteilPv = this.gllib.svBsGesamtPV().subtract(this.mAGAnteilPv);
        }
        switch (this.wplib.wertartenNummer()) {
            case 771120: {
                this.ermittlungLfd();
                break;
            }
            case 771150: {
                this.wplib.wertPosition().makeReadOnly();
                break;
            }
            case 771130: {
                if (this.eelib.marbAGZPPv() == 1) {
                    this.ermittlungEGA();
                    break;
                }
                this.callib.kvAGZ(BigDecimal.ZERO);
                break;
            }
            case 771140: {
                this.ermittlungKug();
                break;
            }
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2026, 0, 1).getDate()) && this.mPVTage.compareTo(DREISSIG) != 0 && this.callib.getTypeOfCalculationCase() != TypeOfCalculationCase.PkvPpVBerechnungOhneFZ) {
            CertificateCalculationCase calculationCase = new CertificateCalculationCase();
            calculationCase.init(this.eelib.marb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), BigDecimal.ZERO, TypeOfCalculationCase.PkvPpVBerechnungOhneFZ);
            calculationCase.start();
            BigDecimal kvAGZVollerMonat = calculationCase.getSumOfValuePosition(this.wplib.wertartenNummer());
            calculationCase.removeValuesOfCalculation();
            this.callib.setResultVM(kvAGZVollerMonat);
        } else {
            this.callib.setResultVM(this.callib.pvAGZ());
        }
    }

    private void ermittlungLfd() throws BusinessDomainException {
        BigDecimal gesamtEntgelt;
        ValuePosition[] vpArray;
        BigDecimal gesamtesFiktivesEntgelt = BigDecimal.ZERO;
        BigDecimal gesamtesKugEntgelt = BigDecimal.ZERO;
        block10: for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130560, 771110, 130540, 230110}))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 130510: 
                case 130560: {
                    this.mBeitragspflichtig = this.mBeitragspflichtig.add(lElement.getResult());
                    continue block10;
                }
                case 771110: {
                    this.wplib.loescheWertPosition(this.wplib.wertPosition());
                    return;
                }
                case 130540: {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferField01())) {
                        gesamtesFiktivesEntgelt = gesamtesFiktivesEntgelt.add(lElement.getBufferField01());
                        continue block10;
                    }
                    gesamtesFiktivesEntgelt = gesamtesFiktivesEntgelt.add(lElement.getResult());
                    continue block10;
                }
                case 230110: {
                    if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2021, 6, 1).getDate())) continue block10;
                    gesamtesKugEntgelt = gesamtesKugEntgelt.add(lElement.getResult());
                    continue block10;
                }
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)gesamtesFiktivesEntgelt) && BigDecimalMapper.compareTo((BigDecimal)(gesamtEntgelt = this.mBeitragspflichtig.add(gesamtesFiktivesEntgelt)), (BigDecimal)this.mPvBBG) > 0) {
            this.mBeitragspflichtig = this.mBeitragspflichtig.multiply(this.mPvBBG).divide(gesamtEntgelt, 2, RoundingMode.HALF_UP);
        }
        if (this.mBeitragspflichtig.compareTo(BigDecimal.ZERO) == 0) {
            this.wplib.addNeueWertPosition(771190, BigDecimal.ZERO, BigDecimal.ZERO, this.mPVTage, BigDecimal.ZERO, this.mBeitragspflichtig, true);
            this.wplib.addNeueWertPosition(771110, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true);
            this.callib.kvAGZ(BigDecimal.ZERO);
            return;
        }
        if (this.mBeitragspflichtig.compareTo(this.mPvBBG) > 0) {
            this.mBeitragspflichtig = this.mPvBBG;
        }
        this.wplib.addNeueWertPosition(771190, BigDecimal.ZERO, BigDecimal.ZERO, this.mPVTage, BigDecimal.ZERO, this.mBeitragspflichtig, true);
        switch (this.eelib.marbAGZPPv()) {
            case 1: {
                this.ermittleAGZNachEntgelt(gesamtesKugEntgelt);
                break;
            }
            case 2: {
                this.ermittleAGZNachBBG(gesamtesKugEntgelt);
            }
        }
    }

    private void ermittleAGZNachBBG(BigDecimal kugEntgelt) throws BusinessDomainException {
        this.mMitarbeiterGesamtbeitrag = this.eelib.marbBeitrPPv();
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 7, 1).getDate()) && this.mMfB) {
            BigDecimal lfdBeitragsPflFuerMfB = this.mPvBBG;
            BigDecimal entgeltAndererAG = BigDecimal.ZERO;
            if (this.callib.dbbgVorhanden()) {
                entgeltAndererAG = this.callib.dbbgGAEGKV().subtract(lfdBeitragsPflFuerMfB);
            } else {
                ValuePosition[] vpArray;
                block3: for (ValuePosition valuePosition : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205}))) {
                    switch (valuePosition.getValueType().getValueTypeKey()) {
                        case 129200: 
                        case 129205: {
                            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getResult(), (BigDecimal)this.mPvBBG) > 0) {
                                    entgeltAndererAG = entgeltAndererAG.add(this.mPvBBG);
                                    continue block3;
                                }
                                entgeltAndererAG = entgeltAndererAG.add(valuePosition.getResult());
                                continue block3;
                            }
                            entgeltAndererAG = entgeltAndererAG.add(valuePosition.getResult());
                            continue block3;
                        }
                    }
                }
            }
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(339595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, entgeltAndererAG, true);
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPvBBG)) {
                this.mMitarbeiterGesamtbeitrag = BigDecimal.ZERO;
            } else if (BigDecimalMapper.compareTo((BigDecimal)lfdBeitragsPflFuerMfB.add(entgeltAndererAG), (BigDecimal)BigDecimal.ZERO) > 0) {
                this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(lfdBeitragsPflFuerMfB).divide(lfdBeitragsPflFuerMfB.add(entgeltAndererAG), 2, RoundingMode.HALF_UP);
                this.mPvBBG = this.mPvBBG.multiply(lfdBeitragsPflFuerMfB).divide(lfdBeitragsPflFuerMfB.add(entgeltAndererAG), 2, RoundingMode.HALF_UP);
            }
        }
        this.wplib.addNeueWertPosition(771110, this.mMitarbeiterGesamtbeitrag);
        this.mMitarbeiterGesamtbeitrag = this.anrechnungKUGEntgelt(kugEntgelt, this.mPvBBG, this.mMitarbeiterGesamtbeitrag);
        BigDecimal gesamtBeitrag = this.mPvBBG.multiply(this.gllib.svBsGesamtPV()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        BigDecimal agZuschuss = gesamtBeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        BigDecimal halberGesamtbeitrag = BigDecimal.ZERO;
        halberGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.compareTo(gesamtBeitrag) < 0 ? this.mMitarbeiterGesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP) : gesamtBeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        if (halberGesamtbeitrag.compareTo(agZuschuss) < 0) {
            agZuschuss = halberGesamtbeitrag;
        }
        this.callib.pvAGZ(agZuschuss);
    }

    private void ermittleAGZNachEntgelt(BigDecimal kugEntgelt) throws BusinessDomainException {
        BigDecimal agZuschuss;
        block16: {
            block17: {
                BigDecimal entgeltLfdAndererAG;
                BigDecimal entgeltLfdEigenerAG;
                block19: {
                    ValuePosition[] lVpArray;
                    block18: {
                        ValuePosition[] vpArray;
                        BigDecimal dbbgSvTage;
                        this.mMitarbeiterGesamtbeitrag = this.eelib.marbBeitrPPv();
                        agZuschuss = BigDecimal.ZERO;
                        if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 7, 1).getDate())) break block16;
                        if (!this.mMfB) break block17;
                        entgeltLfdEigenerAG = BigDecimal.ZERO;
                        entgeltLfdAndererAG = BigDecimal.ZERO;
                        BigDecimal gesEntgeltBeideAG = BigDecimal.ZERO;
                        BigDecimal eigeneBBG = this.gllib.svBbgKvPv();
                        BigDecimal dbbgBBG = this.gllib.svBbgKvPv();
                        if (!this.callib.dbbgVorhanden()) break block18;
                        BigDecimal dbbgEntgelt = this.callib.dbbgGAEGKV();
                        if (dbbgEntgelt.compareTo(BigDecimal.ZERO) == 0) break block19;
                        BigDecimal bigDecimal = dbbgSvTage = BigDecimalMapper.isZero((BigDecimal)BigDecimal.valueOf(this.callib.dbbgSVTG())) ? DREISSIG : BigDecimal.valueOf(this.callib.dbbgSVTG());
                        if (BigDecimalMapper.compareTo((BigDecimal)dbbgSvTage, (BigDecimal)DREISSIG) != 0) {
                            dbbgBBG = dbbgBBG.multiply(dbbgSvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        }
                        for (ValuePosition valuePosition : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510}))) {
                            entgeltLfdEigenerAG = entgeltLfdEigenerAG.add(valuePosition.getResult());
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)DREISSIG) != 0) {
                            eigeneBBG = eigeneBBG.multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)entgeltLfdEigenerAG, (BigDecimal)eigeneBBG) > 0) {
                            entgeltLfdEigenerAG = eigeneBBG;
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)(entgeltLfdAndererAG = (gesEntgeltBeideAG = dbbgEntgelt).subtract(entgeltLfdEigenerAG)), (BigDecimal)BigDecimal.ZERO) >= 0) break block19;
                        entgeltLfdAndererAG = BigDecimal.ZERO;
                        break block19;
                    }
                    for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510}))) {
                        entgeltLfdEigenerAG = entgeltLfdEigenerAG.add(valuePosition.getResult());
                    }
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && entgeltLfdEigenerAG.compareTo(this.mPvBBG) > 0) {
                        entgeltLfdEigenerAG = this.mPvBBG;
                    }
                    for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205}))) {
                        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                            if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getResult(), (BigDecimal)this.mPvBBG) > 0) {
                                entgeltLfdAndererAG = entgeltLfdAndererAG.add(this.mPvBBG);
                                continue;
                            }
                            entgeltLfdAndererAG = entgeltLfdAndererAG.add(valuePosition.getResult());
                            continue;
                        }
                        entgeltLfdAndererAG = entgeltLfdAndererAG.add(valuePosition.getResult());
                    }
                }
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPvBBG)) {
                    this.mMitarbeiterGesamtbeitrag = BigDecimal.ZERO;
                } else if (BigDecimalMapper.compareTo((BigDecimal)entgeltLfdEigenerAG.add(entgeltLfdAndererAG), (BigDecimal)BigDecimal.ZERO) > 0) {
                    this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(entgeltLfdEigenerAG).divide(entgeltLfdEigenerAG.add(entgeltLfdAndererAG), 2, RoundingMode.HALF_UP);
                    this.mPvBBG = this.mPvBBG.multiply(entgeltLfdEigenerAG).divide(entgeltLfdEigenerAG.add(entgeltLfdAndererAG), 2, RoundingMode.HALF_UP);
                }
            }
            if (this.mBeitragspflichtig.compareTo(this.mPvBBG) > 0) {
                this.mBeitragspflichtig = this.mPvBBG;
            }
            this.wplib.addNeueWertPosition(771110, this.mMitarbeiterGesamtbeitrag);
            this.mMitarbeiterGesamtbeitrag = this.anrechnungKUGEntgelt(kugEntgelt, this.mBeitragspflichtig, this.mMitarbeiterGesamtbeitrag);
            if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)DREISSIG) != 0) {
                this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
            agZuschuss = this.mBeitragspflichtig.multiply(this.mAGAnteilPv).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            BigDecimal gesamtBeitrag = this.mBeitragspflichtig.multiply(this.gllib.svBsGesamtPV()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            BigDecimal halberGesamtbeitrag = BigDecimal.ZERO;
            halberGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.compareTo(gesamtBeitrag) < 0 ? this.mMitarbeiterGesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP) : gesamtBeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            if (halberGesamtbeitrag.compareTo(agZuschuss) < 0) {
                agZuschuss = halberGesamtbeitrag;
            }
            BigDecimal fiktSvTage = this.getSVTageUnterBeruecksichtigungFehlzeiten();
            if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)fiktSvTage) != 0) {
                agZuschuss = agZuschuss.multiply(fiktSvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
        }
        this.callib.pvAGZ(agZuschuss);
    }

    private void ermittlungKug() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771120, 771190, 230110}));
        BigDecimal kugEntgeltImMonat = BigDecimal.ZERO;
        BigDecimal aufgelaufenesEntgeltPPV = BigDecimal.ZERO;
        block5: for (ValuePosition lElement : vpArray) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 230110: {
                    kugEntgeltImMonat = kugEntgeltImMonat.add(lElement.getResult());
                    continue block5;
                }
                case 771120: {
                    this.mAGZuschussAufgelaufen = this.mAGZuschussAufgelaufen.add(lElement.getResult());
                    continue block5;
                }
                case 771190: {
                    aufgelaufenesEntgeltPPV = aufgelaufenesEntgeltPPV.add(lElement.getResult());
                    continue block5;
                }
            }
        }
        BigDecimal pvTage = this.wplib.svTageLfd();
        if (this.callib.dbbgVorhanden() && BigDecimal.valueOf(this.callib.dbbgSVTG()).compareTo(pvTage) > 0) {
            pvTage = BigDecimal.valueOf(this.callib.dbbgSVTG());
        }
        this.mPvBBG = this.gllib.svBbgKvPv().multiply(pvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        if (aufgelaufenesEntgeltPPV.add(kugEntgeltImMonat).compareTo(this.mPvBBG) > 0) {
            kugEntgeltImMonat = this.mPvBBG.subtract(aufgelaufenesEntgeltPPV);
        }
        if (kugEntgeltImMonat.compareTo(BigDecimal.ZERO) < 0) {
            kugEntgeltImMonat = BigDecimal.ZERO;
        }
        this.modifizierePPVEntgelt(kugEntgeltImMonat);
        BigDecimal agZuschuss = this.getAGZKUG(kugEntgeltImMonat);
        BigDecimal gesamtBeitrag = this.eelib.marbBeitrPPv();
        if (agZuschuss.add(this.mAGZuschussAufgelaufen).compareTo(gesamtBeitrag) > 0) {
            agZuschuss = gesamtBeitrag.subtract(this.mAGZuschussAufgelaufen);
        }
        this.callib.pvAGZ(agZuschuss);
    }

    private BigDecimal anrechnungKUGEntgelt(BigDecimal kugEntgelt, BigDecimal beitragspflichtig, BigDecimal mitarbeiterGesamtbeitrag) throws BusinessDomainException {
        BigDecimal agzKug;
        BigDecimal marbGesamtbeitrag;
        if (beitragspflichtig.add(kugEntgelt).compareTo(this.mPvBBG) > 0) {
            kugEntgelt = this.mPvBBG.subtract(beitragspflichtig);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)(marbGesamtbeitrag = mitarbeiterGesamtbeitrag.subtract(agzKug = this.getAGZKUG(kugEntgelt))), (BigDecimal)BigDecimal.ZERO) < 0) {
            marbGesamtbeitrag = BigDecimal.ZERO;
        }
        return marbGesamtbeitrag;
    }

    private BigDecimal getAGZKUG(BigDecimal kugEntgelt) throws BusinessDomainException {
        BigDecimal agzKUG = BigDecimal.ZERO;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kugEntgelt)) {
            agzKUG = kugEntgelt.multiply(this.mAGAnteilPv).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            agzKUG = agzKUG.add(kugEntgelt.multiply(this.mANAnteilPv).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        }
        return agzKUG;
    }

    private void ermittlungEGA() throws BusinessDomainException {
        ValuePosition[] vpArray;
        this.fuelleJahresWerte();
        BigDecimal entgeltLfd = BigDecimal.ZERO;
        BigDecimal gesamtBeitragLfdAktuellerMonat = BigDecimal.ZERO;
        BigDecimal lBeitragspflichtig = BigDecimal.ZERO;
        BigDecimal aktuellesEGA = BigDecimal.ZERO;
        block8: for (ValuePosition vp : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771110, 771120, 771190, 130610, 130620, 130650, 130590, 129200}))) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 771110: {
                    this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.add(vp.getResult());
                    gesamtBeitragLfdAktuellerMonat = gesamtBeitragLfdAktuellerMonat.add(vp.getResult());
                    continue block8;
                }
                case 771120: {
                    this.mAGZuschussAufgelaufen = this.mAGZuschussAufgelaufen.add(vp.getResult());
                    continue block8;
                }
                case 771190: {
                    entgeltLfd = entgeltLfd.add(vp.getResult());
                }
                case 129200: {
                    lBeitragspflichtig = lBeitragspflichtig.add(vp.getResult());
                    this.mBeitragspflichtig = this.mBeitragspflichtig.add(vp.getResult());
                    continue block8;
                }
                case 130590: {
                    this.mPVTageAufgelaufen = this.mPVTageAufgelaufen.add(vp.getFactor1());
                    continue block8;
                }
                case 130610: 
                case 130620: 
                case 130650: {
                    aktuellesEGA = aktuellesEGA.add(vp.getResult());
                    continue block8;
                }
            }
        }
        this.mPvBBG = this.gllib.svBbgKvPvJaehrl().multiply(this.mPVTageAufgelaufen).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP);
        BigDecimal pvLuft = this.mPvBBG.subtract(this.mBeitragspflichtig);
        if (!BigDecimalMapper.isZero((BigDecimal)this.eelib.vortragSozialVersicherungPVLuft(this.wplib.gueltigAb()))) {
            pvLuft = pvLuft.add(this.eelib.vortragSozialVersicherungPVLuft(this.wplib.gueltigAb()));
        }
        if (aktuellesEGA.compareTo(pvLuft) >= 0) {
            aktuellesEGA = pvLuft;
        }
        if (aktuellesEGA.compareTo(BigDecimal.ZERO) < 0) {
            aktuellesEGA = BigDecimal.ZERO;
        }
        BigDecimal agZuschuss = BigDecimal.ZERO;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)aktuellesEGA)) {
            this.modifizierePPVEntgelt(aktuellesEGA);
            if (!this.mMfB) {
                BigDecimal halberGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                agZuschuss = aktuellesEGA.multiply(this.mAGAnteilPv).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                if (agZuschuss.compareTo(BigDecimal.ZERO) != 0 && this.mAGZuschussAufgelaufen.add(agZuschuss).compareTo(halberGesamtbeitrag) > 0) {
                    agZuschuss = halberGesamtbeitrag.subtract(this.mAGZuschussAufgelaufen);
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && agZuschuss.compareTo(BigDecimal.ZERO) < 0) {
                        agZuschuss = BigDecimal.ZERO;
                    }
                }
            } else {
                this.mMitarbeiterGesamtbeitrag = this.eelib.marbBeitrPPv();
                BigDecimal beitrag = BigDecimal.ZERO;
                if (!BigDecimalMapper.isZero((BigDecimal)lBeitragspflichtig.add(aktuellesEGA))) {
                    beitrag = entgeltLfd.add(aktuellesEGA).multiply(this.mMitarbeiterGesamtbeitrag).divide(lBeitragspflichtig.add(aktuellesEGA), 2, RoundingMode.HALF_UP);
                }
                BigDecimal gesamtbeitrag = beitrag.subtract(gesamtBeitragLfdAktuellerMonat);
                agZuschuss = DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.DOWN) : gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                this.modifizierePPVBeitraege(gesamtbeitrag);
            }
        }
        this.callib.pvAGZ(agZuschuss);
    }

    private void modifizierePPVEntgelt(BigDecimal decimal) throws BusinessDomainException {
        if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771190}));
            if (vpArray.length == 0) {
                this.wplib.addNeueWertPosition(771190, decimal);
            } else {
                vpArray[0].setResult(vpArray[0].getResult().add(decimal));
            }
        }
    }

    private void modifizierePPVBeitraege(BigDecimal decimal) throws BusinessDomainException {
        if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771110}));
            if (vpArray.length == 0) {
                this.wplib.addNeueWertPosition(771110, decimal);
            } else {
                vpArray[0].setResult(vpArray[0].getResult().add(decimal));
            }
        }
    }

    private void fuelleJahresWerte() throws BusinessDomainException {
        Date start = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        Date aktuellerMonat = DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb());
        while (DateHelper.before((Date)start, (Date)aktuellerMonat)) {
            ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)start), DateHelper.getLastDayOfMonth((Date)start), ValueTypeHelper.getValueTypes((int[])new int[]{771190, 339595, 130590, 771090, 771100, 339510}));
            BigDecimal svTage = BigDecimal.ZERO;
            BigDecimal pvEntgeltGKV = BigDecimal.ZERO;
            BigDecimal lBeitragspflichtig = BigDecimal.ZERO;
            block10: for (ValuePosition vp : vpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 339595: 
                    case 771190: {
                        lBeitragspflichtig = lBeitragspflichtig.add(vp.getResult());
                        this.mBeitragspflichtig = this.mBeitragspflichtig.add(vp.getResult());
                        continue block10;
                    }
                    case 130590: {
                        svTage = svTage.add(vp.getFactor1());
                        continue block10;
                    }
                    case 339510: 
                    case 771090: 
                    case 771100: {
                        pvEntgeltGKV = pvEntgeltGKV.add(vp.getResult());
                    }
                }
            }
            if (BigDecimalMapper.isZero((BigDecimal)pvEntgeltGKV)) {
                this.mPVTageAufgelaufen = this.mPVTageAufgelaufen.add(svTage);
            }
            block11: for (ValuePosition vp : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)start), DateHelper.getLastDayOfMonth((Date)start), ValueTypeHelper.getValueTypes((int[])new int[]{771110, 771120, 771130}))) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 771110: {
                        this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.add(vp.getResult());
                        continue block11;
                    }
                    case 771120: 
                    case 771130: {
                        this.mAGZuschussAufgelaufen = this.mAGZuschussAufgelaufen.add(vp.getResult());
                        continue block11;
                    }
                }
            }
            start = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)start));
        }
    }

    private BigDecimal getSVTageUnterBeruecksichtigungFehlzeiten() throws BusinessDomainException {
        BigDecimal svtage = this.wplib.svTageLfd();
        BigDecimal tempFehltage = this.getFehltage(this.wplib.gueltigAb());
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempFehltage) && BigDecimalMapper.compareTo((BigDecimal)(svtage = svtage.subtract(tempFehltage)), (BigDecimal)BigDecimal.ZERO) < 0) {
            svtage = BigDecimal.ZERO;
        }
        return svtage;
    }

    private BigDecimal getFehltage(Date validDate) throws BusinessDomainException {
        BigDecimal fehltage = BigDecimal.ZERO;
        String fehlzeitSchluessel = "";
        String[] fehlzeiten = new String[]{"KAP"};
        EEAbsentTimeTP[] eeAbsentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(validDate);
        if (eeAbsentTimeTPs != null) {
            for (EEAbsentTimeTP eeAbsentTimeTP : eeAbsentTimeTPs) {
                fehlzeitSchluessel = eeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey();
                for (String fehlzeit : fehlzeiten) {
                    Date fehlzeitBis;
                    if (!StringMapper.equal((String)fehlzeitSchluessel, (String)fehlzeit)) continue;
                    Date fehlzeitAb = DateHelper.before((Date)eeAbsentTimeTP.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)validDate)) ? DateHelper.getFirstDayOfMonth((Date)validDate) : eeAbsentTimeTP.getValidFrom();
                    Date beginnDatumFuerSVTageKuerzung = this.getBeginnDatumFuerSVTageKuerzung(eeAbsentTimeTP.getValidFrom());
                    Date date = fehlzeitBis = DateHelper.before((Date)beginnDatumFuerSVTageKuerzung, (Date)eeAbsentTimeTP.getValidUntil()) ? beginnDatumFuerSVTageKuerzung : eeAbsentTimeTP.getValidUntil();
                    if (!DateHelper.afterOrEqual((Date)beginnDatumFuerSVTageKuerzung, (Date)DateHelper.getFirstDayOfMonth((Date)validDate))) continue;
                    if (DateHelper.after((Date)fehlzeitBis, (Date)DateHelper.getLastDayOfMonth((Date)validDate))) {
                        fehlzeitBis = DateHelper.getLastDayOfMonth((Date)validDate);
                    }
                    fehltage = fehltage.add(BigDecimal.valueOf(DateHelper.getDiffInDays((Date)fehlzeitBis, (Date)fehlzeitAb)).add(BigDecimal.ONE).setScale(0));
                }
            }
        }
        return fehltage;
    }

    private Date getBeginnDatumFuerSVTageKuerzung(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        cal.set(2, cal.get(2) + 1);
        return cal.getTime();
    }
}

