/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungSVEntgeltMfBFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class PVBeitragsermittlungFreiwillig2013Formula {
    private static final BigDecimal _2 = BigDecimal.valueOf(2L);
    private static final BigDecimal _30 = BigDecimal.valueOf(30L);
    private static final BigDecimal _100 = BigDecimal.valueOf(100L);
    private static final BigDecimal _360 = BigDecimal.valueOf(360L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mPvBeitragssatzAG = BigDecimal.ZERO;
    private BigDecimal mPvBeitragssatzAN = BigDecimal.ZERO;
    private BigDecimal mPvGesamtbeitragAN = BigDecimal.ZERO;
    private BigDecimal mPvGesamtbeitragAG = BigDecimal.ZERO;
    private BigDecimal mPvZuschussGrundlage = BigDecimal.ZERO;
    private BigDecimal mPvEntgelt100AGImMonat = BigDecimal.ZERO;
    private BigDecimal mPvAgz = BigDecimal.ZERO;
    private BigDecimal mDifferenzAN = BigDecimal.ZERO;
    private BigDecimal mDifferenzAG = BigDecimal.ZERO;
    private BigDecimal mMaxPvAgz = BigDecimal.ZERO;
    private BigDecimal mAufgelANA = BigDecimal.ZERO;
    private BigDecimal mAufgelEntgeltKUG = BigDecimal.ZERO;
    private BigDecimal mAufgelSVTage = BigDecimal.ZERO;
    private BigDecimal mSvLuft = BigDecimal.ZERO;
    private BigDecimal mAktuellesEGA = BigDecimal.ZERO;
    private BigDecimal mBeitragspflichtigAndererAG = BigDecimal.ZERO;
    private BigDecimal mAufgelAGZFaehig = BigDecimal.ZERO;
    private boolean mIsLKK;
    private boolean mIsFirmenzahler = true;

    public PVBeitragsermittlungFreiwillig2013Formula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void pvBeitragsermittlung() throws BusinessDomainException {
        HealthFund hf;
        if (this.mEeLib.marbBgrKv() == 0) {
            this.mIsFirmenzahler = false;
        }
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) && (hf = this.mEeLib.marbKrk()) != null && hf.getHealthFundTP(this.mVpLib.wirksamAb(), this.mVpLib.gueltigAb()).getTypeOfHealthFundEnum() == TypeOfHealthFundEnum.TOHF_LKK) {
            this.mIsLKK = true;
        }
        BigDecimal pvTage = this.mVpLib.svTage();
        if (this.mCalLib.dbbgVorhanden() && BigDecimal.valueOf(this.mCalLib.dbbgSVTG()).compareTo(pvTage) > 0) {
            pvTage = BigDecimal.valueOf(this.mCalLib.dbbgSVTG());
        }
        BigDecimal pvBBG = this.ermittleBBG(pvTage);
        switch (this.mVpLib.wertartenNummer()) {
            case 771020: {
                if (this.mIsLKK) {
                    this.zuschussErmittlungLKKLfd(pvBBG, pvTage);
                    break;
                }
                this.zuschussErmittlungLfd(pvBBG, pvTage);
                break;
            }
            case 771030: {
                if (this.mIsLKK) break;
                this.zuschussErmittlungEGA();
                break;
            }
            case 771040: {
                if (this.mIsLKK) break;
                this.zuschussErmittlungKug(pvBBG);
                break;
            }
            case 771050: {
                if (!this.mIsLKK && this.mIsFirmenzahler) {
                    this.zuschussErmittlung100AG(pvBBG);
                    break;
                }
                this.mVpLib.wertPosition().makeReadOnly();
                break;
            }
            default: {
                throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException((String)this.getClass().getName(), (int)this.mVpLib.wertartenNummer());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void zuschussErmittlungLfd(BigDecimal pvBBG, BigDecimal pvTage) throws BusinessDomainException {
        void var9_18;
        ValuePosition[] vpArray;
        boolean isKUG;
        this.mPvBeitragssatzAG = this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15 ? this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP) : this.mGlLib.bulaPvAga();
        this.mPvBeitragssatzAN = this.mGlLib.svBsGesamtPV();
        if (this.mEeLib.marbBgrPv() == 2) {
            this.mPvBeitragssatzAG = this.mPvBeitragssatzAG.divide(_2, 4, RoundingMode.HALF_UP);
            this.mPvBeitragssatzAN = this.mPvBeitragssatzAN.divide(_2, 4, RoundingMode.HALF_UP);
        }
        if (this.mEeLib.marbAelterDreiUndZwanzig() && !this.mEeLib.isMarbKindErz()) {
            this.mPvBeitragssatzAN = this.mPvBeitragssatzAN.add(this.mGlLib.svBsKinderlosPV());
        }
        BigDecimal pvBeitragssatzAbschlagKi = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2023, 6, 1).getDate())) {
            pvBeitragssatzAbschlagKi = this.mEeLib.pVAbschlagKinder();
            this.mPvBeitragssatzAN = this.mPvBeitragssatzAN.subtract(pvBeitragssatzAbschlagKi);
        }
        BigDecimal gesamtbeitragPVAllgemein = this.mGlLib.krkGesBeitragBklAllgemeinAGZPV();
        BigDecimal zuschussKinderlos = this.mGlLib.krkGesBeitragBklAlllgemeinPV().subtract(this.mGlLib.krkGesBeitragBklAllgemeinAGZPV());
        switch (this.mEeLib.marbBklFPv().value()) {
            case 1: {
                this.mPvGesamtbeitragAN = !this.mEeLib.isMarbKindErz() && this.mEeLib.marbAelterDreiUndZwanzig() ? (this.mEeLib.marbBgrPv() == 2 ? gesamtbeitragPVAllgemein.divide(_2, 2, RoundingMode.HALF_UP).add(zuschussKinderlos) : gesamtbeitragPVAllgemein.add(zuschussKinderlos)) : (this.mEeLib.marbBgrPv() == 2 ? gesamtbeitragPVAllgemein.divide(_2, 2, RoundingMode.HALF_UP) : gesamtbeitragPVAllgemein);
                if (this.mEeLib.marbBgrPv() == 2) {
                    this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAllgemeinAGZPV().divide(_2, 2, RoundingMode.HALF_UP);
                    break;
                }
                this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAllgemeinAGZPV();
                break;
            }
        }
        if (this.mCalLib.dbbgVorhanden() && BigDecimal.valueOf(this.mCalLib.dbbgSVTG()).compareTo(pvTage) > 0) {
            pvTage = BigDecimal.valueOf(this.mCalLib.dbbgSVTG());
        }
        if (pvTage.compareTo(_30) != 0) {
            this.mPvGesamtbeitragAN = this.mPvGesamtbeitragAN.multiply(pvTage).divide(_30, 2, RoundingMode.HALF_UP);
            this.mPvGesamtbeitragAG = this.mPvGesamtbeitragAG.multiply(pvTage).divide(_30, 2, RoundingMode.HALF_UP);
        }
        boolean bl = isKUG = this.checkKugImMonat() && this.mEeLib.marbBeitragsabsenkungBeiKuG();
        if (isKUG) {
            void var9_11;
            ValuePosition[] vpArray2 = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771090, 771100, 230110}));
            BigDecimal lPvEntgelt = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            BigDecimal lPvGesamtEntgeltKug = BigDecimal.ZERO;
            block14: for (ValuePosition vPos : vpArray2) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 230110: {
                        BigDecimal bigDecimal2 = var9_11.add(vPos.getResult());
                        continue block14;
                    }
                    default: {
                        lPvEntgelt = lPvEntgelt.add(vPos.getResult());
                    }
                }
            }
            lPvGesamtEntgeltKug = lPvEntgelt.add((BigDecimal)var9_11);
            if (lPvGesamtEntgeltKug.compareTo(this.mGlLib.svBbgKvPv()) > 0) {
                lPvGesamtEntgeltKug = this.mGlLib.svBbgKvPv();
            }
            BigDecimal lPvGesamtbeitragKug = BigDecimal.ZERO;
            if (lPvGesamtEntgeltKug.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal pvBeitragssatzKuG = this.mGlLib.svBsGesamtPV();
                if (!this.mEeLib.isMarbKindErz() && this.mEeLib.marbAelterDreiUndZwanzig()) {
                    pvBeitragssatzKuG = pvBeitragssatzKuG.add(this.mGlLib.svBsKinderlosPV());
                }
                lPvGesamtbeitragKug = DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? lPvGesamtEntgeltKug.multiply(pvBeitragssatzKuG).divide(_100, 2, RoundingMode.UP) : lPvGesamtEntgeltKug.multiply(pvBeitragssatzKuG).divide(_100, 2, RoundingMode.HALF_UP);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)pvBeitragssatzAbschlagKi)) {
                    lPvGesamtbeitragKug = lPvGesamtbeitragKug.subtract(lPvEntgelt.multiply(pvBeitragssatzAbschlagKi).divide(_100, 2, RoundingMode.HALF_UP));
                }
            }
            if (lPvGesamtbeitragKug.compareTo(this.mPvGesamtbeitragAN) < 0) {
                this.mDifferenzAN = this.mPvGesamtbeitragAN.subtract(lPvGesamtbeitragKug);
                this.mPvGesamtbeitragAN = lPvGesamtbeitragKug;
            }
        }
        boolean is23c = this.check23c();
        this.mPvZuschussGrundlage = BigDecimal.ZERO;
        this.mPvEntgelt100AGImMonat = BigDecimal.ZERO;
        for (ValuePosition vp : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771090, 771100}))) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 771090: {
                    this.mPvZuschussGrundlage = this.mPvZuschussGrundlage.add(vp.getResult());
                    break;
                }
                case 771100: {
                    this.mPvEntgelt100AGImMonat = this.mPvEntgelt100AGImMonat.add(vp.getResult());
                }
            }
            vp.setPersistentBuffer1(BigDecimal.ONE);
        }
        BigDecimal bigDecimal = pvBBG;
        switch (this.mEeLib.marbAGZFPv()) {
            case 1: 
            case 2: {
                if (is23c || this.checkKugImJahr()) {
                    BigDecimal bigDecimal3 = this.ermittlungNachEntgelt(pvBBG, is23c);
                    break;
                }
                BigDecimal bigDecimal4 = this.ermittlungNachBBG(pvBBG);
                break;
            }
            case 3: {
                BigDecimal bigDecimal5 = this.ermittlungNachEntgelt(pvBBG, is23c);
                break;
            }
            default: {
                this.setFPVEntgelt(this.mPvZuschussGrundlage, pvBBG);
            }
        }
        BigDecimal aGZfaehigSatz = this.mPvBeitragssatzAG.multiply(_2).setScale(4, RoundingMode.HALF_UP);
        BigDecimal aGZFaehigBetrag = var9_18.multiply(aGZfaehigSatz).divide(_100, 2, RoundingMode.HALF_UP);
        BigDecimal anGesamtBeitrag = isKUG ? this.mPvGesamtbeitragAN : var9_18.multiply(this.mPvBeitragssatzAN).divide(_100, 2, RoundingMode.HALF_UP);
        if (this.mIsFirmenzahler) {
            this.mVpLib.addNeueWertPosition(771000, this.mPvBeitragssatzAN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, anGesamtBeitrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            this.mVpLib.addNeueWertPosition(771080, aGZfaehigSatz, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, aGZFaehigBetrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAG, BigDecimal.ZERO, BigDecimal.ZERO);
        } else {
            this.mVpLib.addNeueWertPosition(771010, this.mPvBeitragssatzAN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, anGesamtBeitrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            this.mVpLib.addNeueWertPosition(771080, aGZfaehigSatz, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, aGZFaehigBetrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAG, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    private void zuschussErmittlungLKKLfd(BigDecimal pvBBG, BigDecimal svTage) throws BusinessDomainException {
        Insurance insurance = this.mEeLib.marbVersicherungsdaten();
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)insurance.getERallowanceNIFarm())) {
            this.mPvGesamtbeitragAG = insurance.getERallowanceNIFarm();
            this.mPvGesamtbeitragAN = this.mPvGesamtbeitragAG.multiply(_2).setScale(2, RoundingMode.HALF_UP);
            this.mVpLib.addNeueWertPosition(771010, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mPvGesamtbeitragAN, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            if (svTage.compareTo(_30) != 0) {
                this.mPvGesamtbeitragAG = this.mPvGesamtbeitragAG.multiply(svTage).divide(_30, 2, RoundingMode.HALF_UP);
            }
            BigDecimal pVBeitragsVHSatzAG = BigDecimal.ZERO;
            pVBeitragsVHSatzAG = this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15 ? this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP) : this.mGlLib.bulaPvAga();
            if (this.mEeLib.marbBgrPv() == 2) {
                pVBeitragsVHSatzAG = pVBeitragsVHSatzAG.divide(_2, 4, RoundingMode.HALF_UP);
            }
            ValuePosition[] vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771090}));
            BigDecimal pvEntgeltFrw = BigDecimal.ZERO;
            for (ValuePosition vp : vpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 771090: {
                        pvEntgeltFrw = pvEntgeltFrw.add(vp.getResult());
                    }
                }
            }
            pvEntgeltFrw = BigDecimalMapper.compareTo((BigDecimal)pvEntgeltFrw, (BigDecimal)pvBBG) <= 0 ? pvEntgeltFrw : pvBBG;
            BigDecimal aGZFaehigBetrag = pvEntgeltFrw.multiply(pVBeitragsVHSatzAG).divide(_100, 2, RoundingMode.HALF_UP);
            this.mPvGesamtbeitragAG = BigDecimalMapper.compareTo((BigDecimal)this.mPvGesamtbeitragAG, (BigDecimal)aGZFaehigBetrag) <= 0 ? this.mPvGesamtbeitragAG : aGZFaehigBetrag;
        }
        this.mCalLib.pvAGZ(this.mPvGesamtbeitragAG);
        this.mCalLib.percentage(BigDecimal.ZERO);
    }

    private BigDecimal ermittlungNachBBG(BigDecimal pvBBG) throws BusinessDomainException {
        BigDecimal pvTage = this.mVpLib.svTage();
        if (this.mCalLib.dbbgVorhanden() && BigDecimal.valueOf(this.mCalLib.dbbgSVTG()).compareTo(pvTage) > 0) {
            pvTage = BigDecimal.valueOf(this.mCalLib.dbbgSVTG());
        }
        this.mPvZuschussGrundlage = pvBBG;
        this.setFPVEntgelt(this.mPvZuschussGrundlage, pvBBG);
        this.mPvAgz = this.mPvZuschussGrundlage.multiply(this.mPvBeitragssatzAG).divide(_100, 2, RoundingMode.HALF_UP);
        this.mMaxPvAgz = this.mPvGesamtbeitragAG.divide(_2, 2, RoundingMode.HALF_UP);
        if (this.mPvAgz.compareTo(this.mMaxPvAgz) > 0) {
            this.mPvAgz = this.mMaxPvAgz;
        }
        BigDecimal vHSatz = this.mPvBeitragssatzAG;
        this.mCalLib.percentage(vHSatz);
        this.mCalLib.pvAGZ(this.mPvAgz);
        return this.mPvZuschussGrundlage;
    }

    private BigDecimal ermittlungNachEntgelt(BigDecimal pvBBG, boolean is23c) throws BusinessDomainException {
        BigDecimal pvTage = this.mVpLib.svTage();
        if (this.mCalLib.dbbgVorhanden() && BigDecimal.valueOf(this.mCalLib.dbbgSVTG()).compareTo(pvTage) > 0) {
            pvTage = BigDecimal.valueOf(this.mCalLib.dbbgSVTG());
        }
        this.setFPVEntgelt(this.mPvZuschussGrundlage, pvBBG);
        BigDecimal gesamtesEntgelt = this.mPvZuschussGrundlage.add(this.mPvEntgelt100AGImMonat);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPvEntgelt100AGImMonat)) {
            if (gesamtesEntgelt.compareTo(pvBBG) > 0) {
                this.mPvZuschussGrundlage = this.mPvZuschussGrundlage.multiply(pvBBG).divide(gesamtesEntgelt, 2, RoundingMode.HALF_UP);
            }
        } else if (this.mPvZuschussGrundlage.compareTo(pvBBG) > 0) {
            this.mPvZuschussGrundlage = pvBBG;
        }
        if (gesamtesEntgelt.compareTo(pvBBG) > 0) {
            gesamtesEntgelt = pvBBG;
        }
        this.mPvAgz = this.mPvZuschussGrundlage.multiply(this.mPvBeitragssatzAG).divide(_100, 2, RoundingMode.HALF_UP);
        if (is23c) {
            BigDecimal normalerGesamtBeitrag = BigDecimal.valueOf(this.mPvGesamtbeitragAN.doubleValue());
            BigDecimal vHSatz = this.mEeLib.isMarbKindErz() ? this.mGlLib.svBsGesamtPV() : this.mGlLib.svBsGesamtPV().add(this.mGlLib.svBsKinderlosPV());
            ValuePosition[] vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{129530, 129525}));
            BigDecimal svFreibetrag = BigDecimal.ZERO;
            BigDecimal sachbezug = BigDecimal.ZERO;
            BigDecimal tempSVTage = _30;
            block4: for (ValuePosition vp : vpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 129525: {
                        svFreibetrag = svFreibetrag.add(vp.getResult());
                        continue block4;
                    }
                    case 129530: {
                        sachbezug = sachbezug.add(vp.getResult());
                        tempSVTage = vp.getFactor1();
                    }
                }
            }
            BigDecimal ueberschreitung = BigDecimal.ZERO;
            if (BigDecimalMapper.compareTo((BigDecimal)svFreibetrag, (BigDecimal)sachbezug) < 0) {
                ueberschreitung = sachbezug.subtract(svFreibetrag);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempSVTage) && BigDecimalMapper.compareTo((BigDecimal)tempSVTage, (BigDecimal)_30) != 0) {
                    ueberschreitung = ueberschreitung.multiply(tempSVTage).divide(_30, 2, RoundingMode.HALF_UP);
                }
            }
            BigDecimal tempBBG = pvBBG;
            if (BigDecimalMapper.compareTo((BigDecimal)tempSVTage, (BigDecimal)_30) != 0 && BigDecimalMapper.compareTo((BigDecimal)pvTage, (BigDecimal)_30) == 0) {
                tempBBG = pvBBG.multiply(tempSVTage).divide(_30, 2, RoundingMode.HALF_UP);
            }
            BigDecimal kvArbeitsphase = tempBBG.multiply(vHSatz).divide(_100, 2, RoundingMode.HALF_UP);
            BigDecimal kvKrankheitsphase = ueberschreitung.multiply(vHSatz).divide(_100, 2, RoundingMode.HALF_UP);
            this.mPvGesamtbeitragAN = kvArbeitsphase.add(kvKrankheitsphase);
            this.mDifferenzAN = normalerGesamtBeitrag.subtract(this.mPvGesamtbeitragAN);
            normalerGesamtBeitrag = BigDecimal.valueOf(this.mPvGesamtbeitragAG.doubleValue());
            vHSatz = this.mGlLib.svBsGesamtPV();
            this.mPvGesamtbeitragAG = this.mPvZuschussGrundlage.multiply(vHSatz).divide(_100, 2, RoundingMode.HALF_UP);
            this.mDifferenzAG = normalerGesamtBeitrag.subtract(this.mPvBeitragssatzAG);
        }
        this.mMaxPvAgz = this.mPvGesamtbeitragAG.divide(_2, 2, RoundingMode.HALF_UP);
        if (this.mMaxPvAgz.compareTo(this.mPvAgz) < 0) {
            this.mPvAgz = this.mMaxPvAgz;
        }
        BigDecimal vHSatz = this.mPvBeitragssatzAG;
        this.mCalLib.percentage(vHSatz);
        this.mCalLib.pvAGZ(this.mPvAgz);
        return is23c ? gesamtesEntgelt : pvBBG;
    }

    private BigDecimal ermittleBBG(BigDecimal pvTage) throws BusinessDomainException {
        BigDecimal result = this.mGlLib.svBbgKvPv();
        if (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrKvAndererAG() != 6) {
            BigDecimal dbbgKVEntgelt = BigDecimal.ZERO;
            if (this.mCalLib.dbbgVorhanden()) {
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    if (StringMapper.compareTo((String)this.mCalLib.dbbgKVLBBG(), (String)"J") == 0) {
                        dbbgKVEntgelt = this.mCalLib.dbbgGAEGKV();
                    }
                } else {
                    dbbgKVEntgelt = this.mCalLib.dbbgGAEGKV();
                }
            }
            result = this.pvBBGBeiBeitragsteilung(result, pvTage, dbbgKVEntgelt);
        } else if (BigDecimalMapper.compareTo((BigDecimal)pvTage, (BigDecimal)_30) != 0) {
            result = result.multiply(pvTage).divide(_30, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    private BigDecimal pvBBGBeiBeitragsteilung(BigDecimal pvBBG, BigDecimal pvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getBBGBeiBeitragsteilungEigenerRK(pvBBG, pvTage, dbbgKVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(339595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private boolean checkKugImJahr() throws BusinessDomainException {
        Date suchdatum = DateHelper.getFirstDayOfYear((Date)this.mCalLib.berchnungGueltigAb());
        boolean kugGefunden = false;
        while (DateHelper.beforeOrEqual((Date)suchdatum, (Date)this.mCalLib.berchnungGueltigAb()) && !kugGefunden) {
            ValuePosition[] vpArray;
            for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungWirksamAb()), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes((int[])new int[]{230110}))) {
                if (vPos.getResult().compareTo(BigDecimal.ZERO) <= 0) continue;
                kugGefunden = true;
            }
            suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
        }
        return kugGefunden;
    }

    private boolean checkKugImMonat() throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungWirksamAb()), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{230510})).length != 0;
    }

    private boolean check23c() throws BusinessDomainException {
        return this.mCalLib.getCalculationCase().isSignedAs23cSGBIV() || this.mVpLib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes((int[])new int[]{129610})).compareTo(BigDecimal.ZERO) != 0;
    }

    private void zuschussErmittlungKug(BigDecimal pvBBG) throws BusinessDomainException {
        ValuePosition[] vpArray;
        if (this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15) {
            this.mPvBeitragssatzAG = this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP);
            this.mPvBeitragssatzAN = this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP);
        } else {
            this.mPvBeitragssatzAG = this.mGlLib.bulaPvAga();
            this.mPvBeitragssatzAN = this.mGlLib.svBsGesamtPV().subtract(this.mPvBeitragssatzAG);
        }
        switch (this.mEeLib.marbBklFPv().value()) {
            case 1: {
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 0, 1).getDate())) {
                    this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAlllgemeinPV();
                    break;
                }
                if (!this.mEeLib.marbAelterDreiUndZwanzig() || this.mEeLib.isMarbKindErz()) {
                    this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAllgemeinAGZPV();
                    break;
                }
                this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAlllgemeinPV();
                break;
            }
        }
        BigDecimal aufgelEntgeltFPV = BigDecimal.ZERO;
        BigDecimal kugEntgeltImMonat = BigDecimal.ZERO;
        BigDecimal aufgelAGZ = BigDecimal.ZERO;
        block8: for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771020, 771090, 771100, 230110}))) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 230110: {
                    kugEntgeltImMonat = kugEntgeltImMonat.add(vPos.getResult());
                    continue block8;
                }
                case 771020: {
                    aufgelAGZ = aufgelAGZ.add(vPos.getResult());
                    continue block8;
                }
                case 771090: 
                case 771100: {
                    aufgelEntgeltFPV = aufgelEntgeltFPV.add(vPos.getResult());
                    continue block8;
                }
                default: {
                    throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException((String)this.getClass().getName(), (int)vPos.getValueType().getValueTypeKey());
                }
            }
        }
        if (aufgelEntgeltFPV.add(kugEntgeltImMonat).compareTo(pvBBG) > 0) {
            kugEntgeltImMonat = pvBBG.subtract(aufgelEntgeltFPV);
        }
        if (kugEntgeltImMonat.compareTo(BigDecimal.ZERO) < 0) {
            kugEntgeltImMonat = BigDecimal.ZERO;
        }
        if (DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            this.modifiziereFPVEntgelt(kugEntgeltImMonat);
        }
        this.mPvAgz = kugEntgeltImMonat.multiply(this.mPvBeitragssatzAG.add(this.mPvBeitragssatzAN)).divide(_100, 2, RoundingMode.HALF_UP);
        if (aufgelAGZ.add(this.mPvAgz).compareTo(this.mPvGesamtbeitragAG) > 0) {
            this.mPvAgz = this.mPvGesamtbeitragAG.subtract(aufgelAGZ);
        }
        this.mCalLib.percentage(this.mPvBeitragssatzAG.add(this.mPvBeitragssatzAN));
        this.mCalLib.pvAGZ(this.mPvAgz);
    }

    private void zuschussErmittlung100AG(BigDecimal pvBBG) throws BusinessDomainException {
        ValuePosition genesis;
        ValuePosition[] vpArray;
        if (this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15) {
            this.mPvBeitragssatzAG = this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP);
            this.mPvBeitragssatzAN = this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP);
        } else {
            this.mPvBeitragssatzAG = this.mGlLib.bulaPvAga();
            this.mPvBeitragssatzAN = this.mGlLib.svBsGesamtPV().subtract(this.mPvBeitragssatzAG);
        }
        switch (this.mEeLib.marbBklFPv().value()) {
            case 1: {
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 0, 1).getDate())) {
                    this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAlllgemeinPV();
                    break;
                }
                if (!this.mEeLib.marbAelterDreiUndZwanzig() || this.mEeLib.isMarbKindErz()) {
                    this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAllgemeinAGZPV();
                    break;
                }
                this.mPvGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAlllgemeinPV();
                break;
            }
        }
        BigDecimal aufgelEntgeltFPV = BigDecimal.ZERO;
        BigDecimal entgelt100AGImMonat = BigDecimal.ZERO;
        BigDecimal aufgelAGZ = BigDecimal.ZERO;
        block8: for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{771020, 771090, 771100}))) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 771100: {
                    entgelt100AGImMonat = entgelt100AGImMonat.add(vPos.getResult());
                    continue block8;
                }
                case 771020: {
                    aufgelAGZ = aufgelAGZ.add(vPos.getResult());
                    continue block8;
                }
                case 771090: {
                    aufgelEntgeltFPV = aufgelEntgeltFPV.add(vPos.getResult());
                    continue block8;
                }
                default: {
                    throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException((String)this.getClass().getName(), (int)vPos.getValueType().getValueTypeKey());
                }
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)aufgelEntgeltFPV)) {
            BigDecimal gesamtesEntgelt = aufgelEntgeltFPV.add(entgelt100AGImMonat);
            if (gesamtesEntgelt.compareTo(pvBBG) > 0) {
                entgelt100AGImMonat = entgelt100AGImMonat.multiply(pvBBG).divide(gesamtesEntgelt, 2, RoundingMode.HALF_UP);
            }
        } else if (entgelt100AGImMonat.compareTo(pvBBG) > 0) {
            entgelt100AGImMonat = pvBBG;
        }
        BigDecimal pvVHSatz = this.mPvBeitragssatzAG;
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2022, 0, 1).getDate()) && (genesis = this.mVpLib.genesisParent()).getValueType().getValueTypeKey() == 99973) {
            pvVHSatz = pvVHSatz.add(this.mPvBeitragssatzAN);
        }
        this.mPvAgz = entgelt100AGImMonat.multiply(pvVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        if (aufgelAGZ.add(this.mPvAgz).compareTo(this.mPvGesamtbeitragAG) > 0) {
            this.mPvAgz = this.mPvGesamtbeitragAG.subtract(aufgelAGZ);
        }
        this.mCalLib.percentage(pvVHSatz);
        this.mCalLib.pvAGZ(this.mPvAgz);
    }

    private void modifiziereFPVEntgelt(BigDecimal differenz) throws BusinessDomainException {
        ValuePosition[] vpArray;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)differenz) && (vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)771090)})).length > 0) {
            vpArray[0].setResult(vpArray[0].getResult().add(differenz));
            vpArray[0].setPersistentBuffer2(vpArray[0].getPersistentBuffer2().add(differenz));
        }
    }

    private void zuschussErmittlungEGA() throws BusinessDomainException {
        if (!this.checkKugImJahr()) {
            switch (this.mEeLib.marbAGZFPv()) {
                case 1: 
                case 2: {
                    this.mVpLib.wertPosition().makeReadOnly();
                    return;
                }
            }
            if (this.mEeLib.isMehrfachbeschaeftigt()) {
                this.mVpLib.wertPosition().makeReadOnly();
                return;
            }
        }
        this.mPvBeitragssatzAG = this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15 ? this.mGlLib.svBsGesamtPV().divide(_2, 4, RoundingMode.HALF_UP) : this.mGlLib.bulaPvAga();
        if (this.mEeLib.marbBgrPv() == 2) {
            this.mPvBeitragssatzAG = this.mPvBeitragssatzAG.divide(_2, 4, RoundingMode.HALF_UP);
        }
        BigDecimal aufgelEntgeltFPV = this.sammleJahreswerte();
        BigDecimal pvBBG = this.mGlLib.svBbgKvPvJaehrl().multiply(this.mAufgelSVTage).divide(_360, 2, RoundingMode.HALF_UP);
        this.mSvLuft = pvBBG.subtract(aufgelEntgeltFPV);
        if (!BigDecimalMapper.isZero((BigDecimal)this.mEeLib.vortragSozialVersicherungPVLuft(this.mVpLib.gueltigAb()))) {
            this.mSvLuft = this.mSvLuft.add(this.mEeLib.vortragSozialVersicherungPVLuft(this.mVpLib.gueltigAb()));
        }
        if (this.mSvLuft.compareTo(BigDecimal.ZERO) < 0) {
            this.mSvLuft = BigDecimal.ZERO;
        }
        this.mAktuellesEGA = this.holeEGAImMonat();
        if (this.mSvLuft.compareTo(this.mAktuellesEGA) < 0) {
            this.mAktuellesEGA = this.mSvLuft;
        }
        if (DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            this.modifiziereFPVEntgelt(this.mAktuellesEGA);
        }
        if (this.mEeLib.marbBeitragsabsenkungBeiKuG()) {
            this.modifiziereGesamtbeitragKuG(this.mAktuellesEGA, pvBBG, aufgelEntgeltFPV);
        }
        this.mPvAgz = this.mAktuellesEGA.multiply(this.mPvBeitragssatzAG).divide(_100, 2, RoundingMode.HALF_UP);
        this.mCalLib.percentage(this.mPvBeitragssatzAG);
        this.mCalLib.pvAGZ(this.mPvAgz);
    }

    private void modifiziereGesamtbeitragKuG(BigDecimal aktuellesEGA, BigDecimal pvBBG, BigDecimal aufgelEntgeltFPV) throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)aktuellesEGA)) {
            BigDecimal pvEntgeltEGA;
            this.mPvBeitragssatzAN = this.mGlLib.svBsGesamtPV();
            if (this.mEeLib.marbBgrPv() == 2) {
                this.mPvBeitragssatzAN = this.mPvBeitragssatzAN.divide(_2, 4, RoundingMode.HALF_UP);
            }
            if (!this.mEeLib.isMarbKindErz() && this.mEeLib.marbAelterDreiUndZwanzig()) {
                this.mPvBeitragssatzAN = this.mPvBeitragssatzAN.add(this.mGlLib.svBsKinderlosPV());
            }
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2023, 6, 1).getDate())) {
                this.mPvBeitragssatzAN = this.mPvBeitragssatzAN.subtract(this.mEeLib.pVAbschlagKinder());
            }
            if (BigDecimalMapper.compareTo((BigDecimal)pvBBG, (BigDecimal)(pvEntgeltEGA = aktuellesEGA).add(this.mAufgelEntgeltKUG)) < 0 && BigDecimalMapper.compareTo((BigDecimal)(pvEntgeltEGA = pvBBG.subtract(this.mAufgelEntgeltKUG)), (BigDecimal)BigDecimal.ZERO) < 0) {
                pvEntgeltEGA = BigDecimal.ZERO;
            }
            BigDecimal result = pvEntgeltEGA.multiply(this.mPvBeitragssatzAN).divide(_100, 2, RoundingMode.HALF_UP);
            if (this.mIsFirmenzahler) {
                this.mVpLib.addNeueWertPosition(771000, this.mPvBeitragssatzAN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, result, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                this.mVpLib.addNeueWertPosition(771010, this.mPvBeitragssatzAN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, result, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        }
    }

    private void setFPVEntgelt(BigDecimal entgelt, BigDecimal pvBBG) throws BusinessDomainException {
        ValuePosition[] vpArray;
        if (BigDecimalMapper.compareTo((BigDecimal)entgelt, (BigDecimal)pvBBG) > 0) {
            entgelt = pvBBG;
        }
        if ((vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)771090)})).length > 0) {
            vpArray[0].setResult(entgelt);
            vpArray[0].setPersistentBuffer2(entgelt);
        }
    }

    private BigDecimal holeEGAImMonat() throws BusinessDomainException {
        return this.mVpLib.summeWPErgebnisVonWertarten(new ValueType[]{ValueType.getValueType((int)130610), ValueType.getValueType((int)130620), ValueType.getValueType((int)130650)});
    }

    /*
     * WARNING - void declaration
     */
    private BigDecimal sammleJahreswerte() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal pvBBG = this.mGlLib.svBbgKvPv();
        BigDecimal zwEntgeltFPV = BigDecimal.ZERO;
        BigDecimal aufgelEntgeltFPV = BigDecimal.ZERO;
        ValueType[] vtArray = ValueTypeHelper.getValueTypes((int[])new int[]{771090, 771100, 771000, 771010, 771080, 129200, 230110});
        Date suchdatum = PDateHelper.maxIgnoringNulls((Date[])new Date[]{DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb()), this.mEeLib.marbEintritt()});
        BigDecimal zwEntgeltKUG = BigDecimal.ZERO;
        while (DateHelper.before((Date)suchdatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
            void var9_10;
            vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)suchdatum), DateHelper.getLastDayOfMonth((Date)suchdatum), vtArray);
            BigDecimal zwANA = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            zwEntgeltFPV = BigDecimal.ZERO;
            zwEntgeltKUG = BigDecimal.ZERO;
            boolean isLfdErmittelt = false;
            block17: for (ValuePosition vp : vpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 230110: {
                        zwEntgeltKUG = zwEntgeltKUG.add(vp.getResult());
                        continue block17;
                    }
                    case 771080: {
                        BigDecimal bigDecimal2 = var9_10.add(vp.getFactor1());
                        continue block17;
                    }
                    case 129200: 
                    case 771090: 
                    case 771100: {
                        zwEntgeltFPV = zwEntgeltFPV.add(vp.getResult());
                        isLfdErmittelt = vp.getPersistentBuffer1().compareTo(BigDecimal.ONE) == 0;
                        continue block17;
                    }
                    case 771000: 
                    case 771010: {
                        zwANA = zwANA.add(vp.getResult());
                        continue block17;
                    }
                }
            }
            if (isLfdErmittelt) {
                this.mAufgelANA = this.mAufgelANA.add(zwANA);
                this.mAufgelSVTage = this.mAufgelSVTage.add((BigDecimal)var9_10);
                aufgelEntgeltFPV = aufgelEntgeltFPV.add(zwEntgeltFPV);
            }
            this.mAufgelEntgeltKUG = !BigDecimalMapper.isZeroOrNull((BigDecimal)zwEntgeltKUG) ? this.mAufgelEntgeltKUG.add(zwEntgeltFPV) : this.mAufgelEntgeltKUG.add(pvBBG);
            suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
        }
        vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vtArray);
        boolean nichtsEnthalten = true;
        zwEntgeltKUG = BigDecimal.ZERO;
        zwEntgeltFPV = BigDecimal.ZERO;
        block18: for (ValuePosition vp : vpArray) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 230110: {
                    zwEntgeltKUG = zwEntgeltKUG.add(vp.getResult());
                    continue block18;
                }
                case 129200: 
                case 129210: {
                    this.mBeitragspflichtigAndererAG = this.mBeitragspflichtigAndererAG.add(vp.getResult());
                    continue block18;
                }
                case 771000: 
                case 771010: {
                    this.mAufgelANA = this.mAufgelANA.add(vp.getResult());
                    continue block18;
                }
                case 771080: {
                    nichtsEnthalten = false;
                    this.mAufgelSVTage = this.mAufgelSVTage.add(vp.getFactor1());
                    continue block18;
                }
                case 771090: 
                case 771100: {
                    nichtsEnthalten = false;
                    zwEntgeltFPV = zwEntgeltFPV.add(vp.getResult());
                    continue block18;
                }
            }
        }
        aufgelEntgeltFPV = aufgelEntgeltFPV.add(zwEntgeltFPV);
        this.mAufgelEntgeltKUG = !BigDecimalMapper.isZeroOrNull((BigDecimal)zwEntgeltKUG) ? this.mAufgelEntgeltKUG.add(zwEntgeltFPV) : this.mAufgelEntgeltKUG.add(pvBBG);
        if (nichtsEnthalten && this.mVpLib.svTage().compareTo(BigDecimal.ZERO) != 0) {
            void var9_19;
            this.mAufgelSVTage = this.mAufgelSVTage.add(this.mVpLib.svTage());
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 0, 1).getDate())) {
                BigDecimal bigDecimal3 = this.mGlLib.krkGesBeitragBklAlllgemeinPV();
            } else {
                BigDecimal bigDecimal4 = this.mGlLib.krkGesBeitragBklAllgemeinAGZPV();
            }
            this.mPvGesamtbeitragAN = !this.mEeLib.isMarbKindErz() ? this.mGlLib.krkGesBeitragBklAlllgemeinPV() : this.mGlLib.krkGesBeitragBklAllgemeinAGZPV();
            if (this.mVpLib.svTage().compareTo(_30) != 0) {
                void var9_17;
                BigDecimal bigDecimal5 = var9_17.multiply(this.mVpLib.svTage()).divide(_30, 2, RoundingMode.HALF_UP);
                this.mPvGesamtbeitragAN = this.mPvGesamtbeitragAN.multiply(this.mVpLib.svTage()).divide(_30, 2, RoundingMode.HALF_UP);
            }
            this.mAufgelAGZFaehig = this.mAufgelAGZFaehig.add((BigDecimal)var9_19);
            switch (this.mEeLib.marbBgrKv()) {
                case 0: {
                    this.mVpLib.addNeueWertPosition(771010, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mPvGesamtbeitragAN, true);
                    this.mVpLib.addNeueWertPosition(771080, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, (BigDecimal)var9_19, true);
                    break;
                }
                default: {
                    this.mVpLib.addNeueWertPosition(771000, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mPvGesamtbeitragAN, true);
                    this.mVpLib.addNeueWertPosition(771080, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, (BigDecimal)var9_19, true);
                }
            }
        }
        return aufgelEntgeltFPV;
    }
}

