/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.MKPosition;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.varpayment.VarPayment;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.ChangedSystemLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.library.ValueTypeLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationCheckImpl;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.framework.DateComparator;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ErmittlungSVEntgeltEGAFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal DREIHUNDERTSECHZIG = BigDecimal.valueOf(360L);
    private final ValueTypeLibrary walib;
    private final CalculationLibrary callib;
    private final ChangedSystemLibrary cslib;
    private final EmployeeLibrary eelib;
    private final ValuePositionLibrary wplib;
    private final GlobalLibrary gllib;
    private CalculationCheckImpl cci;
    private BigDecimal svEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneKVBBG = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneRVBBG = BigDecimal.ZERO;
    private BigDecimal summeKVEntgelt = BigDecimal.ZERO;
    private BigDecimal summeRVEntgelt = BigDecimal.ZERO;
    private BigDecimal summeKVEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal summeKVEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal summeRVEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal summeRVEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal tempSVEntgelt = BigDecimal.ZERO;
    private boolean mMaerzklauselSystemStart = false;
    private ValuePosition[] vpArray = null;

    public ErmittlungSVEntgeltEGAFormula(ValueTypeLibrary valueTypeLibrary, CalculationLibrary calculationLibrary, ChangedSystemLibrary systemLibrary, EmployeeLibrary employeeLibrary, ValuePositionLibrary valuePositionLibrary, GlobalLibrary globalLibrary) {
        this.walib = valueTypeLibrary;
        this.callib = calculationLibrary;
        this.cslib = systemLibrary;
        this.eelib = employeeLibrary;
        this.wplib = valuePositionLibrary;
        this.gllib = globalLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        if (!this.isBeitragsfrei()) {
            ValuePosition umlagepflicht;
            this.cci = new CalculationCheckImpl(this.callib, this.eelib, this.gllib, this.wplib);
            this.vorabCheck();
            this.svEntgeltEGA = this.wplib.result();
            if (this.svEntgeltEGA.compareTo(BigDecimal.ZERO) < 0 && this.wplib.genesisParent().getGenesisOfParentObjects() instanceof EEPensionSchemeTP) {
                BigDecimal steuerpflichtigEGA = BigDecimal.ZERO;
                for (ValuePosition element : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130610, 130630, 130640}))) {
                    this.tempSVEntgelt = this.tempSVEntgelt.add(element.getResult());
                }
                if (this.tempSVEntgelt.compareTo(BigDecimal.ZERO) < 0) {
                    for (ValuePosition lElement : this.vpArray = this.wplib.genesisUndFolgen()) {
                        switch (lElement.getValueType().getValueTypeKey()) {
                            case 110610: {
                                steuerpflichtigEGA = steuerpflichtigEGA.add(lElement.getResult());
                            }
                        }
                        lElement.setResult(BigDecimal.ZERO);
                        lElement.makeReadOnly();
                    }
                    this.svEntgeltEGA = BigDecimal.ZERO;
                    this.wplib.wertPosition().makeReadOnly();
                    if (!BigDecimalMapper.isZero((BigDecimal)steuerpflichtigEGA)) {
                        for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{99997}))) {
                            ValuePosition[] tempVPArray;
                            block11: for (ValuePosition tempVP : tempVPArray = this.wplib.genesisUndFolgen(lElement)) {
                                switch (tempVP.getValueType().getValueTypeKey()) {
                                    case 99997: {
                                        tempVP.setResult(tempVP.getResult().add(steuerpflichtigEGA));
                                        continue block11;
                                    }
                                    case 110610: {
                                        tempVP.setResult(tempVP.getResult().add(steuerpflichtigEGA));
                                        continue block11;
                                    }
                                    case 110640: {
                                        tempVP.setResult(tempVP.getResult().subtract(steuerpflichtigEGA));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.eelib.marbAustritt() != null && this.eelib.marb().getSuccessor() == null && DateHelper.between((Date)this.eelib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())) && this.wplib.wertPosition().isPaymentAfterWithdrawal() && DateHelper.after((Date)this.wplib.wertPosition().getZuflussMonat(), (Date)DateHelper.getLastDayOfQuartal((Date)DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)this.eelib.marbAustritt())))) && !this.isEntgeltVorApril()) {
                this.wplib.wertPosition().makeReadOnly();
                return;
            }
            if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()), (Date)DateHelper.getLastDayOfQuartal((Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb())))) {
                this.maerzklauselPruefung();
            }
            if (!this.mMaerzklauselSystemStart) {
                if (!this.wplib.wertPosition().getSignedAsClauseOfMarch()) {
                    if (this.eelib.isBehinderterMA()) {
                        this.erzeugeMindesbemessungsgrundlagenFuerDieBehindertenabrechnung();
                    } else {
                        this.erzeugeKVEntgelt();
                        this.erzeugeRVEntgelt();
                        this.erzeugeAVEntgelt();
                        if (this.eelib.marbPgs() != 112) {
                            this.erzeugePVEntgelt();
                        }
                    }
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) {
                        this.erzeugeInsGEntgelt();
                    }
                    if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate()) && this.eelib.taxacation() == 5) {
                        if (this.eelib.ueberwaelzungLstAN() && !this.wplib.aus37b()) {
                            this.wplib.addNeueWertPosition(new int[]{101680, 736800}, this.svEntgeltEGA);
                        } else if (this.wplib.aus37b()) {
                            this.wplib.addNeueWertPosition(736300, this.svEntgeltEGA);
                        } else {
                            this.wplib.addNeueWertPosition(new int[]{101680, 736300}, this.svEntgeltEGA);
                        }
                    }
                    this.callib.result(this.svEntgeltEGA);
                } else {
                    this.callib.result(BigDecimal.ZERO);
                    umlagepflicht = this.wplib.folgeWertartVomGenesis(135400);
                    if (umlagepflicht != null) {
                        umlagepflicht.makeReadOnly();
                        umlagepflicht.setResult(BigDecimal.ZERO);
                    }
                    this.wplib.addNeueWertPosition(130630, this.svEntgeltEGA);
                    this.wplib.pruefeEigenschaft(this.wplib.wertPosition());
                }
            } else {
                umlagepflicht = this.wplib.folgeWertartVomGenesis(135400);
                if (umlagepflicht != null) {
                    umlagepflicht.makeReadOnly();
                    umlagepflicht.setResult(BigDecimal.ZERO);
                }
                this.wplib.addNeueWertPosition(130640, this.svEntgeltEGA);
                this.wplib.wertPosition().makeReadOnly();
            }
        }
    }

    private void vorabCheck() throws BusinessDomainException {
        this.pruefeaufBruchteilevonCent();
        this.checkMehrfachbeschaeftigung();
    }

    private boolean isBeitragsfrei() throws BusinessDomainException {
        if (this.eelib.isBeitragsfrei()) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.result())) {
                this.wplib.addNeueWertPosition(128600, this.wplib.result());
            }
            this.wplib.loescheWertPosition(this.wplib.wertartenNummer());
            return true;
        }
        return false;
    }

    private void checkMehrfachbeschaeftigung() throws BusinessDomainException {
        if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215}));
            if (!(this.vpArray.length <= 0 || this.eelib.isMehrfachbeschaeftigt() || this.callib.dbgzVorhanden() || this.callib.dbbgVorhanden())) {
                EvaluationExceptionMapper.makeNoMultipleEmploymentForCalculateOfValuePositionDomainException((Date)this.callib.berchnungGueltigAb(), (int)((ValuePosition)this.vpArray[0].getGenesisOfParentObjects()).getValueType().getValueTypeKey());
            }
        }
    }

    private void pruefeaufBruchteilevonCent() throws BusinessDomainException {
        BigInteger tempBigI;
        BigDecimal tempBigD;
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) && (tempBigD = new BigDecimal(tempBigI = this.wplib.result().movePointRight(2).toBigInteger()).movePointLeft(2)).compareTo(this.wplib.result()) != 0) {
            this.gllib.erzeugeWiedervorlageBruchteileVonCent(this.wplib.genesisParent().getValueType().getValueTypeKey());
        }
    }

    private void erzeugeKVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbbgVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) && this.cci.checkGleitzoneKV()) {
            switch (this.eelib.marbBgrKv()) {
                case 1: 
                case 2: 
                case 3: {
                    this.wplib.addNeueWertPosition(321614, this.svEntgeltEGA);
                    return;
                }
            }
        }
        block3 : switch (this.eelib.marbBgrKv()) {
            case 0: {
                switch (this.eelib.marbBklFKv().value()) {
                    case 0: {
                        break;
                    }
                    default: {
                        if (this.eelib.marbPKv()) break;
                        this.wplib.addNeueWertPosition(770030, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, true);
                    }
                }
                if (!this.eelib.marbPKv() || this.eelib.marbAGZPKv() == 9) break;
                this.wplib.addNeueWertPosition(770130, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, false);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                this.wplib.addNeueWertPosition(321610, this.svEntgeltEGA);
                break;
            }
            case 6: {
                this.wplib.addNeueWertPosition(321612, this.svEntgeltEGA);
                break;
            }
            case 9: {
                switch (this.eelib.marbBklFKv().value()) {
                    case 0: {
                        break block3;
                    }
                }
                this.wplib.addNeueWertPosition(770030, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, true);
                break;
            }
        }
    }

    private void erzeugeRVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbgzVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) && this.cci.checkGleitzoneRV() && !this.eelib.kennzBestandGleitzone2022()) {
            switch (this.eelib.marbBgrRv()) {
                case 1: 
                case 2: 
                case 3: {
                    if (!this.eelib.marbVerzichtRvReduzierung()) {
                        this.wplib.addNeueWertPosition(327614, this.svEntgeltEGA);
                    } else {
                        this.wplib.addNeueWertPosition(327610, this.svEntgeltEGA);
                    }
                    return;
                }
                case 0: {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) && this.eelib.marbVersorgungsart().value() != 0) {
                        if (!this.eelib.marbVerzichtRvReduzierung()) {
                            this.wplib.addNeueWertPosition(327614, this.svEntgeltEGA);
                        } else {
                            this.wplib.addNeueWertPosition(327610, this.svEntgeltEGA);
                        }
                    }
                    return;
                }
            }
        }
        switch (this.eelib.marbBgrRv()) {
            case 0: {
                if (this.eelib.marbVersorgungsart().value() == 0) break;
                if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                    this.wplib.addNeueWertPosition(772120, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, true);
                    break;
                }
                if (this.eelib.marbBgrKv() == 6) {
                    this.wplib.addNeueWertPosition(327612, this.svEntgeltEGA);
                    break;
                }
                if (this.eelib.marbPgs() != 109) {
                    this.wplib.addNeueWertPosition(327610, this.svEntgeltEGA);
                    break;
                }
                this.wplib.addNeueWertPosition(327612, this.svEntgeltEGA);
                break;
            }
            case 5: 
            case 6: {
                this.wplib.addNeueWertPosition(327612, this.svEntgeltEGA);
                break;
            }
            default: {
                if (this.eelib.marbPgs() != 109) {
                    this.wplib.addNeueWertPosition(327610, this.svEntgeltEGA);
                    break;
                }
                this.wplib.addNeueWertPosition(327612, this.svEntgeltEGA);
            }
        }
    }

    private void erzeugeAVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbgzVorhanden() || this.callib.dbgzVorhanden() && this.callib.dbgzKennzGLZ().value() == 1) && this.cci.checkGleitzoneAV()) {
            switch (this.eelib.marbBgrAv()) {
                case 1: {
                    this.wplib.addNeueWertPosition(333614, this.svEntgeltEGA);
                    return;
                }
                case 2: {
                    if (!this.eelib.marbAVBefreiungAG()) {
                        this.wplib.addNeueWertPosition(333614, this.svEntgeltEGA);
                    }
                    return;
                }
            }
        }
        if (this.eelib.marbBgrAv() != 0) {
            this.wplib.addNeueWertPosition(333610, this.svEntgeltEGA);
        }
    }

    private void erzeugePVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbgzVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) && this.cci.checkGleitzonePV()) {
            switch (this.eelib.marbBgrPv()) {
                case 1: 
                case 2: {
                    this.wplib.addNeueWertPosition(339614, this.svEntgeltEGA);
                    return;
                }
            }
        }
        block3 : switch (this.eelib.marbBgrPv()) {
            case 1: {
                switch (this.eelib.marbBklFPv().value()) {
                    case 0: {
                        this.wplib.addNeueWertPosition(339610, this.svEntgeltEGA);
                        break block3;
                    }
                }
                this.wplib.addNeueWertPosition(771030, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, true);
                break;
            }
            case 2: {
                this.wplib.addNeueWertPosition(339610, this.svEntgeltEGA);
                break;
            }
            default: {
                if (this.eelib.marbPPVv()) {
                    if (this.eelib.marbAGZPPv() == 9) break;
                    this.wplib.addNeueWertPosition(771130, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, false);
                    break;
                }
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2007, 3, 1).getDate()) || this.eelib.marbBesonderesSvMerkmal().value() != 5) break;
                this.wplib.addNeueWertPosition(771030, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltEGA, true);
            }
        }
    }

    private void erzeugeInsGEntgelt() throws BusinessDomainException {
        if (this.gllib.isInsGPflBetrieb() && this.eelib.isMarbInsGPflichtig()) {
            if (!this.eelib.marbVerzichtRvReduzierung() && (this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbgzVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3))) {
                if (this.cci.checkGleitzoneInsG()) {
                    this.wplib.addNeueWertPosition(365614, this.svEntgeltEGA);
                } else {
                    this.wplib.addNeueWertPosition(365610, this.svEntgeltEGA);
                }
            } else {
                this.wplib.addNeueWertPosition(365610, this.svEntgeltEGA);
            }
        }
    }

    private void maerzklauselPruefung() throws BusinessDomainException {
        if (DateHelper.before((Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), (Date)this.wplib.gueltigAb())) {
            Date berechnungWirksamAb = DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb());
            Date berechnungGueltigAb = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
            if (DateHelper.before((Date)berechnungGueltigAb, (Date)this.eelib.marbEintritt())) {
                berechnungGueltigAb = this.eelib.marbEintritt();
            }
            new CalculationBasic(this.eelib.marb(), berechnungWirksamAb, berechnungGueltigAb, "Ermittlung SVEntgelt EGA");
        } else if (DateHelper.before((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb())) && !this.callib.isMaerzklausel()) {
            new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), "ErmittlungSVEntgelt");
        } else {
            Date marbAustritt = this.getMarbAustrittAusSichtDesAktuellenMonats();
            if (this.eelib.marbBgrKv() == 1 || this.eelib.marbBgrKv() == 2 || this.eelib.marbBgrKv() == 3) {
                if (marbAustritt != null && DateHelper.before((Date)marbAustritt, (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungWirksamAb()))) {
                    this.pruefeMaerzklauselnachAustrittKV();
                } else {
                    this.pruefeMaerzklauselKV();
                }
            } else if (marbAustritt != null && DateHelper.before((Date)marbAustritt, (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungWirksamAb()))) {
                this.pruefeMaerzklauselnachAustrittRV();
            } else {
                this.pruefeMaerzklauselRV();
            }
        }
    }

    private Date getMarbAustrittAusSichtDesAktuellenMonats() throws BusinessDomainException {
        Date austrittsDatum = null;
        try {
            Employment employment = DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) ? this.eelib.marb().getEmployment(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb()) : this.eelib.marb().getEmployment(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
            if (employment != null) {
                austrittsDatum = employment.getDateOfWithDrawal();
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                austrittsDatum = null;
            }
            throw e;
        }
        return austrittsDatum;
    }

    private void pruefeMaerzklauselnachAustrittRV() throws BusinessDomainException {
        if (!this.wplib.kennzFuerMaerzklausel()) {
            HashMap<Date, List<ValuePosition>> eGAMap = new HashMap<Date, List<ValuePosition>>();
            block7: for (ValuePosition valuePosition : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130550, 130555, 130610}))) {
                switch (valuePosition.getValueType().getValueTypeKey()) {
                    case 130510: 
                    case 130550: 
                    case 130555: {
                        this.summeRVEntgeltLfd = this.summeRVEntgeltLfd.add(valuePosition.getResult());
                        continue block7;
                    }
                    case 130610: 
                    case 130640: {
                        List<ValuePosition> list;
                        if (valuePosition.isPaymentAfterWithdrawal()) {
                            if (eGAMap.containsKey(valuePosition.getZuflussMonat())) {
                                list = (List)eGAMap.get(valuePosition.getZuflussMonat());
                                list.add(valuePosition);
                                continue block7;
                            }
                            list = new LinkedList<ValuePosition>();
                            list.add(valuePosition);
                            eGAMap.put(valuePosition.getZuflussMonat(), list);
                            continue block7;
                        }
                        if (eGAMap.containsKey(DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
                            list = (List)eGAMap.get(DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()));
                            list.add(valuePosition);
                            continue block7;
                        }
                        list = new LinkedList();
                        list.add(valuePosition);
                        eGAMap.put(DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), list);
                        continue block7;
                    }
                }
            }
            this.summeRVEntgelt = this.summeRVEntgeltLfd;
            BigDecimal aufgelaufenerJahreswertRV = this.holeAufgelaufenesRVPflichtigesEntgelt().add(this.summeRVEntgelt);
            switch (this.gllib.krkTyp()) {
                case 6: {
                    if (this.eelib.marbErhBeitrErmKnappschRV()) {
                        this.aufgelaufeneRVBBG = this.aufgelaufeneRVBBG.add(this.gllib.svBbgKnappschaftJaehrl().multiply(this.wplib.summeSVTageFuerEGA()).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                        break;
                    }
                    this.aufgelaufeneRVBBG = this.aufgelaufeneRVBBG.add(this.wplib.aufgelBbgRv(true)).add(this.gllib.svBbgRvAv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
                    break;
                }
                default: {
                    this.aufgelaufeneRVBBG = this.aufgelaufeneRVBBG.add(this.wplib.aufgelBbgRv(true)).add(this.gllib.svBbgRvAv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
                }
            }
            LinkedList keyList = new LinkedList(eGAMap.keySet());
            Collections.sort(keyList, new DateComparator());
            for (Date wirksamkeit : keyList) {
                if (!DateHelper.before((Date)wirksamkeit, (Date)DateHelper.getLastDayOfQuartal((Date)this.wplib.gueltigAb()))) continue;
                BigDecimal summeEGA = BigDecimal.ZERO;
                List vpList = (List)eGAMap.get(wirksamkeit);
                for (ValuePosition valuePosition : vpList) {
                    summeEGA = summeEGA.add(valuePosition.getResult());
                }
                BigDecimal rvLuft = this.aufgelaufeneRVBBG.subtract(aufgelaufenerJahreswertRV.add(summeEGA));
                if (rvLuft.compareTo(BigDecimal.ZERO) >= 0) {
                    aufgelaufenerJahreswertRV = aufgelaufenerJahreswertRV.add(summeEGA);
                    continue;
                }
                if (DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
                    if (!this.maerzklauselBeurteilung()) continue;
                    new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfQuartal((Date)this.wplib.gueltigAb())), "ErmittlungSVEntgelt");
                    this.callib.setMaerzklausel(true);
                    if (!this.callib.isMaerzklauselExecuted()) {
                        if (!DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) continue;
                        for (ValuePosition valuePosition : vpList) {
                            if (valuePosition.getSignedAsClauseOfMarch()) continue;
                            valuePosition.setSignedAsClauseOfMarch(true);
                            MKPosition mk = new MKPosition(valuePosition.getResult(), valuePosition);
                            this.wplib.pruefeUmlageEntgelt(mk);
                            this.wplib.pruefeEigenschaft(valuePosition, mk);
                            this.callib.addListOfMKPositions(mk);
                        }
                        continue;
                    }
                    for (ValuePosition valuePosition : vpList) {
                        valuePosition.setSignedAsClauseOfMarch(true);
                    }
                    continue;
                }
                if (!this.maerzklauselvortragVorhanden()) continue;
                this.mMaerzklauselSystemStart = true;
            }
        } else if (!DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb())) && this.maerzklauselvortragVorhanden()) {
            this.mMaerzklauselSystemStart = true;
        }
    }

    private void pruefeMaerzklauselRV() throws BusinessDomainException {
        if (!this.wplib.kennzFuerMaerzklausel()) {
            BigDecimal rvBBG = BigDecimal.ZERO;
            switch (this.gllib.krkTyp()) {
                case 6: {
                    if (this.eelib.marbErhBeitrErmKnappschRV()) {
                        rvBBG = this.gllib.svBbgKnappschaft();
                        break;
                    }
                    rvBBG = this.gllib.svBbgRvAv();
                    break;
                }
                default: {
                    rvBBG = this.gllib.svBbgRvAv();
                }
            }
            if (this.wplib.rvTageMarbLfd().compareTo(DREISSIG) != 0) {
                rvBBG = this.wplib.rvTageMarbLfd().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : rvBBG.multiply(this.wplib.rvTageMarbLfd()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
            block13: for (ValuePosition valuePosition : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130550, 130555, 230510, 230520, 130610, 130640}))) {
                switch (valuePosition.getValueType().getValueTypeKey()) {
                    case 130510: 
                    case 130550: 
                    case 130555: 
                    case 230510: 
                    case 230520: {
                        this.summeRVEntgeltLfd = this.summeRVEntgeltLfd.add(valuePosition.getResult());
                        continue block13;
                    }
                    case 130610: 
                    case 130640: {
                        if (valuePosition.isPaymentAfterWithdrawal()) continue block13;
                        this.summeRVEntgeltEGA = this.summeRVEntgeltEGA.add(valuePosition.getResult());
                        continue block13;
                    }
                }
            }
            if (this.summeRVEntgeltLfd.compareTo(rvBBG) > 0) {
                this.summeRVEntgeltLfd = rvBBG;
            }
            this.summeRVEntgelt = this.summeRVEntgeltLfd.add(this.summeRVEntgeltEGA);
            BigDecimal aufgelaufenerJahreswertRV = this.holeAufgelaufenesRVPflichtigesEntgelt().add(this.summeRVEntgelt);
            switch (this.gllib.krkTyp()) {
                case 6: {
                    if (this.eelib.marbErhBeitrErmKnappschRV()) {
                        this.aufgelaufeneRVBBG = this.aufgelaufeneRVBBG.add(this.gllib.svBbgKnappschaftJaehrl().multiply(this.wplib.summeSVTageFuerEGA()).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                        break;
                    }
                    this.aufgelaufeneRVBBG = this.aufgelaufeneRVBBG.add(this.wplib.aufgelBbgRv(true)).add(this.gllib.svBbgRvAv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
                    break;
                }
                default: {
                    this.aufgelaufeneRVBBG = this.aufgelaufeneRVBBG.add(this.wplib.aufgelBbgRv(true)).add(this.gllib.svBbgRvAv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
                }
            }
            BigDecimal rVLuft = this.aufgelaufeneRVBBG.subtract(aufgelaufenerJahreswertRV);
            if (rVLuft.compareTo(BigDecimal.ZERO) < 0) {
                if (DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
                    if (this.maerzklauselBeurteilung()) {
                        new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfQuartal((Date)this.wplib.gueltigAb())), "ErmittlungSVEntgeltEGA");
                        this.callib.setMaerzklausel(true);
                        block14: for (ValuePosition valuePosition : this.vpArray) {
                            switch (valuePosition.getValueType().getValueTypeKey()) {
                                case 130610: {
                                    if (valuePosition.isPaymentAfterWithdrawal()) continue block14;
                                    valuePosition.setSignedAsClauseOfMarch(true);
                                    continue block14;
                                }
                            }
                        }
                        if (!this.callib.isMaerzklauselExecuted() && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
                            MKPosition mk = new MKPosition(this.svEntgeltEGA, this.wplib.wertPosition());
                            this.wplib.pruefeUmlageEntgelt(mk);
                            this.wplib.pruefeEigenschaft(this.wplib.wertPosition(), mk);
                            this.callib.addListOfMKPositions(mk);
                        }
                    }
                } else if (this.maerzklauselvortragVorhanden()) {
                    this.mMaerzklauselSystemStart = true;
                }
            }
        } else if (DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
            if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
                MKPosition mk = new MKPosition(this.svEntgeltEGA, this.wplib.wertPosition());
                this.wplib.pruefeUmlageEntgelt(mk);
                this.wplib.pruefeEigenschaft(this.wplib.wertPosition(), mk);
                this.callib.addListOfMKPositions(mk);
            }
        } else if (this.maerzklauselvortragVorhanden()) {
            this.mMaerzklauselSystemStart = true;
        }
    }

    private void pruefeMaerzklauselnachAustrittKV() throws BusinessDomainException {
        if (!this.wplib.kennzFuerMaerzklausel()) {
            HashMap<Date, List<ValuePosition>> eGAMap = new HashMap<Date, List<ValuePosition>>();
            block4: for (ValuePosition valuePosition : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130610, 130640}))) {
                switch (valuePosition.getValueType().getValueTypeKey()) {
                    case 130510: {
                        this.summeKVEntgeltLfd = this.summeKVEntgeltLfd.add(valuePosition.getResult());
                        continue block4;
                    }
                    case 130610: 
                    case 130640: {
                        List<ValuePosition> list;
                        if (valuePosition.isPaymentAfterWithdrawal()) {
                            if (eGAMap.containsKey(valuePosition.getZuflussMonat())) {
                                list = (List)eGAMap.get(valuePosition.getZuflussMonat());
                                list.add(valuePosition);
                                continue block4;
                            }
                            list = new LinkedList<ValuePosition>();
                            list.add(valuePosition);
                            eGAMap.put(valuePosition.getZuflussMonat(), list);
                            continue block4;
                        }
                        if (eGAMap.containsKey(DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
                            list = (List)eGAMap.get(DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()));
                            list.add(valuePosition);
                            continue block4;
                        }
                        list = new LinkedList();
                        list.add(valuePosition);
                        eGAMap.put(DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), list);
                        continue block4;
                    }
                }
            }
            this.summeKVEntgelt = this.summeKVEntgeltLfd;
            BigDecimal aufgelaufenerJahreswertKV = this.holeAufgelaufenesKVPflichtigesEntgelt().add(this.summeKVEntgelt);
            this.aufgelaufeneKVBBG = this.aufgelaufeneKVBBG.add(this.wplib.aufgelBbgKv(true)).add(this.gllib.svBbgKvPv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
            LinkedList keyList = new LinkedList(eGAMap.keySet());
            Collections.sort(keyList, new DateComparator());
            for (Date wirksamkeit : keyList) {
                if (!DateHelper.before((Date)wirksamkeit, (Date)DateHelper.getLastDayOfQuartal((Date)this.wplib.gueltigAb()))) continue;
                BigDecimal summeEGA = BigDecimal.ZERO;
                List vpList = (List)eGAMap.get(wirksamkeit);
                for (ValuePosition valuePosition : vpList) {
                    summeEGA = summeEGA.add(valuePosition.getResult());
                }
                BigDecimal kvLuft = this.aufgelaufeneKVBBG.subtract(aufgelaufenerJahreswertKV.add(summeEGA));
                if (kvLuft.compareTo(BigDecimal.ZERO) >= 0) {
                    aufgelaufenerJahreswertKV = aufgelaufenerJahreswertKV.add(summeEGA);
                    continue;
                }
                if (DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
                    if (!this.maerzklauselBeurteilung()) continue;
                    new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfQuartal((Date)this.wplib.gueltigAb())), "ErmittlungSVEntgelt");
                    this.callib.setMaerzklausel(true);
                    if (!this.callib.isMaerzklauselExecuted()) {
                        if (!DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) continue;
                        for (ValuePosition valuePosition : vpList) {
                            if (valuePosition.getSignedAsClauseOfMarch()) continue;
                            valuePosition.setSignedAsClauseOfMarch(true);
                            MKPosition mk = new MKPosition(valuePosition.getResult(), valuePosition);
                            this.wplib.pruefeUmlageEntgelt(mk);
                            this.wplib.pruefeEigenschaft(valuePosition, mk);
                            this.callib.addListOfMKPositions(mk);
                        }
                        continue;
                    }
                    for (ValuePosition valuePosition : vpList) {
                        valuePosition.setSignedAsClauseOfMarch(true);
                    }
                    continue;
                }
                if (!this.maerzklauselvortragVorhanden()) continue;
                this.mMaerzklauselSystemStart = true;
            }
        } else if (!DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb())) && this.maerzklauselvortragVorhanden()) {
            this.mMaerzklauselSystemStart = true;
        }
    }

    private void pruefeMaerzklauselKV() throws BusinessDomainException {
        if (!this.wplib.kennzFuerMaerzklausel()) {
            BigDecimal kvBBG = this.gllib.svBbgKvPv();
            if (this.wplib.kvTageMarbLfd().compareTo(DREISSIG) != 0) {
                kvBBG = this.wplib.kvTageMarbLfd().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : kvBBG.multiply(this.wplib.kvTageMarbLfd()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
            block7: for (ValuePosition valuePosition : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130550, 130555, 230510, 230520, 130610, 130640}))) {
                switch (valuePosition.getValueType().getValueTypeKey()) {
                    case 130510: 
                    case 130550: 
                    case 130555: 
                    case 230510: 
                    case 230520: {
                        this.summeKVEntgeltLfd = this.summeKVEntgeltLfd.add(valuePosition.getResult());
                        continue block7;
                    }
                    case 130610: 
                    case 130640: {
                        this.summeKVEntgeltEGA = this.summeKVEntgeltEGA.add(valuePosition.getResult());
                        continue block7;
                    }
                }
            }
            if (this.summeKVEntgeltLfd.compareTo(kvBBG) > 0) {
                this.summeKVEntgeltLfd = kvBBG;
            }
            this.summeKVEntgelt = this.summeKVEntgeltLfd.add(this.summeKVEntgeltEGA);
            BigDecimal aufgelaufenerJahreswertKV = this.holeAufgelaufenesKVPflichtigesEntgelt().add(this.summeKVEntgelt);
            this.aufgelaufeneKVBBG = this.aufgelaufeneKVBBG.add(this.wplib.aufgelBbgKv(true)).add(this.gllib.svBbgKvPv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
            BigDecimal kVLuft = this.aufgelaufeneKVBBG.subtract(aufgelaufenerJahreswertKV);
            if (kVLuft.compareTo(BigDecimal.ZERO) < 0) {
                if (DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
                    if (this.maerzklauselBeurteilung()) {
                        new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfQuartal((Date)this.wplib.gueltigAb())), "ErmittlungSVEntgeltEGA");
                        this.callib.setMaerzklausel(true);
                        block8: for (ValuePosition valuePosition : this.vpArray) {
                            switch (valuePosition.getValueType().getValueTypeKey()) {
                                case 130610: {
                                    valuePosition.setSignedAsClauseOfMarch(true);
                                    continue block8;
                                }
                            }
                        }
                        if (!this.callib.isMaerzklauselExecuted() && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
                            MKPosition mk = new MKPosition(this.svEntgeltEGA, this.wplib.wertPosition());
                            this.wplib.pruefeUmlageEntgelt(mk);
                            this.wplib.pruefeEigenschaft(this.wplib.wertPosition(), mk);
                            this.callib.addListOfMKPositions(mk);
                        }
                    }
                } else if (this.maerzklauselvortragVorhanden()) {
                    this.mMaerzklauselSystemStart = true;
                }
            }
        } else if (DateHelper.before((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
            if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
                MKPosition mk = new MKPosition(this.svEntgeltEGA, this.wplib.wertPosition());
                this.wplib.pruefeUmlageEntgelt(mk);
                this.wplib.pruefeEigenschaft(this.wplib.wertPosition(), mk);
                this.callib.addListOfMKPositions(mk);
            }
        } else if (this.maerzklauselvortragVorhanden()) {
            this.mMaerzklauselSystemStart = true;
        }
    }

    public boolean maerzklauselBeurteilung() throws BusinessDomainException {
        Date letzterTagDesVorjahres = DateHelper.yesterday((Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()));
        Date gueltigAb = DateHelper.getFirstDayOfMonth((Date)letzterTagDesVorjahres);
        Employee ee = this.wplib.wertPosition().getEmployee();
        boolean keineSVpflicht = true;
        while (DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfYear((Date)letzterTagDesVorjahres), (Date)gueltigAb)) {
            EEAbsentTimeTP[] fehlzeiten;
            try {
                Employment empl = ee.getEmployment(this.wplib.wirksamAb(), gueltigAb);
                if (empl.getDateOfWithDrawal() != null && DateHelper.before((Date)empl.getDateOfWithDrawal(), (Date)gueltigAb)) {
                    gueltigAb = new VDate(gueltigAb).addMonths(-1).getDate();
                    continue;
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                    return false;
                }
                throw e;
            }
            if (!ee.isContributory(this.wplib.wirksamAb(), gueltigAb)) {
                gueltigAb = new VDate(gueltigAb).addMonths(-1).getDate();
                continue;
            }
            ValuePosition[] valueArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), gueltigAb, DateHelper.getLastDayOfMonth((Date)gueltigAb), ValueTypeHelper.getValueTypes((int[])new int[]{130590}));
            BigDecimal svTage = BigDecimal.ZERO;
            for (ValuePosition valuePosition : valueArray) {
                svTage = svTage.add(valuePosition.getFactor1());
            }
            if (BigDecimalMapper.compareTo((BigDecimal)svTage, (BigDecimal)BigDecimal.ZERO) > 0) {
                if (!this.callib.isMaerzklausel()) {
                    this.callib.setMaerzklauselGueltigAb(gueltigAb);
                }
                return true;
            }
            for (EEAbsentTimeTP fehlzeit : fehlzeiten = ee.getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)ee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.wplib.wirksamAb())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.wplib.wirksamAb())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)gueltigAb))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)gueltigAb)))}), true)) {
                String deuvSchluessel = fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey();
                if (StringMapper.compareTo((String)deuvSchluessel, (String)"") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"4.1") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"4.2") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"4.5") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"5.1") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"6.1") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"6.2") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"6.3") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"6.8") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"6.9") != 0) continue;
                if (!this.callib.isMaerzklausel()) {
                    this.callib.setMaerzklauselGueltigAb(gueltigAb);
                }
                return true;
            }
            gueltigAb = new VDate(gueltigAb).addMonths(-1).getDate();
        }
        return false;
    }

    private BigDecimal holeAufgelaufenesKVPflichtigesEntgelt() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
            ValuePosition[] alteVP = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{321510, 321610}));
            for (EECarriedForwardSystemSI eECarriedForwardSystemSI : alteVP) {
                result = result.add(eECarriedForwardSystemSI.getResult());
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        if (DateHelper.between((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb()), (Date)this.callib.berchnungGueltigAb())) {
            EECarriedForwardSystemSI[] vortraege;
            for (EECarriedForwardSystemSI eECarriedForwardSystemSI : vortraege = this.eelib.marb().getEECarriedForwardSystemSI()) {
                if (DateHelper.getYear((Date)eECarriedForwardSystemSI.getValidFrom()) != DateHelper.getYear((Date)this.wplib.gueltigAb())) continue;
                result = result.add(eECarriedForwardSystemSI.getHIPayment());
            }
        }
        return result;
    }

    private BigDecimal holeAufgelaufenesRVPflichtigesEntgelt() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
            ValuePosition[] alteVP = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{327510, 327610, 773510, 773610}));
            for (EECarriedForwardSystemSI eECarriedForwardSystemSI : alteVP) {
                result = result.add(eECarriedForwardSystemSI.getResult());
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        if (DateHelper.between((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb()), (Date)this.callib.berchnungGueltigAb())) {
            EECarriedForwardSystemSI[] vortraege;
            for (EECarriedForwardSystemSI eECarriedForwardSystemSI : vortraege = this.eelib.marb().getEECarriedForwardSystemSI()) {
                if (DateHelper.getYear((Date)eECarriedForwardSystemSI.getValidFrom()) != DateHelper.getYear((Date)this.wplib.gueltigAb())) continue;
                result = result.add(eECarriedForwardSystemSI.getPIPayment());
            }
        }
        return result;
    }

    public boolean maerzklauselvortragVorhanden() throws BusinessDomainException {
        if (DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
            return this.cslib.getVortrag() != null;
        }
        if (this.eelib.vortragSozialVersicherungMKvorhanden(this.wplib.gueltigAb())) {
            return true;
        }
        if (!DateHelper.afterOrEqual((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
            throw EvaluationExceptionMapper.makeNoCFSIAvailable();
        }
        return false;
    }

    private void erzeugeMindesbemessungsgrundlagenFuerDieBehindertenabrechnung() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal svEntLfd = BigDecimal.ZERO;
        BigDecimal summeEntgeltAufgelaufen = BigDecimal.ZERO;
        BigDecimal svEntEGA = BigDecimal.ZERO;
        BigDecimal kvEntgeltEGA = this.svEntgeltEGA;
        BigDecimal rvEntgeltEGA = this.svEntgeltEGA;
        BigDecimal beitragsbemessungsgrundlageKVPVOst = BigDecimal.ZERO;
        BigDecimal beitragsbemessungsgrundlageKVPVWest = BigDecimal.ZERO;
        boolean isUmverteilung = false;
        block6: for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 321610, 327610, 130571, 130570}))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 130510: {
                    svEntLfd = svEntLfd.add(lElement.getResult());
                    continue block6;
                }
                case 321610: {
                    svEntEGA = svEntEGA.add(lElement.getResult());
                    continue block6;
                }
                case 130571: {
                    beitragsbemessungsgrundlageKVPVOst = beitragsbemessungsgrundlageKVPVOst.add(lElement.getResult());
                    continue block6;
                }
                case 130570: {
                    beitragsbemessungsgrundlageKVPVWest = beitragsbemessungsgrundlageKVPVWest.add(lElement.getResult());
                }
            }
        }
        summeEntgeltAufgelaufen = svEntLfd.add(svEntEGA);
        summeEntgeltAufgelaufen = svEntLfd.add(svEntEGA);
        BigDecimal kvVorMonatsDifferenzen = BigDecimal.ZERO;
        BigDecimal rvVorMonatsDifferenzen = BigDecimal.ZERO;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)svEntLfd)) {
            BigDecimal[] vorMonatsDifferenzen = this.getDifferenzAusVormonaten();
            kvVorMonatsDifferenzen = vorMonatsDifferenzen[0];
            rvVorMonatsDifferenzen = vorMonatsDifferenzen[1];
            BigDecimal bigDecimal = kvEntgeltEGA = BigDecimalMapper.compareTo((BigDecimal)kvVorMonatsDifferenzen, (BigDecimal)kvEntgeltEGA) > 0 ? BigDecimal.ZERO : kvEntgeltEGA.subtract(kvVorMonatsDifferenzen);
            if (BigDecimalMapper.compareTo((BigDecimal)rvVorMonatsDifferenzen, (BigDecimal)rvEntgeltEGA) > 0) {
                this.setUmverteilungFolgeWPRV(rvEntgeltEGA);
                isUmverteilung = true;
                rvEntgeltEGA = BigDecimal.ZERO;
            } else {
                rvEntgeltEGA = rvEntgeltEGA.subtract(rvVorMonatsDifferenzen);
            }
        }
        if (this.eelib.marbPgs() == 127) {
            this.setFolgeWPKVPVAV(kvEntgeltEGA, BigDecimal.valueOf(50L));
            if (!isUmverteilung) {
                this.setFolgeWPRV(rvEntgeltEGA, BigDecimal.valueOf(50L));
            }
        } else {
            BigDecimal bBGRV;
            if (svEntLfd.compareTo(beitragsbemessungsgrundlageKVPVWest) <= 0) {
                if (summeEntgeltAufgelaufen.compareTo(beitragsbemessungsgrundlageKVPVWest) <= 0) {
                    if (summeEntgeltAufgelaufen.add(kvEntgeltEGA).compareTo(beitragsbemessungsgrundlageKVPVWest) <= 0) {
                        this.setFolgeWPKVPVAV(kvEntgeltEGA, BigDecimal.valueOf(100L));
                    } else {
                        this.callib.setDurchschnittlicherZusatzbeitrag(true);
                        BigDecimal diffUeberBBG = summeEntgeltAufgelaufen.add(kvEntgeltEGA).subtract(beitragsbemessungsgrundlageKVPVWest);
                        BigDecimal diffUnterBBG = kvEntgeltEGA.subtract(diffUeberBBG);
                        if (!BigDecimalMapper.isZero((BigDecimal)diffUeberBBG)) {
                            this.setFolgeWPKVPVAV(diffUeberBBG, BigDecimal.valueOf(50L));
                        }
                        if (!BigDecimalMapper.isZero((BigDecimal)diffUnterBBG)) {
                            this.setFolgeWPKVPVAV(diffUnterBBG, BigDecimal.valueOf(100L));
                        }
                    }
                } else {
                    this.setFolgeWPKVPVAV(kvEntgeltEGA, BigDecimal.valueOf(50L));
                }
            } else {
                this.setFolgeWPKVPVAV(kvEntgeltEGA, BigDecimal.valueOf(50L));
            }
            BigDecimal bigDecimal = bBGRV = this.gllib.marbRechtskreis() == 'O' ? beitragsbemessungsgrundlageKVPVOst : beitragsbemessungsgrundlageKVPVWest;
            if (!isUmverteilung) {
                if (svEntLfd.compareTo(bBGRV) <= 0) {
                    if (summeEntgeltAufgelaufen.compareTo(bBGRV) <= 0) {
                        if (summeEntgeltAufgelaufen.add(rvEntgeltEGA).compareTo(bBGRV) <= 0) {
                            this.setFolgeWPRV(rvEntgeltEGA, BigDecimal.valueOf(100L));
                        } else {
                            BigDecimal diffUeberBBG = summeEntgeltAufgelaufen.add(rvEntgeltEGA).subtract(bBGRV);
                            BigDecimal diffUnterBBG = rvEntgeltEGA.subtract(diffUeberBBG);
                            if (!BigDecimalMapper.isZero((BigDecimal)diffUeberBBG)) {
                                this.setFolgeWPRV(diffUeberBBG, BigDecimal.valueOf(50L));
                            }
                            if (!BigDecimalMapper.isZero((BigDecimal)diffUnterBBG)) {
                                this.setFolgeWPRV(diffUnterBBG, BigDecimal.valueOf(100L));
                            }
                        }
                    } else {
                        this.setFolgeWPRV(rvEntgeltEGA, BigDecimal.valueOf(50L));
                    }
                } else {
                    this.setFolgeWPRV(rvEntgeltEGA, BigDecimal.valueOf(50L));
                }
            }
        }
    }

    private void setFolgeWPKVPVAV(BigDecimal betrag, BigDecimal prozentsatz) throws BusinessDomainException {
        switch (this.eelib.marbBgrKv()) {
            case 1: 
            case 2: 
            case 3: {
                this.wplib.addNeueWertPosition(321610, prozentsatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, betrag, false);
                this.callib.result1(this.wplib.svTage());
            }
        }
        switch (this.eelib.marbBgrPv()) {
            case 1: 
            case 2: {
                this.wplib.addNeueWertPosition(339610, prozentsatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, betrag, false);
                this.callib.result1(this.wplib.svTage());
            }
        }
        switch (this.eelib.marbBgrAv()) {
            case 1: {
                this.wplib.addNeueWertPosition(333610, prozentsatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, betrag, false);
                this.callib.result1(this.wplib.svTage());
                break;
            }
        }
    }

    private void setFolgeWPRV(BigDecimal betrag, BigDecimal prozentsatz) throws BusinessDomainException {
        switch (this.eelib.marbBgrRv()) {
            case 1: 
            case 2: {
                this.wplib.addNeueWertPosition(327610, prozentsatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, betrag, false);
                this.callib.factor1(this.wplib.svTage());
            }
        }
    }

    private void setUmverteilungFolgeWPRV(BigDecimal betrag) throws BusinessDomainException {
        switch (this.eelib.marbBgrRv()) {
            case 1: 
            case 2: {
                this.wplib.addNeueWertPosition(327610, BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, betrag, false);
                this.wplib.addNeueWertPosition(327610, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, betrag.negate(), false);
                this.callib.factor1(this.wplib.svTage());
            }
        }
    }

    private BigDecimal[] getDifferenzAusVormonaten() throws BusinessDomainException {
        BigDecimal mindestbemessungsgrundlageKV = BigDecimal.ZERO;
        BigDecimal mindestbemessungsgrundlageRV = BigDecimal.ZERO;
        BigDecimal kvEntgelt = BigDecimal.ZERO;
        BigDecimal rvEntgelt = BigDecimal.ZERO;
        Date ersterTagdesJahres = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        Date eintrittsDatum = this.eelib.marbEintritt();
        Date startMonat = DateHelper.before((Date)eintrittsDatum, (Date)ersterTagdesJahres) ? ersterTagdesJahres : eintrittsDatum;
        Date gueltigAb = DateHelper.getFirstDayOfMonth((Date)startMonat);
        Date gueltigBis = DateHelper.getLastDayOfMonth((Date)startMonat);
        while (DateHelper.before((Date)gueltigAb, (Date)this.wplib.gueltigAb())) {
            ValuePosition[] vpArray;
            block7: for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), gueltigAb, gueltigBis, ValueTypeHelper.getValueTypes((int[])new int[]{321510, 321610, 327510, 327610, 773510, 773610, 130575, 130570}))) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 321510: 
                    case 321610: {
                        kvEntgelt = kvEntgelt.add(lElement.getResult());
                        continue block7;
                    }
                    case 327510: 
                    case 327610: 
                    case 773510: 
                    case 773610: {
                        rvEntgelt = rvEntgelt.add(lElement.getResult());
                        continue block7;
                    }
                    case 130575: {
                        mindestbemessungsgrundlageRV = mindestbemessungsgrundlageRV.add(lElement.getResult());
                        continue block7;
                    }
                    case 130570: {
                        mindestbemessungsgrundlageKV = mindestbemessungsgrundlageKV.add(lElement.getResult());
                    }
                }
            }
            gueltigAb = DateHelper.tomorrow((Date)gueltigBis);
            gueltigBis = DateHelper.getLastDayOfMonth((Date)gueltigAb);
        }
        BigDecimal kvDifferenz = mindestbemessungsgrundlageKV.subtract(kvEntgelt);
        kvDifferenz = BigDecimalMapper.compareTo((BigDecimal)kvDifferenz, (BigDecimal)BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : kvDifferenz;
        BigDecimal rvDifferenz = mindestbemessungsgrundlageRV.subtract(rvEntgelt);
        rvDifferenz = BigDecimalMapper.compareTo((BigDecimal)rvDifferenz, (BigDecimal)BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : rvDifferenz;
        return new BigDecimal[]{kvDifferenz, rvDifferenz};
    }

    private boolean isEntgeltVorApril() throws BusinessDomainException {
        VarPayment vP;
        PersistentObject op = this.wplib.genesisParent().getGenesisOfParentObjects();
        if (op instanceof VarPaymentTP && (vP = ((VarPaymentTP)op).getVarPayment()) != null) {
            VarPaymentTP[] vpTPs;
            Date letzterTagErstesQuartal = DateHelper.getLastDayOfQuartal((Date)DateHelper.getFirstDayOfYear((Date)this.wplib.wertPosition().getZuflussMonat()));
            for (VarPaymentTP vpTP : vpTPs = vP.getVarPaymentHistory(letzterTagErstesQuartal)) {
                if (!DateHelper.equal((Date)vpTP.getValidFrom(), (Date)this.wplib.wertPosition().getValidFrom()) || !DateHelper.equal((Date)vpTP.getValidUntil(), (Date)this.wplib.wertPosition().getValidUntil()) || BigDecimalMapper.compareTo((BigDecimal)vpTP.getResult(), (BigDecimal)this.wplib.wertPosition().getResult()) != 0 || BigDecimalMapper.compareTo((BigDecimal)vpTP.getFactor1(), (BigDecimal)this.wplib.wertPosition().getFactor1()) != 0 || BigDecimalMapper.compareTo((BigDecimal)vpTP.getFactor2(), (BigDecimal)this.wplib.wertPosition().getFactor2()) != 0) continue;
                return true;
            }
        }
        return false;
    }
}

