/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.insurancehipiyear;

import com.infor.igf.core.util.CloneUtils;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.elo2.kvpv.Elo2ListeKVPV;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearFilterStruct;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearPersistencyManager;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTP;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTPComparator;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTPPersistencyManager;
import com.varial.personnel.domain.employee.insurancehipiyear.mapper.InsuranceHIPIYearFilterStructMapper;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class InsuranceHIPIYear
extends PersonnelPersistenceObject<InsuranceHIPIYearTP> {
    private static final int PRIORITY = 5;
    private Employee mEmployee;
    private int mYear;

    public InsuranceHIPIYear(Employee employee) {
        super(5);
        this.mEmployee = employee;
    }

    public static InsuranceHIPIYear getInsuranceHIPIYear(String objectID) {
        return new InsuranceHIPIYear(objectID);
    }

    public InsuranceHIPIYear(String objectID) {
        super(5, objectID);
    }

    public InsuranceHIPIYear(String objectId, int version) {
        super(5, objectId, version);
    }

    protected InsuranceHIPIYear(boolean readOnly) {
        super(5, readOnly);
    }

    protected void saveImpl() {
        InsuranceHIPIYearPersistencyManager.save((InsuranceHIPIYear)this);
    }

    protected void load() {
        InsuranceHIPIYearPersistencyManager.load((InsuranceHIPIYear)this);
    }

    protected void deleteImpl() {
        InsuranceHIPIYearPersistencyManager.delete((InsuranceHIPIYear)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        InsuranceHIPIYearTP[] totp;
        for (InsuranceHIPIYearTP lElement : totp = this.getSpecialHistory()) {
            lElement.remove();
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mEmployee.getDomainKey()).append(" / ").append(this.mYear).toString();
    }

    public static InsuranceHIPIYear[] getInsuranceHIPIYear(Order[] sortierung, Criterion filters) {
        return InsuranceHIPIYearPersistencyManager.query((Order[])sortierung, (Criterion)filters);
    }

    protected void setData(Employee employee, int year) {
        this.mEmployee = employee;
        this.mYear = year;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.protocol("Employee", (IPersistentObject)this.mEmployee, (IPersistentObject)employee);
        this.mEmployee = employee;
    }

    public int getYear() {
        this.requireLoaded();
        return this.mYear;
    }

    public void setYear(int year) {
        this.mYear = year;
    }

    public PersonnelHistory<InsuranceHIPIYearTP> getHistory() {
        this.requireLoaded();
        if (this.mHistory == null) {
            this.mHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getSpecialHistory());
        }
        return this.mHistory;
    }

    public InsuranceHIPIYearTP[] getInsuranceHIPIYearTPs() {
        this.requireLoaded();
        return (InsuranceHIPIYearTP[])this.listToArray(this.getHistory().getAll(), InsuranceHIPIYearTP.class);
    }

    public InsuranceHIPIYearTP[] getSpecialHistory() {
        if (this.isNew()) {
            return new InsuranceHIPIYearTP[0];
        }
        return InsuranceHIPIYearTPPersistencyManager.getInsuranceHIPIYearHistory((InsuranceHIPIYear)this);
    }

    public InsuranceHIPIYearTP[] getInsuranceHIPIYearHistory(Date destinationTimePoint) {
        if (this.isNew()) {
            return new InsuranceHIPIYearTP[0];
        }
        PersonnelHistory ph = new PersonnelHistory((PersonnelTimedPersistenceObject[])InsuranceHIPIYearTPPersistencyManager.getInsuranceHIPIYearHistory((InsuranceHIPIYear)this));
        List items = ph.getItems(destinationTimePoint);
        return items.toArray(new InsuranceHIPIYearTP[items.size()]);
    }

    public InsuranceHIPIYearTP getInsuranceHIPIYearTP(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        this.requireLoaded();
        return (InsuranceHIPIYearTP)this.getHistory().getItem(effectiveTimePoint, validTimePoint);
    }

    public InsuranceHIPIYearTP[] getEffectivInsuranceHIPIYearTP(Date effectivTimePoint) {
        return this.getInsuranceHIPIYearHistory(effectivTimePoint);
    }

    public InsuranceHIPIYearTP[] getCurrentEffectivInsuranceHIPIYearTP() {
        InsuranceHIPIYearTP[] result = new InsuranceHIPIYearTP[this.getHistory().getItems(new Date()).size()];
        return this.mHistory.getItems(new Date()).toArray(result);
    }

    public InsuranceHIPIYearTP[] getActiveEffectiveInsuranceHIPIYearHistory() {
        InsuranceHIPIYearTP[] result = new InsuranceHIPIYearTP[this.getHistory().getItems(VDate.getDateMax()).size()];
        return this.getHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public InsuranceHIPIYearTP getCurrentInsuranceHIPIYearTP() throws BusinessDomainException {
        InsuranceHIPIYearTP result = (InsuranceHIPIYearTP)this.mHistory.getItem(new Date(), new Date());
        return result;
    }

    public InsuranceHIPIYearTP[] getTimePeriods(InsuranceHIPIYearTP ptpo) throws BusinessDomainException {
        return (InsuranceHIPIYearTP[])this.getHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public InsuranceHIPIYearTP getActiveInsuranceHIPIYear() {
        InsuranceHIPIYearTP[] boTPs = InsuranceHIPIYearTPPersistencyManager.query(null, (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), (Criterion)Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())), (InsuranceHIPIYear)this, (boolean)true);
        if (boTPs.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return boTPs[0];
    }

    public static InsuranceHIPIYearTP[] getActiveInsuranceHIPIYears(InsuranceHIPIYearFilterStruct[] idlFilters, Order[] sortierung) {
        Conjunction filters = Restrictions.conjunction();
        filters.add(InsuranceHIPIYearFilterStructMapper.toFilter((InsuranceHIPIYearFilterStruct[])idlFilters));
        Criterion crit = Restrictions.sqlRestriction((String)"validuntil = ( select max(validuntil) from inshipiyytp_T A where A.oidinshipiyy = inshipiyyall_v.oidinshipiyy and A.effectiveuntil  = ? )", (String)VDate.getDateMaxAsString());
        filters.add(crit);
        InsuranceHIPIYearTP[] boTPs = InsuranceHIPIYearTPPersistencyManager.queryAll((Order[])sortierung, (Criterion)filters, (boolean)true);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(boTPs, new InsuranceHIPIYearTPComparator());
        }
        return boTPs;
    }

    public InsuranceHIPIYearTP getActiveInsuranceHIPIYearTP() {
        InsuranceHIPIYearTP[] boTPs = InsuranceHIPIYearTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidinshipiyy", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.sqlRestriction((String)"validuntil = ( select max(validuntil) from inshipiyytp_T A where A.oidinshipiyy = inshipiyytp_T.oidinshipiyy and A.effectiveuntil  = ? )", (String)VDate.getDateMaxAsString())}), (InsuranceHIPIYear)this, (boolean)true);
        if (boTPs.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return boTPs[0];
    }

    public InsuranceHIPIYearTP getObjectFromObjectId(Date effectiveTimePoint, Date validTimePoint) {
        InsuranceHIPIYearTP[] tpArray;
        if (validTimePoint == null) {
            throw ExceptionMapper.makeApplicationException((String)"input validFrom is wrong");
        }
        if (effectiveTimePoint == null) {
            effectiveTimePoint = validTimePoint;
        }
        if (DateHelper.before((Date)effectiveTimePoint, (Date)validTimePoint)) {
            effectiveTimePoint = validTimePoint;
        }
        if ((tpArray = InsuranceHIPIYearTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidinshipiyy", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))}), (InsuranceHIPIYear)this, (boolean)true)).length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return tpArray[0];
    }

    public void addHistory(InsuranceHIPIYearTP boTP, boolean removeNew) throws BusinessDomainException {
        boTP.checkAttributes();
        InsuranceHIPIYearTP[] changedArray = (InsuranceHIPIYearTP[])this.listToArray(this.addItem(boTP, removeNew), InsuranceHIPIYearTP.class);
        if (changedArray.length == 1) {
            boTP.setEffectiveFrom(DateHelper.tomorrow((Date)this.getEmployee().getJournalizedUntil()));
        }
        for (InsuranceHIPIYearTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public void setHistory(InsuranceHIPIYearTP boTP, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        InsuranceHIPIYearTP[] changedArray;
        boTP.checkAttributes();
        if (DateHelper.equal((Date)boTP.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = (InsuranceHIPIYearTP[])this.listToArray(this.getHistory().setItem((PersonnelTimedPersistenceObject)boTP, removeNew), InsuranceHIPIYearTP.class);
        } else {
            removeNew = true;
            changedArray = (InsuranceHIPIYearTP[])this.listToArray(this.addItem(boTP, removeNew), InsuranceHIPIYearTP.class);
        }
        for (InsuranceHIPIYearTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public List<InsuranceHIPIYearTP> addItem(InsuranceHIPIYearTP boTP, boolean removeNew) throws BusinessDomainException {
        PersonnelHistory<InsuranceHIPIYearTP> history = this.getHistory();
        Date oldValidUntil = CloneUtils.clone((Date)VDate.getDateMax());
        Date oldValidFrom = CloneUtils.clone((Date)boTP.getValidFrom());
        Date oldEffectiveFrom = CloneUtils.clone((Date)boTP.getEffectiveFrom());
        if (boTP.getValidUntil() != null) {
            oldValidUntil = boTP.getValidUntil();
        }
        List changedList = history.addItem((PersonnelTimedPersistenceObject)boTP, removeNew);
        for (int i = 0; i < changedList.size(); ++i) {
            InsuranceHIPIYearTP hyTP = (InsuranceHIPIYearTP)changedList.get(i);
            if (!DateHelper.equal((Date)hyTP.getValidFrom(), (Date)oldValidFrom) || !DateHelper.equal((Date)hyTP.getEffectiveFrom(), (Date)oldEffectiveFrom)) continue;
            hyTP.setValidUntil(oldValidUntil);
        }
        return changedList;
    }

    public void deleteInsuranceHIPIYear() throws BusinessDomainException {
        boolean deletable = true;
        PersonnelHistory<InsuranceHIPIYearTP> history = this.getHistory();
        for (int i = 0; i < history.getSize(); ++i) {
            if (!((InsuranceHIPIYearTP)history.getItem(i)).getEffectiveFrom().before(this.mEmployee.getJournalizedUntil())) continue;
            deletable = false;
        }
        if (deletable) {
            this.destroy();
        } else {
            this.deleteInsuranceHIPIYearHistory();
        }
    }

    public void deleteInsuranceHIPIYearHistory() throws BusinessDomainException {
        for (int i = 0; i < this.mHistory.getSize(); ++i) {
            if (((InsuranceHIPIYearTP)this.mHistory.getItem(i)).inEffectiveness(this.mEmployee.getJournalizedUntil())) {
                ((InsuranceHIPIYearTP)this.mHistory.getItem(i)).setEffectiveUntil(this.mEmployee.getJournalizedUntil());
                ((InsuranceHIPIYearTP)this.mHistory.getItem(i)).makeSaveable();
                continue;
            }
            if (!DateHelper.after((Date)((InsuranceHIPIYearTP)this.mHistory.getItem(i)).getEffectiveFrom(), (Date)this.mEmployee.getJournalizedUntil())) continue;
            ((InsuranceHIPIYearTP)this.mHistory.getItem(i)).makeSaveable();
            ((InsuranceHIPIYearTP)this.mHistory.getItem(i)).destroy();
        }
    }

    public static boolean isManuallyForThisYear(Employee employee, int year) throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.eq((String)"foryear", (String)String.valueOf(year)), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString())});
        InsuranceHIPIYearTP[] tps = InsuranceHIPIYearTPPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true);
        return tps.length > 0 && tps[0].getManually();
    }

    public static boolean addElo2ListeKVPVItem(AuthorizationToken token, Employee employee, Elo2ListeKVPV item) throws BusinessDomainException {
        InsuranceHIPIYearTP result;
        InsuranceHIPIYearTP tp;
        Employee newEmployee;
        if (item == null) {
            return true;
        }
        Date calculationStart = null;
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.eq((String)"foryear", (String)String.valueOf(item.getJahr())), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString())});
        InsuranceHIPIYearTP[] tps = InsuranceHIPIYearTPPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true);
        if (tps.length > 0 && tps[0].getManually()) {
            return false;
        }
        if (tps.length == 0) {
            newEmployee = InsuranceHIPIYear.getIEmployeePM().getEmployee(employee.getObjectid());
            Date maxDateOfEntry = newEmployee.getMaximumDateOfEntry();
            if (DateHelper.before((Date)DateHelper.getLastDayOfMonth((Date)item.getGueltigbis()), (Date)maxDateOfEntry)) {
                return false;
            }
            InsuranceHIPIYear root = new InsuranceHIPIYear(newEmployee);
            root.setYear(item.getJahr());
            root.makeSaveable();
            SessionContext.getInstance().getPersistencySession().flush();
            tp = new InsuranceHIPIYearTP(root);
            tp.setEffectiveFrom(DateHelper.tomorrow((Date)newEmployee.getJournalizedUntil()));
            tp.setValidFrom(DateHelper.getFirstDayOfMonth((Date)item.getGueltigab()));
            tp.setValidUntil(DateHelper.getLastDayOfMonth((Date)item.getGueltigbis()));
            tp.setTotalRateToPHI(item.getKvzuschuss());
            tp.setBaseRatePHI(item.getKvvorsorge());
            tp.setTotalRateToPNI(item.getPvzuschuss());
            tp.setBaseRatePNI(item.getPvvorsorge());
            root.addHistory(tp, true);
            SessionContext.getInstance().getPersistencySession().flush();
            result = root.getActiveInsuranceHIPIYearTP();
            calculationStart = result.getValidFrom();
        }
        if (tps.length > 0) {
            newEmployee = InsuranceHIPIYear.getIEmployeePM().getEmployee(employee.getObjectid());
            InsuranceHIPIYear root = new InsuranceHIPIYear(tps[0].getInsuranceHIPIYear().getObjectid());
            InsuranceHIPIYearTP tpCurrent = root.getActiveInsuranceHIPIYearTP();
            tp = new InsuranceHIPIYearTP(tpCurrent.getObjectid(), tpCurrent.getVersion(), root);
            tp.setEffectiveFrom(DateHelper.tomorrow((Date)newEmployee.getJournalizedUntil()));
            tp.setValidFrom(DateHelper.getFirstDayOfMonth((Date)item.getGueltigab()));
            tp.setValidUntil(DateHelper.getLastDayOfMonth((Date)item.getGueltigbis()));
            tp.setTotalRateToPHI(item.getKvzuschuss());
            tp.setBaseRatePHI(item.getKvvorsorge());
            tp.setTotalRateToPNI(item.getPvzuschuss());
            tp.setBaseRatePNI(item.getPvvorsorge());
            if (DateHelper.equal((Date)tpCurrent.getValidFrom(), (Date)tp.getValidFrom())) {
                root.setHistory(tp, false, tpCurrent.getEffectiveFrom());
            } else {
                root.addHistory(tp, true);
            }
            SessionContext.getInstance().getPersistencySession().flush();
            result = root.getActiveInsuranceHIPIYearTP();
            calculationStart = result.getValidFrom();
        }
        if (calculationStart != null) {
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, employee, DateHelper.tomorrow((Date)employee.getJournalizedUntil()), calculationStart, InsuranceHIPIYear.class.getName());
        }
        return true;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

