/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.absenttime;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ExceptionHolder;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.absenttime.AbsentTimeTP;
import com.varial.personnel.domain.absenttime.CutOfSocialInsuranceDaysEnum;
import com.varial.personnel.domain.absenttime.CutOfTaxacationDaysEnum;
import com.varial.personnel.domain.absenttime.NumberOfUEnum;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.costunit.CostUnit;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTime;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.TypeAgePartTimeEnum;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.regex.Pattern;

public class EEAbsentTimeTP
extends PersonnelTimedPersistenceObject
implements IEmployeeReferenced {
    private static final int PRIORITY = 6;
    private final Pattern NAME_OF_CHILD_PATTERN = Pattern.compile("(^[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\u00c0\u00c1\u00c2\u00c8\u00c9\u00ca\u00cc\u00cd\u00ce\u00d2\u00d3\u00d4\u00d9\u00da\u00db\u00e0\u00e1\u00e2\u00e8\u00e9\u00ea\u00ec\u00ed\u00ee\u00f2\u00f3\u00f4\u00f9\u00fa\u00fb0-9-_,. ]+)");
    private EEAbsentTime mEEAbsentTime;
    private EEAbsentTime mPredecessorEEAbsentTime;
    private BigDecimal mNumberOfHours;
    private CostUnit mCostUnit;
    private CostCenter mCostCenter;
    private boolean mHalfLeaveDay;
    private BigDecimal mComparisonNet;
    private BigDecimal mStickPay;
    boolean mPrintOnStatementOfEarnings;
    private int mIndexOfConsequence;
    private Date mDueDate;
    private int mTypeOfBirth;
    private String mAdditionalInfo;
    private BigDecimal mNumberOfWorkingHours;
    private boolean mWaitingDay;
    private String mAbandonment;

    public EEAbsentTimeTP(EEAbsentTime eeAbsentTime) {
        super(6);
        this.mEEAbsentTime = eeAbsentTime;
    }

    private EEAbsentTimeTP(String objectID, EEAbsentTime eeAbsentTime) {
        super(6, objectID);
        this.mEEAbsentTime = eeAbsentTime;
    }

    public EEAbsentTimeTP(String objectID, int version) {
        super(6, objectID, version);
    }

    protected EEAbsentTimeTP(EEAbsentTime eeAbsentTime, boolean readOnly) {
        super(6, readOnly);
        this.mEEAbsentTime = eeAbsentTime;
    }

    public static EEAbsentTimeTP getEEAbsentTimeTP(String objectid) {
        return new EEAbsentTimeTP(objectid);
    }

    private EEAbsentTimeTP(String objectid) {
        super(6, objectid);
    }

    public static EEAbsentTimeTP getEEAbsentTimeTP(String objectID, EEAbsentTime eeAbsentTime) {
        return new EEAbsentTimeTP(objectID, eeAbsentTime);
    }

    protected void load() {
        EEAbsentTimeTPPersistencyManager.load((EEAbsentTimeTP)this);
    }

    protected void saveImpl() {
        EEAbsentTimeTPPersistencyManager.save((EEAbsentTimeTP)this);
    }

    protected void deleteImpl() {
        EEAbsentTimeTPPersistencyManager.delete((EEAbsentTimeTP)this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mEEAbsentTime.getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public void setData(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, EEAbsentTime predecessorEEAbsentTime, BigDecimal numberOfHours, CostUnit costUnit, CostCenter costCenter, boolean halfLeaveDay, BigDecimal comparisonNet, BigDecimal stickPay, boolean printOnStatementOfEarnings, int indexOfConsequence, Date dueDate, int typeOfBirth, String additionalInfo, BigDecimal numberOfWorkingHours, boolean waitingDay, String abandonment) {
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mPredecessorEEAbsentTime = predecessorEEAbsentTime;
        this.mNumberOfHours = numberOfHours;
        this.mCostUnit = costUnit;
        this.mCostCenter = costCenter;
        this.mHalfLeaveDay = halfLeaveDay;
        this.mComparisonNet = comparisonNet;
        this.mStickPay = stickPay;
        this.mPrintOnStatementOfEarnings = printOnStatementOfEarnings;
        this.mIndexOfConsequence = indexOfConsequence;
        this.mDueDate = dueDate;
        this.mTypeOfBirth = typeOfBirth;
        this.mAdditionalInfo = additionalInfo;
        this.mNumberOfWorkingHours = numberOfWorkingHours;
        this.mWaitingDay = waitingDay;
        this.mAbandonment = abandonment;
    }

    public void checkAttributes() throws BusinessDomainException {
        this.requireLoaded();
        this.checkDates();
        this.checkValidFromAgainstRetroactiveCalculation(this.getEEAbsentTime().getEmployee());
        this.checkAbsentTime();
        this.checkNumberOfHours();
        this.checkHolidayInOneYear();
        this.checkEEAbsentTimePredecessor();
        this.isThisEEAbsentTimePredecessor();
        this.checkHalfLeaveDay();
        this.checkPrivateHI();
        this.checkGfB();
        this.checkChangedDeuv();
        this.checkVWECostCenters();
        this.checkUseFrom();
        this.checkEL();
        this.checkBT();
        this.checkEFUandEFKandEFZ();
        this.checkKK();
        this.checkWaitingDay();
        this.checkAdditionalInfo();
        this.checkBTandM();
        this.checkAbandonment();
    }

    private void checkAbandonment() throws BusinessDomainException {
        if (!StringMapper.equal((String)this.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"EFS")) {
            if (StringMapper.equal((String)this.mAbandonment, (String)"J") || StringMapper.equal((String)this.mAbandonment, (String)"N")) {
                throw EmployeeExceptionMapper.makeOnlyByEFSDomainException();
            }
        } else if (!(StringMapper.isNullString((String)this.mAbandonment) || StringMapper.equal((String)this.mAbandonment, (String)"J") || StringMapper.equal((String)this.mAbandonment, (String)"N"))) {
            throw FrameWorkExceptionMapper.makeOnlyEmptyOrJOrNAllowedDomainException();
        }
    }

    private void checkChangedDeuv() throws BusinessDomainException {
        String[] oldKeys = new String[]{"AS", "EK"};
        String[] newKeys = new String[]{"AU", "ES"};
        if (DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2006, 7, 1).getDate())) {
            this.checkDEUVAbsentTimeKey(newKeys, oldKeys);
        }
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2007, 3, 1).getDate())) {
            this.checkDEUVAbsentTimeKey(oldKeys, newKeys);
        }
        oldKeys = new String[]{"ZA", "WA"};
        newKeys = new String[]{"Z", "W"};
        if (DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2012, 0, 1).getDate())) {
            this.checkDEUVAbsentTimeKey(newKeys, oldKeys);
        }
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2012, 0, 1).getDate())) {
            this.checkDEUVAbsentTimeKey(oldKeys, newKeys);
        }
        oldKeys = new String[]{"FIV"};
        newKeys = new String[]{"keine"};
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2019, 0, 1).getDate())) {
            this.checkDEUVAbsentTimeKey(oldKeys, newKeys);
        }
    }

    private void checkDEUVAbsentTimeKey(String[] invalids, String[] valids) throws BusinessDomainException {
        String key = this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey();
        for (int i = 0; i < invalids.length; ++i) {
            if (!key.equals(invalids[i])) continue;
            throw EmployeeExceptionMapper.makeAbsentTimeKeyInvalidDomainException(invalids[i], valids[i]);
        }
    }

    private void checkUseFrom() throws BusinessDomainException {
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFZ") && this.isNew() && DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2016, 0, 1).getDate())) {
            throw EmployeeExceptionMapper.makeEFZNotAllowedDomainException();
        }
        if ((StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EZK") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EZQ")) && this.isNew() && DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2023, 6, 1).getDate())) {
            throw EmployeeExceptionMapper.makeEZKandEZQnotAllowedDomainException();
        }
    }

    private void checkAdditionalInfo() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mAdditionalInfo)) {
            return;
        }
        if (!this.NAME_OF_CHILD_PATTERN.matcher(this.mAdditionalInfo).matches()) {
            throw EmployeeExceptionMapper.makeChildnameContainsNotAllowedCharsDomainException();
        }
    }

    private void checkWaitingDay() throws BusinessDomainException {
        if (!(!this.mWaitingDay || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFK") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFS") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFU") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFZ"))) {
            throw FrameWorkExceptionMapper.makeInputNotAllowedDomainException((String)" Wartetag = Ja bei dieser Fehlzeit");
        }
    }

    private void checkBT() throws BusinessDomainException {
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"BT") && this.isNew()) {
            throw EmployeeExceptionMapper.makeBTNotAllowedDomainException();
        }
    }

    private void checkBTandM() throws BusinessDomainException {
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"BTG") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"BTI") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"BIT") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"BGT") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"M") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"MO")) {
            Master master = this.getEEAbsentTime().getEmployee().getMaster(this.mEffectiveFrom, this.mValidFrom);
            if (master.getSex() == SexEnum.SE_MAENNLICH) {
                throw EmployeeExceptionMapper.makeEEAbsenttimeOnlyFemaleDomainException();
            }
            if (this.mDueDate == null) {
                throw EmployeeExceptionMapper.makeInputOfDueDateIsMissingDomainException();
            }
        }
    }

    private void checkEFUandEFKandEFZ() throws BusinessDomainException {
        block7: {
            if (!(StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFK") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFU") || StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getAbsentTimeKey(), (String)"EFS"))) {
                return;
            }
            try {
                Insurance ins = this.getEEAbsentTime().getEmployee().getInsurance(this.mEffectiveFrom, this.mValidFrom);
                if (ins.getPersonGroup() == 103 && ins.getTypeAgePartTime() == TypeAgePartTimeEnum.TOAPTE_BLOCKZEIT) {
                    if (DateHelper.between((Date)ins.getBeginWorkExemption(), (Date)this.mValidFrom, (Date)this.mValidUntil) || DateHelper.before((Date)ins.getBeginWorkExemption(), (Date)this.mValidFrom)) {
                        throw EmployeeExceptionMapper.makeEFUNotAllowedDomainException(" Beginn der Freistellung zwischen Beginn und Ende Fehlzeit oder Beginn der Fehlzeit nach Beginn der Freistellung");
                    }
                    if (DateHelper.before((Date)this.mValidFrom, (Date)ins.getBeginWorkExemption()) && DateHelper.equal((Date)this.mValidUntil, (Date)VDate.getDateMax())) {
                        throw EmployeeExceptionMapper.makeEFUNotAllowedDomainException(" Beginn der Fehlzeit ist vor dem Beginn der Freistellung und das Ende der Fehlzeit fehlt");
                    }
                    if (DateHelper.after((Date)this.mValidUntil, (Date)DateHelper.yesterday((Date)ins.getBeginWorkExemption()))) {
                        throw EmployeeExceptionMapper.makeEFUNotAllowedDomainException(" das Ende der Fehlzeit ist nach dem Beginn der Freistellung");
                    }
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block7;
                throw e;
            }
        }
    }

    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        Date[] dates = this.mEEAbsentTime.getEmployee().checkDates(false, this.getValidFrom(), this.getValidUntil());
        this.setEffectiveFrom(dates[0]);
        this.setValidFrom(dates[1]);
        if (DateHelper.before((Date)this.mValidUntil, (Date)this.mEEAbsentTime.getEmployee().getStartOfHistory())) {
            throw EmployeeExceptionMapper.makeValidUntilBeforeStartOfHistoryDomainException();
        }
        Date lastDateOfWithDrawal = this.getEEAbsentTime().getEmployee().getLastDateOfWithdrawal();
    }

    public void checkAbsentTime() throws BusinessDomainException {
        if (this.mEEAbsentTime.getAbsentTime().getAbsentTimeTP(this.getEffectiveFrom(), this.getValidFrom()).getForAggregationOnly()) {
            throw EmployeeExceptionMapper.makeAbsentTimeForAggregationOnlyDomainException();
        }
    }

    public void checkNumberOfHours() throws BusinessDomainException {
        if (!(StringMapper.equal((String)this.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.43") || StringMapper.equal((String)this.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.44") || StringMapper.equal((String)this.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"1.9.5"))) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfHours) && !DateHelper.equal((Date)this.mValidFrom, (Date)this.mValidUntil)) {
                throw EmployeeExceptionMapper.makeNumberOfHoursFalseDomainException();
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfHours) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfWorkingHours)) {
                return;
            }
            if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfHours) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfWorkingHours) || !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfHours) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNumberOfWorkingHours))) {
                throw EmployeeExceptionMapper.makeNumberOfHoursOrNumberOforkingHoursDomainException();
            }
        }
    }

    public void checkHolidayInOneYear() throws BusinessDomainException {
        if (this.mEEAbsentTime.getAbsentTime().getAbsentTimeTP(this.mEffectiveFrom, this.mValidFrom).getIsHoliday() && new VDate(this.mValidFrom).getYear() != new VDate(this.mValidUntil).getYear()) {
            throw EmployeeExceptionMapper.makeHolidayNotInOneYearDomainException();
        }
    }

    public void isThisEEAbsentTimePredecessor() throws BusinessDomainException {
        Date minValidFromOfSuccessors;
        if (!this.mEEAbsentTime.isNew() && (minValidFromOfSuccessors = EEAbsentTimeTPPersistencyManager.getMinValidFromOfSuccessors((EEAbsentTime)this.getEEAbsentTime())) != null && !DateHelper.before((Date)this.mValidUntil, (Date)minValidFromOfSuccessors)) {
            throw EmployeeExceptionMapper.makeEEAbsentTimeAndSuccessorDontCorrespondingDomainException(DateMapper.toString((Date)minValidFromOfSuccessors));
        }
    }

    public void checkEEAbsentTimePredecessor() throws BusinessDomainException {
        if (this.mPredecessorEEAbsentTime != null && this.mEEAbsentTime.getAbsentTime().getDEUVRelevant()) {
            throw EmployeeExceptionMapper.makePredecessorEEAbsentTimeFalseDomainException();
        }
    }

    public void checkHalfLeaveDay() throws BusinessDomainException {
        AbsentTimeTP eeAbsentTimeTP = this.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.getEffectiveFrom(), this.getValidFrom());
        if (this.mHalfLeaveDay && eeAbsentTimeTP.getAbsentTime().getDEUVRelevant()) {
            throw EmployeeExceptionMapper.makeHalfDaysOfDeuvNotAllowedDomainException();
        }
        if (this.mHalfLeaveDay && !eeAbsentTimeTP.getHalfLeaveDayAllowed()) {
            throw EmployeeExceptionMapper.makeHalfLeaveDayNotAllowedDomainException();
        }
        if (this.mHalfLeaveDay && !DateHelper.equal((Date)this.getValidFrom(), (Date)this.getValidUntil())) {
            throw EmployeeExceptionMapper.makeHalfLeaveDayNotAllowedDomainException();
        }
    }

    public void checkPrivateHI() throws BusinessDomainException {
        Insurance insurance;
        block5: {
            insurance = null;
            try {
                insurance = this.mEEAbsentTime.getEmployee().getInsurance(this.mEffectiveFrom, this.mValidFrom);
            }
            catch (ApplicationException e) {
                throw e;
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                throw e;
            }
        }
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getDEUVAbsentTimeKey(), (String)"2.5") && (insurance == null || !insurance.getPrivateHI())) {
            throw EmployeeExceptionMapper.makeOnlyByPrivateHIDomainException();
        }
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getDEUVAbsentTimeKey(), (String)"4.1") && (insurance == null || insurance.getPrivateHI()) && DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2008, 0, 1).getDate())) {
            throw EmployeeExceptionMapper.makeByPrivateHINotAllowedDomainException();
        }
    }

    public void checkGfB() throws BusinessDomainException {
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getDEUVAbsentTimeKey(), (String)"2.7")) {
            Insurance insurance = (Insurance)this.mEEAbsentTime.getEmployee().getInsuranceHistory().getItemOrNull(this.mEffectiveFrom, this.mValidFrom);
            if (insurance == null) {
                throw EmployeeExceptionMapper.makeInsuranceMissingForDateDomainException();
            }
            if (insurance.getPersonGroup() != 109 && insurance.getDuesGroupHI() != 6 && insurance.getDuesGroupPI() != 5) {
                throw EmployeeExceptionMapper.makeOnlyByGfBDomainException();
            }
        }
    }

    public void checkForAdvice(ExceptionHolder exceptionHolder) {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mComparisonNet) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mStickPay)) {
            exceptionHolder.setException(EmployeeExceptionMapper.makeStickPayMissingDomainException());
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mComparisonNet) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mStickPay)) {
            exceptionHolder.setException(EmployeeExceptionMapper.makeComparisonNetMissingDomainException());
        }
    }

    public PersonnelTimedPersistenceObject createNew() {
        EEAbsentTimeTP result = new EEAbsentTimeTP(this.mEEAbsentTime);
        result.mEffectiveFrom = this.getEffectiveFrom();
        result.mEffectiveUntil = this.getEffectiveUntil();
        result.mValidFrom = this.getValidFrom();
        result.mValidUntil = this.getValidUntil();
        result.mPredecessorEEAbsentTime = this.getPredecessorEEAbsentTime();
        result.mNumberOfHours = this.getNumberOfHours();
        result.mCostUnit = this.getCostUnit();
        result.mCostCenter = this.getCostCenter();
        result.mHalfLeaveDay = this.getHalfLeaveDay();
        result.mComparisonNet = this.getComparisonNet();
        result.mStickPay = this.getStickPay();
        result.mPrintOnStatementOfEarnings = this.getPrintOnStatementOfEarnings();
        result.mIndexOfConsequence = this.getIndexOfConsequence();
        result.mDueDate = this.getDueDate();
        result.mTypeOfBirth = this.getTypeOfBirth();
        result.mAdditionalInfo = this.getAdditionalInfo();
        result.mNumberOfWorkingHours = this.getNumberOfWorkingHours();
        result.mWaitingDay = this.getWaitingDay();
        result.mAbandonment = this.getAbandonment();
        return result;
    }

    public EEAbsentTime getEEAbsentTime() {
        this.requireLoaded();
        return this.mEEAbsentTime;
    }

    public void setEEAbsentTime(EEAbsentTime eeAbsentTime) {
        this.mEEAbsentTime = eeAbsentTime;
    }

    public EEAbsentTime getPredecessorEEAbsentTime() {
        this.requireLoaded();
        return this.mPredecessorEEAbsentTime;
    }

    public void setPredecessorEEAbsentTime(EEAbsentTime predecessorEEAbsentTime) {
        this.protocol("EEAbsentTime.PredecessorEEAbsentTime", this.mPredecessorEEAbsentTime == null ? null : this.mPredecessorEEAbsentTime.getDomainKey(), predecessorEEAbsentTime == null ? null : predecessorEEAbsentTime.getDomainKey());
        this.mPredecessorEEAbsentTime = predecessorEEAbsentTime;
    }

    public BigDecimal getNumberOfHours() {
        this.requireLoaded();
        return this.mNumberOfHours == null ? new BigDecimal("0.00") : this.mNumberOfHours;
    }

    public void setNumberOfHours(BigDecimal numberOfHours) {
        this.protocol("EEAbsentTime.NumberOfHours", this.mNumberOfHours, numberOfHours);
        this.mNumberOfHours = numberOfHours;
    }

    public CostUnit getCostUnit() {
        this.requireLoaded();
        return this.mCostUnit;
    }

    public void setCostUnit(CostUnit costUnit) {
        this.protocol("EEAbsentTime.CostUnit", this.mCostUnit == null ? null : this.mCostUnit.getDomainKey(), costUnit == null ? null : costUnit.getDomainKey());
        this.mCostUnit = costUnit;
    }

    public CostCenter getCostCenter() {
        this.requireLoaded();
        return this.mCostCenter;
    }

    public void setCostCenter(CostCenter costCenter) {
        this.protocol("EEAbsentTime.CostCenter", this.mCostCenter == null ? null : this.mCostCenter.getDomainKey(), costCenter == null ? null : costCenter.getDomainKey());
        this.mCostCenter = costCenter;
    }

    public boolean getHalfLeaveDay() {
        this.requireLoaded();
        return this.mHalfLeaveDay;
    }

    public void setHalfLeaveDay(boolean halfLeaveDay) {
        this.mHalfLeaveDay = halfLeaveDay;
    }

    public BigDecimal getComparisonNet() {
        this.requireLoaded();
        return this.mComparisonNet;
    }

    public void setComparisonNet(BigDecimal comparisonNet) {
        this.mComparisonNet = comparisonNet;
    }

    public BigDecimal getStickPay() {
        this.requireLoaded();
        return this.mStickPay;
    }

    public void setStickPay(BigDecimal stickPay) {
        this.mStickPay = stickPay;
    }

    public boolean getPrintOnStatementOfEarnings() {
        this.requireLoaded();
        return this.mPrintOnStatementOfEarnings;
    }

    public void setPrintOnStatementOfEarnings(boolean printOnStatementOfEarnings) {
        this.mPrintOnStatementOfEarnings = printOnStatementOfEarnings;
    }

    public int getIndexOfConsequence() {
        this.requireLoaded();
        return this.mIndexOfConsequence;
    }

    public void setIndexOfConsequence(int indexOfConsequence) {
        this.mIndexOfConsequence = indexOfConsequence;
    }

    public Date getDueDate() {
        this.requireLoaded();
        return this.mDueDate;
    }

    public void setDueDate(Date dueDate) {
        this.mDueDate = dueDate;
    }

    public int getTypeOfBirth() {
        this.requireLoaded();
        return this.mTypeOfBirth;
    }

    public void setTypeOfBirth(int typeOfBirth) {
        this.mTypeOfBirth = typeOfBirth;
    }

    public String getAdditionalInfo() {
        this.requireLoaded();
        return this.mAdditionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.mAdditionalInfo = additionalInfo;
    }

    public BigDecimal getNumberOfWorkingHours() {
        this.requireLoaded();
        return this.mNumberOfWorkingHours;
    }

    public void setNumberOfWorkingHours(BigDecimal numberOfWorkingHours) {
        this.mNumberOfWorkingHours = numberOfWorkingHours;
    }

    public boolean getWaitingDay() {
        this.requireLoaded();
        return this.mWaitingDay;
    }

    public void setWaitingDay(boolean waitingDay) {
        this.mWaitingDay = waitingDay;
    }

    public String getAbandonment() {
        this.requireLoaded();
        return this.mAbandonment;
    }

    public void setAbandonment(String abandonment) {
        this.mAbandonment = abandonment;
    }

    public void compareToOld(EEAbsentTimeTP old) {
        if (old == null) {
            return;
        }
        if (DateHelper.equal((Date)old.getValidFrom(), (Date)this.getValidFrom()) && PersonnelPersistenceObject.isEqual((IPersistentObject)old.getPredecessorEEAbsentTime(), (IPersistentObject)this.mPredecessorEEAbsentTime) && PBigDecimalMapper.isEqual((BigDecimal)old.getNumberOfHours(), (BigDecimal)this.mNumberOfHours) && !DateHelper.equal((Date)old.getValidUntil(), (Date)this.mValidUntil) && PBigDecimalMapper.isEqual((BigDecimal)old.getComparisonNet(), (BigDecimal)this.mComparisonNet) && PBigDecimalMapper.isEqual((BigDecimal)old.getStickPay(), (BigDecimal)this.mStickPay) && DateHelper.equal((Date)old.getDueDate(), (Date)this.getDueDate()) && PBigDecimalMapper.isEqual((BigDecimal)old.getNumberOfWorkingHours(), (BigDecimal)this.mNumberOfWorkingHours)) {
            this.setOnlyValidUntilChanged(true);
        }
        if (!DateHelper.equal((Date)old.getValidFrom(), (Date)this.getValidFrom())) {
            this.setValuateNeeded(true);
            return;
        }
        if (!DateHelper.equal((Date)old.getValidUntil(), (Date)this.getValidUntil())) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.getPredecessorEEAbsentTime(), (IPersistentObject)this.mPredecessorEEAbsentTime)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getNumberOfHours(), (BigDecimal)this.mNumberOfHours)) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.mHalfLeaveDay != this.getHalfLeaveDay()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getComparisonNet(), (BigDecimal)this.mComparisonNet)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getStickPay(), (BigDecimal)this.mStickPay)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!DateHelper.equal((Date)old.getDueDate(), (Date)this.getDueDate())) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getNumberOfWorkingHours(), (BigDecimal)this.mNumberOfWorkingHours)) {
            this.setValuateNeeded(true);
            return;
        }
    }

    public void checkPostCondition() throws BusinessDomainException {
        if (!DateHelper.equal((Date)this.getEffectiveUntil(), (Date)VDate.getDateMax())) {
            return;
        }
        EEAbsentTimeTP[] tpArray = this.getEEAbsentTime().getEmployee().getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.ne((String)"oideeabsenttime", (String)this.getEEAbsentTime().getObjectid()), Restrictions.eq((String)"oidemployee", (String)this.getEEAbsentTime().getEmployee().getObjectid()), Restrictions.eq((String)"deleted", (String)"F")}), true);
        for (int i = 0; i < tpArray.length; ++i) {
            if (!DateHelper.beforeOrEqual((Date)this.getValidFrom(), (Date)tpArray[i].getValidUntil()) || !DateHelper.afterOrEqual((Date)this.getValidUntil(), (Date)tpArray[i].getValidFrom())) continue;
            throw EmployeeExceptionMapper.makeTwoAbsentTimesToTheSameTimeDomainException();
        }
    }

    public void checkChangedValidness(EEAbsentTimeTP eeAbsenttimeTPold) throws BusinessDomainException {
        if (!DateHelper.equal((Date)this.getValidFrom(), (Date)eeAbsenttimeTPold.getValidFrom())) {
            throw EmployeeExceptionMapper.makeChangeValidnessDomainException();
        }
    }

    public String getRootDomainKey() {
        return this.getEEAbsentTime().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Mitarbeiterfehlzeit";
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEEAbsentTime.getEmployee();
    }

    public void create(AuthorizationToken token, ExceptionHolder exceptionHolder) throws BusinessDomainException {
        this.createInternal(token);
        this.checkForAdvice(exceptionHolder);
    }

    public void createFromCal(AuthorizationToken token) throws BusinessDomainException {
        this.createInternal(token);
    }

    public void createFromPWSymbol() throws BusinessDomainException {
        this.mEEAbsentTime.addHistoryInternal(this, true);
    }

    private void createInternal(AuthorizationToken token) throws BusinessDomainException {
        this.mEEAbsentTime.addHistory(this, true);
        Date valuateValidFrom = this.getEmployee().checkAndCorrectValidFromStartOfValuate(this.getEffectiveFrom(), this.getValidFrom());
        if (this.valuate(this.mEEAbsentTime.getAbsentTime(), this.mEffectiveFrom, valuateValidFrom)) {
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, this.getEmployee(), this.mEffectiveFrom, valuateValidFrom, this.mEEAbsentTime.getClass().getName());
        } else {
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    public void update(AuthorizationToken token, ExceptionHolder exceptionHolder) throws BusinessDomainException {
        this.updateInternal(token);
        this.checkForAdvice(exceptionHolder);
    }

    public void updateFromCal(AuthorizationToken token) throws BusinessDomainException {
        this.updateInternal(token);
    }

    public void updateFromEELOrEAU(AuthorizationToken token) throws BusinessDomainException {
        this.updateInternal(token);
    }

    private void updateInternal(AuthorizationToken token) throws BusinessDomainException {
        this.requireLoaded();
        EEAbsentTimeTP eeAbsentTimeTPold = EEAbsentTimeTP.getEEAbsentTimeTP(this.getObjectid());
        this.checkChangedValidness(eeAbsentTimeTPold);
        this.compareToOld(eeAbsentTimeTPold);
        this.mEEAbsentTime.setHistory(this, false, this.mEffectiveFrom);
        if (this.getValuateNeeded()) {
            PersonnelBasic pb;
            Date valuateEffectiveFrom = this.getEffectiveFrom();
            Date valuateValidFrom = this.getValidFrom();
            if (this.getOnlyValidUntilChanged() && DateHelper.after((Date)(valuateValidFrom = DateHelper.before((Date)eeAbsentTimeTPold.getValidUntil(), (Date)this.getValidUntil()) ? eeAbsentTimeTPold.getValidUntil() : this.getValidUntil()), (Date)(pb = PersonnelBasic.getPersonnelBasic()).getCalculationUntil(this.getEmployee().getJournalizedUntil()))) {
                valuateValidFrom = pb.getCalculationUntil(this.getEmployee().getJournalizedUntil());
            }
            valuateValidFrom = this.getEmployee().checkAndCorrectValidFromStartOfValuate(valuateEffectiveFrom, valuateValidFrom);
            if (this.valuate(this.mEEAbsentTime.getAbsentTime(), valuateEffectiveFrom, valuateValidFrom)) {
                ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, this.getEmployee(), valuateEffectiveFrom, valuateValidFrom, this.mEEAbsentTime.getClass().getName());
            }
        } else {
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    public void delete(AuthorizationToken token) throws BusinessDomainException {
        this.requireLoaded();
        if (this.mEEAbsentTime.getIsDeleted()) {
            throw EmployeeExceptionMapper.makeEEAbsenttimeAlreadyDeletedDomainException();
        }
        Date valuateEffectiveFrom = DateHelper.tomorrow((Date)this.getEmployee().getJournalizedUntil());
        Date valuateValidFrom = this.getEmployee().checkAndCorrectValidFromStartOfValuate(this.mEffectiveFrom, this.mValidFrom);
        this.mEEAbsentTime.deleteEEAbsentTime();
        if (this.valuate(this.mEEAbsentTime.getAbsentTime(), this.mEffectiveFrom, valuateValidFrom)) {
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, this.getEmployee(), valuateEffectiveFrom, valuateValidFrom, this.mEEAbsentTime.getClass().getName());
        } else {
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    public boolean valuate(AbsentTime absentTime, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        AbsentTimeTP absentTimeTP = absentTime.getAbsentTimeTP(effectiveFrom, validFrom);
        return absentTimeTP.getValueType() != null || absentTimeTP.getCutOfSocialInsuranceDays() != CutOfSocialInsuranceDaysEnum.COSIDE_keine_Kuerzung || absentTimeTP.getCutOfTaxacationDays() != CutOfTaxacationDaysEnum.COTDE_keine_Kuerzung || absentTimeTP.getCalculationOfPartTimeWork() || absentTimeTP.getNumberOfU() != NumberOfUEnum.NOUE_keine_Beruecksichtigung;
    }

    public void checkVWECostCenters() throws BusinessDomainException {
        this.requireLoaded();
        this.mEEAbsentTime.checkVWECostCenter(this.mCostCenter, this.mEffectiveFrom, this.mValidFrom);
    }

    public void checkEL() throws BusinessDomainException {
        if (StringMapper.equal((String)this.mEEAbsentTime.getAbsentTime().getDEUVAbsentTimeKey(), (String)"4.7")) {
            Employee employee = this.mEEAbsentTime.getEmployee();
            Date startOfHistory = employee.getStartOfHistory();
            Date possibleBeginEL = employee.getMaximumDateOfEntry();
            if (DateHelper.before((Date)possibleBeginEL, (Date)startOfHistory)) {
                possibleBeginEL = startOfHistory;
            }
            if (!DateHelper.equal((Date)this.mValidFrom, (Date)possibleBeginEL)) {
                throw EmployeeExceptionMapper.makeBeginMustDateofEntryDomainException();
            }
        }
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append(((Object)((Object)this)).getClass().getSimpleName());
        builder.append('[').append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.getValidFrom()));
        builder.append('-').append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.getValidUntil()));
        builder.append(",").append(this.getEEAbsentTime().getAbsentTime().getAbsentTimeKey());
        builder.append(',').append(this.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey());
        builder.append(']');
        return builder.toString();
    }

    public void checkKK() throws BusinessDomainException {
        if (!StringMapper.equal((String)this.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"8.1")) {
            return;
        }
        if (!this.isNew()) {
            return;
        }
        GeneralEmploymentOffice employmentOffice = this.getEEAbsentTime().getEmployee().getAppurtenantEmploymentOfficeForKug(VDate.getDateMax(), VDate.getDateMax());
        if (employmentOffice == null || employmentOffice.getBeginKugBezug() == null || employmentOffice.getEndKugBezug() == null) {
            throw EmployeeExceptionMapper.makeWrongPeriodForAbsenttime81DomainException();
        }
        if (DateHelper.beforeOrEqual((Date)this.getValidFrom(), (Date)employmentOffice.getBeginKugBezug()) || DateHelper.afterOrEqual((Date)this.getValidUntil(), (Date)employmentOffice.getEndKugBezug())) {
            throw EmployeeExceptionMapper.makeWrongPeriodForAbsenttime81DomainException();
        }
    }
}

