/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee;

import com.infor.igf.core.scheduler.JobInformation;
import com.infor.igf.core.scheduler.PreferredScheduler;
import com.infor.igf.core.scheduler.SchedulerService;
import com.infor.igf.core.util.CloneUtils;
import com.infor.igf.core.util.crypt.PasswordHelper;
import com.infor.igf.py.selfservice.SelfServiceHelper;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.base.types.time.TimeHelper;
import com.varial.base.types.time.TimestampHelper;
import com.varial.personnel.domain.aag.account.AagAccountPersistencyManager;
import com.varial.personnel.domain.aag.dsra.IAagDsraPersistencyManager;
import com.varial.personnel.domain.absenttime.CutOfSocialInsuranceDaysEnum;
import com.varial.personnel.domain.aeins.account.IAEinsAccountPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFund;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTP;
import com.varial.personnel.domain.bea.account.BeaAccountPersistencyManager;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CalculationBasicPersistencyManager;
import com.varial.personnel.domain.calculation.CalculationPersistencyManager;
import com.varial.personnel.domain.calculation.EmployeeCalculatePersistencyManager;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.GeneralCommunity;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.wagefactor.WageFactor;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Validityable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValueInterval;
import com.varial.personnel.domain.deuv.dsvv.DEUVDsvvPersistencyManager;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.dskk.dskk.DeuvDskkPersistencyManager;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eel.eelaccount.IEelAccountPersistencyManager;
import com.varial.personnel.domain.elena.account.ElenaAccountPersistencyManager;
import com.varial.personnel.domain.elo2.account.Elo2AccountPersistencyManager;
import com.varial.personnel.domain.employee.EmployeeData;
import com.varial.personnel.domain.employee.EmployeeExtended;
import com.varial.personnel.domain.employee.EmployeeForCalculateStruct;
import com.varial.personnel.domain.employee.EmployeeHelper;
import com.varial.personnel.domain.employee.ForInitialiseOfInsuranceStruct;
import com.varial.personnel.domain.employee.IEmployee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.Journalize;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTime;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimePersistencyManager;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.accidentinsurancefund.EEAccidentInsuranceFund;
import com.varial.personnel.domain.employee.accidentinsurancefund.IEEAccidentInsuranceFundPersistencyManager;
import com.varial.personnel.domain.employee.accidentinsurancefund.SpecialUVReasonEnum;
import com.varial.personnel.domain.employee.advancepayment.AdvancePayment;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentPersistencyManager;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentTP;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentTPPersistencyManager;
import com.varial.personnel.domain.employee.analysiscode.EEAnalysisCode;
import com.varial.personnel.domain.employee.analysiscode.EEAnalysisCodeComparator;
import com.varial.personnel.domain.employee.analysiscode.EEAnalysisCodePersistencyManager;
import com.varial.personnel.domain.employee.analysiscode.EEPAnalysisCodeFilterStruct;
import com.varial.personnel.domain.employee.analysiscode.mapper.EEAnalysisCodeFilterStructMapper;
import com.varial.personnel.domain.employee.attachment.EEAttachment;
import com.varial.personnel.domain.employee.attachment.EEAttachmentPersistencyManager;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTPPersistencyManager;
import com.varial.personnel.domain.employee.bankdetails.EEBankDetails;
import com.varial.personnel.domain.employee.bankdetails.EEBankDetailsTP;
import com.varial.personnel.domain.employee.bankdetails.IEEBankDetailsPersistencyManager;
import com.varial.personnel.domain.employee.bankdetails.IEEBankDetailsTPPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntryPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.clauseofmarch.EECarriedForwardSystemCOM;
import com.varial.personnel.domain.employee.carriedforward.system.clauseofmarch.EECarriedForwardSystemCOMPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreak;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreakPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.sidistance.EECarriedForwardSIDistance;
import com.varial.personnel.domain.employee.carriedforward.system.sidistance.EECarriedForwardSIDistancePersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSIPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.varpayment.EECarriedForwardVarPayment;
import com.varial.personnel.domain.employee.carriedforward.varpayment.EECarriedForwardVarPaymentPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.zvk.EECarriedForwardZVK;
import com.varial.personnel.domain.employee.carriedforward.zvk.IEECarriedForwardZVKPersisitencyManager;
import com.varial.personnel.domain.employee.contacts.EmployeeContact;
import com.varial.personnel.domain.employee.contacts.EmployeeContactPersistencyManager;
import com.varial.personnel.domain.employee.datacredit.EEDataCredit;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditPersistencyManager;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTPPersistencyManager;
import com.varial.personnel.domain.employee.dataera.ChoiceOfERAPaymentEnum;
import com.varial.personnel.domain.employee.dataera.EEDataERA;
import com.varial.personnel.domain.employee.dataera.EEDataERAPersistencyManager;
import com.varial.personnel.domain.employee.disability.EEDisability;
import com.varial.personnel.domain.employee.disability.EEDisabilityPersistencyManager;
import com.varial.personnel.domain.employee.disability.EEDisabilityTP;
import com.varial.personnel.domain.employee.disability.EEDisabilityTPPersistencyManager;
import com.varial.personnel.domain.employee.education.Education;
import com.varial.personnel.domain.employee.education.EducationPersistencyManager;
import com.varial.personnel.domain.employee.eeskill.EESkill;
import com.varial.personnel.domain.employee.eeskill.IEESkillPersistencyManager;
import com.varial.personnel.domain.employee.eewagefactor.EEWageFactor;
import com.varial.personnel.domain.employee.eewagefactor.EEWageFactorTP;
import com.varial.personnel.domain.employee.eewagefactor.IEEWageFactorPersistencyManager;
import com.varial.personnel.domain.employee.elena.dismissal.Dismissal;
import com.varial.personnel.domain.employee.elena.dismissal.DismissalPersistencyManager;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.EmploymentComparator;
import com.varial.personnel.domain.employee.employment.IEmploymentPersistencyManager;
import com.varial.personnel.domain.employee.employment.TotalEmploymentRelationship;
import com.varial.personnel.domain.employee.fixedpayment.FixedPayment;
import com.varial.personnel.domain.employee.fixedpayment.FixedPaymentTP;
import com.varial.personnel.domain.employee.fixedpayment.IFixedPaymentPersistencyManager;
import com.varial.personnel.domain.employee.holidayyear.EEHolidayYear;
import com.varial.personnel.domain.employee.holidayyear.EEHolidayYearPersistencyManager;
import com.varial.personnel.domain.employee.holidayyear.EEHolidayYearTP;
import com.varial.personnel.domain.employee.holidayyear.EEHolidayYearTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.InsuranceCheckUp;
import com.varial.personnel.domain.employee.insurance.InsuranceComparator;
import com.varial.personnel.domain.employee.insurance.TypeAgePartTimeEnum;
import com.varial.personnel.domain.employee.insurancechild.IInsuranceChildPersistencyManager;
import com.varial.personnel.domain.employee.insurancechild.InsuranceChild;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYear;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearPersistencyManager;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTP;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTPPersistencyManager;
import com.varial.personnel.domain.employee.loan.EELoan;
import com.varial.personnel.domain.employee.loan.EELoanPersistencyManager;
import com.varial.personnel.domain.employee.loan.EELoanTP;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.master.IMasterPersistencyManager;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpenses;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesPersistencyManager;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesTP;
import com.varial.personnel.domain.employee.notes.EmployeeNote;
import com.varial.personnel.domain.employee.notes.EmployeeNotePersistencyManager;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeduction;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeductionPersistencyManager;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeductionTP;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedues.InsuranceDues;
import com.varial.personnel.domain.employee.paymentofcontributions.insurancedues.InsuranceDuesPersistencyManager;
import com.varial.personnel.domain.employee.paymentofcontributions.percentofassessment.PercentOfAssessmentPersistencyManager;
import com.varial.personnel.domain.employee.paymentofcontributions.percentofglobalsocialinsurance.PercentOfGlobalSocialInsurancePersistencyManager;
import com.varial.personnel.domain.employee.paymentofcontributions.percentofhealthfund.PercentOfHealthFundPersistencyManager;
import com.varial.personnel.domain.employee.paymentofcontributions.percentoftax.PercentOfTaxPersistencyManager;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionScheme;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemePersistencyManager;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.piecework.EEPieceWork;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkPersistencyManager;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTP;
import com.varial.personnel.domain.employee.relative.DegreeRelationShipEnum;
import com.varial.personnel.domain.employee.relative.EERelative;
import com.varial.personnel.domain.employee.relative.EERelativeDateOfBirthComparator;
import com.varial.personnel.domain.employee.relative.EERelativeTP;
import com.varial.personnel.domain.employee.relative.FlagCalculationEnum;
import com.varial.personnel.domain.employee.relative.IEERelativePersistencyManager;
import com.varial.personnel.domain.employee.scalepayment.ScalePayment;
import com.varial.personnel.domain.employee.scalepayment.ScalePaymentPersistencyManager;
import com.varial.personnel.domain.employee.scalepayment.ScalePaymentTP;
import com.varial.personnel.domain.employee.selfservice.ISelfServicePasswordPersistencyManager;
import com.varial.personnel.domain.employee.selfservice.SelfServicePassword;
import com.varial.personnel.domain.employee.successor.EESuccessor;
import com.varial.personnel.domain.employee.successor.IEESuccessorPersistencyManager;
import com.varial.personnel.domain.employee.tax.ITaxPersistencyManager;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.varpayment.VarPayment;
import com.varial.personnel.domain.employee.varpayment.VarPaymentPersistencyManager;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.domain.employee.vblu.EEVBLU;
import com.varial.personnel.domain.employee.vblu.EEVBLUPersistencyManager;
import com.varial.personnel.domain.employee.work.EEWork;
import com.varial.personnel.domain.employee.work.EEWorkPersistencyManager;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.employee.zvk.EEZVKPersistencyManager;
import com.varial.personnel.domain.eubp.dsan.EubpDsanPersistencyManager;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.eramodel.ERAModel;
import com.varial.personnel.domain.global.fstateregion.FStateRegion;
import com.varial.personnel.domain.global.fstateregion.FStateRegionPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.lstb.lstbaccount.ILStBAccountPersistencyManager;
import com.varial.personnel.domain.payscale.payscalegroup.PayScaleLevel;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.foundations.SpecificEnum;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.plant.settings.PlantSettings;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.domain.zahls.account.ZahlsAccountPersistencyManager;
import com.varial.personnel.domain.zve.account.ZveAccountPersistencyManager;
import com.varial.personnel.framework.ErrorMessage;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.audit.EmployeeAuditProtocolPersistencyManager;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.checkrun.WarningStateOfCheckEnum;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.personnel.isoft.LicenseCodesPayroll;
import com.varial.personnel.persistency.calculation.calculationall.CalculationallContainer;
import com.varial.personnel.persistency.employee.addattachment.IAddattachmentDao;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.exception.StoredException;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Employee
extends PersonnelPersistenceObject<PersonnelTimedPersistenceObject>
implements IEmployee {
    private static final int PRIORITY = 10;
    private PCompany mPCompany;
    private int mPersonnelnumber;
    private Date mJournalizedUntil;
    private boolean mInValuation;
    private boolean mWaitForValuation;
    private boolean mStateOfValuation;
    private Date mValuateEffectiveFrom;
    private Date mValuateValidFrom;
    private String mStateOfValMessage;
    private StoredException mException;
    private Date mDateOfBanRetroactiveCalculation;
    private boolean mMasterdatachecked;
    private boolean mSpecialAccess;
    private int mSpecialAccessLevel;
    private boolean mRetroactiveEntry;
    private Date mStartEffectiveFrom;
    private BigDecimal mLicenceCounter;
    private Date mLastCheck;
    private EmployeeContact[] mEmployeeContact;
    private EmployeeNote[] mEmployeeNote;
    private PersonnelHistory<Master> mMasterHistory;
    private PersonnelHistory<Tax> mTaxHistory;
    private PersonnelHistory<Insurance> mInsuranceHistory;
    private PersonnelHistory<InsuranceChild> mInsuranceChildHistory;
    private PersonnelHistory<Employment> mEmploymentHistory;
    private PersonnelHistory<EEWork> mEEWorkHistory;
    private PersonnelHistory<EEDataERA> mEEDataERAHistory;
    private PersonnelHistory<EEZVK> mZVKHistory;
    private PersonnelHistory<EEVBLU> mVBLUHistory;
    private PersonnelHistory<Education> mEducationHistory;
    private PersonnelHistory<Dismissal> mDismissalHistory;
    private PersonnelHistory<EEAnalysisCode> mEEAnalysisCodeHistory;
    private PersonnelHistory<EEAccidentInsuranceFund> mEEAccidentInsuranceFundHistory;
    private EEAbsentTime[] mEEAbsentTimes = new EEAbsentTime[0];
    private EEAttachment[] mEEAttachments = new EEAttachment[0];
    private EEBankDetails[] mEEBankDetails = new EEBankDetails[0];
    private EECarriedForwardOfEntry[] mEECarriedForwardOfEntrys = new EECarriedForwardOfEntry[0];
    private EECarriedForwardSystemCOM[] mEECarriedForwardSystemCOMs = new EECarriedForwardSystemCOM[0];
    private EECarriedForwardSystemSI[] mEECarriedForwardSystemSIs = new EECarriedForwardSystemSI[0];
    private EECarriedForwardSystemSIBreak[] mEECarriedForwardSystemSIBreaks = new EECarriedForwardSystemSIBreak[0];
    private EECarriedForwardVarPayment[] mEECarriedForwardVarPayments = new EECarriedForwardVarPayment[0];
    private EECarriedForwardSIDistance[] mEECarriedForwardSIDistances = new EECarriedForwardSIDistance[0];
    private EEDisability[] mEEDisabilities = new EEDisability[0];
    private EEHolidayYear[] mEEHolidayYears;
    private EELoan[] mEELoans = new EELoan[0];
    private EEPaymentDeduction[] mEEPaymentDeductions = new EEPaymentDeduction[0];
    private EEPensionScheme[] mEEPensionSchemes = new EEPensionScheme[0];
    private EEWageFactor[] mEEWageFactors = new EEWageFactor[0];
    private FixedPayment[] mFixedPayments = new FixedPayment[0];
    private VarPayment[] mVarPayments = new VarPayment[0];
    private ScalePayment[] mScalePayments = new ScalePayment[0];
    private EEDataCredit[] mEEDataCredits = new EEDataCredit[0];
    private EEPieceWork[] mEEPieceWorks = new EEPieceWork[0];
    private EEMaterialExpenses[] mEEMaterialExpenses = new EEMaterialExpenses[0];
    private EESkill[] mEESkills = new EESkill[0];
    private EERelative[] mEERelatives = new EERelative[0];
    private AdvancePayment[] mAdvancePayments = new AdvancePayment[0];
    private EECarriedForwardZVK[] mEECarriedForwardZVKs = new EECarriedForwardZVK[0];
    private InsuranceHIPIYear[] mInsuranceHIPIYears;
    private Date mDateOfEntry;
    private List<CalculationBasic> mCalculationBasics = new ArrayList<CalculationBasic>();
    private Date mCalculationBasicsMinValidFrom;
    private final List<ErrorMessage> mErrorMessages = new ArrayList<ErrorMessage>();
    private static IValuepositionDao daoValueposition = (IValuepositionDao)Employee.getDao("valuepositionDao");

    private static Object getDao(String daoName) {
        return UtilitiesManager.getApplicationContext().getBean(daoName);
    }

    protected Employee() {
        super(10);
    }

    protected Employee(String objectid) {
        super(10, objectid);
    }

    protected Employee(String objectid, int version) {
        super(10, objectid, version);
    }

    protected Employee(boolean readOnly) {
        super(10, readOnly);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mPCompany.getDomainKey()).append(" / ").append(this.mPersonnelnumber).toString();
    }

    public String getIDString() {
        return new StringBuffer().append(this.getPCompany().getPCompanyKey()).append("/").append(this.getPersonnelnumber()).toString();
    }

    protected void load() {
        this.getIEmployeePM().load(this);
    }

    protected void saveImpl() {
        this.getIEmployeePM().save(this);
    }

    protected void deleteImpl() {
        this.getIEmployeePM().delete(this);
    }

    public boolean deletePossible() throws BusinessDomainException {
        return !DateHelper.afterOrEqual((Date)this.getJournalizedUntil(), (Date)this.getStartOfHistory());
    }

    public boolean existsAccounts() throws BusinessDomainException {
        Criterion filter = Restrictions.eq((String)"oidemployee", (String)this.getObjectid());
        if (InsuranceDuesPersistencyManager.getRowCount((Criterion)filter) != 0L) {
            return true;
        }
        if (DEUVAccountPersistencyManager.getRowCount((Criterion)filter) != 0L) {
            return true;
        }
        return Elo2AccountPersistencyManager.getRowCount((Criterion)filter) != 0L;
    }

    public void deleteEmployee() throws BusinessDomainException {
        if (!DateHelper.before((Date)this.getJournalizedUntil(), (Date)this.getStartOfHistory())) {
            throw EmployeeExceptionMapper.makeUndeletableEEDomainException();
        }
        this.deleteFinaly();
    }

    public void deleteFinaly() throws BusinessDomainException {
        if (LicenseCodesPayroll.SELFSERVICE.isLicensed() && !StringMapper.isNullString((String)this.getActiveMaster().getServiceEmailAddress())) {
            this.deleteSelfservicePassword();
            SelfServiceHelper.deleteSelfServiceDocuments((Employee)this);
        }
        AagAccountPersistencyManager.delete((String)this.getObjectid());
        Employee.getIAagDsraPM().delete(this.getObjectid());
        try {
            ((IAddattachmentDao)UtilitiesManager.getApplicationContext().getBean("addattachmentDao")).delete(SessionContext.getInstance().getSession().getUserCode(), Restrictions.eq((String)"oidemployee", (String)this.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        Employee.getIAEinsAccountPM().delete(this.getObjectid());
        DEUVAccountPersistencyManager.delete((String)this.getObjectid());
        DEUVDsvvPersistencyManager.delete((String)this.getObjectid());
        DeuvDskkPersistencyManager.delete((String)this.getObjectid());
        Employee.getIEauAccountPM().delete(this.getObjectid());
        Employee.getIEelAccountPM().delete(this.getObjectid());
        EEAbsentTimeTPPersistencyManager.delete((String)this.getObjectid());
        EEAbsentTimePersistencyManager.delete((String)this.getObjectid());
        Elo2AccountPersistencyManager.delete((String)this.getObjectid());
        PercentOfHealthFundPersistencyManager.delete((String)this.getObjectid());
        PercentOfAssessmentPersistencyManager.delete((String)this.getObjectid());
        PercentOfGlobalSocialInsurancePersistencyManager.delete((String)this.getObjectid());
        PercentOfTaxPersistencyManager.delete((String)this.getObjectid());
        InsuranceDuesPersistencyManager.delete((String)this.getObjectid());
        Employee.getILStBAccountPM().delete(this.getObjectid());
        ZahlsAccountPersistencyManager.delete((String)this.getObjectid());
        ZveAccountPersistencyManager.delete((String)this.getObjectid());
        ElenaAccountPersistencyManager.delete((String)this.getObjectid());
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"companykey", (String)this.getPCompany().getPCompanyKey()), Restrictions.eq((String)"personnelnumber", (String)String.valueOf(this.getPersonnelnumber()))});
        EmployeeAuditProtocolPersistencyManager pm = (EmployeeAuditProtocolPersistencyManager)UtilitiesManager.getBean((String)"employeeAuditProtocolPersistencyManager", EmployeeAuditProtocolPersistencyManager.class);
        pm.deleteByEmployeeFilter((Criterion)filter);
        this.deletePredecessor();
        this.deleteSuccessor();
        EubpDsanPersistencyManager.getInstance().delete(this.getObjectid());
        Employee.getBeaAccountPM().delete(this.getObjectid());
        SessionContext.getInstance().getPersistencySession().flush();
        this.getIEmployeePM().delete(this);
    }

    public void deleteSelfServiceReference() throws BusinessDomainException {
        Master[] masters;
        for (Master each : masters = this.deleteSelfservicePassword()) {
            each.setServicePassword("");
            each.setServiceEmailAddress("");
            each.makeSaveable();
        }
    }

    public Master[] deleteSelfservicePassword() {
        ISelfServicePasswordPersistencyManager pm;
        SelfServicePassword password;
        Master[] masters = this.getIMasterPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.isNotNull((String)"servicemailaddress")}), true);
        if (masters.length > 0 && (password = (pm = (ISelfServicePasswordPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("selfServicePasswordPersistencyManager", ISelfServicePasswordPersistencyManager.class)).getByObjectid(Long.valueOf(this.getObjectid()).longValue())) != null) {
            pm.delete(password);
        }
        return masters;
    }

    public void deleteSuccessor() {
        this.getIEESuccessorPM().delete(Restrictions.eq((String)"OIDSUCCESSOR", (String)this.getObjectid()));
    }

    public void deletePredecessor() {
        this.getIEESuccessorPM().delete(Restrictions.eq((String)"OIDEMPLOYEE", (String)this.getObjectid()));
    }

    protected void setData(EmployeeData data) {
        this.mPCompany = data.getPCompany();
        this.mPersonnelnumber = data.getPersonnelnumber();
        this.mJournalizedUntil = data.getJournalizedUntil();
        this.mInValuation = data.getInValuation();
        this.mWaitForValuation = data.getWaitForValuation();
        this.mStateOfValuation = data.getStateOfValuation();
        this.mValuateEffectiveFrom = data.getValuateEffectiveFrom();
        this.mValuateValidFrom = data.getValuateValidFrom();
        this.mStateOfValMessage = data.getStateOfValMessage();
        this.mException = data.getException();
        this.mDateOfBanRetroactiveCalculation = data.getdateOfBanRetroactiveCalculation();
        this.mMasterdatachecked = data.getMasterdatachecked();
        this.mSpecialAccess = data.getSpecialAccess();
        this.mRetroactiveEntry = data.getRetroactiveEntry();
        this.mStartEffectiveFrom = data.getStartEffectiveFrom();
        this.mSpecialAccessLevel = data.getSpecialAccessLevel();
        this.mLicenceCounter = data.getLicenceCounter();
        this.mLastCheck = data.getLastCheck();
    }

    public void fillShort(String objectid, Date objectts, String lastuserid, PCompany pcompany, int personnelnumber, Date journalizedUntil) {
        this.setObjectid(objectid);
        this.setTimestamp(objectts);
        this.setLastuser(lastuserid);
        this.mPCompany = pcompany;
        this.mPersonnelnumber = personnelnumber;
        this.mJournalizedUntil = journalizedUntil;
    }

    public PersonnelHistory<PersonnelTimedPersistenceObject> getHistory() {
        throw new UnsupportedOperationException("Employee contains multiply histories, use getXxxHistory (Master, Employment, Insurance, ...) instead.");
    }

    public PCompany getPCompany() {
        this.requireLoaded();
        return this.mPCompany;
    }

    public void setPCompany(PCompany pCompany) {
        this.mPCompany = pCompany;
    }

    public int getPersonnelnumber() {
        this.requireLoaded();
        return this.mPersonnelnumber;
    }

    public void setPersonnelnumber(int personnelnumber) {
        this.mPersonnelnumber = personnelnumber;
    }

    public Date getJournalizedUntil() {
        this.requireLoaded();
        return this.mJournalizedUntil;
    }

    public void setJournalizedUntil(Date journalizedUntil) {
        this.mJournalizedUntil = journalizedUntil;
    }

    public boolean getInValuation() {
        this.requireLoaded();
        return this.mInValuation;
    }

    public void setInValuation(boolean inValuation) {
        this.mInValuation = inValuation;
    }

    public boolean getWaitForValuation() {
        this.requireLoaded();
        return this.mWaitForValuation;
    }

    public void setWaitForValuation(boolean waitForValuation) {
        this.mWaitForValuation = waitForValuation;
    }

    public boolean getStateOfValuation() {
        this.requireLoaded();
        return this.mStateOfValuation;
    }

    public void setStateOfValuation(boolean stateOfValuation) {
        this.mStateOfValuation = stateOfValuation;
    }

    public Date getValuateEffectiveFrom() {
        this.requireLoaded();
        return this.mValuateEffectiveFrom;
    }

    public void setValuateEffectiveFrom(Date valuateEffectiveFrom) {
        this.mValuateEffectiveFrom = valuateEffectiveFrom;
    }

    public Date getValuateValidFrom() {
        this.requireLoaded();
        return this.mValuateValidFrom;
    }

    public void setValuateValidFrom(Date valuateValidFrom) {
        this.mValuateValidFrom = valuateValidFrom;
    }

    public String getStateOfValMessage() {
        this.requireLoaded();
        return this.mStateOfValMessage;
    }

    public void setStateOfValMessage(String stateOfValMessage) {
        this.mStateOfValMessage = stateOfValMessage;
    }

    public StoredException getException() {
        this.requireLoaded();
        return this.mException;
    }

    public void setException(StoredException exception) throws BusinessDomainException {
        if (this.mException != null && !this.mException.equals((Object)exception)) {
            this.mException.makeSaveable();
            this.mException.destroy();
        }
        this.mException = exception;
    }

    public Date getDateOfBanRetroactiveCalculation() {
        this.requireLoaded();
        return this.mDateOfBanRetroactiveCalculation;
    }

    public void setDateOfBanRetroactiveCalculation(Date dateOfBanRetroactiveCalculation) {
        this.mDateOfBanRetroactiveCalculation = dateOfBanRetroactiveCalculation;
    }

    private Date getDateOfEntry() {
        return this.mDateOfEntry;
    }

    public void setDateOfEntry(Date dateOfEntry) {
        this.mDateOfEntry = dateOfEntry;
    }

    public boolean getMasterdatachecked() {
        this.requireLoaded();
        return this.mMasterdatachecked;
    }

    public void setMasterdatachecked(boolean masterdatachecked) {
        this.mMasterdatachecked = masterdatachecked;
    }

    public boolean getSpecialAccess() {
        this.requireLoaded();
        return this.mSpecialAccess;
    }

    public void setSpecialAccess(boolean specialAccess) {
        this.mSpecialAccess = specialAccess;
    }

    public int getSpecialAccessLevel() {
        this.requireLoaded();
        return this.mSpecialAccessLevel;
    }

    public void setSpecialAccessLevel(int specialAccessLevel) {
        this.mSpecialAccessLevel = specialAccessLevel;
    }

    public BigDecimal getLicenceCounter() {
        this.requireLoaded();
        return this.mLicenceCounter;
    }

    public void setLicenceCounter(BigDecimal licenceCounter) {
        this.mLicenceCounter = licenceCounter;
    }

    public Date getLastCheck() {
        this.requireLoaded();
        return this.mLastCheck;
    }

    public void setLastCheck(Date lastCheck) {
        this.mLastCheck = lastCheck;
    }

    public boolean getRetroactiveEntry() {
        this.requireLoaded();
        return this.mRetroactiveEntry;
    }

    public void setRetroactiveEntry(boolean retroactiveEntry) {
        this.mRetroactiveEntry = retroactiveEntry;
    }

    public Date getStartEffectiveFrom() {
        this.requireLoaded();
        return this.mStartEffectiveFrom;
    }

    public void setStartEffectiveFrom(Date startEffectiveFrom) {
        this.mStartEffectiveFrom = startEffectiveFrom;
    }

    public List<CalculationBasic> getCalculationBasics() {
        return this.mCalculationBasics;
    }

    public void initCalculationBasics() {
        this.mCalculationBasics = new ArrayList<CalculationBasic>();
    }

    public void setCalculationBasicsMinValidFrom(Date newMin) {
        this.mCalculationBasicsMinValidFrom = newMin;
    }

    public void addCalculationBasic(CalculationBasic calculationBasic) {
        if (this.mCalculationBasicsMinValidFrom != null && this.mCalculationBasics.size() > 1 && DateHelper.before((Date)calculationBasic.getValidFrom(), (Date)this.mCalculationBasicsMinValidFrom)) {
            calculationBasic.makeReadOnly();
            return;
        }
        for (CalculationBasic cb : this.mCalculationBasics) {
            if (!DateHelper.equal((Date)cb.getEffectiveFrom(), (Date)calculationBasic.getEffectiveFrom()) || !DateHelper.equal((Date)cb.getValidFrom(), (Date)calculationBasic.getValidFrom())) continue;
            calculationBasic.makeReadOnly();
            return;
        }
        this.mCalculationBasics.add(calculationBasic);
        if (this.mCalculationBasics.size() == 1) {
            this.mCalculationBasicsMinValidFrom = this.mCalculationBasics.get(0).getValidFrom();
        }
    }

    public Master getActiveMaster() throws BusinessDomainException {
        Date maxDate = VDate.getDateMax();
        Master[] master = this.getIMasterPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)maxDate)), Restrictions.eq((String)"validuntil", (String)DateMapper.toString((Date)maxDate))}), true);
        if (master.length == 0) {
            throw FrameWorkExceptionMapper.makeNoHistoryFoundForDate((String)this.getObjectid(), (Date)maxDate, (Date)maxDate);
        }
        return master[0];
    }

    public Master[] getActiveEffectiveMasterHistory() {
        List items = this.getMasterHistory().getItems(VDate.getDateMax());
        return items.toArray(new Master[items.size()]);
    }

    public Master[] getEffectiveMasterHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getMasterHistory(effectivTimePoint);
    }

    public Master[] getMasterHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Master[0];
        }
        return this.listToMasterArray(this.getMasterHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<Master> getMasterHistory() {
        this.requireLoaded();
        if (this.mMasterHistory == null) {
            this.mMasterHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEMasterHistory());
        }
        return this.mMasterHistory;
    }

    public Master[] getEEMasterHistory() {
        if (this.isNew()) {
            return new Master[0];
        }
        return this.getIMasterPM().getMasterHistory(this);
    }

    public Master getMaster(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (Master)this.getMasterHistory().getItem(effectiveFrom, validFrom);
    }

    public void addMasterHistory(Master master, boolean removeNew) throws BusinessDomainException {
        master.checkAttributes();
        Master[] changedArray = this.listToMasterArray(this.getMasterHistory().addItem((PersonnelTimedPersistenceObject)master, removeNew));
        if (changedArray.length == 1) {
            master.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Master element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setMasterHistory(Master master, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        Master[] changedArray;
        master.checkAttributes();
        if (DateHelper.equal((Date)master.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToMasterArray(this.getMasterHistory().setItem((PersonnelTimedPersistenceObject)master, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToMasterArray(this.getMasterHistory().addItem((PersonnelTimedPersistenceObject)master, removeNew));
        }
        for (Master element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private Master[] listToMasterArray(List<Master> list) {
        Master[] masterData = new Master[list.size()];
        return list.toArray(masterData);
    }

    public Master[] getMasterTimePeriods(Master ptpo) {
        return (Master[])this.getMasterHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public Tax getActiveTax() {
        Tax[] tax = this.getITaxPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), true);
        if (tax.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return tax[0];
    }

    public Tax[] getActiveEffectiveTaxHistory() {
        List items = this.getTaxHistory().getItems(VDate.getDateMax());
        return items.toArray(new Tax[items.size()]);
    }

    public Tax[] getEffectiveTaxHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getTaxHistory(effectivTimePoint);
    }

    public Tax[] getTaxHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Tax[0];
        }
        return this.listToTaxArray(this.getTaxHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<Tax> getTaxHistory() {
        this.requireLoaded();
        if (this.mTaxHistory == null) {
            this.mTaxHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEETaxHistory());
        }
        return this.mTaxHistory;
    }

    public Tax[] getEETaxHistory() {
        if (this.isNew()) {
            return new Tax[0];
        }
        return this.getITaxPM().getTaxHistory(this);
    }

    public Tax getTax(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (Tax)this.getTaxHistory().getItem(effectiveFrom, validFrom);
    }

    public Tax getTaxOrNull(Date effectiveFrom, Date validFrom) {
        this.requireLoaded();
        return (Tax)this.getTaxHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public void addTaxHistory(Tax tax, boolean removeNew) throws BusinessDomainException {
        tax.checkAttributes();
        this.addTaxHistoryInternal(tax, removeNew);
    }

    public void addTaxHistoryInternal(Tax tax, boolean removeNew) throws BusinessDomainException {
        Tax[] changedArray = this.listToTaxArray(this.getTaxHistory().addItem((PersonnelTimedPersistenceObject)tax, removeNew));
        if (changedArray.length == 1) {
            tax.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Tax element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setTaxHistory(Tax tax, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        tax.checkAttributes();
        this.setTaxHistoryInternal(tax, removeNew, oldEffectiveFrom);
    }

    public void setTaxHistoryInternal(Tax tax, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        Tax[] changedArray;
        if (DateHelper.equal((Date)tax.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToTaxArray(this.getTaxHistory().setItem((PersonnelTimedPersistenceObject)tax, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToTaxArray(this.getTaxHistory().addItem((PersonnelTimedPersistenceObject)tax, removeNew));
        }
        for (Tax element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private Tax[] listToTaxArray(List<Tax> list) {
        Tax[] TaxData = new Tax[list.size()];
        return list.toArray(TaxData);
    }

    public Tax[] getTaxTimePeriods(Tax ptpo) {
        return (Tax[])this.getTaxHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public Insurance getActiveInsurance() {
        Insurance[] ins = this.getIInsurancePM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), true);
        if (ins.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return ins[0];
    }

    public Insurance[] getActiveEffectiveInsuranceHistory() {
        List items = this.getInsuranceHistory().getItems(VDate.getDateMax());
        return items.toArray(new Insurance[items.size()]);
    }

    public Insurance[] getEffectiveInsuranceHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getInsuranceHistory(effectivTimePoint);
    }

    public Insurance[] getInsuranceHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Insurance[0];
        }
        return this.listToInsuranceArray(this.getInsuranceHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<Insurance> getInsuranceHistory() {
        this.requireLoaded();
        if (this.mInsuranceHistory == null) {
            this.mInsuranceHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEInsuranceHistory());
        }
        return this.mInsuranceHistory;
    }

    public Insurance[] getEEInsuranceHistory() {
        if (this.isNew()) {
            return new Insurance[0];
        }
        return this.getIInsurancePM().getInsuranceHistory(this);
    }

    public Insurance getInsurance(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (Insurance)this.getInsuranceHistory().getItem(effectiveFrom, validFrom);
    }

    public void addInsuranceHistory(Insurance insurance, boolean removeNew) throws BusinessDomainException {
        insurance.checkAttributes();
        Insurance[] changedArray = this.listToInsuranceArray(this.getInsuranceHistory().addItem((PersonnelTimedPersistenceObject)insurance, removeNew));
        if (changedArray.length == 1) {
            insurance.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Insurance element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void addInsuranceHistoryInternal(Insurance insurance, boolean removeNew) throws BusinessDomainException {
        insurance.checkDates();
        Insurance[] changedArray = this.listToInsuranceArray(this.getInsuranceHistory().addItem((PersonnelTimedPersistenceObject)insurance, removeNew));
        if (changedArray.length == 1) {
            insurance.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Insurance element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setInsuranceHistory(Insurance insurance, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        this.setInsuranceHistory(insurance, removeNew, oldEffectiveFrom, true);
    }

    public void setInsuranceHistory(Insurance insurance, boolean removeNew, Date oldEffectiveFrom, boolean checkedAttributes) throws BusinessDomainException {
        Insurance[] changedArray;
        if (checkedAttributes) {
            insurance.checkAttributes();
        }
        if (DateHelper.equal((Date)insurance.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToInsuranceArray(this.getInsuranceHistory().setItem((PersonnelTimedPersistenceObject)insurance, removeNew));
        } else {
            removeNew = true;
            insurance.makeReadOnly();
            changedArray = this.listToInsuranceArray(this.getInsuranceHistory().addItem((PersonnelTimedPersistenceObject)insurance, removeNew));
        }
        for (Insurance element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setInsuranceHistoryInternal(Insurance insurance, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        Insurance[] changedArray;
        insurance.checkDates();
        if (DateHelper.equal((Date)insurance.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToInsuranceArray(this.getInsuranceHistory().setItem((PersonnelTimedPersistenceObject)insurance, removeNew));
        } else {
            removeNew = true;
            insurance.makeReadOnly();
            changedArray = this.listToInsuranceArray(this.getInsuranceHistory().addItem((PersonnelTimedPersistenceObject)insurance, removeNew));
        }
        for (Insurance element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private Insurance[] listToInsuranceArray(List<Insurance> list) {
        Insurance[] insurancedata = new Insurance[list.size()];
        return list.toArray(insurancedata);
    }

    public Insurance[] getInsuranceTimePeriods(Insurance ptpo) {
        return (Insurance[])this.getInsuranceHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public InsuranceChild[] getActiveEffectiveInsuranceChildHistory() {
        List items = this.getInsuranceChildHistory().getItems(VDate.getDateMax());
        return items.toArray(new InsuranceChild[items.size()]);
    }

    public InsuranceChild getActiveInsuranceChild() {
        InsuranceChild[] bos = this.getIInsuranceChildPM().query(new Order[0], (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), true);
        if (bos.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return bos[0];
    }

    public InsuranceChild[] getEffectiveInsuranceChildHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getInsuranceChildHistory(effectivTimePoint);
    }

    public InsuranceChild[] getInsuranceChildHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new InsuranceChild[0];
        }
        return this.listToInsuranceChildArray(this.getInsuranceChildHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<InsuranceChild> getInsuranceChildHistory() {
        this.requireLoaded();
        if (this.mInsuranceChildHistory == null) {
            this.mInsuranceChildHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEInsuranceChildHistory());
        }
        return this.mInsuranceChildHistory;
    }

    public InsuranceChild[] getEEInsuranceChildHistory() {
        if (this.isNew()) {
            return new InsuranceChild[0];
        }
        return this.getIInsuranceChildPM().getInsuranceChildHistory(this);
    }

    public InsuranceChild getInsuranceChild(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (InsuranceChild)this.getInsuranceChildHistory().getItem(effectiveFrom, validFrom);
    }

    public void addInsuranceChildHistory(InsuranceChild bo, boolean removeNew) throws BusinessDomainException {
        bo.checkAttributes();
        InsuranceChild[] changedArray = this.listToInsuranceChildArray(this.getInsuranceChildHistory().addItem((PersonnelTimedPersistenceObject)bo, removeNew));
        if (changedArray.length == 1) {
            bo.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (InsuranceChild element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setInsuranceChildHistory(InsuranceChild bo, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        InsuranceChild[] changedArray;
        bo.checkAttributes();
        if (DateHelper.equal((Date)bo.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToInsuranceChildArray(this.getInsuranceChildHistory().setItem((PersonnelTimedPersistenceObject)bo, removeNew));
        } else {
            removeNew = true;
            bo.makeReadOnly();
            changedArray = this.listToInsuranceChildArray(this.getInsuranceChildHistory().addItem((PersonnelTimedPersistenceObject)bo, removeNew));
        }
        for (InsuranceChild element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private InsuranceChild[] listToInsuranceChildArray(List<InsuranceChild> list) {
        InsuranceChild[] eeVBLUData = new InsuranceChild[list.size()];
        return list.toArray(eeVBLUData);
    }

    public InsuranceChild getInsuranceChildOrNull(Date effectiveFrom, Date validFrom) {
        this.requireLoaded();
        return (InsuranceChild)this.getInsuranceChildHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public Employment getActiveEmployment() throws BusinessDomainException {
        Date maxDate = VDate.getDateMax();
        Employment[] et = this.getEmploymentPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)maxDate)), Restrictions.eq((String)"validuntil", (String)DateMapper.toString((Date)maxDate))}), true);
        if (et.length == 0) {
            throw FrameWorkExceptionMapper.makeNoHistoryFoundForDate((String)this.getObjectid(), (Date)maxDate, (Date)maxDate);
        }
        return et[0];
    }

    public Employment[] getActiveEffectiveEmploymentHistory() {
        return this.getEmploymentHistory(VDate.getDateMax());
    }

    public Employment[] getEffectiveEmploymentHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEmploymentHistory(effectivTimePoint);
    }

    public Employment[] getEmploymentHistory(Date effectiveTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Employment[0];
        }
        return this.listToEmploymentArray(this.getEmploymentHistory().getItems(effectiveTimePoint));
    }

    public Employment[] getEmploymentHistory(Date effectiveTimePoint, Date validFrom, Date validUntil) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Employment[0];
        }
        List ptpoList = this.getEmploymentHistory().getPeriods(effectiveTimePoint, validFrom, validUntil);
        return ptpoList.toArray(new Employment[ptpoList.size()]);
    }

    public PersonnelHistory<Employment> getEmploymentHistory() {
        this.requireLoaded();
        if (this.mEmploymentHistory == null) {
            this.mEmploymentHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEEmploymentHistory());
        }
        return this.mEmploymentHistory;
    }

    public Employment[] getEEEmploymentHistory() {
        if (this.isNew()) {
            return new Employment[0];
        }
        return this.getEmploymentPM().getEmploymentHistory(this);
    }

    public Employment getEmployment(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (Employment)this.getEmploymentHistory().getItem(effectiveFrom, validFrom);
    }

    public void addEmploymentHistory(Employment et, boolean removeNew) throws BusinessDomainException {
        et.checkAttributes();
        Employment[] changedArray = this.listToEmploymentArray(this.getEmploymentHistory().addItem((PersonnelTimedPersistenceObject)et, removeNew));
        if (changedArray.length == 1) {
            et.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Employment element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setEmploymentHistory(Employment et, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        et.checkAttributes();
        Employment[] changedArray = DateHelper.equal((Date)et.getEffectiveFrom(), (Date)oldEffectiveFrom) ? this.listToEmploymentArray(this.getEmploymentHistory().setItem((PersonnelTimedPersistenceObject)et, removeNew)) : this.listToEmploymentArray(this.getEmploymentHistory().addItem((PersonnelTimedPersistenceObject)et, removeNew));
        for (Employment element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private Employment[] listToEmploymentArray(List<Employment> list) {
        Employment[] etData = new Employment[list.size()];
        return list.toArray(etData);
    }

    public Employment[] getEmploymentTimePeriods(Employment ptpo) {
        return (Employment[])this.getEmploymentHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public EEWork getActiveEEWork() {
        EEWork[] eeWork = EEWorkPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (eeWork.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return eeWork[0];
    }

    public EEWork[] getActiveEffectiveEEWorkHistory() {
        List items = this.getWorkHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEWork[items.size()]);
    }

    public EEWork[] getEffectiveEEWorkHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEEWorkHistory(effectivTimePoint);
    }

    public EEWork[] getEEWorkHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEWork[0];
        }
        return this.listToEEWorkArray(this.getWorkHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<EEWork> getWorkHistory() {
        this.requireLoaded();
        if (this.mEEWorkHistory == null) {
            this.mEEWorkHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEWorkHistory());
        }
        return this.mEEWorkHistory;
    }

    public EEWork[] getEEWorkHistory() {
        if (this.isNew()) {
            return new EEWork[0];
        }
        return EEWorkPersistencyManager.getEEWorkHistory((Employee)this);
    }

    public EEWork getEEWork(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return (EEWork)this.getWorkHistory().getItem(effectiveFrom, validFrom);
    }

    public EEWork getEEWorkOrNull(Date effectiveFrom, Date validFrom) {
        return (EEWork)this.getWorkHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public EEWork getLastEffectiveEEWork(Date validFrom) throws BusinessDomainException {
        return (EEWork)this.getWorkHistory().getItem(VDate.getDateMax(), validFrom);
    }

    public void addEEWorkHistory(EEWork eeWork, boolean removeNew) throws BusinessDomainException {
        eeWork.checkAttributes();
        EEWork[] changedArray = this.listToEEWorkArray(this.getWorkHistory().addItem((PersonnelTimedPersistenceObject)eeWork, removeNew));
        if (changedArray.length == 1) {
            eeWork.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (EEWork element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setEEWorkHistory(EEWork eeWork, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEWork[] changedArray;
        eeWork.checkAttributes();
        if (DateHelper.equal((Date)eeWork.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEEWorkArray(this.getWorkHistory().setItem((PersonnelTimedPersistenceObject)eeWork, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToEEWorkArray(this.getWorkHistory().addItem((PersonnelTimedPersistenceObject)eeWork, removeNew));
        }
        for (EEWork element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private EEWork[] listToEEWorkArray(List<EEWork> list) {
        EEWork[] eeWorkData = new EEWork[list.size()];
        return list.toArray(eeWorkData);
    }

    public EEWork[] getEEWorkTimePeriods(EEWork ptpo) {
        return (EEWork[])this.getWorkHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public EEWageFactor[] getEEWageFactors() {
        if (this.isNew()) {
            return new EEWageFactor[0];
        }
        if (this.mEEWageFactors.length == 0) {
            this.mEEWageFactors = this.getIEEWageFactorPM().getEEWageFactors(this);
        }
        return this.mEEWageFactors;
    }

    public EEWageFactorTP getEEWageFactorTP(WageFactor wageFactor, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        EEWageFactor[] eewf = this.getEEWageFactors();
        EEWageFactorTP eewftp = null;
        for (EEWageFactor element : eewf) {
            if (!StringMapper.equal((String)element.getWageFactor().getObjectid(), (String)wageFactor.getObjectid())) continue;
            eewftp = element.getEEWageFactorTP(effectiveFrom, validFrom);
        }
        return eewftp;
    }

    public FixedPayment[] getFixedPayments() {
        if (this.isNew()) {
            return new FixedPayment[0];
        }
        if (this.mFixedPayments.length == 0) {
            this.mFixedPayments = this.getIFixedPaymentPM().getFixedPayments(this);
        }
        return this.mFixedPayments;
    }

    public EEHolidayYear[] getEEHolidayYears() {
        if (this.isNew()) {
            return new EEHolidayYear[0];
        }
        if (this.mEEHolidayYears == null) {
            this.mEEHolidayYears = EEHolidayYearPersistencyManager.getEEHolidayYears((Employee)this);
        }
        return this.mEEHolidayYears;
    }

    public EEHolidayYearTP[] getEEHolidayYearsTP(Order[] sort, Criterion filters, boolean readOnly) {
        if (this.isNew()) {
            return new EEHolidayYearTP[0];
        }
        return EEHolidayYearTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)readOnly);
    }

    public EEAbsentTime[] getEEAbsentTimes() {
        if (this.isNew()) {
            return new EEAbsentTime[0];
        }
        if (this.mEEAbsentTimes.length == 0) {
            this.mEEAbsentTimes = EEAbsentTimePersistencyManager.getEEAbsentTimes((Employee)this);
        }
        return this.mEEAbsentTimes;
    }

    public EEAbsentTimeTP[] getEEAbsentTimesTP(Order[] sort, Criterion filters, boolean readOnly) {
        if (this.isNew()) {
            return new EEAbsentTimeTP[0];
        }
        return EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)readOnly);
    }

    public EEDisability[] getEEDisabilities() {
        if (this.isNew()) {
            return new EEDisability[0];
        }
        if (this.mEEDisabilities.length == 0) {
            this.mEEDisabilities = EEDisabilityPersistencyManager.getEEDisabilities((Employee)this);
        }
        return this.mEEDisabilities;
    }

    public EEDisabilityTP[] getEEDisabilitiesTP(Order[] sort, Criterion filters, boolean readOnly) {
        if (this.isNew()) {
            return new EEDisabilityTP[0];
        }
        return EEDisabilityTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)readOnly);
    }

    public EEAttachment[] getEEAttachments() {
        if (this.isNew()) {
            return new EEAttachment[0];
        }
        if (this.mEEAttachments.length == 0) {
            this.mEEAttachments = EEAttachmentPersistencyManager.getEEAttachments((Employee)this);
        }
        return this.mEEAttachments;
    }

    public EEAttachmentTP[] getEEAttachmentsTP(Order[] sort, Criterion filters, boolean readOnly) {
        if (this.isNew()) {
            return new EEAttachmentTP[0];
        }
        return EEAttachmentTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)readOnly);
    }

    public EEBankDetails[] getEEBankDetails() {
        if (this.isNew()) {
            return new EEBankDetails[0];
        }
        if (this.mEEBankDetails.length == 0) {
            this.mEEBankDetails = this.getIEEBankDetailsPM().getEEBankDetails(this);
        }
        return this.mEEBankDetails;
    }

    public EEBankDetailsTP[] getEEBankDetailsTPs(Date effectiveTimePoint, Date validTimePoint) {
        if (this.isNew()) {
            return new EEBankDetailsTP[0];
        }
        return this.getIEEBankDetailsTPPM().getEEBankDetailsTPs(this, effectiveTimePoint, validTimePoint);
    }

    public EELoan[] getEELoans() {
        if (this.isNew()) {
            return new EELoan[0];
        }
        if (this.mEELoans.length == 0) {
            this.mEELoans = EELoanPersistencyManager.getEELoans((Employee)this);
        }
        return this.mEELoans;
    }

    public EEPaymentDeduction[] getEEPaymentDeductions() {
        if (this.isNew()) {
            return new EEPaymentDeduction[0];
        }
        if (this.mEEPaymentDeductions.length == 0) {
            this.mEEPaymentDeductions = EEPaymentDeductionPersistencyManager.getEEPaymentDeductions((Employee)this);
        }
        return this.mEEPaymentDeductions;
    }

    public EEPensionScheme[] getEEPensionSchemes() {
        if (this.isNew()) {
            return new EEPensionScheme[0];
        }
        if (this.mEEPensionSchemes.length == 0) {
            this.mEEPensionSchemes = EEPensionSchemePersistencyManager.getEEPensionSchemes((Employee)this);
        }
        return this.mEEPensionSchemes;
    }

    public VarPayment[] getVarPayments() {
        if (this.isNew()) {
            return new VarPayment[0];
        }
        if (this.mVarPayments.length == 0) {
            this.mVarPayments = VarPaymentPersistencyManager.getVarPayments((Employee)this);
        }
        return this.mVarPayments;
    }

    public InsuranceHIPIYear[] getInsuranceHIPIYears() {
        if (this.isNew()) {
            return new InsuranceHIPIYear[0];
        }
        if (this.mInsuranceHIPIYears == null) {
            this.mInsuranceHIPIYears = InsuranceHIPIYearPersistencyManager.getInsuranceHIPIYears((Employee)this);
        }
        return this.mInsuranceHIPIYears;
    }

    public InsuranceHIPIYearTP[] getInsuranceHIPIYearsTP(Order[] sort, Criterion filters, boolean readOnly) {
        if (this.isNew()) {
            return new InsuranceHIPIYearTP[0];
        }
        return InsuranceHIPIYearTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)readOnly);
    }

    private EEWageFactorTP[] getEEWageFactorHistory() {
        EEWageFactor[] wfArray = this.getEEWageFactors();
        if (wfArray.length > 0) {
            ArrayList<EEWageFactorTP> list = new ArrayList<EEWageFactorTP>();
            for (EEWageFactor element : wfArray) {
                EEWageFactorTP[] wftpArray;
                for (EEWageFactorTP element2 : wftpArray = element.getEEWageFactorTPs()) {
                    list.add(element2);
                }
            }
            EEWageFactorTP[] array = new EEWageFactorTP[list.size()];
            return list.toArray(array);
        }
        return new EEWageFactorTP[0];
    }

    public EEWageFactorTP[] getEffectiveEEWageFactors(Date effectiveTimePoint, Date validTimePoint) {
        EEWageFactorTP[] wftpArray = this.getEEWageFactorHistory();
        if (wftpArray.length > 0) {
            ArrayList<EEWageFactorTP> list = new ArrayList<EEWageFactorTP>();
            for (EEWageFactorTP element : wftpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEWageFactorTP[] array = new EEWageFactorTP[list.size()];
            return list.toArray(array);
        }
        return new EEWageFactorTP[0];
    }

    private FixedPaymentTP[] getFixedPaymentHistory() {
        FixedPayment[] fpArray = this.getFixedPayments();
        if (fpArray.length > 0) {
            ArrayList<FixedPaymentTP> list = new ArrayList<FixedPaymentTP>();
            for (FixedPayment element : fpArray) {
                FixedPaymentTP[] fptpArray;
                for (FixedPaymentTP element2 : fptpArray = element.getFixedPaymentTPs()) {
                    list.add(element2);
                }
            }
            FixedPaymentTP[] array = new FixedPaymentTP[list.size()];
            return list.toArray(array);
        }
        return new FixedPaymentTP[0];
    }

    public FixedPaymentTP[] getEffectiveFixedPayments(Date effectiveTimePoint, Date validTimePoint) {
        FixedPaymentTP[] fptpArray = this.getFixedPaymentHistory();
        if (fptpArray.length > 0) {
            ArrayList<FixedPaymentTP> list = new ArrayList<FixedPaymentTP>();
            for (FixedPaymentTP element : fptpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            FixedPaymentTP[] array = new FixedPaymentTP[list.size()];
            return list.toArray(array);
        }
        return new FixedPaymentTP[0];
    }

    private EEPensionSchemeTP[] getPensionSchemeHistory() {
        EEPensionScheme[] psArray = this.getEEPensionSchemes();
        if (psArray.length > 0) {
            ArrayList<EEPensionSchemeTP> list = new ArrayList<EEPensionSchemeTP>();
            for (EEPensionScheme element : psArray) {
                EEPensionSchemeTP[] pstpArray;
                for (EEPensionSchemeTP element2 : pstpArray = element.getEEPensionSchemeTPs()) {
                    list.add(element2);
                }
            }
            EEPensionSchemeTP[] array = new EEPensionSchemeTP[list.size()];
            return list.toArray(array);
        }
        return new EEPensionSchemeTP[0];
    }

    public EEPensionSchemeTP[] getEffectivePensionSchemes(Date effectiveTimePoint, Date validTimePoint) {
        EEPensionSchemeTP[] pstpArray = this.getPensionSchemeHistory();
        if (pstpArray.length > 0) {
            ArrayList<EEPensionSchemeTP> list = new ArrayList<EEPensionSchemeTP>();
            for (EEPensionSchemeTP element : pstpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEPensionSchemeTP[] array = new EEPensionSchemeTP[list.size()];
            return list.toArray(array);
        }
        return new EEPensionSchemeTP[0];
    }

    private EEHolidayYearTP[] getEEHolidayYearHistory() {
        EEHolidayYear[] boArray = this.getEEHolidayYears();
        if (boArray.length > 0) {
            ArrayList<EEHolidayYearTP> list = new ArrayList<EEHolidayYearTP>();
            for (EEHolidayYear element : boArray) {
                EEHolidayYearTP[] tpArray;
                for (EEHolidayYearTP element2 : tpArray = element.getEEHolidayYearTPs()) {
                    list.add(element2);
                }
            }
            EEHolidayYearTP[] result = new EEHolidayYearTP[list.size()];
            return list.toArray(result);
        }
        return new EEHolidayYearTP[0];
    }

    public EERelativeTP[] getEffectiveEERelatives(Date effectiveTimePoint, Date validTimePoint) {
        EERelativeTP[] tpArray = this.getEERelativesHistory();
        if (tpArray.length > 0) {
            ArrayList<EERelativeTP> list = new ArrayList<EERelativeTP>();
            for (EERelativeTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EERelativeTP[] result = new EERelativeTP[list.size()];
            return list.toArray(result);
        }
        return new EERelativeTP[0];
    }

    public EEHolidayYearTP[] getEffectiveEEHolidayYears(Date effectiveTimePoint, Date validTimePoint) {
        EEHolidayYearTP[] tpArray = this.getEEHolidayYearHistory();
        if (tpArray.length > 0) {
            ArrayList<EEHolidayYearTP> list = new ArrayList<EEHolidayYearTP>();
            for (EEHolidayYearTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEHolidayYearTP[] result = new EEHolidayYearTP[list.size()];
            return list.toArray(result);
        }
        return new EEHolidayYearTP[0];
    }

    private EEAttachmentTP[] getEEAttachmentHistory() {
        EEAttachment[] boArray = this.getEEAttachments();
        if (boArray.length > 0) {
            ArrayList<EEAttachmentTP> list = new ArrayList<EEAttachmentTP>();
            for (EEAttachment element : boArray) {
                EEAttachmentTP[] tpArray;
                for (EEAttachmentTP element2 : tpArray = element.getEEAttachmentTPs()) {
                    list.add(element2);
                }
            }
            EEAttachmentTP[] array = new EEAttachmentTP[list.size()];
            return list.toArray(array);
        }
        return new EEAttachmentTP[0];
    }

    public EEAttachmentTP[] getEffectiveEEAttachments(Date effectiveTimePoint, Date validTimePoint) {
        EEAttachmentTP[] tpArray = this.getEEAttachmentHistory();
        if (tpArray.length > 0) {
            ArrayList<EEAttachmentTP> list = new ArrayList<EEAttachmentTP>();
            for (EEAttachmentTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEAttachmentTP[] array = new EEAttachmentTP[list.size()];
            return list.toArray(array);
        }
        return new EEAttachmentTP[0];
    }

    private EEAbsentTimeTP[] getEEAbsentTimeHistory() {
        EEAbsentTime[] boArray = this.getEEAbsentTimes();
        if (boArray.length > 0) {
            ArrayList<EEAbsentTimeTP> list = new ArrayList<EEAbsentTimeTP>();
            for (EEAbsentTime element : boArray) {
                EEAbsentTimeTP[] tpArray;
                for (EEAbsentTimeTP element2 : tpArray = element.getEEAbsentTimeTPs()) {
                    list.add(element2);
                }
            }
            EEAbsentTimeTP[] array = new EEAbsentTimeTP[list.size()];
            return list.toArray(array);
        }
        return new EEAbsentTimeTP[0];
    }

    public EEAbsentTimeTP[] getEffectiveEEAbsentTimes(Date effectiveTimePoint, Date validTimePoint) {
        EEAbsentTimeTP[] tpArray = this.getEEAbsentTimeHistory();
        if (tpArray.length > 0) {
            ArrayList<EEAbsentTimeTP> list = new ArrayList<EEAbsentTimeTP>();
            for (EEAbsentTimeTP absentTimeTP : tpArray) {
                if (absentTimeTP.getEEAbsentTime().getIsDeleted() || !DateHelper.afterOrEqual((Date)absentTimeTP.getEffectiveFrom(), (Date)effectiveTimePoint) && !absentTimeTP.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)absentTimeTP.getValidFrom(), (Date)validTimePoint) && !absentTimeTP.inValidness(validTimePoint)) continue;
                list.add(absentTimeTP);
            }
            EEAbsentTimeTP[] array = new EEAbsentTimeTP[list.size()];
            return list.toArray(array);
        }
        return new EEAbsentTimeTP[0];
    }

    private EEBankDetailsTP[] getEEBankDetailsHistory() {
        EEBankDetails[] boArray = this.getEEBankDetails();
        if (boArray.length > 0) {
            ArrayList<EEBankDetailsTP> list = new ArrayList<EEBankDetailsTP>();
            for (EEBankDetails element : boArray) {
                EEBankDetailsTP[] tpArray;
                for (EEBankDetailsTP element2 : tpArray = element.getEEBankDetailsTPs()) {
                    list.add(element2);
                }
            }
            EEBankDetailsTP[] array = new EEBankDetailsTP[list.size()];
            return list.toArray(array);
        }
        return new EEBankDetailsTP[0];
    }

    public EEBankDetailsTP[] getEffectiveEEBankDetails(Date effectiveTimePoint, Date validTimePoint) {
        EEBankDetailsTP[] tpArray = this.getEEBankDetailsHistory();
        if (tpArray.length > 0) {
            ArrayList<EEBankDetailsTP> list = new ArrayList<EEBankDetailsTP>();
            for (EEBankDetailsTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEBankDetailsTP[] array = new EEBankDetailsTP[list.size()];
            return list.toArray(array);
        }
        return new EEBankDetailsTP[0];
    }

    private EELoanTP[] getEELoanHistory() {
        EELoan[] boArray = this.getEELoans();
        if (boArray.length > 0) {
            ArrayList<EELoanTP> list = new ArrayList<EELoanTP>();
            for (EELoan element : boArray) {
                EELoanTP[] tpArray;
                for (EELoanTP element2 : tpArray = element.getEELoanTPs()) {
                    list.add(element2);
                }
            }
            EELoanTP[] array = new EELoanTP[list.size()];
            return list.toArray(array);
        }
        return new EELoanTP[0];
    }

    public EELoanTP[] getEffectiveEELoans(Date effectiveTimePoint, Date validTimePoint) {
        EELoanTP[] tpArray = this.getEELoanHistory();
        if (tpArray.length > 0) {
            ArrayList<EELoanTP> list = new ArrayList<EELoanTP>();
            for (EELoanTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EELoanTP[] array = new EELoanTP[list.size()];
            return list.toArray(array);
        }
        return new EELoanTP[0];
    }

    private EEPaymentDeductionTP[] getEEPaymentDeductionHistory() {
        EEPaymentDeduction[] boArray = this.getEEPaymentDeductions();
        if (boArray.length > 0) {
            ArrayList<EEPaymentDeductionTP> list = new ArrayList<EEPaymentDeductionTP>();
            for (EEPaymentDeduction element : boArray) {
                EEPaymentDeductionTP[] tpArray;
                for (EEPaymentDeductionTP element2 : tpArray = element.getEEPaymentDeductionTPs()) {
                    list.add(element2);
                }
            }
            EEPaymentDeductionTP[] array = new EEPaymentDeductionTP[list.size()];
            return list.toArray(array);
        }
        return new EEPaymentDeductionTP[0];
    }

    public EEPaymentDeductionTP[] getEffectiveEEPaymentDeductions(Date effectiveTimePoint, Date validTimePoint) {
        EEPaymentDeductionTP[] tpArray = this.getEEPaymentDeductionHistory();
        if (tpArray.length > 0) {
            ArrayList<EEPaymentDeductionTP> list = new ArrayList<EEPaymentDeductionTP>();
            for (EEPaymentDeductionTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEPaymentDeductionTP[] array = new EEPaymentDeductionTP[list.size()];
            return list.toArray(array);
        }
        return new EEPaymentDeductionTP[0];
    }

    private VarPaymentTP[] getVarPaymentHistory() {
        VarPayment[] fpArray = this.getVarPayments();
        if (fpArray.length > 0) {
            ArrayList<VarPaymentTP> list = new ArrayList<VarPaymentTP>();
            for (VarPayment element : fpArray) {
                VarPaymentTP[] fptpArray;
                for (VarPaymentTP element2 : fptpArray = element.getVarPaymentTPs()) {
                    list.add(element2);
                }
            }
            VarPaymentTP[] array = new VarPaymentTP[list.size()];
            return list.toArray(array);
        }
        return new VarPaymentTP[0];
    }

    public VarPaymentTP[] getEffectiveVarPayments(Date effectiveTimePoint, Date validTimePoint) {
        VarPaymentTP[] fptpArray = this.getVarPaymentHistory();
        if (fptpArray.length > 0) {
            ArrayList<VarPaymentTP> list = new ArrayList<VarPaymentTP>();
            for (VarPaymentTP element : fptpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            VarPaymentTP[] array = new VarPaymentTP[list.size()];
            return list.toArray(array);
        }
        return new VarPaymentTP[0];
    }

    public AdvancePaymentTP[] getEffectiveAdvancePayments(Date effectiveTimePoint, Date validTimePoint) {
        AdvancePaymentTP[] aptpArray = this.getAdvancePaymentHistory();
        if (aptpArray.length > 0) {
            ArrayList<AdvancePaymentTP> list = new ArrayList<AdvancePaymentTP>();
            for (AdvancePaymentTP aptp : aptpArray) {
                if (!DateHelper.afterOrEqual((Date)aptp.getEffectiveFrom(), (Date)effectiveTimePoint) && !aptp.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)aptp.getValidFrom(), (Date)validTimePoint) && !aptp.inValidness(validTimePoint)) continue;
                list.add(aptp);
            }
            AdvancePaymentTP[] array = new AdvancePaymentTP[list.size()];
            return list.toArray(array);
        }
        return new AdvancePaymentTP[0];
    }

    private AdvancePaymentTP[] getAdvancePaymentHistory() {
        AdvancePayment[] apArray = this.getAdvancePayments();
        if (apArray.length > 0) {
            ArrayList<AdvancePaymentTP> list = new ArrayList<AdvancePaymentTP>();
            for (AdvancePayment ap : apArray) {
                AdvancePaymentTP[] ptpoArray;
                for (AdvancePaymentTP ptpo : ptpoArray = ap.getAdvancePaymentTPs()) {
                    list.add(ptpo);
                }
            }
            AdvancePaymentTP[] array = new AdvancePaymentTP[list.size()];
            return list.toArray(array);
        }
        return new AdvancePaymentTP[0];
    }

    private InsuranceHIPIYearTP[] getInsuranceHIPIYearHistory() {
        InsuranceHIPIYear[] boArray = this.getInsuranceHIPIYears();
        if (boArray.length > 0) {
            ArrayList<InsuranceHIPIYearTP> list = new ArrayList<InsuranceHIPIYearTP>();
            for (InsuranceHIPIYear element : boArray) {
                InsuranceHIPIYearTP[] tpArray;
                for (InsuranceHIPIYearTP element2 : tpArray = element.getInsuranceHIPIYearTPs()) {
                    list.add(element2);
                }
            }
            InsuranceHIPIYearTP[] result = new InsuranceHIPIYearTP[list.size()];
            return list.toArray(result);
        }
        return new InsuranceHIPIYearTP[0];
    }

    private AdvancePayment[] getAdvancePayments() {
        if (this.isNew()) {
            return new AdvancePayment[0];
        }
        if (this.mAdvancePayments.length == 0) {
            this.mAdvancePayments = AdvancePaymentPersistencyManager.getAdvancePayments((Employee)this);
        }
        return this.mAdvancePayments;
    }

    public EECarriedForwardOfEntry[] getEECarriedForwardOfEntry() {
        if (this.mEECarriedForwardOfEntrys.length == 0) {
            this.mEECarriedForwardOfEntrys = EECarriedForwardOfEntryPersistencyManager.getEECarriedForwardOfEntry((Employee)this);
        }
        return this.mEECarriedForwardOfEntrys;
    }

    public EECarriedForwardSystemCOM[] getEECarriedForwardSystemCOM() {
        if (this.mEECarriedForwardSystemCOMs.length == 0) {
            this.mEECarriedForwardSystemCOMs = EECarriedForwardSystemCOMPersistencyManager.getEECarriedForwardSystemCOM((Employee)this);
        }
        return this.mEECarriedForwardSystemCOMs;
    }

    public EECarriedForwardSystemSI[] getEECarriedForwardSystemSI() {
        if (this.mEECarriedForwardSystemSIs.length == 0) {
            this.mEECarriedForwardSystemSIs = EECarriedForwardSystemSIPersistencyManager.getEECarriedForwardSystemSI((Employee)this);
        }
        return this.mEECarriedForwardSystemSIs;
    }

    public EECarriedForwardSystemSIBreak[] getEECarriedForwardSystemSIBreak() {
        if (this.mEECarriedForwardSystemSIBreaks.length == 0) {
            this.mEECarriedForwardSystemSIBreaks = EECarriedForwardSystemSIBreakPersistencyManager.getEECarriedForwardSystemSIBreak((Employee)this);
        }
        return this.mEECarriedForwardSystemSIBreaks;
    }

    public EECarriedForwardVarPayment[] getEECarriedForwardVarPayment() {
        if (this.mEECarriedForwardVarPayments.length == 0) {
            this.mEECarriedForwardVarPayments = EECarriedForwardVarPaymentPersistencyManager.getEECarriedForwardVarPayment((Employee)this);
        }
        return this.mEECarriedForwardVarPayments;
    }

    public int getMaxSerialNumberOfCarriedForwardOfEntry() {
        return EECarriedForwardOfEntryPersistencyManager.getMaxSerialNumberOfEmployee((Criterion)Restrictions.eq((String)"oidemployee", (String)this.getObjectid()));
    }

    public Date[] identificationOfValidatedCalculationBasic(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        if (!(this.getStateOfValuation() || this.getValuateEffectiveFrom() == null && this.getValuateValidFrom() == null)) {
            if (DateHelper.beforeOrEqual((Date)this.getValuateEffectiveFrom(), (Date)effectiveFrom)) {
                effectiveFrom = this.getValuateEffectiveFrom();
            }
            if (DateHelper.before((Date)this.getValuateValidFrom(), (Date)validFrom)) {
                validFrom = this.getValuateValidFrom();
            }
        }
        if (DateHelper.beforeOrEqual((Date)effectiveFrom, (Date)this.getJournalizedUntil())) {
            effectiveFrom = DateHelper.tomorrow((Date)this.getJournalizedUntil());
        }
        Date maximumDateOfEntry = this.getMinimumDateOfEntry();
        Date calculationStart = this.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getCalculationStart();
        Date date = null;
        date = DateHelper.beforeOrEqual((Date)maximumDateOfEntry, (Date)calculationStart) ? calculationStart : maximumDateOfEntry;
        if (DateHelper.before((Date)validFrom, (Date)date)) {
            validFrom = date;
        }
        Date[] dates = new Date[]{effectiveFrom, validFrom};
        return dates;
    }

    public Employment cancellationOfReEntry(Date dateOfWithdrawal, Date dateOfEntry) throws BusinessDomainException {
        if (dateOfWithdrawal != null) {
            throw EmployeeExceptionMapper.makeCancellationOfReEntryNotPossibleDomainException();
        }
        Employment empl = null;
        Employment[] employments = this.getActiveEffectiveEmploymentHistory();
        Arrays.sort(employments, new EmploymentComparator());
        for (int i = employments.length - 1; i >= 0; --i) {
            if (employments[i].getDateOfWithDrawal() == null) continue;
            empl = employments[i];
            break;
        }
        Employment newEmpl = empl.createNew();
        newEmpl.setValidUntil(VDate.getDateMax());
        return newEmpl;
    }

    public void checkAttributes() throws BusinessDomainException {
        if (this.isNew()) {
            this.checkPersonnelNumber();
            this.checkDateOfEntry();
            this.checkJournalizedUntil();
        }
    }

    public void checkPersonnelNumber() throws BusinessDomainException {
        if (this.getIEmployeePM().exitsPersonnelnumber(this.getPCompany().getObjectid(), this.getPersonnelnumber())) {
            throw EmployeeExceptionMapper.makePersonnelnumberAlreadyExitsDomainException();
        }
    }

    public void checkDateOfEntry() throws BusinessDomainException {
        if (this.getDateOfEntry() == null) {
            throw EmployeeExceptionMapper.makeDateOfEntryMissingDomainException();
        }
    }

    public void checkJournalizedUntil() {
        if (this.getJournalizedUntil() != null) {
            return;
        }
        Date minimumDateOfEntry = this.getMinimumDateOfEntry();
        Date calculationStart = this.getCalculationStart();
        Date date = null;
        date = DateHelper.beforeOrEqual((Date)minimumDateOfEntry, (Date)calculationStart) ? calculationStart : minimumDateOfEntry;
        this.setJournalizedUntil(DateHelper.getLastDayOfMonth((Date)new VDate(date).addMonths(-1).getDate()));
    }

    public Date getCalculationStart() {
        Date calculationStart = this.getPCompany().getActiveCompanyFoundation().getCalculationStart();
        return calculationStart;
    }

    public Date[] checkDates(boolean firstOfHistorie, Date validFrom, Date validUntil) throws BusinessDomainException {
        Date[] correctedDates = this.checkDates(firstOfHistorie, validFrom);
        if (DateHelper.before((Date)validUntil, (Date)correctedDates[1])) {
            throw FrameWorkExceptionMapper.makeValidFromGreaterThanValidUntilDomainException();
        }
        return correctedDates;
    }

    public Date[] checkDates(boolean firstOfHistorie, Date validFrom) {
        Date[] dates = new Date[2];
        Date newEffectiveFrom = null;
        Date newValidFrom = null;
        newEffectiveFrom = DateHelper.tomorrow((Date)this.getJournalizedUntil());
        if (firstOfHistorie || this.isNew()) {
            Date minimumDateOfEntry = this.getMinimumDateOfEntry();
            Date calculationStart = this.getCalculationStart();
            newValidFrom = DateHelper.max((Date)minimumDateOfEntry, (Date)calculationStart);
        } else {
            Date startOfHistory = this.getStartOfHistory();
            newValidFrom = DateHelper.max((Date)validFrom, (Date)startOfHistory);
        }
        dates[0] = newEffectiveFrom;
        dates[1] = newValidFrom;
        return dates;
    }

    public FStateRegion getFStateRegionForCalendar(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        Plant eePlant;
        PlantPlaceTP eePlantPlaceTP;
        PlantPlace eePlantPlace;
        FStateRegion fstateRegion;
        Date improvedValidTimePoint;
        block9: {
            improvedValidTimePoint = DateHelper.getLastDayOfMonth((Date)validTimePoint);
            fstateRegion = null;
            try {
                EEWork eew = this.getEEWork(effectiveTimePoint, improvedValidTimePoint);
                if (eew != null && eew.getRegionForCalendar() != null) {
                    fstateRegion = FStateRegionPersistencyManager.getFStateRegion((String)eew.getRegionForCalendar().getObjectid());
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block9;
                throw e;
            }
        }
        if (fstateRegion == null && (eePlantPlace = this.getEmployment(effectiveTimePoint, improvedValidTimePoint).getPlantPlace()) != null && (eePlantPlaceTP = (PlantPlaceTP)eePlantPlace.getHistory().getItemOrNull(effectiveTimePoint, validTimePoint)) != null) {
            fstateRegion = FStateRegionPersistencyManager.getFStateRegion((String)eePlantPlaceTP.getFederalState().getObjectid());
        }
        if (fstateRegion == null && (eePlant = this.getEmployment(effectiveTimePoint, improvedValidTimePoint).getPlant()) != null) {
            Foundations found = eePlant.getPlantFoundations(effectiveTimePoint, validTimePoint).getFoundations();
            if (found.getRegionForCalendar() != null) {
                fstateRegion = FStateRegionPersistencyManager.getFStateRegion((String)found.getRegionForCalendar().getObjectid());
            } else if (found.getFederalState() != null) {
                fstateRegion = FStateRegionPersistencyManager.getFStateRegion((String)found.getFederalState().getObjectid());
            }
        }
        if (fstateRegion == null) {
            Foundations found = this.getPCompany().getCompanyFoundations(effectiveTimePoint, validTimePoint).getFoundations();
            fstateRegion = found.getRegionForCalendar() != null ? FStateRegionPersistencyManager.getFStateRegion((String)found.getRegionForCalendar().getObjectid()) : FStateRegionPersistencyManager.getFStateRegion((String)found.getFederalState().getObjectid());
        }
        return fstateRegion;
    }

    public EmployeeNote[] getEmployeeNote() {
        this.requireLoaded();
        if (this.mEmployeeNote == null) {
            this.mEmployeeNote = this.isNew() ? new EmployeeNote[0] : EmployeeNotePersistencyManager.getEmployeeNotes((Employee)this);
        }
        return this.mEmployeeNote;
    }

    public void setEmployeeNote(EmployeeNote[] notes) throws BusinessDomainException {
        if (this.getEmployeeNote() != null) {
            for (EmployeeNote element : this.mEmployeeNote) {
                boolean delete = true;
                if (notes.length == 0) {
                    delete = true;
                } else {
                    for (EmployeeNote note : notes) {
                        if (!StringMapper.equal((String)element.getObjectid(), (String)note.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                element.makeSaveable();
                element.destroy();
            }
        }
        for (EmployeeNote note : notes) {
            if (note.getCreateTaskReminder() && note.getTaskReminderDate() != null) {
                this.createTaskReminderNotes(note);
            }
            note.makeSaveable();
        }
        this.mEmployeeNote = notes;
    }

    public EmployeeContact[] getEmployeeContact() {
        this.requireLoaded();
        if (this.mEmployeeContact == null) {
            this.mEmployeeContact = this.isNew() ? new EmployeeContact[0] : EmployeeContactPersistencyManager.getEmployeeContacts((Employee)this);
        }
        return this.mEmployeeContact;
    }

    public void setEmployeeContact(EmployeeContact[] contacts) throws BusinessDomainException {
        if (this.getEmployeeContact() != null) {
            for (EmployeeContact element : this.mEmployeeContact) {
                boolean delete = true;
                if (contacts.length == 0) {
                    delete = true;
                } else {
                    for (EmployeeContact contact : contacts) {
                        if (!StringMapper.equal((String)element.getObjectid(), (String)contact.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                element.makeSaveable();
                element.destroy();
            }
        }
        for (EmployeeContact contact : contacts) {
            if (contact.getCreateTaskReminder() && contact.getTaskReminderDate() != null) {
                this.createTaskReminderContact(contact);
            }
            contact.makeSaveable();
        }
        this.mEmployeeContact = contacts;
    }

    public Date getMinimumDateOfEntry() {
        Date minimumDateOfEntry;
        if (this.isNew()) {
            minimumDateOfEntry = this.getDateOfEntry();
        } else {
            Employment[] employments = this.getActiveEffectiveEmploymentHistory();
            minimumDateOfEntry = employments[0].getDateOfEntry();
            for (int i = 1; i < employments.length; ++i) {
                if (!DateHelper.before((Date)employments[i].getDateOfEntry(), (Date)minimumDateOfEntry)) continue;
                minimumDateOfEntry = employments[i].getDateOfEntry();
            }
        }
        return minimumDateOfEntry;
    }

    public Date getLastDateOfWithdrawal() {
        List list = this.getEmploymentHistory().getAll();
        if (!list.isEmpty()) {
            Employment[] employment = new Employment[list.size()];
            employment = list.toArray(employment);
            Arrays.sort(employment, new EmploymentComparator());
            return employment[employment.length - 1].getDateOfWithDrawal();
        }
        return null;
    }

    public Date getNextDateOfWithdrawal(Date refDate, Date effectiveTimePoint) throws BusinessDomainException {
        List list = this.getEmploymentHistory().getItems(effectiveTimePoint);
        for (Employment employment : list) {
            Date dateOfwithdrawalToCompare;
            Date dateOfWithdrawal = employment.getDateOfWithDrawal();
            if (dateOfWithdrawal == null || !DateHelper.beforeOrEqual((Date)refDate, (Date)dateOfWithdrawal) || (dateOfwithdrawalToCompare = ((Employment)this.getEmploymentHistory().getItem(effectiveTimePoint, dateOfWithdrawal)).getDateOfWithDrawal()) == null || !DateHelper.equal((Date)dateOfWithdrawal, (Date)dateOfwithdrawalToCompare)) continue;
            return employment.getDateOfWithDrawal();
        }
        return null;
    }

    public Employment getEmploymentWithLastDateOfWithdrawal(Date effectiveTimePoint) {
        List list = this.getEmploymentHistory().getItems(effectiveTimePoint);
        if (!list.isEmpty()) {
            int resultIndex = list.size() - 1;
            for (int i = 0; i < list.size(); ++i) {
                if (((Employment)list.get(i)).getDateOfWithDrawal() == null) continue;
                resultIndex = i;
            }
            return (Employment)list.get(resultIndex);
        }
        return null;
    }

    public Date getMaximumDateOfEntry() {
        int i;
        if (this.isNew()) {
            return this.getDateOfEntry();
        }
        List list = this.getEmploymentHistory().getAll();
        boolean isWithdrawal = false;
        for (i = 1; i < list.size(); ++i) {
            if (((Employment)list.get(i)).getDateOfWithDrawal() == null) continue;
            isWithdrawal = true;
        }
        if (isWithdrawal) {
            Date maximumDateOfEntry = ((Employment)list.get(0)).getDateOfEntry();
            for (i = 1; i < list.size(); ++i) {
                if (!DateHelper.after((Date)((Employment)list.get(i)).getDateOfEntry(), (Date)maximumDateOfEntry)) continue;
                maximumDateOfEntry = ((Employment)list.get(i)).getDateOfEntry();
            }
            return maximumDateOfEntry;
        }
        return this.getStartOfHistory();
    }

    public Date getMaximumDateOfWithdrawal() {
        return PDateHelper.maxIgnoringNulls((Date[])((Date[])this.getEmploymentHistory().getAll().stream().map(Employment::getDateOfWithDrawal).toArray(Date[]::new)));
    }

    public Date getDateOfWithdrawalToDateOfEntry(Date dateOfEntry) {
        Date dateOfWithdrawal = null;
        Employment[] employments = this.getActiveEffectiveEmploymentHistory();
        if (employments.length == 1) {
            if (DateHelper.equal((Date)employments[0].getDateOfEntry(), (Date)dateOfEntry)) {
                dateOfWithdrawal = employments[0].getDateOfWithDrawal();
            }
            return dateOfWithdrawal;
        }
        for (int i = 0; i < employments.length; ++i) {
            if (DateHelper.equal((Date)employments[i].getDateOfEntry(), (Date)dateOfEntry)) {
                dateOfWithdrawal = employments[i].getDateOfWithDrawal();
            }
            if (DateHelper.after((Date)employments[i].getDateOfEntry(), (Date)dateOfEntry)) break;
        }
        return dateOfWithdrawal;
    }

    public Date getStartOfHistory() {
        Employment[] employments = this.getActiveEffectiveEmploymentHistory();
        if (employments.length == 0) {
            throw new IllegalStateException("getActiveEffectiveEmploymentHistory returns 0 for " + this);
        }
        return employments[0].getValidFrom();
    }

    public boolean isInEmployment(Date effectiveTimePoint, Date validTimePoint) {
        Employment employment = (Employment)this.getEmploymentHistory().getItemOrNull(effectiveTimePoint, validTimePoint);
        if (employment == null) {
            return false;
        }
        Date end = employment.getDateOfWithDrawal();
        return DateHelper.afterOrEqual((Date)validTimePoint, (Date)employment.getDateOfEntry()) && (end == null || DateHelper.beforeOrEqual((Date)validTimePoint, (Date)end));
    }

    public boolean isMonthOfEmployment(Date month, Date effectiveTimePoint) {
        Employment employment = (Employment)this.getEmploymentHistory().getItemOrNull(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)month));
        if (employment == null) {
            return false;
        }
        return this.isMonthOfEmployment(month, employment);
    }

    public boolean isMonthOfEmployment(Date month, Employment employment) {
        Date dateOfEntry = employment.getDateOfEntry();
        Date dateOfWithdrawal = employment.getDateOfWithDrawal();
        Date beginOfMonth = DateHelper.getFirstDayOfMonth((Date)month);
        Date endOfMonth = DateHelper.getLastDayOfMonth((Date)month);
        return DateHelper.beforeOrEqual((Date)dateOfEntry, (Date)endOfMonth) && (dateOfWithdrawal == null || DateHelper.afterOrEqual((Date)dateOfWithdrawal, (Date)beginOfMonth));
    }

    public Date checkAndCorrectValidFromStartOfValuate(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        Date currentEntryDate;
        Date startOfHistory;
        Date validFromStart = DateHelper.getFirstDayOfMonth((Date)validFrom);
        if (DateHelper.before((Date)validFromStart, (Date)(startOfHistory = this.getStartOfHistory()))) {
            validFromStart = startOfHistory;
        }
        if (DateHelper.before((Date)validFromStart, (Date)(currentEntryDate = this.getEmployment(effectiveFrom, validFromStart).getDateOfEntry()))) {
            validFromStart = currentEntryDate;
        }
        return validFromStart;
    }

    public Date[] checkAndCorrectStartOfCalculation(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        if (DateHelper.beforeOrEqual((Date)effectiveFrom, (Date)this.getJournalizedUntil())) {
            effectiveFrom = DateHelper.tomorrow((Date)this.getJournalizedUntil());
        }
        validFrom = DateHelper.max((Date[])new Date[]{validFrom, this.getMinimumDateOfEntry(), this.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getCalculationStart()});
        return new Date[]{effectiveFrom, validFrom};
    }

    public void restoreInValuation() {
        this.setInValuation(false);
    }

    public boolean getIsFirstEntry() {
        List list = this.getEmploymentHistory().getAll();
        for (int i = 0; i < list.size(); ++i) {
            if (((Employment)list.get(i)).getDateOfWithDrawal() == null) continue;
            return false;
        }
        return true;
    }

    public void existsMaster() throws BusinessDomainException {
        long countRow = this.getIMasterPM().getRowCount(this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeMasterAlreadyExistsDomainException();
        }
    }

    public void existsTax() throws BusinessDomainException {
        long countRow = this.getITaxPM().getRowCount(this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeTaxAlreadyExistsDomainException();
        }
    }

    public void existsInsurance() throws BusinessDomainException {
        long countRow = this.getIInsurancePM().getRowCount(this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeInsuranceAlreadyExistsDomainException();
        }
    }

    public void existsEmployment() throws BusinessDomainException {
        long countRow = this.getEmploymentPM().getRowCount(this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeEmploymentAlreadyExistsDomainException();
        }
    }

    public void existsEEWork() throws BusinessDomainException {
        long countRow = EEWorkPersistencyManager.getRowCount((Employee)this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeEEWorkAlreadyExistsDomainException();
        }
    }

    public EEDisabilityTP[] getDisabledEmployeesOfYear(PCompany pCompany, Date timePoint) {
        return EEDisabilityTPPersistencyManager.getDisabledEmployeesOfYear((PCompany)pCompany, (Date)DateHelper.getFirstDayOfYear((Date)timePoint), (Date)DateHelper.getLastDayOfYear((Date)timePoint));
    }

    public static Date getDateOfReverseProjection(String oidemployee, Date journalizedUntil) {
        return CalculationBasicPersistencyManager.getDateOfReverseProjection((String)oidemployee, (Date)journalizedUntil);
    }

    public void toStringValues(StringBuilder b) {
        b.append(this.getPersonnelnumber()).append(',');
        b.append(this.getPCompany()).append(',');
    }

    public boolean isContributory(Date effectiveFrom, Date validfrom) {
        List ptpoList = this.getInsuranceHistory().getPeriods(effectiveFrom, DateHelper.getFirstDayOfMonth((Date)validfrom), DateHelper.getLastDayOfMonth((Date)validfrom));
        for (int i = 0; i < ptpoList.size(); ++i) {
            Insurance ins = (Insurance)ptpoList.get(i);
            block0 : switch (ins.getDuesGroupHI()) {
                case 6: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 9: {
                    return true;
                }
                case 0: {
                    switch (ins.getContScaleVHI().value()) {
                        case 0: {
                            break block0;
                        }
                    }
                    return true;
                }
            }
            switch (ins.getDuesGroupPI()) {
                case 1: 
                case 3: {
                    return true;
                }
            }
            switch (ins.getDuesGroupUI()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            switch (ins.getDuesGroupNI()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isContributoryHI(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        block9: {
            try {
                Insurance in = this.getInsurance(effectiveFrom, validFrom);
                block1 : switch (in.getDuesGroupHI()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: {
                        return true;
                    }
                    case 0: {
                        switch (in.getContScaleVHI().value()) {
                            case 0: {
                                break block1;
                            }
                        }
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (BusinessDomainException de) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) break block9;
                throw de;
            }
        }
        return false;
    }

    public boolean isContributoryPI(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        try {
            Insurance in = this.getInsurance(effectiveFrom, validFrom);
            switch (in.getDuesGroupPI()) {
                case 1: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
        catch (BusinessDomainException de) {
            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) {
                throw de;
            }
            return false;
        }
    }

    public boolean isContributoryUI(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        try {
            Insurance in = this.getInsurance(effectiveFrom, validFrom);
            switch (in.getDuesGroupUI()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        catch (BusinessDomainException de) {
            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) {
                throw de;
            }
            return false;
        }
    }

    public boolean isContributoryNI(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        try {
            Insurance in = this.getInsurance(effectiveFrom, validFrom);
            switch (in.getDuesGroupNI()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        catch (BusinessDomainException de) {
            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) {
                throw de;
            }
            return false;
        }
    }

    public void resolveDuesAccountNumber(InsuranceDues insuranceDues, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        String oidHealthFund = insuranceDues.getHealthFund().getObjectid();
        Conjunction filter = Restrictions.conjunction();
        AssignmentPCompanyHealthFund assignment = null;
        Plant plant = this.getAppurtenantPlant(effectiveFrom, validFrom);
        if (plant != null) {
            filter = Restrictions.and((Criterion)Restrictions.eq((String)"oidplant", (String)plant.getObjectid()), (Criterion)Restrictions.eq((String)"oidhealthfund", (String)oidHealthFund));
            assignment = this.resolveAssignment((Criterion)filter);
        }
        insuranceDues.setPlantIsEmployer(assignment != null);
        if (assignment == null) {
            filter = Restrictions.and((Criterion)Restrictions.eq((String)"oidpcompany", (String)this.mPCompany.getObjectid()), (Criterion)Restrictions.eq((String)"oidhealthfund", (String)oidHealthFund));
            assignment = this.resolveAssignment((Criterion)filter);
        }
        String duesAccountNumber = null;
        if (assignment != null) {
            AssignmentPCompanyHealthFundTP tp = assignment.getAssignmentPCompanyHealthFundTP(effectiveFrom, validFrom);
            duesAccountNumber = tp.getDuesAccountNumber();
        }
        insuranceDues.setDuesAccountNumber(duesAccountNumber);
    }

    private AssignmentPCompanyHealthFund resolveAssignment(Criterion filter) {
        AssignmentPCompanyHealthFund[] assignments = AssignmentPCompanyHealthFundPersistencyManager.query(null, (Criterion)filter);
        if (assignments.length == 1) {
            return assignments[0];
        }
        return null;
    }

    public boolean isCalculationScheduled() {
        this.requireLoaded();
        return this.hasSchedjobRows() || this.hasEmployeeCalculateRows();
    }

    private boolean hasSchedjobRows() {
        List jobInfos = this.getSchedulerService().getJobs(PreferredScheduler.CALCULATION);
        if (jobInfos.isEmpty()) {
            return false;
        }
        for (JobInformation jobInfo : jobInfos) {
            if (!jobInfo.getDescription().equals(this.getSchedulerDescription().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEqualSchedjob(Date effectivefrom, Date validFrom, String domainKey, String currentJobName) {
        List jobInfos = this.getSchedulerService().getJobs(PreferredScheduler.CALCULATION);
        if (jobInfos.isEmpty()) {
            return false;
        }
        for (JobInformation jobInfo : jobInfos) {
            String jobValidFrom;
            String jobEffectiveFrom;
            if (jobInfo.getName().equals(currentJobName)) continue;
            List currentlyExecutingjobInfos = this.getSchedulerService().getCurrentlyExecutingJobs(PreferredScheduler.CALCULATION);
            for (JobInformation currentlyExecutingJobInfo : currentlyExecutingjobInfos) {
                if (!currentlyExecutingJobInfo.getName().equals(jobInfo.getName())) continue;
            }
            String jobDomainKey = (String)jobInfo.getExecutionParameter().get("suppliedDomainKey");
            if (jobDomainKey == null || !jobDomainKey.equals(domainKey) || (jobEffectiveFrom = (String)jobInfo.getExecutionParameter().get("effectiveFrom")) == null || (jobValidFrom = (String)jobInfo.getExecutionParameter().get("validFrom")) == null) continue;
            Date jobEffectiveFromDate = new Date(LocalDateTime.parse(jobEffectiveFrom).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            Date jobValidFromDate = new Date(LocalDateTime.parse(jobValidFrom).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            if (!DateHelper.equal((Date)jobEffectiveFromDate, (Date)effectivefrom) || !DateHelper.beforeOrEqual((Date)jobValidFromDate, (Date)validFrom)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEmployeeCalculateRows() {
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.geProperty((String)"effectivefrom", (String)"journalizeduntil"), Restrictions.isNull((String)"oidcalculationcase"), Restrictions.eq((String)"calculatenecessary", (String)BooleanMapper.toString((boolean)true))});
        return EmployeeCalculatePersistencyManager.getRowCount((Criterion)filters) != 0L;
    }

    public String getSchedulerCode() {
        return this.getSchedulerDescription() + " / " + TimeHelper.microSecondsToString((long)TimestampHelper.nextTime());
    }

    public StringBuffer getSchedulerDescription() {
        this.requireLoaded();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.mPCompany.getPCompanyKey());
        buffer.append(" / ");
        buffer.append(this.mPersonnelnumber);
        return buffer;
    }

    public Journalize.StatusOfJournalize journalize(Date journalAt, Date journalTo, List<EmployeeForCalculateStruct> toCalculate, Date minCalculationStart) throws BusinessDomainException {
        AdvancePaymentTP[] tps;
        Insurance insurance;
        if (!DateHelper.equal((Date)this.mJournalizedUntil, (Date)journalAt)) {
            return Journalize.StatusOfJournalize.BEREITS_JOURNALISIERT;
        }
        if (!this.mMasterdatachecked) {
            return Journalize.StatusOfJournalize.FEHLERHAFT_GEPRUEFT;
        }
        if (EmployeeExtended.getWarningStateOfCheck((Date)this.getLastDateOfWithdrawal(), (Date)this.getLastCheck(), (Date)journalAt) == WarningStateOfCheckEnum.ROT) {
            return Journalize.StatusOfJournalize.PRUEFLAUF_FEHLT;
        }
        if (this.mInValuation) {
            return Journalize.StatusOfJournalize.IN_BERECHNUNG;
        }
        if (this.mException != null) {
            return Journalize.StatusOfJournalize.FEHLERHAFT_ABGERECHNET;
        }
        if (this.isCalculationScheduled()) {
            throw EmployeeExceptionMapper.makeWaitForSchedulerDomainException(this.getSchedulerDescription());
        }
        if (this.noInsuranceDateExists()) {
            throw EmployeeExceptionMapper.makeNoInsuranceDatatExistsException(this.getSchedulerDescription());
        }
        if (this.checkattendance(journalTo, journalTo) && (insurance = this.getInsurance(journalTo, journalTo)).getPersonGroup() != 102 && insurance.getPersonGroup() != 107 && insurance.getPersonGroup() != 111 && this.isNoPaymentWithSocialInsuranceDays(journalAt, journalTo)) {
            throw EvaluationExceptionMapper.makeNoPaymentWithSocialInsuranceDaysDomainException((Date)DateHelper.getFirstDayOfMonth((Date)journalTo), (CharSequence)this.getSchedulerDescription());
        }
        if (this.isAgePartTimeBeginPassivPeriod(journalTo)) {
            this.createTaskReminderAgePartTime(journalTo);
        }
        if ((tps = AdvancePaymentTPPersistencyManager.queryAll(null, (Conjunction)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)journalTo))), Restrictions.le((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)journalTo))), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"paid", (String)"F")}), (boolean)true)).length > 0) {
            for (AdvancePaymentTP each : tps) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)each.getResult()) && BigDecimalMapper.isZeroOrNull((BigDecimal)each.getFactor1()) && BigDecimalMapper.isZeroOrNull((BigDecimal)each.getFactor1())) continue;
                throw EmployeeExceptionMapper.makeUnpaidAdvancePaymentExistsDomainException(this.getSchedulerDescription());
            }
        }
        if (this.isToJournalize(journalTo)) {
            this.mJournalizedUntil = journalTo;
            this.mLicenceCounter = this.determineLicenceCounter(minCalculationStart);
            this.checkCalculationNecessary(toCalculate);
            return Journalize.StatusOfJournalize.ERFOLGREICH;
        }
        return Journalize.StatusOfJournalize.SONSTIGES;
    }

    public boolean checkattendance(Date effectiveDate, Date validDate) throws BusinessDomainException {
        Date validFrom = DateHelper.getFirstDayOfMonth((Date)validDate);
        EEAbsentTimeTP[] fehlzeiten = this.getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validFrom))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom)), Restrictions.eq((String)"oidemployee", (String)this.getObjectid())}), true);
        if (fehlzeiten.length == 0) {
            return true;
        }
        if (this.checkFehlzeiten(fehlzeiten, validFrom)) {
            if (fehlzeiten.length == 1) {
                if (DateHelper.after((Date)fehlzeiten[0].getValidFrom(), (Date)validFrom) || DateHelper.before((Date)fehlzeiten[0].getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)validFrom)) || fehlzeiten[0].getEEAbsentTime().getAbsentTime().getAbsentTimeTP(effectiveDate, validFrom).getCutOfSocialInsuranceDays().value() == 0) {
                    return true;
                }
            } else {
                Date tempDate = validFrom;
                Date endDate = DateHelper.getLastDayOfMonth((Date)tempDate);
                boolean attendance = false;
                while (DateHelper.beforeOrEqual((Date)tempDate, (Date)endDate) && !attendance) {
                    attendance = true;
                    for (EEAbsentTimeTP eeATTP : fehlzeiten) {
                        if (!DateHelper.between((Date)tempDate, (Date)eeATTP.getValidFrom(), (Date)eeATTP.getValidUntil()) || eeATTP.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(tempDate, tempDate).getCutOfSocialInsuranceDays().value() == 0) continue;
                        attendance = false;
                    }
                    tempDate = DateHelper.tomorrow((Date)tempDate);
                }
                return attendance;
            }
        }
        return false;
    }

    private boolean checkFehlzeiten(EEAbsentTimeTP[] fehlzeiten, Date checkDate) throws BusinessDomainException {
        for (EEAbsentTimeTP eeATTP : fehlzeiten) {
            if (eeATTP.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(checkDate, checkDate).getCutOfSocialInsuranceDays() == CutOfSocialInsuranceDaysEnum.COSIDE_Kuerzung_nach_Ablauf_Zeitmonat) {
                return false;
            }
            String[] relevanteFehlzeiten = new String[]{"BTV", "EZQ", "EZK", "FUQ"};
            String absentTimeKey = eeATTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey();
            for (String fehlzeit : relevanteFehlzeiten) {
                if (!StringMapper.equal((String)absentTimeKey, (String)fehlzeit)) continue;
                return false;
            }
        }
        return true;
    }

    private void createTaskReminderContact(EmployeeContact contact) {
        String reminderName = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber((Employee)this, (String)"gew\u00fcnschte Kontaktaufnahme mit: ", (String)contact.getAssignmentContact().getContactPerson());
        if (!TaskReminderHelper.existsTaskReminder((String)reminderName)) {
            TaskReminderHelper.createTaskReminder((String)reminderName, (Date)contact.getTaskReminderDate(), (String)"", (String)SessionContext.getInstance().getSession().getUserCode());
        }
    }

    private void createTaskReminderNotes(EmployeeNote note) {
        String reminderName = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber((Employee)this, (String)"Notiz beachten zum Betreff: ", (String)note.getAssignmentNote().getSubject());
        String reminderNote = new StringBuffer().append("Datum: ").append(DateMapper.toDDMMYYYYPointSeparationString((Date)note.getAssignmentNote().getDate())).append(" Ansprechpartner: ").append(note.getAssignmentNote().getName()).append(" Notiz: ").append(note.getAssignmentNote().getNote()).toString();
        if (!TaskReminderHelper.existsTaskReminder((String)reminderName)) {
            TaskReminderHelper.createTaskReminder((String)reminderName, (Date)note.getTaskReminderDate(), (String)reminderNote, (String)SessionContext.getInstance().getSession().getUserCode());
        }
    }

    private void createTaskReminderAgePartTime(Date journalTo) {
        String reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this, (String)"Im Beginnmonat der ATZ-Freistellungsphase sind ggf. noch nicht verbeitragte Altwertguthaben als UV-Brutto zu verbeitragen");
        String reminderNote = new StringBuffer().append("Bitte wenden Sie sich bei Fragen an Ihren Software-Partner").toString();
        if (!TaskReminderHelper.existsTaskReminder((String)reminderName)) {
            TaskReminderHelper.createTaskReminder((String)reminderName, (Date)journalTo, (String)reminderNote, (String)SessionContext.getInstance().getSession().getUserCode());
        }
    }

    private boolean isAgePartTimeBeginPassivPeriod(Date journalTo) throws BusinessDomainException {
        boolean result = false;
        Insurance ins = this.getInsurance(journalTo, journalTo);
        if (ins.getPersonGroup() == 103 && ins.getTypeAgePartTime() == TypeAgePartTimeEnum.TOAPTE_BLOCKZEIT && DateHelper.equal((Date)ins.getBeginWorkExemption(), (Date)journalTo)) {
            ValuePosition[] vpArray = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.in((String)"valuetypenumber", (String[])new String[]{Integer.toString(801165)}), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)journalTo)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)journalTo)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)journalTo))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)journalTo))}));
            BigDecimal oldAssets = BigDecimal.ZERO;
            for (ValuePosition vPos : vpArray) {
                oldAssets = oldAssets.add(vPos.getResult());
            }
            if (!BigDecimalMapper.isZero((BigDecimal)oldAssets)) {
                result = true;
            }
        }
        return result;
    }

    private boolean isToJournalize(Date journalTo) {
        if (this.mStateOfValuation) {
            return true;
        }
        return DateHelper.before((Date)journalTo, (Date)this.mValuateEffectiveFrom) && DateHelper.before((Date)journalTo, (Date)this.mValuateValidFrom);
    }

    private void checkCalculationNecessary(List<EmployeeForCalculateStruct> toCalculate) throws BusinessDomainException {
        PersistencyDataSet valuePositionDatas;
        Date dateOfWithdrawal;
        Junction filters = Restrictions.conjunction().add(Restrictions.eq((String)"oidemployee", (String)this.getObjectid())).add(Restrictions.eq((String)"status", (String)"T")).add(Restrictions.eq((String)"mastereffuntil", (String)"2099-12-31")).add(Restrictions.eq((String)"mastervaluntil", (String)"2099-12-31")).add(Restrictions.eq((String)"empleffuntil", (String)"2099-12-31")).add(Restrictions.eq((String)"emplvaluntil", (String)"2099-12-31")).add(Restrictions.sqlRestriction((String)"validfrom = (select min(validfrom) from calculationcase_t where oidcalculation = objectidroot)"));
        CalculationallContainer[] containers = CalculationPersistencyManager.queryAll((Order[])new Order[]{Order.desc((String)"effectivefrom"), Order.desc((String)"validfrom")}, (Criterion)filters);
        if (!(containers.length <= 0 || (dateOfWithdrawal = this.getLastDateOfWithdrawal()) != null && DateHelper.before((Date)dateOfWithdrawal, (Date)DateHelper.getFirstDayOfMonth((Date)this.getJournalizedUntil())))) {
            Date lastValidFromOfCalculation = containers[0].effectivefrom;
            Date futureCalculateUntil = PersonnelBasic.getPersonnelBasic().getCalculationUntil(lastValidFromOfCalculation);
            if (DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.getJournalizedUntil()), (Date)futureCalculateUntil)) {
                toCalculate.add(new EmployeeForCalculateStruct(this.getObjectid(), DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)PDateHelper.getFirstDayNextMonth((Date)this.getJournalizedUntil())))));
            }
        }
        if ((valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.getJournalizedUntil())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.getJournalizedUntil()))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.getJournalizedUntil())), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.getJournalizedUntil()))), Restrictions.eq((String)"valuetypenumber", (String)"890100")}))).hasNext()) {
            toCalculate.add(new EmployeeForCalculateStruct(this.getObjectid(), DateMapper.toString((Date)DateHelper.tomorrow((Date)this.getJournalizedUntil()))));
        }
    }

    private boolean isNoPaymentWithSocialInsuranceDays(Date journalAt, Date journalTo) throws BusinessDomainException {
        boolean lPruefungsAbbruch = false;
        Date timePoint = journalTo;
        String timePointAsString = DateMapper.toString((Date)timePoint);
        Date dateOfWithdrawal = this.getLastDateOfWithdrawal();
        if (dateOfWithdrawal != null && DateHelper.beforeOrEqual((Date)dateOfWithdrawal, (Date)journalAt)) {
            lPruefungsAbbruch = true;
        }
        if (dateOfWithdrawal != null && DateHelper.between((Date)dateOfWithdrawal, (Date)DateHelper.getFirstDayOfMonth((Date)journalTo), (Date)journalTo)) {
            timePoint = dateOfWithdrawal;
            timePointAsString = DateMapper.toString((Date)timePoint);
        }
        ValueType[] valueTypes = ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130520, 130590, 321590, 327590, 333590, 339590, 230510, 230520});
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidvaluetype", (String)valueTypes[0].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[1].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[2].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[3].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[4].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[5].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[6].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[7].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[8].getObjectid())}), Restrictions.le((String)"effectivefrom", (String)timePointAsString), Restrictions.ge((String)"effectiveuntil", (String)timePointAsString), Restrictions.le((String)"validfrom", (String)timePointAsString), Restrictions.ge((String)"validuntil", (String)timePointAsString)});
        ValuePosition[] valuePositions = ValuePositionPersistencyManager.queryWithOutSort((Criterion)filters);
        BigDecimal siDays = BigDecimalMapper.ZERO;
        BigDecimal siGross = BigDecimalMapper.ZERO;
        BigDecimal hiDays = BigDecimalMapper.ZERO;
        BigDecimal piDays = BigDecimalMapper.ZERO;
        BigDecimal uiDays = BigDecimalMapper.ZERO;
        BigDecimal niDays = BigDecimalMapper.ZERO;
        block20: for (ValuePosition vp : valuePositions) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 130590: {
                    siDays = siDays.add(vp.getFactor1());
                    if (vp.getPersistentBuffer5().compareTo(BigDecimal.ONE) != 0) continue block20;
                    lPruefungsAbbruch = true;
                    continue block20;
                }
                case 321590: {
                    hiDays = hiDays.add(vp.getFactor1());
                    continue block20;
                }
                case 327590: {
                    piDays = piDays.add(vp.getFactor1());
                    continue block20;
                }
                case 333590: {
                    uiDays = uiDays.add(vp.getFactor1());
                    continue block20;
                }
                case 339590: {
                    niDays = niDays.add(vp.getFactor1());
                    continue block20;
                }
                case 130510: 
                case 130520: 
                case 230510: 
                case 230520: {
                    siGross = siGross.add(vp.getResult());
                    continue block20;
                }
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)siDays) && BigDecimalMapper.isZeroOrNull((BigDecimal)siGross) && !lPruefungsAbbruch) {
            Insurance insurance = this.getInsurance(timePoint, timePoint);
            switch (insurance.getDuesGroupHI()) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    if (hiDays.compareTo(BigDecimal.ZERO) == 0) break;
                    return true;
                }
            }
            switch (insurance.getDuesGroupPI()) {
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    if (piDays.compareTo(BigDecimal.ZERO) == 0) break;
                    return true;
                }
            }
            switch (insurance.getDuesGroupUI()) {
                case 1: 
                case 2: {
                    if (uiDays.compareTo(BigDecimal.ZERO) == 0) break;
                    return true;
                }
            }
            switch (insurance.getDuesGroupNI()) {
                case 1: 
                case 2: {
                    if (niDays.compareTo(BigDecimal.ZERO) == 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public EEDataERA getActiveEEDataERA() {
        EEDataERA[] eeDataERA = EEDataERAPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.sqlRestriction((String)"validuntil = ( select max(validuntil) from eedataera_t A where A.oidemployee = eedataera_T.oidemployee and A.effectiveuntil = ?   )", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (eeDataERA.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return eeDataERA[0];
    }

    public EEDataERA[] getActiveEffectiveEEDataERAHistory() {
        List items = this.getDataERAHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEDataERA[items.size()]);
    }

    public EEDataERA[] getEffectiveEEDataERAHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEEDataERAHistory(effectivTimePoint);
    }

    public EEDataERA[] getEEDataERAHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEDataERA[0];
        }
        return this.listToEEDataERAArray(this.getDataERAHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<EEDataERA> getDataERAHistory() {
        this.requireLoaded();
        if (this.mEEDataERAHistory == null) {
            this.mEEDataERAHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEDataERAHistory());
        }
        return this.mEEDataERAHistory;
    }

    public EEDataERA[] getEEDataERAHistory() {
        if (this.isNew()) {
            return new EEDataERA[0];
        }
        return EEDataERAPersistencyManager.getEEDataERAHistory(null, (Employee)this);
    }

    public EEDataERA getEEDataERA(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (EEDataERA)this.getDataERAHistory().getItem(effectiveFrom, validFrom);
    }

    public EEDataERA getEEDataERAOrNull(Date effectiveFrom, Date validFrom) {
        return (EEDataERA)this.getDataERAHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public void addEEDataERAHistory(EEDataERA eeDataERA, boolean removeNew) throws BusinessDomainException {
        EEDataERA[] changedArray;
        eeDataERA.checkAttributes();
        Date oldValidUntil = CloneUtils.clone((Date)eeDataERA.getValidUntil());
        Date oldValidFrom = CloneUtils.clone((Date)eeDataERA.getValidFrom());
        Date oldEffectiveFrom = CloneUtils.clone((Date)eeDataERA.getEffectiveFrom());
        for (EEDataERA element : changedArray = this.listToEEDataERAArray(this.getDataERAHistory().addItem((PersonnelTimedPersistenceObject)eeDataERA, removeNew))) {
            if (!DateHelper.equal((Date)element.getValidFrom(), (Date)oldValidFrom) || !DateHelper.equal((Date)element.getEffectiveFrom(), (Date)oldEffectiveFrom)) continue;
            element.setValidUntil(oldValidUntil);
        }
        if (changedArray.length == 1) {
            eeDataERA.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (EEDataERA element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setEEDataERAHistory(EEDataERA eeDataERA, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEDataERA[] changedArray;
        eeDataERA.checkAttributes();
        if (DateHelper.equal((Date)eeDataERA.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEEDataERAArray(this.getDataERAHistory().setItem((PersonnelTimedPersistenceObject)eeDataERA, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToEEDataERAArray(this.getDataERAHistory().addItem((PersonnelTimedPersistenceObject)eeDataERA, removeNew));
        }
        for (EEDataERA element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private EEDataERA[] listToEEDataERAArray(List<EEDataERA> list) {
        EEDataERA[] eeDataERAData = new EEDataERA[list.size()];
        return list.toArray(eeDataERAData);
    }

    public EEDataERA[] getEEDataERATimePeriods(EEDataERA ptpo) {
        return (EEDataERA[])this.getDataERAHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void existsEEDataERA() throws BusinessDomainException {
        long countRow = EEDataERAPersistencyManager.getRowCount((Employee)this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeEEDataAlreadyExistsDomainException();
        }
    }

    public Date[] deleteEEDataERA() throws BusinessDomainException {
        EEDataERA[] result = EEDataERAPersistencyManager.getEEDataERAHistory((Order[])new Order[]{Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")}, (Employee)this);
        int length = result.length;
        if (length == 0) {
            return new Date[]{null, null};
        }
        if (DateHelper.afterOrEqual((Date)result[0].getEffectiveFrom(), (Date)DateHelper.tomorrow((Date)this.getJournalizedUntil()))) {
            for (int i = 0; i < length; ++i) {
                result[i].makeSaveable();
                result[i].destroy();
            }
            return new Date[]{result[0].getEffectiveFrom(), result[0].getValidFrom()};
        }
        throw EmployeeExceptionMapper.makeEEDataERANotDeletableDomainException();
    }

    public ScalePayment[] getScalePayments() {
        if (this.isNew()) {
            return new ScalePayment[0];
        }
        if (this.mScalePayments.length == 0) {
            this.mScalePayments = ScalePaymentPersistencyManager.getScalePayments((Employee)this);
        }
        return this.mScalePayments;
    }

    public ScalePaymentTP[] getScalePaymentHistory() {
        ScalePayment[] roots = this.getScalePayments();
        if (roots.length > 0) {
            ArrayList<ScalePaymentTP> list = new ArrayList<ScalePaymentTP>();
            for (ScalePayment root : roots) {
                ScalePaymentTP[] ptpos;
                for (ScalePaymentTP ptpo : ptpos = root.getScalePaymentTPs()) {
                    list.add(ptpo);
                }
            }
            ScalePaymentTP[] array = new ScalePaymentTP[list.size()];
            return list.toArray(array);
        }
        return new ScalePaymentTP[0];
    }

    public ScalePaymentTP[] getEffectiveScalePayments(Date effectiveTimePoint, Date validTimePoint) {
        ScalePaymentTP[] tps = this.getScalePaymentHistory();
        if (tps.length > 0) {
            ArrayList<ScalePaymentTP> list = new ArrayList<ScalePaymentTP>();
            for (ScalePaymentTP tp : tps) {
                if (!DateHelper.afterOrEqual((Date)tp.getEffectiveFrom(), (Date)effectiveTimePoint) && !tp.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)tp.getValidFrom(), (Date)validTimePoint) && !tp.inValidness(validTimePoint)) continue;
                list.add(tp);
            }
            ScalePaymentTP[] array = new ScalePaymentTP[list.size()];
            return list.toArray(array);
        }
        return new ScalePaymentTP[0];
    }

    public Date[] checkDatesForAddAndSetWithOutCheck(boolean firstOfHistorie, Date validFrom) {
        Date startOfHistory;
        Date calculationStart;
        Date minimumDateOfEntry;
        Date[] dates = new Date[2];
        Date newEffectiveFrom = null;
        Date newValidFrom = null;
        newEffectiveFrom = DateHelper.tomorrow((Date)this.getJournalizedUntil());
        newValidFrom = firstOfHistorie || this.isNew() ? (DateHelper.beforeOrEqual((Date)(minimumDateOfEntry = this.getMinimumDateOfEntry()), (Date)(calculationStart = this.getCalculationStart())) ? calculationStart : minimumDateOfEntry) : (DateHelper.before((Date)validFrom, (Date)(startOfHistory = this.getStartOfHistory())) ? startOfHistory : validFrom);
        dates[0] = newEffectiveFrom;
        dates[1] = newValidFrom;
        return dates;
    }

    public EEDataCredit[] getEEDataCredits() {
        if (this.isNew()) {
            return new EEDataCredit[0];
        }
        if (this.mEEDataCredits.length == 0) {
            this.mEEDataCredits = EEDataCreditPersistencyManager.getEEDataCredits((Employee)this);
        }
        return this.mEEDataCredits;
    }

    public EEDataCreditTP[] getEEDataCreditHistory() {
        EEDataCredit[] roots = this.getEEDataCredits();
        if (roots.length > 0) {
            ArrayList<EEDataCreditTP> list = new ArrayList<EEDataCreditTP>();
            for (EEDataCredit root : roots) {
                EEDataCreditTP[] ptpos;
                for (EEDataCreditTP ptpo : ptpos = root.getEEDataCreditTPs()) {
                    list.add(ptpo);
                }
            }
            EEDataCreditTP[] array = new EEDataCreditTP[list.size()];
            return list.toArray(array);
        }
        return new EEDataCreditTP[0];
    }

    public EEDataCreditTP[] getEEDataCredits(Date effectiveFrom, Date validFrom) {
        return EEDataCreditTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validFrom)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom)), Restrictions.eq((String)"oidemployee", (String)this.getObjectid())}), (boolean)true);
    }

    public EEDataCreditTP[] getEffectiveEEDataCredits(Date effectiveTimePoint, Date validTimePoint) {
        EEDataCreditTP[] tps = this.getEEDataCreditHistory();
        if (tps.length > 0) {
            ArrayList<EEDataCreditTP> list = new ArrayList<EEDataCreditTP>();
            for (EEDataCreditTP tp : tps) {
                if (!DateHelper.afterOrEqual((Date)tp.getEffectiveFrom(), (Date)effectiveTimePoint) && !tp.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)tp.getValidFrom(), (Date)validTimePoint) && !tp.inValidness(validTimePoint)) continue;
                list.add(tp);
            }
            EEDataCreditTP[] array = new EEDataCreditTP[list.size()];
            return list.toArray(array);
        }
        return new EEDataCreditTP[0];
    }

    public EEDataCreditTP[] getEffectiveEEDataCredits(Date effectiveTimePoint) {
        EEDataCreditTP[] tps = this.getEEDataCreditHistory();
        if (tps.length > 0) {
            ArrayList<EEDataCreditTP> list = new ArrayList<EEDataCreditTP>();
            for (EEDataCreditTP tp : tps) {
                if (!DateHelper.afterOrEqual((Date)tp.getEffectiveFrom(), (Date)effectiveTimePoint) && !tp.inEffectiveness(effectiveTimePoint)) continue;
                list.add(tp);
            }
            EEDataCreditTP[] array = new EEDataCreditTP[list.size()];
            return list.toArray(array);
        }
        return new EEDataCreditTP[0];
    }

    public EECarriedForwardSIDistance[] getEECarriedForwardSIDistance() {
        if (this.mEECarriedForwardSIDistances.length == 0) {
            this.mEECarriedForwardSIDistances = EECarriedForwardSIDistancePersistencyManager.getEECarriedForwardSIDistance((Employee)this);
        }
        return this.mEECarriedForwardSIDistances;
    }

    public void checkVWECostCenter(CostCenter costCenter, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.getPCompany().checkVWECostCenter(costCenter, effectiveFrom, validFrom);
    }

    public void specialCheckAgePartTimePrueflauf() throws BusinessDomainException {
        Date dateOfWithdrawal = this.getLastDateOfWithdrawal();
        if (dateOfWithdrawal != null && DateHelper.beforeOrEqual((Date)dateOfWithdrawal, (Date)this.getJournalizedUntil())) {
            return;
        }
        Date TIME_POINT = new VDate(2009, 0, 1).getDate();
        Insurance[] insurances = this.getInsuranceHistory(VDate.getDateMax());
        Arrays.sort(insurances, new InsuranceComparator());
        for (Insurance ins : insurances) {
            if (ins.getPersonGroup() != 103 || ins.getTypeAgePartTime() != TypeAgePartTimeEnum.TOAPTE_BLOCKZEIT || !DateHelper.before((Date)ins.getValidFrom(), (Date)TIME_POINT)) continue;
            EECarriedForwardSIDistance[] eeCarriedForwards = EECarriedForwardSIDistancePersistencyManager.getEECarriedForwardSIDistance((Employee)this);
            int length1 = eeCarriedForwards.length;
            if (length1 == 0) {
                throw EmployeeExceptionMapper.makeEECarriedForwardSIDistanceIsMissingDomainException();
            }
            for (int j = 0; j < length1; ++j) {
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getHIPaymentWest()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getPIPaymentWest()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getUIPaymentWest()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getNIPaymentWest()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getHIPaymentEast()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getPIPaymentEast()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getUIPaymentEast()) || !BigDecimalMapper.isZeroOrNull((BigDecimal)eeCarriedForwards[j].getNIPaymentEast())) continue;
                throw EmployeeExceptionMapper.makeEECarriedForwardSIDistanceIsMissingDomainException();
            }
            EEDataCreditTP[] eeDataCredit = EEDataCreditTPPersistencyManager.queryAll(null, (Criterion)Restrictions.eq((String)"oidEmployee", (String)this.getObjectid()), (boolean)true);
            length1 = eeDataCredit.length;
            if (length1 == 0) {
                throw EmployeeExceptionMapper.makeEEDataCreditIsMissingDomainException();
            }
            boolean find20090101 = false;
            for (int j = 0; j < length1; ++j) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)eeDataCredit[j].getAmountCarriedForwardWest()) && BigDecimalMapper.isZeroOrNull((BigDecimal)eeDataCredit[j].getHoursCarriedForwardWest()) && BigDecimalMapper.isZeroOrNull((BigDecimal)eeDataCredit[j].getAmountCarriedForwardEast()) && BigDecimalMapper.isZeroOrNull((BigDecimal)eeDataCredit[j].getHoursCarriedForwardEast())) {
                    throw EmployeeExceptionMapper.makeEEDataCreditIsMissingDomainException();
                }
                if (!DateHelper.beforeOrEqual((Date)eeDataCredit[j].getValidFrom(), (Date)TIME_POINT)) continue;
                find20090101 = true;
            }
            if (find20090101) continue;
            throw EmployeeExceptionMapper.makeEEDataCreditIsMissingDomainException();
        }
    }

    public EEPieceWorkTP[] getEffectiveEEPieceWorkTP(Date effectiveTimePoint, Date validTimePoint) {
        EEPieceWorkTP[] tps = this.getEEPieceWorkHistory();
        ArrayList<EEPieceWorkTP> list = new ArrayList<EEPieceWorkTP>();
        for (EEPieceWorkTP pieceWorkTP : tps) {
            if (!DateHelper.afterOrEqual((Date)pieceWorkTP.getEffectiveFrom(), (Date)effectiveTimePoint) && !pieceWorkTP.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)pieceWorkTP.getValidFrom(), (Date)validTimePoint) && !pieceWorkTP.inValidness(validTimePoint)) continue;
            list.add(pieceWorkTP);
        }
        EEPieceWorkTP[] array = new EEPieceWorkTP[list.size()];
        return list.toArray(array);
    }

    private EEPieceWorkTP[] getEEPieceWorkHistory() {
        EEPieceWork[] eepw = this.getEEPieceWorks();
        ArrayList<EEPieceWorkTP> list = new ArrayList<EEPieceWorkTP>();
        for (EEPieceWork pieceWork : eepw) {
            EEPieceWorkTP[] pieceWorkTPs;
            for (EEPieceWorkTP pieceWorkTP : pieceWorkTPs = pieceWork.getEEPieceWorkTPs()) {
                list.add(pieceWorkTP);
            }
        }
        if (!list.isEmpty()) {
            return list.toArray(new EEPieceWorkTP[list.size()]);
        }
        return new EEPieceWorkTP[0];
    }

    private EEPieceWork[] getEEPieceWorks() {
        if (this.isNew()) {
            return new EEPieceWork[0];
        }
        if (this.mEEPieceWorks.length == 0) {
            this.mEEPieceWorks = EEPieceWorkPersistencyManager.getEEPieceWorks((Employee)this);
        }
        return this.mEEPieceWorks;
    }

    public ErrorMessage[] getErrorMessages() {
        return this.mErrorMessages.toArray(new ErrorMessage[this.mErrorMessages.size()]);
    }

    public void addErrorMessage(ErrorMessage errorMessage) {
        this.mErrorMessages.add(errorMessage);
    }

    public void addAllErrorMessages(Collection<ErrorMessage> errorMessages) {
        this.mErrorMessages.addAll(errorMessages);
    }

    public void addEEZVKHistory(EEZVK eeZVK, boolean removeNew) throws BusinessDomainException {
        eeZVK.checkAttributes();
        EEZVK[] changedArray = this.listToEEZVKArray(this.getZVKHistory().addItem((PersonnelTimedPersistenceObject)eeZVK, removeNew));
        if (changedArray.length == 1) {
            eeZVK.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (EEZVK element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private EEZVK[] listToEEZVKArray(List<EEZVK> list) {
        EEZVK[] EEZVKData = new EEZVK[list.size()];
        return list.toArray(EEZVKData);
    }

    public EEZVK getActiveEEZVK() {
        EEZVK[] eezvks = EEZVKPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (eezvks.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return eezvks[0];
    }

    public void setEEZVKHistory(EEZVK eeZVK, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEZVK[] changedArray;
        eeZVK.checkAttributes();
        if (DateHelper.equal((Date)eeZVK.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEEZVKArray(this.getZVKHistory().setItem((PersonnelTimedPersistenceObject)eeZVK, removeNew));
        } else {
            removeNew = true;
            eeZVK.makeReadOnly();
            changedArray = this.listToEEZVKArray(this.getZVKHistory().addItem((PersonnelTimedPersistenceObject)eeZVK, removeNew));
        }
        for (EEZVK element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public EEZVK[] getActiveEffectiveEEZVKHistory() {
        List items = this.getZVKHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEZVK[items.size()]);
    }

    public PersonnelHistory<EEZVK> getZVKHistory() {
        this.requireLoaded();
        if (this.mZVKHistory == null) {
            this.mZVKHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEZVKHistory());
        }
        return this.mZVKHistory;
    }

    public EEZVK[] getEEZVKHistory() {
        if (this.isNew()) {
            return new EEZVK[0];
        }
        return EEZVKPersistencyManager.getEEZVKHistory((Employee)this);
    }

    public EEZVK[] getEffectiveZVKHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEEZVKHistory(effectivTimePoint);
    }

    private EEZVK[] getEEZVKHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEZVK[0];
        }
        return this.listToEEZVKArray(this.getZVKHistory().getItems(effectivTimePoint));
    }

    public EEZVK getEEZVK(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (EEZVK)this.getZVKHistory().getItem(effectiveFrom, validFrom);
    }

    public EEZVK getEEZVKOrNull(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (EEZVK)this.getZVKHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public Education getActiveEducation() {
        Education[] educations = EducationPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (educations.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return educations[0];
    }

    public Education[] getActiveEffectiveEducationHistory() {
        List items = this.getEducationHistory().getItems(VDate.getDateMax());
        return items.toArray(new Education[items.size()]);
    }

    public Education[] getEffectiveEducationHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEducationHistory(effectivTimePoint);
    }

    public Education[] getEducationHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Education[0];
        }
        return this.listToEducationArray(this.getEducationHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<Education> getEducationHistory() {
        this.requireLoaded();
        if (this.mEducationHistory == null) {
            this.mEducationHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEEducationHistory());
        }
        return this.mEducationHistory;
    }

    public Education[] getEEEducationHistory() {
        if (this.isNew()) {
            return new Education[0];
        }
        return EducationPersistencyManager.getEducationHistory((Employee)this);
    }

    public Education getEducation(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (Education)this.getEducationHistory().getItem(effectiveFrom, validFrom);
    }

    public void addEducationHistory(Education tax, boolean removeNew) throws BusinessDomainException {
        tax.checkAttributes();
        Education[] changedArray = this.listToEducationArray(this.getEducationHistory().addItem((PersonnelTimedPersistenceObject)tax, removeNew));
        if (changedArray.length == 1) {
            tax.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Education element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setEducationHistory(Education tax, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        Education[] changedArray;
        tax.checkAttributes();
        if (DateHelper.equal((Date)tax.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEducationArray(this.getEducationHistory().setItem((PersonnelTimedPersistenceObject)tax, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToEducationArray(this.getEducationHistory().addItem((PersonnelTimedPersistenceObject)tax, removeNew));
        }
        for (Education element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private Education[] listToEducationArray(List<Education> list) {
        Education[] EducationData = new Education[list.size()];
        return list.toArray(EducationData);
    }

    public Education[] getEducationTimePeriods(Education ptpo) {
        return (Education[])this.getEducationHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void existsEducation() throws BusinessDomainException {
        long countRow = EducationPersistencyManager.getRowCount((Employee)this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeEducationAlreadyExistsDomainException();
        }
    }

    public Dismissal getActiveDismissal() {
        Dismissal[] dismissals = DismissalPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (dismissals.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return dismissals[0];
    }

    public Dismissal[] getActiveEffectiveDismissalHistory() {
        List items = this.getDismissalHistory().getItems(VDate.getDateMax());
        return items.toArray(new Dismissal[items.size()]);
    }

    public Dismissal[] getEffectiveDismissalHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getDismissalHistory(effectivTimePoint);
    }

    public Dismissal[] getDismissalHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new Dismissal[0];
        }
        return this.listToDismissalArray(this.getDismissalHistory().getItems(effectivTimePoint));
    }

    public PersonnelHistory<Dismissal> getDismissalHistory() {
        this.requireLoaded();
        if (this.mDismissalHistory == null) {
            this.mDismissalHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEDismissalHistory());
        }
        return this.mDismissalHistory;
    }

    public Dismissal[] getEEDismissalHistory() {
        if (this.isNew()) {
            return new Dismissal[0];
        }
        return DismissalPersistencyManager.getDismissalHistory((Employee)this);
    }

    public Dismissal getDismissal(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (Dismissal)this.getDismissalHistory().getItem(effectiveFrom, validFrom);
    }

    public void addDismissalHistory(Dismissal tax, boolean removeNew) throws BusinessDomainException {
        tax.checkAttributes();
        Dismissal[] changedArray = this.listToDismissalArray(this.getDismissalHistory().addItem((PersonnelTimedPersistenceObject)tax, removeNew));
        if (changedArray.length == 1) {
            tax.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (Dismissal element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setDismissalHistory(Dismissal tax, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        Dismissal[] changedArray;
        tax.checkAttributes();
        if (DateHelper.equal((Date)tax.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToDismissalArray(this.getDismissalHistory().setItem((PersonnelTimedPersistenceObject)tax, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToDismissalArray(this.getDismissalHistory().addItem((PersonnelTimedPersistenceObject)tax, removeNew));
        }
        for (Dismissal element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private Dismissal[] listToDismissalArray(List<Dismissal> list) {
        Dismissal[] DismissalData = new Dismissal[list.size()];
        return list.toArray(DismissalData);
    }

    public Dismissal[] getDismissalTimePeriods(Dismissal ptpo) {
        return (Dismissal[])this.getDismissalHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void existsDismissal() throws BusinessDomainException {
        long countRow = DismissalPersistencyManager.getRowCount((Employee)this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeDismissalAlreadyExistsDomainException();
        }
    }

    public Date getApprenticeFrom() {
        Date apprenticeFrom = null;
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)VDate.getDateMax())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)VDate.getDateMax())), Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"persongroup", (String)Integer.toString(102)), Restrictions.eq((String)"persongroup", (String)Integer.toString(105)), Restrictions.eq((String)"persongroup", (String)Integer.toString(121)), Restrictions.eq((String)"persongroup", (String)Integer.toString(122))})});
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        Insurance[] insurances = this.getIInsurancePM().query(sort, (Criterion)filters, true);
        if (insurances.length != 0) {
            apprenticeFrom = insurances[0].getValidFrom();
        }
        return apprenticeFrom;
    }

    public void deleteEducation() throws BusinessDomainException {
        Education[] result = EducationPersistencyManager.query((Order[])new Order[]{Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), (Employee)this, (boolean)true);
        int length = result.length;
        if (DateHelper.afterOrEqual((Date)result[0].getEffectiveFrom(), (Date)DateHelper.tomorrow((Date)this.getJournalizedUntil()))) {
            for (int i = 0; i < length; ++i) {
                result[i].makeSaveable();
                result[i].destroy();
            }
        } else {
            throw EmployeeExceptionMapper.makeEducationNotDeletableDomainException();
        }
    }

    public void deleteDismissal() throws BusinessDomainException {
        Dismissal[] result = DismissalPersistencyManager.query((Order[])new Order[]{Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), (Employee)this, (boolean)true);
        int length = result.length;
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)this.getObjectid()), Restrictions.eq((String)"REASONOFDELIVER", (String)"69")});
        if (ElenaAccountPersistencyManager.getRowCount((Criterion)filters) > 0L) {
            throw EmployeeExceptionMapper.makeDismissalNotDeletableDomainException();
        }
        for (int i = 0; i < length; ++i) {
            result[i].makeSaveable();
            result[i].destroy();
        }
    }

    public EEMaterialExpensesTP[] getEffectiveEEMaterialExpenses(Date effectiveTimePoint, Date validTimePoint) {
        EEMaterialExpensesTP[] tpArray = this.getEEMaterialExpensesHistory();
        if (tpArray.length > 0) {
            ArrayList<EEMaterialExpensesTP> list = new ArrayList<EEMaterialExpensesTP>();
            for (EEMaterialExpensesTP element : tpArray) {
                if (!DateHelper.afterOrEqual((Date)element.getEffectiveFrom(), (Date)effectiveTimePoint) && !element.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)element.getValidFrom(), (Date)validTimePoint) && !element.inValidness(validTimePoint)) continue;
                list.add(element);
            }
            EEMaterialExpensesTP[] array = new EEMaterialExpensesTP[list.size()];
            return list.toArray(array);
        }
        return new EEMaterialExpensesTP[0];
    }

    public EERelativeTP[] getEffectiveEERelativesForEvaluation(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        EERelativeTP[] eeRelativeTPs = this.getEERelativesHistory();
        if (eeRelativeTPs.length > 0) {
            ArrayList<EERelativeTP> list = new ArrayList<EERelativeTP>();
            for (EERelativeTP eeRelativeTP : eeRelativeTPs) {
                if (eeRelativeTP.getDegreeRelationShip() != DegreeRelationShipEnum.DRSE_KIND || !DateHelper.beforeOrEqual((Date)eeRelativeTP.getEffectiveFrom(), (Date)effectiveTimePoint) || !DateHelper.afterOrEqual((Date)eeRelativeTP.getEffectiveUntil(), (Date)effectiveTimePoint) || !DateHelper.beforeOrEqual((Date)eeRelativeTP.getValidFrom(), (Date)validTimePoint) || !DateHelper.afterOrEqual((Date)eeRelativeTP.getValidUntil(), (Date)validTimePoint) || !eeRelativeTP.getDoPayment() && eeRelativeTP.getCAFlagCalculation() != FlagCalculationEnum.FCE_COUNTONLY) continue;
                if (eeRelativeTP.getDateOfBirth() == null) {
                    throw EvaluationExceptionMapper.makeNoDateOfBirthOfChildDomainException();
                }
                if (eeRelativeTP.getCAPaymentUntil() != null) {
                    if (!DateHelper.beforeOrEqual((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)eeRelativeTP.getCAPaymentUntil())) continue;
                    if (DateHelper.after((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)eeRelativeTP.getDateOfBirth())) {
                        if (DateHelper.getDiffInMonths((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)eeRelativeTP.getDateOfBirth()) > 216) {
                            if (!eeRelativeTP.getCACertProvided()) continue;
                            list.add(eeRelativeTP);
                            continue;
                        }
                        list.add(eeRelativeTP);
                        continue;
                    }
                    list.add(eeRelativeTP);
                    continue;
                }
                if (DateHelper.after((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)eeRelativeTP.getDateOfBirth())) {
                    if (DateHelper.getDiffInMonths((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)eeRelativeTP.getDateOfBirth()) > 216) {
                        if (!eeRelativeTP.getCACertProvided()) continue;
                        list.add(eeRelativeTP);
                        continue;
                    }
                    list.add(eeRelativeTP);
                    continue;
                }
                list.add(eeRelativeTP);
            }
            if (!list.isEmpty()) {
                Collections.sort(list, new EERelativeDateOfBirthComparator());
                EERelativeTP[] array = new EERelativeTP[list.size()];
                return list.toArray(array);
            }
            return new EERelativeTP[0];
        }
        return new EERelativeTP[0];
    }

    public BigDecimal getEffectiveNumberOfChildrenForNI(Date effectiveTimePoint, Date validTimePoint, boolean ignoreEmptyDateOfBirth, boolean callByEvaluation) throws BusinessDomainException {
        InsuranceChild insuranceChild;
        int count = 0;
        if (DateHelper.afterOrEqual((Date)validTimePoint, (Date)new VDate(2023, 6, 1).getDate()) && (insuranceChild = (InsuranceChild)this.getInsuranceChildHistory().getItemOrNull(effectiveTimePoint, validTimePoint)) != null) {
            if (!insuranceChild.getManually()) {
                count = insuranceChild.getNumberOfChild();
            }
            if (callByEvaluation && !DateHelper.equal((Date)insuranceChild.getValidUntil(), (Date)VDate.getDateMax())) {
                new CalculationBasic(this, effectiveTimePoint, DateHelper.tomorrow((Date)insuranceChild.getValidUntil()), insuranceChild.getClassName());
            }
        }
        if (count == 0) {
            EERelativeTP[] tpArray;
            for (EERelativeTP eeRelativeTP : tpArray = this.getEERelativesHistory()) {
                if (eeRelativeTP.getDegreeRelationShip() != DegreeRelationShipEnum.DRSE_KIND || !DateHelper.beforeOrEqual((Date)eeRelativeTP.getEffectiveFrom(), (Date)effectiveTimePoint) || !DateHelper.afterOrEqual((Date)eeRelativeTP.getEffectiveUntil(), (Date)effectiveTimePoint) || !DateHelper.beforeOrEqual((Date)eeRelativeTP.getValidFrom(), (Date)validTimePoint) || !DateHelper.afterOrEqual((Date)eeRelativeTP.getValidUntil(), (Date)validTimePoint)) continue;
                Date dateOfBirth = eeRelativeTP.getDateOfBirth();
                if (dateOfBirth == null && !ignoreEmptyDateOfBirth) {
                    throw EvaluationExceptionMapper.makeNoDateOfBirthOfChildDomainException();
                }
                if (dateOfBirth == null || !DateHelper.after((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)dateOfBirth) || !DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint), (Date)DateHelper.getFirstDayOfMonth((Date)dateOfBirth)) && DateHelper.getDiffInYears((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint), (Date)dateOfBirth) >= 25) continue;
                ++count;
            }
        }
        return BigDecimal.valueOf(count);
    }

    private EEMaterialExpensesTP[] getEEMaterialExpensesHistory() {
        EEMaterialExpenses[] boArray = this.getEEMaterialExpensess();
        if (boArray.length > 0) {
            ArrayList<EEMaterialExpensesTP> list = new ArrayList<EEMaterialExpensesTP>();
            for (EEMaterialExpenses eeMatExp : boArray) {
                EEMaterialExpensesTP[] tpArray;
                for (EEMaterialExpensesTP eeMatExpTP : tpArray = eeMatExp.getEEMaterialExpensesTPs()) {
                    list.add(eeMatExpTP);
                }
            }
            EEMaterialExpensesTP[] array = new EEMaterialExpensesTP[list.size()];
            return list.toArray(array);
        }
        return new EEMaterialExpensesTP[0];
    }

    private EERelativeTP[] getEERelativesHistory() {
        EERelative[] boArray = this.getEERelatives();
        if (boArray.length > 0) {
            ArrayList<EERelativeTP> list = new ArrayList<EERelativeTP>();
            for (EERelative eeRelative : boArray) {
                EERelativeTP[] tpArray;
                for (EERelativeTP eeRelativeTP : tpArray = eeRelative.getEERelativeTPs()) {
                    list.add(eeRelativeTP);
                }
            }
            EERelativeTP[] array = new EERelativeTP[list.size()];
            return list.toArray(array);
        }
        return new EERelativeTP[0];
    }

    public EEMaterialExpenses[] getEEMaterialExpensess() {
        if (this.isNew()) {
            return new EEMaterialExpenses[0];
        }
        if (this.mEEMaterialExpenses.length == 0) {
            this.mEEMaterialExpenses = EEMaterialExpensesPersistencyManager.getEEMaterialExpensess((Employee)this);
        }
        return this.mEEMaterialExpenses;
    }

    public EESkill[] getEESkills() {
        if (this.isNew()) {
            return new EESkill[0];
        }
        if (this.mEESkills.length == 0) {
            this.mEESkills = this.getIEESkillPM().getEESkills(this);
        }
        return this.mEESkills;
    }

    public EERelative[] getEERelatives() {
        if (this.isNew()) {
            return new EERelative[0];
        }
        if (this.mEERelatives.length == 0) {
            this.mEERelatives = this.getIEERelativePM().getEERelatives(this);
        }
        return this.mEERelatives;
    }

    private boolean noInsuranceDateExists() {
        long countRow = this.getIInsurancePM().getRowCount(this);
        return countRow == 0L;
    }

    public EEVBLU getActiveEEVBLU() {
        EEVBLU[] eeVblus = EEVBLUPersistencyManager.query((Order[])new Order[0], (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (eeVblus.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return eeVblus[0];
    }

    public void addEEVBLUHistory(EEVBLU eeVBLu, boolean removeNew) throws BusinessDomainException {
        eeVBLu.checkAttributes();
        EEVBLU[] changedArray = this.listToEEVBLUArray(this.getVBLUHistory().addItem((PersonnelTimedPersistenceObject)eeVBLu, removeNew));
        if (changedArray.length == 1) {
            eeVBLu.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (EEVBLU element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private EEVBLU[] listToEEVBLUArray(List<EEVBLU> list) {
        EEVBLU[] eeVBLUData = new EEVBLU[list.size()];
        return list.toArray(eeVBLUData);
    }

    public PersonnelHistory<EEVBLU> getVBLUHistory() {
        this.requireLoaded();
        if (this.mVBLUHistory == null) {
            this.mVBLUHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEVBLUHistory());
        }
        return this.mVBLUHistory;
    }

    public EEVBLU[] getEEVBLUHistory() {
        if (this.isNew()) {
            return new EEVBLU[0];
        }
        return EEVBLUPersistencyManager.getEEVBLUHistory((Employee)this);
    }

    public void setEEVBLUHistory(EEVBLU eeVBLU, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEVBLU[] changedArray;
        eeVBLU.checkAttributes();
        if (DateHelper.equal((Date)eeVBLU.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEEVBLUArray(this.getVBLUHistory().setItem((PersonnelTimedPersistenceObject)eeVBLU, removeNew));
        } else {
            removeNew = true;
            eeVBLU.makeReadOnly();
            changedArray = this.listToEEVBLUArray(this.getVBLUHistory().addItem((PersonnelTimedPersistenceObject)eeVBLU, removeNew));
        }
        for (EEVBLU element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public EEVBLU getEEVBLU(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (EEVBLU)this.getVBLUHistory().getItem(effectiveFrom, validFrom);
    }

    public EEVBLU getEEVBLUOrNull(Date effectiveFrom, Date validFrom) {
        this.requireLoaded();
        return (EEVBLU)this.getVBLUHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public EEVBLU[] getEffectiveVBLUHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEEVBLUHistory(effectivTimePoint);
    }

    private EEVBLU[] getEEVBLUHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEVBLU[0];
        }
        return this.listToEEVBLUArray(this.getVBLUHistory().getItems(effectivTimePoint));
    }

    public EEVBLU[] getActiveEffectiveEEVBLUHistory() {
        List items = this.getVBLUHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEVBLU[items.size()]);
    }

    public EEAnalysisCode getActiveAnalysisCode() {
        EEAnalysisCode[] codes = EEAnalysisCodePersistencyManager.query(null, (Conjunction)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true);
        if (codes.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return codes[0];
    }

    public void addEEAnalysisCodeHistory(EEAnalysisCode code, boolean removeNew) throws BusinessDomainException {
        code.checkAttributes();
        EEAnalysisCode[] changedArray = this.listToEEAnalysisCodeArray(this.getAnalysisCodeHistory().addItem((PersonnelTimedPersistenceObject)code, removeNew));
        if (changedArray.length == 1) {
            code.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (EEAnalysisCode element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    private EEAnalysisCode[] listToEEAnalysisCodeArray(List<EEAnalysisCode> list) {
        EEAnalysisCode[] insurancedata = new EEAnalysisCode[list.size()];
        return list.toArray(insurancedata);
    }

    public PersonnelHistory<EEAnalysisCode> getAnalysisCodeHistory() {
        this.requireLoaded();
        if (this.mEEAnalysisCodeHistory == null) {
            this.mEEAnalysisCodeHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEAnalysisCodeHistory());
        }
        return this.mEEAnalysisCodeHistory;
    }

    private EEAnalysisCode[] getEEAnalysisCodeHistory() {
        if (this.isNew()) {
            return new EEAnalysisCode[0];
        }
        return EEAnalysisCodePersistencyManager.getEEAnalysisCodeHistory((Employee)this);
    }

    public void existsEEAnalysisCode() throws BusinessDomainException {
        long countRow = EEAnalysisCodePersistencyManager.getRowCount((Employee)this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeInsuranceAlreadyExistsDomainException();
        }
    }

    public static EEAnalysisCode[] getActiveEEAnalyseCodes(EEPAnalysisCodeFilterStruct[] filter, Order[] sortierung) {
        EEAnalysisCode[] codes = EEAnalysisCodePersistencyManager.queryAll((Order[])sortierung, (Criterion)EEAnalysisCodeFilterStructMapper.toFilter((EEPAnalysisCodeFilterStruct[])filter), (boolean)true);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(codes, new EEAnalysisCodeComparator());
        }
        return codes;
    }

    public EEAnalysisCode[] getActiveEffectiveEEAnalysisCodeHistory() {
        List items = this.getAnalysisCodeHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEAnalysisCode[items.size()]);
    }

    public EEAnalysisCode[] getEEAnalyseCodeHistory() {
        if (this.isNew()) {
            return new EEAnalysisCode[0];
        }
        return EEAnalysisCodePersistencyManager.getEEAnalyseCodeHistory((Employee)this);
    }

    public EEAnalysisCode[] getEffectiveEEAnalysisCodeHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEEAnalyseCodeHistory(effectivTimePoint);
    }

    private EEAnalysisCode[] getEEAnalyseCodeHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEAnalysisCode[0];
        }
        return this.listToEEAnalysisCodeArray(this.getAnalysisCodeHistory().getItems(effectivTimePoint));
    }

    public EEAnalysisCode getEEAnalysisCode(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (EEAnalysisCode)this.getAnalysisCodeHistory().getItem(effectiveFrom, validFrom);
    }

    public synchronized void setEEAnalysisCodeHistory(EEAnalysisCode code, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEAnalysisCode[] changedArray;
        code.checkAttributes();
        if (DateHelper.equal((Date)code.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEEAnalysisCodeArray(this.getAnalysisCodeHistory().setItem((PersonnelTimedPersistenceObject)code, removeNew));
        } else {
            removeNew = true;
            code.makeReadOnly();
            changedArray = this.listToEEAnalysisCodeArray(this.getAnalysisCodeHistory().addItem((PersonnelTimedPersistenceObject)code, removeNew));
        }
        for (EEAnalysisCode element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public boolean isInsolvencyAssessable() throws BusinessDomainException {
        Employment employment = this.getActiveEmployment();
        try {
            if (employment.getPlant() != null) {
                PlantSettings plantSettings = employment.getPlant().getPlantSettings(VDate.getDateMax(), VDate.getDateMax());
                return plantSettings.getSettings().getInsolvencyAssessable();
            }
            CompanySettings companySettings = this.getPCompany().getCompanySettings(VDate.getDateMax(), VDate.getDateMax());
            return companySettings.getSettings().getInsolvencyAssessable();
        }
        catch (BusinessDomainException de) {
            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) {
                throw de;
            }
            return false;
        }
    }

    public void deleteEEVBLUHistory() throws BusinessDomainException {
        PersonnelHistory<EEVBLU> eeVBLUHistory = this.getVBLUHistory();
        if (DateHelper.after((Date)this.getJournalizedUntil(), (Date)((EEVBLU)eeVBLUHistory.getAll().get(0)).getEffectiveFrom())) {
            throw FrameWorkExceptionMapper.makeDeleteAfterJournalizeNotAllowedDomainException();
        }
        List eeVblus = eeVBLUHistory.getAll();
        for (EEVBLU each : eeVblus) {
            each.makeSaveable();
            each.destroy();
        }
    }

    public void deleteEEZVKHistory() throws BusinessDomainException {
        PersonnelHistory<EEZVK> eeZVKHistory = this.getZVKHistory();
        if (DateHelper.after((Date)this.getJournalizedUntil(), (Date)((EEZVK)eeZVKHistory.getAll().get(0)).getEffectiveFrom())) {
            throw FrameWorkExceptionMapper.makeDeleteAfterJournalizeNotAllowedDomainException();
        }
        List eeZvks = eeZVKHistory.getAll();
        for (EEZVK each : eeZvks) {
            each.makeSaveable();
            each.destroy();
        }
    }

    public Date[] deleteInsuranceChild() throws BusinessDomainException {
        InsuranceChild[] result = this.getIInsuranceChildPM().getInsuranceChildHistory(new Order[]{Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")}, this);
        int length = result.length;
        if (length == 0) {
            return new Date[]{null, null};
        }
        if (DateHelper.afterOrEqual((Date)result[0].getEffectiveFrom(), (Date)DateHelper.tomorrow((Date)this.getJournalizedUntil()))) {
            for (int i = 0; i < length; ++i) {
                result[i].makeSaveable();
                result[i].destroy();
            }
            return new Date[]{result[0].getEffectiveFrom(), result[0].getValidFrom()};
        }
        throw EmployeeExceptionMapper.makeInsuranceChildNotDeletableDomainException(result[0].getValidFrom());
    }

    private BigDecimal determineLicenceCounter(Date minCalculationStartAllOfCompanies) throws BusinessDomainException {
        Date marginalDate = new VDate(2022, 6, 1).getDate();
        CompanyFoundations companyFoundation = this.mPCompany.getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax());
        if (companyFoundation.getSpecific() != SpecificEnum.SE_keine_Besonderheiten) {
            return BigDecimal.valueOf(0L);
        }
        Date dateOfWithdrawal = this.getLastDateOfWithdrawal();
        if (dateOfWithdrawal != null && DateHelper.before((Date)dateOfWithdrawal, (Date)this.getJournalizedUntil())) {
            return BigDecimal.valueOf(0L);
        }
        Insurance insurance = (Insurance)this.getInsuranceHistory().getItemOrNull(this.getJournalizedUntil(), this.getJournalizedUntil());
        if (insurance == null) {
            return BigDecimal.valueOf(0L);
        }
        int personGroup = insurance.getPersonGroup();
        if (personGroup == 102 || personGroup == 121 || personGroup == 122 || personGroup == 105 || personGroup == 106 || personGroup == 109 || personGroup == 110) {
            if (DateHelper.afterOrEqual((Date)minCalculationStartAllOfCompanies, (Date)marginalDate)) {
                return BigDecimal.valueOf(1L);
            }
            return BigDecimal.valueOf(5L, 1);
        }
        if ((personGroup == 990 || personGroup == 991 || personGroup == 992 || personGroup == 993 || personGroup == 994 || personGroup == 995) && insurance.missBgs()) {
            if (insurance.getBeginKVDR() != null && DateHelper.beforeOrEqual((Date)insurance.getBeginKVDR(), (Date)this.getJournalizedUntil()) && (insurance.getEndKVDR() == null || DateHelper.afterOrEqual((Date)insurance.getEndKVDR(), (Date)this.getJournalizedUntil()))) {
                return BigDecimal.valueOf(1L);
            }
            return BigDecimal.valueOf(5L, 1);
        }
        return BigDecimal.valueOf(1L);
    }

    public EEAccidentInsuranceFund getActiveEEAccidentInsuranceFund() throws BusinessDomainException {
        Date maxDate = VDate.getDateMax();
        EEAccidentInsuranceFund[] et = this.getEEAccidentInsuranceFundPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)maxDate)), Restrictions.eq((String)"validuntil", (String)DateMapper.toString((Date)maxDate))}), true);
        if (et.length == 0) {
            throw FrameWorkExceptionMapper.makeNoHistoryFoundForDate((String)this.getObjectid(), (Date)maxDate, (Date)maxDate);
        }
        return et[0];
    }

    public EEAccidentInsuranceFund[] getActiveEffectiveEEAccidentInsuranceFundHistory() {
        List items = this.getEEAccidentInsuranceFundHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEAccidentInsuranceFund[items.size()]);
    }

    public EEAccidentInsuranceFund[] getEffectiveEEAccidentInsuranceFundHistory(Date effectivTimePoint) throws BusinessDomainException {
        if (effectivTimePoint == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimepointIsEmptyDomainException();
        }
        return this.getEEAccidentInsuranceFundHistory(effectivTimePoint);
    }

    public EEAccidentInsuranceFund[] getEEAccidentInsuranceFundHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEAccidentInsuranceFund[0];
        }
        return this.listToEEAccidentInsuranceFundArray(this.getEEAccidentInsuranceFundHistory().getItems(effectivTimePoint));
    }

    public EEAccidentInsuranceFund[] getEEAccidentInsuranceFundHistory(Date effectivTimePoint, Date validFrom, Date validUntil) {
        this.requireLoaded();
        if (this.isNew()) {
            return new EEAccidentInsuranceFund[0];
        }
        List ptpoList = this.getEEAccidentInsuranceFundHistory().getPeriods(effectivTimePoint, validFrom, validUntil);
        return ptpoList.toArray(new EEAccidentInsuranceFund[ptpoList.size()]);
    }

    public PersonnelHistory<EEAccidentInsuranceFund> getEEAccidentInsuranceFundHistory() {
        this.requireLoaded();
        if (this.mEEAccidentInsuranceFundHistory == null) {
            this.mEEAccidentInsuranceFundHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getEEEEAccidentInsuranceFundHistory());
        }
        return this.mEEAccidentInsuranceFundHistory;
    }

    public EEAccidentInsuranceFund[] getEEEEAccidentInsuranceFundHistory() {
        if (this.isNew()) {
            return new EEAccidentInsuranceFund[0];
        }
        return this.getEEAccidentInsuranceFundPM().getEEAccidentInsuranceFundHistory(this);
    }

    public EEAccidentInsuranceFund getEEAccidentInsuranceFund(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (EEAccidentInsuranceFund)this.getEEAccidentInsuranceFundHistory().getItem(effectiveFrom, validFrom);
    }

    public void addEEAccidentInsuranceFundHistory(EEAccidentInsuranceFund bo, boolean removeNew) throws BusinessDomainException {
        bo.checkAttributes();
        EEAccidentInsuranceFund[] changedArray = this.listToEEAccidentInsuranceFundArray(this.getEEAccidentInsuranceFundHistory().addItem((PersonnelTimedPersistenceObject)bo, removeNew));
        if (changedArray.length == 1) {
            bo.setEffectiveFrom(DateHelper.tomorrow((Date)this.getJournalizedUntil()));
        }
        for (EEAccidentInsuranceFund element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void setEEAccidentInsuranceFundHistory(EEAccidentInsuranceFund bo, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEAccidentInsuranceFund[] changedArray;
        bo.checkAttributes();
        if (DateHelper.equal((Date)bo.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = this.listToEEAccidentInsuranceFundArray(this.getEEAccidentInsuranceFundHistory().setItem((PersonnelTimedPersistenceObject)bo, removeNew));
        } else {
            removeNew = true;
            changedArray = this.listToEEAccidentInsuranceFundArray(this.getEEAccidentInsuranceFundHistory().addItem((PersonnelTimedPersistenceObject)bo, removeNew));
        }
        for (EEAccidentInsuranceFund element : changedArray) {
            element.makeSaveable();
            element.registerForLastExecute();
        }
    }

    public void existsEEAccidentInsuranceFund() throws BusinessDomainException {
        long countRow = this.getEEAccidentInsuranceFundPM().getRowCount(this);
        if (countRow != 0L) {
            throw EmployeeExceptionMapper.makeEEAccidentInsuranceFundAlreadyExistsDomainException();
        }
    }

    private EEAccidentInsuranceFund[] listToEEAccidentInsuranceFundArray(List<EEAccidentInsuranceFund> list) {
        EEAccidentInsuranceFund[] etData = new EEAccidentInsuranceFund[list.size()];
        return list.toArray(etData);
    }

    public EEAccidentInsuranceFund[] getEEAccidentInsuranceFundTimePeriods(EEAccidentInsuranceFund ptpo) {
        return (EEAccidentInsuranceFund[])this.getEEAccidentInsuranceFundHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public ForInitialiseOfInsuranceStruct getInitialiseOfInsurance() throws BusinessDomainException {
        Employment employment = this.getActiveEmployment();
        try {
            if (employment.getPlant() != null) {
                PlantSettings plantSettings = employment.getPlant().getPlantSettings(VDate.getDateMax(), VDate.getDateMax());
                return new ForInitialiseOfInsuranceStruct("", plantSettings.getSettings().getInsolvencyAssessable(), plantSettings.getSettings().getERPaysNISurcharge());
            }
            CompanySettings companySettings = this.getPCompany().getCompanySettings(VDate.getDateMax(), VDate.getDateMax());
            return new ForInitialiseOfInsuranceStruct("", companySettings.getSettings().getInsolvencyAssessable(), companySettings.getSettings().getERPaysNISurcharge());
        }
        catch (BusinessDomainException de) {
            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) {
                throw de;
            }
            return new ForInitialiseOfInsuranceStruct("", false, false);
        }
    }

    public EECarriedForwardZVK[] getEECarriedForwardZVK() {
        if (this.mEECarriedForwardZVKs.length == 0) {
            this.mEECarriedForwardZVKs = this.getEECarriedForwardZVKPM().getEECarriedForwardZVK(this);
        }
        return this.mEECarriedForwardZVKs;
    }

    public BigDecimal sumOfValueTypeByResult(Date effectiveTimePoint, Date validFrom, Date validUntil, int ... valueTypeNumbers) {
        int n = valueTypeNumbers.length;
        String[] valueTypeNumbersAsString = new String[n];
        for (int i = 0; i < n; ++i) {
            valueTypeNumbersAsString[i] = Integer.toString(valueTypeNumbers[i]);
        }
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom)), Restrictions.in((String)"valuetypenumber", (String[])valueTypeNumbersAsString)});
        ValuePosition[] valuePositions = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filters);
        return new ValueInterval((Validityable[])valuePositions).calculate(validFrom, validUntil);
    }

    public boolean checkAccidentInsuranceFundIsNecessary(Date timePoint) throws BusinessDomainException {
        return this.checkAccidentInsuranceFundIsNecessary(VDate.getDateMax(), timePoint);
    }

    public boolean checkAccidentInsuranceFundIsNecessary(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        if (this.noCheckForInsolvencyCompany()) {
            return false;
        }
        boolean requiredPgs = true;
        Insurance insurance = (Insurance)this.getInsuranceHistory().getItemOrNull(VDate.getDateMax(), validTimePoint);
        if (insurance != null) {
            int pgs = insurance.getPersonGroup();
            if (!insurance.isDEUVAdviceable() || pgs == 108 || pgs == 111) {
                requiredPgs = false;
            }
        } else {
            return false;
        }
        boolean requiredReason = true;
        EEAccidentInsuranceFund eeAif = (EEAccidentInsuranceFund)this.getEEAccidentInsuranceFundHistory().getItemOrNull(effectiveTimePoint, validTimePoint);
        if (eeAif != null && eeAif.getSpecialUVReason() != SpecialUVReasonEnum.SURE_KEIN_BESONDERER_GRUND) {
            requiredReason = false;
        }
        return requiredPgs && requiredReason;
    }

    public boolean isSuitableForCheckup() throws BusinessDomainException {
        Date lastDateOfWithdrawal = this.getLastDateOfWithdrawal();
        return lastDateOfWithdrawal == null || !this.isBeforeOrEqualMinDateOfRetroactiveCalculation(lastDateOfWithdrawal);
    }

    public boolean isLastDateOfWithdrawalAfter(Date date) {
        Date lastDateOfWithdrawal = this.getLastDateOfWithdrawal();
        return lastDateOfWithdrawal == null || DateHelper.after((Date)lastDateOfWithdrawal, (Date)date);
    }

    public void checkRemittance(Insurance oldObject, Insurance newObject) throws BusinessDomainException {
    }

    public boolean isDateOfWithdrawalJournalized(Date effectiveTimePoint, Date validTimePoint) {
        Employment employment = (Employment)this.getEmploymentHistory().getItemOrNull(effectiveTimePoint, validTimePoint);
        if (employment != null) {
            return this.isDateOfWithdrawalJournalized(employment.getDateOfWithDrawal());
        }
        return false;
    }

    public boolean isDateOfWithdrawalJournalized(Employment employment) {
        return this.isDateOfWithdrawalJournalized(employment.getDateOfWithDrawal());
    }

    public boolean isLastDateOfWithdrawalJournalized() {
        return this.isDateOfWithdrawalJournalized(this.getLastDateOfWithdrawal());
    }

    public boolean isDateOfWithdrawalJournalized(Date dateOfWithdrawal) {
        return dateOfWithdrawal != null && DateHelper.beforeOrEqual((Date)dateOfWithdrawal, (Date)this.getJournalizedUntil());
    }

    public Employee getPredecessor() {
        Employee predecessor = null;
        EESuccessor[] predecessors = this.getIEESuccessorPM().query(null, Restrictions.eq((String)"OIDSUCCESSOR", (String)this.getObjectid()));
        if (predecessors.length > 1) {
            EmployeeExceptionMapper.makeMoreThanOnePredecessorDomainException(this.getDomainKey());
        }
        if (predecessors.length == 1) {
            predecessor = predecessors[0].getEmployee();
        }
        return predecessor;
    }

    public Employee[] getAllPredecessor() {
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (Employee predecessor = this.getPredecessor(); predecessor != null; predecessor = predecessor.getPredecessor()) {
            result.add(predecessor);
        }
        Collections.reverse(result);
        return result.toArray(new Employee[result.size()]);
    }

    public Employee getSuccessor() {
        Employee successor = null;
        EESuccessor[] successors = this.getIEESuccessorPM().query(null, Restrictions.eq((String)"OIDEMPLOYEE", (String)this.getObjectid()));
        if (successors.length > 1) {
            EmployeeExceptionMapper.makeMoreThanOneSuccessorDomainException(this.getDomainKey());
        }
        if (successors.length == 1) {
            successor = successors[0].getSuccessor();
        }
        return successor;
    }

    public Employee[] getAllSuccessor() {
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (Employee successor = this.getSuccessor(); successor != null; successor = successor.getSuccessor()) {
            result.add(successor);
        }
        return result.toArray(new Employee[result.size()]);
    }

    public Employee getLastSuccessor() {
        Employee successor = this.getSuccessor();
        return successor == null ? this : successor.getLastSuccessor();
    }

    public Employee getFirstPredecessor() {
        Employee predecessor = this.getPredecessor();
        return predecessor == null ? this : predecessor.getFirstPredecessor();
    }

    public Employee[] getAllPredecessorAndSuccessor() {
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (Employee each : this.getAllPredecessor()) {
            result.add(each);
        }
        result.add(this);
        for (Employee each : this.getAllSuccessor()) {
            result.add(each);
        }
        return result.toArray(new Employee[result.size()]);
    }

    public boolean isSuccessor() {
        EESuccessor[] successor = ((IEESuccessorPersistencyManager)UtilitiesManager.getBean((String)"eeSuccessorPersistencyManager", IEESuccessorPersistencyManager.class)).query(null, Restrictions.eq((String)"OIDSUCCESSOR", (String)this.getObjectid()));
        return successor.length > 0;
    }

    public boolean isPredecessor() {
        EESuccessor[] successor = ((IEESuccessorPersistencyManager)UtilitiesManager.getBean((String)"eeSuccessorPersistencyManager", IEESuccessorPersistencyManager.class)).query(null, Restrictions.eq((String)"OIDEMPLOYEE", (String)this.getObjectid()));
        return successor.length > 0;
    }

    public Master[] getLinkedActiveEffectiveMasterHistory() {
        ArrayList<Master> result = new ArrayList<Master>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getMasterHistory().getItems(VDate.getDateMax());
            for (Master each : items) {
                result.add(each);
            }
        }
        return this.listToMasterArray(result);
    }

    public Master[] getLinkedAllMasterHistory() {
        ArrayList<Master> result = new ArrayList<Master>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getMasterHistory().getAll();
            for (Master each : items) {
                result.add(each);
            }
        }
        return this.listToMasterArray(result);
    }

    public Employment[] getLinkedActiveEffectiveEmploymentHistory() {
        ArrayList<Employment> result = new ArrayList<Employment>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getEmploymentHistory().getItems(VDate.getDateMax());
            for (Employment each : items) {
                result.add(each);
            }
        }
        return this.listToEmploymentArray(result);
    }

    public Employment[] getLinkedAllEmploymentHistory() {
        ArrayList<Employment> result = new ArrayList<Employment>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getEmploymentHistory().getAll();
            for (Employment each : items) {
                result.add(each);
            }
        }
        return this.listToEmploymentArray(result);
    }

    public Tax[] getLinkedActiveEffectiveTaxHistory() {
        ArrayList<Tax> result = new ArrayList<Tax>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getTaxHistory().getItems(VDate.getDateMax());
            for (Tax each : items) {
                result.add(each);
            }
        }
        return this.listToTaxArray(result);
    }

    public Tax[] getLinkedAllTaxHistory() {
        ArrayList<Tax> result = new ArrayList<Tax>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getTaxHistory().getAll();
            for (Tax each : items) {
                result.add(each);
            }
        }
        return this.listToTaxArray(result);
    }

    public Insurance[] getLinkedActiveEffectiveInsuranceHistory() {
        ArrayList<Insurance> result = new ArrayList<Insurance>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getInsuranceHistory().getItems(VDate.getDateMax());
            for (Insurance each : items) {
                result.add(each);
            }
        }
        return this.listToInsuranceArray(result);
    }

    public Insurance[] getLinkedAllInsuranceHistory() {
        ArrayList<Insurance> result = new ArrayList<Insurance>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            List items = employee.getInsuranceHistory().getAll();
            for (Insurance each : items) {
                result.add(each);
            }
        }
        return this.listToInsuranceArray(result);
    }

    public TotalEmploymentRelationship[] getTotalEmploymentRelationship() throws BusinessDomainException {
        return this.getTotalEmploymentRelationship(VDate.getDateMax());
    }

    public TotalEmploymentRelationship[] getTotalEmploymentRelationship(Date effectiveTimePoint) throws BusinessDomainException {
        ArrayList<TotalEmploymentRelationship> result = new ArrayList<TotalEmploymentRelationship>();
        for (Employee employee : this.getAllPredecessorAndSuccessor()) {
            Employment[] employments = employee.getEffectiveEmploymentHistory(effectiveTimePoint);
            if (employments.length == 0) continue;
            Arrays.sort(employments, new EmploymentComparator());
            if (employments.length == 1) {
                result.add(new TotalEmploymentRelationship(employee.getPersonnelnumber(), employments[0].getDateOfEntry(), employments[0].getDateOfWithDrawal()));
                continue;
            }
            for (int i = 1; i < employments.length; ++i) {
                if (DateHelper.equal((Date)employments[i - 1].getDateOfEntry(), (Date)employments[i].getDateOfEntry())) continue;
                result.add(new TotalEmploymentRelationship(employee.getPersonnelnumber(), employments[i - 1].getDateOfEntry(), employments[i - 1].getDateOfWithDrawal()));
            }
            result.add(new TotalEmploymentRelationship(employee.getPersonnelnumber(), employments[employments.length - 1].getDateOfEntry(), employments[employments.length - 1].getDateOfWithDrawal()));
        }
        return result.toArray(new TotalEmploymentRelationship[result.size()]);
    }

    public void taxChangeNotAllowed(int monthOfJournalizedUntil, int yearOfValidFrom, int yearOfJournalizedUntil, Tax oldTax, Tax newTax) throws BusinessDomainException {
        if (yearOfValidFrom < yearOfJournalizedUntil && !this.taxChangedAllowed(oldTax, newTax)) {
            throw EmployeeExceptionMapper.makeChangeOfTaxNotAllowedDomainException();
        }
    }

    public boolean taxChangedAllowed(Tax old, Tax tax) {
        return false;
    }

    public void specialCheckLowWageUpperLimit() throws BusinessDomainException {
    }

    public void specialCheckLumpSumAndPersongroup(Insurance insurance, TaxacationEnum taxacation, Date checkDate) throws BusinessDomainException {
        if (taxacation == TaxacationEnum.TE_PAUSCHAL_EINHEITLICHE_PAUSCHSTEUER_GFB) {
            HealthFundTP hftp;
            if (insurance.getPersonGroup() != 109) {
                throw EmployeeExceptionMapper.makePauschsteuerGfBNotAllowedDomainException();
            }
            if (InsuranceCheckUp.isActuallyPgs109(insurance) && insurance.getHealthFund() != null && (StringMapper.equal((String)(hftp = insurance.getHealthFund().getHealthFundTP(VDate.getDateMax(), checkDate)).getStandardCompanyNumber(), (String)"98000006") || StringMapper.equal((String)hftp.getStandardCompanyNumber(), (String)"99300933 "))) {
                return;
            }
            if (InsuranceCheckUp.isActuallyPgs109(insurance)) {
                throw EmployeeExceptionMapper.makePauschsteuerGfBNotAllowedDomainException();
            }
        }
        if ((taxacation == TaxacationEnum.TE_PAUSCHAL_KURZFRISTIGE_BESCHAEFTIGUNG || taxacation == TaxacationEnum.TE_PAUSCHAL_GERINGFUEGIGE_BESCHAEFTIGUNG) && InsuranceCheckUp.isActuallyPgs109(insurance)) {
            throw EmployeeExceptionMapper.makePauschsteuer20Or25NotAllowedDomainException();
        }
    }

    public boolean isUseMfaRequired() throws BusinessDomainException {
        Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
        if (!configuration.isEnableMFASelfService()) {
            return false;
        }
        CompanySettings companySettings = this.getPCompany().getActiveCompanySettings();
        if (!companySettings.getUseMfaForService()) {
            return false;
        }
        if (configuration.isEnableMFASelfServiceEmployee()) {
            return this.isUseMfa();
        }
        return true;
    }

    public boolean isUseMfa() throws BusinessDomainException {
        return !this.getMaster(VDate.getDateMax(), VDate.getDateMax()).getNoUseMfaForService();
    }

    public String getMfaSecret() throws BusinessDomainException {
        return this.getMaster(VDate.getDateMax(), VDate.getDateMax()).getMfaSecret();
    }

    public void saveMfa(boolean useMfa, String mfaSecret) throws BusinessDomainException {
        Master master = this.getActiveMaster();
        master.setNoUseMfaForService(!useMfa);
        master.setMfaSecret(PasswordHelper.encrypt((PasswordHelper.EncryptionType)PasswordHelper.EncryptionType.BLOWFISH, (String)(this.mPersonnelnumber + "|@\u00a0@|" + mfaSecret)));
        master.makeSaveable();
        this.setMasterHistory(master, false, master.getEffectiveFrom());
    }

    public void saveMfa(boolean useMfa) throws BusinessDomainException {
        Master master = this.getActiveMaster();
        master.setNoUseMfaForService(!useMfa);
        master.makeSaveable();
        this.setMasterHistory(master, false, master.getEffectiveFrom());
    }

    public void resetMfaSecret() throws BusinessDomainException {
        Master master = this.getActiveMaster();
        master.setMfaSecret(null);
        master.makeSaveable();
        this.setMasterHistory(master, false, master.getEffectiveFrom());
    }

    public boolean isSelfserviceAdmin() throws BusinessDomainException {
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        if (StringMapper.isNullString((String)pb.getEmployeeSelfServiceAdmin())) {
            return false;
        }
        return StringMapper.equal((String)pb.getEmployeeSelfServiceAdmin(), (String)this.getIDString());
    }

    public WorkingTime getAppurtenantWorkingTime(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantWorkingTime((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public WorkingTimeTP getWorkingTimeTP(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantWorkingTimeTP((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public WorkingTime getAssociatedWorkingTime(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAssociatedWorkingTime((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public WorkingTimeTP getAssociatedWorkingTimeTP(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAssociatedWorkingTimeTP((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public BigDecimal getWeeklyWorkingTime(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getWeeklyWorkingTime((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public GeneralEmploymentOffice getAppurtenantEmploymentOffice(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantEmploymentOffice((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public GeneralEmploymentOffice getAppurtenantEmploymentOfficeForKug(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantEmploymentOfficeForKug((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public GeneralCommunity getAppurtenantCommunity(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantCommunity((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public Foundations getAppurtenantFoundations(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantFoundations((Employee)this, (Date)effectiveFrom, (Date)validFrom);
    }

    public void checkAssociationEE(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        EmployeeHelper.checkAssociationEE((Employee)this, (Date)effectiveFrom, (Date)validFrom);
    }

    public void specialCheckAssociationEE(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
    }

    public void checkNIChildEducationAndChildRelief(Tax tax, Date validFrom) throws BusinessDomainException {
        Insurance insurance = (Insurance)this.getInsuranceHistory().getItemOrNull(VDate.getDateMax(), validFrom);
        if (insurance != null) {
            if (insurance.getPersonGroup() >= 981 && insurance.getPersonGroup() <= 999 || insurance.getDuesGroupHI() == 0 || insurance.getDuesGroupHI() == 6) {
                return;
            }
            if (!insurance.getNIChildEducation() && !BigDecimalMapper.isZeroOrNull((BigDecimal)tax.getChildRelief())) {
                throw EmployeeExceptionMapper.makeChildReliefExistsDomainException(insurance.getValidFrom(), tax.getValidFrom());
            }
        }
    }

    public Plant getAppurtenantPlant(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantPlant((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public String getAppurtenantLawArea(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantLawArea((Employee)this, (Date)effectiveFrom, (Date)validFrom);
    }

    public ERAModel getAppurtenantERAModel(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantERAModel((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public PayScaleLevel[] getAppurtenantERAPayScaleLevels(Date effectiveTimePoint, Date validTimePoint, ChoiceOfERAPaymentEnum choiceOfERAPayment) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantERAPayScaleLevels((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint, (ChoiceOfERAPaymentEnum)choiceOfERAPayment);
    }

    public Settings getAppurtenantSettings(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return EmployeeHelper.getAppurtenantSettings((Employee)this, (Date)effectiveFrom, (Date)validFrom);
    }

    public HealthFund getAssessmentHealthFund(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        return EmployeeHelper.getAssessmentHealthFund((Employee)this, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public boolean noCheckForEvPT() throws BusinessDomainException {
        DEUVSender deuvSender = DeuvHelper.getDeuvSender((PCompany)this.getPCompany());
        return deuvSender != null && deuvSender.isTestSender();
    }

    public boolean noCheckForInsolvencyCompany() throws BusinessDomainException {
        StatusByInsolvencyEnum statusByInsolvency = this.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getFoundations().getStatusByInsolvency();
        return statusByInsolvency == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || statusByInsolvency == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN;
    }

    public boolean isBeforeOrEqualMinDateOfRetroactiveCalculation(Date comparisonDate) throws BusinessDomainException {
        return DateHelper.beforeOrEqual((Date)comparisonDate, (Date)this.getMinDateOfRetroactiveCalculation());
    }

    public boolean isBeforeMinDateOfRetroactiveCalculation(Date comparisonDate) throws BusinessDomainException {
        return DateHelper.before((Date)comparisonDate, (Date)this.getMinDateOfRetroactiveCalculation());
    }

    public Date getMinDateOfRetroactiveCalculation() throws BusinessDomainException {
        int months = this.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getMonthsOfCalculation();
        return DateHelper.getFirstDayOfMonth((Date)new VDate(this.getJournalizedUntil()).addMonths(months *= -1).getDate());
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private IMasterPersistencyManager getIMasterPM() {
        return (IMasterPersistencyManager)UtilitiesManager.getBean((String)"masterPersistencyManager", IMasterPersistencyManager.class);
    }

    private ITaxPersistencyManager getITaxPM() {
        return (ITaxPersistencyManager)UtilitiesManager.getBean((String)"taxPersistencyManager", ITaxPersistencyManager.class);
    }

    private IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }

    private IInsuranceChildPersistencyManager getIInsuranceChildPM() {
        return (IInsuranceChildPersistencyManager)UtilitiesManager.getBean((String)"insuranceChildPersistencyManager", IInsuranceChildPersistencyManager.class);
    }

    private IFixedPaymentPersistencyManager getIFixedPaymentPM() {
        return (IFixedPaymentPersistencyManager)UtilitiesManager.getBean((String)"fixedPaymentPersistencyManager", IFixedPaymentPersistencyManager.class);
    }

    private IEEBankDetailsPersistencyManager getIEEBankDetailsPM() {
        return (IEEBankDetailsPersistencyManager)UtilitiesManager.getBean((String)"eeBankDetailsPersistencyManager", IEEBankDetailsPersistencyManager.class);
    }

    private IEEBankDetailsTPPersistencyManager getIEEBankDetailsTPPM() {
        return (IEEBankDetailsTPPersistencyManager)UtilitiesManager.getBean((String)"eeBankDetailsTPPersistencyManager", IEEBankDetailsTPPersistencyManager.class);
    }

    private IEEWageFactorPersistencyManager getIEEWageFactorPM() {
        return (IEEWageFactorPersistencyManager)UtilitiesManager.getBean((String)"eeWageFactorPersistencyManager", IEEWageFactorPersistencyManager.class);
    }

    private IEmploymentPersistencyManager getEmploymentPM() {
        return (IEmploymentPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("employmentPersistencyManager", IEmploymentPersistencyManager.class);
    }

    private IEESkillPersistencyManager getIEESkillPM() {
        return (IEESkillPersistencyManager)UtilitiesManager.getBean((String)"eeSkillPersistencyManager", IEESkillPersistencyManager.class);
    }

    private IEERelativePersistencyManager getIEERelativePM() {
        return (IEERelativePersistencyManager)UtilitiesManager.getBean((String)"eeRelativePersistencyManager", IEERelativePersistencyManager.class);
    }

    private static IAagDsraPersistencyManager getIAagDsraPM() {
        return (IAagDsraPersistencyManager)UtilitiesManager.getBean((String)"aagDsraPersistencyManager", IAagDsraPersistencyManager.class);
    }

    private static IEelAccountPersistencyManager getIEelAccountPM() {
        return (IEelAccountPersistencyManager)UtilitiesManager.getBean((String)"eelAccountPersistencyManager", IEelAccountPersistencyManager.class);
    }

    private static ILStBAccountPersistencyManager getILStBAccountPM() {
        return (ILStBAccountPersistencyManager)UtilitiesManager.getBean((String)"lStBAccountPersistencyManager", ILStBAccountPersistencyManager.class);
    }

    private IEEAccidentInsuranceFundPersistencyManager getEEAccidentInsuranceFundPM() {
        return (IEEAccidentInsuranceFundPersistencyManager)UtilitiesManager.getBean((String)"eeAccidentInsuranceFundPersistencyManager", IEEAccidentInsuranceFundPersistencyManager.class);
    }

    private IEESuccessorPersistencyManager getIEESuccessorPM() {
        return (IEESuccessorPersistencyManager)UtilitiesManager.getBean((String)"eeSuccessorPersistencyManager", IEESuccessorPersistencyManager.class);
    }

    private IEECarriedForwardZVKPersisitencyManager getEECarriedForwardZVKPM() {
        return (IEECarriedForwardZVKPersisitencyManager)UtilitiesManager.getGenericAccessor().getBean("eeCarriedForwardZVKPersisitencyManager", IEECarriedForwardZVKPersisitencyManager.class);
    }

    private SchedulerService getSchedulerService() {
        return (SchedulerService)UtilitiesManager.getBean((String)"schedulerService", SchedulerService.class);
    }

    private static IAEinsAccountPersistencyManager getIAEinsAccountPM() {
        return (IAEinsAccountPersistencyManager)UtilitiesManager.getBean((String)"aEinsAccountPersistencyManager", IAEinsAccountPersistencyManager.class);
    }

    private static IEauAccountPersistencyManager getIEauAccountPM() {
        return (IEauAccountPersistencyManager)UtilitiesManager.getBean((String)"eauAccountPersistencyManager", IEauAccountPersistencyManager.class);
    }

    private static BeaAccountPersistencyManager getBeaAccountPM() {
        return (BeaAccountPersistencyManager)UtilitiesManager.getBean((String)"beaAccountPersistencyManager", BeaAccountPersistencyManager.class);
    }
}

