/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eel;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.DeuvBasicComponents;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.IDbanData;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.eel.EelCompany;
import com.varial.personnel.domain.eel.eelaccount.EelAccount;
import com.varial.personnel.domain.eel.eeldbae.EelDbae;
import com.varial.personnel.domain.eel.eeldbal.EelDbal;
import com.varial.personnel.domain.eel.eeldbap.EelDbap;
import com.varial.personnel.domain.eel.eeldbaw.EelDbaw;
import com.varial.personnel.domain.eel.eeldbbe.EelDbbe;
import com.varial.personnel.domain.eel.eeldbee.EelDbee;
import com.varial.personnel.domain.eel.eeldbfe.EelDbfe;
import com.varial.personnel.domain.eel.eeldbfr.EelDbfr;
import com.varial.personnel.domain.eel.eeldbhe.EelDbhe;
import com.varial.personnel.domain.eel.eeldbid.EelDbid;
import com.varial.personnel.domain.eel.eeldblt.EelDblt;
import com.varial.personnel.domain.eel.eeldbmu.EelDbmu;
import com.varial.personnel.domain.eel.eeldbsd.EelDbsd;
import com.varial.personnel.domain.eel.eeldbtk.EelDbtk;
import com.varial.personnel.domain.eel.eeldbun.EelDbun;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvo;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvoPart;
import com.varial.personnel.domain.eel.eeldbza.EelDbza;
import com.varial.personnel.domain.eel.eeldslw.EelDslw;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.util.Date;

public final class EelComponents {
    private EelComponents() {
    }

    public static String getContentEelDslw(EelDslw dslw) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DSLW", (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"LEIST", (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getBbnrAbsender(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getBbnrEmpfaenger(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dslw.getEelVersion(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dslw.getDatumErstellung(), (int)20);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dslw.getFehlerKennz(), (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dslw.getFehlerAnzahl(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getVersicherungsnr(), (int)12);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dslw.getGeburtsDat(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getBbnrVU(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getDatensatzId(), (int)36);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getProdId(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getModId(), (int)8);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"", (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getBbnrKK(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getBbnrAS(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dslw.getRueckEntgeltErsatz(), (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dslw.getAbgabegrund(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dslw.getKorrabgabegrund(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dslw.getAbrechnungsprogramm(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbna() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDban() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbal() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbae() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbza() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbee() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbaw() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbfr() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbun() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbmu() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbvo() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbhe() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbbe() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDblt() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbsf() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbtk() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbap() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbid() ? "J" : "N"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(dslw.hasMmDbsd() ? "J" : "N"), (int)1);
        if (dslw.hasMmDbna()) {
            builder.append(DeuvBasicComponents.getContentDbna((IDbnaData)dslw.getDbna().getDbnaData()));
        }
        if (dslw.hasMmDban()) {
            builder.append(DeuvBasicComponents.getContentDban((IDbanData)dslw.getDban().getDbanData()));
        }
        if (dslw.hasMmDbal()) {
            EelDbal dbal = dslw.getDbal();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBAL", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getDatumAb(), (int)8);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbal.getAeErstTag(), (int)1);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getDatumEgzBis(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getEndeBvAm(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getEndeBvZum(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbal.getGrundBeend(), (int)2);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbal.getPflZuschlag(), (int)1);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbal.getKinderunter25(), (int)1);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbal.getArbzeitMod(), (int)1);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbal.getMmKug(), (int)1);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getKugBeginn(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getKugEnde(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getLagBeginn1(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getLagEnde1(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getLagBeginn2(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbal.getLagEnde2(), (int)8);
        }
        if (dslw.hasMmDbae()) {
            EelDbae dbae = dslw.getDbae();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBAE", (int)4);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getWaehrEelBrutto(), (int)8);
            if (dbae.getDatumAeBis() != null && VDate.isDateMax((Date)dbae.getDatumAeBis())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getDatumAeBis(), (int)8);
            }
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getEazBeginn1(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getEazEnde1(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getBrutto1(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getNetto1(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getUmgewae(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbae.getEntgArt(), (int)1);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getBruttoAe(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getNettoAe(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getEazBeginn2(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getEazEnde2(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getBrutto2(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getNetto2(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getEazBeginn3(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbae.getEazEnde3(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getBrutto3(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getNetto3(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getEzkv(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getEzrv(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbae.getEzalv(), (int)8);
        }
        if (dslw.hasMmDbza()) {
            EelDbza dbza = dslw.getDbza();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBZA", (int)4);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbza.getAnzahlStd(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbza.getRegAz(), (int)4);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbza.getMazr1(), (int)5);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbza.getAzBeginn2(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbza.getAzEnde2(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbza.getMazr2(), (int)5);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbza.getAzBeginn3(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbza.getAzEnde3(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbza.getMazr3(), (int)5);
        }
        if (dslw.hasMmDbee()) {
            EelDbee dbee = dslw.getDbee();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBEE", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbee.getEelAbAg(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbee.getEelAbSv(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbee.getEelEnde(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbee.getEelEndeGrund(), (int)2);
        }
        if (dslw.hasMmDbaw()) {
            EelDbaw dbaw = dslw.getDbaw();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBAW", (int)4);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbaw.getTage1(), (int)2);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbaw.getTage2(), (int)2);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbaw.getTage3(), (int)2);
        }
        if (dslw.hasMmDbfr()) {
            EelDbfr dbfr = dslw.getDbfr();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBFR", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbfr.getEndeBvZum(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbfr.getFreiStVom(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbfr.getFreiStBis(), (int)8);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbfr.getVaeErstTag(), (int)1);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbfr.getTage(), (int)2);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbfr.getKeineFreiSt(), (int)1);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbfr.getBegrzFreiSt(), (int)2);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbfr.getBezFreiStVom(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbfr.getBezFreiStBis(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbfr.getBezFreiStJahr(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbfr.getFreiStBrutto(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbfr.getFreiStNetto(), (int)8);
            if (dslw.getAbgabegrund() == 73) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
            } else {
                DeuvBasicComponents.append((StringBuilder)builder, (String)dbfr.getFreiStEz(), (int)1);
            }
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbfr.getKinderunter25(), (int)1);
        }
        if (dslw.hasMmDbun()) {
            EelDbun dbun = dslw.getDbun();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBUN", (int)4);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbun.getUnfallAz(), (int)20);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbun.getVtag(), (int)8);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbun.getIkuv(), (int)15);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbun.getZuschl1(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbun.getZuschl2(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbun.getZuschl3(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbun.getFreistZuschl(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbun.getEzuv(), (int)8);
        }
        if (dslw.hasMmDbmu()) {
            EelDbmu dbmu = dslw.getDbmu();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBMU", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getSchutzfrBeginn(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getBvBeginn(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getLetztTag(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getEndebvAm(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getEndebvzUm(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getBvgeKuend(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getWaehrEelNetto(), (int)8);
            if (dbmu.getDatumAeBis() != null && VDate.isDateMax((Date)dbmu.getDatumAeBis())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getDatumAeBis(), (int)8);
            }
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getFehlZeit(), (int)2);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbmu.getAeUeber(), (int)1);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getEntgArt(), (int)1);
            if (dbmu.getBeginn1() != null && VDate.isDateMax((Date)dbmu.getBeginn1())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getBeginn1(), (int)8);
            }
            if (dbmu.getEnde1() != null && VDate.isDateMax((Date)dbmu.getEnde1())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getEnde1(), (int)8);
            }
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getBezAz1(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getMaStd1(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzunEntStd1(), (int)5);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getAzunEntTage1(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzEntschStd1(), (int)5);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getAzEntschTage1(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getNetto1(), (int)8);
            if (dbmu.getBeginn2() != null && VDate.isDateMax((Date)dbmu.getBeginn2())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getBeginn2(), (int)8);
            }
            if (dbmu.getEnde2() != null && VDate.isDateMax((Date)dbmu.getEnde2())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getEnde2(), (int)8);
            }
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getBezAz2(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getMaStd2(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzunEntStd2(), (int)5);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getAzunEntTage2(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzEntschStd2(), (int)5);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getAzEntschTage2(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getNetto2(), (int)8);
            if (dbmu.getBeginn3() != null && VDate.isDateMax((Date)dbmu.getBeginn3())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getBeginn3(), (int)8);
            }
            if (dbmu.getEnde3() != null && VDate.isDateMax((Date)dbmu.getEnde3())) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"99999999", (int)8);
            } else {
                DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbmu.getEnde3(), (int)8);
            }
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getBezAz3(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getMaStd3(), (int)5);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzunEntStd3(), (int)5);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getAzunEntTage3(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzEntschStd3(), (int)5);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbmu.getAzEntschTage3(), (int)2);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getNetto3(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbmu.getAzwWoech(), (int)4);
        }
        if (dslw.hasMmDbvo()) {
            EelDbvo dbvo = dslw.getDbvo();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBVO", (int)4);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbvo.getGrundAv(), (int)1);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvo.getAuAbag(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvo.getAuAbsv(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbvo.getKzAkau(), (int)1);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvo.getMonatsfristab(), (int)8);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbvo.getAnzahlAu(), (int)2);
            if (dbvo.getEelDbvoParts().length > 0) {
                EelDbvoPart[] eelDbvoPartArray = dbvo.getEelDbvoParts();
                int n = eelDbvoPartArray.length;
                for (int i = 0; i < n; ++i) {
                    EelDbvoPart dbvoPart = eelDbvoPartArray[i];
                    DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvoPart.getBeginnAu(), (int)8);
                    DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvoPart.getEndeAu(), (int)8);
                    DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbvoPart.getKzNachweis(), (int)1);
                    DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvoPart.getTeilNachweisAuBeginn(), (int)8);
                    DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvoPart.getTeilNachweisAuEnde(), (int)8);
                    DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbvoPart.getKzAu(), (int)1);
                    DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvoPart.getTeilAnrAuBeginn(), (int)8);
                    DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbvoPart.getTeilAnrAuEnde(), (int)8);
                }
            }
        }
        if (dslw.hasMmDbhe()) {
            EelDbhe dbhe = dslw.getDbhe();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBHE", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbhe.getZahlBeginn(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbhe.getEelBrutto(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbhe.getEelNetto(), (int)8);
        }
        if (dslw.hasMmDbbe()) {
            EelDbbe dbbe = dslw.getDbbe();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBBE", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbbe.getZahlBeginn(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbbe.getBeitrPflBrutto(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbbe.getBeitrPflNetto(), (int)8);
        }
        if (dslw.hasMmDblt()) {
            EelDblt dblt = dslw.getDblt();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBLT", (int)4);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dblt.getBvSeit(), (int)8);
            DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dblt.getBvBis(), (int)8);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dblt.getBvAls(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dblt.getAusbVerh(), (int)1);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dblt.getVorer(), (int)1);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dblt.getVwl(), (int)6);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dblt.getBruttoSb(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dblt.getNettoSb(), (int)8);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dblt.getAeUebergangsbereich(), (int)1);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dblt.getRechtskreis(), (int)1);
        }
        if (dslw.hasMmDbtk()) {
            EelDbtk dbtk = dslw.getDbtk();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBTK", (int)4);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbtk.getBruttoSoll(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbtk.getNettoSoll(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbtk.getTransferKug(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbtk.getBruttoIst(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbtk.getNettoIst(), (int)8);
            DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbtk.getAufstockBetrag(), (int)8);
        }
        if (dslw.hasMmDbap()) {
            EelDbap dbap = dslw.getDbap();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBAP", (int)4);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getNameap(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getTelap(), (int)20);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getFaxap(), (int)20);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getEmailap(), (int)70);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getName1(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getName2(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getName3(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getPlz(), (int)10);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getCity(), (int)34);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getStreet(), (int)33);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbap.getNumber(), (int)9);
        }
        if (dslw.hasMmDbid()) {
            EelDbid dbid = dslw.getDbid();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBID", (int)4);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbid.getAktenzeichenSv(), (int)20);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbid.getAktenzeichenVu(), (int)20);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbid.getReferenzId(), (int)36);
        }
        if (dslw.hasMmDbsd()) {
            EelDbsd dbsd = dslw.getDbsd();
            DeuvBasicComponents.append((StringBuilder)builder, (String)"DBSD", (int)4);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbsd.getDatensatzidursprung(), (int)36);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbsd.getVorname(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbsd.getFamilienname(), (int)30);
            DeuvBasicComponents.append((StringBuilder)builder, (String)dbsd.getAktenzeichenVu(), (int)20);
        }
        if (dslw.hasMmDbfe()) {
            for (EelDbfe dbfe : dslw.getDbfe()) {
                DeuvBasicComponents.append((StringBuilder)builder, (String)"DBFE", (int)4);
                DeuvBasicComponents.append((StringBuilder)builder, (String)dbfe.getFehler(), (int)72);
            }
        }
        return builder.toString();
    }

    public static String getContentVoszForCheck(EelAccount account, EelCompany eelCompany) throws BusinessDomainException {
        StringBuilder b = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)b, (String)"VOSZ", (int)4);
        DeuvBasicComponents.append((StringBuilder)b, (String)"AGEEL", (int)5);
        DeuvBasicComponents.append((StringBuilder)b, (String)eelCompany.getDeuvSenderStdCompNo(), (int)15);
        DeuvBasicComponents.append((StringBuilder)b, (String)account.getDEUVRecipient().getActiveDEUVRecipientTP().getStdCompanyNumber(), (int)15);
        DeuvBasicComponents.append((StringBuilder)b, (String)account.getCreatedOn(), (int)8);
        DeuvBasicComponents.appNum((StringBuilder)b, (int)account.getDEUVRecipient().getActiveDEUVRecipientTP().getFileNumberEEL(), (int)6);
        DeuvBasicComponents.append((StringBuilder)b, (String)eelCompany.getDeuvSenderName(), (int)50);
        DeuvBasicComponents.append((StringBuilder)b, (String)"01", (int)2);
        return b.toString();
    }

    public static String getDskoForCheck(EelAccount account, EelCompany eelCompany, String createOnString) throws BusinessDomainException {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DSKO", (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"LEIST", (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderStdCompNo(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)account.getDEUVRecipient().getActiveDEUVRecipientTP().getStdCompanyNumber(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"04", (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)createOnString, (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderStdCompNo(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)DeuvBasics.getProdId(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)DeuvBasics.getModId(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderName(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderAddress().getPostalCode(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderAddress().getCity(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderAddress().getStreet(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getDeuvSenderPersonSex(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getCommunication().getContactPerson(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getCommunication().getTelephoneNumber(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getCommunication().getFaxNumber(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)eelCompany.getCommunication().getEMailAddress(), (int)70);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)5);
        return builder.toString();
    }
}

