/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.accidentinsurancefundvaluetype.AccidentInsuranceFundValuetype;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.deuv.COR;
import com.varial.personnel.domain.deuv.DateInterval;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuv.deuvaccount.UVRiskPeriod;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdbuv.DEUVDbuv;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsme;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.accidentinsurancefund.EEAccidentInsuranceFund;
import com.varial.personnel.domain.employee.carriedforward.system.accidentinsurancefund.EECarriedForwardSystemAI;
import com.varial.personnel.domain.employee.carriedforward.system.accidentinsurancefund.partclassofrisk.CFAIPartClassOfRisk;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSIPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.partclassofrisk.CFPartClassOfRisk;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.uv.UvEmployee;
import com.varial.personnel.domain.uv.dssd.UvDssd;
import com.varial.personnel.domain.uv.dssd.dbgt.UvDssdDbgt;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class DbuvEmployee
extends UvEmployee<DbuvEmployee> {
    private static final Date START_OF_REASON_92 = DateMapper.toDate((String)"2015-01-01");
    private static final Date START_OF_DSSD_CHECK = DateMapper.toDate((String)"2017-01-01");
    private static final int MAXIMUM_COUNT_OF_COR = 9;
    private final DEUVAdvice mDeuvAdvice;
    private final List<DEUVAccount> mCreateds;
    private final List<DEUVAccount> mResult;

    public DbuvEmployee(DEUVAdvice advice, Employee employee) {
        super(employee, advice.isPreview());
        this.mDeuvAdvice = advice;
        this.mCreateds = new ArrayList<DEUVAccount>();
        this.mResult = new ArrayList<DEUVAccount>();
    }

    protected DbuvEmployee createUvEmployee(Employee employee) {
        return new DbuvEmployee(this.mDeuvAdvice, employee);
    }

    protected Date getCalculationStart() throws BusinessDomainException {
        return this.mDeuvAdvice.getCalculationStart();
    }

    public AccidentInsuranceFundValuetype[] getAifValueTypes(AssignmentPCompanyAccidentInsuranceFundTP tp) {
        return this.getAdvice().getAifValueTypes(tp);
    }

    protected boolean isCFValid(CFPartClassOfRisk[] pCors, Date validTP, Date startCf) throws BusinessDomainException {
        boolean result = true;
        if (DateHelper.afterOrEqual((Date)startCf, (Date)START_OF_DSSD_CHECK)) {
            Plant plant = this.mEmployee.getEmployment(this.getEffectiveDate(), validTP).getPlant();
            for (CFPartClassOfRisk pCor : pCors) {
                if (DbuvEmployee.hasValidDssdForCf(this.mEmployee.getPCompany(), plant, validTP, startCf, pCor.getAccidentInsuranceFund(), pCor.getDifferentAccidentInsuranceFund(), pCor.getClassOfRisk())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected boolean hasCfClassOfRisk(Date year) throws BusinessDomainException {
        List cf = this.getCFClassOfRisks(DateHelper.getFirstDayOfYear((Date)year));
        return cf != null && !cf.isEmpty();
    }

    protected boolean useCFForPayment() {
        return true;
    }

    protected boolean isAssAifValid(Date validTP) {
        return true;
    }

    public void createAccounts() throws BusinessDomainException {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        while (DateHelper.beforeOrEqual((Date)startDate, (Date)endDate)) {
            Date firstDayOfYear = DateHelper.getFirstDayOfYear((Date)startDate);
            Date lastDayOfYear = DateHelper.getLastDayOfYear((Date)startDate);
            List uvMonths = this.getUvMonths(startDate, DateHelper.min((Date)endDate, (Date)lastDayOfYear));
            if ((!uvMonths.isEmpty() || this.hasCfClassOfRisk(firstDayOfYear)) && this.isMaster(firstDayOfYear, lastDayOfYear)) {
                List cors = this.createClassOfRisks(startDate, uvMonths);
                this.getUvMonths().addAll(uvMonths);
                this.addSameEmployees(cors, firstDayOfYear, lastDayOfYear);
                DbuvEmployee.updateCors(this, this.mDeuvAdvice, cors, lastDayOfYear);
                if (!cors.isEmpty()) {
                    DEUVAccount account92 = this.createReason92(firstDayOfYear, lastDayOfYear);
                    DbuvEmployee.createDbuvs(account92.getDEUVDsme(), cors, lastDayOfYear);
                    this.mCreateds.add(account92);
                    this.mDeuvAdvice.updateAifDate(account92);
                }
            }
            startDate = PDateHelper.getFirstDayNextYear((Date)startDate);
        }
    }

    private Date getStartDate() throws BusinessDomainException {
        return DateHelper.max((Date[])new Date[]{START_OF_REASON_92, this.mDeuvAdvice.getCalculationHistoric(), this.getMinimumDateOfEntryJournalized()});
    }

    private Date getMinimumDateOfEntryJournalized() {
        Date minimumDateOfEntry = VDate.getDateMax();
        for (Employment each : this.mEmployee.getEmploymentHistory(this.getJournalizedUntil())) {
            minimumDateOfEntry = DateHelper.min((Date)minimumDateOfEntry, (Date)each.getDateOfEntry());
        }
        return minimumDateOfEntry;
    }

    private Date getEndDate() throws BusinessDomainException {
        Date endJournalized = new VDate(this.getJournalizedUntil()).addYears(-1).getDate();
        endJournalized = DateHelper.getLastDayOfYear((Date)endJournalized);
        if (this.isTerminationOfBusiness() || this.isInsolventCompany()) {
            endJournalized = this.getJournalizedUntil();
        }
        return endJournalized;
    }

    private boolean isTerminationOfBusiness() throws BusinessDomainException {
        Date withdrawal;
        boolean result = false;
        Date termination = this.mDeuvAdvice.getTerminationDate();
        if (termination != null && (withdrawal = this.mEmployee.getLastDateOfWithdrawal()) != null) {
            result = DateHelper.beforeOrEqual((Date)withdrawal, (Date)termination) && DateHelper.afterOrEqual((Date)this.getJournalizedUntil(), (Date)termination);
        }
        return result;
    }

    private boolean isInsolventCompany() throws BusinessDomainException {
        Date withdrawal;
        boolean result = false;
        Date insolvency = this.mDeuvAdvice.getInsolvencyDate();
        if (insolvency != null && (withdrawal = this.mEmployee.getLastDateOfWithdrawal()) != null) {
            result = DateHelper.beforeOrEqual((Date)withdrawal, (Date)insolvency) && DateHelper.afterOrEqual((Date)this.getJournalizedUntil(), (Date)insolvency);
        }
        return result;
    }

    private DEUVAccount createReason92(Date validFrom, Date validUntil) throws BusinessDomainException {
        DEUVAccount account92 = new DEUVAccount();
        account92.setEmployee(this.mEmployee);
        account92.setEffectiveFrom(DateHelper.getFirstDayOfMonth((Date)this.getJournalizedUntil()));
        account92.setValidFrom(validUntil);
        account92.setValidUntil(validUntil);
        account92.setCreatedOn(this.mDeuvAdvice.getCreatedOn());
        account92.setCanceled("N");
        account92.setLongReasonOfDeliv("92");
        account92.setReasonOfDelivery(92);
        account92.setDEUVSender(this.mDeuvAdvice.getDEUVSender());
        account92.setDEUVRecipient(this.getDEUVRecipient());
        account92.setInsuranceNo(this.getInsuranceNo());
        String bbnrHealthFund = this.isBestandsschutz2022() ? this.mDeuvAdvice.getMinijobStdCompanyNo() : this.getHealthFundTp(validUntil).getStandardCompanyNumber();
        DEUVDsme dsme = account92.createDEUVDsme(bbnrHealthFund);
        dsme.setStaat("");
        DEUVDbme dbme = dsme.createDbme();
        dbme.setBeginn(validFrom);
        dbme.setEnde(validUntil);
        dbme.setGleitzone("0");
        dbme.setTaetigkeitssl("");
        account92.update(dsme, dbme);
        return account92;
    }

    private static void restrict(List<COR> cors) {
        if (cors.size() > 9) {
            Collections.sort(cors, new Comparator<COR>(){

                @Override
                public int compare(COR o1, COR o2) {
                    int cmp = BigDecimalMapper.compareTo((BigDecimal)o1.getPayment(), (BigDecimal)o2.getPayment());
                    if (cmp == 0) {
                        cmp = o1.getCor().compareTo(o2.getCor());
                    }
                    if (cmp == 0) {
                        cmp = o1.getAif().getObjectid().compareTo(o2.getAif().getObjectid());
                    }
                    return -cmp;
                }
            });
            while (cors.size() > 9) {
                cors.remove(cors.get(cors.size() - 1));
            }
        }
    }

    private static void createDbuvs(DEUVDsme dsme, List<COR> cors, Date validTimePoint) throws BusinessDomainException {
        ArrayList<DEUVDbuv> dbuvs = new ArrayList<DEUVDbuv>();
        for (COR cor : cors) {
            DEUVDbuv dbuv = dsme.createDbuv();
            dbuv.setAnzahlUV(String.valueOf(cors.size()));
            dbuv.setBbnrUV(DbuvEmployee.getBbnr(cor.getAif(), validTimePoint));
            if (DateHelper.afterOrEqual((Date)validTimePoint, (Date)DEUVAdvice.START_OF_2023)) {
                dbuv.setUnrs(cor.getUnrs());
            } else {
                dbuv.setMitgliedsNr(cor.getMembershipNr());
            }
            if (cor.getAifCor() != null) {
                dbuv.setBbnrGTS(DbuvEmployee.getBbnr(cor.getAifCor(), validTimePoint));
            }
            dbuv.setGtStelle(cor.getCor());
            dbuv.setUvEntgelt(cor.getPayment());
            dbuv.setUVGrund(cor.getUvReason());
            dbuv.setUVString1(cor.getPaymentDescription());
            dbuvs.add(dbuv);
        }
        if (!dbuvs.isEmpty()) {
            DEUVDbuv main = (DEUVDbuv)dbuvs.get(0);
            main.setUVRiskPeriods(dbuvs.toArray(new DEUVDbuv[dbuvs.size()]));
            dsme.getDEUVAccount().setDEUVDbuv(main);
        }
    }

    private static String getBbnr(AccidentInsuranceFund aif, Date validTimePoint) throws BusinessDomainException {
        return aif.getAccidentInsuranceFundTP(VDate.getDateMax(), validTimePoint).getStdCompanyNoOfAccIns();
    }

    protected AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAIFTP(AccidentInsuranceFund aif, Plant plant, Date validTP) throws BusinessDomainException {
        return DbuvEmployee.getAssignmentPCompanyAIFTP(aif, plant, validTP, this.mDeuvAdvice);
    }

    private static AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAIFTP(AccidentInsuranceFund aif, Plant plant, Date validTP, DEUVAdvice deuvAdvice) throws BusinessDomainException {
        AssignmentPCompanyAccidentInsuranceFundTP tp = deuvAdvice.getAssignmentPCompanyAccidentInsuranceFundTP(aif, plant, validTP);
        if (tp == null) {
            throw EmployeeExceptionMapper.makeAccidentInsuranceFundIsNotAssignedDomainException(aif.getAccidentInsuranceFundKey(), DateHelper.getFirstDayOfMonth((Date)validTP));
        }
        return tp;
    }

    private DEUVRecipient getDEUVRecipient() throws BusinessDomainException {
        if (this.isBestandsschutz2022()) {
            return this.mDeuvAdvice.getBuknRecipient();
        }
        DEUVRecipient result = null;
        HealthFund healthFund = this.getLastHealthFund();
        if (healthFund != null) {
            result = this.mDeuvAdvice.getDEUVRecipient(healthFund);
        }
        return result;
    }

    private HealthFund getLastHealthFund() throws BusinessDomainException {
        HealthFund result = null;
        Insurance[] insurances = this.mEmployee.getInsuranceHistory(this.getJournalizedUntil());
        for (int i = insurances.length - 1; i >= 0; --i) {
            if (insurances[i].getHealthFund() == null) continue;
            result = insurances[i].getHealthFund();
            break;
        }
        if (result == null) {
            EECarriedForwardSystemSI[] eecf = this.getEECarriedForwardSystemSIs();
            for (int i = eecf.length - 1; i >= 0; --i) {
                if (eecf[i].getHealthFund() == null) continue;
                result = eecf[i].getHealthFund();
                break;
            }
        }
        return result;
    }

    private HealthFundTP getHealthFundTp(Date validTimePoint) throws BusinessDomainException {
        HealthFund healthFund = this.getLastHealthFund();
        if (healthFund == null) {
            throw EmployeeExceptionMapper.makeMissedHealthfundForDeuvDomainException();
        }
        healthFund = HealthFund.getHealthFundConsiderFusions((HealthFund)healthFund, (Date)validTimePoint);
        return healthFund.getHealthFundTP(VDate.getDateMax(), VDate.getDateMax());
    }

    private EECarriedForwardSystemSI[] getEECarriedForwardSystemSIs() {
        Criterion criterion = Restrictions.eq((String)"OIDEMPLOYEE", (String)this.mEmployee.getObjectid());
        Order[] sort = new Order[]{Order.asc((String)"VALIDFROM")};
        return EECarriedForwardSystemSIPersistencyManager.query((Order[])sort, (Criterion)criterion);
    }

    public boolean isBestandsschutz2022() throws BusinessDomainException {
        Insurance insurance = (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(this.getJournalizedUntil(), VDate.getDateMax());
        return insurance != null && insurance.getPersonGroup() == 109 && insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && insurance.getUseTransitionBy31122022();
    }

    private static List<COR> updateCors(DbuvEmployee dbuvEmployee, DEUVAdvice deuvAdvice, List<COR> cors, Date periodUntil) throws BusinessDomainException {
        DbuvEmployee.limitToYearlyUpperLimit(cors, periodUntil);
        DbuvEmployee.updateUvReasons(cors, dbuvEmployee, deuvAdvice);
        DbuvEmployee.restrict(cors);
        return cors;
    }

    protected static void limitToYearlyUpperLimit(List<COR> cors, Date year) throws BusinessDomainException {
        HashMap<AccidentInsuranceFund, BigDecimal> yearRemains = new HashMap<AccidentInsuranceFund, BigDecimal>();
        for (COR each : cors) {
            BigDecimal remain;
            AccidentInsuranceFund aif = each.getAif();
            if (!yearRemains.containsKey(aif)) {
                BigDecimal upperLimit = DbuvEmployee.getYearlyUpperLimit((AccidentInsuranceFund)aif, (Date)year);
                yearRemains.put(each.getAif(), upperLimit);
            }
            if ((remain = (BigDecimal)yearRemains.get(aif)) == null) continue;
            remain = DbuvEmployee.limitPayment((COR)each, (BigDecimal)remain);
            yearRemains.put(aif, remain);
        }
    }

    private static void updateUvReasons(List<COR> cors, DbuvEmployee dbuvEmployee, DEUVAdvice deuvAdvice) throws BusinessDomainException {
        for (COR cor : cors) {
            UvDssd dssd = deuvAdvice.getUvDssd(cor.getAif(), cor.getMembershipNr(), cor.getUnrs(), cor.getUntil());
            boolean isA09Dssd = dssd == null ? false : dssd.getBeitragsmassstab() > 1;
            String classOfRisk = cor.getCor();
            if (DbuvEmployee.isVirtualClassOfRisk((String)classOfRisk) || isA09Dssd) {
                if (DbuvEmployee.isA07((String)classOfRisk)) {
                    cor.setUvReason("A07");
                } else if (DbuvEmployee.isA08((String)classOfRisk)) {
                    cor.setUvReason("A08");
                } else if (DbuvEmployee.isA09((String)classOfRisk) || isA09Dssd) {
                    cor.setUvReason("A09");
                }
                cor.clear();
                continue;
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)DEUVAccount.truncate((BigDecimal)cor.getPayment()))) continue;
            if (dbuvEmployee != null && dbuvEmployee.isB01(cor)) {
                cor.setUvReason("B01");
            }
            if (StringMapper.isNullString((String)cor.getUvReason())) {
                cor.setUvReason("B09");
            }
            cor.setWorktime(BigDecimal.ZERO);
            cor.setPaymentDescription("");
        }
    }

    private boolean isB01(COR cor) throws BusinessDomainException {
        boolean result = false;
        Date start = cor.getFrom();
        while (DateHelper.before((Date)start, (Date)cor.getUntil())) {
            Insurance insurance = (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(this.getEffectiveDate(), start);
            if (insurance != null && insurance.getPersonGroup() == 103 && insurance.getBeginWorkExemption() != null && DateHelper.before((Date)insurance.getBeginWorkExemption(), (Date)start)) {
                result = true;
                break;
            }
            start = PDateHelper.getFirstDayNextMonth((Date)start);
        }
        return result;
    }

    public static void checkCfForErrors(DEUVAccount account, EECarriedForwardSystemAI cfAif) throws BusinessDomainException {
        if (!DbuvEmployee.hasValidDssdForCf(cfAif)) {
            account.addError("Fehler bei UV-Vortrag: Kein g\u00fcltiger DSSD f\u00fcr den Zeitraum vorhanden oder Gefahrtarifstellen ung\u00fcltig");
        }
    }

    private static boolean hasValidDssdForCf(EECarriedForwardSystemAI eeCf) throws BusinessDomainException {
        boolean result = true;
        Date validTP = eeCf.getValidUntil();
        if (DateHelper.afterOrEqual((Date)validTP, (Date)START_OF_DSSD_CHECK)) {
            Plant plant = eeCf.getPlant();
            for (CFAIPartClassOfRisk pCor : eeCf.getPartClassOfRisk()) {
                if (DbuvEmployee.hasValidDssdForCf(eeCf.getPCompany(), plant, validTP, eeCf.getValidFrom(), pCor.getAccidentInsuranceFund(), pCor.getDifferentAccidentInsuranceFund(), pCor.getClassOfRisk())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static boolean hasValidDssdForCf(PCompany pCompany, Plant plant, Date validTP, Date startCf, AccidentInsuranceFund aif, AccidentInsuranceFund aifCor, String cor) throws BusinessDomainException {
        GeneralEmploymentOffice generalEmploymentOffice = DEUVAdvice.getGeneralEmploymentOffice((PCompany)pCompany, (Plant)plant, (Date)validTP);
        if (aif.isNotValidForDsas(generalEmploymentOffice.getEmployerNumber())) {
            return true;
        }
        UvDssd dssd = null;
        try {
            dssd = aif.subCheckClassOfRiskAgainstDssd(generalEmploymentOffice, pCompany, plant, aif, aifCor, cor, VDate.getDateMax(), validTP, 0, false);
        }
        catch (BusinessDomainException businessDomainException) {
            // empty catch block
        }
        boolean valid = false;
        if (dssd != null && DateHelper.beforeOrEqual((Date)dssd.getMnrgvon(), (Date)startCf)) {
            if (dssd.getBeitragsmassstab() > 3) {
                valid = true;
            } else {
                for (UvDssdDbgt each : dssd.getDbgts()) {
                    String bbnrgt = aifCor.getAccidentInsuranceFundTP(VDate.getDateMax(), validTP).getStdCompanyNoOfAccIns();
                    if (!StringMapper.equal((String)bbnrgt, (String)each.getBbnrgt()) || !StringMapper.equal((String)cor, (String)each.getGtst()) || !DateHelper.beforeOrEqual((Date)each.getGtstVon(), (Date)startCf) || !DateHelper.afterOrEqual((Date)each.getGtstBis(), (Date)validTP)) continue;
                    valid = true;
                    break;
                }
            }
        }
        return valid;
    }

    private String checkAgainstDssd(DEUVAccount account) throws BusinessDomainException {
        ArrayList<CallSite> errorList = new ArrayList<CallSite>();
        Date validFrom = account.getDEUVDbme().getBeginn();
        Date validUntil = account.getDEUVDbme().getEnde();
        for (DbuvEmployee dbuvEmployee : this.getSameEmployees()) {
            for (DateInterval month : dbuvEmployee.getUvMonths()) {
                if (!DateHelper.between((Date)month.getValidUntil(), (Date)validFrom, (Date)validUntil)) continue;
                try {
                    dbuvEmployee.checkAgainDssd(DateHelper.getLastDayOfMonth((Date)month.getValidUntil()));
                }
                catch (BusinessDomainException e) {
                    errorList.add((CallSite)((Object)("PNR " + dbuvEmployee.getEmployee().getPersonnelnumber() + " " + DateMapper.toMMYYYYPointSeparationString((Date)month.getValidUntil()) + ": " + e.getMessage())));
                }
            }
        }
        for (DateInterval month : this.getUvMonths()) {
            if (!DateHelper.between((Date)month.getValidUntil(), (Date)validFrom, (Date)validUntil)) continue;
            try {
                this.checkAgainDssd(DateHelper.getLastDayOfMonth((Date)month.getValidUntil()));
            }
            catch (BusinessDomainException businessDomainException) {
                errorList.add((CallSite)((Object)(DateMapper.toMMYYYYPointSeparationString((Date)month.getValidUntil()) + ": " + businessDomainException.getMessage())));
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String string : errorList) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(string);
        }
        return builder.toString();
    }

    private void checkAgainDssd(Date validTP) throws BusinessDomainException {
        EEAccidentInsuranceFund eeAccidentInsuranceFund = (EEAccidentInsuranceFund)this.mEmployee.getEEAccidentInsuranceFundHistory().getItemOrNull(VDate.getDateMax(), validTP);
        if (eeAccidentInsuranceFund != null && eeAccidentInsuranceFund.getAccidentInsuranceFund() != null) {
            eeAccidentInsuranceFund.setSpecialChecks(false);
            eeAccidentInsuranceFund.checkAttributesFromEmployeeCheckup(validTP);
        }
    }

    public void makeResults() throws BusinessDomainException {
        DEUVAccount storno;
        LinkedList<DEUVAccount> existing = new LinkedList<DEUVAccount>(this.getReferences());
        LinkedList<DEUVAccount> createds = new LinkedList<DEUVAccount>(this.mCreateds);
        this.mResult.clear();
        while (!createds.isEmpty() && !existing.isEmpty()) {
            DEUVAccount existent = (DEUVAccount)existing.getFirst();
            DEUVAccount created = (DEUVAccount)createds.getFirst();
            switch (DbuvEmployee.compareAccounts(existent, created)) {
                case 0: {
                    if (this.hasDeuvRecipientError(existent) && !existent.getDEUVRecipient().equals((Object)created.getDEUVRecipient())) {
                        existing.removeFirst();
                        break;
                    }
                    created.makeReadOnly();
                    existing.removeFirst();
                    createds.removeFirst();
                    break;
                }
                case -1: {
                    storno = this.makeCancellation(existent);
                    this.mResult.add(storno);
                    existing.removeFirst();
                    break;
                }
                case 1: {
                    this.checkForErrors(created);
                    created.setSerialNumber(this.mDeuvAdvice.incrementCounter());
                    this.mResult.add(created);
                    createds.removeFirst();
                    break;
                }
            }
        }
        for (DEUVAccount account : existing) {
            storno = this.makeCancellation(account);
            this.mResult.add(storno);
        }
        for (DEUVAccount account : createds) {
            this.checkForErrors(account);
            account.setSerialNumber(this.mDeuvAdvice.incrementCounter());
            this.mResult.add(account);
        }
    }

    private List<DEUVAccount> getReferences() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.OIDEMPLOYEE, (String)this.mEmployee.getObjectid()), Restrictions.eq((String)DEUVAccountPersistencyManager.REASONOFDELIVERY, (String)"92"), Restrictions.ge((String)DEUVAccountPersistencyManager.VALIDFROM, (String)DateMapper.toString((Date)START_OF_REASON_92))});
        ArrayList<DEUVAccount> references = new ArrayList<DEUVAccount>(Arrays.asList(DEUVAccountPersistencyManager.query(null, (Criterion)filter)));
        for (DEUVAccount each : new ArrayList<DEUVAccount>(references)) {
            if (!each.getTransmitted()) {
                references.remove(each);
                each.makeSaveable();
                each.destroy();
                continue;
            }
            if (this.hasVSNRError(each)) {
                references.remove(each);
                continue;
            }
            if (each.getDEUVDbme() == null || !each.getDEUVDbme().getStornokennzeichen().equals("J")) continue;
            each.reorgCancelled("J");
        }
        Collections.sort(references, new Comparator<DEUVAccount>(){

            @Override
            public int compare(DEUVAccount acc1, DEUVAccount acc2) {
                int result = DateHelper.compare((Date)acc1.getValidFrom(), (Date)acc2.getValidFrom());
                if (result == 0) {
                    return StringMapper.compareTo((String)acc1.getCreatedOn(), (String)acc2.getCreatedOn());
                }
                return result;
            }
        });
        LinkedList<DEUVAccount> toCheck = new LinkedList<DEUVAccount>(references);
        ArrayList<DEUVAccount> obsoletes = new ArrayList<DEUVAccount>();
        while (!toCheck.isEmpty()) {
            DEUVAccount current = (DEUVAccount)toCheck.remove(0);
            if (current.getCanceled().equals("X")) {
                for (DEUVAccount each : toCheck) {
                    if (!each.getCanceled().equals("J") || DbuvEmployee.compareAccounts(current, each) != 0) continue;
                    toCheck.remove(each);
                    obsoletes.add(each);
                    obsoletes.add(current);
                    current = null;
                    break;
                }
                if (current == null) continue;
                current.reorgCancelled("N");
                continue;
            }
            if (!current.getCanceled().equals("J")) continue;
            obsoletes.add(current);
        }
        references.removeAll(obsoletes);
        for (DEUVAccount each : references) {
            each.loadAdvicedState(null);
        }
        return references;
    }

    private boolean hasVSNRError(DEUVAccount account) {
        return account.getAdviceState() == AdviceStateEnum.FEHLER_BESTANDSPRUEFUNG && "Abweichende VSNR aus DBBM".equals(account.getErrorMessage());
    }

    private boolean hasDeuvRecipientError(DEUVAccount account) {
        return account.getAdviceState() == AdviceStateEnum.FEHLER_KERNPRUEFUNG && DateHelper.afterOrEqual((Date)account.getCreatedOnDate(), (Date)DEUVAdvice.START_OF_2025) && account.getErrorMessage().matches(".*DSME[A-Z]20.*");
    }

    public static int compareAccounts(DEUVAccount existing, DEUVAccount created) throws BusinessDomainException {
        int result = DateHelper.compare((Date)existing.getValidFrom(), (Date)created.getValidFrom());
        if (result == 0 && (!StringMapper.equal((String)created.getDEUVDsme().getBbnrVerursacher(), (String)existing.getDEUVDsme().getBbnrVerursacher()) || created.getDEUVDbuv().compareToOld(existing.getDEUVDbuv()))) {
            result = -1;
        }
        return result;
    }

    public static int compareAccountsWithInsNo(DEUVAccount existing, DEUVAccount created) throws BusinessDomainException {
        int result = StringMapper.compareTo((String)existing.getInsuranceNo(), (String)created.getInsuranceNo());
        int n = result < 0 ? -1 : (result = result > 0 ? 1 : 0);
        if (result == 0) {
            result = DateHelper.compare((Date)existing.getValidFrom(), (Date)created.getValidFrom());
        }
        if (result == 0 && (!StringMapper.equal((String)created.getDEUVDsme().getBbnrVerursacher(), (String)existing.getDEUVDsme().getBbnrVerursacher()) || created.getDEUVDbuv().compareToOld(existing.getDEUVDbuv()))) {
            result = -1;
        }
        return result;
    }

    public DEUVAccount makeCancellation(DEUVAccount account) throws BusinessDomainException {
        DEUVAccount storno = DbuvEmployee.makeCancellation(account, this.mDeuvAdvice);
        storno.setInsuranceNo(this.getInsuranceNo());
        storno.getDEUVDsme().setVersicherungsnr(storno.getInsuranceNo());
        storno.makeErrors(false, this.mDeuvAdvice);
        return storno;
    }

    public static DEUVAccount makeCancellation(DEUVAccount account, DEUVAdvice deuvAdvice) throws BusinessDomainException {
        account.reorgCancelled("X");
        DEUVAccount storno = account.createNew();
        storno.setTransmitted(false);
        storno.setEeCertificate(false);
        storno.setCurrentFileNumber(0);
        storno.setCanceled("J");
        storno.setErrorMessage(null);
        if (storno.getDEUVDbme() != null) {
            storno.getDEUVDbme().setStornokennzeichen("J");
        }
        storno.getDEUVDsme().makeCancellation();
        storno.getDEUVDsme().updateVersionNr();
        storno.getDEUVDsme().setProdId(DeuvBasics.getProdId());
        storno.getDEUVDsme().setModId(DeuvBasics.getModId());
        storno.setCreatedOn(deuvAdvice.getCreatedOn());
        storno.getDEUVDsme().setDatumErstellung(deuvAdvice.getCreatedOn());
        deuvAdvice.updateDeuvRecipient(storno);
        storno.getDEUVDsme().setDatensatzIdUrsprung(account.getDEUVDsme().getDatensatzId());
        storno.setSerialNumber(-deuvAdvice.incrementCounter());
        if (account.getManually()) {
            storno.setManually(true);
            storno.setErrorMessage("Die Meldung wurde manuell erstellt und muss daher auch manuell storniert werden!");
        }
        return storno;
    }

    public static DEUVAccount createReason92(EECarriedForwardSystemAI cfAif, DEUVAdvice deuvAdvice) throws BusinessDomainException {
        DEUVAccount account92 = new DEUVAccount();
        account92.setEmployee(null);
        account92.setPCompany(cfAif.getPCompany());
        account92.setEffectiveFrom(DateHelper.getFirstDayOfMonth((Date)deuvAdvice.getCreatedOnDate()));
        account92.setValidFrom(DateHelper.getFirstDayOfYear((Date)cfAif.getValidFrom()));
        account92.setValidUntil(DateHelper.getLastDayOfYear((Date)cfAif.getValidFrom()));
        account92.setCreatedOn(deuvAdvice.getCreatedOn());
        account92.setCanceled("N");
        account92.setLongReasonOfDeliv("92");
        account92.setReasonOfDelivery(92);
        account92.setDEUVSender(deuvAdvice.getDEUVSender());
        account92.setDEUVRecipient(deuvAdvice.getDEUVRecipient(cfAif.getHealthFund()));
        account92.setInsuranceNo(cfAif.getInsuranceNo());
        DEUVDsme dsme = new DEUVDsme();
        dsme.setDEUVAccount(account92);
        dsme.setBbnrAbsender(account92.getSenderCompanyNumber());
        dsme.setDatumErstellung(account92.getCreatedOn());
        dsme.setVersicherungsnr(account92.getInsuranceNo());
        String companyNr = DEUVAdvice.getCompanyNumber((PCompany)cfAif.getPCompany(), (Plant)cfAif.getPlant(), (Date)account92.getValidUntil());
        dsme.setBbnrVerursacher(companyNr);
        dsme.setAzVerursacher(Deuv.toAzVerursacher((String)DbuvEmployee.getIDString(cfAif)));
        dsme.setBbnrKrankenkasse(DbuvEmployee.getBbnrKrankenkasse(cfAif));
        dsme.setPersonengruppe(account92.getPersongroup());
        dsme.setAbgabegrund(String.valueOf(account92.getReasonOfDelivery()));
        dsme.setStatuskennzeichen("");
        dsme.setProdId(DeuvBasics.getProdId());
        dsme.setModId(DeuvBasics.getModId());
        if (DateHelper.afterOrEqual((Date)account92.getValidFrom(), (Date)DEUVAdvice.START_OF_2023)) {
            String mainEmployerNumber = DEUVAdvice.getMainEmployerNumber((PCompany)cfAif.getPCompany(), (Plant)cfAif.getPlant(), (Date)account92.getValidUntil());
            dsme.setHauptbetriebsnummer(mainEmployerNumber);
        }
        dsme.setStaat("");
        DEUVDbme dbme = dsme.createDbme();
        dbme.setBeginn(account92.getValidFrom());
        dbme.setEnde(account92.getValidUntil());
        dbme.setGleitzone("0");
        dbme.setTaetigkeitssl("");
        account92.update(dsme, dbme);
        List<COR> cors = DbuvEmployee.createCfClassOfRisks(cfAif, deuvAdvice, account92.getValidUntil());
        DbuvEmployee.createDbuvs(dsme, cors, account92.getValidUntil());
        return account92;
    }

    private static String getIDString(EECarriedForwardSystemAI cfAif) {
        return cfAif.getPCompany().getPCompanyKey() + "/" + cfAif.getInsuranceNo();
    }

    private static String getBbnrKrankenkasse(EECarriedForwardSystemAI cfAif) throws BusinessDomainException {
        HealthFund healthFund = HealthFund.getHealthFundConsiderFusions((HealthFund)cfAif.getHealthFund(), (Date)DateHelper.getLastDayOfYear((Date)cfAif.getValidUntil()));
        return healthFund.getHealthFundTP(VDate.getDateMax(), VDate.getDateMax()).getStandardCompanyNumber();
    }

    private static List<COR> createCfClassOfRisks(EECarriedForwardSystemAI cfAif, DEUVAdvice deuvAdvice, Date endYear) throws BusinessDomainException {
        ArrayList<COR> result = new ArrayList<COR>();
        for (CFAIPartClassOfRisk cfcor : cfAif.getPartClassOfRisk()) {
            String membershipNumber = cfcor.getMembershipNumber();
            String unrs = null;
            if (StringMapper.isNullString((String)membershipNumber)) {
                AssignmentPCompanyAccidentInsuranceFundTP assAifTp = DbuvEmployee.getAssignmentPCompanyAIFTP(cfcor.getAccidentInsuranceFund(), cfAif.getPlant(), DateHelper.getLastDayOfYear((Date)cfAif.getValidUntil()), deuvAdvice);
                if (DateHelper.afterOrEqual((Date)endYear, (Date)DEUVAdvice.START_OF_2023)) {
                    unrs = assAifTp.getMembershipNumber();
                    membershipNumber = null;
                } else {
                    membershipNumber = assAifTp.getMembershipNumber();
                }
            }
            COR cor = new COR(cfAif.getValidFrom(), cfAif.getValidUntil(), cfcor.getAccidentInsuranceFund(), membershipNumber, unrs, cfcor.getDifferentAccidentInsuranceFund(), cfcor.getClassOfRisk(), BigDecimal.valueOf(100L), cfcor.getAIPayment(), cfcor.getAIHours());
            result.add(cor);
        }
        for (COR cor : result) {
            cor.setPaymentDescription(String.format(Locale.GERMAN, "Vortrag: %,.2f", cor.getPayment()));
        }
        return DbuvEmployee.updateCors(null, deuvAdvice, result, endYear);
    }

    private void checkForErrors(DEUVAccount account) throws BusinessDomainException {
        String errorMessage;
        if (DateHelper.afterOrEqual((Date)account.getValidFrom(), (Date)START_OF_DSSD_CHECK) && !StringMapper.isNullString((String)(errorMessage = this.checkAgainstDssd(account)))) {
            account.addError(errorMessage);
        }
        account.makeErrors(false, this.mDeuvAdvice);
    }

    private DEUVAdvice getAdvice() {
        return this.mDeuvAdvice;
    }

    public Collection<DEUVAccount> getResult() {
        for (DEUVAccount account : this.mResult) {
            Arrays.sort(account.getDEUVDbuv().getUVRiskPeriods(), new UVRiskPeriodViewComparator());
        }
        return Collections.unmodifiableCollection(this.mResult);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getSimpleName());
        builder.append('[').append((Object)this.mEmployee);
        builder.append(',').append(this.mCreateds);
        builder.append(']');
        return builder.toString();
    }

    private class UVRiskPeriodViewComparator
    implements Comparator<UVRiskPeriod> {
        private UVRiskPeriodViewComparator() {
        }

        @Override
        public int compare(UVRiskPeriod uvrp1, UVRiskPeriod uvrp2) {
            int comp = StringMapper.compareTo((String)uvrp1.getBbnrUV(), (String)uvrp2.getBbnrUV());
            if (comp == 0) {
                comp = -BigDecimalMapper.compareTo((BigDecimal)uvrp1.getUvEntgelt(), (BigDecimal)uvrp2.getUvEntgelt());
            }
            if (comp == 0) {
                comp = StringMapper.compareTo((String)uvrp1.getUVGrund(), (String)uvrp2.getUVGrund());
            }
            return comp;
        }
    }
}

