/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.companyplant.mapper;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.ExceptionMapper;

public class CompanyPlantExceptionMapper {
    private static final String CLASS_GENERAL = "PYFirma_Betriebsstaette";
    private static final int STANDARD_PAYMENTPOINT_NO_PHI_MISSING = 115;
    private static final int REGISTRATION_PERIOD_FALSE = 120;
    private static final int TAXNUMBER_MISSING = 150;
    private static final int SHORTDESCRIPTION_MISSING = 310;
    private static final int LONGDESCRIPTION_MISSING = 320;
    private static final int LOCATION_MISSING = 330;
    private static final int CITY_MISSING = 340;
    private static final int STREET_MISSING = 341;
    private static final int FEDERALSTATE_MISSING = 350;
    private static final int Rate_Assessment_Accomplishing_HealthFund_Missing = 510;
    private static final int ASSIGNED_COMPANYACCOUNT_MISSING = 600;
    private static final int LENGTH_OF_KEY_GREATER_TEN = 601;
    private static final int ASSIGNED_TAXOFFICE_MISSING = 602;
    private static final int BANK_MISSING = 605;
    private static final int ACCOUNT_NUMBER_MISSING = 606;
    private static final int NOEMPLOYERNUMBEREXIST = 0;
    private static final int DESCRIPTION_CONTAINS_FALSE_SIGN = 607;
    private static final int EMPLOYER_IS_HEALTHFUND = 700;
    private static final int CHANGE_OF_PENSIONSCHEMESETTINGS_NOT_ALLOWED = 701;
    private static final int INSOLVENCY_ASSESSABLE_NOT_ALLOWED = 702;
    private static final int CHANGE_OF_ANNUAL_INCOME_TAX_RETURN_OF_PREVIOUS_YEAR_NOT_ALLOWED = 703;
    private static final int CHANGE_OF_ZVKSETTINGS_NOT_ALLOWED = 704;
    private static final int CHANGE_OF_TYPE_OF_BUSINESS_NOT_ALLOWED = 705;
    private static final int CHANGE_OF_ASSESSMENTDUTY_NOT_ALLOWED = 706;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYFirma_Betriebsstaette", new ErrorMessage[]{new ErrorMessage(115, "Wenn KVdR-Zahlstelle angehakt ist, muss die KVdR-Zahlstellen-Nr. angegeben werden "), new ErrorMessage(120, "Ein Versatz ist nur bei monatlichen LSt-Anmeldungezeitraum m\u00f6glich "), new ErrorMessage(150, "Die Steuer-Nr. fehlt"), new ErrorMessage(310, "Die Kurzbezeichnung fehlt"), new ErrorMessage(320, "Die Bezeichnung fehlt"), new ErrorMessage(330, "Der Firmen- bzw. Betriebsst\u00e4ttensitz fehlt"), new ErrorMessage(340, "Der Ort in der Hausanschrift fehlt"), new ErrorMessage(341, "Die Stra\u00dfe in der Hausanschrift fehlt"), new ErrorMessage(350, "Das Bundesland fehlt"), new ErrorMessage(510, "Die Umlagekasse fehlt"), new ErrorMessage(600, "Zum eingegeben Zeitpunkt existiert kein Standardfirmenbankkonto, die Auswahl der Zahlungsart '\u00dcberweisung' ist nur mit Angabe des Bankkonto zul\u00e4ssig"), new ErrorMessage(601, "Der Firmenschl\u00fcssel darf nicht l\u00e4nger als 10 Zeichen sein"), new ErrorMessage(602, "Das Finanzamt fehlt"), new ErrorMessage(605, "Die Bankverbindung fehlt"), new ErrorMessage(606, "Die Auswahl der Zahlungsart '\u00dcberweisung' ist nur mit Angabe der Bankkonto-Nr. zul\u00e4ssig"), new ErrorMessage(0, "Die Eingabe der Arbeitgeber-Betriebsnummer ist Pflicht"), new ErrorMessage(607, "Die Verwendung des Zeichens '/' ist in der Bezeichnung nicht erlaubt"), new ErrorMessage(700, "Die AG-Betriebs-Nr. ist Krankenkasse oder Datenannahmestelle "), new ErrorMessage(701, "Ein Wechsel der Verarbeitungsart f\u00fcr betriebliche Altersversorgung ist nur zu Beginn eines Jahres erlaubt "), new ErrorMessage(702, "InsG-Umlagepflichtiger Betrieb erst ab 01.01.2009 erlaubt "), new ErrorMessage(703, "R\u00fcckwirkende \u00c4nderungen des Lohnsteuer-Jahresausgleich durch AG nur noch f\u00fcr das Vorjahr oder aktuelle Berechnungsjahr erlaubt"), new ErrorMessage(704, "Ein Wechsel der Verarbeitungsart f\u00fcr ZVK ist nur zu Beginn eines Jahres erlaubt "), new ErrorMessage(705, "Ein Wechsel der Betriebst\u00e4tigkeit von 'B - Betriebsaufgabe' auf 'A - aktiver Betrieb' ist nicht erlaubt "), new ErrorMessage(706, "Die \u00c4nderung der Umlagepflicht ist nur zum Beginn des aktuellen Kalenderjahres und Folgejahres erlaubt.")});

    public static BusinessDomainException makeStandardPaymentPointNoPHIMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)115, (String)mErrorList.getDefaultString(115));
    }

    public static BusinessDomainException makeRegistrationPeriodFalseDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)120, (String)mErrorList.getDefaultString(120));
    }

    public static BusinessDomainException makeTaxNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)150, (String)mErrorList.getDefaultString(150));
    }

    public static BusinessDomainException makeShortDescriptionMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"Foundation.checkShortDescription", (String)"", (int)310, (String)mErrorList.getDefaultString(310));
    }

    public static BusinessDomainException makeLongDescriptionMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)320, (String)mErrorList.getDefaultString(320));
    }

    public static BusinessDomainException makeLocationMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)330, (String)mErrorList.getDefaultString(330));
    }

    public static BusinessDomainException makeCityMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)340, (String)mErrorList.getDefaultString(340));
    }

    public static BusinessDomainException makeStreetMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)341, (String)mErrorList.getDefaultString(341));
    }

    public static BusinessDomainException makeFederalStateMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)350, (String)mErrorList.getDefaultString(350));
    }

    public static BusinessDomainException makeRateAssessmentAccomplishingHealthFundMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)510, (String)mErrorList.getDefaultString(510));
    }

    public static BusinessDomainException makeAssignedCompanyAccountMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)600, (String)mErrorList.getDefaultString(600));
    }

    public static BusinessDomainException makeLengthOfKeyGreaterTenDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)601, (String)mErrorList.getDefaultString(601));
    }

    public static BusinessDomainException makeAssignedTaxOffiveMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)602, (String)mErrorList.getDefaultString(602));
    }

    public static BusinessDomainException makeBankMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)605, (String)mErrorList.getDefaultString(605));
    }

    public static BusinessDomainException makeAccountNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)606, (String)mErrorList.getDefaultString(606));
    }

    public static BusinessDomainException makeNoEmployerNumberExistDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)0, (String)mErrorList.getDefaultString(0));
    }

    public static BusinessDomainException makeDescriptionContainsFalseSignDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)607, (String)mErrorList.getDefaultString(607));
    }

    public static BusinessDomainException makeEmployerIsHealthFundDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)700, (String)mErrorList.getDefaultString(700));
    }

    public static BusinessDomainException makeChangeOfPensionSchemeSettingsNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)701, (String)mErrorList.getDefaultString(701));
    }

    public static BusinessDomainException makeInsolvencyAssessableNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)702, (String)mErrorList.getDefaultString(702));
    }

    public static BusinessDomainException makeChangeOfAnnualIncomeTaxReturnNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)703, (String)mErrorList.getDefaultString(703));
    }

    public static BusinessDomainException makeChangeOfZVKSettingsNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)704, (String)mErrorList.getDefaultString(704));
    }

    public static BusinessDomainException makeChangeOfTypeOfBusinessNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)705, (String)mErrorList.getDefaultString(705));
    }

    public static BusinessDomainException makeChangeOfAssessmentdutyNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)706, (String)mErrorList.getDefaultString(706));
    }
}

