/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.companyplant;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.AssessmentDutyEnum;
import com.varial.personnel.domain.companyplant.PensionschemeSettingsEnum;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.companyplant.mapper.CompanyPlantExceptionMapper;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModel;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.pcompany.settings.CompanySettingsPersistencyManager;
import com.varial.personnel.domain.plant.settings.PlantSettingsPersistencyManager;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.util.Date;

public final class Settings {
    private boolean mAssessable;
    private HealthFund mRateAssessmentAccomplishingHealthFund;
    private boolean mAnnualIncomeTaxReturn;
    private String mLawArea;
    private boolean mPromptDEUVAccount;
    private AgePartTimeModel mAgePartTimeModel;
    private PensionschemeSettingsEnum mPensionschemeSettingsEnum;
    private boolean mInsolvencyAssessable;
    private BigDecimal mMinLaborUtilizationRate;
    private BigDecimal mMaxlLaborUtilizationRate;
    private boolean mERPaysNISurcharge;
    private ZvkSettingsEnum mZvkSettings;
    private AssessmentDutyEnum mAssessmentDuty;

    public Settings(boolean assessable, HealthFund rateAssessmentAccomplishingHealthFund, boolean annualIncomeTaxReturn, String lawArea, boolean promptDEUVAccount, AgePartTimeModel agePartTimeModel, PensionschemeSettingsEnum pensionschemeSettingsEnum, boolean insolvencyAssessable, BigDecimal minLaborUtilizationRate, BigDecimal maxlLaborUtilizationRate, boolean erPaysNISurcharge, ZvkSettingsEnum zvkSettings, AssessmentDutyEnum assessmentDuty) {
        this.mAssessable = assessable;
        this.mRateAssessmentAccomplishingHealthFund = rateAssessmentAccomplishingHealthFund;
        this.mLawArea = lawArea;
        this.mPromptDEUVAccount = promptDEUVAccount;
        this.mAnnualIncomeTaxReturn = annualIncomeTaxReturn;
        this.mAgePartTimeModel = agePartTimeModel;
        this.mPensionschemeSettingsEnum = pensionschemeSettingsEnum;
        this.mInsolvencyAssessable = insolvencyAssessable;
        this.mMinLaborUtilizationRate = minLaborUtilizationRate;
        this.mMaxlLaborUtilizationRate = maxlLaborUtilizationRate;
        this.mERPaysNISurcharge = erPaysNISurcharge;
        this.mZvkSettings = zvkSettings;
        this.mAssessmentDuty = assessmentDuty;
    }

    public boolean getAssessable() {
        return this.mAssessable;
    }

    public HealthFund getRateAssessmentAccomplishingHealthFund() {
        return this.mRateAssessmentAccomplishingHealthFund;
    }

    public String getLawArea() {
        return this.mLawArea;
    }

    public boolean getPromptDEUVAccount() {
        return this.mPromptDEUVAccount;
    }

    public boolean getAnnualIncomeTaxReturn() {
        return this.mAnnualIncomeTaxReturn;
    }

    public AgePartTimeModel getAgePartTimeModel() {
        return this.mAgePartTimeModel;
    }

    public PensionschemeSettingsEnum getPensionshemeSettingsEnum() {
        return this.mPensionschemeSettingsEnum;
    }

    public boolean getInsolvencyAssessable() {
        return this.mInsolvencyAssessable;
    }

    public void setAssessable(boolean assessable) {
        this.mAssessable = assessable;
    }

    public void setRateAssessmentAccomplishingHealthFund(HealthFund rateAssessmentAccomplishingHealthFund) {
        this.mRateAssessmentAccomplishingHealthFund = rateAssessmentAccomplishingHealthFund;
    }

    public void setLawArea(String lawArea) {
        this.mLawArea = lawArea;
    }

    public void setPromptDEUVAccount(boolean promptDEUVAccount) {
        this.mPromptDEUVAccount = promptDEUVAccount;
    }

    public void setAnnualIncomeTaxReturn(boolean annualIncomeTaxReturn) {
        this.mAnnualIncomeTaxReturn = annualIncomeTaxReturn;
    }

    public void setAgePartTimeModel(AgePartTimeModel agePartTimeModel) {
        this.mAgePartTimeModel = agePartTimeModel;
    }

    public void setPensionshemeSettingsEnum(PensionschemeSettingsEnum pensionshemeSettingsEnum) {
        this.mPensionschemeSettingsEnum = pensionshemeSettingsEnum;
    }

    public void setInsolvencyAssessable(boolean assessable) {
        this.mInsolvencyAssessable = assessable;
    }

    public boolean getERPaysNISurcharge() {
        return this.mERPaysNISurcharge;
    }

    public void setERPaysNISurcharge(boolean eRPaysNISurcharge) {
        this.mERPaysNISurcharge = eRPaysNISurcharge;
    }

    public BigDecimal getMinLaborUtilizationRate() {
        return this.mMinLaborUtilizationRate;
    }

    public void setMinLaborUtilizationRate(BigDecimal minLaborUtilizationRate) {
        this.mMinLaborUtilizationRate = minLaborUtilizationRate;
    }

    public BigDecimal getMaxlLaborUtilizationRate() {
        return this.mMaxlLaborUtilizationRate;
    }

    public void setMaxlLaborUtilizationRate(BigDecimal maxlLaborUtilizationRate) {
        this.mMaxlLaborUtilizationRate = maxlLaborUtilizationRate;
    }

    public ZvkSettingsEnum getZvkSettings() {
        return this.mZvkSettings;
    }

    public void setZvkSettings(ZvkSettingsEnum zvkSettings) {
        this.mZvkSettings = zvkSettings;
    }

    public AssessmentDutyEnum getAssessmentDuty() {
        return this.mAssessmentDuty;
    }

    public void setAssessmentDuty(AssessmentDutyEnum assessmentDuty) {
        this.mAssessmentDuty = assessmentDuty;
    }

    public void checkAttributes(Date validFrom, Settings oldSettings) throws BusinessDomainException {
        this.checkRateAssessmentAccomplishingHealthFund(validFrom);
        this.checkPensionShemeSettings(validFrom, oldSettings);
        this.checkInsolvencyAssessable(validFrom);
        this.checkZVKSettings(validFrom, oldSettings);
    }

    public void checkRateAssessmentAccomplishingHealthFund(Date validFrom) throws BusinessDomainException {
        if (this.getAssessable() && DateHelper.before((Date)validFrom, (Date)new VDate(2006, 0, 1).getDate()) && this.getRateAssessmentAccomplishingHealthFund() == null) {
            throw CompanyPlantExceptionMapper.makeRateAssessmentAccomplishingHealthFundMissingDomainException();
        }
    }

    public void checkPensionShemeSettings(Date validFrom, Settings oldSettings) throws BusinessDomainException {
        if (oldSettings == null) {
            return;
        }
        if (oldSettings.getPensionshemeSettingsEnum().value() != this.getPensionshemeSettingsEnum().value() && !DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)validFrom), (Date)validFrom)) {
            throw CompanyPlantExceptionMapper.makeChangeOfPensionSchemeSettingsNotAllowedDomainException();
        }
    }

    public void checkInsolvencyAssessable(Date validFrom) throws BusinessDomainException {
        Date dateMarginal = new VDate(2009, 0, 1).getDate();
        if (DateHelper.before((Date)validFrom, (Date)dateMarginal) && this.mInsolvencyAssessable) {
            throw CompanyPlantExceptionMapper.makeInsolvencyAssessableNotAllowedDomainException();
        }
    }

    public void checkZVKSettings(Date validFrom, Settings oldSettings) throws BusinessDomainException {
        if (oldSettings == null) {
            return;
        }
        if (oldSettings.getZvkSettings().value() != this.getZvkSettings().value() && !DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)validFrom), (Date)validFrom)) {
            throw CompanyPlantExceptionMapper.makeChangeOfZVKSettingsNotAllowedDomainException();
        }
    }

    public void checkChangeOfAssessmentDuty(boolean isPCompany, String oidPCompanyOrPlant, Date validFrom, Settings oldSettings) throws BusinessDomainException {
        if (oldSettings == null) {
            return;
        }
        if (oldSettings.getAssessmentDuty() != this.getAssessmentDuty()) {
            Date startOfCurrentYear = DateHelper.getFirstDayOfYear((Date)new Date());
            Date startOfNextYear = DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)startOfCurrentYear));
            Date startOfHistory = isPCompany ? CompanySettingsPersistencyManager.getStartOfHistory(oidPCompanyOrPlant) : PlantSettingsPersistencyManager.getStartOfHistory(oidPCompanyOrPlant);
            if (DateHelper.before((Date)startOfHistory, (Date)startOfCurrentYear)) {
                startOfHistory = startOfCurrentYear;
            }
            if (!(DateHelper.equal((Date)validFrom, (Date)startOfHistory) || DateHelper.equal((Date)validFrom, (Date)startOfCurrentYear) || DateHelper.equal((Date)validFrom, (Date)startOfNextYear))) {
                throw CompanyPlantExceptionMapper.makeChangeOfAssessmentdutyNotAllowedDomainException();
            }
        }
    }
}

