/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.aeins.dxa1;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.aeins.AEinsHelper;
import com.varial.personnel.domain.aeins.abloesung.AEinsAbloesung;
import com.varial.personnel.domain.aeins.abloesung.IAEinsAbloesungPersistencyManager;
import com.varial.personnel.domain.aeins.account.AEinsAccount;
import com.varial.personnel.domain.aeins.an.AEinsAn;
import com.varial.personnel.domain.aeins.an.IAEinsAnPersistencyManager;
import com.varial.personnel.domain.aeins.anschrift.AEinsAnschrift;
import com.varial.personnel.domain.aeins.anschrift.IAEinsAnschriftPersistencyManager;
import com.varial.personnel.domain.aeins.dxa1.IAEinsDxa1PersistencyManager;
import com.varial.personnel.domain.aeins.entsendung.AEinsEntsendung;
import com.varial.personnel.domain.aeins.entsendung.IAEinsEntsendungPersistencyManager;
import com.varial.personnel.domain.aeins.firma.AEinsFirma;
import com.varial.personnel.domain.aeins.firma.IAEinsFirmaPersistencyManager;
import com.varial.personnel.domain.aeins.stelle.AEinsStelle;
import com.varial.personnel.domain.aeins.stelle.IAEinsStellePersistencyManager;
import com.varial.personnel.domain.aeins.stelleschiff.AEinsStelleschiff;
import com.varial.personnel.domain.aeins.stelleschiff.IAEinsStelleschiffPersistencyManager;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.Date;

public class AEinsDxa1
extends PersistentObject {
    public static final String VERSION = "030000";
    private final IAEinsDxa1PersistencyManager pm = (IAEinsDxa1PersistencyManager)UtilitiesManager.getBean((String)"aEinsDxa1PersistencyManager", IAEinsDxa1PersistencyManager.class);
    private static final int PRIORITY = 5;
    private static final String KENNUNG = "DXA1";
    private String mVersionsnummer;
    private String mAbsendernummer;
    private String mEmpfaengernummer;
    private String mDatumErstellung;
    private String mProdid;
    private String mModid;
    private String mDatensatzid;
    private String mVorgangsid;
    private String mAktenzeichenverurs;
    private String mStornokennzeichen;
    private String mDatensatzidursprung;
    private AEinsAn mAEinsAn;
    private int mAnzahlAnschrift;
    private AEinsAnschrift[] mAEinsAnschrift;
    private int mAnzahlKontakte;
    private boolean mZustaendigkeitabv;
    private String mMitgliedsnummerabv;
    private String mStaatentsendung;
    private Date mBeginnentsendung;
    private Date mEndeentsendung;
    private String mTaetigkeitausland;
    private int mAnzahlstelle;
    private AEinsStelle[] mAEinsStelle;
    private int mAnzahlStelleschiff;
    private AEinsStelleschiff[] mAEinsStelleschiff;
    private int mAnzahlentsendung;
    private AEinsEntsendung[] mAEinsEntsendung;
    private String mAnUeberlassung;
    private int mAnzahlAbloesung;
    private AEinsAbloesung[] mAEinsAbloesung;
    private String mTaetigkeitdeutsch;
    private String mGeringfuegigebeschaeftigung;
    private String mZahlungsvdavor;
    private String mEntgeltanspruchag;
    private String mAnwerbungan;
    private String mEntscheidungarbver;
    private String mEntlassung;
    private String mEntscheidungaufg;
    private AEinsFirma mAEinsFirma;
    private int mAnzahlkontakteag;
    private String mNennenswerttaetig;
    private String mWeiterespersonal;
    private String mWirtschaftssektor;
    private String mAngabeneinverstanden;
    private String mAbhaengigebeschaeftigung;
    private AEinsAccount mAccount;

    public AEinsDxa1 getAEinsDxa1ForAccount(String oidaccount) {
        AEinsDxa1[] rs = this.pm.query(null, Restrictions.eq((String)"oidaeinsaccount", (String)oidaccount));
        if (rs.length != 1) {
            throw new IllegalStateException("Advice inconsistent, " + rs.length + " Dxa1 (not 1).");
        }
        return rs[0];
    }

    protected AEinsDxa1(int priority) {
        super(priority);
    }

    public AEinsDxa1() {
        this(5);
    }

    public AEinsDxa1(String objectID) {
        super(5, objectID);
    }

    public AEinsDxa1(String objectId, int version) {
        super(5, objectId, version);
    }

    public AEinsDxa1(boolean readOnly) {
        super(5, readOnly);
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        this.pm.save(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public AEinsAccount getAccount() {
        this.requireLoaded();
        return this.mAccount;
    }

    public void setAccount(AEinsAccount account) {
        this.mAccount = account;
    }

    public String getKennung() {
        this.requireLoaded();
        return KENNUNG;
    }

    public String getVersionsnummer() {
        this.requireLoaded();
        return this.mVersionsnummer;
    }

    public void setVersionsnummer(String versionsnummer) {
        this.mVersionsnummer = versionsnummer;
    }

    public boolean isCurrentVersion() {
        return StringMapper.equal((String)VERSION, (String)this.getVersionsnummer());
    }

    public String getAsendernummer() {
        this.requireLoaded();
        return this.mAbsendernummer;
    }

    public void setAsendernummer(String absendernummer) {
        this.mAbsendernummer = absendernummer;
    }

    public int getAnzahlAnschrift() {
        this.requireLoaded();
        return this.mAnzahlAnschrift;
    }

    public void setAnzahlAnschrift(int anzahlAnschrift) {
        this.mAnzahlAnschrift = anzahlAnschrift;
    }

    public int getAnzahlKontakte() {
        this.requireLoaded();
        return this.mAnzahlKontakte;
    }

    public void setAnzahlKontakte(int anzahlKontakte) {
        this.mAnzahlKontakte = anzahlKontakte;
    }

    public int getAnzahlstelle() {
        this.requireLoaded();
        return this.mAnzahlstelle;
    }

    public void setAnzahlstelle(int anzahlstelle) {
        this.mAnzahlstelle = anzahlstelle;
    }

    public int getAnzahlentsendung() {
        this.requireLoaded();
        return this.mAnzahlentsendung;
    }

    public void setAnzahlentsendung(int anzahlentsendung) {
        this.mAnzahlentsendung = anzahlentsendung;
    }

    public int getAnzahlAbloesung() {
        this.requireLoaded();
        return this.mAnzahlAbloesung;
    }

    public void setAnzahlAbloesung(int anzahlAbloesung) {
        this.mAnzahlAbloesung = anzahlAbloesung;
    }

    public int getAnzahlkontakteag() {
        this.requireLoaded();
        return this.mAnzahlkontakteag;
    }

    public void setAnzahlkontakteag(int anzahlkontakteag) {
        this.mAnzahlkontakteag = anzahlkontakteag;
    }

    public String getAbsendernummer() {
        this.requireLoaded();
        return this.mAbsendernummer;
    }

    public void setAbsendernummer(String absendernummer) {
        this.mAbsendernummer = absendernummer;
    }

    public String getEmpfaengernummer() {
        this.requireLoaded();
        return this.mEmpfaengernummer;
    }

    public void setEmpfaengernummer(String empfaengernummer) {
        this.mEmpfaengernummer = empfaengernummer;
    }

    public String getDatumErstellung() {
        this.requireLoaded();
        return this.mDatumErstellung;
    }

    public void setDatumErstellung(String datumErstellung) {
        this.mDatumErstellung = datumErstellung;
    }

    public String getProdid() {
        this.requireLoaded();
        return this.mProdid;
    }

    public void setProdid(String prodid) {
        this.mProdid = prodid;
    }

    public String getModid() {
        this.requireLoaded();
        return this.mModid;
    }

    public void setModid(String modid) {
        this.mModid = modid;
    }

    public String getDatensatzid() {
        this.requireLoaded();
        return this.mDatensatzid;
    }

    public void setDatensatzid(String datensatzid) {
        this.mDatensatzid = datensatzid;
    }

    public String getAktenzeichenverurs() {
        this.requireLoaded();
        return this.mAktenzeichenverurs;
    }

    public void setAktenzeichenverurs(String aktenzeichenverurs) {
        this.mAktenzeichenverurs = aktenzeichenverurs;
    }

    public String getStornokennzeichen() {
        this.requireLoaded();
        return this.mStornokennzeichen;
    }

    public void setStornokennzeichen(String stornokennzeichen) {
        this.mStornokennzeichen = stornokennzeichen;
    }

    public String getStaatentsendung() {
        this.requireLoaded();
        return this.mStaatentsendung;
    }

    public void setStaatentsendung(String staatentsendung) {
        this.mStaatentsendung = staatentsendung;
    }

    public Date getBeginnentsendung() {
        this.requireLoaded();
        return this.mBeginnentsendung;
    }

    public void setBeginnentsendung(Date beginnentsendung) {
        this.mBeginnentsendung = beginnentsendung;
    }

    public Date getEndeentsendung() {
        this.requireLoaded();
        return this.mEndeentsendung;
    }

    public void setEndeentsendung(Date endeentsendung) {
        this.mEndeentsendung = endeentsendung;
    }

    public String getTaetigkeitausland() {
        this.requireLoaded();
        return this.mTaetigkeitausland;
    }

    public void setTaetigkeitausland(String taetigkeitausland) {
        this.mTaetigkeitausland = taetigkeitausland;
    }

    public String getTaetigkeitdeutsch() {
        this.requireLoaded();
        return this.mTaetigkeitdeutsch;
    }

    public void setTaetigkeitdeutsch(String taetigkeitdeutsch) {
        this.mTaetigkeitdeutsch = taetigkeitdeutsch;
    }

    public String getZahlungsvdavor() {
        this.requireLoaded();
        return this.mZahlungsvdavor;
    }

    public void setZahlungsvdavor(String zahlungsvdavor) {
        this.mZahlungsvdavor = zahlungsvdavor;
    }

    public String getEntgeltanspruchag() {
        this.requireLoaded();
        return this.mEntgeltanspruchag;
    }

    public void setEntgeltanspruchag(String entgeltanspruchag) {
        this.mEntgeltanspruchag = entgeltanspruchag;
    }

    public String getAnwerbungan() {
        this.requireLoaded();
        return this.mAnwerbungan;
    }

    public void setAnwerbungan(String anwerbungan) {
        this.mAnwerbungan = anwerbungan;
    }

    public String getEntscheidungarbver() {
        this.requireLoaded();
        return this.mEntscheidungarbver;
    }

    public void setEntscheidungarbver(String entscheidungarbver) {
        this.mEntscheidungarbver = entscheidungarbver;
    }

    public String getEntlassung() {
        this.requireLoaded();
        return this.mEntlassung;
    }

    public void setEntlassung(String entlassung) {
        this.mEntlassung = entlassung;
    }

    public String getEntscheidungaufg() {
        return this.mEntscheidungaufg;
    }

    public void setEntscheidungaufg(String entscheidungaufg) {
        this.mEntscheidungaufg = entscheidungaufg;
    }

    public String getNennenswerttaetig() {
        this.requireLoaded();
        return this.mNennenswerttaetig;
    }

    public void setNennenswerttaetig(String nennenswerttaetig) {
        this.mNennenswerttaetig = nennenswerttaetig;
    }

    public String getWeiterespersonal() {
        this.requireLoaded();
        return this.mWeiterespersonal;
    }

    public void setWeiterespersonal(String weiterespersonal) {
        this.mWeiterespersonal = weiterespersonal;
    }

    public String getWirtschaftssektor() {
        this.requireLoaded();
        return this.mWirtschaftssektor;
    }

    public void setWirtschaftssektor(String wirtschaftssektor) {
        this.mWirtschaftssektor = wirtschaftssektor;
    }

    public String getDatensatzidursprung() {
        this.requireLoaded();
        return this.mDatensatzidursprung;
    }

    public void setDatensatzidursprung(String datensatzidursprung) {
        this.mDatensatzidursprung = datensatzidursprung;
    }

    public String getAnUeberlassung() {
        this.requireLoaded();
        return this.mAnUeberlassung;
    }

    public void setAnUeberlassung(String anUeberlassung) {
        this.mAnUeberlassung = anUeberlassung;
    }

    public String getVorgangsid() {
        this.requireLoaded();
        return this.mVorgangsid;
    }

    public void setVorgangsid(String vorgangsid) {
        this.mVorgangsid = vorgangsid;
    }

    public void setZustaendigkeitabv(boolean zustaendigkeitabv) {
        this.mZustaendigkeitabv = zustaendigkeitabv;
    }

    public String getMitgliedsnummerabv() {
        this.requireLoaded();
        return this.mMitgliedsnummerabv;
    }

    public void setMitgliedsnummerabv(String mitgliedsnummerabv) {
        this.mMitgliedsnummerabv = mitgliedsnummerabv;
    }

    public int getAnzahlStelleschiff() {
        this.requireLoaded();
        return this.mAnzahlStelleschiff;
    }

    public void setAnzahlStelleschiff(int anzahlStelleschiff) {
        this.mAnzahlStelleschiff = anzahlStelleschiff;
    }

    public String getGeringfuegigebeschaeftigung() {
        this.requireLoaded();
        return this.mGeringfuegigebeschaeftigung;
    }

    public void setGeringfuegigebeschaeftigung(String geringfuegigebeschaeftigung) {
        this.mGeringfuegigebeschaeftigung = geringfuegigebeschaeftigung;
    }

    public String getAngabeneinverstanden() {
        this.requireLoaded();
        return this.mAngabeneinverstanden;
    }

    public void setAngabeneinverstanden(String angabeneinverstanden) {
        this.mAngabeneinverstanden = angabeneinverstanden;
    }

    public String getAbhaengigebeschaeftigung() {
        return this.mAbhaengigebeschaeftigung;
    }

    public void setAbhaengigebeschaeftigung(String abhaengigebeschaeftigung) {
        this.mAbhaengigebeschaeftigung = abhaengigebeschaeftigung;
    }

    public AEinsDxa1 createNew(AEinsAccount account) {
        AEinsDxa1 bo = new AEinsDxa1();
        bo.mVersionsnummer = this.getVersionsnummer();
        bo.mAbsendernummer = this.getAbsendernummer();
        bo.mEmpfaengernummer = this.getEmpfaengernummer();
        bo.mDatumErstellung = this.getDatumErstellung();
        bo.mProdid = this.getProdid();
        bo.mModid = this.getModid();
        bo.mDatensatzid = this.getDatensatzid();
        bo.mAktenzeichenverurs = this.getAktenzeichenverurs();
        bo.mStornokennzeichen = this.getStornokennzeichen();
        bo.mAEinsAn = this.getAEinsAn().createNew(bo);
        bo.mAnzahlAnschrift = this.getAnzahlAnschrift();
        AEinsAnschrift[] ans = new AEinsAnschrift[this.getAEinsAnschrift().length];
        for (int i = 0; i < ans.length; ++i) {
            ans[i] = this.getAEinsAnschrift()[i].createNew(bo);
        }
        bo.mAEinsAnschrift = ans;
        bo.mAnzahlKontakte = 0;
        bo.mZustaendigkeitabv = this.hasZustaendigkeitabv();
        bo.mMitgliedsnummerabv = this.getMitgliedsnummerabv();
        bo.mStaatentsendung = this.getStaatentsendung();
        bo.mBeginnentsendung = this.getBeginnentsendung();
        bo.mEndeentsendung = this.getEndeentsendung();
        bo.mTaetigkeitausland = this.getTaetigkeitausland();
        bo.mAnzahlstelle = this.getAnzahlstelle();
        AEinsStelle[] stelle = new AEinsStelle[this.getAEinsStelle().length];
        for (int i = 0; i < stelle.length; ++i) {
            stelle[i] = this.getAEinsStelle()[i].createNew(bo);
        }
        bo.mAEinsStelle = stelle;
        bo.mAnzahlentsendung = this.getAnzahlentsendung();
        AEinsEntsendung[] ent = new AEinsEntsendung[this.getAEinsEntsendung().length];
        for (int i = 0; i < ent.length; ++i) {
            ent[i] = this.getAEinsEntsendung()[i].createNew(bo);
        }
        bo.mAEinsEntsendung = ent;
        bo.mAnUeberlassung = this.getAnUeberlassung();
        bo.mAnzahlAbloesung = this.getAnzahlAbloesung();
        AEinsAbloesung[] ab = new AEinsAbloesung[this.getAEinsAbloesung().length];
        for (int i = 0; i < ab.length; ++i) {
            ab[i] = this.getAEinsAbloesung()[i].createNew(bo);
        }
        bo.mAEinsAbloesung = ab;
        bo.mTaetigkeitdeutsch = this.getTaetigkeitdeutsch();
        bo.mZahlungsvdavor = this.getZahlungsvdavor();
        bo.mEntgeltanspruchag = this.getEntgeltanspruchag();
        bo.mAnwerbungan = this.getAnwerbungan();
        bo.mEntscheidungarbver = this.getEntscheidungarbver();
        bo.mEntlassung = this.getEntlassung();
        bo.mEntscheidungaufg = this.getEntscheidungaufg();
        bo.mAEinsFirma = this.getAEinsFirma().createNew(bo);
        bo.mAnzahlkontakteag = 0;
        bo.mNennenswerttaetig = this.getNennenswerttaetig();
        bo.mWeiterespersonal = this.getWeiterespersonal();
        bo.mWirtschaftssektor = this.getWirtschaftssektor();
        bo.mDatensatzidursprung = this.getDatensatzidursprung();
        bo.mVorgangsid = this.getVorgangsid();
        bo.mAnzahlStelleschiff = this.getAnzahlStelleschiff();
        AEinsStelleschiff[] stelleschiff = new AEinsStelleschiff[this.getAEinsStelleschiff().length];
        for (int i = 0; i < stelleschiff.length; ++i) {
            stelleschiff[i] = this.getAEinsStelleschiff()[i].createNew(bo);
        }
        bo.mAEinsStelleschiff = stelleschiff;
        bo.mGeringfuegigebeschaeftigung = this.getGeringfuegigebeschaeftigung();
        bo.mAngabeneinverstanden = this.getAngabeneinverstanden();
        bo.mAbhaengigebeschaeftigung = this.getAbhaengigebeschaeftigung();
        bo.mAccount = account;
        return bo;
    }

    public void makeSaveable() {
        super.makeSaveable();
        this.getAEinsAn().makeSaveable();
        this.getAEinsFirma().makeSaveable();
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsAbloesung()) {
            aEinsAbloesung.makeSaveable();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsAnschrift()) {
            aEinsAbloesung.makeSaveable();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsEntsendung()) {
            aEinsAbloesung.makeSaveable();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsStelle()) {
            aEinsAbloesung.makeSaveable();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsStelleschiff()) {
            aEinsAbloesung.makeSaveable();
        }
    }

    public void makeReadOnly() {
        super.makeReadOnly();
        this.getAEinsAn().makeReadOnly();
        this.getAEinsFirma().makeReadOnly();
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsAbloesung()) {
            aEinsAbloesung.makeReadOnly();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsAnschrift()) {
            aEinsAbloesung.makeReadOnly();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsEntsendung()) {
            aEinsAbloesung.makeReadOnly();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsStelle()) {
            aEinsAbloesung.makeReadOnly();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsStelleschiff()) {
            aEinsAbloesung.makeReadOnly();
        }
    }

    protected void destroyImpl() throws BusinessDomainException {
        this.requireLoaded();
        this.getAEinsAn().destroy();
        this.getAEinsFirma().destroy();
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsAbloesung()) {
            aEinsAbloesung.destroy();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsAnschrift()) {
            aEinsAbloesung.destroy();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsEntsendung()) {
            aEinsAbloesung.destroy();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsStelle()) {
            aEinsAbloesung.destroy();
        }
        for (AEinsAbloesung aEinsAbloesung : this.getAEinsStelleschiff()) {
            aEinsAbloesung.destroy();
        }
    }

    public void checkAttributes(AEinsAccount account) throws BusinessDomainException {
        if (this.getAEinsFirma().getRechtsform() != 2 && DateHelper.getDiffInMonths((Date)this.getEndeentsendung(), (Date)this.getBeginnentsendung()) >= 24) {
            account.addError("Nur f\u00fcr Mitarbeiter mit der Rechtsform 2 (\u00d6ffentlich) sind Zeitr\u00e4ume von mehr als 24 Monaten zul\u00e4ssig.");
        }
        if (this.getStaatentsendung() == null || !AEinsHelper.checkState((String)this.getStaatentsendung())) {
            account.addError("Der Mitglieds-/Flaggenstaat entspricht nicht den EU-Staaten, EWR-Staaten oder der Schweiz.");
        }
        this.getAEinsAn().check(account);
        AEinsHelper.checkAnschriften((AEinsAnschrift[])this.getAEinsAnschrift(), (AEinsAccount)account);
        for (AEinsAnschrift aEinsAnschrift : this.getAEinsAnschrift()) {
            aEinsAnschrift.check(account, false);
        }
        for (AEinsAnschrift aEinsAnschrift : this.getAEinsStelle()) {
            aEinsAnschrift.check(account, true, this.getStaatentsendung());
        }
        this.getAEinsFirma().check(account, false);
        for (AEinsAnschrift aEinsAnschrift : this.getAEinsEntsendung()) {
            aEinsAnschrift.check(account);
        }
        for (AEinsAnschrift aEinsAnschrift : this.getAEinsAbloesung()) {
            aEinsAnschrift.check(account);
        }
        for (AEinsAnschrift aEinsAnschrift : this.getAEinsStelleschiff()) {
            aEinsAnschrift.check(account);
        }
        this.checkMisc(account);
    }

    private void checkMisc(AEinsAccount account) {
        if (this.getAngabeneinverstanden().equals("N")) {
            account.addError("Die Erkl\u00e4rung des Arbeitgebers zur Richtigkeit muss notwendigerweise mit J angegeben werden.");
        }
        if (StringMapper.isNullString((String)this.getTaetigkeitdeutsch())) {
            account.addError("Der T\u00e4tigkeitsschl\u00fcssel Inland ist zwingend notwendig.");
        }
        if (StringMapper.isNullString((String)this.getTaetigkeitausland())) {
            account.addError("Der T\u00e4tigkeitsschl\u00fcssel Ausland ist zwingend notwendig.");
        }
        if (this.getAbhaengigebeschaeftigung().equals("N")) {
            account.addError("Die Angabe zur Besch\u00e4ftigung im Inland - Abh\u00e4ngige Besch\u00e4ftigung - muss notwendigerweise mit J angegeben werden.");
        }
    }

    public AEinsAn getAEinsAn() {
        if (this.mAEinsAn == null) {
            this.mAEinsAn = (AEinsAn)Deuv.checkDistinct((Object[])((IAEinsAnPersistencyManager)UtilitiesManager.getBean((String)"aEinsAnPersistencyManager", IAEinsAnPersistencyManager.class)).query(null, this.filter()));
        }
        return this.mAEinsAn;
    }

    public AEinsAnschrift[] getAEinsAnschrift() {
        if (this.mAEinsAnschrift == null || this.mAEinsAnschrift.length == 0) {
            if (this.getObjectid() == null) {
                return new AEinsAnschrift[0];
            }
            this.mAEinsAnschrift = ((IAEinsAnschriftPersistencyManager)UtilitiesManager.getBean((String)"aEinsAnschriftPersistencyManager", IAEinsAnschriftPersistencyManager.class)).query(new Order[]{Order.asc((String)"anschriftsart")}, this.filter());
        }
        return this.mAEinsAnschrift;
    }

    public AEinsStelle[] getAEinsStelle() {
        if (this.mAEinsStelle == null || this.mAEinsStelle.length == 0) {
            if (this.getObjectid() == null) {
                return new AEinsStelle[0];
            }
            this.mAEinsStelle = ((IAEinsStellePersistencyManager)UtilitiesManager.getBean((String)"aEinsStellePersistencyManager", IAEinsStellePersistencyManager.class)).query(null, this.filter());
        }
        return this.mAEinsStelle;
    }

    public AEinsStelleschiff[] getAEinsStelleschiff() {
        if (this.mAEinsStelleschiff == null || this.mAEinsStelleschiff.length == 0) {
            if (this.getObjectid() == null) {
                return new AEinsStelleschiff[0];
            }
            this.mAEinsStelleschiff = ((IAEinsStelleschiffPersistencyManager)UtilitiesManager.getBean((String)"aEinsStelleschiffPersistencyManager", IAEinsStelleschiffPersistencyManager.class)).query(null, this.filter());
        }
        return this.mAEinsStelleschiff;
    }

    public AEinsEntsendung[] getAEinsEntsendung() {
        if (this.mAEinsEntsendung == null || this.mAEinsEntsendung.length == 0) {
            if (this.getObjectid() == null) {
                return new AEinsEntsendung[0];
            }
            this.mAEinsEntsendung = ((IAEinsEntsendungPersistencyManager)UtilitiesManager.getBean((String)"aEinsEntsendungPersistencyManager", IAEinsEntsendungPersistencyManager.class)).query(null, this.filter());
        }
        return this.mAEinsEntsendung;
    }

    public AEinsAbloesung[] getAEinsAbloesung() {
        if (this.mAEinsAbloesung == null || this.mAEinsAbloesung.length == 0) {
            this.mAEinsAbloesung = ((IAEinsAbloesungPersistencyManager)UtilitiesManager.getBean((String)"aEinsAbloesungPersistencyManager", IAEinsAbloesungPersistencyManager.class)).query(null, this.filter());
        }
        return this.mAEinsAbloesung;
    }

    public AEinsFirma getAEinsFirma() {
        if (this.mAEinsFirma == null) {
            this.mAEinsFirma = (AEinsFirma)Deuv.checkDistinct((Object[])((IAEinsFirmaPersistencyManager)UtilitiesManager.getBean((String)"aEinsFirmaPersistencyManager", IAEinsFirmaPersistencyManager.class)).query(null, this.filter()));
        }
        return this.mAEinsFirma;
    }

    private Criterion filter() {
        return Restrictions.and((Criterion)Restrictions.eq((String)"oidaeinsdxa1", (String)this.getObjectid()), (Criterion)Restrictions.isNotNull((String)"oidaeinsdxa1"));
    }

    public boolean hasAbloesung() {
        return this.getAEinsAbloesung().length > 0;
    }

    public AEinsAn createAEinsAn() {
        if (this.mAEinsAn != null) {
            throw new IllegalStateException("mAEinsAn already exists");
        }
        this.mAEinsAn = new AEinsAn(this);
        this.mAEinsAn.createPerson();
        return this.mAEinsAn;
    }

    public AEinsFirma createAEinsFirma() {
        if (this.mAEinsFirma != null) {
            throw new IllegalStateException("mAEinsFirma already exists");
        }
        this.mAEinsFirma = new AEinsFirma(this);
        this.mAEinsFirma.createAdresse();
        this.mAEinsFirma.createKommunikation();
        return this.mAEinsFirma;
    }

    public AEinsAbloesung[] createAbloesung() {
        if (this.mAEinsAbloesung != null && this.mAEinsAbloesung.length > 0) {
            throw new IllegalStateException("AEinsAbl\u00f6sung already exists");
        }
        this.mAEinsAbloesung = new AEinsAbloesung[1];
        this.mAEinsAbloesung[0] = new AEinsAbloesung(this);
        return this.mAEinsAbloesung;
    }

    public boolean hasAnschrift() {
        return this.getAEinsAnschrift().length > 0;
    }

    public AEinsAnschrift[] createAnschrift(int length) {
        if (this.mAEinsAnschrift != null && this.mAEinsAnschrift.length > 0) {
            throw new IllegalStateException("AEinsAnschrift already exists");
        }
        this.mAEinsAnschrift = new AEinsAnschrift[length];
        for (int i = 0; i < this.mAEinsAnschrift.length; ++i) {
            this.mAEinsAnschrift[i] = new AEinsAnschrift(this);
        }
        return this.mAEinsAnschrift;
    }

    public boolean hasStelle() {
        return this.getAEinsStelle().length > 0;
    }

    public AEinsStelle[] createStelle(int length) {
        if (this.mAEinsStelle != null && this.mAEinsStelle.length > 0) {
            throw new IllegalStateException("AEinsStelle already exists");
        }
        this.mAEinsStelle = new AEinsStelle[length];
        for (int i = 0; i < this.mAEinsStelle.length; ++i) {
            this.mAEinsStelle[i] = new AEinsStelle(this);
        }
        return this.mAEinsStelle;
    }

    public boolean hasStelleschiff() {
        return this.getAEinsStelleschiff().length > 0;
    }

    public AEinsStelleschiff[] createStelleschiff(int length) {
        if (this.mAEinsStelleschiff != null && this.mAEinsStelleschiff.length > 0) {
            throw new IllegalStateException("AEinsStelleschiff already exists");
        }
        this.mAEinsStelleschiff = new AEinsStelleschiff[length];
        for (int i = 0; i < this.mAEinsStelleschiff.length; ++i) {
            this.mAEinsStelleschiff[i] = new AEinsStelleschiff(this);
        }
        return this.mAEinsStelleschiff;
    }

    public boolean hasEntsendung() {
        return this.getAEinsEntsendung().length > 0;
    }

    public AEinsEntsendung[] createEntsendung(int length) {
        if (this.mAEinsEntsendung != null && this.mAEinsEntsendung.length > 0) {
            throw new IllegalStateException("AEinsEntsendung already exists");
        }
        this.mAEinsEntsendung = new AEinsEntsendung[length];
        for (int i = 0; i < this.mAEinsEntsendung.length; ++i) {
            this.mAEinsEntsendung[i] = new AEinsEntsendung(this);
        }
        return this.mAEinsEntsendung;
    }

    public boolean hasZustaendigkeitabv() {
        return !StringMapper.isNullString((String)this.getMitgliedsnummerabv());
    }

    public static AEinsDxa1[] getDxa1s(Criterion filters, Order[] sortierung) {
        return ((IAEinsDxa1PersistencyManager)UtilitiesManager.getBean((String)"aEinsDxa1PersistencyManager", IAEinsDxa1PersistencyManager.class)).query(sortierung, filters);
    }

    public String getBisherigerEinsatz() {
        return this.getAEinsEntsendung() != null && this.mAEinsEntsendung.length > 0 ? "J" : "N";
    }
}

