/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.employee.entry;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.AbstractApplicationService;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.eequantity.EmployeeQuantityChecker;
import com.varial.personnel.domain.employee.eequantity.EmployeeQuantityStruct;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.IEmploymentPersistencyManager;
import com.varial.personnel.domain.employee.employment.mapper.IEmploymentMapper;
import com.varial.personnel.domain.employee.entry.EntryStruct;
import com.varial.personnel.domain.employee.entry.MigrationEmployeeStruct;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.mapper.IEmployeeShortMapper;
import com.varial.personnel.domain.employee.master.EEMasterStruct;
import com.varial.personnel.domain.employee.master.IMasterPersistencyManager;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.master.mapper.EEMasterMapper;
import com.varial.personnel.domain.employee.master.mapper.IMasterMapper;
import com.varial.personnel.domain.employee.migration.MigrationEmployee;
import com.varial.personnel.domain.employee.migration.MigrationLoader;
import com.varial.personnel.domain.employee.migration.mapper.MigrationEmployeeMapper;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.mapper.PCompanyExceptionMapper;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.framework.audit.IRequestAndAuditBc;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.servantimpl.employee.entry.EntryServantService;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class EntryServantImpl
extends AbstractApplicationService
implements EntryServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEMasterStruct createEmployee(AuthorizationToken token, EntryStruct entry, boolean retroactivEntry, String journalizedUntil) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateMasterRight(), entry.oidPCompany);
            this.beginUpdateService();
            try {
                PCompany pc = PCompanyPersistencyManager.getPCompany((String)entry.oidPCompany);
                pc.requireLoaded();
            }
            catch (IncorrectResultSizeDataAccessException e) {
                throw PCompanyExceptionMapper.makeNoPersonnelPCompanyDomainException();
            }
            Date dateOfEntry = DateMapper.toDate((String)entry.dateOfEntry);
            Date dateOfJournalizedUntil = null;
            if (retroactivEntry) {
                dateOfJournalizedUntil = DateMapper.toDate((String)journalizedUntil);
                if (dateOfJournalizedUntil == null) {
                    throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"journalisiert bis");
                }
                if (!DateHelper.equal((Date)dateOfJournalizedUntil, (Date)DateHelper.getLastDayOfMonth((Date)dateOfJournalizedUntil))) {
                    throw EmployeeExceptionMapper.makeJournalizedUntilIsNotLastDayOfMonthDomainException();
                }
                if (dateOfEntry == null) {
                    throw EmployeeExceptionMapper.makeDateOfEntryMissingDomainException();
                }
                if (DateHelper.before((Date)dateOfJournalizedUntil, (Date)DateHelper.getFirstDayOfMonth((Date)dateOfEntry))) {
                    throw EmployeeExceptionMapper.makeIsNotRetroactiveEntryDomainException();
                }
            }
            Employee employee = IEmployeePersistencyManager.getInstance().createEmployee();
            IEmployeeShortMapper.getInstance().fillEmployee(employee, entry);
            Employment employment = IEmploymentPersistencyManager.getInstance().createEmployment(employee);
            employment.setSpecialChecks(false);
            employment.setWithDrawalDeath(false);
            IEmploymentMapper.getInstance().fillEmployment(employment, entry, true);
            employee.addEmploymentHistory(employment, true);
            employment.checkPlantPlace();
            Master master = IMasterPersistencyManager.getInstance().createMaster(employee);
            IMasterMapper.getInstance().fillMaster(master, entry);
            employee.addMasterHistory(master, true);
            IRequestAndAuditBc.getInstance().auditEntry(master, employment);
            employee.setRetroactiveEntry(retroactivEntry);
            if (retroactivEntry) {
                employee.setStartEffectiveFrom(DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
                employee.setJournalizedUntil(dateOfJournalizedUntil);
            }
            this.getContext().flush();
            EEMasterStruct eEMasterStruct = EEMasterMapper.toIdl((Master)employee.getActiveMaster());
            return eEMasterStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EEMasterStruct createEmployeeCopy(AuthorizationToken token, EntryStruct entry, String oidReferenceEmployee, boolean retroactivEntry, String journalizedUntil, boolean withdrawalReference) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateMasterRight(), entry.oidPCompany);
            this.beginUpdateService();
            Date dateOfEntry = DateMapper.toDate((String)entry.dateOfEntry);
            if (dateOfEntry == null) {
                throw EmployeeExceptionMapper.makeDateOfEntryMissingDomainException();
            }
            try {
                PCompany pc = PCompanyPersistencyManager.getPCompany((String)entry.oidPCompany);
                pc.requireLoaded();
            }
            catch (IncorrectResultSizeDataAccessException e) {
                throw PCompanyExceptionMapper.makeNoPersonnelPCompanyDomainException();
            }
            Date dateOfJournalizedUntil = null;
            if (retroactivEntry) {
                dateOfJournalizedUntil = DateMapper.toDate((String)journalizedUntil);
                if (dateOfJournalizedUntil == null) {
                    throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"journalisiert bis");
                }
                if (!DateHelper.equal((Date)dateOfJournalizedUntil, (Date)DateHelper.getLastDayOfMonth((Date)dateOfJournalizedUntil))) {
                    throw EmployeeExceptionMapper.makeJournalizedUntilIsNotLastDayOfMonthDomainException();
                }
                if (DateHelper.before((Date)dateOfJournalizedUntil, (Date)DateHelper.getFirstDayOfMonth((Date)dateOfEntry))) {
                    throw EmployeeExceptionMapper.makeIsNotRetroactiveEntryDomainException();
                }
            }
            Employee oldEmployee = IEmployeePersistencyManager.getInstance().getEmployee(oidReferenceEmployee);
            Date dayBeforeEntry = DateHelper.yesterday((Date)dateOfEntry);
            Employment employmentOld = oldEmployee.getEmployment(DateHelper.tomorrow((Date)oldEmployee.getJournalizedUntil()), dayBeforeEntry);
            Employment employmentNew = null;
            if (withdrawalReference) {
                if (employmentOld.getDateOfWithDrawal() != null) {
                    throw EmployeeExceptionMapper.makeCopyOfEmployeeNotPossibleDomainException();
                }
                employmentNew = employmentOld.createNew();
                employmentNew.setEffectiveFrom(DateHelper.tomorrow((Date)oldEmployee.getJournalizedUntil()));
                employmentNew.setValidFrom(DateHelper.max((Date)employmentOld.getDateOfEntry(), (Date)DateHelper.getFirstDayOfMonth((Date)dayBeforeEntry)));
                employmentNew.setDateOfWithDrawal(dayBeforeEntry);
                employmentNew.setDateOfWithDrawalSI(dayBeforeEntry);
                employmentNew.setCheckInsolvency(false);
                employmentNew.setSpecialChecks(false);
                employmentNew.specialCheckDateOfWithdrawal();
                oldEmployee.addEmploymentHistory(employmentNew, true);
                this.getContext().flush();
            }
            Employee employee = IEmployeePersistencyManager.getInstance().createEmployee();
            IEmployeeShortMapper.getInstance().fillEmployee(employee, entry);
            Employment employment = IEmploymentPersistencyManager.getInstance().createEmployment(employee);
            employment.setCheckInsolvency(false);
            employment.setSpecialChecks(false);
            IEmploymentMapper.getInstance().fillEmploymentMore(employment, entry, employmentOld, true);
            employee.addEmploymentHistory(employment, true);
            employment.checkPlantPlace();
            Master master = IMasterPersistencyManager.getInstance().createMaster(employee);
            IMasterMapper.getInstance().fillMaster(master, entry);
            Master oldMaster = oldEmployee.getMaster(VDate.getDateMax(), VDate.getDateMax());
            master.setPrivateCommunication(oldMaster.getPrivateCommunication());
            master.setServiceEmailAddress(oldMaster.getServiceEmailAddress());
            employee.addMasterHistory(master, true);
            employee.setRetroactiveEntry(retroactivEntry);
            if (retroactivEntry) {
                employee.setStartEffectiveFrom(DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
                employee.setJournalizedUntil(dateOfJournalizedUntil);
            }
            if (employmentNew != null) {
                IValuationManager.getInstance().valuate(token, oldEmployee, employmentNew.getEffectiveFrom(), employmentNew.getValidFrom(), employmentNew.getClass().getName());
            }
            this.getContext().flush();
            EEMasterStruct eEMasterStruct = EEMasterMapper.toIdl((Master)employee.getActiveMaster());
            return eEMasterStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationEmployeeStruct[] getMigrationEmployees(AuthorizationToken token, String pCompanyKey, String personnelNumber, String firstName, String lastName, String dateOfBirth) throws BusinessDomainException {
        try {
            this.beginQueryService();
            MigrationLoader loader = new MigrationLoader();
            MigrationEmployee[] mes = loader.getMigrationEmployees(pCompanyKey, personnelNumber, lastName, firstName, dateOfBirth);
            MigrationEmployeeStruct[] migrationEmployeeStructArray = MigrationEmployeeMapper.toIdl((MigrationEmployee[])mes);
            return migrationEmployeeStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryStruct getMigrationEmployee(AuthorizationToken token, String migrationPCompanyKey, String migrationPersonnelNumber, String targetPCompanyKey) throws BusinessDomainException {
        try {
            this.beginQueryService();
            MigrationLoader ml = new MigrationLoader();
            ml.readEmployee(migrationPCompanyKey, migrationPersonnelNumber, targetPCompanyKey);
            Employee employee = ml.getEmployee();
            Master master = ml.getMaster();
            Employment employment = ml.getEmployment();
            EntryStruct entryStruct = MigrationEmployeeMapper.toIdl((Employee)employee, (Master)master, (Employment)employment);
            return entryStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNotUsedPersonnelnumber(AuthorizationToken token, String oidPCompany, int startPersonnelNumber) throws BusinessDomainException {
        try {
            this.beginQueryService();
            int n = IEmployeePersistencyManager.getInstance().getNextNotUnsedPersonnelnumber(oidPCompany, startPersonnelNumber);
            return n;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmployeeQuantityStruct checkEntryAllowance(AuthorizationToken token, String eeValue) throws BusinessDomainException {
        try {
            this.beginQueryService();
            EmployeeQuantityChecker checker = new EmployeeQuantityChecker(eeValue);
            EmployeeQuantityStruct employeeQuantityStruct = checker.check();
            return employeeQuantityStruct;
        }
        finally {
            this.endService();
        }
    }
}

