/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.framework.checkrun;

import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.setting.Setting;
import com.varial.framework.domain.setting.SettingPersistencyManager;
import com.varial.personnel.domain.deuvmessaging.CheckOfUntransmitted;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.accidentinsurancefund.EEAccidentInsuranceFund;
import com.varial.personnel.domain.employee.contacts.EmployeeContact;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.InsuranceCheckUp;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionScheme;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemePersistencyManager;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pueg.puegaccount.IPuegAccountPersistencyManager;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.dsln.IUvDslnPersistencyManager;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.checkrun.ModuleOfMessageEnum;
import com.varial.personnel.framework.checkrun.ResultMessageBean;
import com.varial.personnel.framework.checkrun.ScopeOfMessageEnum;
import com.varial.personnel.framework.checkrun.TypeOfMessageEnum;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.PutDataException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckRun {
    private static Logger LOGGER = LoggerFactory.getLogger(CheckRun.class);
    private static final Date CHECK_TIME_POINT = VDate.getDateMax();
    private final ProgressBarUpdater mProgressBar;
    private final ScopeOfMessageEnum mScopeOfMessage;
    private final PersistencySession mContext;
    private final PCompany mPcompany;
    private final Employee[] mEmployees;
    private Master mMaster;
    private Employment mEmployment;
    private boolean mIsDemoCompany = false;
    private final List<ResultMessageBean> mResultMessageBeans = new ArrayList<ResultMessageBean>();
    private boolean mStatusOfCheck = true;
    private boolean mStatusOfCheckAll = true;

    public CheckRun(ProgressBarUpdater progressbar, PCompany pCompany, ScopeOfMessageEnum scopeOfMessage, Employee[] employees, PersistencySession context) {
        this.mProgressBar = progressbar;
        this.mPcompany = pCompany;
        this.mScopeOfMessage = scopeOfMessage;
        this.mEmployees = employees;
        this.mContext = context;
        if (this.isDemoCompany(pCompany)) {
            this.mIsDemoCompany = true;
        }
    }

    public void check() throws BusinessDomainException, PutDataException {
        this.mProgressBar.setTotal(this.mEmployees.length + 1);
        for (int i = 0; i < this.mEmployees.length; ++i) {
            this.mProgressBar.update("pr\u00fcfen Firma/Pnr.: " + this.mEmployees[i].getDomainKey());
            this.mStatusOfCheck = true;
            if (this.mIsDemoCompany) {
                this.mEmployees[i].makeSaveable();
                this.mEmployees[i].setMasterdatachecked(false);
                this.mContext.flush();
                continue;
            }
            this.employeeCheck(this.mEmployees[i]);
            if (this.mStatusOfCheck == this.mEmployees[i].getMasterdatachecked()) continue;
            this.mEmployees[i].makeSaveable();
            this.mEmployees[i].setMasterdatachecked(this.mStatusOfCheck);
            this.mContext.flush();
        }
        this.globalCheck();
        this.checkPueg();
    }

    private void employeeCheck(Employee employee) throws BusinessDomainException {
        if (!employee.isSuitableForCheckup()) {
            return;
        }
        this.mMaster = (Master)employee.getMasterHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax());
        this.mEmployment = (Employment)employee.getEmploymentHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax());
        this.masterCheck(employee);
        this.employmentCheck(employee);
        this.taxCheck(employee);
        this.insuranceCheck(employee);
        this.eePensionSchemeCheck(employee);
        this.zvkCheck(employee);
        this.accidentInsuranceFundCheck(employee);
        this.checkAccidentInsuranceFundAgainstDssd(employee);
        this.checkOperationBAV(employee);
        this.checkGeringfuegigkeitsstatusJahr(employee);
        this.eeAbsentTimeCheck(employee);
    }

    private void masterCheck(Employee employee) throws BusinessDomainException {
        Master master;
        block19: {
            employee = this.getIEmployeePM().getEmployee(employee.getObjectid());
            master = (Master)employee.getMasterHistory().getItemOrNull(CHECK_TIME_POINT, CHECK_TIME_POINT);
            if (master == null) {
                return;
            }
            try {
                master.setSpecialChecks(false);
                master.checkAttributes();
            }
            catch (BusinessDomainException e) {
                this.mStatusOfCheck = false;
                this.mStatusOfCheckAll = false;
                if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break block19;
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), e.getMessage()));
            }
        }
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        try {
            master.checkCivilStatus();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), e.getMessage()));
        }
        try {
            master.checkSOEeMail();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), "Die E-Mail-Adresse f\u00fcr Verdienstnachweis per E-Mail hat keinen korrekten Aufbau"));
        }
        try {
            master.checkSelfserviceEMails();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), "Die E-Mail-Adresse f\u00fcr die Steuerung des Self Service hat keinen korrekten Aufbau"));
        }
        try {
            if (master.getPrivateCommunication() != null) {
                master.getPrivateCommunication().checkAttributes();
            }
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), "Die E-Mail-Adresse in den privaten Kontakten hat keinen korrekten Aufbau"));
        }
        try {
            if (master.getCompanyCommunication() != null) {
                master.getCompanyCommunication().checkAttributes();
            }
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), "Die E-Mail-Adresse in den betrieblichen Kontakten hat keinen korrekten Aufbau"));
        }
        try {
            for (EmployeeContact each : master.getEmployee().getEmployeeContact()) {
                each.getAssignmentContact().checkEmail();
            }
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_PERS_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, master.getValidFrom(), "Eine E-Mail-Adresse eines Ansprechpartners hat keinen korrekten Aufbau"));
        }
    }

    private void employmentCheck(Employee employee) throws BusinessDomainException {
        Employment employment;
        block9: {
            employee = this.getIEmployeePM().getEmployee(employee.getObjectid());
            employment = (Employment)employee.getEmploymentHistory().getItemOrNull(CHECK_TIME_POINT, CHECK_TIME_POINT);
            if (employment == null) {
                return;
            }
            try {
                employment.setSpecialChecks(false);
                employment.setCheckInsolvency(true);
                employment.checkAttributes();
            }
            catch (BusinessDomainException e) {
                if (e.getErrorNumber() == 2213) {
                    this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESCHAEFTIGUNG_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, employment.getValidFrom(), e.getMessage()));
                    return;
                }
                this.mStatusOfCheck = false;
                this.mStatusOfCheckAll = false;
                if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break block9;
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESCHAEFTIGUNG_DATEN, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, employment.getValidFrom(), e.getMessage()));
            }
        }
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        try {
            employment.specialCheckPersonInCharge();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESCHAEFTIGUNG_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, employment.getValidFrom(), e.getMessage()));
        }
        try {
            employment.specialcheckPlantPlace(DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESCHAEFTIGUNG_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, employment.getValidFrom(), e.getMessage()));
        }
    }

    private void taxCheck(Employee employee) throws BusinessDomainException {
        Tax tax;
        block9: {
            employee = this.getIEmployeePM().getEmployee(employee.getObjectid());
            tax = (Tax)employee.getTaxHistory().getItemOrNull(CHECK_TIME_POINT, CHECK_TIME_POINT);
            if (tax == null) {
                return;
            }
            if (this.noCheck(employee)) {
                return;
            }
            try {
                tax.setSpecialChecks(true);
                tax.checkAttributes();
                tax.specialCheckPAYETaxFindingGuenstigerpruefung();
                tax.specialCheckForTaxBraket();
            }
            catch (BusinessDomainException e) {
                this.mStatusOfCheck = false;
                this.mStatusOfCheckAll = false;
                if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break block9;
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESTEUERUNG_DATEN, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, tax.getValidFrom(), e.getMessage()));
            }
        }
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        try {
            tax.specialCheckAssociationEE();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESTEUERUNG_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, tax.getValidFrom(), e.getMessage()));
        }
        try {
            tax.checkNIChildEducationAndChildRelief();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BESTEUERUNG_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, tax.getValidFrom(), e.getMessage()));
        }
    }

    private void insuranceCheck(Employee employee) throws BusinessDomainException {
        InsuranceCheckUp insuranceCheckUp;
        Insurance insurance;
        block24: {
            employee = this.getIEmployeePM().getEmployee(employee.getObjectid());
            insurance = (Insurance)employee.getInsuranceHistory().getItemOrNull(CHECK_TIME_POINT, CHECK_TIME_POINT);
            if (insurance == null) {
                return;
            }
            insuranceCheckUp = new InsuranceCheckUp(employee, insurance, null);
            Date checkDate = DateHelper.tomorrow((Date)employee.getJournalizedUntil());
            try {
                insurance.setSpecialChecks(false);
                insurance.checkAttributes();
                if (insurance.getHealthFund() != null) {
                    this.checkHealthFundMerger(employee, insurance, "Die ausgew\u00e4hlte Krankenkasse ", insurance.getHealthFund(), checkDate);
                }
                if (insurance.getAssessmentHealthFund() != null) {
                    this.checkHealthFundMerger(employee, insurance, "Die ausgew\u00e4hlte Umlagekasse ", insurance.getAssessmentHealthFund(), checkDate);
                }
                if (insurance.getInsolvencyHealthFund() != null) {
                    this.checkHealthFundMerger(employee, insurance, "Die ausgew\u00e4hlte InsG-Umlagekenkasse ", insurance.getInsolvencyHealthFund(), checkDate);
                }
                if (insurance.getHealthFundKVdR() != null) {
                    this.checkHealthFundMerger(employee, insurance, "Die ausgew\u00e4hlte KVdR-Krankenkasse ", insurance.getHealthFundKVdR(), checkDate);
                }
                employee.specialCheckAgePartTimePrueflauf();
                insuranceCheckUp.specialcheckIndividualAmountForKVdR();
                insuranceCheckUp.specialcheckCompleteOccupationLong();
                checkDate = insurance.getValidFrom();
                int yearOfJournalizedUntil = new VDate(employee.getJournalizedUntil()).getYear();
                Date smallestCheckDate = new VDate(yearOfJournalizedUntil, 0, 1).getDate();
                if (DateHelper.before((Date)checkDate, (Date)smallestCheckDate)) {
                    checkDate = smallestCheckDate;
                }
                insuranceCheckUp.specialCheckLumpSumAndPersongroup(checkDate);
            }
            catch (BusinessDomainException e) {
                this.mStatusOfCheck = false;
                this.mStatusOfCheckAll = false;
                if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break block24;
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
            }
        }
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        try {
            employee.specialCheckLowWageUpperLimit();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
        try {
            insuranceCheckUp.checkPersonGroupAndInsolvencyDuty();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
        try {
            insuranceCheckUp.specialcheckKVdRandVBZ(CHECK_TIME_POINT, insurance.getValidFrom());
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
        try {
            insuranceCheckUp.extendedCheckDecreaseOfDuesInReducedHours(DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
        try {
            if (insurance.getOccupationLong() != null) {
                insuranceCheckUp.checkValidityAfter2018();
            }
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
        try {
            insuranceCheckUp.isLegalHealthFundRequired();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
        try {
            insuranceCheckUp.specialCheckPensionFirst();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
        }
    }

    private void eePensionSchemeCheck(Employee employee) throws BusinessDomainException {
        EEPensionScheme[] eePensionSchemes;
        employee = this.getIEmployeePM().getEmployee(employee.getObjectid());
        for (EEPensionScheme each : eePensionSchemes = EEPensionSchemePersistencyManager.query(null, (Criterion)Restrictions.eq((String)"OIDEMPLOYEE", (String)employee.getObjectid()))) {
            EEPensionSchemeTP eePensionSchemeTP = (EEPensionSchemeTP)each.getHistory().getItemOrNull(CHECK_TIME_POINT, CHECK_TIME_POINT);
            if (eePensionSchemeTP == null || this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) continue;
            try {
                eePensionSchemeTP.checkAdvancement();
            }
            catch (BusinessDomainException e) {
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BAV, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, eePensionSchemeTP.getValidFrom(), e.getMessage()));
            }
        }
    }

    private void checkHealthFundMerger(Employee employee, Insurance insurance, String subMessage, HealthFund healthFund, Date checkDate) throws BusinessDomainException {
        block3: {
            if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
                return;
            }
            Date lastDateOfWithdrawal = employee.getLastDateOfWithdrawal();
            Date standardCompanyNumberValidUntil = healthFund.getHealthFundTP(checkDate, checkDate).getStandardCompanyNumberValidUntil();
            try {
                InsuranceCheckUp insuranceCheckUp = new InsuranceCheckUp(employee, insurance, null);
                insuranceCheckUp.checkHealthFundMerger(subMessage, healthFund, checkDate);
            }
            catch (BusinessDomainException e) {
                if (lastDateOfWithdrawal != null && standardCompanyNumberValidUntil != null && DateHelper.beforeOrEqual((Date)lastDateOfWithdrawal, (Date)standardCompanyNumberValidUntil)) break block3;
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_SV_DATEN, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, insurance.getValidFrom(), e.getMessage()));
            }
        }
    }

    private void accidentInsuranceFundCheck(Employee employee) throws BusinessDomainException {
        if (this.noCheck(employee)) {
            return;
        }
        EEAccidentInsuranceFund eeAccidentInsuranceFund = null;
        Date validTimePoint = DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
        eeAccidentInsuranceFund = (EEAccidentInsuranceFund)employee.getEEAccidentInsuranceFundHistory().getItemOrNull(VDate.getDateMax(), validTimePoint);
        if (eeAccidentInsuranceFund == null || eeAccidentInsuranceFund.getAccidentInsuranceFund() == null) {
            if (!employee.checkAccidentInsuranceFundIsNecessary(validTimePoint)) {
                return;
            }
            this.mStatusOfCheck = false;
            this.mStatusOfCheckAll = false;
            if (this.mScopeOfMessage != ScopeOfMessageEnum.NUR_HINWEISE) {
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BG, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, new Date(), "Dem Mitarbeiter ist keine Haupt-Berufsgenossenschaft zugeordnet"));
            }
        }
    }

    private void checkAccidentInsuranceFundAgainstDssd(Employee employee) throws BusinessDomainException {
        Date start = DateHelper.getFirstDayOfYear((Date)employee.getJournalizedUntil());
        if (new VDate(employee.getJournalizedUntil()).getMonth() <= 3) {
            start = new VDate(start).addYears(-1).getDate();
        }
        Date calculationStart = employee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getCalculationStart();
        start = DateHelper.max((Date[])new Date[]{start, new VDate(2017, 0, 1).getDate(), calculationStart});
        Date end = new VDate(employee.getJournalizedUntil()).addMonths(1).getDate();
        end = PDateHelper.minIgnoringNulls((Date[])new Date[]{end, employee.getLastDateOfWithdrawal()});
        this.checkAccidentInsuranceFundAgainstDssd(employee, start, end);
    }

    public void checkAccidentInsuranceFundAgainstDssd(Employee employee, Date validFrom, Date validUntil) throws BusinessDomainException {
        Date start = validFrom;
        while (DateHelper.beforeOrEqual((Date)DateHelper.getLastDayOfMonth((Date)start), (Date)DateHelper.getLastDayOfMonth((Date)validUntil))) {
            block11: {
                Date validTimePoint = DateHelper.getLastDayOfMonth((Date)start);
                if (!employee.isMonthOfEmployment(validTimePoint, VDate.getDateMax())) {
                    start = new VDate(start).addMonths(1).getDate();
                    continue;
                }
                EEAccidentInsuranceFund eeAccidentInsuranceFund = (EEAccidentInsuranceFund)employee.getEEAccidentInsuranceFundHistory().getItemOrNull(VDate.getDateMax(), validTimePoint);
                if (eeAccidentInsuranceFund == null || eeAccidentInsuranceFund.getAccidentInsuranceFund() == null) {
                    block10: {
                        try {
                            if (!employee.checkAccidentInsuranceFundIsNecessary(validTimePoint)) {
                                start = new VDate(start).addMonths(1).getDate();
                            }
                            break block10;
                        }
                        catch (BusinessDomainException de) {
                            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) {
                                throw de;
                            }
                            start = new VDate(start).addMonths(1).getDate();
                        }
                        continue;
                    }
                    this.mStatusOfCheck = false;
                    this.mStatusOfCheckAll = false;
                    if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break;
                    this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BG, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, new Date(), "F\u00fcr die Pr\u00fcfung gegen die r\u00fcckgemeldeten Daten aus dem DSSD fehlt beim Mitarbeiter die Zuordnung einer Haupt-Berufsgenossenschaft."));
                    break;
                }
                try {
                    eeAccidentInsuranceFund.setSpecialChecks(false);
                    eeAccidentInsuranceFund.checkAttributesFromEmployeeCheckup(validTimePoint);
                }
                catch (BusinessDomainException e) {
                    if (e.getErrorNumber() == 100398 || e.getErrorNumber() == 100391 || e.getErrorNumber() == 100399 || e.getErrorNumber() == 100392 || e.getErrorNumber() == 100394 || e.getErrorNumber() == 100393 || e.getErrorNumber() == 100395 || e.getErrorNumber() == 100396) {
                        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) break;
                        this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BG, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, validTimePoint, e.getMessage()));
                        break;
                    }
                    this.mStatusOfCheck = false;
                    this.mStatusOfCheckAll = false;
                    if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break block11;
                    this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BG, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, validTimePoint, e.getMessage()));
                }
            }
            start = new VDate(start).addMonths(1).getDate();
        }
    }

    private void checkOperationBAV(Employee employee) throws BusinessDomainException {
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        ValueType[] valueTypes = ValueTypeHelper.getValueTypes((int[])new int[]{145230, 145235, 145335, 145385, 145130, 145180});
        Date effectiveTimePoint = DateHelper.tomorrow((Date)employee.getJournalizedUntil());
        String effectiveTimePointAsString = DateMapper.toString((Date)effectiveTimePoint);
        String validTimePointAsString = DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)employee.getJournalizedUntil())));
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidvaluetype", (String)valueTypes[0].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[1].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[2].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[3].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[4].getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueTypes[5].getObjectid())}), Restrictions.le((String)"effectivefrom", (String)effectiveTimePointAsString), Restrictions.ge((String)"effectiveuntil", (String)effectiveTimePointAsString), Restrictions.le((String)"validfrom", (String)validTimePointAsString), Restrictions.ge((String)"validuntil", (String)validTimePointAsString), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"results"), Restrictions.eq((String)"results", (String)String.valueOf(BigDecimalMapper.ZERO))})});
        if (ValuePositionPersistencyManager.exists((Criterion)filter)) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BAV, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, effectiveTimePoint, "Eine lfd. BAV kann in diesem Monat nicht bedient werden, da das lfd. beitragspflichtige Entgelt nicht ausreicht!"));
        }
    }

    private void zvkCheck(Employee employee) throws BusinessDomainException {
        EEZVK zvk;
        block8: {
            employee = this.getIEmployeePM().getEmployee(employee.getObjectid());
            zvk = (EEZVK)employee.getZVKHistory().getItemOrNull(CHECK_TIME_POINT, CHECK_TIME_POINT);
            if (zvk == null) {
                return;
            }
            try {
                zvk.setSpecialChecks(false);
                zvk.checkAttributes();
            }
            catch (BusinessDomainException e) {
                this.mStatusOfCheck = false;
                this.mStatusOfCheckAll = false;
                if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_HINWEISE) break block8;
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_ZVK, TypeOfMessageEnum.FEHLER, this.mPcompany, employee, this.mMaster, this.mEmployment, zvk.getValidFrom(), e.getMessage()));
            }
        }
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        try {
            zvk.checkAdvancement();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_ZVK, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, zvk.getValidFrom(), e.getMessage()));
        }
        try {
            zvk.checkEntryAndWithdrawal();
        }
        catch (BusinessDomainException e) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_ZVK, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, zvk.getValidFrom(), e.getMessage()));
        }
    }

    private void globalCheck() {
        try {
            List falseMemberschipNumbers;
            if (this.mEmployees.length > 0 && !(falseMemberschipNumbers = this.mPcompany.specialCheckMembershipNumber()).isEmpty()) {
                String messageNumbers = String.join((CharSequence)", ", falseMemberschipNumbers);
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.FIRMA_BG, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Von der Firma: " + this.mPcompany.getPCompanyKey() + " erf\u00fcllen folgende Mitgliedsnummern der Berufsgenossenschaft nicht die neuen Plausibilit\u00e4tspr\u00fcfungen: " + messageNumbers));
            }
        }
        catch (Exception e) {
            LOGGER.error("Fehler beim Pr\u00fcfen der Mitgliedsnummern der Berufsgenossenschaft ", (Throwable)e);
        }
        try {
            if (this.mEmployees.length > 0 && !this.mPcompany.existsStandardCompanyAccount()) {
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.FIRMA_BANKKONTO, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "F\u00fcr die Firma: " + this.mPcompany.getPCompanyKey() + " existiert kein Standardbankkonto"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Fehler beim Pr\u00fcfen der Existenz eines Standardbankkontos ", (Throwable)e);
        }
        try {
            if (!CheckRun.getRunSIMasterdataCheck()) {
                return;
            }
            String nameAktuelleDatei = null;
            try {
                URL itsg = new URL("https://stammdatendatei.gkv-ag.de/Stammdatendatei.zip");
                InputStream inputStream = itsg.openStream();
                ZipInputStream zipInput = new ZipInputStream(inputStream, Charset.forName("ISO-8859-1"));
                ZipEntry zipEntry = zipInput.getNextEntry();
                nameAktuelleDatei = zipEntry.toString();
            }
            catch (IOException e) {
                LOGGER.error("Fehler bei der Bestimmung des Namens der aktuellen SV-Stammdatendatei ", (Throwable)e);
            }
            Object nameLetzteImportDatei = null;
            Setting setting = SettingPersistencyManager.getSetting((String)"SIMasterDataImport", (String)"SIImport", (String)"PW", (String)"FileName");
            if (setting != null && ((String)(nameLetzteImportDatei = setting.getValue())).length() > 27) {
                nameLetzteImportDatei = ((String)nameLetzteImportDatei).substring(((String)nameLetzteImportDatei).length() - 27);
            }
            if (StringMapper.isNullString((String)nameLetzteImportDatei)) {
                throw FrameWorkExceptionMapper.makePublicMessageDomainException((String)"Achtung! Die Aktualisierung der SV-Daten aus der SV-Stammdatendatei fehlt. Bitte die SV-Daten aktualisieren!");
            }
            if (!StringMapper.equal((String)nameAktuelleDatei, (String)nameLetzteImportDatei)) {
                Date datumAktuelleDatei;
                Date datumLetzterSIImport = null;
                setting = SettingPersistencyManager.getSetting((String)"SIMasterDataImport", (String)"SIImport", (String)"PW", (String)"LastImportFromSI");
                if (setting != null) {
                    datumLetzterSIImport = DateMapper.toDate((String)setting.getValue());
                }
                if (datumLetzterSIImport == null || DateHelper.before((Date)datumLetzterSIImport, (Date)DateHelper.add((Date)new Date(), (int)-30))) {
                    this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.GKV_IMPORT, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Achtung! Die letzte Aktualisierung der SV-Daten liegt  mehr als 30 Tage zur\u00fcck. Bitte die SV-Daten aktualisieren!"));
                }
                if (StringMapper.isNullString((String)nameAktuelleDatei)) {
                    datumAktuelleDatei = new Date();
                } else {
                    String datumAktuelleDateiAsString = nameAktuelleDatei.substring(15, 23);
                    datumAktuelleDatei = new VDate(Integer.valueOf(datumAktuelleDateiAsString.substring(0, 4)).intValue(), Integer.valueOf(datumAktuelleDateiAsString.substring(4, 6)) - 1, Integer.valueOf(datumAktuelleDateiAsString.substring(6, 8)).intValue()).getDate();
                }
                if (((String)nameLetzteImportDatei).startsWith("ESDD0-GES_V100") && ((String)nameLetzteImportDatei).length() >= 27) {
                    String datumLetzteImportDateiAsString = ((String)nameLetzteImportDatei).substring(15, 23);
                    Date datumLetzteImportDatei = new VDate(Integer.valueOf(datumLetzteImportDateiAsString.substring(0, 4)).intValue(), Integer.valueOf(datumLetzteImportDateiAsString.substring(4, 6)) - 1, Integer.valueOf(datumLetzteImportDateiAsString.substring(6, 8)).intValue()).getDate();
                    if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)datumLetzteImportDatei), (Date)DateHelper.getFirstDayOfMonth((Date)datumAktuelleDatei)) && DateHelper.getDiffInDays((Date)datumAktuelleDatei, (Date)datumLetzteImportDatei) > 20) {
                        this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.GKV_IMPORT, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Achtung! F\u00fcr die Aktualisierung der SV-Daten steht eine neue aktuelle SV-Stammdatendatei zur Verf\u00fcgung; mehr als 20 Tage aktueller. Bitte die SV-Daten aktualisieren!"));
                    }
                    if (DateHelper.equal((Date)PDateHelper.getFirstDayNextMonth((Date)datumLetzteImportDatei), (Date)DateHelper.getFirstDayOfMonth((Date)datumAktuelleDatei)) && DateHelper.getDiffInDays((Date)datumAktuelleDatei, (Date)datumLetzteImportDatei) > 20) {
                        this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.GKV_IMPORT, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Achtung! F\u00fcr die Aktualisierungder SV-Daten steht eine neue aktuelle SV-Stammdatendatei zur Verf\u00fcgung; mehr als 20 Tage aktueller. Bitte die SV-Daten aktualisieren!"));
                    }
                    if (DateHelper.before((Date)PDateHelper.getFirstDayNextMonth((Date)datumLetzteImportDatei), (Date)DateHelper.getFirstDayOfMonth((Date)datumAktuelleDatei))) {
                        this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.GKV_IMPORT, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Achtung! F\u00fcr die Aktualisierung der SV-Daten steht eine neue aktuelle SV-Stammdatendatei zur Verf\u00fcgung. Bitte die SV-Daten aktualisieren!"));
                    }
                }
                Date datumLetzterKrkAbgleich = null;
                setting = SettingPersistencyManager.getSetting((String)"GKVImport", (String)"GKVImport", (String)"PW", (String)"LastUpdateFromItsg");
                if (setting != null) {
                    datumLetzterKrkAbgleich = DateMapper.toDate((String)setting.getValue());
                }
                if (!DateHelper.equal((Date)datumLetzterSIImport, datumLetzterKrkAbgleich) && (datumLetzterKrkAbgleich == null || DateHelper.before((Date)datumLetzterKrkAbgleich, (Date)DateHelper.add((Date)new Date(), (int)-30)))) {
                    this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.GKV_IMPORT, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Achtung! Der letzte Aktualisiserung der Krankenkassen liegt  mehr als 30 Tage zur\u00fcck. Bitte die SV-Daten aktualisieren!"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Fehler beim Pr\u00fcfen des erfolgten Imports aus der SV-Stammdatendatei", (Throwable)e);
        }
        try {
            String[] messages = CheckOfUntransmitted.getUntransmittedAccounts((String)SessionContext.getInstance().getSession().getUserCode(), (PCompany)this.mPcompany);
            if (messages.length > 0) {
                for (String each : messages) {
                    this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.TRANSFER_ACCOUNT, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "Achtung! " + (String)each));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Fehler beim Pr\u00fcfen auf zu \u00fcbermittelte Meldungen", (Throwable)e);
        }
        try {
            int year = LocalDate.now().minusMonths(1L).getYear() - 1;
            List missingUvDslns = UvHelper.getMissingUvDsln((int)year, (PCompany)this.mPcompany);
            String uvDslnMessage = "F\u00fcr das Vorjahr existieren keine erfolgreich \u00fcbermittelten UV-Lohnnachweise f\u00fcr: ";
            if (!missingUvDslns.isEmpty()) {
                String message = "Achtung! F\u00fcr das Vorjahr existieren keine erfolgreich \u00fcbermittelten UV-Lohnnachweise f\u00fcr: " + String.join((CharSequence)", ", missingUvDslns);
                this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.TRANSFER_UVDSLN, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), message));
            }
        }
        catch (Exception e) {
            LOGGER.error("Fehler beim Pr\u00fcfen auf zu \u00fcbermittelte Meldungen", (Throwable)e);
        }
    }

    private void checkGeringfuegigkeitsstatusJahr(Employee employee) throws BusinessDomainException {
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        Date validTimePoint = DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
        Date effectiveTimePoint = DateHelper.tomorrow((Date)employee.getJournalizedUntil());
        SocialInsuranceTP socialInsuranceTP = this.getSocialInsurance(validTimePoint);
        BigDecimal svGeringfuegigkeitsgrenzeGfb = socialInsuranceTP.getGlobal().getInsignificantMaximumLimitForLowIncomeEarnersAmount();
        BigDecimal gfbGrenze = svGeringfuegigkeitsgrenzeGfb.multiply(BigDecimal.valueOf(14L));
        BigDecimal employeeSVentgelt = this.getSVEntgeltGfB(employee);
        if (BigDecimalMapper.compareTo((BigDecimal)employeeSVentgelt, (BigDecimal)gfbGrenze) > 0) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_BERECHNUNG, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, effectiveTimePoint, "Das 14-fache der GfB-Grenze wird im laufenden Jahr \u00fcberschritten. Bitte GfB-Status pr\u00fcfen."));
        }
    }

    private BigDecimal getSVEntgeltGfB(Employee employee) {
        Date effectiveTimePoint = DateHelper.tomorrow((Date)employee.getJournalizedUntil());
        Date until = DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)employee.getJournalizedUntil()));
        Date from = DateHelper.getLastDayOfMonth((Date)DateHelper.getFirstDayOfYear((Date)until));
        BigDecimal svEntgelt = BigDecimal.ZERO;
        while (DateHelper.beforeOrEqual((Date)from, (Date)until)) {
            Insurance insurance = (Insurance)employee.getInsuranceHistory().getItemOrNull(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)from));
            if (insurance == null) {
                from = PDateHelper.getLastDayNextMonth((Date)from);
                svEntgelt = BigDecimal.ZERO;
                continue;
            }
            if (insurance.getPersonGroup() != 109 || insurance.getUseTransitionBy31122022()) {
                from = PDateHelper.getLastDayNextMonth((Date)from);
                svEntgelt = BigDecimal.ZERO;
                continue;
            }
            ValuePosition[] vps = ValuePositionPersistencyManager.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)from))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)from))), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(130000))}));
            if (vps.length > 0) {
                for (ValuePosition vp : vps) {
                    svEntgelt = svEntgelt.add(vp.getResult());
                }
            }
            from = PDateHelper.getLastDayNextMonth((Date)from);
        }
        return svEntgelt;
    }

    private void eeAbsentTimeCheck(Employee employee) throws BusinessDomainException {
        if (this.mScopeOfMessage == ScopeOfMessageEnum.NUR_FEHLER) {
            return;
        }
        Date lastDateOfEntry = employee.getMaximumDateOfEntry();
        Date lastDateOfWithdrawal = employee.getLastDateOfWithdrawal();
        if (lastDateOfWithdrawal == null) {
            return;
        }
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)lastDateOfEntry)), Restrictions.gt((String)"validuntil", (String)DateMapper.toString((Date)lastDateOfWithdrawal))});
        long rowCount = EEAbsentTimeTPPersistencyManager.getRowCount((Criterion)filter);
        if (rowCount > 0L) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.MA_FEHLZEIT, TypeOfMessageEnum.HINWEIS, this.mPcompany, employee, this.mMaster, this.mEmployment, new Date(), "Es existieren Fehlzeiten, deren Datum g\u00fcltig bis > dem Austrittsdatum (inklusive = leer) ist. Bitte begrenzen Sie diese Fehlzeiten."));
        }
    }

    private boolean isDemoCompany(PCompany mPcompany) {
        if (mPcompany.getActiveCompanyFoundation().getSpecific().value() == 1) {
            return true;
        }
        return StringMapper.equal((String)mPcompany.getObjectid(), (String)"1");
    }

    private boolean noCheck(Employee employee) {
        Date lastDateOfWithdrawal = employee.getLastDateOfWithdrawal();
        return lastDateOfWithdrawal != null && DateHelper.beforeOrEqual((Date)lastDateOfWithdrawal, (Date)new VDate(DateHelper.getFirstDayOfYear((Date)employee.getJournalizedUntil())).addYears(-1).getDate());
    }

    private void checkPueg() throws BusinessDomainException {
        long countForOtherEmployee;
        Conjunction filterForAccount = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mPcompany.getObjectid())});
        Date timePoint = DateMapper.toDate((String)"2025-07-01");
        this.mPcompany.getActiveCompanyEmploymentOffice();
        String companynumber = this.mPcompany.getActiveCompanyEmploymentOffice().getGeneralEmploymentOffice().getEmployerNumber();
        if (!StringMapper.isNullString((String)companynumber) && (companynumber.startsWith("985") || companynumber.startsWith("987"))) {
            return;
        }
        Junction filterForEmployee = Restrictions.conjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mPcompany.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.lt((String)"persongroup", (String)String.valueOf(900))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"duesgroupni", (String)String.valueOf(1)), Restrictions.eq((String)"duesgroupni", (String)String.valueOf(2))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"dateofwithdrawal"), Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)timePoint))}));
        Junction filterForOtherEmployee = Restrictions.conjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mPcompany.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.lt((String)"persongroup", (String)String.valueOf(900))})).add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"duesgrouphi ", (String)String.valueOf(0)), Restrictions.eq((String)"duesgrouppi ", (String)String.valueOf(1)), Restrictions.eq((String)"duesgroupui ", (String)String.valueOf(1)), Restrictions.eq((String)"duesgroupni ", (String)String.valueOf(1))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"dateofwithdrawal"), Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)timePoint))}));
        Junction filterForKVdR = Restrictions.conjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mPcompany.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.ge((String)"persongroup", (String)String.valueOf(900))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(1)), Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(2)), Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(3)), Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(4))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"dateofwithdrawal"), Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)timePoint))}));
        long countForAccount = this.getIPuegAccountPM().getRowCount((Criterion)filterForAccount);
        if (countForAccount > 0L) {
            return;
        }
        long countForEmployee = CheckRun.getIInsurancePM().getRowCount((Criterion)filterForEmployee);
        if (countForEmployee - (countForOtherEmployee = CheckRun.getIInsurancePM().getRowCount((Criterion)filterForOtherEmployee)) > 0L) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.DABPV, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "ACHTUNG! Der elektronische Abruf der PV-Daten muss zwingend zum Stichtag 01.07.2025 vorgenommen werden!"));
            return;
        }
        long countForKVdR = CheckRun.getIInsurancePM().getRowCount((Criterion)filterForKVdR);
        if (countForKVdR > 0L) {
            this.mResultMessageBeans.add(new ResultMessageBean(ModuleOfMessageEnum.DABPV, TypeOfMessageEnum.GLOBALER_HINWEIS, this.mPcompany, null, null, null, new Date(), "ACHTUNG! Der elektronische Abruf der PV-Daten muss zwingend zum Stichtag 01.07.2025 vorgenommen werden!"));
            return;
        }
    }

    public boolean getStatusOfCheckAll() {
        return this.mStatusOfCheckAll;
    }

    public List<ResultMessageBean> getResultMessageBeans() {
        return this.mResultMessageBeans;
    }

    public static boolean getRunSIMasterdataCheck() throws BusinessDomainException {
        return ((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getBoolean("run.simasterdata.check", true);
    }

    private SocialInsuranceTP getSocialInsurance(Date validTimePoint) throws BusinessDomainException {
        SocialInsurance socialInsurance = SocialInsurancePersistencyManager.getInstance();
        return socialInsurance.getSocialInsurance(VDate.getDateMax(), validTimePoint);
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    protected static IUvDslnPersistencyManager getUvDslnPM() {
        return (IUvDslnPersistencyManager)UtilitiesManager.getBean((String)"uvDslnPersistencyManager", IUvDslnPersistencyManager.class);
    }

    private IPuegAccountPersistencyManager getIPuegAccountPM() {
        return (IPuegAccountPersistencyManager)UtilitiesManager.getBean((String)"puegAccountPersistencyManager", IPuegAccountPersistencyManager.class);
    }

    private static IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }
}

