/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.uv;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.accidentinsurancefundvaluetype.AccidentInsuranceFundValuetype;
import com.varial.personnel.domain.deuv.COR;
import com.varial.personnel.domain.deuv.DateInterval;
import com.varial.personnel.domain.deuv.deuvaccount.PersonalCurrentData;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.accidentinsurancefund.EEAccidentInsuranceFund;
import com.varial.personnel.domain.employee.accidentinsurancefund.SpecialUVReasonEnum;
import com.varial.personnel.domain.employee.accidentinsurancefund.partclassofrisk.PartClassOfRisk;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSIPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.partclassofrisk.CFPartClassOfRisk;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTP;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.uv.UvCalculation;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public abstract class UvEmployee<T extends UvEmployee<T>> {
    private static final Date START_OF_EGA_AIF_AFTER_WITHDRAWAL = DateMapper.toDate((String)"2009-01-01");
    protected static final String UVREASON_A07 = "A07";
    protected static final String UVREASON_A08 = "A08";
    protected static final String UVREASON_A09 = "A09";
    protected static final String UVREASON_B01 = "B01";
    private static final String UVREASON_B06 = "B06";
    protected static final String UVREASON_B09 = "B09";
    protected Employee mEmployee;
    private List<T> mSameEmployees;
    private List<COR> mCfClassOfRisks;
    private List<DateInterval> mAbsentPeriods;
    private final List<DateInterval> mUvMonths;
    private final Date mEffectiveFrom;
    private final Date mJournalizedUntil;
    protected UvCalculation<T> mCalculation;
    private PersonalCurrentData mPersonalCurrentData;
    private boolean mUvFreeEmployment;

    protected UvEmployee(Employee employee) {
        this(employee, false);
    }

    protected UvEmployee(Employee employee, boolean preview) {
        this.mEmployee = employee;
        this.mJournalizedUntil = preview ? PDateHelper.getLastDayNextMonth((Date)this.mEmployee.getJournalizedUntil()) : this.mEmployee.getJournalizedUntil();
        this.mEffectiveFrom = DateHelper.tomorrow((Date)this.mJournalizedUntil);
        this.mCalculation = new UvCalculation(this);
        this.mUvMonths = new ArrayList<DateInterval>();
    }

    protected abstract T createUvEmployee(Employee var1);

    protected abstract boolean hasCfClassOfRisk(Date var1) throws BusinessDomainException;

    protected abstract boolean useCFForPayment();

    protected List<DateInterval> getUvMonths(Date validFrom, Date validUntil) throws BusinessDomainException {
        ArrayList<DateInterval> result = new ArrayList<DateInterval>();
        Date start = validFrom;
        boolean inEmployment = false;
        boolean uvDuty = false;
        while (DateHelper.beforeOrEqual((Date)start, (Date)validUntil)) {
            Date end = DateHelper.getLastDayOfMonth((Date)start);
            if (this.isInEmployment(start, end) || this.mCalculation.hasCorrectionEga(start)) {
                inEmployment = true;
                if (this.isUvDuty(end)) {
                    uvDuty = true;
                    if (this.isAssAifValid(end)) {
                        result.add(new DateInterval(start));
                    }
                }
            }
            start = PDateHelper.getFirstDayNextMonth((Date)start);
        }
        this.mUvFreeEmployment = inEmployment && !uvDuty;
        return result;
    }

    protected boolean isUvDuty(Date validTP) throws BusinessDomainException {
        boolean requiredPgs = false;
        Insurance insurance = (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(this.mJournalizedUntil, validTP);
        if (insurance != null) {
            int pgs = insurance.getPersonGroup();
            if (insurance.isDEUVAdviceable() && pgs != 108 && pgs != 111) {
                requiredPgs = true;
            }
        }
        boolean requiredReason = false;
        EEAccidentInsuranceFund eeAif = (EEAccidentInsuranceFund)this.mEmployee.getEEAccidentInsuranceFundHistory().getItemOrNull(this.mEffectiveFrom, validTP);
        if (eeAif != null && eeAif.getSpecialUVReason() == SpecialUVReasonEnum.SURE_KEIN_BESONDERER_GRUND) {
            requiredReason = true;
        }
        return requiredPgs && requiredReason;
    }

    protected abstract boolean isAssAifValid(Date var1) throws BusinessDomainException;

    protected List<COR> createClassOfRisks(Date periodFrom, List<DateInterval> uvMonths) throws BusinessDomainException {
        List<COR> cfCors;
        ArrayList<COR> cors = new ArrayList<COR>();
        if (this.useCFForPayment() && (cfCors = this.getCFClassOfRisks(DateHelper.getFirstDayOfYear((Date)periodFrom))) != null) {
            cors.addAll(cfCors);
        }
        for (DateInterval uvMonth : uvMonths) {
            EEAccidentInsuranceFund eeaif = this.getEEAccidentInsuranceFund(uvMonth.getValidUntil());
            COR main = this.createCOR(uvMonth.getValidFrom(), uvMonth.getValidUntil(), eeaif.getAccidentInsuranceFund(), eeaif.getDifferentAccidentInsuranceFund(), eeaif.getClassOfRisk(), eeaif.getAIFpercent());
            if (main != null && this.isCorNeeded(uvMonth, main)) {
                this.add(cors, main);
            }
            for (PartClassOfRisk each : eeaif.getPartClassOfRisk()) {
                COR cor = this.createCOR(uvMonth.getValidFrom(), uvMonth.getValidUntil(), each.getAccidentInsuranceFund(), each.getDifferentAccidentInsuranceFund(), each.getClassOfRisk(), each.getAIFPercent());
                if (cor == null || !this.isCorNeeded(uvMonth, cor)) continue;
                this.add(cors, cor);
            }
        }
        return cors;
    }

    protected List<T> getSameEmployees() throws BusinessDomainException {
        if (this.mSameEmployees == null) {
            String insuranceNo = this.getPersonalCurrentData().getInsuranceNo();
            Order[] order = new Order[]{Order.asc((String)"PERSONNELNUMBER")};
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"INSURANCENO", (String)insuranceNo), Restrictions.eq((String)"OIDPCOMPANY", (String)this.mEmployee.getPCompany().getObjectid()), Restrictions.le((String)"EFFECTIVEFROM", (String)DateMapper.toString((Date)this.mJournalizedUntil)), Restrictions.ge((String)"EFFECTIVEUNTIL", (String)DateMapper.toString((Date)this.mJournalizedUntil))});
            Insurance[] query = this.getIInsurancePM().queryAll(order, (Criterion)filter, true);
            HashSet<Employee> employees = new HashSet<Employee>();
            for (Insurance insurance : query) {
                if (this.mEmployee.equals((Object)insurance.getEmployee())) continue;
                employees.add(insurance.getEmployee());
            }
            this.mSameEmployees = new ArrayList<T>();
            for (Employee employee : employees) {
                this.mSameEmployees.add(this.createUvEmployee(employee));
            }
        }
        return this.mSameEmployees;
    }

    private Date getLastEmploymentDay(Employee employee, Date validTP) {
        Date result = null;
        Employment employment = (Employment)employee.getEmploymentHistory().getItemOrNull(this.mJournalizedUntil, validTP);
        if (employment != null && DateHelper.beforeOrEqual((Date)employment.getDateOfEntry(), (Date)validTP)) {
            Date withdrawal = employment.getDateOfWithDrawal();
            result = withdrawal == null ? validTP : withdrawal;
        }
        return result;
    }

    protected boolean isMaster(Date validFrom, Date validUntil) throws BusinessDomainException {
        boolean isMaster = true;
        Date maxEmploymentDay = this.getLastEmploymentDay(this.mEmployee, validUntil);
        for (UvEmployee uvEmployee : this.getSameEmployees()) {
            Employee employee;
            Date lastEmploymentDay;
            if (uvEmployee.getUvMonths(validFrom, validUntil).isEmpty() && !this.hasCfClassOfRisk(validFrom) || (lastEmploymentDay = this.getLastEmploymentDay(employee = uvEmployee.getEmployee(), validUntil)) == null || !DateHelper.after((Date)lastEmploymentDay, (Date)maxEmploymentDay) && (!DateHelper.equal((Date)lastEmploymentDay, (Date)maxEmploymentDay) || employee.getPersonnelnumber() >= this.mEmployee.getPersonnelnumber())) continue;
            isMaster = false;
            break;
        }
        return isMaster;
    }

    protected void addSameEmployees(List<COR> corlist, Date validFrom, Date validUntil) throws BusinessDomainException {
        for (UvEmployee uvEmployee : this.getSameEmployees()) {
            List<DateInterval> uvMonths = uvEmployee.getUvMonths(validFrom, validUntil);
            if (uvMonths.isEmpty() && !uvEmployee.hasCfClassOfRisk(validFrom)) continue;
            this.getUvMonths().addAll(uvMonths);
            List<COR> cors = uvEmployee.createClassOfRisks(validFrom, uvMonths);
            for (COR cor : cors) {
                this.addWithDiffPnr(corlist, cor, uvEmployee.getEmployee().getPersonnelnumber());
            }
        }
    }

    private boolean isCorNeeded(DateInterval month, COR cor) {
        return !BigDecimalMapper.isZeroOrNull((BigDecimal)cor.getPayment()) || this.isInEmploymentNotAbsent(month.getValidFrom(), month.getValidUntil());
    }

    protected void add(List<COR> cors, COR cor) {
        int index = cors.indexOf(cor);
        if (index >= 0) {
            COR old = cors.get(index);
            old.add(cor);
        } else {
            cors.add(cor);
        }
    }

    private void addWithDiffPnr(List<COR> cors, COR cor, int pnr) {
        int index = cors.indexOf(cor);
        String pnrString = pnr + ": ";
        if (index >= 0) {
            COR old = cors.get(index);
            old.add(cor, pnrString);
        } else {
            cor.setPaymentDescription(pnrString + cor.getPaymentDescription());
            cors.add(cor);
        }
    }

    protected EEAccidentInsuranceFund getEEAccidentInsuranceFund(Date validTP) throws BusinessDomainException {
        EEAccidentInsuranceFund eeaif = (EEAccidentInsuranceFund)this.mEmployee.getEEAccidentInsuranceFundHistory().getItemOrNull(this.getEffectiveDate(), validTP);
        if (eeaif == null || eeaif.getAccidentInsuranceFund() == null) {
            throw EmployeeExceptionMapper.makeAccidentInsuranceFundMissingDomainException(validTP, this.mEmployee.getPCompany().getPCompanyKey() + " / " + this.mEmployee.getPersonnelnumber());
        }
        return eeaif;
    }

    protected COR createCOR(Date from, Date until, AccidentInsuranceFund aif, AccidentInsuranceFund aifCor, String cor, BigDecimal percentage) throws BusinessDomainException {
        COR result;
        if (UvEmployee.isVirtualClassOfRisk(cor)) {
            result = new COR(from, until, aif, "", "", aifCor, cor, percentage);
        } else {
            AssignmentPCompanyAccidentInsuranceFundTP assAifTp = this.getAssignmentPCompanyAIFTP(aif, until);
            BigDecimal payment = this.mCalculation.calculatePaymentAIF(from, until, percentage, assAifTp);
            result = new COR(from, until, aif, assAifTp.getMembershipNumber(), assAifTp.getUnrs(), aifCor, cor, percentage, payment);
        }
        return result;
    }

    protected static BigDecimal getYearlyUpperLimit(AccidentInsuranceFund aif, Date year) throws BusinessDomainException {
        BigDecimal result = null;
        AccidentInsuranceFundTP aiftp = (AccidentInsuranceFundTP)aif.getHistory().getItemOrNull(year);
        if (aiftp != null) {
            result = aiftp.getYearlyUpperLimit();
        }
        return result;
    }

    protected List<COR> getCFClassOfRisks(Date firstDayOfYear) throws BusinessDomainException {
        if (DateHelper.equal((Date)firstDayOfYear, (Date)DateHelper.getFirstDayOfYear((Date)this.getCalculationStart()))) {
            if (this.mCfClassOfRisks == null) {
                this.mCfClassOfRisks = this.initCfClassOfRisks(firstDayOfYear);
            }
            return this.mCfClassOfRisks;
        }
        return null;
    }

    protected abstract Date getCalculationStart() throws BusinessDomainException;

    private List<COR> initCfClassOfRisks(Date firstDayOfYear) throws BusinessDomainException {
        ArrayList<COR> cors = new ArrayList<COR>();
        for (EECarriedForwardSystemSI each : this.getEECarriedForwardSystemSIs()) {
            if (!DateHelper.equal((Date)firstDayOfYear, (Date)DateHelper.getFirstDayOfYear((Date)each.getValidFrom()))) continue;
            if (!this.isCFValid(each.getPartClassOfRisk(), this.mEmployee.getStartOfHistory(), each.getValidFrom())) break;
            for (CFPartClassOfRisk cf : each.getPartClassOfRisk()) {
                AssignmentPCompanyAccidentInsuranceFundTP assAifTp = this.getAssignmentPCompanyAIFTP(cf.getAccidentInsuranceFund(), this.mEmployee.getStartOfHistory());
                if (assAifTp == null) continue;
                COR cor = new COR(each.getValidFrom(), each.getValidUntil(), cf.getAccidentInsuranceFund(), assAifTp.getMembershipNumber(), assAifTp.getUnrs(), cf.getDifferentAccidentInsuranceFund(), cf.getClassOfRisk(), BigDecimal.valueOf(100L), cf.getAIPayment(), cf.getAIHours());
                this.add(cors, cor);
            }
        }
        for (COR cor : cors) {
            cor.setPaymentDescription(String.format(Locale.GERMAN, "Vortrag: %,.2f", cor.getPayment()));
        }
        return cors;
    }

    protected abstract boolean isCFValid(CFPartClassOfRisk[] var1, Date var2, Date var3) throws BusinessDomainException;

    private EECarriedForwardSystemSI[] getEECarriedForwardSystemSIs() {
        Criterion criterion = Restrictions.eq((String)"OIDEMPLOYEE", (String)this.mEmployee.getObjectid());
        Order[] sort = new Order[]{Order.asc((String)"VALIDFROM")};
        return EECarriedForwardSystemSIPersistencyManager.query((Order[])sort, (Criterion)criterion);
    }

    protected static BigDecimal limitPayment(COR cor, BigDecimal remain) {
        BigDecimal result = BigDecimal.ZERO;
        if (BigDecimalMapper.isZero((BigDecimal)remain)) {
            cor.setPayment(BigDecimal.ZERO);
            cor.setUvReason(UVREASON_B06);
            cor.setReducedByYearlyLimit(true);
        } else if (BigDecimalMapper.compareTo((BigDecimal)remain, (BigDecimal)cor.getPayment()) < 0) {
            cor.setPayment(remain);
            cor.setReducedByYearlyLimit(true);
        } else {
            result = BigDecimalMapper.subtract((BigDecimal)remain, (BigDecimal)cor.getPayment());
        }
        return result;
    }

    private boolean isInEmployment(Date validFrom, Date validUntil) {
        return !this.getEmploymentPeriods(validFrom, validUntil).isEmpty();
    }

    protected boolean isInEmploymentNotAbsent(Date validFrom, Date validUntil) {
        boolean result = false;
        List<DateInterval> employments = this.getEmploymentPeriods(validFrom, validUntil);
        for (DateInterval employed : employments) {
            if (!this.hasDaysWithoutAbsent(employed)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected List<DateInterval> getEmploymentPeriods(Date validFrom, Date validUntil) {
        ArrayList<DateInterval> result = new ArrayList<DateInterval>();
        List empList = this.mEmployee.getEmploymentHistory().getPeriods(this.mJournalizedUntil, validFrom, validUntil);
        Date entry = null;
        for (Employment employment : empList) {
            Date withdrawal;
            if (DateHelper.beforeOrEqual((Date)employment.getDateOfEntry(), (Date)validUntil)) {
                entry = DateHelper.max((Date)validFrom, (Date)employment.getDateOfEntry());
            }
            if (entry == null || (withdrawal = employment.getDateOfWithDrawal()) == null || !DateHelper.afterOrEqual((Date)employment.getValidUntil(), (Date)withdrawal)) continue;
            DateInterval interval = new DateInterval(entry, withdrawal);
            if (interval.isValid()) {
                result.add(interval);
            }
            entry = null;
        }
        if (entry != null) {
            result.add(new DateInterval(entry, validUntil));
        }
        return result;
    }

    private boolean hasDaysWithoutAbsent(DateInterval employed) {
        boolean result = false;
        List<DateInterval> absentPeriods = this.getAbsentPeriods();
        Date start = employed.getValidFrom();
        for (DateInterval absent : absentPeriods) {
            if (!employed.isIntersection(absent)) continue;
            if (DateHelper.beforeOrEqual((Date)absent.getValidFrom(), (Date)start)) {
                if (DateHelper.afterOrEqual((Date)absent.getValidUntil(), (Date)employed.getValidUntil())) {
                    return false;
                }
                start = DateHelper.tomorrow((Date)absent.getValidUntil());
                continue;
            }
            return true;
        }
        if (DateHelper.beforeOrEqual((Date)start, (Date)employed.getValidUntil())) {
            result = true;
        }
        return result;
    }

    private List<DateInterval> getAbsentPeriods() {
        if (this.mAbsentPeriods == null) {
            Order[] sort = new Order[]{Order.asc((String)"validfrom")};
            String effectivTP = DateMapper.toString((Date)this.getJournalizedUntil());
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()), Restrictions.eq((String)"deleted", (String)BooleanMapper.toString((boolean)false)), Restrictions.le((String)"effectivefrom", (String)effectivTP), Restrictions.ge((String)"effectiveuntil", (String)effectivTP), Restrictions.in((String)"absenttimekey", (String[])new String[]{"EL", "BZ", "T", "EKT", "PZ"})});
            this.mAbsentPeriods = new ArrayList<DateInterval>();
            for (EEAbsentTimeTP attp : EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)filter, (boolean)true)) {
                Date from = attp.getValidFrom();
                if ("T".equals(attp.getEEAbsentTime().getAbsentTime().getAbsentTimeKey())) {
                    from = DateHelper.tomorrow((Date)from);
                }
                this.mAbsentPeriods.add(new DateInterval(from, attp.getValidUntil()));
            }
        }
        return this.mAbsentPeriods;
    }

    public List<Date> getWithDrawalDates() {
        ArrayList<Date> result = new ArrayList<Date>();
        List empList = this.mEmployee.getEmploymentHistory().getPeriods(this.mEffectiveFrom, START_OF_EGA_AIF_AFTER_WITHDRAWAL, this.getJournalizedUntil());
        for (Employment employment : empList) {
            Date withdrawal = employment.getDateOfWithDrawal();
            if (withdrawal == null || !DateHelper.between((Date)withdrawal, (Date)employment.getValidFrom(), (Date)employment.getValidUntil())) continue;
            result.add(withdrawal);
        }
        return result;
    }

    public AssignmentPCompanyAccidentInsuranceFundTP getValidAssPCompanyAIFTP(Date validTP) throws BusinessDomainException {
        AssignmentPCompanyAccidentInsuranceFundTP result = null;
        EEAccidentInsuranceFund eeAIF = (EEAccidentInsuranceFund)this.mEmployee.getEEAccidentInsuranceFundHistory().getItemOrNull(this.getEffectiveDate(), validTP);
        if (eeAIF != null) {
            AccidentInsuranceFund aif = eeAIF.getAccidentInsuranceFund();
            if (aif != null) {
                result = this.getAssignmentPCompanyAIFTP(aif, validTP);
            }
            if (result == null) {
                PartClassOfRisk pCoR;
                AccidentInsuranceFund pCorAif;
                PartClassOfRisk[] partClassOfRiskArray = eeAIF.getPartClassOfRisk();
                int n = partClassOfRiskArray.length;
                for (int i = 0; i < n && ((pCorAif = (pCoR = partClassOfRiskArray[i]).getAccidentInsuranceFund()) == null || (result = this.getAssignmentPCompanyAIFTP(pCorAif, validTP)) == null); ++i) {
                }
            }
        }
        return result;
    }

    protected AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAIFTP(AccidentInsuranceFund aif, Date validTimePoint) throws BusinessDomainException {
        Employment employment = this.mEmployee.getEmployment(this.getEffectiveDate(), validTimePoint);
        Plant plant = employment.getPlant();
        return this.getAssignmentPCompanyAIFTP(aif, plant, validTimePoint);
    }

    protected abstract AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAIFTP(AccidentInsuranceFund var1, Plant var2, Date var3) throws BusinessDomainException;

    public Employee getEmployee() {
        return this.mEmployee;
    }

    public Date getJournalizedUntil() {
        return this.mJournalizedUntil;
    }

    protected Date getEffectiveDate() {
        return this.mEffectiveFrom;
    }

    private PersonalCurrentData getPersonalCurrentData() throws BusinessDomainException {
        if (this.mPersonalCurrentData == null) {
            Date personalCurrentDate = DateHelper.max((Date)this.getJournalizedUntil(), (Date)new Date());
            this.mPersonalCurrentData = new PersonalCurrentData(this.mEmployee, personalCurrentDate);
        }
        return this.mPersonalCurrentData;
    }

    public int getPersonnelnumber() {
        return this.getEmployee().getPersonnelnumber();
    }

    public String getInsuranceNo() throws BusinessDomainException {
        return this.getPersonalCurrentData().getInsuranceNo();
    }

    public String getName() throws BusinessDomainException {
        return this.getPersonalCurrentData().getSurname() + ", " + this.getPersonalCurrentData().getFirstname();
    }

    public List<DateInterval> getUvMonths() {
        return this.mUvMonths;
    }

    protected static boolean isA07(String cor) {
        return "77777777".equals(cor);
    }

    protected static boolean isA08(String cor) {
        return "88888888".equals(cor);
    }

    protected static boolean isA09(String cor) {
        return "99999999".equals(cor);
    }

    protected static boolean isVirtualClassOfRisk(String cor) {
        return UvEmployee.isA07(cor) || UvEmployee.isA08(cor) || UvEmployee.isA09(cor);
    }

    protected boolean isUvFreeEmployment() {
        return this.mUvFreeEmployment;
    }

    public abstract AccidentInsuranceFundValuetype[] getAifValueTypes(AssignmentPCompanyAccidentInsuranceFundTP var1);

    private IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }

    public String toString() {
        return this.getEmployee().toString();
    }
}

