/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.rvbea.transfer;

import com.varial.personnel.domain.deuv.DeuvBasicComponents;
import com.varial.personnel.domain.rvbea.dxeb.RvbeaDxeb;
import com.varial.personnel.domain.rvbea.dxeb.field.DxebField;
import com.varial.personnel.domain.rvbea.dxrr.RvbeaDxrr;
import com.varial.personnel.domain.rvbea.xml.AnAbmeldungsTyp;
import com.varial.personnel.domain.rvbea.xml.RegistrierungsTyp;
import com.varial.personnel.domain.rvbea.xml.SteuerungsdatenTyp;
import com.varial.serverbase.mapper.StringMapper;
import java.util.List;

public final class RvbeaComponents {
    private RvbeaComponents() {
    }

    public static String getContentDxrr(RvbeaDxrr dxrr) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getKennung(), (int)4);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dxrr.getVersionsnummer(), (int)6);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getDsid(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getBbnras(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getBbnrvu(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxrr.getAnzregistrierung(), (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getHauptverfahren(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getTeilverfahren(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxrr.getTeilnahme(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        return builder.toString();
    }

    public static String getContentDxeb(RvbeaDxeb dxeb) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getKennung(), (int)4);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dxeb.getVersionsnummer(), (int)6);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getDsid(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getBbnras(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getBbnrvu(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getBezugsid(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getVsnr(), (int)12);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getAzvu(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dxeb.getAnfgr(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dxeb.getAnfgrvers(), (int)6);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxeb.getHinderungsgrund(), (int)2);
        List dxebMonths = dxeb.getDxebMonths();
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxebMonths.size(), (int)2);
        for (RvbeaDxeb.DxebMonth dxebMonth : dxebMonths) {
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxebMonth.getYear(), (int)4);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxebMonth.getMonth(), (int)2);
            DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxebMonth.getHinderungsgrund(), (int)2);
            if (dxebMonth.getHinderungsgrund() != 0) {
                DeuvBasicComponents.appNum((StringBuilder)builder, (int)0, (int)3);
            } else {
                List dxebFields = dxebMonth.getDxebFields();
                DeuvBasicComponents.appNum((StringBuilder)builder, (int)dxebFields.size(), (int)3);
                for (DxebField dxebField : dxebFields) {
                    DeuvBasicComponents.append((StringBuilder)builder, (String)dxebField.getKey(), (int)15);
                    DeuvBasicComponents.append((StringBuilder)builder, (String)dxebField.getPerfidiaValue(), (int)15);
                }
            }
            DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)500);
        }
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        return builder.toString();
    }

    public static RegistrierungsTyp getDxrrXml(RvbeaDxrr dxrr) {
        RegistrierungsTyp dxrrXml = new RegistrierungsTyp();
        SteuerungsdatenTyp steuerung = new SteuerungsdatenTyp();
        steuerung.setDsId(StringMapper.maxLength((String)dxrr.getDsid(), (int)32));
        steuerung.setBbnras(StringMapper.maxLength((String)dxrr.getBbnras(), (int)8));
        steuerung.setBbnrvu(StringMapper.maxLength((String)dxrr.getBbnrvu(), (int)8));
        dxrrXml.setSteuerungsdaten(steuerung);
        AnAbmeldungsTyp anAbmeldung = new AnAbmeldungsTyp();
        anAbmeldung.setHauptverfahren(StringMapper.maxLength((String)dxrr.getHauptverfahren(), (int)15));
        anAbmeldung.setTeilverfahren(StringMapper.maxLength((String)dxrr.getTeilverfahren(), (int)15));
        anAbmeldung.setTeilnahme(StringMapper.maxLength((String)dxrr.getTeilnahme(), (int)1));
        dxrrXml.getRegistrierung().add(anAbmeldung);
        return dxrrXml;
    }
}

