/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.pueg;

import com.varial.base.callback.TransactionMode;
import com.varial.base.corba.CorbaExceptionTranslatorFactory;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pueg.PuegRecipient;
import com.varial.personnel.domain.pueg.PuegTransfer;
import com.varial.personnel.domain.pueg.advice.PuegAdvice;
import com.varial.personnel.domain.pueg.mapper.PuegExceptionMapper;
import com.varial.personnel.domain.pueg.puegaccount.PuegAccount;
import com.varial.personnel.domain.pueg.puegaccount.PuegAdviceStateEnum;
import com.varial.personnel.domain.pueg.puegaccount.PuegReasonOfDeliveryEnum;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportBeanDataSource;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVCompanyStruct;
import com.varial.personnel.domain.reports.pueg.PuegProtocolReportDataSource;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.applicationexception.DomainExceptionStruct;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.DatabaseExceptionStruct;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import org.springframework.transaction.TransactionStatus;

public class PuegTransferProtocolReport
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final String PROFILE_PREFIX = "PUEGTR";
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/pueg/";
    private final DEUVCompanyStruct[] mCompanyStructs;
    private final ProgressBarUpdater mProgressBar;
    private final Date mCurrentDate;

    public PuegTransferProtocolReport(AuthorizationToken token, ReportFileStructCallback callback, DEUVCompanyStruct[] companyStructs) {
        super(token, (AllCallbackOperations)callback, TransactionMode.NONE, false);
        if (companyStructs == null || companyStructs.length == 0) {
            throw new IllegalStateException("Company structs: " + Arrays.toString(companyStructs));
        }
        this.mCompanyStructs = companyStructs;
        this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, this.mCompanyStructs.length, "Daten\u00fcbermittlung DaBPV");
        this.mCurrentDate = VDate.getCurrentLocalizedDateAndTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ApplicationServiceAdapter applAdapter = new ApplicationServiceAdapter();
        TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
        TransactionStatus txStatus = null;
        try {
            ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
            applAdapter.beginUpdateService();
            ArrayList<String> emptycompanies = new ArrayList<String>(this.mCompanyStructs.length);
            for (DEUVCompanyStruct each : this.mCompanyStructs) {
                txStatus = txAdapter.getUpdateTransaction();
                boolean pueg = this.executeCompany(each, PuegReasonOfDeliveryEnum.ALLE);
                if (pueg) {
                    txAdapter.commit(txStatus);
                } else {
                    emptycompanies.add(each.oidPCompany);
                    this.rollback(txAdapter, txStatus, null);
                }
                this.mProgressBar.nextStep();
            }
            if (emptycompanies.size() == this.mCompanyStructs.length) {
                throw PuegExceptionMapper.makeNoMessagesForTransferDomainException();
            }
        }
        catch (BusinessDomainException de) {
            this.rollback(txAdapter, txStatus, de);
            DomainExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDomainExceptionStruct(de);
            struct.value = struct.value + " " + this;
            ((ReportFileStructCallback)this.getCallback()).setDomainException(struct);
        }
        catch (Throwable t) {
            this.rollback(txAdapter, txStatus, t);
            DatabaseExceptionStruct struct = CorbaExceptionTranslatorFactory.getTranslator().translateIntoDatabaseExceptionStruct(t);
            if (t.getMessage() == null) {
                struct.param1 = t.getClass().getSimpleName();
            }
            struct.param1 = struct.param1 + ", thrower: " + this;
            ((ReportFileStructCallback)this.getCallback()).setException(struct);
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
            applAdapter.endService();
        }
    }

    private boolean executeCompany(DEUVCompanyStruct companyStruct, PuegReasonOfDeliveryEnum reason) throws BusinessDomainException, PutDataException {
        PCompany pCompany = PCompanyPersistencyManager.getPCompany((String)companyStruct.oidPCompany);
        PuegAdvice advice = new PuegAdvice(pCompany);
        String[] states = new String[]{"" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.BEREIT)};
        List<PuegAccount> untransmitteds = advice.getUntransmitteds(reason, states, true);
        if (untransmitteds.isEmpty()) {
            return false;
        }
        LinkedList<PuegRecipient> recipients = this.initRecipients(advice, untransmitteds);
        this.mProgressBar.setTotal(recipients.size() + 1);
        ArrayList<PuegAccount> transmitteds = new ArrayList<PuegAccount>();
        for (PuegRecipient puegRecipient : recipients) {
            this.mProgressBar.update(puegRecipient.getName());
            PuegTransfer transfer = new PuegTransfer(DeuvHelper.getDeuvSender((PCompany)pCompany).getDEUVSenderTP(VDate.getDateMax(), this.mCurrentDate), puegRecipient.getDeuvRecipientTP(), pCompany, puegRecipient.getAccounts());
            transfer.createTransferFile(puegRecipient.getAccounts());
            transmitteds.addAll(transfer.getTransmitteds());
            transfer.writePerfidiaFiles();
        }
        this.getContext().flush();
        this.mProgressBar.update("Erzeuge Report...");
        File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("PuegAccountProtocolReport"), this.createParameters(), (JRDataSource)this.createDataSource(advice, transmitteds, recipients, reason), (String)PROFILE_PREFIX);
        String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
        ((ReportFileStructCallback)this.getCallback()).putData(reports);
        return true;
    }

    private LinkedList<PuegRecipient> initRecipients(PuegAdvice advice, List<PuegAccount> untransmitteds) throws BusinessDomainException {
        HashMap<DEUVRecipient, PuegRecipient> recipients = new HashMap<DEUVRecipient, PuegRecipient>();
        for (PuegAccount account : untransmitteds) {
            PuegRecipient recipient = (PuegRecipient)recipients.get(account.getDEUVRecipient());
            if (recipient == null) {
                recipient = new PuegRecipient(account.getDEUVRecipient(), true);
                recipients.put(account.getDEUVRecipient(), recipient);
            }
            recipient.addAccount(account);
        }
        return new LinkedList<PuegRecipient>(recipients.values());
    }

    private void rollback(TransactionalServiceAdapter txAdapter, TransactionStatus txStatus, Throwable throwable) {
        if (txAdapter != null && txStatus != null) {
            txAdapter.rollbackOnException(txStatus, throwable);
        }
    }

    private Map<String, Object> createParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("recipientReport", this.compileReport("RecipientSubreport"));
        parameters.put("errorReport", this.compileReport("ErrorSubreport"));
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        return parameters;
    }

    private JRDataSource createDataSource(PuegAdvice creator, List<PuegAccount> transmitteds, Deque<PuegRecipient> recipients, PuegReasonOfDeliveryEnum reason) throws BusinessDomainException {
        final PuegProtocolReportDataSource PuegDS = new PuegProtocolReportDataSource(creator, transmitteds, new ArrayList(), recipients, reason, true, false, false);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(PuegDS){

            protected boolean doNext() throws JRException {
                return PuegDS.next();
            }
        };
        return dataSource;
    }

    public JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(REPORT_FOLDER + reportName + ".jrxml"));
    }
}

