/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.pueg;

import com.varial.base.UtilitiesManager;
import com.varial.base.callback.AbstractAsynchronousPrintCommand;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurancechild.InsuranceChild;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.pueg.IPuegAntwort;
import com.varial.personnel.domain.pueg.puegaccount.PuegAccount;
import com.varial.personnel.domain.pueg.puegaccount.PuegAdviceStateEnum;
import com.varial.personnel.domain.pueg.pueganfrage.IPuegAnfragePersistencyManager;
import com.varial.personnel.domain.pueg.pueganfrage.PuegAnfrage;
import com.varial.personnel.domain.pueg.puegantwort.IPuegAntwortPersistencyManager;
import com.varial.personnel.domain.pueg.puegantwort.PuegAntwort;
import com.varial.personnel.domain.pueg.puegantwort.PuegKind;
import com.varial.personnel.domain.pueg.puegantwortkeundigung.IPuegAntwortKuendigungPersistencyManager;
import com.varial.personnel.domain.pueg.puegkuendigung.IPuegKuendigungPersistencyManager;
import com.varial.personnel.domain.pueg.puegkuendigung.PuegKuendigung;
import com.varial.personnel.domain.pueg.receive.PuegAcknowledgement;
import com.varial.personnel.domain.pueg.receive.PuegReceive;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportBeanDataSource;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.pueg.PuegReceiveDS;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.framework.IValuationManager;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;

public class PuegReceiveReport
extends AbstractAsynchronousPrintCommand<ReportFileStructCallback> {
    private static final String PROFILE_PREFIX = "PUEGRR";
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/pueg/";
    public static final Date START_2025_07 = DateMapper.toDate((String)"2025-07-01");
    private final DEUVSender mDeuvSender;
    private final TypeOfReceive mTypeOfReceive;
    private ProgressBarUpdater mProgressBar;

    public PuegReceiveReport(AuthorizationToken token, ReportFileStructCallback callback, String oidDeuvSender, TypeOfReceive typeOfReceive) {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE);
        this.mDeuvSender = DEUVSender.getDEUVSender((String)oidDeuvSender);
        this.mTypeOfReceive = typeOfReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BusinessDomainException, PutDataException {
        this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, 1, "R\u00fcckmeldungen Pueg");
        this.mProgressBar.show();
        try {
            ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
            if (this.mTypeOfReceive == TypeOfReceive.ACKNOWLEDGEMENT || this.mTypeOfReceive == TypeOfReceive.BOTH) {
                PuegAcknowledgement puegAck = new PuegAcknowledgement(this.mDeuvSender);
                puegAck.processFiles();
                this.getContext().flush();
                if (this.mTypeOfReceive != TypeOfReceive.BOTH || !puegAck.getImporteds().isEmpty()) {
                    File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("PuegReceiveReport"), this.createParameters(), (JRDataSource)this.createDataSource(puegAck), (String)PROFILE_PREFIX);
                    String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
                    ((ReportFileStructCallback)this.getCallback()).putData(reports);
                }
                puegAck.writeAcknowledgements();
                this.getContext().flush();
                puegAck.writePerfidiaFiles();
            }
            if (this.mTypeOfReceive == TypeOfReceive.RECEIVE || this.mTypeOfReceive == TypeOfReceive.BOTH) {
                PuegReceive puegReceive = new PuegReceive(this.mDeuvSender);
                puegReceive.readPueg();
                List<IPuegAntwort> importeds = puegReceive.getImporteds();
                this.checkImporteds(importeds);
                this.updateData(importeds);
                this.getContext().flush();
                if (this.mTypeOfReceive != TypeOfReceive.BOTH || !importeds.isEmpty()) {
                    File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("PuegReceiveReport"), this.createParameters(), (JRDataSource)this.createDataSource(puegReceive), (String)PROFILE_PREFIX);
                    String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
                    ((ReportFileStructCallback)this.getCallback()).putData(reports);
                }
                puegReceive.writeAcknowledgements();
                this.getContext().flush();
                puegReceive.writePerfidiaFiles();
            }
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
        }
    }

    private void checkImporteds(List<IPuegAntwort> importeds) {
        for (IPuegAntwort each : importeds) {
            PuegAccount account = this.getAccountByMessageid(each.getMessageidref());
            if (account == null) {
                each.setHinweiscode("Zugeh\u00f6rige Meldung konnte nicht ermittelt werden!");
                each.makeReadOnly();
                continue;
            }
            each.setEmployee(account.getEmployee());
            if (this.alreadyExists(each)) {
                each.setHinweiscode("Die R\u00fcckmeldung wurde bereits importiert!");
                each.makeReadOnly();
                continue;
            }
            if (StringMapper.isNullString((String)each.getHinweiscode())) continue;
            account.makeSaveable();
            account.setAdviceState(PuegAdviceStateEnum.ABGELEHNT);
            account.setErrorMessage(each.getHinweiscode());
        }
    }

    private boolean alreadyExists(IPuegAntwort antwort) {
        if (antwort instanceof PuegAntwort) {
            return PuegReceiveReport.getIPuegAntwortPM().exists(Restrictions.eq((String)"MESSAGEID", (String)antwort.getMessageid()));
        }
        return PuegReceiveReport.getIPuegAntwortKuendigungPM().exists(Restrictions.eq((String)"MESSAGEID", (String)antwort.getMessageid()));
    }

    private void updateData(List<IPuegAntwort> importeds) throws BusinessDomainException {
        for (IPuegAntwort each : importeds) {
            boolean added;
            PuegAntwort antwort;
            if (!(each instanceof PuegAntwort) || (antwort = (PuegAntwort)each).isReadOnly() || antwort.hasHinweiscode()) continue;
            ArrayList<String> hinweise = new ArrayList<String>();
            String result = this.checkPuegKinder(antwort);
            if (!result.isEmpty()) {
                hinweise.add(result);
            }
            if (!(added = InsuranceChild.addPuegKinderToInsuranceChild((AuthorizationToken)this.getToken(), (Employee)antwort.getEmployee(), (PuegKind[])antwort.getPuegKinder()))) {
                hinweise.add("Keine \u00dcbernahme in Mitarbeiter - R\u00fcckmeldung PV-Kinder (als manuell gekennzeichnet)");
            }
            if (!(result = this.updateElterneigenschaft(antwort.getEmployee(), antwort.getElterneigenschaftab())).isEmpty()) {
                hinweise.add(result);
            }
            antwort.setHinweiscode(hinweise.stream().collect(Collectors.joining(", ")));
        }
    }

    private String checkPuegKinder(PuegAntwort antwort) throws BusinessDomainException {
        Object hinweis = "";
        if (antwort.getPuegKinder().length == 0) {
            return "";
        }
        Date minDate = antwort.getEmployee().getMinimumDateOfEntry();
        if (DateHelper.after((Date)minDate, (Date)START_2025_07)) {
            return "";
        }
        for (PuegKind each : antwort.getPuegKinder()) {
            if (DateHelper.after((Date)each.getAbdatum(), (Date)START_2025_07)) break;
            Date checkDate = DateHelper.max((Date)minDate, (Date)each.getAbdatum());
            int anz_kinder = antwort.getEmployee().getEffectiveNumberOfChildrenForNI(VDate.getDateMax(), checkDate, false, false).intValue();
            if (anz_kinder == each.getAnzahl()) continue;
            hinweis = (String)hinweis + "Abweichung in der Anzahl der Kinder! Erfasst: " + anz_kinder + " R\u00fcckmeldung: " + each.getAnzahl() + " (g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)checkDate) + ") ";
        }
        return hinweis;
    }

    private String updateElterneigenschaft(Employee employee, Date elterneigenschaftab) throws BusinessDomainException {
        Insurance oldInsurance;
        Object hinweis = "";
        boolean isUpdateNecessary = false;
        if (elterneigenschaftab != null) {
            boolean newNiChildEducation = true;
            oldInsurance = employee.getActiveInsurance();
            if (oldInsurance.getHealthFundKVdR() != null) {
                if (!oldInsurance.getNIChildOfEducKVdR()) {
                    oldInsurance.setNIChildOfEducKVdR(true);
                    isUpdateNecessary = true;
                }
            } else if (!oldInsurance.getNIChildEducation()) {
                oldInsurance.setNIChildEducation(true);
                isUpdateNecessary = true;
            }
        } else {
            oldInsurance = employee.getActiveInsurance();
            if (oldInsurance.getHealthFundKVdR() != null) {
                if (oldInsurance.getNIChildOfEducKVdR()) {
                    hinweis = "Elterneigenschaft PV (KV der Rentner) erfasst = Ja, R\u00fcckmeldung = Nein";
                }
            } else if (oldInsurance.getNIChildEducation()) {
                hinweis = "Elterneigenschaft PV erfasst = Ja, R\u00fcckmeldung = Nein";
            }
        }
        if (isUpdateNecessary) {
            Date validFrom = oldInsurance.getValidFrom();
            if (DateHelper.between((Date)elterneigenschaftab, (Date)DateHelper.getFirstDayOfMonth((Date)validFrom), (Date)DateHelper.getLastDayOfMonth((Date)validFrom))) {
                employee.setInsuranceHistoryInternal(oldInsurance, false, oldInsurance.getEffectiveFrom());
            }
            if (DateHelper.before((Date)validFrom, (Date)DateHelper.getFirstDayOfMonth((Date)elterneigenschaftab))) {
                oldInsurance.setValidFrom(DateHelper.getFirstDayOfMonth((Date)elterneigenschaftab));
                employee.addInsuranceHistoryInternal(oldInsurance, true);
            }
            if (DateHelper.after((Date)validFrom, (Date)DateHelper.getLastDayOfMonth((Date)elterneigenschaftab))) {
                employee.setInsuranceHistoryInternal(oldInsurance, false, oldInsurance.getEffectiveFrom());
                hinweis = "Elterneigenschaft PV erst mit g\u00fcltig ab : " + DateMapper.toDDMMYYYYPointSeparationString((Date)oldInsurance.getValidFrom()) + " in den aktuellen Datensatz \u00fcbernommen";
            }
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(this.getToken(), employee, DateHelper.tomorrow((Date)employee.getJournalizedUntil()), oldInsurance.getValidFrom(), Insurance.class.getName());
        }
        return hinweis;
    }

    private PuegAccount getAccountByMessageid(String Messageidref) {
        PuegAnfrage[] anfagen = PuegReceiveReport.getIPuegAnfragePM().query(null, Restrictions.eq((String)"MESSAGEID", (String)Messageidref), true);
        if (anfagen.length > 0) {
            return anfagen[0].getPuegAccount();
        }
        PuegKuendigung[] kuend = PuegReceiveReport.getIPuegKuendigungPM().query(null, Restrictions.eq((String)"MESSAGEID", (String)Messageidref), true);
        if (kuend.length > 0) {
            return kuend[0].getPuegAccount();
        }
        return null;
    }

    public JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(REPORT_FOLDER + reportName + ".jrxml"));
    }

    private Map<String, Object> createParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        parameters.put("puegKindReport", this.compileReport("PuegKindSubreport"));
        return parameters;
    }

    private JRDataSource createDataSource(PuegAcknowledgement ack) throws PutDataException {
        final PuegReceiveDS puegReceiveDS = new PuegReceiveDS(ack);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(puegReceiveDS){

            protected boolean doNext() throws JRException {
                return puegReceiveDS.next();
            }
        };
        return dataSource;
    }

    private JRDataSource createDataSource(PuegReceive receive) throws PutDataException {
        final PuegReceiveDS puegReceiveDS = new PuegReceiveDS(receive);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(puegReceiveDS){

            protected boolean doNext() throws JRException {
                return puegReceiveDS.next();
            }
        };
        return dataSource;
    }

    private static IPuegAnfragePersistencyManager getIPuegAnfragePM() {
        return (IPuegAnfragePersistencyManager)UtilitiesManager.getBean((String)"puegAnfragePersistencyManager", IPuegAnfragePersistencyManager.class);
    }

    private static IPuegKuendigungPersistencyManager getIPuegKuendigungPM() {
        return (IPuegKuendigungPersistencyManager)UtilitiesManager.getBean((String)"puegKuendigungPersistencyManager", IPuegKuendigungPersistencyManager.class);
    }

    private static IPuegAntwortPersistencyManager getIPuegAntwortPM() {
        return (IPuegAntwortPersistencyManager)UtilitiesManager.getBean((String)"puegAntwortPersistencyManager", IPuegAntwortPersistencyManager.class);
    }

    private static IPuegAntwortKuendigungPersistencyManager getIPuegAntwortKuendigungPM() {
        return (IPuegAntwortKuendigungPersistencyManager)UtilitiesManager.getBean((String)"puegAntwortKuendigungPersistencyManager", IPuegAntwortKuendigungPersistencyManager.class);
    }

    public static enum TypeOfReceive {
        ACKNOWLEDGEMENT,
        RECEIVE,
        BOTH;

    }
}

