/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.pueg;

import com.varial.base.UtilitiesManager;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pueg.PuegRecipient;
import com.varial.personnel.domain.pueg.advice.PuegAdvice;
import com.varial.personnel.domain.pueg.puegaccount.PuegAccount;
import com.varial.personnel.domain.pueg.puegaccount.PuegAdviceStateEnum;
import com.varial.personnel.domain.pueg.puegaccount.PuegReasonOfDeliveryEnum;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportBeanDataSource;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.pueg.PuegProtocolReportDataSource;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;

public class PuegProtocolReport
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final String PROFILE_PREFIX = "PUEGPR";
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/pueg/";
    private ProgressBarUpdater mProgressBar;
    private final PCompany mPCompany;
    private final PuegReasonOfDeliveryEnum mReasonOfDelivery;
    Date mFrom;
    Date mUntil;
    private final String[] mOidsEmp;
    private boolean mHistorical = false;
    private boolean mAdvancedProtocol = true;
    private boolean mNoDetails = false;

    public PuegProtocolReport(AuthorizationToken token, ReportFileStructCallback callback, String oidPCompany, Date from, Date until, String[] oidsEmployees, boolean advancedProtocol) {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE, false);
        this.mPCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
        this.mReasonOfDelivery = PuegReasonOfDeliveryEnum.ALLE;
        this.mFrom = from;
        this.mUntil = until;
        this.mOidsEmp = oidsEmployees;
        if (this.mFrom != null & this.mUntil != null) {
            this.mHistorical = true;
        }
        if (!advancedProtocol) {
            this.mAdvancedProtocol = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BusinessDomainException, PutDataException {
        try {
            ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
            List<Object> created = new ArrayList();
            List<Object> createdError = new ArrayList();
            PuegAdvice advice = new PuegAdvice(this.mPCompany);
            if (this.mHistorical) {
                advice.setAsHistoricalSetup(this.mFrom, this.mUntil);
            }
            String[] states = new String[]{"" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.AUFGEBAUT), "" + PuegAdviceStateEnum.toInt((PuegAdviceStateEnum)PuegAdviceStateEnum.BEREIT)};
            List<PuegAccount> untransmitteds = null;
            untransmitteds = this.mHistorical ? advice.getUntransmitteds(PuegReasonOfDeliveryEnum.ANFRAGE, states, false) : advice.getUntransmitteds(this.mReasonOfDelivery, states, false);
            if (untransmitteds != null) {
                this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, untransmitteds.size(), "L\u00f6schen von nicht \u00fcbermittelten Meldungen: ");
                for (PuegAccount puegAccount : untransmitteds) {
                    this.mProgressBar.nextStep();
                    if (this.mHistorical) {
                        if (!PuegReasonOfDeliveryEnum.ANFRAGE.equals((Object)puegAccount.getReasonOfDelivery()) || puegAccount.getPuegAnfrage().getBisdatum() == null) continue;
                        puegAccount.makeSaveable();
                        puegAccount.destroy();
                        continue;
                    }
                    if (!PuegReasonOfDeliveryEnum.KUENDIGUNG.equals((Object)puegAccount.getReasonOfDelivery()) && (!PuegReasonOfDeliveryEnum.ANFRAGE.equals((Object)puegAccount.getReasonOfDelivery()) || puegAccount.getPuegAnfrage().getBisdatum() != null) || puegAccount.isCancelationProvisionActual()) continue;
                    puegAccount.makeSaveable();
                    puegAccount.destroy();
                }
            }
            this.getContext().flush();
            ArrayList<Employee> ees = new ArrayList<Employee>();
            ees.addAll(this.getEmployees());
            this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, ees.size(), "Aufbau PUEG (DaBPV)");
            for (Employee emp : ees) {
                this.mProgressBar.nextStep();
                advice.create(emp);
                this.getContext().flush();
            }
            created = advice.getCreated();
            createdError = advice.getCreatedError();
            if (created.size() < 1) {
                this.mNoDetails = true;
                if (createdError.size() < 1) {
                    PuegAccount puegAccount = new PuegAccount(true);
                    puegAccount.addError("Es konnten keine Meldungen aufgebaut werden.");
                    createdError.clear();
                    createdError.add((Object)puegAccount);
                    this.mAdvancedProtocol = true;
                } else if (!this.mAdvancedProtocol) {
                    if (advice.hasInitializedAccounts()) {
                        PuegAccount puegAccount = new PuegAccount(true);
                        puegAccount.addError("Es konnten keine Meldungen aufgebaut werden.");
                        createdError.clear();
                        createdError.add((Object)puegAccount);
                        this.mAdvancedProtocol = true;
                    } else {
                        PuegAccount puegAccount = new PuegAccount(true);
                        puegAccount.addError("In dieser Firma oder Betriebsst\u00e4tte gibt es keine PV-pflichtigen Mitarbeiter.");
                        createdError.clear();
                        createdError.add((Object)puegAccount);
                        this.mAdvancedProtocol = true;
                    }
                }
            }
            Collections.sort(created, advice.getPuegAccountComparator());
            Collections.sort(createdError, advice.getPuegAccountComparator());
            this.getContext().flush();
            LinkedList<PuegRecipient> linkedList = this.initRecipients(advice, created);
            this.mProgressBar.update("Erzeuge Report...");
            File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.compileReport("PuegAccountProtocolReport"), this.createParameters(), (JRDataSource)this.createDataSource(advice, created, createdError, linkedList, this.mReasonOfDelivery), (String)PROFILE_PREFIX);
            String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
            ((ReportFileStructCallback)this.getCallback()).putData(reports);
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)PROFILE_PREFIX);
        }
    }

    private List<Employee> getEmployees() {
        if (this.mHistorical) {
            if (this.mOidsEmp.length == 0) {
                return Arrays.asList(PuegProtocolReport.getIEmployeePM().query(null, Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid()), true));
            }
            return Arrays.asList(PuegProtocolReport.getIEmployeePM().query(null, Restrictions.in((String)"OBJECTID", (String[])this.mOidsEmp), true));
        }
        return Arrays.asList(PuegProtocolReport.getIEmployeePM().query(null, Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid()), true));
    }

    private Map<String, Object> createParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("recipientReport", this.compileReport("RecipientSubreport"));
        parameters.put("errorReport", this.compileReport("ErrorSubreport"));
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        return parameters;
    }

    private JRDataSource createDataSource(PuegAdvice creator, List<PuegAccount> created, List<PuegAccount> createdError, Deque<PuegRecipient> recipients, PuegReasonOfDeliveryEnum mReasonOfDelivery) throws BusinessDomainException {
        final PuegProtocolReportDataSource PuegDS = new PuegProtocolReportDataSource(creator, created, createdError, recipients, mReasonOfDelivery, false, this.mAdvancedProtocol, this.mNoDetails);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(PuegDS){

            protected boolean doNext() throws JRException {
                return PuegDS.next();
            }
        };
        return dataSource;
    }

    public JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(REPORT_FOLDER + reportName + ".jrxml"));
    }

    private LinkedList<PuegRecipient> initRecipients(PuegAdvice advice, List<PuegAccount> untransmitteds) throws BusinessDomainException {
        HashMap<DEUVRecipient, PuegRecipient> recipients = new HashMap<DEUVRecipient, PuegRecipient>();
        for (PuegAccount account : untransmitteds) {
            PuegRecipient recipient = (PuegRecipient)recipients.get(account.getDEUVRecipient());
            if (recipient == null) {
                recipient = new PuegRecipient(account.getDEUVRecipient(), false);
                recipients.put(account.getDEUVRecipient(), recipient);
            }
            recipient.addAccount(account);
        }
        return new LinkedList<PuegRecipient>(recipients.values());
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

