/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.masterdataimport.comparisonhealthfund;

import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.security.AuthorizationFailureException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.TransactionStatusHolder;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.WriteCalculationJob;
import com.varial.personnel.domain.global.healthfund.AnswerBackEnum;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundFilterStruct;
import com.varial.personnel.domain.global.healthfund.HealthFundFilterStructPackage.optAdministrateByUser;
import com.varial.personnel.domain.global.healthfund.HealthFundFilterStructPackage.optAnswerBack;
import com.varial.personnel.domain.global.healthfund.HealthFundFilterStructPackage.optTypeOfHealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.itsg.DifferencesItsg;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundItsg;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundTPItsg;
import com.varial.personnel.domain.global.healthfund.itsg.UpdateJob;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparisonHealthFunds {
    private final AuthorizationToken mToken;
    private final Progressbar<?> mProgressBar;
    private final TransactionStatusHolder mTxHolder;
    private final TransactionalServiceAdapter mTxAdapter;
    private final List<WriteCalculationJob> mWriteCalculationJobs = new ArrayList<WriteCalculationJob>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonHealthFunds.class);

    public ComparisonHealthFunds(AuthorizationToken token, Progressbar<?> progressBar, TransactionStatusHolder txHolder, TransactionalServiceAdapter txAdapter) {
        this.mToken = token;
        this.mProgressBar = progressBar;
        this.mTxHolder = txHolder;
        this.mTxAdapter = txAdapter;
    }

    public String comparisonHealthFund(Date startDate) throws BusinessDomainException {
        optAnswerBack optAnswer = new optAnswerBack();
        HealthFundFilterStruct healthFundFilterStruct = new HealthFundFilterStruct(new optTypeOfHealthFund(), optAnswer, "", "", "", "", "", "", new optAdministrateByUser());
        HealthFundFilterStruct[] filters = new HealthFundFilterStruct[]{healthFundFilterStruct};
        HealthFundTPItsg[] healthFundTPsItsg = HealthFundItsg.getActiveHealthFundsItsg((HealthFundFilterStruct[])filters, null);
        HashMap<String, ArrayList<HealthFundTPItsg>> healthFundTPItsgMap = new HashMap<String, ArrayList<HealthFundTPItsg>>();
        for (HealthFundTPItsg healthFundTPItsg : healthFundTPsItsg) {
            String key = healthFundTPItsg.getStandardCompanyNumber();
            ArrayList<HealthFundTPItsg> list = (ArrayList<HealthFundTPItsg>)healthFundTPItsgMap.get(key);
            if (list == null) {
                list = new ArrayList<HealthFundTPItsg>();
                healthFundTPItsgMap.put(key, list);
            }
            list.add(healthFundTPItsg);
        }
        optAnswer.answerBack(AnswerBackEnum.ABE_Krankenkasse);
        HealthFundTP[] healthFundTPs = HealthFund.getActiveHealthFunds((HealthFundFilterStruct[])filters, null);
        ArrayList<HealthFundTPItsg> healthFundTPItsgList = new ArrayList<HealthFundTPItsg>();
        for (HealthFundTP healthFundTP : healthFundTPs) {
            String standardCompanyNumber = healthFundTP.getStandardCompanyNumber();
            List list = (List)healthFundTPItsgMap.get(standardCompanyNumber);
            if (list == null) continue;
            healthFundTPItsgList.addAll(list);
        }
        Object result = ComparisonHealthFunds.compareToItsg(healthFundTPItsgList, startDate);
        result = (String)result + "\r\n------------------------------------------------------------------------------------------------------------\r\n\r\n" + this.updateFromItsg(healthFundTPItsgList, startDate);
        return result;
    }

    public static String compareToItsg(List<HealthFundTPItsg> healthFundTPItsgList, Date startDate) throws BusinessDomainException {
        StringBuilder buf = new StringBuilder(32000);
        int count = healthFundTPItsgList.size();
        Date firstImported = VDate.getDateMax();
        int valuations = 0;
        int differences = 0;
        int notfound = 0;
        int ignored = 0;
        for (HealthFundTPItsg healthFundTPItsg : healthFundTPItsgList) {
            HealthFundItsg healthFundItsg = healthFundTPItsg.getHealthFundItsg();
            try {
                Date standardCompanyNumberValidUntil = healthFundTPItsg.getStandardCompanyNumberValidUntil();
                HealthFund healthFund = HealthFund.getByStdCompanyNo((String)healthFundTPItsg.getStandardCompanyNumber());
                if (standardCompanyNumberValidUntil != null && (healthFund == null || healthFund.getActiveHealthFundTP().getStandardCompanyNumberValidUntil() != null) && DateHelper.before((Date)standardCompanyNumberValidUntil, (Date)startDate)) continue;
                DifferencesItsg diff = new DifferencesItsg(healthFundItsg, startDate);
                diff.removeWithdrawalEmployees(startDate);
                Date di = diff.getBegin();
                if (di != null && DateHelper.after((Date)firstImported, (Date)di)) {
                    firstImported = di;
                }
                if (diff.getValuateNeeded()) {
                    ++valuations;
                }
                if (diff.getBo() == null) {
                    ++notfound;
                }
                if (!diff.isDifferent()) continue;
                ++differences;
                if (buf.length() < 32000) {
                    buf.append(diff);
                    continue;
                }
                if (ignored > 0) {
                    buf.append(", ");
                }
                if (ignored % 8 == 0) {
                    buf.append("\r\n");
                }
                buf.append(diff.getId());
                ++ignored;
            }
            catch (BusinessDomainException | AuthorizationFailureException e) {
                LOGGER.error(DifferencesItsg.summaryString(new StringBuilder(buf.length() + 256), count, differences, valuations, notfound).append((CharSequence)buf).toString());
                throw e;
            }
            catch (Throwable t) {
                LOGGER.error(DifferencesItsg.summaryString(new StringBuilder(buf.length() + 256), count, differences, valuations, notfound).append((CharSequence)buf).toString());
                throw new ApplicationException("thrower=[" + healthFundItsg + "]", t);
            }
        }
        if (ignored != 0) {
            buf.append("\r\n\r\nDie Ausgabe der aufgelisteten Betriebsnummern ");
            buf.append("wurde abgek\u00fcrzt.\r\n");
            buf.append("Pr\u00fcfen Sie die Krankenkassen einzeln.");
        }
        StringBuilder b = new StringBuilder(buf.length() + 256);
        b.append("Vergleiche ");
        if (count != 1) {
            b.append(count).append(" GKV-Beitragss\u00e4tze");
        } else {
            b.append("einen GKV-Beitragssatz");
        }
        b.append(" mit den vorhandenen Krankenkassen ab " + DateMapper.toDDMMYYYYPointSeparationString((Date)startDate) + ".\r\n\r\n");
        return DifferencesItsg.summaryString(b, count, differences, valuations, notfound).append((CharSequence)buf).toString();
    }

    private String updateFromItsg(List<HealthFundTPItsg> healthFundTPItsgList, Date startDate) throws BusinessDomainException {
        StringBuilder b = new StringBuilder();
        UpdateJob updateJob = new UpdateJob();
        updateJob.setCount(healthFundTPItsgList.size());
        updateJob.setStartDate(startDate);
        Date schedulerTime = PersonnelBasic.getPersonnelBasic().getSchedulerTimeOfHealthFund();
        this.mProgressBar.setTotal(healthFundTPItsgList.size());
        for (HealthFundTPItsg healthFundTPItsg : healthFundTPItsgList) {
            HealthFundItsg itsg = HealthFundItsg.getHealthFundItsg((String)healthFundTPItsg.getHealthFund().getObjectid());
            HealthFund[] targets = HealthFund.getHealthFundsByNo((String)healthFundTPItsg.getStandardCompanyNumber());
            HealthFund healthFund = HealthFund.getByStdCompanyNo((String)DifferencesItsg.getStandardCompanyNumber(itsg));
            Date itsgSCNValidUntil = itsg.getActiveHealthFundTP().getStandardCompanyNumberValidUntil();
            if (itsgSCNValidUntil == null || healthFund != null && healthFund.getActiveHealthFundTP().getStandardCompanyNumberValidUntil() == null || !DateHelper.before((Date)itsgSCNValidUntil, (Date)startDate)) {
                itsg.createFusionReminder(targets);
                while (updateJob.initHealthFund(itsg, targets)) {
                    PersistencySession context = SessionContext.getInstance().getPersistencySession();
                    WriteCalculationJob calcJob = null;
                    try {
                        updateJob.makeUpdate();
                        updateJob.removeWithdrawalEmployees(startDate);
                        if (updateJob.isDiffValuateNeeded()) {
                            calcJob = updateJob.valuate(this.mToken, schedulerTime);
                        }
                        context.flush();
                        if (calcJob != null) {
                            this.mWriteCalculationJobs.add(calcJob);
                        }
                        this.mTxAdapter.commit(this.mTxHolder.getTransactionStatus());
                        this.mTxHolder.setTransactionStatus(this.mTxAdapter.getUpdateTransaction());
                    }
                    catch (BusinessDomainException e) {
                        LOGGER.warn("Krankenkassenabgleich " + itsg.getHealthFund(), (Throwable)e);
                        context.clearAll();
                        this.mTxHolder.getTransactionStatus().setRollbackOnly();
                        this.mTxAdapter.rollbackOnException(this.mTxHolder.getTransactionStatus(), (Throwable)e);
                        this.mTxHolder.setTransactionStatus(this.mTxAdapter.getUpdateTransaction());
                        updateJob.appendToMessage(e, b);
                    }
                }
            }
            this.mProgressBar.nextProcessed();
        }
        return updateJob.buildResultMessage(b);
    }

    public void executeCalculations(Progressbar<?> progressBar) throws BusinessDomainException {
        progressBar.setTotal(this.mWriteCalculationJobs.size());
        for (WriteCalculationJob calcJob : this.mWriteCalculationJobs) {
            calcJob.runAsService();
            progressBar.nextProcessed();
        }
    }
}

