/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.masterdataimport;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.service.TransactionStatusHolder;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.global.accidentinsurancefund.imports.xml.AIFXmlImport;
import com.varial.personnel.domain.global.employmentoffice.EmploymentOfficeOfficial;
import com.varial.personnel.domain.global.employmentoffice.EmploymentOfficeXmlImport;
import com.varial.personnel.domain.global.masterdata.StammdatendateiCreator;
import com.varial.personnel.domain.global.masterdataimport.MasterDataImportStruct;
import com.varial.personnel.domain.global.masterdataimport.MasterDataImportStructPackage.UpdateViaUnion;
import com.varial.personnel.domain.global.recipient.RecipientXmlImport;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.domain.reports.masterdataimport.MasterDataImportProgressBar;
import com.varial.personnel.domain.reports.masterdataimport.Step;
import com.varial.personnel.domain.reports.masterdataimport.comparisonhealthfund.ComparisonHealthFunds;
import com.varial.personnel.domain.reports.masterdataimport.socialinsurance.SocialInsuranceXmlImport;
import com.varial.personnel.framework.ManageViaSettingTable;
import com.varial.personnel.servantimpl.global.healthfund.HealthFundServantImpl;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import de.gkv.masterdata.version1.Stammdatendatei;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterDataImport {
    private static final String NOTUPDATED = "wurden nicht aktualisiert.";
    private static final Logger LOGGER = LoggerFactory.getLogger(MasterDataImport.class);
    private final MasterDataImportStruct mMasterDataImport;
    private final MasterDataImportProgressBar mProgressBar;
    private final AuthorizationToken mToken;
    private final ReportFileStructCallback mCallback;
    private String dateiInfo;
    private String globaleSVDatenInfo = "wurden nicht aktualisiert.";
    private String gkvKrankenkassenInfo = "wurden nicht aktualisiert.";
    private String uvTraegerInfo = "wurden nicht aktualisiert.";
    private String bvEmpfaengerInfo = "wurden nicht aktualisiert.";
    private String baDienststellenInfo = "wurden nicht aktualisiert.";
    private String abgleichKrankenkassenInfo = "wurden nicht aktualisiert.";

    public MasterDataImport(MasterDataImportStruct masterDataImport, MasterDataImportProgressBar progressBar, AuthorizationToken token, ReportFileStructCallback callback) {
        this.mMasterDataImport = masterDataImport;
        this.mProgressBar = progressBar;
        this.mToken = token;
        this.mCallback = callback;
    }

    public void execute() throws BusinessDomainException {
        ApplicationServiceAdapter applServiceAdapter = new ApplicationServiceAdapter();
        TransactionStatusHolder txHolder = new TransactionStatusHolder();
        TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
        PersistencySession context = null;
        SocialInsuranceXmlImport socialInsuranceImporter = null;
        String fileName = null;
        try {
            applServiceAdapter.beginUpdateService();
            context = applServiceAdapter.getContext();
            txHolder.setTransactionStatus(txAdapter.getUpdateTransaction());
            UpdateViaUnion updateVia = this.mMasterDataImport.updateVia;
            fileName = StammdatendateiCreator.getFileName((UpdateViaUnion)updateVia);
            this.dateiInfo = this.createDateiInfo(fileName, updateVia);
            this.mProgressBar.nextStep((Enum)Step.ReadMasterData);
            Stammdatendatei stammdatendatei = StammdatendateiCreator.create((UpdateViaUnion)updateVia);
            if (updateVia.discriminator() == 1) {
                ManageViaSettingTable.setPathForMasterDataXmlImport((String)this.mToken.getUserId(), (String)updateVia.serverPath());
            }
            this.mProgressBar.nextStep((Enum)Step.ImportSocialInsurance);
            socialInsuranceImporter = new SocialInsuranceXmlImport(this.mToken, (Progressbar<?>)this.mProgressBar, stammdatendatei);
            if (this.mMasterDataImport.importSocialInsurance) {
                socialInsuranceImporter.importXml();
                this.globaleSVDatenInfo = socialInsuranceImporter.getCreated() + " S\u00e4tze Sozialversicherung angelegt.";
                if (socialInsuranceImporter.getCalculationDate() != null) {
                    this.globaleSVDatenInfo = this.globaleSVDatenInfo + "\nAlle nicht ausgetretenen Mitarbeiter werden ab " + DateMapper.toDDMMYYYYPointSeparationString((Date)socialInsuranceImporter.getCalculationDate()) + " neu berechnet.";
                }
            }
            this.mProgressBar.nextStep((Enum)Step.ImportHealthFundItsg);
            if (this.mMasterDataImport.importHealthFundItsg) {
                this.gkvKrankenkassenInfo = new HealthFundServantImpl().importStammdatendatei(stammdatendatei, (Progressbar)this.mProgressBar);
                ManageViaSettingTable.setFileForSIMasterDataXmlImport((String)fileName);
                ManageViaSettingTable.setLastHealthFundImportBySIMasterData();
            }
            this.mProgressBar.nextStep((Enum)Step.ImportAccidentInsuranceFund);
            if (this.mMasterDataImport.importAccidentInsuranceFund) {
                Date firstStartDate = DateMapper.toDate((String)"2025-01-01");
                Date currentDate = DateHelper.getFirstDayOfMonth((Date)new Date());
                Date startDate = DateHelper.addMonths((Date)currentDate, (int)-24);
                if (DateHelper.before((Date)startDate, (Date)firstStartDate)) {
                    startDate = firstStartDate;
                }
                AIFXmlImport aifXmlImport = new AIFXmlImport(stammdatendatei, startDate);
                aifXmlImport.create();
                aifXmlImport.resume(context, (Progressbar<?>)this.mProgressBar);
                context.flush();
                this.uvTraegerInfo = aifXmlImport.getImported() + " Berufsgenossenschaften angelegt und " + aifXmlImport.getUpdated() + " aktualisiert.";
            }
            this.mProgressBar.nextStep((Enum)Step.ImportRecipient);
            if (this.mMasterDataImport.importRecipient) {
                RecipientXmlImport recipientImporter = new RecipientXmlImport(stammdatendatei, (Progressbar<?>)this.mProgressBar);
                recipientImporter.importXml();
                this.bvEmpfaengerInfo = recipientImporter.getCreated() + " Versorgungseinrichtungen angelegt, " + recipientImporter.getUpdated() + " Versorgungseinrichtungen aktualisiert.";
            }
            this.mProgressBar.nextStep((Enum)Step.ImportEmploymentOffice);
            if (this.mMasterDataImport.importEmploymentOffice) {
                EmploymentOfficeXmlImport employmentOfficeImporter = new EmploymentOfficeXmlImport(stammdatendatei, (Progressbar)this.mProgressBar);
                EmploymentOfficeOfficial.deleteAll();
                employmentOfficeImporter.importXml();
                this.baDienststellenInfo = employmentOfficeImporter.getCreated() + " Dienstellen angelegt.";
            }
            LOGGER.debug("flush: begin");
            context.flush();
            LOGGER.debug("flush: end");
            LOGGER.debug("commit: begin");
            txAdapter.commit(txHolder.getTransactionStatus());
            LOGGER.debug("commit: end");
        }
        catch (BusinessDomainException | RuntimeException e) {
            LOGGER.debug("clearAll");
            if (context != null) {
                context.clearAll();
            }
            txHolder.getTransactionStatus().setRollbackOnly();
            LOGGER.debug("rollbackOnException");
            txAdapter.rollbackOnException(txHolder.getTransactionStatus(), e);
            LOGGER.debug("endService");
            applServiceAdapter.endService();
            LOGGER.debug("rethrow");
            throw e;
        }
        txHolder.setTransactionStatus(txAdapter.getUpdateTransaction());
        try {
            this.mProgressBar.nextStep((Enum)Step.ComparisonHealthFund);
            String dateString = "2025-01-01";
            Date startDate = DateMapper.toDate((String)"2025-01-01");
            ComparisonHealthFunds comparisonHealthFunds = new ComparisonHealthFunds(this.mToken, (Progressbar<?>)this.mProgressBar, txHolder, txAdapter);
            this.abgleichKrankenkassenInfo = comparisonHealthFunds.comparisonHealthFund(startDate);
            ManageViaSettingTable.setLastHealthFundUpdate();
            ManageViaSettingTable.setFileForHealthFundImport((String)fileName);
            this.mProgressBar.nextStep((Enum)Step.CreateCalculations);
            LOGGER.debug("socialInsuranceImporter.createCalculations()");
            socialInsuranceImporter.createCalculations((Progressbar<?>)this.mProgressBar, startDate);
            LOGGER.debug("comparisonHealthFunds.executeCalculations()");
            comparisonHealthFunds.executeCalculations((Progressbar<?>)this.mProgressBar);
            LOGGER.debug("flush: begin");
            context.flush();
            LOGGER.debug("flush: end");
            LOGGER.debug("commit: begin");
            txAdapter.commit(txHolder.getTransactionStatus());
            LOGGER.debug("commit: end");
        }
        catch (BusinessDomainException | RuntimeException e) {
            LOGGER.debug("clearAll");
            context.clearAll();
            txHolder.getTransactionStatus().setRollbackOnly();
            LOGGER.debug("rollbackOnException");
            txAdapter.rollbackOnException(txHolder.getTransactionStatus(), e);
            LOGGER.debug("endService");
            applServiceAdapter.endService();
            this.abgleichKrankenkassenInfo = ExceptionUtils.getStackTrace((Throwable)e);
            LOGGER.debug("setException");
            if (e instanceof BusinessDomainException) {
                this.mCallback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)((BusinessDomainException)e)));
            } else {
                this.mCallback.setException(ExceptionMapper.makeDatabaseExceptionStruct((Throwable)e));
            }
            return;
        }
        LOGGER.debug("endService");
        applServiceAdapter.endService();
    }

    private String createDateiInfo(String fileName, UpdateViaUnion updateVia) {
        int discriminator = updateVia.discriminator();
        switch (discriminator) {
            case 1: {
                return fileName + "; Pfad = " + updateVia.serverPath();
            }
            case 2: {
                return fileName + " (Client-Download)";
            }
            case 3: {
                return fileName + " (Server-Download)";
            }
        }
        return "Keine Information \u00fcber die Datei vorhanden.";
    }

    public String getDateiInfo() {
        return this.dateiInfo;
    }

    public String getGlobaleSVDatenInfo() {
        return this.globaleSVDatenInfo;
    }

    public String getGkvKrankenkassenInfo() {
        return this.gkvKrankenkassenInfo;
    }

    public String getUvTraegerInfo() {
        return this.uvTraegerInfo;
    }

    public String getBvEmpfaengerInfo() {
        return this.bvEmpfaengerInfo;
    }

    public String getBaDienststellenInfo() {
        return this.baDienststellenInfo;
    }

    public String getAbgleichKrankenkassenInfo() {
        return this.abgleichKrankenkassenInfo;
    }
}

