/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.eubp;

import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.PerfidiaResult;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.eubp.EubpHelper;
import com.varial.personnel.domain.eubp.EubpMandant;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.account.EubpAccountPersistencyManager;
import com.varial.personnel.domain.eubp.account.EubpAccountStateEnum;
import com.varial.personnel.domain.eubp.basics.BasicRecord;
import com.varial.personnel.domain.eubp.mapper.EubpExceptionMapper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.reports.eubp.EubpCreateReport;
import com.varial.personnel.domain.reports.eubp.EubpCreator;
import com.varial.personnel.domain.reports.eubp.EubpDeliveryReasonEnum;
import com.varial.personnel.domain.reports.eubp.EubpProgressbar;
import com.varial.personnel.domain.reports.eubp.Mandanten;
import com.varial.personnel.domain.reports.eubp.MandantenMap;
import com.varial.personnel.domain.reports.eubp.Step;
import com.varial.personnel.domain.reports.mapper.DEUVExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.framework.ExclusiveExecutionLockHelper;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EubpsCreator
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    public static final String SENDQ_PATH = "\\pem\\sendq\\";
    private static final int COUNT_EMPLOYEES_PER_FILE = 500;
    private final EubpDeliveryReasonEnum mDeliveryReason;
    private final boolean mIsZustellung;
    private final String mEmailAddress;
    private final boolean mIsFragebogen;
    private final boolean mKennzLstAp;
    private final int mKennzWg;
    private final boolean mKennzFamilieMitarbeit;
    private final String mNameAp;
    private final String mTelAp;
    private final String mEmailAp;
    private final String mCompanyNumber;
    private final Date mDeliveryDate;
    private final Date mValidFrom;
    private final Date mValidUntil;
    private final Date mEffectiveDate;
    private final PerfidiaResult mPerfidiaResult = new PerfidiaResult();
    private DEUVSenderTP mDEUVSenderTP;
    private DEUVRecipientTP mDEUVRecipientTP;
    private BasicRecord mBasicRecord;
    private EubpAccount mEubpAccount;
    private ReportDataTransfer mReportDataTransfer;
    private EubpProgressbar mProgressbar;
    private int mFileNumber;

    public EubpsCreator(AuthorizationToken token, ReportFileStructCallback callback, int deliveryReason, boolean isZustellung, String emailAddress, boolean isFragebogen, boolean kennzLstAp, int kennzWg, boolean kennzFamilieMitarbeit, String nameAp, String telAp, String emailAp, String companyNumber, Date deliveryDate, Date validFrom, Date validUntil) {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE, true);
        this.mDeliveryReason = EubpDeliveryReasonEnum.fromInt((int)deliveryReason);
        this.mIsZustellung = isZustellung;
        this.mEmailAddress = emailAddress;
        this.mIsFragebogen = isFragebogen;
        this.mKennzLstAp = kennzLstAp;
        this.mKennzWg = kennzWg;
        this.mKennzFamilieMitarbeit = kennzFamilieMitarbeit;
        this.mNameAp = nameAp;
        this.mTelAp = telAp;
        this.mEmailAp = emailAp;
        this.mCompanyNumber = companyNumber;
        this.mDeliveryDate = deliveryDate;
        this.mValidFrom = validFrom;
        this.mEffectiveDate = this.mValidUntil = validUntil;
    }

    public void execute() throws BusinessDomainException, PutDataException {
        ExclusiveExecutionLockHelper.checkExclusiveExecutionLock((Object)((Object)this), (String)"EubpsCreator");
        this.mProgressbar = new EubpProgressbar(this.getCallback(), 0);
        try {
            this.checkExistsEubpAccount();
            this.mProgressbar.nextStep((Enum)Step.SelectMandanten);
            MandantenMap mandantenMap = new MandantenMap(this.mProgressbar, this.mCompanyNumber, this.mEffectiveDate, this.mValidFrom, this.mValidUntil);
            if (!mandantenMap.hasEmployees()) {
                throw EubpExceptionMapper.makeNoEmployeesFoundException((String)this.mCompanyNumber);
            }
            Mandanten mandantenBetriebsnummer = mandantenMap.getMandanten(this.mCompanyNumber);
            this.mDEUVSenderTP = mandantenBetriebsnummer.getDEUVSenderTP(this.mEffectiveDate, this.mValidUntil);
            if (this.mDEUVSenderTP == null) {
                throw DEUVExceptionMapper.makeNoDEUVSenderToSelectedCompanyDomainException();
            }
            String perfidiaPath = this.mDEUVSenderTP.getPerfidiaPath();
            this.mReportDataTransfer = StringMapper.isNullString((String)perfidiaPath) ? new ReportDataTransfer(SENDQ_PATH, "EBE", false) : new ReportDataTransfer(SENDQ_PATH, "EBE", this.mDEUVSenderTP);
            this.mDEUVRecipientTP = this.queryDEUVRecipientTP();
            this.mFileNumber = this.mDEUVRecipientTP.getFileNumberEUBP();
            this.mBasicRecord = new BasicRecord(this.mDEUVSenderTP.getStdCompanyNumber(), this.mDEUVRecipientTP.getStdCompanyNumber(), DeuvBasics.formatDEUVTimestamp((LocalDateTime)LocalDateTime.now()), 0, 0);
            EubpMandant eubpMandant = mandantenBetriebsnummer.toEubpMandant(this.mEffectiveDate, this.mValidUntil);
            this.mEubpAccount = this.createEubpAccount(eubpMandant);
            Set entrySet = mandantenMap.entrySet();
            int countFiles = 0;
            for (Map.Entry entry : entrySet) {
                int countEmployees = ((Mandanten)entry.getValue()).getEmployees().size();
                countFiles += (countEmployees + 500 - 1) / 500;
            }
            this.mProgressbar = new EubpProgressbar(this.getCallback(), countFiles);
            for (Map.Entry entry : entrySet) {
                String betriebsnummer = (String)entry.getKey();
                Mandanten mandanten = (Mandanten)entry.getValue();
                this.createFiles(betriebsnummer, mandanten);
            }
            this.mEubpAccount.setFileNumberUntil(this.mFileNumber);
            if (this.mEubpAccount.getFileNumberUntil() < this.mEubpAccount.getFileNumberFrom()) {
                this.mEubpAccount.destroy();
            }
            this.mDEUVRecipientTP = this.queryDEUVRecipientTP();
            this.mDEUVRecipientTP.makeSaveable();
            this.mDEUVRecipientTP.setFileNumberEUBP(this.mFileNumber);
            this.getContext().flush();
            this.mPerfidiaResult.writePerfidiaFiles();
            EubpCreateReport report = new EubpCreateReport(this.getCallback(), this.getToken(), this.mEubpAccount, this.mProgressbar);
            report.execute();
            this.getCallback().putData(new String[]{report.getURL()});
        }
        catch (BusinessDomainException | RuntimeException e) {
            this.mPerfidiaResult.deletePerfidiaFiles();
            throw e;
        }
        finally {
            ExclusiveExecutionLockHelper.releaseExclusiveExecutionLock((Object)((Object)this), (String)"EubpsCreator");
        }
    }

    private void createFiles(String betriebsnummer, Mandanten mandanten) throws BusinessDomainException {
        List allEmployees = mandanten.getEmployees();
        EubpMandant eubpMandant = mandanten.toEubpMandant(this.mEffectiveDate, this.mValidUntil);
        Iterator iterator = EubpHelper.getSublists((List)allEmployees, (int)500).iterator();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            List employees = (List)iterator.next();
            ++this.mFileNumber;
            this.mProgressbar.nextFile(this.mFileNumber);
            File perfidiaFile = EubpHelper.getPerfidiaFile((DEUVSender)this.mDEUVSenderTP.getDEUVSender(), (int)this.mFileNumber);
            if (perfidiaFile.exists()) {
                throw EubpExceptionMapper.makeFileExists((String)perfidiaFile.getPath());
            }
            this.mReportDataTransfer.setFFile(perfidiaFile);
            BufferedWriter writer = this.mPerfidiaResult.initPerfidiaFile(perfidiaFile);
            try {
                new EubpCreator(this, (Writer)writer, this.mFileNumber, betriebsnummer, eubpMandant, mandanten, (Collection)employees, isFirst, !iterator.hasNext()).create();
            }
            catch (IOException e) {
                throw EubpExceptionMapper.makeWriteEubpFileException((Throwable)e);
            }
            finally {
                PFileHelper.close(writer);
            }
            isFirst = false;
        }
    }

    private void checkExistsEubpAccount() throws BusinessDomainException {
        EubpAccount[] eubpAccounts = EubpAccountPersistencyManager.getInstance().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"BBNRVU", (String)this.mCompanyNumber), Restrictions.eq((String)"ADVICESTATE", (String)EubpAccountStateEnum.UEBERMITTELT.toDBString()), Restrictions.eq((String)"CANCELED", (String)"N")}), true);
        if (eubpAccounts.length > 0) {
            // empty if block
        }
    }

    private EubpAccount createEubpAccount(EubpMandant eubpMandant) throws BusinessDomainException {
        EubpAccount eubpAccount = new EubpAccount();
        eubpAccount.setProdid(DeuvBasics.getProdId());
        eubpAccount.setModid(DeuvBasics.getModId());
        eubpAccount.setDeuvSender(this.mDEUVSenderTP.getDEUVSender());
        eubpAccount.setDeuvRecipient(this.mDEUVRecipientTP.getDEUVRecipient());
        eubpAccount.setEffectiveFrom(this.mEffectiveDate);
        eubpAccount.setValidFrom(this.mValidFrom);
        eubpAccount.setValidUntil(this.mValidUntil);
        eubpAccount.setBbnrvu(this.mCompanyNumber);
        eubpAccount.setCreatedOn(this.mBasicRecord.getEd());
        eubpAccount.setAdviceState(EubpAccountStateEnum.UEBERMITTELT);
        eubpAccount.setTransmitted(false);
        eubpAccount.setCanceled("N");
        eubpAccount.setReasonOfDelivery(0);
        eubpAccount.setFileNumberFrom(this.mFileNumber + 1);
        eubpAccount.setDeliveryDate(this.mDeliveryDate);
        eubpAccount.setErrorMessage(null);
        eubpAccount.setPCompany(eubpMandant.getPCompany());
        eubpAccount.setPlant(eubpMandant.getPlant());
        eubpAccount.setPlantPlace(eubpMandant.getPlantPlace());
        eubpAccount.setOnlyListOfEmployees(false);
        eubpAccount.setForAssignment(0);
        return eubpAccount;
    }

    private DEUVRecipientTP queryDEUVRecipientTP() throws BusinessDomainException {
        DeuvRecipientMap deuvRecipientMap = new DeuvRecipientMap(this.mDEUVSenderTP.getDEUVSender());
        DEUVRecipient dEUVRecipient = deuvRecipientMap.getDeuvRecipient(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG, true);
        return dEUVRecipient.getCurrentDEUVRecipientTP();
    }

    public EubpDeliveryReasonEnum getDeliveryReason() {
        return this.mDeliveryReason;
    }

    public boolean getIsZustellung() {
        return this.mIsZustellung;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public boolean getIsFragebogen() {
        return this.mIsFragebogen;
    }

    public boolean getKennzLstAp() {
        return this.mKennzLstAp;
    }

    public int getKennzWg() {
        return this.mKennzWg;
    }

    public boolean getKennzFamilieMitarbeit() {
        return this.mKennzFamilieMitarbeit;
    }

    public String getNameAp() {
        return this.mNameAp;
    }

    public String getTelAp() {
        return this.mTelAp;
    }

    public String getEmailAp() {
        return this.mEmailAp;
    }

    public String getCompanyNumber() {
        return this.mCompanyNumber;
    }

    public Date getValidFrom() {
        return this.mValidFrom;
    }

    public Date getValidUntil() {
        return this.mValidUntil;
    }

    public Date getEffectiveDate() {
        return this.mEffectiveDate;
    }

    public DEUVSenderTP getDEUVSenderTP() {
        return this.mDEUVSenderTP;
    }

    public EubpAccount getEubpAccount() {
        return this.mEubpAccount;
    }

    public BasicRecord getBasicRecord() {
        return this.mBasicRecord;
    }

    public EubpProgressbar getProgressbar() {
        return this.mProgressbar;
    }

    public ReportFileStructCallback getCallback() {
        return (ReportFileStructCallback)super.getCallback();
    }
}

