/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pueg.receive;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.DeuvResponse;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.basictypes.FileWithText;
import com.varial.personnel.domain.deuvmessaging.mapper.DeuvmessagingExceptionMapper;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pueg.puegaccount.IPuegAccountPersistencyManager;
import com.varial.personnel.domain.pueg.puegaccount.PuegAccount;
import com.varial.personnel.domain.pueg.puegaccount.PuegAdviceStateEnum;
import com.varial.personnel.domain.pueg.puegaccount.PuegReasonOfDeliveryEnum;
import com.varial.personnel.domain.pueg.receive.PuegReceive;
import com.varial.personnel.framework.PFileHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PuegAcknowledgement
extends BasicReceive<PuegAccount> {
    public static final String[] FILENAMEFILTER = new String[]{"EAPR0", "TAPR0"};
    private static String DXVE = "DXVE";
    private static String DATEINUMMER = "DATEINUMMER";
    private static String OK = "OK";
    private static String PARSER_FEHLER = "PARSERFEHLER";
    private static String DATEIFEHLER = "DATEIFEHLER";
    private static String FEHLERNR = "FEHLERNR";
    private static String FEHLERTEXT = "FEHLERTEXT";
    private static String DATENSATZFEHLER = "DATENSATZFEHLER";
    private static String ANZAHL_DATENSATZ = "ANZAHLDATENSATZ";
    private static String KERNPRUEFUNGEN = "KERNPRUEFUNGEN";
    private static String DSID = "DSID";
    private static String ANZAHL_FEHLER = "ANZAHLFEHLER";
    private static String FEHLER = "FEHLER";
    private static final Pattern DXVE_PATTERN = Pattern.compile("DXVE010000(?<RESPONSEID>.{23})(?<OK>1\\d{6})?(?<PARSERFEHLER>21(\\d{6})(<FEHLERTEXT>.{1000}))?(?<DATEIFEHLER>22(\\d{6})(?<FEHLERNR>.{7})(?<FEHLERTEXT>.{64}))?(?<DATENSATZFEHLER>23(\\d{6})(?<ANZAHLDATENSATZ>\\d{2})(?<KERNPRUEFUNGEN>.*))?");
    private static final int DXVE_MIN_LENGTH = 40;
    private static final Pattern FEHLER_DATENSATZ_PATTERN = Pattern.compile("(?<DSID>.{32})(?<ANZAHLFEHLER>\\d)(?<FEHLER>.*)");
    private static final Pattern FEHLER_PATTERN = Pattern.compile("(?<FEHLERNUMMER>.{7})(?<FEHLERTEXT>.{64})");
    protected final List<PuegAccount> mDatasetsWithErrors = new ArrayList<PuegAccount>();
    private final List<FileWithText> mFilesForReport = new ArrayList<FileWithText>();
    private final int mPerfidiaSubFolderNo = DataRecipientUtil.getSubFolderNumber((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);

    public PuegAcknowledgement(DEUVSender deuvSender) {
        super(deuvSender);
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    @Override
    public List<File> getFilesForProcessing() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        return this.getFileList();
    }

    @Override
    public String getProcedureName() {
        return "PUEG-Meldeverfahren";
    }

    @Override
    public String getFileDescription() {
        return "Verarbeitungsergebnis(se)";
    }

    @Override
    public String getActionName() {
        return "verarbeiten";
    }

    @Override
    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile(file, "Verarbeitungsergebnisse Pueg");
        LinkedList<String> records = PFileHelper.getFileLines(file, ISO_8859_1);
        Matcher matcherDxsv = PuegReceive.SVTOAG_DXSV.matcher((CharSequence)records.poll());
        if (matcherDxsv.matches()) {
            int fileNumberRecv = this.getFileNumberFromFileName(file.getName());
            int fileNumberSend = 0;
            String firstRecord = (String)records.getFirst();
            if (firstRecord.startsWith(DXVE)) {
                fileNumberSend = this.getFileNumberFromDXVE(firstRecord);
            }
            if (fileNumberSend != 0 && this.needProcessing(file, fileNumberSend, fileNumberRecv)) {
                return true;
            }
        }
        return false;
    }

    private int getFileNumberFromDXVE(String dxve) {
        Matcher dxveMatcher = DXVE_PATTERN.matcher(dxve);
        if (dxveMatcher.matches()) {
            if (!StringMapper.isNullString((String)dxveMatcher.group(OK))) {
                return this.asInteger(dxveMatcher.group(OK).substring(1, 7));
            }
            if (!StringMapper.isNullString((String)dxveMatcher.group(PARSER_FEHLER))) {
                return this.asInteger(dxveMatcher.group(PARSER_FEHLER).substring(2, 8));
            }
            if (!StringMapper.isNullString((String)dxveMatcher.group(DATEIFEHLER))) {
                return this.asInteger(dxveMatcher.group(DATEIFEHLER).substring(2, 8));
            }
            if (!StringMapper.isNullString((String)dxveMatcher.group(DATENSATZFEHLER))) {
                return this.asInteger(dxveMatcher.group(DATENSATZFEHLER).substring(2, 8));
            }
        }
        return 0;
    }

    public void processFiles() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        Iterator iterator = this.mFiles.keySet().iterator();
        while (iterator.hasNext()) {
            DEUVRecipient each;
            this.mRecipient = each = (DEUVRecipient)iterator.next();
            for (File file : (List)this.mFiles.get(each)) {
                this.processFile(file);
            }
        }
    }

    protected void processFile(File file) throws BusinessDomainException {
        this.mCurrent = file;
        LinkedList<String> records = PFileHelper.getFileLines(file, ISO_8859_1);
        Matcher matcherDxsv = PuegReceive.SVTOAG_DXSV.matcher((CharSequence)records.pollFirst());
        if (matcherDxsv.matches()) {
            int fileNumberRecv = this.getFileNumberFromFileName(this.mCurrent.getName());
            if (((String)records.getFirst()).startsWith(DXVE)) {
                this.readDxve((String)records.pollFirst(), fileNumberRecv);
            } else {
                throw DeuvmessagingExceptionMapper.makeFalseDatasetContentDomainException((File)this.mCurrent, (String)((String)records.getFirst()));
            }
        }
    }

    private void readDxve(String input, int fileNumberRecv) throws BusinessDomainException {
        Matcher dxveMatcher = this.checkInputGetMatcher(input, 40, DXVE_PATTERN);
        int fileNumberSend = 0;
        if (dxveMatcher.matches()) {
            if (!StringMapper.isNullString((String)dxveMatcher.group(OK))) {
                fileNumberSend = this.asInteger(dxveMatcher.group(OK).substring(1, 7));
                this.processErrorFreeFile(fileNumberSend, fileNumberRecv);
            } else if (!StringMapper.isNullString((String)dxveMatcher.group(PARSER_FEHLER))) {
                String parseError = dxveMatcher.group(PARSER_FEHLER);
                fileNumberSend = this.asInteger(parseError.substring(2, 8));
                String error = this.asString(parseError.substring(8));
                this.processFileParserError(fileNumberSend, fileNumberRecv, error);
            } else if (!StringMapper.isNullString((String)dxveMatcher.group(DATEIFEHLER))) {
                String fileError = dxveMatcher.group(DATEIFEHLER);
                fileNumberSend = this.asInteger(fileError.substring(2, 8));
                String error = dxveMatcher.group(FEHLERNR) + " " + dxveMatcher.group(FEHLERTEXT);
                this.processFileError(fileNumberSend, fileNumberRecv, error);
            } else if (!StringMapper.isNullString((String)dxveMatcher.group(DATENSATZFEHLER))) {
                String datasetError = dxveMatcher.group(DATENSATZFEHLER);
                fileNumberSend = this.asInteger(datasetError.substring(2, 8));
                int count = this.asInteger(dxveMatcher.group(ANZAHL_DATENSATZ));
                String error = dxveMatcher.group(KERNPRUEFUNGEN);
                this.readDatasetErrors(error, fileNumberSend, fileNumberRecv, count);
            }
        }
        this.addProcessedFile(this.mCurrent, fileNumberSend, fileNumberRecv);
    }

    private void readDatasetErrors(String input, int fileNumberSend, int fileNumberRecv, int count) throws BusinessDomainException {
        HashMap<String, String> datasetsWithErros = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            int errorcount = 0;
            Matcher matcher = FEHLER_DATENSATZ_PATTERN.matcher(input);
            if (!matcher.matches()) continue;
            String dsid = matcher.group(DSID);
            errorcount = this.asInteger(matcher.group(ANZAHL_FEHLER));
            String errors = matcher.group(FEHLER);
            String errormessage = this.getErrorMessage(errors.substring(0, errorcount * 71));
            datasetsWithErros.put(dsid, errormessage);
            input = errors.substring(errorcount * 71);
        }
        this.processDatasetErrors(fileNumberSend, fileNumberRecv, datasetsWithErros);
    }

    private void processErrorFreeFile(int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        for (PuegAccount account : this.getPuegAccountsSendForFilenumber(fileNumberSend)) {
            if (account.getAdviceState() != PuegAdviceStateEnum.UEBERMITTELT) continue;
            account.setAdviceState(PuegAdviceStateEnum.VERARBEITET);
        }
        this.addFileForReport(this.mCurrent, this.getAdviceStateDesc(AdviceStateEnum.ERFOLGREICH));
    }

    private void processFileParserError(int fileNumberSend, int fileNumberRecv, String error) throws BusinessDomainException {
        for (PuegAccount account : this.getPuegAccountsSendForFilenumber(fileNumberSend)) {
            account.setAdviceState(PuegAdviceStateEnum.FEHLER_DATEI);
            account.setErrorMessage(error);
        }
        this.addFileForReport(this.mCurrent, "Parser-Fehler: " + error);
    }

    private void processFileError(int fileNumberSend, int fileNumberRecv, String error) throws BusinessDomainException {
        for (PuegAccount account : this.getPuegAccountsSendForFilenumber(fileNumberSend)) {
            account.setAdviceState(PuegAdviceStateEnum.FEHLER_DATEI);
            account.setErrorMessage(error);
        }
        this.addFileForReport(this.mCurrent, this.getAdviceStateDesc(AdviceStateEnum.FEHLER_DATEI) + error);
    }

    private void processDatasetErrors(int fileNumberSend, int fileNumberRecv, Map<String, String> datasetsWithErrors) throws BusinessDomainException {
        Object dsidNotFound = "";
        List<PuegAccount> accounts = this.getPuegAccountsSendForFilenumber(fileNumberSend);
        for (String dsid : datasetsWithErrors.keySet()) {
            boolean found = false;
            for (PuegAccount each : new ArrayList<PuegAccount>(accounts)) {
                if (each.getReasonOfDelivery() == PuegReasonOfDeliveryEnum.ANFRAGE) {
                    if (each.getPuegAnfrage() != null && StringMapper.equalWithTrim((String)dsid, (String)each.getPuegAnfrage().getMessageid().substring(0, 32))) {
                        each.setAdviceState(PuegAdviceStateEnum.ABGELEHNT);
                        each.setErrorMessage(datasetsWithErrors.get(dsid));
                        found = true;
                    }
                } else if (each.getPuegKuendigung() != null && StringMapper.equalWithTrim((String)dsid, (String)each.getPuegKuendigung().getMessageid().substring(0, 32))) {
                    each.setAdviceState(PuegAdviceStateEnum.ABGELEHNT);
                    each.setErrorMessage(datasetsWithErrors.get(dsid));
                    found = true;
                }
                if (!found) continue;
                this.mDatasetsWithErrors.add(each);
                accounts.remove((Object)each);
                break;
            }
            if (found) continue;
            dsidNotFound = (String)dsidNotFound + " [" + dsid + "]";
        }
        boolean allHaveErrors = accounts.isEmpty();
        for (PuegAccount each : accounts) {
            each.setAdviceState(PuegAdviceStateEnum.VERARBEITET);
        }
        this.addFileForReport(this.mCurrent, allHaveErrors, (String)dsidNotFound);
    }

    private String getErrorMessage(String errortext) {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        while (errortext.length() > 0) {
            result.add((CallSite)((Object)(errortext.substring(0, 7) + " " + errortext.substring(7, 71).trim())));
            errortext = errortext.substring(71);
        }
        return result.stream().collect(Collectors.joining(", "));
    }

    private List<PuegAccount> getPuegAccountsSendForFilenumber(int fileNumber) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"CURRENTFILENUMBER", (String)String.valueOf(fileNumber)), Restrictions.eq((String)"OIDDEUVSENDER", (String)this.mDeuvSender.getObjectid()), Restrictions.eq((String)"OIDDEUVRECIPIENT", (String)this.mRecipient.getObjectid())});
        ArrayList<PuegAccount> result = new ArrayList<PuegAccount>();
        for (PuegAccount uvDsas : this.getIPuegAccountPM().query(null, (Criterion)filter, false)) {
            result.add(uvDsas);
        }
        return result;
    }

    private boolean needProcessing(File file, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        DeuvResponse response = new DeuvResponse(PerfidiaDataType.APR, this.mPerfidiaSubFolderNo, fileNumberSend, fileNumberRecv, file.getName().startsWith("T") || file.getName().startsWith("t") ? 1 : 0);
        return response.needAcknowlegement(this.mDeuvSender);
    }

    protected void addProcessedFile(File file, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        this.mAcknowledgement.addProcessedFile(file, PerfidiaDataType.APR, this.mPerfidiaSubFolderNo, fileNumberSend, fileNumberRecv);
    }

    private void addFileForReport(File file, boolean allHaveErrors, String dsidNotFound) {
        Object errortext = "";
        errortext = allHaveErrors ? "alle Datens\u00e4tze fehlerhaft" : (dsidNotFound.isEmpty() ? "Datens\u00e4tze teilweise fehlerhaft" : "Folgende Datensatz-IDs wurden nicht gefunden:" + dsidNotFound);
        this.addFileForReport(file, (String)errortext);
    }

    protected void addFileForReport(File file, String text) {
        this.mFilesForReport.add(new FileWithText(file, text));
    }

    protected String getAdviceStateDesc(AdviceStateEnum adviceState) {
        String result = "";
        switch (adviceState) {
            case ERFOLGREICH: {
                result = "fehlerfrei verarbeitet";
                break;
            }
            case FEHLER_DATEI: {
                result = "Dateifehler: ";
                break;
            }
            case FEHLER_BESTANDSPRUEFUNG: {
                result = "R\u00fcckmeldung Bestandsfehler";
                break;
            }
        }
        return result;
    }

    public List<PuegAccount> getDatasetsWithErrors() {
        return Collections.unmodifiableList(this.mDatasetsWithErrors);
    }

    public List<FileWithText> getFilesForReport() {
        return Collections.unmodifiableList(this.mFilesForReport);
    }

    private IPuegAccountPersistencyManager getIPuegAccountPM() {
        return (IPuegAccountPersistencyManager)UtilitiesManager.getBean((String)"puegAccountPersistencyManager", IPuegAccountPersistencyManager.class);
    }
}

