/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.recipient.mapper;

import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.ExceptionMapper;

public class RecipientExceptionMapper {
    private static final String CLASS_GENERAL = "PYEmpfaenger";
    private static final int VALID_TIMEPOINT_IS_EMPTY = 100;
    private static final int RECIPIENT_KEY_MISSING = 101;
    private static final int LONG_DESCRIPTION_MISSING = 102;
    private static final int VWP_MISSING = 103;
    private static final int MONTHLY_MAX_ASSESSABLE_EARNINGS_MISSING = 104;
    private static final int PERCENTAGE_EE_CONTRIBUTION_MISSING = 105;
    private static final int PERCENTAGE_ER_CONTRIBUTION1_MISSING = 106;
    private static final int PERCENTAGE_ER_CONTRIBUTION2_MISSING = 107;
    private static final int RECIPIENT_DONT_EXIST_FOR_THIS_TIME = 110;
    private static final int EMPLOYEE_MISSING = 111;
    private static final int BANKACCOUNT_MISSING = 112;
    private static final int INVALID_DUPLICATION_MONTH = 113;
    private static final int STDCOMPANYNO_NOT_VALID = 114;
    private static final int DUMMY_MEMBERSHIPNO_NOT_VALID = 115;
    private static final int NO_PERCENTAGE_OF_CONTRIBUTION_EE_EXIST = 116;
    private static final int NO_PERCENTAGE_OF_CONTRIBUTION_ER_EXIST = 117;
    private static final int NO_MAXIMUM_CONTRIBUTION_EXIST = 118;
    private static final int VALUETYPE_PAYMENT_MISSING = 119;
    private static final int CANNOT_CREATE_RECIPIENTKEY = 120;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYEmpfaenger", new ErrorMessage[]{new ErrorMessage(100, "Der Zeitpunkt der G\u00fcltigkeit wurde nicht \u00fcbergeben"), new ErrorMessage(101, "Der Empf\u00e4nger fehlt"), new ErrorMessage(102, "Der Name fehlt"), new ErrorMessage(103, "Die Empf\u00e4ngerart ist VWP, aber es fehlen die VWP-Angaben"), new ErrorMessage(104, "Die monatl. Bemessungsgrenze fehlt"), new ErrorMessage(105, "Der Prozentsatz AN-Anteil fehlt"), new ErrorMessage(106, "Der Prozentsatz 1. AG-Anteil fehlt"), new ErrorMessage(107, "Der Prozentsatz 2. AG-Anteil fehlt"), new ErrorMessage(110, "Der Empf\u00e4nger ist zum angegebenen 'G\u00fcltig ab' nicht vorhanden"), new ErrorMessage(111, "Der Mitarbeiter fehlt"), new ErrorMessage(112, "Die Bankverbindung und die Bankkonto-Nr. sind bei dieser Empf\u00e4ngerart Pflichteingaben"), new ErrorMessage(113, "Der Verdoppelungsmonat muss im Wertebereich 0-12 liegen! 0 = keine Verdoppelung."), new ErrorMessage(114, "Keine g\u00fcltige Betriebs-Nr. f\u00fcr den Empf\u00e4nger der Art Versorgungseinrichtung: "), new ErrorMessage(115, "Keine g\u00fcltige Dummy-Mitgliedsnummer f\u00fcr den eingegebenen Empf\u00e4nger der Art Versorgungseinrichtung: "), new ErrorMessage(116, "Der VBLU - AN-Beitragssatz wurde nicht gepflegt"), new ErrorMessage(117, "Der VBLU - AG-Beitragssatz wurde nicht gepflegt"), new ErrorMessage(118, "Der VBLU - H\u00f6chstbeitrag wurde nicht gepflegt"), new ErrorMessage(119, "Die Wertart f\u00fcr ZV-pfl.-Entgelt fehlt in Zeile: "), new ErrorMessage(120, "Kann keinen neuen Schl\u00fcssel erzeugen: ")});

    public static BusinessDomainException makeValidTimepointIsEmptyDomainException(String method) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)method, (String)"", (int)100, (String)mErrorList.getDefaultString(100));
    }

    public static BusinessDomainException makeRecipientKeyMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkRecipientKey", (String)"", (int)101, (String)mErrorList.getDefaultString(101));
    }

    public static BusinessDomainException makeLongDescriptionMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkLongDescription", (String)"", (int)102, (String)mErrorList.getDefaultString(102));
    }

    public static BusinessDomainException makeVWPMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkVWP", (String)"", (int)103, (String)mErrorList.getDefaultString(103));
    }

    public static BusinessDomainException makeMonthlyMaxAssessableEarningsMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkVWP", (String)"", (int)104, (String)mErrorList.getDefaultString(104));
    }

    public static BusinessDomainException makePercentageEEContributionMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkVWP", (String)"", (int)105, (String)mErrorList.getDefaultString(105));
    }

    public static BusinessDomainException makePercentageERContribution1MissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkVWP", (String)"", (int)106, (String)mErrorList.getDefaultString(106));
    }

    public static BusinessDomainException makePercentageERContribution2MissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"checkVWP", (String)"", (int)107, (String)mErrorList.getDefaultString(107));
    }

    public static BusinessDomainException makeRecipientDontExistForThisTimeDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"Recipient.getOjectFromObjectID", (String)"", (int)110, (String)mErrorList.getDefaultString(110));
    }

    public static BusinessDomainException makeEmployeeMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"RecipientServantImpl.getObjectWithCurrentReasonForTransfer", (String)"", (int)111, (String)mErrorList.getDefaultString(111));
    }

    public static BusinessDomainException makeBankAccountMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"RecipientTP.checkBankAccount", (String)"", (int)112, (String)mErrorList.getDefaultString(112));
    }

    public static BusinessDomainException makeInvalidDuplicationMonthDomainException(int duplicationMonth) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"RecipientTP.checkZVK", (String)Integer.toString(duplicationMonth), (int)113, (String)mErrorList.getDefaultString(113));
    }

    public static BusinessDomainException makeStdCompanyNoNotValidDomainException(String info) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)114, (String)(mErrorList.getDefaultString(114) + info));
    }

    public static BusinessDomainException makeDummyMemberShipNoNotValidDomainException(String info) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)115, (String)(mErrorList.getDefaultString(115) + info));
    }

    public static BusinessDomainException makeNoContPercEEBusinessDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)116, (String)mErrorList.getDefaultString(116));
    }

    public static BusinessDomainException makeNoContPercERBusinessDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)117, (String)mErrorList.getDefaultString(117));
    }

    public static BusinessDomainException makeNOMaximumConributionBusinessDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)118, (String)mErrorList.getDefaultString(118));
    }

    public static BusinessDomainException makeValueTypePaymentMissingBusinessDomainException(int row) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)119, (String)(mErrorList.getDefaultString(119) + row));
    }

    public static BusinessDomainException makeCannotCreateRecipientKeyException(String key) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)120, (String)(mErrorList.getDefaultString(120) + key));
    }
}

