/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.healthfund;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.global.healthfund.AssessmentData;
import com.varial.personnel.domain.global.healthfund.AssessmentPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.mapper.HealthFundExceptionMapper;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;

public class Assessment
extends PersistentObject {
    private static final String U1 = "U1";
    private static final String U2 = "U2";
    private static final String U3 = "U3";
    private static final String[] ASSESSMENT_KEYS = new String[]{"U1", "U1", "U1", "U2", "U2", "U2", "U3", "U3", "U3", "U1", "U1", "U1", "U2", "U2", "U2", "U3", "U3", "U3"};
    private static final int PRIORITY = 3;
    private HealthFundTP mHealthFundTP;
    private int mSerialNumber;
    private BigDecimal mSubmitPercentage;
    private BigDecimal mRefundPercentage;

    public Assessment(HealthFundTP healthFundTp, boolean readOnly) {
        super(3, readOnly);
        this.mHealthFundTP = healthFundTp;
    }

    public Assessment(HealthFundTP healthFundTp) {
        super(3);
        this.mHealthFundTP = healthFundTp;
    }

    public static Assessment getAssessment(String objectID, HealthFundTP hftp) {
        return new Assessment(objectID, hftp);
    }

    protected Assessment(String objectID, HealthFundTP hftp) {
        super(3, objectID);
        this.mHealthFundTP = hftp;
    }

    public Assessment(String objectID, int version, HealthFundTP hftp) {
        super(3, objectID, version);
        this.mHealthFundTP = hftp;
    }

    protected void load() {
        AssessmentPersistencyManager.load(this);
    }

    protected void saveImpl() {
        AssessmentPersistencyManager.save(this);
    }

    protected void deleteImpl() {
        AssessmentPersistencyManager.delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.mHealthFundTP.getObjectid() + " / " + this.keyBySerialNumber() + " / " + this.mSerialNumber;
    }

    public void lastExecuteImpl() throws BusinessDomainException {
        this.saveImpl();
    }

    public void setData(AssessmentData data) {
        this.mSerialNumber = data.getSerialNumber();
        this.mSubmitPercentage = BigDecimalMapper.toBigDecimal((BigDecimal)data.getSubmitPercentage());
        this.mRefundPercentage = BigDecimalMapper.toBigDecimal((BigDecimal)data.getRefundPercentage());
    }

    public Assessment createNew(HealthFundTP hftp) {
        Assessment result = new Assessment(hftp);
        this.requireLoaded();
        result.mSerialNumber = this.mSerialNumber;
        result.mSubmitPercentage = this.mSubmitPercentage;
        result.mRefundPercentage = this.mRefundPercentage;
        return result;
    }

    public HealthFundTP getHealthFundTP() {
        this.requireLoaded();
        return this.mHealthFundTP;
    }

    public void setHealthFundTP(HealthFundTP healthFundTP) {
        this.mHealthFundTP = healthFundTP;
    }

    public String getAssessmentKey() {
        this.requireLoaded();
        return this.keyBySerialNumber();
    }

    public int getSerialNumber() {
        this.requireLoaded();
        return this.mSerialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.protocol("SerialNumber", this.mSerialNumber, serialNumber);
        this.mSerialNumber = serialNumber;
    }

    public BigDecimal getSubmitPercentage() {
        this.requireLoaded();
        return this.mSubmitPercentage;
    }

    public void setSubmitPercentage(BigDecimal submitPercentage) {
        this.protocol("SubmitPercentage", this.mSubmitPercentage, submitPercentage);
        this.mSubmitPercentage = BigDecimalMapper.toBigDecimal((BigDecimal)submitPercentage);
    }

    public BigDecimal getRefundPercentage() {
        this.requireLoaded();
        return this.mRefundPercentage;
    }

    public void setRefundPercentage(BigDecimal refundPercentage) {
        this.protocol("RefundPercentage", this.mRefundPercentage, refundPercentage);
        this.mRefundPercentage = BigDecimalMapper.toBigDecimal((BigDecimal)refundPercentage);
    }

    public static Assessment[] getAssessmentU1(HealthFundTP hftp) {
        return AssessmentPersistencyManager.getAssessmentU1(hftp);
    }

    public static Assessment[] getAssessmentU2(HealthFundTP hftp) {
        return AssessmentPersistencyManager.getAssessmentU2(hftp);
    }

    public static Assessment[] getAssessmentU3(HealthFundTP hftp) {
        return AssessmentPersistencyManager.getAssessmentU3(hftp);
    }

    public boolean compareToOld(Assessment old) {
        if (old == null) {
            return false;
        }
        old.requireLoaded();
        boolean sameRefund = this.mRefundPercentage == old.mRefundPercentage || this.mRefundPercentage != null && old.mRefundPercentage != null && BigDecimalMapper.compareTo((BigDecimal)this.mRefundPercentage, (BigDecimal)old.mRefundPercentage) == 0;
        boolean sameSubmit = this.mSubmitPercentage == old.mSubmitPercentage || this.mSubmitPercentage != null && old.mSubmitPercentage != null && BigDecimalMapper.compareTo((BigDecimal)this.mSubmitPercentage, (BigDecimal)old.mSubmitPercentage) == 0;
        return !sameRefund || !sameSubmit;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(256);
        b.append(((Object)((Object)this)).getClass().getSimpleName());
        b.append('{').append(this.keyBySerialNumber());
        b.append(',').append(this.mSerialNumber);
        b.append(',').append(this.mRefundPercentage);
        b.append(',').append(this.mSubmitPercentage);
        b.append(',').append(this.mHealthFundTP == null ? "null" : this.mHealthFundTP.toStringKey());
        b.append('}');
        return b.toString();
    }

    public boolean isEmpty() {
        this.requireLoaded();
        return BigDecimalMapper.isZeroOrNull((BigDecimal)this.mRefundPercentage) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSubmitPercentage);
    }

    private String keyBySerialNumber() {
        if (this.mSerialNumber < 1 || this.mSerialNumber > ASSESSMENT_KEYS.length) {
            return null;
        }
        return ASSESSMENT_KEYS[this.mSerialNumber - 1];
    }

    public void checkValues() throws BusinessDomainException {
        String id;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mRefundPercentage)) {
            return;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSubmitPercentage)) {
            return;
        }
        if (this.mHealthFundTP != null && U2 == this.keyBySerialNumber() && ("98000006".equals(id = this.mHealthFundTP.getStandardCompanyNumber()) || "98000001".equals(id))) {
            return;
        }
        throw HealthFundExceptionMapper.makeAssessmentValuesDomainException();
    }

    public static String valueStringOf(Assessment assessment) {
        if (assessment == null) {
            return null;
        }
        StringBuffer b = new StringBuffer(20);
        b.append(BigDecimalMapper.toString((BigDecimal)BigDecimalMapper.toBigDecimal((BigDecimal)assessment.mRefundPercentage).setScale(2)));
        b.append(' ');
        b.append(BigDecimalMapper.toString((BigDecimal)BigDecimalMapper.toBigDecimal((BigDecimal)assessment.mSubmitPercentage).setScale(2)));
        return b.toString();
    }
}

