/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.fileimport.absenttime;

import com.varial.framework.domain.fileimport.ImportReader;
import com.varial.framework.domain.fileimport.ImportedLine;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsentTimePositionReader
implements ImportReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbsentTimePositionReader.class);
    private final int[] mFieldIndex;
    private BufferedReader mReader;
    private String mCurrentLine;
    private boolean mFinished;
    private int mLineNumber;

    public AbsentTimePositionReader(int[] fieldIndex) {
        if (fieldIndex == null || fieldIndex.length <= 1) {
            throw ExceptionMapper.makeApplicationException((String)"no fields");
        }
        this.mFieldIndex = fieldIndex;
        Arrays.sort(this.mFieldIndex);
        if (this.mFieldIndex[0] < 0) {
            throw ExceptionMapper.makeApplicationException((String)"start index < 0");
        }
    }

    public boolean startRead(File readFile, String presetEncoding) {
        if (!readFile.exists()) {
            return false;
        }
        try {
            String encoding = presetEncoding;
            if (StringMapper.isNullString((String)encoding)) {
                encoding = System.getProperty("file.encoding");
            }
            InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(readFile), encoding);
            this.mReader = new BufferedReader(streamReader);
            this.mCurrentLine = null;
            this.mFinished = false;
            this.mLineNumber = 0;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return true;
    }

    public boolean hasNext() {
        if (this.mFinished) {
            return false;
        }
        if (this.mCurrentLine == null) {
            this.readNextLine();
            return !this.mFinished;
        }
        return true;
    }

    public ImportedLine nextLine() {
        if (this.mFinished) {
            return null;
        }
        if (this.mCurrentLine == null) {
            this.readNextLine();
            if (this.mFinished) {
                return null;
            }
        }
        ++this.mLineNumber;
        if (StringMapper.isNullString((String)this.mCurrentLine)) {
            ImportedLine result = new ImportedLine();
            result.mLineNumber = this.mLineNumber;
            result.mImportedLine = this.mCurrentLine;
            result.mFields = new String[0];
            this.mCurrentLine = null;
            return result;
        }
        try {
            LOGGER.debug("line <{}>", (Object)this.mCurrentLine);
            char[] chars = this.mCurrentLine.toCharArray();
            String[] tokens = new String[this.mFieldIndex.length - 1];
            for (int i = 0; i < this.mFieldIndex.length - 1; ++i) {
                if (this.mFieldIndex[i + 1] <= chars.length) {
                    tokens[i] = new String(chars, this.mFieldIndex[i], this.mFieldIndex[i + 1] - this.mFieldIndex[i]);
                    if (i != 6) continue;
                    tokens[6] = tokens[6].replaceAll("\\s", ".");
                    continue;
                }
                if (this.mFieldIndex[i] < chars.length) {
                    tokens[i] = new String(chars, this.mFieldIndex[i], chars.length - this.mFieldIndex[i]);
                    if (i != 6) continue;
                    tokens[6] = tokens[6].replaceAll("\\s", ".");
                    continue;
                }
                tokens[i] = "";
            }
            ImportedLine result = new ImportedLine();
            result.mLineNumber = this.mLineNumber;
            result.mImportedLine = this.mCurrentLine;
            result.mFields = tokens;
            this.mCurrentLine = null;
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public void endRead() {
        try {
            if (this.mReader != null) {
                this.mReader.close();
            }
        }
        catch (IOException ie) {
            throw ExceptionMapper.makeApplicationException((Throwable)ie);
        }
    }

    private void readNextLine() {
        try {
            this.mCurrentLine = this.mReader.readLine();
            if (this.mCurrentLine == null) {
                this.mFinished = true;
            }
        }
        catch (IOException ie) {
            throw ExceptionMapper.makeApplicationException((Throwable)ie);
        }
    }
}

