/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.libraryimpl;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFund;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.calculation.mapper.CalculationExceptionMapper;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.costunit.CostUnit;
import com.varial.personnel.domain.designationtype.designation.Designation;
import com.varial.personnel.domain.designationtype.wagefactor.WageFactor;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.employee.carriedforward.system.sidistance.EECarriedForwardSIDistance;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.carriedforward.varpayment.EECarriedForwardVarPayment;
import com.varial.personnel.domain.employee.carriedforward.zvk.EECarriedForwardZVK;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.dataera.EEDataERA;
import com.varial.personnel.domain.employee.education.Education;
import com.varial.personnel.domain.employee.eewagefactor.EEWageFactorTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.TypeOfEarnedIncomEnum;
import com.varial.personnel.domain.employee.employment.TypeOfTimeOffEnum;
import com.varial.personnel.domain.employee.insurance.AssessmentDutyEnum;
import com.varial.personnel.domain.employee.insurance.ChoiseOfDuesHIEnum;
import com.varial.personnel.domain.employee.insurance.ChoiseOfDuesNIEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScalePHIEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVHIEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVNIEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.ModeOfCalculationEnum;
import com.varial.personnel.domain.employee.insurance.ModeOfPensionEnum;
import com.varial.personnel.domain.employee.insurance.MultipleIncomeEnum;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.insurance.RemittanceEnum;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.insurance.TypeAgePartTimeEnum;
import com.varial.personnel.domain.employee.insurance.mapper.DemandOfFreeAmountEnum;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.pensionscheme.AdvancementTypeEnum;
import com.varial.personnel.domain.employee.pensionscheme.ContractTypeEnum;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.scalepayment.ScalePaymentTP;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.DevRedHHBenfRateEnum;
import com.varial.personnel.domain.employee.tax.EvaluationTargetOfPaymentEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.vblu.EEVBLU;
import com.varial.personnel.domain.employee.vblu.VbluImplementationPathEnum;
import com.varial.personnel.domain.employee.work.EEWork;
import com.varial.personnel.domain.employee.zvk.CalcOfAddContEnum;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.employee.zvk.FurtherInsuranceEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalcAddContEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalculationEnum;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.IGlobalLibraryImplFactory;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModel;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModelTP;
import com.varial.personnel.domain.global.creditmodel.CreditModel;
import com.varial.personnel.domain.global.creditmodel.TypeOfCreditEnum;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.socialinsurancestatus.SocialInsuranceStatus;
import com.varial.personnel.domain.typeofvalue.basictypes.Truncation;
import com.varial.personnel.domain.typeofvalue.basictypes.TruncationEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.TruncationScaleEnum;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class EmployeeLibraryImpl
implements EmployeeLibrary {
    private static final BigDecimal SIEBEN = BigDecimal.valueOf(7L);
    private static final BigDecimal ZWOELF = BigDecimal.valueOf(12L);
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static final int _64 = 64;
    private static final int _54 = 54;
    private final CalculationCase mCalculationCase;
    private final ValuePosition mValuePosition;
    private EEWork mEEWork = null;
    private boolean mEEWorkLoaded = false;
    private Master mMaster = null;
    private boolean mMasterLoaded = false;
    private Tax mTax = null;
    private boolean mTaxLoaded = false;
    private Insurance mInsurance = null;
    private boolean mInsuranceLoaded = false;
    private Employment mEmployment = null;
    private boolean mEmploymentLoaded = false;
    private int mAJahr;
    private boolean mAJahrLoaded = false;
    private BigDecimal mHinzur = BigDecimal.ZERO;
    private boolean mHinzurLoaded = false;
    private BigDecimal mJFreib = BigDecimal.ZERO;
    private boolean mJFreibLoaded = false;
    private BigDecimal mLZZFreib = BigDecimal.ZERO;
    private boolean mLZZFreibLoaded = false;
    private BigDecimal mJHinzu = BigDecimal.ZERO;
    private boolean mJHinzuLoaded = false;
    private BigDecimal mVBezS = BigDecimal.ZERO;
    private boolean mVBezSLoaded = false;
    private int mVJahr;
    private boolean mVJahrLoaded = false;
    private BigDecimal mWfundf = BigDecimal.ZERO;
    private boolean mWfundfLoaded = false;
    private BigDecimal mZkf = BigDecimal.ZERO;
    private BigDecimal mZMVB = BigDecimal.ZERO;
    private boolean mZMVBLoaded = false;
    private int lzz = 2;
    private boolean pauschaleSteuerErmittlung = false;
    private boolean mZkfLoaded = false;
    private boolean mKugBerechnung = false;
    private final boolean mBeginnKUGLoaded = false;
    private Date mBeginnKUG = null;
    private BigDecimal mKvLuft = BigDecimal.ZERO;
    private boolean mKvLuftLoaded = false;
    private BigDecimal mPvLuft = BigDecimal.ZERO;
    private boolean mPvLuftLoaded = false;
    private boolean mInsGPflichtig = false;
    private boolean mInsGPflichtigLoaded = false;
    private BigDecimal mFaktorF = BigDecimal.ONE;
    private boolean mEeZvkLoaded = false;
    private EEZVK mEEZVK;
    private boolean mEeCFZvkLoaded = false;
    private EECarriedForwardZVK[] mEECarriedForwardsZVK = null;
    private boolean pkpvLoaded = false;
    private BigDecimal mPkpv = BigDecimal.ZERO;
    private boolean pvzLoaded = false;
    private int mPvz = 0;
    private int mPkv = 0;
    private boolean pkvLoaded = false;
    private boolean faktorFLoaded = false;
    private ScalePaymentTP[] marbTarifdaten;
    private boolean marbTarifdatenLoaded = false;
    private boolean mEEWorkVMLoaded = false;
    private EEWork mEEWorkVM;
    private boolean mKiStLStJA = false;
    private HealthFundTP mHealthFundTP = null;
    private boolean mHealthFundTPLoaded = false;
    private boolean mLohnsteuerberechnungDBA = false;
    private boolean mEEDataERALoaded = false;
    private EEDataERA mEEDataERA = null;
    private boolean mHealthFundTPKVdRLoaded = false;
    private HealthFundTP mHealthFundTPKVdR = null;
    private boolean mKrKWechselInKVdR = false;

    public EmployeeLibraryImpl(ValuePosition valuePosition, CalculationCase calculationCase) {
        this.mValuePosition = valuePosition;
        this.mCalculationCase = calculationCase;
    }

    public Date marbJournalisiertBis() throws BusinessDomainException {
        return this.mCalculationCase.getEmployee().getJournalizedUntil();
    }

    public PCompany marbFirma() throws BusinessDomainException {
        return this.mCalculationCase.getEmployee().getPCompany();
    }

    public int alter1() throws BusinessDomainException {
        Date beginnAltersentlastung;
        int altersentlastung = 0;
        if (!this.mLohnsteuerberechnungDBA && !this.isPauschaleSteuerErmittlung() && DateHelper.beforeOrEqual((Date)(beginnAltersentlastung = this.getBeginnAltersentlastung()), (Date)this.mCalculationCase.getValidFrom())) {
            altersentlastung = 1;
        }
        return altersentlastung;
    }

    private Date getBeginnAltersentlastung() throws BusinessDomainException {
        Date beginnAltersentlastung = new VDate(this.getMaster().getDateOfBirth()).addYears(64).getDate();
        if (!DateHelper.equal((Date)beginnAltersentlastung, (Date)DateHelper.getFirstDayOfYear((Date)beginnAltersentlastung))) {
            beginnAltersentlastung = DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)beginnAltersentlastung));
        }
        return beginnAltersentlastung;
    }

    public BigDecimal vortragBruttoArbeitslohn(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryBruttoArbeitslohn(stichtag);
    }

    public BigDecimal vortragErmBruttoArbeitslohn(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryErmBruttoArbeitslohn(stichtag);
    }

    public BigDecimal vortragLSt(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryLohnsteuer(stichtag);
    }

    public BigDecimal vortragErmLSt(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryErmLohnsteuer(stichtag);
    }

    public BigDecimal vortragSolZ(Date stichtag) throws BusinessDomainException {
        return this.getCFEntrySolZ(stichtag);
    }

    public BigDecimal vortragErmSolZ(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryErmSolZ(stichtag);
    }

    public BigDecimal vortragKiSt(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryKirchensteuer(stichtag);
    }

    public BigDecimal vortragErmKiSt(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryErmKirchensteuer(stichtag);
    }

    public BigDecimal vortragKiStEhegatte(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryKirchensteuerEhegatte(stichtag);
    }

    public BigDecimal vortragErmKiStEhegatte(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryErmKirchensteuerEhegatte(stichtag);
    }

    public boolean vortragAusschlussLStJAVorAG(Date stichtag) throws BusinessDomainException {
        return this.getCFAusschlussDurchVorAGLSTJA(stichtag);
    }

    public BigDecimal vortragSozialVersicherungKVEntgelt(Date stichtag) throws BusinessDomainException {
        return this.getCFSIKVEntgelt(stichtag);
    }

    public BigDecimal vortragSozialVersicherungRVTage(Date stichtag) throws BusinessDomainException {
        return this.getCFSIRVTage(stichtag);
    }

    public BigDecimal vortragSozialVersicherungRVEntgelt(Date stichtag) throws BusinessDomainException {
        return this.getCFSIRVEntgelt(stichtag);
    }

    public BigDecimal vortragSozialVersicherungPVEntgelt(Date stichtag) throws BusinessDomainException {
        return this.getCFSIPVEntgelt(stichtag);
    }

    public BigDecimal vortragSozialVersicherungInsGEntgelt(Date stichtag) throws BusinessDomainException {
        return this.getCFSIInsGEntgelt(stichtag);
    }

    public BigDecimal vortragSozialVersicherungAVEntgelt(Date stichtag) throws BusinessDomainException {
        return this.getCFSIAVEntgelt(stichtag);
    }

    public BigDecimal vortragSozialVersicherungSVTage(Date stichtag) throws BusinessDomainException {
        return this.getCFSISVTage(stichtag);
    }

    public boolean vortragSozialVersicherungMKvorhanden(Date stichtag) throws BusinessDomainException {
        boolean result = false;
        EECarriedForwardSystemSI[] vortraege = this.marb().getEECarriedForwardSystemSI();
        int lVorjahr = new VDate(stichtag).getYear() - 1;
        for (EECarriedForwardSystemSI vortrag : vortraege) {
            if (new VDate(vortrag.getValidFrom()).getYear() != lVorjahr) continue;
            result = true;
        }
        return result;
    }

    public BigDecimal vortragSozialVersicherungKVLuft(Date date) {
        if (!this.mKvLuftLoaded) {
            this.mKvLuftLoaded = true;
            EECarriedForwardSystemSI[] vortraege = this.marb().getEECarriedForwardSystemSI();
            int lVorjahr = new VDate(date).getYear() - 1;
            for (EECarriedForwardSystemSI element : vortraege) {
                if (new VDate(element.getValidFrom()).getYear() != lVorjahr) continue;
                this.mKvLuft = this.mKvLuft.add(element.getErAllowanceVHIAir());
            }
        }
        return this.mKvLuft;
    }

    public BigDecimal vortragSozialVersicherungPVLuft(Date date) {
        if (!this.mPvLuftLoaded) {
            this.mPvLuftLoaded = true;
            EECarriedForwardSystemSI[] vortraege = this.marb().getEECarriedForwardSystemSI();
            int lVorjahr = new VDate(date).getYear() - 1;
            for (EECarriedForwardSystemSI element : vortraege) {
                if (new VDate(element.getValidFrom()).getYear() != lVorjahr) continue;
                this.mPvLuft = this.mPvLuft.add(element.getErAllowanceVNIAir());
            }
        }
        return this.mPvLuft;
    }

    public EECarriedForwardVarPayment[] vortragswerteFuerDurchschnitt(Date validfrom, Date validuntil) throws BusinessDomainException {
        return EECarriedForwardVarPayment.getEECarriedForwardVarPayments((Employee)this.mValuePosition.getEmployee(), (Date)validfrom, (Date)validuntil);
    }

    public BigDecimal massgeblicherMonatsverdienst() throws BusinessDomainException {
        if (this.getTax() == null) {
            return BigDecimal.ZERO;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getMonthlyEarnings())) {
            return this.mTax.getMonthlyEarnings();
        }
        return BigDecimal.ZERO;
    }

    public int taxacation() throws BusinessDomainException {
        if (this.getTax() == null) {
            return 0;
        }
        return this.mTax.getTaxacation().value();
    }

    public boolean isDBA(Date validDate) throws BusinessDomainException {
        boolean isDBA = false;
        Tax tax = this.getTax();
        if (tax != null && tax.getCtfcDBAwoutTax()) {
            Date giltBis;
            Date giltAb = tax.getFromDBAwoutTax() != null ? tax.getFromDBAwoutTax() : VDate.getDateMin();
            Date date = giltBis = tax.getUntilDBAwoutTax() != null ? tax.getUntilDBAwoutTax() : VDate.getDateMax();
            if (DateHelper.between((Date)validDate, (Date)giltAb, (Date)giltBis)) {
                isDBA = true;
            }
        }
        return isDBA;
    }

    public boolean ueberwaelzungLstAN() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.mTax.getPayeTax();
    }

    public boolean ueberwaelzungKiStAN() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.mTax.getChurchTax();
    }

    public boolean ueberwaelzungSolZAN() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.mTax.getSolidarityCharge();
    }

    public boolean isMarbKammerBeitragsPflichtig() throws BusinessDomainException {
        boolean result = false;
        if (this.getTax() != null) {
            result = this.mTax.getAssociationEE();
        }
        return result;
    }

    public int stkl() throws BusinessDomainException {
        if (this.getTax() == null) {
            return 0;
        }
        if (this.mKugBerechnung) {
            switch (this.getTax().getDevRedHHBenfGrp().value()) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
            }
        }
        return this.mTax.getTaxBracket();
    }

    public BigDecimal zkf() throws BusinessDomainException {
        if (!this.mLohnsteuerberechnungDBA) {
            if (DateHelper.before((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2008, 0, 1).getDate())) {
                if (!this.mZkfLoaded) {
                    this.mZkfLoaded = true;
                    if (this.getTax() == null) {
                        this.mZkf = BigDecimal.ZERO;
                    } else {
                        this.mZkf = !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getChildRelief()) ? this.mTax.getChildRelief() : BigDecimal.ZERO;
                        if (this.mKugBerechnung) {
                            this.mZkf = BigDecimal.ZERO;
                        }
                    }
                }
            } else if (!this.isPauschaleSteuerErmittlung() && !this.mZkfLoaded) {
                this.mZkfLoaded = true;
                if (this.getTax() == null) {
                    this.mZkf = BigDecimal.ZERO;
                } else {
                    this.mZkf = !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getChildRelief()) ? this.mTax.getChildRelief() : BigDecimal.ZERO;
                    if (this.mKugBerechnung) {
                        this.mZkf = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            this.mZkf = BigDecimal.ZERO;
        }
        return this.mZkf;
    }

    public BigDecimal vbezm() throws BusinessDomainException {
        if (this.getTax() == null) {
            return BigDecimal.ZERO;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getPension())) {
            return this.mTax.getPension().movePointRight(2);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal vbezs() throws BusinessDomainException {
        if (!this.mVBezSLoaded) {
            this.mVBezS = this.getTax() == null ? BigDecimal.ZERO : (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getBonusOfPension()) ? this.mTax.getBonusOfPension().movePointRight(2) : BigDecimal.ZERO);
            this.mVBezSLoaded = true;
        }
        return this.mVBezS;
    }

    public void vbezs(BigDecimal vbezs) {
        this.mVBezS = vbezs;
    }

    public BigDecimal zmvb() throws BusinessDomainException {
        if (!this.mZMVBLoaded) {
            this.mZMVBLoaded = true;
            if (this.lzz() == 1) {
                if (this.getTax().getStartDateOfPension() != null) {
                    if (DateHelper.afterOrEqual((Date)this.getTax().getStartDateOfPension(), (Date)DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom()))) {
                        if (DateHelper.before((Date)this.getTax().getStartDateOfPension(), (Date)DateHelper.getLastDayOfYear((Date)this.mValuePosition.getValidFrom()))) {
                            int i = PDateHelper.getDiffInMonths((Date)DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()), (Date)this.mTax.getStartDateOfPension());
                            this.mZMVB = BigDecimal.valueOf(i);
                        } else {
                            this.mZMVB = BigDecimal.ZERO;
                        }
                    } else {
                        this.mZMVB = ZWOELF;
                    }
                } else {
                    this.mZMVB = BigDecimal.ZERO;
                }
            } else {
                this.mZMVB = BigDecimal.ZERO;
            }
        }
        return this.mZMVB;
    }

    public void zmvb(BigDecimal zmvb) {
        this.mZMVB = zmvb;
    }

    public int af() throws BusinessDomainException {
        int result = 0;
        if (!this.mLohnsteuerberechnungDBA && this.stkl() == 4 && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.getTax().getPercentageSplit())) {
            this.mFaktorF = this.getTax().getPercentageSplit();
            result = 1;
        }
        return result;
    }

    public BigDecimal faktorF() throws BusinessDomainException {
        if (!this.faktorFLoaded) {
            if (!this.mLohnsteuerberechnungDBA) {
                this.faktorFLoaded = true;
                this.mFaktorF = this.getTax() == null ? BigDecimal.ONE : this.getTax().getPercentageSplit();
            } else {
                this.mFaktorF = BigDecimal.ZERO;
            }
        }
        return this.mFaktorF;
    }

    public void faktorF_3NK(BigDecimal faktorF) throws BusinessDomainException {
        if (!this.faktorFLoaded) {
            this.faktorFLoaded = true;
        }
        this.mFaktorF = faktorF;
    }

    public int pkv() throws BusinessDomainException {
        if (!this.pkvLoaded) {
            this.pkvLoaded = true;
            this.mPkv = 0;
            boolean pauschalVersichert = this.marbPauschalVersichert();
            if (this.marbBgrKv() == 0 && this.marbBklFKv() == ContributionScaleVHIEnum.CSE_KEINE && this.marbKvBeitragsErmKVdR() == ChoiseOfDuesHIEnum.CODHIE_KEIN_BEITRAG || pauschalVersichert || this.marbPKv() && this.marbBklFKv() == ContributionScaleVHIEnum.CSE_ERMAESSIGT) {
                this.mPkv = this.marbAGZPKv() == 9 || pauschalVersichert ? 1 : 2;
            }
        }
        return this.mPkv;
    }

    private boolean marbPauschalVersichert() throws BusinessDomainException {
        boolean result = false;
        if (this.marbBgrKv() == 6) {
            switch (this.taxacation()) {
                case 0: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    public BigDecimal pkpv() throws BusinessDomainException {
        if (!this.pkpvLoaded) {
            this.pkpvLoaded = true;
            this.mPkpv = BigDecimalMapper.isZeroOrNull((BigDecimal)this.marbBeitrPKPv()) ? BigDecimal.ZERO : this.marbBeitrPKPv().multiply(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.DOWN);
        }
        return this.mPkpv;
    }

    public int pvz() throws BusinessDomainException {
        if (!this.pvzLoaded) {
            if (this.marbAelterDreiUndZwanzig() && !this.isMarbKindErz()) {
                this.mPvz = 1;
            }
            this.pvzLoaded = true;
        }
        return this.mPvz;
    }

    public FederalState bundeslandKiStWohnort() throws BusinessDomainException {
        if (this.getTax() == null) {
            return null;
        }
        return this.getTax().getFederalState();
    }

    public boolean isMarbKiStWohnort() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.getTax().getChurchTaxDomicile();
    }

    public boolean isKiStErhebung() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.getTax().getChurchTaxDeduction();
    }

    public boolean isMarbLStJA() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        switch (this.getTax().getIncomeTaxReturnYY().value()) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    public boolean isMarbLStJA34EStG() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        switch (this.getTax().getIncomeTaxReturnYY().value()) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean marbVerrgUnterzahlungKiSt() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.getTax().isComputationOfUnderpaymentChurchTax();
    }

    public boolean marbVerrgUnterzahlungLSt() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.getTax().isComputationOfUnderpaymentIncomeTax();
    }

    public boolean marbVerrgUnterzahlungSolZ() throws BusinessDomainException {
        if (this.getTax() == null) {
            return false;
        }
        return this.getTax().isComputationOfUnderpaymentSolidarityCharge();
    }

    public int marbKiStAbz() throws BusinessDomainException {
        int result = 0;
        if (this.getTax() != null && this.getTax().getChurchTaxDeduction()) {
            result = this.getTax().getChurchTaxEE().value();
        }
        return result;
    }

    public int marbKiStAbzEhegatte(int bulaSchl) throws BusinessDomainException {
        int result = 0;
        if (bulaSchl != 9 && bulaSchl != 4 && bulaSchl != 3 && this.getTax() != null && this.stkl() != 1 && this.stkl() != 2 && this.getTax().getChurchTaxDeduction()) {
            result = this.getTax().getChurchTaxSpouse().value();
        }
        return result;
    }

    public int krv() throws BusinessDomainException {
        int result = 0;
        if (this.getTax() != null) {
            switch (this.getTax().getPayeTaxFindings().value()) {
                case 2: {
                    if (this.mKugBerechnung) break;
                    result = 1;
                    break;
                }
                case 3: {
                    if (this.mKugBerechnung) break;
                    result = 2;
                    break;
                }
            }
        }
        return result;
    }

    public int r() throws BusinessDomainException {
        int result = 0;
        if (!this.mLohnsteuerberechnungDBA && this.getTax() != null && (this.getTax().getChurchTaxEE().value() != 0 || this.mKiStLStJA)) {
            result = 1;
        }
        return result;
    }

    private BigDecimal jaehrlHinzurechnungsbetrag() throws BusinessDomainException {
        if (this.getTax() == null) {
            return BigDecimal.ZERO;
        }
        return this.getTax().getAddAmountYY();
    }

    private BigDecimal mtlHinzurechnungsbetrag() throws BusinessDomainException {
        if (this.getTax() == null) {
            return BigDecimal.ZERO;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getAddAmountMM())) {
            return this.mTax.getAddAmountMM();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal jaehrlFreibetrag() throws BusinessDomainException {
        if (this.getTax() == null) {
            return BigDecimal.ZERO;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getFreeAllowanceYY())) {
            return this.mTax.getFreeAllowanceYY();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal mtlFreibetrag() throws BusinessDomainException {
        if (this.getTax() == null) {
            return BigDecimal.ZERO;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getFreeAllowanceMM())) {
            return this.mTax.getFreeAllowanceMM();
        }
        return BigDecimal.ZERO;
    }

    public int lzz() {
        return this.lzz;
    }

    public void lzz(int nlzz) {
        this.lzz = nlzz;
    }

    public boolean isPauschaleSteuerErmittlung() {
        return this.pauschaleSteuerErmittlung;
    }

    public void setPauschaleSteuerErmittlung(boolean bool) {
        this.pauschaleSteuerErmittlung = bool;
    }

    public BigDecimal hinzur() throws BusinessDomainException {
        if (!this.isPauschaleSteuerErmittlung() && !this.mHinzurLoaded) {
            this.mHinzurLoaded = true;
            switch (this.lzz()) {
                case 1: {
                    this.mHinzur = this.jaehrlHinzurechnungsbetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                    break;
                }
                case 2: {
                    this.mHinzur = this.mtlHinzurechnungsbetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                    break;
                }
                case 3: {
                    this.mHinzur = this.mtlHinzurechnungsbetrag().multiply(EINHUNDERT).multiply(SIEBEN).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                    break;
                }
                case 4: {
                    this.mHinzur = this.mtlHinzurechnungsbetrag().multiply(EINHUNDERT).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                    break;
                }
            }
        }
        return this.mHinzur;
    }

    public void hinzur(BigDecimal hinzur) {
        this.mHinzur = hinzur;
    }

    public BigDecimal lzzhinzu() throws BusinessDomainException {
        if (!this.isPauschaleSteuerErmittlung()) {
            switch (this.lzz()) {
                case 1: {
                    return this.jaehrlHinzurechnungsbetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                }
                case 2: {
                    return this.mtlHinzurechnungsbetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                }
                case 3: {
                    return this.mtlHinzurechnungsbetrag().multiply(EINHUNDERT).multiply(SIEBEN).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                }
                case 4: {
                    return this.mtlHinzurechnungsbetrag().multiply(EINHUNDERT).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                }
            }
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal wfundf() throws BusinessDomainException {
        if (!this.mWfundfLoaded) {
            this.mWfundfLoaded = true;
            switch (this.lzz()) {
                case 1: {
                    this.mWfundf = this.jaehrlFreibetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                    break;
                }
                case 2: {
                    this.mWfundf = this.mtlFreibetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                    break;
                }
                case 3: {
                    this.mWfundf = this.mtlFreibetrag().multiply(EINHUNDERT).multiply(SIEBEN).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                    break;
                }
                case 4: {
                    this.mWfundf = this.mtlFreibetrag().multiply(EINHUNDERT).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                    break;
                }
                default: {
                    this.mWfundf = BigDecimal.ZERO;
                }
            }
            if (this.isPauschaleSteuerErmittlung()) {
                this.mWfundf = BigDecimal.ZERO;
            }
        }
        return this.mWfundf;
    }

    public void wfundf(BigDecimal wfundf) {
        this.mWfundf = wfundf;
    }

    public int vjahr() throws BusinessDomainException {
        if (!this.mVJahrLoaded) {
            this.mVJahrLoaded = true;
            this.mVJahr = this.getTax() != null ? (this.getTax().getStartDateOfPension() != null ? new VDate(this.getTax().getStartDateOfPension()).getYear() : 0) : 0;
        }
        return this.mVJahr;
    }

    public int ajahr() throws BusinessDomainException {
        if (!this.mLohnsteuerberechnungDBA) {
            if (!this.mAJahrLoaded) {
                this.mAJahrLoaded = true;
                this.mAJahr = this.getMaster() != null ? (this.getMaster().getDateOfBirth() != null ? new VDate(DateHelper.yesterday((Date)new VDate(this.getMaster().getDateOfBirth()).addYears(64).getDate())).getYear() + 1 : 0) : 0;
            }
        } else {
            this.mAJahr = 0;
        }
        return this.mAJahr;
    }

    public BigDecimal lzzfreib() throws BusinessDomainException {
        if (!this.mLZZFreibLoaded) {
            this.mLZZFreibLoaded = true;
            if (!this.isPauschaleSteuerErmittlung()) {
                switch (this.lzz()) {
                    case 1: {
                        this.mLZZFreib = this.jaehrlFreibetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                        break;
                    }
                    case 2: {
                        this.mLZZFreib = this.mtlFreibetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.HALF_UP);
                        break;
                    }
                    case 3: {
                        this.mLZZFreib = this.mtlFreibetrag().multiply(EINHUNDERT).multiply(SIEBEN).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                        break;
                    }
                    case 4: {
                        this.mLZZFreib = this.mtlFreibetrag().multiply(EINHUNDERT).divide(DREISSIG, 0, RoundingMode.HALF_UP);
                        break;
                    }
                    default: {
                        this.mLZZFreib = BigDecimal.ZERO;
                    }
                }
            }
        }
        return this.mLZZFreib;
    }

    public void lzzfreib(BigDecimal lzzfreib) throws BusinessDomainException {
        this.mLZZFreibLoaded = true;
        this.mLZZFreib = lzzfreib;
    }

    public BigDecimal jfreib() throws BusinessDomainException {
        if (!this.isPauschaleSteuerErmittlung() && !this.mJFreibLoaded) {
            this.mJFreibLoaded = true;
            this.mJFreib = this.jaehrlFreibetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.DOWN);
        }
        return this.mJFreib;
    }

    public void jfreib(BigDecimal jfreib) {
        this.mJFreib = jfreib;
    }

    public BigDecimal jhinzu() throws BusinessDomainException {
        if (!this.isPauschaleSteuerErmittlung() && !this.mJHinzuLoaded) {
            this.mJHinzuLoaded = true;
            this.mJHinzu = this.jaehrlHinzurechnungsbetrag().multiply(EINHUNDERT).setScale(0, RoundingMode.DOWN);
        }
        return this.mJHinzu;
    }

    public void jhinzu(BigDecimal jhinzu) {
        this.mJHinzu = jhinzu;
    }

    public boolean versorgungsFreibetrag() throws BusinessDomainException {
        if (!this.isPauschaleSteuerErmittlung() && this.getTax() != null) {
            return this.getTax().getPensionFreeDues();
        }
        return false;
    }

    public BigDecimal anzurechnendeSteuer() throws BusinessDomainException {
        return this.getTax().getTaxOfSwitzerland();
    }

    public boolean negativeSteuerMoeglich() throws BusinessDomainException {
        if (this.getTax() != null) {
            return this.getTax().isNegativeTaxPossible();
        }
        return false;
    }

    public HealthFund marbUmlagekasse() throws BusinessDomainException {
        HealthFund result = null;
        if (this.getInsurance() != null) {
            result = this.checkKrkFolgeOrganisation(this.mInsurance.getAssessmentHealthFund(), this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
        }
        return result;
    }

    public AssessmentDutyEnum marbUmlagePflichtig() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return AssessmentDutyEnum.ADE_KEINE;
        }
        return this.mInsurance.getAssessmentDuty();
    }

    public boolean abweichendeBAVEinstellung() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.mInsurance.getDifferentPensionschemeSetting();
    }

    public BigDecimal marbProzentsatzRvUnterschiedATZ() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getPercentagePIIncrease();
    }

    public BigDecimal marbProzentsatzMindestNettoATZ() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getPercentageMinNetIncome();
    }

    public Date marbBeginnAtz() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            throw CalculationExceptionMapper.makeBeginnAltersTeilZeitNichtDefiniert();
        }
        if (this.getInsurance().getBeginAgePartTime() != null) {
            return this.getInsurance().getBeginAgePartTime();
        }
        throw CalculationExceptionMapper.makeBeginnAltersTeilZeitNichtDefiniert();
    }

    public boolean isATZTVOeD() throws BusinessDomainException {
        boolean isATZTVOeD;
        block6: {
            isATZTVOeD = false;
            if (this.getInsurance() == null) {
                throw CalculationExceptionMapper.makeBeginnAltersTeilZeitNichtDefiniert();
            }
            AgePartTimeModel aptModel = this.getInsurance().getAgePartTimeModel();
            if (aptModel != null) {
                try {
                    AgePartTimeModelTP aptModelTP = aptModel.getAgePartTimeModelTP(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
                    if (!DateHelper.equal((Date)aptModelTP.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mCalculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)aptModelTP.getValidUntil()), aptModelTP.getClassName());
                    }
                    if (aptModelTP != null) {
                        isATZTVOeD = aptModelTP.getPIincreaseByPayScale();
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block6;
                    throw e;
                }
            }
        }
        return isATZTVOeD;
    }

    public int marbPgs() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 997;
        }
        return this.getInsurance().getPersonGroup();
    }

    public int marbBgrKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupHI();
    }

    public int marbBgrKvAndererAG() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupHIOfOther();
    }

    public int marbBgrRv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupPI();
    }

    public int marbBgrRvAndererAG() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupPIOfOther();
    }

    public int marbBgrRvStoerfall() throws BusinessDomainException {
        int result = 0;
        if (this.marbBgrRv() > 0 && this.marbBgrRv() < 4) {
            result = this.marbBgrRv();
        } else {
            EECarriedForwardSIDistance[] vortraege = this.marb().getEECarriedForwardSIDistance();
            if (vortraege.length == 0) {
                throw EvaluationExceptionMapper.makeNoBGSRVStoerfallDomainException();
            }
            for (EECarriedForwardSIDistance vortrag : vortraege) {
                if (vortrag.getDuesGroupPI() <= result || vortrag.getDuesGroupPI() >= 4) continue;
                result = vortrag.getDuesGroupPI();
            }
        }
        if (result > 0) {
            return result;
        }
        throw EvaluationExceptionMapper.makeNoBGSRVStoerfallDomainException();
    }

    public boolean marbSvFrei() throws BusinessDomainException {
        return this.marbBgrRv() == 0 && this.marbBgrPv() == 0 && this.marbBgrAv() == 0 && this.marbBgrKv() == 0;
    }

    public int marbBgrAv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupUI();
    }

    public int marbBgrAvAndererAG() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupUIOfOther();
    }

    public int marbBgrAvStoerfall() throws BusinessDomainException {
        int result = 0;
        if (this.marbBgrAv() > 0 && this.marbBgrAv() < 4) {
            result = this.marbBgrAv();
        } else {
            EECarriedForwardSIDistance[] vortraege = this.marb().getEECarriedForwardSIDistance();
            if (vortraege.length == 0) {
                throw EvaluationExceptionMapper.makeNoBGSAVStoerfallDomainException();
            }
            for (EECarriedForwardSIDistance vortrag : vortraege) {
                if (vortrag.getDuesGroupUI() <= result || vortrag.getDuesGroupUI() >= 4) continue;
                result = vortrag.getDuesGroupUI();
            }
        }
        if (result > 0) {
            return result;
        }
        throw EvaluationExceptionMapper.makeNoBGSAVStoerfallDomainException();
    }

    public int marbBgrPv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupNI();
    }

    public int marbBgrPvAndererAG() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getDuesGroupNIOfOther();
    }

    public boolean isMarbInsGPflAndererAG() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().isInsGOfOther();
    }

    public ContributionScaleVHIEnum marbBklFKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return ContributionScaleVHIEnum.CSE_KEINE;
        }
        return this.getInsurance().getContScaleVHI();
    }

    public ContributionScalePHIEnum marbBklPKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return ContributionScalePHIEnum.CSPHIE_KEINE;
        }
        return this.getInsurance().getContributionScalePHI();
    }

    public ContributionScaleVNIEnum marbBklFPv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return ContributionScaleVNIEnum.CSVNIE_KEINE;
        }
        return this.getInsurance().getContScaleVNI();
    }

    public int marbAGZFKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getERAllowanceVHI();
    }

    public boolean marbPKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().getPrivateHI();
    }

    public BigDecimal marbBeitrPKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getTotalRateToPHI();
    }

    public int marbAGZPKv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getERAllowancePHI();
    }

    public int marbAGZFPv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getERAllowanceVNI();
    }

    public boolean marbPPVv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().getPrivateNI();
    }

    public BigDecimal marbBeitrPPv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getTotalRateToPNI();
    }

    public int marbAGZPPv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getERAllowancePNI();
    }

    public boolean marbErhBeitrErmKnappschRV() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().isIncreasedDuesMinersPISheme();
    }

    public boolean marbAVBefreiungAG() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().getFreeingOfERDuesUI();
    }

    public boolean isMarbKindErz() throws BusinessDomainException {
        return this.getInsurance().getNIChildEducation();
    }

    public boolean isMarbKindErzKVdR() throws BusinessDomainException {
        return this.getInsurance().getNIChildOfEducKVdR();
    }

    public boolean isKeineLeistungBAVKVdR() throws BusinessDomainException {
        return this.getInsurance().getIsNoPensionForParagraph229();
    }

    public BigDecimal getKVdRFreibetrag() throws BusinessDomainException {
        return this.getInsurance().getFreeAmount();
    }

    public DemandOfFreeAmountEnum getKennzeichenKVdRFreibetrag() throws BusinessDomainException {
        return this.getInsurance().getDemandOfFreeAmount();
    }

    public boolean isMarbGeringverdiener() throws BusinessDomainException {
        return this.getInsurance().getSpecialCategoryOfPersons().value() == 1 || this.getInsurance().getPersonGroup() == 121;
    }

    public boolean isMarbGleitzoneAllgemein() throws BusinessDomainException {
        boolean hatGleitzonenregelung = false;
        if (this.getInsurance() != null) {
            switch (this.getInsurance().getSpecialCategoryOfPersons().value()) {
                case 2: 
                case 3: {
                    if (this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.Bescheinigung || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungOhneFehlzeit || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungKompletterMonat || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungOhneGleitzone || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungOhneGleitzoneUndFZKindkrank || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungOhneGeringverdienerGrenze) {
                        if (this.mCalculationCase.GetCertificateNo() == 103) {
                            hatGleitzonenregelung = true;
                            break;
                        }
                        hatGleitzonenregelung = false;
                        break;
                    }
                    hatGleitzonenregelung = true;
                    break;
                }
                default: {
                    hatGleitzonenregelung = false;
                    break;
                }
            }
        } else {
            hatGleitzonenregelung = false;
        }
        return hatGleitzonenregelung;
    }

    public SpecialCategoryEnum marbGleitzoneregelung() throws BusinessDomainException {
        SpecialCategoryEnum result = SpecialCategoryEnum.SCE_KEINE_BESONDERHEIT;
        if (this.getInsurance() != null) {
            result = this.getInsurance().getSpecialCategoryOfPersons();
        }
        return result;
    }

    public boolean isMarbGleitzoneNurAV() throws BusinessDomainException {
        boolean result = false;
        switch (this.getInsurance().getSpecialCategoryOfPersons().value()) {
            case 3: {
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean kennzBestandGleitzone() throws BusinessDomainException {
        boolean result = false;
        if (DateHelper.before((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate()) && this.getInsurance() != null) {
            result = this.getInsurance().isOldLowWageArea();
        }
        return result;
    }

    public boolean kennzBestandGleitzone2022() throws BusinessDomainException {
        boolean result = false;
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2022, 9, 1).getDate()) && DateHelper.beforeOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2023, 11, 1).getDate()) && this.getInsurance() != null) {
            result = this.getInsurance().getUseTransitionBy31122022();
        }
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2024, 0, 1).getDate()) && this.getInsurance() != null && this.getInsurance().getUseTransitionBy31122022()) {
            throw EvaluationExceptionMapper.makeUseTransitioNotAllowedDomainException();
        }
        return result;
    }

    public boolean marbVerzichtRvReduzierung() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate())) {
            return false;
        }
        return this.getInsurance().getNoExemptionPF();
    }

    public boolean marbBeitragsabsenkungBeiKuG() throws BusinessDomainException {
        boolean result = false;
        if (this.marbBgrKv() == 9) {
            result = this.getInsurance().isDecreaseOfDuesInReducedHours();
        }
        return result;
    }

    public HealthFund marbKrk() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.checkKrkFolgeOrganisation(this.getInsurance().getHealthFund(), this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
        }
        return null;
    }

    public boolean isMarbKrkLKK() throws BusinessDomainException {
        HealthFund hf;
        boolean isLKK = false;
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2019, 0, 1).getDate()) && (hf = this.marbKrk()) != null && hf.getHealthFundTP(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom()).getTypeOfHealthFundEnum() == TypeOfHealthFundEnum.TOHF_LKK) {
            isLKK = true;
        }
        return isLKK;
    }

    public BigDecimal marbKrkAnaBsZusatzbeitrag() throws BusinessDomainException {
        BigDecimal lBeitragssatz = BigDecimal.ZERO;
        HealthFundTP healthFundTP = this.getHealthFundTP();
        if (healthFundTP != null) {
            lBeitragssatz = healthFundTP.getAdditionalDuesEE();
        }
        if (lBeitragssatz == null) {
            lBeitragssatz = BigDecimal.ZERO;
        }
        return lBeitragssatz;
    }

    public BigDecimal marbKrkAgaBsZusatzbeitrag() throws BusinessDomainException {
        BigDecimal lBeitragssatz = BigDecimal.ZERO;
        HealthFundTP healthFundTP = this.getHealthFundTP();
        if (healthFundTP != null) {
            lBeitragssatz = healthFundTP.getAdditionalDuesER();
        }
        if (lBeitragssatz == null) {
            lBeitragssatz = BigDecimal.ZERO;
        }
        return lBeitragssatz;
    }

    private HealthFundTP getHealthFundTP() throws BusinessDomainException {
        block5: {
            if (!this.mHealthFundTPLoaded) {
                this.mHealthFundTPLoaded = true;
                try {
                    HealthFund healthFund = this.marbKrk();
                    if (healthFund != null) {
                        this.mHealthFundTP = healthFund.getHealthFundTP(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
                        if (!DateHelper.equal((Date)this.mHealthFundTP.getValidUntil(), (Date)VDate.getDateMax())) {
                            new CalculationBasic(this.mCalculationCase.getEmployee(), this.mCalculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mHealthFundTP.getValidUntil()), this.mHealthFundTP.getClassName());
                        }
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.mHealthFundTP;
    }

    public BigDecimal marbKrkBsZusatzbeitragKVdR() throws BusinessDomainException {
        BigDecimal lBeitragssatz = BigDecimal.ZERO;
        HealthFund healthFund = this.checkHealthFundBeiKVdRFusion();
        Date validFromKVdR = DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2025, 0, 1).getDate()) ? this.getValidFromKVdR(this.mCalculationCase.getValidFrom()) : (this.mKrKWechselInKVdR ? this.mCalculationCase.getValidFrom() : this.getValidFromKVdR(this.mCalculationCase.getValidFrom()));
        HealthFundTP healthFundTP = healthFund != null ? healthFund.getHealthFundTP(this.mCalculationCase.getEffectiveFrom(), validFromKVdR) : this.getHealthFundTPKVdR(validFromKVdR);
        if (healthFundTP != null) {
            lBeitragssatz = healthFundTP.getAdditionalDues();
        }
        if (lBeitragssatz == null) {
            lBeitragssatz = BigDecimal.ZERO;
        }
        return lBeitragssatz;
    }

    private HealthFund checkHealthFundBeiKVdRFusion() throws BusinessDomainException {
        HealthFund healthFund = null;
        Date validFromAktuell = DateHelper.getFirstDayOfMonth((Date)this.mCalculationCase.getValidFrom());
        HealthFundTP healthFundAktuell = this.getHealthFundTPKVdR(this.mCalculationCase.getEffectiveFrom(), validFromAktuell);
        Date validFromVormonat = DateHelper.addMonths((Date)validFromAktuell, (int)-1);
        HealthFundTP healthFundVormonat = this.getHealthFundTPKVdR(this.mCalculationCase.getEffectiveFrom(), validFromVormonat);
        Date validFromVorvormonat = DateHelper.addMonths((Date)validFromAktuell, (int)-2);
        HealthFundTP healthFundVorvormonat = this.getHealthFundTPKVdR(this.mCalculationCase.getEffectiveFrom(), validFromVorvormonat);
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2021, 0, 1).getDate())) {
            if (healthFundVormonat != null && healthFundVorvormonat != null && !StringMapper.equal((String)healthFundVormonat.getStandardCompanyNumber(), (String)healthFundVorvormonat.getStandardCompanyNumber())) {
                this.mKrKWechselInKVdR = true;
                if (healthFundVorvormonat.getStandardCompanyNumberValidUntil() != null && DateHelper.between((Date)healthFundVorvormonat.getStandardCompanyNumberValidUntil(), (Date)validFromVorvormonat, (Date)DateHelper.getLastDayOfMonth((Date)validFromVorvormonat)) && StringMapper.equal((String)healthFundVorvormonat.getStandardCompanyNumberSuccessor(), (String)healthFundVormonat.getStandardCompanyNumber())) {
                    this.mKrKWechselInKVdR = false;
                    if (healthFundVormonat.getAdditionalDuesValidFrom() != null && DateHelper.between((Date)healthFundVormonat.getAdditionalDuesValidFrom(), (Date)validFromVormonat, (Date)DateHelper.getLastDayOfMonth((Date)validFromVormonat))) {
                        healthFund = healthFundVorvormonat.getHealthFund();
                    }
                }
            } else if (healthFundAktuell != null && healthFundVormonat != null && !StringMapper.equal((String)healthFundAktuell.getStandardCompanyNumber(), (String)healthFundVormonat.getStandardCompanyNumber())) {
                this.mKrKWechselInKVdR = true;
                if (healthFundVormonat.getStandardCompanyNumberValidUntil() != null && DateHelper.between((Date)healthFundVormonat.getStandardCompanyNumberValidUntil(), (Date)validFromVormonat, (Date)DateHelper.getLastDayOfMonth((Date)validFromVormonat)) && StringMapper.equal((String)healthFundVormonat.getStandardCompanyNumberSuccessor(), (String)healthFundAktuell.getStandardCompanyNumber())) {
                    if (healthFundAktuell.getAdditionalDuesValidFrom() != null && DateHelper.between((Date)healthFundAktuell.getAdditionalDuesValidFrom(), (Date)validFromAktuell, (Date)DateHelper.getLastDayOfMonth((Date)validFromAktuell))) {
                        healthFund = healthFundVormonat.getHealthFund();
                    }
                    this.mKrKWechselInKVdR = false;
                }
            }
        }
        if (healthFund == null && healthFundAktuell != null) {
            healthFund = healthFundAktuell.getHealthFund();
        }
        return healthFund;
    }

    private HealthFundTP getHealthFundTPKVdR(Date effectiveDate, Date validDate) throws BusinessDomainException {
        HealthFund healthFund;
        HealthFundTP healthFundTP = null;
        Insurance insurance = this.getInsurance(effectiveDate, validDate);
        if (insurance != null && (healthFund = insurance.getHealthFundKVdR()) != null) {
            healthFund = this.checkKrkFolgeOrganisation(healthFund, effectiveDate, validDate);
            healthFundTP = healthFund.getHealthFundTP(effectiveDate, validDate);
        }
        return healthFundTP;
    }

    private HealthFundTP getHealthFundTPKVdR(Date ValidDate) throws BusinessDomainException {
        block5: {
            if (!this.mHealthFundTPKVdRLoaded) {
                this.mHealthFundTPKVdRLoaded = true;
                try {
                    HealthFund healthFund = this.marbKrkKVdR();
                    if (healthFund != null) {
                        this.mHealthFundTPKVdR = healthFund.getHealthFundTP(this.mCalculationCase.getEffectiveFrom(), ValidDate);
                        if (!DateHelper.equal((Date)this.mHealthFundTPKVdR.getValidUntil(), (Date)VDate.getDateMax())) {
                            new CalculationBasic(this.mCalculationCase.getEmployee(), this.mCalculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mHealthFundTPKVdR.getValidUntil()), this.mHealthFundTPKVdR.getClassName());
                        }
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.mHealthFundTPKVdR;
    }

    public final HealthFund checkKrkFolgeOrganisation(HealthFund healthFund, Date effectivefrom, Date validfrom) throws BusinessDomainException {
        HealthFund currentHealthFund = healthFund;
        if (currentHealthFund != null) {
            currentHealthFund = HealthFund.getHealthFundConsiderFusions((HealthFund)currentHealthFund, (Date)validfrom);
            AssignmentPCompanyHealthFund[] assignment = AssignmentPCompanyHealthFund.getAssignmentPCompanyHealthFund((PCompany)this.marbFirma(), (HealthFund)currentHealthFund);
            if (assignment.length == 0) {
                HealthFundTP hftp = currentHealthFund.getHealthFundTP(effectivefrom, validfrom);
                throw EvaluationExceptionMapper.noAssignmentForFollowInstitutionDomainException(hftp, validfrom);
            }
        }
        return currentHealthFund;
    }

    public HealthFund marbKrkKVdR() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.checkKrkFolgeOrganisation(this.getInsurance().getHealthFundKVdR(), this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
        }
        return null;
    }

    public ChoiseOfDuesHIEnum marbKvBeitragsErmKVdR() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.getInsurance().getChoiseOfDuesHI();
        }
        return ChoiseOfDuesHIEnum.CODHIE_KEIN_BEITRAG;
    }

    public ChoiseOfDuesNIEnum marbPvBeitragsErmKVdR() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.getInsurance().getChoiseOfDuesNI();
        }
        return ChoiseOfDuesNIEnum.CODNIE_KEIN_BEITRAG;
    }

    public BigDecimal marbKvBeitragKVdR() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.getInsurance().getDuesHI();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal marbPvBeitragKVdR() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.getInsurance().getDuesHI();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal marbVBMAX() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.getInsurance().getLimitOfDues();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal marbGesetzlicheRente() throws BusinessDomainException {
        if (this.getInsurance() != null) {
            return this.getInsurance().getLegalPension();
        }
        return BigDecimal.ZERO;
    }

    public MultiplyEmploymentEnum marbMehrfachBeschaeftigung() throws BusinessDomainException {
        MultiplyEmploymentEnum result = MultiplyEmploymentEnum.MEE_KEINE;
        if (this.getInsurance() != null) {
            result = this.getInsurance().getMultiplyEmployment();
        }
        return result;
    }

    public boolean isMehrfachbeschaeftigt() throws BusinessDomainException {
        MultiplyEmploymentEnum multiplyEmployment;
        boolean mehrfachbeschaeftigt = false;
        if (this.getInsurance() != null && ((multiplyEmployment = this.getInsurance().getMultiplyEmployment()) == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG || multiplyEmployment == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS || multiplyEmployment == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV || multiplyEmployment == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS_OHNE_BV)) {
            mehrfachbeschaeftigt = true;
        }
        return mehrfachbeschaeftigt;
    }

    public int marbRentenart() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getTypeOfPension();
    }

    public ModeOfPensionEnum marbVersorgungsart() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return ModeOfPensionEnum.MOPE_KEINE;
        }
        return this.getInsurance().getModeOfPension();
    }

    public ModeOfCalculationEnum marbBerechnungsArtBefreiendeLV() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return ModeOfCalculationEnum.MOCE_TATSAECHLICHES_ENTGELT;
        }
        return this.getInsurance().getModeOfCalculation();
    }

    public BigDecimal marbGesamtbeitragBefreiendeLV() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.getInsurance().getTotalDues())) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getTotalDues();
    }

    public BigDecimal marbAGZBefrLV() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.getInsurance().getEmployersAllowance())) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getEmployersAllowance();
    }

    public RemittanceEnum marbZahlungsArtBefreiendeLV() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return RemittanceEnum.RE_AUSZAHLUNG_AN_MITARBEITER;
        }
        return this.getInsurance().getRemittance();
    }

    public SpecialCategoryEnum marbBesonderesSvMerkmal() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return SpecialCategoryEnum.SCE_KEINE_BESONDERHEIT;
        }
        return this.getInsurance().getSpecialCategoryOfPersons();
    }

    public Date marbAustritt() throws BusinessDomainException {
        Date marbAustritt = this.getEmployment().getDateOfWithDrawal();
        if (marbAustritt != null) {
            return this.mCalculationCase.getTypeOfCalculationCase() != TypeOfCalculationCase.BescheinigungKompletterMonat ? this.getEmployment().getDateOfWithDrawal() : DateHelper.getLastDayOfMonth((Date)this.getEmployment().getDateOfWithDrawal());
        }
        return null;
    }

    public Date marbEintritt() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2008, 0, 1).getDate())) {
            return this.mCalculationCase.getTypeOfCalculationCase() != TypeOfCalculationCase.BescheinigungKompletterMonat ? this.getEmployment().getDateOfEntry() : DateHelper.getFirstDayOfMonth((Date)this.getEmployment().getDateOfEntry());
        }
        return this.mCalculationCase.getTypeOfCalculationCase() != TypeOfCalculationCase.BescheinigungKompletterMonat ? this.getEmployment().getDateOfEntrySI() : DateHelper.getFirstDayOfMonth((Date)this.getEmployment().getDateOfEntrySI());
    }

    public Plant marbBetriebsstaette() throws BusinessDomainException {
        if (this.getEmployment() != null) {
            if (this.getEmployment().getPlant() != null) {
                return this.getEmployment().getPlant();
            }
            return null;
        }
        return null;
    }

    public BigDecimal marbLohnfaktor(WageFactor lohnfaktor) throws BusinessDomainException {
        BigDecimal result;
        block4: {
            result = BigDecimal.ZERO;
            try {
                EEWageFactorTP ewftp = this.marb().getEEWageFactorTP(lohnfaktor, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                if (ewftp != null) {
                    result = ewftp.getDues();
                    EEWageFactorTP next = (EEWageFactorTP)ewftp.getEEWageFactor().getHistory().getItemOrNull(this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)ewftp.getValidUntil()));
                    if (next != null) {
                        new CalculationBasic(this.marb(), this.mValuePosition.getEffectiveFrom(), next.getValidFrom(), next.getClassName());
                    }
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                throw e;
            }
        }
        return result;
    }

    public ScalePaymentTP[] marbTarifdaten() throws BusinessDomainException {
        if (!this.marbTarifdatenLoaded) {
            this.marbTarifdaten = ScalePaymentTP.getScalePaymentTP((Employee)this.mCalculationCase.getEmployee(), (Date)this.mCalculationCase.getEffectiveFrom(), (Date)this.mCalculationCase.getValidFrom());
            this.marbTarifdatenLoaded = true;
        }
        return this.marbTarifdaten;
    }

    public EEWork marbArbeitsangaben() throws BusinessDomainException {
        return this.getEEWork(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
    }

    public boolean isMarbVierundfuenfzigBeiERAStart(Date eraStart, int anzMonateBetriebszugeh\u00f6rigkeit) throws BusinessDomainException {
        Date vierundfuenfzigsterGeburtstag;
        Date vergleichsdateum;
        boolean result = false;
        if (this.getMaster() != null && DateHelper.afterOrEqual((Date)(vergleichsdateum = DateHelper.getLastDayOfMonth((Date)eraStart)), (Date)(vierundfuenfzigsterGeburtstag = new VDate(this.getMaster().getDateOfBirth()).addYears(54).getDate())) && DateHelper.beforeOrEqual((Date)this.marbEintritt(), (Date)new VDate(eraStart).addMonths(anzMonateBetriebszugeh\u00f6rigkeit * -1).getDate())) {
            result = true;
        }
        return result;
    }

    public boolean marbAelterDreiUndZwanzig() throws BusinessDomainException {
        Date dreiundzwanzigsterGeburtstag;
        if (this.getMaster() == null) {
            return true;
        }
        Date berechnungsStart = DateHelper.getFirstDayOfMonth((Date)this.mCalculationCase.getValidFrom());
        if (DateHelper.afterOrEqual((Date)berechnungsStart, (Date)(dreiundzwanzigsterGeburtstag = new VDate(this.getMaster().getDateOfBirth()).addYears(23).getDate()))) {
            return true;
        }
        Date berechneAb = null;
        berechneAb = !DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)dreiundzwanzigsterGeburtstag), (Date)dreiundzwanzigsterGeburtstag) ? DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)dreiundzwanzigsterGeburtstag)) : dreiundzwanzigsterGeburtstag;
        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mCalculationCase.getEffectiveFrom(), berechneAb, this.getClass().getName());
        return false;
    }

    public boolean isMarbAltersRentner() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        Date berechnungsStart = DateHelper.getFirstDayOfMonth((Date)this.mCalculationCase.getValidFrom());
        Date renteneintritt = new VDate(this.marbGeburtstag()).addYears(65).getDate();
        int geburtsjahr = new VDate(this.marbGeburtstag()).getYear();
        if (geburtsjahr > 1963) {
            renteneintritt = new VDate(renteneintritt).addMonths(24).getDate();
        } else if (geburtsjahr > 1958) {
            renteneintritt = new VDate(renteneintritt).addMonths(12 + (geburtsjahr - 1958) * 2).getDate();
        } else if (geburtsjahr > 1946) {
            renteneintritt = new VDate(renteneintritt).addMonths(geburtsjahr - 1946).getDate();
        }
        if (DateHelper.afterOrEqual((Date)berechnungsStart, (Date)renteneintritt)) {
            return true;
        }
        Date berechneAb = !DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)renteneintritt), (Date)renteneintritt) ? DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)renteneintritt)) : renteneintritt;
        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mCalculationCase.getEffectiveFrom(), berechneAb, this.getClass().getName());
        return false;
    }

    public Date marbGeburtstag() throws BusinessDomainException {
        if (this.getMaster() == null) {
            return VDate.getDateMax();
        }
        return this.getMaster().getDateOfBirth();
    }

    private Master getMaster() throws BusinessDomainException {
        if (!this.mMasterLoaded) {
            block4: {
                try {
                    this.mMaster = this.mCalculationCase.getEmployee().getMaster(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mMaster.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mMaster.getValidUntil()), this.mMaster.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mMasterLoaded = true;
        }
        return this.mMaster;
    }

    private Tax getTax() throws BusinessDomainException {
        if (!this.mTaxLoaded) {
            block4: {
                try {
                    this.mTax = this.mCalculationCase.getEmployee().getTax(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mTax.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mTax.getValidUntil()), this.mTax.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mTaxLoaded = true;
        }
        return this.mTax;
    }

    public Insurance marbVersicherungsdaten() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return null;
        }
        return this.mInsurance;
    }

    private Insurance getInsurance() throws BusinessDomainException {
        if (!this.mInsuranceLoaded) {
            this.mInsurance = this.getInsurance(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
            if (!DateHelper.equal((Date)this.mInsurance.getValidUntil(), (Date)VDate.getDateMax())) {
                new CalculationBasic(this.mCalculationCase.getEmployee(), this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mInsurance.getValidUntil()), this.mInsurance.getClassName());
            }
            this.mInsuranceLoaded = true;
        }
        return this.mInsurance;
    }

    private Employment getEmployment() throws BusinessDomainException {
        if (!this.mEmploymentLoaded) {
            block4: {
                try {
                    this.mEmployment = this.mCalculationCase.getEmployee().getEmployment(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
                    if (!DateHelper.equal((Date)this.mEmployment.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mEmployment.getValidUntil()), this.mEmployment.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mEmploymentLoaded = true;
        }
        return this.mEmployment;
    }

    public CostCenter marbStammKostenstelle() throws BusinessDomainException {
        return this.getEmployment().getCostCenter();
    }

    public CostUnit marbStammKostentraeger() throws BusinessDomainException {
        return this.getEmployment().getCostUnit();
    }

    public Designation marbAbteilung() throws BusinessDomainException {
        return this.getEmployment().getDepartment();
    }

    protected Date getCFEntryValidUntil(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        Date result = VDate.getDateMax();
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom()))) continue;
            if (DateHelper.equal((Date)result, (Date)VDate.getDateMax())) {
                result = entry.getEmploymentUntil();
                continue;
            }
            if (!DateHelper.after((Date)entry.getEmploymentUntil(), (Date)result)) continue;
            result = entry.getEmploymentFrom();
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected Date getCFEntryValidFrom(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        Date result = VDate.getDateMax();
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || !DateHelper.before((Date)entry.getEmploymentFrom(), (Date)result)) continue;
            result = entry.getEmploymentFrom();
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryBruttoArbeitslohn(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getGrossPay())) continue;
            result = result.add(entry.getGrossPay());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryErmBruttoArbeitslohn(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom()))) continue;
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getTaxPrivilegedPensionsDiverseYears())) {
                result = result.add(entry.getTaxPrivilegedPensionsDiverseYears());
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getReducedTaxedPayDiverseYears())) continue;
            result = result.add(entry.getReducedTaxedPayDiverseYears());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryLohnsteuer(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getIncomeTax())) continue;
            result = result.add(entry.getIncomeTax());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryErmLohnsteuer(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getIncomeTaxDiverseYears())) continue;
            result = result.add(entry.getIncomeTaxDiverseYears());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntrySolZ(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getSolidarityCharge())) continue;
            result = result.add(entry.getSolidarityCharge());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryErmSolZ(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getSolidarityChargeDiverseYears())) continue;
            result = result.add(entry.getSolidarityChargeDiverseYears());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryKirchensteuer(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getChurchTaxEE())) continue;
            result = result.add(entry.getChurchTaxEE());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    private ChurchTaxEnum getCFEntryKiStErhebung(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        ChurchTaxEnum result = ChurchTaxEnum.CTE_KEIN_EINTRAG;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getChurchTaxEE())) continue;
            result = entry.getTypeOfChurchTaxEmployee();
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryErmKirchensteuer(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getChurchTaxEEDiverseYears())) continue;
            result = result.add(entry.getChurchTaxEEDiverseYears());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryKirchensteuerEhegatte(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getChurchTaxSpouse())) continue;
            result = result.add(entry.getChurchTaxSpouse());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected BigDecimal getCFEntryErmKirchensteuerEhegatte(Date stichtag) throws BusinessDomainException {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        boolean vortragswerteGefunden = false;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            vortragswerteGefunden = true;
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getChurchTaxSpouse())) continue;
            result = result.add(entry.getChurchTaxSpouse());
        }
        if (!vortragswerteGefunden) {
            throw EvaluationExceptionMapper.makeNoCFGrossWageDomainException();
        }
        return result;
    }

    protected boolean getCFAusschlussDurchVorAGLSTJA(Date stichtag) {
        EECarriedForwardOfEntry[] entrys;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom())) || !entry.getExclusionAnnualIncomeTaxReturn()) continue;
            return entry.getExclusionAnnualIncomeTaxReturn();
        }
        return false;
    }

    protected BigDecimal getCFEntrySteuerbeguenstigterVersorgungsbezuege(Date stichtag) {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom()))) continue;
            result = result.add(entry.getTaxPrivilegedPensionsOfOneYear());
        }
        return result;
    }

    protected BigDecimal getCFEntrySteuerbeguenstigterVersorgungsbezuegeMKJ(Date stichtag) {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom()))) continue;
            result = result.add(entry.getTaxPrivilegedPensionsDiverseYears());
        }
        return result;
    }

    protected BigDecimal getCFEntrySteuerbeguenstigterArbeitslohnMKJ(Date stichtag) {
        EECarriedForwardOfEntry[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardOfEntry entry : entrys = this.mCalculationCase.getEmployee().getEECarriedForwardOfEntry()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getEmploymentFrom()))) continue;
            result = result.add(entry.getReducedTaxedPayDiverseYears());
        }
        return result;
    }

    protected BigDecimal getCFSIKVTage(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(BigDecimal.valueOf(mSystemSI.getNumberOfHIDays()));
        }
        return result;
    }

    protected BigDecimal getCFSIKVEntgelt(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(mSystemSI.getHIPayment());
        }
        return result;
    }

    protected BigDecimal getCFSIRVTage(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(BigDecimal.valueOf(mSystemSI.getNumberOfPIDays()));
        }
        return result;
    }

    protected BigDecimal getCFSIRVEntgelt(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(mSystemSI.getPIPayment());
        }
        return result;
    }

    protected BigDecimal getCFSIPVTage(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(BigDecimal.valueOf(mSystemSI.getNumberOfNIDays()));
        }
        return result;
    }

    protected BigDecimal getCFSIPVEntgelt(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(mSystemSI.getNIPayment());
        }
        return result;
    }

    private BigDecimal getCFSIInsGEntgelt(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(mSystemSI.getInsGPayment());
        }
        return result;
    }

    protected BigDecimal getCFSIAVTage(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(BigDecimal.valueOf(mSystemSI.getNumberOfUIDays()));
        }
        return result;
    }

    protected BigDecimal getCFSIAVEntgelt(Date stichtag) {
        EECarriedForwardSystemSI[] mSystemSIs;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSystemSI mSystemSI : mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI()) {
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSI.getValidFrom()))) continue;
            result = result.add(mSystemSI.getUIPayment());
        }
        return result;
    }

    protected BigDecimal getCFSISVTage(Date stichtag) {
        BigDecimal result = BigDecimal.ZERO;
        EECarriedForwardSystemSI[] mSystemSIs = this.mCalculationCase.getEmployee().getEECarriedForwardSystemSI();
        for (int i = 0; i < mSystemSIs.length; ++i) {
            BigDecimal vortragsSVTage = !BigDecimalMapper.isZero((BigDecimal)BigDecimal.valueOf(mSystemSIs[i].getNumberOfPIDays())) ? BigDecimal.valueOf(mSystemSIs[i].getNumberOfPIDays()) : (!BigDecimalMapper.isZero((BigDecimal)BigDecimal.valueOf(mSystemSIs[i].getNumberOfUIDays())) ? BigDecimal.valueOf(mSystemSIs[i].getNumberOfUIDays()) : (!BigDecimalMapper.isZero((BigDecimal)BigDecimal.valueOf(mSystemSIs[i].getNumberOfHIDays())) ? BigDecimal.valueOf(mSystemSIs[i].getNumberOfHIDays()) : BigDecimal.valueOf(mSystemSIs[i].getNumberOfNIDays())));
            if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)mSystemSIs[i].getValidFrom()))) continue;
            result = result.add(vortragsSVTage);
        }
        return result;
    }

    protected EEWork getEEWorkVM(Date wirksamAb, Date gueltigAb) throws BusinessDomainException {
        if (!this.mEEWorkVMLoaded) {
            block4: {
                try {
                    this.mEEWorkVM = this.mCalculationCase.getEmployee().getEEWork(wirksamAb, gueltigAb);
                    if (!DateHelper.equal((Date)this.mEEWorkVM.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), wirksamAb, DateHelper.tomorrow((Date)this.mEEWorkVM.getValidUntil()), this.mEEWorkVM.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mEEWorkVMLoaded = true;
        }
        return this.mEEWorkVM;
    }

    protected EEWork getEEWork(Date wirksamAb, Date gueltigAb) throws BusinessDomainException {
        if (!this.mEEWorkLoaded) {
            block4: {
                try {
                    this.mEEWork = this.mCalculationCase.getEmployee().getEEWork(wirksamAb, gueltigAb);
                    if (!DateHelper.equal((Date)this.mEEWork.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), wirksamAb, DateHelper.tomorrow((Date)this.mEEWork.getValidUntil()), this.mEEWork.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mEEWorkLoaded = true;
        }
        return this.mEEWork;
    }

    public boolean marbBAVGruppenversicherung() throws BusinessDomainException {
        try {
            return ((EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects()).getGroupInsurance();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public boolean marbBAVPauschalbesteuerung() throws BusinessDomainException {
        try {
            return ((EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects()).getLumpSumTaxacation();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public Date marbBAVEintritt() throws BusinessDomainException {
        try {
            return ((EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects()).getDateOfEntry();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public int marbBAVJahrVortrag() throws BusinessDomainException {
        try {
            return ((EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects()).getCarriedForwardYear();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public BigDecimal marbBAVWertVortrag() throws BusinessDomainException {
        try {
            return ((EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects()).getCarriedForwardSIPaymentNew();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public ContractTypeEnum marbArtDesBAVVertrages() throws BusinessDomainException {
        try {
            return ((EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects()).getContractType();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public EEPensionSchemeTP marbBAVVertrag() throws BusinessDomainException {
        try {
            return (EEPensionSchemeTP)((ValuePosition)this.mValuePosition.getGenesisOfParentObjects()).getGenesisOfParentObjects();
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
        }
    }

    public boolean isTeilLZZVorhanden() throws BusinessDomainException {
        boolean result = false;
        if (this.mCalculationCase.getTypeOfCalculationCase() != TypeOfCalculationCase.BescheinigungKompletterMonat) {
            EEAbsentTimeTP[] fehlzeitenImMonat;
            if (DateHelper.between((Date)this.marbEintritt(), (Date)DateHelper.tomorrow((Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom())), (Date)DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
                result = true;
            }
            if (this.marbAustritt() != null && DateHelper.between((Date)this.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()), (Date)DateHelper.yesterday((Date)DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom())))) {
                result = true;
            }
            for (EEAbsentTimeTP element : fehlzeitenImMonat = this.aktuelleFehlzeiten()) {
                if (!element.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getCutByPartTimePayPeriod()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public EEAttachmentTP[] pfaendungenImMonat() throws BusinessDomainException {
        EEAttachmentTP[] attachments = this.mValuePosition.getEmployee().getEEAttachmentsTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mValuePosition.getEmployee().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mValuePosition.getEffectiveFrom())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mValuePosition.getEffectiveFrom())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom())))}), true);
        return attachments;
    }

    public EvaluationTargetOfPaymentEnum marbSollermittlungKug() throws BusinessDomainException {
        return this.getTax().getEvaluationTargetOfPayment();
    }

    public void inKugberechnung() {
        this.mKugBerechnung = true;
    }

    public DevRedHHBenfRateEnum abwLeistungsSatzKug() throws BusinessDomainException {
        if (this.getTax() == null) {
            return DevRedHHBenfRateEnum.DRHBRE_KEINE_ABWEICHNUNG_VON_ZKF;
        }
        return this.getTax().getDevRedHHBenfRate();
    }

    public Employee marb() {
        return this.mValuePosition.getEmployee();
    }

    public boolean isMarbAtzNeuvertrag() throws BusinessDomainException {
        return !DateHelper.before((Date)this.getInsurance().getBeginAgePartTime(), (Date)new VDate(2004, 6, 1).getDate());
    }

    public boolean isMarbAtzVertraglich() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().getUseAgePartTime();
    }

    public boolean isMarbAtzWiederbesetzerVorhanden() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return false;
        }
        return this.getInsurance().getPersonnelnumberReplacer() != 0;
    }

    public TypeAgePartTimeEnum marbAtzModellArt() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return TypeAgePartTimeEnum.TOAPTE_TEILZEIT;
        }
        return this.getInsurance().getTypeAgePartTime();
    }

    public Date marbAtzFreistellungAb() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return VDate.getDateMax();
        }
        return this.getInsurance().getBeginWorkExemption();
    }

    public EEDataERA marbEraDaten() throws BusinessDomainException {
        if (!this.mEEDataERALoaded) {
            block4: {
                try {
                    this.mEEDataERA = this.mCalculationCase.getEmployee().getEEDataERA(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mEEDataERA.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mEEDataERA.getValidUntil()), this.mEEDataERA.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mEEDataERALoaded = true;
        }
        return this.mEEDataERA;
    }

    public BigDecimal marbVHSatzTeilzeit() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        EEWork arbAngaben = this.marbArbeitsangaben();
        if (arbAngaben != null) {
            result = BigDecimalMapper.isZeroOrNull((BigDecimal)arbAngaben.getPercentageOfPartTimeWork()) ? BigDecimal.ZERO : arbAngaben.getPercentageOfPartTimeWork();
        }
        return result;
    }

    public Truncation marbRundungTeilzeit() throws BusinessDomainException {
        Truncation result = new Truncation(TruncationEnum.BTE_commercializeRounding, TruncationScaleEnum.BTSE_2_ADP);
        EEWork arbAngaben = this.marbArbeitsangaben();
        if (arbAngaben != null) {
            result = arbAngaben.getTruncationPartTimeWork();
        }
        return result;
    }

    public EEDataCreditTP marbWertguthaben(TypeOfCreditEnum wghArt) throws BusinessDomainException {
        EEDataCreditTP[] konten;
        EEDataCreditTP result = null;
        for (EEDataCreditTP dataCreditTP : konten = this.marb().getEEDataCredits(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom())) {
            if (dataCreditTP.getEEDataCredit().getCreditModel().getTypeOfCredit().value() != wghArt.value()) continue;
            result = dataCreditTP;
            break;
        }
        return result;
    }

    public EEDataCreditTP marbWertguthaben(CreditModel cModel) throws BusinessDomainException {
        EEDataCreditTP[] konten;
        EEDataCreditTP result = null;
        for (EEDataCreditTP dataCreditTP : konten = this.marb().getEEDataCredits(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom())) {
            if (!dataCreditTP.getEEDataCredit().getCreditModel().equals((Object)cModel)) continue;
            result = dataCreditTP;
            break;
        }
        return result;
    }

    public BigDecimal marbVortragPVLuftAktJahr() {
        BigDecimal result = BigDecimal.ZERO;
        if (!DateHelper.equal((Date)this.mCalculationCase.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()))) {
            EECarriedForwardSIDistance[] vortraege;
            for (EECarriedForwardSIDistance cfsid : vortraege = this.marb().getEECarriedForwardSIDistance()) {
                if (!DateHelper.between((Date)cfsid.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()), (Date)DateHelper.yesterday((Date)this.mCalculationCase.getValidFrom()))) continue;
                result = result.add(cfsid.getNIPaymentWest());
                result = result.add(cfsid.getNIPaymentEast());
            }
        }
        return result;
    }

    public BigDecimal marbVortragPVLuftWest() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getNIPaymentWest());
        }
        return result;
    }

    public BigDecimal marbVortragPVLuftOst() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getNIPaymentEast());
        }
        return result;
    }

    public BigDecimal marbVortragAVLuftAktJahr() {
        BigDecimal result = BigDecimal.ZERO;
        if (!DateHelper.equal((Date)this.mCalculationCase.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()))) {
            EECarriedForwardSIDistance[] vortraege;
            for (EECarriedForwardSIDistance cfsid : vortraege = this.marb().getEECarriedForwardSIDistance()) {
                if (!DateHelper.between((Date)cfsid.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()), (Date)DateHelper.yesterday((Date)this.mCalculationCase.getValidFrom()))) continue;
                result = result.add(cfsid.getUIPaymentWest());
                result = result.add(cfsid.getUIPaymentEast());
            }
        }
        return result;
    }

    public BigDecimal marbVortragAVLuftWest() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getUIPaymentWest());
        }
        return result;
    }

    public BigDecimal marbVortragAVLuftOst() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getUIPaymentEast());
        }
        return result;
    }

    public BigDecimal marbVortragRVLuftAktJahr() {
        BigDecimal result = BigDecimal.ZERO;
        if (!DateHelper.equal((Date)this.mCalculationCase.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()))) {
            EECarriedForwardSIDistance[] vortraege;
            for (EECarriedForwardSIDistance cfsid : vortraege = this.marb().getEECarriedForwardSIDistance()) {
                if (!DateHelper.between((Date)cfsid.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()), (Date)DateHelper.yesterday((Date)this.mCalculationCase.getValidFrom()))) continue;
                result = result.add(cfsid.getPIPaymentWest());
                result = result.add(cfsid.getPIPaymentEast());
            }
        }
        return result;
    }

    public BigDecimal marbVortragRVLuftWest() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getPIPaymentWest());
        }
        return result;
    }

    public BigDecimal marbVortragRVLuftOst() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getPIPaymentEast());
        }
        return result;
    }

    public BigDecimal marbVortragKVLuftAktJahr() {
        BigDecimal result = BigDecimal.ZERO;
        if (!DateHelper.equal((Date)this.mCalculationCase.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()))) {
            EECarriedForwardSIDistance[] vortraege;
            for (EECarriedForwardSIDistance cfsid : vortraege = this.marb().getEECarriedForwardSIDistance()) {
                if (!DateHelper.between((Date)cfsid.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()), (Date)DateHelper.yesterday((Date)this.mCalculationCase.getValidFrom()))) continue;
                result = result.add(cfsid.getHIPaymentWest());
                result = result.add(cfsid.getHIPaymentEast());
            }
        }
        return result;
    }

    public BigDecimal marbVortragKVLuftWest() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getHIPaymentWest());
        }
        return result;
    }

    public BigDecimal marbVortragKVLuftOst() {
        EECarriedForwardSIDistance[] vortraege;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardSIDistance cFSID : vortraege = this.marb().getEECarriedForwardSIDistance()) {
            result = result.add(cFSID.getHIPaymentEast());
        }
        return result;
    }

    public int mbs() throws BusinessDomainException {
        int result = 0;
        if (this.getTax() != null) {
            switch (this.getTax().getTaxacation().value()) {
                case 2: {
                    break;
                }
                default: {
                    if (this.mKugBerechnung) break;
                    result = 1;
                }
            }
        }
        return result;
    }

    public boolean isMarbInsGPflichtig() throws BusinessDomainException {
        if (!this.mInsGPflichtig && !this.mInsGPflichtigLoaded) {
            this.mInsGPflichtigLoaded = true;
            if (this.getInsurance() != null) {
                this.mInsGPflichtig = this.getInsurance().getInsolvencyDuty();
            }
        }
        return this.mInsGPflichtig;
    }

    public ZvkTypeOfCalcAddContEnum zvkBerechnungZusatzbeitrag() throws BusinessDomainException {
        ZvkTypeOfCalcAddContEnum result = ZvkTypeOfCalcAddContEnum.ZTOCACE_keineBerechnung;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().getTypeOfCalcAddCont();
        }
        return result;
    }

    public CalcOfAddContEnum zvkBerechnungZusatzbeitragUeberFreigrenze() throws BusinessDomainException {
        CalcOfAddContEnum result = CalcOfAddContEnum.COACE_KEINE;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().getCalculationOfAddCont();
        }
        return result;
    }

    public boolean isZVKZusatzbeitragAN3Nr63EStG() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().isAddAmountEE3No63EStG();
        }
        return result;
    }

    public AdvancementTypeEnum getEinrechnungFoerderbetrag100EStG() throws BusinessDomainException {
        AdvancementTypeEnum einrechnung = AdvancementTypeEnum.NEIN;
        if (this.getEEZvk() != null) {
            einrechnung = this.getEEZvk().getAdvancementTypeAsCtPays();
        }
        return einrechnung;
    }

    public BigDecimal getVergleichswertAGZusatzbeitrag() throws BusinessDomainException {
        BigDecimal vergleichswert = BigDecimal.ZERO;
        if (this.getEEZvk() != null) {
            vergleichswert = this.getEEZvk().getMonthCompValueErAddCont();
        }
        return vergleichswert;
    }

    private EECarriedForwardZVK[] getEECarriedForwardsZVK(Date stichtag) {
        if (!this.mEeCFZvkLoaded) {
            EECarriedForwardZVK[] entrys = this.mCalculationCase.getEmployee().getEECarriedForwardZVK();
            ArrayList<EECarriedForwardZVK> entryList = new ArrayList<EECarriedForwardZVK>();
            for (EECarriedForwardZVK entry : entrys) {
                if (!DateHelper.equal((Date)DateHelper.getFirstDayOfYear((Date)stichtag), (Date)DateHelper.getFirstDayOfYear((Date)entry.getValidFrom()))) continue;
                entryList.add(entry);
            }
            if (!entryList.isEmpty()) {
                this.mEECarriedForwardsZVK = new EECarriedForwardZVK[entryList.size()];
                this.mEECarriedForwardsZVK = entryList.toArray(this.mEECarriedForwardsZVK);
            } else {
                this.mEECarriedForwardsZVK = null;
            }
            this.mEeCFZvkLoaded = true;
        }
        return this.mEECarriedForwardsZVK;
    }

    public boolean hasCFZVK(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys = this.getEECarriedForwardsZVK(stichtag);
        if (entrys == null) {
            return false;
        }
        return entrys.length != 0;
    }

    public BigDecimal getCFZVK3Nr63(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardZVK entry : entrys = this.getEECarriedForwardsZVK(stichtag)) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getTaxfreeAdditionalContributionER())) continue;
            result = result.add(entry.getTaxfreeAdditionalContributionER());
        }
        return result;
    }

    public BigDecimal getCFZVK3Nr56(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardZVK entry : entrys = this.getEECarriedForwardsZVK(stichtag)) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getTaxfreeAssessmentER())) continue;
            result = result.add(entry.getTaxfreeAssessmentER());
        }
        return result;
    }

    public BigDecimal getCFZVKPauschalsteuer(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardZVK entry : entrys = this.getEECarriedForwardsZVK(stichtag)) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getLumpsumAssessmentER())) continue;
            result = result.add(entry.getLumpsumAssessmentER());
        }
        return result;
    }

    public BigDecimal getCFZVKZusatzPauschalsteuer(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardZVK entry : entrys = this.getEECarriedForwardsZVK(stichtag)) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getLumpsumAdditionalContribution())) continue;
            result = result.add(entry.getLumpsumAdditionalContribution());
        }
        return result;
    }

    public BigDecimal getCFZVKSteuerpflichtig(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardZVK entry : entrys = this.getEECarriedForwardsZVK(stichtag)) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getTaxableAdditionalContributionER())) continue;
            result = result.add(entry.getTaxableAdditionalContributionER());
        }
        return result;
    }

    public BigDecimal getCFZVKSVfreiAusZusatzbeitrag(Date stichtag) throws BusinessDomainException {
        EECarriedForwardZVK[] entrys;
        BigDecimal result = BigDecimal.ZERO;
        for (EECarriedForwardZVK entry : entrys = this.getEECarriedForwardsZVK(stichtag)) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)entry.getSIfreeAdditionalContribution())) continue;
            result = result.add(entry.getSIfreeAdditionalContribution());
        }
        return result;
    }

    public boolean isZVKZusatzumlage() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().isCalculateAddAssessment();
        }
        return result;
    }

    public boolean isZVKWeiteresVersicherungsverhaeltnis() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            FurtherInsuranceEnum furtherInsurance = this.getEEZvk().getFurtherInsurance();
            switch (furtherInsurance.value()) {
                case 2: 
                case 3: {
                    result = true;
                    break;
                }
                case 0: 
                case 1: {
                    result = false;
                }
            }
        }
        return result;
    }

    public ZvkTypeOfCalculationEnum zvkBerechnungUmlage() throws BusinessDomainException {
        ZvkTypeOfCalculationEnum result = ZvkTypeOfCalculationEnum.ZTOCE_keine_Berechnung;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().getTypeOfCalculation();
        }
        return result;
    }

    public Recipient zvKasse() throws BusinessDomainException {
        Recipient result = null;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().getZVK();
        }
        return result;
    }

    private EEZVK getEEZvk() throws BusinessDomainException {
        if (!this.mEeZvkLoaded) {
            block4: {
                try {
                    this.mEEZVK = this.mCalculationCase.getEmployee().getEEZVK(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
                    this.getInsurance();
                    if (!DateHelper.equal((Date)this.mEEZVK.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.mCalculationCase.getEmployee(), this.mValuePosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mEEZVK.getValidUntil()), this.mEEZVK.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            this.mEeZvkLoaded = true;
        }
        return this.mEEZVK;
    }

    public boolean zvkAbwaelzungPauschalLstAn() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().isToShiftLumpSumITax();
        }
        return result;
    }

    public boolean zvkAbwaelzungPauschalSolZAn() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().isToShiftLumpSumSTax();
        }
        return result;
    }

    public boolean zvkAbwaelzungPauschalKiStAn() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().isToShiftLumpSumCTax();
        }
        return result;
    }

    public boolean zvkAbwaelzungPauschalLstAnZusatzbeitrag() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null && (this.getEEZvk().getTypeOfCalcAddCont() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag || this.getEEZvk().getTypeOfCalcAddCont() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers) && this.getEEZvk().getCalculationOfAddCont() == CalcOfAddContEnum.COACE_PASCHALIERT_AN) {
            result = true;
        }
        return result;
    }

    public boolean zvkAbwaelzungPauschalSolZAnZusatzbeitrag() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null && (this.getEEZvk().getTypeOfCalcAddCont() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag || this.getEEZvk().getTypeOfCalcAddCont() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers) && this.getEEZvk().getCalculationOfAddCont() == CalcOfAddContEnum.COACE_PASCHALIERT_AN) {
            result = true;
        }
        return result;
    }

    public boolean zvkAbwaelzungPauschalKiStAnZusatzbeitrag() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null && (this.getEEZvk().getTypeOfCalcAddCont() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag || this.getEEZvk().getTypeOfCalcAddCont() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers) && this.getEEZvk().getCalculationOfAddCont() == CalcOfAddContEnum.COACE_PASCHALIERT_AN) {
            result = true;
        }
        return result;
    }

    public boolean zvkAltersteilzeitVor2003() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null) {
            result = this.getEEZvk().getBeginAgePartTimeBefore2003();
        }
        return result;
    }

    public BigDecimal marbBeitrPKPv() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return BigDecimal.ZERO;
        }
        return this.getInsurance().getBaseRatePrivateInsurance();
    }

    public boolean isMarbZVKPflichtig() throws BusinessDomainException {
        boolean result = false;
        if (this.getEEZvk() != null && (this.getEEZvk().getTypeOfCalcAddCont().value() != 0 || this.getEEZvk().getTypeOfCalculation().value() != 0)) {
            if (this.getEEZvk().getDateOfWithdrawl() != null) {
                if (DateHelper.beforeOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)this.getEEZvk().getDateOfWithdrawl())) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public Date marbEintrittSozialKonzernEintritt() throws BusinessDomainException {
        return this.getEmployment().getAllowableEntryDate();
    }

    public int vorherigePNR() throws BusinessDomainException {
        if (this.getInsurance() == null) {
            return 0;
        }
        return this.getInsurance().getChangePersonnelnumber();
    }

    public Date marbVbluEintritt() throws BusinessDomainException {
        return this.marbVblu().getDateOfEntry();
    }

    public Date marbVbluAustritt() throws BusinessDomainException {
        Date result = VDate.getDateMax();
        if (this.marbVblu().getDateOfWithdrawal() != null) {
            if (DateHelper.before((Date)this.mCalculationCase.getValidFrom(), (Date)this.marbVblu().getDateOfWithdrawal())) {
                new CalculationBasic(this.marb(), this.mCalculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.marbVblu().getDateOfWithdrawal())), this.marbVblu().getClassName());
            }
            result = this.marbVblu().getDateOfWithdrawal();
        }
        return result;
    }

    public BigDecimal marbVbluVHSatzAG() throws BusinessDomainException {
        return this.marbVblu().getContPercER();
    }

    public BigDecimal marbVbluVHSatzAN() throws BusinessDomainException {
        return this.marbVblu().getContPercEE();
    }

    public Recipient vblu() throws BusinessDomainException {
        return this.marbVblu().getVBLU();
    }

    public VbluImplementationPathEnum marbVbluDurchfuehrungsweg() throws BusinessDomainException {
        return this.marbVblu().getImplementationPath();
    }

    public boolean marbVbluJaehrlicheFreigrenze() throws BusinessDomainException {
        return this.marbVblu().isConsumptionExemtionLimit();
    }

    public int marbVbluVortragJahr() throws BusinessDomainException {
        return this.marbVblu().getCarriedForwardYear();
    }

    public BigDecimal marbVbluVortrag() throws BusinessDomainException {
        return this.marbVblu().getCarriedForward();
    }

    public boolean marbVbluPauschLStAN() throws BusinessDomainException {
        return this.marbVblu().isToShiftLumpsumITax();
    }

    public boolean marbVbluPauschSolZAN() throws BusinessDomainException {
        return this.marbVblu().isToShiftLumpsumSTax();
    }

    public boolean marbVbluPauschKiStAN() throws BusinessDomainException {
        return this.marbVblu().isToShiftLumpsumCTax();
    }

    public boolean marbVbluBeitragskappung() throws BusinessDomainException {
        return this.marbVblu().isTruncationOfContribution();
    }

    public EEVBLU marbVblu() throws BusinessDomainException {
        return this.marb().getEEVBLU(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
    }

    public EEWork marbArbeitsangabenVM() throws BusinessDomainException {
        return this.getEEWorkVM(this.mValuePosition.getEffectiveFrom(), DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))));
    }

    public EEAbsentTimeTP[] fehlzeitenBerechnungsZeitraum() {
        EEAbsentTimeTP[] tpArray = this.mValuePosition.getEmployee().getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mValuePosition.getEmployee().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mCalculationCase.getEffectiveFrom())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mCalculationCase.getEffectiveFrom())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mCalculationCase.getValidFrom()))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mCalculationCase.getValidFrom())))}), true);
        if (tpArray.length > 0) {
            ArrayList<EEAbsentTimeTP> list = new ArrayList<EEAbsentTimeTP>();
            for (EEAbsentTimeTP absentTimeTP : tpArray) {
                if (absentTimeTP.getEEAbsentTime().getIsDeleted()) continue;
                list.add(absentTimeTP);
            }
            EEAbsentTimeTP[] array = new EEAbsentTimeTP[list.size()];
            return list.toArray(array);
        }
        return new EEAbsentTimeTP[0];
    }

    public EEAbsentTimeTP[] aktuelleFehlzeiten() throws BusinessDomainException {
        EEAbsentTimeTP[] eeAbsentTimeTPSeq = this.fehlzeitenBerechnungsZeitraum();
        if (this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungOhneGleitzoneUndFZKindkrank || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.VerdienstausfallOhneFZQuarantaene || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.VerdienstausfallOhneFZBetreuungKind || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungOhneFehlzeit || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.BescheinigungKompletterMonat || this.mCalculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.PfaendungOhneFehlzeiten) {
            ArrayList<EEAbsentTimeTP> eeAbsentTimeTPList = new ArrayList<EEAbsentTimeTP>();
            CalculationLibraryImpl callib = new CalculationLibraryImpl(this.mValuePosition, this.mCalculationCase);
            for (EEAbsentTimeTP eeAbsentTimeTP : eeAbsentTimeTPSeq) {
                AbsentTime absentTime = eeAbsentTimeTP.getEEAbsentTime().getAbsentTime();
                if (callib.fehlzeitNichtBeruecksichtigen(absentTime)) continue;
                eeAbsentTimeTPList.add(eeAbsentTimeTP);
            }
            eeAbsentTimeTPSeq = new EEAbsentTimeTP[eeAbsentTimeTPList.size()];
            eeAbsentTimeTPSeq = eeAbsentTimeTPList.toArray(eeAbsentTimeTPSeq);
        }
        return eeAbsentTimeTPSeq;
    }

    public EEAbsentTimeTP[] aktuelleFehlzeitenfuerMonat(Date monat) throws BusinessDomainException {
        return this.mValuePosition.getEmployee().getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mValuePosition.getEmployee().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mValuePosition.getEffectiveFrom())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mValuePosition.getEffectiveFrom())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)monat))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)monat)))}), true);
    }

    public EEAbsentTimeTP[] aktuelleFehlzeitenNachSchluessel(String fehlzeitSchluessel) {
        EEAbsentTimeTP[] result;
        EEAbsentTimeTP[] fehlzeiten = this.mValuePosition.getEmployee().getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mValuePosition.getEmployee().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mCalculationCase.getEffectiveFrom())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mCalculationCase.getEffectiveFrom())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mCalculationCase.getValidFrom()))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mCalculationCase.getValidFrom())))}), true);
        ArrayList<EEAbsentTimeTP> returnList = new ArrayList<EEAbsentTimeTP>();
        for (EEAbsentTimeTP lEeAbsentTimeTP : fehlzeiten) {
            if (!StringMapper.equal((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitSchluessel)) continue;
            returnList.add(lEeAbsentTimeTP);
        }
        if (returnList.isEmpty()) {
            result = new EEAbsentTimeTP[]{};
        } else {
            result = new EEAbsentTimeTP[returnList.size()];
            result = returnList.toArray(result);
        }
        return result;
    }

    public TypeOfTimeOffEnum marbUmlageErstattungsberechnung() throws BusinessDomainException {
        TypeOfTimeOffEnum result = TypeOfTimeOffEnum.TOTOE_KALENDERTAGE;
        if (this.getEmployment() != null) {
            result = this.getEmployment().getTypeOfTimeOff();
        }
        return result;
    }

    public boolean marbAAGBerechnungsrelevant() throws BusinessDomainException {
        boolean result = false;
        Employment lEmployment = this.getEmployment();
        if (lEmployment != null) {
            result = lEmployment.getEarnedIncomeRelevantForCalculation();
        }
        return result;
    }

    public BigDecimal marbMugAagBruttoMonatlich() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Employment lEmployment = this.getEmployment();
        if (lEmployment != null) {
            result = lEmployment.getAverageMonthlyGrossPay();
        }
        return result;
    }

    public BigDecimal marbMugAagNettoMonatlich() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Employment lEmployment = this.getEmployment();
        if (lEmployment != null) {
            result = lEmployment.getAverageMonthlyNetPay();
        }
        return result;
    }

    public BigDecimal marbMugAagNettoTaeglich() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Employment lEmployment = this.getEmployment();
        if (lEmployment != null) {
            result = lEmployment.getCalendarDailyNetPay();
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)result)) {
            throw EvaluationExceptionMapper.makeThreeMonthAverageCalculationDomainException();
        }
        return result;
    }

    public BigDecimal marbMuGAagZuschussKrk() throws BusinessDomainException {
        BigDecimal result = BigDecimal.valueOf(13L);
        Employment lEmployment = this.getEmployment();
        if (lEmployment != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)lEmployment.getMaternityBenefit())) {
            result = lEmployment.getMaternityBenefit();
        }
        return result;
    }

    public TypeOfEarnedIncomEnum marbArtDerEntgeltErmittlung() throws BusinessDomainException {
        TypeOfEarnedIncomEnum result = TypeOfEarnedIncomEnum.TOEIE_MONATSLOHN;
        Employment lEmployment = this.getEmployment();
        if (lEmployment != null) {
            result = lEmployment.getTypeOfEarnedIncome();
        }
        return result;
    }

    public Date marbZVKEintritt() throws BusinessDomainException {
        Date result = null;
        if (this.getEEZvk() != null) {
            result = this.mEEZVK.getDateOfEntry();
        }
        return result;
    }

    public Date marbZVKAustritt() throws BusinessDomainException {
        Date result = VDate.getDateMax();
        if (this.getEEZvk() != null && this.mEEZVK.getDateOfWithdrawl() != null) {
            if (DateHelper.before((Date)this.mCalculationCase.getValidFrom(), (Date)this.mEEZVK.getDateOfWithdrawl())) {
                new CalculationBasic(this.marb(), this.mCalculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.mEEZVK.getDateOfWithdrawl())), this.mEEZVK.getClassName());
            }
            result = this.mEEZVK.getDateOfWithdrawl();
        }
        return result;
    }

    public void marbKiStLStJA(boolean b) {
        this.mKiStLStJA = b;
    }

    public ChurchTaxEnum vortragKiStAuspraegung(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryKiStErhebung(stichtag);
    }

    public Date vortragGueltigBis(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryValidUntil(stichtag);
    }

    public Date vortragGueltigAb(Date stichtag) throws BusinessDomainException {
        return this.getCFEntryValidFrom(stichtag);
    }

    public MultipleIncomeEnum marbMehrfachBezug() throws BusinessDomainException {
        MultipleIncomeEnum result = MultipleIncomeEnum.MIE_0_GRUNDSTELLUNG;
        if (this.getInsurance() != null) {
            result = this.getInsurance().getMultipleIncome();
        }
        return result;
    }

    public boolean isBehinderterMA() throws BusinessDomainException {
        return this.marbPgs() == 107 || this.marbPgs() == 111 || this.marbPgs() == 127;
    }

    public boolean isUebernahmePVZuschlag() throws BusinessDomainException {
        return this.getInsurance().getERPaysNISurcharge();
    }

    public BigDecimal kvz() throws BusinessDomainException {
        Insurance insurance;
        BigDecimal kvz = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mCalculationCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate()) && (insurance = this.getInsurance()) != null) {
            if (this.marbKrkKVdR() != null && insurance.getBeginKVDR() != null) {
                kvz = this.marbKrkBsZusatzbeitragKVdR();
            } else {
                HealthFundTP healthFundTP = this.getHealthFundTP();
                if (healthFundTP != null) {
                    kvz = healthFundTP.getAdditionalDues();
                }
            }
            if (kvz == null) {
                kvz = BigDecimal.ZERO;
            }
        }
        return kvz;
    }

    public Date getValidFromKVdR(Date validFrom) {
        Date validFromKVdR = validFrom;
        if (DateHelper.afterOrEqual((Date)validFrom, (Date)new VDate(2015, 0, 1).getDate())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(validFrom);
            cal.add(2, -2);
            validFromKVdR = cal.getTime();
        }
        return validFromKVdR;
    }

    public boolean zvkAufrechnungJahresendeAustritt() throws BusinessDomainException {
        Date suchDatum;
        Employee employee = this.mCalculationCase.getEmployee();
        Date berechnungsStartFirma = this.marbFirma().getCompanyFoundations(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getCalculationStart();
        Date ersterTagDesjahres = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        ersterTagDesjahres = DateHelper.before((Date)ersterTagDesjahres, (Date)berechnungsStartFirma) ? berechnungsStartFirma : ersterTagDesjahres;
        Date eintritt = this.marbEintritt();
        Date date = suchDatum = DateHelper.after((Date)eintritt, (Date)ersterTagDesjahres) ? this.marbEintritt() : ersterTagDesjahres;
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            EEZVK eeZVK;
            Tax tax;
            block11: {
                tax = null;
                eeZVK = null;
                try {
                    tax = employee.getTax(this.mValuePosition.getEffectiveFrom(), suchDatum);
                    eeZVK = employee.getEEZVK(this.mValuePosition.getEffectiveFrom(), suchDatum);
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block11;
                    throw e;
                }
            }
            if (tax != null) {
                if (tax.getTaxBracket() == 6) {
                    return false;
                }
            } else {
                return false;
            }
            if (eeZVK != null) {
                FurtherInsuranceEnum furtherInsurance = eeZVK.getFurtherInsurance();
                switch (furtherInsurance.value()) {
                    case 2: 
                    case 3: {
                        return false;
                    }
                }
            } else {
                return false;
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return true;
    }

    public void setLohnsteuerberechnungDBA(boolean isLohnsteuerberechnungDBA) {
        this.mLohnsteuerberechnungDBA = isLohnsteuerberechnungDBA;
    }

    public boolean isPGS122Geringverdiener() throws BusinessDomainException {
        boolean isGfB = false;
        if (DateHelper.before((Date)this.getBeginnPGS122(), (Date)new VDate(2020, 0, 1).getDate())) {
            isGfB = true;
        } else {
            GlobalLibrary glLibrary = this.getGlobalLibrary(this.mValuePosition, this.mCalculationCase);
            if (BigDecimalMapper.compareTo((BigDecimal)this.getBeitragspflichtigesEntgelt(), (BigDecimal)glLibrary.svGeringverdienerGrenze()) <= 0) {
                isGfB = true;
            }
        }
        return isGfB;
    }

    private GlobalLibrary getGlobalLibrary(ValuePosition vp, CalculationCase cc) {
        return ((IGlobalLibraryImplFactory)UtilitiesManager.getBean((String)"globalLibraryImplFactory", IGlobalLibraryImplFactory.class)).create(this.mValuePosition, this.mCalculationCase, (EmployeeLibrary)this);
    }

    private Date getBeginnPGS122() throws BusinessDomainException {
        Date beginnPGS122 = null;
        Education education = (Education)this.marb().getEducationHistory().getItemOrNull(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
        if (education != null) {
            beginnPGS122 = education.getDateOfBegin();
        }
        if (beginnPGS122 == null) {
            Insurance insurance = this.getInsurance(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
            while (insurance != null && insurance.getPersonGroup() == 122) {
                beginnPGS122 = insurance.getValidFrom();
                insurance = this.getInsurance(this.mCalculationCase.getEffectiveFrom(), DateHelper.yesterday((Date)insurance.getValidFrom()));
            }
        }
        if (beginnPGS122 == null) {
            beginnPGS122 = this.mCalculationCase.getEffectiveFrom();
        }
        return beginnPGS122;
    }

    private BigDecimal getBeitragspflichtigesEntgelt() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal entgelt = BigDecimal.ZERO;
        for (ValuePosition vp : vpArray = this.mCalculationCase.getValuePositionHistory().getItems(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getValidUntil())) {
            if (vp.getValueType().getValueTypeKey() != 130510 && vp.getValueType().getValueTypeKey() != 130610 && vp.getValueType().getValueTypeKey() != 130620 && vp.getValueType().getValueTypeKey() != 130640 && vp.getValueType().getValueTypeKey() != 130650) continue;
            entgelt = entgelt.add(vp.getResult());
        }
        return entgelt;
    }

    private Insurance getInsurance(Date effectiveDate, Date validDate) throws BusinessDomainException {
        Insurance insurance;
        block2: {
            insurance = null;
            try {
                insurance = this.marb().getInsurance(effectiveDate, validDate);
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block2;
                throw e;
            }
        }
        return insurance;
    }

    public Date getBeginnKUG() throws BusinessDomainException {
        GeneralEmploymentOffice geo = this.marb().getAppurtenantEmploymentOffice(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
        if (geo != null) {
            this.mBeginnKUG = geo.getBeginKugBezug();
        }
        return this.mBeginnKUG;
    }

    public void checkAVBGSBeiAltersvollrentner(Date validFrom) throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)validFrom, (Date)new VDate(2022, 0, 1).getDate())) {
            if (this.mInsurance.getPersonGroup() < 900 && this.mInsurance.getPersonGroup() != 105 && this.mInsurance.getPersonGroup() != 106 && this.mInsurance.getPersonGroup() != 109 && this.mInsurance.getPersonGroup() != 110 && this.mInsurance.getPersonGroup() != 190) {
                throw EvaluationExceptionMapper.makeInvalidDuesGroupUI(validFrom);
            }
        } else {
            throw EvaluationExceptionMapper.makeInvalidDuesGroupUI(validFrom);
        }
    }

    public BigDecimal anzahlKinderPVMinderung() throws BusinessDomainException {
        return this.anzahlKinderPVMinderung(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
    }

    private BigDecimal anzahlKinderPVMinderung(Date effectiveDate, Date validDate) throws BusinessDomainException {
        BigDecimal anzahlKinder = this.marb().getEffectiveNumberOfChildrenForNI(effectiveDate, validDate, false, true);
        if (BigDecimalMapper.compareTo((BigDecimal)anzahlKinder, (BigDecimal)BigDecimal.ONE) >= 0) {
            anzahlKinder = anzahlKinder.subtract(BigDecimal.ONE);
        }
        return anzahlKinder;
    }

    public BigDecimal pVAbschlagKinder() throws BusinessDomainException {
        return this.pVAbschlagKinder(this.mCalculationCase.getEffectiveFrom(), this.mCalculationCase.getValidFrom());
    }

    public BigDecimal pVAbschlagKinder(Date effectiveDate, Date validDate) throws BusinessDomainException {
        GlobalLibrary glLibrary;
        BigDecimal anschlagssatz;
        BigDecimal abschlag = BigDecimal.ZERO;
        BigDecimal anzahlKinder = this.anzahlKinderPVMinderung(effectiveDate, validDate);
        if (BigDecimalMapper.compareTo((BigDecimal)anzahlKinder, (BigDecimal)BigDecimal.ZERO) > 0 && BigDecimalMapper.compareTo((BigDecimal)(abschlag = anzahlKinder.multiply(anschlagssatz = (glLibrary = this.getGlobalLibrary(this.mValuePosition, this.mCalculationCase)).svPVAbschlagssatz()).setScale(2, RoundingMode.HALF_UP)), (BigDecimal)BigDecimal.ONE) > 0) {
            abschlag = BigDecimal.ONE;
        }
        return abschlag;
    }

    public boolean isBufdi() {
        if (this.mInsurance.getPersonGroup() == 123) {
            return true;
        }
        SocialInsuranceStatus svStatus = this.mInsurance.getSIStatus();
        return svStatus != null && StringMapper.equal((String)svStatus.getSIStatusKey(), (String)"BFD Rentenbezug");
    }
}

