/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.employment;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.employment.EEEmploymentStruct;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.IEmploymentPersistencyManager;
import com.varial.personnel.domain.employee.employment.mapper.IEmploymentMapper;
import com.varial.personnel.framework.audit.IRequestAndAuditBc;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;

public class EmploymentManager {
    Employee mEmployee = null;
    Employment mEmployment = null;
    private final boolean mAudit;

    public EmploymentManager() {
        this(true);
    }

    public EmploymentManager(boolean audit) {
        this.mAudit = audit;
    }

    public void handleSetEmployment(int personnelnumberNew, EEEmploymentStruct struct) throws BusinessDomainException {
        this.mEmployee = null;
        this.mEmployment = null;
        if (personnelnumberNew != 0 || personnelnumberNew == struct.root.personnelnumber) {
            this.handleSetEmploymentWithNewPersonnelNumber(personnelnumberNew, struct);
            return;
        }
        this.mEmployee = this.getIEmployeePM().getEmployee(struct.root.oidTs.objectid);
        this.mEmployment = this.getEmploymentPM().createEmployment(struct.history.oidTs.objectid, struct.history.oidTs.version, this.mEmployee);
        this.getEmploymentMapper().fillEmployment(this.mEmployment, struct.history);
        this.mEmployment.registerForFirstExecute();
        Employment employmentOld = this.getEmploymentPM().getEmployment(struct.history.oidTs.objectid);
        this.mEmployment.compareToOld(employmentOld);
        this.mEmployment.setCheckInsolvency(true);
        this.mEmployee.setEmploymentHistory(this.mEmployment, false, DateMapper.toDate((String)struct.history.timePeriod.effectiveFrom));
        if (this.mAudit) {
            IRequestAndAuditBc.getInstance().audit(this.mEmployment, employmentOld);
        }
    }

    public void handleSetEmploymentWithNewPersonnelNumber(int personnelnumberNew, EEEmploymentStruct struct) throws BusinessDomainException {
        this.mEmployee = this.getIEmployeePM().createEmployee(struct.root.oidTs.objectid, struct.root.oidTs.version);
        this.mEmployee.setPersonnelnumber(personnelnumberNew);
        struct.history.personnelnumberOld = Integer.toString(struct.root.personnelnumber);
        this.mEmployment = this.getEmploymentPM().createEmployment(struct.history.oidTs.objectid, struct.history.oidTs.version, this.mEmployee);
        this.getEmploymentMapper().fillEmployment(this.mEmployment, struct.history);
        this.mEmployment.registerForFirstExecute();
        Employment employmentOld = this.getEmploymentPM().getEmployment(struct.history.oidTs.objectid);
        this.mEmployment.compareToOld(employmentOld);
        this.mEmployment.setSpecialChecks(false);
        this.mEmployee.setEmploymentHistory(this.mEmployment, false, DateMapper.toDate((String)struct.history.timePeriod.effectiveFrom));
        if (this.mAudit) {
            IRequestAndAuditBc.getInstance().auditChangePersonnelNumber(personnelnumberNew, struct.root.personnelnumber, this.mEmployment);
        }
    }

    public void handleAddEmployment(int personnelnumberNew, EEEmploymentStruct struct, boolean removeNew) throws BusinessDomainException {
        this.mEmployee = null;
        this.mEmployment = null;
        if (personnelnumberNew != 0 || personnelnumberNew == struct.root.personnelnumber) {
            this.handleAddEmploymentWithNewPersonnelNumber(personnelnumberNew, struct);
            return;
        }
        this.mEmployee = this.getIEmployeePM().getEmployee(struct.root.oidTs.objectid);
        this.mEmployment = this.getEmploymentPM().createEmployment(this.mEmployee);
        this.getEmploymentMapper().fillEmployment(this.mEmployment, struct.history);
        Employment employmentOld = this.getEmploymentPM().getEmployment(struct.history.oidTs.objectid);
        this.mEmployment.compareToOld(employmentOld);
        this.mEmployment.setCheckInsolvency(true);
        this.mEmployee.addEmploymentHistory(this.mEmployment, removeNew);
        if (this.mAudit) {
            IRequestAndAuditBc.getInstance().audit(this.mEmployment, employmentOld);
        }
    }

    public void handleAddEmploymentWithNewPersonnelNumber(int personnelnumberNew, EEEmploymentStruct struct) throws BusinessDomainException {
        this.mEmployee = this.getIEmployeePM().createEmployee(struct.root.oidTs.objectid, struct.root.oidTs.version);
        this.mEmployee.setPersonnelnumber(personnelnumberNew);
        struct.history.personnelnumberOld = Integer.toString(struct.root.personnelnumber);
        Employment employmentOld = this.mEmployment = this.mEmployee.getActiveEmployment();
        struct.history.timePeriod.tps.validFrom = DateMapper.toString((Date)this.mEmployment.getValidFrom());
        this.getEmploymentMapper().fillEmployment(this.mEmployment, struct.history);
        this.mEmployment.registerForFirstExecute();
        this.mEmployment.compareToOld(employmentOld);
        this.mEmployment.setSpecialChecks(false);
        this.mEmployee.setEmploymentHistory(this.mEmployment, false, DateMapper.toDate((String)struct.history.timePeriod.effectiveFrom));
        if (this.mAudit) {
            IRequestAndAuditBc.getInstance().auditChangePersonnelNumber(personnelnumberNew, struct.root.personnelnumber, this.mEmployment);
        }
    }

    public Employee getEmployee() {
        return this.mEmployee;
    }

    public Employment getEmployment() {
        return this.mEmployment;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private IEmploymentPersistencyManager getEmploymentPM() {
        return (IEmploymentPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("employmentPersistencyManager", IEmploymentPersistencyManager.class);
    }

    private IEmploymentMapper getEmploymentMapper() {
        return (IEmploymentMapper)UtilitiesManager.getBean((String)"employmentIdlMapper", IEmploymentMapper.class);
    }
}

