/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee;

import com.infor.igf.core.scheduler.ExecutionGroup;
import com.infor.igf.core.scheduler.PreferredScheduler;
import com.infor.igf.core.scheduler.SchedulerService;
import com.varial.base.UtilitiesManager;
import com.varial.base.callback.AbstractAsynchronousPrintCommand;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.setting.Setting;
import com.varial.framework.domain.setting.SettingPersistencyManager;
import com.varial.personnel.domain.calculation.PermanentCalculationJob;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.EmployeeExtended;
import com.varial.personnel.domain.employee.EmployeeForCalculateStruct;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.JournalizeBean;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.salaryhistory.SalaryHistoryManager;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundationsPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.pueg.puegaccount.IPuegAccountPersistencyManager;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFormatFactory;
import com.varial.personnel.domain.reports.SimpleCollectionReportDS;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Journalize
extends AbstractAsynchronousPrintCommand<ReportFileStructCallback> {
    private static Logger LOGGER = LoggerFactory.getLogger(Journalize.class);
    private static String PROFILE_PREFIX = "JPR";
    private static final String REPORT_FOLDER = "com/varial/personnel/jasperreport/journalize/";
    private static final String REPORT_NAME = "JournalizeReport";
    private boolean mWithProtocol = false;
    private PCompany mPCompany;
    private final EmployeeExtended[] mEmployeeExtendeds;
    private final ProgressBarUpdater mProgressBar;

    public Journalize(AuthorizationToken token, ReportFileStructCallback callback, EmployeeExtended[] eeExtended, LazyRunnableHolder holder) {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE);
        this.mEmployeeExtendeds = eeExtended;
        this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, 1, "Initialisierung...");
    }

    public Journalize(AuthorizationToken token, ReportFileStructCallback callback, String oidPCompany, EmployeeExtended[] eeExtended, LazyRunnableHolder holder) {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE);
        this.mWithProtocol = true;
        this.mPCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
        this.mEmployeeExtendeds = eeExtended;
        this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, 2, "Initialisierung...");
    }

    public void execute() throws BusinessDomainException, PutDataException {
        Employee employee;
        this.mProgressBar.show();
        this.mProgressBar.setTotal(this.mEmployeeExtendeds.length);
        if (this.mEmployeeExtendeds.length != 0) {
            for (int i = 0; i < this.mEmployeeExtendeds.length; ++i) {
                Date journalTo = this.mEmployeeExtendeds[i].getNextJournalizing();
                if (!DateHelper.equal((Date)journalTo, (Date)DateMapper.toDate((String)"2025-11-30"))) continue;
                employee = Journalize.getIEmployeePM().getEmployee(this.mEmployeeExtendeds[i].getObjectID());
                PCompany pCompany = employee.getPCompany();
                boolean cancelExecute = this.checkPueg(pCompany);
                if (!cancelExecute) break;
                throw EmployeeExceptionMapper.makeNotPuegJournalizeNotAllowedDomainException();
            }
        }
        ArrayList<EmployeeForCalculateStruct> toCalculate = new ArrayList<EmployeeForCalculateStruct>();
        List<JournalizeBean> protocolBeans = this.setJournalDate(this.mEmployeeExtendeds, toCalculate, this.getContext());
        this.getContext().flush();
        if (this.mEmployeeExtendeds.length == 0) {
            return;
        }
        employee = Journalize.getIEmployeePM().getEmployee(this.mEmployeeExtendeds[0].getObjectID());
        CompanySettings pcSettings = employee.getPCompany().getCompanySettings(VDate.getDateMax(), VDate.getDateMax());
        if (pcSettings.getDevelopOfSalaryHistoryAtJournalize()) {
            this.mProgressBar.setTotal(this.mEmployeeExtendeds.length);
            SalaryHistoryManager.cleanAndCreateByJournalize((EmployeeExtended[])this.mEmployeeExtendeds, (ProgressBarUpdater)this.mProgressBar, (PersistencySession)this.getContext());
        }
        this.getContext().flush();
        SchedulerService schedulerService = (SchedulerService)UtilitiesManager.getBean((String)"schedulerService", SchedulerService.class);
        EmployeeForCalculateStruct[] structs = toCalculate.toArray(new EmployeeForCalculateStruct[toCalculate.size()]);
        for (int i = 0; i < structs.length; ++i) {
            employee = Journalize.getIEmployeePM().getEmployee(structs[i].oidEmployee);
            Date effectiveFrom = new VDate(employee.getJournalizedUntil()).addDays(1).getDate();
            Date validFrom = DateMapper.toDate((String)structs[i].calculateValidFrom);
            Date[] dates = employee.checkAndCorrectStartOfCalculation(effectiveFrom, validFrom);
            String correctEffectiveFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(dates[0].getTime()), ZoneId.systemDefault()).toString();
            String correctValidFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(dates[1].getTime()), ZoneId.systemDefault()).toString();
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("oidEmployee", employee.getObjectid());
            parameter.put("effectiveFrom", correctEffectiveFrom);
            parameter.put("validFrom", correctValidFrom);
            parameter.put("classOfBasic", ((Object)((Object)this)).getClass().getName());
            parameter.put("suppliedDomainKey", employee.getDomainKey());
            schedulerService.addJob(PreferredScheduler.CALCULATION, ExecutionGroup.CALCULATION, this.getToken().getUserId(), employee.getSchedulerDescription().toString(), PermanentCalculationJob.class, parameter);
            this.getContext().flush();
        }
        if (this.mWithProtocol) {
            protocolBeans.sort((bean1, bean2) -> Integer.compare(bean1.getPersonnelnumber(), bean2.getPersonnelnumber()));
            this.mProgressBar.nextStep("Protokoll drucken ...");
            this.createReport(this.mPCompany, protocolBeans);
        }
    }

    private List<JournalizeBean> setJournalDate(EmployeeExtended[] eeExtended, List<EmployeeForCalculateStruct> toCalculate, PersistencySession context) throws BusinessDomainException, PutDataException {
        HashSet<Date> differentJournalizeDates = new HashSet<Date>();
        Date minCalculationStart = CompanyFoundationsPersistencyManager.getMinCalculationStartAllOfCompanies();
        ArrayList<JournalizeBean> beans = new ArrayList<JournalizeBean>();
        for (EmployeeExtended element : eeExtended) {
            Employee employee = Journalize.getIEmployeePM().createEmployee(element.getObjectID(), element.getVersion());
            this.mProgressBar.update("Journalisierung: " + employee.getIDString());
            Date journalAt = element.getJournalizedUntil();
            Date journalTo = element.getNextJournalizing();
            StatusOfJournalize status = employee.journalize(journalAt, journalTo, toCalculate, minCalculationStart);
            if (status != StatusOfJournalize.ERFOLGREICH) {
                employee.makeReadOnly();
            }
            context.flush();
            if (this.mWithProtocol && status != StatusOfJournalize.ERFOLGREICH && status != StatusOfJournalize.BEREITS_JOURNALISIERT) {
                beans.add(new JournalizeBean(employee.getPCompany(), employee, StatusOfJournalize.toString(status)));
            }
            if (status != StatusOfJournalize.ERFOLGREICH) continue;
            differentJournalizeDates.add(journalTo);
        }
        this.checkSIMasterData();
        return beans;
    }

    private void createReport(PCompany pCompany, List<JournalizeBean> result) throws BusinessDomainException, PutDataException {
        File file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/journalize/JournalizeReport.jrxml"), this.createParameters(), (JRDataSource)new SimpleCollectionReportDS(result, pCompany), (String)PROFILE_PREFIX);
        String[] reports = new String[]{JasperReportManager.getUrl((File)file)};
        LOGGER.debug("File name: {}", (Object)reports[0]);
        ((ReportFileStructCallback)this.getCallback()).putData(reports);
    }

    private Map<String, Object> createParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_FORMAT_FACTORY", new ReportFormatFactory());
        return parameters;
    }

    private boolean checkPueg(PCompany pCompany) throws BusinessDomainException {
        long countForOtherEmployee;
        Conjunction filterForAccount = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid())});
        Date timePoint = DateMapper.toDate((String)"2025-07-01");
        String companynumber = pCompany.getActiveCompanyEmploymentOffice().getGeneralEmploymentOffice().getEmployerNumber();
        if (!StringMapper.isNullString((String)companynumber) && (companynumber.startsWith("985") || companynumber.startsWith("987"))) {
            return false;
        }
        Junction filterForEmployee = Restrictions.conjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.lt((String)"persongroup", (String)String.valueOf(900))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"duesgroupni", (String)String.valueOf(1)), Restrictions.eq((String)"duesgroupni", (String)String.valueOf(2))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"dateofwithdrawal"), Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)timePoint))}));
        Junction filterForOtherEmployee = Restrictions.conjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.lt((String)"persongroup", (String)String.valueOf(900))})).add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"duesgrouphi ", (String)String.valueOf(0)), Restrictions.eq((String)"duesgrouppi ", (String)String.valueOf(1)), Restrictions.eq((String)"duesgroupui ", (String)String.valueOf(1)), Restrictions.eq((String)"duesgroupni ", (String)String.valueOf(1))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"dateofwithdrawal"), Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)timePoint))}));
        Junction filterForKVdR = Restrictions.conjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.ge((String)"persongroup", (String)String.valueOf(900))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(1)), Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(2)), Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(3)), Restrictions.eq((String)"choiseofduesni ", (String)String.valueOf(4))})).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"dateofwithdrawal"), Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)timePoint))}));
        long countForAccount = this.getIPuegAccountPM().getRowCount((Criterion)filterForAccount);
        if (countForAccount > 0L) {
            return false;
        }
        long countForEmployee = Journalize.getIInsurancePM().getRowCount((Criterion)filterForEmployee);
        if (countForEmployee - (countForOtherEmployee = Journalize.getIInsurancePM().getRowCount((Criterion)filterForOtherEmployee)) > 0L) {
            return true;
        }
        long countForKVdR = Journalize.getIInsurancePM().getRowCount((Criterion)filterForKVdR);
        return countForKVdR > 0L;
    }

    private void checkSIMasterData() throws BusinessDomainException {
        String nameAktuelleDatei;
        if (!Journalize.getRunSIMasterdataCheck()) {
            return;
        }
        try {
            URL itsg = new URL("https://stammdatendatei.gkv-ag.de/Stammdatendatei.zip");
            InputStream inputStream = itsg.openStream();
            ZipInputStream zipInput = new ZipInputStream(inputStream, Charset.forName("ISO-8859-1"));
            ZipEntry zipEntry = zipInput.getNextEntry();
            nameAktuelleDatei = zipEntry.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String nameLetzteImportDatei = null;
        Setting setting = SettingPersistencyManager.getSetting((String)"SIMasterDataImport", (String)"SIImport", (String)"PW", (String)"FileName");
        if (setting != null && (nameLetzteImportDatei = setting.getValue()).length() > 27) {
            nameLetzteImportDatei = nameLetzteImportDatei.substring(nameLetzteImportDatei.length() - 27);
        }
        if (StringMapper.isNullString(nameLetzteImportDatei)) {
            throw FrameWorkExceptionMapper.makePublicMessageDomainException((String)"Achtung! Die Aktualisierung der SV-Daten aus der SV-Stammdatendatei fehlt. Bitte die SV-Daten aktualisieren!");
        }
        if (!StringMapper.equal((String)nameAktuelleDatei, (String)nameLetzteImportDatei)) {
            Date datumLetzterSIImport = null;
            setting = SettingPersistencyManager.getSetting((String)"SIMasterDataImport", (String)"SIImport", (String)"PW", (String)"LastImportFromSI");
            if (setting != null) {
                datumLetzterSIImport = DateMapper.toDate((String)setting.getValue());
            }
            if (datumLetzterSIImport == null || DateHelper.before((Date)datumLetzterSIImport, (Date)DateHelper.add((Date)new Date(), (int)-30))) {
                throw FrameWorkExceptionMapper.makePublicMessageDomainException((String)"Achtung! Die letzte Aktualisierung der SV-Daten liegt  mehr als 30 Tage zur\u00fcck. Bitte die SV-Daten aktualisieren!");
            }
        }
    }

    public static boolean getRunSIMasterdataCheck() throws BusinessDomainException {
        return false;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private IPuegAccountPersistencyManager getIPuegAccountPM() {
        return (IPuegAccountPersistencyManager)UtilitiesManager.getBean((String)"puegAccountPersistencyManager", IPuegAccountPersistencyManager.class);
    }

    private static IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }

    public static enum StatusOfJournalize {
        ERFOLGREICH,
        BEREITS_JOURNALISIERT,
        FEHLERHAFT_GEPRUEFT,
        PRUEFLAUF_FEHLT,
        IN_BERECHNUNG,
        FEHLERHAFT_ABGERECHNET,
        SONSTIGES;


        public static String toString(StatusOfJournalize e) {
            switch (e) {
                case ERFOLGREICH: {
                    return "erfolgreich";
                }
                case BEREITS_JOURNALISIERT: {
                    return "bereits journalisiert";
                }
                case FEHLERHAFT_GEPRUEFT: {
                    return "fehlerhaft gepr\u00fcft";
                }
                case PRUEFLAUF_FEHLT: {
                    return "aktueller Pr\u00fcflauf fehlt";
                }
                case IN_BERECHNUNG: {
                    return "in Berechnung";
                }
                case FEHLERHAFT_ABGERECHNET: {
                    return "fehlerhaft abgerechnet";
                }
                case SONSTIGES: {
                    return "sonstiges";
                }
            }
            throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)((Object)e)));
        }
    }
}

