/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.elo2.account;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.base.types.date.GMTCalendar;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.elo2.AdviceStateEnum;
import com.varial.personnel.domain.elo2.DetailMarker;
import com.varial.personnel.domain.elo2.ProtocolContentEmployeeData;
import com.varial.personnel.domain.elo2.ProtocolPriority;
import com.varial.personnel.domain.elo2.ReasonOfDeliveryEnum;
import com.varial.personnel.domain.elo2.account.Elo2Account;
import com.varial.personnel.domain.elo2.account.Elo2AccountPersistencyManager;
import com.varial.personnel.domain.elo2.account.Elo2Advice;
import com.varial.personnel.domain.elo2.account.Elo2EmplData;
import com.varial.personnel.domain.elo2.dueab.Elo2Dueab;
import com.varial.personnel.domain.elo2.duean.Elo2Duean;
import com.varial.personnel.domain.elo2.dueum.Elo2Dueum;
import com.varial.personnel.domain.elo2.mapper.Elo2ExceptionMapper;
import com.varial.personnel.domain.elo2.mapper.ReasonOfDeliveryEnumMapper;
import com.varial.personnel.domain.elo2.transfer.Elo2Transfer;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxComparator;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.framework.D;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Elo2Employee {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Elo2Employee.class);
    protected static final Pattern DEVIANTBIRTH_PATTERN = Pattern.compile("(\\d{2})\\.(\\d{2})\\.(\\d{4})");
    protected static final Date SETUP_AFTER_WITHDRAWAL = DateMapper.toDate((String)"2019-01-01");
    protected final Elo2Advice mElo2Advice;
    protected final Employee mEmployee;
    protected Elo2Account mCurrentElo2Account;
    protected final StringBuilder errorsManualAccount;
    protected String taxId;
    protected boolean noElstam;
    protected Employment activeEmployment;
    protected Date deviantDateOfEntry = null;
    protected boolean reRegister;
    protected final Date currentDate;
    protected Master master;
    protected Tax tax;
    protected boolean createAccount = false;
    protected Map<ReasonOfDeliveryEnum, Elo2Account[]> accountsByType;
    protected boolean hasErrorMessages;
    protected final boolean withoutProtocolling;
    protected Date firstMarch = null;
    protected Date deviantDateOfWithdrawal = null;
    protected final boolean forManualCreation;
    protected final Elo2EmplData emplData;
    protected Date validFrom;
    protected Date effectiveFrom;
    protected final Date creationDate;
    protected final Date maxDate = VDate.getDateMax();
    protected Elo2Account[] mEloUmmeldungen;

    public Elo2Employee(Elo2EmplData data) throws BusinessDomainException {
        this.mEmployee = data.getEmployee();
        this.mElo2Advice = data.getAdvice();
        this.withoutProtocolling = data.isWithoutProtocolling();
        this.forManualCreation = data.isForManual();
        this.emplData = data;
        this.currentDate = data.getValidFrom() != null ? data.getValidFrom() : new VDate().getDate();
        this.creationDate = VDate.getCurrentLocalizedDateAndTime();
        this.validFrom = DateHelper.correctDate((Date)this.currentDate);
        this.effectiveFrom = DateHelper.correctDate((Date)this.currentDate);
        this.accountsByType = new HashMap<ReasonOfDeliveryEnum, Elo2Account[]>();
        this.fetchExistingAccounts();
        this.errorsManualAccount = new StringBuilder();
        this.initFirstMarchDate();
        this.initEmployee();
    }

    private void initFirstMarchDate() {
        Calendar cal = GMTCalendar.getInstance();
        cal.setTime(this.currentDate);
        cal.set(5, 1);
        cal.set(2, 2);
        this.firstMarch = cal.getTime();
    }

    public boolean getHasErrorMessages() {
        return this.hasErrorMessages;
    }

    public Elo2Advice getElo2Advice() {
        return this.mElo2Advice;
    }

    public Employee getEmployee() {
        return this.mEmployee;
    }

    protected void initEmployee() throws BusinessDomainException {
        this.activeEmployment = this.mEmployee.getEmployment(this.maxDate, this.maxDate);
        this.master = this.mEmployee.getMaster(this.maxDate, this.maxDate);
        try {
            this.tax = this.mEmployee.getTax(this.maxDate, this.maxDate);
        }
        catch (Throwable t) {
            LOGGER.debug(t.getMessage(), t);
        }
        if (this.tax == null) {
            this.addProtocolContent("Keine Steuerangaben f\u00fcr MA und den Zeitraum gefunden", null, ProtocolPriority.OPTIONAL);
        } else {
            this.noElstam = this.tax.getNoElstam();
            this.taxId = this.tax.getTin();
            this.reRegister = this.tax.getReregister();
        }
    }

    public Elo2Account getCurrent() {
        return this.mCurrentElo2Account;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append('[').append((Object)this.mEmployee);
        b.append(',').append(this.mCurrentElo2Account);
        b.append(']');
        return b.toString();
    }

    public boolean checkIfAccountInitIsNecessary() {
        return this.isInEmployment(this.mElo2Advice.getElo2Start());
    }

    private Conjunction getStandardFilter() {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()));
        filter.add(Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.validFrom)));
        filter.add(Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.effectiveFrom)));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return filter;
    }

    private Conjunction getStandardReducedFilter() {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return filter;
    }

    private void checkExistingAccountByReason() {
        ReasonOfDeliveryEnum rod = this.mElo2Advice.getReasonOfDelivery();
        Elo2Account[] accounts = ReasonOfDeliveryEnum.UMMELDUNG.equals(rod) || ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND.equals(rod) ? this.mEloUmmeldungen : this.accountsByType.get(rod);
        if (accounts != null) {
            for (Elo2Account acc : accounts) {
                if (acc.getAdviceState() != AdviceStateEnum.CREATED && acc.getAdviceState() != AdviceStateEnum.READANSWERFAILED) continue;
                this.mCurrentElo2Account = acc;
                this.createAccount = true;
                return;
            }
            this.specialCheckExistingAccountByReason();
        }
    }

    public abstract void specialCheckExistingAccountByReason();

    private void checkUnfinishedAccounts() {
        ReasonOfDeliveryEnum rod = this.mElo2Advice.getReasonOfDelivery();
        if (rod == ReasonOfDeliveryEnum.ELSTAM) {
            return;
        }
        for (Map.Entry<ReasonOfDeliveryEnum, Elo2Account[]> me : this.accountsByType.entrySet()) {
            if (me.getKey() == ReasonOfDeliveryEnum.ELSTAM) continue;
            for (Elo2Account acc : me.getValue()) {
                if (acc.getAdviceState() != AdviceStateEnum.CREATED && acc.getAdviceState() != AdviceStateEnum.READANSWERFAILED) continue;
                if (acc.getIsManual()) {
                    this.addProtocolContent("Es existiert ein noch nicht versendetes manuelles Meldekonto " + acc.getDomainKey(), null, ProtocolPriority.OPTIONAL);
                    continue;
                }
                this.addProtocolContent("Meldekonto kann nicht erstellt werden, es existiert ein noch nicht versendetes Konto: " + acc.getDomainKey(), null, ProtocolPriority.OPTIONAL);
            }
        }
        for (Elo2Account acc : this.mEloUmmeldungen) {
            if (acc.getAdviceState() != AdviceStateEnum.CREATED && acc.getAdviceState() != AdviceStateEnum.READANSWERFAILED) continue;
            if (acc.getIsManual()) {
                this.addProtocolContent("Es existiert eine noch nicht versendete manuelle Ummeldung " + acc.getDomainKey(), null, ProtocolPriority.OPTIONAL);
                continue;
            }
            this.addProtocolContent("Meldekonto kann nicht erstellt werden, es existiert eine noch nicht versendete Ummeldung: " + acc.getDomainKey(), null, ProtocolPriority.OPTIONAL);
        }
    }

    public Elo2Account initElo2Account(boolean isSpecialAccess) throws BusinessDomainException {
        try {
            D.enter();
            D.out((Object)this.mEmployee.getIDString());
            this.doGeneralChecks(isSpecialAccess);
            this.checkExistingAccountByReason();
            this.doChecksByReasonOfDelivery();
            if (this.mCurrentElo2Account == null) {
                this.checkUnfinishedAccounts();
            }
            this.checkSeveralTaxIds();
            if (!this.hasErrorMessages && this.createAccount) {
                this.fillCurrentElo2Account(this.checkRefDate());
                Elo2Account elo2Account = this.mCurrentElo2Account;
                return elo2Account;
            }
            if (this.hasErrorMessages && this.forManualCreation) {
                throw Elo2ExceptionMapper.makeManualAccountCreationNotPossibleDomainException((String)this.errorsManualAccount.toString());
            }
        }
        finally {
            D.leave();
        }
        if (this.forManualCreation) {
            throw Elo2ExceptionMapper.makeManualAccountCreationNotPossibleDomainException((String)"Manuelles Meldekonto konnte nicht erstellt werden. Bitte pr\u00fcfen Sie, ob es nicht schon ein Meldekonto gleichen Typs gibt.");
        }
        return null;
    }

    private void checkSeveralTaxIds() {
        String result;
        if (this.noElstam || this.isLumpSum(this.tax) || !this.isWithDrawalNecessary()) {
            return;
        }
        if (!(StringMapper.isNullString((String)this.taxId) || StringMapper.isNullString((String)(result = this.mElo2Advice.appendPersNrToSteuerId(this.taxId, Integer.toString(this.mEmployee.getPersonnelnumber()), this.isInEmployment(this.currentDate)))) || this.isPersNrSplitting())) {
            this.addProtocolContent("Steuer-ID ist mehrfach vorhanden. Pers-Nr.: " + result, null, ProtocolPriority.OPTIONAL);
        }
    }

    private boolean isPersNrSplitting() {
        Employee preEmp;
        Employee sucEmp;
        return ReasonOfDeliveryEnum.ABMELDUNG.equals(this.mElo2Advice.getReasonOfDelivery()) ? (sucEmp = this.mEmployee.getSuccessor()) != null : (preEmp = this.mEmployee.getPredecessor()) != null && preEmp.getLastDateOfWithdrawal() != null && DateHelper.before((Date)preEmp.getLastDateOfWithdrawal(), (Date)new VDate().getDate());
    }

    private void fetchExistingAccounts() {
        Conjunction anFilter = this.getStandardFilter();
        anFilter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG)));
        this.accountsByType.put(ReasonOfDeliveryEnum.ANMELDUNG, Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"createdon")}, (Criterion)anFilter, (boolean)true));
        Conjunction abFilter = this.getStandardFilter();
        abFilter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ABMELDUNG)));
        this.accountsByType.put(ReasonOfDeliveryEnum.ABMELDUNG, Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"createdon")}, (Criterion)abFilter, (boolean)true));
        Conjunction elstFilter = this.getStandardFilter();
        elstFilter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ELSTAM)));
        this.accountsByType.put(ReasonOfDeliveryEnum.ELSTAM, Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"createdon")}, (Criterion)elstFilter, (boolean)true));
        Conjunction anSonstFilter = this.getStandardFilter();
        anSonstFilter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND)));
        this.accountsByType.put(ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND, Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"createdon")}, (Criterion)anSonstFilter, (boolean)true));
        Conjunction abSonstFilter = this.getStandardFilter();
        abSonstFilter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND)));
        this.accountsByType.put(ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND, Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"createdon")}, (Criterion)abSonstFilter, (boolean)true));
        Conjunction umFilter = this.getStandardFilter();
        umFilter.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG)), Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND))}));
        this.mEloUmmeldungen = Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"createdon")}, (Criterion)umFilter, (boolean)true);
    }

    private Tax[] getTaxHistory() {
        return this.mEmployee.getActiveEffectiveTaxHistory();
    }

    private Employment[] getEmploymentHistory() {
        return this.mEmployee.getActiveEffectiveEmploymentHistory();
    }

    private Date checkRefDate() {
        Date refDate = this.activeEmployment.getDateOfEntry();
        PersonnelTimedPersistenceObject lastTaxWithSV = null;
        boolean wasWithPausch = false;
        Tax[] taxes = this.getTaxHistory();
        for (int i = taxes.length - 1; i >= 0; --i) {
            if (taxes[i].getTaxBracket() <= 0 || taxes[i].getNoElstam()) {
                wasWithPausch = true;
                break;
            }
            lastTaxWithSV = taxes[i];
        }
        if (wasWithPausch && lastTaxWithSV != null) {
            refDate = lastTaxWithSV.getValidFrom();
        }
        if (DateHelper.before((Date)refDate, (Date)this.mElo2Advice.getElo2Start())) {
            refDate = this.mElo2Advice.getElo2Start();
        }
        if (DateHelper.after((Date)(refDate = this.checkPreviousYearsForRefDate(refDate)), (Date)new VDate().getDate())) {
            this.addProtocolContent("Meldekonto kann nicht erzeugt werden, das erzeugte RefDatumAG liegt in der Zukunft", null, ProtocolPriority.OPTIONAL);
        }
        if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.ANMELDUNG) {
            if (this.activeEmployment.getDateOfWithDrawal() != null && DateHelper.before((Date)this.activeEmployment.getDateOfWithDrawal(), (Date)refDate)) {
                this.addProtocolContent("Meldekonto kann nicht erzeugt werden, RefDatumAG liegt nach Austrittsdatum", null, ProtocolPriority.OPTIONAL);
            }
            if (DateHelper.before((Date)refDate, (Date)this.activeEmployment.getDateOfEntry())) {
                refDate = this.activeEmployment.getDateOfEntry();
            }
        }
        return refDate;
    }

    private void fillCurrentElo2Account(Date refDate) throws BusinessDomainException {
        Conjunction anFilter = this.getStandardReducedFilter();
        Elo2Account[] accounts = Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom")}, (Criterion)anFilter, (boolean)true);
        if (accounts != null && accounts.length > 0 && DateHelper.before((Date)this.validFrom, (Date)accounts[0].getValidFrom())) {
            this.validFrom = accounts[0].getValidFrom();
        }
        String employerTaxNumber = this.checkEmployerTaxNumber();
        if (this.mCurrentElo2Account == null) {
            this.mCurrentElo2Account = new Elo2Account(this.mEmployee);
            this.mCurrentElo2Account.setCreatedOn(VDate.formatCurrentDateAndTime((Date)this.creationDate));
            this.mCurrentElo2Account.setPCompany(this.mElo2Advice.getPCompany());
            this.mCurrentElo2Account.setPlant(this.mElo2Advice.getPlant());
            this.mCurrentElo2Account.setReasonOfDelivery(this.mElo2Advice.getReasonOfDelivery());
            this.mCurrentElo2Account.setTaxnumber(this.taxId);
            this.mCurrentElo2Account.setAdviceState(AdviceStateEnum.CREATED);
            this.mCurrentElo2Account.setEffectiveFrom(this.effectiveFrom);
            this.mCurrentElo2Account.setValidFrom(this.validFrom);
            this.mCurrentElo2Account.setOrdnungsMerkmal(this.mEmployee.getDomainKey());
            this.mCurrentElo2Account.setEmployerTaxNumber(employerTaxNumber);
            this.mergeWithSpecialValues();
            switch (this.mElo2Advice.getReasonOfDelivery().value()) {
                case 0: 
                case 4: {
                    Elo2Duean an = new Elo2Duean(this.mCurrentElo2Account);
                    this.fillEloAn(an, refDate);
                    break;
                }
                case 1: 
                case 5: {
                    Elo2Account[] anUms = this.queryLastAnOrUmmeldung(this.mCurrentElo2Account.getTaxnumber(), this.mCurrentElo2Account.getPCompany().getObjectid(), this.mCurrentElo2Account.getEmployee().getObjectid());
                    Date deviantRefDate = refDate;
                    if (anUms != null && anUms.length > 0) {
                        deviantRefDate = anUms[0].getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG || anUms[0].getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND ? anUms[0].getElo2Dueum().getRefDate() : anUms[0].getElo2Duean().getRefdatumag();
                    }
                    Elo2Dueab ab = new Elo2Dueab(this.mCurrentElo2Account);
                    this.fillEloAb(ab, deviantRefDate);
                    break;
                }
                case 2: 
                case 6: {
                    Elo2Dueum um = new Elo2Dueum(this.mCurrentElo2Account);
                    this.fillEloUm(um, this.currentDate);
                }
            }
        } else {
            if (!this.forManualCreation && this.mCurrentElo2Account.getIsManual()) {
                this.protocolCurrentManualAccount();
                return;
            }
            this.mCurrentElo2Account.setValidFrom(this.validFrom);
            this.mCurrentElo2Account.setTaxnumber(this.taxId);
            this.mCurrentElo2Account.setEffectiveFrom(this.effectiveFrom);
            this.mCurrentElo2Account.setEmployerTaxNumber(employerTaxNumber);
            this.mergeWithSpecialValues();
            this.mCurrentElo2Account.makeSaveable();
            switch (this.mElo2Advice.getReasonOfDelivery().value()) {
                case 0: 
                case 4: {
                    Elo2Duean an = this.mCurrentElo2Account.getElo2Duean();
                    if (an == null) {
                        an = new Elo2Duean(this.mCurrentElo2Account);
                    }
                    if (this.mCurrentElo2Account.getAdviceState() == AdviceStateEnum.READANSWERFAILED || this.mCurrentElo2Account.getAdviceState() == AdviceStateEnum.TRANSMITTED) {
                        this.fillEloAn(an, an.getRefdatumag());
                    } else {
                        Elo2Account[] abs = this.queryLastAbmeldung(this.mCurrentElo2Account.getTaxnumber(), this.mCurrentElo2Account.getPCompany().getObjectid(), this.mCurrentElo2Account.getEmployee().getObjectid());
                        Date deviantRefDate = null;
                        if (abs != null && abs.length > 0) {
                            if (abs[0].getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG || abs[0].getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND) {
                                if (abs[0].getElo2Dueum() != null) {
                                    deviantRefDate = abs[0].getElo2Dueum().getRefDate();
                                }
                            } else if (abs[0].getElo2Duean() != null) {
                                deviantRefDate = abs[0].getElo2Duean().getRefdatumag();
                            }
                        }
                        if (deviantRefDate == null || DateHelper.after((Date)refDate, (Date)deviantRefDate)) {
                            deviantRefDate = refDate;
                        }
                        this.fillEloAn(an, deviantRefDate);
                    }
                    an.makeSaveable();
                    break;
                }
                case 1: 
                case 5: {
                    Elo2Dueab ab = this.mCurrentElo2Account.getElo2Dueab();
                    if (ab == null) {
                        ab = new Elo2Dueab(this.mCurrentElo2Account);
                    }
                    if (this.mCurrentElo2Account.getAdviceState() == AdviceStateEnum.READANSWERFAILED || this.mCurrentElo2Account.getAdviceState() == AdviceStateEnum.CREATED) {
                        this.fillEloAb(ab, ab.getRefdatumag());
                    } else {
                        this.fillEloAb(ab, refDate);
                    }
                    ab.makeSaveable();
                    break;
                }
                case 2: 
                case 6: {
                    Elo2Dueum um = this.mCurrentElo2Account.getElo2Dueum();
                    if (um == null) {
                        um = new Elo2Dueum(this.mCurrentElo2Account);
                    }
                    if (this.mCurrentElo2Account.getAdviceState() == AdviceStateEnum.READANSWERFAILED) {
                        this.fillEloUm(um, um.getRefDate());
                    } else {
                        this.fillEloUm(um, this.currentDate);
                    }
                    um.makeSaveable();
                }
            }
        }
    }

    private String checkEmployerTaxNumber() throws BusinessDomainException {
        int bundesland = StringMapper.isNullString((String)this.mElo2Advice.getTaxOfficeKey()) ? 0 : Integer.parseInt(this.mElo2Advice.getTaxOfficeKey().substring(0, 2));
        Object employerTaxNumber = !StringMapper.isNullString((String)this.mElo2Advice.getPlantTaxNumber()) ? Elo2Transfer.getEmployerPartElsterTaxNumber((String)this.mElo2Advice.getPlantTaxNumber(), (int)bundesland) : Elo2Transfer.getEmployerPartElsterTaxNumber((String)this.mElo2Advice.getCompanyTaxNumber(), (int)bundesland);
        employerTaxNumber = this.mElo2Advice.getTaxOfficeKey() + "0" + (String)employerTaxNumber;
        if (((String)employerTaxNumber).length() > 13) {
            throw Elo2ExceptionMapper.makeEmployerTaxNumberTooLongDomainException((String)employerTaxNumber);
        }
        return employerTaxNumber;
    }

    protected Date checkDateForSixWeeks(Date currentRefDate) {
        if (DateHelper.getDiffInDays((Date)this.currentDate, (Date)currentRefDate) > 42) {
            return DateHelper.add((Date)this.currentDate, (int)-42);
        }
        return currentRefDate;
    }

    private void protocolCurrentManualAccount() {
        switch (this.mElo2Advice.getReasonOfDelivery().value()) {
            case 0: {
                Elo2Duean an = this.mCurrentElo2Account.getElo2Duean();
                this.addProtocolContent(null, (DetailMarker)an, ProtocolPriority.DUTY);
                break;
            }
            case 1: {
                Elo2Dueab ab = this.mCurrentElo2Account.getElo2Dueab();
                this.addProtocolContent(null, (DetailMarker)ab, ProtocolPriority.DUTY);
                break;
            }
            case 2: {
                Elo2Dueum um = this.mCurrentElo2Account.getElo2Dueum();
                this.addProtocolContent(null, (DetailMarker)um, ProtocolPriority.DUTY);
            }
        }
    }

    private Elo2Account[] queryLastAnOrUmmeldung(String anIdNr, String compObjectId, String oidEmployee) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"taxnumber", (String)anIdNr));
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)compObjectId));
        filter.add(Restrictions.in((String)"reasonofdelivery", (String[])new String[]{ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG), ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND), ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG), ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND)}));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom"), Order.desc((String)"createdon")}, (Criterion)filter, (boolean)false);
    }

    private Elo2Account[] queryLastAbmeldung(String anIdNr, String compObjectId, String oidEmployee) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"taxnumber", (String)anIdNr));
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)compObjectId));
        filter.add(Restrictions.in((String)"reasonofdelivery", (String[])new String[]{ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ABMELDUNG), ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND)}));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom"), Order.desc((String)"createdon")}, (Criterion)filter, (boolean)false);
    }

    private Date checkPreviousYearsForRefDate(Date refDate) {
        Date firstOfCurrentYear;
        if (DateHelper.before((Date)this.currentDate, (Date)this.firstMarch)) {
            Calendar cal = GMTCalendar.getInstance();
            cal.setTime(this.currentDate);
            cal.add(1, -1);
            Date prevYear = cal.getTime();
            Date firstDayOfPrevYear = DateHelper.getFirstDayOfYear((Date)prevYear);
            if (DateHelper.before((Date)refDate, (Date)firstDayOfPrevYear)) {
                return firstDayOfPrevYear;
            }
        }
        if (DateHelper.afterOrEqual((Date)this.currentDate, (Date)this.firstMarch) && DateHelper.before((Date)refDate, (Date)(firstOfCurrentYear = DateHelper.getFirstDayOfYear((Date)this.currentDate)))) {
            return firstOfCurrentYear;
        }
        return refDate;
    }

    private void doFirstGeneralChecks() {
        if (StringMapper.isNullString((String)this.taxId) && !this.noElstam && !this.isLumpSum(this.tax) && this.isWithDrawalNecessary()) {
            this.addProtocolContent("Steuer-ID fehlt", null, ProtocolPriority.OPTIONAL);
        }
        if (this.master != null) {
            if (StringMapper.isNullString((String)this.master.getDateOfBirthELSTAM())) {
                if (this.master.getDateOfBirth() == null) {
                    this.addProtocolContent("Geburtsdatum fehlt", null, ProtocolPriority.OPTIONAL);
                }
            } else if (!this.isFormatOfDeviantBirthDateCorrect(this.master.getDateOfBirthELSTAM())) {
                this.addProtocolContent("Abw. melderechtliches Geb.-Datum ist nicht korrekt.", null, ProtocolPriority.OPTIONAL);
            }
        }
        if (this.noElstam && this.mElo2Advice.getReasonOfDelivery() != ReasonOfDeliveryEnum.ABMELDUNG) {
            this.addProtocolContent("Nimmt nicht am Elstam-Verfahren teil", null, ProtocolPriority.OPTIONAL);
        }
    }

    private void doGeneralChecks(boolean isSpecialAccess) throws BusinessDomainException {
        if (isSpecialAccess && this.mEmployee.getSpecialAccess()) {
            this.addProtocolContent("Mitarbeiter mit spez. Zugriffschutz", null, ProtocolPriority.OPTIONAL);
        }
        if (this.tax == null) {
            this.addProtocolContent("F\u00fcr den Mitarbeiter konnte kein g\u00fcltiger Satz in der Besteuerung gefunden werden", null, ProtocolPriority.OPTIONAL);
            return;
        }
        this.doFirstGeneralChecks();
        if (this.isLumpSumAndNotDeregistration()) {
            this.addProtocolContent("Pauschalbesteuert", null, ProtocolPriority.OPTIONAL);
        }
        if (DateHelper.after((Date)this.activeEmployment.getDateOfEntry(), (Date)new VDate().getDate())) {
            this.addProtocolContent("Besch\u00e4ftigungsbeginn liegt in der Zukunft", null, ProtocolPriority.OPTIONAL);
        }
    }

    private boolean isLumpSumAndNotDeregistration() {
        return this.tax != null && this.tax.getTaxBracket() == 0 && !ReasonOfDeliveryEnum.ABMELDUNG.equals(this.mElo2Advice.getReasonOfDelivery());
    }

    private boolean isFormatOfDeviantBirthDateCorrect(String dateOfBirthELSTAM) {
        Matcher matcher = DEVIANTBIRTH_PATTERN.matcher(dateOfBirthELSTAM);
        return matcher.matches();
    }

    private void doChecksByReasonOfDelivery() throws BusinessDomainException {
        if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.ANMELDUNG) {
            this.doChecksForAnmeldung();
        } else if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.ABMELDUNG) {
            this.doChecksForAbmeldung();
        } else if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG) {
            this.doChecksForUmmeldung();
        } else if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.ELSTAM) {
            this.doChecksForElstam();
        } else if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND) {
            this.doChecksForUmmeldungSonstigerGrund();
        } else if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND) {
            this.doChecksForAbmeldungSonstigerGrund();
        } else if (this.mElo2Advice.getReasonOfDelivery() == ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND) {
            this.doChecksForAnmeldungSonstigerGrund();
        }
    }

    protected void doChecksForAnmeldungSonstigerGrund() throws BusinessDomainException {
    }

    protected void doChecksForAbmeldungSonstigerGrund() throws BusinessDomainException {
    }

    protected void doChecksForUmmeldungSonstigerGrund() throws BusinessDomainException {
    }

    private void doChecksForElstam() {
        this.createAccount = true;
    }

    protected void doChecksForUmmeldung() {
        if (DateHelper.equal((Date)this.mElo2Advice.getCompanyCalucationStart(), (Date)this.mElo2Advice.getElo2Start()) && DateHelper.before((Date)this.activeEmployment.getDateOfEntry(), (Date)this.mElo2Advice.getElo2Start()) && this.mElo2Advice.getReRegisterBecauseSystemChange()) {
            if (this.activeEmployment.getDateOfWithDrawal() != null && DateHelper.before((Date)this.activeEmployment.getDateOfWithDrawal(), (Date)this.currentDate)) {
                return;
            }
            this.createAccount = true;
            return;
        }
        if (!this.reRegister) {
            return;
        }
        if (!DateHelper.before((Date)this.mElo2Advice.getCompanyCalucationStart(), (Date)this.activeEmployment.getDateOfEntry())) {
            return;
        }
        this.createAccount = true;
    }

    protected void doChecksForAbmeldung() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.taxId) && (!this.isWithDrawalNecessary() || this.isLumpSum(this.tax) || this.noElstam)) {
            return;
        }
        Elo2Account[] anmeldungen = null;
        Elo2Account[] abmeldungen = null;
        Elo2Account[] anfragen = null;
        if (this.activeEmployment.getDateOfWithDrawal() != null) {
            abmeldungen = this.accountsByType.get(ReasonOfDeliveryEnum.ABMELDUNG);
            anmeldungen = this.accountsByType.get(ReasonOfDeliveryEnum.ANMELDUNG);
            anfragen = this.accountsByType.get(ReasonOfDeliveryEnum.ELSTAM);
            Elo2Account anm = null;
            Elo2Account meldung = null;
            if (anmeldungen != null && anmeldungen.length > 0) {
                anm = anmeldungen[0];
            }
            meldung = anm;
            Elo2Account umm = null;
            if (this.mEloUmmeldungen != null && this.mEloUmmeldungen.length > 0) {
                umm = this.mEloUmmeldungen[0];
            }
            if (anm == null || umm != null && DateHelper.after((Date)umm.getValidFrom(), (Date)anm.getValidFrom())) {
                meldung = umm;
            }
            Elo2Account anfrage = null;
            if (anfragen != null && anfragen.length > 0) {
                anfrage = anfragen[0];
            }
            if (DateHelper.after((Date)this.activeEmployment.getDateOfWithDrawal(), (Date)this.currentDate) && !this.isLumpSum(this.tax) && !this.isTaxChange(this.tax, meldung, anfrage)) {
                this.addProtocolContent("Austritt des Mitarbeiters liegt in der Zukunft und darf noch nicht gemeldet werden", null, ProtocolPriority.OPTIONAL);
            } else {
                if (this.isLumpSum(this.tax) || this.isTaxChange(this.tax, meldung, anfrage)) {
                    this.deviantDateOfWithdrawal = DateHelper.add((Date)this.tax.getValidFrom(), (int)-1);
                    if (DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)this.activeEmployment.getDateOfEntry())) {
                        this.deviantDateOfWithdrawal = DateHelper.add((Date)this.activeEmployment.getDateOfEntry(), (int)1);
                    }
                }
                if (abmeldungen == null || abmeldungen.length == 0) {
                    if (!(anmeldungen != null && anmeldungen.length != 0 || this.mEloUmmeldungen != null && this.mEloUmmeldungen.length != 0)) {
                        return;
                    }
                    if (anfrage == null || !this.isTaxChangedByElstam(this.tax, anfrage) || this.dateWithDrawalIsAfter(this.deviantDateOfWithdrawal, this.activeEmployment.getDateOfWithDrawal(), anfrage)) {
                        this.createAccount = true;
                        return;
                    }
                }
                Elo2Account ab = null;
                if (abmeldungen != null && abmeldungen.length > 0) {
                    ab = abmeldungen[0];
                }
                anm = null;
                umm = null;
                if (anmeldungen != null && anmeldungen.length > 0 && (anm = anmeldungen[0]) != null && DateHelper.after((Date)anm.getValidFrom(), (Date)this.validFrom)) {
                    this.validFrom = anm.getValidFrom();
                }
                if (this.mEloUmmeldungen != null && this.mEloUmmeldungen.length > 0) {
                    umm = this.mEloUmmeldungen[0];
                }
                if (this.mEloUmmeldungen != null && this.mEloUmmeldungen.length > 0 && (umm == null || DateHelper.after((Date)this.mEloUmmeldungen[0].getValidFrom(), (Date)umm.getValidFrom()))) {
                    umm = this.mEloUmmeldungen[0];
                }
                if (anm != null && (umm == null || DateHelper.after((Date)anm.getValidFrom(), (Date)umm.getValidFrom()))) {
                    if ((ab == null || DateHelper.after((Date)anm.getValidFrom(), (Date)ab.getValidFrom()) || DateHelper.equal((Date)anm.getValidFrom(), (Date)ab.getValidFrom()) && !DateHelper.equal((Date)anm.getElo2Duean().getRefdatumag(), (Date)ab.getElo2Dueab().getRefdatumag())) && !this.isDifferentRefDateByElstam(anfrage, anm, ab) && (anfrage == null || !this.isTaxChangedByElstam(this.tax, anfrage) || this.dateWithDrawalIsAfter(this.deviantDateOfWithdrawal, this.activeEmployment.getDateOfWithDrawal(), anfrage))) {
                        this.createAccount = true;
                        return;
                    }
                } else if (umm != null && (ab == null || anm != null && DateHelper.after((Date)anm.getValidFrom(), (Date)ab.getValidFrom()) && DateHelper.after((Date)umm.getValidFrom(), (Date)ab.getValidFrom()) || DateHelper.equal((Date)umm.getValidFrom(), (Date)ab.getValidFrom()) && !DateHelper.equal((Date)umm.getElo2Dueum().getRefDate(), (Date)ab.getElo2Dueab().getRefdatumag())) && !this.isDifferentRefDateByElstam(anfrage, anm, ab) && (anfrage == null || !this.isTaxChangedByElstam(this.tax, anfrage) || this.dateWithDrawalIsAfter(this.deviantDateOfWithdrawal, this.activeEmployment.getDateOfWithDrawal(), anfrage))) {
                    this.validFrom = umm.getValidFrom();
                    this.createAccount = true;
                    return;
                }
            }
        } else {
            boolean abmExists;
            Elo2Account anfrage;
            Tax[] taxHist;
            anmeldungen = this.accountsByType.get(ReasonOfDeliveryEnum.ANMELDUNG);
            abmeldungen = this.accountsByType.get(ReasonOfDeliveryEnum.ABMELDUNG);
            anfragen = this.accountsByType.get(ReasonOfDeliveryEnum.ELSTAM);
            if (anmeldungen != null && anmeldungen.length > 0) {
                Elo2Account anm = anmeldungen[0];
                if (anm != null && DateHelper.after((Date)anm.getValidFrom(), (Date)this.validFrom)) {
                    this.validFrom = anm.getValidFrom();
                }
                for (Tax taxH : taxHist = this.getTaxHistory()) {
                    if (!DateHelper.afterOrEqual((Date)taxH.getValidFrom(), (Date)this.activeEmployment.getDateOfEntry()) || !DateHelper.afterOrEqual((Date)this.currentDate, (Date)taxH.getValidFrom())) continue;
                    anfrage = null;
                    if (anfragen != null && anfragen.length > 0) {
                        anfrage = anfragen[0];
                    }
                    if (!this.isTaxChangedSinceLastMeldung(taxH, anfrage != null && DateHelper.after((Date)anfrage.getValidFrom(), (Date)anm.getValidFrom()) ? anfrage : anm)) continue;
                    this.deviantDateOfWithdrawal = DateHelper.add((Date)DateHelper.getFirstDayOfMonth((Date)taxH.getValidFrom()), (int)-1);
                    if (DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)anm.getElo2Duean().getBeschbeginn())) {
                        this.deviantDateOfWithdrawal = DateHelper.add((Date)anm.getElo2Duean().getBeschbeginn(), (int)1);
                    }
                    if (DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)anm.getElo2Duean().getBeschbeginn()) || DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)this.mElo2Advice.getElo2Start()) || DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)anm.getElo2Duean().getRefdatumag())) continue;
                    this.deviantDateOfEntry = anm.getElo2Duean().getBeschbeginn();
                    abmExists = false;
                    if (abmeldungen != null && abmeldungen.length > 0) {
                        if (DateHelper.equal((Date)abmeldungen[0].getElo2Dueab().getBeschbeginn(), (Date)this.deviantDateOfEntry)) {
                            abmExists = true;
                            break;
                        }
                        if (DateHelper.equal((Date)taxH.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.deviantDateOfEntry)) && DateHelper.equal((Date)abmeldungen[0].getElo2Dueab().getBeschende(), (Date)DateHelper.add((Date)this.deviantDateOfEntry, (int)-1))) {
                            abmExists = true;
                            break;
                        }
                        for (Elo2Account abm : abmeldungen) {
                            if (!DateHelper.equal((Date)abm.getElo2Dueab().getBeschende(), (Date)this.deviantDateOfWithdrawal)) continue;
                            abmExists = true;
                            break;
                        }
                    }
                    if (!abmExists) {
                        boolean perAnfrage = false;
                        if (anfragen != null && anfragen.length > 0 && this.isTaxChangedByElstam(taxH, anfragen[0]) && !this.isLumpSum(taxH)) {
                            perAnfrage = true;
                            break;
                        }
                        if (!perAnfrage) {
                            this.tax = taxH;
                            this.createAccount = true;
                        } else if (anfragen != null && anfragen.length > 0 && !this.isTaxChangedByElstam(this.mEmployee.getTaxOrNull(this.maxDate, this.maxDate), anfragen[0])) {
                            this.createAccount = true;
                        }
                    }
                    return;
                }
                if (abmeldungen == null || abmeldungen.length < 1 || DateHelper.after((Date)anm.getValidFrom(), (Date)abmeldungen[0].getValidFrom()) || DateHelper.equal((Date)anm.getValidFrom(), (Date)abmeldungen[0].getValidFrom()) && !DateHelper.equal((Date)anm.getElo2Duean().getRefdatumag(), (Date)abmeldungen[0].getElo2Dueab().getRefdatumag())) {
                    Employment emp;
                    Date validFrom = anm.getValidFrom();
                    if (DateHelper.before((Date)validFrom, (Date)anm.getElo2Duean().getBeschbeginn())) {
                        validFrom = anm.getElo2Duean().getBeschbeginn();
                    }
                    try {
                        emp = this.mEmployee.getEmployment(anm.getEffectiveFrom(), validFrom);
                    }
                    catch (BusinessDomainException e) {
                        if (e.getErrorNumber() == 5009) {
                            emp = this.mEmployee.getEmployment(DateHelper.getFirstDayOfMonth((Date)DateHelper.addMonths((Date)anm.getEffectiveFrom(), (int)1)), validFrom);
                        }
                        throw e;
                    }
                    if (DateHelper.after((Date)this.activeEmployment.getDateOfEntry(), (Date)emp.getDateOfEntry()) && !DateHelper.equal((Date)this.activeEmployment.getDateOfEntry(), (Date)anm.getElo2Duean().getBeschbeginn())) {
                        this.deviantDateOfWithdrawal = emp.getDateOfEntry();
                        this.activeEmployment = emp;
                        this.createAccount = true;
                    }
                }
            }
            if (this.mEloUmmeldungen != null && this.mEloUmmeldungen.length > 0) {
                Elo2Account umm = this.mEloUmmeldungen[0];
                if (umm != null && DateHelper.after((Date)umm.getValidFrom(), (Date)this.validFrom)) {
                    this.validFrom = umm.getValidFrom();
                }
                for (Tax taxH : taxHist = this.getTaxHistory()) {
                    if (!DateHelper.afterOrEqual((Date)taxH.getValidFrom(), (Date)umm.getElo2Dueum().getRefDate()) || !DateHelper.afterOrEqual((Date)this.currentDate, (Date)taxH.getValidFrom())) continue;
                    anfrage = null;
                    if (anfragen != null && anfragen.length > 0) {
                        anfrage = anfragen[0];
                    }
                    if (!this.isTaxChangedSinceLastMeldung(taxH, anfrage != null && DateHelper.after((Date)anfrage.getValidFrom(), (Date)umm.getValidFrom()) ? anfrage : umm)) continue;
                    this.deviantDateOfWithdrawal = DateHelper.add((Date)DateHelper.getFirstDayOfMonth((Date)taxH.getValidFrom()), (int)-1);
                    if (DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)umm.getElo2Dueum().getRefDate())) {
                        this.deviantDateOfWithdrawal = DateHelper.add((Date)umm.getElo2Dueum().getRefDate(), (int)1);
                    }
                    if (DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)this.mElo2Advice.getElo2Start()) || DateHelper.before((Date)this.deviantDateOfWithdrawal, (Date)umm.getElo2Dueum().getRefDate())) continue;
                    abmExists = false;
                    if (abmeldungen != null && abmeldungen.length > 0) {
                        if (DateHelper.afterOrEqual((Date)abmeldungen[0].getElo2Dueab().getRefdatumag(), (Date)umm.getElo2Dueum().getRefDate())) {
                            abmExists = true;
                            break;
                        }
                        if (DateHelper.after((Date)abmeldungen[0].getValidFrom(), (Date)umm.getValidFrom())) {
                            abmExists = true;
                            break;
                        }
                        for (Elo2Account abm : abmeldungen) {
                            if (!DateHelper.equal((Date)abm.getElo2Dueab().getBeschende(), (Date)this.deviantDateOfWithdrawal)) continue;
                            abmExists = true;
                            break;
                        }
                    }
                    if (!abmExists) {
                        boolean perAnfrage = false;
                        if (anfragen != null && anfragen.length > 0 && this.isTaxChangedByElstam(taxH, anfragen[0]) && !this.isLumpSum(taxH)) {
                            perAnfrage = true;
                            break;
                        }
                        if (!perAnfrage) {
                            this.tax = taxH;
                            this.createAccount = true;
                        } else if (anfragen != null && anfragen.length > 0 && !this.isTaxChangedByElstam(this.mEmployee.getTaxOrNull(this.maxDate, this.maxDate), anfragen[0])) {
                            this.createAccount = true;
                        }
                    }
                    return;
                }
            }
        }
    }

    private boolean dateWithDrawalIsAfter(Date deviantDateOfWdrawal, Date dateOfWithdrawal, Elo2Account elstam) {
        if (elstam != null && elstam.getElo2Elstam() != null) {
            if (deviantDateOfWdrawal != null && DateHelper.after((Date)deviantDateOfWdrawal, (Date)elstam.getElo2Elstam().getGueltigab()) && !DateHelper.after((Date)deviantDateOfWdrawal, (Date)this.currentDate)) {
                return true;
            }
            if (dateOfWithdrawal != null && !DateHelper.after((Date)dateOfWithdrawal, (Date)this.currentDate)) {
                this.deviantDateOfWithdrawal = dateOfWithdrawal;
                return true;
            }
        }
        return false;
    }

    private boolean isLumpSum(Tax tax) {
        if (tax == null) {
            return false;
        }
        return DateHelper.beforeOrEqual((Date)tax.getValidFrom(), (Date)this.currentDate) && tax.isLumpSum();
    }

    private boolean isWithDrawalNecessary() {
        Date withDrawal = this.activeEmployment.getDateOfWithDrawal();
        return withDrawal == null || !DateHelper.before((Date)DateHelper.addMonths((Date)withDrawal, (int)6), (Date)this.currentDate);
    }

    private boolean isDifferentRefDateByElstam(Elo2Account anfrage, Elo2Account anm, Elo2Account ab) {
        if (anfrage == null || ab == null || anm == null) {
            return false;
        }
        return !DateHelper.after((Date)anm.getValidFrom(), (Date)ab.getValidFrom()) && (!DateHelper.equal((Date)anm.getValidFrom(), (Date)ab.getValidFrom()) || !DateHelper.after((Date)anm.getElo2Duean().getRefdatumag(), (Date)ab.getElo2Dueab().getRefdatumag())) && DateHelper.equal((Date)anfrage.getValidFrom(), (Date)ab.getValidFrom());
    }

    private boolean isTaxChange(Tax tax, Elo2Account meldung, Elo2Account anfrage) throws BusinessDomainException {
        if (tax == null) {
            return false;
        }
        Elo2Account toCheck = meldung;
        if (meldung == null || anfrage != null && DateHelper.after((Date)anfrage.getValidFrom(), (Date)meldung.getValidFrom())) {
            toCheck = anfrage;
        }
        if (toCheck == null) {
            return false;
        }
        return DateHelper.beforeOrEqual((Date)tax.getValidFrom(), (Date)this.currentDate) && this.isTaxChangedSinceLastMeldung(tax, toCheck);
    }

    private boolean isTaxChangedSinceLastMeldung(Tax taxHist, Elo2Account meldung) throws BusinessDomainException {
        Date date = meldung.getValidFrom();
        if (meldung.getElo2Duean() != null) {
            date = meldung.getElo2Duean().getRefdatumag();
        }
        if (DateHelper.before((Date)taxHist.getValidFrom(), (Date)date)) {
            return false;
        }
        if (ReasonOfDeliveryEnum.ANMELDUNG.equals(meldung.getReasonOfDelivery()) || ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND.equals(meldung.getReasonOfDelivery()) || ReasonOfDeliveryEnum.UMMELDUNG.equals(meldung.getReasonOfDelivery()) || ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND.equals(meldung.getReasonOfDelivery())) {
            boolean isAnmHag = false;
            if (meldung.getElo2Duean() != null) {
                isAnmHag = BooleanMapper.toBoolean((String)meldung.getElo2Duean().getHauptag());
            }
            if (meldung.getElo2Dueum() != null) {
                Tax tax = this.mEmployee.getTax(this.maxDate, DateHelper.before((Date)meldung.getValidFrom(), (Date)this.mElo2Advice.getCompanyCalucationStart()) ? this.mElo2Advice.getCompanyCalucationStart() : meldung.getValidFrom());
                boolean bl = isAnmHag = !tax.getSidelineEmployer();
            }
            if (taxHist.getSidelineEmployer() == isAnmHag) {
                return true;
            }
        } else if (ReasonOfDeliveryEnum.ELSTAM.equals(meldung.getReasonOfDelivery()) && meldung.getElo2Elstam() != null) {
            int skelstam = meldung.getElo2Elstam().getSteuerklasse();
            int sktax = taxHist.getTaxBracket();
            if (skelstam == 6 && sktax < 6 || skelstam < 6 && sktax == 6) {
                return true;
            }
        }
        if (taxHist.getNoElstam()) {
            return true;
        }
        if (taxHist.getTaxBracket() == 0) {
            return true;
        }
        return taxHist.isLumpSum();
    }

    private boolean isTaxChangedByElstam(Tax taxHist, Elo2Account elstam) {
        if (elstam == null || taxHist == null || taxHist.getValidFrom() == null || elstam.getValidFrom() == null || DateHelper.after((Date)taxHist.getValidFrom(), (Date)elstam.getValidFrom())) {
            return false;
        }
        return taxHist != null && taxHist.getTaxBracket() == 6 && elstam != null && elstam.getElo2Elstam() != null && elstam.getElo2Elstam().getSteuerklasse() == 6;
    }

    private boolean isTaxChanged(Tax taxHist, Tax taxActive) {
        if (taxHist.getTaxBracket() == 0 && taxActive.getTaxBracket() > 0) {
            return true;
        }
        return taxHist.getNoElstam() && !taxActive.getNoElstam();
    }

    protected void doChecksForAnmeldung() throws BusinessDomainException {
        Elo2Account acc;
        if (this.reRegister) {
            this.addProtocolContent("F\u00fcr diesen Mitarbeiter muss eine Ummeldung aufgebaut werden", null, ProtocolPriority.OPTIONAL);
            return;
        }
        if (!this.isInEmployment(this.currentDate)) {
            if (this.isWithDrawalNecessary()) {
                this.addProtocolContent("Mitarbeiter hat keine aktive Besch\u00e4ftigung", null, ProtocolPriority.OPTIONAL);
            }
            return;
        }
        if (this.tax != null && DateHelper.before((Date)this.currentDate, (Date)this.tax.getValidFrom())) {
            this.addProtocolContent("Das G\u00fcltig-ab der aktuellen Steuer liegt in der Zukunft", null, ProtocolPriority.OPTIONAL);
            return;
        }
        Elo2Account[] anmeldungen = this.accountsByType.get(ReasonOfDeliveryEnum.ANMELDUNG);
        if (!(anmeldungen != null && anmeldungen.length != 0 || this.mEloUmmeldungen != null && this.mEloUmmeldungen.length != 0)) {
            Tax taxByEloStart;
            if (DateHelper.equal((Date)this.mElo2Advice.getCompanyCalucationStart(), (Date)this.mElo2Advice.getElo2Start()) && DateHelper.before((Date)this.activeEmployment.getDateOfEntry(), (Date)this.mElo2Advice.getElo2Start()) && this.mElo2Advice.getReRegisterBecauseSystemChange() && !this.isTaxChanged(taxByEloStart = this.mEmployee.getTax(this.maxDate, this.mElo2Advice.getElo2Start()), this.tax)) {
                if (this.mEloUmmeldungen == null || this.mEloUmmeldungen.length < 1) {
                    this.addProtocolContent("F\u00fcr diesen Mitarbeiter muss eine Ummeldung aufgebaut werden", null, ProtocolPriority.OPTIONAL);
                    return;
                }
                return;
            }
            this.createAccount = true;
            return;
        }
        for (Elo2Account acc2 : anmeldungen) {
            if (acc2.getAdviceState() != AdviceStateEnum.READANSWERFAILED || acc2.getValidUntil() == null) continue;
            acc2.setValidUntil(this.currentDate);
            acc2.makeSaveable();
            this.createAccount = true;
            return;
        }
        Elo2Account[] abmeldungen = this.accountsByType.get(ReasonOfDeliveryEnum.ABMELDUNG);
        if (abmeldungen != null && abmeldungen.length > 0) {
            Elo2Account lastAnm;
            Elo2Account abm = abmeldungen[0];
            if (anmeldungen.length > 0 && (DateHelper.after((Date)(lastAnm = anmeldungen[0]).getValidFrom(), (Date)abm.getValidFrom()) || DateHelper.equal((Date)lastAnm.getValidFrom(), (Date)abm.getValidFrom()) && !DateHelper.equal((Date)lastAnm.getElo2Duean().getRefdatumag(), (Date)abm.getElo2Dueab().getRefdatumag()))) {
                return;
            }
            Employment[] emplHist = this.getEmploymentHistory();
            Tax[] taxHist = this.getTaxHistory();
            Arrays.sort(taxHist, new TaxComparator());
            for (int i = 0; i < taxHist.length; ++i) {
                if (abm.getElo2Dueab().getBeschende() == null || !DateHelper.before((Date)abm.getElo2Dueab().getBeschende(), (Date)taxHist[i].getValidFrom()) || DateHelper.getDiffInDays((Date)taxHist[i].getValidFrom(), (Date)abm.getElo2Dueab().getBeschende()) != 1 || taxHist[i].getTaxBracket() <= 0) continue;
                Employment[] employmentArray = emplHist;
                int n = employmentArray.length;
                for (int j = 0; j < n; ++j) {
                    Employment employm = employmentArray[j];
                    if (!DateHelper.beforeOrEqual((Date)employm.getDateOfEntry(), (Date)taxHist[i].getValidFrom()) || !DateHelper.afterOrEqual((Date)employm.getValidFrom(), (Date)taxHist[i].getValidFrom())) continue;
                    this.deviantDateOfEntry = taxHist[i].getValidFrom();
                    boolean anmExists = false;
                    for (Elo2Account anm : anmeldungen) {
                        if (!DateHelper.equal((Date)anm.getElo2Duean().getBeschbeginn(), (Date)this.deviantDateOfEntry)) continue;
                        anmExists = true;
                        break;
                    }
                    if (anmExists) continue;
                    this.tax = taxHist[i];
                    this.activeEmployment = employm;
                    if (this.tax.getNoElstam()) {
                        this.addProtocolContent("R\u00fcckwirkende Anmeldung wegen Wechsel in Besteuerungsmerkmal nicht m\u00f6glich. Mitarbeiter nimmt nicht am Elstam-Verfahren teil", null, ProtocolPriority.OPTIONAL);
                        continue;
                    }
                    this.createAccount = true;
                    return;
                }
            }
            for (Employment employm : emplHist) {
                if (abm.getElo2Dueab().getBeschende() == null || !DateHelper.after((Date)employm.getDateOfEntry(), (Date)abm.getElo2Dueab().getBeschende())) continue;
                if (anmeldungen.length == 0) {
                    this.activeEmployment = employm;
                    for (Tax taxH : taxHist) {
                        if (!taxH.inValidness(this.activeEmployment.getDateOfEntry())) continue;
                        this.tax = taxH;
                        break;
                    }
                    this.createAccount = true;
                    return;
                }
                if (!DateHelper.equal((Date)anmeldungen[0].getElo2Duean().getBeschbeginn(), (Date)abm.getElo2Dueab().getBeschbeginn())) continue;
                this.activeEmployment = employm;
                for (Tax taxH : taxHist) {
                    if (!taxH.inValidness(this.activeEmployment.getDateOfEntry())) continue;
                    this.tax = taxH;
                    break;
                }
                this.createAccount = true;
                return;
            }
            if (anmeldungen.length < 1 || DateHelper.after((Date)abm.getValidFrom(), (Date)anmeldungen[0].getValidFrom()) || DateHelper.equal((Date)abm.getValidFrom(), (Date)anmeldungen[0].getValidFrom()) && DateHelper.equal((Date)abm.getElo2Dueab().getRefdatumag(), (Date)anmeldungen[0].getElo2Duean().getRefdatumag())) {
                Employment actEmp;
                Date beschEnde = abm.getElo2Dueab().getBeschende();
                Employment emp = this.mEmployee.getEmployment(this.maxDate, abm.getValidFrom());
                if (beschEnde == null) {
                    beschEnde = emp.getDateOfWithDrawal();
                }
                if ((actEmp = this.mEmployee.getEmployment(this.maxDate, this.maxDate)).getDateOfWithDrawal() == null || DateHelper.after((Date)actEmp.getDateOfWithDrawal(), (Date)(beschEnde != null ? beschEnde : this.currentDate))) {
                    if (beschEnde != null && DateHelper.equal((Date)actEmp.getDateOfEntry(), (Date)emp.getDateOfEntry())) {
                        this.deviantDateOfEntry = DateHelper.add((Date)beschEnde, (int)1);
                    }
                    if (this.deviantDateOfEntry == null || DateHelper.beforeOrEqual((Date)this.deviantDateOfEntry, (Date)this.currentDate)) {
                        this.createAccount = true;
                        return;
                    }
                }
            }
        }
        if (anmeldungen.length > 0 && (acc = anmeldungen[0]).getPlant() != null) {
            Plant p = acc.getPlant();
            Foundations pfAcc = p.getPlantFoundations(acc.getEffectiveFrom(), acc.getValidFrom()).getFoundations();
            Foundations pfNow = p.getPlantFoundations(this.effectiveFrom, this.validFrom).getFoundations();
            if (pfAcc.getFederalState().getFederalState() != pfNow.getFederalState().getFederalState()) {
                this.createAccount = true;
                acc.setValidUntil(this.currentDate);
                acc.makeSaveable();
                return;
            }
        }
    }

    public String getEmployeeTaxId() {
        return this.taxId;
    }

    private void fillEloUm(Elo2Dueum um, Date refDate) {
        um.setAngebdat(this.master.getDateOfBirth());
        um.setAnidnr(this.taxId);
        um.setOrdnungsmerkmal(this.mEmployee.getDomainKey());
        um.setRefDate(DateHelper.correctDate((Date)refDate));
        um.setArgbStId(this.mCurrentElo2Account.getEmployerTaxNumber());
        um.setDateOfBirthElstam(this.master.getDateOfBirthELSTAM());
        this.fillSpecialUMFields(um);
        this.addProtocolContent(null, (DetailMarker)um, ProtocolPriority.DUTY);
    }

    private void fillEloAb(Elo2Dueab ab, Date refDate) {
        ab.setAngebdat(this.master.getDateOfBirth());
        ab.setAnidnr(this.taxId);
        if (this.deviantDateOfEntry != null) {
            ab.setBeschbeginn(this.deviantDateOfEntry);
            this.deviantDateOfEntry = null;
        } else {
            ab.setBeschbeginn(this.activeEmployment.getDateOfEntry());
        }
        if (this.deviantDateOfWithdrawal != null) {
            ab.setBeschende(this.deviantDateOfWithdrawal);
            this.deviantDateOfWithdrawal = null;
        } else {
            ab.setBeschende(this.activeEmployment.getDateOfWithDrawal());
        }
        ab.setOrdnungsmerkmal(this.mEmployee.getDomainKey());
        ab.setStorno("F");
        ab.setRefdatumag(refDate);
        ab.setArbgStId(this.mCurrentElo2Account.getEmployerTaxNumber());
        ab.setDateOfBirthElstam(this.master.getDateOfBirthELSTAM());
        this.fillSpecialABFields(ab);
        this.addProtocolContent(null, (DetailMarker)ab, ProtocolPriority.DUTY);
    }

    public abstract void fillSpecialABFields(Elo2Dueab var1);

    public abstract void fillSpecialANFields(Elo2Duean var1);

    public abstract void fillSpecialUMFields(Elo2Dueum var1);

    private void fillEloAn(Elo2Duean an, Date refDate) {
        an.setAngebdat(this.master.getDateOfBirth());
        an.setAnidnr(this.taxId);
        if (this.deviantDateOfEntry != null) {
            an.setBeschbeginn(this.deviantDateOfEntry);
            this.deviantDateOfEntry = null;
        } else {
            an.setBeschbeginn(this.activeEmployment.getDateOfEntry());
        }
        Tax taxToUse = null;
        for (Tax each : this.getTaxHistory()) {
            if (!DateHelper.afterOrEqual((Date)each.getValidFrom(), (Date)an.getBeschbeginn()) || each.getTaxBracket() <= 0 || each.getNoElstam()) continue;
            taxToUse = each;
            break;
        }
        if (taxToUse != null) {
            an.setHauptag(BooleanMapper.toString((!taxToUse.getSidelineEmployer() ? 1 : 0) != 0));
            if (taxToUse.getSidelineEmployer()) {
                an.setWunschfreibetrag(taxToUse.getFreeAllowanceYY());
            }
        } else {
            an.setHauptag(BooleanMapper.toString((!this.tax.getSidelineEmployer() ? 1 : 0) != 0));
            if (this.tax.getSidelineEmployer()) {
                an.setWunschfreibetrag(this.tax.getFreeAllowanceYY());
            }
        }
        an.setOrdnungsmerkmal(this.mEmployee.getDomainKey());
        an.setStorno("F");
        if (DateHelper.before((Date)refDate, (Date)an.getBeschbeginn())) {
            refDate = an.getBeschbeginn();
        }
        an.setRefdatumag(refDate);
        an.setArbgStId(this.mCurrentElo2Account.getEmployerTaxNumber());
        an.setDateOfBirthElstam(this.master.getDateOfBirthELSTAM());
        this.fillSpecialANFields(an);
        this.addProtocolContent(null, (DetailMarker)an, ProtocolPriority.DUTY);
    }

    public Master getMaster(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return this.mEmployee.getMaster(effectiveFrom, validFrom);
    }

    public boolean isInEmployment(Date validFrom) {
        if (this.activeEmployment == null) {
            return false;
        }
        Date start = this.activeEmployment.getDateOfEntry();
        if (DateHelper.after((Date)start, (Date)this.currentDate)) {
            return false;
        }
        Date end = this.activeEmployment.getDateOfWithDrawal();
        if (end == null || DateHelper.after((Date)end, (Date)validFrom) || this.isNecessary(start, end)) {
            return true;
        }
        return DateHelper.getDiffInDays((Date)validFrom, (Date)end) < 42;
    }

    private boolean isNecessary(Date start, Date end) {
        if (DateHelper.getYear((Date)end) < DateHelper.getYear((Date)this.currentDate)) {
            if (DateHelper.getYear((Date)end) == DateHelper.getYear((Date)this.currentDate) - 1) {
                if (DateHelper.getMonth((Date)this.currentDate) <= 2) {
                    return DateHelper.getYear((Date)start) == DateHelper.getYear((Date)this.currentDate) - 1;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    protected void addProtocolContent(String message, DetailMarker detail, ProtocolPriority priority) {
        if (!StringMapper.isNullString((String)message)) {
            this.hasErrorMessages = true;
        }
        if (!this.withoutProtocolling && !this.isOutOfRange(priority)) {
            String plantKey = null;
            if (this.activeEmployment != null && this.activeEmployment.getPlant() != null) {
                plantKey = this.activeEmployment.getPlant().getPlantKey();
            }
            String birthDateAsString = "";
            String surname = "";
            String firstname = "";
            if (this.master != null) {
                surname = this.master.getSurname();
                firstname = this.master.getFirstname();
                birthDateAsString = !StringMapper.isNullString((String)this.master.getDateOfBirthELSTAM()) ? this.master.getDateOfBirthELSTAM() : DateMapper.toDDMMYYYYPointSeparationString((Date)this.master.getDateOfBirth());
            }
            ProtocolContentEmployeeData empData = new ProtocolContentEmployeeData(plantKey, this.mEmployee.getPCompany().getPCompanyKey(), this.mEmployee.getPersonnelnumber(), surname, firstname, birthDateAsString, this.taxId);
            this.mElo2Advice.addProtocolContent(empData, message, detail, priority);
            this.errorsManualAccount.append(message).append(" ");
        }
    }

    private boolean isOutOfRange(ProtocolPriority priority) {
        if (!ProtocolPriority.OPTIONAL.equals((Object)priority)) {
            return false;
        }
        if (this.activeEmployment.getDateOfWithDrawal() != null && DateHelper.before((Date)this.activeEmployment.getDateOfWithDrawal(), (Date)DateHelper.addMonths((Date)this.currentDate, (int)-6))) {
            return false;
        }
        return false;
    }

    public abstract void mergeWithSpecialValues();
}

