/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eel;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CertificateCalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.DeuvDbapFillHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.deuvmessaging.SiVersionCheck;
import com.varial.personnel.domain.eel.EelAccountComparator;
import com.varial.personnel.domain.eel.EelCompany;
import com.varial.personnel.domain.eel.EelComponents;
import com.varial.personnel.domain.eel.EelEmployee;
import com.varial.personnel.domain.eel.EelPresetStruct;
import com.varial.personnel.domain.eel.eelaccount.EelAccount;
import com.varial.personnel.domain.eel.eelaccount.EelAdviceStateEnum;
import com.varial.personnel.domain.eel.eelaccount.IEelAccountPersistencyManager;
import com.varial.personnel.domain.eel.eeldbae.EelDbae;
import com.varial.personnel.domain.eel.eeldbae.EelDbaeHelper;
import com.varial.personnel.domain.eel.eeldbal.DateFromBean;
import com.varial.personnel.domain.eel.eeldbal.EelDbal;
import com.varial.personnel.domain.eel.eeldbal.EelDbalHelper;
import com.varial.personnel.domain.eel.eeldban.EelDban;
import com.varial.personnel.domain.eel.eeldbap.EelDbap;
import com.varial.personnel.domain.eel.eeldbaw.EelDbaw;
import com.varial.personnel.domain.eel.eeldbaw.EelDbawHelper;
import com.varial.personnel.domain.eel.eeldbbe.EelDbbe;
import com.varial.personnel.domain.eel.eeldbbe.EelDbbeHelper;
import com.varial.personnel.domain.eel.eeldbee.EelDbee;
import com.varial.personnel.domain.eel.eeldbfr.EelDbfr;
import com.varial.personnel.domain.eel.eeldbfr.EelDbfrHelper;
import com.varial.personnel.domain.eel.eeldbid.EelDbid;
import com.varial.personnel.domain.eel.eeldblt.EelDblt;
import com.varial.personnel.domain.eel.eeldblt.EelDbltHelper;
import com.varial.personnel.domain.eel.eeldbmu.EelDbmu;
import com.varial.personnel.domain.eel.eeldbmu.EelDbmuHelper;
import com.varial.personnel.domain.eel.eeldbna.EelDbna;
import com.varial.personnel.domain.eel.eeldbun.EelDbun;
import com.varial.personnel.domain.eel.eeldbun.EelDbunHelper;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvo;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvoHelper;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvoPart;
import com.varial.personnel.domain.eel.eeldbza.EelDbza;
import com.varial.personnel.domain.eel.eeldbza.EelDbzaHelper;
import com.varial.personnel.domain.eel.eeldslw.EelDslw;
import com.varial.personnel.domain.eel.ikdata.IKData;
import com.varial.personnel.domain.eel.ikdata.IKDataUtil;
import com.varial.personnel.domain.eel.mapper.EelExceptionMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreak;
import com.varial.personnel.domain.employee.employment.DsmRgnOnPartOfEnum;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.statisticalvalue.StatisticalValue;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.aoksystems.da.kernpruefung.eel12.KernpruefungEEL12Impl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kernpruefung.Rueckgabe;

public class EelAdvice {
    private EelCompany mEelCompany;
    private EelEmployee mEelEmployee;
    private final String mCreatedOnString;
    private final Date mCreatedOnDate;
    private boolean mAffectedBySpecialAccess;
    private int mReasonOfDelivery = 0;
    private boolean mResponseEel = false;
    private boolean mWorkDisease = false;
    private Date mValidFrom;
    private StatisticalValue mStatValue0;
    private StatisticalValue mStatValue1;
    private StatisticalValue mStatValue2;
    private StatisticalValue mStatValue3;
    private StatisticalValue mStatValue4;
    private StatisticalValue mStatValue5;
    private StatisticalValue mStatValue6;
    private int mKeineFreiSt;
    private int mBegrzFreiSt;
    private String mUnfallAz;
    private Date mVtag;
    private String mIkuv;
    private BigDecimal mFreistZu;
    private int mGrundAv;
    private ValueType mVwlValueType;
    private int mRecipient;
    private static final String DGUV = "22672327";
    private static final String DSRV = "66667777";
    private static final String BA = "76641777";
    private static final String SVLFG = "47056789";
    private static final String DGUV_EVPT = "99300900";
    private static final String BA_EVPT = "99300330";
    private static final Date DATE_MMVERZBEITRAGS = DateMapper.toDate((String)"2019-07-01");
    private final DeuvRecipientMap mRecipientMap;
    private int mEntgeltart;
    private BigDecimal mVereinbBrutto;
    private boolean mBruttoAbw;
    private BigDecimal mZuschlag1;
    private BigDecimal mZuschlag2;
    private BigDecimal mZuschlag3;
    private Date mAbwZeitraum;
    private Date mCalcStart;
    private boolean mAnrVorErk = false;
    private boolean mDauEntgErh;
    private String mMonat1;
    private String mMonat2;
    private String mMonat3;
    private String mBrutto1;
    private String mBrutto2;
    private String mBrutto3;
    private boolean mOnlyPeriodsBefore = false;
    private StatisticalValue mStatValue7;
    public static final Date DATE_REASON_04_BEGIN = DateMapper.toDate((String)"2022-11-01");
    public static final Date DATE_REASON_04_END = DateMapper.toDate((String)"2022-12-31");

    public EelAdvice(PCompany pCompany, Employee employee, EEAbsentTimeTP eeAbsentimeTP, int reasonOfDelivery, EelPresetStruct preset) throws BusinessDomainException {
        this(pCompany, employee, eeAbsentimeTP);
        this.mReasonOfDelivery = reasonOfDelivery;
        this.mResponseEel = preset.responseEel;
        this.mWorkDisease = preset.workDisease;
        this.mStatValue0 = this.getStatisticalValue(preset.oidStatValue0);
        this.mStatValue1 = this.getStatisticalValue(preset.oidStatValue1);
        this.mStatValue2 = this.getStatisticalValue(preset.oidStatValue2);
        this.mStatValue3 = this.getStatisticalValue(preset.oidStatValue3);
        this.mStatValue4 = this.getStatisticalValue(preset.oidStatValue4);
        this.mStatValue5 = this.getStatisticalValue(preset.oidStatValue5);
        this.mStatValue6 = this.getStatisticalValue(preset.oidStatValue6);
        this.mStatValue7 = this.getStatisticalValue(preset.oidStatValue7);
        this.mKeineFreiSt = preset.keineFreiSt;
        this.mBegrzFreiSt = preset.begrzFreiSt;
        this.mUnfallAz = preset.unfallAz;
        this.mVtag = DateMapper.toDate((String)preset.vtag);
        this.mIkuv = preset.ikuv;
        this.mFreistZu = BigDecimalMapper.toBigDecimal((String)preset.freistZuschl);
        this.mGrundAv = preset.grundAv;
        this.mVwlValueType = this.getValueType(preset.oidValueType);
        this.mEntgeltart = preset.entgeltart;
        this.mBruttoAbw = preset.bruttoAbw;
        this.mVereinbBrutto = BigDecimalMapper.toBigDecimal((String)preset.vereinbBrutto);
        this.mCalcStart = this.mEelCompany.getPCompany().getActiveCompanyFoundation().getCalculationStart();
        if (!StringMapper.isNullString((String)preset.abwZeitraumAel) && !DateHelper.before((Date)DateMapper.toDate((String)preset.abwZeitraumAel), (Date)this.mCalcStart)) {
            this.mAbwZeitraum = DateMapper.toDate((String)preset.abwZeitraumAel);
        }
        this.mRecipient = preset.recipient;
        this.mAnrVorErk = preset.anrVorErk;
        this.mDauEntgErh = preset.dauEntgErh;
        this.mMonat1 = preset.monat1;
        this.mMonat2 = preset.monat2;
        this.mMonat3 = preset.monat3;
        this.mBrutto1 = preset.brutto1;
        this.mBrutto2 = preset.brutto2;
        this.mBrutto3 = preset.brutto3;
        this.mOnlyPeriodsBefore = preset.onlyPeriodsBefore;
        if (this.mOnlyPeriodsBefore) {
            this.mAbwZeitraum = null;
        }
    }

    public EelAdvice(PCompany pCompany, Employee employee, EEAbsentTimeTP eeAbsentimeTP) throws BusinessDomainException {
        this(pCompany);
        this.mEelEmployee = new EelEmployee(employee, eeAbsentimeTP);
        this.mValidFrom = this.mEelEmployee.getEEAbsentTimeTP().getValidFrom();
    }

    public EelAdvice(PCompany pCompany) throws BusinessDomainException {
        this.mEelCompany = new EelCompany(pCompany);
        this.mEelEmployee = null;
        this.mCreatedOnDate = VDate.getCurrentLocalizedDateAndTime();
        this.mCreatedOnString = DeuvBasics.formatDEUVTimestamp((Date)this.mCreatedOnDate);
        this.mValidFrom = null;
        this.mRecipientMap = new DeuvRecipientMap(this.mEelCompany.getDeuvSender());
    }

    public EelDslw createSuggestion() throws BusinessDomainException {
        SiVersionCheck.checkVersionValidness((SiVersionCheck.Type)SiVersionCheck.Type.EEL);
        this.isCreateOfSuggestionPossible();
        EelDslw dslw = this.createDslw();
        switch (this.mReasonOfDelivery) {
            case 1: {
                this.createKVKrankengeld(dslw);
                break;
            }
            case 2: {
                this.createKVKinderpflegeKrankengeld(dslw);
                break;
            }
            case 3: {
                this.createKVMutterschaftsgeld(dslw);
                break;
            }
            case 4: {
                this.createKVMitaufnahmeKrankenhaus(dslw);
                break;
            }
            case 11: {
                this.createRVUebergangsgeldReha(dslw);
                break;
            }
            case 12: {
                this.createRVUebergangsgeldTeilhabe(dslw);
                break;
            }
            case 21: {
                this.createUVVerletztengeld(dslw);
                break;
            }
            case 22: {
                this.createUVUebergangsgeld(dslw);
                break;
            }
            case 23: {
                this.createUVKinderpflegeVerletztengeld(dslw);
                break;
            }
            case 31: {
                this.createBAUebergangsgeld(dslw);
                break;
            }
            case 41: {
                this.createAnforderungVorerkrankung(dslw);
                break;
            }
            case 42: {
                this.createAnforderungEndeEEL(dslw);
                break;
            }
            case 51: {
                this.createHoeheBeitragspflEinnahmen(dslw);
                break;
            }
            case 99: {
                this.createSystemwechsel(dslw);
                break;
            }
            default: {
                throw new IllegalArgumentException("The reason of delivery " + this.mReasonOfDelivery + " is not supported.");
            }
        }
        return dslw;
    }

    private void createKVKrankengeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createKVKinderpflegeKrankengeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbfr(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createKVMutterschaftsgeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbmu(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
        if (dslw.getDbmu().getEndebvzUm() != null) {
            this.createDbae(dslw);
        }
        if (this.mEntgeltart == 1 && dslw.getDbmu().getBvgeKuend() > 0) {
            this.createDbza(dslw);
        }
        if (dslw.getDbmu().getBvgeKuend() > 0) {
            this.createDbaw(dslw);
        }
    }

    private void createKVMitaufnahmeKrankenhaus(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createRVUebergangsgeldReha(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDblt(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createRVUebergangsgeldTeilhabe(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDblt(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createUVVerletztengeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDbun(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createUVUebergangsgeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDbun(dslw);
        this.createDblt(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createUVKinderpflegeVerletztengeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbfr(dslw);
        this.createDbun(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createBAUebergangsgeld(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbal(dslw);
        this.createDbae(dslw);
        if (this.mEntgeltart == 1) {
            this.createDbza(dslw);
        }
        this.createDbaw(dslw);
        this.createDblt(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
    }

    private void createAnforderungVorerkrankung(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbvo(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
        if (this.isDGUV(dslw)) {
            this.createDbun(dslw);
        }
    }

    private void createAnforderungEndeEEL(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbee(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
        if (this.isDGUV(dslw)) {
            this.createDbun(dslw);
        }
    }

    private void createHoeheBeitragspflEinnahmen(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbbe(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
        if (this.isDGUV(dslw)) {
            this.createDbun(dslw);
        }
    }

    private void createSystemwechsel(EelDslw dslw) throws BusinessDomainException {
        this.createDbna(dslw);
        this.createDban(dslw);
        this.createDbap(dslw);
        this.createDbid(dslw);
        if (this.isDGUV(dslw)) {
            this.createDbun(dslw);
        }
    }

    public EelAccount createAccount(EelDslw dslw) throws BusinessDomainException {
        this.mReasonOfDelivery = dslw.getAbgabegrund();
        this.mResponseEel = false;
        if (dslw.getRueckEntgeltErsatz().equals("J")) {
            this.mResponseEel = true;
        }
        EelAccount account = this.createEelAccount(dslw);
        dslw.setEelAccount(account);
        return account;
    }

    private EelDslw createDslw() throws BusinessDomainException {
        EelDslw result = new EelDslw();
        result.setBbnrAbsender(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.mEelCompany.getDeuvSender()));
        result.setBbnrEmpfaenger(this.getRecipient());
        result.setDatumErstellung(this.getCreatedOnString());
        result.setFehlerKennz("0");
        result.setFehlerAnzahl(0);
        result.setVersicherungsnr(this.mEelEmployee.getPersonalData().getInsuranceNo());
        result.setGeburtsDat(this.mEelEmployee.getPersonalData().getDateOfBirth());
        result.setBbnrVU(this.getEECompanyPlant(this.mValidFrom).getCompanyNumber());
        result.setProdId(DeuvBasics.getProdId());
        result.setModId(DeuvBasics.getModId());
        result.setBbnrKK(this.getHealthFundStdCompNo(this.mEelEmployee.getEmployee(), this.mValidFrom));
        result.setRueckEntgeltErsatz(this.mResponseEel ? "J" : "N");
        result.setAbgabegrund(this.mReasonOfDelivery);
        result.setAbrechnungsprogramm(1);
        result.setKennzStorno("N");
        return result;
    }

    private EelDbna createDbna(EelDslw dslw) throws BusinessDomainException {
        EelDbna result = dslw.createDbna();
        return this.mEelEmployee.fillDbna(result);
    }

    private EelDban createDban(EelDslw dslw) throws BusinessDomainException {
        EelDban result = dslw.createDban();
        return this.mEelEmployee.fillDban(result);
    }

    private EelDbal createDbal(EelDslw dslw) throws BusinessDomainException {
        EelDbal dbal = dslw.createDbal();
        DateFromBean bean = EelDbalHelper.getDatumAB((EelEmployee)this.mEelEmployee);
        if (bean.getWaitingDay().booleanValue()) {
            dbal.setAeErstTag("J");
            dbal.setDatumAb(DateHelper.add((Date)bean.getDateFrom(), (int)-1));
        } else {
            dbal.setAeErstTag("N");
            dbal.setDatumAb(bean.getDateFrom());
        }
        dbal.setDatumEgzBis(EelDbmuHelper.getLetztSvTag((EelEmployee)this.mEelEmployee));
        if (this.mReasonOfDelivery == 11 || this.mReasonOfDelivery == 12 || this.mReasonOfDelivery == 22 || this.mReasonOfDelivery == 31) {
            dbal.setDatumEgzBis(EelDbalHelper.getDatumBisForGO((EelEmployee)this.mEelEmployee));
        }
        dbal.setEndeBvAm(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateDsmRgn());
        dbal.setEndeBvZum(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDsmRgnBy());
        if (dbal.getEndeBvAm() != null && dbal.getEndeBvZum() != null) {
            dbal.setGrundBeend(EelDbalHelper.getGrundBeend((DsmRgnOnPartOfEnum)this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDsmRgnOnPartOf()));
        }
        dbal.setPflZuschlag(EelDbalHelper.getPflZuschlag((EelEmployee)this.mEelEmployee, (Date)this.mValidFrom));
        dbal.setArbzeitMod(EelDbalHelper.getArbzeitMod((EelEmployee)this.mEelEmployee, (Date)this.mAbwZeitraum));
        dbal.setMmKug(EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, (Date)EelDbalHelper.getLetzterAbrMonatVon((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum)));
        if (dbal.getMmKug() == 1) {
            dbal.setKugBeginn(EelDbalHelper.getBeginKugBezug((EelEmployee)this.mEelEmployee, (Date)this.mValidFrom));
            dbal.setKugEnde(EelDbalHelper.getEndKugBezug((EelEmployee)this.mEelEmployee, (Date)this.mValidFrom));
        }
        dbal.setKinderunter25(0);
        Date effectiveTimepoint = this.mEelEmployee.getEffectiveTimePoint();
        Date validTimepoint = this.mValidFrom;
        BigDecimal kinderUnter25 = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)validTimepoint, (Date)new VDate(2023, 6, 1).getDate()) && BigDecimalMapper.compareTo((BigDecimal)(kinderUnter25 = this.mEelEmployee.getEmployee().getEffectiveNumberOfChildrenForNI(effectiveTimepoint, validTimepoint, false, false)), (BigDecimal)BigDecimal.valueOf(5L)) > 0) {
            kinderUnter25 = BigDecimal.valueOf(5L);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)kinderUnter25, (BigDecimal)BigDecimal.valueOf(2L)) >= 0 && BigDecimalMapper.compareTo((BigDecimal)kinderUnter25, (BigDecimal)BigDecimal.valueOf(5L)) <= 0) {
            dbal.setKinderunter25(kinderUnter25.intValue());
        }
        return dbal;
    }

    private EelDbae createDbae(EelDslw dslw) throws BusinessDomainException {
        Date start;
        EelDbae dbae = dslw.createDbae();
        dbae.setWaehrEelBrutto(EelDbaeHelper.getWaehreEelBrutto((EelEmployee)this.mEelEmployee));
        if (dbae.getWaehrEelBrutto() != null) {
            dbae.setDatumAeBis(VDate.getDateMax());
        }
        dbae.setEntgArt(this.mEntgeltart);
        Date entry = this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfEntry();
        int i = 0;
        Date maxDate = entry;
        if (maxDate == null) {
            maxDate = this.mCalcStart;
        }
        Employee emp = this.mEelEmployee.getEmployee();
        Date eazBeginn = DateHelper.getFirstDayOfMonth((Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
        if (DateHelper.before((Date)eazBeginn, (Date)(start = DateHelper.getFirstDayOfMonth((Date)maxDate)))) {
            if (this.mAbwZeitraum != null && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)entry), (Date)DateHelper.getFirstDayOfMonth((Date)this.mAbwZeitraum)) && EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, null, (Date)this.mAbwZeitraum) == 1) {
                this.mOnlyPeriodsBefore = true;
            } else {
                throw EelExceptionMapper.makeNoMonthWithoutKugException();
            }
        }
        int max = DateHelper.getDiffInMonths((Date)eazBeginn, (Date)start);
        if (this.mOnlyPeriodsBefore) {
            max = 0;
        }
        while (i <= max) {
            CertificateCalculationCase calc1 = new CertificateCalculationCase();
            calc1.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
            calc1.start();
            BigDecimal brutto1 = calc1.getGrossWage();
            BigDecimal netto1 = calc1.getNetWage();
            calc1.removeValuesOfCalculation();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto1)) {
                dbae.setBrutto1(brutto1);
                dbae.setNetto1(netto1);
                Date begin = EelDbaeHelper.getEazBeginnWithEntry((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart);
                dbae.setEazBeginn1(begin);
                Date end = EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart);
                if (this.mOnlyPeriodsBefore) {
                    if (dslw.getDbal() != null && dslw.getDbal().getDatumAb() != null) {
                        end = DateHelper.yesterday((Date)dslw.getDbal().getDatumAb());
                    } else if (dslw.getDbmu() != null && dslw.getDbmu().getLetztTag() != null) {
                        end = dslw.getDbmu().getLetztTag();
                    }
                    if (this.mEelEmployee.getEEAbsentTimeTP().getValidUntil() != null && !DateHelper.afterOrEqual((Date)this.mEelEmployee.getEEAbsentTimeTP().getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)begin))) {
                        BigDecimal daysWithoutInterrupt = calc1.getSVTage();
                        BigDecimal days = new BigDecimal(DateHelper.getDiffInDays((Date)end, (Date)begin) + 1);
                        dbae.setBrutto1(brutto1.divide(daysWithoutInterrupt, 4, RoundingMode.HALF_UP).multiply(days).setScale(2, RoundingMode.HALF_UP));
                        dbae.setNetto1(netto1.divide(daysWithoutInterrupt, 4, RoundingMode.HALF_UP).multiply(days).setScale(2, RoundingMode.HALF_UP));
                    }
                }
                dbae.setEazEnde1(end);
                ++i;
                break;
            }
            ++i;
        }
        dbae.setUmgewae(EelDbaeHelper.getUmgewae((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart, (StatisticalValue)this.mStatValue7));
        if (this.mEntgeltart != 1 && this.mBruttoAbw) {
            while (i <= max) {
                CertificateCalculationCase calc2 = new CertificateCalculationCase();
                calc2.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
                calc2.start();
                BigDecimal brutto2 = calc2.getGrossWage();
                BigDecimal netto2 = calc2.getNetWage();
                calc2.removeValuesOfCalculation();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto2)) {
                    dbae.setBrutto2(brutto2);
                    dbae.setNetto2(netto2);
                    dbae.setEazBeginn2(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                    dbae.setEazEnde2(EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                    ++i;
                    break;
                }
                ++i;
            }
            while (i <= max) {
                CertificateCalculationCase calc3 = new CertificateCalculationCase();
                calc3.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
                calc3.start();
                BigDecimal brutto3 = calc3.getGrossWage();
                BigDecimal netto3 = calc3.getNetWage();
                calc3.removeValuesOfCalculation();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto3)) {
                    dbae.setBrutto3(brutto3);
                    dbae.setNetto3(netto3);
                    dbae.setEazBeginn3(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                    dbae.setEazEnde3(EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                    ++i;
                    break;
                }
                ++i;
            }
        }
        if (this.mEntgeltart == 2 && this.mBruttoAbw) {
            if (BigDecimalMapper.compareTo((BigDecimal)dbae.getBrutto1(), (BigDecimal)this.mVereinbBrutto) != 0 && BigDecimalMapper.compareTo((BigDecimal)dbae.getBrutto2(), (BigDecimal)this.mVereinbBrutto) != 0 && BigDecimalMapper.compareTo((BigDecimal)dbae.getBrutto3(), (BigDecimal)this.mVereinbBrutto) != 0) {
                dbae.setBruttoAe(this.mVereinbBrutto);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dbae.getBruttoAe())) {
                    CertificateCalculationCase calcAe = new CertificateCalculationCase();
                    calcAe.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), this.mVereinbBrutto, TypeOfCalculationCase.BescheinigungKompletterMonat);
                    calcAe.start();
                    dbae.setNettoAe(calcAe.getNetWage());
                    calcAe.removeValuesOfCalculation();
                }
            } else {
                dbae.setBrutto2(null);
                dbae.setBrutto3(null);
                dbae.setNetto2(null);
                dbae.setNetto3(null);
                dbae.setEazBeginn2(null);
                dbae.setEazBeginn3(null);
                dbae.setEazEnde2(null);
                dbae.setEazEnde3(null);
            }
        }
        BigDecimal[] ezResults = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        String[] oidsParentValues = EelDbaeHelper.getParentValues((Employee)this.mEelEmployee.getEmployee(), (Date)this.mEelEmployee.getEffectiveTimePoint(), (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)11, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), (Date)EelDbaeHelper.getEazEnde((EelEmployee)this.mEelEmployee, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), (int[])new int[]{130610, 130620, 130630, 130650});
        if (oidsParentValues != null) {
            ezResults = EelDbaeHelper.getEzValues((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart, (String[])oidsParentValues);
        }
        BigDecimal ezkv = ezResults[0];
        BigDecimal ezrv = ezResults[1];
        BigDecimal ezalv = ezResults[2];
        dbae.setEzkv(ezkv);
        dbae.setEzrv(ezrv);
        dbae.setEzalv(ezalv);
        if ((this.mEntgeltart == 1 || this.mEntgeltart == 2) && this.mAbwZeitraum != null && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.mAbwZeitraum), (Date)DateHelper.getFirstDayOfMonth((Date)entry)) && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.mAbwZeitraum), (Date)DateHelper.getFirstDayOfMonth((Date)this.mValidFrom))) {
            CertificateCalculationCase calc = new CertificateCalculationCase();
            calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
            calc.start();
            BigDecimal brutto1 = calc.getGrossWage();
            BigDecimal netto1 = calc.getNetWage();
            calc.removeValuesOfCalculation();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto1)) {
                dbae.setBrutto1(brutto1);
                dbae.setNetto1(netto1);
                dbae.setEazBeginn1(EelDbaeHelper.getEazBeginnWithEntry((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                dbae.setEazEnde1(EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                if (dbae.getWaehrEelBrutto() != null) {
                    dbae.setDatumAeBis(DateHelper.yesterday((Date)this.mValidFrom));
                }
            }
        }
        if (this.mDauEntgErh) {
            CertificateCalculationCase calc;
            BigDecimal net;
            BigDecimal gross;
            dbae.setBrutto1(null);
            dbae.setBrutto2(null);
            dbae.setBrutto3(null);
            dbae.setNetto1(null);
            dbae.setNetto2(null);
            dbae.setNetto3(null);
            dbae.setEazBeginn1(null);
            dbae.setEazBeginn2(null);
            dbae.setEazBeginn3(null);
            dbae.setEazEnde1(null);
            dbae.setEazEnde2(null);
            dbae.setEazEnde3(null);
            if (!StringMapper.isNullString((String)this.mMonat1) && !StringMapper.isNullString((String)this.mBrutto1)) {
                dbae.setEazBeginn1(DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mMonat1)));
                dbae.setEazEnde1(DateHelper.getLastDayOfMonth((Date)DateMapper.toDate((String)this.mMonat1)));
                gross = BigDecimalMapper.toBigDecimal((String)this.mBrutto1);
                net = BigDecimalMapper.ZERO;
                if (!gross.equals(BigDecimalMapper.ZERO)) {
                    calc = new CertificateCalculationCase();
                    calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), dbae.getEazBeginn1(), gross);
                    calc.start();
                    net = calc.getNetWage();
                    calc.removeValuesOfCalculation();
                }
                dbae.setBrutto1(gross);
                dbae.setNetto1(net);
            }
            if (!StringMapper.isNullString((String)this.mMonat2) && !StringMapper.isNullString((String)this.mBrutto2)) {
                dbae.setEazBeginn2(DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mMonat2)));
                dbae.setEazEnde2(DateHelper.getLastDayOfMonth((Date)DateMapper.toDate((String)this.mMonat2)));
                gross = BigDecimalMapper.toBigDecimal((String)this.mBrutto2);
                net = BigDecimalMapper.ZERO;
                if (!gross.equals(BigDecimalMapper.ZERO)) {
                    calc = new CertificateCalculationCase();
                    calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), dbae.getEazBeginn2(), gross);
                    calc.start();
                    net = calc.getNetWage();
                    calc.removeValuesOfCalculation();
                }
                dbae.setBrutto2(gross);
                dbae.setNetto2(net);
            }
            if (!StringMapper.isNullString((String)this.mMonat3) && !StringMapper.isNullString((String)this.mBrutto3)) {
                dbae.setEazBeginn3(DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mMonat3)));
                dbae.setEazEnde3(DateHelper.getLastDayOfMonth((Date)DateMapper.toDate((String)this.mMonat3)));
                gross = BigDecimalMapper.toBigDecimal((String)this.mBrutto3);
                net = BigDecimalMapper.ZERO;
                if (!gross.equals(BigDecimalMapper.ZERO)) {
                    calc = new CertificateCalculationCase();
                    calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), dbae.getEazBeginn3(), gross);
                    calc.start();
                    net = calc.getNetWage();
                    calc.removeValuesOfCalculation();
                }
                dbae.setBrutto3(gross);
                dbae.setNetto3(net);
            }
        }
        return dbae;
    }

    private EelDbza createDbza(EelDslw dslw) throws BusinessDomainException {
        Date abrMonatMinus1;
        EelDbza dbza = dslw.createDbza();
        StatisticalValue statValue = this.mStatValue0;
        if (this.mStatValue1 != null && this.mStatValue0 == null) {
            statValue = this.mStatValue1;
        }
        Date begin = EelDbalHelper.getLetzterAbrMonatVon((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum);
        Date end = EelDbalHelper.getLetzterAbrMonatBis((EelEmployee)this.mEelEmployee, (Date)this.mAbwZeitraum);
        if (this.mOnlyPeriodsBefore && dslw.getDbae() != null) {
            begin = dslw.getDbae().getEazBeginn1();
            end = dslw.getDbae().getEazEnde1();
        }
        if (this.mReasonOfDelivery == 3) {
            dbza.setMazr1(EelDbzaHelper.getMazrForMu((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue3, (StatisticalValue)this.mStatValue4, (Date)begin, (Date)end));
        } else {
            dbza.setMazr1(EelDbzaHelper.getMazr((EelEmployee)this.mEelEmployee, (StatisticalValue)statValue, (Date)begin, (Date)end));
        }
        if (this.mStatValue0 == null) {
            dbza.setRegAz(EelDbzaHelper.getRegAz((EelEmployee)this.mEelEmployee, (Date)this.mAbwZeitraum));
            dbza.setAnzahlStd(EelDbzaHelper.getAnzahlStd((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum));
        } else {
            dbza.setAnzahlStd(dbza.getMazr1());
        }
        if (!this.mOnlyPeriodsBefore && DateHelper.compareDate((Date)begin, (Date)(abrMonatMinus1 = EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)1, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart))) != 0) {
            Date abrMonatMinus2;
            Date abrMonatBisMinus1 = EelDbaeHelper.getEazEnde((EelEmployee)this.mEelEmployee, (int)1, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart);
            if (this.mReasonOfDelivery == 3) {
                dbza.setMazr2(EelDbzaHelper.getMazrForMu((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue3, (StatisticalValue)this.mStatValue4, (Date)abrMonatMinus1, (Date)abrMonatBisMinus1));
            } else {
                dbza.setMazr2(EelDbzaHelper.getMazr((EelEmployee)this.mEelEmployee, (StatisticalValue)statValue, (Date)abrMonatMinus1, (Date)abrMonatBisMinus1));
            }
            if (dbza.getMazr2() != null && !dbza.getMazr2().equals(BigDecimal.ZERO)) {
                dbza.setAzBeginn2(abrMonatMinus1);
                dbza.setAzEnde2(abrMonatBisMinus1);
            }
            if (DateHelper.compareDate((Date)abrMonatMinus1, (Date)(abrMonatMinus2 = EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)2, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart))) != 0) {
                Date abrMonatBisMinus2 = EelDbaeHelper.getEazEnde((EelEmployee)this.mEelEmployee, (int)2, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart);
                if (this.mReasonOfDelivery == 3) {
                    dbza.setMazr3(EelDbzaHelper.getMazrForMu((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue3, (StatisticalValue)this.mStatValue4, (Date)abrMonatMinus2, (Date)abrMonatBisMinus2));
                } else {
                    dbza.setMazr3(EelDbzaHelper.getMazr((EelEmployee)this.mEelEmployee, (StatisticalValue)statValue, (Date)abrMonatMinus2, (Date)abrMonatBisMinus2));
                }
                if (dbza.getMazr3() != null && !dbza.getMazr3().equals(BigDecimal.ZERO)) {
                    dbza.setAzBeginn3(abrMonatMinus2);
                    dbza.setAzEnde3(abrMonatBisMinus2);
                }
            }
        }
        return dbza;
    }

    private EelDbee createDbee(EelDslw dslw) {
        EelDbee dbee = dslw.createDbee();
        dbee.setEelAbAg(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
        return dbee;
    }

    private EelDbaw createDbaw(EelDslw dslw) throws BusinessDomainException {
        EelDbaw dbaw = dslw.createDbaw();
        if (!this.mOnlyPeriodsBefore) {
            dbaw.setTage1(EelDbawHelper.getTage((EelEmployee)this.mEelEmployee, (Date)EelDbalHelper.getLetzterAbrMonatVon((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum)));
            if (this.mEntgeltart == 1) {
                if (dslw.getDbza().getAzBeginn2() != null) {
                    dbaw.setTage2(EelDbawHelper.getTage((EelEmployee)this.mEelEmployee, (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)1, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart)));
                }
                if (dslw.getDbza().getAzBeginn3() != null) {
                    dbaw.setTage3(EelDbawHelper.getTage((EelEmployee)this.mEelEmployee, (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)2, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart)));
                }
            }
            if ((this.mEntgeltart == 2 || this.mEntgeltart == 3) && dslw.getDbae() != null) {
                if (dslw.getDbae().getEazBeginn2() != null) {
                    dbaw.setTage2(EelDbawHelper.getTage((EelEmployee)this.mEelEmployee, (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)1, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart)));
                }
                if (dslw.getDbae().getEazBeginn3() != null) {
                    dbaw.setTage3(EelDbawHelper.getTage((EelEmployee)this.mEelEmployee, (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)2, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart)));
                }
            }
        }
        return dbaw;
    }

    private EelDbfr createDbfr(EelDslw dslw) throws BusinessDomainException {
        EelDbfr dbfr = dslw.createDbfr();
        dbfr.setEndeBvZum(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfWithDrawal());
        dbfr.setFreiStVom(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
        dbfr.setFreiStBis(this.mEelEmployee.getEEAbsentTimeTP().getValidUntil());
        dbfr.setVaeErstTag("N");
        if (this.mKeineFreiSt == 0) {
            dbfr.setBezFreiStVom(EelDbfrHelper.getFehlzeitFreiSt((EelEmployee)this.mEelEmployee).getValidFrom());
            dbfr.setBezFreiStBis(EelDbfrHelper.getFehlzeitFreiSt((EelEmployee)this.mEelEmployee).getValidUntil());
        }
        dbfr.setTage(EelDbfrHelper.getTage((EelEmployee)this.mEelEmployee));
        dbfr.setKeineFreiSt(this.mKeineFreiSt);
        dbfr.setBegrzFreiSt(this.mBegrzFreiSt);
        dbfr.setBezFreiStJahr(EelDbfrHelper.getBezFreiStJahr((EelEmployee)this.mEelEmployee));
        BigDecimal[] results = EelDbfrHelper.getFreiStResults((EelEmployee)this.mEelEmployee, (Date)dbfr.getFreiStVom(), (Date)dbfr.getFreiStBis());
        dbfr.setFreiStBrutto(results[0]);
        dbfr.setFreiStNetto(results[1]);
        dbfr.setFreiStEz(EelDbfrHelper.getFreiStEz((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, (int)this.mReasonOfDelivery, (int)this.mEntgeltart) ? "J" : "N");
        dbfr.setKinderunter25(0);
        Date effectiveTimepoint = this.mEelEmployee.getEffectiveTimePoint();
        Date validTimepoint = this.mValidFrom;
        BigDecimal kinderUnter25 = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)validTimepoint, (Date)new VDate(2023, 6, 1).getDate()) && BigDecimalMapper.compareTo((BigDecimal)(kinderUnter25 = this.mEelEmployee.getEmployee().getEffectiveNumberOfChildrenForNI(effectiveTimepoint, validTimepoint, false, false)), (BigDecimal)BigDecimal.valueOf(5L)) > 0) {
            kinderUnter25 = BigDecimal.valueOf(5L);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)kinderUnter25, (BigDecimal)BigDecimal.valueOf(2L)) >= 0 && BigDecimalMapper.compareTo((BigDecimal)kinderUnter25, (BigDecimal)BigDecimal.valueOf(5L)) <= 0) {
            dbfr.setKinderunter25(kinderUnter25.intValue());
        }
        return dbfr;
    }

    private EelDbun createDbun(EelDslw dslw) throws BusinessDomainException {
        EelDbun dbun = dslw.createDbun();
        dbun.setUnfallAz(this.mUnfallAz);
        dbun.setIkuv(this.mIkuv);
        dbun.setVtag(this.mVtag);
        if (dslw.getAbgabegrund() != 41 && dslw.getAbgabegrund() != 42 && dslw.getAbgabegrund() != 23) {
            if (dslw.getAbgabegrund() == 51) {
                dbun.setZuschl1(this.mZuschlag1);
            } else {
                dbun.setZuschl1(EelDbunHelper.getZuschl((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue2, (Date)EelDbalHelper.getLetzterAbrMonatVon((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum), (Date)EelDbalHelper.getLetzterAbrMonatBis((EelEmployee)this.mEelEmployee, (Date)this.mAbwZeitraum)));
            }
            if ((this.mEntgeltart == 2 || this.mEntgeltart == 3) && dslw.getDbae().getEazBeginn2() != null || this.mEntgeltart == 1 && dslw.getDbza().getAzBeginn2() != null) {
                if (dslw.getAbgabegrund() == 51) {
                    dbun.setZuschl2(this.mZuschlag2);
                } else {
                    dbun.setZuschl2(EelDbunHelper.getZuschl((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue2, (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)1, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), (Date)EelDbaeHelper.getEazEnde((EelEmployee)this.mEelEmployee, (int)1, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart)));
                }
                if ((this.mEntgeltart == 2 || this.mEntgeltart == 3) && dslw.getDbae().getEazBeginn3() != null || this.mEntgeltart == 1 && dslw.getDbza().getAzBeginn3() != null) {
                    if (dslw.getAbgabegrund() == 51) {
                        dbun.setZuschl3(this.mZuschlag3);
                    } else {
                        dbun.setZuschl3(EelDbunHelper.getZuschl((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue2, (Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)2, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), (Date)EelDbaeHelper.getEazEnde((EelEmployee)this.mEelEmployee, (int)2, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart)));
                    }
                }
            }
            dbun.setEzuv(EelDbunHelper.getEzuv((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
        }
        if (dslw.getAbgabegrund() == 23) {
            dbun.setFreistZuschl(this.mFreistZu);
        }
        return dbun;
    }

    private EelDbmu createDbmu(EelDslw dslw) throws BusinessDomainException {
        EelDbmu dbmu = dslw.createDbmu();
        dbmu.setSchutzfrBeginn(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
        dbmu.setBvBeginn(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfEntry());
        dbmu.setLetztTag(EelDbmuHelper.getLetztSvTag((EelEmployee)this.mEelEmployee));
        dbmu.setEndebvAm(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateDsmRgn());
        dbmu.setEndebvzUm(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfWithDrawal());
        dbmu.setBvgeKuend(EelDbalHelper.getGrundBeend((DsmRgnOnPartOfEnum)this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDsmRgnOnPartOf()));
        BigDecimal brutto = EelDbaeHelper.getWaehreEelBrutto((EelEmployee)this.mEelEmployee);
        if (brutto != null) {
            CertificateCalculationCase calc = new CertificateCalculationCase();
            calc.init(this.mEelEmployee.getEmployee(), this.mEelEmployee.getEffectiveTimePointForCalculation(), DateHelper.getFirstDayOfMonth((Date)this.mEelEmployee.getEEAbsentTimeTP().getValidFrom()), brutto);
            calc.start();
            dbmu.setWaehrEelNetto(calc.getNetWageMUG());
        }
        if (dbmu.getWaehrEelNetto() != null) {
            dbmu.setDatumAeBis(VDate.getDateMax());
        }
        dbmu.setFehlZeit(EelDbmuHelper.getFehlzeit1((EelEmployee)this.mEelEmployee));
        dbmu.setAeUeber(EelDbmuHelper.isAeUeber((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)this.mEntgeltart, (Date)this.mAbwZeitraum, (int)this.mReasonOfDelivery) ? "J" : "N");
        dbmu.setAeFest(this.mEntgeltart == 2 ? "J" : "N");
        int i = 0;
        Date maxDate = this.mEelEmployee.getEmployee().getMaximumDateOfEntry();
        if (maxDate == null) {
            maxDate = this.mCalcStart;
        }
        Employee emp = this.mEelEmployee.getEmployee();
        Date eazBeginn = DateHelper.getFirstDayOfMonth((Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
        int max = DateHelper.getDiffInMonths((Date)DateHelper.getFirstDayOfMonth((Date)eazBeginn), (Date)DateHelper.getFirstDayOfMonth((Date)maxDate));
        while (i <= max) {
            CertificateCalculationCase calc1 = new CertificateCalculationCase(103);
            calc1.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
            calc1.start();
            BigDecimal brutto1 = calc1.getGrossWage();
            BigDecimal netto1 = calc1.getNetWageMUG();
            calc1.removeValuesOfCalculation();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto1) || this.isFullAbsentTime220(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart))) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)brutto1)) {
                    dbmu.setNetto1(BigDecimal.ZERO);
                } else {
                    dbmu.setNetto1(netto1);
                }
                dbmu.setBeginn1(EelDbaeHelper.getEazBeginnWithEntry((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                dbmu.setEnde1(EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                ++i;
                break;
            }
            ++i;
        }
        dbmu.setBeginn2(VDate.getDateMax());
        dbmu.setEnde2(VDate.getDateMax());
        dbmu.setBeginn3(VDate.getDateMax());
        dbmu.setEnde3(VDate.getDateMax());
        while (i <= max) {
            dbmu.setBeginn2(null);
            dbmu.setEnde2(null);
            CertificateCalculationCase calc2 = new CertificateCalculationCase(103);
            calc2.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
            calc2.start();
            BigDecimal brutto2 = calc2.getGrossWage();
            BigDecimal netto2 = calc2.getNetWageMUG();
            calc2.removeValuesOfCalculation();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto2) || this.isFullAbsentTime220(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart))) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)brutto2)) {
                    dbmu.setNetto2(BigDecimal.ZERO);
                } else {
                    dbmu.setNetto2(netto2);
                }
                dbmu.setBeginn2(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                dbmu.setEnde2(EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                ++i;
                break;
            }
            ++i;
        }
        while (i <= max) {
            dbmu.setBeginn3(null);
            dbmu.setEnde3(null);
            CertificateCalculationCase calc3 = new CertificateCalculationCase(103);
            calc3.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), BigDecimal.ZERO);
            calc3.start();
            BigDecimal brutto3 = calc3.getGrossWage();
            BigDecimal netto3 = calc3.getNetWageMUG();
            calc3.removeValuesOfCalculation();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)brutto3) || this.isFullAbsentTime220(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart))) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)brutto3)) {
                    dbmu.setNetto3(BigDecimal.ZERO);
                } else {
                    dbmu.setNetto3(netto3);
                }
                dbmu.setBeginn3(EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                dbmu.setEnde3(EelDbaeHelper.getEazEndeWithDrawal((EelEmployee)this.mEelEmployee, (int)i, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart));
                ++i;
                break;
            }
            ++i;
        }
        if (this.mDauEntgErh) {
            CertificateCalculationCase calc;
            BigDecimal net;
            BigDecimal gross;
            dbmu.setNetto1(null);
            dbmu.setNetto2(null);
            dbmu.setNetto3(null);
            dbmu.setBeginn1(VDate.getDateMax());
            dbmu.setEnde1(VDate.getDateMax());
            dbmu.setBeginn2(VDate.getDateMax());
            dbmu.setEnde2(VDate.getDateMax());
            dbmu.setBeginn3(VDate.getDateMax());
            dbmu.setEnde3(VDate.getDateMax());
            if (!StringMapper.isNullString((String)this.mMonat1) && !StringMapper.isNullString((String)this.mBrutto1)) {
                dbmu.setBeginn1(DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mMonat1)));
                dbmu.setEnde1(DateHelper.getLastDayOfMonth((Date)DateMapper.toDate((String)this.mMonat1)));
                gross = BigDecimalMapper.toBigDecimal((String)this.mBrutto1);
                net = BigDecimalMapper.ZERO;
                if (!gross.equals(BigDecimalMapper.ZERO)) {
                    calc = new CertificateCalculationCase();
                    calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), dbmu.getBeginn1(), gross);
                    calc.start();
                    net = calc.getNetWageMUG();
                    calc.removeValuesOfCalculation();
                }
                dbmu.setNetto1(net);
            }
            if (!StringMapper.isNullString((String)this.mMonat2) && !StringMapper.isNullString((String)this.mBrutto2)) {
                dbmu.setBeginn2(DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mMonat2)));
                dbmu.setEnde2(DateHelper.getLastDayOfMonth((Date)DateMapper.toDate((String)this.mMonat2)));
                gross = BigDecimalMapper.toBigDecimal((String)this.mBrutto2);
                net = BigDecimalMapper.ZERO;
                if (!gross.equals(BigDecimalMapper.ZERO)) {
                    calc = new CertificateCalculationCase();
                    calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), dbmu.getBeginn2(), gross);
                    calc.start();
                    net = calc.getNetWageMUG();
                    calc.removeValuesOfCalculation();
                }
                dbmu.setNetto2(net);
            }
            if (!StringMapper.isNullString((String)this.mMonat3) && !StringMapper.isNullString((String)this.mBrutto3)) {
                dbmu.setBeginn3(DateHelper.getFirstDayOfMonth((Date)DateMapper.toDate((String)this.mMonat3)));
                dbmu.setEnde3(DateHelper.getLastDayOfMonth((Date)DateMapper.toDate((String)this.mMonat3)));
                gross = BigDecimalMapper.toBigDecimal((String)this.mBrutto3);
                net = BigDecimalMapper.ZERO;
                if (!gross.equals(BigDecimalMapper.ZERO)) {
                    calc = new CertificateCalculationCase();
                    calc.init(emp, this.mEelEmployee.getEffectiveTimePointForCalculation(), dbmu.getBeginn3(), gross);
                    calc.start();
                    net = calc.getNetWageMUG();
                    calc.removeValuesOfCalculation();
                }
                dbmu.setNetto3(net);
            }
            if (!(BigDecimalMapper.compareTo((BigDecimal)dbmu.getNetto3(), (BigDecimal)EelDbmuHelper.getCompareValue((int)DateHelper.getMonth((Date)dbmu.getBeginn3()), (int)this.mEntgeltart)) <= 0 && dbmu.getNetto3() != null || BigDecimalMapper.compareTo((BigDecimal)dbmu.getNetto2(), (BigDecimal)EelDbmuHelper.getCompareValue((int)DateHelper.getMonth((Date)dbmu.getBeginn2()), (int)this.mEntgeltart)) <= 0 && dbmu.getNetto2() != null || BigDecimalMapper.compareTo((BigDecimal)dbmu.getNetto1(), (BigDecimal)EelDbmuHelper.getCompareValue((int)DateHelper.getMonth((Date)dbmu.getBeginn1()), (int)this.mEntgeltart)) <= 0)) {
                dbmu.setAeUeber("J");
            }
        }
        if (dbmu.getAeFest().equals("N")) {
            dbmu.setBezAz1(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue3, (Date)dbmu.getBeginn1(), (Date)dbmu.getEnde1()));
            dbmu.setMaStd1(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue4, (Date)dbmu.getBeginn1(), (Date)dbmu.getEnde1()));
            dbmu.setAzunEntStd1(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue5, (Date)dbmu.getBeginn1(), (Date)dbmu.getEnde1()));
            dbmu.setAzEntschStd1(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue6, (Date)dbmu.getBeginn1(), (Date)dbmu.getEnde1()));
            dbmu.setBezAz2(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue3, (Date)dbmu.getBeginn2(), (Date)dbmu.getEnde2()));
            dbmu.setMaStd2(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue4, (Date)dbmu.getBeginn2(), (Date)dbmu.getEnde2()));
            dbmu.setAzunEntStd2(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue5, (Date)dbmu.getBeginn2(), (Date)dbmu.getEnde2()));
            dbmu.setAzEntschStd2(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue6, (Date)dbmu.getBeginn2(), (Date)dbmu.getEnde2()));
            dbmu.setBezAz3(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue3, (Date)dbmu.getBeginn3(), (Date)dbmu.getEnde2()));
            dbmu.setMaStd3(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue4, (Date)dbmu.getBeginn3(), (Date)dbmu.getEnde2()));
            dbmu.setAzunEntStd3(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue5, (Date)dbmu.getBeginn3(), (Date)dbmu.getEnde3()));
            dbmu.setAzEntschStd3(EelDbmuHelper.getStunden((EelEmployee)this.mEelEmployee, (StatisticalValue)this.mStatValue6, (Date)dbmu.getBeginn3(), (Date)dbmu.getEnde3()));
        } else {
            BigDecimal sollStundenTag = this.mEelEmployee.getDailyWorkingTime(this.mValidFrom);
            String[] keysUnbezUnent = new String[]{"2.3", "2.20"};
            dbmu.setAzunEntTage1(EelDbmuHelper.getUnbezStunden((EelEmployee)this.mEelEmployee, (Date)dbmu.getBeginn1(), (Date)dbmu.getEnde1(), (String[])keysUnbezUnent).divide(sollStundenTag, 2, RoundingMode.HALF_UP).intValue());
            dbmu.setAzunEntTage2(EelDbmuHelper.getUnbezStunden((EelEmployee)this.mEelEmployee, (Date)dbmu.getBeginn2(), (Date)dbmu.getEnde2(), (String[])keysUnbezUnent).divide(sollStundenTag, 2, RoundingMode.HALF_UP).intValue());
            dbmu.setAzunEntTage3(EelDbmuHelper.getUnbezStunden((EelEmployee)this.mEelEmployee, (Date)dbmu.getBeginn3(), (Date)dbmu.getEnde3(), (String[])keysUnbezUnent).divide(sollStundenTag, 2, RoundingMode.HALF_UP).intValue());
            String[] keysUnbezEnt = new String[]{"3.1", "3.2", "2.1", "2.4", "2.5", "8.1", "2.10", "6.4", "1.5", "1.1", "4.2", "4.3", "2.5", "4.4", "4.2", "4.3", "4.1", "4.6", "2.21", "10.10"};
            dbmu.setAzEntschTage1(EelDbmuHelper.getUnbezStunden((EelEmployee)this.mEelEmployee, (Date)dbmu.getBeginn1(), (Date)dbmu.getEnde1(), (String[])keysUnbezEnt).divide(sollStundenTag, 2, RoundingMode.HALF_UP).intValue());
            dbmu.setAzEntschTage2(EelDbmuHelper.getUnbezStunden((EelEmployee)this.mEelEmployee, (Date)dbmu.getBeginn2(), (Date)dbmu.getEnde2(), (String[])keysUnbezEnt).divide(sollStundenTag, 2, RoundingMode.HALF_UP).intValue());
            dbmu.setAzEntschTage3(EelDbmuHelper.getUnbezStunden((EelEmployee)this.mEelEmployee, (Date)dbmu.getBeginn3(), (Date)dbmu.getEnde3(), (String[])keysUnbezEnt).divide(sollStundenTag, 2, RoundingMode.HALF_UP).intValue());
        }
        if (dbmu.getBezAz1() != null && !dbmu.getBezAz1().equals(BigDecimal.ZERO)) {
            dbmu.setAzwWoech(this.mEelEmployee.getEmployee().getWeeklyWorkingTime(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom));
        }
        dbmu.setEntgArt(this.mEntgeltart);
        return dbmu;
    }

    private EelDbvo createDbvo(EelDslw dslw) throws BusinessDomainException {
        EelDbvo dbvo = dslw.createDbvo();
        dbvo.setGrundAv(this.mGrundAv);
        dbvo.setAuAbag(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
        dbvo.setAnzahlAu(EelDbvoHelper.getAnzahlAu((EelEmployee)this.mEelEmployee));
        EelDbvoPart[] parts = new EelDbvoPart[dbvo.getAnzahlAu()];
        for (int i = 0; i < dbvo.getAnzahlAu(); ++i) {
            EelDbvoPart part = new EelDbvoPart(dbvo);
            EEAbsentTimeTP absenTimeTP = EelDbvoHelper.getFehlzeit((EelEmployee)this.mEelEmployee, (int)i);
            part.setBeginnAu(absenTimeTP.getWaitingDay() ? DateHelper.add((Date)absenTimeTP.getValidFrom(), (int)-1) : absenTimeTP.getValidFrom());
            part.setEndeAu(absenTimeTP.getValidUntil());
            parts[i] = part;
        }
        dbvo.setEelDbvoParts(parts);
        return dbvo;
    }

    private EelDbbe createDbbe(EelDslw dslw) throws BusinessDomainException {
        EelDbbe dbbe = dslw.createDbbe();
        dbbe.setZahlBeginn(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
        BigDecimal brutto = EelDbbeHelper.getBeitrPflBrutto((EelEmployee)this.mEelEmployee);
        dbbe.setBeitrPflBrutto(brutto);
        BigDecimal netto = BigDecimal.ZERO;
        if (BigDecimalMapper.compareTo((BigDecimal)brutto, (BigDecimal)BigDecimal.ZERO) == 1) {
            netto = EelDbbeHelper.getBeitrPflNetto((EelEmployee)this.mEelEmployee, (BigDecimal)brutto);
        }
        dbbe.setBeitrPflNetto(netto);
        return dbbe;
    }

    private EelDblt createDblt(EelDslw dslw) throws BusinessDomainException {
        EelDblt dblt = dslw.createDblt();
        if (dslw.getAbgabegrund() != 22) {
            dblt.setBvSeit(this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfEntry());
            Date withdrawal = this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfWithDrawal();
            if (withdrawal != null) {
                dblt.setBvBis(withdrawal);
            }
            dblt.setBvAls(this.mEelEmployee.getInsurance(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getOccupationDescription(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom));
        }
        dblt.setAusbVerh(EelDbltHelper.getAusbVerh((EelEmployee)this.mEelEmployee) ? "J" : "N");
        if (dslw.getAbgabegrund() != 22 && dslw.getAbgabegrund() != 31) {
            if (this.mAnrVorErk) {
                dblt.setVorer("J");
                if (this.mEelEmployee.getInsurance(this.mValidFrom).getPrivateHI()) {
                    dslw.createDbvo();
                    dslw.getDbvo().setGrundAv(3);
                    dslw.getDbvo().setAuAbag(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
                    dslw.getDbvo().setAuAbsv(null);
                } else {
                    EelAccount vorErk = EelDbltHelper.getAnrechenbareVorerkrankungen((EelEmployee)this.mEelEmployee);
                    if (vorErk != null) {
                        EelDbvo newDbvo = vorErk.getEelDslw().getDbvo().createNewForReason11and12(dslw);
                        if (newDbvo != null) {
                            dslw.getDbvo().setAuAbag(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
                            dslw.getDbvo().setAuAbsv(null);
                        } else {
                            dslw.getDbvo().destroy();
                            dslw.setMmDbvo(false);
                            dblt.setVorer("N");
                        }
                    } else {
                        dblt.setVorer("N");
                    }
                }
            } else {
                dblt.setVorer("N");
            }
        }
        BigDecimal vwl = EelDbltHelper.getVwl((ValueType)this.mVwlValueType, (EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum);
        dblt.setVwl(vwl);
        BigDecimal brutto = EelDbltHelper.getBruttoSb((EelEmployee)this.mEelEmployee, (BigDecimal)vwl);
        dblt.setBruttoSb(brutto);
        if (brutto != null) {
            CertificateCalculationCase calc = new CertificateCalculationCase();
            calc.init(this.mEelEmployee.getEmployee(), this.mEelEmployee.getEffectiveTimePointForCalculation(), DateHelper.getFirstDayOfMonth((Date)this.mEelEmployee.getEEAbsentTimeTP().getValidFrom()), brutto);
            calc.start();
            dblt.setNettoSb(calc.getNetWage());
        }
        if (dslw.getAbgabegrund() != 22 && dslw.getAbgabegrund() != 31) {
            if (DateHelper.before((Date)EelDbaeHelper.getEazBeginn((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (int)0, (Date)this.mAbwZeitraum, (EelDbalHelper.getMmKug((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum, null) == 1 ? 1 : 0) != 0, (int)this.mReasonOfDelivery, (int)this.mEntgeltart), (Date)DATE_MMVERZBEITRAGS)) {
                dblt.setMmVerzichtBeitrags(EelDbltHelper.getMmVerzichtBeitrags((EelEmployee)this.mEelEmployee) ? "J" : "N");
            } else {
                dblt.setMmVerzichtBeitrags("N");
            }
            dblt.setAeUebergangsbereich(EelDbltHelper.getAeGleitzone((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum) ? "J" : "N");
        }
        if (dslw.getAbgabegrund() != 22) {
            dblt.setRechtskreis("" + EelDbltHelper.getRechtskreis((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany));
        }
        return dblt;
    }

    private EelDbap createDbap(EelDslw dslw) throws BusinessDomainException {
        EelDbap result = dslw.createDbap();
        DEUVSenderTP senderTP = this.mEelCompany.getDeuvSender().getDEUVSenderTP(VDate.getDateMax(), VDate.getDateMax());
        Employment employment = this.mEelEmployee.getEmployment(VDate.getDateMax(), this.mValidFrom);
        this.getHelper().fillDbap(result.getDbapData(), senderTP, employment, this.mValidFrom, DeuvHelper.TypeOfCommunication.EEL);
        return result;
    }

    private EelDbid createDbid(EelDslw dslw) {
        EelDbid dbid = dslw.createDbid();
        dbid.setAktenzeichenVu(this.getAzvu());
        return dbid;
    }

    private EelAccount createEelAccount(EelDslw dslw) throws BusinessDomainException {
        EelAccount account = new EelAccount(this.mEelEmployee.getEmployee());
        account.setEelEmployee(this.mEelEmployee);
        account.setEelDslw(dslw);
        Date effectiveFrom = new Date();
        Date effectiveFromMaster = this.mEelEmployee.getEmployee().getMaster(this.mEelEmployee.getEffectiveTimePoint(), this.mEelEmployee.getEEAbsentTimeTP().getValidFrom()).getEffectiveFrom();
        if (DateHelper.before((Date)effectiveFrom, (Date)effectiveFromMaster)) {
            effectiveFrom = effectiveFromMaster;
        }
        account.setEffectiveFrom(effectiveFrom);
        account.setCreatedOn(this.getCreatedOnString());
        account.setValidFrom(this.mEelEmployee.getEEAbsentTimeTP().getValidFrom());
        account.setValidUntil(this.mEelEmployee.getEEAbsentTimeTP().getValidUntil());
        account.setReasonOfDelivery(dslw.getAbgabegrund());
        account.setCanceled("N");
        account.setErrorMessage("");
        account.setAktenzeichenVU(dslw.getDbid().getAktenzeichenVu());
        account.setAdviceState(EelAdviceStateEnum.AUFGEBAUT);
        account.setDEUVRecipient(this.getDEUVRecipient(this.mValidFrom));
        return account;
    }

    public void deleteAccount(EelAccount account) throws BusinessDomainException {
        if (account.getReasonOfDelivery() == 61 || account.getReasonOfDelivery() == 62 || account.getReasonOfDelivery() == 66 || account.getReasonOfDelivery() == 71) {
            throw new IllegalArgumentException("The reason of delivery " + account.getReasonOfDelivery() + " is not supported.");
        }
        if (account.getAdviceState().equals((Object)EelAdviceStateEnum.AUFGEBAUT) || account.getAdviceState().equals((Object)EelAdviceStateEnum.BEREIT)) {
            account.makeSaveable();
            account.destroy();
        } else if (account.getAdviceState().equals((Object)EelAdviceStateEnum.VERARBEITET)) {
            this.makeCancellation(account);
        } else if (account.getAdviceState().equals((Object)EelAdviceStateEnum.VORSCHLAG_STORNO)) {
            account.makeSaveable();
            if (account.getCanceled().equals("X")) {
                account.setAdviceState(EelAdviceStateEnum.VERARBEITET);
                account.setCanceled("N");
            } else {
                account.setAdviceState(EelAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT);
            }
        } else {
            throw EelExceptionMapper.makeNoDeleteOrCancellationAllowedDomainException((String)(account.getAktenzeichenVU() + " " + account.getValidFrom()));
        }
    }

    public EelAccount makeCancellation(EelAccount account) throws BusinessDomainException {
        this.mReasonOfDelivery = account.getReasonOfDelivery();
        EelAccount storno = account.makeCancelation();
        storno.makeSaveable();
        this.checkConvertToV12(storno);
        storno.setCreatedOn(this.mCreatedOnString);
        storno.getEelDslw().setDatumErstellung(this.getCreatedOnString());
        storno.getEelDslw().setBbnrAbsender(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.mEelCompany.getDeuvSender()));
        storno.getEelDslw().setBbnrEmpfaenger(this.getUpdatedRecipient(storno.getEelDslw().getBbnrEmpfaenger(), account.getValidFrom()));
        String stdCompNoKK = account.getEelDslw().getBbnrKK();
        String updatedStdCompNoKK = DeuvRecipientMap.updateStdCompNoHealthFund((String)stdCompNoKK, (Date)account.getValidFrom());
        storno.getEelDslw().setBbnrKK(updatedStdCompNoKK);
        storno.getEelDslw().setBbnrVU(this.getEECompanyPlantCancel(storno.getEmployee(), account.getValidFrom()).getCompanyNumber());
        storno.getEelDslw().setProdId(DeuvBasics.getProdId());
        storno.getEelDslw().setModId(DeuvBasics.getModId());
        storno.getEelDslw().setVersicherungsnr(storno.getEmployee().getActiveInsurance().getInsuranceNo());
        storno.setAdviceState(EelAdviceStateEnum.VORSCHLAG_STORNO);
        DEUVRecipient deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getEelDslw().getBbnrKK());
        storno.setDEUVRecipient(deuvRecipient);
        this.checkAttributes(storno);
        return storno;
    }

    public void checkAttributes(EelAccount eelAccount) throws BusinessDomainException {
        KernpruefungEEL12Impl kp = new KernpruefungEEL12Impl();
        String vosz = EelComponents.getContentVoszForCheck((EelAccount)eelAccount, (EelCompany)this.mEelCompany);
        String dsko = EelComponents.getDskoForCheck((EelAccount)eelAccount, (EelCompany)this.mEelCompany, (String)this.getCreatedOnString());
        StringBuffer dslw = new StringBuffer();
        dslw.append(EelComponents.getContentEelDslw((EelDslw)eelAccount.getEelDslw()));
        Rueckgabe rueckgabe = kp.pruefe(dsko, vosz);
        eelAccount.addIfError(rueckgabe);
        rueckgabe = kp.pruefe(dslw.toString(), vosz);
        eelAccount.addIfError(rueckgabe);
    }

    private void checkConvertToV10(EelAccount storno) throws BusinessDomainException {
        if (storno.getEelDslw().getEelVersion() == 9) {
            EelDblt dblt;
            storno.getEelDslw().setEelVersion(10);
            if (storno.getEelDslw().hasMmDbmu()) {
                EelDbmu dbmu = storno.getEelDslw().getDbmu();
                if ("J".equals(dbmu.getAeFest())) {
                    dbmu.setEntgArt(2);
                } else {
                    dbmu.setEntgArt(1);
                }
            }
            if (storno.getEelDslw().hasMmDblt() && "J".equals((dblt = storno.getEelDslw().getDblt()).getVorer())) {
                EelDbvoPart part;
                EelDbvo dbvo = storno.getEelDslw().createDbvo();
                ArrayList<EelDbvoPart> parts = new ArrayList<EelDbvoPart>();
                if (dblt.getVorerBeginn1() != null) {
                    part = new EelDbvoPart(dbvo);
                    part.setBeginnAu(dblt.getVorerBeginn1());
                    part.setEndeAu(dblt.getVorerEnde1());
                    part.setKzAu(1);
                    parts.add(part);
                }
                if (dblt.getVorerBeginn2() != null) {
                    part = new EelDbvoPart(dbvo);
                    part.setBeginnAu(dblt.getVorerBeginn2());
                    part.setEndeAu(dblt.getVorerEnde2());
                    part.setKzAu(1);
                    parts.add(part);
                }
                dbvo.setEelDbvoParts(parts.toArray(new EelDbvoPart[parts.size()]));
                dbvo.setAnzahlAu(parts.size());
                dbvo.setGrundAv(3);
                if (storno.getEelDslw().hasMmDblt()) {
                    dbvo.setAuAbag(storno.getEelDslw().getDbal().getDatumAb());
                }
            }
        }
    }

    private void checkConvertToV11(EelAccount storno) throws BusinessDomainException {
        this.checkConvertToV10(storno);
        if (storno.getEelDslw().getEelVersion() == 10) {
            storno.getEelDslw().setEelVersion(11);
            storno.getEelDslw().setAbrechnungsprogramm(1);
        }
    }

    private void checkConvertToV12(EelAccount storno) throws BusinessDomainException {
        this.checkConvertToV11(storno);
        if (storno.getEelDslw().getEelVersion() == 11) {
            storno.getEelDslw().setEelVersion(12);
            if (storno.getEelDslw().hasMmDbal()) {
                EelDbal dbal = storno.getEelDslw().getDbal();
                dbal.setKinderunter25(0);
            }
            if (storno.getEelDslw().hasMmDbfr()) {
                EelDbfr dbfr = storno.getEelDslw().getDbfr();
                dbfr.setKinderunter25(0);
            }
        }
    }

    private String getRecipient() throws BusinessDomainException {
        String key = this.mEelEmployee.getEEAbsentTimeTP().getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey();
        block0 : switch (this.mReasonOfDelivery) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 41: {
                return this.getHealthFundStdCompNo(this.mEelEmployee.getEmployee(), this.mValidFrom);
            }
            case 11: 
            case 12: {
                return DSRV;
            }
            case 21: 
            case 23: {
                if (this.isHealthFund()) {
                    return this.getHealthFundStdCompNo(this.mEelEmployee.getEmployee(), this.mValidFrom);
                }
            }
            case 22: {
                if (this.isSVLFG(this.mIkuv)) {
                    return SVLFG;
                }
                if (this.isTestSender()) {
                    return DGUV_EVPT;
                }
                return DGUV;
            }
            case 31: {
                if (this.isTestSender()) {
                    return BA_EVPT;
                }
                return BA;
            }
            case 42: 
            case 51: {
                if (this.mEelEmployee == null) {
                    return null;
                }
                if (key.equals("4.1") || key.equals("4.5")) {
                    return this.getHealthFundStdCompNo(this.mEelEmployee.getEmployee(), this.mValidFrom);
                }
                EelAccount[] results = EelAccount.getEelAccountByEeAbsentTimeAI(this.mEelEmployee.getEmployee().getObjectid(), DateMapper.toString((Date)this.mEelEmployee.getEEAbsentTimeTP().getValidFrom()));
                if (results == null || results.length == 0) {
                    throw EelExceptionMapper.makeNoNewMessagesCreatedDomainException();
                }
                if (results[0].getEelDslw().hasMmDbun()) {
                    this.mUnfallAz = results[0].getEelDslw().getDbun().getUnfallAz();
                    this.mVtag = results[0].getEelDslw().getDbun().getVtag();
                    this.mIkuv = results[0].getEelDslw().getDbun().getIkuv();
                    this.mZuschlag1 = results[0].getEelDslw().getDbun().getZuschl1();
                    this.mZuschlag2 = results[0].getEelDslw().getDbun().getZuschl2();
                    this.mZuschlag3 = results[0].getEelDslw().getDbun().getZuschl3();
                }
                return results[0].getEelDslw().getBbnrEmpfaenger();
            }
            case 99: {
                switch (key) {
                    case "1.1": 
                    case "4.1": 
                    case "4.2": 
                    case "4.5": 
                    case "10.9": {
                        return this.getHealthFundStdCompNo(this.mEelEmployee.getEmployee(), this.mValidFrom);
                    }
                    case "4.3": {
                        switch (this.mRecipient) {
                            case 1: {
                                return DSRV;
                            }
                            case 2: {
                                if (this.isTestSender()) {
                                    return DGUV_EVPT;
                                }
                                return DGUV;
                            }
                            case 3: {
                                if (this.isTestSender()) {
                                    return BA_EVPT;
                                }
                                return BA;
                            }
                        }
                        break block0;
                    }
                }
                throw new IllegalArgumentException("The recipient " + this.mRecipient + " for reason 99 is not supported.");
            }
        }
        throw new IllegalArgumentException("The reason of delivery " + this.mReasonOfDelivery + " is not supported.");
    }

    private String getUpdatedRecipient(String bbnr, Date validTimePoint) throws BusinessDomainException {
        switch (bbnr) {
            case "66667777": 
            case "47056789": 
            case "99300900": 
            case "22672327": 
            case "99300330": 
            case "76641777": {
                return bbnr;
            }
        }
        return DeuvRecipientMap.updateStdCompNoHealthFund((String)bbnr, (Date)validTimePoint);
    }

    private boolean isHealthFund() throws BusinessDomainException {
        if (this.mWorkDisease) {
            return false;
        }
        return !this.mEelEmployee.getInsurance(this.mValidFrom).getPrivateHI();
    }

    private boolean isSVLFG(String ikuv) {
        IKData ikdata = IKDataUtil.getIKDatasByFullIKnummer((String)ikuv);
        return ikdata != null && ikdata.getName1().startsWith("SVLFG");
    }

    private String getHealthFundStdCompNo(Employee emp, Date validTimePoint) throws BusinessDomainException {
        return this.getHealthFund(emp, validTimePoint).getHealthFundTP(VDate.getDateMax(), validTimePoint).getStandardCompanyNumber();
    }

    private HealthFund getHealthFund(Employee emp, Date validTimePoint) throws BusinessDomainException {
        Insurance ins = emp.getInsurance(VDate.getDateMax(), validTimePoint);
        HealthFund hf = ins.getHealthFund();
        int pgs = ins.getPersonGroup();
        if (pgs == 109 || pgs == 110 || pgs == 190) {
            hf = ins.getLegalHealthFund();
        }
        return HealthFund.getHealthFundConsiderFusions((HealthFund)hf, (Date)validTimePoint);
    }

    public String getCreatedOnString() {
        return this.mCreatedOnString;
    }

    public Date getCreatedOnDate() {
        return this.mCreatedOnDate;
    }

    public Date getEelStartDate() throws BusinessDomainException {
        return DateHelper.max((Date)this.mEelCompany.getDateOfEelStart(), (Date)DeuvHelper.getCalculationStart((PCompany)this.mEelCompany.getPCompany()));
    }

    public boolean isAffectedBySpecialAccess() {
        return this.mAffectedBySpecialAccess;
    }

    public void setAffectedBySpecialAccess(boolean affectedBySpecialAccess) {
        this.mAffectedBySpecialAccess = affectedBySpecialAccess;
    }

    public boolean isCreateOfSuggestionPossible() throws BusinessDomainException {
        Insurance ins;
        int pgs;
        if (this.mReasonOfDelivery != 41) {
            if (!this.mEelEmployee.getEmployee().getStateOfValuation()) {
                throw EelExceptionMapper.makeEmployeeWithCalculationStateException((String)this.mEelEmployee.getEmployee().getIDString());
            }
            if (this.mEelEmployee.getEmployee().getInValuation()) {
                throw EelExceptionMapper.makeEmployeeInValuationException((String)this.mEelEmployee.getEmployee().getIDString());
            }
            if (this.mEelEmployee.getEmployee().isCalculationScheduled()) {
                throw EelExceptionMapper.makeEmployeeWaitingForCalculationException((String)this.mEelEmployee.getEmployee().getIDString());
            }
        }
        if (this.mReasonOfDelivery == 42) {
            String[] reasons = new String[]{"01", "04", "11", "12", "21", "22"};
            String[] states = new String[]{"" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.UEBERMITTELT), "" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VERARBEITET)};
            EelAccount[] origins = EelAccount.getEelAccountOrigins(this.mEelEmployee.getEmployee().getObjectid(), this.mEelEmployee.getEEAbsentTimeTP().getValidFrom(), reasons, states);
            if (origins == null || origins.length < 1) {
                throw EelExceptionMapper.makeReason42NotAllowedException();
            }
        }
        String key = this.mEelEmployee.getEEAbsentTimeTP().getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey();
        Date calcStart = this.mCalcStart;
        Date lastPeriod = EelDbalHelper.getLetzterAbrMonatVon((EelEmployee)this.mEelEmployee, (EelCompany)this.mEelCompany, (Date)this.mAbwZeitraum);
        if (DateHelper.before((Date)lastPeriod, (Date)calcStart)) {
            throw EelExceptionMapper.makeNoMonthCalculatedException();
        }
        if ((this.mReasonOfDelivery == 2 || this.mReasonOfDelivery == 23) && StringMapper.isNullString((String)this.mEelEmployee.getEEAbsentTimeTP().getAdditionalInfo())) {
            throw EelExceptionMapper.makeNoChildDomainException((String)"1.1");
        }
        if (this.mBruttoAbw && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVereinbBrutto) && this.mEntgeltart == 2) {
            throw EelExceptionMapper.makeAgreedGrossNeededDomainException();
        }
        if (this.mReasonOfDelivery == 41) {
            if (EelDbvoHelper.getFehlzeiten((EelEmployee)this.mEelEmployee, (int)6).length == 0) {
                throw EelExceptionMapper.makeNoAUInLastSixMonthDomainException();
            }
            if (!StringMapper.equal((String)"4.3", (String)key)) {
                Date validUntil;
                if (this.getDays() < 30) {
                    throw EelExceptionMapper.makeNotEnoughDaysDomainException();
                }
                if (this.getDays() <= 42 && (validUntil = this.mEelEmployee.getEEAbsentTimeTP().getValidUntil()) != null && DateHelper.before((Date)validUntil, (Date)VDate.getCurrentLocalizedDateAndTime())) {
                    throw EelExceptionMapper.makeNotNecessaryDomainException();
                }
            }
        }
        if ((pgs = (ins = this.mEelEmployee.getInsurance(this.mValidFrom)).getPersonGroup()) >= 900) {
            throw EelExceptionMapper.makePGS9XXNotAllowedException();
        }
        if (!(this.mReasonOfDelivery != 1 && this.mReasonOfDelivery != 2 && this.mReasonOfDelivery != 3 && this.mReasonOfDelivery != 41 || pgs != 109 && pgs != 110 && pgs != 190 || pgs == 109 && (this.mReasonOfDelivery == 41 && ins.getDuesGroupHI() == 3 || ins.getDuesGroupPI() == 1) && ins.getUseTransitionBy31122022())) {
            throw EelExceptionMapper.makePGSNotAllowedDomainException();
        }
        if ((pgs == 109 || pgs == 110 || pgs == 190) && ins.getLegalHealthFund() == null) {
            throw EelExceptionMapper.makeDiffHealthFundNeededException();
        }
        if ((this.mReasonOfDelivery == 1 || this.mReasonOfDelivery == 2 || this.mReasonOfDelivery == 3 || this.mReasonOfDelivery == 41 || this.mReasonOfDelivery == 21 || this.mReasonOfDelivery == 22 || this.mReasonOfDelivery == 23 || this.mReasonOfDelivery == 31) && pgs == 110) {
            throw EelExceptionMapper.makePGS110NotAllowedDomainException();
        }
        if ((this.mReasonOfDelivery == 1 || this.mReasonOfDelivery == 2 || this.mReasonOfDelivery == 3 || this.mReasonOfDelivery == 41) && ins.getPrivateHI() && ins.getDuesGroupHI() <= 0) {
            throw EelExceptionMapper.makePrivateHiNotAllowedDomainException();
        }
        if ((this.mReasonOfDelivery == 11 || this.mReasonOfDelivery == 12) && ins.getDuesGroupPI() <= 0) {
            throw EelExceptionMapper.makePiFreeNotAllowedDomainException();
        }
        if (this.mReasonOfDelivery == 99) {
            if (StringMapper.equal((String)"4.3", (String)key) && this.mRecipient == 0) {
                throw EelExceptionMapper.makeReceipientNeededDomainException();
            }
            if (!this.isAdviceableFor99()) {
                throw EelExceptionMapper.makeReason99NotAllowedDomainException();
            }
        }
        Date entry = this.mEelEmployee.getEmployment(this.mEelEmployee.getEffectiveTimePoint(), this.mValidFrom).getDateOfEntry();
        if (!(this.mReasonOfDelivery != 1 && this.mReasonOfDelivery != 11 && this.mReasonOfDelivery != 12 && this.mReasonOfDelivery != 23 && this.mReasonOfDelivery != 3 || !DateHelper.equal((Date)entry, (Date)this.mValidFrom) || DateHelper.equal((Date)this.mCalcStart, (Date)this.mValidFrom) || this.mEelEmployee.getEmployee().isPredecessor())) {
            throw EelExceptionMapper.makeReceipientNeededDomainException();
        }
        if (this.mDauEntgErh && DateHelper.getFirstDayOfMonth((Date)entry).equals(DateHelper.getFirstDayOfMonth((Date)this.mValidFrom))) {
            throw EelExceptionMapper.makeCompensationIncreaseDomainException();
        }
        return true;
    }

    private boolean isAdviceableFor99() {
        EECarriedForwardSystemSIBreak[] breaks = this.mEelEmployee.getEmployee().getEECarriedForwardSystemSIBreak();
        Date calcStart = this.mEelEmployee.getEmployee().getCalculationStart();
        EEAbsentTimeTP actualAT = this.mEelEmployee.getEEAbsentTimeTP();
        for (EECarriedForwardSystemSIBreak each : breaks) {
            if (!DateHelper.equal((Date)DateHelper.tomorrow((Date)each.getValidUntil()), (Date)calcStart) || !actualAT.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey().equals(each.getAbsentTime().getDEUVAbsentTimeKey()) || !DateHelper.equal((Date)actualAT.getValidFrom(), (Date)calcStart)) continue;
            return true;
        }
        return false;
    }

    public int getDays() {
        int result = 0;
        for (EEAbsentTimeTP each : EelDbvoHelper.getFehlzeiten((EelEmployee)this.mEelEmployee, (int)12)) {
            result = each.getValidUntil().equals(VDate.getDateMax()) ? result + DateHelper.getDiffInDays((Date)this.mCreatedOnDate, (Date)each.getValidFrom()) + 1 + 7 : result + DateHelper.getDiffInDays((Date)each.getValidUntil(), (Date)each.getValidFrom()) + 1;
        }
        EEAbsentTimeTP tp = this.mEelEmployee.getEEAbsentTimeTP();
        result = tp.getValidUntil().equals(VDate.getDateMax()) ? result + DateHelper.getDiffInDays((Date)this.mCreatedOnDate, (Date)tp.getValidFrom()) + 1 + 7 : result + DateHelper.getDiffInDays((Date)tp.getValidUntil(), (Date)tp.getValidFrom()) + 1;
        return result;
    }

    private IEECompanyPlant getEECompanyPlantCancel(Employee emp, Date validFrom) {
        IEECompanyPlant mEECompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        mEECompanyPlant.setEmployee(emp);
        mEECompanyPlant.setEffectiveFrom(VDate.getDateMax());
        mEECompanyPlant.setValidFrom(validFrom);
        return mEECompanyPlant;
    }

    private IEECompanyPlant getEECompanyPlant(Date validFrom) {
        IEECompanyPlant mEECompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        mEECompanyPlant.setEmployee(this.mEelEmployee.getEmployee());
        mEECompanyPlant.setEffectiveFrom(this.mEelEmployee.getEffectiveTimePoint());
        mEECompanyPlant.setValidFrom(validFrom);
        return mEECompanyPlant;
    }

    private String getAzvu() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mEelCompany.getPCompany().getPCompanyKey());
        sb.append(" / ");
        sb.append(this.mEelEmployee.getEmployee().getPersonnelnumber());
        return sb.toString();
    }

    private StatisticalValue getStatisticalValue(String oidStatisticalValue) {
        if (StringMapper.isNullString((String)oidStatisticalValue)) {
            return null;
        }
        return StatisticalValue.getStatisticalValue((String)oidStatisticalValue);
    }

    private ValueType getValueType(String oidValueType) {
        if (StringMapper.isNullString((String)oidValueType)) {
            return null;
        }
        return ValueType.getValueType((String)oidValueType);
    }

    public static Criterion getFilter() {
        return Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.BEREIT))), Restrictions.eq((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO)))});
    }

    public List<EelAccount> getUntransmitteds(SpecialAccess specialAccess) throws BusinessDomainException {
        Criterion filter = EelAdvice.getFilter();
        ArrayList<EelAccount> accounts = new ArrayList<EelAccount>();
        for (Criterion empFilter : EelAccount.getEmployeeFilter(this.mEelCompany.getPCompany().getObjectid(), null, null)) {
            EelAccount[] rows = EelAdvice.getIEelAccountPM().query(null, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            accounts.addAll(Arrays.asList(rows));
        }
        EelAccount[] filtered = (EelAccount[])specialAccess.filter((IEmployeeReferenced[])accounts.toArray(new EelAccount[accounts.size()]));
        if (accounts.size() != filtered.length) {
            this.setAffectedBySpecialAccess(true);
        }
        List<EelAccount> untransmittedsList = EelAdvice.getUntransmittedsWithoutError(filtered);
        Collections.sort(untransmittedsList, this.getEelAccountComparator());
        return untransmittedsList;
    }

    public static List<EelAccount> getUntransmittedsWithoutError(EelAccount[] accounts) throws BusinessDomainException {
        ArrayList<EelAccount> untransmittedsList = new ArrayList<EelAccount>();
        for (EelAccount account : accounts) {
            if (account.getCanceled().equals("X") || account.hasErrors() && !account.getErrorMessage().startsWith("NCSZH10")) continue;
            untransmittedsList.add(account);
        }
        return untransmittedsList;
    }

    protected Comparator<EelAccount> getEelAccountComparator() {
        return new EelAccountComparator();
    }

    public EelCompany getEelCompany() {
        return this.mEelCompany;
    }

    public String getCompanyDescription() throws BusinessDomainException {
        return this.mEelCompany.getPCompanyName();
    }

    private DEUVRecipient getDEUVRecipient(Date validTimePoint) throws BusinessDomainException {
        return this.mRecipientMap.getDeuvRecipient(this.getHealthFund(this.mEelEmployee.getEmployee(), validTimePoint));
    }

    public static final String formatEelTimestampForQuery(Date d) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(d);
    }

    public void makeCancellation() throws BusinessDomainException {
        Date eelStart = this.getEelStartDate();
        EelAccount[] accountToCheck = EelAccount.getEelAccountsForCancelCheck(eelStart, this.mEelCompany.getPCompany().getObjectid());
        if (accountToCheck.length < 1) {
            throw EelExceptionMapper.makeNoMessagesForCancellationDomainException();
        }
        ArrayList<EelAccount> created = new ArrayList<EelAccount>();
        for (EelAccount account : accountToCheck) {
            EelAccount origin;
            EEAbsentTimeTP absentTimeTP;
            boolean storno = false;
            if (!account.isCancelDeleted(eelStart) && account.getReasonOfDelivery() != 71) {
                absentTimeTP = account.getEEAbsentTimeTP();
                if (absentTimeTP == null) {
                    this.mEelEmployee = null;
                    created.add(this.makeCancellation(account));
                } else if (account.isCancelationNewReason() && account.hasModifications(absentTimeTP)) {
                    this.mEelEmployee = new EelEmployee(account.getEmployee(), absentTimeTP);
                    this.mEelCompany = new EelCompany(account.getEmployee().getPCompany());
                    this.mValidFrom = absentTimeTP.getValidFrom();
                    EelAccount newAcc = account.createNew();
                    newAcc.setLastuser(SessionContext.getInstance().getSession().getUserCode());
                    this.checkConvertToV12(newAcc);
                    created.add(this.makeCancellation(account));
                    this.setNewValues(newAcc, absentTimeTP);
                    newAcc.setAdviceState(EelAdviceStateEnum.VORSCHLAG_STORNO);
                    this.checkAttributes(newAcc);
                    newAcc.makeSaveable();
                    created.add(newAcc);
                    storno = true;
                }
            }
            if (storno || account.getReasonOfDelivery() != 71 || account.hasReason51(eelStart) || (absentTimeTP = account.getEEAbsentTimeTP()) == null || (origin = this.getOrigin(account)) == null || !origin.getEelDslw().hasMmDbae() || BigDecimalMapper.isZeroOrNull((BigDecimal)origin.getEelDslw().getDbae().getBruttoAe())) continue;
            this.mReasonOfDelivery = 51;
            this.mEelEmployee = new EelEmployee(account.getEmployee(), absentTimeTP);
            this.mEelCompany = new EelCompany(account.getEmployee().getPCompany());
            this.mValidFrom = absentTimeTP.getValidFrom();
            EelDslw dslw = this.createDslw();
            this.createHoeheBeitragspflEinnahmen(dslw);
            EelAccount newAccount = this.createAccount(dslw);
            this.checkAttributes(newAccount);
            if (!newAccount.hasErrors()) {
                newAccount.setAdviceState(EelAdviceStateEnum.BEREIT);
            }
            newAccount.makeSaveable();
        }
        if (created.isEmpty()) {
            throw EelExceptionMapper.makeNoMessagesForCancellationDomainException();
        }
    }

    private void setNewValues(EelAccount newAcc, EEAbsentTimeTP tp) throws BusinessDomainException {
        EelDslw dslw = newAcc.getEelDslw();
        if (dslw.hasMmDbfr()) {
            dslw.getDbfr().setFreiStVom(tp.getValidFrom());
            dslw.getDbfr().setFreiStBis(tp.getValidUntil());
            BigDecimal[] results = EelDbfrHelper.getFreiStResults((EelEmployee)this.mEelEmployee, (Date)dslw.getDbfr().getFreiStVom(), (Date)dslw.getDbfr().getFreiStBis());
            dslw.getDbfr().setFreiStBrutto(results[0]);
            dslw.getDbfr().setFreiStNetto(results[1]);
        }
        newAcc.setValidUntil(tp.getValidUntil());
    }

    public static String[] getDeuvAbsentTimeKeys(int reasonOfDelivery) {
        String[] keys = null;
        switch (reasonOfDelivery) {
            case 0: {
                keys = new String[]{"1.1", "4.1", "4.2", "4.3", "4.5", "10.9"};
                break;
            }
            case 100: {
                keys = new String[]{"10.31", "10.32", "10.33"};
                break;
            }
            case 1: {
                keys = new String[]{"4.1", "10.9"};
                break;
            }
            case 4: {
                keys = new String[]{"4.1", "10.9", "4.11"};
                break;
            }
            case 2: 
            case 23: {
                keys = new String[]{"1.1"};
                break;
            }
            case 3: {
                keys = new String[]{"4.5"};
                break;
            }
            case 11: 
            case 12: 
            case 22: 
            case 31: {
                keys = new String[]{"4.3"};
                break;
            }
            case 21: {
                keys = new String[]{"4.2"};
                break;
            }
            case 41: 
            case 61: {
                keys = new String[]{"10.31", "10.32", "10.33", "4.3", "4.1", "4.10", "10.10"};
                break;
            }
            case 42: 
            case 62: {
                keys = new String[]{"4.1", "4.2", "4.3", "4.5", "1.1"};
                break;
            }
            case 51: {
                keys = new String[]{"4.1", "4.5"};
                break;
            }
            case 71: {
                keys = new String[]{"4.1", "4.2", "4.3", "1.1"};
                break;
            }
            case 99: {
                keys = new String[]{"1.1", "4.1", "4.2", "4.3", "4.5", "10.9"};
                break;
            }
            default: {
                throw new IllegalArgumentException("The reason of delivery " + reasonOfDelivery + " is not supported.");
            }
        }
        return keys;
    }

    private boolean isDGUV(EelDslw dslw) {
        return dslw.getBbnrEmpfaenger().equals(DGUV) || dslw.getBbnrEmpfaenger().equals(DGUV_EVPT);
    }

    private boolean isTestSender() throws BusinessDomainException {
        return DeuvHelper.getDeuvSender((PCompany)this.mEelCompany.getPCompany()).isTestSender();
    }

    private boolean isFullAbsentTime220(Date from) {
        EEAbsentTimeTP[] tps;
        for (EEAbsentTimeTP tp : tps = this.mEelEmployee.getEmployee().getEffectiveEEAbsentTimes(this.mEelEmployee.getEffectiveTimePoint(), from)) {
            if (!tp.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey().equals("2.20") || !DateHelper.beforeOrEqual((Date)tp.getValidFrom(), (Date)from) || !DateHelper.afterOrEqual((Date)tp.getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)from))) continue;
            return true;
        }
        return false;
    }

    private EelAccount getOrigin(EelAccount account) {
        return EelAccount.getEelAccountOneOriginOrNull(account.getEmployee().getObjectid(), account.getValidFrom(), new String[]{"1", "3", "11", "12", "21", "22", "31"});
    }

    public static EEAbsentTimeTP[] shrinkEEAbsentTimeTPListForReason04(EEAbsentTimeTP[] tps) {
        ArrayList<EEAbsentTimeTP> tpList = new ArrayList<EEAbsentTimeTP>();
        for (EEAbsentTimeTP tp : tps) {
            if (!"4.11".equals(tp.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) && (!DateHelper.beforeOrEqual((Date)tp.getValidFrom(), (Date)DATE_REASON_04_END) || !DateHelper.afterOrEqual((Date)tp.getValidUntil(), (Date)DATE_REASON_04_BEGIN))) continue;
            tpList.add(tp);
        }
        return tpList.toArray(new EEAbsentTimeTP[tpList.size()]);
    }

    private static IEelAccountPersistencyManager getIEelAccountPM() {
        return (IEelAccountPersistencyManager)UtilitiesManager.getBean((String)"eelAccountPersistencyManager", IEelAccountPersistencyManager.class);
    }

    private DeuvDbapFillHelper getHelper() {
        return (DeuvDbapFillHelper)UtilitiesManager.getApplicationContext().getBean("deuvDbapFillHelper");
    }
}

