/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.receive;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvResponse;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbap;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eau.eaudbap.EauDbap;
import com.varial.personnel.domain.eau.eaudxkk.EauDxkk;
import com.varial.personnel.domain.eau.eaudxkk.NachweisartEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EauReceive
extends BasicReceive<EauAccount> {
    private static final String[] FILENAMEFILTER = new String[]{"EEAA0", "TEAA0", "EEAR0", "TEAR0"};
    private static final int LENGTH_TO_FILENUMBER = 71;
    private static final Pattern VOSX_TO_FILENUMBER = Pattern.compile("VOSX(\\d{6})(.{5})(.{15})(.{15})(\\d{20})(\\d{6})(.*)");
    private static final Pattern DXKK1_A = Pattern.compile("DXKK010001(.{15})(.{15})(\\d{20})(.{7})(.{8})(.{32})(.{20})(.{1})(.{32})(.{15})(\\d{1})(.*)");
    private static final int DXKK_REST_GROUP = 12;
    private static final Pattern DBAP = Pattern.compile("(.{1})(.{30})(.{20})(.{20})(.{70})(.{30})(.{30})(.{30})(.{10})(.{34})(.{33})(.{09})(.{100})(.*)");
    private static final int DBAP_LENGTH = 417;
    private static final Pattern DXKK1_B = Pattern.compile("(.{1})(.{30})(.{30})(.{12})(\\d{8})(\\d{8})(\\d{8})(\\d{8})(.{1})(.{1})(.{1})(.{1})(.{1})(.{1})(.{500})(.*)");
    private static final int DXKK1_B_LENGTH = 611;
    private static final Pattern DXKK1_B2 = Pattern.compile("(.{1})(.{30})(.{30})(.{12})(\\d{8})(\\d{8})(\\d{8})(\\d{8})(.{1})(.{1})(.{1})(.{1})(.{1})(\\d{8})(\\d{8})(.{1})(.{500})(.*)");
    private static final int DXKK1_B2_LENGTH = 627;
    private static final Pattern DXKK2_A = Pattern.compile("DXKK020000(.{15})(.{15})(\\d{20})(.{7})(.{8})(.{36})(.{256})(.{1})(.*)");
    private static final int DXKK2_REST_GROUP = 9;
    private static final Pattern DXKK2_R = Pattern.compile("(.{15})(.{36})(\\d{1})(.*)");
    private static final int DXKK2_R_LENGTH = 52;
    private static final Pattern DBAP2 = Pattern.compile("(.{256})(.{20})(.{20})(.{320})(.{256})(.{32})(.{256})(.{256})(.{9})(.*)");
    private static final int DBAP2_LENGTH = 1425;
    private static final Pattern DXKK2_AN = Pattern.compile("(.{256})(.{256})(.{12})(\\d{2})(\\d{8})(.*)");
    private static final int DXKK2_AN_LENGTH = 534;
    private static final Pattern DXKK2_NW = Pattern.compile("(.{8})(.{8})(.{8})(.*)");
    private static final int DXKK2_NW_LENGTH = 24;
    private static final Pattern DXKK2_AU = Pattern.compile("(.{8})(.{1})(.{1})(.{1})(.{1})(.*)");
    private static final int DXKK2_AU_LENGTH = 12;
    private static final Pattern DXKK2_S = Pattern.compile("(.{36})(\\d{1})(.*)");
    private static final int DXKK2_S_LENGTH = 37;
    private static final Pattern DXKK2_VS = Pattern.compile("(.{12})(.*)");
    private static final int DXKK2_VS_LENGTH = 12;
    private static final Pattern DXKK2_GD = Pattern.compile("(.{256})(.{256})(.*)");
    private static final int DXKK2_GD_LENGTH = 512;
    private static final Pattern DXKK2_S2 = Pattern.compile("(.{256})(.{256})(\\d{8})(.*)");
    private static final int DXKK2_S2_LENGTH = 520;
    private static final Pattern NUMBERPATTERN = Pattern.compile("(\\d{6})");
    private static final Pattern DXVE = Pattern.compile("DXVE010000(.{32})(\\d{1})(\\d{6})(.{7})(.{2000})(.*)");
    private static final Pattern DXVE2 = Pattern.compile("DXVE020000(.{36})(\\d{1})(.*)");
    private static final Pattern DXVE2_CONFIRM = Pattern.compile("(\\d{6})(.*)");
    private static final Pattern DXVE2_PARSEERROR = Pattern.compile("(.{1024})(.*)");
    private static final Pattern DXVE2_FILEERROR = Pattern.compile("(\\d{6})(.{10})(.{1024})(.*)");
    private static final Pattern DXVD = Pattern.compile("DXVD010000(.{32})(\\d{6})(.{32})(\\d{1})(.*)");
    private static final Pattern DXVD_ERROR = Pattern.compile("(.{7})(.{64})(.{100})(.*)");
    private static final Pattern DXVD2 = Pattern.compile("DXVD020000(.{36})(\\d{6})(.{36})(\\d{1})(.*)");
    private static final Pattern DXVD2_ERROR = Pattern.compile("(.{10})(.{1024})(.*)");
    private static final int DXVE_LENGTH = 2156;
    private static final int DXVE2_MIN_LENGTH = 47;
    private static final int DXVE2_CONFIRM_LENGTH = 6;
    private static final int DXVE2_PARSEERROR_LENGTH = 1024;
    private static final int DXVE2_FILEERROR_LENGTH = 1040;
    private static final int DXVD_MIN_LENGTH = 352;
    private static final int DXVD_ERROR_LENGTH = 171;
    private static final int DXVD2_MIN_LENGTH = 89;
    private static final int DXVD2_ERROR_LENGTH = 1034;
    private final AuthorizationToken mToken;
    private boolean mVersion2 = false;
    private String mArt;
    private String mId;

    public EauReceive(DEUVSender deuvSender, AuthorizationToken token) {
        super(deuvSender);
        this.mToken = token;
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    @Override
    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile(file, "Meldung elektronische Arbeitsunf\u00e4higkeitsbescheinigung");
        CharSequence content = PFileHelper.getFileContent(file, ISO_8859_1, 71);
        Matcher matcherVosx = VOSX_TO_FILENUMBER.matcher(content);
        if (matcherVosx.matches()) {
            String name = file.getName().toUpperCase();
            if (name.startsWith("EEAA0") || name.startsWith("TEAA0")) {
                LinkedList<String> records = PFileHelper.getFileLines(file, ISO_8859_1);
                records.pollFirst();
                int fileNumberRecv = this.getFileNumberFromEnding(file.getName());
                if (fileNumberRecv < 0) {
                    fileNumberRecv = Integer.parseInt(matcherVosx.group(6));
                }
                int fileNumberSend = 0;
                String firstRecord = (String)records.getFirst();
                if (firstRecord.startsWith("DXVE")) {
                    Matcher dxveMatcher2;
                    Matcher dxveMatcher = DXVE.matcher(firstRecord);
                    if (dxveMatcher.matches()) {
                        fileNumberSend = this.asInteger(dxveMatcher.group(3));
                    }
                    if ((dxveMatcher2 = DXVE2.matcher(firstRecord)).matches()) {
                        String status = this.asString(dxveMatcher2.group(2));
                        String rest = dxveMatcher2.group(3);
                        if (status.equals("0")) {
                            dxveMatcher2 = DXVE2_CONFIRM.matcher(rest);
                            if (dxveMatcher2.matches()) {
                                fileNumberSend = this.asInteger(dxveMatcher2.group(1));
                            }
                        } else {
                            if (status.equals("1")) {
                                return true;
                            }
                            dxveMatcher2 = DXVE2_FILEERROR.matcher(rest);
                            if (dxveMatcher2.matches()) {
                                fileNumberSend = this.asInteger(dxveMatcher2.group(1));
                            }
                        }
                    }
                } else if (firstRecord.startsWith("DXVD")) {
                    Matcher dxvdMatcher2;
                    Matcher dxvdMatcher = DXVD.matcher(firstRecord);
                    if (dxvdMatcher.matches()) {
                        fileNumberSend = this.asInteger(dxvdMatcher.group(2));
                    }
                    if ((dxvdMatcher2 = DXVD2.matcher(firstRecord)).matches()) {
                        fileNumberSend = this.asInteger(dxvdMatcher2.group(2));
                    }
                }
                return this.needImport(file, deuvRecipient, PerfidiaDataType.EAA, fileNumberSend, fileNumberRecv);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getProcedureName() {
        return "eAU";
    }

    @Override
    public String getFileDescription() {
        return "R\u00fcckmeldung(en) elektronische AU";
    }

    @Override
    public String getActionName() {
        return "importieren";
    }

    public void readEauReceives(DEUVRecipient deuvRecipient) throws BusinessDomainException {
        this.initFiles();
        this.mRecipient = deuvRecipient;
        for (File file : (List)this.mFiles.get(deuvRecipient)) {
            this.readEauReceives(file);
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    private void readEauReceives(File input) throws BusinessDomainException {
        this.mCurrent = input;
        CharSequence content = PFileHelper.getFileContent(input, ISO_8859_1, 71);
        Matcher matcher = VOSX_TO_FILENUMBER.matcher(content);
        if (matcher.matches()) {
            int currentFileNumber = this.getFileNumberFromEnding(input.getName());
            if (currentFileNumber < 0) {
                currentFileNumber = Integer.parseInt(matcher.group(6));
            }
            LinkedList<String> records = PFileHelper.getFileLines(input, ISO_8859_1);
            records.pollFirst();
            records.pollLast();
            String name = input.getName().toUpperCase();
            if (name.startsWith("EEAR0") || name.startsWith("TEAR0")) {
                while (!records.isEmpty()) {
                    this.readDxkk((String)records.pollFirst(), currentFileNumber);
                    SessionContext.getInstance().getPersistencySession().flush();
                }
                this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.EAR, this.mRecipient, currentFileNumber);
            } else {
                while (!records.isEmpty()) {
                    if (((String)records.getFirst()).startsWith("DXVE")) {
                        this.readDxve(input, (String)records.pollFirst(), currentFileNumber);
                    } else if (((String)records.getFirst()).startsWith("DXVD")) {
                        this.readDxvd(input, (String)records.pollFirst(), currentFileNumber);
                    } else {
                        EauAccount account = new EauAccount(null, true);
                        account.addError("Nicht plausibler Datensatz! Die Datei konnte nicht verarbeitet werden. Bitte pr\u00fcfen und ggf. manuell eingreifen:\n" + input.getAbsolutePath());
                        this.mImporteds.add(account);
                        records.pollFirst();
                    }
                    SessionContext.getInstance().getPersistencySession().flush();
                }
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcher);
        }
        this.mPerfidiaResult.addReceivedFile(input);
    }

    private void readDxve(File file, String input, int currentFileNumber) throws BusinessDomainException {
        EauAccount[] accounts;
        boolean isVersion2 = false;
        Matcher matcher = this.checkInputGetMatcher(input, 2156, DXVE, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 47, DXVE2);
            isVersion2 = true;
        }
        String status = this.asString(matcher.group(2));
        int dateiNr = 0;
        String errorNr = "";
        String error = "";
        if (isVersion2) {
            String rest = matcher.group(3);
            if (status.equals("0")) {
                matcher = this.checkInputGetMatcher(rest, 6, DXVE2_CONFIRM);
                dateiNr = Integer.parseInt(matcher.group(1));
            } else if (status.equals("1")) {
                matcher = this.checkInputGetMatcher(rest, 1024, DXVE2_PARSEERROR);
                error = this.asString(matcher.group(1));
            } else {
                matcher = this.checkInputGetMatcher(rest, 1040, DXVE2_FILEERROR);
                dateiNr = Integer.parseInt(matcher.group(1));
                errorNr = this.asString(matcher.group(2));
                error = this.asString(matcher.group(3));
            }
        } else {
            dateiNr = Integer.parseInt(matcher.group(3));
            errorNr = this.asString(matcher.group(4));
            error = this.asString(matcher.group(5));
        }
        Object message = "";
        if (status.equals("1")) {
            EauAccount dummy = new EauAccount(null, true);
            message = "Parser-Fehler bei gesendeten Antrag. Dateiname Verarbeitungsergebnis: " + file.getAbsolutePath() + ", Fehler: " + error + ".";
            dummy.addError((String)message);
            dummy.setAnswerType("DXVE");
            this.mImporteds.add(dummy);
            dateiNr = EauReceive.getFileNumberByErrorMessage(error);
            if (dateiNr == 0) {
                dateiNr = currentFileNumber;
            }
        }
        for (EauAccount account : accounts = EauAccount.getEauAccountsByFileNr((int)dateiNr, (DEUVRecipient)this.mRecipient)) {
            if (EauAdviceStateEnum.VERARBEITET.equals((Object)account.getAdviceState()) || EauAdviceStateEnum.ABGELEHNT.equals((Object)account.getAdviceState())) continue;
            account.makeSaveable();
            if (status.equals("0")) {
                account.setAdviceState(EauAdviceStateEnum.VERARBEITET);
                continue;
            }
            if (status.equals("1")) {
                if (!EauAdviceStateEnum.UEBERMITTELT.equals((Object)account.getAdviceState())) continue;
                account.setAdviceState(EauAdviceStateEnum.ABGELEHNT);
                account.addError((String)message);
                continue;
            }
            if (!status.equals("2")) continue;
            account.setAdviceState(EauAdviceStateEnum.ABGELEHNT);
            account.addError("(" + errorNr + ")" + error + ".");
        }
        this.mAcknowledgement.addProcessedFile(file, PerfidiaDataType.EAA, this.mRecipient, dateiNr, currentFileNumber);
    }

    protected static int getFileNumberByErrorMessage(String error) {
        Matcher matcher;
        if (StringMapper.isNullString((String)error)) {
            return 0;
        }
        String number = "";
        if (error.length() >= 11 && "DTNR=".equals(error.substring(0, 5))) {
            number = error.substring(5, 11);
        }
        if (error.length() >= 19 && "Dateinummer: ".equals(error.substring(0, 13))) {
            number = error.substring(13, 19);
        }
        if ((matcher = NUMBERPATTERN.matcher(number)).matches()) {
            return Integer.parseInt(number);
        }
        return 0;
    }

    private void readDxvd(File file, String input, int currentFileNumber) throws BusinessDomainException {
        boolean isVersion2 = false;
        Matcher matcher = this.checkInputGetMatcher(input, 352, DXVD, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 89, DXVD2);
            isVersion2 = true;
        }
        int dateiNr = Integer.parseInt(matcher.group(2));
        String datensatzID = this.asString(matcher.group(3));
        Integer anzahl = Integer.valueOf(this.asString(matcher.group(4)));
        String rest = matcher.group(5);
        EauAccount account = this.getOrigin(datensatzID);
        if (account == null) {
            account = new EauAccount(null, true);
            account.addError("Verarbeitungsergebnis wurde nicht eingelesen, da das eAU-Meldekonto nicht gefunden wurde:" + file.getName() + ".");
            this.mImporteds.add(account);
        } else if (!EauAdviceStateEnum.VERARBEITET.equals((Object)account.getAdviceState()) && !EauAdviceStateEnum.ABGELEHNT.equals((Object)account.getAdviceState())) {
            account.setAdviceState(EauAdviceStateEnum.ABGELEHNT);
            account.makeSaveable();
        }
        account.setAnswerType("DXVD");
        for (int i = 0; i < anzahl; ++i) {
            int restGroup;
            if (isVersion2) {
                matcher = this.checkInputGetMatcher(input, 1034, DXVD2_ERROR, false);
                restGroup = 3;
            } else {
                matcher = this.checkInputGetMatcher(rest, 171, DXVD_ERROR, false);
                restGroup = 4;
            }
            String errorNr = this.asString(matcher.group(1));
            String error = this.asString(matcher.group(2));
            rest = matcher.group(restGroup);
            account.addError("(" + errorNr + ")" + error + ".");
        }
        this.mAcknowledgement.addProcessedFile(file, PerfidiaDataType.EAA, this.mRecipient, dateiNr, currentFileNumber);
    }

    private EauAccount getOrigin(String oid) {
        return !StringUtils.isNumeric((CharSequence)oid) || oid.length() > 18 ? null : this.getReceived(oid);
    }

    private EauAccount getReceived(String oid) {
        EauAccount[] receiveds = this.getPm().query(null, Restrictions.eq((String)"OBJECTID", (String)oid), true);
        return receiveds.length == 0 ? null : receiveds[0];
    }

    private boolean needImport(File input, DEUVRecipient responder, PerfidiaDataType type, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        int perfidiaSubFolder = DataRecipientUtil.getSubFolderNumberByCompNo((String)responder.getCurrentDEUVRecipientTP().getStdCompanyNumber());
        DeuvResponse response = new DeuvResponse(type, perfidiaSubFolder, fileNumberSend, fileNumberRecv, input.getName().startsWith("T") || input.getName().startsWith("t") ? 1 : 0);
        return response.needAcknowlegement(this.mDeuvSender);
    }

    private void readDxkk(String input, int currentFileNumber) throws BusinessDomainException {
        this.mVersion2 = false;
        Matcher matcher = this.checkInputGetMatcher(input, 0, DXKK1_A, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 0, DXKK2_A);
            this.mVersion2 = true;
        }
        EauDxkk dxkk = this.mVersion2 ? this.createEauDxkk2(matcher) : this.createEauDxkk(matcher);
        EauAccount account = this.getOrigin(dxkk);
        account.setAnswerType("DXKK");
        if (dxkk.getKennzstorno().equals("J")) {
            account.setAdviceState(EauAdviceStateEnum.UEBERMITTELT);
        } else {
            account.setAdviceState(EauAdviceStateEnum.VERARBEITET);
            dxkk.makeSaveable();
        }
        account.setDEUVRecipient(this.mRecipient);
        if (!account.isReadOnly() && StringMapper.isNullString((String)dxkk.getMessage()) && ("J".equals(dxkk.getKennzstorno()) || !"4".contentEquals(dxkk.getKzaktuelleau()) && !"1".contentEquals(dxkk.getKzaktuelleau()))) {
            Date until = this.getUntil(dxkk);
            this.doActionsByReason(account, until, "J".equals(dxkk.getKennzstorno()), dxkk);
        } else {
            account.setCancelFromHF("J".equals(dxkk.getKennzstorno()));
        }
        account.addEauDxkkForProtocol(dxkk);
        account.setCurrentFileNumberReceive(currentFileNumber);
        this.mImporteds.add(account);
    }

    private Date getUntil(EauDxkk dxkk) {
        Date until = dxkk.getAubistatsaechlich();
        if (until == null) {
            until = dxkk.getAubisvoraussicht();
        }
        if (until == null) {
            until = dxkk.getStationbis();
        }
        return until;
    }

    private EauAccount getOrigin(EauDxkk dxkk) {
        String azvu = dxkk.getAzvu().replaceAll(" / ", "/");
        Employee employee = null;
        employee = dxkk.getAuabag() == null ? Deuv.findEmployeeByAzOrVsnr((String)azvu, (String)dxkk.getVsnr(), (String)dxkk.getBbnrempfaenger(), (Date)VDate.getDateMax()) : Deuv.findEmployeeByAzOrVsnr((String)azvu, (String)dxkk.getVsnr(), (String)dxkk.getBbnrempfaenger(), (Date)dxkk.getAuabag());
        if (employee == null) {
            EauAccount account = new EauAccount(null, true);
            account.addError("Zuordnung zum Mitarbeiter anhand AZVU oder VSNR nicht m\u00f6glich: " + dxkk.getAzvu() + " / " + dxkk.getVsnr() + ".");
            return account;
        }
        EauAccount account = this.getReceived(employee, dxkk);
        if (account == null && "J".equals(dxkk.getKennzstorno())) {
            account = this.getReceivedOriginByDsId(employee, dxkk);
        }
        if (account == null) {
            account = new EauAccount(employee, true);
            account.addError("R\u00fcckmeldung wurde nicht eingelesen, da das eAU-Meldekonto nicht gefunden wurde.");
        } else {
            account.setErrorMessage("");
            EauDxkk[] dxkks = account.getEauDxkk();
            if (dxkks.length > 0) {
                boolean noSave = false;
                for (EauDxkk each : dxkks) {
                    if (each.isNew() && !DateHelper.afterOrEqual((Date)this.getUntil(each), (Date)this.getUntil(dxkk)) || "4".contentEquals(each.getKzaktuelleau()) || "1".contentEquals(each.getKzaktuelleau())) continue;
                    noSave = true;
                }
                if (noSave) {
                    dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da bereits eine R\u00fcckmeldung f\u00fcr das AU-ab-AG-Datum eingelesen wurde. Bitte ggf. pr\u00fcfen.");
                }
            }
            account.makeSaveable();
            dxkk.setEauAccount(account);
            dxkk.makeSaveable();
        }
        return account;
    }

    private void doActionsByReason(EauAccount account, Date until, boolean isStorno, EauDxkk dxkk) throws BusinessDomainException {
        EEAbsentTimeTP absentTimeTP = account.getEEAbsentTimeTP();
        boolean importToAT = this.getImportToAT(account);
        if (importToAT) {
            if (absentTimeTP != null) {
                if (isStorno) {
                    absentTimeTP.setValidUntil(VDate.getDateMax());
                    account.setValidUntil(null);
                    account.setCancelFromHF(true);
                } else {
                    if (until == null) {
                        dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da kein eAU-Bis \u00fcbermittelt wurde.");
                        return;
                    }
                    if (DateHelper.before((Date)until, (Date)absentTimeTP.getValidFrom())) {
                        dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eAU-Bis = " + DateMapper.toDDMMYYYYPointSeparationString((Date)until) + " vor dem Beginn der Fehlzeit = " + DateMapper.toDDMMYYYYPointSeparationString((Date)absentTimeTP.getValidFrom()) + " ist.");
                        return;
                    }
                    Date validUntil = absentTimeTP.getValidUntil();
                    if (validUntil == null || VDate.isDateMax((Date)validUntil) || DateHelper.afterOrEqual((Date)until, (Date)validUntil)) {
                        Date lastDateOfWithDrawal = account.getEmployee().getLastDateOfWithdrawal();
                        if (lastDateOfWithDrawal != null && DateHelper.after((Date)until, (Date)lastDateOfWithDrawal)) {
                            dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eAU-Bis = " + DateMapper.toDDMMYYYYPointSeparationString((Date)until) + " nach dem Austritt = " + DateMapper.toDDMMYYYYPointSeparationString((Date)lastDateOfWithDrawal) + " liegt.");
                            return;
                        }
                        absentTimeTP.setValidUntil(until);
                        account.setValidUntil(until);
                    } else {
                        dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eAU-Bis = " + DateMapper.toDDMMYYYYPointSeparationString((Date)until) + " vor dem Ende der Fehlzeit = " + DateMapper.toDDMMYYYYPointSeparationString((Date)validUntil) + " ist.");
                        return;
                    }
                }
                try {
                    absentTimeTP.checkPostCondition();
                }
                catch (BusinessDomainException bde) {
                    dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit: " + bde.getLocalizedMessage());
                    return;
                }
                account.setAbsentTimeChanged(true);
                absentTimeTP.makeSaveable();
                try {
                    absentTimeTP.updateFromEELOrEAU(this.mToken);
                }
                catch (BusinessDomainException bde) {
                    dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit: " + bde.getLocalizedMessage());
                }
            } else {
                dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eine passende Fehlzeit nicht gefunden wurde.");
            }
        } else if (isStorno) {
            account.setValidUntil(null);
            account.setCancelFromHF(true);
        } else {
            account.setValidUntil(until);
        }
    }

    private boolean getImportToAT(EauAccount account) throws BusinessDomainException {
        Employee emp = account.getEmployee();
        if (emp == null) {
            return false;
        }
        Plant plant = emp.getAppurtenantPlant(VDate.getDateMax(), account.getValidFrom());
        PCompany comp = emp.getPCompany();
        if (plant != null && plant.getPlantFoundations(VDate.getDateMax(), account.getValidFrom()).getFoundations().getAuLimitationOfAbsenttime()) {
            return true;
        }
        return comp != null && comp.getCompanyFoundations(VDate.getDateMax(), account.getValidFrom()).getFoundations().getAuLimitationOfAbsenttime();
    }

    private EauDxkk createEauDxkk(Matcher matcher) throws BusinessDomainException {
        EauDxkk dxkk = this.initEauDxkk(matcher);
        String rest = matcher.group(12);
        if (dxkk.hasMmDbap()) {
            rest = this.initDbap(rest, dxkk.getDbap());
        }
        rest = this.initDxkkB(rest, dxkk);
        dxkk.makeReadOnly();
        return dxkk;
    }

    private EauDxkk createEauDxkk2(Matcher matcher) throws BusinessDomainException {
        EauDxkk dxkk = this.initEauDxkk2(matcher);
        String rest = matcher.group(9);
        if ("S".equals(this.mArt)) {
            rest = this.initDxkk2_S(rest, dxkk);
            rest = "1".equals(this.mId) ? this.initDxkk2_VS(rest, dxkk) : this.initDxkk2_GD(rest, dxkk);
            rest = this.initDxkk2_S2(rest, dxkk);
            dxkk.setKennzstorno("J");
            dxkk.setNachweisart(NachweisartEnum.ERSTNACHWEIS);
        } else {
            rest = this.initDxkk2_R(rest, dxkk);
            if (dxkk.hasMmDbap()) {
                rest = this.initDbap2(rest, dxkk.getDbap());
            }
            rest = this.initDxkk2_AN(rest, dxkk);
            dxkk.setNachweisart(NachweisartEnum.ERSTNACHWEIS);
            if ("2".contentEquals(dxkk.getKzaktuelleau()) || "3".contentEquals(dxkk.getKzaktuelleau()) || "5".contentEquals(dxkk.getKzaktuelleau())) {
                rest = this.initDxkk2_NW(rest, dxkk);
            }
            if ("2".contentEquals(dxkk.getKzaktuelleau())) {
                rest = this.initDxkk2_AU(rest, dxkk);
            }
        }
        dxkk.makeReadOnly();
        return dxkk;
    }

    private EauDxkk initEauDxkk(Matcher matcher) {
        int i = 1;
        String version = "010001";
        String bbnrab = this.asString(matcher.group(i++));
        String bbnrep = this.asString(matcher.group(i++));
        String datumer = this.asString(matcher.group(i++));
        String prodid = this.asString(matcher.group(i++));
        String modid = this.asString(matcher.group(i++));
        String datensatzID = this.asString(matcher.group(i++));
        String azvu = this.asString(matcher.group(i++));
        String kennzst = this.asString(matcher.group(i++));
        String datensatzIDUrspung = this.asString(matcher.group(i++));
        String bbnrvu = this.asString(matcher.group(i++));
        String mmap = this.asString(matcher.group(i++));
        EauDxkk dxkk = new EauDxkk();
        dxkk.setEauVersion(Integer.valueOf("010001").intValue());
        dxkk.setBbnrabsender(bbnrab);
        dxkk.setBbnrempfaenger(bbnrep);
        dxkk.setDatumerstellung(datumer);
        dxkk.setProdid(prodid);
        dxkk.setModid(modid);
        dxkk.setDatensatzid(datensatzID);
        dxkk.setAzvu(azvu);
        dxkk.setKennzstorno(kennzst);
        dxkk.setDatensatzidursprung(datensatzIDUrspung);
        dxkk.setBbnrverursacher(bbnrvu);
        dxkk.setBbnrabrechnungsstelle("");
        if ("1".equals(mmap)) {
            dxkk.createDbap();
        }
        return dxkk;
    }

    private String initDbap(String input, EauDbap dbap) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 417, DBAP);
        int i = 1;
        String geschlechtAP = this.asString(matcher.group(i++));
        String nameAP = this.asString(matcher.group(i++));
        String telefonAP = this.asString(matcher.group(i++));
        String faxAP = this.asString(matcher.group(i++));
        String emailAP = this.asString(matcher.group(i++));
        String name1 = this.asString(matcher.group(i++));
        String name2 = this.asString(matcher.group(i++));
        String name3 = this.asString(matcher.group(i++));
        String plz = this.asString(matcher.group(i++));
        String ort = this.asString(matcher.group(i++));
        String strasse = this.asString(matcher.group(i++));
        String hausnr = this.asString(matcher.group(i++));
        Dbap data = new Dbap();
        data.setAnrap(geschlechtAP);
        data.setNameap(nameAP);
        data.setTelap(telefonAP);
        data.setFaxap(faxAP);
        data.setEmailap(emailAP);
        data.setName1(name1);
        data.setName2(name2);
        data.setName3(name3);
        data.setPlz(plz);
        data.setOrt(ort);
        data.setStrasse(strasse);
        data.setHausnr(hausnr);
        dbap.setDbapData(data);
        return matcher.group(++i);
    }

    private String initDxkkB(String input, EauDxkk dxkk) throws BusinessDomainException {
        boolean mmsa;
        Matcher matcher = this.checkInputGetMatcher(input, 627, DXKK1_B2, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 611, DXKK1_B);
            mmsa = false;
        } else {
            mmsa = true;
        }
        int i = 1;
        String geschlecht = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String nachname = this.asString(matcher.group(i++));
        String vsnr = this.asString(matcher.group(i++));
        String auabag = this.asString(matcher.group(i++));
        String auseit = this.asString(matcher.group(i++));
        String aubis = this.asString(matcher.group(i++));
        String festgestelltam = this.asString(matcher.group(i++));
        String kennzAU = this.asString(matcher.group(i++));
        String arbeitsunfall = this.asString(matcher.group(i++));
        String darzt = this.asString(matcher.group(i++));
        String sonstUnfall = this.asString(matcher.group(i++));
        String stationaer = this.asString(matcher.group(i++));
        if (mmsa && "J".equals(stationaer)) {
            String aufnahme = this.asString(matcher.group(i++));
            String dauerKH = this.asString(matcher.group(i++));
            dxkk.setStationab(this.toDateYYYYMMDD(aufnahme));
            dxkk.setStationbis(this.toDateYYYYMMDD(dauerKH));
        }
        String bescheinigungsart = this.asString(matcher.group(i++));
        dxkk.setGeschlecht(geschlecht);
        dxkk.setVorname(vorname);
        dxkk.setFamilienname(nachname);
        dxkk.setVsnr(vsnr);
        dxkk.setAuabag(this.toDateYYYYMMDD(auabag));
        dxkk.setAuabkk(this.toDateYYYYMMDD(auseit));
        dxkk.setAubisvoraussicht(this.toDateYYYYMMDD(aubis));
        dxkk.setFestgestelltam(this.toDateYYYYMMDD(festgestelltam));
        dxkk.setKzaktuelleau(kennzAU);
        dxkk.setArbeitsunfall(arbeitsunfall);
        dxkk.setDarztzugewiesen(darzt);
        dxkk.setSonstigerunfall(sonstUnfall);
        if ("1".equals(bescheinigungsart)) {
            dxkk.setNachweisart(NachweisartEnum.ERSTNACHWEIS);
        } else if ("2".equals(bescheinigungsart)) {
            dxkk.setNachweisart(NachweisartEnum.FOLGENACHWEIS);
        }
        return "";
    }

    private EauDxkk initEauDxkk2(Matcher matcher) {
        int i = 1;
        String version = "020000";
        String bbnrab = this.asString(matcher.group(i++));
        String bbnrep = this.asString(matcher.group(i++));
        String datumer = this.asString(matcher.group(i++));
        String prodid = this.asString(matcher.group(i++));
        String modid = this.asString(matcher.group(i++));
        String datensatzID = this.asString(matcher.group(i++));
        String azvu = this.asString(matcher.group(i++));
        this.mArt = this.asString(matcher.group(i++));
        EauDxkk dxkk = new EauDxkk();
        dxkk.setEauVersion(Integer.valueOf("020000").intValue());
        dxkk.setBbnrabsender(bbnrab);
        dxkk.setBbnrempfaenger(bbnrep);
        dxkk.setDatumerstellung(datumer);
        dxkk.setProdid(prodid);
        dxkk.setModid(modid);
        dxkk.setDatensatzid(datensatzID);
        dxkk.setAzvu(azvu);
        return dxkk;
    }

    private String initDxkk2_R(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 52, DXKK2_R);
        int i = 1;
        String bbnrvu = this.asString(matcher.group(i++));
        String refId = this.asString(matcher.group(i++));
        String mmap = this.asString(matcher.group(i++));
        dxkk.setKennzstorno("N");
        dxkk.setBbnrverursacher(bbnrvu);
        dxkk.setBbnrabrechnungsstelle("");
        if ("1".equals(mmap)) {
            dxkk.createDbap();
        }
        return matcher.group(i);
    }

    private String initDxkk2_S(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 37, DXKK2_S);
        int i = 1;
        String datensatzIDUrspung = this.asString(matcher.group(i++));
        this.mId = this.asString(matcher.group(i++));
        dxkk.setDatensatzidursprung(datensatzIDUrspung);
        return matcher.group(i);
    }

    private String initDbap2(String input, EauDbap dbap) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 1425, DBAP2);
        int i = 1;
        String nameAP = this.asString(matcher.group(i++));
        String telefonAP = this.asString(matcher.group(i++));
        String faxAP = this.asString(matcher.group(i++));
        String emailAP = this.asString(matcher.group(i++));
        String name1 = this.asString(matcher.group(i++));
        String plz = this.asString(matcher.group(i++));
        String ort = this.asString(matcher.group(i++));
        String strasse = this.asString(matcher.group(i++));
        String hausnr = this.asString(matcher.group(i++));
        Dbap data = new Dbap();
        data.setNameap(nameAP);
        data.setTelap(telefonAP);
        data.setFaxap(faxAP);
        data.setEmailap(emailAP);
        data.setName1(name1);
        data.setPlz(plz);
        data.setOrt(ort);
        data.setStrasse(strasse);
        data.setHausnr(hausnr);
        dbap.setDbapData(data);
        return matcher.group(i);
    }

    private String initDxkk2_AN(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 534, DXKK2_AN);
        int i = 1;
        String vorname = this.asString(matcher.group(i++));
        String familienname = this.asString(matcher.group(i++));
        String vsnr = this.asString(matcher.group(i++));
        String kennzR = this.asString(matcher.group(i++));
        String abwabag = this.asString(matcher.group(i++));
        dxkk.setVorname(vorname);
        dxkk.setFamilienname(familienname);
        dxkk.setVsnr(vsnr);
        dxkk.setKzaktuelleau(kennzR.substring(1));
        dxkk.setAuabag(this.toDateYYYYMMDD(abwabag));
        return matcher.group(i);
    }

    private String initDxkk2_NW(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 24, DXKK2_NW);
        int i = 1;
        String nwseit = this.asString(matcher.group(i++));
        String vornwbis = this.asString(matcher.group(i++));
        String tatbis = this.asString(matcher.group(i++));
        dxkk.setAuabkk(this.toDateYYYYMMDD(nwseit));
        dxkk.setAubisvoraussicht(this.toDateYYYYMMDD(vornwbis));
        dxkk.setAubistatsaechlich(this.toDateYYYYMMDD(tatbis));
        return matcher.group(i);
    }

    private String initDxkk2_AU(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 12, DXKK2_AU);
        int i = 1;
        String festgestelltam = this.asString(matcher.group(i++));
        String arbeitsunfall = this.asString(matcher.group(i++));
        String darzt = this.asString(matcher.group(i++));
        String sonstUnfall = this.asString(matcher.group(i++));
        String nachweisart = this.asString(matcher.group(i++));
        dxkk.setFestgestelltam(this.toDateYYYYMMDD(festgestelltam));
        dxkk.setArbeitsunfall(arbeitsunfall);
        dxkk.setDarztzugewiesen(darzt);
        dxkk.setSonstigerunfall(sonstUnfall);
        if ("1".equals(nachweisart)) {
            dxkk.setNachweisart(NachweisartEnum.ERSTNACHWEIS);
        } else if ("2".equals(nachweisart)) {
            dxkk.setNachweisart(NachweisartEnum.FOLGENACHWEIS);
        }
        return matcher.group(i);
    }

    private String initDxkk2_VS(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 12, DXKK2_VS);
        int i = 1;
        String vsnr = this.asString(matcher.group(i++));
        dxkk.setVsnr(vsnr);
        return matcher.group(i);
    }

    private String initDxkk2_GD(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 512, DXKK2_GD);
        int i = 1;
        String geburtsname = this.asString(matcher.group(i++));
        String geburtsort = this.asString(matcher.group(i++));
        dxkk.setGebname(geburtsname);
        dxkk.setGebort(geburtsort);
        return matcher.group(i);
    }

    private String initDxkk2_S2(String input, EauDxkk dxkk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 520, DXKK2_S2);
        int i = 1;
        String familienname = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String geburtsd = this.asString(matcher.group(i++));
        dxkk.setFamilienname(familienname);
        dxkk.setVorname(vorname);
        dxkk.setGebdatum(this.toDateYYYYMMDD(geburtsd));
        return matcher.group(i);
    }

    private Date toDateYYYYMMDD(String date) {
        if ("99999999".equals(date)) {
            return null;
        }
        return PDateHelper.toDateYYYYMMDD((String)date);
    }

    private EauAccount getReceived(Employee emp, EauDxkk dxkktemp) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)emp.getObjectid()), Restrictions.eq((String)"VALIDFROM", (String)DateMapper.toString((Date)dxkktemp.getAuabag())), Restrictions.eq((String)"REASONOFDELIVERY", (String)"0"), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.UEBERMITTELT.ordinal())), Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.VERARBEITET.ordinal())), Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.ABGELEHNT.ordinal()))}), Restrictions.eq((String)"CANCELED", (String)"N")});
        Order[] sort = new Order[]{Order.asc((String)"CREATEDON")};
        EauAccount[] receiveds = this.getPm().query(sort, (Criterion)filter, true);
        if (receiveds == null || receiveds.length == 0) {
            if (dxkktemp.getAuabag() == null) {
                return null;
            }
            filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)emp.getObjectid()), Restrictions.eq((String)"VALIDFROM", (String)DateMapper.toString((Date)DateHelper.add((Date)dxkktemp.getAuabag(), (int)1))), Restrictions.eq((String)"REASONOFDELIVERY", (String)"0"), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.UEBERMITTELT.ordinal())), Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.VERARBEITET.ordinal())), Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.ABGELEHNT.ordinal()))}), Restrictions.eq((String)"CANCELED", (String)"N")});
            sort = new Order[]{Order.asc((String)"CREATEDON")};
            receiveds = this.getPm().query(sort, (Criterion)filter, true);
            if (receiveds == null || receiveds.length == 0) {
                return null;
            }
        }
        return receiveds[0];
    }

    private EauAccount getReceivedOriginByDsId(Employee emp, EauDxkk dxkktemp) {
        Order[] sort;
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"DATENSATZID", (String)dxkktemp.getDatensatzidursprung()), Restrictions.eq((String)"STORNOKENNZEICHEN", (String)"N")});
        EauDxkk[] dxkks = EauDxkk.getEauDxkks((Criterion)filter, (Order[])(sort = new Order[]{Order.desc((String)"ed")}));
        if (dxkks == null || dxkks.length == 0) {
            return null;
        }
        return dxkks[0].getEauAccount();
    }

    private IEauAccountPersistencyManager getPm() {
        return (IEauAccountPersistencyManager)UtilitiesManager.getBean((String)"eauAccountPersistencyManager", IEauAccountPersistencyManager.class);
    }

    private int getFileNumberFromEnding(String filename) {
        String ending = null;
        if (filename != null && filename.length() >= 7 && filename.charAt(filename.length() - 4) == '.') {
            String firstPart = filename.substring(filename.length() - 7, filename.length() - 4);
            String secondPart = filename.substring(filename.length() - 3, filename.length());
            ending = firstPart.concat(secondPart);
        }
        int fileNumber = -1;
        if (ending != null) {
            try {
                fileNumber = Integer.parseInt(ending);
            }
            catch (NumberFormatException e) {
                fileNumber = -1;
            }
        }
        return fileNumber;
    }
}

