/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.deuvaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistentBusinessObject;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.DeuvComponents;
import com.varial.personnel.domain.deuv.DeuvTransfer;
import com.varial.personnel.domain.deuv.IDbanData;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.deuv.dbkv.DeuvDbkv;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVEmployee;
import com.varial.personnel.domain.deuv.deuvaccount.PersonalCurrentData;
import com.varial.personnel.domain.deuv.deuvaccount.TypeOfAccountEnum;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.DisruptionImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.EntryImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValueInterval;
import com.varial.personnel.domain.deuv.deuvdban.DEUVDban;
import com.varial.personnel.domain.deuv.deuvdbeu.DEUVDbeu;
import com.varial.personnel.domain.deuv.deuvdbgb.DEUVDbgb;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdbna.DEUVDbna;
import com.varial.personnel.domain.deuv.deuvdbso.DEUVDbso;
import com.varial.personnel.domain.deuv.deuvdbst.DEUVDbst;
import com.varial.personnel.domain.deuv.deuvdbuv.DEUVDbuv;
import com.varial.personnel.domain.deuv.deuvdsfz.DEUVDsfz;
import com.varial.personnel.domain.deuv.deuvdsfz.DEUVDsfzPersistencyManager;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsme;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsmePersistencyManager;
import com.varial.personnel.domain.deuv.deuvtrigger.DEUVTrigger;
import com.varial.personnel.domain.deuv.dsvv.DsvvHelper;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.AdviceStateFilterEnum;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.recipient.RecipientTP;
import com.varial.personnel.domain.global.recipient.TypeOfRecipientEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.library.ReportFilterMapper;
import com.varial.personnel.domain.rvbea.dxar.RvbeaDxar;
import com.varial.personnel.framework.CompareToOldUtil;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import de.deutscherv.gb0500.kernpruefung.krips.impl.Krips;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kernpruefung.Rueckgabe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DEUVAccount
extends PersistentObject
implements IEmployeeReferenced {
    private static final Logger LOGGER = LoggerFactory.getLogger(DEUVAccount.class);
    public static final String ZERO = "0";
    public static final String N = "N";
    public static final String J = "J";
    public static final String X = "X";
    public static final String K = "K";
    private static final String LAW_AREA_ERROR = "?";
    private static final int PRIORITY = 1;
    private static final Date START_OF_REASON57 = DateMapper.toDate((String)"2007-01-01");
    private static final Date START_OF_MBBGL = DateMapper.toDate((String)"2012-01-01");
    private static final BigDecimal MONTHLY_MINIMUM = BigDecimal.valueOf(15500L, 2);
    private static final Date START_OF_MBBGL_CORRECTION = DateMapper.toDate((String)"2013-05-01");
    public static final Date BEGIN_OF_SEPARATE_EGA_GD54 = DateMapper.toDate((String)"2011-01-01");
    private DEUVEmployee mDEUVEmployee;
    private Employee mEmployee;
    private PCompany mPCompany;
    private Date mEffectiveFrom;
    private String mCreatedOn;
    private Date mValidFrom;
    private Date mValidUntil;
    private int mReasonOfDelivery;
    private String mLongReasonOfDeliv;
    private DEUVSender mDEUVSender;
    private DEUVRecipient mDEUVRecipient;
    private boolean mEeCertificate;
    private boolean mTransmitted;
    private int mCurrentFileNumber;
    private String mCanceled;
    private String mInsuranceNo;
    private int mPersongroup;
    private String mDuesgroups;
    private BigDecimal mPayment;
    private int mSerialNumber;
    private Insurance mValidInsurance;
    private DEUVDsme mDEUVDsme;
    private DEUVDbme mDEUVDbme;
    private DEUVDbna mDEUVDbna;
    private DEUVDbgb mDEUVDbgb;
    private DEUVDban mDEUVDban;
    private DEUVDbeu mDEUVDbeu;
    private DEUVDbso mDEUVDbso;
    private DEUVDbuv mDEUVDbuv;
    private DeuvDbkv mDeuvDbkv;
    private DEUVDbst mDeuvDbst;
    private DEUVDsfz mDeuvDsfz;
    private String mErrorMessage;
    private boolean mManually;
    private IEECompanyPlant mEECompanyPlant;
    private boolean mSplitting;
    private boolean mSystemChangeEga;
    private boolean mEgaInBZ;
    private BigDecimal mPaymentMidijob2022;
    private AdviceStateEnum mAdviceState = AdviceStateEnum.AUFGEBAUT;
    private RvbeaDxar mRvbeaDxar;
    private boolean mSelfservice;
    private TypeOfAccountEnum mTypeOfAccount = TypeOfAccountEnum.DSME;
    public static final String _10_01 = "10.01";
    public static final String _10_02 = "10.02";
    public static final String _10_03 = "10.03";
    public static final String _10_04 = "10.04";
    public static final String _10_05 = "10.05";
    public static final String _11_01 = "11.01";
    public static final String _11_02 = "11.02";
    public static final String _11_03 = "11.03";
    public static final String _11_04 = "11.04";
    public static final String _11_05 = "11.05";
    public static final String _12_01 = "12.01";
    public static final String _12_02 = "12.02";
    public static final String _12_03 = "12.03";
    public static final String _13_01 = "13.01";
    public static final String _13_02 = "13.02";
    public static final String _13_03 = "13.03";
    public static final String _13_04 = "13.04";
    public static final String _13_05 = "13.05";
    public static final String _13_06 = "13.06";
    public static final String _13_07 = "13.07";
    public static final String _13_08 = "13.08";
    public static final String _13_09 = "13.09";
    public static final String _13_10 = "13.10";
    public static final String _13_11 = "13.11";
    public static final String _13_12 = "13.12";
    public static final String _13_13 = "13.13";
    public static final String _13_14 = "13.14";
    public static final String _13_99 = "13.99";
    public static final String _30_01 = "30.01";
    public static final String _30_02 = "30.02";
    public static final String _30_03 = "30.03";
    public static final String _30_04 = "30.04";
    public static final String _30_05 = "30.05";
    public static final String _30_06 = "30.06";
    public static final String _31_01 = "31.01";
    public static final String _31_02 = "31.02";
    public static final String _31_03 = "31.03";
    public static final String _31_04 = "31.04";
    public static final String _31_05 = "31.05";
    public static final String _32_01 = "32.01";
    public static final String _32_02 = "32.02";
    public static final String _32_03 = "32.03";
    public static final String _33_01 = "33.01";
    public static final String _33_02 = "33.02";
    public static final String _33_03 = "33.03";
    public static final String _33_04 = "33.04";
    public static final String _33_05 = "33.05";
    public static final String _33_06 = "33.06";
    public static final String _33_07 = "33.07";
    public static final String _33_08 = "33.08";
    public static final String _33_09 = "33.09";
    public static final String _34_01 = "34.01";
    public static final String _34_02 = "34.02";
    public static final String _34_03 = "34.03";
    public static final String _34_04 = "34.04";
    public static final String _34_05 = "34.05";
    public static final String _35_01 = "35.01";
    public static final String _36_01 = "36.01";
    public static final String _49_01 = "49.01";
    public static final String _50_01 = "50.01";
    public static final String _51_01 = "51.01";
    public static final String _52_01 = "52.01";
    public static final String _53_01 = "53.01";
    public static final String _54_01 = "54.01";
    public static final String _55_01 = "55.01";
    public static final String _56_01 = "56.01";
    public static final String _57_01 = "57.01";
    public static final String _70_01 = "70.01";
    public static final String _71_01 = "71.01";
    public static final String _72_01 = "72.01";
    public static final String _31 = "31";
    public static final String _32 = "32";
    public static final String _33 = "33";
    public static final String _11 = "11";
    public static final String _12 = "12";
    public static final String _13 = "13";
    public static final String _20 = "20";
    public static final String _10 = "10";
    public static final String _30 = "30";
    public static final String _58 = "58";
    public static final String _92 = "92";
    public static final String _17 = "17";
    public static final String _37 = "37";

    protected DEUVAccount(int priority) {
        super(priority);
    }

    public DEUVAccount() {
        super(1);
    }

    public DEUVAccount(boolean readOnly) {
        super(1, readOnly);
    }

    public DEUVAccount(String oid) {
        super(1, oid);
    }

    protected void load() {
        DEUVAccountPersistencyManager.load((DEUVAccount)this);
    }

    protected void saveImpl() throws BusinessDomainException {
        DEUVAccountPersistencyManager.save((DEUVAccount)this);
    }

    protected void deleteImpl() {
        DEUVAccountPersistencyManager.delete((DEUVAccount)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        this.requireLoaded();
        if (!this.myStateAtDeuvBegin() && this.mTransmitted) {
            throw new IllegalStateException("never destroy transmitted accounts!");
        }
        this.partialDestroyImpl();
    }

    public final void specialDestroy() throws BusinessDomainException {
        if (this.isReadOnly()) {
            LOGGER.debug("tried to destroy readonly object {}, ObjectId <{}>", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.getObjectid());
            return;
        }
        this.registerForDelete();
        this.specialDestroyImpl();
        this.setDestroyed(true);
    }

    private void specialDestroyImpl() throws BusinessDomainException {
        if (!this.isReadOnly()) {
            SessionContext.getInstance().getPersistencySession().registerForDelete((PersistentBusinessObject)this);
        }
        this.requireLoaded();
        this.partialDestroyImpl();
    }

    private void partialDestroyImpl() throws BusinessDomainException {
        if (this.mDEUVDsme != null) {
            this.mDEUVDsme.destroy();
        }
        if (this.getDeuvDsfz() != null) {
            this.mDeuvDsfz.destroy();
        }
        if (this.mDEUVDbme != null) {
            this.mDEUVDbme.destroy();
        }
        if (this.mDEUVDbna != null) {
            this.mDEUVDbna.destroy();
        }
        if (this.mDEUVDbgb != null) {
            this.mDEUVDbgb.destroy();
        }
        if (this.mDEUVDban != null) {
            this.mDEUVDban.destroy();
        }
        if (this.mDEUVDbeu != null) {
            this.mDEUVDbeu.destroy();
        }
        if (this.mDEUVDbuv != null) {
            this.mDEUVDbuv.destroy();
        }
        if (this.mDEUVDbso != null) {
            this.mDEUVDbso.destroy();
        }
        if (this.mDeuvDbkv != null) {
            this.mDeuvDbkv.destroy();
        }
        if (this.mDeuvDbst != null) {
            this.mDeuvDbst.destroy();
        }
    }

    private boolean myStateAtDeuvBegin() {
        return _13_99.equals(this.mLongReasonOfDeliv);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        StringBuilder result = new StringBuilder();
        if (this.mEmployee != null) {
            result.append(this.mEmployee.getDomainKey());
        }
        return result.append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public static DEUVAccount getDEUVAccount(String objectID) {
        return new DEUVAccount(objectID);
    }

    public static DEUVAccount[] getDEUVAccounts(String oidPCompany, Date validFrom, Date validUntil, boolean annoucement, boolean prompt, boolean noticeOfWithdrawal, boolean annualReport, boolean adviceOfBreak, boolean specialAdvice, boolean gkvMonthlyAdvice, boolean adviceOfModification, boolean adviceOfInsolvency, boolean aiAnnualAdvice, boolean specialAiAnnualAdvice, boolean parentTime, int adviceState, ReportFirstFilterStruct firstfilter, ReportSecondFilterStruct[] secondfilters) {
        if (specialAiAnnualAdvice) {
            List<DEUVAccount> results = DEUVAccount.GetSpecialAiAnnual(oidPCompany, validFrom, validUntil);
            return results.toArray(new DEUVAccount[results.size()]);
        }
        String[] oidEmployees = ReportFilterMapper.getOidsFromReportFilter((String)oidPCompany, (ReportFirstFilterStruct)firstfilter, (ReportSecondFilterStruct[])secondfilters);
        if (oidEmployees != null && oidEmployees.length == 0) {
            return new DEUVAccount[0];
        }
        List<Criterion> filters = DEUVAccount.createFilterForGetDEUVAccounts(oidEmployees, oidPCompany, validFrom, validUntil, annoucement, prompt, noticeOfWithdrawal, annualReport, adviceOfBreak, specialAdvice, gkvMonthlyAdvice, adviceOfModification, adviceOfInsolvency, aiAnnualAdvice, parentTime, adviceState);
        ArrayList<DEUVAccount> results = new ArrayList<DEUVAccount>();
        for (Criterion filter : filters) {
            DEUVAccount[] accounts = DEUVAccountPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true);
            results.addAll(Arrays.asList(accounts));
        }
        Collections.sort(results, new DeuvAccountSortComparator());
        return results.toArray(new DEUVAccount[results.size()]);
    }

    public static final Order[] getSortStruct() {
        return new Order[]{Order.asc((String)"createdon"), Order.asc((String)"serialnumber")};
    }

    public static List<Criterion> createFilterForGetDEUVAccounts(String[] oidEmployees, String oidPCompany, Date validFrom, Date validUntil, boolean annoucement, boolean prompt, boolean noticeOfWithdrawal, boolean annualReport, boolean adviceOfBreak, boolean specialAdvice, boolean gkvMonthlyAdvice, boolean adviceOfModification, boolean adviceOfInsolvency, boolean aiAnnualAdvice, boolean parentTime, int adviceState) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.lt((String)DEUVAccountPersistencyManager.CREATEDON, (String)DeuvBasics.formatDEUVTimestamp((Date)DateHelper.tomorrow((Date)validUntil))), Restrictions.ge((String)DEUVAccountPersistencyManager.CREATEDON, (String)DeuvBasics.formatDEUVTimestamp((Date)validFrom))});
        ArrayList<String> oids = new ArrayList<String>();
        if (annoucement) {
            oids.add(_10);
            oids.add(_11);
            oids.add(_12);
            oids.add(_13);
        }
        if (prompt) {
            oids.add(_20);
        }
        if (noticeOfWithdrawal) {
            oids.add(_30);
            oids.add(_31);
            oids.add(_32);
            oids.add(_33);
            oids.add("34");
            oids.add("35");
            oids.add("36");
            oids.add("49");
        }
        if (annualReport) {
            oids.add("50");
        }
        if (adviceOfBreak) {
            oids.add("51");
            oids.add("52");
            oids.add("53");
        }
        if (specialAdvice) {
            oids.add("54");
            oids.add("55");
            oids.add("56");
            oids.add("57");
            oids.add("91");
        }
        if (gkvMonthlyAdvice) {
            oids.add(_58);
        }
        if (adviceOfModification) {
            oids.add("60");
            oids.add("61");
            oids.add("62");
            oids.add("63");
        }
        if (adviceOfInsolvency) {
            oids.add("70");
            oids.add("71");
            oids.add("72");
        }
        if (aiAnnualAdvice) {
            oids.add(_92);
        }
        if (parentTime) {
            oids.add(_17);
            oids.add(_37);
        }
        if (!oids.isEmpty()) {
            filter.add(Restrictions.in((String)DEUVAccountPersistencyManager.REASONOFDELIVERY, (String[])oids.toArray(new String[oids.size()])));
        }
        if (adviceState >= 0) {
            filter.add(AdviceStateFilterEnum.getFilter((int)adviceState));
        }
        ArrayList<Criterion> result = new ArrayList<Criterion>();
        if (oidEmployees == null) {
            result.add((Criterion)filter.add(Restrictions.eq((String)DEUVAccountPersistencyManager.OIDPCOMPANY, (String)oidPCompany)));
        } else {
            for (Criterion each : PRestrictions.in((String)DEUVAccountPersistencyManager.OIDEMPLOYEE, (String[])oidEmployees)) {
                result.add(Restrictions.and((Criterion)filter, (Criterion)each));
            }
        }
        return result;
    }

    private static List<DEUVAccount> GetSpecialAiAnnual(String oidPCompany, Date validFrom, Date validUntil) {
        Conjunction filter = new Conjunction(new Criterion[]{Restrictions.isNull((String)DEUVAccountPersistencyManager.OIDEMPLOYEE), Restrictions.eq((String)DEUVAccountPersistencyManager.OIDPCOMPANYOFDEUVACCOUNT, (String)oidPCompany), Restrictions.eq((String)DEUVAccountPersistencyManager.REASONOFDELIVERY, (String)_92), Restrictions.lt((String)DEUVAccountPersistencyManager.CREATEDON, (String)DeuvBasics.formatDEUVTimestamp((Date)DateHelper.tomorrow((Date)validUntil))), Restrictions.ge((String)DEUVAccountPersistencyManager.CREATEDON, (String)DeuvBasics.formatDEUVTimestamp((Date)validFrom))});
        DEUVAccount[] accounts = DEUVAccountPersistencyManager.query((Order[])DEUVAccount.getSortStruct(), (Criterion)filter);
        return Arrays.asList(accounts);
    }

    public String getCreatedOn() {
        this.requireLoaded();
        return this.mCreatedOn;
    }

    public Date getCreatedOnDate() {
        return this.mDEUVEmployee == null ? DeuvBasics.deuvDateStringToDate((String)this.mCreatedOn) : this.mDEUVEmployee.getCreatedOnDate();
    }

    public void setCreatedOn(String createdOn) {
        if (this.myStateAtDeuvBegin()) {
            this.mCreatedOn = DeuvBasics.formatDEUVTimestamp((Date)this.mDEUVEmployee.getDEUVStart());
            return;
        }
        this.mCreatedOn = createdOn;
    }

    public void updateUntransmitted(int serialnumber, String createdOn) {
        this.requireLoaded();
        if (this.mTransmitted) {
            throw new IllegalStateException("never change transmitted accounts!");
        }
        this.loadAdvicedState(null);
        this.mSerialNumber = serialnumber;
        if (this.isDsme()) {
            this.mCreatedOn = createdOn;
            this.mDEUVDsme = this.getDEUVDsme();
            this.mDEUVDsme.setDatumErstellung(createdOn);
        }
        this.makeSaveable();
    }

    public int getCurrentFileNumber() {
        this.requireLoaded();
        return this.mCurrentFileNumber;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.mCurrentFileNumber = currentFileNumber;
    }

    public boolean getEeCertificate() {
        this.requireLoaded();
        return this.mEeCertificate;
    }

    public void setEeCertificate(boolean eeCertificate) {
        this.mEeCertificate = eeCertificate;
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public String getLongReasonOfDeliv() {
        this.requireLoaded();
        return this.mLongReasonOfDeliv;
    }

    public void setLongReasonOfDeliv(String longReasonOfDeliv) {
        this.mLongReasonOfDeliv = longReasonOfDeliv;
    }

    public DEUVRecipient getDEUVRecipient() {
        this.requireLoaded();
        return this.mDEUVRecipient;
    }

    public void setDEUVRecipient(DEUVRecipient deuvRecipient) {
        this.mDEUVRecipient = deuvRecipient;
    }

    public DEUVSender getDEUVSender() {
        this.requireLoaded();
        return this.mDEUVSender;
    }

    public void setDEUVSender(DEUVSender deuvSender) {
        this.mDEUVSender = deuvSender;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public PCompany getPCompany() {
        this.requireLoaded();
        return this.mPCompany;
    }

    public void setPCompany(PCompany pCompany) {
        this.mPCompany = pCompany;
    }

    public int getReasonOfDelivery() {
        this.requireLoaded();
        return this.mReasonOfDelivery;
    }

    public void setReasonOfDelivery(int reasonOfDelivery) {
        this.mReasonOfDelivery = reasonOfDelivery;
        if (this.mDEUVDsme != null && this.mDEUVEmployee != null) {
            this.mDEUVDsme.setAbgabegrund(String.valueOf(reasonOfDelivery));
            this.mDEUVDsme.setKennzkv(this.mDEUVEmployee.getKennzkv(this));
        }
    }

    public void updateReasonOfDelivery() {
        if (this.mLongReasonOfDeliv != null && this.mLongReasonOfDeliv.length() >= 2) {
            String reason = this.mLongReasonOfDeliv.substring(0, 2);
            this.mReasonOfDelivery = Integer.parseInt(reason);
            if (this.mDEUVDsme != null) {
                this.mDEUVDsme.setAbgabegrund(reason);
                this.mDEUVDsme.setKennzkv(this.mDEUVEmployee.getKennzkv(this));
            }
        }
    }

    public boolean getTransmitted() {
        this.requireLoaded();
        return this.mTransmitted;
    }

    public void setTransmitted(boolean transmitted) {
        this.mTransmitted = transmitted;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public Date getValidUntil() {
        this.requireLoaded();
        return this.mValidUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.mValidUntil = validUntil;
    }

    public String getCanceled() {
        this.requireLoaded();
        return this.mCanceled;
    }

    public void setCanceled(String canceled) {
        this.mCanceled = canceled;
    }

    public String getDuesgroups() {
        this.requireLoaded();
        return this.mDuesgroups;
    }

    public void setDuesgroups(String duesgroups) {
        this.mDuesgroups = duesgroups;
    }

    public String getInsuranceNo() {
        this.requireLoaded();
        return this.mInsuranceNo;
    }

    public void setInsuranceNo(String insuranceno) {
        this.mInsuranceNo = insuranceno;
    }

    public BigDecimal getPayment() {
        this.requireLoaded();
        return this.mPayment;
    }

    public void setPayment(BigDecimal payment) {
        this.mPayment = payment;
    }

    public int getPersongroup() {
        this.requireLoaded();
        return this.mPersongroup;
    }

    public void setPersongroup(int persongroup) {
        this.mPersongroup = persongroup;
    }

    public int getSerialNumber() {
        this.requireLoaded();
        return this.mSerialNumber;
    }

    public void setSerialNumber(int counter) {
        this.mSerialNumber = counter;
    }

    public String getErrorMessage() {
        this.requireLoaded();
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public boolean getManually() {
        this.requireLoaded();
        return this.mManually;
    }

    public void setManually(boolean manually) {
        this.mManually = manually;
    }

    public void invertSerialNumber() {
        this.mSerialNumber = -this.getSerialNumber();
    }

    public boolean isSystemChangeEga() {
        return this.mSystemChangeEga;
    }

    public void setSystemChangeEga(boolean systemChangeEga) {
        this.mSystemChangeEga = systemChangeEga;
    }

    public boolean isEgaInBZ() {
        return this.mEgaInBZ;
    }

    public void setEgaInBZ(boolean egaInBZ) {
        this.mEgaInBZ = egaInBZ;
    }

    public boolean isSplitting() {
        return this.mSplitting;
    }

    public void setSplitting(boolean splitting) {
        this.mSplitting = splitting;
    }

    public AdviceStateEnum getAdviceState() {
        this.requireLoaded();
        return this.mAdviceState;
    }

    public void setAdviceState(AdviceStateEnum adviceState) {
        this.mAdviceState = adviceState;
    }

    public RvbeaDxar getRvbeaDxar() {
        this.requireLoaded();
        return this.mRvbeaDxar;
    }

    public void setRvbeaDxar(RvbeaDxar rvbeaDxar) {
        this.mRvbeaDxar = rvbeaDxar;
    }

    public boolean getSelfservice() {
        this.requireLoaded();
        return this.mSelfservice;
    }

    public void setSelfservice(boolean selfservice) {
        this.mSelfservice = selfservice;
    }

    public TypeOfAccountEnum getTypeOfAccount() {
        this.requireLoaded();
        return this.mTypeOfAccount;
    }

    public void setTypeOfAccount(TypeOfAccountEnum typeOfAccount) {
        this.mTypeOfAccount = typeOfAccount;
    }

    public BigDecimal getPaymentMidijob2022() {
        return this.mPaymentMidijob2022;
    }

    public void toStringValues(StringBuilder b) {
        b.append(this.mCanceled).append(',');
        b.append(this.mTransmitted ? J : N).append(',');
        b.append(this.mSelfservice ? J : N).append(',');
        b.append(this.mCreatedOn).append(',');
        b.append(DateMapper.toString((Date)this.mValidFrom)).append(',');
        b.append(DateMapper.toString((Date)this.mValidUntil)).append(',');
        if (this.mEmployee != null) {
            b.append(this.mEmployee.getDomainID()).append(',');
        }
        b.append(this.mLongReasonOfDeliv).append(',');
        b.append(this.mPayment).append(',');
    }

    public void init(DEUVEmployee de, DEUVTrigger trigger) {
        this.init(de, trigger.getValidFrom(), trigger.getValidUntil());
    }

    public void init(DEUVEmployee de, Date validFrom) {
        this.init(de, validFrom, VDate.getDateMax());
    }

    public void init(DEUVEmployee de, Date validFrom, Date validUntil) {
        this.mDEUVEmployee = de;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mEmployee = this.mDEUVEmployee.getEmployee();
        DEUVAdvice advice = this.mDEUVEmployee.getDEUVAdvice();
        this.mCreatedOn = advice.getCreatedOn();
        this.mEffectiveFrom = this.mDEUVEmployee.getEffectiveFrom();
        this.mDEUVSender = advice.getDEUVSender();
        this.mCanceled = N;
        this.mCurrentFileNumber = 0;
        this.mEeCertificate = false;
        this.mTransmitted = false;
    }

    public boolean initTimePeriods() throws BusinessDomainException {
        this.mValidInsurance = this.mDEUVEmployee.getInsuranceOrNull(this.mEffectiveFrom, this.mValidFrom);
        if (this.mValidInsurance == null) {
            return false;
        }
        this.mInsuranceNo = this.mDEUVEmployee.getInsuranceNo();
        this.mPersongroup = this.mValidInsurance.getPersonGroup();
        this.mDuesgroups = this.mValidInsurance.getDuesGroups();
        if (!this.mValidInsurance.isDEUVAdviceable()) {
            return false;
        }
        HealthFund healthfund = this.mValidInsurance.getHealthFund();
        if (healthfund == null) {
            return false;
        }
        this.mDEUVRecipient = this.mDEUVEmployee.getDEUVAdvice().getDEUVRecipient(healthfund);
        return true;
    }

    public void computePayment(Date endOfAbsentTime, boolean isEelAbsence) throws BusinessDomainException {
        if (PDateHelper.inSameMonth((Date)this.mValidUntil, (Date)endOfAbsentTime) && (!PDateHelper.isLastDayOfMonth((Date)endOfAbsentTime) || this.mDEUVEmployee.isSocialInsuranceFree(DateHelper.tomorrow((Date)this.mValidUntil), DateHelper.getLastDayOfMonth((Date)this.mValidUntil)))) {
            if (PDateHelper.inSameMonth((Date)this.mValidFrom, (Date)this.mValidUntil)) {
                this.computePayment(false);
            } else {
                Date temp = this.mValidUntil;
                this.mValidUntil = PDateHelper.getLastDayPreviousMonth((Date)this.mValidUntil);
                this.computePayment();
                this.mValidUntil = temp;
            }
        } else if (isEelAbsence) {
            Date temp = this.mValidUntil;
            this.mValidUntil = DateHelper.getLastDayOfMonth((Date)this.mValidUntil);
            this.computePayment();
            this.mValidUntil = temp;
        } else {
            this.computePayment();
        }
    }

    public void computePayment() throws BusinessDomainException {
        if (!PDateHelper.isFirstDayOfMonth((Date)this.mValidFrom) && this.mDEUVEmployee.isEelAbsence(DateHelper.yesterday((Date)this.mValidFrom))) {
            Date temp = this.mValidFrom;
            this.mValidFrom = DateHelper.getFirstDayOfMonth((Date)this.mValidFrom);
            this.computePayment(true);
            this.mValidFrom = temp;
        } else {
            this.computePayment(true);
        }
    }

    private void computePayment(boolean payment) throws BusinessDomainException {
        if (DateHelper.before((Date)this.mValidUntil, (Date)this.mValidFrom)) {
            this.addError("Fehler in der Verarbeitung. Ein Zeitraum vom " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mValidFrom) + " bis " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mValidUntil) + " ist unzul\u00e4ssig.");
        }
        this.mValidFrom = DateHelper.max((Date)this.mValidFrom, (Date)DateHelper.getFirstDayOfYear((Date)this.mValidUntil));
        this.setPayment(payment ? this.calculatePayment() : BigDecimal.ZERO);
        this.mDEUVEmployee.makeStoerfall(this.mValidFrom, this.mValidUntil);
        this.mDEUVDbme.setGleitzone(BigDecimalMapper.isZero((BigDecimal)this.getPayment()) ? ZERO : this.mDEUVEmployee.getLowWageType(this.mValidFrom, this.mValidUntil));
        this.mDEUVDbme.setEntgeltRb(ZERO.equals(this.mDEUVDbme.getGleitzone()) ? null : this.getPaymentRv());
        this.mDEUVDsme.setBbnrKrankenkasse(this.getBbnrKrankenkasse());
    }

    private BigDecimal calculatePayment() throws BusinessDomainException {
        Date paymentFrom = this.getPaymentFrom();
        if (this.mDEUVEmployee.isSocialInsuranceFree(paymentFrom, this.mValidUntil)) {
            return BigDecimal.ZERO;
        }
        if (DateHelper.before((Date)this.mValidUntil, (Date)START_OF_MBBGL)) {
            return this.getPaymentBefore2012(paymentFrom);
        }
        if (this.mDEUVEmployee.isBestandsschutz2022(this.mValidUntil)) {
            ValueInterval viPayment2022 = this.mDEUVEmployee.getPaymentPositions(this.mDEUVEmployee.getAdjustedDuesGroups2022(this.mDuesgroups));
            this.mPaymentMidijob2022 = viPayment2022.calculate(paymentFrom, this.mValidUntil);
        }
        ValueInterval viMbbgl = this.mDEUVEmployee.getMbbglPositions();
        if (this.isPensionPayingInstitution() && DateHelper.afterOrEqual((Date)paymentFrom, (Date)DEUVAdvice.START_OF_2020)) {
            ValueInterval viPaymentBv = this.mDEUVEmployee.getPaymentBvPositions();
            return this.calculatePayment(paymentFrom, viMbbgl, viPaymentBv);
        }
        ValueInterval viPayment = this.mDEUVEmployee.getPaymentPositions(this.mDuesgroups);
        return this.calculatePayment(paymentFrom, viMbbgl, viPayment);
    }

    private BigDecimal calculatePayment(Date paymentFrom, ValueInterval viMbbgl, ValueInterval viPayment) throws BusinessDomainException {
        if (!this.hasValuesForTimePeriod(viMbbgl, paymentFrom, this.mValidUntil)) {
            return viPayment.calculate(paymentFrom, this.mValidUntil);
        }
        int count = PDateHelper.countAffectedMonths((Date)this.mValidUntil, (Date)paymentFrom);
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            Date from = new VDate(paymentFrom).addMonths(i).getDate();
            BigDecimal minpayment = this.getMinimumPayment(viMbbgl, from);
            result = BigDecimalMapper.isZero((BigDecimal)minpayment) ? result.add(viPayment.calculate(from, from)) : result.add(minpayment);
        }
        return result;
    }

    private BigDecimal getMinimumPayment(ValueInterval vi, Date from) throws BusinessDomainException {
        BigDecimal minpayment = vi.calculate(from, from);
        if (BigDecimalMapper.isZero((BigDecimal)minpayment)) {
            return BigDecimal.ZERO;
        }
        boolean error = false;
        for (ValuePosition vp : vi.getValuePositions()) {
            if (!DateHelper.between((Date)from, (Date)vp.getValidFrom(), (Date)vp.getValidUntil()) || !DateHelper.before((Date)vp.getEffectiveFrom(), (Date)START_OF_MBBGL_CORRECTION)) continue;
            error = true;
            break;
        }
        if (error) {
            BigDecimal monthlymin = this.mDEUVEmployee.getMinPaymentGfB(from);
            if (BigDecimalMapper.isZero((BigDecimal)minpayment.remainder(monthlymin))) {
                return monthlymin;
            }
            this.addError("Fehler bei der Ermittlung der Mindestbeitragsbemessungsgrundlage. Neuberechnung erforderlich!");
        }
        return minpayment;
    }

    private boolean hasValuesForTimePeriod(ValueInterval valueInterval, Date validFrom, Date validUntil) {
        boolean result = false;
        for (ValuePosition each : valueInterval.getValuePositions()) {
            if (!PDateHelper.isIntersection((Date)validFrom, (Date)validUntil, (Date)each.getValidFrom(), (Date)each.getValidUntil())) continue;
            result = true;
            break;
        }
        return result;
    }

    private BigDecimal getPaymentBefore2012(Date paymentFrom) throws BusinessDomainException {
        ValueInterval vi = this.mDEUVEmployee.getPaymentPositions(this.mDuesgroups);
        if (!this.mValidInsurance.isMonthlyMinimum()) {
            return vi.calculate(paymentFrom, this.mValidUntil);
        }
        int count = PDateHelper.countAffectedMonths((Date)this.mValidUntil, (Date)paymentFrom);
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            Date from = new VDate(paymentFrom).addMonths(i).getDate();
            BigDecimal payment = vi.calculate(from, from);
            result = BigDecimalMapper.compareTo((BigDecimal)payment, (BigDecimal)MONTHLY_MINIMUM) < 0 ? result.add(MONTHLY_MINIMUM) : result.add(payment);
        }
        return result;
    }

    private BigDecimal getPaymentRv() throws BusinessDomainException {
        if (DateHelper.before((Date)this.mValidUntil, (Date)DEUVAdvice.MID_OF_2019)) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        if (DateHelper.before((Date)this.mValidFrom, (Date)DEUVAdvice.MID_OF_2019)) {
            Date validUntil = this.mValidUntil;
            this.mValidUntil = DateHelper.yesterday((Date)DEUVAdvice.MID_OF_2019);
            result = this.calculatePayment();
            this.mValidUntil = validUntil;
            result = result.add(this.mDEUVEmployee.getPaymentRvMidijob(DEUVAdvice.MID_OF_2019, this.mValidUntil));
        } else {
            result = this.mDEUVEmployee.getPaymentRvMidijob(this.mValidFrom, this.mValidUntil);
        }
        return result;
    }

    public static final BigDecimal truncate(BigDecimal amount) {
        if (amount == null) {
            return amount;
        }
        return amount.setScale(0, RoundingMode.HALF_UP);
    }

    public DEUVDsme createDEUVDsme() throws BusinessDomainException {
        return this.createDEUVDsme(null);
    }

    public DEUVDsme createDEUVDsme(String bbnrKrankenkasse) throws BusinessDomainException {
        this.mDEUVDsme = new DEUVDsme();
        this.mDEUVDsme.setDEUVAccount(this);
        this.mDEUVDsme.setBbnrAbsender(this.getSenderCompanyNumber());
        this.mDEUVDsme.setDatumErstellung(this.getCreatedOn());
        this.mDEUVDsme.setVersicherungsnr(this.getInsuranceNo());
        String bbnrVerursacher = this.getEECompanyPlant().getCompanyNumber();
        if (bbnrVerursacher != null) {
            this.mDEUVDsme.setBbnrVerursacher(bbnrVerursacher);
        } else {
            this.mDEUVDsme.setBbnrVerursacher(LAW_AREA_ERROR);
        }
        this.mDEUVDsme.setAzVerursacher(Deuv.toAzVerursacher((String)this.mEmployee.getIDString()));
        if (bbnrKrankenkasse == null) {
            this.mDEUVDsme.setBbnrKrankenkasse(this.getBbnrKrankenkasse());
        } else {
            this.mDEUVDsme.setBbnrKrankenkasse(bbnrKrankenkasse);
        }
        this.mDEUVDsme.setPersonengruppe(this.getPersongroup());
        this.mDEUVDsme.setAbgabegrund(String.valueOf(this.getReasonOfDelivery()));
        this.mDEUVDsme.setStaat(this.getNationalityKey());
        this.mDEUVDsme.setProdId(DeuvBasics.getProdId());
        this.mDEUVDsme.setModId(DeuvBasics.getModId());
        if (DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)DEUVAdvice.START_OF_2023)) {
            String mainEmployerNumber = DEUVAdvice.getMainEmployerNumber(this.getEmployee(), this.mEffectiveFrom, this.getValidDate());
            this.mDEUVDsme.setHauptbetriebsnummer(mainEmployerNumber);
        }
        return this.mDEUVDsme;
    }

    public String getNationalityKey() throws BusinessDomainException {
        Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveFrom, this.getValidDate());
        return insurance.getNationality().getState();
    }

    public String getBbnrKrankenkasse() throws BusinessDomainException {
        Date validDate = this.getValidDate();
        Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveFrom, validDate);
        return this.getBbnrKrankenkasse(insurance.getHealthFund(), validDate);
    }

    private String getBbnrKrankenkasse(HealthFund healthFund, Date validDate) throws BusinessDomainException {
        return HealthFund.getHealthFundConsiderFusions((HealthFund)healthFund, (Date)validDate).getHealthFundTP(this.mEffectiveFrom, VDate.getDateMax()).getStandardCompanyNumber();
    }

    public String getSenderCompanyNumber() throws BusinessDomainException {
        DEUVSenderTP tp = this.mDEUVSender.getDEUVSenderTP(VDate.getDateMax(), VDate.getDateMax());
        return tp.getStdCompanyNumber();
    }

    public DEUVDbso createDEUVDbso() {
        DEUVDbso dbso = this.mDEUVDsme.createDbso();
        dbso.setBeginn(this.mValidFrom);
        return dbso;
    }

    public DEUVDbme createDEUVDbme() throws BusinessDomainException {
        DEUVDbme dbme = this.mDEUVDsme.createDbme();
        dbme.setBeginn(this.mValidFrom);
        if (!VDate.getDateMax().equals(this.mValidUntil)) {
            dbme.setEnde(this.mValidUntil);
        }
        dbme.setEntgelt(this.mPayment);
        dbme.setBeitragsgruppe(this.mDuesgroups);
        dbme.setTaetigkeitssl(this.getOccupationKey());
        if (DateHelper.before((Date)this.getValidFrom(), (Date)DEUVAdvice.START_OF_2025)) {
            String rechtskreis = this.getEECompanyPlant().getLawArea();
            if (rechtskreis != null) {
                dbme.setRechtskreis(rechtskreis);
            } else {
                dbme.setRechtskreis(LAW_AREA_ERROR);
            }
        }
        return dbme;
    }

    private String getOccupationKey() throws BusinessDomainException {
        Date validDate = this.getValidDate();
        Insurance insurance = this.mDEUVEmployee.getInsurance(VDate.getDateMax(), validDate);
        return insurance.getOccupationKey(validDate);
    }

    public DEUVDbna createDEUVDbna() {
        return this.mDEUVEmployee.fill(this.mDEUVDsme.createDEUVDbna(), this.mValidFrom);
    }

    public DEUVDbgb createDEUVDbgb() {
        return this.mDEUVEmployee.fill(this.mDEUVDsme.createDbgb());
    }

    public DEUVDban createDEUVDban() {
        return this.mDEUVEmployee.fill(this.mDEUVDsme.createDban());
    }

    private boolean isDsme() {
        return this.getTypeOfAccount() == TypeOfAccountEnum.DSME;
    }

    public static Criterion getFilterForDsme() {
        return Restrictions.lt((String)DEUVAccountPersistencyManager.TYPEOFACCOUNT, (String)TypeOfAccountEnum.toDBString((TypeOfAccountEnum)TypeOfAccountEnum.DSFZ));
    }

    public static Criterion getFilterForDsfz() {
        return Restrictions.eq((String)DEUVAccountPersistencyManager.TYPEOFACCOUNT, (String)TypeOfAccountEnum.toDBString((TypeOfAccountEnum)TypeOfAccountEnum.DSFZ));
    }

    public boolean isCurrentVersion() {
        if (this.isDsme()) {
            return this.getDEUVDsme().isCurrentVersion();
        }
        return this.getDeuvDsfz().isCurrentVersion();
    }

    public DEUVDsme getDEUVDsme() {
        if (this.mDEUVDsme == null && this.isDsme()) {
            DEUVDsme[] rs = DEUVDsmePersistencyManager.query(null, (Criterion)Restrictions.eq((String)"oiddeuvaccount", (String)this.getObjectid()), (boolean)true);
            if (rs.length != 1) {
                throw new IllegalStateException("Advice inconsistent, " + rs.length + " DSME (not 1).");
            }
            this.mDEUVDsme = rs[0];
        }
        return this.mDEUVDsme;
    }

    public DEUVDsfz getDeuvDsfz() {
        if (this.mDeuvDsfz == null && !this.isDsme()) {
            DEUVDsfz[] rs = DEUVDsfzPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"oiddeuvaccount", (String)this.getObjectid()), (boolean)true);
            if (rs.length != 1) {
                throw new IllegalStateException("Advice inconsistent, " + rs.length + " DSFZ (not 1).");
            }
            this.mDeuvDsfz = rs[0];
        }
        return this.mDeuvDsfz;
    }

    public DEUVDbme getDEUVDbme() {
        if (this.mDEUVDbme == null && this.isDsme()) {
            this.mDEUVDbme = this.getDEUVDsme().getDEUVDbme();
        }
        return this.mDEUVDbme;
    }

    public DEUVDbna getDEUVDbna() {
        if (this.mDEUVDbna == null) {
            this.mDEUVDbna = this.isDsme() ? this.getDEUVDsme().getDEUVDbna() : this.getDeuvDsfz().getDeuvDbna();
        }
        return this.mDEUVDbna;
    }

    public DEUVDban getDEUVDban() {
        if (this.mDEUVDban == null) {
            this.mDEUVDban = this.isDsme() ? this.getDEUVDsme().getDEUVDban() : this.getDeuvDsfz().getDeuvDban();
        }
        return this.mDEUVDban;
    }

    public DEUVDbgb getDEUVDbgb() {
        if (this.mDEUVDbgb == null) {
            this.mDEUVDbgb = this.isDsme() ? this.getDEUVDsme().getDEUVDbgb() : this.getDeuvDsfz().getDeuvDbgb();
        }
        return this.mDEUVDbgb;
    }

    public DEUVDbuv getDEUVDbuv() {
        if (this.mDEUVDbuv == null && this.isDsme()) {
            this.mDEUVDbuv = this.getDEUVDsme().getDEUVDbuv();
        }
        return this.mDEUVDbuv;
    }

    public DEUVDbso getDEUVDbso() {
        if (this.mDEUVDbso == null && this.isDsme()) {
            this.mDEUVDbso = this.getDEUVDsme().getDEUVDbso();
        }
        return this.mDEUVDbso;
    }

    public DeuvDbkv getDeuvDbkv() {
        if (this.mDeuvDbkv == null && this.isDsme()) {
            this.mDeuvDbkv = this.getDEUVDsme().getDeuvDbkv();
        }
        return this.mDeuvDbkv;
    }

    public DEUVDbst getDeuvDbst() {
        if (this.mDeuvDbst == null && this.isDsme()) {
            this.mDeuvDbst = this.getDEUVDsme().getDEUVDbst();
        }
        return this.mDeuvDbst;
    }

    public void setDEUVDbuv(DEUVDbuv dbuv) {
        this.mDEUVDbuv = dbuv;
    }

    public void setDeuvDbst(DEUVDbst dbst) {
        this.mDeuvDbst = dbst;
    }

    public DEUVDsfz createDeuvDsfz() {
        this.mDeuvDsfz = new DEUVDsfz();
        this.mDeuvDsfz.setDeuvAccount(this);
        this.setTypeOfAccount(TypeOfAccountEnum.DSFZ);
        return this.mDeuvDsfz;
    }

    public boolean compareToOldAll(DEUVAccount other) {
        return this.compareToOld(other) || this.mDEUVDsme.isStaatChanged(other.mDEUVDsme) || this.isDEUVDbanChanged(other) || this.isDEUVDbnaChanged(other);
    }

    public boolean compareToOld(DEUVAccount other) {
        if (other == null) {
            return true;
        }
        if (LOGGER.isDebugEnabled() && this.getDEUVDbme() != null && other.getDEUVDbme() != null && StringMapper.compareTo((String)this.mDEUVDbme.getGleitzone(), (String)other.mDEUVDbme.getGleitzone()) != 0) {
            LOGGER.debug("changed Gleitzonenkennzeichen <{}> <{}> <{}> <{}>", new Object[]{this.getDEUVDbme().getGleitzone(), other.getDEUVDbme().getGleitzone(), this.getDEUVDbme(), other.getDEUVDbme()});
        }
        return CompareToOldUtil.isDifferent((int)this.getReasonOfDelivery(), (int)other.getReasonOfDelivery()) || this.getDEUVDsme().compareToOld(other.getDEUVDsme()) || this.isDEUVDbmeChanged(other) || this.isDEUVDbsoChanged(other) || this.isDeuvDbkvChanged(other);
    }

    private boolean isDEUVDbmeChanged(DEUVAccount other) {
        if (this.mDEUVDbme == null || other.mDEUVDbme == null) {
            return this.mDEUVDbme != other.mDEUVDbme;
        }
        return this.mDEUVDbme.compareToOld(other.mDEUVDbme);
    }

    private boolean isDEUVDbsoChanged(DEUVAccount other) {
        if (this.getDEUVDbso() == null || other.getDEUVDbso() == null) {
            return this.mDEUVDbso != other.mDEUVDbso;
        }
        return this.mDEUVDbso.compareToOld(other.mDEUVDbso);
    }

    private boolean isDeuvDbkvChanged(DEUVAccount other) {
        if (this.getDeuvDbkv() == null || other.getDeuvDbkv() == null) {
            return this.mDeuvDbkv != other.mDeuvDbkv;
        }
        return this.mDeuvDbkv.compareToOld(other.mDeuvDbkv);
    }

    private boolean isDEUVDbnaChanged(DEUVAccount other) {
        if (this.getDEUVDbna() == null || other.getDEUVDbna() == null) {
            return this.mDEUVDbna != other.mDEUVDbna;
        }
        return this.mDEUVDbna.compareToOld(other.mDEUVDbna);
    }

    private boolean isDEUVDbanChanged(DEUVAccount other) {
        if (this.getDEUVDban() == null || other.getDEUVDban() == null) {
            return this.mDEUVDban != other.mDEUVDban;
        }
        return this.mDEUVDban.compareToOld(other.mDEUVDban);
    }

    public void loadAdvicedState(DEUVEmployee de) {
        this.mDEUVEmployee = de;
        this.getDEUVDsme();
        this.getDeuvDsfz();
        this.getDEUVDbna();
        this.getDEUVDbgb();
        this.getDEUVDban();
        this.getDEUVDbme();
        this.getDEUVDbuv();
        this.getDEUVDbso();
        this.getDeuvDbkv();
        this.getDeuvDbst();
        if (this.mDEUVDbme != null) {
            BigDecimal payment;
            String duesgroup = this.mDEUVDbme.getBeitragsgruppe();
            if (!StringMapper.equal((String)duesgroup, (String)this.mDuesgroups)) {
                this.mDuesgroups = duesgroup;
                this.makeSaveable();
            }
            if (BigDecimalMapper.compareTo((BigDecimal)(payment = this.mDEUVDbme.getEntgelt()), (BigDecimal)this.mPayment) != 0) {
                this.setPayment(payment);
                this.makeSaveable();
            }
        }
        if (this.mDEUVDsme != null) {
            String insuranceNo;
            int persongroup = this.mDEUVDsme.getPersonengruppe();
            if (persongroup != this.mPersongroup) {
                this.mPersongroup = persongroup;
                this.makeSaveable();
            }
            if (!StringMapper.equal((String)(insuranceNo = this.mDEUVDsme.getVersicherungsnr()), (String)this.mInsuranceNo)) {
                this.mInsuranceNo = insuranceNo;
                this.makeSaveable();
            }
        }
    }

    public boolean create() throws BusinessDomainException {
        if (!this.initTimePeriods()) {
            return false;
        }
        this.mDEUVDsme = this.createDEUVDsme();
        this.mDEUVDbme = this.createDEUVDbme();
        this.mDEUVDbna = this.createDEUVDbna();
        this.mDEUVDban = this.createDEUVDban();
        if (this.isInsuranceUnknown()) {
            this.mDEUVDbgb = this.createDEUVDbgb();
        }
        return true;
    }

    public boolean isInsuranceUnknown() {
        return StringMapper.isNullString((String)this.getInsuranceNo());
    }

    public void makeReadOnly() {
        super.makeReadOnly();
        if (this.mDEUVDsme != null) {
            this.mDEUVDsme.makeReadOnly();
        }
        if (this.getDeuvDsfz() != null) {
            this.mDeuvDsfz.makeReadOnly();
        }
        if (this.mDEUVDbme != null) {
            this.mDEUVDbme.makeReadOnly();
        }
        if (this.mDEUVDbna != null) {
            this.mDEUVDbna.makeReadOnly();
        }
        if (this.mDEUVDbgb != null) {
            this.mDEUVDbgb.makeReadOnly();
        }
        if (this.mDEUVDban != null) {
            this.mDEUVDban.makeReadOnly();
        }
        if (this.mDEUVDbeu != null) {
            this.mDEUVDbeu.makeReadOnly();
        }
        if (this.mDEUVDbso != null) {
            this.mDEUVDbso.makeReadOnly();
        }
        if (this.mDEUVDbuv != null) {
            this.mDEUVDbuv.makeReadOnly();
        }
        if (this.mDeuvDbkv != null) {
            this.mDeuvDbkv.makeReadOnly();
        }
        if (this.mDeuvDbst != null) {
            this.mDeuvDbst.makeReadOnly();
        }
    }

    public void makeSaveable() {
        super.makeSaveable();
        this.requireLoaded();
        if (!this.myStateAtDeuvBegin() && this.mTransmitted) {
            return;
        }
        this.partialMakeSaveable();
    }

    public void specialMakeSaveable() {
        this.requireLoaded();
        super.makeSaveable();
        this.partialMakeSaveable();
    }

    private void partialMakeSaveable() {
        if (this.mDEUVDsme != null) {
            this.mDEUVDsme.makeSaveable();
        }
        if (this.getDeuvDsfz() != null) {
            this.mDeuvDsfz.makeSaveable();
        }
        if (this.mDEUVDbme != null) {
            this.mDEUVDbme.makeSaveable();
        }
        if (this.mDEUVDbna != null) {
            this.mDEUVDbna.makeSaveable();
        }
        if (this.mDEUVDbgb != null) {
            this.mDEUVDbgb.makeSaveable();
        }
        if (this.mDEUVDban != null) {
            this.mDEUVDban.makeSaveable();
        }
        if (this.mDEUVDbeu != null) {
            this.mDEUVDbeu.makeSaveable();
        }
        if (this.mDEUVDbso != null) {
            this.mDEUVDbso.makeSaveable();
        }
        if (this.mDEUVDbuv != null) {
            this.mDEUVDbuv.makeSaveable();
        }
        if (this.mDeuvDbkv != null) {
            this.mDeuvDbkv.makeSaveable();
        }
        if (this.mDeuvDbst != null) {
            this.mDeuvDbst.makeSaveable();
        }
    }

    public boolean isCancelled() {
        this.requireLoaded();
        return !StringMapper.equal((String)this.mCanceled, (String)N);
    }

    public DEUVAccount createNew() {
        this.requireLoaded();
        DEUVAccount a = new DEUVAccount();
        a.mEmployee = this.getEmployee();
        a.mPCompany = this.getPCompany();
        a.mDEUVEmployee = this.mDEUVEmployee;
        a.mDEUVDsme = this.getDEUVDsme().createNew(a);
        if (this.getDEUVDbme() != null) {
            a.mDEUVDbme = this.mDEUVDbme.createNew(a.mDEUVDsme);
        }
        if (this.getDEUVDbna() != null) {
            a.mDEUVDbna = this.mDEUVDbna.createNew(a.mDEUVDsme);
        }
        if (this.getDEUVDbgb() != null) {
            a.mDEUVDbgb = this.mDEUVDbgb.createNew(a.mDEUVDsme);
        }
        if (this.getDEUVDban() != null) {
            a.mDEUVDban = this.mDEUVDban.createNew(a.mDEUVDsme);
        }
        if (this.getDEUVDbuv() != null) {
            a.mDEUVDbuv = this.mDEUVDbuv.createNew(a.mDEUVDsme);
        }
        if (this.getDEUVDbso() != null) {
            a.mDEUVDbso = this.mDEUVDbso.createNew(a.mDEUVDsme);
        }
        if (this.getDeuvDbkv() != null) {
            a.mDeuvDbkv = this.mDeuvDbkv.createNew(a.mDEUVDsme);
        }
        if (this.getDeuvDbst() != null) {
            a.mDeuvDbst = this.mDeuvDbst.makeCopy(a.mDEUVDsme);
        }
        a.mEffectiveFrom = this.mEffectiveFrom;
        a.mCreatedOn = this.mCreatedOn;
        a.mValidFrom = this.mValidFrom;
        a.mValidUntil = this.mValidUntil;
        a.mReasonOfDelivery = this.mReasonOfDelivery;
        a.mLongReasonOfDeliv = this.mLongReasonOfDeliv;
        a.mDEUVSender = this.mDEUVSender;
        a.mDEUVRecipient = this.mDEUVRecipient;
        a.mInsuranceNo = this.mInsuranceNo;
        a.mPersongroup = this.mPersongroup;
        a.mDuesgroups = this.mDuesgroups;
        a.setPayment(this.mPayment);
        a.mEeCertificate = false;
        a.mTransmitted = false;
        a.mCurrentFileNumber = 0;
        a.mCanceled = N;
        a.mSerialNumber = 0;
        a.mErrorMessage = null;
        a.mManually = false;
        return a;
    }

    public void setDEUVEmployee(DEUVEmployee de) {
        this.mDEUVEmployee = de;
    }

    public void createAdvicePeriod(DEUVAccount adviced) throws BusinessDomainException {
        DEUVDbme db;
        this.initInsurance(this.mValidUntil);
        this.mDEUVRecipient = adviced.mDEUVRecipient;
        this.mInsuranceNo = this.mDEUVEmployee.getInsuranceNo();
        this.mDuesgroups = this.mValidInsurance.getDuesGroups();
        if (adviced.getPersongroup() != this.mValidInsurance.getPersonGroup()) {
            this.setErrorMessage("PGS Anmeldung ungleich PGS Abmeldung");
        }
        this.mPersongroup = this.mValidInsurance.getPersonGroup();
        DEUVDsme ds = adviced.getDEUVDsme();
        this.mDEUVDsme = ds.createNew(this);
        this.mDEUVDsme.setMmName(N);
        this.mDEUVDsme.setMmGeburtsangaben(N);
        this.mDEUVDsme.setMmAnschrift(N);
        this.mDEUVDsme.setMmEuDaten(N);
        this.mDEUVDsme.setMmMeldedaten(J);
        this.mDEUVDsme.setDatumErstellung(this.mCreatedOn);
        this.mDEUVDsme.setVersicherungsnr(this.mInsuranceNo);
        this.mDEUVDsme.setPersonengruppe(this.mPersongroup);
        this.mDEUVDsme.setStaat(this.getNationalityKey());
        if (DateHelper.afterOrEqual((Date)this.mValidUntil, (Date)DEUVAdvice.START_OF_2023)) {
            String mainEmployerNumber = DEUVAdvice.getMainEmployerNumber(this.getEmployee(), this.mEffectiveFrom, this.getValidDate());
            this.mDEUVDsme.setHauptbetriebsnummer(mainEmployerNumber);
        }
        if (!N.equals((db = adviced.getDEUVDbme()).getStornokennzeichen())) {
            throw new IllegalStateException("Not N, never referr to a canceled advice.");
        }
        this.mDEUVDbme = db.createNew(this.mDEUVDsme);
        this.mDEUVDbme.setBeitragsgruppe(this.mDuesgroups);
        if (DateHelper.afterOrEqual((Date)this.mValidUntil, (Date)DEUVAdvice.START_OF_2025)) {
            this.mDEUVDbme.setRechtskreis(null);
        } else if (this.mDEUVDbme.getRechtskreis() == null) {
            String rechtskreis = this.getEECompanyPlant().getLawArea();
            if (rechtskreis != null) {
                this.mDEUVDbme.setRechtskreis(rechtskreis);
            } else {
                this.mDEUVDbme.setRechtskreis(LAW_AREA_ERROR);
            }
        }
        this.mDEUVDbme.setTaetigkeitssl(this.getOccupationKey());
    }

    private void initInsurance(Date endOfPeriod) throws BusinessDomainException {
        this.mValidInsurance = this.mDEUVEmployee.getInsurance(this.mEffectiveFrom, endOfPeriod);
    }

    public boolean isCalendaryReason() {
        this.requireLoaded();
        return DisruptionImpl.isCalendarymonth((int)this.mReasonOfDelivery);
    }

    public void updateDbme() throws BusinessDomainException {
        this.mDEUVDbme.setBeginn(this.mValidFrom);
        if (VDate.isDateMax((Date)this.mValidUntil)) {
            this.mDEUVDbme.setEnde(null);
        } else {
            this.mDEUVDbme.setEnde(this.mValidUntil);
        }
        this.mDEUVDbme.setEntgelt(this.mPayment);
        this.mDEUVDbme.setTaetigkeitssl(this.getOccupationKey());
    }

    public boolean isAffectedBy(Date validFrom) {
        this.requireLoaded();
        if (DateHelper.compare((Date)this.mValidFrom, (Date)validFrom) >= 0) {
            return true;
        }
        return this.isPaymentOrSpecial() && DateHelper.compare((Date)DateHelper.tomorrow((Date)this.mValidUntil), (Date)validFrom) >= 0;
    }

    private boolean isBeginOrModification() {
        return this.mValidUntil == null || DateHelper.equal((Date)this.mValidUntil, (Date)VDate.getDateMax());
    }

    public boolean isPayment() {
        this.requireLoaded();
        return this.isPaymentOrSpecial() && !this.isSpecialCase();
    }

    private boolean isPaymentOrSpecial() {
        return !this.isBeginOrModification();
    }

    public boolean isEntry() {
        return this.getReasonOfDelivery() == 10 || this.getReasonOfDelivery() == 11 || this.getReasonOfDelivery() == 12 || this.getReasonOfDelivery() == 13;
    }

    public boolean isLeave() {
        this.requireLoaded();
        return this.mReasonOfDelivery == 30 || this.mReasonOfDelivery == 34 || this.mReasonOfDelivery == 35 || this.mReasonOfDelivery == 33 || this.mReasonOfDelivery == 49;
    }

    public boolean isReasonPrompt() {
        return this.getReasonOfDelivery() == 20;
    }

    private boolean isEgaInAbsence() {
        return this.getReasonOfDelivery() == 54;
    }

    private boolean isStoerfall() {
        return this.getReasonOfDelivery() == 55;
    }

    public boolean isReasonDbkv() {
        return this.getReasonOfDelivery() == 58;
    }

    public boolean isSpecialCase() {
        this.requireLoaded();
        return this.isEgaInAbsence() || this.isStoerfall() || this.mReasonOfDelivery == 56;
    }

    public boolean isModification() {
        int reasonOfDelivery = this.getReasonOfDelivery();
        return reasonOfDelivery == 60 || reasonOfDelivery == 61 || reasonOfDelivery == 62 || reasonOfDelivery == 63;
    }

    public boolean isUvReason() {
        return this.getReasonOfDelivery() == 91 || this.getReasonOfDelivery() == 92;
    }

    public void update(BigDecimal payment, String reason) throws BusinessDomainException {
        this.setPayment(payment);
        this.mReasonOfDelivery = Integer.parseInt(reason.substring(0, 2));
        this.mLongReasonOfDeliv = reason;
        if (this.initTimePeriods()) {
            this.mDEUVDsme = this.createDEUVDsme();
            this.mDEUVDbme = this.createDEUVDbme();
            this.mDEUVDbme.setGleitzone(ZERO);
        }
    }

    public void makeLeave(Date absenceUntil) throws BusinessDomainException {
        this.computePayment();
        if (this.isPaymentExemtion(absenceUntil)) {
            this.setPayment(BigDecimal.valueOf(0L));
        }
        this.updateDbme();
    }

    private boolean isPaymentExemtion(Date absenceUntil) {
        if (absenceUntil == null) {
            return false;
        }
        Date leaveAt = this.mValidUntil;
        DEUVAccount lastCreated = this.mDEUVEmployee.getLastCreated();
        if (lastCreated != null && !DateHelper.before((Date)absenceUntil, (Date)leaveAt) && lastCreated.isCalendaryReason()) {
            return true;
        }
        Date firstOfLeave = DateHelper.getFirstDayOfMonth((Date)leaveAt);
        if (this.mDEUVEmployee.isCalendaryReason()) {
            Date disruption = this.mDEUVEmployee.getDisruption().getValidAfter();
            disruption = DateHelper.getFirstDayOfMonth((Date)disruption);
            disruption = new VDate(disruption).addMonths(1).getDate();
            return DateHelper.equal((Date)firstOfLeave, (Date)disruption);
        }
        Date disruption = this.mValidFrom;
        disruption = DateHelper.getFirstDayOfMonth((Date)disruption);
        disruption = new VDate(disruption).addMonths(1).getDate();
        return DateHelper.equal((Date)firstOfLeave, (Date)disruption);
    }

    public void clearDbanAssociation() {
        if (this.mDEUVDban != null) {
            this.mDEUVDban.makeReadOnly();
        }
        this.mDEUVDban = null;
    }

    public void clearDbnaAssociation() {
        if (this.mDEUVDbna != null) {
            this.mDEUVDbna.makeReadOnly();
        }
        this.mDEUVDbna = null;
    }

    public void clearDbstAssociation() {
        if (this.mDeuvDbst != null) {
            this.mDeuvDbst.makeReadOnly();
        }
        this.mDeuvDbst = null;
    }

    public void clearDbmeAssociation() {
        if (this.mDEUVDbme != null) {
            this.mDEUVDbme.makeReadOnly();
        }
        this.mDEUVDbme = null;
    }

    public void clearDbuvAssociation() {
        if (this.mDEUVDbuv != null) {
            this.mDEUVDbuv.makeReadOnly();
        }
        this.mDEUVDbuv = null;
    }

    public void update(DEUVAccount current) {
        if (this.isEgaInAbsence()) {
            return;
        }
        if (this.isDisruptionCalendary()) {
            this.mDEUVEmployee.setDisruption(this);
            return;
        }
        current.mDEUVRecipient = this.mDEUVRecipient;
        current.mInsuranceNo = this.mInsuranceNo;
        current.mPersongroup = this.mPersongroup;
        current.mDuesgroups = this.mDuesgroups;
        current.mReasonOfDelivery = this.mReasonOfDelivery;
        current.mLongReasonOfDeliv = this.mLongReasonOfDeliv;
        current.mDEUVDsme = this.mDEUVDsme;
        if (this.mDEUVDbme != null) {
            current.mDEUVDbme = this.mDEUVDbme;
            if (this.isBeginOrModification()) {
                current.mValidFrom = this.mValidFrom;
            } else {
                current.mDEUVDbme = this.mDEUVDbme;
                current.setValidAfter(this.mValidUntil);
            }
        }
        if (this.mDEUVDbna != null) {
            current.mDEUVDbna = this.mDEUVDbna;
        }
        if (this.mDEUVDbgb != null) {
            current.mDEUVDbgb = this.mDEUVDbgb;
        }
        if (this.mDEUVDban != null) {
            current.mDEUVDban = this.mDEUVDban;
        }
        if (this.mDEUVDbeu != null) {
            current.mDEUVDbeu = this.mDEUVDbeu;
        }
    }

    public boolean isDisruptionCalendary() {
        return DisruptionImpl.isCalendarymonth((int)this.mReasonOfDelivery);
    }

    public void setValidAfter(Date until) {
        this.mValidFrom = DateHelper.tomorrow((Date)until);
    }

    public Date getValidAfter() {
        this.requireLoaded();
        if (this.isBeginOrModification()) {
            return this.mValidFrom;
        }
        return DateHelper.tomorrow((Date)this.mValidUntil);
    }

    public DEUVAccount makeCancellation(boolean hasErrors, DEUVAdvice deuvAdvice) throws BusinessDomainException {
        if (hasErrors) {
            this.makeReadOnly();
        } else {
            this.makeSaveable();
        }
        this.mCanceled = X;
        DEUVAccount storno = this.createNew();
        storno.mTransmitted = this.myStateAtDeuvBegin();
        storno.mCanceled = J;
        if (storno.mDEUVDbso != null) {
            storno.mDEUVDbso.setStornokennzeichen(J);
        }
        if (storno.mDEUVDbme != null) {
            storno.mDEUVDbme.setStornokennzeichen(J);
        }
        if (storno.mDeuvDbkv != null) {
            storno.mDeuvDbkv.setKennzst(J);
        }
        storno.mDEUVDsme.makeCancellation();
        storno.mDEUVDsme.updateVersionNr();
        storno.mDEUVDsme.setProdId(DeuvBasics.getProdId());
        storno.mDEUVDsme.setModId(DeuvBasics.getModId());
        storno.mDEUVDsme.clearDbuvAssociation();
        deuvAdvice.updateDeuvRecipient(storno);
        storno.mDEUVDsme.setDatensatzIdUrsprung(this.mDEUVDsme.getDatensatzId());
        if (storno.mDEUVDbme != null && DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)DEUVAdvice.START_OF_2025)) {
            storno.mDEUVDbme.setRechtskreis(null);
        }
        if (storno.mDeuvDbkv != null && DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)DEUVAdvice.START_OF_2025)) {
            storno.mDeuvDbkv.setKennzrk(null);
        }
        if (this.getManually() && !StringMapper.isNullString((String)this.getErrorMessage())) {
            storno.setManually(true);
            storno.setErrorMessage(this.getErrorMessage());
            storno.setErrorKey();
        }
        return storno;
    }

    public boolean isInvalid() {
        return this.mReasonOfDelivery == 0 || this.mDEUVDsme == null;
    }

    public boolean makeErrors(boolean hasErrors) {
        return this.makeErrors(hasErrors, this.mDEUVEmployee.getDEUVAdvice());
    }

    public boolean makeErrors(boolean hasErrors, DEUVAdvice deuvAdvice) {
        boolean isUnrecoverableError;
        String vosz;
        String accountString;
        Krips kernpruefung;
        Rueckgabe rueckgabe;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.isRecipientDasBv() && (rueckgabe = (kernpruefung = new Krips()).pruefe(accountString = DeuvComponents.getContentDeuvAccount((DEUVAccount)this), vosz = this.getContentVoszForCheck())).getReturnCode() >= 2) {
            for (String error : rueckgabe.getRueckgabeMeldungen()) {
                if (!this.isErrorValid(error)) continue;
                errorMessages.add(error);
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(DeuvHelper.getErrorMessage((String)this.mErrorMessage, errorMessages, (boolean)false));
        if (!(this.getReasonOfDelivery() != 10 || this.mEmployee == null || DsvvHelper.isValidForTransfer((Employee)this.mEmployee, (String)this.getInsuranceNo()) || !StringMapper.isNullString((String)this.getInsuranceNo()) && this.isInsuranceNoUsedBefore(this.getInsuranceNo()))) {
            builder.append("Anmeldungen sind nur nach erfolgter \"Abfrage Versicherungsnummer\" m\u00f6glich!");
        }
        if (deuvAdvice != null && deuvAdvice.getInsuranceNoBlackList().contains(this.getInsuranceNo())) {
            builder.append("Ung\u00fcltige SV-Nummer. ");
        }
        if (this.mEmployee != null && !this.mEmployee.getMasterdatachecked()) {
            builder.append("Der Mitarbeiter-Pr\u00fcflauf wurde nicht erfolgreich durchgef\u00fchrt. ");
        }
        if (this.mReasonOfDelivery != 92 && !this.isCancellation() && DateHelper.before((Date)this.mValidFrom, (Date)Insurance.START_OF_DISABILTTY_CERTICATE) && (this.mPersongroup == 107 || this.mPersongroup == 111 || this.mPersongroup == 127)) {
            builder.append("Meldungen f\u00fcr die PGS 107, 111, 127 k\u00f6nnen erst ab dem 01.01.2015 erstellt werden. ");
        }
        boolean bl = isUnrecoverableError = builder.length() != 0;
        if (this.mValidInsurance != null && this.mValidInsurance.isIncreasedDuesMinersPISheme() && this.mValidInsurance.getPersonGroup() != 109) {
            builder.append("Bei erh\u00f6htem Beitrag zur knappschaftlichen RV, werden keine DE\u00dcV-Meldungen erstellt. ");
            this.setManually(true);
        }
        if (this.isSystemChangeEga()) {
            builder.insert(0, "M\u00e4rzklausel nach Systemwechsel: Die Meldung betrifft einen Zeitraum vor Berechnungsbeginn und muss daher manuell f\u00fcr den letzten Besch\u00e4ftigungsmonat vor Systemwechsel gemeldet werden!");
            this.setManually(true);
            isUnrecoverableError = false;
        }
        if (this.isEgaInBZ()) {
            builder.insert(0, "Ega w\u00e4hrend Fehlzeit BZ, keine Besch\u00e4ftigung seit Berechnungsbeginn: EGA muss daher manuell f\u00fcr den letzten Besch\u00e4ftigungsmonat vor Systemwechsel gemeldet werden!");
            this.setManually(true);
            isUnrecoverableError = false;
        }
        if (builder.length() != 0 && !this.myStateAtDeuvBegin()) {
            if (this.mEmployee != null) {
                builder.insert(0, "*** Achtung: Keine Meldung f\u00fcr Pers.-Nr. " + this.mEmployee.getPersonnelnumber() + " Abgabegrund " + this.mLongReasonOfDeliv + " ");
            } else {
                builder.insert(0, "*** ");
            }
            if (builder.length() > 250) {
                builder.setLength(246);
                builder.append(" ...");
            }
            builder.append(" ***");
            this.mErrorMessage = builder.toString();
        }
        if (hasErrors && StringMapper.isNullString((String)this.mErrorMessage)) {
            this.setErrorDependency();
        }
        if (!StringMapper.isNullString((String)this.mErrorMessage)) {
            this.setErrorKey();
        }
        return isUnrecoverableError;
    }

    public String getContentVoszForCheck() {
        StringBuilder b = new StringBuilder();
        DeuvTransfer.append((StringBuilder)b, (String)"VOSZ", (int)4);
        DeuvTransfer.append((StringBuilder)b, (String)this.getVerfahrenskennz(), (int)5);
        DeuvTransfer.append((StringBuilder)b, (String)this.getDEUVSender().getActiveDEUVSenderTP().getStdCompanyNumber(), (int)15);
        DeuvTransfer.append((StringBuilder)b, (String)this.getDEUVRecipient().getActiveDEUVRecipientTP().getStdCompanyNumber(), (int)15);
        DeuvTransfer.append((StringBuilder)b, (String)DeuvBasics.formatDEUVTimestamp((Date)this.getCreatedOnDate()), (int)8);
        DeuvTransfer.append((StringBuilder)b, (int)this.getDEUVRecipient().getActiveDEUVRecipientTP().getFileNumberOfDEUV(), (int)6);
        DeuvTransfer.append((StringBuilder)b, (String)this.getDEUVSender().getActiveDEUVSenderTP().getName(), (int)50);
        DeuvTransfer.append((StringBuilder)b, (String)"01", (int)2, (int)105);
        return b.toString();
    }

    private String getVerfahrenskennz() {
        if (this.getDEUVRecipient().getTypeOfHealthFund() == TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG) {
            return "AGTRV";
        }
        return "AGDEU";
    }

    private boolean isErrorValid(String error) {
        boolean valid = true;
        if (this.mDEUVSender.isTestSender()) {
            if (error.contains("DBME133")) {
                valid = false;
            }
            if (error.contains("DSME628") && this.getPersongroup() == 109) {
                valid = false;
            }
        }
        if (error.contains("DSME644")) {
            valid = false;
        }
        return valid;
    }

    private boolean isInsuranceNoUsedBefore(String insuranceNo) {
        Conjunction adviceStateFilter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.ADVICESTATE, (String)AdviceStateEnum.toDBString((AdviceStateEnum)AdviceStateEnum.UEBERMITTELT)), Restrictions.lt((String)DEUVAccountPersistencyManager.CREATEDON, (String)"2020")});
        adviceStateFilter = Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.ADVICESTATE, (String)AdviceStateEnum.toDBString((AdviceStateEnum)AdviceStateEnum.ERFOLGREICH)), adviceStateFilter});
        return DEUVAccountPersistencyManager.getRowCount((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.INSURANCENO, (String)insuranceNo), adviceStateFilter})) > 0L;
    }

    public void setErrorDependency() {
        this.mErrorMessage = "Abh\u00e4ngigkeit zu fehlerhafter DE\u00dcV-Meldung dieses Mitarbeiters. ";
        this.setErrorKey();
    }

    private void setErrorKey() {
        this.mCanceled = K;
    }

    public void addError(String errorMessage) {
        this.mErrorMessage = StringMapper.isNullString((String)this.getErrorMessage()) ? errorMessage : this.mErrorMessage.trim() + ", " + errorMessage;
    }

    public boolean compareToOldState(DEUVAccount other) {
        return other == null || this.mDEUVDsme.compareToOld(other.mDEUVDsme) || this.mDEUVDbme.compareToOldState(other.mDEUVDbme);
    }

    public boolean isAbsenceHidden() {
        return this.isReadOnly() && this.isCalendaryReason();
    }

    public boolean checkSplitting() {
        return DEUVAccount.checkSplitting(this.mPersongroup, this.mDuesgroups);
    }

    public static boolean checkSplitting(int persongroup, String duesgroups) {
        return (persongroup == 101 || persongroup == 106) && duesgroups.startsWith("6") && !duesgroups.endsWith("000");
    }

    public void updateSplitting() throws BusinessDomainException {
        this.mSplitting = true;
        this.mDuesgroups = "6000";
        if (this.mDEUVDbme != null) {
            this.mDEUVDbme.setBeitragsgruppe(this.mDuesgroups);
        }
        this.mDEUVDsme.setBbnrKrankenkasse(this.mDEUVEmployee.getDEUVAdvice().getMinijobStdCompanyNo());
        this.mDEUVRecipient = this.mDEUVEmployee.getDEUVAdvice().getBuknRecipient();
        if (this.mLongReasonOfDeliv.startsWith("1")) {
            this.mReasonOfDelivery = 10;
            this.mLongReasonOfDeliv = _10;
            this.updateReasonOfDelivery();
        }
    }

    public void stripSplitting() {
        this.mSplitting = true;
        char[] chars = this.mDuesgroups.toCharArray();
        chars[0] = 48;
        this.mDuesgroups = new String(chars);
        if (this.mDEUVDbme != null) {
            this.mDEUVDbme.setBeitragsgruppe(this.mDuesgroups);
        }
    }

    public boolean isBeginNotAbsence() {
        this.requireLoaded();
        return !this.isModification() && !this.isBeginAfterAbsence() && this.isBeginOrModification();
    }

    private boolean isBeginAfterAbsence() {
        return _13_04.equals(this.mLongReasonOfDeliv) || _13_08.equals(this.mLongReasonOfDeliv) || _13_11.equals(this.mLongReasonOfDeliv) || _13_13.equals(this.mLongReasonOfDeliv) || _13_14.equals(this.mLongReasonOfDeliv);
    }

    public boolean isBeginAfterAbsence(Date validFrom) {
        this.requireLoaded();
        if (!DateHelper.equal((Date)this.mValidFrom, (Date)validFrom)) {
            return false;
        }
        return this.isBeginAfterAbsence();
    }

    public boolean makePersonalData(DEUVAccount adviced) {
        if (this.isCancelled() || this.mDEUVDbna != null && this.mDEUVDban != null && !this.myStateAtDeuvBegin()) {
            return true;
        }
        boolean changed = false;
        if (this.mDEUVDbna == null) {
            DEUVDbna dbna = this.createDEUVDbna();
            if (dbna.compareToOld(adviced.mDEUVDbna)) {
                this.mDEUVDbna = dbna;
                changed = true;
            } else {
                this.mDEUVDsme.setMmName(N);
                dbna.makeReadOnly();
            }
        }
        if (this.mDEUVDban == null) {
            DEUVDban dban = this.createDEUVDban();
            if (dban.compareToOld(adviced.mDEUVDban)) {
                this.mDEUVDban = dban;
                changed = true;
            } else {
                this.mDEUVDsme.setMmAnschrift(N);
                dban.makeReadOnly();
            }
        }
        if (changed && !this.hasError()) {
            this.makeErrors(false);
        }
        return !this.mSplitting;
    }

    public void updateResume(DEUVAccount current) {
        if (this.isModification() && !this.mTransmitted) {
            return;
        }
        current.mDEUVDsme = this.mDEUVDsme;
        if (this.mDEUVDbna != null) {
            current.mDEUVDbna = this.mDEUVDbna;
        }
        if (this.mDEUVDban != null) {
            current.mDEUVDban = this.mDEUVDban;
        }
    }

    public boolean isInvalidOrInsignificant() {
        this.requireLoaded();
        return this.isInvalid() || this.isPGS110();
    }

    public boolean isPGS110() {
        this.requireLoaded();
        return this.mPersongroup == 110;
    }

    public boolean isInsignificantForAnnual() {
        return this.isPGS110() && this.mValidFrom != null && (DateHelper.before((Date)this.mValidFrom, (Date)DEUVAdvice.START_OF_2009) || DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)DEUVAdvice.START_OF_2017));
    }

    public DEUVAccount makeDeuvBegin() throws BusinessDomainException {
        EECarriedForwardSystemSI cfi = EECarriedForwardSystemSI.getEECarriedForwardSystemSI((Employee)this.mEmployee);
        if (this.mPersongroup == 110) {
            this.mLongReasonOfDeliv = _13_99;
            this.mTransmitted = true;
            return this;
        }
        if (cfi == null) {
            this.mLongReasonOfDeliv = _13_07;
            return this;
        }
        String cfDuesgroups = cfi.getDuesGroups();
        HealthFund cfh = cfi.getHealthFund();
        if ("0000".equals(cfDuesgroups) && cfi.getPersonGroup() != 190 || cfh == null) {
            this.mLongReasonOfDeliv = EntryImpl.reasonBy((int)this.mPersongroup);
            return this;
        }
        HealthFundTP cftp = this.mDEUVEmployee.getHealthFundTP(cfh, this.mEffectiveFrom, this.mValidFrom);
        String id = this.getBbnrKrankenkasse();
        if (!cftp.getStandardCompanyNumber().equals(id) && !this.getBbnrKrankenkasse(cfh, this.mValidFrom).equals(id)) {
            this.mLongReasonOfDeliv = _11;
            return this;
        }
        if (!this.mDuesgroups.equals(cfDuesgroups)) {
            this.mLongReasonOfDeliv = _12;
            return this;
        }
        this.mLongReasonOfDeliv = _13_07;
        return this;
    }

    public int fixReasonAtFusion(int reasonsIndex) throws BusinessDomainException {
        if (reasonsIndex != 16) {
            return reasonsIndex;
        }
        HealthFundTP previous = this.getHealthFundTP(this.mValidUntil);
        HealthFundTP current = this.getHealthFundTP(DateHelper.tomorrow((Date)this.mValidUntil));
        if (previous != null && current != null) {
            if (StringMapper.equal((String)previous.getStandardCompanyNumberSuccessor(), (String)current.getStandardCompanyNumber())) {
                return -1;
            }
            if (StringMapper.equal((String)previous.getStandardCompanyNumber(), (String)current.getStandardCompanyNumber())) {
                return -1;
            }
        }
        return reasonsIndex;
    }

    private HealthFundTP getHealthFundTP(Date validFrom) {
        try {
            Insurance in = this.mDEUVEmployee.getInsurance(this.mEffectiveFrom, validFrom);
            HealthFund hf = in.getHealthFund();
            return this.mDEUVEmployee.getHealthFundTP(hf, this.mEffectiveFrom, DateHelper.tomorrow((Date)validFrom));
        }
        catch (BusinessDomainException e) {
            return null;
        }
    }

    public boolean hasError() {
        this.requireLoaded();
        return K.equals(this.mCanceled);
    }

    public boolean isSeparateRequired() throws BusinessDomainException {
        if (DateHelper.before((Date)this.getValidFrom(), (Date)START_OF_REASON57)) {
            return false;
        }
        Insurance insurance = this.mEmployee.getInsurance(VDate.getDateMax(), this.getValidFrom());
        if (DateHelper.equal((Date)this.getValidFrom(), (Date)insurance.getPensionBalanceTriggerDate())) {
            return true;
        }
        Date startOfPensionPayment = new VDate(this.getValidFrom()).addMonths(3).getDate();
        return DateHelper.equal((Date)startOfPensionPayment, (Date)(insurance = this.mEmployee.getInsurance(VDate.getDateMax(), startOfPensionPayment)).getStartOfPensionPayment());
    }

    public boolean isPersongroupATZ() {
        this.requireLoaded();
        return this.mPersongroup == 103;
    }

    public boolean isPromptRequired() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mReasonOfDelivery != 10) {
            return false;
        }
        if (DateHelper.before((Date)this.mValidFrom, (Date)DEUVAdvice.START_OF_2009)) {
            return false;
        }
        return this.mDEUVEmployee.isPromptRequired(this.getValidDate());
    }

    public DEUVAccount createPrompt() {
        DEUVAccount account = this.createNew();
        try {
            account.updatePrompt();
        }
        catch (BusinessDomainException exception) {
            this.appendErrorMessage(account, "Sofortmeldung", exception);
        }
        return account;
    }

    private void appendErrorMessage(DEUVAccount result, String action, BusinessDomainException exception) {
        ExceptionMapper.printException((Throwable)exception);
        result.appendErrorMessage("Fehler bei Aufbau " + action + ": " + exception.getMessage() + ". ");
    }

    private void updatePrompt() throws BusinessDomainException {
        this.mCanceled = N;
        this.mReasonOfDelivery = 20;
        this.mLongReasonOfDeliv = _20;
        this.updateReasonOfDelivery();
        if (this.mDEUVDban != null && !StringMapper.isNullString((String)this.mInsuranceNo)) {
            this.mDEUVDsme.clearDbanAssociation();
        }
        this.mDEUVDbme.clearDsmeAssociation();
        this.mDEUVDsme.setHauptbetriebsnummer(null);
        this.mDEUVDbso = this.createDEUVDbso();
        this.mDEUVRecipient = this.mDEUVEmployee.getPromptRecipient();
        DEUVRecipientTP tp = this.mDEUVRecipient.getDEUVRecipientTP(VDate.getDateMax(), VDate.getDateMax());
        this.mDEUVDsme.setBbnrKrankenkasse(tp.getStdCompanyNumber());
    }

    private void appendErrorMessage(String message) {
        this.addError(message);
    }

    public boolean isStateAtDeuvBegin() {
        this.requireLoaded();
        return this.myStateAtDeuvBegin();
    }

    public void setStateAtDeuvBegin() {
        this.mLongReasonOfDeliv = _13_99;
        this.mReasonOfDelivery = 13;
        this.mTransmitted = true;
        this.makeReadOnly();
        this.updatePersonalData();
    }

    public void updatePersonalData() {
        try {
            PersonalCurrentData pcd = new PersonalCurrentData(this.mEmployee, this.mValidFrom, this.mValidFrom);
            pcd.fill((IDbanData)this.mDEUVDban);
            pcd.fill((IDbnaData)this.mDEUVDbna);
        }
        catch (BusinessDomainException e) {
            LOGGER.warn("Can't update personal data of {}", (Object)this);
        }
    }

    public boolean isPensionBalanceDifferent(DEUVAccount other) {
        if (other == null || this.mValidInsurance == null || other.mValidInsurance == null) {
            return false;
        }
        return this.mValidInsurance.isPensionBalanceDifferent(other.mValidInsurance);
    }

    public boolean isPensionPayingInstitution() {
        RecipientTP tp;
        Recipient recipient;
        if (this.mDEUVEmployee != null && !this.mDEUVEmployee.isPensionPayingEnabled(this.mValidFrom)) {
            return false;
        }
        Insurance insurance = (Insurance)this.getEmployee().getInsuranceHistory().getItemOrNull(this.mEffectiveFrom, this.getValidDate());
        if (insurance != null && (recipient = insurance.getRecipient()) != null && (tp = (RecipientTP)recipient.getHistory().getItemOrNull(this.mEffectiveFrom, this.getValidDate())) != null) {
            return TypeOfRecipientEnum.TORE_Versorgungseinrichtung == tp.getTypeOfRecipientEnum();
        }
        return false;
    }

    public void updatePensionPayingInstitution() throws BusinessDomainException {
        String ppMembershipNumber;
        Insurance insurance = this.getEmployee().getInsurance(this.mEffectiveFrom, this.getValidDate());
        Recipient recipient = insurance.getRecipient();
        RecipientTP tp = recipient.getRecipientTP(this.mEffectiveFrom, this.getValidDate());
        this.mDEUVDsme.setBbnrKrankenkasse(tp.getStandardCompanyNumber());
        if (StringMapper.isNullString((String)tp.getStandardCompanyNumber())) {
            this.addError("die Betriebsnummer der berufsst\u00e4ndischen Versorgungseinrichtung fehlt");
        }
        if (StringMapper.isNullString((String)(ppMembershipNumber = insurance.getPpMembershipNumber()))) {
            this.addError("die Mitgliedsnummer berufsst\u00e4ndische Versorgung fehlt");
        }
        this.mDEUVDsme.setAzKrankenkasse(ppMembershipNumber);
        this.mDEUVDsme.clearDbstAssociation();
        if (ppMembershipNumber.startsWith(LAW_AREA_ERROR)) {
            if (this.isEntry()) {
                if (this.mDEUVDbna == null) {
                    this.mDEUVDbna = this.createDEUVDbna();
                }
                if (this.mDEUVDbgb == null) {
                    this.mDEUVDbgb = this.createDEUVDbgb();
                }
            } else {
                this.addError("die Dummy-Mitgliedsnummer BV ist nur bei Anmeldungen zul\u00e4ssig");
            }
        }
        if (this.mDEUVDbme != null && !StringMapper.isNullString((String)this.mDEUVDbme.getGleitzone())) {
            this.mDEUVDbme.setGleitzone(ZERO);
            this.mDEUVDbme.setEntgeltRb(null);
        }
    }

    public Date getValidDate() {
        if (this.isBeginOrModification()) {
            return this.getValidFromOrEntry();
        }
        return this.getValidUntil();
    }

    public Date getValidFromOrEntry() {
        Employment[] es = this.getEmployee().getEmploymentHistory(VDate.getDateMax());
        Date first = es[0].getValidFrom();
        return DateHelper.max((Date)first, (Date)this.getValidFrom());
    }

    private Date getPaymentFrom() {
        this.requireLoaded();
        if (PDateHelper.isFirstDayOfMonth((Date)this.mValidFrom) || !this.mDEUVEmployee.isBeginDisruption(this.mValidFrom)) {
            return this.mValidFrom;
        }
        return PDateHelper.getFirstDayNextMonth((Date)this.mValidFrom);
    }

    public int compareToResume(DEUVAccount anOther) {
        int comp = DateHelper.compare((Date)this.getValidFrom(), (Date)anOther.getValidFrom());
        if (comp == 0) {
            int anotherVal;
            int thisVal = this.getReasonOfDelivery();
            int n = thisVal < (anotherVal = anOther.getReasonOfDelivery()) ? -1 : (comp = thisVal == anotherVal ? 0 : 1);
        }
        if (comp == 0) {
            comp = -DateHelper.compare((Date)PDateHelper.toDate((Date)this.getValidUntil()), (Date)PDateHelper.toDate((Date)anOther.getValidUntil()));
        }
        if (comp == 0) {
            comp = this.compareDuesGroups(this.getDuesgroups(), anOther.getDuesgroups());
        }
        if (comp == 0) {
            comp = this.compareTo(this.reorder(this), this.reorder(anOther));
        }
        return comp;
    }

    private int reorder(DEUVAccount account) {
        if (account.getDEUVRecipient() == null) {
            return 0;
        }
        if (account.isRecipientDasBv()) {
            return 1;
        }
        return -1;
    }

    private int compareDuesGroups(String dues1, String dues2) {
        if (this.getReasonOfDelivery() == 58) {
            return 0;
        }
        return StringMapper.compareTo((String)dues1, (String)dues2);
    }

    private int compareTo(int one, int anOther) {
        return one < anOther ? -1 : (one == anOther ? 0 : 1);
    }

    public boolean isCancellation() {
        if (this.getDEUVDbme() != null) {
            return J.equals(this.getDEUVDbme().getStornokennzeichen());
        }
        if (this.getDEUVDbso() != null) {
            return J.equals(this.getDEUVDbso().getStornokennzeichen());
        }
        if (this.getDeuvDbkv() != null) {
            return J.equals(this.getDeuvDbkv().getKennzst());
        }
        return false;
    }

    public void reorgCancelled(String cancelled) {
        if (!cancelled.equals(this.getCanceled())) {
            this.setCanceled(cancelled);
            this.makeSaveable();
        }
    }

    public void update(DeuvDbkv dbkv) {
        this.mDeuvDbkv = dbkv;
        this.mPayment = BigDecimalMapper.isZeroOrNull((BigDecimal)dbkv.getLfdrv()) ? dbkv.getLfdkv() : dbkv.getLfdrv();
    }

    public void update(DEUVDsme dsme, DEUVDbme dbme) {
        this.mDEUVDsme = dsme;
        this.mDEUVDbme = dbme;
    }

    public void update(DEUVDsme dsme, DeuvDbkv dbkv) {
        this.mDEUVDsme = dsme;
        this.mDeuvDbkv = dbkv;
    }

    public void updateKennzeichen() throws BusinessDomainException {
        if (this.mDEUVDsme != null && (this.getReasonOfDelivery() == 10 || this.getReasonOfDelivery() == 40)) {
            int duesGroupHi;
            Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveFrom, this.getValidDate());
            this.mDEUVDsme.setStatuskennzeichen(insurance.getStatusCodeDEUV());
            if (this.mDEUVDbme != null && DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)DEUVAdvice.START_OF_2018) && this.mPersongroup >= 100 && this.mPersongroup < 200 && ((duesGroupHi = insurance.getDuesGroupHI()) == 1 || duesGroupHi == 2 || duesGroupHi == 3)) {
                this.mDEUVDbme.setKennzSaisonarbeitnehmer(DeuvBasics.asString((boolean)insurance.getSeasonalworker()));
            }
        }
    }

    public boolean isAfterStartMidijob() {
        return DateHelper.afterOrEqual((Date)this.getValidDate(), (Date)DEUVAdvice.MID_OF_2019);
    }

    public boolean isRecipientDasBv() {
        return this.getDEUVRecipient().getTypeOfHealthFund() == TypeOfHealthFundEnum.TOHF_VERSORGUNG || this.getDEUVDsme() != null && !StringMapper.isNullString((String)this.getDEUVDsme().getAzKrankenkasse());
    }

    private IEECompanyPlant getEECompanyPlant() {
        if (this.mEECompanyPlant == null) {
            this.mEECompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
            this.mEECompanyPlant.setEmployee(this.getEmployee());
            this.mEECompanyPlant.setEffectiveFrom(this.getEffectiveFrom());
            this.mEECompanyPlant.setValidFrom(this.getValidDate());
        }
        return this.mEECompanyPlant;
    }

    private static class DeuvAccountSortComparator
    implements Comparator<DEUVAccount> {
        private DeuvAccountSortComparator() {
        }

        @Override
        public int compare(DEUVAccount acc1, DEUVAccount acc2) {
            int diff = StringMapper.compareTo((String)acc1.getCreatedOn(), (String)acc2.getCreatedOn());
            if (diff == 0) {
                diff = acc1.getSerialNumber() < acc2.getSerialNumber() ? -1 : (acc1.getSerialNumber() == acc2.getSerialNumber() ? 0 : 1);
            }
            return diff;
        }
    }
}

