/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.companyplant.TypeOfBusinessEnum;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.DeuvBasicComponents;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.DeuvComponents;
import com.varial.personnel.domain.deuv.DeuvEmployer;
import com.varial.personnel.domain.deuv.IVoszData;
import com.varial.personnel.domain.deuv.deuvdbpa.DeuvDbpa;
import com.varial.personnel.domain.deuv.deuvdsbd.DEUVDsbd;
import com.varial.personnel.domain.deuv.deuvdsbd.DEUVDsbdPersistencyManager;
import com.varial.personnel.domain.deuv.deuvdsbd.IDeuvDsbd;
import com.varial.personnel.domain.deuv.dsak.BasicDeuvEmployerCreator;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.BasicTransfer;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basictypes.ContactPerson;
import com.varial.personnel.domain.employee.accidentinsurancefund.partclassofrisk.IPartClassOfRiskPersistencyManager;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTP;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientPersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.framework.CompareToOldUtil;
import com.varial.personnel.framework.basictypes.Communication;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.deutscherv.gb0500.kernpruefung.krips.impl.Krips;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kernpruefung.Rueckgabe;

public class DeuvDsbdCreate
extends BasicDeuvEmployerCreator<DEUVDsbd> {
    private static final String N = "N";
    private static final String J = "J";
    private static final String A = "A";
    private static final String R = "R";
    private static final String B = "B";
    private static final String L = "L";
    private static final Date START_OF_2025 = DateMapper.toDate((String)"2025-01-01");
    private static final Date END_INITIAL_2025 = DateMapper.toDate((String)"2025-06-01");
    private static final String REASON_01 = "01";
    private static final String REASON_09 = "09";
    private static final String PRIVATE_HOUSEHOLD = "18002";
    private DEUVRecipientTP mDeuvRecipientTP;
    private DsbdTransfer mTransfer;
    Map<String, DeuvEmployer> mDeuvEmployerMap = new HashMap<String, DeuvEmployer>();
    private Map<String, DEUVDsbd> mTransmitteds;

    public DeuvDsbdCreate(DEUVSender deuvSender) {
        super(deuvSender);
    }

    public List<DEUVDsbd> createDsbds() throws BusinessDomainException {
        for (DEUVDsbd each : DeuvDsbdCreate.getUntransmitteds(this.getDeuvSender())) {
            each.destroy();
        }
        this.initDsbdEmployers();
        this.createInitialUnrs(this.mDeuvEmployerMap);
        LocalDate maxChangeDate = LocalDate.now().plusMonths(3L).with(TemporalAdjusters.lastDayOfMonth());
        for (DeuvEmployer each : this.mDeuvEmployerMap.values()) {
            if (each.getChangeDate() != null && DateHelper.toLocalDate((Date)each.getChangeDate()).isAfter(maxChangeDate)) continue;
            DEUVDsbd created = this.createDsbd(each);
            DEUVDsbd old = this.getTransmittedDsbd(each);
            if (REASON_01.equals(created.getAbgabegrund())) {
                if (old == null) {
                    created.setTransmitted(true);
                    created.setAdviceState(AdviceStateEnum.INITIALZUSTAND);
                    continue;
                }
                if (!this.isEndTransmittedAlready(created, old) && this.isDsbdChanged(created, old)) {
                    this.add(created);
                    continue;
                }
                created.makeReadOnly();
                continue;
            }
            this.add(created);
        }
        return this.getCreateds();
    }

    public List<String> getIDsUsingDeuvSenderContact() throws BusinessDomainException {
        ArrayList<String> result = new ArrayList<String>();
        this.initDsbdEmployers();
        for (DeuvEmployer each : this.mDeuvEmployerMap.values()) {
            if (!each.isDeuvSenderContactUsed()) continue;
            result.add(each.getIdentifier());
        }
        return result;
    }

    private DEUVDsbd createDsbd(DeuvEmployer each) throws BusinessDomainException {
        DEUVDsbd created = new DEUVDsbd();
        this.fillBasisDataDsbd(created);
        created.setBbnrBeschBetrieb(each.getStdCompanyNo());
        created.setAzVerursacher(each.getIdentifier());
        created.setDatumEreignis(each.getChangeDate());
        created.setAbgabegrund(each.getReasonOfDelivery());
        DeuvEmployer.CorrespondenceAddress ma = each.getMainAddress();
        created.setName1(ma.getName1());
        created.setName2(ma.getName2());
        created.setName3(ma.getName3());
        created.setPostleitzahl(ma.getPostalCode());
        created.setOrt(ma.getDomicile());
        created.setStrasse(ma.getStreetName());
        created.setHausnummer(ma.getStreetNumber());
        created.setRechtsform(each.getLegalFormDsbd());
        created.setRechtsformergaenzung(each.getLegalFormAdditionDsbd());
        created.setUnrs(each.getUnrs());
        created.setKennzBeendigung(each.getTypeOfBusiness());
        Communication communicationDsbd = new Communication(StringMapper.maxLength((String)each.getTelephoneNumber(), (int)20), "", "", StringMapper.maxLength((String)each.getEMailAddress(), (int)70), "", StringMapper.maxLength((String)each.getContactPerson(), (int)30));
        created.setCommunicationDsbd(communicationDsbd);
        DeuvDbpa dbpa = created.createDbpa();
        if (each.hasOtherAddress()) {
            dbpa.setArtPostanschrift(each.getTypeOfOtherPostalAddress());
            DeuvEmployer.CorrespondenceAddress oa = each.getOtherAddress();
            dbpa.setName1(oa.getName1());
            dbpa.setName2(oa.getName2());
            dbpa.setName3(oa.getName3());
            dbpa.setPostleitzahl(oa.getPostalCode());
            dbpa.setOrt(oa.getDomicile());
            dbpa.setStrasse(oa.getStreetName());
            dbpa.setHausnummer(oa.getStreetNumber());
            dbpa.setPlzpostfach(oa.getPostalCodePingeonHole());
            dbpa.setPostfach(oa.getPingeonHole());
            if (oa.getState() != null && !StringMapper.isNullString((String)oa.getState().getState()) && !StringMapper.equal((String)oa.getState().getState(), (String)"000")) {
                dbpa.setLaenderkennzeichen(oa.getState().getActiveStateTP().getStateTag());
            }
        } else {
            dbpa.setKennzLoeschenPa(L);
        }
        if (!each.getMainAddress().isNameValid() || each.hasOtherAddress() && !each.getOtherAddress().isNameValid()) {
            created.setErrorMessage(FrameWorkExceptionMapper.makeLongDescriptionFormatDomainException((String)"Name").getMessage());
            created.makeReadOnly();
        }
        if (each.hasMainUnrsError()) {
            created.setErrorMessage("Es konnte keine eindeutige Haupt-UNRS ermittelt werden! " + String.join((CharSequence)", ", each.getUnrsList()));
        } else if (created.getUnrs() == null) {
            created.setErrorMessage("Es konnte keine UNRS ermittelt werden!");
        }
        return created;
    }

    private void fillBasisDataDsbd(DEUVDsbd dsbd) throws BusinessDomainException {
        dsbd.setDEUVSender(this.getDeuvSender());
        DEUVRecipientTP recipientTP = this.getDEUVRecipientTPForDsbd();
        dsbd.setDEUVRecipient(recipientTP.getDEUVRecipient());
        dsbd.setTransmitted(false);
        dsbd.setBbnrAbsender(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.getDeuvSender()));
        dsbd.setBbnrEmpfaenger(recipientTP.getStdCompanyNumber());
        dsbd.setDatumErstellung(this.getCreatedOn());
        dsbd.setBbnrAbrstelle("");
        dsbd.setProdId(DeuvBasics.getProdId());
        dsbd.setModId(DeuvBasics.getModId());
        dsbd.setKennzName(N);
        dsbd.setKennzAnschrift(N);
        dsbd.setKennzAP(N);
        dsbd.setKennzunrs(N);
    }

    private void initDsbdEmployers() throws BusinessDomainException {
        HashMap<String, List<DeuvEmployer>> bbnrEmployerMap = new HashMap<String, List<DeuvEmployer>>();
        ArrayList<String> compOids = new ArrayList<String>();
        for (PCompany pCompany : this.getAssignedPCompanies()) {
            compOids.add(pCompany.getObjectid());
            this.addEmployer(pCompany, bbnrEmployerMap);
        }
        if (compOids.isEmpty()) {
            return;
        }
        for (Plant plant : this.getPlantsForCompOids(compOids)) {
            this.addEmployer(plant, bbnrEmployerMap);
        }
        this.mDeuvEmployerMap.clear();
        for (String bbnr : bbnrEmployerMap.keySet()) {
            List employerList = (List)bbnrEmployerMap.get(bbnr);
            this.initUnrs(employerList);
            DeuvEmployer mainEmployer = (DeuvEmployer)employerList.get(0);
            if (mainEmployer.getUnrsList().isEmpty() && this.isPrivateHousehold(mainEmployer)) continue;
            this.mDeuvEmployerMap.put(bbnr, mainEmployer);
        }
    }

    private void addEmployer(PCompany pCompany, Map<String, List<DeuvEmployer>> bbnrEmployerMap) throws BusinessDomainException {
        GeneralEmploymentOffice ceo = this.getGeneralEmploymentOffice(pCompany);
        if (ceo == null || this.isInvalidEmployerNumber(ceo.getEmployerNumber())) {
            return;
        }
        Foundations foundations = this.getFoundations(pCompany).getFoundations();
        ContactPerson cct = DeuvHelper.getCommunication((DEUVSenderTP)this.getDeuvSenderTP(), (PCompany)pCompany, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.DSBD);
        boolean deuvSenderContactUsed = !DeuvHelper.hasCommunication((PCompany)pCompany, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.DSBD);
        String id = pCompany.getPCompanyKey();
        DeuvEmployer employer = new DeuvEmployer(pCompany, ceo, foundations, cct, id, this.getDateOfEvent(pCompany, null, foundations), deuvSenderContactUsed);
        this.addEmployer(employer, bbnrEmployerMap);
    }

    protected void addEmployer(Plant plant, Map<String, List<DeuvEmployer>> bbnrEmployerMap) throws BusinessDomainException {
        GeneralEmploymentOffice peo = this.getGeneralEmploymentOffice(plant);
        if (peo == null || StringMapper.isNullString((String)peo.getEmployerNumber())) {
            peo = this.getGeneralEmploymentOffice(plant.getHeadCompany());
        }
        if (peo == null || this.isInvalidEmployerNumber(peo.getEmployerNumber())) {
            return;
        }
        Foundations foundations = this.getFoundations(plant).getFoundations();
        ContactPerson pct = DeuvHelper.getCommunication((DEUVSenderTP)this.getDeuvSenderTP(), (Plant)plant, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.DSBD);
        boolean deuvSenderContactUsed = !DeuvHelper.hasCommunication((Plant)plant, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.DSBD);
        String id = plant.getHeadCompany().getPCompanyKey() + "/" + plant.getPlantKey();
        DeuvEmployer employer = new DeuvEmployer(plant, peo, foundations, pct, id, this.getDateOfEvent(null, plant, foundations), deuvSenderContactUsed);
        this.addEmployer(employer, bbnrEmployerMap);
    }

    private void addEmployer(DeuvEmployer employer, Map<String, List<DeuvEmployer>> bbnrEmployerMap) {
        List<DeuvEmployer> employerList = bbnrEmployerMap.get(employer.getStdCompanyNo());
        if (employerList == null) {
            employerList = new ArrayList<DeuvEmployer>();
            employerList.add(employer);
            bbnrEmployerMap.put(employer.getStdCompanyNo(), employerList);
        } else {
            DeuvEmployer master = employerList.get(0);
            if (!this.hasDsbd(master) && this.hasDsbd(employer)) {
                employerList.add(0, employer);
            } else {
                employerList.add(employer);
            }
        }
    }

    private Date getDateOfEvent(PCompany pCompany, Plant plant, Foundations foundations) {
        ArrayList foundList;
        Date result;
        Date date = result = pCompany != null ? pCompany.getDateOfEventDsbd() : plant.getDateOfEventDsbd();
        if (foundations.getTypeOfBusiness() != TypeOfBusinessEnum.TYBE_BETRIEBSAUFGABE) {
            return result;
        }
        if (pCompany != null) {
            foundList = new ArrayList(pCompany.getCompanyFoundationsHistory().getAll());
            Collections.reverse(foundList);
            for (CompanyFoundations each : foundList) {
                if (each.getFoundations().getTypeOfBusiness() == TypeOfBusinessEnum.TYBE_BETRIEBSAUFGABE) {
                    result = each.getValidFrom();
                    continue;
                }
                return result;
            }
        }
        if (plant != null) {
            foundList = new ArrayList(plant.getPlantFoundationsHistory().getAll());
            Collections.reverse(foundList);
            for (CompanyFoundations each : foundList) {
                if (each.getFoundations().getTypeOfBusiness() == TypeOfBusinessEnum.TYBE_BETRIEBSAUFGABE) {
                    result = each.getValidFrom();
                    continue;
                }
                return result;
            }
        }
        return result;
    }

    private boolean isPrivateHousehold(DeuvEmployer deuvEmployer) {
        return !StringMapper.isNullString((String)deuvEmployer.getLegalFormDsbd()) && !StringMapper.isNullString((String)deuvEmployer.getLegalFormAdditionDsbd()) && PRIVATE_HOUSEHOLD.equals(deuvEmployer.getLegalFormDsbd() + deuvEmployer.getLegalFormAdditionDsbd());
    }

    private boolean isDsbdChanged(DEUVDsbd dsbd, DEUVDsbd old) {
        boolean changed = false;
        if (this.isNameChanged(dsbd, old)) {
            changed = true;
            dsbd.setKennzName(J);
        }
        if (this.isAdressChanged(dsbd, old)) {
            changed = true;
            dsbd.setKennzAnschrift(J);
        }
        if (this.isContactPersonChanged(dsbd, old)) {
            changed = true;
            dsbd.setKennzAP(J);
        }
        if (this.isUnrsChanged(dsbd, old)) {
            changed = true;
            dsbd.setKennzunrs(J);
        }
        if (!changed) {
            boolean dbpaExist;
            boolean oldDbpaExist = old.getDbpa() != null && !L.equals(old.getDbpa().getKennzLoeschenPa());
            boolean bl = dbpaExist = !L.equals(dsbd.getDbpa().getKennzLoeschenPa());
            if (oldDbpaExist != dbpaExist) {
                changed = true;
            } else if (oldDbpaExist && dbpaExist) {
                changed = this.isDbpaChanged(dsbd.getDbpa(), old.getDbpa());
            }
        }
        if (!changed) {
            String oldKennz = this.getCorrectedKennzend(old.getKennzBeendigung());
            changed = !StringMapper.equal((String)dsbd.getKennzBeendigung(), (String)oldKennz);
        }
        return changed;
    }

    private boolean isEndTransmittedAlready(DEUVDsbd dsbd, DEUVDsbd old) {
        if (B.equals(dsbd.getKennzBeendigung()) && B.equals(this.getCorrectedKennzend(old.getKennzBeendigung()))) {
            return old.getDatumEreignis() == null || dsbd.getDatumEreignis() == null || DateHelper.beforeOrEqual((Date)old.getDatumEreignis(), (Date)dsbd.getDatumEreignis());
        }
        return false;
    }

    private boolean isNameChanged(DEUVDsbd dsbd, DEUVDsbd old) {
        return CompareToOldUtil.isDifferent((String)dsbd.getName1(), (String)old.getName1()) || CompareToOldUtil.isDifferent((String)dsbd.getName2(), (String)old.getName2()) || CompareToOldUtil.isDifferent((String)dsbd.getName3(), (String)old.getName3());
    }

    private boolean isAdressChanged(DEUVDsbd dsbd, DEUVDsbd old) {
        return CompareToOldUtil.isDifferent((String)dsbd.getPostleitzahl(), (String)old.getPostleitzahl()) || CompareToOldUtil.isDifferent((String)dsbd.getOrt(), (String)old.getOrt()) || CompareToOldUtil.isDifferent((String)dsbd.getStrasse(), (String)old.getStrasse()) || CompareToOldUtil.isDifferent((String)dsbd.getHausnummer(), (String)old.getHausnummer());
    }

    private boolean isDbpaChanged(DeuvDbpa dbpa, DeuvDbpa old) {
        boolean changed;
        boolean bl = changed = CompareToOldUtil.isDifferent((String)dbpa.getName1(), (String)old.getName1()) || CompareToOldUtil.isDifferent((String)dbpa.getName2(), (String)old.getName2()) || CompareToOldUtil.isDifferent((String)dbpa.getName3(), (String)old.getName3()) || CompareToOldUtil.isDifferent((String)dbpa.getPostleitzahl(), (String)old.getPostleitzahl()) || CompareToOldUtil.isDifferent((String)dbpa.getOrt(), (String)old.getOrt()) || CompareToOldUtil.isDifferent((String)dbpa.getStrasse(), (String)old.getStrasse()) || CompareToOldUtil.isDifferent((String)dbpa.getHausnummer(), (String)old.getHausnummer()) || CompareToOldUtil.isDifferent((String)dbpa.getPlzpostfach(), (String)old.getPlzpostfach()) || CompareToOldUtil.isDifferent((String)dbpa.getPostfach(), (String)old.getPostfach());
        if (!changed && !StringMapper.isNullString((String)old.getArtPostanschrift())) {
            changed = CompareToOldUtil.isDifferent((String)dbpa.getArtPostanschrift(), (String)old.getArtPostanschrift());
        }
        if (!changed && old.getKennung().equals("DBPA")) {
            changed = CompareToOldUtil.isDifferent((String)dbpa.getLaenderkennzeichen(), (String)old.getLaenderkennzeichen());
        }
        return changed;
    }

    private boolean isContactPersonChanged(DEUVDsbd dsbd, DEUVDsbd old) {
        Communication commDsbd = dsbd.getCommunicationDsbd();
        Communication commOld = old.getCommunicationDsbd();
        return CompareToOldUtil.isDifferent((String)commDsbd.getContactPerson(), (String)commOld.getContactPerson()) || CompareToOldUtil.isDifferent((String)commDsbd.getTelephoneNumber(), (String)commOld.getTelephoneNumber()) || CompareToOldUtil.isDifferent((String)commDsbd.getEMailAddress(), (String)commOld.getEMailAddress());
    }

    private boolean isUnrsChanged(DEUVDsbd dsbd, DEUVDsbd old) {
        if (!StringMapper.isNullString((String)old.getUnrs())) {
            return CompareToOldUtil.isDifferent((String)dsbd.getUnrs(), (String)old.getUnrs());
        }
        return false;
    }

    private String getCorrectedKennzend(String kennzend) {
        String result = kennzend;
        if (R.equals(kennzend)) {
            result = B;
        }
        if (A.equals(kennzend)) {
            result = "";
        }
        return result;
    }

    protected void checkForErrors(DEUVDsbd dsbd) throws BusinessDomainException {
        LocalDate sixWeeksAgo;
        LocalDate ereignisDatum;
        Krips kernpruefung = new Krips();
        String dsbdString = DeuvComponents.getContentDsbd((IDeuvDsbd)dsbd);
        String vosz = DeuvBasicComponents.getVosz((IVoszData)this.getDsbdTransfer());
        Rueckgabe rueckgabe = kernpruefung.pruefe(dsbdString, vosz);
        List errors = new ArrayList();
        if (rueckgabe.getReturnCode() >= 2) {
            errors = DeuvHelper.removeInvalidErrors((Rueckgabe)rueckgabe, (String[])new String[]{"DSBD590"});
        }
        dsbd.setErrorMessage(DeuvHelper.getErrorMessage((String)dsbd.getErrorMessage(), errors, (boolean)true));
        if (StringMapper.isNullString((String)dsbd.getErrorMessage()) && (ereignisDatum = DateHelper.toLocalDate((Date)dsbd.getDatumEreignis())).isBefore(sixWeeksAgo = LocalDate.now().minusWeeks(6L))) {
            dsbd.setWarning("Hinweis: Das Ereignisdatum ist \u00e4lter als 6 Wochen. \u00dcberpr\u00fcfen und gegebenenfalls korrigieren!");
        }
    }

    private boolean hasDsbd(DeuvEmployer employer) {
        return this.getTransmittedDsbd(employer) != null;
    }

    private DEUVDsbd getTransmittedDsbd(DeuvEmployer employer) {
        DEUVDsbd dsbd;
        DEUVDsbd result = null;
        if (this.mTransmitteds == null) {
            this.initTransmitteds();
        }
        if ((dsbd = this.mTransmitteds.get(employer.getStdCompanyNo())) != null && StringMapper.equal((String)dsbd.getAzVerursacher(), (String)employer.getIdentifier())) {
            result = dsbd;
        }
        return result;
    }

    private void initTransmitteds() {
        Order[] orders = new Order[]{Order.desc((String)"DATUMERSTELLUNG"), Order.asc((String)"BBNRBETRIEBSSTAETT")};
        Conjunction criterion = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDDEUVSENDER", (String)this.getDeuvSender().getObjectid()), Restrictions.eq((String)"TRANSMITTED", (String)BooleanMapper.toString((boolean)true))});
        this.mTransmitteds = new HashMap<String, DEUVDsbd>();
        for (DEUVDsbd dsbd : DEUVDsbdPersistencyManager.query((Order[])orders, (Criterion)criterion, (boolean)true)) {
            if (REASON_09.equals(dsbd.getAbgabegrund()) && !dsbd.isMainUnrs()) continue;
            DEUVDsbd transmitted = this.mTransmitteds.get(dsbd.getBbnrBeschBetrieb());
            if (transmitted == null) {
                this.mTransmitteds.put(dsbd.getBbnrBeschBetrieb(), dsbd);
                continue;
            }
            if (!REASON_09.equals(transmitted.getAbgabegrund()) || REASON_09.equals(dsbd.getAbgabegrund())) continue;
            if (StringMapper.isNullString((String)dsbd.getUnrs())) {
                dsbd.setUnrs(transmitted.getUnrs());
            }
            this.mTransmitteds.put(dsbd.getBbnrBeschBetrieb(), dsbd);
        }
    }

    private DEUVRecipientTP getDEUVRecipientTPForDsbd() throws BusinessDomainException {
        if (this.mDeuvRecipientTP == null) {
            DEUVRecipient[] query;
            for (DEUVRecipient each : query = DEUVRecipientPersistencyManager.query((Order[])new Order[]{Order.asc((String)"TYPEOFHEALTHFUND")}, (Criterion)Restrictions.eq((String)"OIDDEUVSENDER", (String)this.getDeuvSender().getObjectid()))) {
                if (!DeuvDsbdCreate.isRecipientForDSBD(each)) continue;
                this.mDeuvRecipientTP = each.getCurrentDEUVRecipientTP();
                break;
            }
            if (this.mDeuvRecipientTP == null) {
                throw new IllegalStateException("Kein g\u00fcltiger DE\u00dcV-Empf\u00e4nger f\u00fcr DSBD gefunden");
            }
        }
        return this.mDeuvRecipientTP;
    }

    public static boolean isRecipientForDSBD(DEUVRecipient recipient) throws BusinessDomainException {
        TypeOfHealthFundEnum typeOfHealthFund = recipient.getTypeOfHealthFund();
        return (TypeOfHealthFundEnum.TOHF_AOK == typeOfHealthFund || TypeOfHealthFundEnum.TOHF_IKK == typeOfHealthFund || TypeOfHealthFundEnum.TOHF_BKK == typeOfHealthFund || TypeOfHealthFundEnum.TOHF_VDAK == typeOfHealthFund || TypeOfHealthFundEnum.TOHF_SEE_KK == typeOfHealthFund || TypeOfHealthFundEnum.TOHF_LKK == typeOfHealthFund || TypeOfHealthFundEnum.TOHF_KNAPPSCHAFT == typeOfHealthFund) && DataRecipientUtil.isValid((String)recipient.getCurrentDEUVRecipientTP().getStdCompanyNumber());
    }

    protected Date getValidTimePoint() {
        return VDate.getDateMax();
    }

    private DsbdTransfer getDsbdTransfer() throws BusinessDomainException {
        if (this.mTransfer == null) {
            this.mTransfer = new DsbdTransfer(this.getDeuvSenderTP(), this.getDEUVRecipientTPForDsbd());
        }
        return this.mTransfer;
    }

    private void createInitialUnrs(Map<String, DeuvEmployer> dsbdEmployer) throws BusinessDomainException {
        for (DeuvEmployer employer : dsbdEmployer.values()) {
            if (this.existsDsbdReason09_2025(employer) || this.isStartAfterInitial2025(employer)) continue;
            ArrayList validUnrss = new ArrayList(employer.getUnrsList());
            if (validUnrss.isEmpty()) {
                validUnrss.add(null);
            }
            for (String unrs : validUnrss) {
                DEUVDsbd old;
                DEUVDsbd dsbd = this.createDsbdInitial2025(employer, unrs);
                if (B.equals(employer.getTypeOfBusiness()) && (old = this.getTransmittedDsbd(employer)) != null && B.equals(this.getCorrectedKennzend(old.getKennzBeendigung()))) {
                    dsbd.makeReadOnly();
                    continue;
                }
                if (validUnrss.size() == 1 || unrs.equals(employer.getUnrs())) {
                    dsbd.setMainUnrs(true);
                }
                this.add(dsbd);
            }
        }
    }

    private boolean isStartAfterInitial2025(DeuvEmployer employer) throws BusinessDomainException {
        PCompany pCompany = employer.isPlant() ? employer.getPlant().getHeadCompany() : employer.getPCompany();
        Date start = pCompany.getCompanyFoundations(this.getValidTimePoint(), this.getValidTimePoint()).getCalculationStart();
        return DateHelper.afterOrEqual((Date)start, (Date)END_INITIAL_2025);
    }

    private DEUVDsbd createDsbdInitial2025(DeuvEmployer each, String unrs) throws BusinessDomainException {
        DEUVDsbd created = new DEUVDsbd();
        this.fillBasisDataDsbd(created);
        created.setBbnrBeschBetrieb(each.getStdCompanyNo());
        created.setAzVerursacher(each.getIdentifier());
        created.setDatumEreignis(new Date());
        created.setAbgabegrund(REASON_09);
        created.setName1("DUMMY");
        created.setName2(null);
        created.setName3(null);
        created.setPostleitzahl("99999");
        created.setOrt("DUMMY");
        created.setStrasse("DUMMY");
        created.setHausnummer("9");
        created.setRechtsform("009");
        created.setRechtsformergaenzung(REASON_09);
        created.setUnrs(unrs);
        created.setKennzunrs(N);
        created.setKennzBeendigung(null);
        Communication communicationDsbd = new Communication(StringMapper.maxLength((String)"0999-9999", (int)20), "", "", StringMapper.maxLength((String)"dummy@dummy.de", (int)70), "", StringMapper.maxLength((String)"unbekannt", (int)30));
        created.setCommunicationDsbd(communicationDsbd);
        DeuvDbpa dbpa = created.createDbpa();
        dbpa.setKennzLoeschenPa(L);
        if (each.hasMainUnrsError()) {
            created.setErrorMessage("Es konnte keine eindeutige Haupt-UNRS ermittelt werden! " + String.join((CharSequence)", ", each.getUnrsList()));
        } else if (created.getUnrs() == null) {
            created.setErrorMessage("Es konnte keine UNRS ermittelt werden!");
        }
        return created;
    }

    private void initUnrs(List<DeuvEmployer> employerList) throws BusinessDomainException {
        DeuvEmployer main = employerList.get(0);
        for (AssignmentPCompanyAccidentInsuranceFundTP aifTP : this.getAssignedAIFs(employerList)) {
            String unrs = aifTP.getUnrs();
            if (StringMapper.isNullString((String)unrs) || main.getUnrsList().contains(unrs)) continue;
            if (aifTP.getGenerallyResponsible()) {
                if (main.hasMainUnrs()) {
                    main.setMainUnrsError();
                } else {
                    main.setMainUnrs();
                }
                main.getUnrsList().add(0, unrs);
                continue;
            }
            main.getUnrsList().add(unrs);
        }
        if (main.getUnrsList().size() > 1 && !main.hasMainUnrs()) {
            main.setMainUnrsError();
        }
    }

    private Set<AssignmentPCompanyAccidentInsuranceFundTP> getAssignedAIFs(List<DeuvEmployer> employers) throws BusinessDomainException {
        HashSet<AssignmentPCompanyAccidentInsuranceFundTP> result = new HashSet<AssignmentPCompanyAccidentInsuranceFundTP>();
        HashMap<AccidentInsuranceFund, AssignmentPCompanyAccidentInsuranceFundTP> assAifMap = new HashMap<AccidentInsuranceFund, AssignmentPCompanyAccidentInsuranceFundTP>();
        for (DeuvEmployer each : employers) {
            if (each.isPlant()) {
                assAifMap.clear();
                for (AssignmentPCompanyAccidentInsuranceFundTP assAifTP : this.getAssAifs(Restrictions.eq((String)"OIDPLANT", (String)each.getPlant().getObjectid()))) {
                    if (!this.isAssAifValid(assAifTP)) continue;
                    AccidentInsuranceFund aif = assAifTP.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
                    assAifMap.put(aif, assAifTP);
                }
                PCompany pCompany = each.getPlant().getHeadCompany();
                for (AssignmentPCompanyAccidentInsuranceFundTP assAifTP : this.getAssAifs(pCompany)) {
                    AccidentInsuranceFund aif = assAifTP.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
                    if (assAifMap.containsKey(aif) || !this.isAssAifValid(assAifTP)) continue;
                    assAifMap.put(aif, assAifTP);
                }
                for (AssignmentPCompanyAccidentInsuranceFundTP assAifTP : this.evaluateAssignments(each.getPlant(), assAifMap.values())) {
                    result.add(assAifTP);
                }
                continue;
            }
            if (this.getSettings(each.getPCompany()).getUsePlants()) continue;
            List<AssignmentPCompanyAccidentInsuranceFundTP> assAifTPs = this.getAssAifs(each.getPCompany());
            if (assAifTPs.size() == 1) {
                result.add(assAifTPs.get(0));
                continue;
            }
            for (AssignmentPCompanyAccidentInsuranceFundTP assAifTP : this.getAssAifs(each.getPCompany())) {
                if (!this.isAssAifValid(assAifTP)) continue;
                result.add(assAifTP);
            }
        }
        return result;
    }

    private List<AssignmentPCompanyAccidentInsuranceFundTP> getAssAifs(PCompany pCompany) {
        Criterion filters = Restrictions.and((Criterion)Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()), (Criterion)Restrictions.isNull((String)"oidplant"));
        return Arrays.asList(this.getAssAifs(filters));
    }

    private AssignmentPCompanyAccidentInsuranceFundTP[] getAssAifs(Criterion filter) {
        return AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.getValidTimePoint())), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.getValidTimePoint())), filter}));
    }

    private boolean isAssAifValid(AssignmentPCompanyAccidentInsuranceFundTP assAifTp) {
        Date validUntil;
        boolean valid;
        AccidentInsuranceFund aif = assAifTp.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
        AccidentInsuranceFundTP aifTP = (AccidentInsuranceFundTP)aif.getHistory().getItemOrNull(VDate.getDateMax());
        boolean bl = valid = !StringMapper.isNullString((String)aifTP.getStdCompanyNoOfAccIns());
        if (valid && (validUntil = ((AccidentInsuranceFundTP)aif.getHistory().getItemOrNull(VDate.getDateMax())).getValidUntilOfConsolidation()) != null && DateHelper.before((Date)validUntil, (Date)START_OF_2025)) {
            valid = false;
        }
        if (valid) {
            valid = !assAifTp.hasMembershipEnded() || DateHelper.after((Date)assAifTp.getValidFrom(), (Date)START_OF_2025);
        }
        return valid;
    }

    private List<AssignmentPCompanyAccidentInsuranceFundTP> evaluateAssignments(Plant plant, Collection<AssignmentPCompanyAccidentInsuranceFundTP> assAif) {
        ArrayList<AssignmentPCompanyAccidentInsuranceFundTP> plantOrWithEmployees = new ArrayList<AssignmentPCompanyAccidentInsuranceFundTP>();
        ArrayList<AssignmentPCompanyAccidentInsuranceFundTP> companyWithoutEmployees = new ArrayList<AssignmentPCompanyAccidentInsuranceFundTP>();
        for (AssignmentPCompanyAccidentInsuranceFundTP each : assAif) {
            if (each.getAssignmentPCompanyAccidentInsuranceFund().getPlant() != null || this.hasAssignedEmployees(each, plant)) {
                plantOrWithEmployees.add(each);
                continue;
            }
            companyWithoutEmployees.add(each);
        }
        ArrayList<AssignmentPCompanyAccidentInsuranceFundTP> result = new ArrayList<AssignmentPCompanyAccidentInsuranceFundTP>();
        if (!plantOrWithEmployees.isEmpty()) {
            result.addAll(plantOrWithEmployees);
        } else if (companyWithoutEmployees.size() == 1) {
            result.add((AssignmentPCompanyAccidentInsuranceFundTP)companyWithoutEmployees.get(0));
        } else {
            for (AssignmentPCompanyAccidentInsuranceFundTP each : companyWithoutEmployees) {
                if (!each.getGenerallyResponsible()) continue;
                result.add(each);
                break;
            }
        }
        return result;
    }

    private boolean hasAssignedEmployees(AssignmentPCompanyAccidentInsuranceFundTP assAifTP, Plant plant) {
        AccidentInsuranceFund aif = assAifTP.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDPLANT", (String)plant.getObjectid()), Restrictions.or((Criterion)Restrictions.eq((String)"OIDACCIDENTINS", (String)aif.getObjectid()), (Criterion)Restrictions.eq((String)"OIDEEACCIDENTINCOR", (String)aif.getObjectid()))});
        return this.getPartClassOfRiskPM().existAll((Criterion)filter);
    }

    private boolean existsDsbdReason09_2025(DeuvEmployer employer) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDDEUVSENDER", (String)this.getDeuvSender().getObjectid()), Restrictions.eq((String)"BBNRBETRIEBSSTAETT", (String)employer.getStdCompanyNo()), Restrictions.or((Criterion)Restrictions.eq((String)"RESERVE", (String)AdviceStateEnum.toDBString((AdviceStateEnum)AdviceStateEnum.UEBERMITTELT)), (Criterion)Restrictions.eq((String)"RESERVE", (String)AdviceStateEnum.toDBString((AdviceStateEnum)AdviceStateEnum.ERFOLGREICH))), Restrictions.eq((String)"ABGABEGRUND", (String)REASON_09), Restrictions.eq((String)"RECHTSFORM", (String)"009"), Restrictions.eq((String)"RECHTSFORMERGAE", (String)REASON_09)});
        return DEUVDsbdPersistencyManager.query(null, (Criterion)filter, (boolean)true).length > 0;
    }

    public static final DEUVDsbd[] getUntransmitteds(DEUVSender deuvSender) {
        Conjunction criterion = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDDEUVSENDER", (String)deuvSender.getObjectid()), Restrictions.eq((String)"TRANSMITTED", (String)BooleanMapper.toString((boolean)false))});
        Order[] sort = new Order[]{Order.asc((String)"BBNRBETRIEBSSTAETT")};
        return DEUVDsbdPersistencyManager.query((Order[])sort, (Criterion)criterion, (boolean)false);
    }

    private IPartClassOfRiskPersistencyManager getPartClassOfRiskPM() {
        return (IPartClassOfRiskPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("partClassOfRiskPersistencyManager", IPartClassOfRiskPersistencyManager.class);
    }

    private class DsbdTransfer
    extends BasicTransfer<DEUVDsbd> {
        protected DsbdTransfer(DEUVSenderTP deuvSenderTP, DEUVRecipientTP recipientTP) {
            super(deuvSenderTP, recipientTP, null);
        }

        public String getDeuvFeature() {
            return "AGDEU";
        }

        public int getFileNumber() {
            return this.mDeuvRecipientTP.getFileNumberOfDEUV();
        }

        public String getDeuvProcedure() {
            return "DEUEV";
        }

        protected DeuvHelper.TypeOfCommunication getTypeOfCommunication() {
            return DeuvHelper.TypeOfCommunication.DEUV;
        }
    }
}

